/// <reference types="jest" />
import { ISDK, ToolkitInfo } from '../../lib/api';
import { CloudFormationStack } from '../../lib/api/util/cloudformation';
export interface MockToolkitInfoProps {
    readonly bucketName?: string;
    readonly bucketUrl?: string;
    readonly version?: number;
    readonly bootstrapStack?: CloudFormationStack;
}
export declare class MockToolkitInfo extends ToolkitInfo {
    readonly found = true;
    readonly bucketUrl: string;
    readonly bucketName: string;
    readonly version: number;
    readonly prepareEcrRepository: jest.Mock<Promise<import("../../lib/api").EcrRepositoryInfo>, [string]>;
    private readonly _bootstrapStack?;
    constructor(sdk: ISDK, props?: MockToolkitInfoProps);
    get bootstrapStack(): CloudFormationStack;
    validateVersion(expectedVersion: number, ssmParameterName: string | undefined): Promise<void>;
}
