/**
 * An entry in the construct metadata table.
 *
 * @stability stable
 */
export interface MetadataEntry {
    /**
     * The metadata entry type.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * The data.
     *
     * @stability stable
     */
    readonly data: any;
    /**
     * Stack trace.
     *
     * Can be omitted by setting the context key
     * `ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA` to 1.
     *
     * @default - no trace information
     * @stability stable
     */
    readonly trace?: string[];
}
/**
 * Metadata keys used by constructs.
 *
 * @stability stable
 */
export declare class ConstructMetadata {
    /**
     * If set in the construct's context, omits stack traces from metadata entries.
     *
     * @stability stable
     */
    static readonly DISABLE_STACK_TRACE_IN_METADATA = "disable-stack-trace";
    /**
     * Context type for info level messages.
     *
     * @stability stable
     */
    static readonly INFO_METADATA_KEY = "info";
    /**
     * Context type for warning level messages.
     *
     * @stability stable
     */
    static readonly WARNING_METADATA_KEY = "warning";
    /**
     * Context type for error level messages.
     *
     * @stability stable
     */
    static readonly ERROR_METADATA_KEY = "error";
    private constructor();
}
