import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [logs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchlogs.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Logs extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [logs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchlogs.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate the specified AWS Key Management Service (AWS KMS) customer master key (CMK) with the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_AssociateKmsKey.html
     */
    toAssociateKmsKey(): this;
    /**
     * Grants permission to cancel an export task if it is in PENDING or RUNNING state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html
     */
    toCancelExportTask(): this;
    /**
     * Grants permission to create an ExportTask which allows you to efficiently export data from a Log Group to your Amazon S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateExportTask.html
     */
    toCreateExportTask(): this;
    /**
     * Grants permission to create the log delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
     */
    toCreateLogDelivery(): this;
    /**
     * Grants permission to create a new log group with the specified name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateLogGroup.html
     */
    toCreateLogGroup(): this;
    /**
     * Grants permission to create a new log stream with the specified name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateLogStream.html
     */
    toCreateLogStream(): this;
    /**
     * Grants permission to delete a data protection policy attached to a log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteDataProtectionPolicy.html
     */
    toDeleteDataProtectionPolicy(): this;
    /**
     * Grants permission to delete the destination with the specified name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteDestination.html
     */
    toDeleteDestination(): this;
    /**
     * Grants permission to delete the log delivery information for specified log delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
     */
    toDeleteLogDelivery(): this;
    /**
     * Grants permission to delete the log group with the specified name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteLogGroup.html
     */
    toDeleteLogGroup(): this;
    /**
     * Grants permission to delete a log stream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteLogStream.html
     */
    toDeleteLogStream(): this;
    /**
     * Grants permission to delete a metric filter associated with the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteMetricFilter.html
     */
    toDeleteMetricFilter(): this;
    /**
     * Grants permission to delete a saved CloudWatch Logs Insights query definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteQueryDefinition.html
     */
    toDeleteQueryDefinition(): this;
    /**
     * Grants permission to delete a resource policy from this account
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete the retention policy of the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html
     */
    toDeleteRetentionPolicy(): this;
    /**
     * Grants permission to delete a subscription filter associated with the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteSubscriptionFilter.html
     */
    toDeleteSubscriptionFilter(): this;
    /**
     * Grants permission to return all the destinations that are associated with the AWS account making the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDestinations.html
     */
    toDescribeDestinations(): this;
    /**
     * Grants permission to return all the export tasks that are associated with the AWS account making the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks(): this;
    /**
     * Grants permission to return all the log groups that are associated with the AWS account making the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html
     */
    toDescribeLogGroups(): this;
    /**
     * Grants permission to return all the log streams that are associated with the specified log group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html
     */
    toDescribeLogStreams(): this;
    /**
     * Grants permission to return all the metrics filters associated with the specified log group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeMetricFilters.html
     */
    toDescribeMetricFilters(): this;
    /**
     * Grants permission to return a list of CloudWatch Logs Insights queries that are scheduled, executing, or have been executed recently in this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueries.html
     */
    toDescribeQueries(): this;
    /**
     * Grants permission to return a paginated list of your saved CloudWatch Logs Insights query definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html
     */
    toDescribeQueryDefinitions(): this;
    /**
     * Grants permission to return all the resource policies in this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeResourcePolicies.html
     */
    toDescribeResourcePolicies(): this;
    /**
     * Grants permission to return all the subscription filters associated with the specified log group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html
     */
    toDescribeSubscriptionFilters(): this;
    /**
     * Grants permission to disassociate the associated AWS Key Management Service (AWS KMS) customer master key (CMK) from the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DisassociateKmsKey.html
     */
    toDisassociateKmsKey(): this;
    /**
     * Grants permission to retrieve log events, optionally filtered by a filter pattern from the specified log group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html
     */
    toFilterLogEvents(): this;
    /**
     * Grants permission to retrieve a data protection policy attached to a log group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetDataProtectionPolicy.html
     */
    toGetDataProtectionPolicy(): this;
    /**
     * Grants permission to get the log delivery information for specified log delivery
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
     */
    toGetLogDelivery(): this;
    /**
     * Grants permission to retrieve log events from the specified log stream
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html
     */
    toGetLogEvents(): this;
    /**
     * Grants permission to return a list of the fields that are included in log events in the specified log group, along with the percentage of log events that contain each field
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html
     */
    toGetLogGroupFields(): this;
    /**
     * Grants permission to retrieve all the fields and values of a single log event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html
     */
    toGetLogRecord(): this;
    /**
     * Grants permission to return the results from the specified query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html
     */
    toGetQueryResults(): this;
    /**
     * Grants permission to share CloudWatch resources with a monitoring account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account-Setup.html#CloudWatch-Unified-Cross-Account-Setup-permissions
     */
    toLink(): this;
    /**
     * Grants permission to list all the log deliveries for specified account and/or log source
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
     */
    toListLogDeliveries(): this;
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the tags for the specified log group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html
     */
    toListTagsLogGroup(): this;
    /**
     * Grants permission to attach a data protection policy to detect and redact sensitive information from log events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html
     */
    toPutDataProtectionPolicy(): this;
    /**
     * Grants permission to create or update a Destination
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html
     */
    toPutDestination(): this;
    /**
     * Grants permission to create or update an access policy associated with an existing Destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html
     */
    toPutDestinationPolicy(): this;
    /**
     * Grants permission to upload a batch of log events to the specified log stream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html
     */
    toPutLogEvents(): this;
    /**
     * Grants permission to create or update a metric filter and associates it with the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutMetricFilter.html
     */
    toPutMetricFilter(): this;
    /**
     * Grants permission to create or update a query definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutQueryDefinition.html
     */
    toPutQueryDefinition(): this;
    /**
     * Grants permission to create or update a resource policy allowing other AWS services to put log events to this account
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to set the retention of the specified log group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html
     */
    toPutRetentionPolicy(): this;
    /**
     * Grants permission to create or update a subscription filter and associates it with the specified log group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html
     */
    toPutSubscriptionFilter(): this;
    /**
     * Grants permission to schedule a query of a log group using CloudWatch Logs Insights
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
     */
    toStartQuery(): this;
    /**
     * Grants permission to stop a CloudWatch Logs Insights query that is in progress
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StopQuery.html
     */
    toStopQuery(): this;
    /**
     * Grants permission to add or update the specified tags for the specified log group
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagLogGroup.html
     */
    toTagLogGroup(): this;
    /**
     * Grants permission to add or update the specified tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test the filter pattern of a metric filter against a sample of log event messages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TestMetricFilter.html
     */
    toTestMetricFilter(): this;
    /**
     * Grants permission to fetch unmasked log events that have been redacted with a data protection policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html
     */
    toUnmask(): this;
    /**
     * Grants permission to remove the specified tags from the specified log group
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagLogGroup.html
     */
    toUntagLogGroup(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the log delivery information for specified log delivery
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
     */
    toUpdateLogDelivery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type log-group to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LogGroup.html
     *
     * @param logGroupName - Identifier for the logGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLogGroup(logGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type log-stream to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LogStream.html
     *
     * @param logGroupName - Identifier for the logGroupName.
     * @param logStreamName - Identifier for the logStreamName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLogStream(logGroupName: string, logStreamName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type destination to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Destination.html
     *
     * @param destinationName - Identifier for the destinationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDestination(destinationName: string, account?: string, region?: string, partition?: string): this;
}
