"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Codecatalyst = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Codecatalyst extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'codecatalyst';
        this.accessLevelList = {
            Write: [
                'AcceptConnection',
                'AssociateIamRoleToConnection',
                'DeleteConnection',
                'DisassociateIamRoleFromConnection',
                'PutBillingAuthorization',
                'RejectConnection'
            ],
            Read: [
                'GetBillingAuthorization',
                'GetConnection',
                'GetPendingConnection'
            ],
            List: [
                'ListConnections',
                'ListIamRolesForConnection'
            ]
        };
    }
    /**
     * Grants permission to accept a request to connect this account to a CodeCatalyst space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toAcceptConnection() {
        return this.to('AcceptConnection');
    }
    /**
     * Grants permission to associate an IAM role to a connection
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toAssociateIamRoleToConnection() {
        return this.to('AssociateIamRoleToConnection');
    }
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toDeleteConnection() {
        return this.to('DeleteConnection');
    }
    /**
     * Grants permission to disassociate an IAM role from a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toDisassociateIamRoleFromConnection() {
        return this.to('DisassociateIamRoleFromConnection');
    }
    /**
     * Grants permission to describe the billing authorization for a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetBillingAuthorization() {
        return this.to('GetBillingAuthorization');
    }
    /**
     * Grants permission to get a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetConnection() {
        return this.to('GetConnection');
    }
    /**
     * Grants permission to get a pending request to connect this account to a CodeCatalyst space
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetPendingConnection() {
        return this.to('GetPendingConnection');
    }
    /**
     * Grants permission to list connections which are not pending
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toListConnections() {
        return this.to('ListConnections');
    }
    /**
     * Grants permission to list IAM roles associated with a connection
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toListIamRolesForConnection() {
        return this.to('ListIamRolesForConnection');
    }
    /**
     * Grants permission to creates or update the billing authorization for a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toPutBillingAuthorization() {
        return this.to('PutBillingAuthorization');
    }
    /**
     * Grants permission to reject a request to connect this account to a CodeCatalyst space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toRejectConnection() {
        return this.to('RejectConnection');
    }
    /**
     * Adds a resource of type connections to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnections(connectionId, account, region, partition) {
        return this.on(`arn:${partition || Codecatalyst.defaultPartition}:codecatalyst:${region || '*'}:${account || '*'}:/connections/${connectionId}`);
    }
}
exports.Codecatalyst = Codecatalyst;
_a = JSII_RTTI_SYMBOL_1;
Codecatalyst[_a] = { fqn: "iam-floyd.Codecatalyst", version: "0.470.0" };
//# sourceMappingURL=data:application/json;base64,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