import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [license-manager-user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerusersubscriptions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class LicenseManagerUserSubscriptions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [license-manager-user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerusersubscriptions.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate a subscribed user to an instance launched with license manager user subscriptions products
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_AssociateUser.html
     */
    toAssociateUser(): this;
    /**
     * Grants permission to deregister Microsoft Active Directory with license-manager-user-subscriptions for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_DeregisterIdentityProvider.html
     */
    toDeregisterIdentityProvider(): this;
    /**
     * Grants permission to disassociate a subscribed user from an instance launched with license manager user subscriptions products
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_DisassociateUser.html
     */
    toDisassociateUser(): this;
    /**
     * Grants permission to list all the identity providers on license manager user subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListIdentityProviders.html
     */
    toListIdentityProviders(): this;
    /**
     * Grants permission to list all the instances launched with license manager user subscription products
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListInstances.html
     */
    toListInstances(): this;
    /**
     * Grants permission to lists all the product subscriptions for a product and identity provider
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListProductSubscriptions.html
     */
    toListProductSubscriptions(): this;
    /**
     * Grants permission to list all the users associated to an instance launched for a product
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_ListUserAssociations.html
     */
    toListUserAssociations(): this;
    /**
     * Grants permission to registers Microsoft Active Directory with license-manager-user-subscriptions for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_RegisterIdentityProvider.html
     */
    toRegisterIdentityProvider(): this;
    /**
     * Grants permission to start product subscription for a user on a registered active directory for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_StartProductSubscription.html
     */
    toStartProductSubscription(): this;
    /**
     * Grants permission to stop product subscription for a user on a registered active directory for a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_StopProductSubscription.html
     */
    toStopProductSubscription(): this;
    /**
     * Grants permission to update the identity provider configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager-user-subscriptions/latest/APIReference/API_UpdateIdentityProviderSettings.html
     */
    toUpdateIdentityProviderSettings(): this;
    protected accessLevelList: AccessLevelList;
}
