# flake8: noqa

import httpretty
import json


def register_uris():
    """
    Mocks for Google Custom Search API set of endpoints

    Note: The data here has been stripped down from that actually returned from the Google Custom Search API
    """

    # First page of results for "snap"
    httpretty.register_uri(
        httpretty.GET,
        "https://www.googleapis.com/customsearch/v1/siterestrict?key=test-api-key&cx=009048213575199080868%3Ai3zoqdwqk8o&q=snap",
        match_querystring=True,
        body=json.dumps(
            {
                "queries": {"nextPage": [{"count": 10, "startIndex": 11}]},
                "items": [
                    {
                        "title": "Snapcraft - Snaps are universal Linux packages",
                        "htmlTitle": "Snapcraft - \u003cb\u003eSnaps\u003c/b\u003e are universal Linux packages",
                        "link": "https://developer.ubuntu.com/core/publish-and-distribute",
                        "displayLink": "developer.ubuntu.com",
                        "snippet": "Snaps are containerised software packages that are simple to create and install. \nThey auto-update and are safe to run. And because they bundle their ...",
                        "htmlSnippet": "\u003cb\u003eSnaps\u003c/b\u003e are containerised software packages that are simple to create and install. \u003cbr\u003e\nThey auto-update and are safe to run. And because they bundle their&nbsp;...",
                        "formattedUrl": "https://developer.ubuntu.com/core/publish-and-distribute",
                        "htmlFormattedUrl": "https://developer.ubuntu.com/core/publish-and-distribute",
                    },
                    {
                        "title": "Install Linux apps using the Snap Store | Snapcraft",
                        "htmlTitle": "Install Linux apps using the \u003cb\u003eSnap\u003c/b\u003e Store | Snapcraft",
                        "link": "https://apps.ubuntu.com/",
                        "displayLink": "apps.ubuntu.com",
                        "snippet": "Find and install the best Linux software for all major Linux distributions.",
                        "htmlSnippet": "Find and install the best Linux software for all major Linux distributions.",
                        "cacheId": "2tuPjHyE8bcJ",
                        "formattedUrl": "https://apps.ubuntu.com/",
                        "htmlFormattedUrl": "https://apps.ubuntu.com/",
                    },
                    {
                        "title": "Installing snapd - Snap documentation",
                        "htmlTitle": "Installing snapd - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snapd",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Snaps can be used on all major Linux distributions, including Ubuntu, Linux Mint, \nDebian and Fedora. Snap is pre-installed and ready to go on the following:.",
                        "htmlSnippet": "\u003cb\u003eSnaps\u003c/b\u003e can be used on all major Linux distributions, including Ubuntu, Linux Mint, \u003cbr\u003e\nDebian and Fedora. \u003cb\u003eSnap\u003c/b\u003e is pre-installed and ready to go on the following:.",
                        "cacheId": "Q5gTgMVLepMJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snapd",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003ed",
                    },
                    {
                        "title": "Snaps on Ubuntu | Desktop | Ubuntu",
                        "htmlTitle": "\u003cb\u003eSnaps\u003c/b\u003e on Ubuntu | Desktop | Ubuntu",
                        "link": "https://www.ubuntu.com/desktop/snappy",
                        "displayLink": "www.ubuntu.com",
                        "snippet": "Snaps work on any distribution or device. Snaps are faster to install, easier to \ncreate, safer to run, and they update automatically and transactionally so your \napp ...",
                        "htmlSnippet": "\u003cb\u003eSnaps\u003c/b\u003e work on any distribution or device. \u003cb\u003eSnaps\u003c/b\u003e are faster to install, easier to \u003cbr\u003e\ncreate, safer to run, and they update automatically and transactionally so your \u003cbr\u003e\napp&nbsp;...",
                        "cacheId": "_jtLFnyc2_AJ",
                        "formattedUrl": "https://www.ubuntu.com/desktop/snappy",
                        "htmlFormattedUrl": "https://www.ubuntu.com/desktop/\u003cb\u003esnap\u003c/b\u003epy",
                    },
                    {
                        "title": "Getting started - Snap documentation",
                        "htmlTitle": "Getting started - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/getting-started",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "A snap is a bundle of your app and its dependencies that works without \nmodification across many different Linux distributions. Snaps are discoverable \nand ...",
                        "htmlSnippet": "A \u003cb\u003esnap\u003c/b\u003e is a bundle of your app and its dependencies that works without \u003cbr\u003e\nmodification across many different Linux distributions. \u003cb\u003eSnaps\u003c/b\u003e are discoverable \u003cbr\u003e\nand&nbsp;...",
                        "cacheId": "3bwiiTQTzXUJ",
                        "formattedUrl": "https://docs.snapcraft.io/getting-started",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/getting-started",
                    },
                    {
                        "title": "Snap documentation",
                        "htmlTitle": "\u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Snap Documentation. Welcome to the home of snap, snapd, and snapcraft \ndocumentation. Snaps are app packages for desktop, cloud and IoT that are easy \nto ...",
                        "htmlSnippet": "\u003cb\u003eSnap\u003c/b\u003e Documentation. Welcome to the home of \u003cb\u003esnap\u003c/b\u003e, snapd, and snapcraft \u003cbr\u003e\ndocumentation. \u003cb\u003eSnaps\u003c/b\u003e are app packages for desktop, cloud and IoT that are easy \u003cbr\u003e\nto&nbsp;...",
                        "cacheId": "8w9UrSFZh0UJ",
                        "formattedUrl": "https://docs.snapcraft.io/",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/",
                    },
                    {
                        "title": "Installing the Snap Store app - Snap documentation",
                        "htmlTitle": "Installing the \u003cb\u003eSnap\u003c/b\u003e Store app - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-store-app",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "The Snap Store app is installed with the following command: $ sudo snap install \nsnap-store. See Installing snapd if you don't already have snapd installed.",
                        "htmlSnippet": "The \u003cb\u003eSnap\u003c/b\u003e Store app is installed with the following command: $ sudo \u003cb\u003esnap\u003c/b\u003e install \u003cbr\u003e\n\u003cb\u003esnap\u003c/b\u003e-store. See Installing snapd if you don&#39;t already have snapd installed.",
                        "cacheId": "XjKhjqsS9a8J",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-store-app",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-store-app",
                    },
                    {
                        "title": "Installing snap on Manjaro Linux - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on Manjaro Linux - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-manjaro-linux",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Installing snap on Manjaro Linux. Snapd can be installed from Manjaro's Add/\nRemove Software application (Pamac), found in the launch menu. From the ...",
                        "htmlSnippet": "Installing \u003cb\u003esnap\u003c/b\u003e on Manjaro Linux. Snapd can be installed from Manjaro&#39;s Add/\u003cbr\u003e\nRemove Software application (Pamac), found in the launch menu. From the&nbsp;...",
                        "cacheId": "zkkT5R4ygbEJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-manjaro-linux",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-manjaro-linux",
                    },
                    {
                        "title": "Installing snap on Fedora - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on Fedora - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-fedora",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Installing snap on Fedora. Snap can be installed on Fedora from the command \nline: $ sudo dnf install snapd. Either log out and back in again, or restart your ...",
                        "htmlSnippet": "Installing \u003cb\u003esnap\u003c/b\u003e on Fedora. \u003cb\u003eSnap\u003c/b\u003e can be installed on Fedora from the command \u003cbr\u003e\nline: $ sudo dnf install snapd. Either log out and back in again, or restart your&nbsp;...",
                        "cacheId": "yna3K0fkB5UJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-fedora",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-fedora",
                    },
                    {
                        "title": "Desktop for developers | Ubuntu",
                        "htmlTitle": "Desktop for developers | Ubuntu",
                        "link": "https://ubuntu.com/desktop/developers",
                        "displayLink": "ubuntu.com",
                        "snippet": "Linux 4.15 kernel; Core applications packaged as snaps; Apps available in store \nincluding ... Everything your developers need is just a snap or an apt away.",
                        "htmlSnippet": "Linux 4.15 kernel; Core applications packaged as \u003cb\u003esnaps\u003c/b\u003e; Apps available in store \u003cbr\u003e\nincluding ... Everything your developers need is just a \u003cb\u003esnap\u003c/b\u003e or an apt away.",
                        "cacheId": "q-3JFcWqMX8J",
                        "formattedUrl": "https://ubuntu.com/desktop/developers",
                        "htmlFormattedUrl": "https://ubuntu.com/desktop/developers",
                    },
                ],
            }
        ),
        content_type="application/json",
    )

    # Results for "snap" with siteSearch=maas.io/docs
    httpretty.register_uri(
        httpretty.GET,
        "https://www.googleapis.com/customsearch/v1/siterestrict?key=test-api-key&cx=009048213575199080868%3Ai3zoqdwqk8o&q=snap&siteSearch=maas.io%2Fdocs",
        match_querystring=True,
        body=json.dumps(
            {
                "queries": {"nextPage": [{"count": 10, "startIndex": 11}]},
                "items": [
                    {
                        "title": "Install from a Snap | MAAS documentation",
                        "htmlTitle": "Install from a \u003cb\u003eSnap\u003c/b\u003e | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/installconfig-snap-install",
                        "displayLink": "maas.io/docs",
                        "snippet": "Snaps are containerised software packages. To install MAAS from a snap, simply \nenter the following: sudo snap install maas --devmode --stable. After entering ...",
                        "htmlSnippet": "\u003cb\u003eSnaps\u003c/b\u003e are containerised software packages. To install MAAS from a \u003cb\u003esnap\u003c/b\u003e, simply \u003cbr\u003e\nenter the following: sudo \u003cb\u003esnap\u003c/b\u003e install maas --devmode --stable. After entering&nbsp;...",
                        "cacheId": "GL7NO5yj7fMJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/installconfig-snap-install",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/installconfig-\u003cb\u003esnap\u003c/b\u003e-install",
                    },
                    {
                        "title": "Install from a Snap | MAAS documentation",
                        "htmlTitle": "Install from a \u003cb\u003eSnap\u003c/b\u003e | MAAS documentation",
                        "link": "https://maas.io/docs/2.2/en/installconfig-snap-install",
                        "displayLink": "maas.io/docs",
                        "snippet": "May 30, 2017 ... Although snap installs are meant to eventually replace traditional Ubuntu \npackages, installing MAAS from a snap is considered experimental at ...",
                        "htmlSnippet": "May 30, 2017 \u003cb\u003e...\u003c/b\u003e Although \u003cb\u003esnap\u003c/b\u003e installs are meant to eventually replace traditional Ubuntu \u003cbr\u003e\npackages, installing MAAS from a \u003cb\u003esnap\u003c/b\u003e is considered experimental at&nbsp;...",
                        "cacheId": "LydTcPvwa8oJ",
                        "formattedUrl": "https://maas.io/docs/2.2/en/installconfig-snap-install",
                        "htmlFormattedUrl": "https://maas.io/docs/2.2/en/installconfig-\u003cb\u003esnap\u003c/b\u003e-install",
                    },
                    {
                        "title": "Installation | MAAS documentation",
                        "htmlTitle": "Installation | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/installconfig-install",
                        "displayLink": "maas.io/docs",
                        "snippet": "Installation. There are four ways to install MAAS: From a snap. Install via a snap. \nVersatile: Put components where you want them (centralized or distributed) ...",
                        "htmlSnippet": "Installation. There are four ways to install MAAS: From a \u003cb\u003esnap\u003c/b\u003e. Install via a \u003cb\u003esnap\u003c/b\u003e. \u003cbr\u003e\nVersatile: Put components where you want them (centralized or distributed)&nbsp;...",
                        "cacheId": "nKjPVqZ7xfAJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/installconfig-install",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/installconfig-install",
                    },
                    {
                        "title": "2.4 Release Notes | MAAS documentation",
                        "htmlTitle": "2.4 Release Notes | MAAS documentation",
                        "link": "https://maas.io/docs/2.4/en/release-notes",
                        "displayLink": "maas.io/docs",
                        "snippet": "May 30, 2018 ... The availability of the MAAS snap changes that behaviour, no longer providing \nweb UI access on port 80. To remain consistent with the snap, ...",
                        "htmlSnippet": "May 30, 2018 \u003cb\u003e...\u003c/b\u003e The availability of the MAAS \u003cb\u003esnap\u003c/b\u003e changes that behaviour, no longer providing \u003cbr\u003e\nweb UI access on port 80. To remain consistent with the \u003cb\u003esnap\u003c/b\u003e,&nbsp;...",
                        "cacheId": "qvBKEcmpmsgJ",
                        "formattedUrl": "https://maas.io/docs/2.4/en/release-notes",
                        "htmlFormattedUrl": "https://maas.io/docs/2.4/en/release-notes",
                    },
                    {
                        "title": "High Availability | MAAS documentation",
                        "htmlTitle": "High Availability | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/manage-ha",
                        "displayLink": "maas.io/docs",
                        "snippet": "Install the MAAS snap on each machine you intend to use as a rack or region \ncontroller. You'll need the MAAS shared secret, located here, /var/lib/maas/secret\n ...",
                        "htmlSnippet": "Install the MAAS \u003cb\u003esnap\u003c/b\u003e on each machine you intend to use as a rack or region \u003cbr\u003e\ncontroller. You&#39;ll need the MAAS shared secret, located here, /var/lib/maas/secret\u003cbr\u003e\n&nbsp;...",
                        "cacheId": "r2XJJdOMfaoJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/manage-ha",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/manage-ha",
                    },
                    {
                        "`title": "Prometheus metrics | MAAS documentation",
                        "htmlTitle": "Prometheus metrics | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/manage-prometheus-metrics",
                        "displayLink": "maas.io/docs",
                        "snippet": "For a snap-based MAAS installation, the library is already included in the snap, \nso metrics will be available out of the box. For a Debian-based MAAS installation\n ...",
                        "htmlSnippet": "For a \u003cb\u003esnap\u003c/b\u003e-based MAAS installation, the library is already included in the \u003cb\u003esnap\u003c/b\u003e, \u003cbr\u003e\nso metrics will be available out of the box. For a Debian-based MAAS installation\u003cbr\u003e\n&nbsp;...",
                        "cacheId": "QxirPgSfwiAJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/manage-prometheus-metrics",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/manage-prometheus-metrics",
                    },
                    {
                        "title": "Add Nodes | MAAS documentation",
                        "htmlTitle": "Add Nodes | MAAS documentation",
                        "link": "https://maas.io/docs/2.3/en/nodes-add",
                        "displayLink": "maas.io/docs",
                        "snippet": "Add Nodes. Adding a node to MAAS is typically done via a combination of DHCP \n(and TFTP), which should, by now, be enabled in your MAAS environment, and ...",
                        "htmlSnippet": "Add Nodes. Adding a node to MAAS is typically done via a combination of DHCP \u003cbr\u003e\n(and TFTP), which should, by now, be enabled in your MAAS environment, and&nbsp;...",
                        "cacheId": "57bvi4TKctsJ",
                        "formattedUrl": "https://maas.io/docs/2.3/en/nodes-add",
                        "htmlFormattedUrl": "https://maas.io/docs/2.3/en/nodes-add",
                    },
                    {
                        "title": "Web UI | MAAS documentation",
                        "htmlTitle": "Web UI | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/installconfig-webui",
                        "displayLink": "maas.io/docs",
                        "snippet": "Unless MAAS was installed from a snap (see Install from snap) or the Ubuntu \nServer ISO (see Install from ISO), you'll need to create a user in order to access \nthe ...",
                        "htmlSnippet": "Unless MAAS was installed from a \u003cb\u003esnap\u003c/b\u003e (see Install from \u003cb\u003esnap\u003c/b\u003e) or the Ubuntu \u003cbr\u003e\nServer ISO (see Install from ISO), you&#39;ll need to create a user in order to access \u003cbr\u003e\nthe&nbsp;...",
                        "cacheId": "KBGUt6UyJMsJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/installconfig-webui",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/installconfig-webui",
                    },
                    {
                        "title": "Device Discovery | MAAS documentation",
                        "htmlTitle": "Device Discovery | MAAS documentation",
                        "link": "https://maas.io/docs/2.2/en/installconfig-network-dev-discovery",
                        "displayLink": "maas.io/docs",
                        "snippet": "Install from ISO · Install from packages · Install from a snap · Install with LXD · \nUpgrade from 1.9 to 2.0 · Hardware testing · Commissioning and Hardware \ntesting ...",
                        "htmlSnippet": "Install from ISO &middot; Install from packages &middot; Install from a \u003cb\u003esnap\u003c/b\u003e &middot; Install with LXD &middot; \u003cbr\u003e\nUpgrade from 1.9 to 2.0 &middot; Hardware testing &middot; Commissioning and Hardware \u003cbr\u003e\ntesting&nbsp;...",
                        "cacheId": "pN51ZwRWBqYJ",
                        "formattedUrl": "https://maas.io/docs/2.2/en/installconfig-network-dev-discovery",
                        "htmlFormattedUrl": "https://maas.io/docs/2.2/en/installconfig-network-dev-discovery",
                    },
                    {
                        "title": "Architectural Overview | MAAS documentation",
                        "htmlTitle": "Architectural Overview | MAAS documentation",
                        "link": "https://maas.io/docs/2.2/en/intro-architecture",
                        "displayLink": "maas.io/docs",
                        "snippet": "Install from ISO · Install from packages · Install from a snap · Install with LXD · \nUpgrade from 1.9 to 2.0 · Hardware testing · Commissioning and Hardware \ntesting ...",
                        "htmlSnippet": "Install from ISO &middot; Install from packages &middot; Install from a \u003cb\u003esnap\u003c/b\u003e &middot; Install with LXD &middot; \u003cbr\u003e\nUpgrade from 1.9 to 2.0 &middot; Hardware testing &middot; Commissioning and Hardware \u003cbr\u003e\ntesting&nbsp;...",
                        "cacheId": "XePT7iPs_uUJ",
                        "formattedUrl": "https://maas.io/docs/2.2/en/intro-architecture",
                        "htmlFormattedUrl": "https://maas.io/docs/2.2/en/intro-architecture",
                    },
                ],
            }
        ),
        content_type="application/json",
    )

    # Results for "snap" with start=20
    httpretty.register_uri(
        httpretty.GET,
        "https://www.googleapis.com/customsearch/v1/siterestrict?key=test-api-key&cx=009048213575199080868%3Ai3zoqdwqk8o&q=snap&start=20",
        match_querystring=True,
        body=json.dumps(
            {
                "queries": {
                    "previousPage": [{"count": 10, "startIndex": 10}],
                    "nextPage": [{"count": 10, "startIndex": 30}],
                },
                "items": [
                    {
                        "title": "Installing snap on CentOS - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on CentOS - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-centos",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Snap is available for CentOS 7.6+, and Red Hat Enterprise Linux 7.6+, from the ... \nOnce installed, the systemd unit that manages the main snap communication ...",
                        "htmlSnippet": "\u003cb\u003eSnap\u003c/b\u003e is available for CentOS 7.6+, and Red Hat Enterprise Linux 7.6+, from the ... \u003cbr\u003e\nOnce installed, the systemd unit that manages the main \u003cb\u003esnap\u003c/b\u003e communication&nbsp;...",
                        "cacheId": "92ch6i8PQuwJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-centos",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-centos",
                    },
                    {
                        "title": "Snapshots - Snap documentation",
                        "htmlTitle": "Snapshots - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/snapshots",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "A snapshot is a copy of the user, system and configuration data stored by snapd \nfor one or more snaps on your system. Snapshots are generated manually with ...",
                        "htmlSnippet": "A snapshot is a copy of the user, system and configuration data stored by snapd \u003cbr\u003e\nfor one or more \u003cb\u003esnaps\u003c/b\u003e on your system. Snapshots are generated manually with&nbsp;...",
                        "cacheId": "dEmR_zVdN4cJ",
                        "formattedUrl": "https://docs.snapcraft.io/snapshots",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/\u003cb\u003esnaps\u003c/b\u003ehots",
                    },
                    {
                        "title": "The snap format - Snap documentation",
                        "htmlTitle": "The \u003cb\u003esnap\u003c/b\u003e format - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/snap-format",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "A snap is a Squashfs file carrying content alongside metadata to tell the system it \nshould be manipulated. When installed, the Squashfs file for the snap is ...",
                        "htmlSnippet": "A \u003cb\u003esnap\u003c/b\u003e is a Squashfs file carrying content alongside metadata to tell the system it \u003cbr\u003e\nshould be manipulated. When installed, the Squashfs file for the \u003cb\u003esnap\u003c/b\u003e is&nbsp;...",
                        "cacheId": "hRzSriKzEf4J",
                        "formattedUrl": "https://docs.snapcraft.io/snap-format",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/\u003cb\u003esnap\u003c/b\u003e-format",
                    },
                    {
                        "title": "ROS applications - Snap documentation",
                        "htmlTitle": "ROS applications - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/ros-applications",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "With snapcraft it's just one command to bundle a specific ROS version along with \nyour application into a snap that works anywhere and can be automatically ...",
                        "htmlSnippet": "With snapcraft it&#39;s just one command to bundle a specific ROS version along with \u003cbr\u003e\nyour application into a \u003cb\u003esnap\u003c/b\u003e that works anywhere and can be automatically&nbsp;...",
                        "cacheId": "noAw-PbE2uoJ",
                        "formattedUrl": "https://docs.snapcraft.io/ros-applications",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/ros-applications",
                    },
                    {
                        "title": "Releasing your app - Snap documentation",
                        "htmlTitle": "Releasing your app - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/releasing-your-app",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "After creating a snap a snap, you should upload it to the Snap Store, from where \nit can reach a potential audience of millions. You will need the following:.",
                        "htmlSnippet": "After creating a \u003cb\u003esnap\u003c/b\u003e a \u003cb\u003esnap\u003c/b\u003e, you should upload it to the \u003cb\u003eSnap\u003c/b\u003e Store, from where \u003cbr\u003e\nit can reach a potential audience of millions. You will need the following:.",
                        "cacheId": "8gxdj62dskMJ",
                        "formattedUrl": "https://docs.snapcraft.io/releasing-your-app",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/releasing-your-app",
                    },
                    {
                        "title": "Installing snap on Raspbian - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on Raspbian - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-raspbian",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "The default terminal, also known as a command line, is called LXTerminal and it's \nlaunched from its icon on the desktop. Take a look at the official Raspberry Pi ...",
                        "htmlSnippet": "The default terminal, also known as a command line, is called LXTerminal and it&#39;s \u003cbr\u003e\nlaunched from its icon on the desktop. Take a look at the official Raspberry Pi&nbsp;...",
                        "cacheId": "KHRYCfaTqewJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-raspbian",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-raspbian",
                    },
                    {
                        "title": "Install from a Snap | MAAS documentation",
                        "htmlTitle": "Install from a \u003cb\u003eSnap\u003c/b\u003e | MAAS documentation",
                        "link": "https://maas.io/docs/2.6/en/installconfig-snap-install",
                        "displayLink": "maas.io/docs",
                        "snippet": "Snaps are containerised software packages. To install MAAS from a snap, simply \nenter the following: sudo snap install maas --devmode --stable. After entering ...",
                        "htmlSnippet": "\u003cb\u003eSnaps\u003c/b\u003e are containerised software packages. To install MAAS from a \u003cb\u003esnap\u003c/b\u003e, simply \u003cbr\u003e\nenter the following: sudo \u003cb\u003esnap\u003c/b\u003e install maas --devmode --stable. After entering&nbsp;...",
                        "cacheId": "GL7NO5yj7fMJ",
                        "formattedUrl": "https://maas.io/docs/2.6/en/installconfig-snap-install",
                        "htmlFormattedUrl": "https://maas.io/docs/2.6/en/installconfig-\u003cb\u003esnap\u003c/b\u003e-install",
                    },
                    {
                        "title": "Configuration in snaps - Snap documentation",
                        "htmlTitle": "Configuration in \u003cb\u003esnaps\u003c/b\u003e - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/configuration-in-snaps",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "For example, to see the configuration options exposed by an installed snap, enter \nsnap get \u003csnap name\u003e : $ sudo snap get nextcloud Key Value nextcloud {.",
                        "htmlSnippet": "For example, to see the configuration options exposed by an installed \u003cb\u003esnap\u003c/b\u003e, enter \u003cbr\u003e\n\u003cb\u003esnap\u003c/b\u003e get &lt;\u003cb\u003esnap\u003c/b\u003e name&gt; : $ sudo \u003cb\u003esnap\u003c/b\u003e get nextcloud Key Value nextcloud {.",
                        "cacheId": "RqKLvEvwGmMJ",
                        "formattedUrl": "https://docs.snapcraft.io/configuration-in-snaps",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/configuration-in-\u003cb\u003esnaps\u003c/b\u003e",
                    },
                    {
                        "title": "Installing snap on Deepin - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on Deepin - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-deepin",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Installing snap on Deepin. Snap can be installed by opening a terminal and \ntyping a couple of commands. Deepin's terminal, also known as a command line,\n ...",
                        "htmlSnippet": "Installing \u003cb\u003esnap\u003c/b\u003e on Deepin. \u003cb\u003eSnap\u003c/b\u003e can be installed by opening a terminal and \u003cbr\u003e\ntyping a couple of commands. Deepin&#39;s terminal, also known as a command line,\u003cbr\u003e\n&nbsp;...",
                        "cacheId": "9l_kpf-0rwkJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-deepin",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-deepin",
                    },
                    {
                        "title": "Releasing to the Snap Store - Snap documentation",
                        "htmlTitle": "Releasing to the \u003cb\u003eSnap\u003c/b\u003e Store - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/releasing-to-the-snap-store",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Once you have a snap that works under strict or classic confinement, you're ready \nto publish the snap in the Snap Store where it can be showcased to millions.",
                        "htmlSnippet": "Once you have a \u003cb\u003esnap\u003c/b\u003e that works under strict or classic confinement, you&#39;re ready \u003cbr\u003e\nto publish the \u003cb\u003esnap\u003c/b\u003e in the \u003cb\u003eSnap\u003c/b\u003e Store where it can be showcased to millions.",
                        "cacheId": "s6Kn8uAqHMUJ",
                        "formattedUrl": "https://docs.snapcraft.io/releasing-to-the-snap-store",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/releasing-to-the-\u003cb\u003esnap\u003c/b\u003e-store",
                    },
                ],
            }
        ),
        content_type="application/json",
    )

    # Results for "snap" with start=20 and num=3
    httpretty.register_uri(
        httpretty.GET,
        "https://www.googleapis.com/customsearch/v1/siterestrict?key=test-api-key&cx=009048213575199080868%3Ai3zoqdwqk8o&q=snap&start=20&num=3",
        match_querystring=True,
        body=json.dumps(
            {
                "hello": "world",
                "queries": {
                    "previousPage": [{"count": 3, "startIndex": 17}],
                    "nextPage": [{"count": 3, "startIndex": 23}],
                },
                "items": [
                    {
                        "title": "Installing snap on CentOS - Snap documentation",
                        "htmlTitle": "Installing \u003cb\u003esnap\u003c/b\u003e on CentOS - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/installing-snap-on-centos",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "Snap is available for CentOS 7.6+, and Red Hat Enterprise Linux 7.6+, from the ... \nOnce installed, the systemd unit that manages the main snap communication ...",
                        "htmlSnippet": "\u003cb\u003eSnap\u003c/b\u003e is available for CentOS 7.6+, and Red Hat Enterprise Linux 7.6+, from the ... \u003cbr\u003e\nOnce installed, the systemd unit that manages the main \u003cb\u003esnap\u003c/b\u003e communication&nbsp;...",
                        "cacheId": "92ch6i8PQuwJ",
                        "formattedUrl": "https://docs.snapcraft.io/installing-snap-on-centos",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/installing-\u003cb\u003esnap\u003c/b\u003e-on-centos",
                    },
                    {
                        "title": "Snapshots - Snap documentation",
                        "htmlTitle": "Snapshots - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/snapshots",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "A snapshot is a copy of the user, system and configuration data stored by snapd \nfor one or more snaps on your system. Snapshots are generated manually with ...",
                        "htmlSnippet": "A snapshot is a copy of the user, system and configuration data stored by snapd \u003cbr\u003e\nfor one or more \u003cb\u003esnaps\u003c/b\u003e on your system. Snapshots are generated manually with&nbsp;...",
                        "cacheId": "dEmR_zVdN4cJ",
                        "formattedUrl": "https://docs.snapcraft.io/snapshots",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/\u003cb\u003esnaps\u003c/b\u003ehots",
                    },
                    {
                        "title": "The snap format - Snap documentation",
                        "htmlTitle": "The \u003cb\u003esnap\u003c/b\u003e format - \u003cb\u003eSnap\u003c/b\u003e documentation",
                        "link": "https://docs.snapcraft.io/snap-format",
                        "displayLink": "docs.snapcraft.io",
                        "snippet": "A snap is a Squashfs file carrying content alongside metadata to tell the system it \nshould be manipulated. When installed, the Squashfs file for the snap is ...",
                        "htmlSnippet": "A \u003cb\u003esnap\u003c/b\u003e is a Squashfs file carrying content alongside metadata to tell the system it \u003cbr\u003e\nshould be manipulated. When installed, the Squashfs file for the \u003cb\u003esnap\u003c/b\u003e is&nbsp;...",
                        "cacheId": "hRzSriKzEf4J",
                        "formattedUrl": "https://docs.snapcraft.io/snap-format",
                        "htmlFormattedUrl": "https://docs.\u003cb\u003esnap\u003c/b\u003ecraft.io/\u003cb\u003esnap\u003c/b\u003e-format",
                    },
                ],
            }
        ),
        content_type="application/json",
    )
