"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!(props === null || props === void 0 ? void 0 : props.userPool)) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool");
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props === null || props === void 0 ? void 0 : props.identityPoolOptions,
            authenticationProviders: {
                ...(_b = props === null || props === void 0 ? void 0 : props.identityPoolOptions) === null || _b === void 0 ? void 0 : _b.authenticationProviders,
                userPools: [
                    ...(((_d = (_c = props === null || props === void 0 ? void 0 : props.identityPoolOptions) === null || _c === void 0 ? void 0 : _c.authenticationProviders) === null || _d === void 0 ? void 0 : _d.userPools) ||
                        []),
                    ...(this.userPool
                        ? [new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({ userPool: this.userPool })]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.0.76" };
//# sourceMappingURL=data:application/json;base64,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