from ruleau import All, execute, rule
from ruleau.adapter import ApiAdapter


# create a rule
@rule(rule_id="rul_01", name="over_18")
def over_18(context, payload):
    """
    Check applicant over 18
    >>> age(None, {"age": 18})
    True
    >>> age(None, {"age": 17})
    False
    """
    return "age" in payload and payload["age"] >= 18


@rule(rule_id="rul_02", name="not_short", depends_on=[over_18])
def not_short(context, payload):
    """
    Check applicant isn't short
    """
    return (
        context.dependent_results.over_18.result
        and "height" in payload
        and payload["height"] == "tall"
    )


collection = All(
    "Age Checker",
    "rul_03",
    All("sub level", "rul_04", over_18, All("sub sub level", "rul_05", not_short)),
)

# create a payload (the answers to the rule's questions)
payload = {"age": 18, "height": "tall", "case_id": "testing-xx"}
api_adapter = ApiAdapter(base_url="http://localhost:8000/")
# send the results
result = execute(
    collection,
    payload,
    # api_adapter=api_adapter,
    case_id_jsonpath="$.case_id",
)
print(f"result: {result.result}")
