# Docker

The *steinbock* framework can be used interactively using the *steinbock* Docker container.

In this section, the installation and configuration of the *steinbock* Docker container is described.

## Requirements

[Install Docker](https://docs.docker.com/get-docker/)

!!! note "Adding a user to the `docker-users` group on Windows hosts"
    On Windows hosts, to add a user to the `docker-users` group using the Command Prompt (as administrator):

        net localgroup /add docker-users <username>
		
	Replace `<username>` with the name of the user (for domain accounts, use the `<domain>\<username>` format).

## Usage

In principle, the *steinbock* Docker container can be run on any Docker-enabled platform:

    docker run jwindhager/steinbock

For reproducibility, it is recommended to always pull a specific release, e.g.:

    docker run jwindhager/steinbock:0.5.6

Commands that launch a graphical user interface (e.g., for Ilastik, CellProfiler) may require further system configuration and additional arguments to `docker run`. To simplify the use of the *steinbock* command-line interface, it is therefore recommended to use a `steinbock` alias for the `docker run` command, as explained in the following.

### Windows

On the Command Prompt, to create a `steinbock` command alias for running *steinbock*:

    doskey steinbock=docker run -v "C:\Data":/data jwindhager/steinbock:0.5.6 $*

In the command above, adapt the path to your *steinbock* data/working directory (`C:\Data`) and the *steinbock* Docker container version (`0.5.6`) as needed. The created alias enables running `steinbock` from the current Command Prompt without typing the full Docker command.

To check whether *steinbock* runs (this should print the *steinbock* Docker container version):

    steinbock --version

!!! note "Graphical user interfaces on Windows hosts"
    Commands that launch a graphical user interface (e.g., for Ilastik, CellProfiler) will not work on Windows hosts. It is recommended to run these programs directly on the Windows host, if graphical user interfaces are required.

### Linux

On the terminal, to create a `steinbock` command alias for running *steinbock*:

    alias steinbock="docker run -v /mnt/data:/data -v /tmp/.X11-unix:/tmp/.X11-unix -v ~/.Xauthority:/home/steinbock/.Xauthority:ro -e DISPLAY jwindhager/steinbock:0.5.6"

In the command above, adapt the path to your *steinbock* data/working directory (`/mnt/data`) and the *steinbock* Docker container version (`0.5.6`) as needed. The created alias enables running `steinbock` from the current terminal without typing the full Docker command.

To allow the *steinbock* Docker container to run graphical user interfaces, if necessary:

    xhost +local:root

To check whether *steinbock* runs (this should print the *steinbock* Docker container version):

    steinbock --version

### MacOS

To allow the *steinbock* Docker container to run graphical user interfaces, you will first need to install [XQuartz](https://www.xquartz.org/).

Open *XQuartz* > *Preferences* and tick `Allow connections from network clients`.

In the terminal run

    xhost + ${hostname}
    
Next, setup a HOSTNAME environment variable via:

    export HOSTNAME=`hostname`
    
Finally, on the terminal, to create a `steinbock` command alias for running *steinbock*:

    alias steinbock="docker run -v /mnt/data:/data -v /tmp/.X11-unix:/tmp/.X11-unix -v ~/.Xauthority:/home/steinbock/.Xauthority:ro --env "DISPLAY=${HOSTNAME}:0" jwindhager/steinbock:0.5.6"
    
In the command above, adapt the path to your *steinbock* data/working directory (`/mnt/data`) and the *steinbock* Docker container version (`0.5.6`) as needed. The created alias enables running `steinbock` from the current terminal without typing the full Docker command.

To check whether *steinbock* runs (this should print the *steinbock* Docker container version):

    steinbock --version    


## Usage

Please refer to [CLI usage](../cli/intro.md) for usage instructions.

!!! note "File permissions"
    By default, the *steinbock* Docker container internally runs as `steinbock` user with user ID (UID) `1000` and group ID (GID) `1000`. Files created from within the container will therefore be owned by the host system user/group matching these IDs. On most Linux systems, by default, this will map to the standard user (e.g., `ubuntu`). 
    
    However, if your user does not match the UID/GID (e.g., on multi-user environments, MacOS), you may not have ownership/write access to files generated by `steinbock`. In this case, you have the following options:

      - **[Beginner]** After creating files with *steinbock*, change their ownership to your account

      - **[Linux only]** Mount `/etc/passwd` and run the Docker container with a user existing on the host: 

            docker run -v /etc/passwd:/etc/passwd:ro -u $(id -u):$(id -g) ...

      - **[Advanced]** Run the *steinbock* Docker container using [singularity](https://sylabs.io/singularity/) (see [here](https://sylabs.io/guides/3.0/user-guide/singularity_and_docker.html)) to minimize abstraction

      - **[Administrator]** Re-build the *steinbock* Docker container from scratch with matching UID/GID ([Dockerfile](https://github.com/BodenmillerGroup/steinbock/blob/main/Dockerfile))

      - **[Developer]** If you would like to provide a workaround for this inconvenience (e.g., automatically change the UID/GID at runtime of the *steinbock* Docker container), you are more than welcome to submit a pull request!

    The data/working directory must be writable by the `steinbock` user from within the *steinbock* Docker container.
