import { EventPattern } from './event-pattern';
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
export declare function mergeEventPattern(dest: any, src: any): any;
/**
 * Whether two string probably contain the same environment dimension (region or account)
 *
 * Used to compare either accounts or regions, and also returns true if both
 * are unresolved (in which case both are expted to be "current region" or "current account").
 * @internal
 */
export declare function sameEnvDimension(dim1: string, dim2: string): boolean;
/**
 * Transform an eventPattern object into a valid Event Rule Pattern
 * by changing detailType into detail-type when present.
 */
export declare function renderEventPattern(eventPattern: EventPattern): any;
