#!/usr/bin/env python
# -*- coding: utf-8 -*--

# Copyright (c) 2021 Oracle and/or its affiliates.
# Licensed under the Universal Permissive License v 1.0 as shown at https://oss.oracle.com/licenses/upl/

"""
The module save the gis data corresponding to zip code.
"""
import pandas as pd

zip_code_dict = {
    "00501": (40.922326, -72.637078),
    "00544": (40.922326, -72.637078),
    "00601": (18.165273, -66.722583),
    "00602": (18.393103, -67.180953),
    "00603": (18.455913, -67.14578),
    "00604": (18.49352, -67.135883),
    "00605": (18.465162, -67.141486),
    "00606": (18.172947, -66.944111),
    "00610": (18.288685, -67.139696),
    "00611": (18.279531, -66.80217),
    "00612": (18.450674, -66.698262),
    "00613": (18.458093, -66.732732),
    "00614": (18.429675, -66.674506),
    "00616": (18.444792, -66.640678),
    "00617": (18.447092, -66.544255),
    "00622": (17.998531, -67.187318),
    "00623": (18.062201, -67.149541),
    "00624": (18.023535, -66.726156),
    "00627": (18.477891, -66.85477),
    "00631": (18.269187, -66.864993),
    "00636": (18.113284, -67.039706),
    "00637": (18.087322, -66.934911),
    "00638": (18.33616, -66.472087),
    "00641": (18.250027, -66.698957),
    "00646": (18.43606, -66.281954),
    "00647": (17.969594, -66.939754),
    "00650": (18.360125, -66.562311),
    "00652": (18.457254, -66.603358),
    "00653": (17.972468, -66.898661),
    "00656": (18.02328, -66.786909),
    "00659": (18.481391, -66.808696),
    "00660": (18.145486, -67.135323),
    "00662": (18.480285, -67.028155),
    "00664": (18.217606, -66.598306),
    "00667": (18.015099, -67.055973),
    "00669": (18.295952, -66.881925),
    "00670": (18.252135, -66.990967),
    "00674": (18.44553, -66.490268),
    "00676": (18.383727, -67.080799),
    "00677": (18.335781, -67.252547),
    "00678": (18.45303, -66.933689),
    "00680": (18.219023, -67.508068),
    "00681": (18.219023, -67.508068),
    "00682": (18.219023, -67.508068),
    "00683": (18.113284, -67.039706),
    "00685": (18.3236, -66.972227),
    "00687": (18.316976, -66.415207),
    "00688": (18.429675, -66.674506),
    "00690": (18.476196, -67.139597),
    "00692": (18.435818, -66.338523),
    "00693": (18.443109, -66.398302),
    "00694": (18.443109, -66.398302),
    "00698": (18.06104, -66.861164),
    "00703": (18.250398, -66.12845),
    "00704": (17.99229, -66.139253),
    "00705": (18.128092, -66.268717),
    "00707": (18.007014, -65.898719),
    "00714": (17.96751, -66.04138),
    "00715": (18.011854, -66.563721),
    "00716": (18.001995, -66.607429),
    "00717": (18.001995, -66.607429),
    "00718": (18.22139, -65.77831),
    "00719": (18.298017, -66.229751),
    "00720": (18.226862, -66.39402),
    "00721": (18.364161, -65.778288),
    "00723": (18.009994, -66.010572),
    "00725": (18.212965, -66.058033),
    "00726": (18.212965, -66.058033),
    "00727": (18.212965, -66.058033),
    "00728": (18.001995, -66.607429),
    "00729": (18.333093, -65.883864),
    "00730": (18.001995, -66.607429),
    "00731": (18.03831, -66.626344),
    "00732": (18.021781, -66.613742),
    "00733": (18.019331, -66.619165),
    "00734": (17.999499, -66.643934),
    "00735": (18.264872, -65.594769),
    "00736": (18.102967, -66.139274),
    "00737": (18.102967, -66.139274),
    "00738": (18.359381, -65.611361),
    "00739": (18.181469, -66.169519),
    "00740": (18.331958, -65.63878),
    "00741": (18.162156, -65.753485),
    "00742": (18.264872, -65.594769),
    "00744": (18.206329, -65.743058),
    "00745": (18.367347, -65.816583),
    "00751": (17.99852, -66.264825),
    "00754": (18.187584, -65.962389),
    "00757": (17.991233, -66.395543),
    "00765": (18.123347, -65.460356),
    "00766": (18.120519, -66.496607),
    "00767": (18.045522, -65.886988),
    "00769": (18.095992, -66.35081),
    "00771": (18.196576, -65.87197),
    "00772": (18.447406, -65.899357),
    "00773": (18.366027, -65.708138),
    "00775": (18.323736, -65.296467),
    "00777": (18.206489, -65.901774),
    "00778": (18.259092, -65.974641),
    "00780": (18.001995, -66.607429),
    "00782": (18.224958, -66.219885),
    "00783": (18.304369, -66.330525),
    "00784": (17.99229, -66.139253),
    "00785": (18.018822, -66.795603),
    "00786": (18.128092, -66.268717),
    "00791": (18.138029, -65.788499),
    "00792": (18.138029, -65.788499),
    "00794": (18.200898, -66.307236),
    "00795": (17.997367, -66.493218),
    "00801": (18.322285, -64.963715),
    "00802": (18.322285, -64.963715),
    "00803": (18.322285, -64.963715),
    "00804": (18.322285, -64.963715),
    "00805": (18.322285, -64.963715),
    "00820": (17.734211, -64.734694),
    "00821": (17.734211, -64.734694),
    "00822": (17.734211, -64.734694),
    "00823": (17.734211, -64.734694),
    "00824": (17.734211, -64.734694),
    "00830": (18.32816, -64.740737),
    "00831": (18.32816, -64.740737),
    "00840": (17.734211, -64.734694),
    "00841": (17.734211, -64.734694),
    "00850": (17.734211, -64.734694),
    "00851": (17.734211, -64.734694),
    "00901": (18.465901, -66.103568),
    "00902": (18.410462, -66.060533),
    "00906": (18.410462, -66.060533),
    "00907": (18.451647, -66.077003),
    "00908": (18.410462, -66.060533),
    "00909": (18.443384000000002, -66.068133),
    "00910": (18.410462, -66.060533),
    "00911": (18.450828, -66.057859),
    "00912": (18.444187, -66.059859),
    "00913": (18.450735, -66.043352),
    "00914": (18.410462, -66.060533),
    "00915": (18.437896, -66.048087),
    "00916": (18.410462, -66.060533),
    "00917": (18.422018, -66.050602),
    "00918": (18.419069, -66.062319),
    "00919": (18.410462, -66.060533),
    "00920": (18.406808, -66.091885),
    "00921": (18.390429, -66.066124),
    "00922": (18.410462, -66.060533),
    "00923": (18.410775, -66.036708),
    "00924": (18.396392, -66.01146),
    "00925": (18.401055, -66.049773),
    "00926": (18.369376, -66.062804),
    "00927": (18.385174, -66.071959),
    "00928": (18.410462, -66.060533),
    "00929": (18.410462, -66.060533),
    "00930": (18.410462, -66.060533),
    "00931": (18.410462, -66.060533),
    "00933": (18.410462, -66.060533),
    "00934": (18.34487, -66.166014),
    "00935": (18.410462, -66.060533),
    "00936": (18.410462, -66.060533),
    "00937": (18.410462, -66.060533),
    "00938": (18.410462, -66.060533),
    "00939": (18.410462, -66.060533),
    "00940": (18.410462, -66.060533),
    "00949": (18.431911, -66.199692),
    "00950": (18.457761, -66.196503),
    "00951": (18.457761, -66.196503),
    "00952": (18.457761, -66.196503),
    "00953": (18.356794999999998, -66.25701),
    "00954": (18.358939, -66.258108),
    "00955": (18.410462, -66.060533),
    "00956": (18.326702, -66.174176),
    "00957": (18.366645, -66.183907),
    "00958": (18.34487, -66.166014),
    "00959": (18.387058, -66.159044),
    "00960": (18.34487, -66.166014),
    "00961": (18.413195, -66.168651),
    "00962": (18.437644, -66.140407),
    "00963": (18.443217, -66.139293),
    "00965": (18.428784, -66.11539),
    "00966": (18.396815, -66.114889),
    "00968": (18.410462, -66.060533),
    "00969": (18.362322, -66.113729),
    "00970": (18.359143, -66.112295),
    "00971": (18.30942, -66.113606),
    "00975": (18.410462, -66.060533),
    "00976": (18.338133, -65.989229),
    "00977": (18.337004, -65.990099),
    "00978": (18.337004, -65.990099),
    "00979": (18.410462, -66.060533),
    "00981": (18.410462, -66.060533),
    "00982": (18.410462, -66.060533),
    "00983": (18.413452, -65.977659),
    "00984": (18.393355, -65.972495),
    "00985": (18.345741, -65.93888),
    "00986": (18.393355, -65.972495),
    "00987": (18.373466, -65.959932),
    "00988": (18.393355, -65.972495),
    "01001": (42.140549, -72.788661),
    "01002": (42.367092, -72.464571),
    "01003": (42.369562, -72.63599),
    "01004": (42.384494, -72.513183),
    "01005": (42.32916, -72.139465),
    "01007": (42.280267, -72.402056),
    "01008": (42.177833, -72.958359),
    "01009": (42.206092, -72.340486),
    "01010": (42.108585, -72.20448),
    "01011": (42.294259, -72.952776),
    "01012": (42.392274, -72.825607),
    "01013": (42.161492, -72.667341),
    "01014": (42.170731, -72.604842),
    "01020": (42.177492, -72.562563),
    "01021": (42.170731, -72.604842),
    "01022": (42.193392, -72.55436),
    "01026": (42.428617, -72.909841),
    "01027": (42.368303, -72.768839),
    "01028": (42.062009, -72.49874),
    "01029": (42.190904, -73.051661),
    "01030": (42.189335, -72.79774),
    "01031": (42.352554, -72.205724),
    "01032": (42.443837, -72.819446),
    "01033": (42.262285, -72.504086),
    "01034": (42.112748, -72.952003),
    "01035": (42.356804, -72.576613),
    "01036": (42.067614, -72.417507),
    "01037": (42.347856, -72.225251),
    "01038": (42.387269, -72.643081),
    "01039": (42.35641, -72.682127),
    "01040": (42.198291, -72.64207),
    "01041": (42.170731, -72.604842),
    "01050": (42.313427, -72.903677),
    "01053": (42.353838, -72.704385),
    "01054": (42.474681, -72.467543),
    "01056": (42.173276, -72.627038),
    "01057": (42.095323, -72.282063),
    "01059": (42.369562, -72.63599),
    "01060": (42.415154, -72.76927),
    "01061": (42.369562, -72.63599),
    "01062": (42.328838, -72.845227),
    "01063": (42.317939, -72.640234),
    "01066": (42.406697, -72.633901),
    "01068": (42.346144, -72.058847),
    "01069": (42.176131, -72.31457),
    "01070": (42.448984, -72.958397),
    "01071": (42.177432, -72.864558),
    "01072": (42.471562, -72.44017),
    "01073": (42.230008, -72.728463),
    "01074": (42.375998, -72.149388),
    "01075": (42.24984, -72.58152),
    "01077": (42.066644, -72.541205),
    "01079": (42.192892, -72.329574),
    "01080": (42.179805, -72.517813),
    "01081": (42.061948, -72.213598),
    "01082": (42.377471, -72.548549),
    "01083": (42.204027, -72.199439),
    "01084": (42.390303, -72.870857),
    "01085": (42.14869, -72.501887),
    "01086": (42.173428, -72.847964),
    "01088": (42.390583, -72.646894),
    "01089": (42.125793, -72.645334),
    "01090": (42.170731, -72.604842),
    "01092": (42.202887, -72.229025),
    "01093": (42.442673, -72.652511),
    "01094": (42.358201, -72.140846),
    "01095": (42.125974, -72.489988),
    "01096": (42.413069, -72.821653),
    "01097": (42.161743, -72.845912),
    "01098": (42.40494, -72.896133),
    "01101": (42.170731, -72.604842),
    "01102": (42.170731, -72.604842),
    "01103": (42.103044, -72.590783),
    "01104": (42.128605, -72.567966),
    "01105": (42.099793, -72.577732),
    "01106": (42.049194, -72.567882),
    "01107": (42.126237, -72.586733),
    "01108": (42.080594, -72.558081),
    "01109": (42.119293, -72.548981),
    "01111": (42.170731, -72.604842),
    "01114": (42.170731, -72.604842),
    "01115": (42.102894, -72.591633),
    "01116": (42.170731, -72.604842),
    "01118": (42.093894, -72.523227),
    "01119": (42.124943, -72.526705),
    "01128": (42.094616, -72.487229),
    "01129": (42.124485, -72.489479),
    "01133": (42.170731, -72.604842),
    "01138": (42.170731, -72.604842),
    "01139": (42.170731, -72.604842),
    "01144": (42.101796, -72.59151),
    "01151": (42.150593, -72.51278),
    "01152": (42.170731, -72.604842),
    "01199": (42.119943, -72.604983),
    "01201": (42.479475, -73.24807),
    "01202": (42.3929, -73.228483),
    "01203": (42.3929, -73.228483),
    "01220": (42.385595, -73.172166),
    "01222": (42.185969, -73.318695),
    "01223": (42.3418, -73.103468),
    "01224": (42.3929, -73.228483),
    "01225": (42.482125, -73.127483),
    "01226": (42.470296, -73.08895),
    "01227": (42.516145, -73.092852),
    "01229": (42.279292, -73.343545),
    "01230": (42.299392, -73.26665),
    "01235": (42.29237, -73.22164),
    "01236": (42.291299, -73.358798),
    "01237": (42.487569, -73.235048),
    "01238": (42.369856, -73.267465),
    "01240": (42.459202, -73.219858),
    "01242": (42.338594, -73.250891),
    "01243": (42.356088, -73.010448),
    "01244": (42.122827, -73.253983),
    "01245": (42.18669, -73.206498),
    "01247": (42.426974, -73.18632),
    "01252": (42.198648, -73.446234),
    "01253": (42.213156, -73.090434),
    "01254": (42.233105, -73.238358),
    "01255": (42.148975, -73.14861),
    "01256": (42.367341, -73.128528),
    "01257": (42.314564, -73.267694),
    "01258": (42.128075, -73.36089),
    "01259": (42.198712, -73.278543),
    "01260": (42.286586, -73.313274),
    "01262": (42.304604, -73.330001),
    "01263": (42.3929, -73.228483),
    "01264": (42.220001, -73.197865),
    "01266": (42.360482, -73.265354),
    "01267": (42.642075, -73.257699),
    "01270": (42.443726, -73.116127),
    "01301": (42.601335, -72.623619),
    "01302": (42.522178, -72.624164),
    "01330": (42.562391, -72.738152),
    "01331": (42.547302, -72.183903),
    "01337": (42.62706, -72.642888),
    "01338": (42.573832, -72.769487),
    "01339": (42.594252, -72.665507),
    "01340": (42.681539, -72.822986),
    "01341": (42.590824, -72.70976),
    "01342": (42.54723, -72.607679),
    "01343": (42.642666, -72.986231),
    "01344": (42.627072, -72.553654),
    "01346": (42.618011, -72.788896),
    "01347": (42.556558, -72.518104),
    "01349": (42.621412, -72.705633),
    "01350": (42.721456, -72.976204),
    "01351": (42.548107, -72.48693),
    "01354": (42.522178, -72.624164),
    "01355": (42.518718, -72.534371),
    "01360": (42.614152, -72.528209),
    "01364": (42.578325, -72.556589),
    "01366": (42.459632, -72.182962),
    "01367": (42.683065, -72.715667),
    "01368": (42.672182, -72.196376),
    "01369": (42.522178, -72.624164),
    "01370": (42.588812, -72.758781),
    "01373": (42.464522, -72.682346),
    "01375": (42.565346, -72.70094),
    "01376": (42.654878, -72.718123),
    "01378": (42.667059, -72.339655),
    "01379": (42.581007, -72.437179),
    "01380": (42.553431, -72.392694),
    "01420": (42.583689, -71.816767),
    "01430": (42.654906, -71.920942),
    "01431": (42.446396, -71.459405),
    "01432": (42.446396, -71.459405),
    "01436": (42.601427, -72.083838),
    "01438": (42.551681, -72.029434),
    "01440": (42.582529, -72.025884),
    "01441": (42.364807, -71.896868),
    "01450": (42.446396, -71.459405),
    "01451": (42.500187, -71.575864),
    "01452": (42.483895, -72.011516),
    "01453": (42.471316, -71.837509),
    "01460": (42.446396, -71.459405),
    "01462": (42.583322, -71.752266),
    "01463": (42.446396, -71.459405),
    "01464": (42.446396, -71.459405),
    "01467": (42.487056, -71.613078),
    "01468": (42.555059, -72.072285),
    "01469": (42.446396, -71.459405),
    "01470": (42.446396, -71.459405),
    "01471": (42.446396, -71.459405),
    "01472": (42.446396, -71.459405),
    "01473": (42.549489, -71.913219),
    "01474": (42.446396, -71.459405),
    "01475": (42.661612, -72.047876),
    "01477": (42.364807, -71.896868),
    "01501": (42.184835, -71.947184),
    "01503": (42.3129, -71.841656),
    "01504": (42.114078, -71.799785),
    "01505": (42.300037, -71.943458),
    "01506": (42.19169, -72.105011),
    "01507": (42.13277, -71.972627),
    "01508": (42.109748, -72.079455),
    "01509": (42.364807, -71.896868),
    "01510": (42.413972, -71.687523),
    "01515": (42.205311, -72.049907),
    "01516": (42.113076, -71.891139),
    "01517": (42.364807, -71.896868),
    "01518": (42.106405, -72.114045),
    "01519": (42.203944, -71.682862),
    "01520": (42.336791, -71.845316),
    "01521": (42.061063, -72.163991),
    "01522": (42.264629, -71.795442),
    "01523": (42.427188, -71.91177),
    "01524": (42.238192, -72.012379),
    "01525": (42.364807, -71.896868),
    "01526": (42.364807, -71.896868),
    "01527": (42.255642, -71.819961),
    "01529": (42.124662, -71.846943),
    "01531": (42.320938, -72.128644),
    "01532": (42.322118, -71.64282),
    "01534": (42.207191, -71.856807),
    "01535": (42.275382, -72.089338),
    "01536": (42.407556, -71.860402),
    "01537": (42.166241, -71.891052),
    "01538": (42.364807, -71.896868),
    "01540": (42.109223, -71.855444),
    "01541": (42.451926, -71.880057),
    "01542": (42.220085, -71.914361),
    "01543": (42.383516, -71.95463),
    "01545": (42.286992, -71.715313),
    "01546": (42.364807, -71.896868),
    "01550": (42.129251, -72.031155),
    "01560": (42.176544, -71.681912),
    "01561": (42.443539, -71.686137),
    "01562": (42.254837, -72.065612),
    "01564": (42.366765, -71.939375),
    "01566": (42.10273, -72.080996),
    "01568": (42.175591, -71.603197),
    "01569": (42.059736, -71.638438),
    "01570": (42.1351, -71.994169),
    "01571": (42.059189, -71.937037),
    "01580": (42.364807, -71.896868),
    "01581": (42.255222, -71.845865),
    "01582": (42.364807, -71.896868),
    "01583": (42.362783, -71.781215),
    "01585": (42.235638, -72.172523),
    "01586": (42.364807, -71.896868),
    "01588": (42.166554, -71.899484),
    "01590": (42.126575, -71.755193),
    "01601": (42.265275, -71.879415),
    "01602": (42.274595, -71.846966),
    "01603": (42.245442, -71.839257),
    "01604": (42.247955, -71.76678),
    "01605": (42.288792, -71.796128),
    "01606": (42.311834, -71.794465),
    "01607": (42.226452, -71.792506),
    "01608": (42.293501, -71.925696),
    "01609": (42.282565, -71.827685),
    "01610": (42.246483, -71.808915),
    "01611": (42.239392, -71.878716),
    "01612": (42.304675, -71.892875),
    "01613": (42.293316, -71.801971),
    "01614": (42.364807, -71.896868),
    "01615": (42.364807, -71.896868),
    "01653": (42.364807, -71.896868),
    "01654": (42.364807, -71.896868),
    "01655": (42.364807, -71.896868),
    "01701": (42.446396, -71.459405),
    "01702": (42.446396, -71.459405),
    "01703": (42.446396, -71.459405),
    "01704": (42.446396, -71.459405),
    "01705": (42.446396, -71.459405),
    "01718": (42.446396, -71.459405),
    "01719": (42.446396, -71.459405),
    "01720": (42.446396, -71.459405),
    "01721": (42.446396, -71.459405),
    "01730": (42.446396, -71.459405),
    "01731": (42.446396, -71.459405),
    "01740": (42.436043, -71.605916),
    "01741": (42.446396, -71.459405),
    "01742": (42.446396, -71.459405),
    "01745": (42.293442, -71.502762),
    "01746": (42.446396, -71.459405),
    "01747": (42.127515, -71.533138),
    "01748": (42.446396, -71.459405),
    "01749": (42.446396, -71.459405),
    "01752": (42.446396, -71.459405),
    "01754": (42.446396, -71.459405),
    "01756": (42.100352, -71.546961),
    "01757": (42.147087, -71.528085),
    "01760": (42.446396, -71.459405),
    "01770": (42.446396, -71.459405),
    "01772": (42.296842, -71.533229),
    "01773": (42.446396, -71.459405),
    "01775": (42.446396, -71.459405),
    "01776": (42.446396, -71.459405),
    "01778": (42.446396, -71.459405),
    "01784": (42.446396, -71.459405),
    "01801": (42.488595, -71.157271),
    "01803": (42.504844, -71.201539),
    "01805": (42.446396, -71.459405),
    "01806": (42.446396, -71.459405),
    "01807": (42.446396, -71.459405),
    "01808": (42.446396, -71.459405),
    "01810": (42.647991, -71.165685),
    "01812": (42.647191, -71.184202),
    "01813": (42.446396, -71.459405),
    "01815": (42.446396, -71.459405),
    "01821": (42.446396, -71.459405),
    "01822": (42.446396, -71.459405),
    "01824": (42.446396, -71.459405),
    "01826": (42.446396, -71.459405),
    "01827": (42.446396, -71.459405),
    "01830": (42.792639, -71.072501),
    "01831": (42.771095, -71.122054),
    "01832": (42.789627, -71.126562),
    "01833": (42.72377, -70.981298),
    "01834": (42.751074, -71.021437),
    "01835": (42.752844, -71.084301),
    "01840": (42.70734, -71.161052),
    "01841": (42.70979, -71.164402),
    "01842": (42.635443, -70.879123),
    "01843": (42.71037, -71.088303),
    "01844": (42.73184, -71.186915),
    "01845": (42.672835, -71.087689),
    "01850": (42.446396, -71.459405),
    "01851": (42.446396, -71.459405),
    "01852": (42.446396, -71.459405),
    "01853": (42.446396, -71.459405),
    "01854": (42.446396, -71.459405),
    "01860": (42.802441, -71.0896),
    "01862": (42.446396, -71.459405),
    "01863": (42.446396, -71.459405),
    "01864": (42.581332, -71.083725),
    "01865": (42.446396, -71.459405),
    "01866": (42.446396, -71.459405),
    "01867": (42.537065, -71.107172),
    "01876": (42.446396, -71.459405),
    "01879": (42.446396, -71.459405),
    "01880": (42.499891, -71.068829),
    "01885": (42.635443, -70.879123),
    "01886": (42.446396, -71.459405),
    "01887": (42.561782, -71.173888),
    "01888": (42.446396, -71.459405),
    "01889": (42.571633, -71.109646),
    "01890": (42.454545, -71.148779),
    "01899": (42.635443, -70.879123),
    "01901": (42.461246, -70.946743),
    "01902": (42.473195, -70.928593),
    "01903": (42.635443, -70.879123),
    "01904": (42.488896, -70.964694),
    "01905": (42.469395, -70.972844),
    "01906": (42.472112, -70.997794),
    "01907": (42.513295, -70.905893),
    "01908": (42.427296, -70.922442),
    "01910": (42.454796, -70.974694),
    "01913": (42.853539, -70.948211),
    "01915": (42.565145, -70.853843),
    "01921": (42.683256, -71.017403),
    "01922": (42.763216, -70.92812),
    "01923": (42.577188, -70.949245),
    "01929": (42.62781, -70.780576),
    "01930": (42.630011, -70.694179),
    "01931": (42.635443, -70.879123),
    "01936": (42.635443, -70.879123),
    "01937": (42.635443, -70.879123),
    "01938": (42.68571, -70.864132),
    "01940": (42.533732, -71.028775),
    "01944": (42.579503, -70.755062),
    "01945": (42.56142, -70.770768),
    "01949": (42.644942, -71.087905),
    "01950": (42.80965, -70.873196),
    "01951": (42.777524, -70.867246),
    "01952": (42.851234, -70.865667),
    "01960": (42.536996, -70.973646),
    "01961": (42.635443, -70.879123),
    "01965": (42.558113, -70.825743),
    "01966": (42.657866, -70.618057),
    "01969": (42.716155, -70.892754),
    "01970": (42.512946, -70.904237),
    "01971": (42.635443, -70.879123),
    "01982": (42.626664, -70.851125),
    "01983": (42.661793, -70.954487),
    "01984": (42.597691, -70.8732),
    "01985": (42.79414, -70.971068),
    "02018": (41.970474, -70.701357),
    "02019": (42.076501, -71.470464),
    "02020": (42.081825, -70.643868),
    "02021": (42.179146, -71.121185),
    "02025": (42.233938, -70.815826),
    "02026": (42.244733, -71.181141),
    "02027": (42.180048, -71.08923),
    "02030": (42.236114, -71.283072),
    "02031": (41.998799, -71.200894),
    "02032": (42.153786, -71.21455),
    "02035": (42.062204, -71.235774),
    "02038": (42.08868, -71.404814),
    "02040": (41.970474, -70.701357),
    "02041": (42.069642, -70.649075),
    "02043": (42.212105, -70.884989),
    "02044": (41.970474, -70.701357),
    "02045": (42.284413, -70.873659),
    "02047": (42.142836, -70.69353),
    "02048": (42.013182, -71.218373),
    "02050": (42.111805, -70.710744),
    "02051": (42.151202, -70.734146),
    "02052": (42.181265, -71.309934),
    "02053": (42.156282, -71.427663),
    "02054": (42.165249, -71.36126),
    "02055": (41.970474, -70.701357),
    "02056": (42.117511, -71.331793),
    "02059": (41.970474, -70.701357),
    "02060": (41.970474, -70.701357),
    "02061": (42.154145, -70.823035),
    "02062": (42.182798, -71.196277),
    "02065": (42.097219, -70.651567),
    "02066": (42.207254, -70.770188),
    "02067": (42.105288, -71.184785),
    "02070": (42.180048, -71.08923),
    "02071": (42.100399, -71.270933),
    "02072": (42.118416, -71.105733),
    "02081": (42.148624, -71.255533),
    "02090": (42.220548, -71.199238),
    "02093": (42.054311, -71.371169),
    "02101": (42.370567, -71.026964),
    "02102": (42.338947, -70.919635),
    "02103": (42.338947, -70.919635),
    "02104": (42.338947, -70.919635),
    "02105": (42.338947, -70.919635),
    "02106": (42.354318, -71.073449),
    "02107": (42.338947, -70.919635),
    "02108": (42.353806, -71.102446),
    "02109": (42.360027, -71.054495),
    "02110": (42.352847, -71.051466),
    "02111": (42.351047, -71.059365),
    "02112": (42.338947, -70.919635),
    "02113": (42.365398, -71.055001),
    "02114": (42.362097, -71.023661),
    "02115": (42.342043, -71.096848),
    "02116": (42.347207, -71.086095),
    "02117": (42.338947, -70.919635),
    "02118": (42.336162, -71.072854),
    "02119": (42.323077, -71.084608),
    "02120": (42.332484, -71.096416),
    "02121": (42.307098, -71.081645),
    "02122": (42.29658, -71.055215),
    "02123": (42.338947, -70.919635),
    "02124": (42.286784, -71.071045),
    "02125": (42.31476, -71.067244),
    "02126": (42.301247, -71.105195),
    "02127": (42.329023, -71.020343),
    "02128": (42.364197, -71.025694),
    "02129": (42.382588, -71.065287),
    "02130": (42.309661, -71.121097),
    "02131": (42.284197, -71.120896),
    "02132": (42.277897, -71.155833),
    "02133": (42.338947, -70.919635),
    "02134": (42.357169, -71.112646),
    "02135": (42.349768, -71.104888),
    "02136": (42.254248, -71.129321),
    "02137": (42.338947, -70.919635),
    "02138": (42.380442, -71.132947),
    "02139": (42.365146, -71.101842),
    "02140": (42.393246, -71.133833),
    "02141": (42.368673, -71.083596),
    "02142": (42.36284, -71.084814),
    "02143": (42.38092, -71.098896),
    "02144": (42.402696, -71.12022),
    "02145": (42.391046, -71.095146),
    "02148": (42.436545, -71.085396),
    "02149": (42.407396, -71.051183),
    "02150": (42.378197, -71.038894),
    "02151": (42.366303, -71.020494),
    "02152": (42.378447, -70.981679),
    "02153": (42.446396, -71.459405),
    "02155": (42.422095, -71.109297),
    "02156": (42.446396, -71.459405),
    "02163": (42.32532, -71.112159),
    "02169": (42.241799, -71.006042),
    "02170": (42.267248, -71.016742),
    "02171": (42.284898, -71.014243),
    "02176": (42.458995, -71.053095),
    "02177": (42.446396, -71.459405),
    "02180": (42.474595, -71.098146),
    "02184": (42.202216, -71.005192),
    "02185": (42.180048, -71.08923),
    "02186": (42.240598, -71.078494),
    "02187": (42.180048, -71.08923),
    "02188": (42.20794, -70.95514),
    "02189": (42.210649, -70.932318),
    "02190": (42.167841, -70.95074),
    "02191": (42.251499, -70.94484),
    "02196": (42.338947, -70.919635),
    "02199": (42.347247, -71.082395),
    "02201": (42.338947, -70.919635),
    "02202": (42.361094, -71.061814),
    "02203": (42.361485, -71.060364),
    "02204": (42.338947, -70.919635),
    "02205": (42.350334, -71.053877),
    "02206": (42.338947, -70.919635),
    "02207": (42.338947, -70.919635),
    "02208": (42.338947, -70.919635),
    "02209": (42.338947, -70.919635),
    "02210": (42.347547, -71.040645),
    "02211": (42.338947, -70.919635),
    "02212": (42.446396, -71.459405),
    "02215": (42.345079, -71.107653),
    "02216": (42.338947, -70.919635),
    "02217": (42.338947, -70.919635),
    "02222": (42.364381, -71.063314),
    "02238": (42.446396, -71.459405),
    "02239": (42.446396, -71.459405),
    "02241": (42.338947, -70.919635),
    "02266": (42.338947, -70.919635),
    "02269": (42.180048, -71.08923),
    "02283": (42.338947, -70.919635),
    "02284": (42.338947, -70.919635),
    "02293": (42.338947, -70.919635),
    "02295": (42.338947, -70.919635),
    "02297": (42.338947, -70.919635),
    "02301": (42.079399, -71.03999),
    "02302": (42.08475, -71.000189),
    "02303": (41.970474, -70.701357),
    "02304": (41.970474, -70.701357),
    "02305": (41.970474, -70.701357),
    "02322": (42.126049, -71.048216),
    "02324": (41.973741, -70.976558),
    "02325": (41.98725, -70.972786),
    "02327": (42.040708, -70.827245),
    "02330": (41.896238, -70.759689),
    "02331": (41.970474, -70.701357),
    "02332": (42.052985, -70.710808),
    "02333": (42.02285, -70.931056),
    "02334": (42.023528, -71.132397),
    "02337": (42.022225, -70.931588),
    "02338": (41.988351, -70.860578),
    "02339": (42.123534, -70.851048),
    "02340": (42.123534, -70.851048),
    "02341": (42.055701, -70.875936),
    "02343": (42.144424, -71.00289),
    "02344": (41.970474, -70.701357),
    "02345": (41.888198, -70.581029),
    "02346": (41.915054, -70.882035),
    "02347": (41.843757, -70.959981),
    "02348": (41.970474, -70.701357),
    "02349": (41.970474, -70.701357),
    "02350": (42.018525, -70.847486),
    "02351": (42.11749, -70.959888),
    "02355": (41.916918, -70.801331),
    "02356": (42.053408, -71.12033),
    "02357": (42.064499, -71.087091),
    "02358": (41.95351, -70.713109),
    "02359": (42.065702, -70.800778),
    "02360": (41.886207, -70.638717),
    "02361": (41.970474, -70.701357),
    "02362": (41.970474, -70.701357),
    "02364": (41.979405, -70.744813),
    "02366": (41.850087, -70.704431),
    "02367": (41.96914, -70.812299),
    "02368": (42.171467, -71.055602),
    "02370": (41.954199, -70.885095),
    "02375": (42.023199, -71.111091),
    "02379": (42.02165, -71.023588),
    "02381": (41.931602, -70.561051),
    "02382": (42.0785, -70.940837),
    "02420": (42.45631, -71.21665),
    "02421": (42.442567, -71.226453),
    "02445": (42.318097, -71.143697),
    "02446": (42.343097, -71.123046),
    "02447": (42.180048, -71.08923),
    "02451": (42.398588, -71.24505),
    "02452": (42.394319, -71.218049),
    "02453": (42.365396, -71.23165),
    "02454": (42.356719, -71.250479),
    "02456": (42.446396, -71.459405),
    "02457": (42.180048, -71.08923),
    "02458": (42.385096, -71.208399),
    "02459": (42.334146, -71.183298),
    "02460": (42.374296, -71.182371),
    "02461": (42.361196, -71.205349),
    "02462": (42.349496, -71.209699),
    "02464": (42.36599, -71.221849),
    "02465": (42.378145, -71.213199),
    "02466": (42.346696, -71.224957),
    "02467": (42.357563999999996, -71.211649),
    "02468": (42.327146, -71.231534),
    "02471": (42.446396, -71.459405),
    "02472": (42.363096, -71.201398),
    "02474": (42.417595, -71.159696),
    "02475": (42.446396, -71.459405),
    "02476": (42.379146, -71.184299),
    "02477": (42.446396, -71.459405),
    "02478": (42.412795, -71.204399),
    "02479": (42.446396, -71.459405),
    "02481": (42.310597, -71.274652),
    "02482": (42.294546, -71.299201),
    "02492": (42.279797, -71.25006),
    "02493": (42.375925, -71.227208),
    "02494": (42.300147, -71.26315),
    "02495": (42.446396, -71.459405),
    "02532": (41.745505, -70.590471),
    "02534": (41.669373, -70.62337),
    "02535": (41.379034, -70.673082),
    "02536": (41.662506, -70.562843),
    "02537": (41.72832, -70.439975),
    "02538": (41.77544, -70.660562),
    "02539": (41.401176, -70.552054),
    "02540": (41.614199, -70.493263),
    "02541": (41.799312, -70.308662),
    "02542": (41.65308, -70.553727),
    "02543": (41.593809, -70.646442),
    "02552": (41.379836, -70.643092),
    "02553": (41.67336, -70.608047),
    "02554": (41.287647, -70.08665),
    "02556": (41.652967, -70.375475),
    "02557": (41.417376, -70.560032),
    "02558": (41.74756, -70.658164),
    "02559": (41.694771, -70.622769),
    "02561": (41.770254, -70.533664),
    "02562": (41.793263, -70.519584),
    "02563": (41.711291, -70.477482),
    "02564": (41.273949, -70.015545),
    "02565": (41.799312, -70.308662),
    "02568": (41.41595, -70.595235),
    "02571": (41.760216, -70.694662),
    "02573": (41.379836, -70.643092),
    "02574": (41.603946, -70.638189),
    "02575": (41.42125, -70.642806),
    "02576": (41.769863, -70.749688),
    "02584": (41.277794, -70.046019),
    "02601": (41.829813, -70.138834),
    "02630": (41.697313, -70.301394),
    "02631": (41.852997, -70.044462),
    "02632": (41.796311, -70.175129),
    "02633": (41.859559, -70.0468),
    "02634": (41.799312, -70.308662),
    "02635": (41.624341, -70.43638),
    "02636": (41.799312, -70.308662),
    "02637": (41.701438, -70.277212),
    "02638": (41.725716, -70.089142),
    "02639": (41.750745, -70.071836),
    "02641": (41.734713, -70.20467),
    "02642": (41.850612, -70.020648),
    "02643": (41.784308, -69.962034),
    "02644": (41.790031, -70.268632),
    "02645": (41.835582, -70.043359),
    "02646": (41.845717, -70.053544),
    "02647": (41.635004, -70.306336),
    "02648": (41.813034, -70.246666),
    "02649": (41.788337, -70.253543),
    "02650": (41.73497, -70.029065),
    "02651": (41.824264, -69.98176),
    "02652": (41.931061, -70.283584),
    "02653": (41.852933, -70.01539),
    "02655": (41.810178, -70.191269),
    "02657": (41.888775, -70.091057),
    "02659": (41.848932, -70.030194),
    "02660": (41.80038, -70.089244),
    "02661": (41.686205, -70.032858),
    "02662": (41.756694, -69.984123),
    "02663": (41.800531, -70.076776),
    "02664": (41.82412, -70.084259),
    "02666": (41.987377, -70.047163),
    "02667": (41.821307, -70.022806),
    "02668": (41.79055, -70.201719),
    "02669": (41.698721, -70.004937),
    "02670": (41.710855, -70.072195),
    "02671": (41.846719, -70.038282),
    "02672": (41.635635, -70.323307),
    "02673": (41.776105, -70.150512),
    "02675": (41.716271, -70.135884),
    "02702": (41.782993, -71.017328),
    "02703": (41.938976, -71.302297),
    "02712": (41.756214, -71.067062),
    "02713": (41.42178, -70.931309),
    "02714": (41.756214, -71.067062),
    "02715": (41.817659, -71.151787),
    "02717": (41.747358, -70.978947),
    "02718": (41.871407, -71.013148),
    "02719": (41.631672, -70.870045),
    "02720": (41.819766, -71.165971),
    "02721": (41.678895, -71.153648),
    "02722": (41.756214, -71.067062),
    "02723": (41.693802, -71.133088),
    "02724": (41.684202, -71.175139),
    "02725": (41.723851, -71.173989),
    "02726": (41.757951, -71.153639),
    "02738": (41.736735, -70.754015),
    "02739": (41.664976, -70.810856),
    "02740": (41.633416, -70.951045),
    "02741": (41.756214, -71.067062),
    "02742": (41.619557, -70.956346),
    "02743": (41.711894, -70.908286),
    "02744": (41.609354, -70.916181),
    "02745": (41.7087, -70.946883),
    "02746": (41.665704, -70.943021),
    "02747": (41.639261, -71.007578),
    "02748": (41.566464, -70.984253),
    "02760": (41.964376, -71.326448),
    "02761": (41.756214, -71.067062),
    "02762": (42.013553, -71.334399),
    "02763": (41.972584, -71.308229),
    "02764": (41.847791, -71.155797),
    "02766": (41.959149, -71.180393),
    "02767": (41.9367, -71.048941),
    "02768": (41.756214, -71.067062),
    "02769": (41.852989, -71.243061),
    "02770": (41.751812, -70.846041),
    "02771": (41.840103, -71.318995),
    "02777": (41.766629, -71.234443),
    "02779": (41.828249, -71.064135),
    "02780": (41.858851, -71.092827),
    "02783": (41.756214, -71.067062),
    "02790": (41.61547, -71.079636),
    "02791": (41.519104, -71.085137),
    "02801": (41.530131, -71.284066),
    "02802": (41.954098, -71.462053),
    "02804": (41.322365, -71.679251),
    "02806": (41.742501, -71.320395),
    "02807": (41.188888, -71.577696),
    "02808": (41.403784, -71.761665),
    "02809": (41.678378, -71.2704),
    "02812": (41.469148, -71.675092),
    "02813": (41.395079, -71.66542),
    "02814": (41.888971, -71.688769),
    "02815": (41.770525, -71.65585),
    "02816": (41.694251, -71.636786),
    "02817": (41.631168, -71.667165),
    "02818": (41.64335, -71.478002),
    "02822": (41.5469, -71.650262),
    "02823": (41.7312, -71.546756),
    "02824": (42.000248, -71.563057),
    "02825": (41.790569, -71.70644),
    "02826": (41.982417, -71.600848),
    "02827": (41.691676, -71.727467),
    "02828": (41.879298, -71.551682),
    "02829": (41.879298, -71.589357),
    "02830": (41.97239, -71.648502),
    "02831": (41.753594, -71.577746),
    "02832": (41.509632, -71.733875),
    "02833": (41.475117, -71.772617),
    "02835": (41.51412, -71.377247),
    "02836": (41.447427, -71.620432),
    "02837": (41.510257, -71.16634),
    "02838": (41.967848, -71.475604),
    "02839": (41.941715, -71.637581),
    "02840": (41.487552, -71.327084),
    "02841": (41.498977, -71.299004),
    "02842": (41.519757, -71.273101),
    "02852": (41.586851, -71.464801),
    "02854": (41.375317, -71.64393),
    "02857": (41.838827, -71.655006),
    "02858": (41.962303, -71.647542),
    "02859": (41.964150000000004, -71.723316),
    "02860": (41.875149, -71.392732),
    "02861": (41.878249, -71.369899),
    "02862": (41.86125, -71.369099),
    "02863": (41.889849, -71.394186),
    "02864": (41.949498, -71.43269),
    "02865": (41.925298, -71.493355),
    "02871": (41.58523, -71.264197),
    "02872": (41.707119, -71.286834),
    "02873": (41.519922, -71.774023),
    "02874": (41.478466, -71.471752),
    "02875": (41.456039, -71.635474),
    "02876": (41.998398, -71.576307),
    "02877": (41.5289, -71.529854),
    "02878": (41.61018, -71.175183),
    "02879": (41.443653, -71.534202),
    "02880": (41.375317, -71.64393),
    "02881": (41.482901, -71.524317),
    "02882": (41.377185, -71.497793),
    "02883": (41.375317, -71.64393),
    "02885": (41.727451, -71.257492),
    "02886": (41.70247, -71.47902),
    "02887": (41.682455, -71.557732),
    "02888": (41.7473, -71.411088),
    "02889": (41.689182, -71.496048),
    "02891": (41.284494, -71.710708),
    "02892": (41.505764, -71.62114),
    "02893": (41.696822, -71.507304),
    "02894": (41.45005, -71.70742),
    "02895": (41.984598, -71.51939),
    "02896": (41.934348, -71.540506),
    "02898": (41.504089, -71.662954),
    "02901": (41.82275, -71.414451),
    "02902": (41.81835, -71.424851),
    "02903": (41.819459, -71.4115),
    "02904": (41.85414, -71.437752),
    "02905": (41.803799, -71.422547),
    "02906": (41.8374, -71.394717),
    "02907": (41.797065, -71.425501),
    "02908": (41.837399, -71.4399),
    "02909": (41.820599, -71.444302),
    "02910": (41.7917, -71.435251),
    "02911": (41.838749, -71.449202),
    "02912": (41.826737, -71.397699),
    "02914": (41.813429, -71.363348),
    "02915": (41.7743, -71.349697),
    "02916": (41.842727, -71.355798),
    "02917": (41.853899, -71.497804),
    "02918": (41.841499, -71.440352),
    "02919": (41.870932, -71.497604),
    "02920": (41.7693, -71.471353),
    "02921": (41.76675, -71.476703),
    "02940": (41.871766, -71.558518),
    "03031": (42.87474, -71.629365),
    "03032": (42.989151, -71.343576),
    "03033": (42.847268, -71.767437),
    "03034": (43.059283, -71.305437),
    "03036": (42.961606, -71.251021),
    "03037": (42.987495, -71.252719),
    "03038": (42.950825, -71.197169),
    "03040": (43.005895, -71.013202),
    "03041": (43.005895, -71.013202),
    "03042": (43.047595, -71.084411),
    "03043": (42.916233, -71.816505),
    "03044": (42.992203, -71.127041),
    "03045": (42.94671, -71.687633),
    "03047": (42.929346, -71.859087),
    "03048": (42.875116, -71.717548),
    "03049": (42.859545, -71.581313),
    "03051": (42.766426, -71.61887),
    "03052": (42.886789, -71.485331),
    "03053": (42.8712, -71.387776),
    "03054": (42.924928, -71.667508),
    "03055": (42.848787, -71.743882),
    "03057": (42.850464, -71.727044),
    "03060": (42.771537, -71.626336),
    "03061": (42.952124, -71.653939),
    "03062": (42.860117, -71.49976),
    "03063": (42.774427, -71.511111),
    "03064": (42.774237, -71.628611),
    "03070": (42.903497, -71.775889),
    "03071": (42.762946, -71.845164),
    "03073": (43.005895, -71.013202),
    "03076": (42.740651, -71.318715),
    "03077": (43.05932, -71.204521),
    "03079": (42.872045, -71.196195),
    "03082": (42.902031, -71.773947),
    "03084": (42.822275, -71.860983),
    "03086": (42.894022, -71.730154),
    "03087": (42.892211, -71.234009),
    "03101": (42.988483, -71.462111),
    "03102": (43.007883, -71.494561),
    "03103": (42.942463, -71.463761),
    "03104": (42.897524, -71.372208),
    "03105": (42.952124, -71.653939),
    "03106": (43.065097, -71.443616),
    "03107": (42.952124, -71.653939),
    "03108": (42.952124, -71.653939),
    "03109": (42.970084, -71.405283),
    "03110": (42.93743, -71.535515),
    "03111": (42.952124, -71.653939),
    "03215": (43.930221, -71.534068),
    "03216": (43.447006, -71.684093),
    "03217": (43.715626, -71.639896),
    "03218": (43.417369, -71.373189),
    "03220": (43.455551, -71.40709),
    "03221": (43.280961, -71.792489),
    "03222": (43.70781, -71.72158),
    "03223": (43.841799, -71.665223),
    "03224": (43.378281, -71.604226),
    "03225": (43.386652, -71.292981),
    "03226": (43.69387, -71.466212),
    "03227": (43.694809, -71.323953),
    "03229": (43.301308, -71.812943),
    "03230": (43.514791, -71.882094),
    "03231": (43.466172, -71.736518),
    "03232": (43.967542, -71.840883),
    "03233": (43.422706, -71.944794),
    "03234": (43.340736, -71.669712),
    "03235": (43.374297, -71.680021),
    "03237": (43.414064, -71.384213),
    "03238": (43.967542, -71.840883),
    "03240": (43.967542, -71.840883),
    "03241": (43.718268, -71.889483),
    "03242": (43.180148, -71.81959),
    "03243": (43.443473, -71.762631),
    "03244": (43.12295, -71.914287),
    "03245": (43.737831, -71.604406),
    "03246": (43.535461, -71.426997),
    "03247": (43.588972, -71.445452),
    "03251": (44.049183, -71.653505),
    "03252": (43.468562, -71.537145),
    "03253": (43.592239, -71.517479),
    "03254": (43.728235, -71.335248),
    "03255": (43.321723, -72.01184),
    "03256": (43.603288, -71.634674),
    "03257": (43.301663, -71.733643),
    "03259": (43.85971, -71.37719),
    "03260": (43.365345, -71.934059),
    "03261": (43.208676, -71.202568),
    "03262": (44.035391, -71.686326),
    "03263": (43.297834, -71.343707),
    "03264": (43.710919, -71.694017),
    "03266": (43.752475, -71.788434),
    "03268": (43.361756, -71.558817),
    "03269": (43.50178, -71.514248),
    "03272": (43.310279, -71.662928),
    "03273": (43.304205, -71.928867),
    "03274": (43.967542, -71.840883),
    "03275": (43.286382, -71.599047),
    "03276": (43.536056, -71.49166),
    "03278": (43.310858, -71.842299),
    "03279": (43.967542, -71.840883),
    "03280": (43.17229, -72.100689),
    "03281": (43.084176, -71.762578),
    "03282": (43.967542, -71.840883),
    "03284": (43.493812, -72.047018),
    "03287": (43.44853, -71.915826),
    "03289": (43.496372, -71.519728),
    "03290": (43.124825, -71.125879),
    "03291": (43.182251, -71.139551),
    "03293": (43.967542, -71.840883),
    "03298": (43.524872, -71.445841),
    "03299": (43.524872, -71.445841),
    "03301": (43.230314, -71.536101),
    "03302": (43.310279, -71.662928),
    "03303": (43.281654, -71.659523),
    "03304": (43.128256, -71.544599),
    "03305": (43.2134, -71.517151),
    "03307": (43.319339, -71.467006),
    "03431": (42.903656, -72.248052),
    "03435": (42.947098, -72.243029),
    "03440": (43.044535, -71.971353),
    "03441": (42.777271, -72.444106),
    "03442": (43.002936, -71.908029),
    "03443": (42.883948, -72.454813),
    "03444": (42.889124, -72.018993),
    "03445": (42.998225, -72.201903),
    "03446": (42.841079, -72.330145),
    "03447": (42.881769, -72.248026),
    "03448": (42.936786, -72.210953),
    "03449": (42.93924, -71.983797),
    "03450": (42.884548, -72.102634),
    "03451": (42.894151, -72.280099),
    "03452": (42.821969, -72.082559),
    "03455": (42.88825, -72.279638),
    "03456": (43.119294, -72.202564),
    "03457": (42.896623, -72.091677),
    "03458": (42.956433, -71.9372),
    "03461": (42.76509, -72.00912),
    "03462": (42.870716, -72.239432),
    "03464": (42.95478, -72.102454),
    "03465": (42.843617, -72.279814),
    "03466": (42.858419, -72.432202),
    "03467": (42.973867, -72.44256),
    "03468": (42.890804, -71.933396),
    "03469": (42.87341, -72.31509),
    "03470": (42.895797, -72.274928),
    "03561": (44.335289, -71.877638),
    "03570": (44.512344, -71.194226),
    "03574": (44.30632, -71.728049),
    "03575": (44.695648, -71.387387),
    "03576": (44.902731, -71.500809),
    "03579": (44.695648, -71.387387),
    "03580": (44.212814, -71.737162),
    "03581": (44.404848, -71.154758),
    "03582": (44.75096, -71.422453),
    "03583": (44.695648, -71.387387),
    "03584": (44.476575, -71.561225),
    "03585": (44.245004, -71.888882),
    "03587": (44.695648, -71.387387),
    "03588": (44.56532, -71.218672),
    "03589": (44.695648, -71.387387),
    "03590": (44.695648, -71.387387),
    "03592": (44.695648, -71.387387),
    "03595": (44.26895, -71.547061),
    "03597": (44.695648, -71.387387),
    "03598": (44.363681, -71.610189),
    "03601": (43.195982, -72.300075),
    "03602": (43.134412, -72.310623),
    "03603": (43.268117, -72.370222),
    "03604": (42.947098, -72.243029),
    "03605": (43.213615, -72.196758),
    "03607": (43.364504, -72.193966),
    "03608": (43.072239, -72.390121),
    "03609": (43.138018, -72.407236),
    "03740": (44.114163, -71.948852),
    "03741": (43.63123, -72.057312),
    "03743": (43.415993, -72.209819),
    "03745": (43.462156, -72.337149),
    "03746": (43.364504, -72.193966),
    "03748": (43.630906, -72.116603),
    "03749": (43.579573, -72.08541),
    "03750": (43.697999, -72.215182),
    "03751": (43.44872, -72.063675),
    "03752": (43.417705, -72.196718),
    "03753": (43.463101, -72.218445),
    "03754": (43.365618, -72.125562),
    "03755": (43.861077, -72.120314),
    "03756": (43.967542, -71.840883),
    "03765": (44.037549, -72.046692),
    "03766": (43.637148, -72.23546),
    "03768": (43.801656, -72.130495),
    "03769": (43.786267, -72.120468),
    "03770": (43.421675, -72.255638),
    "03771": (44.268612, -72.015317),
    "03773": (43.390485, -72.199659),
    "03774": (44.077803, -72.014608),
    "03777": (43.927348, -72.10987),
    "03779": (43.948343, -72.062132),
    "03780": (43.967542, -71.840883),
    "03781": (43.432999, -72.282596),
    "03782": (43.426838, -72.15471),
    "03784": (43.644367, -72.2348),
    "03785": (43.948644, -72.080708),
    "03801": (43.009222, -70.950742),
    "03802": (43.005895, -71.013202),
    "03803": (42.92703, -71.444752),
    "03804": (43.005895, -71.013202),
    "03805": (43.285282, -70.930684),
    "03809": (43.462586, -71.222455),
    "03810": (43.502514, -71.277387),
    "03811": (42.878366, -71.159035),
    "03812": (43.883871, -71.257726),
    "03813": (43.797391, -71.145357),
    "03814": (43.762429, -71.122689),
    "03815": (43.253739, -71.109825),
    "03816": (43.660752, -71.274458),
    "03817": (43.74858, -71.089796),
    "03818": (43.78892, -71.10261),
    "03819": (42.926725, -71.082299),
    "03820": (43.297309, -70.992042),
    "03821": (43.326734, -71.028427),
    "03822": (43.326734, -71.028427),
    "03824": (43.165772, -70.962843),
    "03825": (43.29779, -71.097423),
    "03826": (42.893629, -71.14269),
    "03827": (42.912071, -71.054245),
    "03830": (43.635065, -71.009368),
    "03832": (43.883871, -71.257726),
    "03833": (42.951274, -70.922262),
    "03835": (43.306172, -71.003435),
    "03836": (43.823704, -71.093154),
    "03837": (43.446567, -71.299456),
    "03838": (44.050111, -71.265371),
    "03839": (43.309966, -70.998256),
    "03840": (43.038634, -70.809157),
    "03841": (42.877438, -71.139098),
    "03842": (42.917389, -70.95095),
    "03843": (43.005895, -71.013202),
    "03844": (42.891888, -70.982601),
    "03845": (44.082716, -71.134348),
    "03846": (43.883871, -71.257726),
    "03847": (43.883871, -71.257726),
    "03848": (42.909731, -71.102933),
    "03849": (43.902311, -71.124612),
    "03850": (43.707657, -71.301681),
    "03851": (43.422942, -71.011369),
    "03852": (43.326734, -71.028427),
    "03853": (43.646319, -71.282068),
    "03854": (43.064938, -70.721596),
    "03855": (43.459503, -71.119055),
    "03856": (43.037363, -70.978211),
    "03857": (42.979021, -70.891642),
    "03858": (42.937092, -71.006898),
    "03859": (42.861915, -71.04002),
    "03860": (43.784643, -71.10263),
    "03862": (43.00027, -70.913947),
    "03864": (43.667352, -71.153338),
    "03865": (42.937838, -70.926206),
    "03866": (43.41176, -71.027303),
    "03867": (43.326831, -70.993148),
    "03868": (43.349689, -70.945161),
    "03869": (43.16136, -70.942666),
    "03870": (43.010939, -70.764813),
    "03871": (42.980639, -70.771896),
    "03872": (43.570694, -71.079427),
    "03873": (42.922666, -71.174262),
    "03874": (42.964415, -70.819897),
    "03875": (43.855269, -71.176182),
    "03878": (43.229489, -70.958264),
    "03882": (43.704702, -70.990155),
    "03883": (43.883871, -71.257726),
    "03884": (43.256871, -71.171886),
    "03885": (43.01295, -70.882134),
    "03886": (43.647527, -71.277779),
    "03887": (43.459999, -71.040842),
    "03890": (43.811782, -71.194586),
    "03894": (43.667102, -71.183597),
    "03896": (43.589157, -71.218894),
    "03897": (43.883871, -71.257726),
    "03901": (43.279539, -70.740013),
    "03902": (43.245785, -70.664719),
    "03903": (43.182729, -70.745759),
    "03904": (43.191554, -70.684607),
    "03905": (43.094746, -70.68928),
    "03906": (43.340626, -70.753996),
    "03907": (43.350806, -70.731498),
    "03908": (43.227549, -70.71171),
    "03909": (43.237891, -70.69099),
    "03910": (43.211674, -70.73201),
    "03911": (43.155465, -70.635702),
    "04001": (43.520752, -70.804588),
    "04002": (43.467224, -70.738992),
    "04003": (43.735867, -69.995456),
    "04004": (43.365658, -70.604379),
    "04005": (43.532376, -70.651859),
    "04006": (43.436049, -70.3598),
    "04007": (43.45813, -70.505301),
    "04008": (44.023162, -69.875816),
    "04009": (43.939828, -70.747431),
    "04010": (44.163033, -70.739823),
    "04011": (43.935634, -70.340652),
    "04013": (44.408078, -70.470703),
    "04014": (43.365658, -70.604379),
    "04015": (43.962115, -70.524465),
    "04016": (44.180965, -70.891727),
    "04017": (43.727806, -70.120437),
    "04019": (44.408078, -70.470703),
    "04020": (43.77397, -70.791727),
    "04021": (43.812676, -70.450494),
    "04022": (44.566156, -70.661557),
    "04024": (43.844826, -70.688656),
    "04027": (43.459708, -70.91519),
    "04028": (43.732391, -70.845114),
    "04029": (43.867223, -70.547159),
    "04030": (43.596921, -70.689681),
    "04032": (43.864477, -70.097543),
    "04033": (44.408078, -70.470703),
    "04034": (44.408078, -70.470703),
    "04037": (44.044292, -70.964418),
    "04038": (43.803689, -70.355188),
    "04039": (43.878567, -70.328889),
    "04040": (43.992681, -70.357119),
    "04041": (43.879628, -70.826188),
    "04042": (43.584232, -70.624391),
    "04043": (43.494679, -70.54921),
    "04046": (43.534125, -70.607475),
    "04047": (43.744987, -70.909196),
    "04048": (43.661222, -70.83448),
    "04049": (43.703854, -70.748668),
    "04050": (44.408078, -70.470703),
    "04051": (44.139839, -70.886741),
    "04053": (44.408078, -70.470703),
    "04054": (43.276341, -70.597752),
    "04055": (43.957208, -70.639546),
    "04056": (43.658378, -70.868871),
    "04057": (44.408078, -70.470703),
    "04061": (43.54209, -70.710773),
    "04062": (43.911381, -70.396652),
    "04063": (43.504889, -70.385703),
    "04064": (43.411837, -70.469526),
    "04066": (43.779982, -69.975477),
    "04068": (43.848322, -70.935379),
    "04069": (43.894983, -70.189159),
    "04070": (43.576983, -70.273642),
    "04071": (43.906227, -70.465928),
    "04072": (43.541241, -70.666387),
    "04073": (43.576196, -70.630569),
    "04074": (43.724562, -70.375162),
    "04075": (43.796053, -70.552183),
    "04076": (43.510275, -70.77159),
    "04077": (43.910029, -70.524524),
    "04078": (43.820774, -70.120781),
    "04079": (43.78105, -69.995537),
    "04081": (44.566156, -70.661557),
    "04082": (44.408078, -70.470703),
    "04083": (43.465941, -70.748295),
    "04084": (43.804454, -70.554905),
    "04085": (43.771934, -70.639561),
    "04086": (43.981404, -69.937793),
    "04087": (43.573684, -70.749181),
    "04088": (44.566156, -70.661557),
    "04090": (43.429659, -70.671274),
    "04091": (44.408078, -70.470703),
    "04092": (43.855116, -70.568534),
    "04093": (43.653805, -70.622959),
    "04094": (43.406101, -70.573255),
    "04095": (43.601018, -70.902676),
    "04096": (43.798227, -70.171979),
    "04097": (43.837951, -70.200114),
    "04098": (44.408078, -70.470703),
    "04101": (43.658784, -70.262393),
    "04102": (43.74275, -70.44338),
    "04103": (43.68826, -70.289844),
    "04104": (43.84649, -70.464839),
    "04105": (43.73928, -70.270696),
    "04106": (43.627364, -70.289248),
    "04107": (43.595512, -70.239559),
    "04108": (43.662809, -70.188442),
    "04109": (43.678339, -70.198742),
    "04110": (43.759021, -70.199307),
    "04112": (44.408078, -70.470703),
    "04116": (44.408078, -70.470703),
    "04122": (44.408078, -70.470703),
    "04123": (44.408078, -70.470703),
    "04124": (44.408078, -70.470703),
    "04210": (44.087422, -70.243848),
    "04211": (44.197009, -70.239485),
    "04212": (44.197009, -70.239485),
    "04216": (44.56816, -70.704051),
    "04217": (44.428414, -70.770035),
    "04219": (44.265009, -70.587095),
    "04220": (44.326165, -70.381112),
    "04221": (44.38575, -70.311314),
    "04222": (43.968378, -70.184618),
    "04223": (44.023873, -70.285748),
    "04224": (44.553968, -70.422541),
    "04225": (44.602705, -70.22651),
    "04226": (44.555618, -70.691857),
    "04227": (44.579135, -70.326337),
    "04228": (44.197009, -70.239485),
    "04230": (44.062672, -70.327049),
    "04231": (44.313283, -70.861797),
    "04234": (44.617509, -70.182012),
    "04236": (44.189655, -70.136683),
    "04237": (44.494347, -70.735691),
    "04238": (44.22564, -70.372831),
    "04239": (44.541508, -70.208556),
    "04240": (44.086323, -70.169297),
    "04241": (44.197009, -70.239485),
    "04243": (44.197009, -70.239485),
    "04250": (44.033026, -70.101247),
    "04252": (44.032476, -70.068046),
    "04253": (44.297416, -70.189139),
    "04254": (44.242189, -70.188508),
    "04255": (44.401595, -70.708774),
    "04256": (44.079644, -70.272624),
    "04257": (44.570265, -70.516131),
    "04258": (44.146121, -70.339859),
    "04259": (44.349166, -69.870181),
    "04260": (43.967474, -70.299687),
    "04261": (44.689526, -71.011246),
    "04262": (45.063384, -70.381639),
    "04263": (44.292089, -70.135366),
    "04265": (44.303359, -70.037848),
    "04266": (44.357987, -70.255783),
    "04267": (44.566156, -70.661557),
    "04268": (44.280503, -70.691576),
    "04270": (44.284385, -70.507791),
    "04271": (44.264111, -70.498513),
    "04274": (44.047435, -70.389923),
    "04275": (44.566156, -70.661557),
    "04276": (44.523556, -70.638174),
    "04278": (44.377031, -70.568041),
    "04280": (44.126723, -70.126922),
    "04281": (44.353052, -70.607841),
    "04282": (44.265473, -70.254155),
    "04283": (44.197009, -70.239485),
    "04284": (44.359835, -70.074555),
    "04285": (45.063384, -70.381639),
    "04286": (44.40205, -70.860094),
    "04287": (44.057514, -69.965553),
    "04288": (44.197009, -70.239485),
    "04289": (44.340438, -70.543265),
    "04290": (44.477183, -70.436722),
    "04291": (44.040857, -70.453006),
    "04292": (44.3189, -70.477506),
    "04294": (44.618873, -70.245935),
    "04330": (44.351642, -69.803773),
    "04332": (44.414056, -69.751913),
    "04333": (44.414056, -69.751913),
    "04336": (44.315693, -69.818009),
    "04338": (44.414056, -69.751913),
    "04341": (44.258771, -69.551024),
    "04342": (44.077448, -69.738418),
    "04343": (44.414056, -69.751913),
    "04344": (44.256614, -69.797105),
    "04345": (44.296652, -69.796909),
    "04346": (44.269959, -69.724135),
    "04347": (44.24913, -69.795037),
    "04348": (44.220432, -69.513293),
    "04349": (44.414056, -69.751913),
    "04350": (44.158104, -69.95404),
    "04351": (44.358014, -69.867001),
    "04352": (44.461522, -69.986762),
    "04353": (44.188406, -69.575119),
    "04354": (44.39559, -69.4168),
    "04355": (44.38484, -69.953716),
    "04357": (44.108059, -69.827489),
    "04358": (44.375578, -69.586327),
    "04359": (44.183266, -69.777196),
    "04360": (44.414056, -69.751913),
    "04363": (44.414056, -69.751913),
    "04364": (44.322865, -69.957627),
    "04401": (45.061744, -68.878893),
    "04402": (45.519867, -68.647416),
    "04406": (45.184103, -69.233382),
    "04408": (44.641873, -68.391481),
    "04410": (45.058864, -68.95432),
    "04411": (44.914946, -68.625688),
    "04412": (44.83561, -68.783742),
    "04413": (45.002969, -67.495548),
    "04414": (45.310095, -69.029462),
    "04415": (45.351184, -69.058062),
    "04416": (44.600448, -68.773241),
    "04417": (44.81782, -68.817481),
    "04418": (45.049429, -68.581212),
    "04419": (44.808062, -68.940624),
    "04420": (44.412968, -68.798047),
    "04421": (44.415639, -68.792883),
    "04422": (45.066999, -69.040695),
    "04423": (45.039478, -68.529182),
    "04424": (45.658831, -67.866054),
    "04426": (45.171605, -69.207725),
    "04427": (44.989376, -68.865187),
    "04428": (44.79169, -68.577728),
    "04429": (44.894294, -68.818345),
    "04430": (45.233408, -68.689174),
    "04431": (44.561174, -68.664735),
    "04434": (45.519867, -68.647416),
    "04435": (44.966032, -69.13308),
    "04438": (44.632657, -68.849975),
    "04441": (45.792364, -69.30463),
    "04442": (45.792364, -69.30463),
    "04443": (45.315976, -69.457444),
    "04444": (44.835984, -68.829046),
    "04448": (45.245635, -68.666632),
    "04449": (45.006054, -68.884621),
    "04450": (44.918877, -68.965803),
    "04451": (45.519867, -68.647416),
    "04453": (44.787228999999996, -69.21821),
    "04454": (45.002969, -67.495548),
    "04455": (45.519867, -68.647416),
    "04456": (44.871231, -69.011636),
    "04457": (45.366794, -68.49299),
    "04459": (45.519867, -68.647416),
    "04460": (45.618608, -68.543602),
    "04461": (45.0542, -68.595946),
    "04462": (45.226479, -68.752091),
    "04463": (45.244612, -68.975988),
    "04464": (45.792364, -69.30463),
    "04467": (45.519867, -68.647416),
    "04468": (45.040655, -68.722962),
    "04469": (45.002798, -68.63343),
    "04471": (46.516166, -68.886826),
    "04472": (44.409375, -68.625903),
    "04473": (45.068848, -68.744361),
    "04474": (44.842939, -68.782487),
    "04475": (45.040668, -68.618775),
    "04476": (44.433911, -68.721716),
    "04478": (45.28657, -70.054629),
    "04479": (45.792364, -69.30463),
    "04481": (45.792364, -69.30463),
    "04485": (45.792364, -69.30463),
    "04487": (45.519867, -68.647416),
    "04488": (44.894697, -69.142341),
    "04489": (44.922368, -68.686796),
    "04490": (45.002969, -67.495548),
    "04491": (45.002969, -67.495548),
    "04492": (45.002969, -67.495548),
    "04493": (45.519867, -68.647416),
    "04495": (45.519867, -68.647416),
    "04496": (44.65337, -68.917487),
    "04497": (46.516166, -68.886826),
    "04530": (43.867892, -69.826495),
    "04535": (44.008962, -69.566684),
    "04536": (44.021333, -69.523263),
    "04537": (43.894903, -69.627163),
    "04538": (43.956167, -69.517161),
    "04539": (43.928967, -69.598725),
    "04541": (43.884294, -69.479184),
    "04543": (43.986485, -69.424228),
    "04544": (43.82677, -69.597446),
    "04547": (44.010424, -69.231179),
    "04548": (43.805389, -69.745295),
    "04549": (44.021333, -69.523263),
    "04551": (44.010411, -69.440192),
    "04552": (44.021333, -69.523263),
    "04553": (43.991336, -69.503427),
    "04554": (43.870936, -69.566313),
    "04555": (44.074877, -69.536374),
    "04556": (43.931748, -69.587334),
    "04558": (43.896727, -69.509282),
    "04562": (43.789616, -69.810821),
    "04563": (44.02301, -69.255572),
    "04564": (43.932449, -69.468052),
    "04565": (43.773312, -69.863461),
    "04567": (43.900856, -69.859541),
    "04568": (43.877877, -69.612725),
    "04570": (44.021333, -69.523263),
    "04571": (43.88261, -69.680144),
    "04572": (44.038581, -69.415708),
    "04573": (43.929821, -69.592127),
    "04574": (44.162384, -69.387795),
    "04575": (43.854534, -69.660795),
    "04576": (43.935605, -69.529648),
    "04578": (43.964901, -69.597134),
    "04579": (43.938696, -69.764378),
    "04605": (44.477935, -68.356311),
    "04606": (45.002969, -67.495548),
    "04607": (44.483471, -68.090339),
    "04609": (44.362323, -68.305513),
    "04611": (45.002969, -67.495548),
    "04612": (44.239876, -68.354598),
    "04613": (44.641873, -68.391481),
    "04614": (44.29691, -68.623927),
    "04615": (44.641873, -68.391481),
    "04616": (44.258121, -68.567404),
    "04617": (44.337581, -68.765568),
    "04619": (45.188254, -67.389101),
    "04622": (44.603258, -67.923248),
    "04623": (44.698608, -67.779881),
    "04624": (44.641873, -68.391481),
    "04625": (44.641873, -68.391481),
    "04626": (45.002969, -67.495548),
    "04627": (44.213503, -68.711691),
    "04628": (45.002969, -67.495548),
    "04629": (44.641873, -68.391481),
    "04630": (44.70746, -67.46247),
    "04631": (45.036287, -67.136853),
    "04634": (44.595131, -68.233576),
    "04635": (44.641873, -68.391481),
    "04637": (45.185635, -67.601026),
    "04640": (44.641873, -68.391481),
    "04642": (44.641873, -68.391481),
    "04643": (45.002969, -67.495548),
    "04644": (44.641873, -68.391481),
    "04645": (44.032196, -69.148017),
    "04646": (44.641873, -68.391481),
    "04648": (45.002969, -67.495548),
    "04649": (45.002969, -67.495548),
    "04650": (44.641873, -68.391481),
    "04652": (44.904288, -67.040767),
    "04653": (44.641873, -68.391481),
    "04654": (44.660627, -67.469196),
    "04655": (45.002969, -67.495548),
    "04656": (44.641873, -68.391481),
    "04657": (45.002969, -67.495548),
    "04658": (45.002969, -67.495548),
    "04660": (44.334692, -68.308737),
    "04662": (44.294073, -68.284865),
    "04664": (44.641873, -68.391481),
    "04665": (44.641873, -68.391481),
    "04666": (44.930092, -67.156533),
    "04667": (45.013348, -67.097043),
    "04668": (45.209229, -67.575432),
    "04669": (44.641873, -68.391481),
    "04671": (45.002969, -67.495548),
    "04672": (44.413523, -68.251778),
    "04673": (44.313629, -68.686305),
    "04674": (44.641873, -68.391481),
    "04675": (44.299037, -68.246314),
    "04676": (44.399111, -68.701228),
    "04677": (44.491175, -68.19137),
    "04679": (44.390897, -68.261568),
    "04680": (45.002969, -67.495548),
    "04681": (44.641873, -68.391481),
    "04683": (44.641873, -68.391481),
    "04684": (44.641873, -68.391481),
    "04685": (44.213118, -68.396479),
    "04686": (45.002969, -67.495548),
    "04690": (44.641873, -68.391481),
    "04691": (45.002969, -67.495548),
    "04693": (44.387188, -68.074964),
    "04694": (45.152637, -67.37741),
    "04730": (46.121345, -67.833009),
    "04732": (46.975725, -68.39816),
    "04733": (46.516166, -68.886826),
    "04734": (46.516166, -68.886826),
    "04735": (46.516166, -68.886826),
    "04736": (46.871355, -68.025442),
    "04737": (46.516166, -68.886826),
    "04738": (46.516166, -68.886826),
    "04739": (46.516166, -68.886826),
    "04740": (46.611101, -67.85582),
    "04741": (46.516166, -68.886826),
    "04742": (46.746453, -67.84150700000001),
    "04743": (47.056484, -68.255868),
    "04744": (46.516166, -68.886826),
    "04745": (47.295289, -68.39192),
    "04746": (47.00434, -67.998581),
    "04747": (46.011345, -68.273154),
    "04750": (46.906749, -67.851979),
    "04751": (46.892918, -67.9643),
    "04756": (46.934538, -68.109616),
    "04757": (47.007842, -68.182061),
    "04758": (46.551571, -67.84817),
    "04759": (46.516166, -68.886826),
    "04760": (46.516166, -68.886826),
    "04761": (46.100442, -68.003376),
    "04762": (46.976619, -68.205546),
    "04763": (46.09998, -68.14487),
    "04764": (46.516166, -68.886826),
    "04765": (45.999084, -68.443112),
    "04766": (46.516166, -68.886826),
    "04768": (46.516166, -68.886826),
    "04769": (46.715072, -68.012557),
    "04770": (46.516166, -68.886826),
    "04772": (47.263956, -68.335025),
    "04773": (46.516166, -68.886826),
    "04774": (46.516166, -68.886826),
    "04775": (46.516166, -68.886826),
    "04776": (46.516166, -68.886826),
    "04777": (45.519867, -68.647416),
    "04779": (46.516166, -68.886826),
    "04780": (46.516166, -68.886826),
    "04781": (46.516166, -68.886826),
    "04782": (45.519867, -68.647416),
    "04783": (46.787807, -68.155212),
    "04785": (46.986075, -68.042433),
    "04786": (46.793032, -68.105233),
    "04787": (46.594523, -67.930172),
    "04788": (46.516166, -68.886826),
    "04841": (44.128607, -69.068648),
    "04843": (44.12613, -69.029238),
    "04846": (44.131005, -69.091111),
    "04847": (44.241072, -69.203015),
    "04848": (44.309021, -68.900772),
    "04849": (44.324832, -68.998255),
    "04850": (44.478694, -69.149559),
    "04851": (44.032196, -69.148017),
    "04852": (44.021333, -69.523263),
    "04853": (44.113472, -68.855722),
    "04854": (44.07951, -69.085574),
    "04855": (44.032196, -69.148017),
    "04856": (44.132144, -69.03416),
    "04857": (43.995024, -69.198524),
    "04858": (44.115186, -69.132883),
    "04859": (44.002248, -69.11955),
    "04860": (43.963129, -69.213329),
    "04861": (44.108131, -69.042704),
    "04862": (44.231517, -69.219722),
    "04863": (44.08511, -68.841965),
    "04864": (44.086333, -69.188163),
    "04865": (44.192369, -69.121139),
    "04901": (44.554321, -69.617809),
    "04903": (44.549225, -69.713178),
    "04910": (44.530366, -69.639976),
    "04911": (44.81062, -69.912885),
    "04912": (44.9227, -69.67668),
    "04915": (44.404619, -69.040297),
    "04917": (44.480593999999996, -69.83253),
    "04918": (44.414056, -69.751913),
    "04920": (45.575731, -69.909773),
    "04921": (44.579387, -69.175448),
    "04922": (44.677388, -69.378829),
    "04923": (45.036055, -69.438697),
    "04924": (44.743659, -69.585151),
    "04925": (45.575731, -69.909773),
    "04926": (44.391167, -69.538257),
    "04927": (44.621084, -69.512609),
    "04928": (44.944157, -69.228736),
    "04929": (44.761527, -69.322662),
    "04930": (44.964532, -69.203773),
    "04932": (44.6819, -69.121648),
    "04933": (45.519867, -68.647416),
    "04935": (44.414056, -69.751913),
    "04936": (45.063384, -70.381639),
    "04937": (44.646261, -69.680158),
    "04938": (44.650311, -70.129267),
    "04939": (45.014913, -69.156965),
    "04940": (44.622563, -70.075178),
    "04941": (44.488583, -69.339221),
    "04942": (44.973047, -69.548148),
    "04943": (44.896404, -69.464092),
    "04944": (44.684737, -69.6425),
    "04945": (44.883675, -69.452187),
    "04947": (45.063384, -70.381639),
    "04949": (44.371549, -69.15555),
    "04950": (44.786404, -69.805662),
    "04951": (44.478694, -69.149559),
    "04952": (44.39785, -69.142182),
    "04953": (44.863406, -69.266827),
    "04954": (45.575731, -69.909773),
    "04955": (44.60363, -70.010292),
    "04956": (44.952578, -70.183554),
    "04957": (44.707468, -69.818804),
    "04958": (44.8019, -69.946593),
    "04961": (45.575731, -69.909773),
    "04962": (44.479288, -69.622006),
    "04963": (44.557111, -69.826495),
    "04964": (45.063384, -70.381639),
    "04965": (44.802655, -69.537715),
    "04966": (45.063384, -70.381639),
    "04967": (44.760948, -69.387705),
    "04969": (44.772503, -69.247539),
    "04970": (44.985998, -70.660181),
    "04971": (44.93183, -69.403011),
    "04972": (44.478694, -69.149559),
    "04973": (44.357201, -69.215906),
    "04974": (44.489412, -68.933051),
    "04975": (44.624515, -69.586852),
    "04976": (44.769303, -69.593975),
    "04978": (44.62111, -69.770923),
    "04979": (44.931415, -69.834764),
    "04981": (44.501114, -68.891743),
    "04982": (45.063384, -70.381639),
    "04983": (44.814175, -70.187221),
    "04984": (44.670079, -70.196855),
    "04985": (45.575731, -69.909773),
    "04986": (44.513048, -69.183929),
    "04987": (44.478694, -69.149559),
    "04988": (44.601175, -69.357191),
    "04989": (44.427757, -69.635908),
    "04992": (44.662822, -70.153049),
    "05001": (43.591821, -72.463589),
    "05009": (43.592039, -72.588407),
    "05030": (43.410672, -72.429777),
    "05031": (43.657625, -72.54586),
    "05032": (43.758758, -72.688169),
    "05033": (44.004691, -72.15845),
    "05034": (43.592527, -72.621578),
    "05035": (43.599795, -72.675164),
    "05036": (44.017782, -72.577365),
    "05037": (43.467179, -72.488285),
    "05038": (43.994212, -72.457153),
    "05039": (44.033236, -72.293631),
    "05040": (44.077918, -72.210962),
    "05041": (43.995961, -72.411393),
    "05042": (44.359629, -72.086586),
    "05043": (43.807282, -72.214693),
    "05045": (43.928681, -72.196635),
    "05046": (44.281506, -72.207573),
    "05047": (43.672103, -72.355539),
    "05048": (43.573379, -72.402698),
    "05049": (43.592039, -72.588407),
    "05050": (44.46239, -72.135804),
    "05051": (44.068284, -72.118739),
    "05052": (43.591324, -72.34903),
    "05053": (43.709919, -72.511882),
    "05054": (43.995961, -72.411393),
    "05055": (43.717918, -72.3612),
    "05056": (43.526289, -72.724848),
    "05058": (43.995961, -72.411393),
    "05059": (43.664059, -72.433116),
    "05060": (43.985803, -72.694098),
    "05061": (43.928552, -72.569113),
    "05062": (43.47559, -72.572818),
    "05065": (43.777365, -72.407132),
    "05067": (43.697055, -72.508042),
    "05068": (43.777096, -72.528249),
    "05069": (44.19779, -72.110362),
    "05070": (43.844018, -72.378546),
    "05071": (43.565888, -72.534106),
    "05072": (43.892586, -72.369563),
    "05073": (43.630897, -72.48908),
    "05074": (43.995961, -72.411393),
    "05075": (43.854017999999996, -72.254614),
    "05076": (43.995961, -72.411393),
    "05077": (43.895465, -72.473372),
    "05079": (43.952586, -72.311252),
    "05081": (44.119395, -72.088869),
    "05083": (43.995961, -72.411393),
    "05084": (43.718535, -72.443862),
    "05085": (43.995961, -72.411393),
    "05086": (44.115326, -72.317918),
    "05088": (43.673484, -72.31196),
    "05089": (43.5181, -72.418059),
    "05091": (43.631348, -72.512835),
    "05101": (43.171185, -72.623106),
    "05141": (42.99467, -72.720362),
    "05142": (43.402135, -72.583854),
    "05143": (43.298315, -72.667167),
    "05144": (43.592039, -72.588407),
    "05146": (43.179936, -72.605636),
    "05148": (43.228101, -72.787995),
    "05149": (43.376744, -72.706913),
    "05150": (43.33803, -72.527652),
    "05151": (43.409654, -72.495851),
    "05152": (43.09893, -73.034944),
    "05153": (43.439854, -72.620659),
    "05154": (43.164738, -72.53194),
    "05155": (43.169854, -72.851525),
    "05156": (43.40971, -72.586064),
    "05158": (43.082635, -72.474882),
    "05159": (43.093972, -72.456492),
    "05161": (43.316142, -72.739715),
    "05201": (42.934076, -73.105382),
    "05250": (43.065719, -73.134727),
    "05251": (43.261817, -73.139173),
    "05252": (43.069409, -73.165898),
    "05253": (43.182502, -73.065443),
    "05254": (43.177204, -73.045787),
    "05255": (43.169289, -73.047358),
    "05257": (42.966471, -73.250529),
    "05260": (42.829469, -73.262496),
    "05261": (42.790682, -73.201254),
    "05262": (42.979702, -73.192929),
    "05301": (42.884281, -72.760753),
    "05302": (42.99467, -72.720362),
    "05303": (42.99467, -72.720362),
    "05304": (42.99467, -72.720362),
    "05340": (43.16409, -72.91514),
    "05341": (42.968046, -72.812012),
    "05342": (42.795363, -72.817838),
    "05343": (43.012776, -72.767275),
    "05344": (42.99467, -72.720362),
    "05345": (43.013138, -72.678725),
    "05346": (43.016096, -72.534025),
    "05350": (42.785591, -72.971932),
    "05351": (42.939071, -72.72923),
    "05352": (42.782616, -73.067501),
    "05353": (43.070341, -72.672991),
    "05354": (42.773711, -72.520166),
    "05355": (43.00476, -72.792004),
    "05356": (43.013041, -72.793787),
    "05357": (42.957233, -72.62408),
    "05358": (42.766519, -72.745723),
    "05359": (43.133864, -72.714573),
    "05360": (43.050937, -72.825636),
    "05361": (42.78318, -72.867891),
    "05362": (42.975027, -72.673566),
    "05363": (42.944039, -72.727518),
    "05401": (44.507404, -73.151384),
    "05402": (44.442117, -73.082525),
    "05403": (44.448119, -73.098238),
    "05404": (44.498032, -73.182158),
    "05405": (44.442117, -73.082525),
    "05406": (44.442117, -73.082525),
    "05407": (44.442117, -73.082525),
    "05439": (44.49518, -73.165092),
    "05440": (44.93606, -73.289065),
    "05441": (44.836967, -72.92169),
    "05442": (44.724842, -72.701554),
    "05443": (44.157814, -73.071813),
    "05444": (44.62218, -72.881162),
    "05445": (44.31658, -73.226034),
    "05446": (44.535557, -73.103897),
    "05447": (44.824855, -72.895849),
    "05448": (44.741186, -72.882683),
    "05449": (44.442117, -73.082525),
    "05450": (44.902044, -72.782425),
    "05451": (44.50835, -73.050271),
    "05452": (44.485558, -73.025271),
    "05453": (44.442117, -73.082525),
    "05454": (44.733486, -72.953478),
    "05455": (44.816159, -72.969743),
    "05456": (44.210886, -73.256629),
    "05457": (44.96038, -72.913261),
    "05458": (44.723391, -73.303193),
    "05459": (44.962395, -73.033062),
    "05460": (44.974765, -73.105205),
    "05461": (44.4553, -73.067858),
    "05462": (44.318091, -73.006184),
    "05463": (44.878094, -73.338597),
    "05464": (44.638789, -72.82199),
    "05465": (44.458996, -72.955175),
    "05466": (44.362504, -73.019801),
    "05468": (44.643418, -73.121685),
    "05469": (44.240375, -73.134702),
    "05470": (44.824855, -72.895849),
    "05471": (44.848241, -72.619812),
    "05472": (44.149509, -73.197156),
    "05473": (44.239233, -73.205939),
    "05474": (44.835274, -73.277846),
    "05476": (44.952669, -72.65435),
    "05477": (44.387289, -72.953283),
    "05478": (44.779982, -72.908985),
    "05479": (44.824855, -72.895849),
    "05481": (44.824855, -72.895849),
    "05482": (44.42493, -73.114047),
    "05483": (44.897751, -72.961075),
    "05485": (44.905573, -72.963154),
    "05486": (44.738156, -73.306352),
    "05487": (44.235203, -73.02086),
    "05488": (44.902128, -72.948391),
    "31221": (32.806707, -83.691315),
    "05489": (44.565148, -72.907209),
    "05490": (44.504656, -72.885253),
    "05491": (44.145691, -73.260487),
    "05492": (44.736083, -72.703199),
    "05494": (44.56959, -73.025541),
    "05495": (44.430096, -73.026735),
    "05501": (42.647191, -71.184202),
    "05544": (42.647191, -71.184202),
    "05601": (44.19906, -72.559638),
    "05602": (44.26829, -72.623619),
    "05603": (44.156554, -72.655892),
    "05604": (44.259518, -72.585018),
    "05609": (44.259518, -72.585018),
    "05620": (44.259518, -72.585018),
    "05633": (44.259518, -72.585018),
    "05640": (44.174872, -72.502235),
    "05641": (44.20896, -72.607693),
    "05647": (44.266228, -72.530473),
    "05648": (44.259518, -72.585018),
    "05649": (44.157636, -72.453261),
    "05650": (44.407044, -72.498572),
    "05651": (44.279376, -72.49657),
    "05652": (44.718619, -72.57821),
    "05653": (44.701158, -72.479642),
    "05654": (44.155438, -72.484706),
    "05655": (44.560808, -72.590031),
    "05656": (44.642603, -72.735911),
    "05657": (44.599905, -72.647519),
    "05658": (44.374874, -72.329902),
    "05660": (44.270817, -72.786431),
    "05661": (44.560179, -72.615346),
    "05662": (44.442001, -72.718759),
    "05663": (44.180906, -72.678854),
    "05664": (44.183536, -72.646591),
    "05665": (44.67307, -72.597057),
    "05666": (44.259518, -72.585018),
    "05667": (44.283708, -72.552243),
    "05669": (44.028005, -73.089655),
    "05670": (44.175744, -72.50247),
    "05671": (44.259518, -72.585018),
    "05672": (44.535179, -72.660043),
    "05673": (44.192186, -72.843868),
    "05674": (44.217175, -72.820401),
    "05675": (44.078238, -72.426322),
    "05676": (44.259608, -72.781143),
    "05677": (44.389313, -72.708616),
    "05678": (44.155782, -72.46581),
    "05679": (44.103841, -72.526916),
    "05680": (44.539539, -72.487589),
    "05681": (44.259518, -72.585018),
    "05682": (44.343536, -72.575645),
    "05701": (43.630346, -72.93586),
    "05702": (43.412792, -72.990632),
    "05730": (43.420978, -72.828524),
    "05731": (43.687677, -73.291868),
    "05732": (43.643723, -73.209356),
    "05733": (43.655139, -73.121251),
    "05734": (43.982512, -73.331483),
    "05735": (43.636856, -73.126638),
    "05736": (43.594106, -73.008253),
    "05737": (43.713218, -72.925199),
    "05738": (43.526706, -72.869165),
    "05739": (43.34792, -73.027985),
    "05740": (43.97153, -73.091416),
    "05741": (43.592039, -72.818121),
    "05742": (43.446092, -72.92087),
    "05743": (43.634258, -73.182585),
    "05744": (43.576783, -73.107352),
    "05745": (43.592039, -72.818121),
    "05746": (43.592039, -72.588407),
    "05747": (44.0032, -72.817108),
    "05748": (43.907858, -72.890031),
    "05750": (43.599381, -73.25104),
    "05751": (43.656951, -72.782713),
    "05753": (43.991942, -73.171578),
    "05757": (43.478301, -73.060391),
    "05758": (43.444535, -72.802413),
    "05759": (43.535739, -72.970114),
    "05760": (43.863158, -73.242322),
    "05761": (43.361439, -73.150683),
    "05762": (43.592039, -72.818121),
    "05763": (43.72182, -72.999461),
    "05764": (43.525395, -73.112878),
    "05765": (43.601975, -73.09589),
    "05766": (43.979315, -73.010663),
    "05767": (43.866832, -72.851495),
    "05768": (43.026984, -73.055156),
    "05769": (43.920297, -73.122709),
    "05770": (43.912406, -73.279162),
    "05772": (43.756978, -72.730177),
    "05773": (43.477386, -73.066066),
    "05774": (43.429363, -73.161826),
    "05775": (43.360006, -73.224211),
    "05776": (43.026984, -73.055156),
    "05777": (43.588163, -73.065323),
    "05778": (43.893982, -73.203001),
    "05819": (44.426455, -72.114155),
    "05820": (44.741679, -72.364639),
    "05821": (44.313675, -72.11879),
    "05822": (44.73663, -72.199084),
    "05823": (45.005783, -72.138347),
    "05824": (44.581613, -71.833956),
    "05825": (44.775607, -72.22641),
    "05826": (44.641663, -72.388928),
    "05827": (44.678786, -72.35944),
    "05828": (44.437306, -72.123508),
    "05829": (44.952347, -72.218616),
    "05830": (44.97035, -72.036632),
    "05832": (44.587962, -71.910223),
    "05833": (44.775607, -72.22641),
    "05836": (44.496356, -72.17371),
    "05837": (44.667396, -71.813465),
    "05838": (44.468494, -71.930077),
    "05839": (44.679528, -72.221912),
    "05840": (44.680771, -71.719436),
    "05841": (44.600325, -72.286556),
    "05842": (44.775607, -72.22641),
    "05843": (44.51609, -72.309822),
    "05845": (44.783177, -72.301139),
    "05846": (44.832535, -71.841125),
    "05847": (44.788925, -72.439455),
    "05848": (44.382103, -71.919518),
    "05849": (44.497557, -71.950519),
    "05850": (44.481915, -71.988258),
    "05851": (44.5351, -72.056557),
    "05853": (44.878704, -71.971424),
    "05855": (44.907921, -72.203948),
    "05857": (44.927018, -72.299191),
    "05858": (44.512087, -71.795986),
    "05859": (44.937769, -72.433354),
    "05860": (44.823782, -72.102019),
    "05861": (44.46239, -72.135804),
    "05862": (44.46239, -72.135804),
    "05863": (44.503403, -71.972088),
    "05866": (44.639653, -72.132255),
    "05867": (44.664521, -72.042415),
    "05868": (44.775607, -72.22641),
    "05871": (44.683041, -71.936817),
    "05872": (44.849402, -72.03121),
    "05873": (44.393366, -72.222424),
    "05874": (44.869117, -72.450485),
    "05875": (44.710028, -72.258038),
    "05901": (44.680771, -71.719436),
    "05902": (44.680771, -71.719436),
    "05903": (44.930787, -71.597809),
    "05904": (44.680771, -71.719436),
    "05905": (44.671187, -71.662213),
    "05906": (44.680771, -71.719436),
    "05907": (44.932643, -71.776359),
    "06001": (41.757944, -72.728272),
    "06002": (41.851961, -72.738939),
    "06006": (41.879637, -72.734271),
    "06010": (41.681198, -72.939577),
    "06011": (41.791776, -72.718832),
    "06013": (41.761773, -72.95826),
    "06016": (41.842097, -72.708388),
    "06018": (42.001585, -73.295891),
    "06019": (41.842882, -72.899645),
    "06020": (41.853921, -72.902811),
    "06021": (42.005809, -73.118329),
    "06022": (41.851597, -72.918127),
    "06023": (41.613489, -72.7207),
    "06024": (42.015806, -73.291299),
    "06025": (41.688896, -72.534482),
    "06026": (41.939096, -72.740538),
    "06027": (42.004978, -72.896907),
    "06028": (41.859248, -72.603033),
    "06029": (41.849319, -72.411777),
    "06030": (41.791776, -72.718832),
    "06031": (41.949717, -73.304403),
    "06032": (41.726769, -72.829543),
    "06033": (41.703451, -72.539332),
    "06034": (41.791776, -72.718832),
    "06035": (41.966062, -72.796407),
    "06037": (41.602948, -72.769991),
    "06039": (41.951917, -73.38138000000001),
    "06040": (41.776048, -72.523748),
    "06041": (41.794681, -72.564832),
    "06043": (41.768648, -72.439278),
    "06045": (41.791776, -72.718832),
    "06049": (41.791776, -72.718832),
    "06050": (41.666049, -72.778391),
    "06051": (41.668449, -72.770441),
    "06052": (41.656748, -72.801892),
    "06053": (41.690249, -72.790991),
    "06057": (41.883102, -73.045918),
    "06058": (41.886811, -73.184674),
    "06059": (41.899683, -72.890744),
    "06060": (42.004694, -72.843205),
    "06061": (41.874382, -72.967958),
    "06062": (41.672983, -72.859695),
    "06063": (41.93937, -72.990647),
    "06064": (41.791776, -72.718832),
    "06065": (41.968597, -73.014467),
    "06066": (41.8372, -72.454917),
    "06067": (41.657249, -72.670887),
    "06068": (42.00579, -73.399336),
    "06069": (41.874681, -73.433903),
    "06070": (41.868647, -72.819742),
    "06071": (41.919603, -72.433046),
    "06072": (41.976466, -72.490593),
    "06073": (41.657099, -72.572233),
    "06074": (41.834198, -72.564632),
    "06075": (41.81152, -72.308779),
    "06076": (41.900495, -72.27641),
    "06077": (41.991645, -72.257735),
    "06078": (41.989646, -72.658135),
    "06079": (42.032012, -73.403763),
    "06080": (41.948597, -72.628802),
    "06081": (41.905269, -72.767239),
    "06082": (41.984646, -72.557731),
    "06083": (41.791776, -72.718832),
    "06084": (41.882553, -72.361039),
    "06085": (41.860009, -72.933467),
    "06087": (41.757616, -72.884953),
    "06088": (41.903347, -72.592883),
    "06089": (41.889965, -72.704),
    "06090": (41.955645, -72.861993),
    "06091": (42.003447, -72.992109),
    "06092": (41.865597, -72.849854),
    "06093": (42.005795, -72.727337),
    "06094": (41.896321, -73.146312),
    "06095": (41.909988, -72.804935),
    "06096": (41.933846, -72.660245),
    "06098": (41.925671, -73.058157),
    "06101": (41.78007, -72.677099),
    "06102": (41.791776, -72.718832),
    "06103": (41.766349, -72.674636),
    "06104": (41.791776, -72.718832),
    "06105": (41.774499, -72.699537),
    "06106": (41.745049, -72.687787),
    "06107": (41.75325, -72.75804),
    "06108": (41.779799, -72.621365),
    "06109": (41.698899, -72.667887),
    "06110": (41.73425, -72.738139),
    "06111": (41.685985, -72.729646),
    "06112": (41.791337, -72.694337),
    "06114": (41.747399, -72.672237),
    "06115": (41.758849, -72.679387),
    "06117": (41.788688, -72.755739),
    "06118": (41.748999, -72.609884),
    "06119": (41.764349, -72.726388),
    "06120": (41.785449, -72.669936),
    "06123": (41.791776, -72.718832),
    "06126": (41.791776, -72.718832),
    "06127": (41.791776, -72.718832),
    "06128": (41.791776, -72.718832),
    "06129": (41.791776, -72.718832),
    "06131": (41.791776, -72.718832),
    "06132": (41.791776, -72.718832),
    "06133": (41.791776, -72.718832),
    "06134": (41.791776, -72.718832),
    "06137": (41.791776, -72.718832),
    "06138": (41.791776, -72.718832),
    "06140": (41.791776, -72.718832),
    "06141": (41.791776, -72.718832),
    "06142": (41.791776, -72.718832),
    "06143": (41.791776, -72.718832),
    "06144": (41.791776, -72.718832),
    "06145": (41.791776, -72.718832),
    "06146": (41.791776, -72.718832),
    "06147": (41.791776, -72.718832),
    "06150": (41.791776, -72.718832),
    "06151": (41.791776, -72.718832),
    "06152": (41.791776, -72.718832),
    "06153": (41.791776, -72.718832),
    "06154": (41.771499, -72.686687),
    "06155": (41.76928, -72.686465),
    "06156": (41.767949, -72.690687),
    "06160": (41.766499, -72.693337),
    "06161": (41.766049, -72.671837),
    "06167": (41.791776, -72.718832),
    "06176": (41.791776, -72.718832),
    "06180": (41.791776, -72.718832),
    "06183": (41.763849, -72.673037),
    "06199": (41.927447, -72.680386),
    "06226": (41.845504, -72.091889),
    "06230": (41.847302, -72.02528),
    "06231": (41.626377, -72.3728),
    "06232": (41.731847, -72.374634),
    "06233": (41.831565, -72.020137),
    "06234": (41.847758, -71.983412),
    "06235": (41.80294, -72.126036),
    "06237": (41.696124, -72.300043),
    "06238": (41.778623, -72.323642),
    "06239": (41.864901, -71.874354),
    "06241": (41.854975, -71.858826),
    "06242": (41.927524, -72.041112),
    "06243": (41.844885, -71.818941),
    "06244": (41.984327, -71.981045),
    "06245": (42.019776, -71.941669),
    "06246": (41.971116, -71.891732),
    "06247": (41.788756, -71.975819),
    "06248": (41.689249, -72.398627),
    "06249": (41.628008, -72.245422),
    "06250": (41.78155, -72.22554),
    "06251": (41.799326, -72.306526),
    "06254": (41.609895, -72.150305),
    "06255": (41.978392, -71.899716),
    "06256": (41.778469, -72.040003),
    "06258": (41.889048, -71.968232),
    "06259": (41.863133, -72.00259),
    "06260": (41.862904, -71.887712),
    "06262": (42.021536, -71.947077),
    "06263": (41.839051, -71.90634),
    "06264": (41.695803, -72.087045),
    "06265": (41.81152, -72.308779),
    "06266": (41.674079, -72.172298),
    "06267": (41.943902, -71.945253),
    "06268": (41.787937, -72.25248),
    "06269": (41.808007, -72.250963),
    "06277": (41.975796, -71.862047),
    "06278": (41.889043, -72.147561),
    "06279": (41.896623, -72.262236),
    "06280": (41.693914, -72.137843),
    "06281": (41.961991, -72.014108),
    "06282": (41.952846, -72.057134),
    "06320": (41.413998, -72.10907),
    "06330": (41.501708, -72.044306),
    "06331": (41.696753, -71.998277),
    "06332": (41.725694, -71.909019),
    "06333": (41.378842, -72.236794),
    "06334": (41.544598, -72.177023),
    "06335": (41.523376999999996, -72.021165),
    "06336": (41.579548, -72.196273),
    "06337": (41.559873, -71.889199),
    "06339": (41.492843, -71.965554),
    "06340": (41.355405, -72.038268),
    "06349": (41.39973, -72.090357),
    "06350": (41.644546, -72.06769),
    "06351": (41.599562, -71.982619),
    "06353": (41.452548, -72.137471),
    "06354": (41.704931, -71.849772),
    "06355": (41.485188, -72.000748),
    "06357": (41.323447, -72.215623),
    "06359": (41.466851, -71.880694),
    "06360": (41.499398, -71.994757),
    "06365": (41.522369, -71.993427),
    "06370": (41.512172, -72.102302),
    "06371": (41.409397, -72.147665),
    "06372": (41.388216, -71.949548),
    "06373": (41.678546, -71.817759),
    "06374": (41.688121, -71.884113),
    "06375": (41.401066, -72.140022),
    "06376": (41.296668, -72.263296),
    "06377": (41.719948, -71.823184),
    "06378": (41.378598, -71.917915),
    "06379": (41.455191, -71.895547),
    "06380": (41.563998, -72.05522),
    "06382": (41.424507, -72.069578),
    "06383": (41.601648, -72.04037),
    "06384": (41.576894, -71.866587),
    "06385": (41.456698, -72.126498),
    "06386": (41.464758, -72.127301),
    "06387": (41.744527, -71.913339),
    "06388": (41.344098, -71.976467),
    "06389": (41.559648, -72.122672),
    "06390": (40.992288, -72.723496),
    "06401": (41.342514, -73.070301),
    "06403": (41.435134, -73.058835),
    "06404": (41.165097, -73.129186),
    "06405": (41.284746, -72.796292),
    "06408": (41.365709, -72.927507),
    "06409": (41.349098, -72.41338),
    "06410": (41.460167, -72.97222),
    "06411": (41.550097, -72.922235),
    "06412": (41.39027, -72.461805),
    "06413": (41.298201, -72.532934),
    "06414": (41.566668, -72.558055),
    "06415": (41.546443, -72.338832),
    "06416": (41.608529, -72.667807),
    "06417": (41.368124, -72.452284),
    "06418": (41.327246, -73.084252),
    "06419": (41.417962, -72.493446),
    "06420": (41.527441, -72.269141),
    "06422": (41.462468, -72.682297),
    "06423": (41.475478, -72.389729),
    "06424": (41.559841, -72.494927),
    "06426": (41.448179, -72.50426),
    "06430": (41.175173, -73.282408),
    "06431": (41.219093, -73.252696),
    "06432": (41.196046, -73.252802),
    "06436": (41.308873, -73.363661),
    "06437": (41.338847, -72.690089),
    "06438": (41.471457, -72.511376),
    "06439": (41.421198, -72.414095),
    "06440": (41.308873, -73.363661),
    "06441": (41.462718, -72.578971),
    "06442": (41.344076, -72.444369),
    "06443": (41.350397, -72.788392),
    "06444": (41.791776, -72.718832),
    "06447": (41.636949, -72.463179),
    "06450": (41.536498, -72.801901),
    "06451": (41.54011, -72.81888000000001),
    "06454": (41.365709, -72.927507),
    "06455": (41.515346, -72.712988),
    "06456": (41.538016999999996, -72.525208),
    "06457": (41.550139, -72.655357),
    "06459": (41.556463, -72.658179),
    "06460": (41.343773, -72.951273),
    "06467": (41.565697, -72.903746),
    "06468": (41.341845, -73.236918),
    "06469": (41.508904, -72.440086),
    "06470": (41.396295, -73.310561),
    "06471": (41.332347, -72.780892),
    "06472": (41.379797, -72.772991),
    "06473": (41.384381, -72.862644),
    "06474": (41.464758, -72.127301),
    "06475": (41.300448, -72.389129),
    "06477": (41.279896, -73.031018),
    "06478": (41.432583, -73.138379),
    "06479": (41.577844999999996, -72.902496),
    "06480": (41.598339, -72.601307),
    "06481": (41.542105, -72.666583),
    "06482": (41.408136999999996, -73.249671),
    "06483": (41.417646, -73.102078),
    "06484": (41.314347, -73.137143),
    "06487": (41.365709, -72.927507),
    "06488": (41.470921, -73.240839),
    "06489": (41.604786, -72.871945),
    "06490": (41.143396, -73.289859),
    "06491": (41.386646, -73.187207),
    "06492": (41.456205, -72.811047),
    "06493": (41.365709, -72.927507),
    "06494": (41.365709, -72.927507),
    "06495": (41.365709, -72.927507),
    "06497": (41.207146, -73.130503),
    "06498": (41.307899, -72.463381),
    "06501": (41.365709, -72.927507),
    "06502": (41.365709, -72.927507),
    "06503": (41.365709, -72.927507),
    "06504": (41.365709, -72.927507),
    "06505": (41.305721, -72.779901),
    "06506": (41.365709, -72.927507),
    "06507": (41.365709, -72.927507),
    "06508": (41.365709, -72.927507),
    "06509": (41.365709, -72.927507),
    "06510": (41.309797, -72.922296),
    "06511": (41.310547, -72.926046),
    "06512": (41.290997, -72.865894),
    "06513": (41.307197, -72.865365),
    "06514": (41.372723, -72.938747),
    "06515": (41.328697, -72.964247),
    "06516": (41.272452, -72.940335),
    "06517": (41.362197, -72.911396),
    "06518": (41.416747, -72.906096),
    "06519": (41.296897, -72.938596),
    "06520": (41.365709, -72.927507),
    "06521": (41.365709, -72.927507),
    "06524": (41.428088, -72.996191),
    "06525": (41.353296, -73.013981),
    "06530": (41.365709, -72.927507),
    "06531": (41.365709, -72.927507),
    "06532": (41.365709, -72.927507),
    "06533": (41.365709, -72.927507),
    "06534": (41.365709, -72.927507),
    "06535": (41.365709, -72.927507),
    "06536": (41.365709, -72.927507),
    "06537": (41.365709, -72.927507),
    "06538": (41.365709, -72.927507),
    "06540": (41.299647, -72.918846),
    "06601": (41.308873, -73.363661),
    "06602": (41.179846, -73.189006),
    "06604": (41.192746, -73.213907),
    "06605": (41.162573, -73.216557),
    "06606": (41.208796, -73.211807),
    "06607": (41.181596, -73.165604),
    "06608": (41.188199, -73.180005),
    "06610": (41.219847, -73.163955),
    "06611": (41.259996, -73.206957),
    "06612": (41.273016, -73.297721),
    "06614": (41.216006, -73.130353),
    "06615": (41.177046, -73.133574),
    "06650": (41.308873, -73.363661),
    "06673": (41.308873, -73.363661),
    "06699": (41.308873, -73.363661),
    "06701": (41.365709, -72.927507),
    "06702": (41.540696, -73.071124),
    "06703": (41.365709, -72.927507),
    "06704": (41.581797, -73.034451),
    "06705": (41.552893, -72.992749),
    "06706": (41.535346, -73.026951),
    "06708": (41.551496, -73.064152),
    "06710": (41.571496, -73.044035),
    "06712": (41.499097, -72.975694),
    "06716": (41.598347, -72.980578),
    "06720": (41.365709, -72.927507),
    "06721": (41.365709, -72.927507),
    "06722": (41.365709, -72.927507),
    "06723": (41.365709, -72.927507),
    "06724": (41.365709, -72.927507),
    "06725": (41.365709, -72.927507),
    "06726": (41.365709, -72.927507),
    "06749": (41.365709, -72.927507),
    "06750": (41.714352, -73.251598),
    "06751": (41.6409, -73.209685),
    "06752": (41.520312, -73.363875),
    "06753": (41.828067, -73.332345),
    "06754": (41.744373, -73.301922),
    "06755": (41.634686, -73.472048),
    "06756": (41.794278, -73.239023),
    "06757": (41.774725, -73.401908),
    "06758": (41.739889, -73.222981),
    "06759": (41.791598, -73.229787),
    "06762": (41.528274, -73.116458),
    "31294": (32.806707, -83.691315),
    "06763": (41.689616, -73.212587),
    "06770": (41.491016, -73.052965),
    "06776": (41.658619, -73.366017),
    "06777": (41.690297, -73.310346),
    "06778": (41.707722, -73.108997),
    "06779": (41.604052, -73.216887),
    "06781": (41.669898, -72.99145),
    "06782": (41.65873, -73.044364),
    "06783": (41.578971, -73.298344),
    "06784": (41.525631, -73.490891),
    "06785": (41.682439, -73.305256),
    "06786": (41.66353, -73.022449),
    "06787": (41.658721, -73.098657),
    "06790": (41.87484, -73.126763),
    "06791": (41.649639, -73.176163),
    "06793": (41.718159, -73.294187),
    "06794": (41.646347, -73.316951),
    "06795": (41.759427, -73.162003),
    "06796": (41.821529, -73.350384),
    "06798": (41.733106, -73.135499),
    "06801": (41.381244, -73.39908),
    "06804": (41.404799, -73.275562),
    "06807": (41.058646, -73.587618),
    "06810": (41.376242, -73.471416),
    "06811": (41.42333, -73.478717),
    "06812": (41.486689, -73.491042),
    "06813": (41.308873, -73.363661),
    "06814": (41.308873, -73.363661),
    "06816": (41.308873, -73.363661),
    "06817": (41.308873, -73.363661),
    "06820": (41.075846, -73.480765),
    "06829": (41.25553, -73.427915),
    "06830": (41.042746, -73.62617),
    "06831": (41.079983, -73.654472),
    "06832": (41.308873, -73.363661),
    "06836": (41.308873, -73.363661),
    "06840": (41.162209, -73.501267),
    "06842": (41.147096, -73.495366),
    "06850": (41.126146, -73.442423),
    "06851": (41.139796, -73.404963),
    "06852": (41.308873, -73.363661),
    "06853": (41.070396, -73.437563),
    "06854": (41.090946, -73.432313),
    "06855": (41.099196, -73.398362),
    "06856": (41.111196, -73.420363),
    "06857": (41.308873, -73.363661),
    "06858": (41.110496, -73.416213),
    "06859": (41.308873, -73.363661),
    "06860": (41.308873, -73.363661),
    "06870": (41.034946, -73.566968),
    "06875": (41.308873, -73.363661),
    "06876": (41.032647, -73.583569),
    "06877": (41.308201, -73.494637),
    "06878": (41.035596, -73.580241),
    "06879": (41.308873, -73.363661),
    "06880": (41.144496, -73.343261),
    "06881": (41.308873, -73.363661),
    "06883": (41.222945, -73.376263),
    "06888": (41.308873, -73.363661),
    "06889": (41.141005, -73.34689),
    "06896": (41.271095, -73.38634),
    "06897": (41.209695, -73.439165),
    "06901": (41.054082, -73.536216),
    "06902": (41.060196, -73.544477),
    "06903": (41.136773, -73.565919),
    "06904": (41.308873, -73.363661),
    "06905": (41.116751, -73.552752),
    "06906": (41.071246, -73.521416),
    "06907": (41.088346, -73.537217),
    "06910": (41.039147, -73.559118),
    "06911": (41.308873, -73.363661),
    "06912": (41.308873, -73.363661),
    "06913": (41.308873, -73.363661),
    "06914": (41.308873, -73.363661),
    "06920": (41.308873, -73.363661),
    "06921": (41.049866, -73.53796),
    "06922": (41.051551, -73.514344),
    "06925": (41.308873, -73.363661),
    "06926": (41.041197, -73.538567),
    "06927": (41.308873, -73.363661),
    "06928": (41.308873, -73.363661),
    "07001": (40.582845, -74.27524),
    "07002": (40.670858, -74.109486),
    "07003": (40.808549, -74.187005),
    "07004": (40.875948, -74.29681),
    "07005": (40.918648, -74.430696),
    "07006": (40.854548, -74.278892),
    "07007": (40.79185, -74.245241),
    "07008": (40.583203, -74.234839),
    "07009": (40.857049, -74.227109),
    "07010": (40.820541, -73.98782),
    "07011": (40.877949, -74.141237),
    "07012": (40.847699, -74.160538),
    "07013": (40.872898, -74.170138),
    "07014": (40.832449, -74.136937),
    "07015": (41.011428, -74.304793),
    "07016": (40.654802, -74.304792),
    "07017": (40.77185, -74.207039),
    "07018": (40.7566, -74.216839),
    "07019": (40.79185, -74.245241),
    "07020": (40.82655, -73.978082),
    "07021": (40.826158, -74.276591),
    "07022": (40.817537, -74.000883),
    "07023": (40.641902, -74.387044),
    "07024": (40.848745, -73.974032),
    "07026": (40.884648, -74.110336),
    "07027": (40.651242, -74.322892),
    "07028": (40.807499, -74.205039),
    "07029": (40.744501, -74.150787),
    "07030": (40.746851, -74.033934),
    "07031": (40.787112, -74.127316),
    "07032": (40.75175, -74.122937),
    "07033": (40.677601, -74.291191),
    "07034": (40.880649, -74.379745),
    "07035": (40.926637, -74.303093),
    "07036": (40.626953, -74.250939),
    "07039": (40.787006, -74.325993),
    "07040": (40.7291, -74.266541),
    "07041": (40.73365, -74.301692),
    "07042": (40.811908, -74.216389),
    "07043": (40.8034, -74.19448),
    "07044": (40.832849, -74.243895),
    "07045": (40.906311, -74.363231),
    "07046": (40.890502, -74.440898),
    "07047": (40.789724, -74.023234),
    "07050": (40.7704, -74.23674),
    "07051": (40.79185, -74.245241),
    "07052": (40.789944, -74.22719),
    "07054": (40.852118, -74.407706),
    "07055": (40.855103, -74.126916),
    "07057": (40.852799, -74.107325),
    "07058": (40.871014, -74.340144),
    "07059": (40.629101, -74.532449),
    "07060": (40.615202, -74.414995),
    "07061": (40.665651, -74.299692),
    "07062": (40.632252, -74.399736),
    "07063": (40.604752, -74.442746),
    "07064": (40.570254, -74.249739),
    "07065": (40.609553, -74.280641),
    "07066": (40.622502, -74.311092),
    "07067": (40.590853, -74.314688),
    "07068": (40.820499, -74.306093),
    "07070": (40.827449, -74.109786),
    "07071": (40.799549, -74.116517),
    "07072": (40.828399, -74.076055),
    "07073": (40.828399, -74.093886),
    "07074": (40.839299, -74.060184),
    "07075": (40.848599, -74.089585),
    "07076": (40.637852, -74.368244),
    "07077": (40.551804, -74.259139),
    "07078": (40.74055, -74.334443),
    "07079": (40.745772, -74.267541),
    "07080": (40.572065, -74.413545),
    "07081": (40.701101, -74.316301),
    "07082": (40.92769, -74.347695),
    "07083": (40.692651, -74.269841),
    "07087": (40.758951, -74.056335),
    "07088": (40.71789, -74.284341),
    "07090": (40.652851, -74.346764),
    "07091": (40.665651, -74.299692),
    "07092": (40.680701, -74.358394),
    "07093": (40.7888, -74.011533),
    "07094": (40.78885, -74.056035),
    "07095": (40.553254, -74.288023),
    "07096": (40.73276, -74.075485),
    "07097": (40.73276, -74.075485),
    "07099": (40.73276, -74.075485),
    "07101": (40.736101, -74.22509),
    "07102": (40.735642, -74.173988),
    "07103": (40.738901, -74.194839),
    "07104": (40.76435, -74.151788),
    "07105": (40.723606, -74.147337),
    "07106": (40.74245, -74.23114),
    "07107": (40.7646, -74.188029),
    "07108": (40.722496, -74.200649),
    "07109": (40.7821, -74.167488),
    "07110": (40.821299, -74.159449),
    "07111": (40.726231, -74.23294),
    "07112": (40.711151, -74.211265),
    "07114": (40.705401, -74.169538),
    "07175": (40.79185, -74.245241),
    "07182": (40.79185, -74.245241),
    "07184": (40.79185, -74.245241),
    "07188": (40.79185, -74.245241),
    "07189": (40.79185, -74.245241),
    "07191": (40.79185, -74.245241),
    "07192": (40.79185, -74.245241),
    "07193": (40.79185, -74.245241),
    "07194": (40.79185, -74.245241),
    "07195": (40.79185, -74.245241),
    "07197": (40.79185, -74.245241),
    "07198": (40.79185, -74.245241),
    "07199": (40.79185, -74.245241),
    "07201": (40.672052, -74.183438),
    "07202": (40.650902, -74.217189),
    "07203": (40.650152, -74.25879),
    "07204": (40.665652, -74.26674),
    "07205": (40.693823, -74.229889),
    "07206": (40.652152, -74.191814),
    "07207": (40.665651, -74.299692),
    "07208": (40.677102, -74.229289),
    "07302": (40.726001, -74.047304),
    "07303": (40.73276, -74.075485),
    "07304": (40.716101, -74.065535),
    "07305": (40.696661, -74.081135),
    "07306": (40.734951, -74.068685),
    "07307": (40.749801, -74.054285),
    "07308": (40.73276, -74.075485),
    "07309": (40.73276, -74.075485),
    "07310": (40.732728, -74.037168),
    "07311": (40.73235, -74.075391),
    "07399": (40.73235, -74.075391),
    "07401": (41.017446, -74.062774),
    "07403": (41.023414, -74.334444),
    "07405": (40.998797, -74.426148),
    "07407": (40.905848, -74.117736),
    "07410": (40.935348, -74.119236),
    "07416": (41.115723, -74.593439),
    "07417": (41.010464, -74.20831),
    "07418": (41.228102, -74.477351),
    "07419": (41.159187, -74.57688),
    "07420": (41.028396, -74.304516),
    "07421": (41.151395, -74.357893),
    "07422": (41.187468, -74.458935),
    "07423": (40.998882, -74.096848),
    "07424": (40.883548, -74.214388),
    "07428": (41.206509, -74.538144),
    "07430": (41.053446, -74.172766),
    "07432": (40.994697, -74.142287),
    "07435": (41.053096, -74.439356),
    "07436": (41.023402, -74.238623),
    "07438": (41.099796, -74.443399),
    "07439": (41.078346, -74.594104),
    "07440": (40.948208, -74.295592),
    "07442": (40.999597, -74.297725),
    "07444": (41.008797, -74.402663),
    "07446": (41.059124, -74.133441),
    "07450": (40.982247, -74.11207),
    "07451": (40.948054, -74.083231),
    "07452": (40.960347, -74.125036),
    "07456": (41.110445, -74.293271),
    "07457": (40.992647, -74.312443),
    "07458": (41.044324, -74.098093),
    "07460": (41.138101, -74.561915),
    "07461": (41.242702, -74.596734),
    "07462": (41.189046, -74.51434),
    "07463": (41.041225, -74.128326),
    "07465": (41.065596, -74.297393),
    "07470": (40.948689, -74.241168),
    "07474": (41.011428, -74.304793),
    "07477": (41.011428, -74.304793),
    "07480": (41.047296, -74.294243),
    "07481": (40.998387, -74.165733),
    "07495": (40.948054, -74.083231),
    "07498": (40.948054, -74.083231),
    "07501": (40.915045, -74.174488),
    "07502": (40.918698, -74.194989),
    "07503": (40.898098, -74.151837),
    "07504": (40.911248, -74.144087),
    "07505": (40.916648, -74.174038),
    "07506": (40.954375, -74.161788),
    "07507": (41.011428, -74.304793),
    "07508": (40.951587, -74.186269),
    "07509": (41.011428, -74.304793),
    "07510": (41.011428, -74.304793),
    "07511": (41.011428, -74.304793),
    "07512": (40.901698, -74.22199),
    "07513": (40.907698, -74.146515),
    "07514": (40.928748, -74.143187),
    "07522": (40.923798, -74.179488),
    "07524": (40.932498, -74.156971),
    "07533": (41.011428, -74.304793),
    "07538": (41.011428, -74.304793),
    "07543": (41.011428, -74.304793),
    "07544": (41.011428, -74.304793),
    "07601": (40.913482, -74.001623),
    "07602": (40.948054, -74.083231),
    "07603": (40.874773, -74.030484),
    "07604": (40.862349, -74.075585),
    "07605": (40.863499, -73.987132),
    "07606": (40.857899, -74.048884),
    "07607": (40.90181, -74.061784),
    "07608": (40.863954, -74.055584),
    "07620": (40.958975, -73.927906),
    "07621": (40.923498, -73.998332),
    "07624": (40.970621, -73.960164),
    "07626": (40.972898, -74.098841),
    "07627": (40.954198, -73.957623),
    "07628": (40.955018, -73.989911),
    "07630": (40.973199, -74.021118),
    "07631": (40.889498, -73.971782),
    "07632": (40.883949, -73.952423),
    "07640": (40.991696, -73.98486),
    "07641": (40.963867, -73.99358),
    "07642": (41.008367, -74.048576),
    "07643": (40.925361, -74.076029),
    "07644": (40.878349, -74.081335),
    "07645": (41.054651, -74.045425),
    "07646": (40.932998, -74.017633),
    "07647": (41.008636, -73.93893),
    "07648": (40.992921, -73.949747),
    "07649": (40.955347, -74.026983),
    "07650": (40.939673, -74.010792),
    "07652": (40.944997, -74.068964),
    "07653": (40.948054, -74.083231),
    "07656": (41.032868, -74.042948),
    "07657": (40.83315, -74.004233),
    "07660": (40.853449, -74.021233),
    "07661": (40.926248, -74.038533),
    "07662": (40.905698, -74.079035),
    "07663": (40.942101, -74.094685),
    "07666": (40.914616, -73.986334),
    "07670": (40.919298, -73.960481),
    "07675": (41.011453, -74.021278),
    "07701": (40.358409, -74.068143),
    "07702": (40.325361, -74.107943),
    "07703": (40.314531, -74.041654),
    "07704": (40.358459, -74.036433),
    "07709": (40.302718, -74.24928),
    "07710": (40.302718, -74.24928),
    "07711": (40.237111, -74.008581),
    "07712": (40.250725, -74.048582),
    "07715": (40.302718, -74.24928),
    "07716": (40.404762, -74.05617),
    "07717": (40.191913, -74.015931),
    "07718": (40.417707, -74.088534),
    "07719": (40.257461, -74.112134),
    "07720": (40.202113, -74.012581),
    "07721": (40.38633, -74.115229),
    "07722": (40.302848, -74.160911),
    "07723": (40.250861, -74.004581),
    "07724": (40.30466, -74.073433),
    "07726": (40.2697, -74.265539),
    "07727": (40.285211, -74.161571),
    "07728": (40.236423, -74.306284),
    "07730": (40.423057, -74.176036),
    "07731": (40.258361, -74.19678),
    "07732": (40.401078, -74.000582),
    "07733": (40.376408, -74.170037),
    "07734": (40.438145, -74.127883),
    "07735": (40.438398, -74.188087),
    "07737": (40.409391, -74.059884),
    "07738": (40.346629, -74.125401),
    "07739": (40.382028, -74.168941),
    "07740": (40.345361, -74.1109),
    "07746": (40.351277, -74.141236),
    "07747": (40.407507, -74.233788),
    "07748": (40.400997, -74.144636),
    "07750": (40.277757, -74.194702),
    "07751": (40.319979, -74.214488),
    "07752": (40.402277, -74.027285),
    "07753": (40.209551, -74.071351),
    "07754": (40.302718, -74.24928),
    "07755": (40.261158, -74.021382),
    "07756": (40.278922, -74.123285),
    "07757": (40.31496, -74.019032),
    "07758": (40.429731, -74.106535),
    "07760": (40.370684, -74.008432),
    "07762": (40.176013, -74.031331),
    "07763": (40.302718, -74.24928),
    "07764": (40.283511, -74.018282),
    "07765": (40.302718, -74.24928),
    "07777": (40.302718, -74.24928),
    "07799": (40.302718, -74.24928),
    "07801": (40.917598, -74.546651),
    "07802": (40.867331, -74.578269),
    "07803": (40.877099, -74.584453),
    "07806": (40.867331, -74.578269),
    "07820": (40.869648, -74.849661),
    "07821": (41.092778, -74.718969),
    "07822": (41.161241, -74.6174),
    "07823": (40.819772, -75.030961),
    "07825": (40.942238, -74.937487),
    "07826": (41.188035, -74.824675),
    "07827": (41.255279, -74.644746),
    "07828": (40.880028, -74.75756),
    "07829": (40.84335, -74.985914),
    "07830": (40.717424, -74.813951),
    "07831": (40.739382, -74.944756),
    "07832": (40.893979, -75.029163),
    "07833": (40.906906, -75.075377),
    "07834": (40.881248, -74.489349),
    "07836": (40.850884, -74.701558),
    "07837": (41.12831, -74.678956),
    "07838": (40.888834, -74.937714),
    "07839": (41.12831, -74.678956),
    "07840": (40.868804, -74.844734),
    "07842": (40.867331, -74.578269),
    "07843": (40.936753, -74.659969),
    "07844": (40.919658, -74.984628),
    "07845": (40.867331, -74.578269),
    "07846": (40.968998, -74.873265),
    "07847": (40.876098, -74.695309),
    "07848": (41.128183, -74.731759),
    "07849": (40.950597, -74.612904),
    "07850": (40.906298, -74.664605),
    "07851": (41.178266, -74.89306),
    "07852": (40.863318, -74.721224),
    "07853": (40.806849, -74.794595),
    "07855": (41.12831, -74.678956),
    "07856": (40.874049, -74.73433),
    "07857": (40.897808, -74.700159),
    "07860": (41.069522, -74.806938),
    "07863": (40.820044, -74.941392),
    "07865": (40.810748, -74.87427),
    "07866": (40.960111, -74.501551),
    "07869": (40.837399, -74.586052),
    "07870": (40.810362, -74.819318),
    "07871": (41.040597, -74.718191),
    "07874": (40.930937, -74.713557),
    "07875": (41.043858, -74.871981),
    "07876": (40.855286, -74.655255),
    "07877": (41.10289, -74.850759),
    "07878": (40.871099, -74.477699),
    "07879": (40.955934, -74.788108),
    "07880": (40.864844, -74.897002),
    "07881": (41.125646, -74.917711),
    "07882": (40.747698, -75.008713),
    "07885": (40.935349, -74.577102),
    "07890": (41.12831, -74.678956),
    "07901": (40.71275, -74.361594),
    "07902": (40.665651, -74.299692),
    "07920": (40.682651, -74.573001),
    "07921": (40.659151, -74.676788),
    "07922": (40.675451, -74.422196),
    "07924": (40.72575, -74.593552),
    "07926": (40.800353, -74.571785),
    "07927": (40.820799, -74.456198),
    "07928": (40.759477, -74.496806),
    "07930": (40.782111, -74.683861),
    "07931": (40.699572, -74.653603),
    "07932": (40.7735, -74.397996),
    "07933": (40.689339, -74.472198),
    "07934": (40.715359, -74.682767),
    "07935": (40.739782, -74.448747),
    "07936": (40.816349, -74.367747),
    "07938": (40.655399, -74.586151),
    "07939": (40.566553, -74.599801),
    "07940": (40.7582, -74.423019),
    "07945": (40.786699, -74.5938),
    "07946": (40.678701, -74.505399),
    "07950": (40.843399, -74.540341),
    "07960": (40.77165, -74.506256),
    "07961": (40.77975, -74.442797),
    "07962": (40.867331, -74.578269),
    "07963": (40.867331, -74.578269),
    "07970": (40.805549, -74.573832),
    "07974": (40.697851, -74.405595),
    "07976": (40.739599, -74.483413),
    "07977": (40.707876, -74.654131),
    "07978": (40.642491, -74.639597),
    "07979": (40.708241, -74.748389),
    "07980": (40.69835, -74.450197),
    "07981": (40.823899, -74.419097),
    "07983": (40.867331, -74.578269),
    "07999": (40.867331, -74.578269),
    "08001": (39.559077, -75.350573),
    "08002": (39.908663, -75.010307),
    "08003": (39.889763, -74.972761),
    "08004": (39.760048, -74.866534),
    "08005": (39.753858, -74.293989),
    "08006": (39.751214, -74.114631),
    "08007": (39.863813, -75.053765),
    "08008": (39.641062, -74.192228),
    "08009": (39.761231, -74.92701),
    "08010": (40.049948, -74.917061),
    "08011": (39.976041, -74.711429),
    "08012": (39.790131, -75.036652),
    "08014": (39.802163, -75.339215),
    "08015": (39.924179, -74.670408),
    "08016": (40.089874, -74.751146),
    "08018": (39.80237, -74.938259),
    "08019": (39.749506, -74.558941),
    "08020": (39.796706, -75.218852),
    "08021": (39.80364, -75.005762),
    "08022": (40.049355, -74.702475),
    "08023": (39.681545, -75.493433),
    "08025": (39.701526, -75.162903),
    "08026": (39.833114, -74.967496),
    "08027": (39.771133, -75.272137),
    "08028": (39.696661, -75.127183),
    "08029": (39.837113, -75.062315),
    "08030": (39.890413, -75.112619),
    "08031": (39.805543, -75.067729),
    "08032": (39.77875, -75.060114),
    "08033": (39.876313, -75.033414),
    "08034": (39.899962, -75.035015),
    "08035": (39.879163, -75.065666),
    "08036": (39.987212, -74.829308),
    "08037": (39.563616, -74.711081),
    "08038": (39.569805, -75.312703),
    "08039": (39.693067, -75.271114),
    "08041": (40.044129, -74.679579),
    "08042": (40.012273, -74.66464),
    "08043": (39.839156, -74.965057),
    "08045": (39.868113, -75.032114),
    "08046": (40.013737, -74.805773),
    "08048": (39.962299, -74.80007),
    "08049": (39.854363, -75.036214),
    "08050": (39.702978, -74.257677),
    "08051": (39.751571, -75.212842),
    "08052": (39.951212, -74.992163),
    "08053": (39.892263, -74.94075),
    "08054": (39.955912, -74.91731),
    "08055": (39.874549, -74.762083),
    "08056": (39.787913, -75.246687),
    "08057": (40.054255, -74.840115),
    "08059": (39.886463, -75.094068),
    "08060": (40.044956, -74.801869),
    "08061": (39.808643000000004, -75.212943),
    "08062": (39.715857, -75.235017),
    "08063": (39.779654, -75.218413),
    "08064": (39.862433, -74.725079),
    "08065": (40.031291, -74.861971),
    "08066": (39.815690000000004, -75.238849),
    "08067": (39.733769, -75.408412),
    "08068": (39.966394, -74.709185),
    "08069": (39.619937, -75.288423),
    "08070": (39.637683, -75.512699),
    "08071": (39.734928, -75.136809),
    "08072": (39.541055, -75.383689),
    "08073": (39.862433, -74.725079),
    "08074": (39.720622, -75.168141),
    "08075": (40.063293, -74.853307),
    "08076": (39.862433, -74.725079),
    "08077": (39.999211, -74.90871),
    "08078": (39.850163, -75.070672),
    "08079": (39.587729, -75.439362),
    "08080": (39.75521, -75.201593),
    "08081": (39.747558, -74.970462),
    "08083": (39.844063, -75.022163),
    "08084": (39.829763, -75.012012),
    "08085": (39.75274, -75.318049),
    "08086": (39.838721, -75.24861),
    "08087": (39.671687, -74.288092),
    "08088": (39.860351, -74.669346),
    "08089": (39.723037, -74.836939),
    "08090": (39.798313, -75.148071),
    "08091": (39.734923, -74.950993),
    "08092": (39.656391, -74.295555),
    "08093": (39.85781, -75.13732),
    "08094": (39.725538, -75.058082),
    "08095": (39.654885, -74.868531),
    "08096": (39.822013, -75.129669),
    "08097": (39.762971, -75.19787),
    "08098": (39.586, -75.379897),
    "08099": (39.779179, -74.962071),
    "08101": (39.80237, -74.938259),
    "08102": (39.950912, -75.118869),
    "08103": (39.933174, -75.108519),
    "08104": (39.916612, -75.109169),
    "08105": (39.920162, -75.084667),
    "08106": (39.828349, -74.994647),
    "08107": (39.872001, -75.053114),
    "08108": (39.834003, -74.991268),
    "08109": (39.950312, -75.059916),
    "08110": (39.839405, -74.945624),
    "08201": (39.48909, -74.680323),
    "08202": (39.112027, -74.731427),
    "08203": (39.370172, -74.49401),
    "08204": (39.110337, -74.767939),
    "08210": (39.137841, -74.78056),
    "08212": (38.937168, -74.965385),
    "08213": (39.509208, -74.608557),
    "08214": (39.056521, -74.816619),
    "08215": (39.530539, -74.638341),
    "08217": (39.573741, -74.719989),
    "08218": (39.056521, -74.816619),
    "08219": (39.056521, -74.816619),
    "08220": (39.509208, -74.608557),
    "08221": (39.427786, -74.622112),
    "08223": (39.13952, -74.73038),
    "08224": (39.595197, -74.435683),
    "08225": (39.421922, -74.572227),
    "08226": (39.24853, -74.604409),
    "08230": (39.205183, -74.778293),
    "08231": (39.509208, -74.608557),
    "08232": (39.470869, -74.686004),
    "08234": (39.374067, -74.611764),
    "08240": (39.487717, -74.554334),
    "08241": (39.521785, -74.694414),
    "08242": (39.017283, -74.883671),
    "08243": (39.154028, -74.700502),
    "08244": (39.425655, -74.664422),
    "08245": (39.09998, -74.848733),
    "08246": (39.056521, -74.816619),
    "08247": (39.047882, -74.77505),
    "08248": (39.192018, -74.661977),
    "08250": (39.056521, -74.816619),
    "08251": (39.140921, -74.851181),
    "08252": (39.042124, -74.861792),
    "08260": (39.067777, -74.77674),
    "08270": (39.158165, -74.786886),
    "08302": (39.3762, -75.1617),
    "08310": (39.523712, -74.899762),
    "08311": (39.330611, -75.117761),
    "08312": (39.653531, -75.078625),
    "08313": (39.529261, -75.224865),
    "08314": (39.358151, -74.977352),
    "08315": (39.273214, -75.095025),
    "08316": (39.267898, -74.979118),
    "08317": (39.425858, -74.826057),
    "08318": (39.548074, -75.198368),
    "08319": (39.376144, -74.805412),
    "08320": (39.379906, -75.221681),
    "08321": (39.273034, -75.19137),
    "08322": (39.59823, -75.035749),
    "08323": (39.405498, -75.320881),
    "08324": (39.224047, -74.994184),
    "08326": (39.533843, -74.934493),
    "08327": (39.387948, -75.007418),
    "08328": (39.58101, -75.055482),
    "08329": (39.285278, -74.998319),
    "08330": (39.47204, -74.71588),
    "08332": (39.370401, -75.04282),
    "08340": (39.447855, -74.869885),
    "08341": (39.530779, -74.940036),
    "08342": (39.50208, -74.833469),
    "08343": (39.641089, -75.144475),
    "08344": (39.565465, -75.014084),
    "08345": (39.304244, -75.109132),
    "08346": (39.557607, -74.870807),
    "08347": (39.499765, -75.082022),
    "08348": (39.313114, -74.980668),
    "08349": (39.283259, -75.098448),
    "08350": (39.491351, -74.875543),
    "08352": (39.469515, -75.146176),
    "08353": (39.42165, -75.207667),
    "08360": (39.392671, -75.025676),
    "08361": (39.465465, -74.965279),
    "08362": (39.271264, -75.027671),
    "08401": (39.486848, -74.643014),
    "08402": (39.442068, -74.666123),
    "08403": (39.324265, -74.513497),
    "08404": (39.509208, -74.608557),
    "08405": (39.509208, -74.608557),
    "08406": (39.414646, -74.66415),
    "08501": (40.149712, -74.539598),
    "08502": (40.461504, -74.648302),
    "08504": (40.425369, -74.668753),
    "08505": (40.101535, -74.724711),
    "08510": (40.193311, -74.442803),
    "08511": (40.049551, -74.557215),
    "08512": (40.323116, -74.516597),
    "08514": (40.139913, -74.465018),
    "08515": (40.147555, -74.661474),
    "08518": (40.12486, -74.738863),
    "08520": (40.281558, -74.572449),
    "08525": (40.389675, -74.783956),
    "08526": (40.162275, -74.475936),
    "08527": (40.105164, -74.352814),
    "08528": (40.382756, -74.609551),
    "08530": (40.37936, -74.901535),
    "08533": (40.08294, -74.498741),
    "08534": (40.32863, -74.813557),
    "08535": (40.22586, -74.452293),
    "08536": (40.342197, -74.582062),
    "08540": (40.343625, -74.693953),
    "08541": (40.280531, -74.712018),
    "08542": (40.350456, -74.658852),
    "08543": (40.280531, -74.712018),
    "08544": (40.349206, -74.652811),
    "08550": (40.266858, -74.651101),
    "08551": (40.445602, -74.840322),
    "08553": (40.412705, -74.632256),
    "08554": (40.071829, -74.711814),
    "08555": (40.22136, -74.474745),
    "08556": (40.419965, -74.988619),
    "08557": (40.563654, -74.949409),
    "08558": (40.434255, -74.708525),
    "08559": (40.436413, -74.970597),
    "08560": (40.311826, -74.863858),
    "08561": (40.242313, -74.578709),
    "08562": (40.0751, -74.608402),
    "08570": (40.430006, -74.417344),
    "08601": (40.280531, -74.712018),
    "08602": (40.280531, -74.712018),
    "08603": (40.280531, -74.712018),
    "08604": (40.280531, -74.712018),
    "08605": (40.280531, -74.712018),
    "08606": (40.280531, -74.712018),
    "08607": (40.280531, -74.712018),
    "08608": (40.220108, -74.764055),
    "08609": (40.224808, -74.741004),
    "08610": (40.201609, -74.704953),
    "08611": (40.196658, -74.741554),
    "08618": (40.223608, -74.732504),
    "08619": (40.241808, -74.696151),
    "08620": (40.194664, -74.639852),
    "08625": (40.280531, -74.712018),
    "08628": (40.265457, -74.816757),
    "08629": (40.219558, -74.733404),
    "08638": (40.232908, -74.716954),
    "08640": (40.009789, -74.605198),
    "08641": (39.968787, -74.62405),
    "08645": (40.280531, -74.712018),
    "08646": (40.280531, -74.712018),
    "08647": (40.280531, -74.712018),
    "08648": (40.279457, -74.69118),
    "08650": (40.280531, -74.712018),
    "08666": (40.280531, -74.712018),
    "08677": (40.280531, -74.712018),
    "08690": (40.233577, -74.657602),
    "08691": (40.219738, -74.593949),
    "08695": (40.280531, -74.712018),
    "08701": (39.94517, -74.149784),
    "08720": (40.138878, -74.11221),
    "08721": (39.966604, -74.300023),
    "08722": (39.927521, -74.198585),
    "08723": (39.940021, -74.122989),
    "08724": (39.938047, -74.17109),
    "08730": (40.107614, -74.065081),
    "08731": (39.876031, -74.230522),
    "08732": (39.983267, -74.128482),
    "08733": (39.992317, -74.28224),
    "08734": (39.863489, -74.168217),
    "08735": (39.980917, -74.07203),
    "08736": (40.121514, -74.069963),
    "08738": (40.029916, -74.05688),
    "08739": (40.000759, -74.24928),
    "08740": (39.926628, -74.133332),
    "08741": (40.003246, -74.109626),
    "08742": (39.954807, -74.157056),
    "08750": (40.161392, -74.043772),
    "31295": (32.810189, -83.569001),
    "08751": (39.945991, -74.181649),
    "08752": (39.805832, -74.145694),
    "08753": (39.958851, -74.215336),
    "08754": (40.000759, -74.24928),
    "08755": (40.000696, -74.256821),
    "08756": (39.787966, -74.191058),
    "08757": (39.943064, -74.264068),
    "08758": (39.787943, -74.246662),
    "08759": (39.945797999999996, -74.29782),
    "08801": (40.631008, -74.890685),
    "08802": (40.695034, -75.028089),
    "08803": (40.563654, -74.949409),
    "08804": (40.646294, -75.092934),
    "08805": (40.575402, -74.538249),
    "08807": (40.598702, -74.607518),
    "08808": (40.737213, -75.046926),
    "08809": (40.5305, -74.845574),
    "08810": (40.372306, -74.494889),
    "08812": (40.589702, -74.463947),
    "08816": (40.427697, -74.421695),
    "08817": (40.519753, -74.393444),
    "08818": (40.430006, -74.417344),
    "08820": (40.576611, -74.362616),
    "08821": (40.566553, -74.599801),
    "08822": (40.50786, -74.863283),
    "08823": (40.440604, -74.560249),
    "08824": (40.422955, -74.549761),
    "08825": (40.58119, -75.012655),
    "08826": (40.578191, -74.904575),
    "08827": (40.6667, -74.964692),
    "08828": (40.37554, -74.421644),
    "08829": (40.668163, -74.889823),
    "08830": (40.569211, -74.315042),
    "08831": (40.343757, -74.42887),
    "08832": (40.517559, -74.306961),
    "08833": (40.635369, -74.829976),
    "08834": (40.563654, -74.949409),
    "08835": (40.541053, -74.589225),
    "08836": (40.604352, -74.5538),
    "08837": (40.527054, -74.350393),
    "08840": (40.472224, -74.45194),
    "08846": (40.575202, -74.499398),
    "08848": (40.664749, -74.970542),
    "08850": (40.448255, -74.444395),
    "08852": (40.386942, -74.555799),
    "08853": (40.492604, -74.726555),
    "08854": (40.552925, -74.457746),
    "08855": (40.430006, -74.417344),
    "08857": (40.407319, -74.314319),
    "08858": (40.691798, -74.752537),
    "08859": (40.459205, -74.306956),
    "08861": (40.520654, -74.279144),
    "08862": (40.430006, -74.417344),
    "08863": (40.53139, -74.31525),
    "08865": (40.765309, -74.98743),
    "08867": (40.585926, -74.976982),
    "08868": (40.565493000000004, -74.938931),
    "08869": (40.573802, -74.642649),
    "08870": (40.563654, -74.949409),
    "08871": (40.430006, -74.417344),
    "08872": (40.453358, -74.334192),
    "08873": (40.491002, -74.523648),
    "08875": (40.580918, -74.711731),
    "08876": (40.560314, -74.66165),
    "08877": (40.430006, -74.417344),
    "08878": (40.436865, -74.250942),
    "08879": (40.46397, -74.274168),
    "08880": (40.552253, -74.531149),
    "08882": (40.445905, -74.381768),
    "08884": (40.385707, -74.393249),
    "08885": (40.576372, -74.831105),
    "08886": (40.717349, -75.072957),
    "08887": (40.52057, -74.79463200000001),
    "08888": (40.619412, -74.740597),
    "08889": (40.615577, -74.772376),
    "08890": (40.536069, -74.578872),
    "08896": (40.566553, -74.599801),
    "08899": (40.520254, -74.420545),
    "08901": (40.486754, -74.444395),
    "08902": (40.437705, -74.488547),
    "08903": (40.513854, -74.445098),
    "08904": (40.499866, -74.428095),
    "08905": (40.430006, -74.417344),
    "08906": (40.430006, -74.417344),
    "08922": (40.430006, -74.417344),
    "08933": (40.430006, -74.417344),
    "08988": (40.430006, -74.417344),
    "08989": (40.430006, -74.417344),
    "10001": (40.750422, -73.996328),
    "10002": (40.718758, -73.986427),
    "10003": (40.730223, -73.988564),
    "10004": (40.696355, -74.025276),
    "10005": (40.706903, -74.008654),
    "10006": (40.708834, -74.013168),
    "10007": (40.713941, -74.007401),
    "10008": (40.780751, -73.977182),
    "10009": (40.72775, -73.980396),
    "10010": (40.739024, -73.983542),
    "10011": (40.740916, -73.999769),
    "10012": (40.729124, -73.991582),
    "10013": (40.722105, -74.003497),
    "10014": (40.738088, -74.005095),
    "10015": (40.780751, -73.977182),
    "10016": (40.745527, -73.978449),
    "10017": (40.752955, -73.973196),
    "10018": (40.755332, -73.993172),
    "10019": (40.765926, -73.985443),
    "10020": (40.735449, -73.996788),
    "10021": (40.768823, -73.960257),
    "10022": (40.758775, -73.967842),
    "10023": (40.776765, -73.982213),
    "10024": (40.80813, -73.965653),
    "10025": (40.798664, -73.967778),
    "10026": (40.802918, -73.953107),
    "10027": (40.812242, -73.9532),
    "10028": (40.776629, -73.953914),
    "10029": (40.791884, -73.943517),
    "10030": (40.818474, -73.94329),
    "10031": (40.823438, -73.949039),
    "10032": (40.839137, -73.942181),
    "10033": (40.851293, -73.934764),
    "10034": (40.863194, -73.926959),
    "10035": (40.801913, -73.9347),
    "10036": (40.75953, -73.989847),
    "10037": (40.813884, -73.938498),
    "10038": (40.710223, -74.003368),
    "10039": (40.826736, -73.939398),
    "10040": (40.858692, -73.930999),
    "10041": (40.703801, -74.009814),
    "10043": (40.780751, -73.977182),
    "10044": (40.761812, -73.950521),
    "10045": (40.70859, -74.008687),
    "10046": (40.780751, -73.977182),
    "10047": (40.780751, -73.977182),
    "10048": (40.71254, -74.013289),
    "10055": (40.780751, -73.977182),
    "10060": (40.780751, -73.977182),
    "10069": (40.777952, -73.988381),
    "10072": (40.780751, -73.977182),
    "10079": (40.780751, -73.977182),
    "10080": (40.780751, -73.977182),
    "10081": (40.780751, -73.977182),
    "10082": (40.780751, -73.977182),
    "10087": (40.780751, -73.977182),
    "10090": (40.780751, -73.977182),
    "10094": (40.780751, -73.977182),
    "10095": (40.748181, -73.988421),
    "10096": (40.780751, -73.977182),
    "10098": (40.748181, -73.988421),
    "10099": (40.780751, -73.977182),
    "10101": (40.780751, -73.977182),
    "10102": (40.780751, -73.977182),
    "10103": (40.760264, -73.97624),
    "10104": (40.760943, -73.979908),
    "10105": (40.762808, -73.978534),
    "10106": (40.765243, -73.980438),
    "10107": (40.766429, -73.982728),
    "10108": (40.780751, -73.977182),
    "10109": (40.780751, -73.977182),
    "10110": (40.753987, -73.980811),
    "10111": (40.759224, -73.977762),
    "10112": (40.759287, -73.979808),
    "10113": (40.780751, -73.977182),
    "10114": (40.780751, -73.977182),
    "10115": (40.811115, -73.96423),
    "10116": (40.780751, -73.977182),
    "10117": (40.780751, -73.977182),
    "10118": (40.748998, -73.986467),
    "10119": (40.780751, -73.977182),
    "10120": (40.750629, -73.989426),
    "10121": (40.74964, -73.991889),
    "10122": (40.751757, -73.992171),
    "10123": (40.751489, -73.990537),
    "10124": (40.780751, -73.977182),
    "10125": (40.780751, -73.977182),
    "10126": (40.780751, -73.977182),
    "10128": (40.780989, -73.95158),
    "10129": (40.780751, -73.977182),
    "10130": (40.780751, -73.977182),
    "10131": (40.780751, -73.977182),
    "10132": (40.780751, -73.977182),
    "10133": (40.780751, -73.977182),
    "10138": (40.780751, -73.977182),
    "10149": (40.780751, -73.977182),
    "10150": (40.780751, -73.977182),
    "10151": (40.763419, -73.973971),
    "10152": (40.758937, -73.97302),
    "10153": (40.764068, -73.97348),
    "10154": (40.758304, -73.973468),
    "10155": (40.761104, -73.968036),
    "10156": (40.780751, -73.977182),
    "10157": (40.780751, -73.977182),
    "10158": (40.749435, -73.9758),
    "10159": (40.780751, -73.977182),
    "10160": (40.780751, -73.977182),
    "10161": (40.780751, -73.977182),
    "10162": (40.769945, -73.951117),
    "10163": (40.780751, -73.977182),
    "10164": (40.780751, -73.977182),
    "10165": (40.752351, -73.979132),
    "10166": (40.754591, -73.976238),
    "10167": (40.754858, -73.97497),
    "10168": (40.751933, -73.976794),
    "10169": (40.75474, -73.976595),
    "10170": (40.752621, -73.97548),
    "10171": (40.756447, -73.974821),
    "10172": (40.755839, -73.975279),
    "10173": (40.754305, -73.979564),
    "10174": (40.751656, -73.97516),
    "10175": (40.754305, -73.979782),
    "10176": (40.75557, -73.978877),
    "10177": (40.755332, -73.976082),
    "10178": (40.751378, -73.978507),
    "10179": (40.780751, -73.977182),
    "10184": (40.780751, -73.977182),
    "10185": (40.780751, -73.977182),
    "10196": (40.780751, -73.977182),
    "10197": (40.780751, -73.977182),
    "10199": (40.750308, -74.00058),
    "10203": (40.780751, -73.977182),
    "10211": (40.780751, -73.977182),
    "10212": (40.780751, -73.977182),
    "10213": (40.780751, -73.977182),
    "10242": (40.780751, -73.977182),
    "10249": (40.780751, -73.977182),
    "10256": (40.780751, -73.977182),
    "10257": (40.780751, -73.977182),
    "10258": (40.780751, -73.977182),
    "10259": (40.780751, -73.977182),
    "10260": (40.780751, -73.977182),
    "10261": (40.780751, -73.977182),
    "10265": (40.780751, -73.977182),
    "10268": (40.780751, -73.977182),
    "10269": (40.780751, -73.977182),
    "10270": (40.706925, -74.008154),
    "10271": (40.708918, -74.011066),
    "10272": (40.780751, -73.977182),
    "10273": (40.780751, -73.977182),
    "10274": (40.780751, -73.977182),
    "10275": (40.780751, -73.977182),
    "10276": (40.780751, -73.977182),
    "10277": (40.780751, -73.977182),
    "10278": (40.780751, -73.977182),
    "10279": (40.712697, -74.007812),
    "10280": (40.708857, -74.016217),
    "10281": (40.714643, -74.014958),
    "10282": (40.716597, -74.01459),
    "10285": (40.71533, -74.016306),
    "10286": (40.714231, -74.011895),
    "10292": (40.780751, -73.977182),
    "10301": (40.623632, -74.093323),
    "10302": (40.628923, -74.137947),
    "10303": (40.631697, -74.165016),
    "10304": (40.608389, -74.093684),
    "10305": (40.596828, -74.077837),
    "10306": (40.559668, -74.12241),
    "10307": (40.510723, -74.24194),
    "10308": (40.551191, -74.148893),
    "10309": (40.531767, -74.218779),
    "10310": (40.632943, -74.118669),
    "10311": (40.605245, -74.179485),
    "10312": (40.545163, -74.174692),
    "10313": (40.564393, -74.146836),
    "10314": (40.591006, -74.150741),
    "10451": (40.819329, -73.920355),
    "10452": (40.838729, -73.921605),
    "10453": (40.852728, -73.912455),
    "10454": (40.807129, -73.918405),
    "10455": (40.815029, -73.908355),
    "10456": (40.830529, -73.908655),
    "10457": (40.846129, -73.898255),
    "10458": (40.864728, -73.889855),
    "10459": (40.825629, -73.893605),
    "10460": (40.841829, -73.879004),
    "10461": (40.845279, -73.843103),
    "10462": (40.842729, -73.854703),
    "10463": (40.879528, -73.904355),
    "10464": (40.863028, -73.799802),
    "10465": (40.826879, -73.825153),
    "10466": (40.859878, -73.841003),
    "10467": (40.876328, -73.870404),
    "10468": (40.870978, -73.900505),
    "10469": (40.869978, -73.844903),
    "10470": (40.87143, -73.862303),
    "10471": (40.899178, -73.898677),
    "10472": (40.829529, -73.865704),
    "10473": (40.816229, -73.860304),
    "10474": (40.813929, -73.884104),
    "10475": (40.874878, -73.827653),
    "10499": (40.851549, -73.840908),
    "10501": (41.293169, -73.759033),
    "10502": (41.015096, -73.841478),
    "10503": (41.025947, -73.87185),
    "10504": (41.075185, -73.761247),
    "10505": (41.33431, -73.749244),
    "10506": (41.123741, -73.718481),
    "10507": (41.229037, -73.697998),
    "10509": (41.415979, -73.725197),
    "10510": (41.05978, -73.829802),
    "10511": (41.259961, -73.943495),
    "10512": (41.429571, -73.777626),
    "10514": (41.078957, -73.775547),
    "10516": (41.455213, -73.812479),
    "10517": (41.300561, -73.861217),
    "10518": (41.269896, -73.612074),
    "10519": (41.347727, -73.661014),
    "10520": (41.122622, -73.867258),
    "10521": (41.234256, -73.926165),
    "10522": (41.011147, -73.865178),
    "10523": (41.058732, -73.836784),
    "10524": (41.375016, -73.931844),
    "31296": (32.806707, -83.691315),
    "10526": (41.300361, -73.647891),
    "10527": (41.323246, -73.75791100000001),
    "10528": (40.979118, -73.723036),
    "10530": (41.019105, -73.812077),
    "10532": (41.013742, -73.835421),
    "10533": (41.079553, -73.856051),
    "10535": (41.338568, -73.735548),
    "10536": (41.271614, -73.687334),
    "10537": (41.394819, -73.718016),
    "10538": (41.090197, -73.755284),
    "10540": (41.333398, -73.724257),
    "10541": (41.412395, -73.752059),
    "10542": (41.372581, -73.760132),
    "10543": (40.949199, -73.738779),
    "10545": (41.119008, -73.732996),
    "10546": (41.201373, -73.796456),
    "10547": (41.281975, -73.797555),
    "10548": (41.25126, -73.942877),
    "10549": (41.197329, -73.72286),
    "10550": (40.909838, -73.83389),
    "10551": (41.119008, -73.732996),
    "10552": (41.011586, -73.798391),
    "10553": (40.909449, -73.822109),
    "10557": (41.119008, -73.732996),
    "10558": (41.119008, -73.732996),
    "10559": (41.119008, -73.732996),
    "10560": (41.331814, -73.608451),
    "10562": (41.109701, -73.827995),
    "10566": (41.28383, -73.893116),
    "10567": (41.284044, -73.893116),
    "10570": (41.131069, -73.792214),
    "10571": (41.119008, -73.732996),
    "10572": (41.119008, -73.732996),
    "10573": (41.022193, -73.679799),
    "10576": (41.208519, -73.568126),
    "10577": (41.002757, -73.751025),
    "10578": (41.315779, -73.645145),
    "10579": (41.399262, -73.776871),
    "10580": (40.955237, -73.744725),
    "10581": (41.119008, -73.732996),
    "10583": (40.992686, -73.799476),
    "10587": (41.328737, -73.742268),
    "10588": (41.330892, -73.823549),
    "10589": (41.326544, -73.693685),
    "10590": (41.254331, -73.542714),
    "10591": (41.089703, -73.844034),
    "10592": (41.119008, -73.732996),
    "10594": (41.117214, -73.771469),
    "10595": (41.090218, -73.784768),
    "10596": (41.254823, -73.958727),
    "10597": (41.297198, -73.597979),
    "10598": (41.287329, -73.790284),
    "10601": (41.031397, -73.769626),
    "10602": (41.119008, -73.732996),
    "10603": (41.048958, -73.783036),
    "10604": (41.156215, -73.805176),
    "10605": (41.007597, -73.748575),
    "10606": (41.021686, -73.766044),
    "10607": (41.039235, -73.807293),
    "10610": (41.119008, -73.732996),
    "10625": (41.119008, -73.732996),
    "10629": (41.119008, -73.732996),
    "10633": (41.119008, -73.732996),
    "10650": (41.013696, -73.705975),
    "10701": (40.946107, -73.866926),
    "10702": (41.119008, -73.732996),
    "10703": (40.959347, -73.881329),
    "10704": (40.922938, -73.861941),
    "10705": (40.926538, -73.872529),
    "10706": (40.987797, -73.862969),
    "10707": (40.960498, -73.816127),
    "10708": (40.938448, -73.829978),
    "10709": (40.956098, -73.812177),
    "10710": (40.967946, -73.84736),
    "10801": (41.035123, -73.801401),
    "10802": (40.948274, -73.795361),
    "10803": (40.904538, -73.806277),
    "10804": (40.951498, -73.786526),
    "10805": (40.899599, -73.780976),
    "10901": (41.137295, -74.105737),
    "10910": (41.386195, -74.125718),
    "10911": (41.160945, -74.060826),
    "10912": (41.387822, -74.354699),
    "10913": (41.068782, -73.957282),
    "10914": (41.464867, -74.255646),
    "10915": (41.555634, -74.328805),
    "10916": (41.443168, -74.258172),
    "10917": (41.329223999999996, -74.121764),
    "10918": (41.414188, -74.348151),
    "10919": (41.53156, -74.370569),
    "10920": (41.152545, -73.936305),
    "10921": (41.319956, -74.36699),
    "10922": (41.334557, -73.99175),
    "10923": (41.203984, -74.003167),
    "10924": (41.357428, -74.210608),
    "10925": (41.297325, -74.26484),
    "10926": (41.300486, -74.124934),
    "10927": (41.191694, -73.964933),
    "10928": (41.398883, -74.255846),
    "10930": (41.372924, -74.245108),
    "10931": (41.120195, -74.170639),
    "10932": (41.485227, -74.484249),
    "10933": (41.365286, -74.510918),
    "10940": (41.390109, -74.340401),
    "10941": (41.370586, -74.354017),
    "10943": (41.387822, -74.354699),
    "10950": (41.343092, -74.316824),
    "10952": (41.118595, -74.084536),
    "10953": (41.409284, -74.083045),
    "10954": (41.097716, -74.010934),
    "10956": (41.149494, -73.98827),
    "10958": (41.375634, -74.43375),
    "10959": (41.387822, -74.354699),
    "10960": (41.080474, -73.930179),
    "10962": (41.057496, -73.953181),
    "10963": (41.401702, -74.536702),
    "10964": (41.008947, -73.92093),
    "10965": (41.061476, -74.018283),
    "10968": (41.040946, -73.918205),
    "10969": (41.325856, -74.488954),
    "10970": (41.18416, -74.045358),
    "10973": (41.386099, -74.480395),
    "10974": (41.157473, -74.200784),
    "10975": (41.332379, -74.113857),
    "10976": (41.083784, -74.061335),
    "10977": (41.115833, -74.047384),
    "10979": (41.182344, -74.318354),
    "10980": (41.235675, -74.028095),
    "10981": (41.323172, -74.288565),
    "10982": (41.160945, -74.060826),
    "10983": (41.027646, -73.948404),
    "10984": (41.206898, -74.015411),
    "10985": (41.574986, -74.322534),
    "10986": (41.265953, -73.982912),
    "10987": (41.28142, -74.204924),
    "10988": (41.314931, -74.550346),
    "10989": (41.122868, -73.934844),
    "10990": (41.350681, -74.32116),
    "10992": (41.407974, -74.345433),
    "10993": (41.208044, -73.975833),
    "10994": (41.100622, -73.970482),
    "10995": (41.160945, -74.060826),
    "10996": (41.36471, -73.998375),
    "10997": (41.387822, -74.354699),
    "10998": (41.331044, -74.456673),
    "11001": (40.720051, -73.706783),
    "11002": (40.754757, -73.601772),
    "11003": (40.697558, -73.704946),
    "11004": (40.745263, -73.711159),
    "11005": (40.757057, -73.7182),
    "11010": (40.700101, -73.674074),
    "11020": (40.754757, -73.601772),
    "11021": (40.754757, -73.601772),
    "11022": (40.754757, -73.601772),
    "11023": (40.754757, -73.601772),
    "11024": (40.754757, -73.601772),
    "11025": (40.754757, -73.601772),
    "11026": (40.754757, -73.601772),
    "11027": (40.754757, -73.601772),
    "11030": (40.754757, -73.601772),
    "11040": (40.729351, -73.682824),
    "11041": (40.754757, -73.601772),
    "11042": (40.754757, -73.601772),
    "11043": (40.754757, -73.601772),
    "11044": (40.754757, -73.601772),
    "11050": (40.754757, -73.601772),
    "11051": (40.754757, -73.601772),
    "11052": (40.754757, -73.601772),
    "11053": (40.754757, -73.601772),
    "11054": (40.754757, -73.601772),
    "11055": (40.754757, -73.601772),
    "11096": (40.620492, -73.747376),
    "11099": (40.754757, -73.601772),
    "11101": (40.744622, -73.934502),
    "11102": (40.770808, -73.92516),
    "11103": (40.761884, -73.911642),
    "11104": (40.742794, -73.918216),
    "11105": (40.776468, -73.908761),
    "11106": (40.760601, -73.930984),
    "11109": (40.651378, -73.870779),
    "11120": (40.651378, -73.870779),
    "11201": (40.694481, -73.989319),
    "11202": (40.645099, -73.945032),
    "11203": (40.663551, -73.949389),
    "11204": (40.603838, -73.987635),
    "11205": (40.682507, -73.936274),
    "11206": (40.700453, -73.949255),
    "11207": (40.670925, -73.895216),
    "11208": (40.662195, -73.912945),
    "11209": (40.622459, -74.028749),
    "11210": (40.625468, -73.945521),
    "11211": (40.707789, -73.945344),
    "11212": (40.663845, -73.916406),
    "11213": (40.67317, -73.936055),
    "11214": (40.599523, -73.998594),
    "11215": (40.664322, -73.984132),
    "11216": (40.680474, -73.946829),
    "11217": (40.684948, -73.980613),
    "11218": (40.64434, -73.978411),
    "11219": (40.633157, -73.996953),
    "11220": (40.634873, -74.016905),
    "11221": (40.700418, -73.936764),
    "11222": (40.728388, -73.945754),
    "11223": (40.633801, -73.954405),
    "11224": (40.635444, -73.968536),
    "11225": (40.661096, -73.952295),
    "11226": (40.644962, -73.956304),
    "11228": (40.624552, -73.989853),
    "11229": (40.600988, -73.939998),
    "11230": (40.62251, -73.966109),
    "11231": (40.676521, -74.003322),
    "11232": (40.671186, -73.971708),
    "11233": (40.682088, -73.920638),
    "11234": (40.610947, -73.913892),
    "11235": (40.584455, -73.948402),
    "11236": (40.65701, -73.91581),
    "11237": (40.702192, -73.91807),
    "11238": (40.680593, -73.963928),
    "11239": (40.649207, -73.876754),
    "11240": (40.645099, -73.945032),
    "11241": (40.645099, -73.945032),
    "11242": (40.645099, -73.945032),
    "11243": (40.645099, -73.945032),
    "11244": (40.645099, -73.945032),
    "11245": (40.645099, -73.945032),
    "11247": (40.645099, -73.945032),
    "11248": (40.645099, -73.945032),
    "11249": (40.645099, -73.945032),
    "11251": (40.645099, -73.945032),
    "11252": (40.645099, -73.945032),
    "11254": (40.645099, -73.945032),
    "11255": (40.645099, -73.945032),
    "11256": (40.645099, -73.945032),
    "11351": (40.781703, -73.831698),
    "11352": (40.651378, -73.870779),
    "11354": (40.766382, -73.82619),
    "11355": (40.750317, -73.813903),
    "11356": (40.784369, -73.843641),
    "11357": (40.786173, -73.819069),
    "11358": (40.760426, -73.795788),
    "11359": (40.79278, -73.776701),
    "11360": (40.756745, -73.803301),
    "11361": (40.764438, -73.773026),
    "11362": (40.758364, -73.735759),
    "11363": (40.771467, -73.745323),
    "11364": (40.742772, -73.758831),
    "11365": (40.738884, -73.790067),
    "11366": (40.727277, -73.790772),
    "11367": (40.730164, -73.821997),
    "11368": (40.748751, -73.854333),
    "11369": (40.762741, -73.869969),
    "11370": (40.763771, -73.891451),
    "11371": (40.7712, -73.867514),
    "11372": (40.751146, -73.882508),
    "11373": (40.73509, -73.877562),
    "11374": (40.722861, -73.862069),
    "11375": (40.723041, -73.843688),
    "11377": (40.748372, -73.905445),
    "11378": (40.722848, -73.908413),
    "11379": (40.71924, -73.892791),
    "11380": (40.651378, -73.870779),
    "11381": (40.651378, -73.870779),
    "11385": (40.702404, -73.885979),
    "11386": (40.651378, -73.870779),
    "11390": (40.651378, -73.870779),
    "11405": (40.651378, -73.870779),
    "11411": (40.685535, -73.737064),
    "11412": (40.695829, -73.761747),
    "11413": (40.664542, -73.755926),
    "11414": (40.658825, -73.84382),
    "11415": (40.707133, -73.829247),
    "11416": (40.684546, -73.850708),
    "11417": (40.675056, -73.844315),
    "11418": (40.698566, -73.83127),
    "11419": (40.686769, -73.822979),
    "11420": (40.674432, -73.819013),
    "11421": (40.691917, -73.85666),
    "11422": (40.659418, -73.736866),
    "11423": (40.716888, -73.766897),
    "11424": (40.651378, -73.870779),
    "11425": (40.651378, -73.870779),
    "11426": (40.736798, -73.723176),
    "11427": (40.729293, -73.749811),
    "11428": (40.720639, -73.742099),
    "11429": (40.710076, -73.740151),
    "11430": (40.655246, -73.797769),
    "11431": (40.686903, -73.850143),
    "11432": (40.714531, -73.794435),
    "11433": (40.696533, -73.786776),
    "11434": (40.674583, -73.78156),
    "11435": (40.700229, -73.797278),
    "11436": (40.675283, -73.800696),
    "11439": (40.722008, -73.790822),
    "11451": (40.651378, -73.870779),
    "11484": (40.651378, -73.870779),
    "11499": (40.651378, -73.870779),
    "11501": (40.735901, -73.638061),
    "11507": (40.754757, -73.601772),
    "11509": (40.588854, -73.72709),
    "11510": (40.654626, -73.608972),
    "11514": (40.74435, -73.608422),
    "11516": (40.626453, -73.725825),
    "11518": (40.640387, -73.668224),
    "11520": (40.651251, -73.585222),
    "11530": (40.726801, -73.639723),
    "11531": (40.754757, -73.601772),
    "11535": (40.754757, -73.601772),
    "11536": (40.754757, -73.601772),
    "11542": (40.754757, -73.601772),
    "11545": (40.754757, -73.601772),
    "11547": (40.754757, -73.601772),
    "11548": (40.754757, -73.601772),
    "11549": (40.754757, -73.601772),
    "11550": (40.700201, -73.620872),
    "11551": (40.754757, -73.601772),
    "11552": (40.690251, -73.653023),
    "11553": (40.705868, -73.591421),
    "11554": (40.72135, -73.55877),
    "11555": (40.754757, -73.601772),
    "11556": (40.754757, -73.601772),
    "11557": (40.638803, -73.693274),
    "11558": (40.606953, -73.654724),
    "11559": (40.615435, -73.72642),
    "11560": (40.754757, -73.601772),
    "11561": (40.589139, -73.642323),
    "11563": (40.657602, -73.672574),
    "11564": (40.754757, -73.601772),
    "11565": (40.674652, -73.673324),
    "11566": (40.668501, -73.553628),
    "11568": (40.754757, -73.601772),
    "11569": (40.590503, -73.580822),
    "11570": (40.667352, -73.638523),
    "11571": (40.754757, -73.601772),
    "11572": (40.635252, -73.636923),
    "11575": (40.680451, -73.590071),
    "11576": (40.656802, -73.622523),
    "11577": (40.754757, -73.601772),
    "11579": (40.754757, -73.601772),
    "11580": (40.676052, -73.697828),
    "11581": (40.652253, -73.711775),
    "11582": (40.754757, -73.601772),
    "11583": (40.754757, -73.601772),
    "11588": (40.754757, -73.601772),
    "11590": (40.74505, -73.571521),
    "11592": (40.621753, -73.632673),
    "11593": (40.754757, -73.601772),
    "11594": (40.754757, -73.601772),
    "11595": (40.754757, -73.601772),
    "11596": (40.754757, -73.601772),
    "11597": (40.754757, -73.601772),
    "11598": (40.633103, -73.712025),
    "11599": (40.607574, -73.742691),
    "11690": (40.651378, -73.870779),
    "11691": (40.601475, -73.76191),
    "11692": (40.5923, -73.793273),
    "11693": (40.59846, -73.81427),
    "11694": (40.57661, -73.84276),
    "11695": (40.651378, -73.870779),
    "11697": (40.559365, -73.906713),
    "11701": (40.686249, -73.411866),
    "11702": (40.66415, -73.340984),
    "11703": (40.732348, -73.325363),
    "11704": (40.709098, -73.356164),
    "11705": (40.748364, -73.057026),
    "11706": (40.705138, -73.243004),
    "11707": (40.922326, -72.637078),
    "11708": (40.922326, -72.637078),
    "11709": (40.754757, -73.601772),
    "11710": (40.6729, -73.53652),
    "11713": (40.922326, -72.637078),
    "11714": (40.728449, -73.495369),
    "11715": (40.75673, -73.043481),
    "11716": (40.76902, -73.113366),
    "11717": (40.780882, -73.250336),
    "11718": (40.715424, -73.260912),
    "11719": (40.922326, -72.637078),
    "11720": (40.922326, -72.637078),
    "11721": (40.893197, -73.370462),
    "11722": (40.78193, -73.196148),
    "11724": (40.860098, -73.442315),
    "11725": (40.842247, -73.280935),
    "11726": (40.68022, -73.394762),
    "11727": (40.922326, -72.637078),
    "11729": (40.762574, -73.323061),
    "11730": (40.724146, -73.175926),
    "11731": (40.856997, -73.314561),
    "11732": (40.754757, -73.601772),
    "11733": (40.922326, -72.637078),
    "11735": (40.754757, -73.601772),
    "11736": (40.754757, -73.601772),
    "11737": (40.754757, -73.601772),
    "11738": (40.922326, -72.637078),
    "11739": (40.922326, -72.637078),
    "11740": (40.866948, -73.362512),
    "11741": (40.78791, -73.066689),
    "11742": (40.798994, -73.048985),
    "11743": (40.867647, -73.410218),
    "11745": (40.922326, -72.637078),
    "11746": (40.814348, -73.363363),
    "11747": (40.787248, -73.405573),
    "11749": (40.922326, -72.637078),
    "11750": (40.922326, -72.637078),
    "11751": (40.72813, -73.217871),
    "11752": (40.757226, -73.182854),
    "11753": (40.754757, -73.601772),
    "11754": (40.80323, -73.30485),
    "11755": (40.85185, -73.129003),
    "11756": (40.7228, -73.515819),
    "11757": (40.688799, -73.376475),
    "11758": (40.754757, -73.601772),
    "11760": (40.810246, -73.191789),
    "11762": (40.754757, -73.601772),
    "11763": (40.922326, -72.637078),
    "11764": (40.922326, -72.637078),
    "11765": (40.754757, -73.601772),
    "11766": (40.922326, -72.637078),
    "11767": (40.846678, -73.146763),
    "11768": (40.914289, -73.33268),
    "11769": (40.738322, -73.131797),
    "11770": (40.644344, -73.161286),
    "11771": (40.754757, -73.601772),
    "11772": (40.922326, -72.637078),
    "11773": (40.754757, -73.601772),
    "11774": (40.754757, -73.601772),
    "11775": (40.922326, -72.637078),
    "11776": (40.922326, -72.637078),
    "11777": (40.922326, -72.637078),
    "11778": (40.922326, -72.637078),
    "11779": (40.808322, -73.130469),
    "11780": (40.889314, -73.174435),
    "11782": (40.745866, -73.085858),
    "11783": (40.683897, -73.496169),
    "11784": (40.922326, -72.637078),
    "11786": (40.922326, -72.637078),
    "11787": (40.856793, -73.208278),
    "11788": (40.819074, -73.2122),
    "11789": (40.922326, -72.637078),
    "11790": (40.90129, -73.182803),
    "11791": (40.754757, -73.601772),
    "11792": (40.922326, -72.637078),
    "11793": (40.67815, -73.509519),
    "11794": (40.922326, -72.637078),
    "11795": (40.699825, -73.290905),
    "11796": (40.732304, -73.10002),
    "11797": (40.754757, -73.601772),
    "11798": (40.73417, -73.351354),
    "11801": (40.754757, -73.601772),
    "11802": (40.754757, -73.601772),
    "11803": (40.754757, -73.601772),
    "11804": (40.754757, -73.601772),
    "11805": (40.922326, -72.637078),
    "11815": (40.754757, -73.601772),
    "11819": (40.754757, -73.601772),
    "11853": (40.754757, -73.601772),
    "11854": (40.754757, -73.601772),
    "11855": (40.754757, -73.601772),
    "11901": (40.922326, -72.637078),
    "11930": (40.922326, -72.637078),
    "11931": (40.922326, -72.637078),
    "11932": (40.922326, -72.637078),
    "11933": (40.922326, -72.637078),
    "11934": (40.922326, -72.637078),
    "11935": (40.922326, -72.637078),
    "11937": (40.922326, -72.637078),
    "11939": (40.922326, -72.637078),
    "11940": (40.922326, -72.637078),
    "11941": (40.922326, -72.637078),
    "11942": (40.922326, -72.637078),
    "11944": (40.922326, -72.637078),
    "11946": (40.922326, -72.637078),
    "11947": (40.922326, -72.637078),
    "11948": (40.922326, -72.637078),
    "11949": (40.922326, -72.637078),
    "11950": (40.922326, -72.637078),
    "11951": (40.922326, -72.637078),
    "11952": (40.922326, -72.637078),
    "11953": (40.922326, -72.637078),
    "11954": (40.922326, -72.637078),
    "11955": (40.922326, -72.637078),
    "11956": (40.922326, -72.637078),
    "11957": (40.922326, -72.637078),
    "11958": (40.922326, -72.637078),
    "11959": (40.922326, -72.637078),
    "11960": (40.922326, -72.637078),
    "11961": (40.922326, -72.637078),
    "11962": (40.922326, -72.637078),
    "11963": (40.922326, -72.637078),
    "11964": (40.922326, -72.637078),
    "11965": (40.922326, -72.637078),
    "11967": (40.922326, -72.637078),
    "11968": (40.922326, -72.637078),
    "11969": (40.922326, -72.637078),
    "11970": (40.922326, -72.637078),
    "11971": (40.922326, -72.637078),
    "11972": (40.922326, -72.637078),
    "11973": (40.922326, -72.637078),
    "11975": (40.922326, -72.637078),
    "11976": (40.922326, -72.637078),
    "11977": (40.922326, -72.637078),
    "11978": (40.922326, -72.637078),
    "11980": (40.922326, -72.637078),
    "12007": (42.482455, -73.936671),
    "12008": (42.859176, -73.902117),
    "12009": (42.688731, -74.030596),
    "12010": (42.906298, -74.229042),
    "12015": (42.28004, -73.837035),
    "12016": (42.910206, -74.423606),
    "12017": (42.309805, -73.565617),
    "12018": (42.670645, -73.55142),
    "12019": (42.934416, -73.848971),
    "12020": (42.983588, -73.882538),
    "12022": (42.67051, -73.357825),
    "12023": (42.602236, -74.154615),
    "12024": (42.494981, -73.510676),
    "12025": (43.082793, -74.160753),
    "12027": (42.923676, -73.911768),
    "12028": (42.851332, -73.454055),
    "12029": (42.357057, -73.448944),
    "12031": (42.592287, -74.438129),
    "12032": (43.15566, -74.494888),
    "12033": (42.589158, -73.565925),
    "12035": (42.721081, -74.382064),
    "12036": (42.541025, -74.655395),
    "12037": (42.335777, -73.528651),
    "12040": (42.646742, -73.371611),
    "12041": (42.561988, -73.957345),
    "12042": (42.411207, -73.927573),
    "12043": (42.665376, -74.51884),
    "12045": (42.475704, -73.797722),
    "12046": (42.492791, -73.928403),
    "12047": (42.647039, -73.739349),
    "12050": (42.317154, -73.748555),
    "12051": (42.355924, -73.847967),
    "12052": (42.670318, -73.549377),
    "12053": (42.77788, -74.197936),
    "12054": (42.605467, -73.8757),
    "12055": (42.614852, -73.970812),
    "12056": (42.770065, -74.085963),
    "12057": (42.980783, -73.352206),
    "12058": (42.352969, -73.905306),
    "12059": (42.618248, -74.028108),
    "12060": (42.419964, -73.512815),
    "12061": (42.570352, -73.655682),
    "12062": (42.537218, -73.503877),
    "12063": (42.563685, -73.627428),
    "12064": (42.632058, -74.667368),
    "12065": (42.850576, -73.792524),
    "12066": (42.801547, -74.342884),
    "12067": (42.555446, -73.913714),
    "12068": (42.940975, -74.391459),
    "12069": (42.945701, -74.263312),
    "12070": (42.969738, -74.292476),
    "12071": (42.592287, -74.438129),
    "12072": (42.877533, -74.404477),
    "12073": (42.592287, -74.438129),
    "12074": (43.082925, -74.043981),
    "12075": (42.366064, -73.589731),
    "12076": (42.411096, -74.427506),
    "12077": (42.595704, -73.787766),
    "12078": (43.114958, -74.344328),
    "12082": (42.772624, -73.446834),
    "12083": (42.382594, -73.951259),
    "12084": (42.703519, -73.960324),
    "12085": (42.694777, -73.905271),
    "12086": (42.969505, -74.155559),
    "12087": (42.411114, -73.881515),
    "12089": (42.866666, -73.318113),
    "12090": (42.73531, -73.437943),
    "12092": (42.712176, -74.349066),
    "12093": (42.458932, -74.580562),
    "12094": (42.879946, -73.48684),
    "12095": (43.090543, -74.355438),
    "12106": (42.385231, -73.704442),
    "12107": (42.660046, -74.116812),
    "12108": (43.667618, -74.456913),
    "12110": (42.752928, -73.779714),
    "12111": (42.614852, -73.970812),
    "12115": (42.473718, -73.56733),
    "12116": (42.551473, -74.913829),
    "12117": (43.132167, -74.248494),
    "12118": (43.033189, -73.897322),
    "12120": (42.478906, -74.147178),
    "12121": (42.712948, -73.601722),
    "12122": (42.560533, -74.295505),
    "12123": (42.565736, -73.629023),
    "12124": (42.444198, -73.788241),
    "12125": (42.466748, -73.567189),
    "12128": (42.724978, -73.764296),
    "12130": (42.439983, -73.666343),
    "12131": (42.592287, -74.438129),
    "12132": (42.466061, -73.629296),
    "12133": (42.926121, -73.346409),
    "12134": (43.176121, -74.248627),
    "12136": (42.434992, -73.561172),
    "12137": (42.838578, -74.131734),
    "12138": (42.685947, -73.390627),
    "12139": (43.428386, -74.526485),
    "12140": (42.686757, -73.527434),
    "12141": (42.731771, -74.185395),
    "12143": (42.493642, -73.858352),
    "12144": (42.621627, -73.596089),
    "12147": (42.500258, -74.160591),
    "12148": (42.841619, -73.847016),
    "12149": (42.609418, -74.594655),
    "12150": (42.869961, -74.050083),
    "12151": (42.924726, -73.785914),
    "12153": (42.635503, -73.479705),
    "12154": (42.904445, -73.615618),
    "12155": (42.605453, -74.820584),
    "12156": (42.491469, -73.723935),
    "12157": (42.655569, -74.337322),
    "12158": (42.529746, -73.840579),
    "12159": (42.644278, -73.876338),
    "31297": (32.700450000000004, -83.657207),
    "12160": (42.756876, -74.317361),
    "12161": (42.521038, -73.851898),
    "12164": (43.667618, -74.456913),
    "12165": (42.331057, -73.529774),
    "12166": (42.842006, -74.446),
    "12167": (42.413508, -74.61939),
    "12168": (42.63593, -73.408789),
    "12169": (42.585511, -73.415444),
    "12170": (43.001932, -73.660897),
    "12172": (42.285749, -73.733532),
    "12173": (42.399271, -73.622327),
    "12174": (42.343986, -73.73477),
    "12175": (42.535029, -74.54525),
    "12176": (42.385117, -73.958671),
    "12177": (42.95002, -74.296985),
    "12179": (42.71144, -73.525561),
    "12180": (42.673701, -73.608792),
    "12181": (42.738678, -73.673862),
    "12182": (42.685792, -73.652374),
    "12183": (42.745994, -73.694263),
    "12184": (42.398503, -73.626548),
    "12185": (42.856307, -73.500679),
    "12186": (42.620654, -73.980441),
    "12187": (42.592287, -74.438129),
    "12188": (42.845579, -73.702433),
    "12189": (42.736277, -73.720318),
    "12190": (43.667618, -74.456913),
    "12192": (42.397703, -73.834836),
    "12193": (42.521722, -74.03961),
    "12194": (42.572934, -74.514163),
    "12195": (42.479384, -73.474809),
    "12196": (42.603715, -73.561566),
    "12197": (42.606993, -74.732401),
    "12198": (42.676167, -73.606194),
    "12201": (42.614852, -73.970812),
    "12202": (42.636371, -73.763564),
    "12203": (42.700345, -73.857496),
    "12204": (42.682978, -73.770714),
    "12205": (42.719799, -73.820666),
    "12206": (42.675779, -73.793065),
    "12207": (42.656029, -73.750764),
    "12208": (42.654658, -73.805866),
    "12209": (42.677953, -73.91019),
    "12210": (42.683079, -73.758115),
    "12211": (42.712973, -73.773868),
    "12212": (42.716774, -73.810373),
    "12214": (42.614852, -73.970812),
    "12220": (42.614852, -73.970812),
    "12222": (42.692909, -73.838035),
    "12223": (42.614852, -73.970812),
    "12224": (42.614852, -73.970812),
    "12225": (42.614852, -73.970812),
    "12226": (42.614852, -73.970812),
    "12227": (42.614852, -73.970812),
    "12228": (42.614852, -73.970812),
    "12229": (42.614852, -73.970812),
    "12230": (42.614852, -73.970812),
    "12231": (42.614852, -73.970812),
    "12232": (42.614852, -73.970812),
    "12233": (42.614852, -73.970812),
    "12234": (42.614852, -73.970812),
    "12235": (42.614852, -73.970812),
    "12236": (42.614852, -73.970812),
    "12237": (42.614852, -73.970812),
    "12238": (42.614852, -73.970812),
    "12239": (42.614852, -73.970812),
    "12240": (42.614852, -73.970812),
    "12241": (42.614852, -73.970812),
    "12242": (42.614852, -73.970812),
    "12243": (42.614852, -73.970812),
    "12244": (42.614852, -73.970812),
    "12245": (42.614852, -73.970812),
    "12246": (42.647079, -73.750314),
    "12247": (42.614852, -73.970812),
    "12248": (42.614852, -73.970812),
    "12249": (42.614852, -73.970812),
    "12250": (42.614852, -73.970812),
    "12252": (42.614852, -73.970812),
    "12255": (42.614852, -73.970812),
    "12256": (42.614852, -73.970812),
    "12257": (42.614852, -73.970812),
    "12260": (42.614852, -73.970812),
    "12261": (42.614852, -73.970812),
    "12262": (42.614852, -73.970812),
    "12288": (42.614852, -73.970812),
    "12301": (42.833261, -74.058015),
    "12302": (42.880035, -73.991321),
    "12303": (42.782276, -73.944818),
    "12304": (42.788176, -73.899917),
    "12305": (42.812776, -73.943368),
    "12306": (42.816438, -74.052713),
    "12307": (42.805376, -73.934868),
    "12308": (42.835926, -73.920467),
    "12309": (42.809077, -73.869316),
    "12325": (42.833261, -74.058015),
    "12345": (42.833261, -74.058015),
    "12401": (41.96973, -74.06678),
    "12402": (41.878801, -74.345684),
    "12404": (41.949146999999996, -74.130688),
    "12405": (42.315975, -74.065515),
    "12406": (42.141725, -74.572054),
    "12407": (42.332859, -74.367866),
    "12409": (42.054666, -74.192451),
    "12410": (42.073965, -74.453033),
    "12411": (41.875232, -74.043557),
    "12412": (41.998413, -74.265437),
    "12413": (42.301789, -74.029434),
    "12414": (42.258459, -74.021968),
    "12416": (42.095023, -74.271661),
    "12417": (41.907604, -73.989254),
    "12418": (42.368277, -74.179384),
    "12419": (41.856903, -74.111235),
    "12420": (41.669831, -74.380138),
    "12421": (42.235727, -74.56969),
    "12422": (42.307188, -74.200237),
    "12423": (42.377483, -74.123477),
    "12424": (42.28041, -74.15549),
    "12427": (42.169082, -74.12958),
    "12428": (41.897181, -74.253996),
    "12429": (41.816228, -73.992565),
    "12430": (42.177175, -74.547279),
    "12431": (42.336112, -74.024147),
    "12432": (41.949795, -74.003246),
    "12433": (42.008413, -74.147995),
    "12434": (42.320684, -74.459223),
    "12435": (41.727613, -74.515647),
    "12436": (42.19551, -74.102319),
    "12438": (42.183045, -74.925617),
    "12439": (42.293905, -74.185279),
    "12440": (41.872233, -74.146678),
    "12441": (41.878801, -74.345684),
    "12442": (42.233275, -74.241582),
    "12443": (41.853723, -74.115476),
    "12444": (42.264524, -74.295888),
    "12446": (41.884748, -74.232063),
    "12448": (42.083209, -74.191963),
    "12449": (41.883711, -74.182479),
    "12450": (42.208809, -74.163793),
    "12451": (42.304064, -73.930812),
    "12452": (42.223407, -74.386635),
    "12453": (42.098698, -73.935418),
    "12454": (42.282466, -74.160193),
    "12455": (42.185189, -74.617819),
    "12456": (42.037136, -73.992829),
    "12457": (41.8743, -74.168979),
    "12458": (41.80137, -74.420108),
    "12459": (42.20943, -74.683726),
    "12460": (42.409721, -74.192105),
    "12461": (41.875001, -74.273362),
    "12463": (42.197886, -74.00995),
    "12464": (42.019668, -74.228732),
    "12465": (42.136293, -74.473639),
    "12466": (41.894812, -73.976653),
    "12468": (42.286917, -74.385762),
    "12469": (42.464687, -74.213992),
    "12470": (42.282915, -74.018409),
    "12471": (41.840304, -74.030611),
    "12472": (41.873367, -74.074621),
    "12473": (42.276462, -74.044432),
    "12474": (42.295703, -74.563088),
    "12475": (42.017632, -74.007868),
    "12477": (41.996982, -74.202816),
    "12480": (41.911181, -74.407894),
    "12481": (41.970903, -74.218443),
    "12482": (42.267617, -73.986354),
    "12483": (41.663895, -74.424533),
    "12484": (41.846274, -74.20731),
    "12485": (42.195922, -74.137242),
    "12486": (41.837953, -74.232241),
    "12487": (41.857076, -74.017907),
    "12489": (41.760604, -74.353531),
    "12490": (42.108689, -73.934577),
    "12491": (41.983752, -74.124371),
    "12492": (42.206787, -74.375508),
    "12493": (41.795276, -73.980908),
    "12494": (41.972572, -74.267623),
    "12495": (42.046885, -74.203575),
    "12496": (42.320273, -74.231589),
    "12498": (41.883076, -74.169764),
    "12501": (41.826491, -73.710901),
    "12502": (42.067399, -73.657698),
    "12503": (42.043039, -73.587575),
    "12504": (42.035434, -73.909234),
    "12506": (41.759905, -73.743714),
    "12507": (42.000547, -73.919899),
    "12508": (41.712677, -73.773082),
    "12510": (41.759905, -73.743714),
    "12511": (41.759905, -73.743714),
    "12512": (41.552793, -73.968183),
    "12513": (42.206862, -73.694642),
    "12514": (41.867364, -73.777256),
    "12515": (41.682335, -74.05799),
    "12516": (42.099322, -73.576102),
    "12517": (42.130934, -73.548337),
    "12518": (41.348593, -74.135167),
    "12520": (41.431474, -74.132883),
    "12521": (42.190488, -73.64465),
    "12522": (41.800316, -73.687324),
    "12523": (42.119528, -73.697297),
    "12524": (41.61898, -73.847308),
    "12525": (41.677151, -74.17387),
    "12526": (42.121298, -73.792924),
    "12527": (41.520249, -73.933259),
    "12528": (41.720945, -74.009481),
    "12529": (42.19327, -73.550028),
    "12530": (42.210991, -73.687001),
    "12531": (41.549045, -73.670325),
    "12533": (41.748948, -73.766191),
    "12534": (42.184313, -73.742997),
    "12537": (41.582437, -73.936281),
    "12538": (41.813468, -73.814913),
    "12540": (41.633029, -73.743183),
    "12541": (42.142068, -73.757399),
    "12542": (41.612647, -74.002802),
    "12543": (41.357625, -74.230587),
    "12544": (42.259623, -73.667962),
    "12545": (41.832012, -73.637175),
    "12546": (41.93846, -73.546336),
    "12547": (41.644832, -74.068056),
    "12548": (41.672278, -74.103276),
    "12549": (41.405901, -74.255717),
    "12550": (41.38537, -74.185363),
    "12551": (41.387822, -74.354699),
    "12552": (41.387822, -74.354699),
    "12553": (41.413667, -74.311974),
    "12555": (41.387822, -74.354699),
    "12561": (41.74638, -74.109241),
    "12563": (41.485285, -73.595066),
    "12564": (41.663759, -73.590491),
    "12565": (42.250141, -73.659054),
    "12566": (41.405485, -74.219343),
    "12567": (41.952681, -73.63633),
    "12568": (41.641207, -74.07805),
    "12569": (41.825708, -73.783655),
    "12570": (41.646389, -73.650107),
    "12571": (41.808427, -73.786847),
    "12572": (41.836548, -73.760423),
    "12574": (41.915068, -73.95173),
    "12575": (41.50755, -74.156394),
    "12577": (41.437176, -74.121804),
    "12578": (41.81246, -73.786647),
    "12580": (41.881636, -73.72455),
    "12581": (41.913511, -73.695442),
    "12582": (41.554509, -73.72667),
    "12583": (41.909683, -73.749214),
    "12584": (41.464073, -74.059104),
    "12585": (41.716145, -73.690109),
    "12586": (41.406785, -74.26731),
    "12588": (41.878801, -74.345684),
    "12589": (41.631653, -74.154472),
    "12590": (41.736948, -73.741141),
    "12592": (41.802285, -73.560425),
    "12593": (42.243991, -73.641076),
    "12594": (41.672789, -73.584346),
    "12601": (41.695839, -73.896164),
    "12602": (41.759905, -73.743714),
    "12603": (41.690707, -73.862074),
    "12604": (41.759905, -73.743714),
    "12701": (41.686944, -74.677156),
    "12719": (41.486186, -74.915176),
    "12720": (41.661466, -74.911474),
    "12721": (41.63868, -74.721754),
    "12722": (41.719016, -74.755373),
    "12723": (41.775202, -75.01807),
    "12724": (41.719016, -74.755373),
    "12725": (41.899285, -74.58802),
    "12726": (41.691959, -74.974074),
    "12727": (41.719016, -74.755373),
    "12729": (41.403723, -74.425265),
    "12732": (41.517426, -74.845788),
    "12733": (41.647052, -74.537252),
    "12734": (41.734858, -74.734508),
    "12736": (41.878194, -75.034258),
    "12737": (41.547309, -74.820881),
    "12738": (41.656753, -74.568565),
    "12739": (41.450914, -74.601097),
    "12740": (41.818383, -74.748053),
    "12741": (41.839135, -75.05342),
    "12742": (41.710156, -74.71536),
    "12743": (41.531346, -74.849136),
    "12745": (41.762944, -75.030592),
    "12746": (41.437689, -74.640019),
    "12747": (41.770283, -74.726066),
    "12748": (41.782874, -74.905417),
    "12749": (41.687384, -74.835807),
    "12750": (41.729581, -74.961146),
    "12751": (41.694655, -74.682731),
    "12752": (41.758563, -74.946306),
    "12754": (41.71994, -74.66934),
    "12758": (41.818205, -74.802549),
    "12759": (41.786516, -74.658843),
    "12760": (41.871276, -75.076328),
    "12762": (41.686123, -74.783554),
    "12763": (41.80469, -74.696318),
    "12764": (41.595908, -74.96233),
    "12765": (41.865656, -74.60902),
    "12766": (41.820897, -74.995771),
    "12767": (41.719016, -74.755373),
    "12768": (41.841414, -74.857261),
    "12769": (41.651453, -74.436159),
    "12770": (41.446322, -74.856932),
    "12771": (41.357119, -74.498396),
    "12775": (41.619506, -74.575902),
    "12776": (41.819249, -74.951782),
    "12777": (41.552911, -74.603366),
    "12778": (41.661538, -74.817751),
    "12779": (41.770195, -74.716843),
    "12780": (41.376892, -74.459687),
    "12781": (41.719016, -74.755373),
    "12782": (41.881485, -74.430063),
    "12783": (41.657319, -74.840778),
    "12784": (41.714311, -74.584061),
    "12785": (41.719016, -74.755373),
    "12786": (41.64788, -74.811773),
    "12787": (41.800193, -74.828611),
    "12788": (41.810974, -74.729403),
    "12789": (41.797345, -74.671013),
    "12790": (41.592331, -74.552644),
    "12791": (41.695448999999996, -74.746874),
    "12792": (41.591075000000004, -74.749722),
    "12801": (43.31888, -73.669061),
    "12803": (43.283561, -73.629401),
    "12804": (43.489472, -73.789563),
    "12808": (43.708338, -73.794147),
    "12809": (43.280711, -73.484828),
    "12810": (43.59886, -73.943693),
    "12811": (43.62422, -74.061201),
    "12812": (43.667618, -74.456913),
    "12814": (43.574329, -73.677564),
    "12815": (43.677503, -73.773434),
    "12816": (43.068526, -73.392229),
    "12817": (43.522364, -73.794491),
    "12819": (43.614194, -73.503056),
    "12820": (43.47181, -73.639291),
    "12821": (43.46144, -73.403287),
    "12822": (43.241967, -73.890739),
    "12823": (43.154262, -73.458063),
    "12824": (43.560729, -73.755545),
    "12827": (43.443936, -73.489198),
    "12828": (43.371195, -73.434566),
    "12831": (43.204261, -73.707415),
    "12832": (43.369373, -73.331692),
    "12833": (43.181214, -73.906293),
    "12834": (43.212754, -73.434261),
    "12835": (43.287589, -73.976958),
    "12836": (43.730225, -73.543498),
    "12837": (43.492705, -73.278904),
    "12838": (43.354304, -73.404906),
    "12839": (43.203596, -73.468589),
    "12841": (43.646953, -73.508308),
    "12842": (43.749928, -74.327593),
    "12843": (43.58596, -73.916498),
    "12844": (43.475353, -73.627156),
    "12845": (43.518611, -73.875462),
    "12846": (43.455598, -73.771547),
    "12847": (43.953253, -74.440029),
    "12848": (43.100123, -73.524554),
    "12849": (43.442087, -73.290902),
    "12850": (43.185956, -73.983737),
    "12851": (44.214452, -73.787317),
    "12852": (44.145678, -73.815204),
    "12853": (43.622181, -73.922201),
    "12854": (43.452517, -73.34095),
    "12855": (43.970736, -73.721139),
    "12856": (43.723665, -74.087329),
    "12857": (44.145678, -73.815204),
    "12858": (43.879451, -73.400254),
    "12859": (43.20138, -73.891854),
    "12860": (43.592829, -73.784407),
    "12861": (43.743816, -73.422181),
    "12862": (43.675377, -73.932509),
    "12863": (43.061305, -73.92308),
    "12864": (43.667618, -74.456913),
    "12865": (43.225966, -73.348736),
    "12866": (43.101145, -73.850623),
    "12870": (43.841273, -73.759213),
    "12871": (43.130211, -73.643205),
    "12872": (44.145678, -73.815204),
    "12873": (43.104587, -73.314179),
    "12874": (43.693173, -73.505019),
    "12878": (43.464398, -73.876364),
    "12879": (44.145678, -73.815204),
    "12883": (43.852071, -73.478024),
    "12884": (43.088397, -73.591652),
    "12885": (43.570457, -73.859928),
    "12886": (43.631297, -73.936399),
    "12887": (43.492815, -73.421536),
    "12901": (44.71187, -73.637104),
    "12903": (44.685411, -73.447398),
    "12910": (44.865209, -73.577683),
    "12911": (44.528081, -73.471946),
    "12912": (44.711326, -73.648386),
    "12913": (44.401213, -74.070277),
    "12914": (44.674942, -74.444789),
    "12915": (44.552725, -74.317958),
    "12916": (44.87763, -74.489379),
    "12917": (44.932057, -74.200948),
    "12918": (44.686162, -73.670249),
    "12919": (44.726056, -73.578285),
    "12920": (44.932727, -74.068371),
    "12921": (44.879906, -73.452578),
    "12922": (44.287829, -74.702338),
    "12923": (44.916842, -73.932053),
    "12924": (44.706561, -73.744555),
    "12926": (44.944145, -74.327316),
    "12927": (44.228969, -74.858103),
    "12928": (43.930616, -73.58854),
    "12929": (44.847709, -73.582317),
    "12930": (44.552725, -74.317958),
    "12932": (44.145678, -73.815204),
    "12933": (44.881962, -73.963279),
    "12934": (44.892243, -73.907936),
    "12935": (44.801467, -73.739157),
    "12936": (44.273412, -73.377434),
    "12937": (44.955977, -74.48674),
    "12939": (44.552725, -74.317958),
    "12941": (44.145678, -73.815204),
    "12942": (44.145678, -73.815204),
    "12943": (44.202397, -73.773111),
    "12944": (44.343063, -73.436913),
    "12945": (44.552725, -74.317958),
    "12946": (44.130663, -73.734652),
    "12949": (44.746861, -74.660413),
    "12950": (44.145678, -73.815204),
    "12952": (44.734587, -73.900452),
    "12953": (44.859117, -74.288237),
    "12955": (44.804316, -73.97299),
    "12956": (44.12404, -73.491335),
    "12957": (44.85688, -74.552321),
    "12958": (44.792956, -73.661296),
    "12959": (44.76292, -73.615749),
    "12960": (44.041863, -73.505265),
    "12961": (44.055155, -73.534677),
    "12962": (44.617784, -73.605062),
    "12964": (44.145678, -73.815204),
    "12965": (44.726424, -74.678121),
    "12966": (44.8532, -74.419121),
    "12967": (44.761862, -74.680488),
    "12969": (44.552725, -74.317958),
    "12970": (44.552725, -74.317958),
    "12972": (44.66607, -73.569167),
    "12973": (44.234289, -74.555957),
    "12974": (44.087072, -73.461308),
    "12975": (44.526437, -73.409243),
    "12976": (44.552725, -74.317958),
    "12977": (44.145678, -73.815204),
    "12978": (44.664956, -73.761204),
    "12979": (44.864633, -73.626615),
    "12980": (44.657819, -74.515511),
    "12981": (44.624413, -73.809266),
    "12983": (44.583429, -74.272104),
    "12985": (44.570072, -73.678749),
    "12986": (44.599971, -74.294012),
    "12987": (44.145678, -73.815204),
    "12989": (44.552725, -74.317958),
    "12992": (44.827274, -73.513225),
    "12993": (44.18783, -73.434541),
    "12995": (44.805681, -74.252254),
    "12996": (44.242261, -73.416202),
    "12997": (44.145678, -73.815204),
    "12998": (44.08267, -73.530601),
    "13020": (42.823968, -76.062425),
    "13021": (42.894381, -76.565683),
    "13022": (43.163364, -76.509567),
    "13024": (43.163364, -76.509567),
    "13026": (42.755978999999996, -76.646007),
    "13027": (43.158531, -76.360147),
    "13028": (43.310494, -76.135765),
    "13029": (43.227448, -76.140648),
    "13030": (43.165372, -75.993896),
    "13031": (43.049756, -76.348012),
    "13032": (43.005767, -75.798607),
    "13033": (43.185529, -76.579082),
    "13034": (42.924315, -76.676419),
    "13035": (42.939422, -75.775568),
    "13036": (43.330332, -76.17085),
    "13037": (43.009985, -75.806194),
    "13039": (43.125491, -76.154128),
    "13040": (42.565932, -75.955301),
    "13041": (43.119217, -76.131931),
    "13042": (43.27637, -76.225752),
    "13043": (43.042044, -75.740848),
    "13044": (43.301232, -75.982593),
    "13045": (42.614268, -76.120128),
    "13051": (42.870698, -75.91128),
    "13052": (42.776527, -75.859458),
    "13053": (42.477712, -76.291224),
    "13054": (43.14548, -75.559605),
    "13056": (42.677155, -76.105201),
    "13057": (43.096216, -76.047426),
    "13060": (43.027813, -76.416612),
    "13061": (42.841725, -75.744589),
    "13062": (42.484352, -76.389023),
    "13063": (42.855631, -75.976158),
    "13064": (43.431311, -76.200448),
    "13065": (42.822662, -76.80197),
    "13066": (42.947789, -75.995518),
    "13068": (42.49653, -76.372864),
    "13069": (43.345255, -76.227027),
    "13071": (42.673871, -76.526226),
    "13072": (42.768124, -75.788393),
    "13073": (42.579298, -76.392709),
    "13074": (43.324451, -76.306549),
    "13076": (43.338817, -76.189586),
    "13077": (42.678012, -76.175275),
    "13078": (42.966136, -76.057658),
    "13080": (43.067413, -76.439657),
    "13081": (42.876886, -76.631117),
    "13082": (43.103886, -75.961597),
    "13083": (43.642147, -76.029304),
    "13084": (42.891099, -76.128862),
    "13087": (42.706981, -76.156103),
    "13088": (43.124866, -76.207867),
    "13089": (43.02143, -76.197701),
    "13090": (43.152767, -76.223459),
    "13092": (42.659466, -76.410528),
    "13093": (43.431311, -76.200448),
    "13101": (42.597468, -76.072949),
    "13102": (42.554215, -76.292723),
    "13103": (43.339851, -76.096357),
    "13104": (42.955618, -75.96654),
    "13107": (43.457798, -76.153442),
    "13108": (42.948057, -76.329799),
    "13110": (42.8809, -76.291265),
    "13111": (43.258337, -76.6292),
    "13112": (43.098983, -76.413216),
    "13113": (43.089111, -76.621747),
    "13114": (43.398473, -76.204997),
    "13115": (43.397671, -76.482365),
    "13116": (43.076828, -76.006001),
    "13117": (43.002267, -76.704722),
    "13118": (42.737724, -76.407811),
    "13119": (42.97446, -76.440833),
    "13120": (42.951126, -76.179845),
    "13121": (43.483379, -76.315044),
    "13122": (42.825164, -75.85266),
    "13123": (43.236407, -75.776918),
    "13124": (42.479801, -75.622857),
    "13126": (43.465388, -76.342172),
    "13129": (42.712735, -75.731391),
    "13131": (43.43397, -76.120904),
    "13132": (43.296808, -76.229091),
    "13134": (42.968619, -75.679351),
    "13135": (43.33021, -76.260803),
    "13136": (42.619466, -75.845544),
    "13137": (43.157653, -76.44698),
    "13138": (42.89274, -76.026459),
    "13139": (42.742057, -76.628454),
    "13140": (42.886349, -76.541321),
    "13141": (42.739682, -76.157108),
    "13142": (43.560497, -76.15532),
    "13143": (43.238248, -76.752077),
    "13144": (43.571095, -75.972208),
    "13145": (43.621562, -76.11029),
    "13146": (43.099386, -76.762705),
    "13147": (42.770829, -76.586213),
    "13148": (42.905264, -76.794921),
    "13152": (42.884394, -76.285202),
    "13153": (42.991112, -76.451147),
    "13154": (43.134425, -76.765591),
    "13155": (42.654768, -75.769855),
    "13156": (43.341948, -76.665228),
    "13157": (43.209147, -75.72307),
    "13158": (42.696543, -75.98409),
    "13159": (42.830037, -76.124357),
    "13160": (42.847447, -76.649164),
    "13162": (43.18852, -75.712551),
    "13163": (43.078461, -75.701639),
    "13164": (43.100588, -76.321678),
    "13165": (42.892556, -76.882263),
    "13166": (43.046493, -76.555316),
    "13167": (43.346453, -76.229719),
    "13201": (43.02143, -76.197701),
    "13202": (43.043116, -76.150796),
    "13203": (43.062016, -76.134145),
    "13204": (43.055766, -76.177597),
    "13205": (43.006816, -76.142495),
    "13206": (43.076416, -76.109995),
    "13207": (43.012216, -76.170596),
    "13208": (43.074466, -76.145796),
    "13209": (43.084666, -76.240549),
    "13210": (43.031416, -76.110995),
    "13211": (43.091916, -76.124645),
    "13212": (43.122566, -76.128382),
    "13214": (43.039666, -76.072153),
    "13215": (42.972161, -76.227599),
    "13217": (43.02143, -76.197701),
    "13218": (43.02143, -76.197701),
    "13219": (43.041703, -76.222898),
    "13220": (43.123415, -76.12823),
    "13221": (43.02143, -76.197701),
    "13224": (43.038366, -76.099394),
    "13225": (43.02143, -76.197701),
    "13244": (43.037716, -76.139646),
    "13250": (43.02143, -76.197701),
    "13251": (43.02143, -76.197701),
    "13252": (43.050966, -76.156696),
    "13260": (43.02143, -76.197701),
    "13261": (43.02143, -76.197701),
    "13290": (43.067576, -76.171351),
    "13301": (43.419596, -75.224784),
    "13302": (43.497512, -75.988154),
    "13303": (43.364242, -75.468514),
    "13304": (43.244356, -75.166319),
    "13305": (43.818705, -75.480342),
    "13308": (43.137703, -75.523266),
    "13309": (43.23331, -75.294896),
    "13310": (42.930711, -75.560937),
    "13312": (43.818705, -75.480342),
    "13313": (42.879227, -75.267172),
    "13314": (42.954541, -75.616793),
    "13315": (42.734593, -75.133065),
    "13316": (43.285739, -75.626755),
    "13317": (42.867146, -74.595636),
    "13318": (42.921786, -75.255163),
    "13319": (43.028469, -75.264008),
    "13320": (42.768195, -74.759734),
    "13321": (43.090027, -75.387088),
    "13322": (42.961973, -75.233003),
    "13323": (43.036697, -75.382414),
    "13324": (43.271433, -75.04774),
    "13325": (43.56647, -75.425289),
    "13326": (42.714065, -74.890929),
    "13327": (43.909848, -75.365264),
    "13328": (42.983981, -75.422034),
    "13329": (43.18486, -74.941747),
    "13331": (43.816675, -74.886163),
    "13332": (42.719674, -75.558861),
    "13333": (42.793309, -74.837198),
    "13334": (42.82982, -75.65364),
    "13335": (42.711712, -75.246539),
    "13337": (42.755679, -74.876761),
    "13338": (43.500975, -75.153257),
    "13339": (42.924806, -74.616883),
    "13340": (43.039203, -75.118168),
    "13341": (43.036069, -75.396214),
    "13342": (42.63153, -75.186593),
    "13343": (43.818705, -75.480342),
    "13345": (43.818705, -75.480342),
    "13346": (42.822667, -75.553153),
    "13348": (42.690531, -75.063513),
    "13350": (43.026867, -74.933404),
    "13352": (43.328187, -75.117319),
    "13353": (43.667618, -74.456913),
    "13354": (43.273266, -75.301263),
    "13355": (42.817286, -75.422764),
    "13357": (43.013625, -74.958226),
    "13360": (43.667618, -74.456913),
    "13361": (42.964369, -74.881228),
    "13362": (42.980334, -75.518569),
    "13363": (43.328374, -75.520067),
    "13364": (42.954541, -75.616793),
    "13365": (43.078904, -74.864422),
    "13367": (43.789296, -75.415599),
    "13368": (43.621838, -75.365348),
    "13401": (43.267243, -75.688223),
    "13402": (42.898322, -75.549372),
    "13403": (43.172019, -75.27371),
    "13404": (43.818705, -75.480342),
    "13406": (43.135209, -74.934473),
    "13407": (43.029258, -75.011662),
    "13408": (42.924089, -75.651484),
    "13409": (42.972773, -75.600722),
    "13410": (42.937863, -74.611711),
    "13411": (42.631807, -75.385073),
    "13413": (43.067369, -75.290911),
    "13415": (42.590419, -75.195695),
    "13416": (43.203313, -74.971893),
    "13417": (43.100869, -75.29496),
    "13418": (42.954541, -75.616793),
    "13420": (43.752203, -74.873176),
    "13421": (43.047755, -75.640944),
    "13424": (43.056581, -75.38291),
    "13425": (42.96965, -75.485421),
    "13426": (43.562757, -75.996773),
    "13428": (42.926617, -74.54472),
    "13431": (43.232502, -75.07288),
    "13433": (43.576823, -75.315816),
    "13435": (43.305156, -75.150183),
    "13436": (43.667618, -74.456913),
    "13437": (43.577131, -75.829419),
    "13438": (43.341666, -75.221046),
    "13439": (42.84018, -74.97159),
    "13440": (43.20886, -75.383365),
    "13441": (43.164312, -75.511301),
    "13442": (43.239274, -75.47796),
    "13449": (43.239274, -75.47796),
    "13450": (42.70804, -74.802488),
    "13452": (42.975134, -74.657384),
    "13454": (43.460951, -74.957099),
    "13455": (42.916235, -75.35448),
    "13456": (42.991124, -75.270758),
    "13457": (42.775805, -75.048502),
    "13459": (42.787077, -74.584971),
    "13460": (42.648204, -75.455824),
    "13461": (43.074349, -75.580839),
    "13464": (42.672573, -75.593362),
    "13465": (42.954541, -75.616793),
    "13468": (42.83883, -74.85897),
    "13469": (43.219369, -75.299112),
    "13470": (43.190651, -74.650311),
    "13471": (43.228682, -75.591423),
    "13472": (43.460951, -74.957099),
    "13473": (43.818705, -75.480342),
    "13475": (42.893454, -74.836685),
    "13476": (43.092924, -75.50161),
    "13477": (43.141536, -75.530826),
    "13478": (43.146502, -75.586218),
    "13479": (43.053769, -75.271559),
    "13480": (42.926167, -75.360922),
    "13482": (42.704333, -75.184913),
    "13483": (43.403751, -75.825528),
    "13484": (42.854631, -75.660462),
    "13485": (42.747058, -75.160928),
    "13486": (43.339068, -75.341898),
    "13488": (42.680906, -74.76529),
    "13489": (43.44448, -75.543231),
    "13490": (43.124769, -75.432867),
    "13491": (42.909121999999996, -75.12867),
    "13492": (43.197827, -75.287643),
    "13493": (43.427301, -75.880041),
    "13494": (43.524904, -75.142771),
    "13495": (43.102744, -75.321211),
    "13501": (43.077369, -75.233208),
    "13502": (43.150119, -75.192786),
    "13503": (43.101869, -75.231158),
    "13504": (43.136033, -75.432486),
    "13505": (43.087169, -75.260259),
    "13599": (43.239274, -75.47796),
    "13601": (44.072542, -76.016589),
    "13602": (44.032457, -75.754468),
    "13603": (43.908739, -75.896719),
    "13605": (43.960222, -75.905634),
    "13606": (43.831853, -76.007188),
    "13607": (44.074604, -75.840719),
    "13608": (44.148052, -75.759103),
    "13611": (43.778046, -76.125914),
    "13612": (43.98871, -75.766746),
    "13613": (44.788969, -74.879786),
    "13614": (44.538648, -75.68666),
    "13615": (44.057685, -76.019634),
    "13616": (43.951428, -75.860442),
    "13617": (44.574484, -75.059713),
    "13618": (44.126469, -76.272585),
    "13619": (44.068221, -75.920097),
    "13620": (43.818705, -75.480342),
    "13621": (44.845315, -75.047975),
    "13622": (44.091892, -76.108527),
    "13623": (44.440171, -75.757938),
    "13624": (44.144238, -76.062002),
    "13625": (44.421607, -75.105077),
    "13626": (43.892324, -75.703596),
    "13627": (43.818705, -75.480342),
    "13628": (43.885519, -75.798319),
    "13630": (44.462555, -75.30067),
    "13631": (43.818705, -75.480342),
    "13632": (44.139501, -76.061552),
    "13633": (44.49891, -75.477156),
    "13634": (44.014261, -76.08002),
    "13635": (44.523528, -75.160038),
    "13636": (43.75965, -76.152508),
    "13637": (44.0981, -75.817097),
    "13638": (44.01751, -75.755032),
    "13639": (44.23896, -75.122756),
    "13640": (44.321282, -76.017151),
    "13641": (44.207681, -75.914556),
    "13642": (44.550897, -75.237516),
    "13643": (44.014698, -75.728357),
    "13645": (44.533125, -75.192865),
    "13646": (44.468, -75.359907),
    "13647": (44.608735, -74.973218),
    "13648": (43.818705, -75.480342),
    "13649": (44.921678, -74.706763),
    "13650": (43.812653, -76.208109),
    "13651": (43.870842, -76.180886),
    "13652": (44.549025, -75.204351),
    "13654": (44.616648, -75.185085),
    "13655": (44.980232, -74.647334),
    "13656": (44.200392, -75.984109),
    "13657": (44.035703, -76.090424),
    "13658": (44.516168, -75.21642),
    "13659": (43.75037, -75.899974),
    "13660": (44.770682, -75.019312),
    "13661": (43.727352, -76.090851),
    "13662": (44.57026, -75.152249),
    "13664": (44.555889, -75.655877),
    "13665": (44.054012, -75.514487),
    "13666": (44.533125, -75.192865),
    "13667": (44.855075, -74.942946),
    "13668": (44.53517, -75.099289),
    "13669": (44.509143, -75.249795),
    "13670": (44.216681, -75.084323),
    "13671": (44.308475, -75.66879),
    "13672": (44.544283, -74.780387),
    "13673": (44.116323, -75.719346),
    "13674": (43.73345, -76.054313),
    "13675": (44.283403, -75.857026),
    "13676": (44.539717, -75.142415),
    "13677": (44.673438, -75.082041),
    "13678": (44.828685, -74.979811),
    "13679": (44.327083, -75.80354),
    "13680": (44.452668, -75.342977),
    "13681": (44.439964, -75.377707),
    "13682": (43.856677, -75.907485),
    "13683": (44.533125, -75.192865),
    "13684": (44.382351, -75.104276),
    "13685": (43.872933, -76.092563),
    "13687": (44.64472, -74.879155),
    "13688": (43.951666, -75.767772),
    "13690": (44.174001, -74.991929),
    "13691": (44.220448, -75.767059),
    "13692": (44.289833, -76.02621),
    "13693": (44.029787, -76.222374),
    "13694": (44.550617, -75.194099),
    "13695": (44.140791, -74.912493),
    "13696": (44.69563, -74.89998),
    "13697": (44.642889, -74.840761),
    "13699": (44.496564, -75.072951),
    "13730": (42.255147, -75.533335),
    "13731": (42.12923, -74.843187),
    "13732": (42.049798, -76.181009),
    "31298": (32.87333, -83.708399),
    "13733": (42.295949, -75.507589),
    "13734": (42.12518, -76.405626),
    "13736": (42.294616, -76.198223),
    "13737": (42.080494, -76.097288),
    "13738": (42.567313, -76.123795),
    "13739": (42.340298, -74.874437),
    "13740": (42.183045, -74.925617),
    "13743": (42.226448, -76.309863),
    "13744": (42.243783, -75.90689),
    "13745": (42.173775, -75.872839),
    "13746": (42.277777, -75.846246),
    "13747": (42.505122, -74.982056),
    "13748": (42.108659, -75.809834),
    "13749": (42.206745, -75.74488),
    "13750": (42.444889, -74.840217),
    "13751": (42.424859, -74.900195),
    "13752": (42.220641, -74.916308),
    "13753": (42.293718, -74.920671),
    "13754": (42.097004, -75.713691),
    "13755": (42.035768, -74.900852),
    "13756": (42.003935, -75.122615),
    "13757": (42.350091, -74.977712),
    "13758": (42.583518, -75.721931),
    "13760": (42.150588, -76.055064),
    "13761": (42.206745, -75.74488),
    "13762": (42.206745, -75.74488),
    "13763": (42.206745, -75.74488),
    "13774": (42.183045, -74.925617),
    "13775": (42.32887, -75.136628),
    "13776": (42.458584, -75.311836),
    "13777": (42.244157, -75.989275),
    "13778": (42.34013, -75.734191),
    "13780": (42.365134, -75.611685),
    "13782": (42.192781, -75.012689),
    "13783": (42.115853, -75.028814),
    "13784": (42.431068, -76.159312),
    "13786": (42.183045, -74.925617),
    "13787": (42.186306, -75.67618),
    "13788": (42.380427, -74.711604),
    "13790": (42.159206, -75.930931),
    "13794": (42.402816, -76.036582),
    "13795": (42.056172, -75.788126),
    "13796": (42.555454, -75.135511),
    "13797": (42.339355, -76.045026),
    "13801": (42.49712, -75.731309),
    "13802": (42.253754, -76.046399),
    "13803": (42.497925, -76.047429),
    "13804": (42.183045, -74.925617),
    "13806": (42.183045, -74.925617),
    "13807": (42.601799, -74.975717),
    "13808": (42.531661, -75.131023),
    "13809": (42.400281, -75.451576),
    "13810": (42.610748, -75.102602),
    "13811": (42.170428, -76.213825),
    "13812": (42.039954, -76.370793),
    "13813": (42.147454, -75.55656),
    "13814": (42.603574, -75.528221),
    "13815": (42.536226, -75.601779),
    "13820": (42.461688, -75.096727),
    "13825": (42.441165, -75.148268),
    "13826": (42.112127, -75.639586),
    "13827": (42.176816, -76.2568),
    "13830": (42.437881, -75.567327),
    "13832": (42.568979, -75.654133),
    "13833": (42.195785, -75.759054),
    "13834": (42.539439, -74.966985),
    "13835": (42.371552, -76.197488),
    "13837": (42.183045, -74.925617),
    "13838": (42.308884, -75.391644),
    "13839": (42.217118, -75.232488),
    "13840": (42.039512, -76.400376),
    "13841": (42.461525, -75.632735),
    "13842": (42.183045, -74.925617),
    "13843": (42.542579, -75.412243),
    "13844": (42.624833, -75.652767),
    "13845": (42.065842, -76.381946),
    "13846": (42.380509, -75.059702),
    "13847": (42.183045, -74.925617),
    "13848": (42.214705, -75.727699),
    "13849": (42.382962, -75.292321),
    "13850": (42.055476, -76.027088),
    "13851": (42.206745, -75.74488),
    "13856": (42.250118, -75.125556),
    "13859": (42.379383, -75.264556),
    "13860": (42.183045, -74.925617),
    "13861": (42.501093, -75.140874),
    "13862": (42.321825, -75.945183),
    "13863": (42.449946, -75.924813),
    "13864": (42.186744, -76.348074),
    "13865": (42.069103, -75.644078),
    "13901": (42.165629, -75.890685),
    "13902": (42.105375, -75.8876),
    "13903": (42.083005, -75.923248),
    "13904": (42.131088, -75.787801),
    "13905": (42.173709, -75.922159),
    "14001": (43.013808, -78.525296),
    "14003": (42.998052, -78.184813),
    "14004": (42.872937, -78.528446),
    "14005": (42.917622, -78.264873),
    "14006": (42.823386, -78.858355),
    "14008": (43.291696, -78.626944),
    "14009": (42.597171, -78.37463),
    "14010": (42.768413, -78.887094),
    "14011": (42.699424, -78.287793),
    "14012": (43.327031, -78.534963),
    "14013": (43.077884, -78.394594),
    "14020": (42.980544, -78.231764),
    "14021": (42.998052, -78.184813),
    "14024": (42.590046, -78.246616),
    "14025": (42.625391, -78.726767),
    "14026": (42.941008, -78.688009),
    "14027": (42.57075, -79.030785),
    "14028": (43.313814, -78.736907),
    "14029": (42.474283, -78.247413),
    "14030": (42.560669, -78.522178),
    "14031": (42.992968, -78.601269),
    "14032": (42.937314, -78.593381),
    "14033": (42.646441, -78.666272),
    "14034": (42.668773, -78.816333),
    "14035": (42.49064, -78.849861),
    "14036": (42.978522, -78.372338),
    "14037": (42.807705, -78.446855),
    "14038": (42.947259, -78.474444),
    "14039": (42.837456, -78.1719),
    "14040": (42.895989, -78.385667),
    "14041": (42.408583, -78.984391),
    "14042": (42.473934, -78.494065),
    "14043": (42.898958, -78.707872),
    "14047": (42.683521999999996, -78.995736),
    "14048": (42.487716, -79.328287),
    "14051": (43.042907, -78.698796),
    "14052": (42.768209, -78.577136),
    "14054": (42.917037, -78.126525),
    "14055": (42.559423, -78.621851),
    "14056": (42.991173, -78.312171),
    "14057": (42.641429, -78.875456),
    "14058": (43.088434, -78.16261),
    "14059": (42.828309, -78.628966),
    "14060": (42.445698, -78.341227),
    "14061": (42.594627, -79.08404),
    "14062": (42.441146, -79.172343),
    "14063": (42.412217, -79.319254),
    "14065": (42.475344, -78.370334),
    "14066": (42.629014, -78.19448),
    "14067": (43.208166, -78.56623),
    "14068": (43.026737, -78.762454),
    "14069": (42.610187, -78.639976),
    "14070": (42.41994, -78.954628),
    "14072": (43.015256, -78.958945),
    "14075": (42.729083, -78.837596),
    "14080": (42.640179, -78.543738),
    "14081": (42.543516, -79.101301),
    "14082": (42.65161, -78.387099),
    "14083": (42.675193, -78.436442),
    "14085": (42.716055, -78.929357),
    "14086": (42.907658, -78.632137),
    "14091": (42.54386, -78.94475),
    "14092": (43.170805, -78.989515),
    "14094": (43.168463, -78.706886),
    "14095": (43.32684, -78.830681),
    "14098": (43.324031, -78.367151),
    "14101": (42.38917, -78.554217),
    "14102": (42.851099, -78.547172),
    "14103": (43.239442, -78.359871),
    "14105": (43.196947, -78.502849),
    "14107": (43.32684, -78.830681),
    "14108": (43.271156, -78.724806),
    "14109": (43.32684, -78.830681),
    "14110": (42.768413, -78.887094),
    "14111": (42.583165, -78.91888),
    "14112": (42.691742, -78.992658),
    "14113": (42.656199, -78.340092),
    "14120": (43.179206, -78.808908),
    "14125": (43.087438, -78.269677),
    "14126": (43.330443, -78.72666100000001),
    "14127": (42.742541, -78.704437),
    "14129": (42.472671, -79.007621),
    "14130": (42.543108, -78.153849),
    "14131": (43.233055, -78.906562),
    "14132": (43.153105, -78.885611),
    "14133": (42.489129, -78.366991),
    "14134": (42.532281, -78.517233),
    "14135": (42.488983, -79.238997),
    "14136": (42.520038, -79.207843),
    "14138": (42.374077, -78.94643),
    "14139": (42.716759, -78.543478),
    "14140": (42.807159, -78.667599),
    "14141": (42.538335000000004, -78.685169),
    "14143": (42.975195, -78.069868),
    "14144": (43.199494, -79.042477),
    "14145": (42.733778, -78.423303),
    "14150": (42.99704, -78.878659),
    "14151": (42.768413, -78.887094),
    "14166": (42.4511, -79.415421),
    "14167": (42.738977, -78.312478),
    "14168": (42.509271, -78.999471),
    "14169": (42.767333, -78.585646),
    "14170": (42.702797, -78.670098),
    "14171": (42.406409, -78.639581),
    "14172": (43.272729, -78.83101),
    "14173": (42.524691, -78.475474),
    "14174": (43.244454, -78.988325),
    "14201": (42.929303, -78.832706),
    "14202": (42.889662, -78.884157),
    "14203": (42.868057, -78.867906),
    "14204": (42.882957, -78.864898),
    "14205": (42.768413, -78.887094),
    "14206": (42.881012, -78.814555),
    "14207": (42.949557, -78.897009),
    "14208": (42.916107, -78.858157),
    "14209": (42.918107, -78.865857),
    "14210": (42.863608, -78.825755),
    "14211": (42.912257, -78.819005),
    "14212": (42.894558, -78.818805),
    "14213": (42.918057, -78.891108),
    "14214": (42.940107, -78.835256),
    "14215": (42.932957, -78.812252),
    "14216": (42.946407, -78.860407),
    "14217": (42.900044, -78.808205),
    "14218": (42.814558, -78.807754),
    "14219": (42.786308, -78.826444),
    "14220": (42.845908, -78.823005),
    "14221": (42.968507, -78.749153),
    "14222": (42.918207, -78.875007),
    "14223": (42.974607, -78.850507),
    "14224": (42.837128, -78.748352),
    "14225": (42.925458, -78.748145),
    "14226": (42.974389, -78.794905),
    "14227": (42.885308, -78.746202),
    "14228": (43.026016, -78.766073),
    "14231": (42.768413, -78.887094),
    "14233": (42.768413, -78.887094),
    "14240": (42.768413, -78.887094),
    "14241": (42.938258, -78.744053),
    "14260": (42.768413, -78.887094),
    "14261": (42.768413, -78.887094),
    "14263": (42.768413, -78.887094),
    "14264": (42.885568, -78.873479),
    "14265": (42.768413, -78.887094),
    "14267": (42.768413, -78.887094),
    "14269": (42.768413, -78.887094),
    "14270": (42.768413, -78.887094),
    "14272": (42.768413, -78.887094),
    "14273": (42.75495, -78.784908),
    "14276": (42.768413, -78.887094),
    "14280": (42.768413, -78.887094),
    "14301": (43.089805, -79.009414),
    "14302": (43.32684, -78.830681),
    "14303": (43.086455, -79.037965),
    "14304": (43.100305, -78.952112),
    "14305": (43.117255, -79.018415),
    "14410": (43.195261, -77.855883),
    "14411": (43.235143, -78.194251),
    "14413": (43.222735, -76.982149),
    "14414": (42.895631, -77.735104),
    "14415": (42.754115, -77.026379),
    "14416": (43.073792, -78.019684),
    "14418": (42.622634, -77.227187),
    "14420": (43.223303, -77.917335),
    "14422": (43.073142, -78.056938),
    "14423": (42.935329, -77.838998),
    "14424": (42.813576, -77.289687),
    "14425": (42.958041, -77.308256),
    "14427": (42.62674, -78.059147),
    "14428": (43.074911, -77.835003),
    "14429": (43.381027, -78.231338),
    "14430": (43.286024, -77.684264),
    "14432": (42.962932, -77.150097),
    "14433": (43.097869, -76.872736),
    "14435": (42.723231, -77.668291),
    "14437": (42.61837, -77.737515),
    "14441": (42.722446, -76.963823),
    "14443": (42.900966, -77.42331),
    "14445": (43.113563, -77.482538),
    "14449": (43.235369, -77.137642),
    "14450": (43.104287, -77.428964),
    "14452": (43.381027, -78.231338),
    "14453": (43.010908, -77.47054),
    "14454": (42.783801, -77.777872),
    "14456": (42.857414, -77.034883),
    "14461": (42.808127, -77.287611),
    "14462": (42.694819, -77.754628),
    "14463": (42.796578, -77.063876),
    "14464": (43.321659, -77.925097),
    "14466": (42.78481, -77.618049),
    "14467": (43.058863, -77.558902),
    "14468": (43.28521, -77.832333),
    "14469": (42.869556, -77.465843),
    "14470": (43.21586, -78.073057),
    "14471": (42.755573, -77.491905),
    "14472": (42.982513, -77.606771),
    "14475": (42.935868, -77.498231),
    "14476": (43.324058, -78.049928),
    "14477": (43.330763, -78.123328),
    "14478": (42.570794, -77.12259),
    "14479": (43.241502, -78.318828),
    "14480": (42.837288, -77.703091),
    "14481": (42.760644, -77.90355),
    "14482": (42.95619, -77.989988),
    "14485": (42.889864, -77.608688),
    "14486": (42.915297, -77.949818),
    "14487": (42.809457, -77.650938),
    "14488": (42.729839, -77.773919),
    "14489": (43.099263, -76.970937),
    "14502": (43.110807, -77.31345),
    "14504": (42.968903, -77.233194),
    "14505": (43.15594, -77.172684),
    "14506": (43.001323, -77.504268),
    "14507": (42.686845, -77.262987),
    "14508": (43.381027, -78.231338),
    "14510": (42.683466, -77.866402),
    "14511": (43.002612, -77.86458),
    "14512": (42.667802, -77.413496),
    "14513": (43.087067, -77.097867),
    "14514": (43.085778, -77.805628),
    "14515": (43.257819, -77.735079),
    "14516": (43.195842, -76.908805),
    "14517": (42.591883, -77.894474),
    "14518": (42.931873, -77.011839),
    "14519": (43.221476, -77.308614),
    "14520": (43.348369, -77.045288),
    "14521": (42.689791, -76.794102),
    "14522": (43.081306, -77.218849),
    "14525": (42.910203, -78.026899),
    "14526": (43.145813, -77.454446),
    "14527": (42.637423, -77.069925),
    "14529": (42.535363, -77.628857),
    "14530": (42.682391, -78.056235),
    "14532": (42.963394, -77.043612),
    "14533": (42.843464, -77.896153),
    "14534": (43.060229, -77.520692),
    "14536": (42.555988, -78.098906),
    "14537": (43.033002, -77.157465),
    "14538": (43.283582, -77.142027),
    "14539": (42.834327, -77.877876),
    "14541": (42.749713, -76.844921),
    "14542": (43.144795, -76.860779),
    "14543": (42.996612999999996, -77.666524),
    "14544": (42.734157, -77.242693),
    "14545": (42.652111, -77.710539),
    "14546": (43.04471, -77.772652),
    "14547": (42.808127, -77.287611),
    "14548": (42.978834, -77.252696),
    "14549": (42.692874, -78.022364),
    "14550": (42.674209, -78.084485),
    "14551": (43.210384, -77.053517),
    "14555": (43.254644, -76.983518),
    "14556": (42.729839, -77.773919),
    "14557": (43.041606, -78.057252),
    "14558": (42.855409, -77.687643),
    "14559": (43.185709, -77.830577),
    "14560": (42.635525, -77.594478),
    "14561": (42.83336, -77.129398),
    "14563": (43.348369, -77.045288),
    "14564": (42.973715, -77.426906),
    "14568": (43.142795, -77.287414),
    "14569": (42.740223, -78.164804),
    "14571": (43.328706, -78.238501),
    "14572": (42.516793, -77.564247),
    "14580": (43.21821, -77.454075),
    "14585": (42.905459, -77.548423),
    "14586": (43.041553, -77.683575),
    "14588": (42.683451, -76.872442),
    "14589": (43.23941, -77.163811),
    "14590": (43.224693, -76.840547),
    "14591": (42.818578, -78.102549),
    "14592": (42.875685, -77.883511),
    "14601": (43.286024, -77.684264),
    "14602": (43.286024, -77.684264),
    "14603": (43.161613, -77.606774),
    "14604": (43.156612, -77.604023),
    "14605": (43.166313, -77.602973),
    "14606": (43.173612, -77.691577),
    "14607": (43.152013, -77.584888),
    "14608": (43.154611, -77.624001),
    "14609": (43.198197, -77.549971),
    "14610": (43.140163, -77.557871),
    "14611": (43.140163, -77.650275),
    "14612": (43.257111, -77.67824),
    "14613": (43.13378, -77.519325),
    "14614": (43.104463, -77.512569),
    "14615": (43.22252, -77.552021),
    "14616": (43.228955, -77.680927),
    "14617": (43.207062, -77.609425),
    "14618": (43.112163, -77.561771),
    "14619": (43.135688, -77.649126),
    "14620": (43.129862, -77.618523),
    "14621": (43.149013, -77.631124),
    "14622": (43.199613, -77.595823),
    "14623": (43.082184, -77.649074),
    "14624": (43.121612, -77.731127),
    "14625": (43.152213, -77.505705),
    "14626": (43.190312, -77.720018),
    "14627": (43.127513, -77.627674),
    "14638": (43.286024, -77.684264),
    "14639": (43.286024, -77.684264),
    "14642": (43.286024, -77.684264),
    "14643": (43.286024, -77.684264),
    "14644": (43.286024, -77.684264),
    "14645": (43.286024, -77.684264),
    "14646": (43.286024, -77.684264),
    "14647": (43.286024, -77.684264),
    "14649": (43.286024, -77.684264),
    "14650": (43.286024, -77.684264),
    "14651": (43.286024, -77.684264),
    "14652": (43.286024, -77.684264),
    "14653": (43.286024, -77.684264),
    "14660": (43.286024, -77.684264),
    "14664": (43.286024, -77.684264),
    "14673": (43.286024, -77.684264),
    "14683": (43.286024, -77.684264),
    "14692": (43.286024, -77.684264),
    "14694": (43.286024, -77.684264),
    "14701": (42.196125, -79.432256),
    "14702": (42.081657, -79.294921),
    "14703": (42.342529, -79.41091),
    "14704": (42.342529, -79.41091),
    "14706": (42.116168, -78.516218),
    "14707": (42.073739, -78.059374),
    "14708": (42.025431, -78.084837),
    "14709": (42.217609, -78.090559),
    "14710": (42.084481, -79.391738),
    "14711": (42.320366, -78.12964),
    "14712": (42.164572, -79.445292),
    "14714": (42.290569, -78.237314),
    "14715": (42.154417, -78.139391),
    "14716": (42.316748, -79.432622),
    "14717": (42.257674, -78.174601),
    "14718": (42.250021, -79.296028),
    "14719": (42.343336, -78.869752),
    "14720": (42.105907, -79.27912),
    "14721": (42.013691, -78.264775),
    "14722": (42.187468, -79.450523),
    "14723": (42.308946, -79.387594),
    "14724": (42.07268, -79.644932),
    "14726": (42.252473, -79.008294),
    "14727": (42.245997, -78.209403),
    "14728": (42.2828, -79.366516),
    "14729": (42.405354, -78.735158),
    "14730": (42.174736, -78.94734),
    "14731": (42.297229, -78.649654),
    "14732": (42.229098, -79.11347),
    "14733": (42.126604, -79.182837),
    "14735": (42.45079, -78.104285),
    "14736": (42.133206, -79.737701),
    "14737": (42.335753, -78.491244),
    "14738": (42.053586, -79.118889),
    "14739": (42.187901, -78.157246),
    "14740": (42.21129, -79.170519),
    "14741": (42.21704, -78.584117),
    "14742": (42.120512, -79.30958),
    "14743": (42.197916, -78.415859),
    "14744": (42.422827, -78.206289),
    "14745": (42.4777, -78.140343),
    "14747": (42.152725, -79.111065),
    "14748": (42.144977, -78.646626),
    "14750": (42.12481, -79.440009),
    "14751": (42.298328, -79.006231),
    "14752": (42.352416, -79.323502),
    "14753": (42.141266, -78.607674),
    "14754": (42.031872, -78.209708),
    "14755": (42.254567, -78.823628),
    "14756": (42.19815, -79.417353),
    "14757": (42.23716, -79.370911),
    "14758": (42.342529, -79.41091),
    "14760": (42.082142, -78.425973),
    "14766": (42.357543, -78.807283),
    "14767": (42.191346, -79.505101),
    "14769": (42.371561, -79.468963),
    "14770": (42.092944, -78.342341),
    "14772": (42.156841, -78.844412),
    "14774": (42.114385, -78.168055),
    "14775": (42.230461, -79.42678),
    "14777": (42.397363, -78.23233),
    "14778": (42.270112, -78.684684),
    "14779": (42.180526, -78.615625),
    "14781": (42.172076, -79.611348),
    "14782": (42.257762, -79.253829),
    "14783": (42.082001, -78.917738),
    "14784": (42.31514, -79.38833),
    "14785": (42.155693, -79.412233),
    "14786": (42.12267, -78.221332),
    "14787": (42.253734, -79.484286),
    "14788": (42.062125, -78.377974),
    "14801": (42.206390999999996, -77.306185),
    "14802": (42.240535, -77.783192),
    "14803": (42.254097, -77.799317),
    "14804": (42.313285, -77.851286),
    "14805": (42.375566, -76.732706),
    "14806": (42.145794, -77.811901),
    "14807": (42.465145, -77.57387),
    "14808": (42.562012, -77.468518),
    "14809": (42.367861, -77.464128),
    "14810": (42.357464, -77.302789),
    "14812": (42.322924, -76.977336),
    "14813": (42.242168, -77.963148),
    "14814": (42.156516, -76.93164),
    "14815": (42.369808, -77.235796),
    "14816": (42.199631, -76.7312),
    "14817": (42.359694, -76.349154),
    "14818": (42.464152, -76.798018),
    "14819": (42.211491, -77.453509),
    "14820": (42.180046, -77.280502),
    "14821": (42.262954, -77.215478),
    "14822": (42.422577, -77.835626),
    "14823": (42.348146, -77.42713),
    "14824": (42.272948, -76.693628),
    "14825": (42.052426, -76.607029),
    "14826": (42.470356, -77.391286),
    "14827": (42.178527, -77.141357),
    "14830": (42.120541, -77.048462),
    "14831": (42.145265, -77.56683),
    "14836": (42.546164, -77.90021),
    "14837": (42.555387, -77.014409),
    "14838": (42.181224, -76.671949),
    "14839": (42.143242, -77.562991),
    "14840": (42.322455, -77.198396),
    "14841": (42.492291, -76.824556),
    "14842": (42.577714, -76.96452),
    "14843": (42.383978, -77.479051),
    "14844": (42.160717, -76.878456),
    "14845": (42.21003, -76.836629),
    "14846": (42.555834, -77.999451),
    "14847": (42.60844, -76.735556),
    "14850": (42.402794, -76.483999),
    "14851": (42.460721, -76.505435),
    "14852": (42.445074, -76.467233),
    "14853": (42.447373, -76.483703),
    "14854": (42.50632, -76.608222),
    "14855": (42.142197, -77.497908),
    "14856": (42.374218, -77.364812),
    "14857": (42.512631999999996, -76.927019),
    "14858": (42.04507, -77.106679),
    "14859": (42.115457, -76.507823),
    "14860": (42.586029, -76.801671),
    "14861": (42.087671, -76.684615),
    "14863": (42.451569, -76.706717),
    "14864": (42.259644, -76.842298),
    "14865": (42.358866, -76.841852),
    "14867": (42.365688, -76.610212),
    "14869": (42.377454, -76.77621),
    "14870": (42.159759, -77.382462),
    "14871": (42.047024, -76.882455),
    "14872": (42.240529, -76.875072),
    "14873": (42.38056, -77.354408),
    "14874": (42.520261, -77.197141),
    "14876": (42.429721, -76.925846),
    "14877": (42.071887, -77.677653),
    "14878": (42.48015, -76.946931),
    "14879": (42.327262, -77.193204),
    "14880": (42.16615, -77.965672),
    "14881": (42.402463, -76.360782),
    "14882": (42.573453, -76.552378),
    "14883": (42.203102, -76.471165),
    "14884": (42.455859, -77.889425),
    "14885": (42.060366, -77.562142),
    "14886": (42.4803, -76.635158),
    "14887": (42.399371, -77.026768),
    "14889": (42.210223, -76.585084),
    "14891": (42.37285, -76.927135),
    "14892": (42.107825, -76.502218),
    "14893": (42.474143, -77.097713),
    "14894": (42.027102, -76.764516),
    "14895": (42.230956, -77.917245),
    "14897": (42.050965, -77.821349),
    "14898": (42.069469, -77.438058),
    "14901": (42.082585, -76.71857),
    "14902": (42.147285, -76.750888),
    "14903": (42.119824, -76.887659),
    "14904": (42.061824, -76.823678),
    "14905": (42.093574, -76.844329),
    "14925": (42.147285, -76.750888),
    "15001": (40.675225, -80.304178),
    "15003": (40.600494, -80.210521),
    "15004": (40.341349, -80.382247),
    "15005": (40.618418, -80.204103),
    "15006": (40.493128, -79.903121),
    "15007": (40.434436, -80.024817),
    "15009": (40.729053, -80.385191),
    "15010": (40.665672, -80.352049),
    "15012": (40.070268, -79.603426),
    "15014": (40.272101, -79.899562),
    "15015": (40.434436, -80.024817),
    "15017": (40.354589, -80.091342),
    "15018": (40.457657, -80.208374),
    "15019": (40.412663, -80.317007),
    "15020": (40.434436, -80.024817),
    "15021": (40.382141, -80.404366),
    "15022": (40.135834, -79.932907),
    "15024": (40.434436, -80.024817),
    "15025": (40.324279, -79.931735),
    "15026": (40.490003, -80.290333),
    "15027": (40.699515, -80.264683),
    "15028": (40.434436, -80.024817),
    "15030": (40.434436, -80.024817),
    "15031": (40.354712, -80.166906),
    "15032": (40.434436, -80.024817),
    "15033": (40.179896, -79.868392),
    "15034": (40.315793, -79.892171),
    "15035": (40.434436, -80.024817),
    "15036": (40.214896, -80.179139),
    "15037": (40.271965, -79.896642),
    "15038": (40.252086, -79.925235),
    "15042": (40.710283, -80.240559),
    "15043": (40.639461, -80.339953),
    "15044": (40.434436, -80.024817),
    "15045": (40.434436, -80.024817),
    "15046": (40.468068, -80.123459),
    "15047": (40.434436, -80.024817),
    "15049": (40.434436, -80.024817),
    "15050": (40.554305, -80.428223),
    "15051": (40.434436, -80.024817),
    "15052": (40.702397, -80.388271),
    "15053": (40.380036, -80.360544),
    "15054": (40.362515, -80.408551),
    "15055": (40.305838, -80.121904),
    "15056": (40.375069, -80.015425),
    "15057": (40.359139, -80.267451),
    "15059": (40.740063, -80.397486),
    "15060": (40.368121, -80.289382),
    "15061": (40.656366, -80.327814),
    "15062": (40.361852, -79.75128),
    "15063": (40.260001, -80.124442),
    "15064": (40.355865, -80.14155),
    "15065": (40.434436, -80.024817),
    "15066": (40.712175, -80.321773),
    "15067": (40.282786, -80.173907),
    "15068": (40.478821, -79.581506),
    "15069": (40.360223, -79.439801),
    "15071": (40.403348, -80.184169),
    "15072": (40.139296, -79.856168),
    "15074": (40.686473, -80.326538),
    "15075": (40.434436, -80.024817),
    "15076": (40.434436, -80.024817),
    "15077": (40.602535, -80.386344),
    "15078": (40.358435, -80.387917),
    "15081": (40.576267, -80.238332),
    "15082": (40.386263, -80.208316),
    "15083": (40.22559, -79.751605),
    "15084": (40.434436, -80.024817),
    "15085": (40.382668, -79.594643),
    "15086": (40.434436, -80.024817),
    "15087": (40.360223, -79.439801),
    "15088": (40.271597, -79.89661),
    "15089": (40.201808, -79.727237),
    "15090": (40.434436, -80.024817),
    "15091": (40.434436, -80.024817),
    "15095": (40.434436, -80.024817),
    "15096": (40.434436, -80.024817),
    "15101": (40.434436, -80.024817),
    "15102": (40.371471, -80.11595),
    "15104": (40.366287, -79.858359),
    "15106": (40.44908, -80.103165),
    "15108": (40.469268, -80.140228),
    "15110": (40.372069, -79.85382),
    "15112": (40.434436, -80.024817),
    "15116": (40.357719, -79.979974),
    "15120": (40.392619, -79.905171),
    "15122": (40.360575, -79.908621),
    "15123": (40.434436, -80.024817),
    "15126": (40.452644, -80.128852),
    "15127": (40.434436, -80.024817),
    "15129": (40.303119, -79.997567),
    "15130": (40.434436, -80.024817),
    "15131": (40.434436, -80.024817),
    "15132": (40.407269, -80.048026),
    "15133": (40.323419, -79.940172),
    "15134": (40.434436, -80.024817),
    "15135": (40.434436, -80.024817),
    "15136": (40.467006, -80.103669),
    "15137": (40.434436, -80.024817),
    "15139": (40.434436, -80.024817),
    "15140": (40.434436, -80.024817),
    "15142": (40.402452, -80.166896),
    "15143": (40.451367, -80.20828),
    "15144": (40.434436, -80.024817),
    "15145": (40.434436, -80.024817),
    "15146": (40.548117, -80.236882),
    "15147": (40.351469, -80.011574),
    "15148": (40.434436, -80.024817),
    "15189": (40.434436, -80.024817),
    "15201": (40.434436, -80.024817),
    "15202": (40.328598, -79.949182),
    "15203": (40.425369, -79.979914),
    "15204": (40.455368, -80.064416),
    "15205": (40.432205, -80.102101),
    "15206": (40.416419, -80.075427),
    "15207": (40.356169, -79.982123),
    "15208": (40.519017, -80.16608),
    "15209": (40.392719, -80.042375),
    "15210": (40.419662, -80.027243),
    "15211": (40.429519, -80.014375),
    "15212": (40.428169, -80.074977),
    "15213": (40.423069, -79.980624),
    "15214": (40.434436, -80.024817),
    "15215": (40.377569, -79.994074),
    "15216": (40.400091, -80.046176),
    "15217": (40.385219, -80.054876),
    "15218": (40.434436, -80.024817),
    "15219": (40.375351, -80.017075),
    "15220": (40.418119, -80.052576),
    "15221": (40.414611, -80.043342),
    "15222": (40.434436, -80.024817),
    "15223": (40.457418, -80.044926),
    "15224": (40.434436, -80.024817),
    "15225": (40.505118, -80.115528),
    "15226": (40.40014, -80.016074),
    "15227": (40.380519, -79.966723),
    "15228": (40.369569, -80.043925),
    "15229": (40.434436, -80.024817),
    "15230": (40.434436, -80.024817),
    "15231": (40.434436, -80.024817),
    "15232": (40.434436, -80.024817),
    "15233": (40.434436, -80.024817),
    "15234": (40.368819, -80.022399),
    "15235": (40.398608, -80.000854),
    "15236": (40.33514, -79.983243),
    "15237": (40.434436, -80.024817),
    "15238": (40.380019, -80.006474),
    "15239": (40.434436, -80.024817),
    "15240": (40.434436, -80.024817),
    "15241": (40.332266, -80.081026),
    "15242": (40.434436, -80.024817),
    "15243": (40.384169, -80.072876),
    "15244": (40.434436, -80.024817),
    "15250": (40.434436, -80.024817),
    "15251": (40.434436, -80.024817),
    "15252": (40.434436, -80.024817),
    "15253": (40.434436, -80.024817),
    "15254": (40.434436, -80.024817),
    "15255": (40.434436, -80.024817),
    "15257": (40.434436, -80.024817),
    "15258": (40.434436, -80.024817),
    "15259": (40.434436, -80.024817),
    "15260": (40.434436, -80.024817),
    "15261": (40.434436, -80.024817),
    "15262": (40.434436, -80.024817),
    "15263": (40.434436, -80.024817),
    "15264": (40.434436, -80.024817),
    "15265": (40.434436, -80.024817),
    "15266": (40.434436, -80.024817),
    "15267": (40.434436, -80.024817),
    "15268": (40.434436, -80.024817),
    "15270": (40.434436, -80.024817),
    "15272": (40.434436, -80.024817),
    "15274": (40.434436, -80.024817),
    "15275": (40.44952, -80.179475),
    "15276": (40.434436, -80.024817),
    "15277": (40.434436, -80.024817),
    "15278": (40.434436, -80.024817),
    "15279": (40.434436, -80.024817),
    "15281": (40.434436, -80.024817),
    "15282": (40.434436, -80.024817),
    "15283": (40.434436, -80.024817),
    "15285": (40.434436, -80.024817),
    "15286": (40.434436, -80.024817),
    "15290": (40.434436, -80.024817),
    "15295": (40.434436, -80.024817),
    "15301": (40.135391, -80.146709),
    "15310": (39.870635, -80.211335),
    "15311": (40.049765, -80.168133),
    "15312": (40.200737, -80.267148),
    "15313": (40.065496, -80.022102),
    "15314": (40.153459, -80.083967),
    "15315": (39.817048, -79.956728),
    "15316": (39.870635, -80.211335),
    "15317": (40.155704, -80.12842),
    "15320": (39.918913, -79.98532),
    "15321": (40.159268, -80.104193),
    "15322": (39.966702, -80.045233),
    "15323": (40.11016, -80.251693),
    "15324": (40.050163, -79.98324),
    "15325": (39.95017, -79.967626),
    "15327": (39.764089, -79.937419),
    "15329": (40.049949, -80.28121),
    "15330": (40.17557, -80.099336),
    "15331": (40.106824, -80.021614),
    "15332": (40.19897, -80.059974),
    "15333": (40.025105, -80.011741),
    "15334": (39.870635, -80.211335),
    "15336": (40.260141, -79.992678),
    "15337": (39.937962, -80.001496),
    "15338": (39.820941, -79.974551),
    "15339": (40.301838, -80.15431),
    "15340": (40.226863, -80.169026),
    "15341": (39.870635, -80.211335),
    "15342": (40.133091, -80.133451),
    "15344": (39.870635, -80.211335),
    "15345": (40.028432, -80.104213),
    "15346": (39.934662, -80.070275),
    "15347": (40.217358, -80.226885),
    "15348": (39.987651, -80.003686),
    "15349": (39.774031, -80.024576),
    "15350": (40.293731, -80.200484),
    "15351": (39.877901, -79.925807),
    "15352": (39.870635, -80.211335),
    "15353": (39.870635, -80.211335),
    "15354": (39.870635, -80.211335),
    "15357": (39.95437, -79.990431),
    "15358": (40.056347, -79.992554),
    "15359": (39.870635, -80.211335),
    "15360": (40.092344, -80.099457),
    "15361": (40.32819, -80.256291),
    "15362": (39.744657, -80.214471),
    "15363": (40.250454, -80.198354),
    "15364": (39.870635, -80.211335),
    "15365": (40.16113, -80.378093),
    "15366": (40.110068, -80.031787),
    "15367": (40.244339, -80.247797),
    "15368": (40.023775, -80.007731),
    "15370": (39.87477, -80.08057),
    "15376": (40.128081, -80.270231),
    "15377": (40.024677, -80.429726),
    "15378": (40.277534, -80.27313),
    "15379": (40.241731, -80.424154),
    "15380": (39.909365, -80.43004),
    "15401": (39.944884, -79.770063),
    "15410": (39.912105, -79.89636),
    "15411": (39.752401, -79.330768),
    "15412": (40.095888, -79.849887),
    "15413": (39.986828, -79.863732),
    "15415": (39.980787, -79.850366),
    "15416": (39.932084, -79.65217),
    "15417": (39.921613, -79.690472),
    "15419": (40.068921, -79.873163),
    "15420": (39.932084, -79.65217),
    "15421": (39.845088, -79.599126),
    "15422": (39.992254, -79.817083),
    "15423": (40.082192, -79.930266),
    "15424": (39.824325, -79.306409),
    "15425": (40.00743, -79.700949),
    "15427": (40.065064, -79.973302),
    "15428": (39.983001, -79.725516),
    "15429": (40.008082, -79.939234),
    "15430": (40.041785, -79.659978),
    "15431": (39.949088, -79.723151),
    "15432": (40.099693, -79.85968),
    "15433": (39.973512, -79.704535),
    "15434": (40.080438, -79.875826),
    "15435": (39.950123, -79.858471),
    "15436": (39.954424, -79.808073),
    "15437": (39.79741, -79.596769),
    "15438": (40.066729, -79.844514),
    "15439": (39.771324, -79.635842),
    "15440": (39.757751, -79.628365),
    "15442": (40.015516, -79.843978),
    "15443": (39.926347, -79.901324),
    "15444": (40.05656, -79.902101),
    "15445": (39.876835, -79.671812),
    "15446": (40.037453, -79.377806),
    "15447": (39.945987, -79.939317),
    "15448": (40.360223, -79.439801),
    "15449": (39.963622, -79.785349),
    "15450": (39.998279, -79.975391),
    "15451": (39.742861, -79.854871),
    "15454": (39.932084, -79.65217),
    "15455": (39.998536, -79.643451),
    "15456": (39.877276, -79.805549),
    "15458": (39.888242, -79.869352),
    "15459": (39.822431, -79.529731),
    "15460": (39.932084, -79.65217),
    "15461": (39.94577, -79.681838),
    "15462": (40.05974, -79.381435),
    "15463": (39.882521, -79.833585),
    "15464": (39.933738, -79.432647),
    "15465": (39.932084, -79.65217),
    "15466": (40.075064, -79.894347),
    "15467": (39.932084, -79.65217),
    "15468": (39.941838, -79.841031),
    "15469": (40.00786, -79.438215),
    "15470": (39.850675, -79.523004),
    "15472": (39.918319, -79.715837),
    "15473": (40.064564, -79.775594),
    "15474": (39.911834, -79.71174),
    "15475": (39.984667, -79.881421),
    "15476": (39.879384, -79.916806),
    "15477": (40.080713, -79.862734),
    "15478": (39.92959, -79.698875),
    "15479": (40.155299, -79.738092),
    "15480": (39.988339, -79.771265),
    "15482": (40.065106, -79.769027),
    "15483": (40.038498, -79.920937),
    "15484": (39.893625, -79.785642),
    "15485": (39.817346, -79.330642),
    "15486": (40.010683, -79.750787),
    "15488": (39.976316, -79.768901),
    "15489": (39.956056, -79.700745),
    "15490": (40.075857, -79.452796),
    "15492": (40.117828, -79.771797),
    "15501": (39.990045, -79.08745),
    "15502": (40.046023, -79.258458),
    "15510": (39.963306, -79.04089),
    "15520": (40.113021, -79.070218),
    "15521": (40.198627, -78.622801),
    "15522": (39.95464, -78.574759),
    "15530": (39.942768, -78.981234),
    "15531": (40.006392, -78.989292),
    "15532": (39.767296, -79.062012),
    "15533": (39.98344, -78.251177),
    "15534": (39.864251, -78.674197),
    "15535": (39.839294, -78.469881),
    "15536": (39.943762, -78.122265),
    "15537": (39.966962, -78.458753),
    "15538": (39.945164, -78.954581),
    "15539": (40.130173, -78.591457),
    "15540": (39.796137, -79.247161),
    "15541": (40.085382, -78.963508),
    "15542": (39.8659, -79.074705),
    "15544": (40.137749, -79.092551),
    "15545": (39.886506, -78.712775),
    "15546": (40.145938, -79.067583),
    "15547": (40.1595, -79.061629),
    "15548": (40.101106, -78.938653),
    "15549": (40.020764, -79.012306),
    "15550": (39.902488, -78.658195),
    "15551": (39.887287, -79.254694),
    "15552": (39.875014, -79.038599),
    "15553": (39.982795, -78.771929),
    "15554": (39.981413, -78.611595),
    "15555": (40.091429, -79.087198),
    "15557": (39.955145, -79.141476),
    "15558": (39.941261, -79.083318),
    "15559": (40.057047, -78.642513),
    "31299": (32.806707, -83.691315),
    "15560": (40.017059, -78.907682),
    "15561": (40.096406, -79.090158),
    "15562": (39.74802, -79.123732),
    "15563": (40.094802, -78.965817),
    "15564": (39.729896, -78.844105),
    "15565": (40.003476, -79.037983),
    "15601": (40.347017, -79.500729),
    "15605": (40.360223, -79.439801),
    "15606": (40.360223, -79.439801),
    "15610": (40.120149, -79.405069),
    "15611": (40.303771, -79.653058),
    "15612": (40.360223, -79.439801),
    "15613": (40.436827, -79.617178),
    "15615": (40.360619, -79.743317),
    "15616": (40.360223, -79.439801),
    "15617": (40.360223, -79.439801),
    "15618": (40.497049, -79.489055),
    "15619": (40.360223, -79.439801),
    "15620": (40.323845, -79.343421),
    "15621": (40.360223, -79.439801),
    "15622": (40.190193, -79.30196),
    "15623": (40.36921, -79.619012),
    "15624": (40.357753, -79.484028),
    "15625": (40.360223, -79.439801),
    "15626": (40.36131, -79.571423),
    "15627": (40.350227, -79.402056),
    "15628": (40.102807, -79.377008),
    "15629": (40.598047, -79.562383),
    "15630": (40.847829, -79.451575),
    "15631": (40.084517, -79.590529),
    "15632": (40.429723, -79.634789),
    "15633": (40.357548, -79.522546),
    "15634": (40.308892, -79.66542),
    "15635": (40.352037, -79.49789),
    "15636": (40.36602, -79.656525),
    "15637": (40.266168, -79.56779),
    "15638": (40.26106, -79.14313),
    "15639": (40.328617, -79.624473),
    "15640": (40.225086, -79.732805),
    "15641": (40.628165, -79.595648),
    "15642": (40.36502, -79.58406),
    "15644": (40.374572, -79.407913),
    "15646": (40.360223, -79.439801),
    "15647": (40.341519, -79.727216),
    "15650": (40.35577, -79.421969),
    "15655": (40.231409, -79.171459),
    "15656": (40.63896, -79.610962),
    "15658": (40.271322, -79.251145),
    "15660": (40.248798, -79.764638),
    "15661": (40.286515, -79.513433),
    "15662": (40.360223, -79.439801),
    "15663": (40.24397, -79.676516),
    "15664": (40.310772, -79.617187),
    "15665": (40.292194, -79.664868),
    "15666": (40.202211, -79.609982),
    "15668": (40.423293, -79.663288),
    "15670": (40.396655, -79.444008),
    "15671": (40.349446, -79.322549),
    "15672": (40.24375, -79.658436),
    "15673": (40.593035, -79.558098),
    "15674": (40.216006, -79.487239),
    "15675": (40.314908, -79.681435),
    "15676": (40.242429, -79.454212),
    "15677": (40.360223, -79.439801),
    "15678": (40.282843, -79.723278),
    "15679": (40.226934, -79.673364),
    "15680": (40.518905, -79.495871),
    "15681": (40.542875, -79.397809),
    "15682": (40.847829, -79.451575),
    "15683": (40.35535, -79.520544),
    "15684": (40.46037, -79.515628),
    "15685": (40.360223, -79.439801),
    "15686": (40.616816, -79.479833),
    "15687": (40.360223, -79.439801),
    "15688": (40.360223, -79.439801),
    "15689": (40.360223, -79.439801),
    "15690": (40.400412, -79.546855),
    "15691": (40.294021, -79.686626),
    "15692": (40.329386, -79.680567),
    "15693": (40.248274, -79.408579),
    "15695": (40.196199, -79.694244),
    "15696": (40.279337, -79.366066),
    "15697": (40.240536, -79.505889),
    "15698": (40.222685, -79.691067),
    "15701": (40.621272, -79.080422),
    "15705": (40.640031, -79.129445),
    "15710": (40.633313, -78.872314),
    "15711": (41.171119, -78.913113),
    "15712": (40.781719, -78.853612),
    "15713": (40.61927, -79.083982),
    "15714": (40.658721, -78.794582),
    "15715": (40.970448, -78.875799),
    "15716": (40.483646, -79.206322),
    "15717": (40.486445, -79.195766),
    "15720": (40.529238, -79.0846),
    "15721": (41.054375, -78.41095),
    "15722": (40.583025, -78.728455),
    "15723": (40.705639, -79.16151),
    "15724": (40.724976, -78.860324),
    "15725": (40.632813, -79.132551),
    "15727": (40.55027, -79.323745),
    "15728": (40.748901, -78.997726),
    "15729": (40.706462, -78.924401),
    "15730": (40.967066, -78.925563),
    "15731": (40.498602, -79.173892),
    "15732": (40.661336, -79.217127),
    "15733": (41.141079, -78.962877),
    "15734": (40.718817, -78.979489),
    "15736": (40.692153, -79.34218),
    "15737": (40.607635, -78.752415),
    "15738": (40.693633, -78.775076),
    "15739": (40.677971, -79.165708),
    "15740": (41.141079, -78.962877),
    "15741": (40.796017, -78.858614),
    "15742": (40.804413, -78.889036),
    "15744": (41.141079, -78.962877),
    "15745": (40.620736, -78.918561),
    "15746": (40.767854, -78.877331),
    "15747": (40.701519, -79.182743),
    "15748": (40.627752, -79.089616),
    "15750": (40.482783, -79.185048),
    "15751": (40.640031, -79.129445),
    "15752": (40.5412, -79.282047),
    "15753": (40.989115, -78.422403),
    "15754": (40.500198, -79.176571),
    "15756": (40.568381, -79.299931),
    "15757": (40.989115, -78.422403),
    "15758": (40.640031, -79.129445),
    "15759": (40.685945, -79.051607),
    "15760": (40.652187, -78.80542),
    "15761": (40.620066, -78.887009),
    "15762": (40.600962, -78.82209),
    "15763": (40.640031, -79.129445),
    "15764": (41.141079, -78.962877),
    "15765": (40.621281, -78.99431),
    "15767": (40.944538, -78.979845),
    "15770": (41.141079, -78.962877),
    "15771": (40.72193, -79.006162),
    "15772": (40.869654, -78.900483),
    "15773": (40.629818, -78.732947),
    "15774": (40.847829, -79.451575),
    "15775": (40.63513, -78.769185),
    "15776": (41.141079, -78.962877),
    "15777": (40.702673, -78.958847),
    "15778": (40.967353, -79.199017),
    "15779": (40.360223, -79.439801),
    "15780": (41.141079, -78.962877),
    "15781": (41.141079, -78.962877),
    "15783": (40.583778, -79.342331),
    "15784": (41.141079, -78.962877),
    "15801": (41.118045, -78.720302),
    "15821": (41.415878, -78.665057),
    "15822": (41.415878, -78.665057),
    "15823": (41.253932, -78.699711),
    "15824": (41.247202, -78.7989),
    "15825": (41.162735, -79.081609),
    "15827": (41.291008, -78.50435),
    "15828": (41.475887, -79.239101),
    "15829": (41.141079, -78.962877),
    "15831": (41.304782, -78.621286),
    "15832": (41.417566, -78.204927),
    "15834": (41.51031, -78.23157),
    "15840": (41.149752, -78.820695),
    "15841": (41.283709, -78.551668),
    "15845": (41.504669, -78.687183),
    "15846": (41.336887, -78.605537),
    "15847": (41.141079, -78.962877),
    "15848": (40.989115, -78.422403),
    "15849": (41.20156, -78.583502),
    "15851": (41.095556, -78.886154),
    "15853": (41.362112, -78.726238),
    "15856": (40.989115, -78.422403),
    "15857": (41.452935, -78.529829),
    "15860": (41.141079, -78.962877),
    "15861": (41.417566, -78.204927),
    "15863": (41.141079, -78.962877),
    "15864": (41.141079, -78.962877),
    "15865": (41.047897, -78.819682),
    "15866": (41.011686, -78.785731),
    "15868": (41.279081, -78.527949),
    "15870": (41.572956, -78.665262),
    "15901": (40.412707, -78.854245),
    "15902": (40.417111, -78.80599),
    "15904": (40.319279, -78.828084),
    "15905": (40.314074, -78.870894),
    "15906": (40.494132, -78.838673),
    "15907": (40.325374, -78.915147),
    "15909": (40.440314, -78.85591),
    "15915": (40.484487, -78.702224),
    "15920": (40.460262, -79.009721),
    "15921": (40.319561, -78.694043),
    "15922": (40.484487, -78.702224),
    "15923": (40.348279, -79.15321),
    "15924": (40.11492, -78.7851),
    "15925": (40.4128, -78.633698),
    "15926": (40.074818, -78.83817),
    "15927": (40.538311, -78.786549),
    "15928": (40.23523, -78.919007),
    "15929": (40.462521, -79.012834),
    "15930": (40.293935, -78.719217),
    "15931": (40.459581, -78.771875),
    "15934": (40.279925, -78.803247),
    "15935": (40.20137, -78.958371),
    "15936": (40.155129, -78.916785),
    "15937": (40.208435, -78.987265),
    "15938": (40.427588, -78.639257),
    "15940": (40.517191, -78.61487),
    "15942": (40.419784, -78.823794),
    "15943": (40.392443, -78.848566),
    "15944": (40.326182, -79.101925),
    "15945": (40.356723, -78.873296),
    "15946": (40.369239, -78.752509),
    "15948": (40.464069, -78.685365),
    "15949": (40.403698, -79.12204),
    "15951": (40.338615, -78.776137),
    "15952": (40.298574, -78.781592),
    "15953": (40.206435, -78.900533),
    "15954": (40.401071, -79.029098),
    "15955": (40.334129, -78.715511),
    "15956": (40.41164, -78.778413),
    "15957": (40.572746, -78.900034),
    "15958": (40.39114, -78.735229),
    "15959": (40.267975, -78.915567),
    "15960": (40.49963, -78.861308),
    "15961": (40.437721, -78.924998),
    "15962": (40.380188, -78.719019),
    "15963": (40.180418, -78.829021),
    "16001": (40.885861, -79.934048),
    "16002": (40.8409, -79.859175),
    "16003": (40.921145, -79.92758),
    "16016": (40.921145, -79.92758),
    "16017": (40.921145, -79.92758),
    "16018": (40.921145, -79.92758),
    "16020": (41.106846, -79.900626),
    "16021": (40.921145, -79.92758),
    "16022": (41.055515, -79.731308),
    "16023": (40.792353, -79.760048),
    "16024": (40.921867, -79.994747),
    "16025": (40.940484, -79.777107),
    "16027": (40.826436, -80.013785),
    "16028": (40.98399, -79.615234),
    "16029": (40.780174, -79.780792),
    "16030": (41.136538, -79.802384),
    "16033": (40.904798, -79.936488),
    "16034": (40.864921, -79.735066),
    "16035": (41.106756, -80.007017),
    "16036": (41.202325, -79.453751),
    "16037": (40.8282, -80.09825),
    "16038": (40.935262, -80.00865),
    "16039": (40.921145, -79.92758),
    "16040": (41.091444, -79.835723),
    "16041": (41.005368, -79.766612),
    "16045": (40.801238, -79.963774),
    "16046": (40.866316, -79.936986),
    "16048": (41.04719, -79.808899),
    "16049": (41.093079, -79.682532),
    "16050": (41.041059, -79.762814),
    "16051": (41.01782, -80.072356),
    "16052": (40.956173, -79.933127),
    "16053": (40.803054, -79.990821),
    "16054": (41.202325, -79.453751),
    "16055": (40.720919, -79.76262),
    "16056": (40.861995, -79.864282),
    "16057": (41.052427, -80.043821),
    "16058": (41.202325, -79.453751),
    "16059": (40.710689, -79.937074),
    "16061": (41.021754, -79.884312),
    "16063": (40.7609, -80.10939),
    "16066": (40.709713, -80.104597),
    "16101": (40.964516, -80.300736),
    "16102": (40.9613, -80.408502),
    "16103": (40.989662, -80.308376),
    "16105": (41.024051, -80.345444),
    "16107": (40.989662, -80.308376),
    "16108": (40.989662, -80.308376),
    "16110": (41.629436, -80.214024),
    "16111": (41.524812, -80.32056),
    "16112": (40.95621, -80.486131),
    "16113": (41.286567, -80.423727),
    "16114": (41.405788, -80.184099),
    "16115": (40.786243999999996, -80.391487),
    "16116": (41.031749, -80.457328),
    "16117": (40.917478, -80.363481),
    "16120": (40.905222, -80.468225),
    "16121": (41.210606, -80.487821),
    "16123": (40.813208, -80.199126),
    "16124": (41.334133, -80.262473),
    "16125": (41.326606, -80.288302),
    "16127": (41.170823, -80.089581),
    "16130": (41.32821, -80.292168),
    "16131": (41.534292, -80.417374),
    "16132": (41.011263, -80.497546),
    "16133": (41.278208, -80.113231),
    "16134": (41.456649, -80.449185),
    "16136": (40.834767, -80.328009),
    "16137": (41.222885, -80.250704),
    "16140": (40.989662, -80.308376),
    "16141": (40.833615, -80.384434),
    "16142": (41.10446, -80.352749),
    "16143": (41.087533, -80.472593),
    "16145": (41.380743, -80.21727),
    "16146": (41.234505, -80.44793),
    "16148": (41.221984, -80.438887),
    "16150": (41.283776, -80.400053),
    "16151": (41.44346, -80.205513),
    "16153": (41.335562, -80.10361),
    "16154": (41.368354, -80.360703),
    "16155": (40.989662, -80.308376),
    "16156": (41.089458, -80.19346),
    "16157": (40.893341, -80.33774),
    "16159": (41.238352, -80.300747),
    "16160": (40.930132, -80.361099),
    "16161": (41.200256, -80.502702),
    "16172": (41.119992, -80.333192),
    "16201": (40.817197, -79.419457),
    "16210": (40.855727, -79.545145),
    "16211": (40.640031, -79.129445),
    "16212": (40.754086, -79.580912),
    "16213": (41.123556, -79.568457),
    "16214": (41.143274, -79.452051),
    "16215": (40.847829, -79.451575),
    "16216": (40.847829, -79.451575),
    "16217": (41.475887, -79.239101),
    "16218": (40.847829, -79.451575),
    "16220": (41.202325, -79.453751),
    "16221": (41.202325, -79.453751),
    "16222": (40.881227, -79.240054),
    "16223": (40.847829, -79.451575),
    "16224": (41.202325, -79.453751),
    "16225": (41.202325, -79.453751),
    "16226": (40.79965, -79.420198),
    "16228": (40.756829, -79.522225),
    "16229": (40.743732, -79.46114),
    "16230": (41.017753, -79.279932),
    "16232": (41.190299, -79.592521),
    "16233": (41.388826, -79.273662),
    "16234": (41.202325, -79.453751),
    "16235": (41.300236, -79.35779),
    "16236": (40.781788, -79.521842),
    "16238": (40.787688, -79.521034),
    "16239": (41.469973, -79.125004),
    "16240": (41.202325, -79.453751),
    "16242": (41.12698, -79.40791),
    "16244": (40.847829, -79.451575),
    "16245": (40.847829, -79.451575),
    "16246": (40.640031, -79.129445),
    "16248": (41.041098, -79.501668),
    "16249": (40.746619, -79.496645),
    "16250": (40.777387, -79.233585),
    "16253": (40.847829, -79.451575),
    "16254": (41.263674, -79.434105),
    "16255": (41.105702, -79.489973),
    "16256": (40.867654, -79.141344),
    "16257": (41.202325, -79.453751),
    "16258": (41.235244, -79.281881),
    "16259": (40.915899, -79.461201),
    "16260": (41.202325, -79.453751),
    "16261": (40.847829, -79.451575),
    "16262": (40.837764, -79.629766),
    "16263": (40.847829, -79.451575),
    "16301": (41.330725, -79.775153),
    "16311": (41.456666, -80.043012),
    "16312": (41.935848, -79.309668),
    "16313": (41.798453, -79.193751),
    "16314": (41.51838, -80.047368),
    "16316": (41.616247, -80.306783),
    "16317": (41.496472, -79.887384),
    "16319": (41.398105, -79.738809),
    "16321": (41.475887, -79.239101),
    "16322": (41.475887, -79.239101),
    "16323": (41.335291, -79.783172),
    "16326": (41.202325, -79.453751),
    "16327": (41.666057, -80.065793),
    "16328": (41.666057, -80.065793),
    "16329": (41.811682, -79.264322),
    "16331": (41.202325, -79.453751),
    "16332": (41.355729, -79.381225),
    "16333": (41.742791, -78.78726),
    "16334": (41.202325, -79.453751),
    "16335": (41.611599, -80.114891),
    "16340": (41.862381, -79.432589),
    "16341": (41.501311, -79.633336),
    "16342": (41.320273, -79.926847),
    "16343": (41.411018, -79.749341),
    "16344": (41.471714, -79.688057),
    "16345": (41.926402, -79.090299),
    "16346": (41.378581, -79.707212),
    "16347": (41.68338, -79.032776),
    "16350": (41.890561, -79.227866),
    "16351": (41.830662, -79.229452),
    "16352": (41.743431, -79.052756),
    "16353": (41.500915, -79.407452),
    "16354": (41.661775, -79.720068),
    "16360": (41.689858, -79.900897),
    "16361": (41.202325, -79.453751),
    "16362": (41.398105, -79.738809),
    "16364": (41.398105, -79.738809),
    "16365": (41.84356, -79.172619),
    "16366": (41.811682, -79.264322),
    "16367": (41.811682, -79.264322),
    "16368": (41.811682, -79.264322),
    "16369": (41.811682, -79.264322),
    "16370": (41.475887, -79.239101),
    "16371": (41.823681, -79.201275),
    "16372": (41.199287, -79.874548),
    "16373": (41.273318, -79.812491),
    "16374": (41.398105, -79.738809),
    "16375": (41.202325, -79.453751),
    "16388": (41.659552, -80.157553),
    "16401": (41.894652, -80.311081),
    "16402": (41.969142, -79.477037),
    "16403": (41.803393, -80.059383),
    "16404": (41.666057, -80.065793),
    "16405": (41.943966, -79.568294),
    "16406": (41.757871, -80.370323),
    "16407": (41.924886, -79.696549),
    "16410": (41.921275, -80.302761),
    "16411": (41.982574, -80.439619),
    "16412": (41.90425, -80.157715),
    "16413": (42.182748, -80.064915),
    "16415": (42.011544, -80.335032),
    "16416": (41.818831, -79.446306),
    "16417": (41.950719, -80.295852),
    "16420": (41.811682, -79.264322),
    "16421": (42.172938, -79.937675),
    "16422": (41.643145, -80.394299),
    "16423": (42.015789, -80.346492),
    "16424": (41.624388, -80.452295),
    "16426": (41.985964, -80.132523),
    "16427": (41.87726, -79.969168),
    "16428": (42.176845, -79.841991),
    "16430": (41.999881, -80.42585),
    "16432": (41.666057, -80.065793),
    "16433": (41.752837, -80.207488),
    "16434": (41.667286, -80.097316),
    "16435": (41.800421, -80.371429),
    "16436": (41.920018, -79.448206),
    "16438": (41.941617, -79.845963),
    "16440": (41.763965, -80.098233),
    "16441": (41.970601, -79.997581),
    "16442": (42.030403, -79.828985),
    "16443": (41.935633, -80.471462),
    "16444": (42.182748, -80.064915),
    "16475": (42.182748, -80.064915),
    "16501": (42.087337, -80.087341),
    "16502": (42.110357, -80.100931),
    "16503": (42.126757, -80.061029),
    "16504": (42.109556, -80.050278),
    "16505": (42.110857, -80.153383),
    "16506": (42.064456, -80.165682),
    "16507": (42.134257, -80.084042),
    "16508": (42.097156, -80.09283),
    "16509": (42.048568, -80.027928),
    "16510": (42.108655, -79.953504),
    "16511": (42.160153, -79.984376),
    "16512": (42.030201, -80.257855),
    "16514": (42.182748, -80.064915),
    "16515": (42.182748, -80.064915),
    "16522": (42.182748, -80.064915),
    "16530": (42.182748, -80.064915),
    "16531": (42.182748, -80.064915),
    "16532": (42.182748, -80.064915),
    "16533": (42.182748, -80.064915),
    "16534": (42.182748, -80.064915),
    "16538": (42.182748, -80.064915),
    "16541": (42.182748, -80.064915),
    "16544": (42.182748, -80.064915),
    "16546": (42.182748, -80.064915),
    "16550": (42.182748, -80.064915),
    "16553": (42.182748, -80.064915),
    "16554": (42.182748, -80.064915),
    "16558": (42.182748, -80.064915),
    "16563": (42.182748, -80.064915),
    "16565": (42.182748, -80.064915),
    "16601": (40.489433, -78.349874),
    "16602": (40.508219, -78.382635),
    "16603": (40.50177, -78.410035),
    "16611": (40.54851, -78.095064),
    "16613": (40.554875, -78.544825),
    "16614": (40.262311, -78.421434),
    "16616": (40.989115, -78.422403),
    "16617": (40.562667, -78.363835),
    "16619": (40.684687, -78.413712),
    "16620": (40.989115, -78.422403),
    "16621": (40.1999, -78.140812),
    "16622": (40.402523, -77.966977),
    "16623": (40.285076, -78.022032),
    "16624": (40.570219, -78.599119),
    "16625": (40.354932, -78.46266),
    "16627": (40.749629, -78.536067),
    "16629": (40.521778, -78.526274),
    "16630": (40.470718, -78.58946),
    "16631": (40.493522, -78.368229),
    "16633": (40.160065, -78.234638),
    "16634": (40.402523, -77.966977),
    "16635": (40.510278, -78.407982),
    "16636": (40.60772, -78.526783),
    "16637": (40.349335, -78.442466),
    "16638": (40.402523, -77.966977),
    "16639": (40.671195, -78.508823),
    "16640": (40.687598, -78.552346),
    "16641": (40.507567, -78.576208),
    "16644": (40.717845, -78.463679),
    "16645": (40.989115, -78.422403),
    "16646": (40.680896, -78.599266),
    "16647": (40.402523, -77.966977),
    "16648": (40.432059, -78.364965),
    "16650": (40.108984, -78.279287),
    "16651": (40.78995, -78.377189),
    "16652": (40.515371, -77.975879),
    "16654": (40.402523, -77.966977),
    "16655": (40.250384, -78.537796),
    "16656": (40.989115, -78.422403),
    "16657": (40.385496, -78.172245),
    "16659": (40.170266, -78.385341),
    "16660": (40.402523, -77.966977),
    "16661": (40.830471, -78.435525),
    "16662": (40.33984, -78.336709),
    "31620": (31.151742, -83.407143),
    "16663": (40.989115, -78.422403),
    "16664": (40.193882, -78.426719),
    "16665": (40.385507, -78.447236),
    "16666": (40.822197, -78.455355),
    "16667": (40.181801, -78.493371),
    "16668": (40.633518, -78.608257),
    "16669": (40.583226, -78.073445),
    "16670": (40.254864, -78.512462),
    "16671": (40.989115, -78.422403),
    "16672": (40.175325, -78.249266),
    "16673": (40.335467, -78.387541),
    "16674": (40.186465, -78.116188),
    "16675": (40.671181, -78.675548),
    "16677": (40.813628, -78.238986),
    "16678": (40.201876, -78.252528),
    "16679": (40.169799, -78.212185),
    "16680": (40.760116, -78.450043),
    "16681": (40.989115, -78.422403),
    "16682": (40.271126, -78.45878),
    "16683": (40.402523, -77.966977),
    "16684": (40.636691, -78.303614),
    "16685": (40.270965, -78.077244),
    "16686": (40.522068, -78.340045),
    "16689": (39.943762, -78.122265),
    "16691": (39.943762, -78.122265),
    "16692": (40.745169, -78.67683),
    "16693": (40.402532, -78.255764),
    "16694": (40.165987, -78.138144),
    "16695": (40.230406, -78.358877),
    "16698": (40.989115, -78.422403),
    "16699": (40.484487, -78.702224),
    "16701": (41.862341, -78.63731),
    "16720": (41.615099, -77.957975),
    "16724": (41.801078, -78.579739),
    "16725": (41.885487, -78.723198),
    "16726": (41.818645, -78.595669),
    "16727": (41.982786, -78.546304),
    "16728": (41.415878, -78.665057),
    "16729": (41.96089, -78.486099),
    "16730": (41.801078, -78.579739),
    "16731": (41.941328, -78.361927),
    "16732": (41.801078, -78.579739),
    "16733": (41.801078, -78.579739),
    "16734": (41.619213, -78.839413),
    "16735": (41.795662, -78.631755),
    "16738": (41.836866, -78.691582),
    "16740": (41.719284, -78.623042),
    "16743": (41.881851, -78.457878),
    "16744": (41.87833, -78.557219),
    "16745": (41.919565, -78.48561),
    "16746": (41.737627, -77.902366),
    "16748": (41.963791, -78.188866),
    "16749": (41.798748, -78.539192),
    "16750": (41.801078, -78.579739),
    "16751": (41.801078, -78.579739),
    "16801": (40.881935, -77.867822),
    "16802": (40.799672, -77.862339),
    "16803": (40.878721, -77.757999),
    "16804": (40.972229, -77.760172),
    "16805": (40.972229, -77.760172),
    "16820": (40.89869, -77.456184),
    "16821": (40.989115, -78.422403),
    "16822": (41.105476, -77.50553),
    "16823": (40.897823, -77.773188),
    "16825": (40.990006, -78.360612),
    "16826": (40.972229, -77.760172),
    "16827": (40.885162, -77.644896),
    "16828": (40.807973, -77.703942),
    "16829": (40.932545, -77.763472),
    "16830": (41.037563, -78.435492),
    "16832": (40.838329, -77.450929),
    "16833": (40.949208, -78.582309),
    "16834": (40.989115, -78.422403),
    "16835": (40.904645, -77.875191),
    "16836": (40.989115, -78.422403),
    "16837": (40.989115, -78.422403),
    "16838": (40.989115, -78.422403),
    "16839": (40.989115, -78.422403),
    "16840": (40.989115, -78.422403),
    "16841": (40.918199, -77.679655),
    "16843": (41.003007, -78.464189),
    "16844": (40.901934, -77.750812),
    "16845": (40.989115, -78.422403),
    "16847": (40.989115, -78.422403),
    "16848": (41.220635, -77.618532),
    "16849": (40.989115, -78.422403),
    "16850": (40.989115, -78.422403),
    "16851": (40.808151, -77.812525),
    "16852": (40.972229, -77.760172),
    "16853": (40.95408, -77.781465),
    "16854": (40.893455, -77.473298),
    "16855": (40.989115, -78.422403),
    "16856": (40.929851, -77.638892),
    "16858": (40.96891, -78.191551),
    "16859": (40.900498999999996, -78.025894),
    "16860": (40.989115, -78.422403),
    "16861": (40.989115, -78.422403),
    "16863": (40.989115, -78.422403),
    "16864": (40.972229, -77.760172),
    "16865": (40.868075, -77.957409),
    "16866": (40.905166, -77.844216),
    "16868": (40.726405, -77.911776),
    "16870": (40.913584, -77.829726),
    "16871": (40.989115, -78.422403),
    "16872": (40.939915, -77.448451),
    "16873": (40.989115, -78.422403),
    "16874": (40.992146, -78.027865),
    "16875": (40.88368, -77.518716),
    "16876": (40.961582, -78.292599),
    "16877": (40.692101, -78.165044),
    "16878": (40.989115, -78.422403),
    "16879": (40.989115, -78.422403),
    "16881": (40.989115, -78.422403),
    "16882": (40.897081, -77.402419),
    "16901": (41.862339, -77.258974),
    "16910": (41.77197, -76.521266),
    "16911": (41.77197, -77.242228),
    "16912": (41.822885, -77.200274),
    "16914": (41.77197, -76.521266),
    "16915": (41.776165, -77.956692),
    "16917": (41.769456, -77.000451),
    "16918": (41.77197, -77.242228),
    "16920": (41.979118, -77.370183),
    "16921": (41.77197, -77.242228),
    "16922": (41.733379, -77.644214),
    "16923": (41.737627, -77.902366),
    "16925": (41.938208, -76.800579),
    "16926": (41.77197, -76.521266),
    "16927": (41.737627, -77.902366),
    "16928": (41.93602, -77.445729),
    "16929": (41.984078, -77.181189),
    "16930": (41.77197, -77.242228),
    "16932": (41.790065, -77.035282),
    "16933": (41.793666, -77.072151),
    "16935": (41.77197, -77.242228),
    "16936": (41.90843, -77.011231),
    "16937": (41.737627, -77.902366),
    "16938": (41.77197, -77.242228),
    "16939": (41.677542, -77.015194),
    "16940": (41.977039, -77.24531),
    "16941": (41.737627, -77.902366),
    "16942": (41.989264, -77.347725),
    "16943": (41.77197, -77.242228),
    "16945": (41.77197, -76.521266),
    "16946": (41.943444, -77.2292),
    "16947": (41.788389, -76.837246),
    "16948": (41.843678, -77.75736),
    "16950": (41.919341, -77.523033),
    "17001": (40.21604, -76.924996),
    "17002": (40.539667, -77.790168),
    "17003": (40.352637, -76.435873),
    "17004": (40.591417, -77.73103),
    "17005": (40.600992, -76.811693),
    "17006": (40.29736, -77.56437),
    "17007": (40.141205, -77.242351),
    "17008": (40.167091, -76.978448),
    "17009": (40.629711, -77.607196),
    "17010": (40.27124, -76.582049),
    "17011": (40.251914, -77.079091),
    "17012": (40.136687, -77.242805),
    "17013": (40.168495, -77.228817),
    "17014": (40.478716, -77.345514),
    "17016": (40.275536, -76.405309),
    "17017": (40.894363, -76.596151),
    "17018": (40.361876, -76.895539),
    "17019": (40.091217, -76.977835),
    "17020": (40.458261, -77.060745),
    "17021": (40.478716, -77.345514),
    "17022": (40.150963, -76.61028),
    "17023": (40.584804, -76.767913),
    "17024": (40.442354, -77.27088),
    "17025": (40.235675, -76.987249),
    "17026": (40.456193, -76.434639),
    "17027": (40.157981, -76.996398),
    "17028": (40.373438, -76.682667),
    "17029": (40.550937, -77.626095),
    "17030": (40.608245, -76.737545),
    "17031": (40.406766, -77.292578),
    "17032": (40.507107, -76.843844),
    "17033": (40.269748, -76.636357),
    "17034": (40.329577, -76.834076),
    "17035": (40.478716, -77.345514),
    "17036": (40.340043, -76.782764),
    "17037": (40.436276, -77.397013),
    "17038": (40.430902, -76.480732),
    "17039": (40.300505, -76.258399),
    "17040": (40.34253, -77.304476),
    "17041": (40.223623, -76.538007),
    "17042": (40.331594, -76.397634),
    "17043": (40.244339, -76.918796),
    "17044": (40.564909, -77.630152),
    "17045": (40.574445, -76.987538),
    "17046": (40.381212, -76.436791),
    "17047": (40.406766, -77.292578),
    "17048": (40.558844, -76.790132),
    "17049": (40.651725, -77.306056),
    "17051": (40.478095, -77.734919),
    "17052": (40.402523, -77.966977),
    "17053": (40.325105, -77.025886),
    "17054": (40.495979, -77.723716),
    "17055": (40.180953, -77.177086),
    "17056": (40.478716, -77.345514),
    "17057": (40.191241, -76.720142),
    "17058": (40.555304, -77.400062),
    "17059": (40.571404, -77.317266),
    "17060": (40.402523, -77.966977),
    "17061": (40.571494, -76.840528),
    "17062": (40.556195, -77.154223),
    "17063": (40.740026, -77.493466),
    "17064": (40.254642, -76.461544),
    "17065": (40.202649, -77.08213),
    "17066": (40.382302, -77.882222),
    "17067": (40.368282, -76.359975),
    "17068": (40.405796, -77.134043),
    "17069": (40.455272, -76.970942),
    "17070": (40.263875, -76.898096),
    "17071": (40.406766, -77.292578),
    "17072": (40.230601, -77.079425),
    "17073": (40.314112, -76.26055),
    "17074": (40.506053, -77.129129),
    "17075": (40.39313, -77.831635),
    "17076": (40.478716, -77.345514),
    "17077": (40.375404, -76.414757),
    "17078": (40.317606, -76.416907),
    "17080": (40.639199, -76.80292),
    "17081": (40.203019, -77.284761),
    "17082": (40.549581, -77.395272),
    "17083": (40.27639, -76.411239),
    "17084": (40.541706, -77.692538),
    "17085": (40.277076, -76.385727),
    "17086": (40.478716, -77.345514),
    "17087": (40.362956, -76.271943),
    "17088": (40.308696, -76.296308),
    "17089": (40.269738, -76.936046),
    "17090": (40.342999, -77.182569),
    "17091": (40.136687, -77.242805),
    "17093": (40.293538, -76.926346),
    "17094": (40.565325, -77.235359),
    "17097": (40.573734, -76.65693),
    "17098": (40.588313, -76.695547),
    "17099": (40.644505, -77.567708),
    "17101": (40.264589, -76.869644),
    "17102": (40.272538, -76.890695),
    "17103": (40.272389, -76.860994),
    "17104": (40.253639, -76.857944),
    "17105": (40.278498, -76.875207),
    "17106": (40.292664, -76.850061),
    "17107": (40.297031, -76.876437),
    "17108": (40.308638, -76.801693),
    "17109": (40.290953, -76.820294),
    "17110": (40.302238, -76.866348),
    "17111": (40.272089, -76.801693),
    "17112": (40.344295, -76.790248),
    "17113": (40.23904, -76.841644),
    "17120": (40.265689, -76.882745),
    "17121": (40.294396, -76.893751),
    "17122": (40.249845, -76.871209),
    "17123": (40.267518, -76.883734),
    "17124": (40.26746, -76.885967),
    "17125": (40.266221, -76.882854),
    "17126": (40.26179, -76.880021),
    "17127": (40.261516, -76.880884),
    "17128": (40.389865, -76.782323),
    "17129": (40.261516, -76.880884),
    "17130": (40.270222, -76.882889),
    "17140": (40.30864, -76.846449),
    "17177": (40.298988, -76.847194),
    "17201": (39.908055, -77.666445),
    "17210": (40.171667, -77.661354),
    "17211": (39.755155, -78.406388),
    "17212": (39.943762, -78.122265),
    "17213": (40.17973, -77.865942),
    "17214": (39.739893, -77.470729),
    "17215": (39.943762, -78.122265),
    "17217": (40.225168, -77.725013),
    "17219": (40.218448, -77.679713),
    "17220": (40.178081, -77.735336),
    "17221": (40.073155, -77.832158),
    "17222": (39.900035, -77.529619),
    "17223": (39.943762, -78.122265),
    "17224": (40.002593, -77.809574),
    "17225": (39.805922, -77.726127),
    "17228": (39.943762, -78.122265),
    "17229": (39.943762, -78.122265),
    "17231": (39.859432, -77.857889),
    "17232": (40.105495, -77.640461),
    "17233": (39.928812, -77.981379),
    "17235": (39.858699, -77.69815),
    "17236": (39.819034, -77.798952),
    "17237": (39.83593, -77.553776),
    "17238": (39.943762, -78.122265),
    "17239": (40.402523, -77.966977),
    "17240": (40.174798, -77.470285),
    "17241": (40.173093, -77.421905),
    "17243": (40.225376, -77.887496),
    "17244": (40.079556, -77.679344),
    "17246": (40.049118, -77.67175399999999),
    "17247": (39.799481, -77.581092),
    "17249": (40.402523, -77.966977),
    "17250": (39.736395, -77.52474),
    "17251": (40.112652, -77.670626),
    "17252": (39.916149, -77.811826),
    "17253": (40.402523, -77.966977),
    "17254": (39.96959, -77.584841),
    "17255": (40.133259, -77.87475),
    "17256": (39.783391, -77.674851),
    "17257": (40.070789, -77.45983),
    "17260": (40.402523, -77.966977),
    "17261": (39.833095, -77.488633),
    "17262": (40.173439, -77.709212),
    "17263": (39.724825, -77.71862899999999),
    "17264": (40.222408, -77.941975),
    "17265": (40.054782, -77.775921),
    "17266": (40.104094, -77.472794),
    "17267": (39.943762, -78.122265),
    "17268": (39.793552, -77.59228),
    "17270": (39.854017999999996, -77.799733),
    "17271": (40.108243, -77.807221),
    "17272": (39.771372, -77.62702),
    "17301": (39.896923, -76.994725),
    "17302": (39.821313, -76.405931),
    "17303": (39.923644, -77.300085),
    "17304": (39.976602, -77.227126),
    "17306": (39.979154, -77.249592),
    "17307": (39.933286, -77.287491),
    "17309": (39.860758, -76.467305),
    "17310": (39.890605, -77.356642),
    "17311": (39.871756, -76.759884),
    "17312": (39.946739, -76.506639),
    "17313": (39.912423, -76.65353),
    "17314": (39.792142, -76.54384),
    "17315": (40.004544, -76.884956),
    "17316": (39.876563, -77.027176),
    "17317": (39.97014, -76.521686),
    "17318": (40.021496, -76.726638),
    "17319": (40.150726, -76.798353),
    "17320": (39.780789, -77.361859),
    "17321": (39.784476, -76.518286),
    "17322": (39.844726, -76.576556),
    "17323": (40.07501, -77.027926),
    "17324": (40.017772, -77.193663),
    "17325": (39.840922, -77.226591),
    "17326": (39.894800000000004, -77.213493),
    "17327": (39.892205, -76.750637),
    "17329": (39.766883, -76.877706),
    "17331": (39.935502, -76.672739),
    "17332": (39.775037, -76.735116),
    "17333": (39.972985, -76.687826),
    "17337": (40.015656, -77.200131),
    "17339": (39.995219, -76.889249),
    "17340": (39.829806, -77.095399),
    "17342": (39.853644, -76.707997),
    "17343": (39.869229, -77.329248),
    "17344": (39.801004, -77.022875),
    "17345": (39.95406, -76.835812),
    "17347": (39.942848, -76.552798),
    "17349": (39.866988, -76.633324),
    "17350": (39.881881, -77.077431),
    "17352": (39.838639, -76.449874),
    "17353": (39.882976, -77.393593),
    "17354": (39.82457, -76.89927),
    "17355": (39.757328, -76.699442),
    "17356": (39.905747, -76.615805),
    "17358": (39.972985, -76.687826),
    "17360": (39.823461, -76.700714),
    "17361": (39.799799, -76.687931),
    "17362": (39.944531, -76.775774),
    "17363": (39.809151, -76.606747),
    "17364": (39.933775, -76.905317),
    "17365": (40.018835, -76.784811),
    "17366": (40.006581, -76.613232),
    "17368": (39.994482, -76.677736),
    "17370": (40.067766, -76.720322),
    "17371": (39.900579, -76.789624),
    "17372": (40.007937, -77.100231),
    "17375": (39.894800000000004, -77.213493),
    "17401": (39.962998, -76.727139),
    "17402": (40.001615, -76.689918),
    "17403": (39.93939, -76.666257),
    "17404": (39.934957, -76.577982),
    "17405": (40.008647, -76.597187),
    "17406": (40.004593, -76.594727),
    "17407": (39.897907000000004, -76.662569),
    "17415": (39.972985, -76.687826),
    "17501": (40.129894, -76.361053),
    "17502": (40.088469, -76.462434),
    "17503": (40.0185, -76.297582),
    "17504": (40.024047, -76.328081),
    "17505": (40.066647, -76.187926),
    "17506": (40.117326, -76.052379),
    "17507": (40.196641, -76.016047),
    "17508": (40.125896, -76.213013),
    "17509": (39.903954, -76.040115),
    "17512": (40.11675, -76.369028),
    "17516": (40.026391, -76.262044),
    "17517": (40.188445, -76.337734),
    "17518": (39.818309, -76.249931),
    "17519": (40.142759, -76.019741),
    "17520": (40.097468, -76.356832),
    "17521": (40.204393, -76.34643),
    "17522": (40.169662, -76.356933),
    "17527": (40.011961, -76.021595),
    "17528": (40.043523, -76.238766),
    "17529": (40.043967, -76.108543),
    "17532": (39.86632, -76.28062),
    "17533": (40.233892, -76.260725),
    "17534": (40.036659, -76.106902),
    "17535": (40.005276, -76.042921),
    "17536": (39.842724, -76.080469),
    "17537": (39.988548, -76.238729),
    "17538": (40.112477, -76.36089),
    "17540": (40.100846, -76.191873),
    "17543": (40.134761, -76.455212),
    "17545": (40.155927, -76.464018),
    "17547": (40.061596, -76.485935),
    "17549": (40.154498, -76.08756),
    "17550": (40.072108, -76.57779),
    "17551": (40.031882, -76.236823),
    "17552": (40.113745, -76.354),
    "17554": (40.038842, -76.425978),
    "17555": (40.120279, -75.961183),
    "17557": (40.14607, -76.073814),
    "17560": (39.912288, -76.237428),
    "17562": (39.898072, -76.091234),
    "17563": (39.844788, -76.155069),
    "17564": (40.0185, -76.297582),
    "17565": (39.904409, -76.322481),
    "17566": (39.856368, -76.148506),
    "17567": (40.209941, -76.116445),
    "17568": (39.9469, -76.232229),
    "17569": (40.152713, -76.091179),
    "17570": (40.129645, -76.571739),
    "17572": (40.015026, -76.149994),
    "17573": (40.0185, -76.297582),
    "17575": (40.064746, -76.434285),
    "17576": (40.036398, -76.203069),
    "17577": (40.0185, -76.297582),
    "17578": (40.168624, -76.330001),
    "17579": (40.082226, -76.113772),
    "17580": (40.116846, -76.213075),
    "17581": (40.157576, -76.046317),
    "17582": (39.990664, -76.43485),
    "17583": (39.972349, -76.28733),
    "17584": (39.959349, -76.259779),
    "17585": (40.048398, -76.211427),
    "17601": (40.076553, -76.31068),
    "17602": (40.004048, -76.249829),
    "17603": (40.009147, -76.367132),
    "17604": (40.065096, -76.335631),
    "17605": (40.0185, -76.297582),
    "17606": (40.110201, -76.305378),
    "17607": (40.0185, -76.297582),
    "17608": (40.0185, -76.297582),
    "17699": (40.0185, -76.297582),
    "17701": (41.266716, -76.958314),
    "17702": (41.194306, -77.054665),
    "17703": (41.33275, -77.023601),
    "17705": (41.33275, -77.023601),
    "17720": (41.186545, -77.218368),
    "17721": (41.186028, -77.316191),
    "17722": (41.33275, -77.023601),
    "17723": (41.33275, -77.023601),
    "17724": (41.639449, -76.84143),
    "17726": (41.122741, -77.431745),
    "17727": (41.33275, -77.023601),
    "17728": (41.255299, -76.948034),
    "17729": (41.737627, -77.902366),
    "17730": (41.10891, -76.877491),
    "17731": (41.432901, -76.516887),
    "17735": (41.77197, -76.521266),
    "17737": (41.280128, -76.6753),
    "17738": (41.220635, -77.618532),
    "17739": (41.33275, -77.023601),
    "17740": (41.208518, -77.025687),
    "17742": (41.229734, -76.594727),
    "17743": (41.77197, -76.521266),
    "17744": (41.251994, -77.161674),
    "17745": (41.229022, -77.641745),
    "17747": (41.018519, -77.341611),
    "17748": (41.135507, -77.369964),
    "17749": (41.071982, -76.818381),
    "17750": (41.032529, -77.495147),
    "17751": (41.071123, -77.476304),
    "17752": (41.214561, -76.856502),
    "17754": (41.307308, -76.881055),
    "17756": (41.244348, -76.74048),
    "17758": (41.432901, -76.516887),
    "17759": (41.218259, -77.12137),
    "17760": (41.220635, -77.618532),
    "17762": (41.221474, -76.659535),
    "17763": (41.498523, -76.946724),
    "17764": (41.306045, -77.571221),
    "17765": (41.77197, -77.242228),
    "17767": (41.220635, -77.618532),
    "17768": (41.432901, -76.516887),
    "17769": (41.33275, -77.023601),
    "17771": (41.438766, -77.06138),
    "17772": (41.10285, -76.823084),
    "17773": (41.220635, -77.618532),
    "17774": (41.227207, -76.646221),
    "17776": (41.37857, -77.331293),
    "17777": (41.097981, -76.850306),
    "17778": (41.270789, -77.969664),
    "17779": (41.187424, -77.372827),
    "17801": (40.869766, -76.735577),
    "17810": (40.978059, -77.08184),
    "17812": (40.726469, -77.272828),
    "17813": (40.754705, -77.169508),
    "17814": (41.218998, -76.395426),
    "17815": (41.005609, -76.430563),
    "17820": (41.020674, -76.436239),
    "17821": (40.991968, -76.647082),
    "17822": (40.967437, -76.604896),
    "17823": (40.889632, -76.664574),
    "48470": (43.743805, -82.740132),
    "17824": (40.859435, -76.550811),
    "17825": (40.889632, -76.664574),
    "17827": (40.765049, -76.939544),
    "17828": (40.889632, -76.664574),
    "17829": (40.882861, -77.189174),
    "17830": (40.889632, -76.664574),
    "17831": (40.834408, -76.835439),
    "17832": (40.805096, -76.464607),
    "17833": (40.762675, -77.07752),
    "17834": (40.793938, -76.476946),
    "17835": (40.978059, -77.08184),
    "17836": (40.889632, -76.664574),
    "17837": (40.969642, -76.948072),
    "17839": (41.020062, -76.438413),
    "17840": (40.772687, -76.438311),
    "17841": (40.766765, -77.150271),
    "17842": (40.779808, -77.117558),
    "17843": (40.762675, -77.07752),
    "17844": (40.947833, -77.011087),
    "17845": (40.978059, -77.08184),
    "17846": (41.143816, -76.525177),
    "17847": (40.993883, -76.847896),
    "17850": (40.889632, -76.664574),
    "17851": (40.803636, -76.428612),
    "17853": (40.723706, -77.013547),
    "17855": (40.882689, -76.984667),
    "17856": (41.048043, -76.903895),
    "17857": (40.90805, -76.784197),
    "17858": (41.042106, -76.424297),
    "17859": (41.061483, -76.418093),
    "17860": (40.889632, -76.664574),
    "17861": (40.762675, -77.07752),
    "17862": (40.857426, -77.064941),
    "17864": (40.695087, -76.903957),
    "17865": (40.889632, -76.664574),
    "17866": (40.791688, -76.551871),
    "17867": (40.889632, -76.664574),
    "17868": (40.952908, -76.631118),
    "17870": (40.825914, -76.857577),
    "17872": (40.791953, -76.601592),
    "17876": (40.845896, -76.82241),
    "17877": (40.87897, -76.667267),
    "17878": (41.120644, -76.412386),
    "17880": (40.978059, -77.08184),
    "17881": (40.782155, -76.672737),
    "17882": (40.762675, -77.07752),
    "17883": (40.978059, -77.08184),
    "17884": (41.027277, -76.653633),
    "17885": (40.978059, -77.08184),
    "17886": (41.01789, -76.870841),
    "17887": (40.978059, -77.08184),
    "17888": (40.815401, -76.368632),
    "17889": (40.905947, -76.859662),
    "17901": (40.708751, -76.282986),
    "17920": (40.816696, -76.350279),
    "17921": (40.692886, -76.303085),
    "17922": (40.59782, -76.14932),
    "17923": (40.67602, -76.316013),
    "17925": (40.750796, -76.062859),
    "17927": (40.804881, -76.341156),
    "17929": (40.675475, -76.165297),
    "17930": (40.711356, -76.139162),
    "17931": (40.692869, -76.348699),
    "17932": (40.649109, -76.503339),
    "17933": (40.595462, -76.246441),
    "17934": (40.798623, -76.21553),
    "17935": (40.795384, -76.270574),
    "17936": (40.748879, -76.335499),
    "17938": (40.688219, -76.539205),
    "17941": (40.687178, -76.578173),
    "17942": (40.722587, -76.229623),
    "17943": (40.761438, -76.387242),
    "17944": (40.67578, -76.2819),
    "17945": (40.774531, -76.370427),
    "17946": (40.808081, -76.240747),
    "17948": (40.733004, -76.306129),
    "17949": (40.794007, -76.243323),
    "17951": (40.682985, -76.238725),
    "17952": (40.747301, -76.062825),
    "17953": (40.733072, -76.085783),
    "17954": (40.711461, -76.199621),
    "17957": (40.592578, -76.516075),
    "17959": (40.675413, -76.155786),
    "17960": (40.703416, -75.959812),
    "17961": (40.618065, -76.206854),
    "17963": (40.577029, -76.33716),
    "17964": (40.724376, -76.488833),
    "17965": (40.771333, -76.199259),
    "17966": (40.722587, -76.229623),
    "17967": (40.856227, -76.23464),
    "17968": (40.636539, -76.591109),
    "17970": (40.707055, -76.284374),
    "17972": (40.602048, -76.154856),
    "17974": (40.690632, -76.227294),
    "17976": (40.763239, -76.148397),
    "17978": (40.625754, -76.621769),
    "17979": (40.554516, -76.203767),
    "17980": (40.590428, -76.53981),
    "17981": (40.694624, -76.306539),
    "17982": (40.781484, -76.013399),
    "17983": (40.645911, -76.532384),
    "17985": (40.914137, -76.193099),
    "18001": (40.693376, -75.471156),
    "18002": (40.665597, -75.426247),
    "18003": (40.693376, -75.471156),
    "18010": (40.693376, -75.471156),
    "18011": (40.514472, -75.602941),
    "18012": (40.813281, -75.59202),
    "18013": (40.766465, -75.315246),
    "18014": (40.733142, -75.351785),
    "18015": (40.58883, -75.351958),
    "18016": (40.693376, -75.471156),
    "18017": (40.662211, -75.39027),
    "18018": (40.625297, -75.379174),
    "18020": (40.669251, -75.334887),
    "18025": (40.693376, -75.471156),
    "18030": (40.801062, -75.661425),
    "18031": (40.550733, -75.540673),
    "18032": (40.602633, -75.472276),
    "18034": (40.543998, -75.41242),
    "18035": (40.750996, -75.53937),
    "18036": (40.502424, -75.411145),
    "18037": (40.616645, -75.489587),
    "18038": (40.79071, -75.482967),
    "18039": (40.328645, -75.10278),
    "18040": (40.806206, -75.20887),
    "18041": (40.382488, -75.51541),
    "18042": (40.683198, -75.264861),
    "18043": (40.792804, -75.137186),
    "18044": (40.693376, -75.471156),
    "18045": (40.695731, -75.286528),
    "18046": (40.538843, -75.568502),
    "18049": (40.520705, -75.496131),
    "18050": (40.693376, -75.471156),
    "18051": (40.599843, -75.663187),
    "18052": (40.656746, -75.504128),
    "18053": (40.718662, -75.700739),
    "18054": (40.289663, -75.450703),
    "18055": (40.588799, -75.313756),
    "18056": (40.454205, -75.581444),
    "18058": (40.903599, -75.476885),
    "18059": (40.717684, -75.533488),
    "18060": (40.53484, -75.57864000000001),
    "18062": (40.517851, -75.565028),
    "18063": (40.782456, -75.173494),
    "18064": (40.737648, -75.272892),
    "18065": (40.696738, -75.611647),
    "18066": (40.652611, -75.759361),
    "18067": (40.724479, -75.365412),
    "18068": (40.693376, -75.471156),
    "18069": (40.629605, -75.621885),
    "18070": (40.430181, -75.531182),
    "18071": (40.855728, -75.58918),
    "18072": (40.841099, -75.258376),
    "18073": (40.374347, -75.482175),
    "18074": (40.320832, -75.500492),
    "18076": (40.387419, -75.505547),
    "18077": (40.567316, -75.236191),
    "18078": (40.669675, -75.620901),
    "18079": (40.745524, -75.659209),
    "18080": (40.734537, -75.618611),
    "18081": (40.328645, -75.10278),
    "18083": (40.772873, -75.363531),
    "18084": (40.327782, -75.454043),
    "18085": (40.740625, -75.254854),
    "18086": (40.736119, -75.54494),
    "18087": (40.548196, -75.596131),
    "18088": (40.759591, -75.428538),
    "18091": (40.801131, -75.310958),
    "18092": (40.467193, -75.512091),
    "18098": (40.693376, -75.471156),
    "18099": (40.693376, -75.471156),
    "18101": (40.607497, -75.470026),
    "18102": (40.607006, -75.480877),
    "18103": (40.604372, -75.473127),
    "18104": (40.621048, -75.545306),
    "18105": (40.693376, -75.471156),
    "18106": (40.582381, -75.591132),
    "18109": (40.693376, -75.471156),
    "18175": (40.585561, -75.621058),
    "18195": (40.57983, -75.579884),
    "18201": (40.964584, -76.008333),
    "18210": (41.012618, -75.560751),
    "18211": (40.744932, -75.83155000000001),
    "18212": (40.784095, -75.708281),
    "18214": (40.80868, -76.036009),
    "18216": (40.932217, -75.919196),
    "18218": (40.858951, -76.013009),
    "18219": (40.990662, -76.056358),
    "18220": (40.838915, -76.069416),
    "18221": (41.001634, -75.905693),
    "18222": (41.034017, -76.003059),
    "18223": (41.272248, -75.880146),
    "18224": (41.019593, -75.881697),
    "18225": (40.988813, -75.961651),
    "18229": (40.896709, -75.759303),
    "18230": (40.934763, -75.73577),
    "18231": (40.900231, -76.005382),
    "18232": (40.872243, -75.915416),
    "18234": (40.992517, -75.962585),
    "18235": (40.886664, -75.736164),
    "18237": (40.897645, -75.997791),
    "18239": (40.996051, -75.981475),
    "18240": (40.933194, -75.76383),
    "18241": (40.922289, -76.14894),
    "18242": (40.910952, -76.122324),
    "18243": (41.001683, -75.966146),
    "18244": (40.824546, -75.665068),
    "18245": (40.722587, -76.229623),
    "18246": (40.954011, -76.174707),
    "18247": (41.014808, -76.058391),
    "18248": (40.901977, -76.118764),
    "18249": (40.975202, -76.0845),
    "18250": (40.90537, -75.74156),
    "18251": (41.272248, -75.880146),
    "18252": (40.79849, -75.937836),
    "18254": (40.924803, -75.938611),
    "18255": (40.911443, -75.77900700000001),
    "18256": (40.944777, -76.145197),
    "18301": (41.089642, -75.199705),
    "18320": (41.071213, -75.236436),
    "18321": (41.079679, -75.319542),
    "18322": (41.054711, -75.331879),
    "18323": (41.033755, -75.30798),
    "18324": (41.185011, -74.97889),
    "18325": (41.187023, -75.28593),
    "18326": (41.152364, -75.276395),
    "18327": (40.988562, -75.151193),
    "18328": (41.229482, -74.967407),
    "18330": (41.033192, -75.449047),
    "18331": (40.947398, -75.366015),
    "18332": (41.025342, -75.323738),
    "18333": (40.95158, -75.501306),
    "18334": (41.057236, -75.465137),
    "18335": (41.050764, -75.208269),
    "18336": (41.370358, -74.736057),
    "18337": (41.320051, -74.880639),
    "18340": (41.413707, -74.751138),
    "18341": (40.991053, -75.299256),
    "18342": (41.145778, -75.294125),
    "18343": (40.898617, -75.104575),
    "18344": (41.136268, -75.37092),
    "18346": (41.094926, -75.298177),
    "18347": (41.13856, -75.562988),
    "18348": (41.033755, -75.30798),
    "18349": (41.122633, -75.45882),
    "18350": (41.083557, -75.515614),
    "18351": (40.921386, -75.097007),
    "18352": (40.986265, -75.348026),
    "18353": (41.011645, -75.254722),
    "18354": (40.937939, -75.292615),
    "18355": (41.090045, -75.357801),
    "18356": (41.031177, -75.097435),
    "18357": (41.233562, -75.238879),
    "18360": (41.041895, -75.368964),
    "18370": (41.105903, -75.346913),
    "18371": (41.340936, -75.024055),
    "18372": (41.095823, -75.323654),
    "18373": (41.340936, -75.024055),
    "18401": (41.615989, -75.274708),
    "18403": (41.487598, -75.533403),
    "18405": (41.582471, -75.130121),
    "18407": (41.583122, -75.505612),
    "18410": (41.486527, -75.693335),
    "18411": (41.463694, -75.681992),
    "18413": (41.654319, -75.614463),
    "18414": (41.539797, -75.719723),
    "18415": (41.701677, -75.133727),
    "18416": (41.375602, -75.547966),
    "18417": (41.797309, -75.206086),
    "18419": (41.562365, -75.782573),
    "18420": (41.401881, -75.637626),
    "18421": (41.652271999999996, -75.531325),
    "18424": (41.346095, -75.331956),
    "18425": (41.41594, -75.022543),
    "18426": (41.320734, -75.199395),
    "18427": (41.422497, -75.335384),
    "18428": (41.482733, -75.24019),
    "18430": (41.820346, -75.80463),
    "18431": (41.564258, -75.265643),
    "18433": (41.561174, -75.618764),
    "18434": (41.504326, -75.572238),
    "18435": (41.475422, -75.009368),
    "18436": (41.452686, -75.321884),
    "18437": (41.617378, -75.282339),
    "18438": (41.431256, -75.303874),
    "18439": (41.828081, -75.396741),
    "18440": (41.551585, -75.767583),
    "18441": (41.820346, -75.80463),
    "18443": (41.667024, -75.118513),
    "18444": (41.321625, -75.538602),
    "18445": (41.356766, -75.381762),
    "18446": (41.627612, -75.786129),
    "18447": (41.494578, -75.653932),
    "18448": (41.46488, -75.596231),
    "18449": (41.615989, -75.274708),
    "18451": (41.340936, -75.024055),
    "18452": (41.350663, -75.552502),
    "18453": (41.615989, -75.274708),
    "18454": (41.615989, -75.274708),
    "18455": (41.615989, -75.274708),
    "18456": (41.615989, -75.274708),
    "18457": (41.340936, -75.024055),
    "18458": (41.414928, -74.934461),
    "18459": (41.615989, -75.274708),
    "18460": (41.259242, -75.373122),
    "18461": (41.615989, -75.274708),
    "18462": (41.89529, -75.42428),
    "18463": (41.376953, -75.31601),
    "18464": (41.396988, -75.186881),
    "18465": (41.84015, -75.531898),
    "18466": (41.17551, -75.461757),
    "18469": (41.615989, -75.274708),
    "18470": (41.698964, -75.529304),
    "18471": (41.523812, -75.690608),
    "18472": (41.613395, -75.371218),
    "18473": (41.540648, -75.222927),
    "18501": (41.401881, -75.637626),
    "18502": (41.350303, -75.689965),
    "18503": (41.410079, -75.666784),
    "18504": (41.421572, -75.691955),
    "18505": (41.413137, -75.65194),
    "18507": (41.361332, -75.706584),
    "18508": (41.439979, -75.66843),
    "18509": (41.42908, -75.647633),
    "18510": (41.396665, -75.652869),
    "18512": (41.43503, -75.610332),
    "18514": (41.401881, -75.637626),
    "18515": (41.403529, -75.706485),
    "18517": (41.382529, -75.713185),
    "18518": (41.372779, -75.730836),
    "18519": (41.463118, -75.629099),
    "18522": (41.401881, -75.637626),
    "18540": (41.401881, -75.637626),
    "18577": (41.401881, -75.637626),
    "18601": (41.272248, -75.880146),
    "18602": (41.192177, -75.716073),
    "18603": (41.056142, -76.299844),
    "18610": (41.085529, -75.499384),
    "18611": (41.110259, -75.775517),
    "18612": (41.271121, -75.999621),
    "18614": (41.524261, -76.397554),
    "18615": (41.447109, -75.855544),
    "18616": (41.432901, -76.516887),
    "18617": (41.265528, -76.052153),
    "18618": (41.37385, -75.969059),
    "18619": (41.432901, -76.516887),
    "18621": (41.28317, -76.064414),
    "18622": (41.272248, -75.880146),
    "18623": (41.632632, -76.154464),
    "18624": (41.048947, -75.60858),
    "18625": (41.513852, -75.841598),
    "18626": (41.432901, -76.516887),
    "18627": (41.316584, -76.021037),
    "18628": (41.432901, -76.516887),
    "18629": (41.27708, -75.960156),
    "18630": (41.27708, -75.960156),
    "18631": (40.98713, -76.287669),
    "18632": (41.432901, -76.516887),
    "18634": (41.249808, -76.008195),
    "18635": (41.049051, -76.189182),
    "18636": (41.27708, -75.960156),
    "18640": (41.298152, -75.85856),
    "18641": (41.238649, -75.868267),
    "18642": (41.217263, -75.938105),
    "18643": (41.262312, -75.816983),
    "18644": (41.337161, -75.912401),
    "18651": (41.28871, -75.98764),
    "18653": (41.394526, -75.824239),
    "18654": (41.350053, -76.03193),
    "18655": (41.151321, -76.108103),
    "18656": (41.288634, -76.142277),
    "18657": (41.566386, -75.975715),
    "18660": (41.142698, -76.039935),
    "18661": (41.114503, -75.909158),
    "18690": (41.272248, -75.880146),
    "18701": (41.203631, -75.88434),
    "18702": (41.211028, -75.838169),
    "18703": (41.242081, -75.88569),
    "18704": (41.27843, -75.905842),
    "18705": (41.261699, -75.849123),
    "18706": (41.2313, -75.896241),
    "18707": (41.166401, -75.961432),
    "18708": (41.24083, -75.947216),
    "18709": (41.28603, -75.89509),
    "18710": (41.272248, -75.880146),
    "18711": (41.272248, -75.880146),
    "18761": (41.272248, -75.880146),
    "18762": (41.272248, -75.880146),
    "18763": (41.272248, -75.880146),
    "18764": (41.272248, -75.880146),
    "18765": (41.272248, -75.880146),
    "18766": (41.244781, -75.88959),
    "18767": (41.272248, -75.880146),
    "18768": (41.272248, -75.880146),
    "18769": (41.272248, -75.880146),
    "18773": (41.272248, -75.880146),
    "18774": (41.272248, -75.880146),
    "18801": (41.84414, -75.831862),
    "18810": (41.861751, -76.488418),
    "18812": (41.820346, -75.80463),
    "18813": (41.820346, -75.80463),
    "18814": (41.77197, -76.521266),
    "18815": (41.77197, -76.521266),
    "18816": (41.820346, -75.80463),
    "18817": (41.77197, -76.521266),
    "18818": (41.820346, -75.80463),
    "18820": (41.820346, -75.80463),
    "18821": (41.973758, -75.74480199999999),
    "18822": (41.960544, -75.748053),
    "18823": (41.820346, -75.80463),
    "18824": (41.702924, -75.767941),
    "18825": (41.820346, -75.80463),
    "18826": (41.766723999999996, -75.732669),
    "18827": (41.95752, -75.637286),
    "18828": (41.820346, -75.80463),
    "18829": (41.77197, -76.521266),
    "18830": (41.820346, -75.80463),
    "18831": (41.880928, -76.585448),
    "18832": (41.713484, -76.487176),
    "18833": (41.599586, -76.442518),
    "18834": (41.890486, -75.688114),
    "18837": (41.77197, -76.521266),
    "18839": (41.820346, -75.80463),
    "18840": (41.97819, -76.599403),
    "18842": (41.820346, -75.80463),
    "18843": (41.8237, -75.88314),
    "18844": (41.820346, -75.80463),
    "18845": (41.77197, -76.521266),
    "18846": (41.77197, -76.521266),
    "18847": (41.957087, -75.664856),
    "18848": (41.773762, -76.389299),
    "18850": (41.813972, -76.549572),
    "18851": (41.77197, -76.521266),
    "18853": (41.668617, -76.265169),
    "18854": (41.77197, -76.521266),
    "18901": (40.334863, -75.118737),
    "18910": (40.328645, -75.10278),
    "18911": (40.328645, -75.10278),
    "18912": (40.309942, -75.074252),
    "18913": (40.376499, -75.04129),
    "18914": (40.288277, -75.201848),
    "18915": (40.272756, -75.256285),
    "18916": (40.328645, -75.10278),
    "18917": (40.375008, -75.204464),
    "18918": (40.320036, -75.374155),
    "18920": (40.488543, -75.09576),
    "18921": (40.328645, -75.10278),
    "18922": (40.328645, -75.10278),
    "18923": (40.272313, -75.117414),
    "18924": (40.308116, -75.358575),
    "18925": (40.283176, -75.064112),
    "18926": (40.39473, -75.098468),
    "18927": (40.323533, -75.254829),
    "18928": (40.335974, -75.04288),
    "18929": (40.254157, -75.08854),
    "18930": (40.54199, -75.207252),
    "18931": (40.328645, -75.10278),
    "18932": (40.299561, -75.254097),
    "18933": (40.328645, -75.10278),
    "18934": (40.349443, -75.067622),
    "18935": (40.328645, -75.10278),
    "18936": (40.2375, -75.23656),
    "18938": (40.357492, -74.998605),
    "18940": (40.263042, -74.955535),
    "18942": (40.463447, -75.167341),
    "18943": (40.268981, -75.009401),
    "18944": (40.390196, -75.233253),
    "18946": (40.271104, -75.062204),
    "18947": (40.43014, -75.1172),
    "18949": (40.38805, -75.142522),
    "18950": (40.416516, -75.074832),
    "18951": (40.452525, -75.221391),
    "18953": (40.328645, -75.10278),
    "18954": (40.224658, -75.001662),
    "18955": (40.47963, -75.314639),
    "18956": (40.262783, -75.01568),
    "18957": (40.302945, -75.448579),
    "18958": (40.290357, -75.435539),
    "18960": (40.360473, -75.317521),
    "18962": (40.344529, -75.268738),
    "18963": (40.328645, -75.10278),
    "18964": (40.288379, -75.341026),
    "18966": (40.186758, -75.007099),
    "18968": (40.328645, -75.10278),
    "18969": (40.325792, -75.380495),
    "18970": (40.328645, -75.10278),
    "18971": (40.34698, -75.376985),
    "18972": (40.529063, -75.124333),
    "18974": (40.208476, -75.040613),
    "18976": (40.244807, -75.142587),
    "18977": (40.284947, -74.877828),
    "18979": (40.211896, -75.35586),
    "18980": (40.274185, -75.020499),
    "18981": (40.328645, -75.10278),
    "18991": (40.328645, -75.10278),
    "19001": (40.123805, -75.114767),
    "19002": (40.180876, -75.215621),
    "19003": (39.998811, -75.30793),
    "19004": (40.013811, -75.228224),
    "19006": (40.1284, -75.060665),
    "19007": (40.115859, -74.853608),
    "19008": (39.972965, -75.365635),
    "19009": (40.135012, -75.062292),
    "19010": (39.955561, -75.344833),
    "19012": (40.059161, -75.104468),
    "19013": (39.878817, -75.437102),
    "19014": (39.866766, -75.398537),
    "19015": (39.909511, -75.366785),
    "19016": (39.934047, -75.405987),
    "19017": (39.883911, -75.466949),
    "19018": (39.921562, -75.29503),
    "19019": (40.001811, -75.11787),
    "19020": (40.125609, -74.994262),
    "19021": (40.090878, -74.887554),
    "19022": (39.898162, -75.319632),
    "19023": (39.917562, -75.269628),
    "19025": (40.162403, -75.409776),
    "19026": (39.937562, -75.307731),
    "19027": (40.07501, -75.131518),
    "19028": (39.934047, -75.405987),
    "19029": (39.867562, -75.28586),
    "19030": (40.177087, -74.829107),
    "19031": (40.106805, -75.215071),
    "19032": (39.895162, -75.278829),
    "19033": (39.890962, -75.327282),
    "19034": (40.130959, -75.207437),
    "19035": (40.04486, -75.280686),
    "19036": (39.902512, -75.29268),
    "19037": (39.934047, -75.405987),
    "19038": (40.101109, -75.17802),
    "19039": (39.88211, -75.337234),
    "19040": (40.182406, -75.106265),
    "19041": (40.002911, -75.321632),
    "19043": (39.899562, -75.307731),
    "19044": (40.191808, -75.150577),
    "19046": (40.09796, -75.107767),
    "19047": (40.289021, -75.065486),
    "19048": (40.173509, -74.92461),
    "19049": (40.328645, -75.10278),
    "19050": (39.914562, -75.29458),
    "19052": (39.894161, -75.445589),
    "19053": (40.15468, -74.990378),
    "19054": (40.174246, -74.821857),
    "19055": (40.145759, -74.841107),
    "19056": (40.147709, -74.880059),
    "19057": (40.143309, -74.846373),
    "19058": (40.328645, -75.10278),
    "19059": (40.328645, -75.10278),
    "19061": (39.85091, -75.418228),
    "19063": (39.918804, -75.399118),
    "19064": (39.931858, -75.341583),
    "19065": (39.921061, -75.386136),
    "19066": (40.003412, -75.249476),
    "19067": (40.208408, -74.82914),
    "19070": (39.907762, -75.325182),
    "19072": (40.020911, -75.259975),
    "19073": (39.955409, -75.40172),
    "19074": (39.888412, -75.29818),
    "19075": (40.113809, -75.185219),
    "19076": (39.885984, -75.307231),
    "19078": (39.878212, -75.323082),
    "19079": (39.901112, -75.267628),
    "19080": (40.043201, -75.357678),
    "19081": (39.897162, -75.344083),
    "19082": (39.951662, -75.285429),
    "19083": (39.974861, -75.312081),
    "19085": (40.027909, -75.369458),
    "19086": (39.896711, -75.370385),
    "19087": (39.98596, -75.370934),
    "19088": (39.934047, -75.405987),
    "19089": (40.043399, -75.357308),
    "19090": (40.161856, -75.10897),
    "19091": (39.934047, -75.405987),
    "19092": (40.001811, -75.11787),
    "19093": (40.001811, -75.11787),
    "19094": (39.876862, -75.346083),
    "19095": (40.08561, -75.151569),
    "19096": (40.051411, -75.164822),
    "19098": (39.895362, -75.310731),
    "19099": (40.001811, -75.11787),
    "19101": (40.001811, -75.11787),
    "19102": (39.952562, -75.166472),
    "19103": (40.003361, -75.186822),
    "19104": (39.960912, -75.19668),
    "19105": (40.001811, -75.11787),
    "19106": (39.950004, -75.150071),
    "19107": (39.962612, -75.162871),
    "19108": (39.959812, -75.161622),
    "19109": (39.949612, -75.163722),
    "19110": (39.950212, -75.163572),
    "19111": (40.06317, -75.081317),
    "19112": (39.892213, -75.179623),
    "19113": (39.869958, -75.277458),
    "19114": (40.019816, -75.065617),
    "19115": (40.07841, -75.045065),
    "19116": (40.104709, -75.006771),
    "19118": (40.07231, -75.203371),
    "19119": (40.068142, -75.123024),
    "19120": (40.031611, -75.119019),
    "19121": (39.983212, -75.174172),
    "19122": (39.977462, -75.141271),
    "19123": (39.98238, -75.115369),
    "19124": (40.021561, -75.093668),
    "19125": (39.977262, -75.13292),
    "19126": (40.061411, -75.131769),
    "19127": (40.024761, -75.222473),
    "19128": (40.049111, -75.178489),
    "19129": (40.022911, -75.167771),
    "19130": (40.001161, -75.169671),
    "50013": (42.023535, -93.640818),
    "19131": (39.996811, -75.207774),
    "19132": (40.040111, -75.117719),
    "19133": (39.992562, -75.13732),
    "19134": (39.994662, -75.107969),
    "19135": (40.017061, -75.098618),
    "19136": (40.044661, -75.020665),
    "19137": (39.986162, -75.150671),
    "19138": (40.056261, -75.16117),
    "19139": (39.996211, -75.117519),
    "19140": (40.014861, -75.128302),
    "19141": (40.009611, -75.15032),
    "19142": (39.963339, -75.161672),
    "19143": (39.957312, -75.187023),
    "19144": (40.033111, -75.179871),
    "19145": (39.917002, -75.1877),
    "19146": (39.945112, -75.175822),
    "19147": (39.936212, -75.155973),
    "19148": (39.950362, -75.155371),
    "19149": (40.024361, -75.081668),
    "19150": (40.07231, -75.17122),
    "19151": (39.986610999999996, -75.213174),
    "19152": (40.014011, -75.086818),
    "19153": (39.899412, -75.226976),
    "19154": (40.084017, -75.018265),
    "19155": (40.001811, -75.11787),
    "19160": (40.001811, -75.11787),
    "19161": (40.001811, -75.11787),
    "19162": (40.001811, -75.11787),
    "19170": (40.001811, -75.11787),
    "19171": (40.001811, -75.11787),
    "19172": (39.947321, -75.150011),
    "19173": (40.001811, -75.11787),
    "19175": (39.990562, -75.12957),
    "19177": (40.001811, -75.11787),
    "19178": (40.001811, -75.11787),
    "19179": (40.001811, -75.11787),
    "19181": (40.001811, -75.11787),
    "19182": (40.001811, -75.11787),
    "19183": (40.001811, -75.11787),
    "19184": (40.001811, -75.11787),
    "19185": (40.001811, -75.11787),
    "19187": (40.001811, -75.11787),
    "19188": (40.001811, -75.11787),
    "19191": (40.001811, -75.11787),
    "19192": (39.951112, -75.167622),
    "19193": (40.001811, -75.11787),
    "19194": (40.001811, -75.11787),
    "19196": (40.001811, -75.11787),
    "19197": (40.001811, -75.11787),
    "19244": (40.001811, -75.11787),
    "19255": (40.001811, -75.11787),
    "19301": (40.040057, -75.488793),
    "19310": (39.941554, -75.957993),
    "19311": (39.866821, -75.839686),
    "19312": (40.030058, -75.45644),
    "19316": (40.054976, -75.837767),
    "19317": (39.865567, -75.557698),
    "19318": (39.852406, -75.811789),
    "19319": (39.920918, -75.522168),
    "19320": (39.968862, -75.829163),
    "19330": (39.916517, -75.925805),
    "19331": (39.882274, -75.516529),
    "19333": (40.042623, -75.42746),
    "19335": (40.031265, -75.722614),
    "19339": (39.934047, -75.405987),
    "19340": (39.934047, -75.405987),
    "19341": (40.049852, -75.637035),
    "19342": (39.902633, -75.483224),
    "19343": (40.100892, -75.753071),
    "19344": (40.089561, -75.867533),
    "19345": (39.847803, -75.719347),
    "19346": (39.983153, -75.748055),
    "19347": (39.983153, -75.748055),
    "19348": (39.867864, -75.716333),
    "19350": (39.771506, -75.799761),
    "19351": (39.983153, -75.748055),
    "19352": (39.778703, -75.88758),
    "19353": (40.013158, -75.499046),
    "19354": (40.058173, -75.743272),
    "19355": (40.02951, -75.713599),
    "19357": (39.983153, -75.748055),
    "19358": (39.962081, -75.802502),
    "19360": (39.726143, -75.7857),
    "19362": (39.757361, -76.037603),
    "19363": (39.849721, -75.957276),
    "19365": (40.001064, -75.830891),
    "19366": (39.983153, -75.748055),
    "19367": (39.970601, -75.895794),
    "19369": (39.990302, -75.893598),
    "19370": (39.983153, -75.748055),
    "19371": (39.983153, -75.748055),
    "19372": (39.993929, -75.818572),
    "19373": (39.905987, -75.535383),
    "19374": (39.872825, -75.848075),
    "19375": (39.901177, -75.750203),
    "19376": (39.983153, -75.748055),
    "19380": (39.980107, -75.610503),
    "19381": (39.983153, -75.748055),
    "19382": (39.912284, -75.630235),
    "19383": (39.94545, -75.602401),
    "19390": (39.841367, -75.847944),
    "19395": (39.932821, -75.544822),
    "19397": (39.983153, -75.748055),
    "19398": (39.983153, -75.748055),
    "19399": (39.983153, -75.748055),
    "19401": (40.149154, -75.356627),
    "19403": (40.124886, -75.357027),
    "19404": (40.211896, -75.35586),
    "19405": (40.120931, -75.362127),
    "19406": (40.179242, -75.388022),
    "19407": (40.211896, -75.35586),
    "19408": (40.156555, -75.413127),
    "19409": (40.211896, -75.35586),
    "19420": (40.152871, -75.456719),
    "19421": (39.983153, -75.748055),
    "19422": (40.15755, -75.279941),
    "19423": (40.21735, -75.364973),
    "19424": (40.211896, -75.35586),
    "19425": (40.103858, -75.639994),
    "19426": (40.236083, -75.430272),
    "19428": (40.082509, -75.304377),
    "19429": (40.211896, -75.35586),
    "19430": (40.185071, -75.419966),
    "19432": (40.079629, -75.559975),
    "19435": (40.312552, -75.55171),
    "19436": (40.200757, -75.250665),
    "19437": (40.181054, -75.257855),
    "19438": (40.274188, -75.395188),
    "19440": (40.28202, -75.358491),
    "19441": (40.211896, -75.35586),
    "19442": (40.146549, -75.617739),
    "19443": (40.241004, -75.34392),
    "19444": (40.08526, -75.257423),
    "19446": (40.224245, -75.29156),
    "19450": (40.211896, -75.35586),
    "19451": (40.211896, -75.35586),
    "19452": (40.211896, -75.35586),
    "19453": (40.151918, -75.504383),
    "19454": (40.220106, -75.237877),
    "19455": (40.211896, -75.35586),
    "19456": (40.133355, -75.453631),
    "19457": (40.208976, -75.5984),
    "19460": (40.128175, -75.541769),
    "19462": (40.137759, -75.352751),
    "19464": (40.263457, -75.617195),
    "19465": (40.191907, -75.66531),
    "19468": (40.20894, -75.490215),
    "19470": (40.186707, -75.728759),
    "19472": (40.344773, -75.57745800000001),
    "19473": (40.224789, -75.478534),
    "19474": (40.225109, -75.403095),
    "19475": (40.146989, -75.605398),
    "19477": (40.185934, -75.232407),
    "19478": (40.275914, -75.461756),
    "19480": (40.098032, -75.688005),
    "19481": (40.092269, -75.453735),
    "19482": (40.080323, -75.455408),
    "19483": (40.211896, -75.35586),
    "19484": (40.211896, -75.35586),
    "19485": (40.211896, -75.35586),
    "19486": (40.203291, -75.301918),
    "19487": (39.983153, -75.748055),
    "19488": (39.983153, -75.748055),
    "19489": (39.983153, -75.748055),
    "19490": (40.192881, -75.357555),
    "19492": (40.290125, -75.502974),
    "19493": (39.983153, -75.748055),
    "19494": (39.983153, -75.748055),
    "19495": (39.983153, -75.748055),
    "19496": (39.983153, -75.748055),
    "19501": (40.242327, -76.057696),
    "19503": (40.447833, -75.708672),
    "19504": (40.335395, -75.720131),
    "19505": (40.458523, -75.741863),
    "19506": (40.454997, -75.90646),
    "19507": (40.491214, -76.269231),
    "19508": (40.404848, -75.886642),
    "19510": (40.371492, -75.887797),
    "19511": (40.482102, -75.743476),
    "19512": (40.364068, -75.870971),
    "19516": (40.485843, -76.005958),
    "19518": (40.365322, -75.848729),
    "19519": (40.318986, -75.733368),
    "19520": (40.156293, -75.786492),
    "19522": (40.326392, -75.808303),
    "19523": (40.189715, -75.888112),
    "19525": (40.309952, -75.584885),
    "19526": (40.368035, -75.861788),
    "19529": (40.627864, -75.883429),
    "19530": (40.473382, -75.775241),
    "19533": (40.420446, -75.85715),
    "19534": (40.573618, -75.864968),
    "19535": (40.335593, -75.801009),
    "19536": (40.521756, -75.741859),
    "19538": (40.569818, -75.740942),
    "19539": (40.432311, -75.796571),
    "19540": (40.321665, -75.804757),
    "19541": (40.400685, -76.037566),
    "19542": (40.260992, -75.768437),
    "19543": (40.367731, -75.89161),
    "19544": (40.418662, -76.294364),
    "19545": (40.33968, -75.63016),
    "19547": (40.343449, -75.897566),
    "19548": (40.407173, -75.984901),
    "19549": (40.722587, -76.229623),
    "19550": (40.455305, -76.245345),
    "19551": (40.326171, -75.88889),
    "19554": (40.505184, -76.141334),
    "19555": (40.411279, -75.887016),
    "19557": (40.613868, -75.814984),
    "19559": (40.494368, -76.18646),
    "19560": (40.395908, -75.889849),
    "19562": (40.476019, -75.849294),
    "19564": (40.526803, -75.869653),
    "19565": (40.337188, -75.951748),
    "19567": (40.432759, -75.925707),
    "19601": (40.357242, -75.940153),
    "19602": (40.326546, -75.915919),
    "19603": (40.388442, -75.963055),
    "19604": (40.360942, -75.927852),
    "19605": (40.404942, -75.941603),
    "19606": (40.335119, -75.874976),
    "19607": (40.299463, -75.987606),
    "19608": (40.316342, -75.935521),
    "19609": (40.327992, -75.990807),
    "19610": (40.338017, -75.978006),
    "19611": (40.303892, -75.938853),
    "19612": (40.4389, -75.885303),
    "19640": (40.407173, -75.984901),
    "19701": (39.594736, -75.693903),
    "19702": (39.614737, -75.701277),
    "19703": (39.80379, -75.45814),
    "19706": (39.594256, -75.608081),
    "19707": (39.635202, -75.680897),
    "19708": (39.577567, -75.690069),
    "19709": (39.485721, -75.677535),
    "19710": (39.757783, -75.639143),
    "19711": (39.668282, -75.688489),
    "19712": (39.564499, -75.597047),
    "19713": (39.665662, -75.719349),
    "19714": (39.564499, -75.597047),
    "19715": (39.564499, -75.597047),
    "19716": (39.564499, -75.597047),
    "19717": (39.564499, -75.597047),
    "19718": (39.564499, -75.597047),
    "19720": (39.592895, -75.651466),
    "19721": (39.564499, -75.597047),
    "19725": (39.564499, -75.597047),
    "19726": (39.564499, -75.597047),
    "19730": (39.51251, -75.627281),
    "19731": (39.512902, -75.58518),
    "19732": (39.793864, -75.57375),
    "19733": (39.555459, -75.650462),
    "19734": (39.430666, -75.646408),
    "19735": (39.794396, -75.597598),
    "19736": (39.797126, -75.660413),
    "19801": (39.727113, -75.547844),
    "19802": (39.71987, -75.593512),
    "19803": (39.79936, -75.531694),
    "19804": (39.759577, -75.617198),
    "19805": (39.743107, -75.593447),
    "19806": (39.758562, -75.568745),
    "19807": (39.794943, -75.616134),
    "19808": (39.735912, -75.664729),
    "19809": (39.764712, -75.506892),
    "19810": (39.763961, -75.527812),
    "19850": (39.564499, -75.597047),
    "19880": (39.564499, -75.597047),
    "19884": (39.564499, -75.597047),
    "19885": (39.564499, -75.597047),
    "19886": (39.564499, -75.597047),
    "19887": (39.564499, -75.597047),
    "19889": (39.564499, -75.597047),
    "19890": (39.564499, -75.597047),
    "19891": (39.564499, -75.597047),
    "19892": (39.564499, -75.597047),
    "19893": (39.564499, -75.597047),
    "19894": (39.564499, -75.597047),
    "19895": (39.564499, -75.597047),
    "19896": (39.564499, -75.597047),
    "19897": (39.564499, -75.597047),
    "19898": (39.564499, -75.597047),
    "19899": (39.734792, -75.624617),
    "19901": (39.156376, -75.49549),
    "19902": (39.10868, -75.448023),
    "19903": (39.10868, -75.448023),
    "19904": (39.160542, -75.597381),
    "19905": (39.10868, -75.448023),
    "19930": (38.555533, -75.186955),
    "19931": (38.569091, -75.624087),
    "19933": (38.660295, -75.330023),
    "19934": (39.086921, -75.612286),
    "19936": (39.218448, -75.584848),
    "19938": (39.246071, -75.688873),
    "19939": (38.621403, -75.181502),
    "19940": (38.631744, -75.324585),
    "19941": (38.652805, -75.275018),
    "19943": (39.033438, -75.609891),
    "19944": (38.486485, -75.058874),
    "19945": (38.55144, -75.157634),
    "19946": (39.023141, -75.48191),
    "19947": (38.632891, -75.33426299999999),
    "19950": (38.82458, -75.588771),
    "19951": (38.691547, -75.225025),
    "19952": (38.912195, -75.611322),
    "19953": (39.16343, -75.679733),
    "19954": (38.894017, -75.520078),
    "19955": (39.225604, -75.664153),
    "19956": (38.663322, -75.378729),
    "19958": (38.65536, -75.325612),
    "19960": (38.848792, -75.41087),
    "19961": (39.166323, -75.448289),
    "19962": (38.971647, -75.591714),
    "19963": (38.72712, -75.322829),
    "19964": (39.140254, -75.667898),
    "19966": (38.659458, -75.24641),
    "19967": (38.700518, -75.242294),
    "19968": (38.692714, -75.322223),
    "19969": (38.725562, -75.353387),
    "19970": (38.621587, -75.104645),
    "19971": (38.629763, -75.319975),
    "19973": (38.659891, -75.380454),
    "19975": (38.550784, -75.330307),
    "19977": (39.194026, -75.565131),
    "19979": (38.971038, -75.577158),
    "19980": (39.07239, -75.571073),
    "20001": (38.911936, -77.016719),
    "20002": (38.908218, -76.982147),
    "20003": (38.860315, -76.988897),
    "20004": (38.892247, -77.019477),
    "20005": (38.904011, -77.031695),
    "20006": (38.897131, -77.041248),
    "20007": (38.914561, -77.075649),
    "20008": (38.93521, -77.060399),
    "20009": (38.919261, -77.039798),
    "20010": (38.932711, -77.030248),
    "20011": (38.95261, -77.017898),
    "20012": (38.980231, -77.026298),
    "20013": (38.893311, -77.014647),
    "20015": (38.96926, -77.070949),
    "20016": (38.93826, -77.091149),
    "20017": (38.93846, -76.993068),
    "20018": (38.93056, -76.977953),
    "20019": (38.891561, -76.939396),
    "20020": (38.85761, -76.971547),
    "20024": (38.876494, -77.022948),
    "20026": (38.893311, -77.014647),
    "20029": (38.893311, -77.014647),
    "20030": (38.893311, -77.014647),
    "20032": (38.8368, -76.997697),
    "20033": (38.893311, -77.014647),
    "20035": (38.893311, -77.014647),
    "20036": (38.900659, -77.039914),
    "20037": (38.918903, -77.061781),
    "20038": (38.893311, -77.014647),
    "20039": (38.893311, -77.014647),
    "20040": (38.893311, -77.014647),
    "20041": (38.893311, -77.014647),
    "20042": (38.893311, -77.014647),
    "20043": (38.893311, -77.014647),
    "20044": (38.893311, -77.014647),
    "20045": (38.896599, -77.0319),
    "20046": (38.893311, -77.014647),
    "20047": (38.893311, -77.014647),
    "20049": (38.895911, -77.020998),
    "20050": (38.893311, -77.014647),
    "20051": (38.893311, -77.014647),
    "20052": (38.90014, -77.047899),
    "20053": (38.893311, -77.014647),
    "20055": (38.901633, -77.020959),
    "20056": (38.893311, -77.014647),
    "20057": (38.893311, -77.014647),
    "20058": (38.893311, -77.014647),
    "20059": (38.893311, -77.014647),
    "20060": (38.918011, -77.020398),
    "20061": (38.893311, -77.014647),
    "20062": (38.900009, -77.036948),
    "20063": (38.905317, -77.046645),
    "20064": (38.933161, -76.996348),
    "20065": (38.883412, -77.028198),
    "20066": (38.893311, -77.014647),
    "20067": (38.893311, -77.014647),
    "20068": (38.893311, -77.014647),
    "20069": (38.893311, -77.014647),
    "20070": (38.893311, -77.014647),
    "20071": (38.893311, -77.014647),
    "20073": (38.897011, -77.025098),
    "20074": (38.893311, -77.014647),
    "20075": (38.893311, -77.014647),
    "20076": (38.893311, -77.014647),
    "20077": (38.893311, -77.014647),
    "20078": (38.893311, -77.014647),
    "20080": (38.893311, -77.014647),
    "20081": (38.893311, -77.014647),
    "20082": (38.893311, -77.014647),
    "50014": (42.045748, -93.647237),
    "20088": (38.893311, -77.014647),
    "20090": (38.893311, -77.014647),
    "20091": (38.893311, -77.014647),
    "20097": (38.893311, -77.014647),
    "20098": (38.893311, -77.014647),
    "20099": (38.893311, -77.014647),
    "20101": (39.002125, -77.442066),
    "20102": (39.085309, -77.645224),
    "20103": (38.996242, -77.449952),
    "20104": (39.085309, -77.645224),
    "20105": (38.957718, -77.60375),
    "20106": (38.6842, -78.016813),
    "20107": (38.968321, -77.533263),
    "20108": (38.744685, -77.487162),
    "20109": (38.763215, -77.493092),
    "20110": (38.749207, -77.487762),
    "20111": (38.770741, -77.449443),
    "20112": (38.770864, -77.449443),
    "20113": (38.770864, -77.449443),
    "20115": (38.840456, -77.891136),
    "20116": (38.853723, -77.860127),
    "20117": (39.029599, -77.693844),
    "20118": (39.007548, -77.765553),
    "20119": (38.636964, -77.638287),
    "20120": (38.84479, -77.46701),
    "20121": (38.819513, -77.45576),
    "20122": (38.831813, -77.288755),
    "20124": (38.781809, -77.381808),
    "20128": (38.741639, -77.977432),
    "20129": (39.160291, -77.60967),
    "20130": (39.004843, -77.954597),
    "20131": (39.057952, -77.743423),
    "20132": (39.143614, -77.734232),
    "20134": (39.152187, -77.702576),
    "20135": (39.082266, -77.846661),
    "20136": (38.734255, -77.547383),
    "20137": (38.819463999999996, -77.736814),
    "20138": (38.633774, -77.686868),
    "20139": (38.654282, -77.702542),
    "20140": (38.916291, -77.864841),
    "20141": (39.116425, -77.780216),
    "20142": (39.130665, -77.774665),
    "20143": (38.845535, -77.566921),
    "20144": (38.911315, -77.967401),
    "20146": (39.085309, -77.645224),
    "20147": (39.037339, -77.480542),
    "20148": (39.014196, -77.528452),
    "20149": (39.085309, -77.645224),
    "20151": (38.88668, -77.44566),
    "20152": (38.897591, -77.509174),
    "20153": (38.831813, -77.288755),
    "20155": (38.815714, -77.621613),
    "20156": (38.721912, -77.466897),
    "20158": (39.138314, -77.657328),
    "20159": (39.133855, -77.662072),
    "20160": (39.098479, -77.688338),
    "20163": (39.085309, -77.645224),
    "20164": (39.023047, -77.399367),
    "20165": (39.047157, -77.386647),
    "20166": (38.981387, -77.472333),
    "20167": (39.085309, -77.645224),
    "20168": (38.721912, -77.466897),
    "20169": (38.867441, -77.644539),
    "20170": (38.983887, -77.367457),
    "20171": (38.92518, -77.39284),
    "20172": (38.831813, -77.288755),
    "20175": (39.041987, -77.605404),
    "20176": (39.119727, -77.603458),
    "20177": (39.158095, -77.666863),
    "20178": (39.072918, -77.608014),
    "20180": (39.220432, -77.659636),
    "20181": (38.700017, -77.548271),
    "20182": (38.700866, -77.585708),
    "20184": (38.962661, -77.884726),
    "20185": (38.992978, -77.879855),
    "20186": (38.689832, -77.836115),
    "20187": (38.715296, -77.741696),
    "20188": (38.765619, -77.820293),
    "20190": (38.96146, -77.3418),
    "20191": (38.93181, -77.352718),
    "20192": (38.831813, -77.288755),
    "20193": (38.831813, -77.288755),
    "20194": (38.980742, -77.341878),
    "20195": (38.831813, -77.288755),
    "20196": (38.831813, -77.288755),
    "20197": (39.188205, -77.630013),
    "20198": (38.870681, -77.760779),
    "20199": (39.085309, -77.645224),
    "20201": (38.893311, -77.014647),
    "20202": (38.893311, -77.014647),
    "20203": (38.905317, -77.046645),
    "20204": (38.893311, -77.014647),
    "20206": (38.893311, -77.014647),
    "20207": (38.893311, -77.014647),
    "20208": (38.896611, -77.011748),
    "20210": (38.893311, -77.014647),
    "20211": (38.893311, -77.014647),
    "20212": (38.893311, -77.014647),
    "20213": (38.893311, -77.014647),
    "20214": (38.893311, -77.014647),
    "20215": (38.893311, -77.014647),
    "20216": (38.891911, -77.014098),
    "20217": (38.893311, -77.014647),
    "20218": (38.893311, -77.014647),
    "20219": (38.893311, -77.014647),
    "20220": (38.893311, -77.014647),
    "20221": (38.893311, -77.014647),
    "20222": (38.893311, -77.014647),
    "20223": (38.893311, -77.014647),
    "20224": (38.893311, -77.014647),
    "20226": (38.893311, -77.014647),
    "20227": (38.893311, -77.014647),
    "20228": (38.893311, -77.014647),
    "20229": (38.893311, -77.014647),
    "20230": (38.893311, -77.014647),
    "20231": (38.893311, -77.014647),
    "20232": (38.900561, -77.039099),
    "20233": (38.893311, -77.014647),
    "20235": (38.915361, -77.057199),
    "20238": (38.893311, -77.014647),
    "20239": (38.893311, -77.014647),
    "20240": (38.897143, -77.040895),
    "20241": (38.893311, -77.014647),
    "20242": (38.867812, -77.028948),
    "20244": (38.893311, -77.014647),
    "20245": (38.893311, -77.014647),
    "20250": (38.887323, -77.03274),
    "20251": (38.893311, -77.014647),
    "20254": (38.893311, -77.014647),
    "20260": (38.893311, -77.014647),
    "20261": (38.893311, -77.014647),
    "20262": (38.893311, -77.014647),
    "20265": (38.893311, -77.014647),
    "20266": (38.893311, -77.014647),
    "20268": (38.893311, -77.014647),
    "20270": (38.893311, -77.014647),
    "20277": (38.893311, -77.014647),
    "20289": (38.893311, -77.014647),
    "20299": (38.893311, -77.014647),
    "20301": (38.889357, -77.031113),
    "20303": (38.893311, -77.014647),
    "20306": (38.893311, -77.014647),
    "20307": (38.893311, -77.014647),
    "20310": (38.893311, -77.014647),
    "20314": (38.893311, -77.014647),
    "20315": (38.928861, -77.017948),
    "20317": (38.931161, -77.010298),
    "20318": (38.893311, -77.014647),
    "20319": (38.866745, -77.016556),
    "20330": (38.893311, -77.014647),
    "20332": (38.834563, -77.015848),
    "20336": (38.860415, -77.022545),
    "20337": (38.893311, -77.014647),
    "20338": (38.893311, -77.014647),
    "20340": (38.893311, -77.014647),
    "20350": (38.893311, -77.014647),
    "20370": (38.893311, -77.014647),
    "20372": (38.893311, -77.014647),
    "20373": (38.893311, -77.014647),
    "20374": (38.855522, -77.002197),
    "20375": (38.826163, -77.017448),
    "20380": (38.893311, -77.014647),
    "20388": (38.872552999999996, -76.996605),
    "20389": (38.893311, -77.014647),
    "20390": (38.893311, -77.014647),
    "20391": (38.893311, -77.014647),
    "20392": (38.893311, -77.014647),
    "20393": (38.893311, -77.014647),
    "20394": (38.893311, -77.014647),
    "20395": (38.893311, -77.014647),
    "20398": (38.893311, -77.014647),
    "20401": (38.893311, -77.014647),
    "20402": (38.893311, -77.014647),
    "20403": (38.893311, -77.014647),
    "20404": (38.899161, -77.008948),
    "20405": (38.893311, -77.014647),
    "20406": (38.893311, -77.014647),
    "20407": (38.893311, -77.014647),
    "20408": (38.893311, -77.014647),
    "20409": (38.893311, -77.014647),
    "20410": (38.893311, -77.014647),
    "20411": (38.883962, -77.022098),
    "20412": (38.895261, -77.022098),
    "20413": (38.893311, -77.014647),
    "20414": (38.883962, -77.022098),
    "20415": (38.893311, -77.014647),
    "20416": (38.893311, -77.014647),
    "20418": (38.904253, -77.05723),
    "20419": (38.893311, -77.014647),
    "20420": (38.903461, -77.027648),
    "20421": (38.893311, -77.014647),
    "20422": (38.893311, -77.014647),
    "20423": (38.893311, -77.014647),
    "20424": (38.893311, -77.014647),
    "20425": (38.893311, -77.014647),
    "20426": (38.893311, -77.014647),
    "20427": (38.893311, -77.014647),
    "20428": (38.893311, -77.014647),
    "20429": (38.893311, -77.014647),
    "20431": (38.898618, -77.042753),
    "20433": (38.899996, -77.041976),
    "20434": (38.893311, -77.014647),
    "20435": (38.899399, -77.040319),
    "20436": (38.895927, -77.021068),
    "20437": (38.902761, -77.048499),
    "20439": (38.893311, -77.014647),
    "20440": (38.913911, -77.045349),
    "20441": (38.923861, -77.036349),
    "20442": (38.895977, -77.017668),
    "20444": (38.893311, -77.014647),
    "20447": (38.884712, -77.025198),
    "20451": (38.897711, -77.044449),
    "20453": (38.893311, -77.014647),
    "20456": (38.898111, -77.040149),
    "20460": (38.876362, -77.018798),
    "20463": (38.893311, -77.014647),
    "20468": (38.893311, -77.014647),
    "20469": (38.893311, -77.014647),
    "20470": (38.893311, -77.014647),
    "20472": (38.893311, -77.014647),
    "20501": (38.89872, -77.036198),
    "20502": (38.89872, -77.036198),
    "20503": (38.900711, -77.043068),
    "20504": (38.893311, -77.014647),
    "20505": (38.893311, -77.014647),
    "20506": (38.899364, -77.037668),
    "20507": (38.893311, -77.014647),
    "20508": (38.893311, -77.014647),
    "20510": (38.893311, -77.014647),
    "20515": (38.893311, -77.014647),
    "20520": (38.893217, -77.048957),
    "20521": (38.893311, -77.014647),
    "20522": (38.893217, -77.048957),
    "20523": (38.89449, -77.047807),
    "20524": (38.902414, -77.032601),
    "20525": (38.893311, -77.014647),
    "20526": (38.902217, -77.043738),
    "20527": (38.902933, -77.036091),
    "20530": (38.897561, -77.026998),
    "20531": (38.893761, -77.021848),
    "20532": (38.904486, -77.017291),
    "20533": (38.901102, -77.032591),
    "20534": (38.894075, -77.01254),
    "20535": (38.894097, -77.025133),
    "20536": (38.901211, -77.016948),
    "20537": (38.894097, -77.025133),
    "20538": (38.893311, -77.014647),
    "20539": (38.893311, -77.014647),
    "20540": (38.887405, -77.004663),
    "20541": (38.887405, -77.004663),
    "20542": (38.940761, -77.028348),
    "20543": (38.893311, -77.014647),
    "20544": (38.893311, -77.014647),
    "20546": (38.890976, -77.021092),
    "20547": (38.893311, -77.014647),
    "20548": (38.898111, -77.017698),
    "20549": (38.893311, -77.014647),
    "20550": (38.893311, -77.014647),
    "20551": (38.891995, -77.045219),
    "20552": (38.893311, -77.014647),
    "20553": (38.887333, -77.023118),
    "20554": (38.893311, -77.014647),
    "20555": (38.900011, -77.040149),
    "20557": (38.887405, -77.004663),
    "20558": (38.893311, -77.014647),
    "20559": (38.887405, -77.004663),
    "20560": (38.893311, -77.014647),
    "20565": (38.891941, -77.018853),
    "20566": (38.897074, -77.05535),
    "20570": (38.899061, -77.040149),
    "20571": (38.900559, -77.034554),
    "20572": (38.893311, -77.014647),
    "20573": (38.893311, -77.014647),
    "20575": (38.893311, -77.014647),
    "20576": (38.893662, -77.023592),
    "20577": (38.900758, -77.034455),
    "56651": (47.836367, -96.3504),
    "20578": (38.893311, -77.014647),
    "20579": (38.904311, -77.044649),
    "20580": (38.893311, -77.014647),
    "20581": (38.893311, -77.014647),
    "20585": (38.893311, -77.014647),
    "20586": (38.902211, -77.047399),
    "20590": (38.883962, -77.022098),
    "20591": (38.893311, -77.014647),
    "20593": (38.893311, -77.014647),
    "20594": (38.88494, -77.018372),
    "20597": (38.893311, -77.014647),
    "20599": (38.893311, -77.014647),
    "20601": (38.603783, -76.867928),
    "20602": (38.518559, -76.912165),
    "20603": (38.52115, -77.062012),
    "20604": (38.509548, -76.981651),
    "20606": (38.247149, -76.748088),
    "20607": (38.666071, -76.998396),
    "20608": (38.588843, -76.712639),
    "20609": (38.300217, -76.743445),
    "20610": (38.444727, -76.533026),
    "20611": (38.454919, -76.980364),
    "20612": (38.508689, -76.687344),
    "20613": (38.658807, -76.824293),
    "20615": (38.493984, -76.567469),
    "20616": (38.636227, -77.084649),
    "20617": (38.536256, -76.853752),
    "20618": (38.309506999999996, -76.763069),
    "20619": (38.324994, -76.637383),
    "20620": (38.347927, -76.621613),
    "20621": (38.350987, -76.783288),
    "20622": (38.484421, -76.754943),
    "20623": (38.745514, -76.840572),
    "20624": (38.329424, -76.730799),
    "20625": (38.262037, -76.85019),
    "20626": (38.236645, -76.762227),
    "20627": (38.276828, -76.703971),
    "20628": (38.148114, -76.359651),
    "20629": (38.376974, -76.434476),
    "20630": (38.178948, -76.47451),
    "20632": (38.421762, -76.948718),
    "20634": (38.242387, -76.501513),
    "20635": (38.312112, -76.607676),
    "20636": (38.342437, -76.569163),
    "20637": (38.520572, -76.781313),
    "20639": (38.519368, -76.546326),
    "20640": (38.453999, -77.052819),
    "20643": (38.503876, -77.148283),
    "20645": (38.298477, -76.88491),
    "20646": (38.513875, -77.01034),
    "20650": (38.278757, -76.655917),
    "20653": (38.232909, -76.430853),
    "20656": (38.359274, -76.683325),
    "20657": (38.493430000000004, -76.459768),
    "20658": (38.563331, -77.159621),
    "20659": (38.279211, -76.608406),
    "20660": (38.363994, -76.694102),
    "20661": (38.343591, -76.884559),
    "20662": (38.430568, -77.192545),
    "20664": (38.364718, -76.917398),
    "20667": (38.216529, -76.433445),
    "20670": (38.281094, -76.420952),
    "20674": (38.16863, -76.498367),
    "20675": (38.576096, -77.015916),
    "20676": (38.560231, -76.531761),
    "20677": (38.504699, -77.037862),
    "20678": (38.511282, -76.528578),
    "20680": (38.122181, -76.369412),
    "20682": (38.283551, -76.848093),
    "20684": (38.141377, -76.38535),
    "20685": (38.440484, -76.51736),
    "20686": (38.188796, -76.420738),
    "20687": (38.078898, -76.351659),
    "20688": (38.37741, -76.440937),
    "20689": (38.556448, -76.541436),
    "20690": (38.160744, -76.525504),
    "20692": (38.192688, -76.501604),
    "20693": (38.476246, -77.084009),
    "20695": (38.59744, -76.990278),
    "20697": (38.833563, -76.877743),
    "20701": (39.1332, -76.798843),
    "20703": (38.833563, -76.877743),
    "20704": (38.833563, -76.877743),
    "20705": (39.044858, -76.886795),
    "20706": (38.96076, -76.856135),
    "20707": (39.093136, -76.881945),
    "20708": (39.049859, -76.834493),
    "20709": (38.833563, -76.877743),
    "20710": (38.901211, -76.925943),
    "20711": (38.802262999999996, -76.645735),
    "20712": (38.942660000000004, -76.967057),
    "20714": (38.610496, -76.595901),
    "20715": (38.982612, -76.74379),
    "20716": (38.926311, -76.709789),
    "20717": (38.833563, -76.877743),
    "20718": (38.833563, -76.877743),
    "20719": (38.833563, -76.877743),
    "20720": (38.98851, -76.79098),
    "20721": (38.919357, -76.787141),
    "20722": (38.886849, -76.865764),
    "20723": (39.13652, -76.868729),
    "20724": (39.098008, -76.804443),
    "20725": (38.833563, -76.877743),
    "20726": (38.833563, -76.877743),
    "20731": (38.833563, -76.877743),
    "20732": (38.565841, -76.526169),
    "20733": (38.921313, -76.532569),
    "20735": (38.739765, -76.912096),
    "20736": (38.548775, -76.562876),
    "20737": (38.963206, -76.917795),
    "20738": (38.833563, -76.877743),
    "20740": (38.979495, -76.895852),
    "20741": (38.833563, -76.877743),
    "20742": (38.833563, -76.877743),
    "20743": (38.889711, -76.892544),
    "20744": (38.757114, -76.977596),
    "20745": (38.814362, -76.957746),
    "20746": (38.834912, -76.912745),
    "20747": (38.851262, -76.885744),
    "20748": (38.817263, -76.935795),
    "20749": (38.833563, -76.877743),
    "20750": (38.833563, -76.877743),
    "20751": (38.960712, -76.621708),
    "20752": (38.833563, -76.877743),
    "20753": (38.833563, -76.877743),
    "20754": (38.604072, -76.604364),
    "20755": (39.154307, -76.69119),
    "20757": (38.833563, -76.877743),
    "20758": (38.736079, -76.583547),
    "20759": (39.160806, -76.927881),
    "20762": (38.806207, -76.875551),
    "20763": (39.136189, -76.815044),
    "20764": (38.965727, -76.589086),
    "20765": (38.974512, -76.545083),
    "20768": (38.833563, -76.877743),
    "20769": (38.98346, -76.811392),
    "20770": (38.995909, -76.880966),
    "20771": (38.833563, -76.877743),
    "20772": (38.816171, -76.786093),
    "20773": (38.833563, -76.877743),
    "20774": (38.868212, -76.815591),
    "20775": (38.833563, -76.877743),
    "20776": (38.962992, -76.564785),
    "20777": (39.173059, -76.966718),
    "20778": (39.002411, -76.563885),
    "20779": (38.942878, -76.558783),
    "20781": (38.94161, -76.937446),
    "20782": (38.912211, -76.967247),
    "20783": (39.000509, -76.972297),
    "20784": (38.95131, -76.895795),
    "20785": (38.922261, -76.875494),
    "20787": (38.98707, -76.982405),
    "20788": (38.969434, -76.950913),
    "20790": (38.833563, -76.877743),
    "20791": (38.833563, -76.877743),
    "20794": (39.155266, -76.813394),
    "20797": (38.833563, -76.877743),
    "20799": (38.833563, -76.877743),
    "20812": (38.96851, -77.140801),
    "20813": (39.143979, -77.207617),
    "20814": (39.00452, -77.1046),
    "20815": (38.983759, -77.079449),
    "20816": (38.955907, -77.1165),
    "20817": (38.989586, -77.153801),
    "20818": (39.128407, -77.180053),
    "20824": (39.143979, -77.207617),
    "20825": (39.143979, -77.207617),
    "20827": (39.143979, -77.207617),
    "20830": (39.15522, -77.066745),
    "20832": (39.150364, -77.077651),
    "20833": (39.204341, -77.05055),
    "20837": (39.123705, -77.403211),
    "20838": (39.228424, -77.37097),
    "20839": (39.17877, -77.419605),
    "20841": (39.184675, -77.328764),
    "20842": (39.191093, -77.421929),
    "20847": (39.143979, -77.207617),
    "20848": (39.143979, -77.207617),
    "20849": (39.143979, -77.207617),
    "20850": (39.089557, -77.184127),
    "20851": (39.077858, -77.125751),
    "20852": (39.052158, -77.121096),
    "20853": (39.107357, -77.0996),
    "20854": (39.029839, -77.234792),
    "20855": (39.142857, -77.138145),
    "20857": (39.143979, -77.207617),
    "20859": (39.143979, -77.207617),
    "20860": (39.142424, -77.044614),
    "20861": (39.151468, -76.994498),
    "20862": (39.175506, -77.020626),
    "20866": (39.105644, -76.935861),
    "20868": (39.122262, -76.972157),
    "20871": (39.207775, -77.259816),
    "20872": (39.285477, -77.215203),
    "20874": (39.135512, -77.282223),
    "20875": (39.143979, -77.207617),
    "20876": (39.210218, -77.239729),
    "20877": (39.139336, -77.182953),
    "20878": (39.091857, -77.198452),
    "20879": (39.173, -77.185542),
    "20880": (39.138815, -77.172591),
    "20882": (39.233512, -77.145781),
    "20884": (39.143979, -77.207617),
    "20885": (39.187421, -77.202798),
    "20886": (39.175703, -77.18725),
    "20889": (39.143979, -77.207617),
    "20891": (39.143979, -77.207617),
    "20892": (39.002375, -77.10341),
    "20894": (39.143979, -77.207617),
    "20895": (39.09538, -77.111555),
    "20896": (39.036496, -77.0931),
    "20897": (39.143979, -77.207617),
    "20898": (39.143979, -77.207617),
    "20899": (39.140324, -77.221984),
    "20901": (39.036289, -77.010948),
    "20902": (39.039974, -77.044449),
    "20903": (39.015209, -76.980597),
    "20904": (39.066844, -76.996866),
    "20905": (39.114753, -77.00587),
    "20906": (39.083978, -77.061278),
    "20907": (39.143979, -77.207617),
    "20908": (39.143979, -77.207617),
    "20910": (39.003109, -77.029648),
    "20911": (39.143979, -77.207617),
    "20912": (38.98236, -77.005798),
    "20913": (38.833563, -76.877743),
    "20914": (39.143979, -77.207617),
    "20915": (39.143979, -77.207617),
    "20916": (39.143979, -77.207617),
    "20918": (39.143979, -77.207617),
    "20997": (39.143979, -77.207617),
    "21001": (39.499909, -76.231177),
    "21005": (39.477062, -76.120824),
    "21009": (39.472579, -76.277279),
    "21010": (39.380158, -76.295468),
    "21012": (39.031461, -76.623203),
    "21013": (39.496406, -76.486624),
    "21014": (39.547557, -76.321984),
    "21015": (39.551757, -76.298713),
    "21017": (39.47366, -76.238835),
    "21018": (39.509276, -76.385083),
    "21020": (39.521276, -76.804699),
    "21022": (39.397861, -76.671742),
    "21023": (39.532955, -76.743196),
    "21027": (39.438964, -76.592139),
    "21028": (39.563172, -76.236427),
    "21029": (39.212456, -76.951498),
    "21030": (39.491227, -76.664077),
    "21031": (39.480493, -76.655257),
    "21032": (39.01811, -76.588272),
    "21034": (39.646205, -76.226377),
    "21035": (39.04296, -76.62863),
    "21036": (39.240155, -77.00375),
    "21037": (38.975128, -76.623684),
    "21040": (39.434799, -76.293579),
    "21041": (39.236405, -76.941902),
    "21042": (39.261897, -76.897247),
    "21043": (39.254833, -76.800124),
    "21044": (39.206132, -76.887905),
    "21045": (39.207806, -76.825475),
    "21046": (39.175406, -76.834945),
    "21047": (39.531206, -76.439035),
    "21048": (39.499102, -76.910108),
    "21050": (39.587155, -76.392733),
    "21051": (39.47314, -76.448385),
    "21052": (39.206998, -76.445599),
    "21053": (39.687103, -76.717644),
    "21054": (39.048359, -76.631238),
    "21055": (39.438964, -76.592139),
    "21056": (39.086064, -76.545474),
    "21057": (39.451006, -76.501186),
    "21060": (39.170158, -76.579836),
    "21061": (38.967943, -76.615637),
    "21062": (38.974203, -76.594942),
    "21071": (39.515748, -76.766097),
    "21074": (39.614552, -76.864427),
    "21075": (39.205756, -76.753093),
    "21076": (39.057694, -76.615557),
    "21077": (38.947102, -76.629277),
    "21078": (39.560095, -76.15517),
    "21080": (39.534703, -77.049302),
    "21082": (39.481685, -76.471736),
    "21084": (39.552706, -76.419734),
    "21085": (39.449157, -76.351881),
    "21087": (39.445257, -76.421783),
    "21088": (39.534703, -77.049302),
    "21090": (39.068309, -76.631743),
    "21092": (39.438964, -76.592139),
    "21093": (39.433206, -76.654593),
    "21094": (39.438964, -76.592139),
    "21098": (38.974203, -76.594942),
    "21102": (39.556164, -76.870849),
    "21104": (39.378104, -76.916267),
    "21105": (39.711379, -76.659492),
    "21106": (38.971475, -76.580934),
    "21108": (38.986961, -76.582479),
    "21111": (39.566189, -76.597891),
    "21113": (38.975412, -76.586886),
    "21114": (39.06436, -76.622577),
    "21117": (39.429055, -76.787696),
    "21120": (39.642203, -76.673693),
    "21122": (38.976813, -76.616185),
    "21123": (38.974203, -76.594942),
    "21128": (39.404757, -76.450084),
    "21130": (39.471559, -76.211676),
    "21131": (39.483255, -76.577619),
    "21132": (39.692854, -76.421834),
    "21133": (39.377871999999996, -76.816675),
    "21136": (39.487615, -76.796347),
    "21139": (39.438964, -76.592139),
    "21140": (39.031943, -76.625199),
    "21144": (38.983971, -76.623121),
    "21146": (38.951199, -76.603722),
    "21150": (39.236405, -76.941902),
    "21152": (39.526441, -76.715587),
    "21153": (39.412905, -76.730345),
    "21154": (39.657355, -76.371332),
    "21155": (39.567574, -76.797213),
    "21156": (39.461038, -76.583163),
    "21157": (39.564201, -76.980701),
    "21158": (39.606981, -77.029403),
    "21160": (39.703155, -76.330641),
    "21161": (39.658104, -76.527937),
    "21162": (39.389457, -76.411976),
    "21163": (39.349834, -76.845587),
    "21201": (39.296536, -76.623489),
    "21202": (39.295907, -76.608438),
    "21203": (39.284707, -76.620489),
    "21204": (39.407156, -76.60379),
    "21205": (39.302757, -76.567987),
    "21206": (39.336857, -76.553237),
    "21207": (39.325605, -76.736594),
    "21208": (39.385156, -76.727036),
    "21209": (39.354256, -76.667892),
    "21210": (39.352356, -76.63329),
    "21211": (39.327889, -76.63899),
    "21212": (39.356206, -76.610989),
    "21213": (39.306606, -76.603338),
    "21214": (39.350006, -76.562187),
    "21215": (39.343306, -76.681192),
    "21216": (39.310756, -76.674792),
    "21217": (39.308606, -76.63749),
    "21218": (39.328456, -76.599139),
    "21219": (39.229611, -76.445532),
    "21220": (39.344057, -76.505086),
    "21221": (39.296007, -76.559787),
    "21222": (39.325991, -76.451733),
    "21223": (39.279506, -76.65014),
    "21224": (39.279207, -76.557237),
    "21225": (39.018973, -76.616437),
    "21226": (39.06871, -76.584137),
    "21227": (39.241606, -76.677291),
    "21228": (39.274156, -76.631074),
    "21229": (39.286613, -76.65284),
    "21230": (39.264548, -76.622439),
    "21231": (39.288757, -76.592238),
    "21233": (39.284707, -76.620489),
    "21234": (39.413106, -76.530044),
    "21235": (39.284707, -76.620489),
    "21236": (39.392107, -76.489277),
    "21237": (39.339957, -76.488035),
    "21239": (39.356356, -76.587588),
    "21240": (39.142793, -76.651589),
    "21241": (39.284707, -76.620489),
    "21244": (39.333105, -76.784896),
    "21250": (39.258226, -76.713149),
    "21251": (39.438964, -76.592139),
    "21252": (39.388799, -76.613325),
    "21263": (39.284707, -76.620489),
    "21264": (39.284707, -76.620489),
    "21265": (39.284707, -76.620489),
    "21268": (39.284707, -76.620489),
    "21270": (39.284707, -76.620489),
    "21273": (39.284707, -76.620489),
    "21274": (39.284707, -76.620489),
    "21275": (39.284707, -76.620489),
    "21278": (39.284707, -76.620489),
    "21279": (39.284707, -76.620489),
    "21280": (39.284707, -76.620489),
    "21281": (39.284707, -76.620489),
    "21282": (39.438964, -76.592139),
    "21283": (39.284707, -76.620489),
    "21284": (39.438964, -76.592139),
    "21285": (39.438964, -76.592139),
    "21286": (39.414306, -76.576089),
    "21287": (39.297457, -76.592738),
    "21288": (39.284707, -76.620489),
    "21289": (39.284707, -76.620489),
    "21290": (39.293256, -76.623839),
    "21297": (39.284707, -76.620489),
    "21298": (39.284707, -76.620489),
    "21401": (38.967311, -76.610143),
    "21402": (39.04811, -76.452032),
    "21403": (39.007361, -76.584637),
    "21404": (38.974203, -76.594942),
    "21405": (38.992124, -76.506883),
    "21411": (38.974203, -76.594942),
    "21412": (38.974203, -76.594942),
    "21501": (39.580691, -78.690593),
    "21502": (39.59915, -78.844425),
    "21503": (39.580691, -78.690593),
    "21504": (39.580691, -78.690593),
    "21505": (39.594043, -78.843432),
    "21520": (39.58935, -79.230969),
    "21521": (39.536798, -79.009008),
    "21522": (39.601664, -79.233691),
    "21523": (39.486109, -79.08297),
    "21524": (39.69668, -78.803067),
    "21528": (39.652837, -78.901395),
    "21529": (39.708261, -78.777446),
    "21530": (39.679418, -78.524164),
    "21531": (39.637098, -79.257117),
    "21532": (39.64206, -78.912502),
    "21536": (39.655141, -79.124143),
    "21538": (39.416917, -79.222202),
    "21539": (39.571706, -78.934521),
    "21540": (39.475381, -79.058451),
    "21541": (39.565589, -79.382332),
    "21542": (39.595113, -78.943082),
    "21543": (39.633866, -78.960403),
    "21545": (39.695649, -78.872465),
    "21550": (39.43392, -79.316683),
    "21555": (39.596645, -78.572564),
    "21556": (39.572452, -78.843962),
    "21557": (39.50582, -78.921162),
    "21560": (39.601008, -78.687137),
    "21561": (39.538568, -79.190791),
    "21562": (39.490547, -79.013989),
    "21601": (38.800714, -76.051486),
    "21606": (38.758525, -76.180166),
    "21607": (39.073391, -76.060665),
    "21609": (38.740562, -75.958683),
    "21610": (39.366812, -76.067079),
    "21612": (38.74955, -76.273704),
    "21613": (38.479813, -76.079864),
    "21617": (39.084003, -76.091375),
    "21619": (38.946034, -76.279172),
    "21620": (39.235988, -76.059316),
    "21622": (38.415211, -76.191021),
    "21623": (39.1305, -75.961404),
    "21624": (38.836766, -76.27137),
    "21625": (38.869275, -76.000119),
    "21626": (38.323604, -76.097337),
    "21627": (38.242608, -76.053064),
    "21628": (39.231771, -75.929797),
    "21629": (38.859523, -75.835702),
    "21631": (38.579447, -75.939691),
    "21632": (38.823318, -75.825197),
    "21634": (38.29868, -76.203532),
    "21635": (39.320381, -75.836031),
    "21636": (39.022245, -75.809462),
    "21638": (39.019049, -76.115897),
    "21639": (38.968592, -75.790732),
    "21640": (39.081351, -75.811781),
    "21641": (38.920588, -75.93877),
    "21643": (38.643824, -75.863003),
    "21644": (39.118226, -75.876881),
    "21645": (39.313679, -75.96152),
    "21647": (38.808497, -76.287709),
    "21648": (38.478205, -76.241202),
    "21649": (39.106088, -75.79087),
    "21650": (39.308228, -75.812769),
    "21651": (39.274314, -75.895115),
    "21652": (38.795102, -76.152762),
    "21653": (38.751834, -76.178041),
    "21654": (38.710783, -76.125184),
    "21655": (38.752146, -75.90765),
    "21656": (39.034637, -76.092127),
    "21657": (38.975882, -75.975322),
    "21658": (39.00255, -76.142374),
    "21659": (38.561727, -75.80465),
    "21660": (38.874255, -75.866707),
    "21661": (39.117823, -76.223193),
    "21662": (38.713532, -76.196838),
    "21663": (38.748765, -76.167765),
    "21664": (38.600971, -75.947375),
    "21665": (38.745387, -76.326606),
    "21666": (39.012075, -76.11568),
    "21667": (39.339906, -76.047396),
    "21668": (39.119123, -76.031257),
    "21669": (38.453204, -76.2641),
    "21670": (38.88927, -75.861191),
    "21671": (38.704729, -76.332647),
    "21672": (38.274149, -76.072171),
    "21673": (38.664452, -76.058006),
    "21675": (38.307394, -76.106344),
    "21676": (38.784568, -76.300134),
    "21677": (38.49965, -76.202456),
    "21678": (39.308842, -76.08165),
    "21679": (38.91506, -76.073905),
    "21681": (38.88927, -75.861191),
    "21682": (38.88927, -75.861191),
    "21683": (38.88927, -75.861191),
    "21684": (38.88927, -75.861191),
    "21685": (38.88927, -75.861191),
    "21686": (38.88927, -75.861191),
    "21687": (38.88927, -75.861191),
    "21688": (38.88927, -75.861191),
    "21690": (39.034637, -76.092127),
    "21701": (39.512748, -77.369299),
    "21702": (39.492596, -77.461211),
    "21703": (39.364713, -77.463561),
    "21704": (39.345477, -77.383229),
    "21705": (39.469961, -77.392139),
    "21709": (39.469961, -77.392139),
    "21710": (39.291049, -77.455243),
    "21711": (39.666266, -77.954912),
    "21713": (39.551986, -77.695721),
    "21714": (39.4203, -77.505098),
    "21715": (39.386893, -77.658015),
    "21716": (39.317945, -77.624701),
    "21717": (39.330887, -77.427405),
    "21718": (39.400868, -77.627954),
    "21719": (39.695751, -77.495542),
    "21720": (39.647296, -77.584162),
    "21721": (39.642537, -77.637152),
    "21722": (39.665751, -77.906389),
    "21723": (39.328104, -77.0142),
    "21727": (39.675397, -77.336732),
    "21733": (39.559419, -77.76039),
    "21734": (39.60596, -77.707207),
    "21736": (39.520696, -77.916196),
    "21737": (39.259656, -77.012699),
    "21738": (39.281504, -77.025362),
    "21740": (39.58887, -77.700213),
    "21741": (39.693944, -77.742116),
    "21742": (39.642995, -77.652779),
    "21746": (39.563787, -77.720642),
    "21747": (39.520696, -77.916196),
    "21748": (39.520696, -77.916196),
    "21749": (39.520696, -77.916196),
    "21750": (39.58895, -78.050204),
    "21754": (39.339477, -77.310622),
    "21755": (39.353688, -77.567142),
    "21756": (39.458488, -77.693341),
    "21757": (39.619399, -77.252657),
    "21758": (39.34924, -77.620514),
    "21759": (39.569426, -77.290519),
    "21762": (39.482208, -77.246761),
    "21764": (39.534703, -77.049302),
    "21765": (39.337804, -77.071952),
    "21766": (39.641946, -78.408891),
    "21767": (39.696761, -77.746766),
    "21769": (39.53503, -77.485034),
    "21770": (39.351552, -77.265818),
    "21771": (39.407252, -77.214087),
    "21773": (39.550036, -77.556275),
    "21774": (39.432571, -77.220932),
    "21775": (39.564472, -77.29468),
    "21776": (39.521886, -77.093303),
    "21777": (39.27777, -77.532068),
    "21778": (39.618999, -77.335442),
    "21779": (39.430227, -77.66013),
    "21780": (39.667035, -77.481888),
    "21781": (39.56991, -77.760697),
    "21782": (39.438718, -77.771667),
    "21783": (39.591355, -77.614762),
    "21784": (39.45672, -76.969601),
    "21787": (39.657449, -77.169055),
    "21788": (39.610876, -77.398931),
    "21790": (39.265086, -77.496646),
    "21791": (39.57985, -77.131896),
    "21792": (39.469961, -77.392139),
    "21793": (39.491247, -77.343542),
    "21794": (39.296204, -76.98115),
    "21795": (39.589123, -77.826258),
    "21797": (39.402352, -77.081821),
    "21798": (39.542724, -77.292314),
    "21801": (38.382445, -75.633621),
    "21802": (38.388434, -75.6276),
    "21803": (38.388434, -75.6276),
    "21804": (38.350793, -75.533782),
    "21810": (38.388434, -75.6276),
    "21811": (38.310447, -75.320901),
    "21813": (38.421121, -75.19596),
    "21814": (38.388434, -75.6276),
    "21817": (37.998308, -75.818797),
    "21821": (38.166101, -75.92329),
    "21822": (38.216972, -75.55053),
    "21824": (37.983912, -76.035623),
    "21826": (38.320318, -75.620806),
    "21829": (38.102963, -75.381853),
    "21830": (38.409235, -75.724848),
    "21835": (38.532301, -75.949958),
    "21836": (38.073294, -75.734412),
    "21837": (38.458249, -75.754804),
    "21838": (38.018983, -75.728768),
    "21840": (38.388434, -75.6276),
    "21841": (38.246348, -75.301838),
    "21842": (38.381107, -75.113816),
    "21843": (38.22309, -75.324057),
    "21849": (38.376894, -75.462009),
    "21850": (38.394572, -75.410499),
    "21851": (38.089201, -75.537185),
    "21852": (38.388434, -75.6276),
    "21853": (38.200553, -75.75292),
    "21856": (38.305282, -75.763118),
    "21857": (38.092718, -75.888207),
    "21861": (38.538904, -75.719182),
    "21862": (38.400306, -75.216551),
    "21863": (38.217824, -75.326618),
    "21864": (38.042932, -75.411789),
    "21865": (38.268914, -75.790882),
    "21866": (37.966573, -76.023482),
    "21867": (38.10049, -75.822318),
    "21869": (38.430928, -75.897058),
    "21870": (38.092718, -75.888207),
    "21871": (38.094181, -75.717406),
    "21872": (38.412085, -75.281074),
    "21874": (38.40406, -75.351349),
    "21875": (38.452527, -75.574165),
    "21890": (38.092718, -75.888207),
    "21901": (39.535078, -75.894051),
    "21902": (39.552962, -76.072471),
    "21903": (39.571449, -76.033281),
    "21904": (39.615086, -76.063342),
    "21911": (39.671572, -76.056651),
    "21912": (39.533058, -75.915203),
    "21913": (39.410355, -75.863287),
    "21914": (39.574387, -75.978564),
    "21915": (39.469098, -75.849327),
    "21916": (39.541512, -75.999972),
    "21917": (39.537261, -76.003452),
    "21918": (39.543894, -76.049157),
    "21919": (39.470309, -75.927952),
    "21920": (39.658031, -75.828196),
    "21921": (39.56186, -75.87574),
    "21922": (39.593612, -75.947332),
    "21930": (39.366183, -75.884544),
    "22002": (38.691448, -78.137019),
    "22003": (38.835762, -77.212794),
    "22009": (38.831813, -77.288755),
    "22015": (38.785864, -77.286156),
    "22026": (38.584734, -77.349935),
    "22027": (38.895078, -77.221453),
    "22030": (38.853231, -77.305097),
    "22031": (38.853962, -77.284195),
    "22032": (38.819712, -77.287105),
    "22033": (38.879466, -77.378858),
    "22034": (38.831813, -77.288755),
    "22035": (38.855715000000004, -77.361633),
    "22036": (38.735114, -77.07965),
    "22037": (38.831813, -77.288755),
    "22038": (38.852849, -77.30199),
    "22039": (38.759329, -77.311588),
    "22040": (38.884177, -77.171752),
    "22041": (38.850212, -77.144801),
    "22042": (38.863452, -77.193915),
    "22043": (38.899361, -77.189502),
    "22044": (38.858853, -77.154761),
    "22046": (38.884936, -77.174052),
    "22047": (38.831813, -77.288755),
    "22060": (38.714562, -77.167886),
    "22066": (39.001609, -77.306416),
    "22067": (38.96451, -77.233103),
    "22079": (38.692865, -77.204031),
    "22081": (38.873861, -77.234454),
    "22082": (38.831813, -77.288755),
    "22092": (38.831813, -77.288755),
    "22093": (39.085309, -77.645224),
    "22095": (38.831813, -77.288755),
    "22096": (38.831813, -77.288755),
    "22101": (38.935202, -77.18672),
    "22102": (38.953033, -77.229496),
    "22103": (38.831813, -77.288755),
    "22106": (38.831813, -77.288755),
    "22109": (38.920165, -77.229043),
    "22116": (38.871469, -77.234428),
    "22118": (38.831813, -77.288755),
    "22119": (38.831813, -77.288755),
    "22120": (38.831813, -77.288755),
    "22121": (38.830912, -77.432252),
    "22122": (38.831813, -77.288755),
    "22124": (38.892796, -77.329906),
    "22125": (38.681615, -77.26052),
    "22134": (38.52602, -77.322803),
    "22135": (38.721912, -77.466897),
    "22150": (38.763463, -77.186063),
    "22151": (38.802858, -77.211556),
    "22152": (38.775687, -77.233746),
    "22153": (38.757015, -77.181612),
    "22156": (38.831813, -77.288755),
    "22158": (38.831813, -77.288755),
    "22159": (38.831813, -77.288755),
    "22160": (38.831813, -77.288755),
    "22161": (38.807462, -77.219354),
    "22172": (38.581369, -77.367205),
    "22180": (38.897361, -77.253749),
    "22181": (38.90521, -77.295256),
    "22182": (38.935292, -77.268022),
    "22183": (38.831813, -77.288755),
    "22184": (38.831813, -77.288755),
    "22185": (38.831813, -77.288755),
    "22191": (38.625541, -77.271644),
    "22192": (38.675952, -77.316344),
    "22193": (38.643765, -77.345106),
    "22194": (38.721912, -77.466897),
    "22195": (38.721912, -77.466897),
    "22199": (38.831813, -77.288755),
    "22201": (38.885484, -77.099113),
    "22202": (38.854462, -77.059721),
    "22203": (38.874775, -77.119515),
    "22204": (38.860335, -77.100868),
    "22205": (38.875811, -77.140021),
    "22206": (38.840403, -77.0888),
    "22207": (38.907416, -77.122344),
    "22209": (38.893596, -77.110376),
    "22210": (38.880811, -77.11295),
    "22211": (38.878674, -77.077426),
    "22212": (38.880811, -77.11295),
    "22213": (38.894898, -77.162829),
    "22214": (38.880811, -77.11295),
    "22215": (38.880811, -77.11295),
    "22216": (38.880811, -77.11295),
    "22217": (38.880811, -77.11295),
    "22218": (38.880811, -77.11295),
    "22219": (38.880811, -77.11295),
    "22222": (38.861462, -77.053599),
    "22223": (38.880811, -77.11295),
    "22225": (38.880811, -77.11295),
    "22226": (38.883358, -77.10281),
    "22227": (38.880811, -77.11295),
    "22229": (38.880811, -77.11295),
    "22230": (38.87972, -77.110817),
    "22234": (38.880811, -77.11295),
    "22240": (38.856623, -77.051788),
    "22241": (38.880811, -77.11295),
    "22242": (38.850879, -77.052336),
    "22243": (38.86045, -77.051569),
    "22244": (38.854522, -77.052035),
    "22245": (38.851773, -77.052296),
    "22246": (38.880811, -77.11295),
    "22301": (38.823062, -77.079622),
    "22302": (38.827627, -77.089566),
    "22303": (38.791231, -77.08135),
    "22304": (38.81522, -77.10993),
    "22305": (38.835412, -77.063959),
    "22306": (38.758914, -77.087344),
    "22307": (38.771363, -77.065699),
    "22308": (38.731564, -77.060399),
    "22309": (38.722264, -77.171945),
    "22310": (38.779391, -77.119401),
    "22311": (38.832762, -77.119627),
    "22312": (38.799956, -77.150177),
    "22313": (38.815762, -77.09005),
    "22314": (38.811436, -77.063587),
    "22315": (38.759553, -77.148518),
    "22320": (38.804413, -77.046699),
    "22321": (38.831813, -77.288755),
    "22331": (38.801342, -77.070733),
    "22332": (38.803142, -77.072679),
    "22333": (38.815762, -77.09005),
    "22334": (38.815762, -77.09005),
    "22336": (38.815762, -77.09005),
    "22401": (38.295135, -77.483689),
    "22402": (38.299613, -77.489666),
    "22403": (38.417273, -77.460814),
    "22404": (38.298305, -77.489913),
    "22405": (38.336458, -77.436618),
    "22406": (38.414357, -77.534708),
    "22407": (38.271969, -77.606772),
    "22408": (38.233933, -77.56277299999999),
    "22412": (38.184716, -77.662559),
    "22427": (38.008401, -77.260353),
    "22428": (38.014536, -77.355902),
    "22430": (38.385704, -77.374292),
    "22432": (37.837435, -76.345493),
    "22433": (38.344608, -77.871855),
    "22435": (37.961716, -76.577422),
    "22436": (38.024704, -77.037147),
    "22437": (37.818619, -76.786335),
    "22438": (38.056246, -77.018147),
    "22442": (38.121793, -76.79025),
    "22443": (38.184926, -76.823742),
    "22446": (38.171755, -77.408163),
    "22448": (38.326218, -77.039825),
    "22451": (38.271077, -77.17261),
    "22454": (37.852669, -76.847543),
    "22456": (37.852316, -76.40511),
    "22460": (37.879796999999996, -76.598782),
    "22463": (38.468432, -77.461213),
    "22469": (38.059488, -76.676452),
    "22471": (38.39933, -77.581351),
    "22472": (37.950511, -76.636722),
    "22473": (37.876733, -76.427334),
    "22476": (38.032905, -77.06328),
    "22480": (37.667319, -76.404996),
    "22481": (38.271077, -77.17261),
    "22482": (37.715738, -76.450212),
    "22485": (38.277209, -77.17225),
    "22488": (38.102075, -76.743458),
    "22501": (38.015899, -77.559298),
    "22503": (37.739451, -76.50021),
    "22504": (37.76914, -76.712135),
    "22507": (37.757226, -76.511804),
    "22508": (38.308398, -77.796156),
    "22509": (38.078932, -77.04851),
    "22511": (37.985615, -76.499878),
    "22513": (37.750261, -76.509615),
    "22514": (37.980787, -77.242558),
    "22517": (37.750280000000004, -76.578109),
    "22520": (38.111955, -76.82434),
    "22523": (37.792761, -76.60933),
    "22524": (38.118186, -76.680504),
    "22526": (38.271077, -77.17261),
    "22528": (37.713175, -76.409946),
    "22529": (38.018054, -76.68611),
    "22530": (37.90938, -76.293436),
    "22534": (38.08462, -77.666948),
    "22535": (38.157349, -77.180478),
    "22538": (38.207873, -77.2502),
    "22539": (37.855567, -76.312376),
    "22542": (38.292189, -77.897386),
    "22544": (38.271077, -77.17261),
    "22545": (38.508611, -77.542957),
    "22546": (37.948572, -77.437767),
    "22547": (38.271077, -77.17261),
    "22548": (37.837583, -76.69477499999999),
    "22552": (38.009438, -77.225139),
    "22553": (38.182869, -77.69932),
    "22554": (38.438958, -77.4354),
    "22555": (38.417273, -77.460814),
    "22558": (38.121793, -76.79025),
    "22560": (37.916613, -76.947547),
    "22565": (38.137216, -77.518865),
    "22567": (38.242901, -77.917753),
    "22570": (37.947224, -76.615358),
    "22572": (37.96954, -76.766517),
    "22576": (37.688877, -76.431553),
    "22577": (38.067325, -76.550274),
    "22578": (37.688601, -76.361585),
    "22579": (37.802527, -76.363603),
    "22580": (38.130103, -77.417234),
    "22581": (38.121793, -76.79025),
    "22601": (39.169668, -78.16856),
    "22602": (39.150074, -78.268988),
    "22603": (39.263975, -78.198932),
    "22604": (39.167603, -78.168643),
    "22610": (38.818692, -78.275719),
    "22611": (39.135711, -77.991926),
    "22620": (39.048614, -78.060132),
    "22622": (39.2543, -78.066373),
    "22623": (38.853733, -78.141239),
    "22624": (39.271865, -78.099763),
    "22625": (39.296066, -78.310539),
    "22626": (38.983383, -78.403766),
    "22627": (38.787434, -78.083739),
    "22630": (38.928308, -78.174537),
    "22637": (39.253982, -78.352754),
    "22638": (39.236944, -78.288465),
    "22639": (38.830067, -78.022322),
    "22640": (38.812892, -78.116528),
    "22641": (39.056218, -78.37477),
    "22642": (38.932418, -78.065023),
    "22643": (38.895454, -78.004435),
    "22644": (38.963523, -78.548229),
    "22645": (39.048863, -78.285171),
    "22646": (39.121941, -77.990069),
    "22649": (39.004774, -78.247806),
    "22650": (38.763022, -78.387191),
    "22652": (38.840715, -78.427584),
    "22654": (39.078491, -78.443076),
    "22655": (39.163418, -78.246159),
    "22656": (39.213701, -78.090144),
    "22657": (39.020716, -78.41733),
    "22660": (38.94761, -78.433111),
    "22663": (39.121941, -77.990069),
    "22664": (38.918791, -78.512429),
    "22701": (38.511694, -77.9928),
    "22709": (38.428509, -78.267848),
    "22711": (38.428509, -78.267848),
    "22712": (38.545289, -77.756064),
    "22713": (38.537138, -78.132778),
    "22714": (38.511323, -77.901265),
    "22715": (38.418207, -78.189878),
    "22716": (38.624123, -78.102389),
    "22718": (38.457473, -77.804343),
    "22719": (38.428509, -78.267848),
    "22720": (38.472457, -77.642308),
    "22721": (38.428509, -78.267848),
    "22722": (38.428509, -78.267848),
    "22723": (38.396709, -78.432237),
    "22724": (38.622436, -77.907403),
    "22725": (38.428509, -78.267848),
    "22726": (38.404605, -77.770885),
    "22727": (38.369952, -78.297605),
    "22728": (38.602592, -77.681065),
    "22729": (38.368552, -78.011837),
    "22730": (38.428509, -78.267848),
    "22731": (38.428509, -78.267848),
    "22732": (38.428509, -78.267848),
    "22733": (38.359195, -78.060292),
    "22734": (38.530877, -77.803719),
    "22735": (38.486703, -78.150059),
    "22736": (38.389874, -77.711884),
    "22737": (38.588388, -78.002489),
    "57037": (43.068331, -97.130498),
    "22738": (38.3215, -78.304169),
    "22739": (38.505945, -77.59557),
    "22740": (38.612785, -78.227578),
    "22741": (38.434991, -77.860642),
    "22742": (38.462651, -77.706223),
    "22743": (38.495692, -78.331826),
    "22746": (38.647841, -78.029974),
    "22747": (38.705616, -78.174894),
    "22748": (38.372652, -78.380509),
    "22749": (38.620549, -78.191528),
    "22801": (38.422776999999996, -78.877137),
    "22802": (38.490526, -78.817876),
    "22807": (38.440898, -78.874173),
    "22810": (38.808869, -78.777598),
    "22811": (38.781688, -78.948643),
    "22812": (38.345632, -78.854597),
    "22815": (38.619698, -78.815219),
    "22820": (38.749089, -79.000426),
    "22821": (38.417919, -79.044186),
    "22824": (38.818191, -78.637768),
    "22827": (38.4009, -78.729679),
    "22830": (38.640083, -78.940553),
    "22831": (38.534126, -78.999618),
    "22832": (38.465855, -78.749875),
    "22833": (38.528361, -78.855172),
    "22834": (38.550848, -78.876177),
    "22835": (38.645981, -78.481288),
    "22840": (38.400968, -78.734456),
    "22841": (38.347167, -78.838654),
    "22842": (38.785693, -78.680304),
    "22843": (38.325455, -79.094228),
    "22844": (38.673777, -78.677685),
    "22845": (38.799978, -78.81029),
    "22846": (38.375012, -78.77954),
    "22847": (38.761208, -78.712058),
    "22848": (38.384681, -78.891422),
    "22849": (38.525239, -78.607184),
    "22850": (38.55743, -78.922657),
    "22851": (38.559864, -78.512018),
    "22853": (38.63976, -78.781566),
    "22901": (38.093604, -78.561139),
    "22902": (38.026588, -78.48045),
    "22903": (38.033938, -78.492384),
    "22904": (38.040101, -78.485066),
    "22905": (38.040101, -78.485066),
    "22906": (38.040101, -78.485066),
    "22907": (38.040101, -78.485066),
    "22908": (38.040101, -78.485066),
    "22909": (38.024474, -78.448214),
    "22910": (38.040101, -78.485066),
    "22911": (38.099507, -78.408498),
    "22920": (37.972758, -78.82231),
    "22922": (37.690183, -78.947944),
    "22923": (38.209534, -78.309759),
    "22924": (38.001317, -78.727146),
    "22931": (37.893092, -78.709897),
    "22932": (38.129592, -78.710635),
    "22935": (38.270529, -78.557765),
    "22936": (38.166565, -78.506832),
    "22937": (37.82019, -78.609661),
    "22938": (37.859373, -78.816071),
    "22939": (38.096364, -78.99295),
    "22940": (38.194421, -78.584936),
    "22942": (38.175906, -78.181467),
    "22943": (38.078772, -78.521957),
    "22945": (38.065383, -78.595831),
    "22946": (37.850141, -78.541911),
    "22947": (38.053137, -78.339571),
    "22948": (38.428509, -78.267848),
    "22949": (37.753, -78.859153),
    "22952": (37.974432, -78.936098),
    "22953": (38.428509, -78.267848),
    "22954": (37.78907, -79.012459),
    "22957": (38.22702, -78.176806),
    "22958": (37.818439, -78.893139),
    "22959": (37.933631, -78.63511),
    "22960": (38.219183, -78.046093),
    "22963": (37.893119, -78.338579),
    "22964": (37.803604, -78.959134),
    "22965": (38.330132, -78.475018),
    "22967": (37.824173, -78.962522),
    "22968": (38.258615, -78.407377),
    "22969": (37.818031, -78.819906),
    "22971": (37.759956, -78.810459),
    "22972": (38.199692, -78.239378),
    "22973": (38.312057, -78.482014),
    "22974": (37.95591, -78.276599),
    "22976": (37.839132, -79.069321),
    "22980": (38.065794, -78.903445),
    "22987": (38.179859, -78.618912),
    "22989": (38.428509, -78.267848),
    "23001": (37.28822, -76.426013),
    "23002": (37.342768, -77.984092),
    "23003": (37.432335, -76.601616),
    "23004": (37.563225, -78.53643),
    "23005": (37.754912, -77.480128),
    "23009": (37.798833, -77.180912),
    "23011": (37.479524, -76.949981),
    "23014": (37.733844, -77.888082),
    "23015": (37.914736, -77.62341),
    "23017": (37.418242, -76.508402),
    "23018": (37.418242, -76.508402),
    "23021": (37.410286, -76.294103),
    "23022": (37.848408, -78.277393),
    "23023": (37.701823, -76.916248),
    "23024": (37.90754, -77.798047),
    "23025": (37.410286, -76.294103),
    "23027": (37.64794, -78.138859),
    "23030": (37.354115, -77.073103),
    "23031": (37.598391, -76.447551),
    "23032": (37.644319, -76.446001),
    "23035": (37.410286, -76.294103),
    "23038": (37.807863, -78.093506),
    "23039": (37.657031, -77.794731),
    "23040": (37.518167, -78.214232),
    "23043": (37.551856, -76.366544),
    "23045": (37.410286, -76.294103),
    "23047": (37.846874, -77.513156),
    "23050": (37.500094, -76.454046),
    "23054": (37.733844, -77.888082),
    "23055": (37.848408, -78.277393),
    "23056": (37.410286, -76.294103),
    "23058": (37.531296, -77.416103),
    "23059": (37.728404, -77.554393),
    "23060": (37.595064, -77.508719),
    "23061": (37.41259, -76.546416),
    "23062": (37.277726, -76.49988),
    "23063": (37.725416, -77.995),
    "23064": (37.410286, -76.294103),
    "23065": (37.798243, -77.937457),
    "23066": (37.410286, -76.294103),
    "23067": (37.825208, -77.989878),
    "23068": (37.410286, -76.294103),
    "23069": (37.735448, -77.337944),
    "23070": (37.55118, -76.384428),
    "23071": (37.541289, -76.4152),
    "23072": (37.391501, -76.514807),
    "23075": (37.545511, -77.317838),
    "23076": (37.410286, -76.294103),
    "23079": (37.644319, -76.446001),
    "23081": (37.223482, -76.783317),
    "23083": (37.322156, -78.121631),
    "23084": (37.848408, -78.277393),
    "23085": (37.701823, -76.916248),
    "23086": (37.677991, -77.028495),
    "23089": (37.465312, -76.909711),
    "23090": (37.235892, -76.445567),
    "23091": (37.617747, -76.771273),
    "23092": (37.582554, -76.498426),
    "23093": (37.998422, -77.967416),
    "23101": (37.553314, -77.892964),
    "23102": (37.694226, -77.796603),
    "23103": (37.663224, -77.791971),
    "23105": (37.345032, -77.944868),
    "23106": (37.733093, -77.206868),
    "23107": (37.28641, -76.404783),
    "23108": (37.701823, -76.916248),
    "23109": (37.410286, -76.294103),
    "23110": (37.613475, -76.810087),
    "23111": (37.628179, -77.281955),
    "23112": (37.454138, -77.66258),
    "23113": (37.494897, -77.663061),
    "23115": (37.836374, -76.913844),
    "23116": (37.669086, -77.329421),
    "23117": (37.937619, -77.868959),
    "23119": (37.410286, -76.294103),
    "23120": (37.416066, -77.779015),
    "23123": (37.563225, -78.53643),
    "23124": (37.535579, -77.005863),
    "23125": (37.343785, -76.287792),
    "23126": (37.701823, -76.916248),
    "23127": (37.310451, -76.746769),
    "23128": (37.410286, -76.294103),
    "23129": (37.701136, -77.790584),
    "23130": (37.410286, -76.294103),
    "23131": (37.312159, -76.518831),
    "23138": (37.355641, -76.292253),
    "23139": (37.541609, -77.928759),
    "23140": (37.453467, -77.033714),
    "23141": (37.518432, -77.134289),
    "23146": (37.739029, -77.708072),
    "23147": (37.37956, -77.034752),
    "23148": (37.753427, -77.047727),
    "23149": (37.644319, -76.446001),
    "23150": (37.501495, -77.271789),
    "23153": (37.779913, -77.940549),
    "23154": (37.418242, -76.508402),
    "23155": (37.418242, -76.508402),
    "23156": (37.544151, -76.684306),
    "23160": (37.733844, -77.888082),
    "23161": (37.701823, -76.916248),
    "23162": (37.772187, -77.45264),
    "23163": (37.350792, -76.316136),
    "23168": (37.394138, -76.835415),
    "23169": (37.644319, -76.446001),
    "23170": (37.940788, -77.996956),
    "23173": (37.524246, -77.493157),
    "23175": (37.635564, -76.591805),
    "23176": (37.644319, -76.446001),
    "23177": (37.701823, -76.916248),
    "23178": (37.400387, -76.452896),
    "23180": (37.725161, -76.613446),
    "23181": (37.607215, -76.891642),
    "23183": (37.363201, -76.532492),
    "23184": (37.322121, -76.53185),
    "23185": (37.273209, -76.732423),
    "23186": (37.310451, -76.746769),
    "23187": (37.310451, -76.746769),
    "23188": (37.34822, -76.773832),
    "23190": (37.482039, -76.636154),
    "23191": (37.418242, -76.508402),
    "23192": (37.820707, -77.651831),
    "23218": (37.524246, -77.493157),
    "23219": (37.541696, -77.439204),
    "23220": (37.552746, -77.456602),
    "23221": (37.553196, -77.489706),
    "23222": (37.568861, -77.428004),
    "23223": (37.533246, -77.431054),
    "23224": (37.497796, -77.46726),
    "23225": (37.519396, -77.500757),
    "23226": (37.587223, -77.518407),
    "23227": (37.6247, -77.435149),
    "23228": (37.624988, -77.49592),
    "23229": (37.595695, -77.570359),
    "23230": (37.592095, -77.495206),
    "23231": (37.457072, -77.307326),
    "23232": (37.520187, -77.408359),
    "23233": (37.615276, -77.576641),
    "23234": (37.43732, -77.478825),
    "23235": (37.494147, -77.556501),
    "23236": (37.466359, -77.590818),
    "23237": (37.400822, -77.471206),
    "23238": (37.733844, -77.888082),
    "23240": (37.524246, -77.493157),
    "23241": (37.524246, -77.493157),
    "23242": (37.531296, -77.416103),
    "23249": (37.524246, -77.493157),
    "23250": (37.507498, -77.332916),
    "23255": (37.531296, -77.416103),
    "23260": (37.524246, -77.493157),
    "23261": (37.524246, -77.493157),
    "23266": (37.567896, -77.528308),
    "23269": (37.524246, -77.493157),
    "23270": (37.524246, -77.493157),
    "23272": (37.524246, -77.493157),
    "23273": (37.524246, -77.493157),
    "23274": (37.524246, -77.493157),
    "23275": (37.524246, -77.493157),
    "23276": (37.524246, -77.493157),
    "23278": (37.524246, -77.493157),
    "23279": (37.524246, -77.493157),
    "23280": (37.637622, -77.46836),
    "23282": (37.524246, -77.493157),
    "23284": (37.549446, -77.451155),
    "23285": (37.524246, -77.493157),
    "23286": (37.524246, -77.493157),
    "23288": (37.531296, -77.416103),
    "23289": (37.531296, -77.416103),
    "23290": (37.524246, -77.493157),
    "23291": (37.524246, -77.493157),
    "23292": (37.524246, -77.493157),
    "23293": (37.524246, -77.493157),
    "23294": (37.628657, -77.542871),
    "23297": (37.389721, -77.561266),
    "23298": (37.540646, -77.431555),
    "23301": (37.712919, -75.661132),
    "23302": (37.865814, -75.527697),
    "23303": (37.896797, -75.52058099999999),
    "23304": (36.989766, -76.572291),
    "23306": (37.567852, -75.858617),
    "23307": (37.432247, -75.880425),
    "23308": (37.823569, -75.615138),
    "23310": (37.259125, -75.961975),
    "23313": (37.201937, -75.952409),
    "23314": (36.956505, -76.542783),
    "23315": (36.73282, -76.830545),
    "23316": (37.294283, -75.961858),
    "23320": (36.749991, -76.218759),
    "23321": (36.781942, -76.325762),
    "23322": (36.6434, -76.24201),
    "23323": (36.710949, -76.339913),
    "23324": (36.802097, -76.273934),
    "23325": (36.79202, -76.23856),
    "23326": (36.777015, -76.239417),
    "23327": (36.7085, -76.278531),
    "23328": (36.7085, -76.278531),
    "23336": (37.948723, -75.436285),
    "23337": (37.918556, -75.490518),
    "23341": (37.577292, -75.864607),
    "23345": (37.738248, -75.701449),
    "23347": (37.356057, -75.964939),
    "23350": (37.376126, -75.882344),
    "23354": (37.458837, -75.900724),
    "23356": (37.999789, -75.413184),
    "23357": (37.750487, -75.66704),
    "23358": (37.639252, -75.865009),
    "23359": (37.883709, -75.604063),
    "23389": (37.656158, -75.848807),
    "23395": (37.975567, -75.479748),
    "23396": (37.923682, -75.555142),
    "23397": (36.898915, -76.687745),
    "23398": (37.534336, -75.877052),
    "23399": (37.916218, -75.616754),
    "23401": (37.596576, -75.789256),
    "23404": (37.677193, -75.672604),
    "23405": (37.413281, -75.92133),
    "23407": (37.838898, -75.563439),
    "23408": (37.424497, -75.877143),
    "23409": (37.844421, -75.611577),
    "23410": (37.603823, -75.75782),
    "23412": (37.790415, -75.60347),
    "23413": (37.469454, -75.879019),
    "23414": (37.816896, -75.583227),
    "23415": (37.92807, -75.526526),
    "23416": (37.922866, -75.538591),
    "23417": (37.693197, -75.746),
    "23418": (37.796421, -75.650275),
    "23419": (37.307411, -75.926877),
    "23420": (37.59081, -75.832274),
    "23421": (37.840771, -75.633717),
    "23422": (37.616183, -75.791519),
    "23423": (37.542324, -75.74122),
    "23424": (36.996881, -76.564516),
    "23426": (37.922894, -75.678111),
    "23427": (37.926441, -75.72197800000001),
    "23429": (37.271104, -75.953608),
    "23430": (36.990826, -76.661123),
    "23431": (36.898915, -76.687745),
    "23432": (36.874916, -76.553061),
    "23433": (36.9061, -76.493175),
    "23434": (36.704592, -76.636158),
    "23435": (36.837412, -76.477756),
    "23436": (36.886856, -76.523388),
    "23437": (36.646717, -76.796225),
    "23438": (36.598524, -76.710143),
    "23439": (36.746101, -76.665251),
    "23440": (37.823118, -75.994287),
    "23441": (37.732288, -75.677292),
    "23442": (37.899545, -75.580102),
    "23443": (37.188217, -75.969003),
    "23450": (36.844004, -76.12036),
    "23451": (36.856348, -76.053568),
    "23452": (36.846147, -76.097355),
    "23454": (36.828586, -76.070772),
    "23455": (36.888865, -76.146757),
    "23456": (36.746599, -76.039092),
    "23457": (36.622351, -76.02485),
    "23458": (36.847388, -76.15581),
    "23459": (36.924496, -76.018703),
    "23460": (36.837598, -76.026053),
    "23461": (36.790249, -76.002552),
    "23462": (36.837052, -76.146692),
    "23463": (36.795669, -76.012628),
    "23464": (36.799473, -76.178375),
    "23465": (36.851243, -76.169215),
    "23466": (36.795669, -76.012628),
    "23467": (36.795669, -76.012628),
    "23468": (36.843948, -76.142407),
    "23471": (36.795669, -76.012628),
    "23479": (36.795669, -76.012628),
    "23480": (37.604378, -75.692465),
    "23482": (37.273986, -75.86913),
    "23483": (37.943726, -75.502306),
    "23486": (37.518917, -75.810482),
    "23487": (36.845054, -76.713731),
    "23488": (37.948229, -75.601856),
    "23501": (36.895911, -76.208521),
    "23502": (36.887433, -76.212909),
    "23503": (36.948097, -76.256311),
    "23504": (36.877847, -76.265762),
    "23505": (36.902947, -76.278813),
    "23506": (36.931166, -76.23972),
    "23507": (36.865697, -76.299862),
    "23508": (36.884447, -76.299963),
    "23509": (36.881197, -76.261511),
    "23510": (36.881047, -76.292412),
    "23511": (36.935579, -76.303417),
    "23512": (36.931166, -76.23972),
    "23513": (36.890747, -76.23516),
    "23514": (36.931166, -76.23972),
    "23515": (36.931166, -76.23972),
    "23517": (36.869597, -76.292611),
    "23518": (36.907997, -76.216448),
    "23519": (36.931166, -76.23972),
    "23520": (36.931166, -76.23972),
    "23521": (36.913144, -76.14715699999999),
    "23523": (36.831647, -76.270561),
    "23529": (36.931166, -76.23972),
    "23530": (36.931166, -76.23972),
    "23541": (36.931166, -76.23972),
    "23551": (36.931166, -76.23972),
    "23601": (37.058296, -76.463471),
    "23602": (37.125384, -76.510952),
    "23603": (37.168276, -76.541367),
    "23604": (37.157438, -76.584469),
    "23605": (37.021946, -76.436637),
    "23606": (37.073526, -76.493022),
    "23607": (36.991097, -76.420763),
    "23608": (37.152619, -76.542039),
    "23609": (37.195924, -76.524805),
    "23612": (37.195924, -76.524805),
    "23628": (37.195924, -76.524805),
    "23630": (37.072658, -76.38992),
    "23631": (37.072658, -76.38992),
    "23651": (37.018012, -76.304391),
    "23653": (37.072658, -76.38992),
    "23661": (37.034746, -76.385817),
    "23662": (37.132326, -76.365419),
    "23663": (37.034207, -76.319364),
    "23664": (37.05165, -76.334465),
    "23665": (37.083118, -76.360036),
    "23666": (37.060646, -76.371616),
    "23667": (37.019346, -76.331815),
    "23668": (37.020596, -76.337715),
    "23669": (37.045715, -76.353866),
    "23670": (37.072658, -76.38992),
    "23681": (37.072658, -76.38992),
    "23690": (37.230251, -76.524359),
    "23691": (37.203185, -76.494054),
    "23692": (37.168632, -76.458126),
    "23693": (37.152812, -76.44791),
    "23694": (37.223152, -76.55901),
    "23696": (37.189902, -76.426469),
    "23701": (36.811498, -76.367715),
    "23702": (36.804098, -76.329263),
    "23703": (36.867948, -76.380766),
    "23704": (36.824298, -76.315663),
    "23705": (36.868553, -76.355165),
    "23707": (36.837153, -76.347314),
    "23708": (36.868553, -76.355165),
    "23709": (36.868553, -76.355165),
    "23801": (37.233941, -77.334831),
    "23803": (37.21713, -77.389253),
    "23804": (37.204765, -77.392784),
    "23805": (37.1922, -77.389641),
    "23806": (37.204765, -77.392784),
    "23821": (36.858078, -77.894632),
    "23822": (37.072361, -77.647495),
    "23824": (37.12237, -77.978923),
    "23827": (36.611614, -77.207263),
    "23828": (36.597427, -77.293341),
    "23829": (36.720629, -77.236519),
    "23830": (37.021522, -77.453348),
    "23831": (37.320744, -77.454311),
    "23832": (37.392683, -77.605362),
    "23833": (37.168045, -77.674226),
    "23834": (37.26219, -77.396989),
    "23836": (37.347458, -77.338551),
    "23837": (36.70656, -77.21552199999999),
    "23838": (37.333271, -77.634265),
    "23839": (37.065785, -76.915537),
    "23840": (37.069327, -77.677945),
    "23841": (37.079304, -77.601563),
    "23842": (37.150869, -77.213961),
    "23843": (36.849008, -77.807345),
    "23844": (36.662286, -77.335713),
    "23845": (36.598591, -78.001206),
    "23846": (37.07295, -76.856852),
    "23847": (36.694745, -77.535517),
    "23850": (37.134946, -77.736402),
    "23851": (36.682635, -76.942233),
    "23856": (36.808949, -77.720027),
    "23857": (36.596172, -77.890727),
    "23860": (37.286676, -77.296596),
    "23866": (36.887634, -76.900225),
    "23867": (36.864325, -77.282567),
    "23868": (36.734246, -77.81356099999999),
    "23870": (36.721471, -77.531996),
    "23872": (37.010322, -77.736044),
    "23873": (36.80878, -77.954397),
    "23874": (36.607792, -77.092706),
    "23875": (37.234733, -77.263465),
    "23876": (36.948942, -77.841001),
    "23878": (36.820784, -77.026194),
    "23879": (36.595815, -77.59207),
    "23881": (37.169453, -76.967517),
    "23882": (36.878331, -77.392824),
    "23883": (37.095554, -76.821125),
    "23884": (36.945667, -77.253913),
    "23885": (37.180418, -77.575347),
    "23887": (36.6608, -77.820567),
    "23888": (36.958091, -77.040206),
    "23889": (36.885672, -77.764753),
    "23890": (36.973687, -77.12993),
    "23891": (36.909845, -77.286287),
    "23893": (36.61509, -77.927891),
    "23894": (37.125964, -77.703648),
    "23897": (36.838572, -77.27587),
    "23898": (36.833708, -76.817727),
    "23899": (37.199009, -76.984159),
    "23901": (37.280694, -78.421284),
    "23909": (37.301574, -78.394944),
    "23915": (36.70774, -78.281204),
    "23917": (36.655033, -78.350388),
    "23919": (36.612381, -78.288907),
    "23920": (36.697808, -77.935481),
    "23921": (37.563225, -78.53643),
    "23922": (37.190922, -78.182733),
    "23923": (37.087895, -78.637846),
    "23924": (36.771496, -78.425379),
    "23927": (36.65565, -78.458282),
    "23930": (37.150355, -78.095474),
    "23934": (37.153846, -78.661108),
    "23936": (37.412369, -78.434926),
    "23937": (36.961434, -78.556872),
    "23938": (36.918641, -78.052391),
    "23939": (37.377196, -78.80648),
    "23941": (36.948129, -78.248333),
    "23942": (37.238139, -78.461789),
    "23943": (37.238139, -78.461789),
    "23944": (36.909212, -78.142642),
    "23947": (37.013846, -78.567247),
    "23950": (36.690021, -78.232633),
    "23952": (36.979498, -78.285967),
    "23954": (37.238139, -78.461789),
    "23955": (37.116094, -78.057832),
    "23958": (37.377196, -78.80648),
    "23959": (37.108477, -78.739921),
    "23960": (37.238139, -78.461789),
    "23962": (36.951533, -78.705413),
    "23963": (37.181814, -78.77379),
    "23964": (36.783999, -78.618595),
    "23966": (37.280047, -78.346836),
    "23967": (36.905289, -78.632086),
    "23968": (36.723976, -78.530076),
    "23970": (36.717223, -78.168729),
    "23974": (36.961136, -78.258493),
    "23976": (36.839122, -78.598225),
    "24001": (37.274175, -79.95786),
    "24002": (37.274175, -79.95786),
    "24003": (37.274175, -79.95786),
    "24004": (37.274175, -79.95786),
    "24005": (37.274175, -79.95786),
    "24006": (37.274175, -79.95786),
    "24007": (37.274175, -79.95786),
    "24008": (37.274175, -79.95786),
    "24009": (37.274175, -79.95786),
    "24010": (37.274175, -79.95786),
    "24011": (37.270237, -79.941586),
    "24012": (37.30529, -79.92711),
    "24013": (37.265687, -79.923698),
    "24014": (37.238643, -79.940559),
    "24015": (37.253866, -79.974559),
    "24016": (37.272486, -79.952709),
    "24017": (37.297919, -79.98776),
    "24018": (37.250349, -80.05251),
    "24019": (37.351517, -79.905211),
    "24020": (37.358887, -79.944789),
    "24022": (37.278439, -79.933206),
    "24023": (37.210663, -80.406172),
    "24024": (37.274175, -79.95786),
    "24025": (37.274175, -79.95786),
    "24026": (37.274175, -79.95786),
    "24027": (37.274175, -79.95786),
    "24028": (37.274175, -79.95786),
    "24029": (37.274175, -79.95786),
    "24030": (37.274175, -79.95786),
    "24031": (37.274175, -79.95786),
    "24032": (37.274175, -79.95786),
    "24033": (37.274175, -79.95786),
    "24034": (37.274175, -79.95786),
    "24035": (37.274175, -79.95786),
    "24036": (37.274175, -79.95786),
    "24037": (37.274175, -79.95786),
    "24038": (37.274175, -79.95786),
    "24040": (37.274175, -79.95786),
    "24042": (37.271687, -79.939228),
    "24043": (37.269168, -79.939905),
    "24044": (37.274175, -79.95786),
    "24045": (37.268618, -79.940655),
    "24048": (37.274175, -79.95786),
    "24050": (37.555083, -79.786151),
    "24053": (36.612434, -80.504446),
    "24054": (36.670446, -79.742557),
    "24055": (36.735045, -79.975528),
    "24058": (37.198248, -80.615065),
    "24059": (37.154932, -80.121522),
    "24060": (37.256283, -80.43473),
    "24061": (37.179115, -80.351482),
    "24062": (37.174227, -80.395698),
    "24063": (37.174227, -80.395698),
    "24064": (37.369287, -79.819537),
    "24065": (37.098391, -79.95233),
    "24066": (37.547903, -79.712321),
    "24067": (37.024849, -80.056685),
    "24068": (37.154804, -80.418396),
    "24069": (36.594226, -79.616614),
    "24070": (37.355418, -80.158462),
    "24072": (37.044622, -80.227981),
    "24073": (37.118759, -80.41787),
    "24076": (36.597733, -80.36824),
    "24077": (37.372608, -79.901331),
    "24078": (36.724691, -79.914912),
    "57261": (45.369855, -97.603949),
    "24079": (37.048796, -80.153614),
    "24082": (36.627165, -80.11928),
    "24083": (37.44197, -79.914156),
    "24084": (37.122327, -80.752614),
    "24085": (37.645695, -79.864047),
    "24086": (37.277231, -80.670159),
    "24087": (37.225683, -80.184842),
    "24088": (36.889337, -80.025866),
    "24089": (36.708873, -79.970745),
    "24090": (37.527349, -79.834474),
    "24091": (36.895714, -80.327524),
    "24092": (36.985894, -79.772986),
    "24093": (37.384006, -80.853048),
    "24094": (37.385257, -80.590627),
    "24095": (37.21229, -79.742886),
    "24101": (37.177891, -79.667368),
    "24102": (36.840862, -79.986739),
    "24104": (37.154717, -79.494856),
    "24105": (36.90035, -80.585888),
    "24111": (37.174227, -80.395698),
    "24112": (36.681298, -79.86626),
    "24113": (36.679571, -79.865168),
    "24114": (36.679571, -79.865168),
    "24115": (36.679571, -79.865168),
    "24120": (36.700218, -80.353031),
    "24121": (37.185024, -79.563579),
    "24122": (37.419582, -79.710746),
    "24124": (37.342026, -80.762866),
    "24126": (37.069206, -80.689067),
    "24127": (37.498957, -80.138591),
    "24128": (37.331516, -80.523039),
    "24129": (37.096403, -80.608056),
    "24130": (37.555083, -79.786151),
    "24131": (37.488235, -80.222319),
    "24132": (37.204788, -80.620517),
    "24133": (36.682193, -80.136393),
    "24134": (37.261147, -80.74373),
    "24136": (37.35623, -80.690234),
    "24137": (36.934169, -79.682503),
    "24138": (37.06488, -80.32637),
    "24139": (36.995808, -79.470112),
    "24141": (37.119732, -80.556541),
    "24142": (37.138733, -80.54802),
    "24143": (37.122583, -80.562913),
    "24146": (37.006912, -79.913875),
    "24147": (37.363616, -80.749864),
    "24148": (36.650725, -79.854972),
    "24149": (37.057894, -80.436385),
    "24150": (37.37067, -80.662674),
    "24151": (36.995127, -79.852489),
    "24153": (37.28814, -80.067762),
    "24155": (37.288384, -80.067062),
    "24156": (37.288384, -80.067062),
    "24157": (37.288384, -80.067062),
    "24161": (36.982776, -79.548523),
    "24162": (37.152878, -80.263621),
    "24165": (36.593912, -80.005233),
    "24167": (37.314577, -80.722619),
    "24168": (36.688926, -79.944745),
    "24171": (36.689183, -80.251601),
    "24174": (37.350092, -79.69189),
    "24175": (37.416128, -79.924765),
    "24176": (37.014893, -79.757636),
    "24177": (36.724064, -80.35806),
    "24178": (37.310494, -79.789799),
    "24179": (37.275674, -79.877505),
    "24184": (37.104127, -79.799315),
    "24185": (36.741838, -80.267112),
    "24201": (36.613815, -82.176238),
    "24202": (36.621571, -82.167633),
    "24203": (36.761613, -81.968712),
    "24209": (36.761613, -81.968712),
    "24210": (36.740217, -82.026738),
    "24211": (36.66726, -81.964801),
    "24212": (36.690942, -81.970764),
    "24215": (36.923445, -82.796445),
    "24216": (36.940452, -82.665879),
    "24217": (37.130943, -82.344881),
    "24218": (36.743491, -83.22336),
    "24219": (36.894806, -82.654215),
    "24220": (37.130943, -82.344881),
    "24221": (36.743491, -83.22336),
    "24224": (37.043978, -81.855318),
    "24225": (36.925928, -82.093586),
    "24226": (37.159677, -82.358274),
    "24228": (37.149797, -82.463069),
    "24230": (36.971586, -82.475496),
    "24236": (36.645463, -81.742678),
    "24237": (36.925928, -82.093586),
    "24239": (37.287992, -82.027408),
    "24243": (36.771579, -82.927728),
    "24244": (36.711382, -82.833676),
    "24245": (36.828738, -82.471457),
    "24246": (36.864429, -82.737469),
    "24248": (36.743491, -83.22336),
    "24250": (36.739474, -82.639637),
    "24251": (36.621664, -82.542414),
    "24256": (37.18399, -82.323976),
    "24258": (36.739474, -82.639637),
    "24260": (36.963056, -82.01331),
    "24263": (36.6885, -83.114212),
    "24265": (36.743491, -83.22336),
    "24266": (36.908553, -82.053655),
    "24269": (37.130943, -82.344881),
    "24270": (36.721945, -82.256139),
    "24271": (36.762954, -82.399015),
    "24272": (37.130943, -82.344881),
    "24273": (36.93767, -82.622624),
    "24277": (36.75823, -83.032536),
    "24279": (37.088727, -82.623231),
    "24280": (36.95095, -81.964938),
    "24281": (36.743491, -83.22336),
    "24282": (36.743491, -83.22336),
    "24283": (36.936767, -82.364288),
    "24285": (36.950943, -82.786715),
    "24289": (37.130943, -82.344881),
    "24290": (36.613714, -82.561825),
    "24292": (36.608229, -81.584934),
    "24293": (37.002843, -82.570697),
    "24301": (37.064714, -80.771241),
    "24311": (36.869374, -81.399235),
    "24312": (36.854655, -80.922512),
    "24313": (36.897395, -80.789443),
    "24314": (37.127348, -81.15842),
    "24315": (37.127348, -81.15842),
    "24316": (36.941611, -81.620331),
    "24317": (36.664788, -80.729669),
    "24318": (37.127348, -81.15842),
    "24319": (36.798213, -81.617482),
    "24322": (36.81781, -81.111146),
    "24323": (36.871709, -81.198867),
    "24324": (36.981684, -80.774844),
    "24325": (36.812134, -80.58895),
    "24326": (36.718676, -81.187968),
    "24327": (36.779961, -81.817064),
    "24328": (36.667972, -80.675229),
    "24330": (36.712696, -81.042703),
    "24333": (36.660281, -80.913605),
    "24340": (36.74578, -81.773242),
    "24343": (36.730347, -80.67507),
    "24347": (36.975578, -80.669513),
    "24348": (36.638835, -81.194296),
    "24350": (36.915513, -81.059955),
    "24351": (36.58637, -80.759966),
    "24352": (36.711129, -80.535146),
    "24354": (36.832324, -81.597841),
    "24360": (36.905629, -80.924423),
    "24361": (36.752637, -81.848288),
    "24363": (36.657529, -81.367509),
    "24366": (37.127348, -81.15842),
    "24368": (36.880988, -81.25526),
    "24370": (36.906696, -81.645388),
    "24373": (36.826371, -81.549231),
    "24374": (36.802255, -81.206262),
    "24375": (36.787066, -81.388192),
    "24377": (37.006018, -81.570038),
    "24378": (36.688587, -81.361748),
    "24379": (36.682782, -81.257795),
    "24380": (36.881393, -80.504784),
    "24381": (36.694308, -80.776569),
    "24382": (36.92855, -81.146559),
    "24401": (38.157368, -79.065116),
    "24402": (38.159275, -79.062858),
    "24407": (38.179715, -79.141332),
    "24411": (38.091705, -79.322363),
    "24412": (38.055311, -79.746367),
    "24413": (38.385967, -79.559157),
    "24415": (37.926477, -79.329162),
    "24416": (37.730001, -79.355121),
    "24421": (38.243395, -79.173229),
    "24422": (37.824232, -79.823119),
    "24426": (37.780216, -79.986963),
    "24430": (38.073868, -79.359123),
    "24431": (38.153856, -78.860085),
    "24432": (38.139476, -79.373366),
    "24433": (38.385967, -79.559157),
    "24435": (37.875396, -79.298708),
    "24437": (38.2064, -78.941138),
    "24438": (37.555083, -79.786151),
    "24439": (37.978313, -79.503429),
    "24440": (37.983435, -79.175646),
    "24441": (38.272465, -78.805841),
    "24442": (38.385967, -79.559157),
    "24445": (37.994443, -79.831593),
    "24448": (37.796454, -79.785987),
    "24450": (37.779976, -79.443495),
    "24457": (37.780396, -79.88283),
    "24458": (38.385967, -79.559157),
    "24459": (38.042838, -79.242427),
    "24460": (38.055311, -79.746367),
    "24463": (38.179715, -79.141332),
    "24464": (37.865358, -79.0804),
    "24465": (38.385967, -79.559157),
    "24467": (38.242038, -78.96826),
    "24468": (38.385967, -79.559157),
    "24469": (38.179715, -79.141332),
    "24471": (38.322592, -78.788649),
    "24472": (37.941296, -79.276332),
    "24473": (37.883036, -79.448586),
    "24474": (37.806241, -79.840421),
    "24476": (38.179715, -79.141332),
    "24477": (37.973609, -79.065951),
    "24479": (38.188328, -79.211901),
    "24482": (38.210585, -78.989369),
    "24483": (37.859217, -79.230686),
    "24484": (38.055311, -79.746367),
    "24485": (38.174227, -79.209622),
    "24486": (38.282326, -78.946136),
    "24487": (38.055311, -79.746367),
    "24501": (37.383112, -79.178326),
    "24502": (37.382542, -79.218121),
    "24503": (37.408091, -79.209247),
    "24504": (37.405242, -79.125261),
    "24505": (37.400944, -79.178506),
    "24506": (37.381692, -79.161046),
    "24512": (37.242503, -79.109789),
    "24513": (37.245798, -79.133546),
    "24514": (37.400944, -79.178506),
    "24515": (37.400944, -79.178506),
    "24517": (37.225543, -79.24118),
    "24520": (36.596827, -79.043054),
    "24521": (37.59162, -79.108441),
    "24522": (37.356134, -78.848202),
    "24523": (37.336027, -79.522585),
    "24526": (37.516659, -79.38752),
    "24527": (36.710176, -79.3381),
    "24528": (37.117502, -79.074279),
    "24529": (36.61405, -78.641645),
    "24530": (36.785155, -79.60708),
    "24531": (36.830785, -79.412735),
    "24533": (37.537969, -78.946324),
    "24534": (36.875823, -78.748218),
    "24535": (36.611317, -78.945519),
    "24536": (37.496433, -79.305838),
    "24538": (37.296071, -78.949355),
    "24539": (36.866093, -78.831701),
    "24540": (36.603501, -79.376228),
    "24541": (36.577505, -79.441637),
    "24543": (36.592679, -79.410983),
    "24544": (36.592679, -79.410983),
    "24549": (36.704919, -79.502331),
    "24550": (37.243659, -79.270958),
    "24551": (37.372437, -79.318718),
    "24553": (37.58939, -78.860834),
    "24554": (37.148585, -79.111743),
    "24555": (37.732638, -79.525212),
    "24556": (37.375464, -79.403888),
    "24557": (36.983015, -79.321101),
    "24558": (36.783814, -78.964257),
    "24562": (37.751112, -78.631326),
    "24563": (37.038301, -79.36393),
    "24565": (36.846278, -79.207927),
    "24566": (36.721431, -79.255522),
    "24569": (37.093523, -79.081614),
    "24570": (37.333936, -79.406303),
    "24571": (37.141308, -79.359182),
    "24572": (37.475715, -79.140618),
    "24574": (37.544326, -79.244826),
    "24576": (37.245798, -79.133546),
    "24577": (36.811672, -78.962546),
    "24578": (37.677211, -79.550792),
    "24579": (37.59797, -79.525047),
    "24580": (36.589478, -78.67745),
    "24581": (37.640813, -78.803767),
    "24585": (36.801515, -78.883933),
    "24586": (36.6136, -79.276568),
    "24588": (37.283924, -79.090832),
    "24589": (36.777629, -78.778726),
    "24590": (37.846277, -78.529827),
    "24592": (36.679767, -78.952947),
    "24593": (37.344169, -78.918241),
    "24594": (36.668449, -79.355493),
    "24595": (37.567427, -79.075617),
    "24597": (36.838178, -79.067906),
    "24598": (36.616452, -78.798686),
    "24599": (37.682224, -78.731156),
    "24601": (37.13549, -81.563406),
    "24602": (36.999484, -81.79514),
    "24603": (37.287992, -82.027408),
    "24604": (37.203317, -81.557499),
    "24605": (37.172408, -81.507054),
    "24606": (37.13549, -81.563406),
    "24607": (37.130943, -82.344881),
    "24608": (37.13549, -81.563406),
    "24609": (37.123379, -81.54705),
    "24612": (37.094523, -81.818037),
    "24613": (37.13549, -81.563406),
    "24614": (37.257171, -82.100073),
    "24618": (37.287992, -82.027408),
    "24619": (37.13549, -81.563406),
    "24620": (37.287992, -82.027408),
    "24622": (37.13549, -81.563406),
    "24624": (37.287992, -82.027408),
    "24627": (37.287992, -82.027408),
    "24628": (37.287992, -82.027408),
    "24630": (37.175577, -81.539856),
    "24631": (37.287992, -82.027408),
    "24634": (37.287992, -82.027408),
    "24635": (37.305417, -81.34246),
    "24637": (37.13549, -81.563406),
    "24639": (37.287992, -82.027408),
    "24640": (37.13549, -81.563406),
    "24641": (37.186196, -81.554668),
    "24646": (37.287992, -82.027408),
    "24647": (37.287992, -82.027408),
    "24649": (37.045445, -81.9271),
    "24651": (37.174459, -81.416087),
    "24656": (37.287992, -82.027408),
    "24657": (37.287992, -82.027408),
    "24658": (37.287992, -82.027408),
    "24701": (37.332725, -81.160066),
    "24712": (37.452346, -81.00916),
    "24714": (37.460069, -81.160053),
    "24715": (37.343532, -81.325281),
    "24716": (37.603344, -81.53998),
    "24719": (37.603344, -81.53998),
    "24724": (37.333273, -81.311849),
    "24726": (37.603344, -81.53998),
    "24729": (37.416395, -81.105803),
    "24731": (37.416395, -81.105803),
    "24732": (37.416395, -81.105803),
    "24733": (37.440745, -81.190841),
    "24736": (37.416393, -81.202217),
    "24737": (37.35391, -81.251807),
    "24738": (37.416395, -81.105803),
    "24739": (37.416395, -81.105803),
    "24740": (37.379876, -81.117475),
    "24747": (37.414224, -81.178417),
    "24751": (37.416395, -81.105803),
    "24801": (37.411086, -81.539352),
    "24808": (37.375246, -81.653889),
    "24811": (37.375246, -81.653889),
    "24813": (37.343847, -81.683131),
    "24815": (37.375246, -81.653889),
    "24816": (37.375246, -81.653889),
    "24817": (37.375246, -81.653889),
    "24818": (37.603344, -81.53998),
    "24820": (37.375246, -81.653889),
    "24821": (37.38297, -81.634292),
    "24822": (37.603344, -81.53998),
    "24823": (37.626772, -81.702061),
    "24824": (37.375246, -81.653889),
    "24825": (37.375246, -81.653889),
    "24826": (37.375246, -81.653889),
    "24827": (37.603344, -81.53998),
    "24828": (37.467849, -81.681104),
    "24829": (37.375246, -81.653889),
    "24830": (37.375246, -81.653889),
    "24831": (37.432867, -81.570983),
    "24832": (37.375246, -81.653889),
    "24834": (37.603344, -81.53998),
    "24836": (37.36584, -81.554444),
    "24839": (37.603344, -81.53998),
    "24841": (37.405828, -81.576548),
    "24842": (37.375246, -81.653889),
    "24843": (37.375246, -81.653889),
    "24844": (37.375246, -81.653889),
    "24845": (37.603344, -81.53998),
    "24846": (37.375246, -81.653889),
    "24847": (37.603344, -81.53998),
    "24848": (37.375246, -81.653889),
    "24849": (37.603344, -81.53998),
    "24850": (37.375246, -81.653889),
    "24851": (37.743063, -82.10801),
    "24852": (37.414357, -81.431783),
    "24853": (37.442086, -81.511965),
    "24854": (37.743967, -81.574986),
    "24855": (37.375246, -81.653889),
    "24856": (37.375246, -81.653889),
    "24857": (37.603344, -81.53998),
    "24859": (37.603344, -81.53998),
    "24860": (37.603344, -81.53998),
    "24861": (37.417549, -81.423979),
    "24862": (37.375246, -81.653889),
    "24866": (37.375246, -81.653889),
    "24867": (37.603344, -81.53998),
    "24868": (37.389939, -81.419578),
    "24869": (37.603344, -81.53998),
    "24870": (37.74071, -81.583069),
    "24871": (37.375246, -81.653889),
    "24872": (37.375246, -81.653889),
    "24873": (37.375246, -81.653889),
    "24874": (37.603344, -81.53998),
    "24877": (37.375246, -81.653889),
    "24878": (37.375246, -81.653889),
    "24879": (37.375246, -81.653889),
    "24880": (37.603344, -81.53998),
    "24881": (37.375246, -81.653889),
    "24882": (37.603344, -81.53998),
    "24883": (37.375246, -81.653889),
    "24884": (37.375246, -81.653889),
    "24887": (37.375246, -81.653889),
    "24888": (37.375246, -81.653889),
    "24889": (37.375246, -81.653889),
    "24892": (37.375246, -81.653889),
    "24894": (37.375246, -81.653889),
    "24895": (37.375246, -81.653889),
    "24896": (37.603344, -81.53998),
    "24897": (37.375246, -81.653889),
    "24898": (37.603344, -81.53998),
    "24899": (37.375246, -81.653889),
    "24901": (37.844155, -80.538781),
    "24902": (37.774666, -80.461492),
    "24910": (37.84394, -80.572401),
    "24915": (38.387966, -79.990585),
    "24916": (37.975595, -80.426874),
    "24917": (37.975595, -80.426874),
    "24918": (37.552029, -80.539672),
    "24919": (37.674782, -80.890043),
    "24920": (38.387966, -79.990585),
    "24924": (38.387966, -79.990585),
    "24925": (37.975595, -80.426874),
    "24927": (38.387966, -79.990585),
    "24931": (37.918876, -80.611705),
    "24934": (38.326214, -79.898674),
    "24935": (37.648541, -80.877395),
    "24936": (37.975595, -80.426874),
    "24938": (37.915363, -80.335257),
    "24941": (37.58902, -80.340084),
    "24942": (37.552029, -80.539672),
    "24943": (37.975595, -80.426874),
    "24944": (38.387966, -79.990585),
    "24945": (37.552029, -80.539672),
    "24946": (38.110904, -80.264059),
    "24950": (37.975595, -80.426874),
    "24951": (37.552029, -80.539672),
    "24954": (38.258638, -80.104625),
    "24957": (37.975595, -80.426874),
    "24958": (37.975595, -80.426874),
    "24961": (37.975595, -80.426874),
    "24962": (37.648541, -80.877395),
    "24963": (37.399956, -80.797806),
    "24966": (37.975595, -80.426874),
    "24970": (37.744709, -80.454189),
    "24974": (37.552029, -80.539672),
    "24976": (37.552029, -80.539672),
    "24977": (37.975595, -80.426874),
    "24981": (37.648541, -80.877395),
    "24983": (37.552029, -80.539672),
    "24984": (37.489872, -80.420487),
    "24985": (37.552029, -80.539672),
    "24986": (37.782726, -80.312877),
    "24991": (37.975595, -80.426874),
    "24993": (37.552029, -80.539672),
    "25002": (38.041293, -81.064784),
    "25003": (38.243675, -81.771226),
    "25004": (37.784459, -81.118491),
    "25005": (38.591037, -81.273681),
    "25007": (37.82156, -81.409586),
    "25008": (37.940013, -81.354496),
    "25009": (37.997105, -81.71704),
    "25010": (37.997105, -81.71704),
    "25011": (38.508559, -81.841002),
    "25015": (38.232406, -81.502399),
    "25018": (38.465777, -81.050662),
    "25019": (38.465777, -81.050662),
    "25021": (37.997105, -81.71704),
    "25022": (37.833204, -81.902401),
    "25024": (38.154021, -81.630599),
    "25025": (38.296818, -81.554655),
    "25026": (38.490789, -81.392845),
    "25028": (37.997105, -81.71704),
    "25030": (38.387998, -81.254838),
    "25031": (38.163248, -81.307528),
    "25033": (38.610603, -81.924758),
    "25035": (38.193014, -81.498415),
    "25036": (38.041293, -81.064784),
    "25039": (38.279199, -81.59823),
    "25040": (38.041293, -81.064784),
    "25043": (38.467298, -81.080031),
    "25044": (37.880406, -81.408766),
    "25045": (38.453862, -81.357213),
    "25046": (38.731737, -81.314633),
    "25047": (37.833204, -81.902401),
    "25048": (37.942986, -81.402075),
    "25049": (38.126494, -81.607191),
    "25051": (37.997105, -81.71704),
    "25053": (38.01946, -81.885268),
    "25054": (38.073666, -81.451066),
    "25057": (38.041293, -81.064784),
    "25059": (38.254945, -81.217588),
    "25060": (37.949132, -81.444561),
    "25061": (38.296818, -81.554655),
    "25062": (37.854572, -81.453786),
    "25063": (38.582138, -80.936783),
    "25064": (38.348822, -81.570048),
    "25067": (38.209887, -81.438053),
    "25070": (38.543573, -81.941425),
    "25071": (38.386942, -81.450424),
    "25075": (38.178047, -81.615909),
    "25076": (37.833204, -81.902401),
    "25079": (38.495072, -81.398422),
    "25081": (38.072562, -81.825259),
    "25082": (38.560972, -82.022361),
    "25083": (38.296818, -81.554655),
    "25085": (38.156166, -81.174906),
    "25086": (38.215547, -81.406705),
    "25088": (38.465777, -81.050662),
    "25090": (38.041293, -81.064784),
    "25093": (37.997105, -81.71704),
    "25095": (38.752312, -81.997278),
    "25102": (38.187888, -81.3657),
    "25103": (38.207048, -81.39286),
    "25106": (38.833117, -82.138543),
    "25107": (38.296818, -81.554655),
    "25108": (37.997105, -81.71704),
    "25109": (38.475369, -81.880455),
    "25110": (38.21097, -81.388446),
    "25111": (38.465777, -81.050662),
    "25112": (38.282497, -81.56514),
    "25113": (38.465777, -81.050662),
    "25114": (37.997105, -81.71704),
    "25115": (38.041293, -81.064784),
    "25118": (38.041293, -81.064784),
    "25119": (38.041293, -81.064784),
    "25121": (37.920381, -81.903389),
    "25122": (38.296818, -81.554655),
    "25123": (38.704805, -81.914474),
    "25124": (38.475369, -81.880455),
    "25125": (38.334726, -81.198102),
    "25126": (38.195983, -81.371367),
    "25130": (38.063165, -81.818718),
    "25132": (38.296818, -81.554655),
    "25133": (38.465777, -81.050662),
    "25134": (38.296818, -81.554655),
    "25136": (38.172523, -81.322175),
    "25139": (38.139916, -81.29309),
    "25140": (37.877222, -81.481192),
    "25141": (38.465777, -81.050662),
    "25142": (37.997105, -81.71704),
    "25143": (38.323042, -81.616124),
    "25147": (38.296818, -81.554655),
    "25148": (37.997105, -81.71704),
    "25149": (37.997105, -81.71704),
    "25150": (38.465777, -81.050662),
    "25152": (38.041293, -81.064784),
    "25154": (38.136924, -81.679052),
    "25156": (38.401962, -81.461063),
    "25159": (38.479147, -81.783795),
    "25160": (38.290746, -81.277293),
    "25161": (38.041293, -81.064784),
    "25162": (38.210104, -81.385107),
    "25164": (38.491236, -81.198904),
    "25165": (38.140996, -81.658829),
    "25168": (38.555097, -81.901394),
    "25169": (37.997105, -81.71704),
    "25173": (38.076677, -81.237015),
    "25174": (37.854721, -81.418351),
    "25177": (38.31461, -81.636926),
    "25180": (37.793057, -81.384755),
    "25181": (38.085024, -81.622894),
    "25182": (38.296818, -81.554655),
    "25183": (37.833204, -81.902401),
    "25185": (38.041293, -81.064784),
    "25186": (38.154338, -81.278012),
    "25187": (38.725035, -82.027474),
    "25193": (38.010386, -81.558467),
    "25201": (38.296818, -81.554655),
    "25202": (38.332069, -81.8563),
    "25203": (37.986266, -81.942704),
    "25204": (37.997105, -81.71704),
    "25205": (38.042839, -81.805265),
    "25206": (37.997105, -81.71704),
    "25208": (37.997105, -81.71704),
    "25209": (37.991591, -81.542234),
    "25211": (38.465777, -81.050662),
    "25213": (38.50099, -81.914048),
    "25214": (38.18983, -81.565648),
    "25231": (38.824924, -81.70665),
    "25234": (38.828582, -81.132151),
    "25235": (38.828582, -81.132151),
    "25239": (38.848369, -81.847298),
    "25241": (38.796245, -81.807118),
    "25243": (38.683119, -81.453016),
    "25244": (38.824924, -81.70665),
    "25245": (38.70697, -81.722296),
    "25247": (38.752312, -81.997278),
    "25248": (38.623155, -81.621667),
    "25250": (38.752312, -81.997278),
    "25251": (38.731737, -81.314633),
    "25252": (38.824924, -81.70665),
    "25253": (38.989085, -81.951871),
    "25256": (38.731737, -81.314633),
    "25258": (38.913649, -80.831256),
    "25259": (38.696744, -81.233061),
    "25260": (39.011467, -82.016935),
    "25261": (38.828582, -81.132151),
    "25262": (38.905595, -81.835048),
    "25264": (38.824924, -81.70665),
    "25265": (38.986319, -81.965175),
    "25266": (38.731737, -81.314633),
    "25267": (38.913649, -80.831256),
    "25268": (38.828582, -81.132151),
    "25270": (38.888886, -81.439879),
    "25271": (38.791845, -81.728065),
    "25275": (38.889106, -81.682596),
    "25276": (38.777675, -81.364262),
    "25279": (38.824924, -81.70665),
    "25281": (38.731737, -81.314633),
    "25283": (38.465777, -81.050662),
    "25285": (38.465777, -81.050662),
    "25286": (38.608737, -81.419262),
    "25287": (38.752312, -81.997278),
    "25301": (38.328948, -81.605094),
    "25302": (38.401498, -81.584087),
    "25303": (38.352946, -81.658246),
    "25304": (38.305728, -81.595903),
    "25305": (38.335798, -81.612344),
    "25306": (38.317499, -81.527433),
    "25309": (38.310767, -81.756808),
    "25311": (38.371957, -81.632845),
    "25312": (38.455865, -81.637823),
    "25313": (38.414156, -81.758172),
    "25314": (38.32925, -81.665927),
    "25315": (38.235149, -81.553608),
    "25317": (38.335647, -81.613794),
    "25320": (38.542798, -81.633378),
    "25321": (38.296818, -81.554655),
    "25322": (38.534661, -81.56035),
    "25323": (38.296818, -81.554655),
    "25324": (38.296818, -81.554655),
    "25325": (38.296818, -81.554655),
    "25326": (38.296818, -81.554655),
    "25327": (38.296818, -81.554655),
    "25328": (38.296818, -81.554655),
    "25329": (38.296818, -81.554655),
    "25330": (38.296818, -81.554655),
    "25331": (38.296818, -81.554655),
    "25332": (38.296818, -81.554655),
    "25333": (38.296818, -81.554655),
    "25334": (38.296818, -81.554655),
    "25335": (38.296818, -81.554655),
    "25336": (38.296818, -81.554655),
    "25337": (38.296818, -81.554655),
    "25338": (38.296818, -81.554655),
    "25339": (38.296818, -81.554655),
    "25350": (38.296818, -81.554655),
    "25356": (38.296818, -81.554655),
    "25357": (38.296818, -81.554655),
    "25358": (38.296818, -81.554655),
    "25360": (38.296818, -81.554655),
    "25361": (38.296818, -81.554655),
    "25362": (38.296818, -81.554655),
    "25364": (38.296818, -81.554655),
    "25365": (38.296818, -81.554655),
    "25375": (38.296818, -81.554655),
    "25387": (38.296818, -81.554655),
    "25389": (38.354041, -81.639389),
    "25392": (38.296818, -81.554655),
    "25396": (38.296818, -81.554655),
    "25401": (39.444061, -77.951924),
    "25402": (39.461663, -78.011472),
    "25410": (39.315914, -77.877223),
    "25411": (39.552557, -78.18773),
    "25413": (39.377876, -78.064925),
    "25414": (39.313538, -77.860278),
    "25419": (39.572966, -77.882155),
    "25420": (39.384529, -78.102777),
    "25421": (39.381345, -78.143466),
    "25422": (39.612559, -78.391552),
    "25423": (39.315914, -77.877223),
    "25425": (39.314617, -77.789387),
    "25427": (39.485043, -78.034659),
    "25428": (39.362373, -78.033065),
    "25429": (39.349586, -77.878957),
    "25430": (39.344424, -77.941833),
    "25431": (39.314071, -78.659428),
    "25432": (39.315914, -77.877223),
    "25434": (39.530566, -78.45729),
    "25437": (39.314071, -78.659428),
    "25438": (39.26006, -77.831031),
    "25440": (39.442661, -78.02628),
    "25441": (39.315914, -77.877223),
    "25442": (39.371605, -77.822878),
    "25443": (39.389587, -77.838337),
    "25444": (39.34125, -78.754473),
    "25446": (39.224095, -77.878788),
    "25501": (38.167112, -81.968862),
    "25502": (38.657528, -82.10679),
    "25503": (38.60323, -82.112281),
    "25504": (38.379347, -82.264954),
    "25505": (37.833204, -81.902401),
    "25506": (38.219908, -82.145897),
    "25507": (38.384557, -82.557785),
    "25508": (37.96087, -82.01076),
    "25510": (38.426471, -82.110405),
    "25511": (38.132114, -82.418277),
    "25512": (38.271293, -82.376703),
    "25514": (38.072978, -82.539781),
    "25515": (38.738211, -82.155965),
    "25517": (38.132114, -82.418277),
    "25519": (38.132114, -82.418277),
    "25520": (38.590868, -82.177263),
    "25521": (38.246211, -81.960658),
    "25523": (38.280522, -82.083145),
    "25524": (38.034057, -82.100836),
    "25526": (38.397097, -81.961657),
    "25529": (38.146531, -81.86073),
    "25530": (38.356931, -82.525529),
    "25534": (38.132114, -82.418277),
    "25535": (38.299465, -82.457353),
    "25537": (38.523488, -82.255114),
    "25540": (38.16021, -82.054088),
    "25541": (38.434487, -82.134925),
    "25544": (38.222163, -82.113554),
    "25545": (38.456541, -82.234177),
    "25547": (37.955852, -82.005372),
    "25550": (38.871527, -82.098592),
    "25555": (38.240005, -82.565378),
    "25557": (38.082564, -82.072502),
    "25559": (38.317827, -82.22918),
    "25560": (38.450355, -81.896554),
    "25562": (38.343176, -82.490494),
    "25564": (38.255874, -81.890954),
    "25565": (38.105713, -82.027154),
    "25567": (38.228049, -81.870544),
    "25569": (38.475369, -81.880455),
    "25570": (38.222206, -82.418862),
    "25571": (38.299231, -82.153237),
    "25572": (38.187456, -81.901236),
    "25573": (38.231798, -81.942329),
    "25601": (37.865036, -82.025158),
    "25606": (37.833204, -81.902401),
    "25607": (37.795916, -81.783341),
    "25608": (37.743063, -82.10801),
    "25611": (37.833204, -81.902401),
    "25612": (37.833204, -81.902401),
    "25614": (37.833204, -81.902401),
    "25617": (37.833204, -81.902401),
    "25621": (37.636568, -81.950082),
    "25623": (37.743063, -82.10801),
    "25624": (37.833204, -81.902401),
    "25625": (37.829956, -82.058464),
    "25628": (37.833204, -81.902401),
    "25630": (37.833204, -81.902401),
    "25632": (37.765557, -81.921698),
    "25634": (37.833204, -81.902401),
    "25635": (37.735653, -81.875358),
    "25636": (37.821927, -82.006203),
    "25637": (37.84639, -82.048494),
    "25638": (37.741593, -82.003139),
    "25639": (37.875177, -81.982637),
    "25644": (37.833204, -81.902401),
    "25645": (37.833204, -81.902401),
    "25646": (37.830256, -81.963853),
    "25647": (37.784635, -81.990849),
    "25649": (37.88911, -82.048823),
    "25650": (37.637348, -81.875714),
    "25651": (37.743063, -82.10801),
    "25652": (37.803545, -82.046594),
    "25653": (37.808204, -82.053011),
    "25654": (37.781792, -81.891965),
    "25661": (37.702526, -82.26002),
    "25665": (37.721351, -82.30835),
    "25666": (37.926178, -82.270292),
    "25667": (37.704739000000004, -82.273892),
    "25669": (38.132114, -82.418277),
    "25670": (37.718871, -82.193059),
    "25671": (37.743063, -82.10801),
    "25672": (37.743063, -82.10801),
    "25674": (37.827155, -82.404906),
    "25676": (37.743063, -82.10801),
    "25678": (37.743063, -82.10801),
    "25682": (37.6224, -82.008561),
    "25685": (37.743063, -82.10801),
    "25686": (37.743063, -82.10801),
    "25687": (37.743063, -82.10801),
    "25688": (37.743063, -82.10801),
    "25690": (37.743063, -82.10801),
    "25691": (37.743063, -82.10801),
    "25692": (37.743063, -82.10801),
    "25694": (37.743063, -82.10801),
    "25696": (37.743063, -82.10801),
    "25697": (37.743063, -82.10801),
    "25699": (38.132114, -82.418277),
    "25701": (38.371727, -82.412866),
    "25702": (38.444067, -82.34872),
    "25703": (38.422801, -82.413818),
    "25704": (38.397571, -82.477733),
    "25705": (38.406124, -82.359088),
    "25706": (38.413384, -82.277401),
    "25707": (38.413384, -82.277401),
    "25708": (38.413384, -82.277401),
    "25709": (38.132114, -82.418277),
    "25710": (38.413384, -82.277401),
    "25711": (38.413384, -82.277401),
    "25712": (38.413384, -82.277401),
    "25713": (38.413384, -82.277401),
    "25714": (38.413384, -82.277401),
    "25715": (38.413384, -82.277401),
    "25716": (38.413384, -82.277401),
    "25717": (38.413384, -82.277401),
    "25718": (38.413384, -82.277401),
    "25719": (38.413384, -82.277401),
    "25720": (38.413384, -82.277401),
    "25721": (38.413384, -82.277401),
    "25722": (38.413384, -82.277401),
    "25723": (38.413384, -82.277401),
    "25724": (38.413384, -82.277401),
    "25725": (38.413384, -82.277401),
    "25726": (38.413384, -82.277401),
    "25727": (38.413384, -82.277401),
    "25728": (38.413384, -82.277401),
    "25729": (38.413384, -82.277401),
    "25755": (38.422115, -82.431667),
    "25770": (38.413384, -82.277401),
    "25771": (38.413384, -82.277401),
    "25772": (38.413384, -82.277401),
    "25773": (38.413384, -82.277401),
    "25774": (38.413384, -82.277401),
    "25775": (38.413384, -82.277401),
    "25776": (38.413384, -82.277401),
    "25777": (38.413384, -82.277401),
    "25778": (38.413384, -82.277401),
    "25779": (38.413384, -82.277401),
    "25801": (37.767248, -81.216446),
    "25802": (37.748935, -81.224458),
    "25810": (37.603344, -81.53998),
    "25811": (37.603344, -81.53998),
    "25812": (38.135025, -81.087871),
    "25813": (37.753437, -81.1973),
    "25816": (37.735161, -81.136328),
    "25817": (37.774581, -81.388107),
    "25818": (37.862613, -81.200997),
    "25820": (37.509522, -81.099605),
    "25823": (37.670797, -81.174872),
    "25825": (37.665456, -81.093339),
    "25826": (37.603344, -81.53998),
    "25827": (37.700567, -81.201446),
    "25831": (38.041293, -81.064784),
    "25832": (37.693341, -81.216077),
    "25833": (38.041293, -81.064784),
    "25836": (37.779232, -81.263538),
    "25837": (38.041293, -81.064784),
    "25839": (37.768902, -81.371602),
    "25840": (38.063982, -81.094259),
    "25841": (37.554091, -81.100627),
    "25843": (37.679167, -81.151526),
    "25844": (37.825085, -81.38583),
    "25845": (37.603344, -81.53998),
    "25846": (38.041293, -81.064784),
    "25847": (37.713406, -81.178779),
    "25848": (37.603344, -81.53998),
    "25849": (37.730624, -81.279864),
    "25851": (37.802469, -81.282759),
    "25853": (37.748935, -81.224458),
    "25854": (38.041293, -81.064784),
    "25855": (38.041293, -81.064784),
    "25856": (37.647885, -81.190628),
    "25857": (37.631543, -81.227631),
    "25859": (38.041293, -81.064784),
    "25860": (37.748935, -81.224458),
    "25862": (38.041293, -81.064784),
    "25864": (38.041293, -81.064784),
    "25865": (37.73121, -81.317326),
    "25866": (38.041293, -81.064784),
    "25868": (38.041293, -81.064784),
    "25870": (37.610803, -81.505936),
    "25871": (37.770012, -81.210253),
    "25873": (37.7517, -81.214825),
    "25875": (37.603344, -81.53998),
    "25876": (37.603344, -81.53998),
    "25878": (37.717052, -81.240023),
    "25879": (37.975773, -81.114993),
    "25880": (38.00309, -81.19331),
    "25882": (37.582143, -81.413815),
    "25901": (37.959435, -81.15848),
    "25902": (37.596319, -81.190678),
    "25904": (37.91101, -81.264824),
    "25906": (37.837573, -81.128631),
    "25907": (37.853198, -81.081717),
    "25908": (37.715831, -81.246754),
    "25909": (37.838147, -81.200383),
    "25911": (37.758469, -81.167549),
    "25912": (38.041293, -81.064784),
    "25913": (37.603344, -81.53998),
    "25914": (38.041293, -81.064784),
    "25915": (37.625414, -81.27493),
    "25916": (37.603344, -81.53998),
    "25917": (37.948765, -81.15307),
    "25918": (37.741625, -81.014915),
    "25919": (37.800481, -81.180561),
    "25920": (37.717933, -81.37157),
    "25921": (37.777244, -81.345004),
    "25922": (37.460452, -81.112799),
    "25926": (37.787252, -81.195122),
    "25927": (37.748935, -81.224458),
    "25928": (37.603344, -81.53998),
    "25931": (38.041293, -81.064784),
    "25932": (37.764228, -81.221724),
    "25934": (37.848955, -81.093678),
    "25936": (38.041293, -81.064784),
    "25938": (38.041293, -81.064784),
    "25942": (38.041293, -81.064784),
    "25943": (37.603344, -81.53998),
    "25951": (37.645544, -80.864634),
    "25958": (37.975595, -80.426874),
    "25961": (37.975595, -80.426874),
    "25962": (37.973212, -80.74519),
    "25965": (37.648541, -80.877395),
    "25966": (37.648541, -80.877395),
    "25967": (37.975595, -80.426874),
    "25969": (37.648541, -80.877395),
    "25971": (37.416395, -81.105803),
    "25972": (37.975595, -80.426874),
    "25976": (37.865186, -80.874366),
    "25977": (37.648541, -80.877395),
    "25978": (37.648541, -80.877395),
    "25979": (37.648541, -80.877395),
    "25981": (37.975595, -80.426874),
    "25984": (37.968468, -80.669597),
    "25985": (37.648541, -80.877395),
    "25986": (38.041293, -81.064784),
    "25988": (37.648541, -80.877395),
    "25989": (37.684255, -81.048923),
    "26003": (40.102703, -80.647599),
    "26030": (40.225862, -80.65135),
    "26031": (39.955349, -80.710507),
    "26032": (40.210727, -80.550337),
    "26033": (39.872322, -80.555275),
    "26034": (40.556137, -80.565784),
    "26035": (40.373181, -80.566155),
    "26036": (40.015394, -80.550114),
    "26037": (40.335218, -80.570953),
    "26038": (39.962545, -80.719815),
    "26039": (39.868737, -80.600655),
    "26040": (39.985905, -80.719565),
    "26041": (39.916748, -80.737134),
    "26047": (40.522005, -80.571689),
    "26050": (40.608776, -80.613199),
    "26055": (39.877162, -80.694606),
    "26056": (40.516234, -80.592823),
    "26058": (40.27932, -80.599949),
    "26059": (40.081064, -80.59733),
    "26060": (40.078249, -80.589611),
    "26062": (40.507729, -80.565292),
    "26070": (40.293469, -80.594036),
    "26074": (40.169839, -80.595763),
    "26075": (40.192679, -80.665879),
    "26101": (39.286315, -81.55477),
    "26102": (39.218276, -81.497865),
    "26103": (39.236427, -81.540501),
    "26104": (39.28037, -81.493574),
    "26105": (39.324924, -81.538034),
    "26106": (39.218276, -81.497865),
    "26120": (39.218276, -81.497865),
    "26121": (39.218276, -81.497865),
    "26133": (39.155706, -81.736307),
    "26134": (39.375025, -81.263875),
    "26135": (39.450612, -80.870081),
    "26136": (38.828582, -81.132151),
    "26137": (38.828582, -81.132151),
    "26138": (39.040511, -81.371951),
    "26141": (39.040511, -81.371951),
    "26142": (39.216011, -81.48079),
    "26143": (39.032058, -81.380692),
    "26146": (39.496137, -81.057241),
    "26147": (38.921782, -81.093773),
    "26148": (39.198501, -81.068913),
    "26149": (39.494178, -80.907644),
    "26150": (39.189677, -81.513911),
    "26151": (38.828582, -81.132151),
    "26152": (39.040511, -81.371951),
    "26155": (39.611458999999996, -80.817928),
    "26159": (39.606691, -80.929167),
    "26160": (39.040511, -81.371951),
    "26161": (39.198501, -81.068913),
    "26162": (39.575518, -80.666712),
    "26164": (38.98882, -81.713983),
    "26167": (39.575518, -80.666712),
    "26169": (39.218276, -81.497865),
    "26170": (39.408888, -81.20786),
    "26173": (38.95192, -81.709496),
    "26175": (39.541445, -80.975638),
    "26178": (39.198501, -81.068913),
    "26180": (39.218276, -81.497865),
    "26181": (39.206816, -81.65769),
    "26184": (39.322871, -81.401137),
    "26186": (39.575518, -80.666712),
    "26187": (39.367796, -81.455899),
    "26201": (38.975479, -80.240664),
    "26202": (38.318389, -80.834152),
    "26203": (38.522709, -80.607651),
    "26205": (38.329918, -80.645376),
    "26206": (38.423224, -80.564685),
    "26208": (38.387147, -80.590651),
    "26209": (38.387966, -79.990585),
    "26210": (38.899314, -80.226855),
    "26215": (38.899314, -80.226855),
    "26217": (38.601167, -80.465431),
    "26218": (38.899314, -80.226855),
    "26219": (38.899314, -80.226855),
    "26222": (38.645017, -80.432189),
    "26224": (38.89487, -79.850148),
    "26228": (38.899314, -80.226855),
    "26229": (38.899314, -80.226855),
    "26230": (38.75338, -79.814713),
    "26234": (38.899314, -80.226855),
    "26236": (38.899314, -80.226855),
    "26237": (38.864632, -80.21241),
    "26238": (39.125078, -80.017982),
    "26241": (38.846815, -79.892841),
    "26250": (39.022982, -79.932),
    "26253": (38.836615, -79.872553),
    "26254": (38.75338, -79.814713),
    "26257": (38.75338, -79.814713),
    "26259": (38.75338, -79.814713),
    "26260": (39.130056, -79.468329),
    "26261": (38.230265, -80.578921),
    "26263": (38.75338, -79.814713),
    "26264": (38.387966, -79.990585),
    "26266": (38.482539, -80.431111),
    "26267": (38.75338, -79.814713),
    "26268": (38.75338, -79.814713),
    "26269": (39.117906, -79.563678),
    "26270": (38.75338, -79.814713),
    "26271": (39.117906, -79.563678),
    "26273": (38.696059, -79.974846),
    "26275": (38.978405, -79.949417),
    "26276": (38.75338, -79.814713),
    "26278": (38.75338, -79.814713),
    "26280": (38.75338, -79.814713),
    "26282": (38.75338, -79.814713),
    "26283": (39.056458, -79.821443),
    "26285": (38.93074, -79.967754),
    "26287": (39.096016, -79.678724),
    "26288": (38.483244, -80.447555),
    "26289": (39.117906, -79.563678),
    "26291": (38.387966, -79.990585),
    "26292": (39.138003, -79.481555),
    "26293": (38.75338, -79.814713),
    "26294": (38.75338, -79.814713),
    "26296": (38.75338, -79.814713),
    "26298": (38.482539, -80.431111),
    "26301": (39.287434, -80.341883),
    "26302": (39.267736, -80.307718),
    "26306": (39.285204, -80.385344),
    "26320": (39.450612, -80.870081),
    "26321": (39.09078, -80.470734),
    "26323": (39.258671, -80.287544),
    "26325": (39.198501, -81.068913),
    "26327": (39.198501, -81.068913),
    "26328": (39.270846, -80.719742),
    "26330": (39.309303, -80.282306),
    "26332": (39.285204, -80.385344),
    "26334": (39.125078, -80.017982),
    "26335": (38.777546, -80.656974),
    "26337": (39.198501, -81.068913),
    "26338": (39.115329, -80.58037),
    "26339": (39.270846, -80.719742),
    "26342": (38.913649, -80.831256),
    "26343": (38.945847, -80.51449),
    "26346": (39.198501, -81.068913),
    "26347": (39.345364000000004, -80.04977),
    "26348": (39.575518, -80.666712),
    "26349": (39.125078, -80.017982),
    "26350": (38.913649, -80.831256),
    "26351": (38.940946, -80.83133),
    "26354": (39.336266, -80.015686),
    "26361": (39.285204, -80.385344),
    "26362": (39.145318, -81.034061),
    "26366": (39.374487, -80.348925),
    "26369": (39.331202, -80.332455),
    "26372": (38.945847, -80.51449),
    "26374": (39.48274, -79.836968),
    "26375": (39.279818, -80.575379),
    "26376": (38.945847, -80.51449),
    "26377": (39.575518, -80.666712),
    "26378": (39.109143, -80.441713),
    "26384": (38.913649, -80.831256),
    "26385": (39.152121, -80.357602),
    "26386": (39.377263, -80.354173),
    "26404": (39.346214, -80.313875),
    "26405": (39.125078, -80.017982),
    "26407": (39.198501, -81.068913),
    "26408": (39.21751, -80.295772),
    "26410": (39.458091, -79.688154),
    "26411": (39.270846, -80.719742),
    "26412": (38.945847, -80.51449),
    "26415": (39.279104, -81.001944),
    "26416": (39.161343, -80.049182),
    "26419": (39.575518, -80.666712),
    "26421": (39.198501, -81.068913),
    "26422": (39.285204, -80.385344),
    "26424": (39.345364000000004, -80.04977),
    "26425": (39.312958, -79.704927),
    "26426": (39.245329, -80.49102),
    "26430": (38.913649, -80.831256),
    "26431": (39.328705, -80.273372),
    "26434": (39.450612, -80.870081),
    "26435": (39.345364000000004, -80.04977),
    "26436": (39.270846, -80.719742),
    "26437": (39.575518, -80.666712),
    "26438": (39.346511, -80.32056),
    "26440": (39.345364000000004, -80.04977),
    "26443": (38.913649, -80.831256),
    "26444": (39.458091, -79.688154),
    "26447": (38.945847, -80.51449),
    "26448": (39.285204, -80.385344),
    "26451": (39.199606, -80.40256),
    "26452": (39.042331, -80.447878),
    "26456": (39.296522, -80.774491),
    "26461": (39.285204, -80.385344),
    "26463": (39.285204, -80.385344),
    "26501": (39.609911, -79.983141),
    "26502": (39.625302, -79.967184),
    "26503": (39.636606, -79.895639),
    "26504": (39.578512, -80.093007),
    "26505": (39.609596, -79.967623),
    "26506": (39.645276, -79.962669),
    "26507": (39.680786, -79.836473),
    "26508": (39.595329, -79.922871),
    "26519": (39.516364, -79.617653),
    "26520": (39.458091, -79.688154),
    "26521": (39.578512, -80.093007),
    "26522": (39.578512, -80.093007),
    "26524": (39.458091, -79.688154),
    "26525": (39.666293, -79.620241),
    "26527": (39.578512, -80.093007),
    "26529": (39.651628, -80.159737),
    "26531": (39.605344, -79.895832),
    "26533": (39.578512, -80.093007),
    "26534": (39.62764, -79.942937),
    "26535": (39.458091, -79.688154),
    "26537": (39.471673, -79.67596),
    "26541": (39.658416, -80.028814),
    "26542": (39.458091, -79.688154),
    "26543": (39.578512, -80.093007),
    "26544": (39.578512, -80.093007),
    "26546": (39.674575, -80.034965),
    "26547": (39.458091, -79.688154),
    "26554": (39.494115, -80.221282),
    "26555": (39.514343, -80.218538),
    "26559": (39.505155, -80.172524),
    "26560": (39.514343, -80.218538),
    "26561": (39.575518, -80.666712),
    "26562": (39.651148, -80.416065),
    "26563": (39.478198, -80.271988),
    "26566": (39.514343, -80.218538),
    "26568": (39.285204, -80.385344),
    "26570": (39.584289, -80.23895),
    "26571": (39.506654, -80.252582),
    "26572": (39.514343, -80.218538),
    "26574": (39.558696, -80.180468),
    "26575": (39.575518, -80.666712),
    "26576": (39.48774, -80.266588),
    "26578": (39.446631, -80.176171),
    "26581": (39.575518, -80.666712),
    "26582": (39.536663, -80.23996),
    "26585": (39.579171, -80.368694),
    "26586": (39.519136, -80.089673),
    "26587": (39.521541, -80.299082),
    "65440": (37.612779, -91.652493),
    "26588": (39.535089, -80.127883),
    "26589": (39.6572, -80.366185),
    "26590": (39.578512, -80.093007),
    "26591": (39.451967, -80.26255),
    "26601": (38.654141, -80.67597),
    "26610": (38.318389, -80.834152),
    "26611": (38.913649, -80.831256),
    "26612": (38.620506, -80.586148),
    "26615": (38.706017, -80.736884),
    "26617": (38.465777, -81.050662),
    "26618": (38.706017, -80.736884),
    "26619": (38.735774, -80.732359),
    "26621": (38.733696, -80.574704),
    "26623": (38.630462, -80.858859),
    "26624": (38.718522, -80.687337),
    "26627": (38.762122, -80.640614),
    "26629": (38.580977, -80.693054),
    "26631": (38.706017, -80.736884),
    "26634": (38.913649, -80.831256),
    "26636": (38.913649, -80.831256),
    "26638": (38.913649, -80.831256),
    "26639": (38.574978, -80.799944),
    "26641": (38.706017, -80.736884),
    "26651": (38.326251, -80.854096),
    "26656": (38.318389, -80.834152),
    "26660": (38.318389, -80.834152),
    "26662": (38.318389, -80.834152),
    "26667": (38.318389, -80.834152),
    "26671": (38.318389, -80.834152),
    "26674": (38.20125, -81.185153),
    "26675": (38.318389, -80.834152),
    "26676": (38.155842, -80.682702),
    "26678": (38.318389, -80.834152),
    "26679": (38.318389, -80.834152),
    "26680": (38.041293, -81.064784),
    "26681": (38.318389, -80.834152),
    "26684": (38.318389, -80.834152),
    "26690": (38.318389, -80.834152),
    "26691": (38.318389, -80.834152),
    "26704": (39.251133, -78.618258),
    "26705": (39.458091, -79.688154),
    "26707": (38.986974, -79.146211),
    "26710": (39.443055, -78.964749),
    "26711": (39.314071, -78.659428),
    "26714": (39.314071, -78.659428),
    "26716": (39.458091, -79.688154),
    "26717": (39.443055, -78.964749),
    "26719": (39.500536, -78.744739),
    "26720": (39.070601, -79.233536),
    "26722": (39.314071, -78.659428),
    "26726": (39.452686, -78.892554),
    "26731": (39.070601, -79.233536),
    "26734": (39.070601, -79.233536),
    "26739": (39.070601, -79.233536),
    "26743": (39.32047, -79.045902),
    "26750": (39.546831, -78.909518),
    "26753": (39.600736, -78.769112),
    "26755": (39.18471, -78.726985),
    "26757": (39.34487, -78.758487),
    "26761": (39.314071, -78.659428),
    "26763": (39.314071, -78.659428),
    "26764": (39.430634, -79.519679),
    "26767": (39.617003, -78.763194),
    "26801": (38.999518, -78.821226),
    "26802": (38.684692, -79.353564),
    "26804": (38.684692, -79.353564),
    "26807": (38.648787, -79.327196),
    "26808": (39.211295, -78.436258),
    "26810": (38.999518, -78.821226),
    "26812": (38.999518, -78.821226),
    "26814": (38.684692, -79.353564),
    "26815": (38.684692, -79.353564),
    "26817": (39.314071, -78.659428),
    "26818": (38.999518, -78.821226),
    "26823": (39.314071, -78.659428),
    "26824": (39.314071, -78.659428),
    "26833": (39.116709, -79.134177),
    "26836": (39.018679, -78.820561),
    "26838": (38.999518, -78.821226),
    "26845": (38.999518, -78.821226),
    "26847": (38.990838, -79.129301),
    "26851": (39.077365, -78.593865),
    "26852": (39.314071, -78.659428),
    "26855": (39.070601, -79.233536),
    "26865": (39.314071, -78.659428),
    "26866": (38.684692, -79.353564),
    "26884": (38.684692, -79.353564),
    "26886": (38.684692, -79.353564),
    "27006": (35.945381, -80.448686),
    "27007": (36.385903, -80.589507),
    "27009": (36.213266, -80.084667),
    "27010": (36.182975, -80.338662),
    "27011": (36.21397, -80.690386),
    "27012": (36.081218, -80.328298),
    "27013": (35.755719, -80.681056),
    "27014": (35.819175, -80.54826),
    "27016": (36.446831, -80.220095),
    "27017": (36.357619, -80.697202),
    "27018": (36.197851, -80.575334),
    "27019": (36.316152, -80.234934),
    "27020": (36.119371, -80.80111),
    "27021": (36.320179, -80.292174),
    "27022": (36.503292, -80.216866),
    "27023": (36.15511, -80.441566),
    "27024": (36.490434, -80.823878),
    "27025": (36.348831, -79.894851),
    "27027": (36.447936, -79.930301),
    "27028": (35.906241, -80.54609),
    "27030": (36.444303, -80.665406),
    "27031": (36.399366, -80.70809),
    "27040": (36.160959, -80.378143),
    "27041": (36.422632, -80.505421),
    "27042": (36.340817, -80.055357),
    "27043": (36.346198, -80.404421),
    "27045": (36.230211, -80.329602),
    "27046": (36.483901, -80.105319),
    "27047": (36.329166, -80.56777),
    "27048": (36.466883, -79.912823),
    "27049": (36.551332, -80.655786),
    "27050": (36.22358, -80.395517),
    "27051": (36.191405, -80.16357),
    "27052": (36.34518, -80.159989),
    "27053": (36.490659, -80.463069),
    "27054": (35.790116, -80.605096),
    "27055": (36.136665, -80.682984),
    "27094": (36.027482, -80.20728),
    "27098": (36.027482, -80.20728),
    "27099": (36.027482, -80.20728),
    "27101": (36.101817, -80.28762),
    "27102": (36.032304, -80.396168),
    "27103": (36.058599, -80.320965),
    "27104": (36.097952, -80.329096),
    "27105": (36.161935, -80.241287),
    "27106": (36.149337, -80.325815),
    "27107": (36.04803, -80.182863),
    "27108": (36.027482, -80.20728),
    "27109": (36.027482, -80.20728),
    "27110": (36.027482, -80.20728),
    "27111": (36.027482, -80.20728),
    "27113": (36.027482, -80.20728),
    "27114": (36.027482, -80.20728),
    "27115": (36.027482, -80.20728),
    "27116": (36.027482, -80.20728),
    "27117": (36.027482, -80.20728),
    "27120": (36.027482, -80.20728),
    "27127": (36.040815, -80.282645),
    "27130": (36.027482, -80.20728),
    "27150": (36.027482, -80.20728),
    "27151": (36.027482, -80.20728),
    "27152": (36.027482, -80.20728),
    "27155": (36.027482, -80.20728),
    "27156": (36.027482, -80.20728),
    "27157": (36.027482, -80.20728),
    "27198": (36.027482, -80.20728),
    "27199": (36.027482, -80.20728),
    "27201": (36.031836, -79.485643),
    "27202": (36.185517, -79.505479),
    "27203": (35.708376, -79.85213),
    "27204": (35.788286, -79.720556),
    "27207": (35.608354, -79.372362),
    "27208": (35.573086, -79.52309),
    "27209": (35.365836, -79.943839),
    "27212": (36.466412, -79.275549),
    "27213": (35.648194, -79.414859),
    "27214": (36.193624, -79.674079),
    "27215": (36.091025, -79.430129),
    "27216": (36.047523, -79.479743),
    "27217": (36.150681, -79.3944),
    "27220": (36.046677, -79.389631),
    "27228": (35.783476, -79.129791),
    "27229": (35.264204, -79.800002),
    "27230": (35.802758, -79.879711),
    "27231": (36.181138, -79.164741),
    "27233": (35.937583, -79.69325),
    "27235": (36.094489, -80.004721),
    "27237": (35.467567, -79.165314),
    "27239": (35.608108, -80.144554),
    "27242": (35.326471, -79.548614),
    "27243": (36.06984, -79.198764),
    "27244": (36.164963, -79.446213),
    "27247": (35.451411, -79.783404),
    "27248": (35.785766, -79.710068),
    "27249": (36.150393, -79.610426),
    "27252": (35.576848, -79.363115),
    "27253": (35.972114, -79.347527),
    "27256": (35.562695, -79.33863),
    "27258": (36.042367, -79.324239),
    "27259": (35.492077, -79.479016),
    "27260": (35.993538, -79.988711),
    "27261": (36.080707, -80.0244),
    "27262": (35.955786, -80.013043),
    "27263": (35.935894, -79.93955),
    "27264": (36.080707, -80.0244),
    "27265": (36.029892, -79.991542),
    "27278": (36.077432, -79.085469),
    "27281": (35.186814, -79.561566),
    "27282": (35.996926, -79.926902),
    "27283": (35.952564, -79.636747),
    "27284": (36.118312, -80.101271),
    "27285": (36.027482, -80.20728),
    "27288": (36.486369, -79.749957),
    "27289": (36.392135, -79.773094),
    "27291": (36.364834, -79.187938),
    "27292": (35.801894, -80.210762),
    "27293": (35.882943, -80.275963),
    "27294": (35.882943, -80.275963),
    "27295": (35.813292, -80.277877),
    "27298": (35.838293, -79.674436),
    "27299": (35.743919, -80.349473),
    "27301": (36.108629, -79.670689),
    "27302": (36.087114, -79.306093),
    "27305": (36.512445, -79.235356),
    "27306": (35.247617, -79.923328),
    "27310": (36.166822, -79.948214),
    "27311": (36.47025, -79.460025),
    "27312": (35.745239, -79.213195),
    "27313": (35.950913, -79.765959),
    "27314": (36.293921, -79.200365),
    "27315": (36.487281, -79.404114),
    "27316": (35.714279, -79.646945),
    "27317": (35.823611, -79.712537),
    "27320": (36.358275, -79.742001),
    "27321": (36.347568, -79.680318),
    "27322": (36.392135, -79.773094),
    "27323": (36.392135, -79.773094),
    "27325": (35.393319, -79.518562),
    "27326": (36.461083, -79.597001),
    "27330": (35.469782, -79.171723),
    "27331": (35.372577, -79.276577),
    "27340": (35.948814, -79.329664),
    "27341": (35.562753, -79.698691),
    "27342": (36.075623, -79.620641),
    "27343": (36.493537, -79.060407),
    "27344": (35.711578, -79.333922),
    "27349": (35.91485, -79.403671),
    "27350": (35.817452, -79.908483),
    "27351": (35.660548, -80.283647),
    "27355": (35.799927, -79.593442),
    "27356": (35.439894, -79.825137),
    "27357": (36.225751, -79.974028),
    "27358": (36.200019, -79.880028),
    "27359": (36.021389, -79.357399),
    "27360": (35.854539, -80.124764),
    "27361": (35.882943, -80.275963),
    "27370": (35.801501, -79.961118),
    "27371": (35.393595, -79.907346),
    "27373": (35.882943, -80.275963),
    "27374": (35.781848, -80.203546),
    "27375": (36.392135, -79.773094),
    "27376": (35.240268, -79.468201),
    "27377": (36.046202, -79.608882),
    "27379": (36.379479, -79.366733),
    "27401": (36.055285, -79.831692),
    "27402": (36.106711, -79.791901),
    "27403": (36.089396, -79.823336),
    "27404": (36.080707, -80.0244),
    "27405": (36.114003, -79.787099),
    "27406": (35.991647, -79.759794),
    "27407": (36.001791, -79.888672),
    "27408": (36.103685, -79.816254),
    "27409": (36.087534, -79.93439),
    "27410": (36.119984, -79.870925),
    "27411": (36.080707, -80.0244),
    "27412": (36.066129, -79.806735),
    "27413": (36.080707, -80.0244),
    "27415": (36.080707, -80.0244),
    "27416": (36.080707, -80.0244),
    "27417": (36.080707, -80.0244),
    "27419": (36.080707, -80.0244),
    "27420": (36.112987, -79.775913),
    "27425": (36.080707, -80.0244),
    "27427": (36.080707, -80.0244),
    "27429": (36.080707, -80.0244),
    "27435": (36.080707, -80.0244),
    "27438": (36.080707, -80.0244),
    "27455": (36.182391, -79.805975),
    "27480": (36.080707, -80.0244),
    "27495": (36.080707, -80.0244),
    "27498": (36.080707, -80.0244),
    "27499": (36.080707, -80.0244),
    "27501": (35.478164, -78.729411),
    "27502": (35.748012, -78.834012),
    "27503": (36.09206, -78.885147),
    "27504": (35.40709, -78.402967),
    "27505": (35.471966, -79.058238),
    "27506": (35.420467, -78.713729),
    "27507": (36.451463, -78.566691),
    "27508": (35.982555, -78.208581),
    "27509": (36.119588, -78.768421),
    "27510": (35.905477, -79.090077),
    "27511": (35.751243, -78.70732),
    "27512": (35.808387, -78.839488),
    "27513": (35.801341, -78.816564),
    "27514": (36.004647, -79.054475),
    "27515": (36.05251, -79.107692),
    "27516": (35.946263, -79.136862),
    "27518": (35.797692, -78.625265),
    "27519": (35.76812, -78.829548),
    "27520": (35.633257, -78.435416),
    "27521": (35.425247, -78.656553),
    "27522": (36.108089, -78.671974),
    "27524": (35.4282, -78.339839),
    "27525": (36.068066, -78.399881),
    "27526": (35.758691, -78.646886),
    "27529": (35.714139, -78.66304),
    "27530": (35.368277, -78.092871),
    "27531": (35.463121, -77.995728),
    "27532": (35.372045, -78.052422),
    "27533": (35.372045, -78.052422),
    "27534": (35.385571, -78.03207),
    "27536": (36.38698, -78.396213),
    "72853": (35.030397, -93.303203),
    "27540": (35.607666, -78.829724),
    "27541": (36.314975, -79.06404),
    "27542": (35.571141, -78.287178),
    "27543": (35.429849, -78.882395),
    "27544": (36.220048, -78.450087),
    "27545": (35.788031, -78.459605),
    "27546": (35.399221, -78.871194),
    "27549": (36.065143, -78.277943),
    "27551": (36.507009, -77.997521),
    "27552": (35.413579, -78.979964),
    "27553": (36.468871, -78.336604),
    "27555": (35.629518, -78.204968),
    "27556": (36.413473, -78.327491),
    "27557": (35.587186, -78.232745),
    "27559": (35.623508, -79.098782),
    "27560": (35.852458, -78.843526),
    "27562": (35.643693, -78.867658),
    "27563": (36.449642, -78.185544),
    "27564": (36.101529, -78.713346),
    "27565": (36.348168, -78.65313),
    "27568": (35.488348, -78.217864),
    "27569": (35.471193, -78.164309),
    "27570": (36.37367, -78.110931),
    "27571": (35.906468, -78.45482),
    "27572": (36.205828, -78.878578),
    "27573": (36.39165, -78.950937),
    "27576": (35.563572, -78.244459),
    "27577": (35.536543, -78.336001),
    "27581": (36.209675, -78.72704),
    "27582": (36.442431, -78.557098),
    "27583": (36.311201, -78.92292),
    "27584": (36.518058, -78.400865),
    "27586": (36.37367, -78.110931),
    "27587": (35.858041, -78.586534),
    "27588": (35.973108, -78.450754),
    "27589": (36.339089, -78.190028),
    "27591": (35.811324, -78.395966),
    "27592": (35.67238, -78.534929),
    "27593": (35.590731, -78.360723),
    "27594": (36.37367, -78.110931),
    "27596": (36.018749, -78.438181),
    "27597": (35.879220000000004, -78.355582),
    "27599": (36.05251, -79.107692),
    "27601": (35.773755, -78.604175),
    "27602": (35.758667, -78.671089),
    "27603": (35.689086, -78.675118),
    "27604": (35.837111, -78.555342),
    "27605": (35.789601, -78.652475),
    "27606": (35.715972, -78.747741),
    "27607": (35.804237, -78.707101),
    "27608": (35.80895, -78.646238),
    "27609": (35.841146, -78.630413),
    "27610": (35.7429, -78.564443),
    "27611": (35.797692, -78.625265),
    "27612": (35.821942, -78.675135),
    "27613": (35.86952, -78.705465),
    "27614": (35.972686, -78.620292),
    "27615": (35.918893, -78.627455),
    "27616": (35.805765, -78.688301),
    "27619": (35.851463, -78.63141),
    "27620": (35.797692, -78.625265),
    "27621": (35.797692, -78.625265),
    "27622": (35.797692, -78.625265),
    "27623": (35.797692, -78.625265),
    "27624": (35.797692, -78.625265),
    "27625": (35.797692, -78.625265),
    "27626": (35.797692, -78.625265),
    "27627": (35.797692, -78.625265),
    "27628": (35.797692, -78.625265),
    "27629": (35.817497, -78.552388),
    "27634": (35.797692, -78.625265),
    "27635": (35.797692, -78.625265),
    "27636": (35.797692, -78.625265),
    "27640": (35.797692, -78.625265),
    "27650": (35.797692, -78.625265),
    "27656": (35.797692, -78.625265),
    "27658": (35.797692, -78.625265),
    "27661": (35.797692, -78.625265),
    "27668": (35.797692, -78.625265),
    "27675": (35.797692, -78.625265),
    "27676": (35.797692, -78.625265),
    "27690": (35.797692, -78.625265),
    "27695": (35.797692, -78.625265),
    "27697": (35.88224, -78.413371),
    "27698": (35.797692, -78.625265),
    "27699": (35.797692, -78.625265),
    "27701": (36.004307, -78.875467),
    "27702": (36.051155, -78.857651),
    "27703": (35.957366, -78.821694),
    "27704": (36.037132, -78.828086),
    "27705": (36.019354, -78.899525),
    "27706": (35.997043, -78.94223),
    "27707": (35.94816, -78.941599),
    "27708": (36.028685, -78.92398),
    "27709": (36.051155, -78.857651),
    "27710": (36.051155, -78.857651),
    "27711": (36.051155, -78.857651),
    "27712": (36.091848, -78.908043),
    "27713": (35.911215, -78.917768),
    "27715": (36.051155, -78.857651),
    "27717": (36.051155, -78.857651),
    "27722": (36.051155, -78.857651),
    "27801": (35.949051, -77.641181),
    "27802": (35.935563, -77.78077),
    "27803": (35.902088, -77.874947),
    "27804": (35.941739, -77.939841),
    "27805": (36.169398, -77.097225),
    "27806": (35.373666, -76.861978),
    "27807": (35.800198, -78.10562),
    "27808": (35.469911, -76.756914),
    "27809": (36.006705, -77.707389),
    "27810": (35.445752, -76.639119),
    "27811": (35.584685, -77.513357),
    "27812": (35.757803, -77.39351),
    "27813": (35.616471, -77.935161),
    "27814": (35.500693, -76.977521),
    "27816": (36.09786, -78.03876),
    "27817": (35.460458, -77.063047),
    "27818": (36.491011, -77.031055),
    "27819": (35.817763, -77.453286),
    "27820": (36.450554, -77.452452),
    "27821": (35.327785, -76.872371),
    "27822": (35.787273, -77.856015),
    "27823": (36.279884, -77.723443),
    "27824": (35.325223, -76.028472),
    "27825": (35.866711, -77.084958),
    "27826": (35.510544, -76.179248),
    "27827": (35.693518, -77.511147),
    "27828": (35.663061, -77.456086),
    "27829": (35.687351, -77.59113),
    "27830": (35.469355, -77.979026),
    "27831": (36.482084, -77.568112),
    "27832": (36.417965, -77.441731),
    "27833": (35.580444, -77.392609),
    "27834": (35.631003, -77.381019),
    "27835": (35.588523, -77.353092),
    "27836": (35.580444, -77.392609),
    "27837": (35.506325, -77.214568),
    "27838": (36.356129, -77.483072),
    "27839": (36.33719, -77.629192),
    "27840": (35.963174, -77.223554),
    "27841": (35.906104, -77.273825),
    "27842": (36.525838, -77.8555),
    "27843": (36.059381, -77.406093),
    "27844": (36.237677, -77.706792),
    "27845": (36.374826, -77.370513),
    "27846": (35.805568, -76.997456),
    "27847": (36.187122, -77.189818),
    "27849": (36.093332, -77.143875),
    "27850": (36.376924, -77.709017),
    "27851": (35.674077, -78.026484),
    "27852": (35.750972, -77.670582),
    "27853": (36.356129, -77.483072),
    "27854": (36.363144, -77.386748),
    "27855": (36.449543, -77.052051),
    "27856": (36.02049, -77.982782),
    "27857": (35.970377, -77.251106),
    "27858": (35.616949, -77.402789),
    "27860": (35.610477, -76.717723),
    "27861": (35.819037, -77.314288),
    "27862": (36.356129, -77.483072),
    "27863": (35.488295, -77.972713),
    "27864": (35.793, -77.633263),
    "27865": (35.574633, -76.776212),
    "27866": (36.5044, -77.55694),
    "27867": (36.356129, -77.483072),
    "27868": (36.054832, -77.911635),
    "27869": (36.31037, -77.318446),
    "27870": (36.303962, -77.641063),
    "27871": (35.834564, -77.248489),
    "27872": (36.216644, -77.222348),
    "27873": (35.649494, -77.791845),
    "27874": (36.23245, -77.608355),
    "27875": (35.471657, -76.495091),
    "27876": (36.490454, -77.442173),
    "27877": (36.356129, -77.483072),
    "27878": (35.865387, -77.838886),
    "27879": (35.567478, -77.280169),
    "27880": (35.738821, -78.10039),
    "27881": (35.915926999999996, -77.585471),
    "27882": (35.94476, -78.093002),
    "27883": (35.656386, -77.805965),
    "27884": (35.711302, -77.266682),
    "27885": (35.465559, -76.271685),
    "27886": (35.928437, -77.581631),
    "27887": (36.235198, -77.502602),
    "27888": (35.609289, -77.713073),
    "27889": (35.519268, -76.8892),
    "27890": (36.389174, -77.750353),
    "27891": (36.124661, -77.825049),
    "27892": (35.821205, -77.102193),
    "27893": (35.723264, -77.925269),
    "27894": (35.715778, -77.904283),
    "27895": (35.719923, -77.926691),
    "27896": (35.771467, -77.973007),
    "27897": (36.393691, -77.313667),
    "27906": (36.285388, -76.213284),
    "27907": (36.285026, -76.255312),
    "27909": (36.293633, -76.271958),
    "27910": (36.339311, -76.990498),
    "27915": (35.776474, -75.635823),
    "27916": (36.307995, -75.918814),
    "27917": (36.370898, -75.989967),
    "27919": (36.257499, -76.544379),
    "27920": (35.252534, -75.572155),
    "27921": (36.389961, -76.199736),
    "27922": (36.360803, -76.905529),
    "27923": (36.383368, -75.954658),
    "27924": (36.152409, -76.852518),
    "27925": (35.936934, -76.203339),
    "27926": (36.520104, -76.59285),
    "27927": (36.391941, -75.825512),
    "27928": (35.829692, -76.567703),
    "27929": (36.439774, -76.005478),
    "27930": (36.198539, -76.373908),
    "27932": (36.135621, -76.580107),
    "27935": (36.416392, -76.797951),
    "27936": (35.233846, -75.614493),
    "27937": (36.493521, -76.815386),
    "27938": (36.422539, -76.714802),
    "27939": (36.293128, -75.975578),
    "27941": (36.157985, -75.833856),
    "27942": (36.274551, -76.786498),
    "27943": (35.692774, -75.713785),
    "27944": (36.168529, -76.373128),
    "27946": (36.365847, -76.625361),
    "27947": (36.171411, -75.862128),
    "27948": (35.772912, -75.634892),
    "27949": (36.083688, -75.696557),
    "27950": (36.427047, -75.976651),
    "27953": (35.823791, -75.846714),
    "27954": (35.950867, -75.681122),
    "27956": (36.401953, -75.997651),
    "27957": (36.113612, -76.912879),
    "27958": (36.399081, -76.064702),
    "27959": (36.02153, -75.661879),
    "27960": (35.355633, -76.187429),
    "27962": (35.818681, -76.609454),
    "27964": (36.084092, -75.804485),
    "27965": (36.273673, -75.909652),
    "27966": (36.201721, -75.865772),
    "27967": (36.164672, -76.967234),
    "27968": (35.692774, -75.713785),
    "27969": (36.424152, -76.702125),
    "27970": (35.835272, -76.554122),
    "27972": (35.554569, -75.469319),
    "27973": (36.400991, -76.09242),
    "27974": (36.239776, -76.022486),
    "27976": (36.455346, -76.280026),
    "27978": (35.698493, -75.772775),
    "27979": (36.434329, -76.620014),
    "27980": (36.249278, -76.630775),
    "27981": (35.862175, -75.643747),
    "27982": (35.559564, -75.465858),
    "27983": (36.039911, -76.936954),
    "27985": (36.219345, -76.466689),
    "27986": (36.418251, -76.954858),
    "28001": (35.319817, -80.253448),
    "28002": (35.264179, -80.108188),
    "28006": (35.365255, -81.087967),
    "28007": (35.021874, -80.085232),
    "28009": (35.41569, -80.159356),
    "28010": (35.719228, -80.89909),
    "28012": (35.278438, -81.197088),
    "28016": (35.319564, -81.234751),
    "28017": (35.254876, -81.691402),
    "28018": (35.440832, -81.789415),
    "28019": (35.316793, -81.831944),
    "28020": (35.519973, -81.627064),
    "28021": (35.306707, -81.236958),
    "28023": (35.571468, -80.596523),
    "28024": (35.241615, -81.775456),
    "28025": (35.371633, -80.562141),
    "28026": (35.346285, -80.541088),
    "28027": (35.410688, -80.658405),
    "28031": (35.473286, -80.872585),
    "28032": (35.314194, -81.134336),
    "28033": (35.435922, -81.33848),
    "28034": (35.349898, -81.221463),
    "28036": (35.283427, -80.844594),
    "28037": (35.486134, -81.0553),
    "28038": (35.196998, -81.538645),
    "28039": (35.677889, -80.44593),
    "28040": (35.382054, -81.774),
    "28041": (35.58167, -80.45806),
    "28042": (35.373884, -81.543706),
    "28043": (35.325025, -81.846013),
    "28052": (35.267916, -81.178725),
    "28053": (35.275073, -81.213369),
    "28054": (35.249452, -81.133003),
    "28055": (35.284018, -81.189693),
    "28056": (35.242038, -81.169072),
    "28070": (35.462187, -80.898668),
    "28071": (35.547494, -80.310215),
    "28072": (35.610921, -80.436124),
    "28073": (35.204027, -81.471909),
    "28074": (35.224743, -81.885081),
    "28075": (35.353672, -80.672368),
    "28076": (35.226581, -81.795027),
    "28077": (35.404157, -81.194174),
    "28078": (35.401071, -80.869457),
    "28079": (35.115644, -80.597878),
    "28080": (35.472855, -81.106202),
    "28081": (35.462981, -80.672531),
    "28082": (35.346285, -80.541088),
    "28083": (35.476586, -80.571498),
    "28086": (35.296207, -81.491436),
    "28088": (35.545428, -80.608038),
    "28089": (35.308726, -81.661675),
    "28090": (35.433739, -81.569729),
    "28091": (34.967043, -79.98678),
    "28092": (35.485145, -81.181799),
    "28093": (35.484822, -81.239543),
    "28097": (35.262131, -80.424512),
    "28098": (35.262444, -81.097965),
    "28101": (35.26749, -81.09104),
    "28102": (34.813634, -79.97756),
    "28103": (34.997268, -80.364223),
    "28104": (35.089042, -80.704424),
    "28105": (35.114887, -80.704991),
    "28106": (35.26002, -80.804151),
    "28107": (35.250608, -80.535601),
    "28108": (34.916253, -80.640383),
    "28109": (35.480124, -80.270445),
    "28110": (35.074176, -80.527827),
    "28111": (35.011204, -80.558743),
    "28112": (34.901591, -80.527201),
    "28114": (35.256702, -81.700869),
    "28115": (35.688136, -80.819825),
    "28117": (35.583962, -80.868463),
    "28119": (34.921646, -80.135131),
    "28120": (35.318697, -81.026738),
    "28123": (35.529792, -80.947028),
    "28124": (35.416779, -80.416474),
    "28125": (35.656287, -80.701616),
    "28126": (35.276794, -80.716495),
    "28127": (35.44125, -80.225068),
    "28128": (35.30281, -80.196863),
    "28129": (35.240666, -80.319154),
    "28130": (35.26002, -80.804151),
    "28133": (35.011107, -80.255799),
    "28134": (35.07854, -80.891141),
    "28135": (35.023262, -80.210985),
    "28136": (35.396126, -81.630272),
    "28137": (35.454142, -80.283764),
    "28138": (35.541642, -80.455915),
    "28139": (35.339729, -82.004874),
    "28144": (35.680441, -80.45316),
    "28145": (35.682683, -80.477116),
    "28146": (35.618694, -80.402235),
    "28147": (35.681714, -80.561516),
    "28150": (35.312012, -81.556777),
    "28151": (35.233125, -81.574711),
    "28152": (35.329336, -81.580919),
    "28159": (35.691689, -80.432679),
    "28160": (35.354511, -81.9211),
    "28163": (35.258365, -80.415177),
    "28164": (35.329185, -81.057419),
    "28166": (35.679407, -80.898817),
    "28167": (35.486941, -81.975821),
    "28168": (35.521229, -81.418729),
    "28169": (35.35289, -81.425111),
    "28170": (34.924469, -80.05003),
    "28173": (34.925105, -80.72775),
    "28174": (34.964812, -80.427656),
    "28201": (35.26002, -80.804151),
    "28202": (35.226192, -80.843493),
    "28203": (35.208992, -80.856343),
    "28204": (35.215342, -80.828706),
    "28205": (35.325959, -80.827444),
    "28206": (35.250841, -80.820091),
    "28207": (35.195393, -80.826393),
    "28208": (35.209125, -80.92175),
    "28209": (35.174351, -80.853396),
    "28210": (35.156753, -80.851319),
    "28211": (35.169586, -80.79076),
    "28212": (35.186185, -80.749617),
    "28213": (35.283599, -80.763757),
    "28214": (35.279945, -80.864057),
    "28215": (35.246597, -80.788726),
    "28216": (35.298775, -80.895731),
    "28217": (35.133618, -80.963642),
    "28218": (35.26002, -80.804151),
    "28219": (35.26002, -80.804151),
    "28220": (35.26002, -80.804151),
    "28221": (35.26002, -80.804151),
    "28222": (35.26002, -80.804151),
    "28223": (35.304093, -80.726687),
    "28224": (35.26002, -80.804151),
    "28225": (35.26002, -80.804151),
    "28226": (35.108637, -80.82747),
    "28227": (35.136591, -80.711197),
    "28228": (35.26002, -80.804151),
    "28229": (35.26002, -80.804151),
    "28230": (35.26002, -80.804151),
    "28231": (35.26002, -80.804151),
    "28232": (35.26002, -80.804151),
    "28233": (35.489411, -80.825368),
    "28234": (35.26002, -80.804151),
    "28235": (35.26002, -80.804151),
    "28236": (35.26002, -80.804151),
    "28237": (35.26002, -80.804151),
    "28240": (35.26002, -80.804151),
    "28241": (35.26002, -80.804151),
    "28242": (35.26002, -80.804151),
    "28243": (35.26002, -80.804151),
    "28244": (35.26002, -80.804151),
    "28246": (35.227542, -80.842543),
    "28247": (35.065595, -80.851149),
    "28250": (35.26002, -80.804151),
    "28253": (35.26002, -80.804151),
    "28254": (35.26002, -80.804151),
    "28255": (35.26002, -80.804151),
    "28256": (35.26002, -80.804151),
    "28258": (35.26002, -80.804151),
    "28260": (35.26002, -80.804151),
    "28261": (35.26002, -80.804151),
    "28262": (35.318311, -80.747559),
    "28265": (35.26002, -80.804151),
    "28266": (35.284459, -80.858155),
    "28269": (35.331981, -80.798583),
    "28270": (35.112999, -80.762565),
    "28272": (35.26002, -80.804151),
    "28273": (35.128678, -80.933793),
    "28274": (35.187943, -80.831693),
    "28275": (35.26002, -80.804151),
    "28277": (35.055216, -80.819488),
    "28278": (35.20724, -80.956766),
    "28280": (35.26002, -80.804151),
    "28281": (35.26002, -80.804151),
    "28282": (35.224242, -80.844743),
    "28283": (35.26002, -80.804151),
    "28284": (35.26002, -80.804151),
    "28285": (35.26002, -80.804151),
    "28286": (35.26002, -80.804151),
    "28287": (35.26002, -80.804151),
    "28288": (35.26002, -80.804151),
    "28289": (35.26002, -80.804151),
    "28290": (35.26002, -80.804151),
    "28296": (35.225242, -80.845843),
    "28297": (35.26002, -80.804151),
    "28299": (35.26002, -80.804151),
    "28301": (35.053416, -78.781027),
    "28302": (35.034307, -78.908828),
    "28303": (35.074168, -78.964952),
    "28304": (35.020629, -78.99091),
    "28305": (35.050713, -78.906552),
    "28306": (34.942986, -78.884801),
    "28307": (35.140193, -78.987942),
    "28308": (35.173377, -79.013799),
    "28309": (35.039726, -78.842868),
    "28310": (35.050612, -78.80384),
    "28311": (35.156447, -78.912281),
    "28314": (35.05425, -79.011328),
    "28315": (35.203802, -79.517795),
    "28318": (35.066726, -78.590479),
    "28319": (34.595364000000004, -79.197058),
    "28320": (34.621027, -78.725506),
    "28323": (35.312764, -78.914817),
    "28325": (35.141931, -78.099221),
    "28326": (35.310584, -79.347244),
    "28327": (35.32304, -79.428264),
    "28328": (35.006676, -78.415415),
    "28329": (34.994005, -78.277669),
    "28330": (34.974434, -79.79851),
    "28331": (35.150896, -78.915788),
    "28332": (34.64374, -78.737402),
    "28333": (35.266919, -78.025587),
    "28334": (35.325672, -78.693354),
    "28335": (35.350774, -78.625362),
    "28337": (34.660959, -78.621643),
    "28338": (35.095959, -79.714244),
    "28339": (35.330059, -78.705859),
    "28340": (34.623018, -79.148832),
    "28341": (35.105419, -78.102083),
    "28342": (35.210565, -78.649602),
    "28343": (34.795061, -79.577405),
    "28344": (35.194383, -78.678821),
    "28345": (34.937085, -79.649111),
    "28347": (35.035103, -79.551692),
    "28348": (34.921277, -78.93292),
    "28349": (35.015157, -77.896863),
    "28350": (35.230608, -79.315694),
    "28351": (34.77465, -79.571125),
    "28352": (34.796929, -79.475606),
    "28353": (34.781768, -79.482423),
    "28355": (35.467567, -79.165314),
    "28356": (35.218025, -78.783749),
    "28357": (34.778165, -79.163606),
    "28358": (34.631016, -79.106224),
    "28359": (34.607669, -79.014425),
    "28360": (34.669719, -79.108363),
    "28361": (35.02363, -79.246841),
    "28362": (34.379114, -79.127936),
    "28363": (34.97281, -79.61268),
    "28364": (34.711437, -79.318072),
    "28365": (35.229061, -78.09006),
    "28366": (35.14936, -78.333526),
    "28367": (35.162723, -79.73794),
    "28368": (35.322949, -79.107381),
    "28369": (34.473204, -79.034509),
    "28370": (35.216222, -79.452352),
    "28371": (34.896504, -78.99298),
    "28372": (34.716443, -79.127951),
    "28373": (35.100733, -79.466296),
    "28374": (35.211461, -79.413311),
    "28375": (34.471259, -79.041388),
    "28376": (34.953431, -79.233178),
    "28377": (34.700472, -79.113936),
    "28378": (34.854316, -79.064165),
    "28379": (34.974134, -79.724173),
    "28380": (34.994152, -79.767341),
    "28382": (35.00116, -78.451568),
    "28383": (34.665311, -79.196744),
    "28384": (34.797081, -78.968753),
    "28385": (35.045096, -78.508895),
    "28386": (34.765637, -79.031674),
    "28387": (35.218064, -79.394988),
    "28388": (35.280335, -79.432734),
    "28390": (35.189079, -78.977243),
    "28391": (35.030903, -78.700219),
    "28392": (34.745753, -78.809292),
    "28393": (34.984688, -78.198087),
    "28394": (35.230348, -79.337956),
    "28395": (35.142518, -78.745001),
    "28396": (34.903601, -79.404128),
    "28398": (35.01803, -78.031022),
    "28399": (34.762175, -78.679332),
    "28401": (34.163503, -77.95481),
    "28402": (34.340518, -77.901408),
    "28403": (34.139742, -77.870418),
    "28404": (33.926255, -78.07127),
    "28405": (34.184682, -77.836109),
    "28406": (34.088079, -77.852599),
    "28407": (34.088079, -77.852599),
    "28408": (34.212707, -77.792177),
    "28409": (34.13637, -77.862667),
    "28410": (34.088079, -77.852599),
    "28411": (34.303335, -77.803856),
    "28412": (34.127458, -77.91859),
    "28420": (34.06493, -78.494942),
    "28421": (34.510936, -78.094517),
    "28422": (34.017181, -78.172242),
    "28423": (34.275295, -78.350029),
    "28424": (34.290716, -78.699417),
    "28425": (34.546108, -77.937122),
    "28428": (34.035151, -77.895702),
    "28429": (34.329932, -77.887477),
    "28430": (34.301907, -78.725768),
    "28431": (34.316747, -78.891483),
    "28432": (34.165516, -78.789061),
    "28433": (34.529167, -78.592149),
    "28434": (34.471042, -78.477201),
    "28435": (34.441229, -78.115064),
    "28436": (34.283839, -78.260664),
    "28438": (34.420379, -78.894652),
    "28439": (34.278093, -78.987194),
    "28441": (34.822898, -78.323226),
    "28442": (34.337401, -78.652989),
    "28443": (34.391419, -77.658725),
    "28444": (34.711792, -78.26273),
    "28445": (34.527983, -77.514707),
    "28446": (34.83661, -78.348111),
    "28447": (34.623287, -78.234209),
    "28448": (34.497157, -78.322339),
    "28449": (33.986817, -77.920117),
    "28450": (34.345825, -78.751361),
    "28451": (34.245499, -78.083622),
    "28452": (33.997292, -78.554121),
    "28453": (34.885139, -78.034098),
    "28454": (34.659359, -77.711665),
    "28455": (34.117032, -78.690122),
    "28456": (34.353063, -78.24873),
    "28457": (34.477635, -77.816971),
    "28458": (34.829225, -78.022982),
    "28459": (33.933388, -78.412864),
    "28460": (34.60694, -77.426164),
    "28461": (33.966293, -78.238126),
    "28462": (34.002551, -78.223678),
    "28463": (34.153412, -78.635372),
    "28464": (34.778119, -77.967075),
    "28465": (34.090202, -78.127035),
    "28466": (34.76743, -77.940027),
    "28467": (33.911953, -78.395641),
    "28468": (33.945533, -78.327029),
    "28469": (33.936658, -78.271319),
    "28470": (33.992923, -78.311346),
    "28471": (34.613953, -78.03154),
    "28472": (34.262252, -78.625479),
    "28478": (34.67509, -78.044929),
    "28479": (34.155253, -78.055776),
    "28480": (34.214489, -77.859467),
    "28501": (35.220079, -77.615508),
    "28502": (35.288558, -77.662614),
    "28503": (35.319066, -77.595034),
    "28504": (35.205977, -77.657605),
    "28508": (35.103676, -77.824959),
    "28509": (35.156145, -76.632264),
    "28510": (35.034156, -76.798574),
    "28511": (34.873922, -76.587097),
    "28512": (34.741717, -76.755456),
    "28513": (35.463405, -77.359224),
    "28515": (35.13584, -76.70564),
    "28516": (34.753777, -76.610744),
    "28518": (34.895292, -77.785362),
    "28519": (35.129461, -77.01996),
    "28520": (34.873922, -76.587097),
    "28521": (34.897753, -77.77497),
    "28522": (35.005079, -77.523102),
    "28523": (35.229878, -77.304943),
    "28524": (34.873922, -76.587097),
    "28525": (35.134409, -77.688191),
    "28526": (35.255441, -77.364631),
    "28527": (35.226396, -77.020149),
    "28528": (34.873922, -76.587097),
    "28529": (35.090185, -76.828552),
    "28530": (35.440556, -77.399501),
    "28531": (34.873922, -76.587097),
    "28532": (35.028677, -77.053443),
    "28533": (34.903793, -76.899976),
    "28537": (35.266039, -76.577201),
    "28538": (35.421956, -77.591228),
    "28539": (34.709544, -77.222926),
    "28540": (34.726587, -77.414673),
    "28541": (34.692056, -77.391199),
    "28542": (34.664035, -77.463687),
    "28543": (34.736045, -77.382049),
    "28544": (34.622794999999996, -77.417426),
    "28545": (34.692056, -77.391199),
    "28546": (34.720825, -77.444847),
    "28547": (34.690934, -77.361429),
    "28551": (35.215944, -77.631048),
    "28552": (35.282911, -76.583839),
    "28553": (34.873922, -76.587097),
    "28554": (35.49993, -77.651024),
    "28555": (34.934067, -77.280066),
    "28556": (35.122377, -76.671887),
    "28557": (34.727798, -76.770987),
    "28560": (35.098109, -77.178429),
    "28561": (35.103736, -77.07585),
    "28562": (35.116959, -77.190548),
    "28563": (35.110855, -77.06336),
    "28564": (35.110855, -77.06336),
    "28570": (34.766818, -76.878174),
    "28571": (35.053819, -76.723675),
    "28572": (35.057332, -77.694287),
    "28573": (35.009751, -77.240202),
    "28574": (34.860048, -77.581206),
    "28575": (34.873922, -76.587097),
    "28577": (34.873922, -76.587097),
    "28578": (35.217099, -77.897418),
    "28579": (34.873922, -76.587097),
    "28580": (35.428349, -77.701329),
    "28581": (34.873922, -76.587097),
    "28582": (34.873922, -76.587097),
    "28583": (35.156145, -76.632264),
    "28584": (34.776677, -77.173963),
    "28585": (35.057695, -77.431386),
    "28586": (35.31313, -77.177912),
    "28587": (35.191279, -76.660435),
    "28589": (34.873922, -76.587097),
    "28590": (35.47461, -77.327423),
    "28594": (34.695016, -76.862415),
    "28601": (35.758221, -81.308224),
    "28602": (35.661511, -81.269348),
    "28603": (35.679876, -81.287181),
    "28604": (36.072025, -81.910144),
    "28605": (36.163862, -81.714505),
    "28606": (36.122485, -81.23358),
    "28607": (36.222156, -81.699784),
    "28608": (36.221334, -81.713416),
    "28609": (35.684978, -81.044672),
    "28610": (35.730213, -81.12693),
    "28611": (35.994554, -81.726617),
    "28612": (35.689483, -81.538697),
    "28613": (35.740848, -81.209458),
    "28615": (36.464673, -81.596886),
    "28616": (36.059123, -81.889238),
    "28617": (36.494803, -81.385406),
    "28618": (36.207343, -81.541072),
    "28619": (35.717868, -81.640557),
    "28621": (36.318035, -80.799944),
    "28622": (36.185475, -81.919892),
    "28623": (36.520689, -80.983323),
    "28624": (36.114413, -81.412744),
    "28625": (35.790866, -80.89757),
    "28626": (36.330187, -81.508408),
    "28627": (36.470469, -81.006386),
    "28628": (35.721174, -81.817998),
    "28629": (36.348613, -81.374732),
    "28630": (35.834865, -81.454664),
    "28631": (36.545329, -81.41463),
    "28633": (35.937564, -81.539847),
    "28634": (35.964392, -80.777838),
    "28635": (36.308091, -81.116941),
    "28636": (35.938931, -81.149233),
    "28637": (35.727107, -81.497816),
    "28638": (35.839777, -81.479726),
    "28640": (36.403558, -81.414753),
    "28641": (35.938422, -81.884521),
    "28642": (36.210523, -80.801365),
    "28643": (36.502581, -81.553069),
    "28644": (36.422183, -81.300052),
    "28645": (35.947401, -81.560742),
    "28646": (36.040964, -81.917716),
    "28647": (35.779182, -81.675545),
    "28649": (36.307698, -81.200766),
    "28650": (35.588869, -81.162793),
    "28651": (36.241997, -81.224811),
    "28652": (36.086466, -81.934265),
    "28653": (36.065053, -81.901715),
    "28654": (36.100492, -81.165221),
    "28655": (35.772992, -81.676229),
    "28656": (36.238438, -81.045963),
    "28657": (36.059029, -81.930337),
    "28658": (35.631914, -81.17193),
    "28659": (36.208773, -81.067495),
    "28660": (35.974905, -80.864673),
    "28661": (35.99726, -81.562609),
    "28662": (36.085582, -81.876049),
    "28663": (36.527637, -81.301935),
    "28664": (36.044098, -82.003691),
    "28665": (36.223349, -81.179412),
    "28666": (35.73005, -81.495395),
    "28667": (35.777241, -81.43023),
    "28668": (36.398983, -80.987489),
    "28669": (36.227255, -80.998644),
    "28670": (36.20083, -80.929782),
    "28671": (35.74858, -81.563674),
    "28672": (36.414156, -81.492983),
    "28673": (35.603076, -80.997147),
    "28674": (36.216247, -81.207166),
    "28675": (36.495157, -81.140955),
    "28676": (36.336635, -80.852275),
    "28677": (35.773406, -80.901036),
    "28678": (35.88313, -81.162749),
    "28679": (36.254958, -81.83579399999999),
    "28680": (35.750657, -81.695292),
    "28681": (35.916914, -81.209656),
    "28682": (35.579418, -80.968153),
    "28683": (36.346341, -80.989986),
    "28684": (36.340991, -81.579496),
    "28685": (36.331988, -81.031598),
    "28687": (35.529792, -80.947028),
    "28688": (35.529792, -80.947028),
    "28689": (36.029749, -80.887909),
    "28690": (35.737757, -81.6166),
    "28691": (36.209158, -81.778871),
    "28692": (36.266185, -81.802644),
    "28693": (36.455704, -81.572935),
    "28694": (36.359734, -81.484857),
    "28697": (36.211148, -81.129235),
    "28698": (36.324526, -81.739308),
    "28699": (35.831037, -81.00762),
    "28701": (35.628016, -82.556751),
    "28702": (35.409905, -83.479397),
    "28704": (35.589686, -82.541808),
    "28705": (36.038317, -82.205783),
    "28707": (35.430091, -83.092783),
    "28708": (35.205962, -82.898272),
    "28709": (35.71628, -82.529787),
    "28710": (35.4319, -82.544826),
    "28711": (35.564616, -82.461196),
    "28712": (35.174351, -82.753971),
    "28713": (35.38563, -83.508554),
    "28714": (35.835649, -82.268193),
    "28715": (35.535096, -82.529962),
    "28716": (35.492743, -82.959555),
    "28717": (35.101156, -83.093769),
    "28718": (35.15081, -82.63735199999999),
    "28719": (35.494881, -83.34906),
    "28720": (35.436893, -82.241744),
    "28721": (35.637588, -82.978588),
    "28722": (35.261201, -82.123534),
    "28723": (35.249256, -83.132409),
    "28724": (35.295403, -82.388325),
    "28725": (35.373461, -83.259211),
    "28726": (35.313136, -82.442057),
    "28727": (35.322276, -82.503226),
    "28728": (35.498797, -82.708024),
    "28729": (35.31252, -82.587192),
    "28730": (35.529188, -82.404704),
    "28731": (35.297055, -82.403731),
    "28732": (35.370666, -82.494647),
    "28733": (35.423135, -83.779522),
    "28734": (35.155829, -83.422421),
    "28735": (35.322276, -82.503226),
    "28736": (35.230342, -83.107379),
    "28737": (35.738725, -82.059494),
    "28738": (35.468264, -83.002841),
    "28739": (35.318016, -82.45034),
    "28740": (35.89163, -82.319283),
    "28741": (35.123767, -83.419534),
    "28742": (35.333332, -82.524772),
    "28743": (35.808232, -82.752619),
    "28744": (35.117299, -83.295244),
    "28745": (35.56115, -83.013022),
    "28746": (35.463527, -82.183853),
    "28747": (35.157059, -82.826781),
    "28748": (35.579969, -82.683175),
    "28749": (35.738725, -82.059494),
    "28750": (35.236179, -82.236198),
    "28751": (35.527318, -83.036558),
    "28752": (35.684187, -82.034672),
    "28753": (35.859719, -82.710523),
    "28754": (35.879456, -82.516228),
    "28755": (35.83924, -82.196202),
    "28756": (35.336371, -82.158975),
    "28757": (35.641473, -82.315637),
    "28758": (35.371065, -82.49375),
    "28760": (35.381677, -82.481257),
    "28761": (35.669058, -81.906612),
    "28762": (35.616257, -82.148319),
    "28763": (35.051539, -83.38539),
    "28765": (35.921862, -82.110672),
    "28766": (35.260991, -82.644584),
    "28768": (35.231828, -82.748346),
    "28770": (35.618596, -82.30048),
    "28771": (35.343758, -83.773869),
    "28772": (35.159152, -82.83832),
    "28773": (35.257579, -82.288029),
    "28774": (35.097862, -82.988872),
    "28775": (35.03107, -83.327411),
    "28776": (35.483482, -82.520707),
    "28777": (35.91464, -82.07647),
    "28778": (35.608576, -82.453107),
    "28779": (35.275674, -83.187963),
    "28781": (35.219991, -83.785397),
    "28782": (35.279322, -82.179654),
    "28783": (35.246573, -83.044292),
    "28784": (35.217377, -82.417819),
    "28786": (35.585619, -82.959617),
    "28787": (35.702704, -82.588915),
    "28788": (35.328533, -83.233302),
    "28789": (35.423045, -83.263368),
    "28790": (35.208041, -82.488614),
    "28791": (35.346415, -82.525027),
    "28792": (35.317413, -82.450455),
    "28793": (35.292714, -82.503611),
    "28801": (35.602711, -82.567281),
    "28802": (35.623732, -82.667132),
    "28803": (35.573619, -82.580635),
    "28804": (35.624512, -82.589146),
    "28805": (35.615785, -82.517148),
    "28806": (35.570357, -82.605913),
    "28810": (35.620335, -82.528558),
    "28813": (35.50042, -82.502644),
    "28814": (35.664752, -82.492664),
    "28815": (35.620335, -82.528558),
    "28816": (35.620335, -82.528558),
    "28901": (35.170731, -83.87111),
    "28902": (35.025885, -83.878025),
    "28903": (35.094379, -84.035916),
    "28904": (35.071416, -83.778309),
    "28905": (35.14641, -83.902545),
    "28906": (35.131159, -84.038776),
    "28909": (35.015083, -83.905055),
    "29001": (33.685155, -80.190733),
    "29002": (34.126535, -81.234811),
    "29003": (33.206294, -80.973559),
    "29006": (33.871866, -81.414643),
    "29009": (34.436891, -80.532238),
    "29010": (34.207324, -80.306569),
    "29014": (34.596281, -81.083171),
    "29015": (34.41478, -81.270211),
    "29016": (34.104758, -80.918919),
    "29018": (33.341855, -80.565482),
    "29020": (34.313477, -80.612489),
    "29030": (33.570316, -80.708141),
    "29031": (34.567049, -81.481439),
    "29032": (34.35723, -80.54149),
    "29033": (33.868493, -81.294081),
    "29036": (34.135909, -81.334355),
    "29037": (34.221772, -81.872428),
    "29038": (33.381696, -80.956389),
    "29039": (33.417322, -80.91752),
    "29040": (34.025111, -80.478151),
    "29041": (33.688373, -80.208109),
    "29042": (33.237543, -81.104895),
    "29044": (33.992252, -80.94791),
    "29045": (34.19522, -80.79861),
    "29046": (34.15998, -80.240955),
    "29047": (33.496664, -80.582264),
    "29048": (33.416449, -80.402308),
    "29051": (33.688373, -80.208109),
    "29052": (33.84642, -80.733782),
    "29053": (33.815305, -81.104235),
    "29054": (33.925422, -81.410107),
    "29055": (34.612456, -80.940759),
    "29056": (33.785465, -79.832218),
    "29058": (34.588803, -80.718482),
    "29059": (33.349458, -80.438902),
    "29061": (33.920355, -80.823),
    "29062": (34.012593, -80.567589),
    "29063": (34.085949, -81.131151),
    "29065": (34.301089, -81.285308),
    "29067": (34.600417, -80.542015),
    "29069": (34.269558, -80.005897),
    "29070": (33.895434, -81.423918),
    "29071": (33.925183, -81.248345),
    "29072": (33.976907, -81.253034),
    "29073": (33.905323, -81.335083),
    "29074": (34.456984, -80.789236),
    "29075": (34.193507, -81.396654),
    "29078": (34.260265, -80.731308),
    "29079": (34.278255, -80.100896),
    "29080": (34.049335, -80.043417),
    "29081": (33.08885, -81.014013),
    "29082": (33.029619, -80.762449),
    "29101": (34.470238, -80.256814),
    "29102": (33.618408, -80.21155),
    "29104": (33.950173, -80.217283),
    "29105": (33.88797, -81.679404),
    "29106": (34.373596, -81.098735),
    "29107": (33.525625, -81.121253),
    "29108": (34.310027, -81.608611),
    "29111": (33.688373, -80.208109),
    "29112": (33.554183, -81.07622),
    "29113": (33.409377, -80.977637),
    "29114": (33.937810999999996, -79.903726),
    "29115": (33.490935, -80.821825),
    "29116": (33.49593, -80.824603),
    "29117": (33.442019, -80.797486),
    "29118": (33.567493, -80.924805),
    "29122": (34.23862, -81.327116),
    "29123": (33.766538, -81.247547),
    "29125": (33.756082, -80.457854),
    "29126": (34.323019, -81.412148),
    "29127": (34.188062, -81.552888),
    "29128": (34.059796, -80.513051),
    "29129": (33.844203, -81.65509),
    "29130": (34.306879, -80.926792),
    "29132": (34.307413, -81.12523),
    "29133": (33.4008, -80.701135),
    "29135": (33.696732, -80.867833),
    "29137": (33.605723, -81.365813),
    "29138": (34.031353, -81.77374),
    "29142": (33.466571, -80.782531),
    "29143": (33.688373, -80.208109),
    "29145": (34.28357, -81.624583),
    "29146": (33.517097, -81.269821),
    "29147": (34.005992, -80.970766),
    "29148": (33.55156, -80.322756),
    "29150": (33.913678, -80.354238),
    "29151": (33.899856, -80.37434),
    "29152": (33.918824, -80.370098),
    "29153": (33.94462, -80.320637),
    "29154": (33.866953, -80.426703),
    "29160": (33.729014, -81.102992),
    "29161": (34.062595, -79.933777),
    "29162": (33.884239, -80.022566),
    "29163": (33.417884, -80.434809),
    "29164": (33.655015, -81.416321),
    "29166": (34.000971, -81.741069),
    "29168": (33.895272, -80.498019),
    "29169": (33.953664, -81.187338),
    "29170": (33.932043, -81.15429),
    "29171": (33.925183, -81.248345),
    "29172": (33.901578, -81.090419),
    "29175": (34.441802, -80.603298),
    "29176": (34.373596, -81.098735),
    "29177": (34.150446, -81.260051),
    "29178": (34.454376, -81.563222),
    "29180": (34.387337, -81.082923),
    "29201": (33.987454, -81.024864),
    "29202": (33.962455, -80.979652),
    "29203": (34.075613, -81.039585),
    "29204": (34.051603, -80.978511),
    "29205": (33.987555, -81.000013),
    "29206": (34.030004, -80.951029),
    "29207": (34.01974, -80.939131),
    "29208": (33.993705, -81.019913),
    "29209": (33.944163, -80.942597),
    "29210": (33.981468, -80.993483),
    "29211": (34.096716, -80.922338),
    "29212": (34.020988, -81.197778),
    "29214": (34.005992, -80.970766),
    "29215": (34.005992, -80.970766),
    "29216": (34.005992, -80.970766),
    "29217": (34.005992, -80.970766),
    "29218": (34.005992, -80.970766),
    "29219": (34.005992, -80.970766),
    "29220": (34.005992, -80.970766),
    "29221": (34.005992, -80.970766),
    "29222": (34.005992, -80.970766),
    "29223": (34.099488, -80.924638),
    "29224": (34.005992, -80.970766),
    "29225": (34.005992, -80.970766),
    "29226": (34.005992, -80.970766),
    "29227": (34.005992, -80.970766),
    "29228": (33.925183, -81.248345),
    "29229": (34.12266, -80.884194),
    "29230": (34.107483, -81.062623),
    "29240": (34.005992, -80.970766),
    "29250": (34.005992, -80.970766),
    "29260": (34.005992, -80.970766),
    "29290": (34.005992, -80.970766),
    "29292": (34.005992, -80.970766),
    "29301": (35.011309, -81.993403),
    "29302": (34.893907, -81.83404),
    "29303": (34.980316, -81.916778),
    "29304": (34.916625, -81.863874),
    "29305": (35.111404, -82.105503),
    "29306": (34.899493, -81.86309),
    "29307": (35.058097, -81.98003),
    "29316": (35.030481, -81.979347),
    "29318": (34.888237, -81.96902),
    "29319": (34.888237, -81.96902),
    "29320": (34.95717, -81.991626),
    "29321": (34.720999, -81.733884),
    "29322": (35.113668, -82.040137),
    "29323": (35.109575, -82.010515),
    "29324": (34.99056, -81.83271),
    "29325": (34.43492, -81.893558),
    "29329": (35.001748, -81.832999),
    "29330": (35.04921, -81.83128),
    "29331": (34.638315, -81.856745),
    "29332": (34.281449, -81.977214),
    "29333": (34.968472, -81.906376),
    "29334": (34.935427, -81.992532),
    "29335": (34.749045, -81.882943),
    "29336": (34.888237, -81.96902),
    "29338": (34.999397, -82.057103),
    "29340": (35.00549, -81.63383),
    "29341": (35.099884, -81.705609),
    "29342": (34.996314, -81.652395),
    "29346": (35.044719, -81.977324),
    "29348": (34.888237, -81.96902),
    "29349": (35.075367, -82.02964),
    "29351": (34.415357, -81.804172),
    "29353": (34.81248, -81.64306),
    "29355": (34.35512, -81.65907),
    "29356": (35.146058, -82.153545),
    "29360": (34.528882, -82.055091),
    "29364": (34.79259, -81.477843),
    "29365": (35.006816, -81.985214),
    "29368": (34.949241, -81.990216),
    "29369": (34.970097, -82.02732),
    "29370": (34.375065, -81.967088),
    "29372": (34.889502, -81.773952),
    "29373": (34.912385, -81.748663),
    "29374": (34.887498, -81.944611),
    "29375": (34.863648, -82.110149),
    "29376": (34.829502, -81.947247),
    "29377": (34.987543, -82.135145),
    "29378": (34.853013, -81.772738),
    "29379": (34.700463, -81.647687),
    "29384": (34.335762, -82.095499),
    "29385": (34.834143, -82.009137),
    "29386": (34.888237, -81.96902),
    "29388": (34.890526, -81.991496),
    "29390": (34.888237, -81.96902),
    "29391": (34.888237, -81.96902),
    "29401": (32.780326, -79.940844),
    "29402": (32.84885, -79.85773),
    "29403": (32.822391, -79.965464),
    "29404": (32.898194, -80.068564),
    "29405": (32.853019, -79.991295),
    "29406": (32.927344, -80.022009),
    "29407": (32.812039, -80.093128),
    "29409": (32.84885, -79.85773),
    "29410": (33.192514, -80.03063),
    "29412": (32.717954, -79.953725),
    "29413": (32.84885, -79.85773),
    "29414": (32.810035, -80.025928),
    "29415": (32.84885, -79.85773),
    "29416": (32.84885, -79.85773),
    "29417": (32.84885, -79.85773),
    "29418": (32.89295, -80.045849),
    "29419": (32.84885, -79.85773),
    "29420": (33.014817, -80.195143),
    "29422": (32.84885, -79.85773),
    "29423": (32.84885, -79.85773),
    "29424": (32.783076, -79.93701),
    "29425": (32.786176, -79.94711),
    "29426": (32.779028, -80.328772),
    "29429": (33.006254, -79.656119),
    "29430": (33.214551, -79.816871),
    "29431": (33.270301, -79.873606),
    "29432": (33.272291, -80.792496),
    "29433": (33.061376, -80.631208),
    "29434": (33.136208, -79.88258),
    "29435": (32.778856, -80.42646),
    "29436": (33.298903, -80.123972),
    "29437": (33.14975, -80.493683),
    "29438": (32.502398, -80.307509),
    "29439": (32.663043, -79.92697),
    "29440": (33.439327, -79.367525),
    "29442": (33.403693, -79.226361),
    "29445": (33.057972, -80.010088),
    "29446": (32.656443, -80.566105),
    "29447": (33.086324, -80.62279),
    "29448": (33.239304, -80.453386),
    "29449": (32.710486, -80.27443),
    "29450": (33.043929, -79.784137),
    "29451": (32.807206, -79.760516),
    "29452": (32.730451, -80.460935),
    "29453": (33.183389, -79.714992),
    "29455": (32.835713, -79.821702),
    "29456": (33.01317, -80.107174),
    "29457": (32.84885, -79.85773),
    "29458": (33.119382, -79.507388),
    "29461": (33.197118, -80.02333899999999),
    "29464": (32.847273, -79.82056299999999),
    "29465": (32.84885, -79.85773),
    "29466": (32.867373, -79.804893),
    "29468": (33.411753, -80.071194),
    "29469": (33.245244, -80.098656),
    "29470": (32.787774, -80.224756),
    "29471": (33.172596, -80.660654),
    "29472": (33.032573, -80.37462),
    "29474": (32.846691, -80.595162),
    "29475": (32.899004, -80.819421),
    "29476": (33.164201, -79.904182),
    "29477": (33.151503, -80.478782),
    "29479": (33.33618, -79.92364),
    "29481": (33.098059, -80.682465),
    "29482": (32.766336, -79.83951),
    "29483": (33.040201, -80.431751),
    "29484": (33.00234, -80.226694),
    "29485": (32.999726, -80.329328),
    "29487": (32.659087, -80.167357),
    "29488": (32.925196, -80.703213),
    "29492": (32.96678, -79.852835),
    "29493": (33.032704, -80.84452),
    "29501": (34.049849, -79.685361),
    "29502": (34.200994, -79.784721),
    "29503": (34.062999, -79.650627),
    "29504": (34.041582, -79.693294),
    "29505": (34.049881, -79.693907),
    "29506": (34.061465, -79.622227),
    "85364": (32.615305, -114.648722),
    "29510": (33.435562, -79.409083),
    "29511": (33.939968, -79.041027),
    "29512": (34.598755, -79.707693),
    "29516": (34.517149, -79.644187),
    "29518": (33.598355, -79.709369),
    "29519": (34.026958, -79.353715),
    "29520": (34.691548, -79.943741),
    "29525": (34.584251, -79.587852),
    "29526": (33.868775, -78.948287),
    "29527": (33.82352, -79.022331),
    "29528": (33.935814, -78.919205),
    "29530": (33.980551, -79.756816),
    "29532": (34.317738, -79.931655),
    "29536": (34.422187, -79.341359),
    "29540": (34.384261, -79.842182),
    "29541": (34.063272, -79.733541),
    "29542": (34.425629, -79.352291),
    "29543": (34.375384, -79.276529),
    "29544": (33.953007, -78.994502),
    "29545": (34.166757, -78.958922),
    "29546": (33.952411, -79.360418),
    "29547": (34.484912, -79.350207),
    "29550": (34.345106, -80.073953),
    "29551": (34.365898, -80.132418),
    "29554": (33.732071, -79.430945),
    "29555": (33.886864, -79.489745),
    "29556": (33.663869, -79.837756),
    "29560": (33.908371, -79.743104),
    "29563": (34.350121, -79.240676),
    "29564": (33.598355, -79.709369),
    "29565": (34.384337, -79.478122),
    "29566": (33.816472, -78.758018),
    "29567": (34.495502, -79.348165),
    "29568": (33.833574, -78.885268),
    "29569": (33.977392, -78.918109),
    "29570": (34.686733, -79.555879),
    "29571": (34.164144, -79.363948),
    "29572": (33.711741, -78.852005),
    "29573": (34.488255, -79.476859),
    "29574": (34.159262, -79.273221),
    "29575": (33.7577, -78.907599),
    "29576": (33.529642, -79.04822),
    "29577": (33.788817, -78.96918),
    "29578": (33.738887, -78.999561),
    "29579": (33.737697, -78.978653),
    "29580": (33.598355, -79.709369),
    "29581": (34.000746, -79.102314),
    "29582": (33.770465, -78.771832),
    "29583": (33.972437, -79.59917),
    "29584": (34.591849, -80.170691),
    "29585": (33.464107, -79.183904),
    "29587": (33.621094, -78.963155),
    "29589": (34.105265, -79.322116),
    "29590": (33.598355, -79.709369),
    "29591": (33.937275, -79.769899),
    "29592": (34.258011, -79.478292),
    "29593": (34.442018, -79.880497),
    "29594": (34.64051, -79.586895),
    "29596": (34.732321999999996, -79.829665),
    "29597": (33.785803, -78.971795),
    "29598": (33.935814, -78.919205),
    "29601": (34.848567, -82.402871),
    "29602": (34.800718, -82.395594),
    "29603": (34.837666, -82.371519),
    "29604": (34.849745, -82.453779),
    "29605": (34.772107, -82.374371),
    "29606": (34.849745, -82.453779),
    "29607": (34.909132, -82.384232),
    "29608": (34.849745, -82.453779),
    "29609": (34.902126, -82.386943),
    "29610": (34.849745, -82.453779),
    "29611": (34.83889, -82.420851),
    "29612": (34.849745, -82.453779),
    "29613": (34.924876, -82.433132),
    "29614": (34.872423, -82.362585),
    "29615": (34.938893, -82.358999),
    "29616": (34.849745, -82.453779),
    "29617": (34.955463, -82.465633),
    "29620": (34.215714, -82.446307),
    "29621": (34.492717999999996, -82.638297),
    "29622": (34.491988, -82.782868),
    "29623": (34.438087, -82.835449),
    "29624": (34.51236, -82.708334),
    "29625": (34.468005, -82.685702),
    "29626": (34.415763, -82.705099),
    "29627": (34.492422, -82.569083),
    "29628": (34.191846, -82.490284),
    "29630": (34.744649, -82.797267),
    "29631": (34.75974, -82.802154),
    "29632": (34.847372, -82.710126),
    "29633": (34.847372, -82.710126),
    "29634": (34.847372, -82.710126),
    "29635": (35.078914, -82.507625),
    "29636": (34.849745, -82.453779),
    "29638": (34.330362, -82.336693),
    "29639": (34.326755, -82.430787),
    "29640": (34.843968, -82.643754),
    "29641": (34.813542, -82.653067),
    "29642": (34.790129, -82.593723),
    "29643": (34.542683, -83.029707),
    "29644": (34.65781, -82.2441),
    "29645": (34.595311, -82.114703),
    "29646": (34.114209, -82.128301),
    "29647": (34.178813, -82.163078),
    "29648": (34.21241, -82.168139),
    "29649": (34.290916, -82.154473),
    "29650": (34.948738, -82.368415),
    "29651": (34.962338, -82.330093),
    "29652": (34.849745, -82.453779),
    "29653": (34.274203, -82.21392),
    "29654": (34.416329, -82.508821),
    "29655": (34.420766, -82.608768),
    "29656": (34.625157, -82.765393),
    "29657": (34.783697, -82.70937),
    "29658": (34.763442, -83.277599),
    "29659": (34.221282, -82.63181),
    "29661": (35.071605, -82.531215),
    "29662": (34.750238, -82.267062),
    "29664": (34.85656, -83.191276),
    "29665": (34.724743, -82.910578),
    "29666": (34.119292, -81.998485),
    "29667": (34.764198, -82.76478),
    "29669": (34.656799, -82.535325),
    "29670": (34.608943, -82.597346),
    "29671": (34.873784, -82.712484),
    "29672": (34.773984, -82.945651),
    "29673": (34.72209, -82.392453),
    "29675": (34.764076, -83.088332),
    "29676": (34.866881, -82.97658),
    "29677": (34.59755, -82.756844),
    "29678": (34.715679, -82.963909),
    "29679": (34.607898, -82.939668),
    "29680": (34.696203, -82.289322),
    "29681": (34.80728, -82.266734),
    "29682": (34.837186, -82.825562),
    "29683": (35.028924, -82.494068),
    "29684": (34.409132, -82.660151),
    "29685": (34.977961, -82.784806),
    "29686": (34.897008, -83.037482),
    "29687": (34.970915, -82.38156),
    "29688": (35.047684, -82.353038),
    "29689": (34.533588, -82.892202),
    "29690": (35.071632, -82.374186),
    "29691": (34.845676, -83.067197),
    "29692": (34.388579, -82.248844),
    "29693": (34.696493, -83.153509),
    "29695": (34.218582, -82.304658),
    "29696": (34.703943, -83.035205),
    "29697": (34.553641999999996, -82.612123),
    "29698": (34.888237, -81.96902),
    "29702": (35.10953, -81.494193),
    "29703": (34.992612, -81.178712),
    "29704": (34.859604, -80.938257),
    "29706": (34.693285, -81.168022),
    "29708": (35.050243, -80.990828),
    "29709": (34.755564, -80.129515),
    "29710": (35.035952, -81.165152),
    "29712": (34.778195, -80.996122),
    "29714": (34.696331, -80.943356),
    "29715": (34.987625, -81.155211),
    "29716": (35.062815, -80.969035),
    "29717": (34.963339, -81.433448),
    "29718": (34.71154, -80.392891),
    "29720": (34.717915, -80.683935),
    "29721": (34.699412, -80.781721),
    "29722": (34.767269, -80.658932),
    "29724": (34.775301999999996, -81.022816),
    "29726": (34.859857, -81.227432),
    "29727": (34.591849, -80.170691),
    "29728": (34.768882, -80.3751),
    "29729": (34.692493, -81.003877),
    "29730": (34.909109, -81.052437),
    "29731": (34.992612, -81.178712),
    "29732": (34.937706, -81.092227),
    "29733": (34.992612, -81.178712),
    "29734": (34.992612, -81.178712),
    "29741": (34.721259, -80.18961),
    "29742": (34.932788, -81.338537),
    "29743": (35.025155, -81.407268),
    "29744": (34.973866, -80.851836),
    "29745": (34.991814, -81.208605),
    "29801": (33.554433, -81.69588),
    "29802": (33.723519, -81.59072),
    "29803": (33.505914, -81.695053),
    "29804": (33.53773, -81.599891),
    "29805": (33.699335, -81.646528),
    "29808": (33.53773, -81.599891),
    "29809": (33.413029, -81.689951),
    "29810": (32.990158, -81.287561),
    "29812": (33.249806, -81.349595),
    "29813": (33.291666, -81.482658),
    "29816": (33.496998, -81.850871),
    "29817": (33.363819, -81.29751),
    "29819": (34.059884, -82.201429),
    "29821": (33.623057, -82.132655),
    "29822": (33.499656, -81.86485),
    "29824": (33.767808, -81.987524),
    "29826": (33.38599, -81.378496),
    "29827": (32.959891999999996, -81.249224),
    "29828": (33.518235, -81.827708),
    "29829": (33.641442, -81.79287),
    "29831": (33.421714, -81.724702),
    "29832": (33.783177, -81.818415),
    "29834": (33.497937, -81.844485),
    "29835": (33.893238, -82.260861),
    "29836": (32.951573, -81.348337),
    "29838": (33.705234, -82.218723),
    "29839": (33.507335, -81.599198),
    "29840": (33.83562, -82.319983),
    "29841": (33.466705, -81.739059),
    "29842": (33.470747, -81.8639),
    "29843": (33.178426, -81.182699),
    "29844": (33.785444, -82.211086),
    "29845": (33.83562, -82.319983),
    "29846": (33.024104, -81.225755),
    "29847": (33.698302, -81.864218),
    "29848": (33.996062, -82.150998),
    "29849": (33.098848, -81.206789),
    "29850": (33.545819, -81.686183),
    "29851": (33.526017, -81.795561),
    "29853": (33.302264, -81.376276),
    "29856": (33.480097, -81.549415),
    "29860": (33.556645, -81.855456),
    "29861": (33.53773, -81.599891),
    "29899": (33.83562, -82.319983),
    "29901": (32.424352999999996, -80.565343),
    "29902": (32.404673, -80.653104),
    "29903": (32.443974, -80.735245),
    "29904": (32.390605, -80.661027),
    "29905": (32.340119, -80.689041),
    "29906": (32.382327, -80.760332),
    "29910": (32.34969, -80.899506),
    "29911": (32.885698, -81.206373),
    "29912": (32.488929, -80.989142),
    "29913": (32.929902, -81.184627),
    "29914": (32.552652, -80.677001),
    "29915": (32.156011, -80.787899),
    "29916": (32.718903, -81.151373),
    "29918": (32.80661, -81.183087),
    "29920": (32.371627, -80.538322),
    "29921": (32.718212, -81.207112),
    "29922": (32.74172, -81.193318),
    "29923": (32.788773, -81.126913),
    "29924": (32.882332, -81.132412),
    "29925": (32.21319, -80.799698),
    "29926": (32.207724, -80.747577),
    "29927": (32.244037, -81.074835),
    "29928": (32.265135, -80.644117),
    "29929": (32.946307, -80.948043),
    "29931": (32.538432, -80.702594),
    "29932": (32.788773, -81.126913),
    "29933": (32.788773, -81.126913),
    "29934": (32.271811, -81.061485),
    "29935": (32.387434, -80.684392),
    "29936": (32.486826, -80.925708),
    "29938": (32.390605, -80.661027),
    "29939": (32.678624, -81.245487),
    "29940": (32.569296, -80.719179),
    "29941": (32.587814, -80.718285),
    "29943": (32.393253, -81.011496),
    "29944": (32.797222, -81.079803),
    "29945": (32.692321, -80.887321),
    "30002": (33.771704, -84.23937),
    "30003": (33.960353, -84.037859),
    "30004": (34.112373, -84.30205),
    "30005": (34.078229, -84.228131),
    "30006": (33.912473, -84.557181),
    "30007": (33.912473, -84.557181),
    "30008": (33.897203, -84.591983),
    "30009": (33.844371, -84.47405),
    "30010": (33.960353, -84.037859),
    "30011": (34.019109, -83.826094),
    "30012": (33.719178, -84.002061),
    "30013": (33.643597, -83.968359),
    "30014": (33.529341, -83.849622),
    "30015": (33.555791, -83.864915),
    "30016": (33.514565, -83.862612),
    "30017": (33.916922, -84.040973),
    "30018": (33.717989, -83.801451),
    "30019": (33.988309, -83.879494),
    "30021": (33.810953, -84.23797),
    "30022": (34.02679, -84.242235),
    "30023": (33.844371, -84.47405),
    "30024": (34.042479, -84.026171),
    "30025": (33.679092, -83.683477),
    "30026": (33.962979, -84.092267),
    "30028": (34.193041, -84.092588),
    "30029": (33.960353, -84.037859),
    "30030": (33.772554, -84.291723),
    "30031": (33.891251, -84.07456),
    "30032": (33.749655, -84.272871),
    "30033": (33.816452, -84.285772),
    "30034": (33.690757, -84.251171),
    "30035": (33.732056, -84.200919),
    "30036": (33.891251, -84.07456),
    "30037": (33.891251, -84.07456),
    "30038": (33.667509, -84.144816),
    "30039": (33.817803, -84.022911),
    "30040": (34.232095, -84.157975),
    "30041": (34.203659, -84.103108),
    "30042": (33.929464, -84.103226),
    "30043": (34.00309, -84.012608),
    "30044": (33.941847, -84.070567),
    "30045": (33.936729, -83.957347),
    "30046": (33.960353, -84.037859),
    "30047": (33.865587, -84.072463),
    "30048": (33.960353, -84.037859),
    "30052": (33.876889, -83.896781),
    "30054": (33.670567, -83.874013),
    "30055": (33.431362, -83.790756),
    "30056": (33.514898, -83.70718),
    "30058": (33.735607, -84.100915),
    "30060": (33.938206, -84.540333),
    "30061": (33.932842, -84.556004),
    "30062": (33.982269, -84.48803),
    "30063": (33.965294, -84.511209),
    "30064": (33.923652, -84.629241),
    "30065": (33.912473, -84.557181),
    "30066": (34.024849, -84.498365),
    "30067": (33.932551, -84.462379),
    "30068": (33.970894, -84.445734),
    "30069": (33.912473, -84.557181),
    "30070": (33.571234, -83.895063),
    "30071": (33.944461, -84.210969),
    "30072": (33.790606, -84.205269),
    "30074": (33.891251, -84.07456),
    "30075": (34.055198, -84.370475),
    "30076": (34.027783, -84.320162),
    "30077": (33.844371, -84.47405),
    "30078": (33.863454, -84.008066),
    "30079": (33.793491, -84.258421),
    "30080": (33.864604, -84.556181),
    "30081": (33.858836, -84.71062),
    "30082": (33.856754, -84.534496),
    "30083": (33.786405, -84.203419),
    "30084": (33.853945, -84.215369),
    "30085": (33.891251, -84.07456),
    "30086": (33.891251, -84.07456),
    "30087": (33.810475, -84.136145),
    "30088": (33.761106, -84.176618),
    "30090": (33.952450999999996, -84.547082),
    "30091": (33.960353, -84.037859),
    "30092": (33.910725, -84.138468),
    "30093": (33.932173, -84.181881),
    "30094": (33.611119, -84.068288),
    "30095": (34.025598, -84.13045),
    "30096": (33.984534, -84.152915),
    "30097": (34.006019, -84.144674),
    "30098": (33.960353, -84.037859),
    "30099": (33.959535, -84.105011),
    "30101": (34.023398, -84.673784),
    "30102": (34.07068, -84.589406),
    "30103": (34.296339, -84.909216),
    "30104": (34.053167, -85.079865),
    "30105": (34.479253, -85.149208),
    "30106": (33.836897, -84.630729),
    "30107": (34.30116, -84.442937),
    "30108": (33.587706, -85.123883),
    "30109": (33.653355, -85.136227),
    "30110": (33.767997, -85.172928),
    "30111": (33.912473, -84.557181),
    "30113": (33.836682, -85.210444),
    "30114": (34.250547, -84.49093),
    "30115": (34.199345, -84.419935),
    "30116": (33.604458, -85.04987),
    "30117": (33.566767, -85.078863),
    "30118": (33.571176, -85.09612),
    "30119": (33.618931, -85.073582),
    "30120": (34.200787, -84.847108),
    "30121": (34.20787, -84.76727),
    "30122": (33.765457, -84.646946),
    "30123": (34.244179, -84.845684),
    "30124": (34.16159, -85.33281),
    "30125": (33.998841, -85.239429),
    "30126": (33.833161, -84.603102),
    "30127": (33.91351, -84.685885),
    "30129": (34.333308, -85.233721),
    "30132": (33.935396, -84.866654),
    "30133": (33.68966, -84.744595),
    "30134": (33.759543, -84.777337),
    "30135": (33.667491, -84.750615),
    "30137": (34.118352, -84.762315),
    "30138": (33.99994, -85.172297),
    "30139": (34.462493, -84.743027),
    "30140": (33.88232, -85.234946),
    "30141": (33.879416, -84.844274),
    "30142": (34.242944, -84.458326),
    "30143": (34.469042, -84.428243),
    "30144": (34.03384, -84.597433),
    "30145": (34.233908, -84.962055),
    "30146": (34.242944, -84.458326),
    "30147": (34.152211, -85.220364),
    "30148": (34.439829, -84.302964),
    "30149": (34.280355, -85.182085),
    "30150": (33.643002, -85.181782),
    "30151": (34.242944, -84.458326),
    "30152": (33.995132, -84.654385),
    "30153": (33.993766, -85.091511),
    "30154": (33.68966, -84.744595),
    "30157": (33.90448, -84.862139),
    "30161": (34.262335, -85.22089),
    "30162": (34.290508, -85.213817),
    "30163": (34.333308, -85.233721),
    "30164": (34.333308, -85.233721),
    "30165": (34.315817, -85.272949),
    "30168": (33.783756, -84.595232),
    "30170": (33.524163, -85.165295),
    "30171": (34.337901, -84.737644),
    "30172": (34.333308, -85.233721),
    "30173": (34.145452, -85.117749),
    "30175": (34.515653, -84.523407),
    "30176": (33.770057, -85.261585),
    "30177": (34.402724, -84.378511),
    "30178": (34.129573, -84.973364),
    "30179": (33.73746, -85.026107),
    "30180": (33.705546, -84.975668),
    "85365": (32.709332, -114.490471),
    "30182": (33.680148, -85.251297),
    "30183": (34.338605, -84.577601),
    "30184": (34.264331, -84.753929),
    "30185": (33.509001, -84.910211),
    "30187": (33.659494, -84.778163),
    "30188": (34.127398, -84.481787),
    "30189": (34.147985, -84.47725),
    "30204": (33.07577, -84.145706),
    "30205": (33.30009, -84.453196),
    "30206": (33.104729, -84.456917),
    "30212": (33.278205, -84.288803),
    "30213": (33.591462, -84.608907),
    "30214": (33.467941, -84.480626),
    "30215": (33.394307, -84.473778),
    "30216": (33.237156, -83.898277),
    "30217": (33.278005, -85.134045),
    "30218": (33.06913, -84.613189),
    "30219": (33.157214, -85.170588),
    "30220": (33.275619, -84.741266),
    "30222": (33.046754, -84.740188),
    "30223": (33.265854, -84.289552),
    "30224": (33.240386, -84.273402),
    "30228": (33.408112, -84.273764),
    "30229": (33.232156, -84.56854),
    "30230": (33.144151, -84.960566),
    "30232": (33.403811, -84.504403),
    "30233": (33.319863, -83.981112),
    "30234": (33.322351, -84.028744),
    "30236": (33.518505, -84.337523),
    "30237": (33.500697, -84.351273),
    "30238": (33.494387, -84.379724),
    "30240": (33.024347, -85.073906),
    "30241": (33.024935, -84.957664),
    "30248": (33.372111, -84.115645),
    "30250": (33.442909, -84.313582),
    "30251": (33.179184, -84.699455),
    "30252": (33.476762, -84.055005),
    "30253": (33.451043, -84.154412),
    "30256": (33.039123, -84.377639),
    "30257": (33.1365, -84.148695),
    "30258": (33.022288, -84.436925),
    "30259": (33.276279, -84.738721),
    "30260": (33.58016, -84.326757),
    "30261": (33.04567, -85.048995),
    "30263": (33.369595, -84.819397),
    "30264": (33.361003, -84.814173),
    "30265": (33.415987, -84.705681),
    "30266": (33.265656, -84.298964),
    "30268": (33.559191, -84.710082),
    "30269": (33.395759, -84.568173),
    "30271": (33.351401, -84.756109),
    "30272": (33.625894, -84.516327),
    "30273": (33.577049, -84.272559),
    "30274": (33.555536000000004, -84.397997),
    "30275": (33.42985, -84.874406),
    "30276": (33.285373, -84.602516),
    "30277": (33.363069, -84.659393),
    "30281": (33.549947, -84.207969),
    "30284": (33.345253, -84.289814),
    "30285": (32.965021, -84.219349),
    "30286": (32.884509, -84.336486),
    "30287": (33.500697, -84.351273),
    "30288": (33.636858, -84.337139),
    "30289": (33.32603, -84.637108),
    "30290": (33.460036, -84.585773),
    "30291": (33.573098, -84.551011),
    "30292": (33.117012, -84.399149),
    "30293": (32.968248, -84.625409),
    "30294": (33.616559, -84.293942),
    "30295": (33.077371, -84.321736),
    "30296": (33.558361, -84.434776),
    "30297": (33.611509, -84.374496),
    "30298": (33.500697, -84.351273),
    "30301": (33.844371, -84.47405),
    "30302": (33.844371, -84.47405),
    "30303": (33.752456, -84.392026),
    "30304": (33.848196, -84.429296),
    "30305": (33.834989, -84.386826),
    "30306": (33.787804, -84.359775),
    "30307": (33.762855, -84.357375),
    "30308": (33.794055, -84.377326),
    "30309": (33.797854, -84.387726),
    "30310": (33.718257, -84.430877),
    "30311": (33.724907, -84.468329),
    "30312": (33.829743, -84.381529),
    "30313": (33.760505, -84.399626),
    "30314": (33.757806, -84.433649),
    "30315": (33.697257, -84.383725),
    "30316": (33.726906, -84.358525),
    "30317": (33.753555, -84.351125),
    "30318": (33.792005, -84.442778),
    "30319": (33.876752, -84.329124),
    "30320": (33.656824, -84.423648),
    "30321": (33.844371, -84.47405),
    "30322": (33.795204, -84.324824),
    "30324": (33.820104, -84.366475),
    "30325": (33.844371, -84.47405),
    "30326": (33.849615, -84.360881),
    "30327": (33.863953, -84.422028),
    "30328": (33.933543, -84.395777),
    "30329": (33.826553, -84.324874),
    "30330": (33.707107, -84.432127),
    "30331": (33.724275, -84.578581),
    "30332": (33.776305, -84.397976),
    "30333": (33.891251, -84.07456),
    "30334": (33.702657, -84.439127),
    "30336": (33.740581, -84.554542),
    "30337": (33.642809, -84.461778),
    "30338": (33.96685, -84.324916),
    "30339": (33.906202, -84.433678),
    "30340": (33.893201, -84.253871),
    "30341": (33.890102, -84.278222),
    "30342": (33.881052, -84.379476),
    "30343": (33.844371, -84.47405),
    "30344": (33.691858, -84.448027),
    "30345": (33.845603, -84.281422),
    "30346": (33.924401, -84.337557),
    "30347": (33.844371, -84.47405),
    "30348": (33.844371, -84.47405),
    "30349": (33.61806, -84.550147),
    "30350": (33.9632, -84.314224),
    "30353": (33.844371, -84.47405),
    "30354": (33.667508, -84.389616),
    "30355": (33.844371, -84.47405),
    "30356": (33.891251, -84.07456),
    "30357": (33.844371, -84.47405),
    "30358": (33.998151, -84.34112),
    "30359": (33.891251, -84.07456),
    "30360": (33.931069, -84.277772),
    "30361": (33.844371, -84.47405),
    "30362": (33.891251, -84.07456),
    "30364": (33.844371, -84.47405),
    "30366": (33.891251, -84.07456),
    "30368": (33.844371, -84.47405),
    "30369": (33.844371, -84.47405),
    "30370": (33.844371, -84.47405),
    "30371": (33.844371, -84.47405),
    "30374": (33.844371, -84.47405),
    "30375": (33.844371, -84.47405),
    "30376": (33.844371, -84.47405),
    "30377": (33.844371, -84.47405),
    "30378": (33.844371, -84.47405),
    "30379": (33.844371, -84.47405),
    "30380": (33.844371, -84.47405),
    "30384": (33.844371, -84.47405),
    "30385": (33.844371, -84.47405),
    "30386": (33.844371, -84.47405),
    "30387": (33.844371, -84.47405),
    "30388": (33.844371, -84.47405),
    "30389": (33.844371, -84.47405),
    "30390": (33.844371, -84.47405),
    "30392": (33.844371, -84.47405),
    "30394": (33.844371, -84.47405),
    "30396": (33.844371, -84.47405),
    "30398": (33.844371, -84.47405),
    "30399": (33.844371, -84.47405),
    "30401": (32.569871, -82.346181),
    "30410": (32.17966, -82.516557),
    "30411": (32.143021, -82.82677),
    "30412": (32.077458, -82.482488),
    "30413": (32.88914, -82.466644),
    "30414": (32.163392, -81.87191),
    "30415": (32.352307, -81.6571),
    "30417": (32.160611, -81.923832),
    "30420": (32.10597, -82.03389),
    "30421": (32.058597, -82.027358),
    "30423": (32.163392, -81.87191),
    "30424": (32.767634, -81.629062),
    "30425": (32.654937, -82.100208),
    "30426": (33.05387, -81.684489),
    "30427": (32.066649, -82.012344),
    "30428": (32.118831, -82.724555),
    "30429": (32.152808, -81.925865),
    "30434": (33.028798, -82.437965),
    "30436": (32.129147, -82.330546),
    "30438": (32.050694, -81.998348),
    "30439": (32.39938, -82.048201),
    "30441": (32.926431, -82.172337),
    "30442": (32.779376, -81.973904),
    "30445": (32.183157, -82.566698),
    "30446": (32.580957, -81.482625),
    "30447": (32.504092, -82.484754),
    "30448": (32.475892, -82.372622),
    "30449": (32.528104, -81.533198),
    "30450": (32.552055, -81.924195),
    "30451": (32.414349, -82.086658),
    "30452": (32.398006, -81.889152),
    "30453": (32.031081, -82.146011),
    "30454": (32.50631, -82.713743),
    "30455": (32.722971, -81.793305),
    "30456": (32.980305, -81.84486),
    "30457": (32.383145, -82.557135),
    "30458": (32.425, -81.784956),
    "30459": (32.447036, -81.77772),
    "30460": (32.41795, -81.78233),
    "30461": (32.450032, -81.715799),
    "30464": (32.445915, -82.258728),
    "30467": (32.743851, -81.628687),
    "30470": (32.188768, -82.522115),
    "30471": (32.54978, -82.183916),
    "30473": (32.028823, -82.516246),
    "30474": (32.198683, -82.39208),
    "30475": (32.177513, -82.373889),
    "30477": (32.863678, -82.407516),
    "30499": (32.050694, -81.998348),
    "30501": (34.334398, -83.837912),
    "30502": (34.212993, -83.794858),
    "30503": (34.345432, -83.950541),
    "30504": (34.241066000000004, -83.886508),
    "30506": (34.336238, -83.860031),
    "30507": (34.257212, -83.824574),
    "30510": (34.50429, -83.594758),
    "30511": (34.393713, -83.473886),
    "30512": (34.867512, -83.967636),
    "30513": (34.831246, -84.331339),
    "30514": (34.903398, -84.019157),
    "30515": (33.960353, -84.037859),
    "30516": (34.383987, -83.03321),
    "30517": (34.109873, -83.685149),
    "30518": (34.113712, -84.033984),
    "30519": (34.079715, -83.930765),
    "30520": (34.355933, -83.152947),
    "30521": (34.363122, -83.254745),
    "30522": (34.73249, -84.425035),
    "30523": (34.655918, -83.508274),
    "30525": (34.886868, -83.375358),
    "30527": (34.397806, -83.775657),
    "30528": (34.610466, -83.74615),
    "30529": (34.169691, -83.570671),
    "30530": (34.168274, -83.402226),
    "30531": (34.535213, -83.574032),
    "30533": (34.541371, -84.024387),
    "30534": (34.453661, -84.155043),
    "30535": (34.631639, -83.569657),
    "30537": (34.97, -83.357507),
    "30538": (34.53512, -83.258748),
    "30539": (34.658482, -84.493207),
    "30540": (34.70129, -84.449007),
    "30541": (34.92873, -84.436752),
    "30542": (34.282818, -83.891451),
    "30543": (34.364396, -83.735421),
    "30544": (34.593092, -83.562922),
    "30545": (34.729196, -83.720937),
    "30546": (34.906339, -83.72739),
    "30547": (34.373145, -83.491925),
    "30548": (34.099031, -83.71817),
    "30549": (34.10601, -83.589021),
    "30552": (34.78992, -83.443351),
    "30553": (34.408031, -83.144241),
    "30554": (34.41088, -83.703923),
    "30555": (34.936986, -84.403709),
    "30557": (34.527955, -83.23208),
    "30558": (34.329372, -83.543357),
    "30559": (34.936697, -84.268863),
    "30560": (34.86263, -84.248612),
    "30562": (34.914393, -83.402766),
    "30563": (34.541683, -83.52283),
    "30564": (34.445369, -83.906516),
    "30565": (34.113429, -83.474576),
    "30566": (34.239428, -83.897612),
    "30567": (34.159431, -83.59706),
    "30568": (34.944609, -83.381415),
    "30571": (34.66578, -83.709564),
    "30572": (34.712091, -84.027629),
    "30573": (34.742007, -83.397716),
    "30575": (34.195058, -83.713188),
    "30576": (34.856395, -83.457267),
    "30577": (34.554103, -83.288828),
    "30580": (34.676584, -83.43578),
    "30581": (34.804473, -83.419137),
    "30582": (34.934417, -83.828504),
    "30596": (34.629391, -83.509934),
    "30597": (34.527671, -83.980879),
    "30598": (34.59179, -83.352534),
    "30599": (34.130594, -83.587419),
    "30601": (33.992902, -83.353697),
    "30602": (33.925971, -83.365029),
    "30603": (33.947587, -83.408897),
    "30604": (33.944339, -83.38908),
    "30605": (33.923088, -83.364038),
    "30606": (33.951348, -83.43064),
    "30607": (33.998267, -83.439569),
    "30608": (33.944339, -83.38908),
    "30609": (33.946364, -83.37743),
    "30612": (33.944339, -83.38908),
    "30619": (33.888662, -83.222254),
    "30620": (33.943652, -83.721536),
    "30621": (33.805718, -83.48171),
    "30622": (33.901988, -83.518452),
    "30623": (33.754235, -83.511055),
    "30624": (34.164131, -82.957102),
    "30625": (33.525614, -83.365611),
    "30627": (34.05918, -83.099349),
    "30628": (34.088156, -83.202379),
    "30629": (34.105661, -83.144463),
    "30630": (33.907589, -83.164573),
    "30631": (33.577007, -82.858099),
    "30633": (34.152968, -83.262772),
    "30634": (34.185291, -82.943399),
    "30635": (34.129737, -82.840971),
    "30638": (33.755811, -83.420094),
    "30639": (34.274306, -83.147024),
    "30641": (33.778256999999996, -83.580359),
    "30642": (33.560655, -83.193389),
    "30643": (34.361177, -82.941703),
    "30645": (33.801274, -83.516374),
    "30646": (34.088693, -83.30911),
    "30647": (34.120239, -83.288117),
    "30648": (33.85281, -83.020293),
    "30650": (33.591117, -83.492928),
    "30655": (33.788322, -83.701264),
    "30656": (33.838638, -83.710359),
    "30660": (33.763817, -82.899831),
    "30662": (34.297968, -83.192787),
    "30663": (33.61101, -83.602459),
    "30664": (33.559964, -82.794766),
    "30665": (33.561871, -83.074186),
    "30666": (33.980323, -83.590148),
    "30667": (33.804626, -83.151661),
    "30668": (33.877751, -82.747023),
    "30669": (33.634342, -83.122065),
    "30671": (33.740502, -83.1706),
    "30673": (33.73149, -82.710833),
    "30677": (33.81673, -83.43347),
    "30678": (33.458056, -83.08023),
    "30680": (33.987138, -83.698498),
    "30683": (33.930735, -83.292152),
    "30701": (34.496921, -84.887942),
    "30703": (34.479066, -84.762161),
    "30705": (34.785543, -84.771623),
    "30707": (34.76416, -85.353517),
    "30708": (34.872473, -84.75688),
    "30710": (34.867821, -84.919498),
    "30711": (34.887628, -84.744577),
    "30719": (34.801861, -84.989796),
    "30720": (34.791428, -84.992771),
    "30721": (34.788493, -84.91381),
    "30722": (34.759522, -84.951261),
    "30724": (34.78783, -84.777863),
    "30725": (34.846843, -85.238041),
    "30726": (34.980249, -85.140798),
    "30728": (34.697006, -85.255273),
    "30730": (34.392073, -85.417428),
    "30731": (34.518597, -85.414081),
    "30732": (34.569015, -84.711863),
    "30733": (34.414048, -85.052629),
    "30734": (34.535071, -84.724186),
    "30735": (34.583318, -84.906803),
    "30736": (34.888709, -85.118699),
    "30738": (34.813904, -85.501868),
    "30739": (34.801819, -85.212809),
    "30740": (34.766976, -85.072681),
    "30741": (34.798084, -85.246291),
    "30742": (34.931497, -85.175034),
    "30746": (34.571753, -85.025616),
    "30747": (34.484159, -85.315546),
    "30750": (34.93473, -85.384631),
    "30751": (34.981449, -84.735233),
    "30752": (34.871687, -85.50208),
    "30753": (34.532713, -85.368362),
    "30755": (34.875416, -85.050047),
    "30756": (34.9298, -84.988536),
    "30757": (34.922998, -85.448302),
    "30802": (33.573999, -82.312058),
    "30803": (33.141307, -82.527009),
    "30805": (33.359709, -82.198897),
    "30806": (33.527993, -82.5104),
    "30807": (33.447102, -82.642214),
    "30808": (33.404395, -82.401622),
    "30809": (33.551132, -82.143617),
    "30810": (33.223471, -82.599738),
    "30811": (33.050487, -81.929165),
    "30812": (33.386041, -82.090996),
    "30813": (33.466721, -82.213991),
    "30814": (33.456131, -82.307337),
    "30815": (33.32229, -82.058032),
    "30816": (33.155067, -82.134871),
    "30817": (33.812714, -82.453456),
    "30818": (33.189975, -82.34339),
    "30819": (33.432384, -82.625213),
    "30820": (33.231593, -82.631164),
    "30821": (33.484966, -82.718794),
    "30822": (32.873466, -81.875482),
    "30823": (33.181447, -82.438568),
    "30824": (33.494908, -82.513847),
    "30828": (33.406118, -82.641067),
    "30830": (33.080724, -81.986767),
    "30833": (33.192426, -82.361546),
    "30901": (33.456687, -81.969184),
    "30903": (33.386041, -82.090996),
    "30904": (33.478686, -82.015988),
    "30905": (33.412986, -82.133732),
    "30906": (33.358865, -82.009938),
    "30907": (33.457921, -82.068935),
    "30909": (33.416616, -82.055973),
    "30910": (33.386041, -82.090996),
    "30911": (33.386041, -82.090996),
    "30912": (33.386041, -82.090996),
    "30913": (33.386041, -82.090996),
    "30914": (33.386041, -82.090996),
    "30916": (33.386041, -82.090996),
    "30917": (33.527678, -82.235542),
    "30919": (33.386041, -82.090996),
    "30999": (33.386041, -82.090996),
    "31001": (31.977048, -83.372515),
    "31002": (32.56887, -82.540305),
    "31003": (32.606433, -83.20951),
    "31004": (32.946971, -83.800628),
    "31005": (32.539506, -83.662733),
    "31006": (32.572668, -84.226075),
    "31007": (32.185828, -83.901376),
    "31008": (32.618051, -83.788976),
    "31009": (32.303915, -83.009422),
    "31010": (31.917178, -83.785365),
    "31011": (32.150374, -83.055544),
    "31012": (32.310632, -83.160882),
    "31013": (32.338639, -83.692562),
    "31014": (32.383904, -83.321095),
    "31015": (31.919861, -83.777354),
    "31016": (32.900292, -84.062584),
    "31017": (32.607654, -83.269106),
    "31018": (32.968449, -82.648357),
    "31019": (32.428425, -83.044502),
    "31020": (32.715133, -83.455788),
    "31021": (32.459291, -82.938121),
    "31022": (32.505705, -83.108975),
    "31023": (32.143564, -83.194358),
    "31024": (33.320818, -83.355865),
    "31025": (32.360242, -83.749048),
    "31027": (32.552377, -82.781684),
    "31028": (32.56822, -83.70177),
    "31029": (33.025944, -83.915021),
    "31030": (32.560698, -83.854528),
    "31031": (32.881267, -83.302945),
    "31032": (32.991607, -83.567362),
    "31033": (33.056543, -83.424672),
    "31034": (33.022658, -83.246975),
    "31035": (32.855295, -82.702399),
    "31036": (32.275664, -83.49009),
    "31037": (32.047457, -82.9747),
    "31038": (33.207511, -83.618059),
    "31039": (32.559781, -84.227675),
    "31040": (32.540073, -82.914974),
    "31041": (32.372937, -84.212159),
    "31042": (32.751414, -83.145237),
    "31044": (32.661271, -83.331033),
    "31045": (33.296633, -82.755599),
    "31046": (33.027607, -83.803166),
    "31047": (32.454331, -83.646436),
    "31049": (32.698954, -82.525306),
    "31050": (32.715632, -83.915762),
    "31051": (32.146879, -83.891349),
    "31052": (32.783332, -83.823023),
    "31054": (32.886524, -83.231724),
    "31055": (32.047918, -82.910927),
    "31057": (32.438321, -83.905039),
    "31058": (32.559781, -84.227675),
    "31060": (31.964005, -82.926588),
    "31061": (33.072279, -83.239008),
    "31062": (33.087138, -83.22492),
    "31063": (32.240448, -83.863997),
    "31064": (33.337906, -83.698508),
    "31065": (32.56204, -83.159741),
    "31066": (32.786842, -83.979228),
    "31067": (32.876666, -82.946903),
    "31068": (32.327479, -84.101472),
    "31069": (32.43194, -83.722649),
    "31070": (32.182652, -83.778422),
    "31071": (32.09813, -83.504479),
    "31072": (31.948637, -83.539522),
    "31073": (32.176429, -83.122891),
    "31075": (32.379902, -82.966995),
    "31076": (32.551695, -84.092715),
    "31077": (32.176429, -83.122891),
    "31078": (32.687207, -84.010581),
    "31079": (31.948411, -83.453578),
    "31081": (32.559781, -84.227675),
    "31082": (32.974982, -82.840564),
    "31083": (32.084139, -82.912341),
    "31084": (31.989039, -83.394574),
    "31085": (33.435022, -83.626885),
    "31086": (32.989503, -83.876108),
    "31087": (33.257068, -83.08922),
    "31088": (32.555039, -83.644751),
    "31089": (32.873449, -82.782879),
    "31090": (32.806595, -83.066814),
    "31091": (32.219249, -83.731718),
    "31092": (32.115981, -83.791644),
    "31093": (32.587303, -83.658174),
    "31094": (33.07975, -82.805591),
    "31095": (32.487403, -83.669655),
    "31096": (32.635692, -82.657495),
    "31097": (32.901627, -84.212644),
    "31098": (32.49372, -83.640099),
    "31099": (32.646236, -83.6513),
    "31106": (33.844371, -84.47405),
    "31107": (33.844371, -84.47405),
    "31119": (33.891251, -84.07456),
    "31126": (33.844371, -84.47405),
    "31131": (33.844371, -84.47405),
    "31139": (33.844371, -84.47405),
    "31141": (33.891251, -84.07456),
    "31145": (33.891251, -84.07456),
    "31146": (33.891251, -84.07456),
    "31150": (33.844371, -84.47405),
    "31156": (33.844371, -84.47405),
    "31191": (33.844371, -84.47405),
    "31192": (33.844371, -84.47405),
    "31193": (33.844371, -84.47405),
    "31195": (33.844371, -84.47405),
    "31196": (33.844371, -84.47405),
    "31197": (33.844371, -84.47405),
    "31198": (33.844371, -84.47405),
    "31199": (33.844371, -84.47405),
    "31201": (32.827949, -83.595066),
    "31202": (32.806707, -83.691315),
    "31203": (32.806707, -83.691315),
    "31204": (32.852249, -83.667064),
    "31205": (32.806707, -83.691315),
    "31206": (32.834861, -83.668091),
    "31207": (32.830389, -83.648552),
    "31208": (32.806707, -83.691315),
    "31209": (32.806707, -83.691315),
    "31210": (32.843368, -83.680078),
    "31211": (32.866987, -83.607363),
    "31212": (32.806707, -83.691315),
    "31213": (32.839289, -83.638752),
    "31216": (32.74857, -83.747721),
    "31217": (32.811767, -83.565009),
    "31220": (32.859461, -83.802047),
    "31301": (31.779116, -81.60385),
    "31302": (32.107103, -81.291335),
    "31303": (32.488015, -81.322392),
    "31304": (31.495071, -81.381908),
    "31305": (31.413831, -81.369263),
    "31307": (32.174021, -81.353756),
    "31308": (32.159233, -81.502963),
    "31309": (31.87673, -81.457959),
    "31310": (31.806832, -81.437074),
    "31312": (32.331563, -81.384181),
    "31313": (31.804838, -81.523649),
    "31314": (31.806832, -81.437074),
    "31315": (31.844332, -81.654696),
    "31316": (31.780996, -81.773916),
    "31318": (32.149861, -81.372184),
    "31319": (31.459045, -81.368884),
    "31320": (31.778847, -81.420626),
    "31321": (32.009967, -81.514752),
    "31322": (32.071917, -81.083881),
    "31323": (31.785934, -81.57385),
    "31324": (31.951531, -81.407336),
    "31326": (32.285205, -81.287526),
    "31327": (31.495071, -81.381908),
    "31328": (32.00593, -80.855322),
    "31329": (32.369703, -81.361775),
    "31331": (31.512024, -81.358252),
    "31333": (31.770473, -81.62083),
    "31401": (32.072257, -81.135618),
    "31402": (31.971394, -81.07156),
    "31403": (31.971394, -81.07156),
    "31404": (32.048247, -81.11748),
    "31405": (32.065317, -81.181413),
    "31406": (31.975611, -81.086617),
    "31407": (32.167235, -81.19989699999999),
    "31408": (32.108154, -81.174612),
    "31409": (31.971394, -81.07156),
    "31410": (32.017461, -80.997043),
    "31411": (31.942645, -81.045795),
    "31412": (31.971394, -81.07156),
    "31414": (31.971394, -81.07156),
    "31415": (32.075307, -81.128865),
    "31416": (32.005255, -81.047711),
    "31418": (31.971394, -81.07156),
    "31419": (32.008492, -81.214369),
    "31420": (31.971394, -81.07156),
    "31421": (31.971394, -81.07156),
    "31422": (31.971394, -81.07156),
    "31498": (31.971394, -81.07156),
    "31499": (31.971394, -81.07156),
    "31501": (31.224262, -82.359628),
    "31502": (31.018954, -82.416543),
    "31503": (31.193229, -82.376595),
    "31510": (31.576952, -82.461197),
    "31512": (31.549597, -82.987305),
    "31513": (31.756861, -82.350837),
    "31515": (31.717717, -82.299677),
    "31516": (31.326324, -82.271206),
    "31518": (31.483312, -82.214987),
    "31519": (31.671903, -82.864903),
    "31520": (31.230428, -81.492883),
    "31521": (31.241505, -81.532489),
    "31522": (31.213223, -81.449141),
    "31523": (31.218921, -81.546047),
    "31524": (31.221995, -81.482551),
    "31525": (31.280403, -81.530477),
    "31527": (31.059721, -81.416665),
    "31532": (31.795977, -82.707079),
    "31533": (31.509338, -82.857131),
    "31534": (31.571596, -82.854631),
    "31535": (31.504581, -82.824636),
    "31537": (30.855314, -82.027252),
    "31539": (31.806871, -82.626991),
    "31542": (31.178954, -82.123686),
    "31543": (31.26837, -81.810366),
    "31544": (31.83245, -82.977178),
    "31545": (31.600775, -81.957787),
    "31546": (31.531938, -81.804924),
    "31547": (30.804684, -81.627717),
    "31548": (30.784384, -81.692042),
    "31549": (31.931373, -82.682963),
    "31550": (31.168101, -82.594815),
    "31551": (31.453629, -82.230385),
    "31552": (31.307256, -82.600728),
    "31553": (31.158299, -81.954478),
    "31554": (31.504909, -82.703064),
    "31555": (31.685101, -82.037562),
    "31556": (31.412649, -82.115541),
    "31557": (31.369686, -82.115363),
    "31558": (30.844019, -81.630984),
    "31560": (31.512923, -82.010258),
    "31561": (31.198914, -81.332211),
    "31563": (31.731163, -82.194912),
    "31564": (31.018954, -82.416543),
    "31565": (31.069415, -81.633658),
    "31566": (31.187918, -81.889563),
    "31567": (31.614311999999998, -82.724308),
    "31568": (30.995235, -81.778181),
    "31569": (30.939072, -81.703469),
    "31598": (31.578181, -81.880222),
    "31599": (31.578181, -81.880222),
    "31601": (30.753904, -83.332068),
    "31602": (30.893109, -83.327812),
    "31603": (30.827965, -83.252192),
    "31604": (30.827965, -83.252192),
    "31605": (30.945994, -83.247371),
    "31606": (30.826306, -83.245331),
    "31622": (31.383968, -83.221348),
    "31623": (31.064114, -82.68954),
    "31624": (31.303159, -82.847997),
    "31625": (30.856633, -83.526479),
    "31626": (30.828644, -83.910971),
    "31627": (31.040257, -83.391519),
    "31629": (30.761316, -83.708223),
    "31630": (30.975874, -82.880688),
    "31631": (31.05682, -82.772422),
    "31632": (30.942022, -83.333206),
    "31634": (31.050929, -82.76133),
    "31635": (31.035327, -83.098737),
    "31636": (30.745322, -83.184325),
    "31637": (31.271045, -83.468529),
    "31638": (30.924839, -83.539952),
    "31639": (31.199826, -83.218233),
    "31641": (30.899018, -83.128478),
    "31642": (31.340836, -82.853406),
    "31643": (30.78944, -83.587777),
    "31645": (31.083619, -83.228709),
    "31646": (30.434346, -82.165527),
    "31647": (31.212878, -83.412143),
    "31648": (30.768894, -83.037116),
    "31649": (30.955111, -83.013828),
    "31650": (31.361682, -82.96823499999999),
    "31698": (30.84848, -83.287753),
    "31699": (30.975119, -83.207206),
    "31701": (31.560674, -84.176751),
    "31702": (31.594782, -84.194812),
    "31703": (31.543065, -84.219594),
    "31704": (31.549975, -84.061155),
    "31705": (31.546375, -84.078338),
    "31706": (31.559274, -84.176507),
    "31707": (31.529269, -84.293109),
    "31708": (31.591073, -84.132357),
    "31709": (32.040432, -84.215282),
    "31710": (32.051235, -84.181547),
    "31711": (32.155949, -84.163983),
    "31712": (31.849613, -83.7277),
    "31713": (31.47718, -84.699156),
    "31714": (31.723074, -83.644063),
    "31715": (30.835331, -84.511949),
    "31716": (31.358861, -84.100301),
    "31717": (30.888734, -84.617836),
    "31718": (30.901863, -84.570049),
    "31720": (30.856633, -83.526479),
    "31722": (31.080682, -83.649138),
    "31723": (31.346088, -84.901178),
    "31724": (31.557533, -84.854212),
    "31725": (30.907915, -84.703795),
    "31726": (31.824017, -84.343163),
    "31727": (31.44172, -83.503715),
    "31728": (30.857503, -84.22903),
    "31729": (30.71471, -84.351846),
    "31730": (31.249152, -84.242837),
    "31732": (31.29563, -84.871091),
    "31733": (31.557454, -83.509385),
    "31734": (30.887347, -84.468281),
    "31735": (31.968395, -83.978975),
    "31736": (31.775195, -84.747201),
    "31737": (31.16251, -84.713359),
    "31738": (30.976287, -83.871284),
    "31739": (31.260443, -84.253089),
    "31740": (31.731183, -84.832234),
    "31741": (31.298124, -84.71746),
    "31742": (31.76615, -84.438586),
    "31743": (31.938088, -84.03104),
    "31744": (31.272009, -83.889951),
    "31745": (30.918229, -84.867238),
    "31746": (31.506869000000002, -84.721045),
    "31747": (31.17885, -83.588901),
    "31749": (31.417797, -83.355349),
    "31750": (31.748753, -83.235412),
    "31751": (31.63618, -85.054942),
    "31752": (30.791856, -84.549907),
    "31753": (31.205365, -83.877554),
    "31754": (31.844937, -85.104383),
    "31756": (31.200827, -83.945527),
    "31757": (30.853592, -83.888269),
    "31758": (30.868187, -83.927785),
    "31759": (30.985082, -84.834731),
    "31760": (31.706283, -83.408633),
    "31761": (31.089377, -84.986113),
    "31762": (31.484266, -84.513659),
    "31763": (31.763715, -84.160359),
    "31764": (32.000148, -84.088354),
    "31765": (31.021859, -84.061389),
    "31766": (31.537959999999998, -84.611559),
    "31767": (31.88141, -85.024468),
    "31768": (31.183438, -83.789698),
    "31769": (31.620866, -83.249754),
    "31770": (31.37168, -84.338325),
    "31771": (31.246179, -83.654904),
    "31772": (31.726629, -83.959728),
    "31773": (30.968592, -84.02725),
    "31774": (31.571754, -83.269632),
    "31775": (31.359156, -83.59029),
    "31776": (31.172696, -83.792379),
    "31777": (31.911689, -84.506058),
    "31778": (30.869228, -83.900766),
    "31779": (31.225572, -84.223371),
    "31780": (32.027663, -84.37249),
    "31781": (31.538397, -83.784347),
    "31782": (31.543065, -84.219594),
    "31783": (31.780373, -83.526041),
    "31784": (31.27433, -84.047656),
    "31785": (31.689973, -84.32748),
    "31786": (31.760361, -84.614914),
    "31787": (31.772073, -84.222541),
    "31789": (31.481811, -83.727288),
    "31790": (31.652867, -83.578336),
    "31791": (31.603336, -83.850054),
    "31792": (30.825551, -83.950795),
    "31793": (31.485438, -83.503621),
    "31794": (31.463918, -83.499944),
    "31795": (31.475155, -83.592123),
    "31796": (31.762219, -83.876179),
    "31797": (30.901959, -84.311493),
    "31798": (31.571849, -83.087813),
    "31799": (30.880968, -83.885902),
    "31801": (32.701116999999996, -84.494946),
    "31803": (32.254152, -84.489818),
    "31804": (32.661625, -84.855447),
    "31805": (32.292547, -84.736706),
    "31806": (32.209028, -84.277064),
    "31807": (32.631243, -84.789524),
    "31808": (32.563874, -84.991501),
    "31810": (32.701116999999996, -84.494946),
    "31811": (32.746007, -84.934906),
    "31812": (32.701116999999996, -84.494946),
    "31814": (32.07663, -84.849724),
    "31815": (32.069538, -84.728093),
    "31816": (32.91107, -84.615478),
    "31820": (32.565782, -84.850953),
    "31821": (32.07663, -84.849724),
    "31822": (32.834241, -84.904638),
    "31823": (32.822628, -84.820364),
    "31824": (32.076133, -84.543517),
    "31825": (32.074331, -84.718627),
    "31826": (32.791278, -84.733595),
    "31827": (32.673738, -84.537989),
    "31829": (32.564771, -84.733865),
    "31830": (32.906319, -84.716723),
    "31831": (32.738687, -84.78546),
    "31832": (32.076133, -84.543517),
    "31833": (32.907328, -85.077535),
    "31836": (32.790007, -84.56542),
    "31901": (32.472864, -84.97823),
    "31902": (32.524252, -84.955843),
    "31903": (32.41851, -84.934344),
    "31904": (32.534374, -84.99698),
    "31905": (32.392337, -84.931457),
    "31906": (32.493455, -84.95328),
    "31907": (32.483084, -84.914976),
    "31908": (32.534852, -84.906483),
    "31909": (32.542198, -84.920187),
    "31914": (32.491005, -84.874123),
    "31917": (32.491005, -84.874123),
    "31993": (32.482142, -84.977131),
    "31994": (32.491005, -84.874123),
    "31995": (32.495841, -84.963981),
    "31997": (32.491005, -84.874123),
    "31998": (32.491005, -84.874123),
    "31999": (32.491005, -84.874123),
    "32004": (29.937673, -81.420603),
    "32007": (29.799631, -81.627324),
    "32008": (30.101927, -82.908004),
    "32009": (30.521109, -81.906051),
    "32011": (30.556322, -81.837594),
    "32013": (30.041449, -83.123055),
    "32024": (30.105451, -82.68778),
    "32025": (30.160115, -82.639606),
    "32030": (30.105553, -81.768964),
    "32033": (29.813208, -81.468724),
    "32034": (30.60778, -81.682889),
    "32035": (30.551558, -81.698422),
    "32038": (30.211903, -82.626332),
    "32040": (30.302616, -82.190828),
    "32041": (30.6233, -81.590249),
    "32042": (29.968926, -82.122553),
    "32043": (29.998318, -81.76468),
    "32044": (29.862285, -82.143297),
    "32046": (30.670745, -81.894528),
    "32050": (30.031702, -81.848401),
    "32052": (30.495814, -82.985428),
    "32053": (30.555263, -83.148179),
    "32054": (30.007626, -82.341422),
    "32055": (30.155907, -82.652551),
    "32056": (30.162772, -82.651184),
    "32058": (30.047063, -82.12691),
    "32059": (30.498591, -83.361506),
    "32060": (30.175865, -83.030438),
    "32061": (30.211903, -82.626332),
    "32062": (30.186428, -82.983576),
    "32063": (30.284628, -82.160139),
    "32064": (30.331517, -82.957151),
    "32065": (29.986046, -81.883212),
    "32066": (30.148296, -83.210982),
    "32067": (29.956068, -81.815115),
    "32068": (30.078597, -81.847794),
    "32071": (30.036193, -82.932228),
    "32072": (30.36036, -82.25418),
    "32073": (30.119884, -81.791546),
    "32079": (29.984882, -81.802221),
    "32082": (30.102212, -81.382302),
    "32083": (30.054956, -82.213361),
    "32084": (29.849505, -81.332552),
    "32085": (29.937673, -81.420603),
    "32086": (29.775409, -81.302246),
    "32087": (30.291034, -82.334017),
    "32091": (29.928149, -82.179651),
    "85366": (32.609959, -114.631172),
    "32092": (29.921998, -81.504509),
    "32094": (30.194651, -82.857328),
    "32095": (29.983058, -81.450583),
    "32096": (30.386063, -82.77389),
    "32097": (30.659689, -81.683649),
    "32099": (30.337538, -81.768622),
    "32102": (29.174011, -81.575044),
    "32105": (29.200508, -81.406458),
    "32110": (29.402177000000002, -81.33425),
    "32111": (29.060711, -81.969048),
    "32112": (29.511518, -81.681387),
    "32113": (29.411299, -82.084651),
    "32114": (29.146163, -81.053368),
    "32115": (29.022728999999998, -81.172169),
    "32116": (29.10909, -80.984344),
    "32117": (29.188732, -81.231384),
    "32118": (29.208908, -81.00227),
    "32119": (29.150622, -81.025223),
    "32120": (29.022728999999998, -81.172169),
    "32121": (29.022728999999998, -81.172169),
    "32122": (29.022728999999998, -81.172169),
    "32123": (29.022728999999998, -81.172169),
    "32124": (29.14192, -81.140241),
    "32125": (29.022728999999998, -81.172169),
    "32126": (29.022728999999998, -81.172169),
    "32127": (29.113539, -80.976485),
    "32129": (29.022728999999998, -81.172169),
    "32130": (29.183646, -81.329387),
    "32131": (29.612208, -81.699606),
    "32132": (28.974136, -80.92291),
    "32133": (29.008805, -81.909445),
    "32134": (29.390965, -81.855082),
    "32135": (29.466085, -81.282815),
    "32136": (29.509845, -81.18295),
    "32137": (29.564391, -81.201389),
    "32138": (29.699255, -81.922362),
    "32139": (29.384185, -81.618309),
    "32140": (29.611384, -81.73499),
    "32141": (28.933217, -80.900037),
    "32142": (29.466085, -81.282815),
    "32145": (29.68875, -81.406081),
    "32147": (29.657611, -81.779652),
    "32148": (29.598959, -81.762249),
    "32149": (29.58203, -81.744852),
    "32151": (29.466085, -81.282815),
    "32157": (29.45817, -81.591447),
    "32158": (28.811078, -81.653642),
    "32159": (28.923468, -81.894367),
    "32160": (29.768321, -81.990729),
    "32164": (29.486141, -81.204491),
    "32168": (28.951931, -81.033705),
    "32169": (29.131714, -81.133519),
    "32170": (29.022728999999998, -81.172169),
    "32173": (29.022728999999998, -81.172169),
    "32174": (29.30766, -81.177846),
    "32175": (29.022728999999998, -81.172169),
    "32176": (29.335111, -81.249977),
    "32177": (29.611093, -81.785957),
    "32178": (29.644306, -81.668593),
    "32179": (29.086882, -81.905259),
    "32180": (29.244623, -81.471982),
    "32181": (29.539751, -81.613183),
    "32182": (29.485625, -81.958901),
    "32183": (29.059673, -81.905068),
    "32185": (29.736833, -81.957967),
    "32187": (29.59344, -81.589937),
    "32189": (29.536502, -81.633608),
    "32190": (29.28926, -81.503244),
    "32192": (29.326821, -82.104632),
    "32193": (29.463627, -81.640527),
    "32195": (29.006144, -81.87785),
    "32198": (29.022728999999998, -81.172169),
    "32201": (30.389438, -81.680806),
    "32202": (30.328439, -81.65602),
    "32203": (30.32281, -81.547044),
    "32204": (30.323539, -81.681068),
    "32205": (30.330938, -81.833074),
    "32206": (30.352488, -81.665918),
    "32207": (30.290839, -81.631465),
    "32208": (30.391988, -81.685569),
    "32209": (30.347838, -81.813774),
    "32210": (30.274539, -81.786671),
    "32211": (30.347139, -81.581959),
    "32212": (30.213189, -81.690016),
    "32214": (30.34494, -81.683107),
    "32215": (30.240689, -81.892982),
    "32216": (30.28434, -81.54074),
    "32217": (30.24058, -81.618814),
    "32218": (30.47548, -81.67602),
    "32219": (30.378738, -81.745368),
    "32220": (30.337236, -81.863176),
    "32221": (30.259438, -81.848561),
    "32222": (30.218289, -81.820628),
    "32223": (30.166809, -81.63425),
    "32224": (30.24359, -81.715976),
    "32225": (30.331905, -81.50091),
    "32226": (30.479666, -81.527063),
    "32227": (30.38024, -81.41602),
    "32228": (30.38239, -81.436859),
    "32229": (30.34494, -81.683107),
    "32230": (30.34494, -81.683107),
    "32231": (30.34494, -81.683107),
    "32232": (30.34494, -81.683107),
    "32233": (30.35239, -81.517761),
    "32234": (30.275711, -81.968614),
    "32235": (30.34494, -81.683107),
    "32236": (30.34494, -81.683107),
    "32237": (30.34494, -81.683107),
    "32238": (30.34494, -81.683107),
    "32239": (30.34494, -81.683107),
    "32240": (30.34494, -81.683107),
    "32241": (30.34494, -81.683107),
    "32244": (30.220302, -81.747414),
    "32245": (30.34494, -81.683107),
    "32246": (30.293273, -81.50916),
    "32247": (30.34494, -81.683107),
    "32250": (30.280143, -81.416506),
    "32254": (30.357888, -81.674018),
    "32255": (30.287041, -81.389305),
    "32256": (30.213733, -81.539129),
    "32257": (30.191737, -81.603557),
    "32258": (30.156591, -81.560415),
    "32259": (29.877289, -81.561245),
    "32260": (29.937673, -81.420603),
    "32266": (30.315978, -81.408006),
    "32267": (30.34494, -81.683107),
    "32276": (30.325739, -81.659017),
    "32277": (30.370439, -81.586394),
    "32301": (30.418514, -84.203379),
    "32302": (30.479347, -84.346204),
    "32303": (30.535698, -84.247698),
    "32304": (30.437954, -84.347459),
    "32305": (30.130775, -84.406629),
    "32306": (30.442499, -84.29855),
    "32307": (30.42565, -84.287749),
    "32308": (30.556205, -84.176838),
    "32309": (30.514599, -84.188446),
    "32310": (30.364812, -84.460793),
    "32311": (30.433478, -84.135913),
    "32312": (30.572171, -84.21548),
    "32313": (30.479347, -84.346204),
    "32314": (30.479347, -84.346204),
    "32315": (30.479347, -84.346204),
    "32316": (30.479347, -84.346204),
    "32317": (30.479347, -84.346204),
    "32320": (29.819333, -84.852937),
    "32321": (30.419284, -84.97804000000001),
    "32322": (29.853775, -84.735838),
    "32323": (29.882567, -84.596417),
    "32324": (30.640548, -84.780758),
    "32326": (30.183372, -84.34906),
    "32327": (30.165498, -84.430777),
    "32328": (29.749548, -84.816238),
    "32329": (29.745525999999998, -85.023947),
    "32330": (30.565334, -84.735972),
    "32331": (30.441092, -83.516133),
    "32332": (30.589232, -84.564944),
    "32333": (30.591733, -84.574009),
    "32334": (30.288896, -84.848444),
    "32335": (30.288896, -84.848444),
    "32336": (30.298333, -83.900753),
    "32337": (30.342161, -83.840177),
    "32340": (30.527068, -83.388742),
    "32341": (30.47756, -83.391393),
    "32343": (30.565524, -84.429835),
    "32344": (30.504216, -83.843279),
    "32345": (30.342161, -83.840177),
    "32346": (30.021079, -84.386837),
    "32347": (29.931864, -83.55146),
    "32348": (29.966454, -83.659371),
    "32350": (30.584683, -83.328781),
    "32351": (30.555675, -84.63183),
    "32352": (30.665715, -84.75363),
    "32353": (30.549676, -84.606864),
    "32355": (30.163062, -84.208346),
    "32356": (29.853852, -83.442125),
    "32357": (30.214672, -83.711084),
    "32358": (30.141958, -84.552965),
    "32359": (29.693191, -83.37638),
    "32360": (30.288896, -84.848444),
    "32361": (30.342161, -83.840177),
    "32362": (30.319263, -84.267397),
    "32395": (30.479347, -84.346204),
    "32399": (30.449428, -84.29095),
    "32401": (30.1922, -85.663027),
    "32402": (30.234451, -85.692035),
    "32403": (30.086746, -85.630745),
    "32404": (30.14697, -85.521142),
    "32405": (30.205121, -85.668892),
    "32406": (30.234451, -85.692035),
    "32407": (30.200682, -85.813624),
    "32408": (30.165546, -85.711603),
    "32409": (30.311713, -85.692309),
    "32410": (29.939543, -85.409602),
    "32411": (30.234451, -85.692035),
    "32412": (30.234451, -85.692035),
    "32413": (30.169688999999998, -85.693681),
    "32417": (30.243832, -85.916988),
    "32420": (30.641158, -85.375585),
    "32421": (30.553171, -85.171315),
    "32422": (30.705557, -86.031448),
    "32423": (30.940432, -85.063884),
    "32424": (30.442582, -85.046048),
    "32425": (30.875532, -85.684243),
    "32426": (30.935644, -85.346802),
    "32427": (30.707368, -85.793737),
    "32428": (30.634834, -85.577618),
    "85367": (32.656575, -114.404216),
    "32430": (30.403984, -85.161075),
    "32431": (30.801747, -85.287774),
    "32432": (30.715807, -85.078384),
    "32433": (30.6393, -86.145909),
    "32434": (30.762486, -86.342683),
    "32435": (30.603777, -86.12111),
    "32437": (30.451272, -85.872398),
    "32438": (30.45245, -85.491959),
    "32439": (30.561269, -86.1706),
    "32440": (30.882994, -85.361113),
    "32442": (30.719031, -85.083627),
    "32443": (30.859204, -85.14758),
    "32444": (30.094456, -85.537104),
    "32445": (30.963462, -85.187828),
    "32446": (30.799574, -85.229347),
    "32447": (30.760299, -85.202225),
    "32448": (30.674946, -85.212174),
    "32449": (30.403984, -85.161075),
    "32452": (30.849972, -85.768022),
    "32454": (30.603777, -86.12111),
    "32455": (30.845927, -85.930198),
    "32456": (29.9323, -85.235414),
    "32457": (29.902484, -85.242169),
    "32459": (30.513484, -86.160893),
    "32460": (30.777608999999998, -84.955871),
    "32461": (30.252531, -85.942389),
    "32462": (30.591268, -85.739452),
    "32463": (30.639134, -85.587862),
    "32464": (30.872298, -85.929742),
    "32465": (30.025584, -85.215173),
    "32466": (30.383156, -85.51506),
    "32501": (30.424838, -87.256471),
    "32502": (30.474288, -87.225691),
    "32503": (30.462646, -87.216523),
    "32504": (30.488696, -87.214171),
    "32505": (30.457046, -87.257722),
    "32506": (30.391835, -87.348931),
    "32507": (30.358927, -87.380931),
    "32508": (30.359464, -87.312205),
    "32509": (30.464324, -87.340262),
    "32511": (30.61428, -87.275772),
    "32512": (30.394327, -87.299129),
    "32513": (30.557064, -87.259592),
    "32514": (30.537068, -87.241202),
    "32516": (30.61428, -87.275772),
    "32520": (30.412377, -87.203543),
    "32521": (30.61428, -87.275772),
    "32522": (30.61428, -87.275772),
    "32523": (30.61428, -87.275772),
    "32524": (30.61428, -87.275772),
    "32526": (30.493102, -87.359621),
    "32530": (30.598564, -87.031496),
    "32531": (30.85525, -86.674139),
    "32533": (30.665519, -87.350295),
    "32534": (30.534235, -87.292335),
    "32535": (30.955907, -87.364552),
    "32536": (30.713591, -86.557478),
    "32537": (30.741965, -86.655208),
    "32538": (30.970852999999998, -86.311093),
    "32539": (30.777294, -86.483154),
    "32540": (30.661155, -86.594479),
    "32541": (30.582064, -86.57345),
    "32542": (30.539331, -86.608737),
    "32544": (30.422926, -86.698525),
    "32547": (30.448726, -86.62545),
    "32548": (30.42057, -86.628607),
    "32549": (30.661155, -86.594479),
    "32559": (30.356287, -87.277307),
    "32560": (30.581825, -87.292918),
    "32561": (30.669276, -87.060696),
    "32562": (30.659159, -87.04972),
    "32563": (30.659159, -87.04972),
    "32564": (30.741616, -86.719764),
    "32565": (30.88276, -87.102495),
    "32566": (30.427685, -86.927118),
    "32567": (30.715985, -86.512784),
    "32568": (30.868646, -87.453852),
    "32569": (30.659587, -86.602385),
    "32570": (30.792885, -86.985834),
    "32571": (30.669808, -87.179447),
    "32572": (30.659159, -87.04972),
    "32573": (30.61428, -87.275772),
    "32574": (30.61428, -87.275772),
    "32575": (30.61428, -87.275772),
    "32576": (30.61428, -87.275772),
    "32577": (30.690231, -87.385248),
    "32578": (30.687036, -86.566325),
    "32579": (30.581826, -86.581628),
    "32580": (30.50821, -86.49706),
    "32581": (30.61428, -87.275772),
    "32582": (30.61428, -87.275772),
    "32583": (30.577638, -86.966835),
    "32588": (30.661155, -86.594479),
    "32589": (30.61428, -87.275772),
    "32590": (30.61428, -87.275772),
    "32591": (30.61428, -87.275772),
    "32592": (30.61428, -87.275772),
    "32593": (30.61428, -87.275772),
    "32594": (30.61428, -87.275772),
    "32595": (30.61428, -87.275772),
    "32596": (30.61428, -87.275772),
    "32597": (30.529739, -87.275693),
    "32598": (30.61428, -87.275772),
    "32601": (29.68041, -82.345739),
    "32602": (29.629887, -82.396567),
    "32603": (29.718806999999998, -82.353874),
    "32604": (29.573293, -82.397904),
    "32605": (29.677899, -82.466362),
    "32606": (29.697133, -82.403746),
    "32607": (29.653042, -82.440667),
    "32608": (29.575246, -82.407395),
    "32609": (29.761371, -82.398315),
    "32610": (29.681312, -82.353862),
    "32611": (29.681312, -82.353862),
    "32612": (29.681312, -82.353862),
    "32613": (29.681312, -82.353862),
    "32614": (29.681312, -82.353862),
    "32615": (29.813456, -82.472049),
    "32616": (29.792034, -82.495964),
    "32617": (29.337795, -82.082367),
    "32618": (29.569316, -82.506445),
    "32619": (29.749093, -82.865081),
    "32621": (29.431045, -82.549823),
    "32622": (29.905008, -82.298477),
    "32625": (29.188034, -82.991541),
    "32626": (29.389639, -82.834776),
    "32627": (29.681312, -82.353862),
    "32628": (29.680616, -83.089669),
    "32631": (29.730413, -82.097095),
    "32633": (29.681312, -82.353862),
    "32634": (29.35089, -82.27648),
    "32635": (29.681312, -82.353862),
    "32639": (29.24467, -82.740173),
    "32640": (29.642025, -82.327515),
    "32641": (29.682383, -82.201383),
    "32643": (29.740704, -82.366367),
    "32644": (29.460221, -82.855334),
    "32648": (29.538213, -83.19261),
    "32653": (29.772819, -82.378158),
    "32654": (29.681312, -82.353862),
    "32655": (29.817457, -82.60064),
    "32656": (29.813555, -81.946556),
    "32658": (29.826139, -82.416024),
    "32662": (29.681312, -82.353862),
    "32663": (29.342404, -82.212649),
    "32664": (29.437972, -82.229534),
    "32666": (29.697588, -81.97397),
    "32667": (29.565077, -82.417182),
    "32668": (29.328402, -82.703766),
    "32669": (29.687249, -82.564624),
    "32680": (29.669866, -83.004951),
    "32681": (29.428088, -82.24489),
    "32683": (29.310929, -82.794469),
    "32686": (29.362674, -82.254723),
    "32692": (29.329518, -83.139957),
    "32693": (29.674633, -82.811678),
    "32694": (29.7968, -82.156228),
    "32696": (29.354149, -82.635652),
    "32697": (29.931522, -82.425518),
    "32701": (28.666625, -81.365039),
    "32702": (29.059052, -81.581964),
    "32703": (28.635425, -81.488843),
    "32704": (28.566338000000002, -81.260818),
    "32706": (28.966351, -81.237061),
    "32707": (28.661468, -81.313989),
    "32708": (28.690114, -81.222547),
    "32709": (28.486379, -81.009032),
    "32710": (28.566338000000002, -81.260818),
    "32712": (28.731322, -81.537602),
    "32713": (28.889107, -81.319985),
    "32714": (28.688256, -81.280369),
    "32715": (28.744752, -81.22328),
    "32716": (28.744752, -81.22328),
    "32718": (28.744752, -81.22328),
    "32719": (28.744752, -81.22328),
    "32720": (29.07198, -81.403355),
    "32721": (28.997288, -81.299521),
    "32722": (29.022728999999998, -81.172169),
    "32724": (29.056227, -81.096461),
    "32725": (28.900274, -81.245074),
    "32726": (28.710129, -81.683696),
    "32727": (28.855517, -81.674147),
    "32728": (29.022728999999998, -81.172169),
    "32730": (28.651275, -81.34184),
    "32732": (28.751078, -81.107884),
    "32733": (28.613308, -81.258108),
    "32735": (28.904429, -81.743634),
    "32736": (28.910207, -81.523516),
    "32738": (28.939718, -81.233099),
    "32739": (29.022728999999998, -81.172169),
    "32744": (28.988027, -81.220829),
    "32746": (28.7577, -81.350772),
    "32747": (28.827219, -81.332888),
    "32750": (28.705924, -81.340639),
    "32751": (28.625476, -81.36459),
    "32752": (28.744752, -81.22328),
    "32754": (28.699314, -80.895344),
    "32756": (28.811078, -81.653642),
    "32757": (28.773952, -81.643943),
    "32759": (28.853312, -80.993118),
    "32762": (28.744752, -81.22328),
    "32763": (28.939904, -81.301856),
    "32764": (28.854824, -81.084188),
    "32765": (28.666574, -81.207353),
    "32766": (28.660674, -81.113444),
    "32767": (28.981525, -81.482049),
    "32768": (28.698542, -81.569764),
    "32771": (28.793491, -81.299169),
    "32772": (28.80722, -81.250236),
    "32773": (28.754582, -81.26418),
    "32774": (29.022728999999998, -81.172169),
    "32775": (28.77016, -80.872042),
    "32776": (28.831447, -81.505121),
    "32777": (28.566338000000002, -81.260818),
    "32778": (28.767762, -81.725272),
    "32779": (28.72449, -81.294452),
    "32780": (28.548877, -80.853421),
    "32781": (28.306726, -80.686159),
    "32782": (28.306726, -80.686159),
    "32783": (28.306726, -80.686159),
    "32784": (28.925371, -81.680144),
    "32789": (28.602327, -81.35874),
    "32790": (28.566338000000002, -81.260818),
    "32791": (28.744752, -81.22328),
    "32792": (28.597377, -81.303592),
    "32793": (28.566338000000002, -81.260818),
    "32794": (28.566338000000002, -81.260818),
    "32795": (28.744752, -81.22328),
    "32796": (28.509529, -80.831574),
    "32798": (28.717472, -81.583045),
    "32799": (28.744752, -81.22328),
    "32801": (28.545179, -81.373291),
    "32802": (28.519024, -81.343903),
    "32803": (28.556479, -81.33664),
    "32804": (28.575428, -81.395503),
    "32805": (28.52823, -81.408642),
    "32806": (28.51103, -81.357841),
    "32807": (28.551479, -81.30514),
    "32808": (28.580344, -81.439562),
    "32809": (28.463682, -81.394771),
    "32810": (28.59965, -81.433892),
    "32811": (28.51633, -81.451559),
    "32812": (28.470392, -81.386077),
    "32814": (28.566338000000002, -81.260818),
    "32815": (28.306726, -80.686159),
    "32816": (28.566338000000002, -81.260818),
    "32817": (28.589077, -81.227652),
    "32818": (28.594747, -81.496741),
    "32819": (28.452157, -81.46784),
    "32820": (28.572527, -81.121885),
    "32821": (28.385285, -81.472748),
    "32822": (28.494385, -81.29024),
    "32824": (28.43522, -81.349743),
    "32825": (28.535094, -81.220237),
    "32826": (28.510801999999998, -81.34349),
    "32827": (28.399634, -81.290418),
    "32828": (28.529582, -81.175502),
    "32829": (28.467101, -81.241651),
    "32830": (28.385549, -81.505894),
    "32831": (28.465553, -81.151009),
    "32832": (28.388834, -81.175651),
    "32833": (28.508779, -81.070334),
    "32834": (28.566338000000002, -81.260818),
    "32835": (28.52038, -81.483543),
    "32836": (28.411534, -81.525044),
    "32837": (28.390234, -81.433155),
    "32839": (28.489931, -81.406142),
    "32853": (28.566338000000002, -81.260818),
    "32854": (28.566338000000002, -81.260818),
    "32855": (28.550028, -81.104185),
    "32856": (28.548379, -81.420092),
    "32857": (28.566338000000002, -81.260818),
    "32858": (28.566338000000002, -81.260818),
    "32859": (28.442926, -81.402613),
    "32860": (28.566338000000002, -81.260818),
    "32861": (28.566338000000002, -81.260818),
    "32862": (28.417368, -81.332763),
    "32867": (28.566338000000002, -81.260818),
    "32868": (28.566338000000002, -81.260818),
    "32869": (28.566338000000002, -81.260818),
    "32872": (28.566338000000002, -81.260818),
    "32877": (28.566338000000002, -81.260818),
    "32878": (28.566338000000002, -81.260818),
    "32886": (28.566338000000002, -81.260818),
    "32887": (28.566338000000002, -81.260818),
    "32890": (28.566338000000002, -81.260818),
    "32891": (28.566338000000002, -81.260818),
    "32893": (28.566338000000002, -81.260818),
    "32897": (28.566338000000002, -81.260818),
    "32898": (28.566338000000002, -81.260818),
    "32899": (28.306726, -80.686159),
    "32901": (28.012189, -80.585519),
    "32902": (28.306726, -80.686159),
    "32903": (28.107943, -80.579625),
    "32904": (28.051946, -80.739647),
    "32905": (27.96861, -80.611642),
    "32906": (28.067128, -80.650341),
    "32907": (28.017577, -80.659539),
    "32908": (27.95504, -80.692096),
    "32909": (27.933086, -80.638504),
    "32910": (28.306726, -80.686159),
    "32911": (28.306726, -80.686159),
    "32912": (28.306726, -80.686159),
    "32919": (28.306726, -80.686159),
    "32920": (28.394642, -80.614323),
    "32922": (28.315086, -80.723445),
    "32923": (28.427535, -80.828991),
    "32924": (28.306726, -80.686159),
    "32925": (28.174349, -80.583979),
    "32926": (28.386561, -80.799662),
    "32927": (28.45663, -80.797847),
    "32931": (28.325685, -80.623424),
    "32932": (28.306726, -80.686159),
    "32934": (28.088526, -80.62782),
    "32935": (28.210733, -80.680583),
    "32936": (28.306726, -80.686159),
    "32937": (28.167091, -80.615835),
    "32940": (28.216262, -80.697829),
    "32941": (27.924577, -80.523463),
    "32948": (27.775251, -80.609403),
    "32949": (27.936416, -80.555597),
    "32950": (28.072093, -80.596021),
    "32951": (27.953124, -80.634),
    "32952": (28.276389, -80.656825),
    "32953": (28.388797, -80.730088),
    "32954": (28.22571, -80.673356),
    "32955": (28.28714, -80.723065),
    "32956": (28.329785, -80.732327),
    "32957": (27.709049, -80.572557),
    "32958": (27.799123, -80.483098),
    "32959": (28.306726, -80.686159),
    "32960": (27.638005, -80.40294),
    "32961": (27.617473, -80.423083),
    "32962": (27.658291, -80.476926),
    "32963": (27.689785, -80.375726),
    "32964": (27.709049, -80.572557),
    "32965": (27.709049, -80.572557),
    "32966": (27.697229, -80.631131),
    "32967": (27.696114, -80.467458),
    "32968": (27.588524, -80.525331),
    "32969": (27.709049, -80.572557),
    "32970": (27.752905, -80.474297),
    "32971": (27.709049, -80.572557),
    "32976": (27.867945, -80.541647),
    "32978": (27.709049, -80.572557),
    "33001": (24.83059, -80.804872),
    "33002": (25.558428, -80.458168),
    "33004": (26.062416, -80.159667),
    "33008": (26.145724, -80.448254),
    "33009": (25.992118, -80.146701),
    "33010": (25.829024, -80.286355),
    "33011": (25.558428, -80.458168),
    "33012": (25.859523, -80.22387),
    "33013": (25.860022999999998, -80.271571),
    "33014": (25.910972, -80.290572),
    "33015": (25.909923, -80.36122399999999),
    "33016": (25.891822, -80.372824),
    "33017": (25.558428, -80.458168),
    "33018": (25.909809, -80.388874),
    "33019": (26.091514, -80.192966),
    "33020": (26.022217, -80.155017),
    "33021": (26.023267, -80.211942),
    "33022": (26.013368, -80.144217),
    "33023": (25.996668, -80.257444),
    "33024": (26.029582, -80.248916),
    "33025": (26.142322, -80.231595),
    "33026": (26.153819, -80.25357),
    "33027": (26.039737, -80.365429),
    "33028": (26.004868, -80.313445),
    "33029": (26.097815, -80.319019),
    "33030": (25.558428, -80.458168),
    "33031": (25.558428, -80.458168),
    "33032": (25.558428, -80.458168),
    "33033": (25.558428, -80.458168),
    "33034": (25.558428, -80.458168),
    "33035": (25.558428, -80.458168),
    "33036": (24.90169, -80.682667),
    "33037": (24.963509, -80.961294),
    "33039": (25.558428, -80.458168),
    "33040": (24.655692, -81.382372),
    "33041": (25.100957, -81.568862),
    "33042": (24.860066, -81.003803),
    "33043": (24.687493, -81.249423),
    "33044": (24.664649, -81.565319),
    "33045": (25.100957, -81.568862),
    "33050": (24.687724, -81.294685),
    "33051": (24.72339, -81.020281),
    "33052": (24.723283, -81.063249),
    "33054": (25.924821, -80.324273),
    "33055": (25.94762, -80.277821),
    "33056": (25.94837, -80.24792),
    "33060": (26.240059, -80.139816),
    "33061": (26.253909, -80.134216),
    "33062": (26.178661, -80.144873),
    "33063": (26.267436, -80.209176),
    "33064": (26.22116, -80.125066),
    "33065": (26.22131, -80.26137),
    "33066": (26.251905999999998, -80.165406),
    "33067": (26.303307, -80.241539),
    "33068": (26.154262, -80.208569),
    "33069": (26.247379, -80.182393),
    "33070": (24.925108, -80.713465),
    "33071": (26.135692, -80.253284),
    "33072": (26.233459, -80.092365),
    "33073": (26.298352, -80.180078),
    "33074": (26.145724, -80.448254),
    "33075": (26.145724, -80.448254),
    "33076": (26.221054, -80.313415),
    "33077": (26.145724, -80.448254),
    "33081": (26.145724, -80.448254),
    "33082": (26.145724, -80.448254),
    "33083": (26.145724, -80.448254),
    "33084": (26.289057, -80.129816),
    "33090": (25.558428, -80.458168),
    "33092": (25.558428, -80.458168),
    "33093": (26.145724, -80.448254),
    "33097": (26.145724, -80.448254),
    "33101": (25.779076, -80.19782),
    "33102": (25.558428, -80.458168),
    "33107": (25.558428, -80.458168),
    "33109": (25.558428, -80.458168),
    "33110": (25.846874, -80.20827),
    "33111": (25.558428, -80.458168),
    "33114": (25.558428, -80.458168),
    "33116": (25.558428, -80.458168),
    "33119": (25.784526, -80.131967),
    "33121": (25.558428, -80.458168),
    "33122": (25.800075, -80.280972),
    "33124": (25.558428, -80.458168),
    "33125": (25.783676, -80.235421),
    "33126": (25.790376, -80.288372),
    "33127": (25.813625, -80.203169),
    "33128": (25.775926, -80.205019),
    "33129": (25.754277, -80.203519),
    "33130": (25.807425, -80.22952),
    "33131": (25.759926, -80.187519),
    "33132": (25.782275, -80.179407),
    "33133": (25.737777, -80.22477),
    "33134": (25.767977, -80.271372),
    "33135": (25.767476, -80.234971),
    "33136": (25.783426, -80.204469),
    "33137": (25.814275, -80.187219),
    "33138": (25.852073, -80.182118),
    "33139": (25.787326, -80.156368),
    "33140": (25.819825, -80.133717),
    "33141": (25.848623, -80.144617),
    "33142": (25.811575, -80.236821),
    "33143": (25.558428, -80.458168),
    "33144": (25.766427, -80.304172),
    "33145": (25.753877, -80.22527),
    "33146": (25.558428, -80.458168),
    "33147": (25.851523, -80.23812),
    "33148": (25.558428, -80.458168),
    "33149": (25.709978, -80.173295),
    "33150": (25.852273, -80.207219),
    "33151": (25.832074, -80.20942),
    "33152": (25.795476, -80.312873),
    "33153": (25.865523, -80.193619),
    "33154": (25.912671, -80.195719),
    "33155": (25.558428, -80.458168),
    "33156": (25.558428, -80.458168),
    "33157": (25.558428, -80.458168),
    "33158": (25.558428, -80.458168),
    "33159": (25.558428, -80.458168),
    "33160": (25.944859, -80.139067),
    "33161": (25.893422, -80.175768),
    "33162": (25.92862, -80.182969),
    "33163": (25.94497, -80.21452),
    "33164": (25.558428, -80.458168),
    "33165": (25.826996, -80.319991),
    "33166": (25.830124, -80.292572),
    "33167": (25.891872, -80.22267),
    "33168": (25.853667, -80.174618),
    "33169": (25.94262, -80.214621),
    "33170": (25.558428, -80.458168),
    "33172": (25.558428, -80.458168),
    "33173": (25.558428, -80.458168),
    "33174": (25.558428, -80.458168),
    "33175": (25.558428, -80.458168),
    "33176": (25.558428, -80.458168),
    "33177": (25.558428, -80.458168),
    "33178": (25.874473, -80.350023),
    "33179": (25.954336, -80.182018),
    "33180": (25.959719, -80.140267),
    "33181": (25.896522, -80.156988),
    "33182": (25.558428, -80.458168),
    "33183": (25.558428, -80.458168),
    "33184": (25.558428, -80.458168),
    "33185": (25.558428, -80.458168),
    "33186": (25.558428, -80.458168),
    "33187": (25.558428, -80.458168),
    "33188": (25.558428, -80.458168),
    "33189": (25.558428, -80.458168),
    "33190": (25.558428, -80.458168),
    "33192": (25.558428, -80.458168),
    "33193": (25.558428, -80.458168),
    "33194": (25.558428, -80.458168),
    "33195": (25.772876, -80.187019),
    "33196": (25.558428, -80.458168),
    "33197": (25.558428, -80.458168),
    "33199": (25.558428, -80.458168),
    "33231": (25.558428, -80.458168),
    "33233": (25.558428, -80.458168),
    "33234": (25.558428, -80.458168),
    "33238": (25.558428, -80.458168),
    "33239": (25.558428, -80.458168),
    "33242": (25.558428, -80.458168),
    "33243": (25.558428, -80.458168),
    "33245": (25.558428, -80.458168),
    "33247": (25.558428, -80.458168),
    "33255": (25.558428, -80.458168),
    "33256": (25.558428, -80.458168),
    "33257": (25.558428, -80.458168),
    "33261": (25.558428, -80.458168),
    "33265": (25.558428, -80.458168),
    "33266": (25.558428, -80.458168),
    "33269": (25.558428, -80.458168),
    "33280": (25.558428, -80.458168),
    "33283": (25.558428, -80.458168),
    "33296": (25.558428, -80.458168),
    "33299": (25.558428, -80.458168),
    "33301": (26.085115, -80.159317),
    "33302": (26.145724, -80.448254),
    "33303": (26.196911, -80.095165),
    "33304": (26.124513, -80.120216),
    "33305": (26.149662, -80.122916),
    "33306": (26.165612, -80.111766),
    "33307": (26.145724, -80.448254),
    "33308": (26.098414, -80.182168),
    "33309": (26.186109, -80.179318),
    "33310": (26.144263, -80.206919),
    "33311": (26.144303, -80.183868),
    "33312": (26.177411, -80.209085),
    "33313": (26.148662, -80.207519),
    "33314": (26.069666, -80.224569),
    "33315": (26.08329, -80.162266),
    "33316": (26.103114, -80.123866),
    "33317": (26.091765, -80.286534),
    "33318": (26.11842, -80.251988),
    "33319": (26.184761, -80.24057),
    "33320": (26.162462, -80.25822),
    "33321": (26.144589, -80.26052),
    "33322": (26.118845, -80.331401),
    "33323": (26.139766, -80.359157),
    "33324": (26.125463, -80.264371),
    "33325": (26.070747, -80.24417),
    "33326": (26.202757, -80.281527),
    "33327": (26.11363, -80.41699),
    "33328": (26.105514, -80.255133),
    "33329": (26.145724, -80.448254),
    "33330": (26.066316, -80.333872),
    "33331": (26.048032, -80.374894),
    "33332": (26.059583, -80.414605),
    "33334": (26.184511, -80.134366),
    "33335": (26.089215, -80.335973),
    "33337": (26.129013, -80.260071),
    "33338": (26.145724, -80.448254),
    "33339": (26.145724, -80.448254),
    "33340": (26.145724, -80.448254),
    "33345": (26.165424, -80.29589),
    "33346": (26.145724, -80.448254),
    "33348": (26.145724, -80.448254),
    "33349": (26.145724, -80.448254),
    "33351": (26.108554, -80.266437),
    "33355": (26.145724, -80.448254),
    "33359": (26.145724, -80.448254),
    "33388": (26.120864, -80.25327),
    "33394": (26.122063, -80.138967),
    "33401": (26.672643, -80.070613),
    "33402": (26.645895, -80.430269),
    "33403": (26.645895, -80.430269),
    "33404": (26.645895, -80.430269),
    "33405": (26.645895, -80.430269),
    "33406": (26.639594, -80.082714),
    "33407": (26.645895, -80.430269),
    "33408": (26.645895, -80.430269),
    "33409": (26.645895, -80.430269),
    "33410": (26.598446, -80.054613),
    "33411": (26.664443, -80.174116),
    "33412": (26.645895, -80.430269),
    "33413": (26.655494, -80.159616),
    "33414": (26.645659, -80.25144),
    "33415": (26.656044, -80.125952),
    "33416": (26.665394, -80.092864),
    "33417": (26.645895, -80.430269),
    "33418": (26.645895, -80.430269),
    "33419": (26.645895, -80.430269),
    "33420": (26.645895, -80.430269),
    "33421": (26.645895, -80.430269),
    "33422": (26.645895, -80.430269),
    "33424": (26.645895, -80.430269),
    "33425": (26.645895, -80.430269),
    "33426": (26.528233, -80.084764),
    "33427": (26.375954, -80.10717),
    "33428": (26.348017, -80.218991),
    "33429": (26.645895, -80.430269),
    "33430": (26.645895, -80.430269),
    "33431": (26.378704, -80.104343),
    "33432": (26.384203, -80.081114),
    "33433": (26.350274, -80.158367),
    "33434": (26.381132, -80.170567),
    "33435": (26.518049, -80.079114),
    "33436": (26.535402, -80.112447),
    "33437": (26.513629, -80.174297),
    "33438": (26.645895, -80.430269),
    "33439": (26.645895, -80.430269),
    "33440": (26.630066, -81.090897),
    "33441": (26.273761, -80.140769),
    "33442": (26.301407, -80.138516),
    "33443": (26.145724, -80.448254),
    "33444": (26.457598, -80.081614),
    "33445": (26.548504, -80.100015),
    "33446": (26.454017, -80.181862),
    "33447": (26.645895, -80.430269),
    "33448": (26.645895, -80.430269),
    "33454": (26.645895, -80.430269),
    "33455": (27.050934, -80.158594),
    "33458": (26.645895, -80.430269),
    "33459": (26.645895, -80.430269),
    "33460": (26.619627, -80.059063),
    "33461": (26.619546, -80.091704),
    "33462": (26.574736, -80.079405),
    "33463": (26.595537, -80.129065),
    "33464": (26.645895, -80.430269),
    "33465": (26.628272, -80.132569),
    "33466": (26.645895, -80.430269),
    "33467": (26.595867, -80.22087),
    "33468": (26.645895, -80.430269),
    "33469": (26.645895, -80.430269),
    "33470": (26.649816, -80.294771),
    "33471": (26.886471, -81.195575),
    "33474": (26.645895, -80.430269),
    "33475": (27.110182, -80.454196),
    "33476": (26.623067, -80.17864),
    "33477": (26.645895, -80.430269),
    "33478": (26.645895, -80.430269),
    "33480": (26.600995, -80.038113),
    "33481": (26.645895, -80.430269),
    "33482": (26.645895, -80.430269),
    "33483": (26.464145, -80.064844),
    "33484": (26.454218, -80.13473),
    "33486": (26.348292999999998, -80.117265),
    "33487": (26.411642, -80.09277),
    "33488": (26.645895, -80.430269),
    "33493": (26.645895, -80.430269),
    "33496": (26.409333, -80.162567),
    "33497": (26.645895, -80.430269),
    "33498": (26.39341, -80.222751),
    "33499": (26.645895, -80.430269),
    "33503": (27.764761, -82.273409),
    "33509": (28.119579, -82.451959),
    "33510": (27.83083, -82.356458),
    "33511": (27.903679, -82.294021),
    "33513": (28.676288, -82.149168),
    "33514": (28.668112999999998, -82.02883),
    "33521": (28.775537, -82.059745),
    "33523": (28.36886, -82.322756),
    "33524": (28.182209, -82.152341),
    "33525": (28.331765, -82.244624),
    "33526": (28.310134, -82.247783),
    "33527": (27.975742, -82.240415),
    "33530": (27.906823, -82.176749),
    "33534": (27.911823, -82.385728),
    "33537": (28.324796, -82.481766),
    "33538": (28.781677, -82.121086),
    "33539": (28.21305, -82.16568),
    "33540": (28.240942, -82.156491),
    "33541": (28.240543, -82.446251),
    "33543": (28.20592, -82.306326),
    "33544": (28.271989, -82.284738),
    "33547": (27.893718, -82.205331),
    "33548": (27.871964, -82.438841),
    "33549": (28.060825, -82.391666),
    "33550": (27.871964, -82.438841),
    "33556": (28.128688, -82.584113),
    "33564": (28.029627, -82.134741),
    "33565": (28.082724, -82.156607),
    "33566": (28.008056, -82.341905),
    "33567": (27.980218, -82.322484),
    "33568": (27.871964, -82.438841),
    "33569": (27.846419, -82.301249),
    "33570": (27.69913, -82.45263),
    "33571": (27.720111, -82.453041),
    "33572": (27.84579, -82.331983),
    "33573": (27.704045999999998, -82.35742),
    "33574": (28.334752, -82.269323),
    "33576": (28.331729, -82.300982),
    "33583": (27.871964, -82.438841),
    "33584": (27.999687, -82.287957),
    "33585": (28.735643, -82.061556),
    "33586": (27.871964, -82.438841),
    "33587": (27.871964, -82.438841),
    "33592": (28.092775, -82.278977),
    "33593": (28.324796, -82.481766),
    "33594": (27.937779, -82.347371),
    "33595": (27.871964, -82.438841),
    "33597": (28.647306, -82.108078),
    "33598": (27.73383, -82.297468),
    "33601": (27.996097, -82.582035),
    "33602": (27.950898, -82.461517),
    "33603": (27.986147, -82.463804),
    "33604": (28.014096, -82.449816),
    "33605": (27.946665, -82.427265),
    "33606": (27.930552, -82.465326),
    "33607": (27.966697, -82.556868),
    "33608": (27.84343, -82.488413),
    "33609": (27.942648, -82.513067),
    "33610": (27.995997, -82.375733),
    "33611": (27.942099, -82.512017),
    "33612": (28.054195, -82.442683),
    "33613": (28.077403, -82.444209),
    "33614": (28.031495, -82.496367),
    "33615": (28.039847, -82.548749),
    "33616": (27.867201, -82.529567),
    "33617": (28.030714, -82.386351),
    "33618": (28.076299, -82.485188),
    "33619": (27.92485, -82.379447),
    "33620": (28.059994, -82.407887),
    "33621": (27.849135, -82.494582),
    "33622": (27.871964, -82.438841),
    "33623": (27.871964, -82.438841),
    "33624": (28.074809, -82.554404),
    "33625": (28.072671, -82.559501),
    "33626": (28.066478, -82.611596),
    "33629": (27.921056, -82.508867),
    "33630": (27.871964, -82.438841),
    "33631": (27.871964, -82.438841),
    "33633": (27.871964, -82.438841),
    "33634": (28.002755, -82.545466),
    "33635": (28.026337, -82.613819),
    "33637": (28.047044, -82.363024),
    "33647": (28.127834, -82.350338),
    "33650": (27.871964, -82.438841),
    "33651": (27.871964, -82.438841),
    "33655": (27.871964, -82.438841),
    "33660": (27.871964, -82.438841),
    "33661": (27.871964, -82.438841),
    "33662": (27.871964, -82.438841),
    "33663": (27.871964, -82.438841),
    "33664": (27.871964, -82.438841),
    "33672": (27.871964, -82.438841),
    "33673": (27.871964, -82.438841),
    "33674": (27.871964, -82.438841),
    "33675": (27.871964, -82.438841),
    "33677": (27.871964, -82.438841),
    "33679": (27.871964, -82.438841),
    "33680": (27.871964, -82.438841),
    "33681": (27.871964, -82.438841),
    "33682": (27.871964, -82.438841),
    "33684": (27.871964, -82.438841),
    "33685": (27.871964, -82.438841),
    "33686": (27.871964, -82.438841),
    "33687": (27.871964, -82.438841),
    "33688": (27.871964, -82.438841),
    "33689": (27.871964, -82.438841),
    "33690": (27.871964, -82.438841),
    "33694": (27.871964, -82.438841),
    "33697": (27.871964, -82.438841),
    "33701": (27.775654, -82.64092),
    "33702": (27.863201, -82.631509),
    "33703": (27.816003, -82.62092),
    "33704": (27.798053, -82.63077),
    "33705": (27.743555, -82.64182),
    "33706": (27.749529, -82.754223),
    "33707": (27.757005, -82.726422),
    "33708": (27.811608, -82.80143),
    "33709": (27.820082, -82.730798),
    "33710": (27.788853, -82.699621),
    "33711": (27.733448, -82.690035),
    "33712": (27.735925, -82.672426),
    "33713": (27.789403, -82.677321),
    "33714": (27.817335, -82.68324),
    "33715": (27.670536, -82.711927),
    "33716": (27.890727, -82.692961),
    "33728": (27.891809, -82.724763),
    "33729": (27.881909, -82.664359),
    "33730": (27.891809, -82.724763),
    "33731": (27.891809, -82.724763),
    "33732": (27.891809, -82.724763),
    "33733": (27.925755, -82.75211),
    "33734": (27.891809, -82.724763),
    "33736": (27.891809, -82.724763),
    "33737": (27.891809, -82.724763),
    "33738": (27.891809, -82.724763),
    "33740": (27.891809, -82.724763),
    "33741": (27.891809, -82.724763),
    "33742": (27.891809, -82.724763),
    "33743": (27.891809, -82.724763),
    "33744": (27.891809, -82.724763),
    "33747": (27.891809, -82.724763),
    "33755": (27.978147, -82.78152299999999),
    "33756": (27.946998, -82.794324),
    "33757": (27.891809, -82.724763),
    "33758": (27.891809, -82.724763),
    "33759": (27.984851, -82.704321),
    "33760": (27.90045, -82.715166),
    "33761": (27.925501, -82.725852),
    "33762": (27.89417, -82.674571),
    "33763": (28.017296, -82.746082),
    "33764": (27.916038, -82.734299),
    "33765": (27.990179, -82.743298),
    "33766": (27.891809, -82.724763),
    "33767": (27.959847, -82.828625),
    "33769": (27.891809, -82.724763),
    "33770": (27.916998, -82.802668),
    "33771": (27.908479, -82.756823),
    "33772": (27.846601, -82.795385),
    "33773": (27.88015, -82.753373),
    "33774": (27.883949, -82.826525),
    "33775": (27.891809, -82.724763),
    "33776": (27.850547, -82.826267),
    "33777": (27.854588, -82.754528),
    "33778": (27.88403, -82.802466),
    "33779": (27.839698, -82.772483),
    "33780": (27.891809, -82.724763),
    "33781": (27.868101, -82.758523),
    "33782": (27.868115, -82.708639),
    "33784": (27.891809, -82.724763),
    "33785": (27.886757, -82.843525),
    "33786": (27.922922, -82.839325),
    "33801": (28.059997, -81.956122),
    "33802": (28.020992, -81.985185),
    "33803": (27.894389, -81.850798),
    "33804": (28.002553, -81.61864),
    "33805": (28.094746, -81.947117),
    "33806": (28.002553, -81.61864),
    "33807": (28.002553, -81.61864),
    "33809": (28.176194, -81.959132),
    "33810": (28.147923, -82.037153),
    "33811": (27.986538, -82.013855),
    "33813": (27.963896, -81.917604),
    "33815": (28.049648, -82.006855),
    "33820": (28.002553, -81.61864),
    "33823": (28.086751, -81.742864),
    "33825": (27.473059, -81.464053),
    "33826": (27.339483, -81.252872),
    "33827": (27.906571, -81.549715),
    "33830": (27.918445, -81.790794),
    "33831": (27.955426, -81.951673),
    "33834": (27.601936, -81.85069),
    "33835": (27.699258, -81.949419),
    "33836": (28.167211, -81.631589),
    "33837": (28.164093, -81.647317),
    "33838": (28.009099, -81.677776),
    "33839": (28.005662, -81.702448),
    "33840": (28.084383, -81.5415),
    "33841": (27.742463, -81.723311),
    "33843": (27.72938, -81.55934),
    "33844": (28.075834, -81.592933),
    "33845": (28.002553, -81.61864),
    "33846": (27.964651, -81.867153),
    "33847": (27.984091, -81.716682),
    "33848": (28.263489, -81.512387),
    "33849": (28.197539, -82.039587),
    "33850": (28.092424, -81.727551),
    "33851": (28.036937, -81.627998),
    "33852": (27.336002, -81.36628),
    "33853": (27.991865, -81.480831),
    "33854": (28.002553, -81.61864),
    "33855": (27.798022, -81.357154),
    "33856": (27.855686, -81.430915),
    "33857": (27.391447, -81.228096),
    "33858": (28.050121, -81.505211),
    "33859": (27.885359, -81.522998),
    "33860": (27.844612, -81.835864),
    "33862": (27.244668, -81.288424),
    "33863": (28.002553, -81.61864),
    "33865": (27.450538, -81.899723),
    "33867": (27.768567, -81.19664),
    "33868": (28.03668, -81.760824),
    "33870": (27.457947, -81.373012),
    "33871": (27.485803, -81.407884),
    "33872": (27.393804, -81.287076),
    "33873": (27.518602, -81.784123),
    "33877": (27.976883, -81.614414),
    "33880": (27.987284, -81.762456),
    "33881": (28.06374, -81.711071),
    "33882": (28.029402, -81.732139),
    "33883": (28.002553, -81.61864),
    "33884": (28.053322, -81.668575),
    "33885": (28.002553, -81.61864),
    "33888": (28.023115, -81.723417),
    "33890": (27.457687, -81.721609),
    "33901": (26.564355, -81.925065),
    "33902": (26.623908, -81.883648),
    "33903": (26.693048, -81.912454),
    "33904": (26.606491, -81.95016),
    "33905": (26.607784, -81.832214),
    "33906": (26.552895, -81.94861),
    "33907": (26.634845, -81.959923),
    "33908": (26.561955, -81.911422),
    "33909": (26.623638, -81.968),
    "33910": (26.552895, -81.94861),
    "33911": (26.596286, -81.882373),
    "33912": (26.563728, -81.726965),
    "33913": (26.529206, -81.693572),
    "33914": (26.622535, -81.923974),
    "33915": (26.659942, -81.893427),
    "33916": (26.635461, -81.843807),
    "33917": (26.648211, -81.844716),
    "33918": (26.71613, -81.607007),
    "33919": (26.572627, -81.937186),
    "33920": (26.595182, -81.6815),
    "33921": (26.754493, -82.261149),
    "33922": (26.624433, -82.128052),
    "33924": (26.521464, -82.180242),
    "33927": (26.901981, -82.000005),
    "33928": (26.472274, -81.705902),
    "33930": (26.612772, -81.479912),
    "33931": (26.5761, -82.071178),
    "33932": (26.552895, -81.94861),
    "33935": (26.690881, -81.448873),
    "33936": (26.593573, -81.661922),
    "33938": (26.901981, -82.000005),
    "33944": (26.946449, -81.309114),
    "33945": (26.658313, -82.1434),
    "33946": (26.879424, -82.266405),
    "33947": (26.884228, -82.269126),
    "33948": (26.94099, -82.20688),
    "33949": (26.993904, -82.098418),
    "33950": (26.860103, -82.013411),
    "33951": (26.970756, -81.984504),
    "33952": (26.994048, -82.156128),
    "33953": (26.997956, -82.200524),
    "33954": (27.019741, -82.123194),
    "33955": (26.828631, -81.909078),
    "33956": (26.575762, -82.107459),
    "33957": (26.458308, -82.100065),
    "33960": (27.120281, -81.390945),
    "33965": (26.552895, -81.94861),
    "33970": (26.564718, -81.620778),
    "33971": (26.589408, -81.670757),
    "33972": (26.641661, -81.913575),
    "33975": (26.763312, -81.438833),
    "33980": (26.986122, -82.055747),
    "33981": (26.93457, -82.232398),
    "33982": (26.959685, -81.819036),
    "33983": (27.001845, -82.018382),
    "33990": (26.6265, -81.967657),
    "33991": (26.628091, -82.018158),
    "33993": (26.678619, -82.025384),
    "33994": (26.552895, -81.94861),
    "34101": (25.855534, -81.38719),
    "34102": (26.133968, -81.795309),
    "34103": (26.191666, -81.803944),
    "34104": (26.178752, -81.745447),
    "34105": (26.193769, -81.763609),
    "34106": (26.14326, -81.389124),
    "34107": (26.14326, -81.389124),
    "34108": (26.241595, -81.807056),
    "34109": (26.253416, -81.764364),
    "34110": (26.282328, -81.757284),
    "34112": (26.118429, -81.736052),
    "34113": (26.042638, -81.718172),
    "34114": (26.014314, -81.585552),
    "34116": (26.187256, -81.711048),
    "34117": (26.115558, -81.523853),
    "34119": (26.239288, -81.66871),
    "34120": (26.330438, -81.587104),
    "34133": (26.552895, -81.94861),
    "34134": (26.362566, -81.818279),
    "34135": (26.377129, -81.733377),
    "34136": (26.552895, -81.94861),
    "34137": (26.14326, -81.389124),
    "34138": (25.836746, -81.121963),
    "34139": (25.856971, -81.377791),
    "34140": (26.14326, -81.389124),
    "34141": (25.873412, -81.159938),
    "34142": (26.18437, -81.415175),
    "34143": (26.464183, -81.504661),
    "34145": (25.938768, -81.696751),
    "34146": (26.14326, -81.389124),
    "34201": (27.404731, -82.470456),
    "34202": (27.471379, -82.37934),
    "34203": (27.454723, -82.535883),
    "34204": (27.427213, -82.438689),
    "34205": (27.466869, -82.456033),
    "34206": (27.427213, -82.438689),
    "34207": (27.439419, -82.577779),
    "34208": (27.467817, -82.512018),
    "34209": (27.475853, -82.616719),
    "34210": (27.473598, -82.660725),
    "34215": (27.471256, -82.682262),
    "34216": (27.529113, -82.731722),
    "34217": (27.485915, -82.710221),
    "34218": (27.499515, -82.709871),
    "34219": (27.566457, -82.269458),
    "34220": (27.427213, -82.438689),
    "34221": (27.577315, -82.516004),
    "34222": (27.546332, -82.496732),
    "34223": (27.143931, -82.404959),
    "34224": (27.064882, -82.400124),
    "34228": (27.357231, -82.443071),
    "34229": (27.213378, -82.488818),
    "34230": (27.335023, -82.537169),
    "34231": (27.227589, -82.432111),
    "34232": (27.203872, -82.443249),
    "34233": (27.127372, -82.423776),
    "34234": (27.368769, -82.526768),
    "34235": (27.363072, -82.478376),
    "34236": (27.326863, -82.543319),
    "34237": (27.337173, -82.514176),
    "34238": (27.242689, -82.475145),
    "34239": (27.310774, -82.520868),
    "34240": (27.231941, -82.3504),
    "34241": (27.241077, -82.351349),
    "34242": (27.256626, -82.539819),
    "34243": (27.415606, -82.528065),
    "34250": (27.572236, -82.583168),
    "34251": (27.372771, -82.225911),
    "34260": (27.427213, -82.438689),
    "34264": (27.427213, -82.438689),
    "34265": (27.186146, -81.809939),
    "34266": (27.186075, -81.866661),
    "34267": (27.186146, -81.809939),
    "34268": (27.203827, -81.864443),
    "34270": (27.405429, -82.543519),
    "34272": (27.146963, -82.425512),
    "34274": (27.144031, -82.464468),
    "34275": (27.229227, -82.459848),
    "34276": (27.167521, -82.380967),
    "34277": (27.167521, -82.380967),
    "34278": (27.331628, -82.528488),
    "34280": (27.427213, -82.438689),
    "34281": (27.427213, -82.438689),
    "34282": (27.427213, -82.438689),
    "34284": (27.167521, -82.380967),
    "34285": (27.09639, -82.433818),
    "34286": (27.074755, -82.175602),
    "34287": (27.189487, -82.334882),
    "34292": (27.090034, -82.370028),
    "34293": (27.060576, -82.352038),
    "34295": (27.085985, -82.438918),
    "85369": (32.751632, -114.074901),
    "34420": (29.101476, -82.044371),
    "34421": (29.240728, -82.087458),
    "34423": (28.867027, -82.572703),
    "34428": (28.958393, -82.599279),
    "34429": (28.904358, -82.596051),
    "34430": (29.240728, -82.087458),
    "34431": (29.09481, -82.249223),
    "34432": (29.101529, -82.34129),
    "34433": (28.994902, -82.519629),
    "34434": (28.993778, -82.424132),
    "34436": (28.73035, -82.307734),
    "34442": (28.922317, -82.390044),
    "34445": (28.948753, -82.406476),
    "34446": (28.7508, -82.513889),
    "34447": (28.804911, -82.574264),
    "34448": (28.787963, -82.567981),
    "34449": (29.095501, -82.656099),
    "34450": (28.834011, -82.282224),
    "34451": (28.803207, -82.32167),
    "34452": (28.777849, -82.360295),
    "34453": (28.872256, -82.345411),
    "34460": (28.859286, -82.508694),
    "34461": (28.819711, -82.464061),
    "34464": (28.859286, -82.508694),
    "34465": (28.817853, -82.446209),
    "34470": (29.238672, -82.169401),
    "34471": (29.160525, -81.942516),
    "34472": (29.125344, -82.008571),
    "34473": (29.113464, -82.195635),
    "34474": (29.150148, -82.137774),
    "34475": (29.154639, -82.304525),
    "34476": (29.115896, -82.242211),
    "34477": (29.240728, -82.087458),
    "34478": (29.187178, -82.112278),
    "34479": (29.178235, -82.02819),
    "34480": (29.180072, -82.03227),
    "34481": (29.128062, -82.297544),
    "34482": (29.261079, -82.219513),
    "34483": (29.240728, -82.087458),
    "34484": (28.905906, -82.061193),
    "34487": (28.859286, -82.508694),
    "34488": (29.263549, -81.95316),
    "34489": (29.215153, -82.097163),
    "34491": (29.01123, -82.032463),
    "34492": (28.99796, -82.016139),
    "34498": (29.030531, -82.719003),
    "34601": (28.586197, -82.395858),
    "34602": (28.509319, -82.295675),
    "34603": (28.564167, -82.416515),
    "34605": (28.505896, -82.422554),
    "34606": (28.496411, -82.40101),
    "34607": (28.504888, -82.625672),
    "34608": (28.483643, -82.542698),
    "34609": (28.494344, -82.450658),
    "34610": (28.377455, -82.524063),
    "34611": (28.564167, -82.416515),
    "34613": (28.604951, -82.531987),
    "34614": (28.627958, -82.536465),
    "34636": (28.65503, -82.267706),
    "34639": (28.250774, -82.46263),
    "34652": (28.239369, -82.736882),
    "34653": (28.242508, -82.695536),
    "34654": (28.296388, -82.617095),
    "34655": (28.216016, -82.67162),
    "34656": (28.324796, -82.481766),
    "34660": (28.067043, -82.778424),
    "34661": (28.64364, -82.263836),
    "34667": (28.382489, -82.64803),
    "34668": (28.297976, -82.704101),
    "34669": (28.360086, -82.62074),
    "34673": (28.324796, -82.481766),
    "34674": (28.324796, -82.481766),
    "34677": (28.050324, -82.677379),
    "34679": (28.430213, -82.661555),
    "34680": (28.324796, -82.481766),
    "34681": (28.087401, -82.777683),
    "34682": (27.891809, -82.724763),
    "34683": (28.074144, -82.744889),
    "34684": (28.084797, -82.725257),
    "34685": (28.109717, -82.692882),
    "34688": (27.891809, -82.724763),
    "34689": (28.092104, -82.732165),
    "34690": (28.191434, -82.724448),
    "34691": (28.196394, -82.762191),
    "34695": (28.017645, -82.747692),
    "34697": (27.891809, -82.724763),
    "34698": (28.010895, -82.773995),
    "34705": (28.706723, -81.718455),
    "34711": (28.584025, -81.779423),
    "34712": (28.811078, -81.653642),
    "34713": (28.811078, -81.653642),
    "34729": (28.811078, -81.653642),
    "34731": (28.863361, -81.905624),
    "34734": (28.538407, -81.520774),
    "34736": (28.587996, -81.870269),
    "34737": (28.697081, -81.797564),
    "34739": (27.933215, -81.092447),
    "34740": (28.545385, -81.650667),
    "34741": (28.307138, -81.461385),
    "34742": (27.995287, -81.259332),
    "34743": (28.326039, -81.405894),
    "34744": (28.297638, -81.32402),
    "34745": (27.995287, -81.259332),
    "34746": (28.243011, -81.400997),
    "34747": (28.303738, -81.589782),
    "34748": (28.758895, -81.888695),
    "34749": (28.811078, -81.653642),
    "34753": (28.58299, -81.894119),
    "34755": (28.578234, -81.831883),
    "34756": (28.581499, -81.685146),
    "34758": (28.203877, -81.487992),
    "34759": (28.094636, -81.498979),
    "34760": (28.550978, -81.621546),
    "34761": (28.569438, -81.530251),
    "34762": (28.74751, -81.895885),
    "34769": (28.230351, -81.359092),
    "34770": (27.995287, -81.259332),
    "34771": (28.246439, -81.231589),
    "34772": (28.172669, -81.26899),
    "34773": (28.146663, -80.993806),
    "34777": (28.541579, -81.605846),
    "34778": (28.566338000000002, -81.260818),
    "34785": (28.844473, -82.078342),
    "34786": (28.481031, -81.543979),
    "34787": (28.468581, -81.512343),
    "34788": (28.888724, -81.782704),
    "34789": (28.811078, -81.653642),
    "34797": (28.712017, -81.808159),
    "34945": (27.412128, -80.534169),
    "34946": (27.511616, -80.364447),
    "34947": (27.445611, -80.387742),
    "34948": (27.382196, -80.409024),
    "34949": (27.456687, -80.285812),
    "34950": (27.448066, -80.333224),
    "34951": (27.513925, -80.457475),
    "34952": (27.312492, -80.313322),
    "34953": (27.257707, -80.380277),
    "34954": (27.382196, -80.409024),
    "34956": (27.106451, -80.45192),
    "34957": (27.236473, -80.237943),
    "34958": (27.242402, -80.224613),
    "34972": (27.420316, -80.945361),
    "34973": (27.297631, -80.802656),
    "34974": (27.216626, -80.827757),
    "34979": (27.382196, -80.409024),
    "34981": (27.391213, -80.374042),
    "34982": (27.362859, -80.307717),
    "34983": (27.347284, -80.347722),
    "34984": (27.251266, -80.345407),
    "34985": (27.382196, -80.409024),
    "34986": (27.333392, -80.397427),
    "34987": (27.29076, -80.484851),
    "34988": (27.386818, -80.503746),
    "34990": (27.111235, -80.419042),
    "34991": (27.110182, -80.454196),
    "34992": (27.110182, -80.454196),
    "34994": (27.189748, -80.254768),
    "34995": (27.17537, -80.241512),
    "34996": (27.205819, -80.195911),
    "34997": (27.108081, -80.230818),
    "35004": (33.603543, -86.466833),
    "35005": (33.578097, -86.987228),
    "35006": (33.437653, -87.207592),
    "35007": (33.193415, -86.794377),
    "35010": (32.930079, -85.805026),
    "35011": (32.990191, -85.958001),
    "35013": (33.922162, -86.449262),
    "35014": (33.403969, -86.233878),
    "35015": (33.544622, -86.929208),
    "35016": (34.393855, -86.365403),
    "35019": (34.265451, -86.712779),
    "35020": (33.441602, -86.88857),
    "35021": (33.544622, -86.929208),
    "35022": (33.352745, -86.968328),
    "35023": (33.478989, -86.944763),
    "35031": (34.091285, -86.559625),
    "35032": (33.256886, -86.338572),
    "35033": (33.957886, -87.003767),
    "35034": (32.989499, -87.220392),
    "35035": (33.016616, -86.9598),
    "35036": (33.63628, -86.916202),
    "35038": (33.804411, -87.202136),
    "35040": (33.138832, -86.725315),
    "35041": (33.64672, -86.931818),
    "35042": (32.948233, -87.139316),
    "35043": (33.298238, -86.656328),
    "35044": (33.245885, -86.364148),
    "35045": (32.856632, -86.652875),
    "35046": (32.886365, -86.648931),
    "35048": (33.544622, -86.929208),
    "35049": (33.977816, -86.55985),
    "35051": (33.232849, -86.554849),
    "35052": (33.589518, -86.392283),
    "35053": (34.044614, -87.051404),
    "35054": (33.529643, -86.300691),
    "35055": (34.111067, -86.853185),
    "35056": (34.196448, -86.895226),
    "35057": (34.087769, -86.944713),
    "35058": (34.209766, -86.752029),
    "35060": (33.558905, -86.929443),
    "35061": (33.460807, -86.960864),
    "35062": (33.735709, -87.054641),
    "35063": (33.827269, -87.027469),
    "35064": (33.475407, -86.925391),
    "35068": (33.601739, -86.826491),
    "35070": (34.005773, -86.74995),
    "35071": (33.70615, -86.848289),
    "35072": (33.058725, -86.079106),
    "35073": (33.659545, -86.801693),
    "35074": (33.202691, -87.118044),
    "35077": (34.034276, -86.841753),
    "35078": (33.199274, -86.459291),
    "35079": (33.953352, -86.745469),
    "35080": (33.266341, -86.901975),
    "35082": (33.116229, -86.138624),
    "35083": (34.152149, -86.791286),
    "35085": (32.970056, -86.734146),
    "35087": (34.272537, -86.576125),
    "35089": (32.934298, -86.095801),
    "35091": (33.769928, -86.800573),
    "35094": (33.51828, -86.584472),
    "35096": (33.445821, -86.255605),
    "35097": (33.904975, -86.626094),
    "35098": (34.137678, -87.026554),
    "35111": (33.299704, -87.048881),
    "35112": (33.695814, -86.46564),
    "35114": (33.337916, -86.733796),
    "35115": (33.136658, -86.883586),
    "35116": (33.727106, -86.763967),
    "35117": (33.637322, -86.875181),
    "35118": (33.536339, -87.051031),
    "35119": (33.650832, -86.769698),
    "35120": (33.657096, -86.38336),
    "35121": (33.968171, -86.5535),
    "35123": (33.544622, -86.929208),
    "35124": (33.293157, -86.767961),
    "35125": (33.592484, -86.325995),
    "35126": (33.72988, -86.645081),
    "35127": (33.549138, -86.884204),
    "35128": (33.587299, -86.336607),
    "35130": (33.721814, -87.124359),
    "35131": (33.715229, -86.24746),
    "35133": (33.845846, -86.586724),
    "35135": (33.622079, -86.221589),
    "35136": (32.897085, -86.156068),
    "35137": (33.206302, -86.781162),
    "35139": (33.711096, -86.975856),
    "35142": (33.406869, -86.87347),
    "35143": (33.080188, -86.550392),
    "35144": (33.28241, -86.683891),
    "35146": (33.705871, -86.403202),
    "35147": (33.419068, -86.544426),
    "35148": (33.757716, -87.0461),
    "35149": (33.272776, -86.204925),
    "35150": (33.316003, -86.228703),
    "35151": (33.175552, -86.357359),
    "35160": (33.387375, -86.144681),
    "35161": (33.420206, -86.102782),
    "35171": (32.893156, -86.756368),
    "35172": (33.810179, -86.724855),
    "35173": (33.646334, -86.58589),
    "35175": (34.433986, -86.501338),
    "35176": (33.464255, -86.509972),
    "35178": (33.309634, -86.5613),
    "35179": (34.258747, -86.925471),
    "35180": (33.790134, -86.829871),
    "35181": (33.544622, -86.929208),
    "35182": (33.706786, -86.256658),
    "35183": (33.06767, -86.303403),
    "35184": (33.102111, -87.141467),
    "35185": (33.335629, -86.543692),
    "35186": (33.285635, -86.496647),
    "35187": (33.08104, -86.879328),
    "35188": (33.17994, -87.165935),
    "35201": (33.456412, -86.801904),
    "35202": (33.544622, -86.929208),
    "35203": (33.519204, -86.807889),
    "35204": (33.524455, -86.837898),
    "35205": (33.569398, -86.782584),
    "35206": (33.566137, -86.705192),
    "35207": (33.572576, -86.837341),
    "35208": (33.498055, -86.879941),
    "35209": (33.465336, -86.808213),
    "35210": (33.579661, -86.734969),
    "35211": (33.45717, -86.864909),
    "35212": (33.547803, -86.749538),
    "35213": (33.455408, -86.749588),
    "35214": (33.575142, -86.905859),
    "35215": (33.542055, -86.80604),
    "35216": (33.56014, -86.78134),
    "35217": (33.56076, -86.856553),
    "35218": (33.506305, -86.895191),
    "35219": (33.544622, -86.929208),
    "35220": (33.544622, -86.929208),
    "35221": (33.453807, -86.898341),
    "35222": (33.523204, -86.763788),
    "35223": (33.499513, -86.726838),
    "35224": (33.521455, -86.974735),
    "35225": (33.544622, -86.929208),
    "35226": (33.396723, -86.834563),
    "35228": (33.455807, -86.911841),
    "35229": (33.462856, -86.790389),
    "35230": (33.544622, -86.929208),
    "35231": (33.544622, -86.929208),
    "35232": (33.544622, -86.929208),
    "35233": (33.508205, -86.802339),
    "35234": (33.513505, -86.83244),
    "35235": (33.632816, -86.649293),
    "35236": (33.544622, -86.929208),
    "35237": (33.544622, -86.929208),
    "35238": (33.544622, -86.929208),
    "35240": (33.425892, -86.776926),
    "35242": (33.381339, -86.704571),
    "35243": (33.445932, -86.750203),
    "35244": (33.351944, -86.949784),
    "35245": (33.544622, -86.929208),
    "35246": (33.544622, -86.929208),
    "35249": (33.544622, -86.929208),
    "35253": (33.544622, -86.929208),
    "35254": (33.544622, -86.929208),
    "35255": (33.544622, -86.929208),
    "35259": (33.544622, -86.929208),
    "35260": (33.544622, -86.929208),
    "35261": (33.544622, -86.929208),
    "35263": (33.522505, -86.80939),
    "35266": (33.372861, -86.853075),
    "35277": (33.544622, -86.929208),
    "35278": (33.544622, -86.929208),
    "35279": (33.544622, -86.929208),
    "35280": (33.544622, -86.929208),
    "35281": (33.544622, -86.929208),
    "35282": (33.544622, -86.929208),
    "35283": (33.544622, -86.929208),
    "35285": (33.544622, -86.929208),
    "35286": (33.544622, -86.929208),
    "35287": (33.544622, -86.929208),
    "35288": (33.445808, -86.928542),
    "35289": (33.544622, -86.929208),
    "35290": (33.544622, -86.929208),
    "35291": (33.544622, -86.929208),
    "35292": (33.544622, -86.929208),
    "35293": (33.544622, -86.929208),
    "35294": (33.544622, -86.929208),
    "35295": (33.544622, -86.929208),
    "35296": (33.544622, -86.929208),
    "35297": (33.544622, -86.929208),
    "35298": (33.544622, -86.929208),
    "35299": (33.544622, -86.929208),
    "35401": (33.241899, -87.597599),
    "35402": (33.306606, -87.453224),
    "35403": (33.20445, -87.526953),
    "35404": (33.182563, -87.482744),
    "35405": (33.10407, -87.518144),
    "35406": (33.335596, -87.533495),
    "35407": (33.306606, -87.453224),
    "35440": (33.311014, -87.18975),
    "35441": (32.855347, -87.721868),
    "35442": (33.236962, -88.061517),
    "35443": (32.737366, -87.967724),
    "35444": (33.333139, -87.277818),
    "35446": (33.230568, -87.754733),
    "35447": (33.289682, -88.117113),
    "35448": (32.835692, -87.956884),
    "35449": (33.135876, -87.338369),
    "35452": (33.293358, -87.688789),
    "35453": (33.18178, -87.383843),
    "35456": (33.072735, -87.432921),
    "35457": (33.294004, -87.776584),
    "35458": (33.367757, -87.801689),
    "35459": (32.621168, -88.285932),
    "35460": (32.672049, -88.120605),
    "35461": (33.413277, -88.209276),
    "35462": (32.836298, -87.893016),
    "35463": (33.084337, -87.697507),
    "35464": (32.778274, -88.145715),
    "35466": (33.290717, -87.875835),
    "35468": (33.306606, -87.453224),
    "35469": (32.835692, -87.956884),
    "35470": (32.571432, -88.133322),
    "35471": (33.262603, -88.088514),
    "35473": (33.347539, -87.537152),
    "35474": (32.910756, -87.593514),
    "35475": (33.39924, -87.559894),
    "35476": (33.356502, -87.538006),
    "35477": (32.872597, -88.237388),
    "35478": (33.306606, -87.453224),
    "35480": (33.127407, -87.762393),
    "35481": (33.314928, -88.042923),
    "35482": (33.306606, -87.453224),
    "35485": (33.306606, -87.453224),
    "35486": (33.272662, -87.793794),
    "35487": (33.307222, -87.585902),
    "35490": (33.226133, -87.225842),
    "35491": (32.835692, -87.956884),
    "35501": (33.796234, -87.316923),
    "35502": (33.901993, -87.293888),
    "35503": (33.915182, -87.307386),
    "35504": (33.818309, -87.235474),
    "35540": (34.229897, -87.358538),
    "35541": (34.095345, -87.188237),
    "35542": (33.712675, -87.774117),
    "35543": (34.16493, -87.739592),
    "35544": (33.950211, -88.018981),
    "35545": (33.645228, -87.923872),
    "35546": (33.634468, -87.676862),
    "35548": (34.038126, -87.75667),
    "35549": (33.772696, -87.455456),
    "35550": (33.740956, -87.225644),
    "35551": (34.145939, -87.373241),
    "35552": (34.025325, -88.153299),
    "35553": (34.121357, -87.360437),
    "35554": (33.92856, -87.613508),
    "35555": (33.72005, -87.809908),
    "35559": (33.889566, -87.696401),
    "35560": (33.679503, -87.237372),
    "35563": (34.078901, -87.813808),
    "35564": (34.122514, -87.828236),
    "35565": (34.179569, -87.505293),
    "35570": (34.167583, -87.994648),
    "35571": (34.373392, -87.946916),
    "35572": (34.188775, -87.2786),
    "35573": (33.92169, -87.524264),
    "35574": (33.615308, -87.99477),
    "35575": (34.049571, -87.552646),
    "35576": (33.606342, -88.131425),
    "35577": (34.093409, -87.600815),
    "35578": (33.885529, -87.469627),
    "35579": (33.664909, -87.376844),
    "35580": (33.713348, -87.298601),
    "35581": (34.390917, -87.859392),
    "35582": (34.453468, -88.067792),
    "35584": (33.820144, -87.077898),
    "35585": (34.424572, -87.81446),
    "35586": (33.854224, -88.10667),
    "35587": (33.793322, -87.440648),
    "35592": (33.732286, -88.086009),
    "35593": (34.404307, -87.954816),
    "35594": (34.062, -87.814078),
    "35601": (34.549833, -86.995551),
    "35602": (34.606216, -87.088142),
    "35603": (34.53832, -86.96556),
    "35609": (34.495365, -86.82993),
    "35610": (34.942388, -87.273375),
    "35611": (34.764976, -87.103488),
    "35612": (34.774907, -87.030479),
    "35613": (34.831704, -86.886679),
    "35614": (34.847364, -87.060696),
    "35615": (34.774907, -87.030479),
    "35616": (34.733866, -87.90624),
    "35617": (34.869964, -87.706859),
    "35618": (34.673954, -87.28962),
    "35619": (34.459389, -87.054151),
    "35620": (34.899993, -86.972554),
    "35621": (34.367528, -86.73641),
    "35622": (34.361909, -86.899143),
    "35630": (34.869601, -87.686915),
    "35631": (34.869964, -87.706859),
    "35632": (34.869964, -87.706859),
    "35633": (34.880706, -87.742362),
    "35634": (34.900446, -87.794596),
    "35640": (34.491606, -86.934715),
    "35643": (34.635459, -87.267871),
    "35645": (34.907715, -87.50135),
    "35646": (34.677233, -87.53399),
    "35647": (34.959647, -87.100579),
    "35648": (34.944077, -87.365663),
    "35649": (34.625877, -86.874641),
    "35650": (34.492894, -87.299281),
    "35651": (34.47926, -87.476911),
    "35652": (34.844868, -87.321426),
    "35653": (34.444903, -87.854726),
    "35654": (34.46752, -87.647762),
    "35660": (34.691165, -87.710054),
    "35661": (34.758537, -87.70004),
    "35662": (34.757152, -87.966575),
    "35670": (34.436256, -86.729737),
    "35671": (34.679634, -86.962519),
    "35672": (34.633251, -87.418659),
    "35673": (34.591393, -87.078896),
    "35674": (34.66604, -87.749232),
    "35677": (34.925311, -87.991142),
    "35699": (34.495365, -86.82993),
    "35739": (34.961697, -86.844257),
    "35740": (34.799983, -85.803464),
    "35741": (34.719303, -86.475425),
    "35742": (34.774907, -87.030479),
    "35744": (34.60335, -85.911106),
    "35745": (34.925315, -86.190432),
    "35746": (34.75343, -85.98022),
    "35747": (34.41847, -86.289976),
    "35748": (34.722737, -86.40353),
    "35749": (34.829768, -86.703349),
    "35750": (34.937132, -86.581015),
    "35751": (34.79549, -86.274287),
    "35752": (34.807443, -85.887684),
    "35754": (34.50544, -86.62488),
    "35755": (34.733585, -86.020239),
    "35756": (34.651409, -86.754233),
    "35757": (34.778246, -86.744163),
    "35758": (34.710815, -86.742478),
    "35759": (34.88186, -86.555622),
    "35760": (34.56112, -86.385064),
    "35761": (34.893332, -86.452042),
    "35762": (34.733964, -86.522913),
    "35763": (34.724161, -86.464438),
    "35764": (34.703063, -86.306794),
    "35765": (34.669329, -86.016699),
    "35766": (34.871329, -86.251275),
    "35767": (34.733964, -86.522913),
    "35768": (34.750724, -86.142151),
    "35769": (34.617951, -86.056162),
    "35771": (34.671536, -85.958355),
    "35772": (34.856233, -85.871317),
    "35773": (34.904492, -86.681104),
    "35774": (34.717551, -86.073788),
    "35775": (34.541985, -86.687136),
    "35776": (34.746425, -86.076117),
    "35801": (34.718428, -86.556439),
    "35802": (34.660866, -86.560608),
    "35803": (34.58639, -86.536754),
    "35804": (34.728366, -86.585312),
    "35805": (34.702327, -86.628864),
    "35806": (34.76184, -86.686994),
    "35807": (34.733964, -86.522913),
    "35808": (34.677627, -86.612147),
    "35809": (34.733964, -86.522913),
    "35810": (34.797685, -86.593583),
    "35811": (34.791497, -86.513152),
    "35812": (34.733964, -86.522913),
    "35813": (34.733964, -86.522913),
    "35814": (34.733964, -86.522913),
    "35815": (34.733964, -86.522913),
    "35816": (34.753078, -86.628643),
    "35824": (34.645603, -86.752294),
    "35893": (34.733964, -86.522913),
    "35894": (34.733964, -86.522913),
    "35895": (34.733964, -86.522913),
    "35896": (34.733964, -86.522913),
    "35897": (34.733964, -86.522913),
    "35898": (34.733964, -86.522913),
    "35899": (34.733897999999996, -86.645592),
    "35901": (34.024285, -86.074145),
    "35902": (33.984062, -85.803434),
    "35903": (33.984547, -85.907668),
    "35904": (34.05744, -86.107869),
    "35905": (33.93523, -85.957593),
    "35906": (34.033764, -86.085173),
    "35907": (33.959647, -85.973173),
    "35950": (34.314291, -86.242033),
    "35951": (34.322334, -86.193529),
    "35952": (34.07097, -86.209599),
    "35953": (33.785173, -86.216884),
    "35954": (34.051848, -86.061397),
    "35956": (34.267, -86.166021),
    "35957": (34.280737, -86.229092),
    "35958": (34.917606, -85.64924),
    "35959": (34.359072, -85.611793),
    "35960": (34.110859, -85.590218),
    "35961": (34.337295, -85.85769),
    "35962": (34.302028, -86.004164),
    "35963": (34.359123, -85.923978),
    "35964": (34.34962, -86.319824),
    "35966": (34.803085, -85.720245),
    "35967": (34.417112, -85.828068),
    "35968": (34.507242, -85.797851),
    "35971": (34.43038, -85.898669),
    "35972": (34.00233, -86.224672),
    "35973": (34.373726, -85.557307),
    "35974": (34.359204, -86.02397),
    "35975": (34.435197, -86.038915),
    "35976": (34.344851, -86.27518),
    "35978": (34.600393, -85.730615),
    "35979": (34.839084, -85.619582),
    "35980": (34.209898, -86.343937),
    "35981": (34.719358, -85.658943),
    "35983": (34.144013, -85.748018),
    "35984": (34.556856, -85.578584),
    "35986": (34.419163, -85.761585),
    "35987": (33.916778, -86.243593),
    "35988": (34.570198, -85.729289),
    "35989": (34.4879, -85.689133),
    "35990": (34.056618, -86.275434),
    "36003": (32.450328, -86.721712),
    "36005": (31.839131, -85.928538),
    "36006": (32.576407, -86.711472),
    "36008": (32.501649, -86.572711),
    "36009": (31.560143, -86.327501),
    "36010": (31.713427, -85.816261),
    "36013": (32.310624, -86.186132),
    "36015": (31.642713, -86.734317),
    "36016": (31.805322, -85.421299),
    "36017": (31.749142, -85.561944),
    "36020": (32.505625, -86.332245),
    "36022": (32.614355, -86.35842),
    "36023": (32.800155, -85.803427),
    "36024": (32.645178, -86.036529),
    "36025": (32.632954, -86.134553),
    "36026": (32.77522, -86.1216),
    "36027": (31.914745, -85.389969),
    "36028": (31.518541, -86.354365),
    "36029": (32.092808, -85.704649),
    "36030": (31.850138, -86.837211),
    "36031": (32.250651, -85.752417),
    "36032": (32.01285, -86.608238),
    "36033": (31.624666, -86.634844),
    "36034": (31.611203, -86.167727),
    "36035": (31.810302, -86.092603),
    "36036": (32.011697, -86.166847),
    "36037": (31.796729, -86.596233),
    "36038": (31.260882, -86.444833),
    "36039": (32.293879, -85.813517),
    "36040": (32.152198, -86.597157),
    "36041": (31.945789, -86.306248),
    "36042": (31.871334, -86.405406),
    "36043": (32.206441, -86.380464),
    "36045": (32.587631, -86.132981),
    "36046": (32.081409, -86.356906),
    "36047": (32.072616, -86.510331),
    "36048": (31.785579, -85.551104),
    "36049": (31.754655, -86.291595),
    "36051": (32.601807, -86.516424),
    "36052": (32.239196, -86.036354),
    "36053": (32.092808, -85.704649),
    "36054": (32.584717, -86.225602),
    "36057": (32.233377, -86.208528),
    "36061": (32.092808, -85.704649),
    "36062": (31.74589, -86.323949),
    "36064": (32.296092, -86.09259),
    "36065": (32.072585, -86.060586),
    "36066": (32.50919, -86.440879),
    "36067": (32.540642, -86.658347),
    "36068": (32.507893, -86.666272),
    "36069": (32.089321, -86.174619),
    "36071": (31.706155, -86.371489),
    "36072": (31.826055, -85.166028),
    "36075": (32.383939, -85.910123),
    "36078": (32.594995, -85.985078),
    "36079": (31.802786, -85.954983),
    "36080": (32.700393, -86.257604),
    "36081": (31.869128, -85.966268),
    "36082": (31.816474, -85.964713),
    "36083": (32.372144, -85.66671),
    "36087": (32.40926, -85.738032),
    "36088": (32.414501, -85.72525),
    "36089": (32.142191, -85.742406),
    "36091": (32.776052, -86.644088),
    "36092": (32.592659, -86.215304),
    "36093": (32.562179, -86.099371),
    "36101": (32.356988, -86.257817),
    "36102": (32.233377, -86.208528),
    "36103": (32.346158, -86.287316),
    "36104": (32.373788, -86.289182),
    "36105": (32.22558, -86.290586),
    "36106": (32.353338, -86.257517),
    "36107": (32.380587, -86.280718),
    "36108": (32.340688, -86.37382),
    "36109": (32.390547, -86.239667),
    "36110": (32.441374, -86.253327),
    "36111": (32.342438, -86.267317),
    "36112": (32.374287, -86.345719),
    "36113": (32.384587, -86.303868),
    "36114": (32.403987, -86.253867),
    "36115": (32.407587, -86.247417),
    "36116": (32.285501, -86.228765),
    "36117": (32.370048, -86.116486),
    "36118": (32.233377, -86.208528),
    "36119": (32.233377, -86.208528),
    "36120": (32.233377, -86.208528),
    "36121": (32.233377, -86.208528),
    "36123": (32.233377, -86.208528),
    "36124": (32.233377, -86.208528),
    "36125": (32.233377, -86.208528),
    "36130": (32.233377, -86.208528),
    "36131": (32.233377, -86.208528),
    "36132": (32.233377, -86.208528),
    "36133": (32.233377, -86.208528),
    "36134": (32.233377, -86.208528),
    "36135": (32.233377, -86.208528),
    "36140": (32.233377, -86.208528),
    "36141": (32.233377, -86.208528),
    "36142": (32.233377, -86.208528),
    "36177": (32.233377, -86.208528),
    "36191": (32.233377, -86.208528),
    "36201": (33.759768, -85.792328),
    "36202": (33.762195, -85.837828),
    "36203": (33.725908, -85.899397),
    "36204": (33.762195, -85.837828),
    "36205": (33.735842, -85.793257),
    "36206": (33.806783, -85.759952),
    "36207": (33.720373, -85.753344),
    "36250": (33.780861, -85.904456),
    "36251": (33.234539, -85.847477),
    "36253": (33.762195, -85.837828),
    "36254": (33.657348999999996, -85.699116),
    "36255": (33.193639, -85.745014),
    "36256": (33.022741, -85.696391),
    "36257": (33.762195, -85.837828),
    "36258": (33.418514, -85.711041),
    "36260": (33.640094, -85.991753),
    "36261": (33.706595, -85.509902),
    "36262": (33.779335, -85.463112),
    "36263": (33.456308, -85.369167),
    "36264": (33.627166, -85.502022),
    "36265": (33.853627, -85.758295),
    "36266": (33.340127, -85.789238),
    "36267": (33.18082, -85.941752),
    "36268": (33.486183, -85.920854),
    "36269": (33.729152, -85.394198),
    "36270": (33.42978, -85.468493),
    "36271": (33.807215, -85.905573),
    "36272": (33.827328, -85.795257),
    "36273": (33.565683, -85.38201),
    "36274": (33.216876, -85.405707),
    "36275": (33.977829, -85.552143),
    "36276": (33.207578, -85.480892),
    "36277": (33.81408, -85.835693),
    "36278": (33.318053, -85.498377),
    "36279": (33.866182, -85.87097),
    "36280": (33.351626, -85.372497),
    "36301": (31.148124, -85.371845),
    "36302": (31.156018, -85.355931),
    "36303": (31.160148, -85.322984),
    "36304": (31.156018, -85.355931),
    "36305": (31.219697, -85.4828),
    "36310": (31.559402, -85.222965),
    "36311": (31.455485, -85.633907),
    "36312": (31.189627, -85.262314),
    "36313": (31.150094, -85.813687),
    "36314": (31.096354, -85.83934),
    "36316": (31.176749, -85.813483),
    "36317": (31.407872, -85.603458),
    "36318": (31.149764, -85.946093),
    "36319": (31.22514, -85.171875),
    "36320": (31.099623, -85.314295),
    "36321": (31.202473, -85.301373),
    "36322": (31.272415, -85.705129),
    "36323": (31.407434, -86.083517),
    "36330": (31.315846, -85.942956),
    "36331": (31.297817, -85.90364),
    "36340": (31.053473, -85.784393),
    "36343": (31.080374, -85.168005),
    "36344": (31.105822, -85.690252),
    "36345": (31.357917, -85.30124),
    "36346": (31.565157, -85.970956),
    "36349": (31.121244, -85.559235),
    "36350": (31.33494, -85.511331),
    "36351": (31.398322, -85.927933),
    "36352": (31.352897, -85.659319),
    "36353": (31.411109, -85.366472),
    "36360": (31.450171, -85.65182),
    "36361": (31.407872, -85.603458),
    "36362": (31.327347, -85.737811),
    "36370": (31.14031, -85.157345),
    "36371": (31.307446, -85.52633),
    "36373": (31.501041999999998, -85.113506),
    "36374": (31.574779, -85.536957),
    "36375": (31.137138, -85.564508),
    "36376": (31.252306, -85.264387),
    "36401": (31.489241, -87.052004),
    "36420": (31.304166, -86.386398),
    "36425": (31.56779, -87.250028),
    "36426": (31.129427, -87.096126),
    "36427": (31.091784, -87.26404),
    "36429": (31.466945, -87.044687),
    "36431": (31.529531, -87.345345),
    "36432": (31.370941, -86.998104),
    "36435": (31.871803, -87.412893),
    "36436": (31.58842, -87.840875),
    "36439": (31.429472, -87.339329),
    "36441": (31.060013, -87.199942),
    "36442": (31.019653, -86.329568),
    "36444": (31.590428, -87.447935),
    "36445": (31.522005, -87.381527),
    "36446": (31.782639, -87.741085),
    "36449": (31.529531, -87.345345),
    "36451": (31.704953, -87.801307),
    "36453": (31.238943, -86.124023),
    "36454": (31.466945, -87.044687),
    "36455": (31.260882, -86.444833),
    "36456": (31.546733, -86.713793),
    "36457": (31.361214, -87.435279),
    "36458": (31.514659, -87.408362),
    "36460": (31.56713, -87.314222),
    "36461": (31.522093, -87.341108),
    "36462": (31.529531, -87.345345),
    "36467": (31.260401, -86.356208),
    "36470": (31.508073, -87.428429),
    "36471": (31.606263, -87.21944),
    "36473": (31.466945, -87.044687),
    "36474": (31.260882, -86.444833),
    "36475": (31.371175, -87.298377),
    "36476": (31.260882, -86.444833),
    "36477": (31.07181, -86.113647),
    "36480": (31.541789, -87.500236),
    "36481": (31.808458, -87.316372),
    "36482": (31.67448, -87.675884),
    "36483": (31.022268, -86.629331),
    "36501": (31.482494, -87.880106),
    "36502": (31.119972, -87.470001),
    "36503": (31.128242, -87.152068),
    "36504": (31.015817, -87.497165),
    "36505": (30.939368, -88.015868),
    "36507": (30.763492, -87.756371),
    "36509": (30.419006, -88.253643),
    "36511": (30.465497, -87.753507),
    "36512": (30.658865, -88.177975),
    "36513": (31.406683, -88.175846),
    "36515": (31.58842, -87.840875),
    "36518": (31.436682, -88.245363),
    "36521": (30.929148, -88.181921),
    "36522": (30.798501, -88.273482),
    "36523": (30.390301, -88.207586),
    "36524": (31.816246, -88.061865),
    "36525": (30.944616, -88.090905),
    "36526": (30.540328, -87.6912),
    "36527": (30.737792, -87.900287),
    "36528": (30.254867, -88.1349),
    "36529": (31.406683, -88.175846),
    "36530": (30.412773, -87.549041),
    "36532": (30.562883, -87.810464),
    "36533": (30.484131, -87.860613),
    "36535": (30.467608, -87.692401),
    "36536": (30.42216, -87.706371),
    "36538": (31.406683, -88.175846),
    "36539": (31.406683, -88.175846),
    "36540": (31.58842, -87.840875),
    "36541": (30.498046, -88.332468),
    "36542": (30.284936, -87.794246),
    "36543": (31.216132, -87.461537),
    "36544": (30.479141, -88.232843),
    "36545": (31.592985, -87.898539),
    "36547": (30.265325, -87.629926),
    "36548": (31.406683, -88.175846),
    "36549": (30.39736, -87.458796),
    "36550": (31.22896, -87.713373),
    "36551": (30.513519, -87.667604),
    "36553": (31.209178, -88.075266),
    "36555": (30.427641, -87.796011),
    "36556": (31.406683, -88.175846),
    "36558": (31.553004, -88.294124),
    "36559": (30.562308, -87.900545),
    "36560": (31.080313, -88.057203),
    "36561": (30.281046, -87.581457),
    "36562": (31.040286, -87.666699),
    "36564": (30.475955, -87.917867),
    "36567": (30.749915, -87.577231),
    "36568": (30.49434, -88.269865),
    "36569": (31.552362, -88.090115),
    "36570": (31.58842, -87.840875),
    "36571": (30.869984, -88.118401),
    "36572": (30.585158, -88.087879),
    "36574": (30.51715, -87.603901),
    "36575": (30.779545, -88.272544),
    "36576": (30.527068, -87.735),
    "36577": (30.732789, -87.70195),
    "36578": (30.85852, -87.728987),
    "36579": (31.079113, -87.798576),
    "36580": (30.468691, -87.703035),
    "36581": (31.369572, -88.012236),
    "36582": (30.486565, -88.20225),
    "36583": (31.406683, -88.175846),
    "36584": (31.213691, -88.393047),
    "36585": (31.406683, -88.175846),
    "36586": (31.58842, -87.840875),
    "36587": (30.812649, -88.318487),
    "36590": (30.487953, -88.253278),
    "36601": (30.701142, -88.103184),
    "36602": (30.692389, -88.046698),
    "36603": (30.69117, -88.057773),
    "36604": (30.684039, -88.067048),
    "36605": (30.601842, -88.118975),
    "36606": (30.66709, -88.1052),
    "36607": (30.788123, -88.088073),
    "36608": (30.639867, -88.25445),
    "36609": (30.551887, -88.185603),
    "36610": (30.7309, -88.078949),
    "36611": (30.768787, -88.11085),
    "36612": (30.747387, -88.118001),
    "36613": (30.769758, -88.196296),
    "36614": (30.601892, -88.211103),
    "36615": (30.64109, -88.062248),
    "36616": (30.671048, -88.126656),
    "36617": (30.715588, -88.096),
    "36618": (30.681689, -88.149001),
    "36619": (30.462987, -88.216493),
    "36621": (30.658865, -88.177975),
    "36622": (30.658865, -88.177975),
    "36623": (30.658865, -88.177975),
    "36625": (30.658865, -88.177975),
    "36626": (30.658865, -88.177975),
    "36628": (30.658865, -88.177975),
    "36630": (30.658865, -88.177975),
    "36631": (30.658865, -88.177975),
    "36633": (30.658865, -88.177975),
    "36640": (30.658865, -88.177975),
    "36641": (30.658865, -88.177975),
    "36644": (30.658865, -88.177975),
    "36652": (30.658865, -88.177975),
    "36660": (30.658865, -88.177975),
    "36663": (30.81901, -88.231726),
    "36670": (30.658865, -88.177975),
    "36671": (30.658865, -88.177975),
    "36675": (30.658865, -88.177975),
    "36685": (30.658865, -88.177975),
    "36688": (30.696589, -88.173652),
    "36689": (30.658865, -88.177975),
    "36690": (30.658865, -88.177975),
    "36691": (30.658865, -88.177975),
    "36693": (30.635741, -88.174502),
    "36695": (30.666959, -88.226989),
    "36701": (32.43372, -87.055532),
    "36702": (32.419259, -87.124708),
    "36703": (32.467164, -86.959844),
    "36720": (32.145564, -87.354953),
    "36721": (32.048079, -87.26226),
    "36722": (32.051214, -87.569778),
    "36723": (32.082415, -87.294855),
    "36726": (31.998366, -87.351944),
    "36727": (31.58842, -87.840875),
    "36728": (32.192472, -87.467873),
    "36732": (32.384949, -87.824556),
    "36736": (32.261286, -87.77611),
    "36738": (32.365963, -87.721033),
    "36740": (32.610762, -87.844122),
    "36741": (32.006129, -86.981703),
    "36742": (32.52418, -87.672092),
    "36744": (32.699872, -87.586079),
    "36745": (32.414036, -87.898611),
    "36748": (32.321943, -87.749847),
    "36749": (32.510383, -86.813834),
    "36750": (32.83217, -86.843808),
    "36751": (31.902773, -87.577911),
    "36752": (32.294321, -86.647119),
    "36753": (32.048079, -87.26226),
    "36754": (32.129123, -87.706019),
    "36756": (32.608995, -87.350401),
    "36758": (32.484147, -87.076236),
    "36759": (32.388235, -87.26262),
    "36761": (32.189926, -87.063331),
    "36762": (31.940191, -88.00336),
    "36763": (32.251626, -87.949363),
    "36764": (32.268329, -87.795275),
    "36765": (32.58819, -87.56625),
    "36766": (31.947005, -87.074497),
    "36767": (32.289861, -87.219864),
    "36768": (31.932526, -87.044855),
    "36769": (31.994807, -87.545406),
    "36773": (32.322859, -87.376446),
    "36775": (32.213977, -87.078655),
    "36776": (32.755975, -87.705829),
    "36778": (32.01998, -87.054284),
    "36779": (32.591207, -87.271667),
    "36782": (32.131469, -87.83266),
    "36783": (32.302397, -87.678612),
    "36784": (31.745135, -87.769476),
    "36785": (32.323895, -86.86458),
    "36786": (32.446243, -87.503256),
    "36790": (32.723537, -86.875759),
    "36792": (32.931293, -86.917506),
    "36793": (32.891444, -86.983385),
    "36801": (32.621147, -85.392878),
    "36802": (32.578185, -85.349003),
    "36803": (32.522567, -85.431517),
    "36804": (32.576792, -85.311984),
    "36830": (32.547542, -85.468222),
    "36831": (32.578185, -85.349003),
    "36832": (32.592036, -85.518913),
    "36849": (32.578185, -85.349003),
    "36850": (32.808407, -85.703776),
    "36851": (32.286092, -85.161497),
    "36852": (32.783136999999996, -85.275581),
    "36853": (32.794796, -85.744428),
    "36854": (32.885631, -85.264695),
    "36855": (32.91934, -85.311223),
    "36856": (32.296518, -84.997165),
    "36858": (32.295844, -85.292938),
    "36859": (32.229846, -85.008178),
    "36860": (32.238147, -85.36233),
    "36861": (32.900767, -85.822787),
    "36862": (32.912315, -85.388079),
    "36863": (32.900173, -85.296659),
    "36865": (32.578185, -85.349003),
    "36866": (32.536635, -85.697354),
    "36867": (32.375318, -85.203923),
    "36868": (32.464614, -85.020604),
    "36869": (32.318701, -85.111997),
    "36870": (32.478145, -85.123979),
    "36871": (32.166569, -85.165575),
    "36872": (32.578185, -85.349003),
    "36874": (32.580449, -85.217224),
    "36875": (32.257831, -85.129772),
    "36877": (32.558314, -85.091498),
    "36879": (32.681539, -85.565954),
    "36901": (32.467134, -88.140634),
    "36904": (32.115939, -88.273598),
    "36906": (32.004227, -88.200738),
    "36907": (32.435545, -88.329881),
    "36908": (31.922384, -88.323669),
    "36910": (32.004227, -88.200738),
    "36912": (32.233182, -88.321388),
    "36913": (32.004227, -88.200738),
    "36915": (32.004227, -88.200738),
    "36916": (32.209362, -88.048983),
    "36919": (31.947815, -88.32911),
    "36921": (31.915506, -88.151048),
    "36922": (32.210259, -88.065479),
    "36925": (32.444907, -88.193305),
    "37010": (36.556825, -87.018127),
    "37011": (36.170556, -86.8825),
    "37012": (36.034524, -85.997115),
    "37013": (36.036032, -86.645598),
    "37014": (35.856609, -86.663307),
    "37015": (36.297807, -87.083657),
    "37016": (35.933832, -86.112561),
    "37018": (35.643787, -86.183248),
    "37019": (35.431968, -86.762712),
    "37020": (35.580793, -86.399852),
    "37022": (36.477191, -86.460853),
    "37023": (36.580898, -87.774854),
    "37024": (35.874553, -86.907565),
    "37025": (35.92171, -87.348964),
    "37026": (35.701738, -86.107742),
    "37027": (35.982981, -86.816058),
    "37028": (36.584621, -87.843106),
    "37029": (36.039122, -87.26284),
    "37030": (36.276278, -85.95174),
    "37031": (36.380555, -86.310674),
    "37032": (36.521638, -87.008437),
    "37033": (35.750099, -87.502405),
    "37034": (35.640617, -86.718225),
    "37035": (36.376837, -87.112668),
    "37036": (36.232191, -87.278993),
    "37037": (35.695974, -86.368041),
    "37040": (36.51674, -87.308491),
    "37041": (36.477428, -87.377197),
    "37042": (36.501766, -87.399188),
    "37043": (36.512666, -87.301283),
    "37044": (36.531398, -87.353008),
    "37046": (35.790897, -86.726133),
    "37047": (35.354815, -86.829364),
    "37048": (36.485607, -86.528398),
    "37049": (36.521044, -86.712734),
    "37050": (36.452109, -87.701641),
    "37051": (36.272071, -87.391396),
    "37052": (36.398614, -87.376496),
    "37055": (36.141461, -87.396417),
    "37056": (36.146949, -87.352971),
    "37057": (36.358212, -86.037379),
    "37058": (36.494203, -87.878742),
    "37059": (35.993753, -85.945143),
    "37060": (35.73168, -86.558626),
    "37061": (36.288768, -87.749245),
    "37062": (35.97805, -87.135938),
    "37063": (35.859565, -86.420958),
    "37064": (35.890746, -86.965691),
    "37065": (35.895085, -86.921416),
    "37066": (36.401201, -86.449479),
    "37067": (35.912072, -86.765537),
    "37068": (35.874553, -86.907565),
    "37069": (35.979553, -86.910623),
    "37070": (36.186605, -86.785248),
    "37071": (36.156231, -86.304922),
    "37072": (36.34145, -86.775747),
    "37073": (36.437397, -86.809567),
    "37074": (36.402012, -86.143252),
    "37075": (36.347551, -86.612045),
    "37076": (36.153572, -86.583994),
    "37077": (36.304701, -86.621095),
    "37078": (35.923958999999996, -87.810501),
    "37079": (36.490214, -87.697982),
    "37080": (36.326101, -86.899299),
    "37082": (36.189656, -87.089254),
    "37083": (36.52772, -86.025585),
    "37085": (35.936886, -86.291678),
    "37086": (36.008511, -86.559194),
    "37087": (36.267266, -86.291167),
    "37088": (36.156231, -86.304922),
    "37089": (35.859565, -86.420958),
    "37090": (36.118515, -86.263),
    "37091": (35.504165, -86.792003),
    "37095": (35.999286, -85.944738),
    "37096": (35.594367, -87.856665),
    "37097": (35.786732, -87.787992),
    "37098": (35.850248, -87.312683),
    "37101": (36.066188, -87.659245),
    "37110": (35.684033, -85.778151),
    "37111": (35.678368, -85.777633),
    "37115": (36.259503, -86.706296),
    "37116": (36.186605, -86.785248),
    "37118": (35.908701, -86.19487),
    "37119": (36.631981, -86.539028),
    "37121": (36.156231, -86.304922),
    "37122": (36.184603, -86.468695),
    "37127": (35.762951, -86.372158),
    "37128": (35.845418, -86.486683),
    "37129": (35.901746, -86.423535),
    "37130": (35.886984, -86.35778),
    "37131": (35.859565, -86.420958),
    "37132": (35.859565, -86.420958),
    "37133": (35.859565, -86.420958),
    "37134": (36.014193, -87.938738),
    "37135": (35.925201, -86.675349),
    "37136": (36.156231, -86.304922),
    "37137": (35.873344, -87.491254),
    "37138": (36.137706, -86.633545),
    "37140": (35.877706, -87.642386),
    "37141": (36.616801, -86.66518),
    "37142": (36.402215, -87.492837),
    "37143": (36.135105, -87.039855),
    "37144": (35.285712, -86.639625),
    "37145": (36.346164, -85.918944),
    "37146": (36.271077, -87.047966),
    "37147": (35.692395, -87.662335),
    "37148": (36.547545, -86.515887),
    "37149": (35.80362, -86.148505),
    "37150": (36.517717, -85.866182),
    "37151": (36.314537, -86.045992),
    "37152": (36.402548, -86.772247),
    "37153": (35.766806, -86.542707),
    "37155": (36.477428, -87.377197),
    "37160": (35.486335, -86.462357),
    "37161": (35.471531, -86.489019),
    "37162": (35.510825, -86.450042),
    "37165": (36.283543, -87.458058),
    "37166": (35.958503, -85.835635),
    "37167": (35.856167, -86.45336),
    "37171": (36.361093, -87.316272),
    "37172": (36.51351, -86.888624),
    "37174": (35.712381, -86.901661),
    "37175": (36.272979, -87.747374),
    "37178": (36.315226, -87.798852),
    "37179": (35.809026, -86.891286),
    "37180": (35.622306, -86.573246),
    "37181": (36.245657, -87.465507),
    "37183": (35.501239, -86.335135),
    "37184": (36.087694, -86.151145),
    "37185": (36.032353, -87.82746),
    "37186": (36.572762, -86.305594),
    "37187": (36.124378, -87.226354),
    "37188": (36.481635, -86.689867),
    "37189": (36.276652, -86.832048),
    "37190": (35.836335, -86.033176),
    "37191": (36.495848, -87.538989),
    "37201": (36.165688, -86.778098),
    "37202": (36.340304, -86.827254),
    "37203": (36.150406, -86.791598),
    "37204": (36.119294, -86.850099),
    "37205": (36.108558, -86.865776),
    "37206": (36.180143, -86.73575),
    "37207": (36.233916, -86.784698),
    "37208": (36.174256, -86.810198),
    "37209": (36.142007, -86.89995),
    "37210": (36.137475, -86.729947),
    "37211": (36.070359, -86.718347),
    "37212": (36.132607, -86.803748),
    "37213": (36.168626, -86.762899),
    "37214": (36.174205, -86.662146),
    "37215": (36.086531, -86.885987),
    "37216": (36.204255, -86.723997),
    "37217": (36.107372, -86.662914),
    "37218": (36.234304, -86.89585),
    "37219": (36.161906, -86.781748),
    "37220": (36.067109, -86.782098),
    "37221": (36.06616, -86.963852),
    "37222": (36.056164, -86.980116),
    "37224": (36.186605, -86.785248),
    "37227": (36.186605, -86.785248),
    "37228": (36.193205, -86.8083),
    "37229": (36.186605, -86.785248),
    "37230": (36.186605, -86.785248),
    "37232": (36.186605, -86.785248),
    "37234": (36.186605, -86.785248),
    "37235": (36.186605, -86.785248),
    "37236": (36.186605, -86.785248),
    "37237": (36.186605, -86.785248),
    "37238": (36.186605, -86.785248),
    "37239": (36.186605, -86.785248),
    "37240": (36.186605, -86.785248),
    "37241": (36.186605, -86.785248),
    "37242": (36.186605, -86.785248),
    "37243": (36.167606, -86.784498),
    "37244": (36.186605, -86.785248),
    "37245": (36.186605, -86.785248),
    "37246": (36.158606, -86.789998),
    "37247": (36.186605, -86.785248),
    "37248": (36.186605, -86.785248),
    "37249": (36.186605, -86.785248),
    "37250": (36.186605, -86.785248),
    "37301": (35.360328, -85.789682),
    "37302": (35.017572, -85.018914),
    "37303": (35.457491, -84.63982),
    "37304": (35.345216, -85.138046),
    "37305": (35.373473, -85.699601),
    "37306": (35.089483, -86.175941),
    "37307": (35.130815, -84.521805),
    "37308": (35.312806, -85.009853),
    "37309": (35.322816, -84.736414),
    "37310": (35.2637, -84.793619),
    "37311": (35.149223, -84.874031),
    "37312": (35.255097, -84.86844),
    "37313": (35.351615, -85.70031),
    "37314": (35.246689, -84.303121),
    "37315": (35.047891, -85.057359),
    "37316": (34.997057, -84.732656),
    "37317": (35.020673, -84.374828),
    "37318": (35.178335, -86.016657),
    "37320": (35.17272, -84.861885),
    "37321": (35.556414, -84.979171),
    "37322": (35.484053, -84.84546),
    "37323": (35.136098, -84.845707),
    "37324": (35.255505, -86.068439),
    "37325": (35.240205, -84.573882),
    "37326": (35.033927, -84.379169),
    "37327": (35.386535, -85.376504),
    "37328": (35.068833, -86.412827),
    "37329": (35.374591, -84.488998),
    "37330": (35.270666, -86.056548),
    "37331": (35.347928, -84.534548),
    "37332": (35.531335, -84.945661),
    "37333": (35.13081, -84.328172),
    "37334": (35.168227, -86.601925),
    "37335": (35.058083, -86.412954),
    "37336": (35.310427, -84.935342),
    "37337": (35.623951, -84.942494),
    "37338": (35.602658, -84.998978),
    "37339": (35.385223, -85.653738),
    "37340": (35.029115, -85.517231),
    "37341": (35.214176, -85.091744),
    "37342": (35.380586, -85.965585),
    "37343": (35.166775, -85.21024),
    "37345": (35.045745, -86.25541),
    "37347": (35.097012, -85.589691),
    "37348": (35.103977, -86.418625),
    "37349": (35.497637, -86.07482),
    "37350": (35.130697, -85.301627),
    "37351": (35.104522, -85.2631),
    "37352": (35.282767, -86.305403),
    "37353": (35.160258, -84.889237),
    "37354": (35.491574, -84.33952),
    "37355": (35.517946, -86.06988),
    "37356": (35.264698, -85.822933),
    "37357": (35.621365, -85.875966),
    "37359": (35.194599, -86.467197),
    "37360": (35.468961, -86.305194),
    "37361": (35.101062, -84.689716),
    "37362": (35.049197, -84.735366),
    "37363": (35.120227, -85.060369),
    "37364": (35.17272, -84.861885),
    "37365": (35.373473, -85.699601),
    "37366": (35.373473, -85.699601),
    "37367": (35.609437, -85.210253),
    "37369": (35.171646, -84.502303),
    "37370": (35.373143, -84.695085),
    "37371": (35.441376, -84.641623),
    "37372": (35.175522, -86.098338),
    "37373": (35.388975, -85.104336),
    "37374": (35.170416, -85.632114),
    "37375": (35.184313, -86.06546),
    "37376": (35.045233, -85.930195),
    "37377": (35.175117, -85.319805),
    "37378": (35.678368, -85.777633),
    "37379": (35.211052, -85.198979),
    "37380": (35.109722, -85.655679),
    "37381": (35.693499, -84.819767),
    "37382": (35.497637, -86.07482),
    "37383": (35.180503, -85.903522),
    "37384": (35.221092, -85.209082),
    "37385": (35.376907, -84.272243),
    "37387": (35.273159, -85.761237),
    "37388": (35.497968, -86.197898),
    "37389": (35.497637, -86.07482),
    "37391": (35.089723, -84.376621),
    "37394": (35.527616, -85.842163),
    "37395": (35.61722, -84.928921),
    "37396": (35.020638, -85.529023),
    "37397": (35.171226, -85.530468),
    "37398": (35.146602, -86.102966),
    "37401": (35.017818, -85.206426),
    "37402": (35.046323, -85.312907),
    "37403": (35.047273, -85.292207),
    "37404": (35.024174, -85.271756),
    "37405": (35.089664, -85.335675),
    "37406": (35.067272, -85.250058),
    "37407": (35.002474, -85.289806),
    "37408": (35.029154, -85.30685),
    "37409": (35.003374, -85.331395),
    "37410": (35.00307, -85.308956),
    "37411": (35.035273, -85.245455),
    "37412": (35.001524, -85.238392),
    "37414": (35.221092, -85.209082),
    "37415": (35.129075, -85.265017),
    "37416": (35.102747, -85.182663),
    "37419": (35.050162, -85.34052199999999),
    "37421": (35.040495, -85.153781),
    "37422": (35.221092, -85.209082),
    "37424": (35.221092, -85.209082),
    "37450": (35.221092, -85.209082),
    "37501": (35.169255, -89.990415),
    "37601": (36.3417, -82.387716),
    "37602": (36.271729, -82.501212),
    "37604": (36.308229, -82.387422),
    "37605": (36.315795, -82.383792),
    "37614": (36.157086, -82.562649),
    "37615": (36.352451, -82.492958),
    "37616": (36.227409, -82.734005),
    "37617": (36.525039, -82.369895),
    "37618": (36.479403, -82.261059),
    "37620": (36.531703, -82.192545),
    "37621": (36.504158, -82.26446),
    "37625": (36.504158, -82.26446),
    "37640": (36.362685, -81.919401),
    "37641": (36.256939, -82.690504),
    "37642": (36.495148, -82.732009),
    "37643": (36.330784, -82.122892),
    "37644": (36.436637, -82.051765),
    "37645": (36.564092, -82.683281),
    "37650": (36.06833, -82.399677),
    "37656": (36.307671, -82.558738),
    "37657": (36.027038, -82.545757),
    "37658": (36.253659999999996, -82.149749),
    "37659": (36.289189, -82.489065),
    "37660": (36.514384, -82.547615),
    "37662": (36.530517, -82.529816),
    "37663": (36.47152, -82.4834),
    "37664": (36.503789, -82.496969),
    "37665": (36.579851, -82.573274),
    "37669": (36.504158, -82.26446),
    "37680": (36.526206, -81.796303),
    "37681": (36.251851, -82.582954),
    "37682": (36.296007, -82.305359),
    "37683": (36.451666, -81.823043),
    "37684": (36.271729, -82.501212),
    "37686": (36.449142, -82.340731),
    "37687": (36.21957, -82.097785),
    "37688": (36.5407, -81.879863),
    "37690": (36.244143, -82.56404),
    "37691": (36.375484, -81.75824),
    "37692": (36.201952, -82.316667),
    "37694": (36.384473, -82.266921),
    "37699": (36.504158, -82.26446),
    "37701": (35.815758, -83.987698),
    "37705": (36.202528, -84.068808),
    "37707": (36.566257, -83.636479),
    "37708": (36.250636, -83.493998),
    "37709": (36.161793, -83.68192),
    "37710": (36.162585, -84.299217),
    "37711": (36.314262, -83.12129),
    "37713": (36.104208, -83.121619),
    "37714": (36.302779, -84.20298),
    "37715": (36.560275, -83.947827),
    "37716": (36.105314, -84.17446),
    "37717": (36.110028, -84.167208),
    "37719": (36.035211, -84.390727),
    "37721": (36.029286, -83.817508),
    "37722": (35.839769, -83.203929),
    "37723": (35.951478, -84.812093),
    "37724": (36.556666, -83.690318),
    "37725": (36.000789, -83.423276),
    "37726": (36.202427, -84.79351),
    "37727": (35.909233, -83.006316),
    "37729": (36.508642, -84.045356),
    "37730": (36.550453, -83.964644),
    "37731": (36.510756, -83.057056),
    "37732": (36.387879, -84.616597),
    "37733": (36.351914, -84.713666),
    "37737": (35.758228, -84.101182),
    "37738": (35.727782, -83.436982),
    "37742": (35.674723, -84.189652),
    "37743": (36.131582, -82.869219),
    "37744": (36.168271, -82.854836),
    "37745": (36.245521, -82.82378),
    "37748": (35.919953, -84.516642),
    "37752": (36.532527, -83.573282),
    "37753": (35.82414, -83.098214),
    "37754": (36.087461, -84.041266),
    "37755": (36.425232, -84.543615),
    "37756": (36.354403, -84.449208),
    "37757": (36.307449, -84.15575),
    "37760": (36.09903, -83.457262),
    "37762": (36.446193, -84.148034),
    "37763": (35.816595, -84.521104),
    "37764": (35.974032, -83.602564),
    "37765": (36.493188, -83.15127),
    "37766": (36.424766, -84.090654),
    "37769": (36.198793, -84.118107),
    "37770": (36.146631, -84.695508),
    "37771": (35.826473, -84.28365),
    "37772": (35.787243, -84.256679),
    "37773": (36.466398, -83.678621),
    "37774": (35.738092, -84.344062),
    "37777": (35.827859, -84.04546),
    "37778": (36.213293, -83.275211),
    "37779": (36.218058, -83.771137),
    "37801": (35.688378, -84.076895),
    "37802": (35.728283, -83.933815),
    "37803": (35.653917, -83.995621),
    "37804": (35.799053, -83.885212),
    "37806": (36.085904, -83.737262),
    "37807": (36.294236, -83.806991),
    "37809": (36.154227, -82.994077),
    "37810": (36.179069, -83.083417),
    "37811": (36.356017, -83.184274),
    "37813": (36.188826, -83.261343),
    "37814": (36.224258, -83.30984),
    "37815": (36.213293, -83.275211),
    "37816": (36.213293, -83.275211),
    "37818": (36.173296, -82.976161),
    "37819": (36.556524, -84.192358),
    "37820": (36.086723, -83.559174),
    "37821": (36.00244, -83.159605),
    "37822": (35.947688, -83.106554),
    "37824": (36.449963, -83.591129),
    "37825": (36.454861, -83.583199),
    "37826": (35.542073, -84.582782),
    "37828": (36.200476, -84.085785),
    "37829": (35.984852, -84.595764),
    "37830": (36.019381, -84.243175),
    "37831": (36.105971, -84.195796),
    "37840": (36.049427, -84.440586),
    "37841": (36.509395, -84.517984),
    "37842": (35.87543, -84.792927),
    "37843": (36.023406, -83.054705),
    "37845": (36.081406, -84.442969),
    "37846": (35.678118, -84.431236),
    "37847": (36.418966, -84.201074),
    "37848": (36.250636, -83.493998),
    "37849": (36.071877, -84.021456),
    "37851": (36.557884, -83.81392),
    "37852": (36.377044, -84.581147),
    "37853": (35.837548, -83.906157),
    "37854": (35.843277, -84.656532),
    "37857": (36.415976, -82.949145),
    "37860": (36.244307, -83.185535),
    "37861": (36.230696, -83.554826),
    "37862": (35.833278, -83.572214),
    "37863": (35.83391, -83.568939),
    "37864": (35.854211, -83.613849),
    "37865": (35.86053, -83.711272),
    "37866": (36.342768, -83.82039),
    "37867": (36.580283, -83.647254),
    "37868": (35.880902, -83.556134),
    "37869": (36.509867, -83.185624),
    "37870": (36.48404, -83.823282),
    "37871": (36.068694, -83.656829),
    "37872": (36.182465, -84.599987),
    "37873": (36.520167, -82.857862),
    "37874": (35.571343, -84.410561),
    "37876": (35.849046, -83.51432),
    "37877": (36.177707, -83.407043),
    "37878": (35.584404, -83.992315),
    "37879": (36.471886, -83.52214),
    "37880": (35.520244, -84.825054),
    "37881": (36.250636, -83.493998),
    "37882": (35.682298, -83.751242),
    "37885": (35.531891, -84.225767),
    "37886": (35.754464, -83.804833),
    "37887": (36.031584, -84.560491),
    "37888": (36.250636, -83.493998),
    "37890": (36.077612, -83.299826),
    "37891": (36.256858, -83.146114),
    "37892": (36.5482, -84.414551),
    "37901": (36.032334, -83.884804),
    "37902": (35.944976, -83.875822),
    "37909": (35.944822, -84.010109),
    "37912": (35.981701, -84.015635),
    "37914": (35.983366, -83.784109),
    "37915": (35.990369, -83.905415),
    "37916": (35.933783, -83.973635),
    "37917": (35.998447, -83.910527),
    "37918": (36.065908, -83.909603),
    "37919": (35.937391, -84.04224),
    "37920": (35.89292, -83.938689),
    "37921": (36.021873, -83.932092),
    "37922": (35.858018, -84.119383),
    "37923": (35.924795, -84.082405),
    "37924": (35.985081, -83.975603),
    "37927": (35.990142, -83.96218),
    "37928": (35.990142, -83.96218),
    "37929": (35.922421, -83.795492),
    "37930": (35.9029, -83.953554),
    "37931": (35.976167, -84.125653),
    "37932": (35.933487, -84.148074),
    "37933": (35.990142, -83.96218),
    "37938": (36.116665, -83.935206),
    "37939": (35.990142, -83.96218),
    "37940": (35.990142, -83.96218),
    "37950": (35.990142, -83.96218),
    "37990": (35.990142, -83.96218),
    "37995": (35.990142, -83.96218),
    "37996": (35.990142, -83.96218),
    "37997": (35.990142, -83.96218),
    "37998": (35.935134, -83.750258),
    "38001": (35.806106, -89.086594),
    "38002": (35.292102, -89.752615),
    "38004": (35.454301, -89.809562),
    "38006": (35.75357, -89.104516),
    "38007": (36.158668, -89.437684),
    "38008": (35.197635, -88.986448),
    "38010": (35.288624, -89.48802),
    "38011": (35.473412, -89.745307),
    "38012": (35.633418, -89.276381),
    "38014": (35.201738, -89.971538),
    "38015": (35.551009, -89.738952),
    "38017": (35.080992, -89.699083),
    "38018": (35.104589, -89.900314),
    "38019": (35.541624, -89.63552),
    "38021": (35.871014, -89.175275),
    "38023": (35.460696, -89.93429),
    "38024": (36.036069, -89.438461),
    "38025": (36.046851, -89.443779),
    "38027": (35.201738, -89.971538),
    "38028": (35.175796, -89.684982),
    "38029": (35.201738, -89.971538),
    "38030": (36.068517, -89.561464),
    "38034": (35.843638, -89.207168),
    "38036": (35.327428, -89.619816),
    "38037": (35.792984, -89.646955),
    "38039": (35.055153, -89.140622),
    "38040": (35.840794, -89.531217),
    "38041": (35.659259, -89.696162),
    "38042": (35.124195, -89.075852),
    "38044": (35.189276, -88.955968),
    "38045": (35.290428, -89.232185),
    "38046": (35.10486, -89.350387),
    "38047": (36.063765, -89.560879),
    "38048": (35.15066, -89.481362),
    "38049": (35.443164, -89.563798),
    "38050": (35.837913, -89.227284),
    "38052": (35.086247, -88.912495),
    "38053": (35.320197, -89.892286),
    "38054": (35.334132, -89.870636),
    "38055": (35.201738, -89.971538),
    "38056": (36.046851, -89.443779),
    "38057": (35.077518, -89.33787),
    "38058": (35.463075, -89.711843),
    "38059": (36.113717, -89.272827),
    "38060": (35.234809, -89.489977),
    "38061": (35.075589, -88.957929),
    "38063": (35.754505, -89.66112),
    "38066": (35.084994, -89.421234),
    "38067": (35.084166, -89.005719),
    "38068": (35.259373, -89.409857),
    "38069": (35.456111, -89.339146),
    "38070": (35.942019, -89.243405),
    "38071": (35.414319, -89.818781),
    "38074": (35.213371, -88.990028),
    "38075": (35.314672, -89.126324),
    "38076": (35.141626, -89.422466),
    "38077": (36.344296, -89.522851),
    "38079": (36.35529, -89.472468),
    "38080": (36.25973, -89.465379),
    "38083": (35.201738, -89.971538),
    "38088": (35.201738, -89.971538),
    "38101": (35.050667, -89.847782),
    "38103": (35.154875, -90.049631),
    "38104": (35.13573, -90.002079),
    "38105": (35.15182, -90.033959),
    "38106": (35.096351, -90.042984),
    "38107": (35.170953, -90.017716),
    "38108": (35.175239, -89.97306),
    "38109": (35.053795, -90.094757),
    "38110": (35.201738, -89.971538),
    "38111": (35.10956, -89.948119),
    "38112": (35.146285, -89.981523),
    "38113": (35.12738, -89.984484),
    "38114": (35.099348, -89.985187),
    "38115": (35.057906, -89.864023),
    "38116": (35.032879, -90.01109),
    "38117": (35.113588, -89.906749),
    "38118": (35.037585, -89.930187),
    "38119": (35.078775, -89.841963),
    "38120": (35.123644, -89.842541),
    "38122": (35.157958, -89.918514),
    "38124": (35.201738, -89.971538),
    "38125": (35.028829, -89.782647),
    "38126": (35.127163, -90.044782),
    "38127": (35.24346, -90.011979),
    "38128": (35.223442, -89.920266),
    "38130": (35.201738, -89.971538),
    "38131": (35.064837, -89.992905),
    "38132": (35.068014, -90.003349),
    "38133": (35.208941, -89.791656),
    "38134": (35.184469, -89.857389),
    "38135": (35.234976, -89.843594),
    "38136": (35.201738, -89.971538),
    "38137": (35.201738, -89.971538),
    "38138": (35.08753, -89.792638),
    "38139": (35.077091, -89.759979),
    "38140": (35.201738, -89.971538),
    "38141": (35.014466, -89.853346),
    "38142": (35.201738, -89.971538),
    "38143": (35.201738, -89.971538),
    "38145": (35.201738, -89.971538),
    "38146": (35.201738, -89.971538),
    "38147": (35.201738, -89.971538),
    "38148": (35.201738, -89.971538),
    "38150": (35.201738, -89.971538),
    "38151": (35.201738, -89.971538),
    "38152": (35.201738, -89.971538),
    "38157": (35.201738, -89.971538),
    "38159": (35.201738, -89.971538),
    "38161": (35.201738, -89.971538),
    "38163": (35.201738, -89.971538),
    "38165": (35.201738, -89.971538),
    "38166": (35.201738, -89.971538),
    "38167": (35.201738, -89.971538),
    "38168": (35.201738, -89.971538),
    "38173": (35.201738, -89.971538),
    "38174": (35.201738, -89.971538),
    "38175": (35.201738, -89.971538),
    "38177": (35.201738, -89.971538),
    "38181": (35.201738, -89.971538),
    "38182": (35.201738, -89.971538),
    "38183": (35.201738, -89.971538),
    "38184": (35.201738, -89.971538),
    "38186": (35.201738, -89.971538),
    "38187": (35.201738, -89.971538),
    "38188": (35.201738, -89.971538),
    "38190": (35.201738, -89.971538),
    "38193": (35.201738, -89.971538),
    "38194": (35.201738, -89.971538),
    "38195": (35.201738, -89.971538),
    "38197": (35.201738, -89.971538),
    "38201": (36.077501, -88.495094),
    "38220": (35.98991, -88.635869),
    "38221": (36.246599, -88.046704),
    "38222": (36.428005, -88.179868),
    "38223": (36.310995, -88.260367),
    "38224": (36.401598, -88.466035),
    "38225": (36.313605, -88.742473),
    "38226": (36.347497, -88.677715),
    "38229": (36.224842, -88.616346),
    "38230": (36.213708, -88.781253),
    "38231": (36.221214, -88.421701),
    "38232": (36.35288, -89.333345),
    "38233": (36.134323, -89.028993),
    "38235": (35.977824, -88.574447),
    "38236": (36.176184, -88.277355),
    "38237": (36.324103, -88.782561),
    "38238": (36.282357, -88.738132),
    "38240": (36.271215, -89.292228),
    "38241": (36.391905, -88.611055),
    "38242": (36.31586, -88.315916),
    "38251": (36.333902, -88.304762),
    "38253": (36.310755, -89.073128),
    "38254": (36.379051, -89.353821),
    "38255": (36.241614, -88.860371),
    "38256": (36.295353, -88.157201),
    "38257": (36.381482, -89.08396),
    "38258": (36.040631, -88.606605),
    "38259": (36.168626, -89.198503),
    "38260": (36.358606, -89.210108),
    "38261": (36.354638, -89.122231),
    "38271": (36.458295, -89.233227),
    "38281": (36.354384, -89.149881),
    "38301": (35.570424, -88.862742),
    "38302": (35.612405, -88.841225),
    "38303": (35.612405, -88.841225),
    "38305": (35.652446, -88.835682),
    "38308": (35.612405, -88.841225),
    "38310": (35.271057, -88.447528),
    "38311": (35.448494, -88.121113),
    "38313": (35.613916, -88.660454),
    "38314": (35.612405, -88.841225),
    "38315": (35.272194999999996, -88.626639),
    "38316": (36.057402, -88.804199),
    "38317": (36.056026, -88.282103),
    "38318": (35.961327, -88.270214),
    "38320": (36.082972, -88.101856),
    "38321": (35.87179, -88.529538),
    "38324": (35.867454, -88.39343),
    "38326": (35.110079, -88.292167),
    "38327": (35.219095, -88.319171),
    "38328": (35.666113, -88.215928),
    "38329": (35.536264, -88.114375),
    "38330": (36.080961, -89.036758),
    "38331": (35.969336, -89.131915),
    "38332": (35.428488, -88.429204),
    "38333": (36.114158, -87.98197),
    "38334": (35.268959, -88.567203),
    "38336": (35.748414, -89.032672),
    "38337": (35.780292, -89.026456),
    "38338": (35.870849, -88.846372),
    "38339": (35.056023, -88.504368),
    "38340": (35.407562, -88.642991),
    "38341": (35.905992, -88.078052),
    "38342": (36.05038, -88.291871),
    "38343": (35.880408, -88.93101),
    "38344": (35.985967, -88.433709),
    "38345": (35.621106, -88.496219),
    "38346": (36.030588, -88.805599),
    "38347": (35.471954, -88.491318),
    "38348": (35.860641, -88.640325),
    "38351": (35.675767, -88.412139),
    "38352": (35.535462, -88.537854),
    "38355": (35.813893, -88.753157),
    "38356": (35.482255, -88.911302),
    "38357": (35.139103, -88.565035),
    "38358": (35.920312, -88.813982),
    "38359": (35.367207, -88.388143),
    "38361": (35.300156, -88.274636),
    "38362": (35.724238, -88.780118),
    "38363": (35.697465, -88.111755),
    "38365": (35.038284, -88.225601),
    "38366": (35.485, -88.747695),
    "38367": (35.065178, -88.641833),
    "38368": (35.501858, -88.368317),
    "38369": (36.127152, -88.959639),
    "38370": (35.322354, -88.24275),
    "38371": (35.467143, -88.298898),
    "38372": (35.210571, -88.179203),
    "38374": (35.466358, -88.2138),
    "38375": (35.214443, -88.580145),
    "38376": (35.126018, -88.346807),
    "38377": (35.35604, -88.826923),
    "38378": (35.766822, -88.683882),
    "38379": (35.164604, -88.443952),
    "38380": (35.785097, -88.041426),
    "38381": (35.343473, -88.942458),
    "38382": (35.96713, -88.9815),
    "38387": (35.884516, -88.289175),
    "38388": (35.768119, -88.348263),
    "38389": (36.135364, -89.111653),
    "38390": (35.8458, -88.357504),
    "38391": (35.540108, -88.988401),
    "38392": (35.481628, -89.027133),
    "38393": (34.99687, -88.645577),
    "38401": (35.623997, -87.00404),
    "38402": (35.629413, -87.068172),
    "38425": (35.388038, -87.930163),
    "38449": (35.055109, -86.883959),
    "38450": (35.180623, -87.786778),
    "38451": (35.493211, -87.093094),
    "38452": (35.195385, -87.827937),
    "38453": (35.092452, -86.716719),
    "38454": (35.74803, -87.357729),
    "38455": (35.05392, -86.895305),
    "38456": (35.339549, -87.307286),
    "38457": (35.035472, -87.291424),
    "38459": (35.183444, -86.850038),
    "38460": (35.077182, -87.143713),
    "38461": (35.627022, -87.29402),
    "38462": (35.526554, -87.489057),
    "38463": (35.07132, -87.549745),
    "38464": (35.235493, -87.397143),
    "38468": (35.149182, -87.295169),
    "38469": (35.078858, -87.433561),
    "38471": (35.083472, -87.901086),
    "38472": (35.254073, -87.023994),
    "38473": (35.036274, -87.150744),
    "38474": (35.541801, -87.209525),
    "38475": (35.264369, -88.053366),
    "38476": (35.803869, -87.25914),
    "38477": (35.093795, -87.000953),
    "38478": (35.217373, -87.015664),
    "38481": (35.034741, -87.49336),
    "38482": (35.772652, -87.146428),
    "38483": (35.239335, -87.399717),
    "38485": (35.345882, -87.775459),
    "38486": (35.170415, -87.402375),
    "38487": (35.722628, -87.212698),
    "38488": (35.052581, -86.717885),
    "38501": (36.217846, -85.542327),
    "38502": (36.141824, -85.454779),
    "38503": (36.141824, -85.454779),
    "38504": (36.381838, -84.775579),
    "38505": (36.141824, -85.454779),
    "38506": (36.182723, -85.469451),
    "38541": (36.481086, -85.346687),
    "38542": (36.323952, -85.203098),
    "38543": (36.364735, -85.189932),
    "38544": (36.118922, -85.663021),
    "38545": (36.207497, -85.664611),
    "38547": (36.166413, -86.00636),
    "38548": (36.163921, -85.533995),
    "38549": (36.552982, -85.162523),
    "38550": (35.773417, -85.619169),
    "38551": (36.547776999999996, -85.512924),
    "38552": (36.212422, -85.825952),
    "38553": (36.197616, -85.011311),
    "38554": (36.244711, -85.160197),
    "38555": (35.962348, -85.051431),
    "38556": (36.384844, -84.935655),
    "38557": (35.988457, -85.012389),
    "38558": (35.960491, -85.014224),
    "38559": (35.835572, -85.519057),
    "38560": (36.218759, -85.862182),
    "38562": (36.369292, -85.681124),
    "38563": (36.209988, -85.982033),
    "38564": (36.278335, -85.748452),
    "38565": (36.259849, -85.00154),
    "38567": (36.138347, -85.91431299999999),
    "38568": (36.422652, -85.446431),
    "38569": (36.124389, -85.859146),
    "38570": (36.38519, -85.329392),
    "38573": (36.452484, -85.229094),
    "38574": (36.117716, -85.234938),
    "38575": (36.552546, -85.631181),
    "38577": (36.532956, -84.951245),
    "38578": (36.007405, -85.162272),
    "38579": (35.836776, -85.546347),
    "38580": (36.281225, -85.304796),
    "38581": (35.766758, -85.678847),
    "38582": (36.107377, -85.729463),
    "38583": (35.943857, -85.439246),
    "38585": (35.677816, -85.434355),
    "38587": (35.866476, -85.609235),
    "38588": (36.433214, -85.707955),
    "38589": (36.282181, -85.091312),
    "38601": (34.471941, -89.447507),
    "38602": (34.686272, -90.106756),
    "38603": (34.741457, -89.163282),
    "38606": (34.343102, -89.956497),
    "38609": (34.235111, -90.29272),
    "38610": (34.667999, -88.99877),
    "38611": (34.848108, -89.617691),
    "38614": (34.256003, -90.634809),
    "38617": (34.308025, -90.519949),
    "38618": (34.69018, -89.962513),
    "38619": (34.474028, -89.954427),
    "38620": (34.25082, -89.962994),
    "38621": (34.447051, -90.101204),
    "38622": (34.173057, -90.136429),
    "38623": (34.291611, -90.292717),
    "38625": (34.641739, -88.827123),
    "38626": (34.535704, -90.369304),
    "38627": (34.432943, -89.05727),
    "38628": (34.291611, -90.292717),
    "38629": (34.850879, -88.933747),
    "38630": (34.242356, -90.648864),
    "38631": (34.37406, -90.606054),
    "38632": (34.80684, -89.994591),
    "38633": (34.623448, -89.180301),
    "38634": (34.74504, -89.484963),
    "38635": (34.774733, -89.513878),
    "38637": (34.950609, -90.03355),
    "38638": (34.695853, -89.828798),
    "38639": (34.30373, -90.429351),
    "38641": (34.911834999999996, -90.14603),
    "38642": (34.930329, -89.399923),
    "38643": (34.189235, -90.21591599999999),
    "38644": (34.461795, -90.498088),
    "38645": (34.236389, -90.47941),
    "38646": (34.314968, -90.214465),
    "38647": (34.788948, -89.185048),
    "38649": (34.953584, -89.523027),
    "38650": (34.512992, -89.133523),
    "38651": (34.875133, -89.985853),
    "38652": (34.488692, -88.963649),
    "38654": (34.921172, -89.869062),
    "38655": (34.330814, -89.483519),
    "38658": (34.196241, -89.888559),
    "38659": (34.62921, -89.366355),
    "38661": (34.893744, -89.564928),
    "38663": (34.722961, -88.903624),
    "38664": (34.780008, -90.332582),
    "38665": (34.414146, -90.039377),
    "38666": (34.358883, -89.930441),
    "38668": (34.621336, -89.930083),
    "38669": (34.195345, -90.733538),
    "38670": (34.561069, -90.330278),
    "38671": (34.956633, -89.99624),
    "38672": (34.947407, -89.925792),
    "38673": (34.291869, -89.611016),
    "38674": (34.877104, -88.900175),
    "38675": (34.358201, -89.483865),
    "38676": (34.692892, -90.338981),
    "38677": (34.33962, -89.573605),
    "38679": (34.870804, -89.64082),
    "38680": (34.960712, -90.113913),
    "38683": (34.89462, -88.885227),
    "38685": (34.547621, -89.612918),
    "38686": (34.875277, -89.991991),
    "38701": (33.314539, -91.02297),
    "38702": (33.425792, -90.994597),
    "38703": (33.414186, -91.009518),
    "38704": (33.253401, -90.918503),
    "38720": (34.074216, -90.75974),
    "38721": (32.973917, -90.831601),
    "38722": (33.26597, -90.844813),
    "38723": (33.218997, -91.047905),
    "38725": (33.627816, -90.994878),
    "38726": (33.75291, -90.958277),
    "38730": (33.741709, -90.773978),
    "38731": (33.085379, -91.088255),
    "38732": (33.847591, -90.84313),
    "38733": (33.624024, -90.819547),
    "38736": (33.690173, -90.549626),
    "38737": (33.685766, -90.607299),
    "38738": (33.628715, -90.607457),
    "38739": (34.060359, -90.501063),
    "38740": (33.94809, -90.770386),
    "38744": (33.045837, -91.019421),
    "38745": (32.711257, -90.952716),
    "38746": (34.000588, -90.919616),
    "38748": (33.230409, -90.910451),
    "38749": (33.628715, -90.607457),
    "38751": (33.443446, -90.608662),
    "38753": (33.350655, -90.583441),
    "38754": (33.263048, -90.59677),
    "38756": (33.398505, -90.88387),
    "38758": (34.076795, -90.507012),
    "38759": (33.818742, -90.840631),
    "38760": (33.454614, -90.994264),
    "38761": (33.443386, -90.506817),
    "38762": (33.767126, -90.84697800000001),
    "38763": (32.879795, -90.81096),
    "38764": (33.725717, -90.92728),
    "38765": (32.879795, -90.81096),
    "38767": (34.1412, -90.7865),
    "38768": (33.958959, -90.477605),
    "38769": (33.841892, -90.882598),
    "38771": (33.66479, -90.555537),
    "38772": (33.562871, -91.039093),
    "38773": (33.608538, -90.794341),
    "38774": (33.957757, -90.74504),
    "38776": (33.409614, -90.910404),
    "38778": (33.556746, -90.545111),
    "38780": (33.272695, -90.995399),
    "38781": (33.887774, -90.737149),
    "38782": (33.269118, -90.957291),
    "38801": (34.291889, -88.683828),
    "38802": (34.234527, -88.767127),
    "38803": (34.187638, -88.77852),
    "38804": (34.3371, -88.684672),
    "38820": (34.171543, -89.032791),
    "38821": (33.942639, -88.411284),
    "38824": (34.314813, -88.63922),
    "38825": (33.869763, -88.462173),
    "38826": (34.269844, -88.745933),
    "38827": (34.550663, -88.22674),
    "38828": (34.464253, -88.958608),
    "38829": (34.632922, -88.533107),
    "38833": (34.855985, -88.286923),
    "38834": (34.87589, -88.591575),
    "38835": (34.920451, -88.521772),
    "38838": (34.584628, -88.248391),
    "38839": (33.856165, -89.303214),
    "38841": (34.336606, -89.010873),
    "38843": (34.276489, -88.355013),
    "38844": (33.84026, -88.2635),
    "38846": (34.868523, -88.41982),
    "38847": (34.346321, -88.246027),
    "38848": (33.940078, -88.320711),
    "38849": (34.421084, -88.665975),
    "38850": (34.013571, -88.996107),
    "38851": (33.911901, -88.931148),
    "38852": (34.81583, -88.2318),
    "38854": (33.906827, -88.955351),
    "38855": (34.324376, -88.393184),
    "38856": (34.592786, -88.510356),
    "38857": (34.275006, -88.592851),
    "38858": (34.161842, -88.472146),
    "38859": (34.531462, -88.387511),
    "38860": (33.94295, -88.868022),
    "38862": (34.239541, -88.617454),
    "38863": (34.227246, -89.040537),
    "38864": (34.161748, -89.179467),
    "38865": (34.818882, -88.56325),
    "38866": (34.304376, -88.667209),
    "38868": (34.144146, -88.68396),
    "38869": (34.349542, -88.836268),
    "38870": (34.045269, -88.365609),
    "38871": (34.317365, -89.159059),
    "38873": (34.671205, -88.238068),
    "38874": (34.226527, -89.251922),
    "38875": (33.906827, -88.955351),
    "38876": (34.235149, -88.333454),
    "38877": (33.987089, -88.898807),
    "38878": (33.896961, -89.221899),
    "38879": (34.170691, -88.759077),
    "38880": (34.612636, -88.582231),
    "38901": (33.786016, -89.845462),
    "38902": (33.824113, -89.794687),
    "38912": (33.65497, -90.053958),
    "38913": (34.12266, -89.395779),
    "38914": (33.898213, -89.431864),
    "38915": (34.034636, -89.342661),
    "38916": (33.857172, -89.352482),
    "38917": (33.518425, -89.995978),
    "38920": (33.929206, -90.188462),
    "38921": (34.007428, -90.115364),
    "38922": (33.961287, -89.64824),
    "38923": (33.445684, -89.910076),
    "38924": (33.255582, -90.183344),
    "38925": (33.563223, -89.641871),
    "38926": (33.689476, -89.758302),
    "38927": (34.125054, -90.013183),
    "38928": (33.929206, -90.188462),
    "38929": (33.78764, -89.647197),
    "38930": (33.550408, -90.224856),
    "38935": (33.523355, -90.27757),
    "38940": (33.742966, -90.000461),
    "38941": (33.467852, -90.294639),
    "38943": (33.489564, -89.834467),
    "38944": (33.752133, -90.374127),
    "38945": (33.650681, -90.196909),
    "38946": (33.404573, -90.371993),
    "38947": (33.512759, -89.920125),
    "38948": (34.102656, -89.855317),
    "38949": (34.199242, -89.381994),
    "38950": (33.733437, -90.237053),
    "38951": (33.942942, -89.283006),
    "38952": (33.627351, -90.301026),
    "38953": (34.029737, -89.719526),
    "38954": (33.445684, -89.910076),
    "38955": (33.743871, -89.375281),
    "38957": (33.983323, -90.389521),
    "38958": (33.929206, -90.188462),
    "38959": (33.380913, -90.349601),
    "38960": (33.787157, -89.821941),
    "38961": (34.029737, -89.719526),
    "38962": (33.929206, -90.188462),
    "38963": (34.022051, -90.349894),
    "38964": (34.09953, -90.443027),
    "38965": (34.101631, -89.633458),
    "38966": (33.898064, -90.335055),
    "38967": (33.514926, -89.628584),
    "39038": (33.170596, -90.475786),
    "39039": (32.845368, -90.241776),
    "39040": (32.645794, -90.423646),
    "39041": (32.406956, -90.46141),
    "39042": (32.300019, -89.938693),
    "39043": (32.269041, -89.987491),
    "39044": (31.96499, -89.981393),
    "39045": (32.785348, -89.869807),
    "39046": (32.625298, -90.008601),
    "39047": (32.388633, -89.958406),
    "39051": (32.785217, -89.524057),
    "39054": (32.812875, -90.927522),
    "39056": (32.370736, -90.312371),
    "39057": (32.477116, -89.26359),
    "39058": (32.311287, -90.39715699999999),
    "39059": (31.965088, -90.375733),
    "39060": (32.311287, -90.39715699999999),
    "39061": (32.879795, -90.81096),
    "39062": (31.986101, -89.919219),
    "39063": (33.071531, -89.899593),
    "39066": (32.27307, -90.50985),
    "39067": (33.08167, -89.541348),
    "39069": (31.731988, -91.056503),
    "39071": (32.553269, -90.326653),
    "39072": (32.311287, -90.39715699999999),
    "39073": (32.280972, -90.003854),
    "39074": (32.399853, -89.505298),
    "39077": (31.928751, -90.392603),
    "39078": (31.87408, -90.206289),
    "39079": (32.989226, -89.943323),
    "39080": (32.492533, -89.494585),
    "39081": (31.739958, -91.050948),
    "39082": (31.94173, -90.133459),
    "39083": (31.868475, -90.429426),
    "39086": (31.997408, -90.716602),
    "39087": (32.470606, -89.517069),
    "39088": (32.841523, -90.723119),
    "39090": (33.055142, -89.5913),
    "39092": (32.384482, -89.415089),
    "39094": (32.620305, -89.614259),
    "39095": (33.126082, -90.057116),
    "39096": (31.739958, -91.050948),
    "39097": (32.980758, -90.592812),
    "39098": (32.566039, -89.713545),
    "39107": (33.082754, -89.641184),
    "39108": (33.082754, -89.641184),
    "39109": (32.690864, -89.355388),
    "39110": (32.553769, -90.138906),
    "39111": (31.910321, -89.775032),
    "39112": (31.896236, -89.780694),
    "39113": (32.711257, -90.952716),
    "39114": (31.907972, -89.813907),
    "39115": (33.125998, -90.531759),
    "39116": (31.852342, -89.50805),
    "39117": (32.402897, -89.594886),
    "39119": (31.717905000000002, -89.623543),
    "39120": (31.527752, -91.307025),
    "39121": (31.470602, -91.404404),
    "39122": (31.470602, -91.404404),
    "39130": (32.642448, -90.090683),
    "39140": (31.71093, -90.038237),
    "39144": (32.005479, -90.981274),
    "39145": (32.33857, -89.833228),
    "39146": (32.950379, -90.02631),
    "39148": (32.319905, -89.992257),
    "39149": (31.837604, -90.016517),
    "39150": (31.916949, -90.975632),
    "39151": (32.106173, -89.783633),
    "39152": (32.274536, -89.562728),
    "39153": (32.033656, -89.524458),
    "39154": (32.196072, -90.47528),
    "39156": (32.52792, -90.754175),
    "39157": (32.436064, -90.13731),
    "39158": (32.642448, -90.090683),
    "39159": (32.859106, -90.897658),
    "39160": (33.082754, -89.641184),
    "39161": (32.498294, -89.868563),
    "39162": (32.640397, -90.595701),
    "39163": (32.642448, -90.090683),
    "39165": (31.470602, -91.404404),
    "39166": (33.094729, -90.490483),
    "39167": (32.096124, -90.061508),
    "39168": (31.82958, -89.403302),
    "39169": (33.134414, -90.237888),
    "39170": (32.189393, -90.422369),
    "39171": (32.753923, -89.52414),
    "39173": (32.762751, -90.36285),
    "39174": (32.395343, -90.154436),
    "39175": (32.22149, -90.4372),
    "39176": (33.329023, -89.751563),
    "39177": (32.711257, -90.952716),
    "39179": (32.801526, -90.098134),
    "39180": (32.339533, -90.834407),
    "39181": (32.348565, -90.864199),
    "39182": (32.348565, -90.864199),
    "39183": (32.386006, -90.840021),
    "39189": (32.62897, -89.406315),
    "39190": (31.470602, -91.404404),
    "39191": (31.847453, -90.377153),
    "39192": (33.198544, -89.853487),
    "39193": (32.234775, -90.07263),
    "39194": (32.815898, -90.475849),
    "39201": (32.291095, -90.192687),
    "39202": (32.305395, -90.176737),
    "39203": (32.308595, -90.210438),
    "39204": (32.30148, -90.290313),
    "39205": (32.311287, -90.39715699999999),
    "39206": (32.370044, -90.169987),
    "39207": (32.311287, -90.39715699999999),
    "39208": (32.267238, -89.958708),
    "39209": (32.374632, -90.362921),
    "39210": (32.321845, -90.177137),
    "39211": (32.366844, -90.123786),
    "39212": (32.238808, -90.28773),
    "39213": (32.306096, -90.216282),
    "39215": (32.311287, -90.39715699999999),
    "39216": (32.336744, -90.216096),
    "39217": (32.297396, -90.208088),
    "39218": (32.215304, -90.126353),
    "39225": (32.311287, -90.39715699999999),
    "39232": (32.311287, -90.39715699999999),
    "39235": (32.311287, -90.39715699999999),
    "39236": (32.311287, -90.39715699999999),
    "39250": (32.311287, -90.39715699999999),
    "39269": (32.300296, -90.188638),
    "39271": (32.311287, -90.39715699999999),
    "39272": (32.311287, -90.39715699999999),
    "39282": (32.311287, -90.39715699999999),
    "39283": (32.311287, -90.39715699999999),
    "39284": (32.311287, -90.39715699999999),
    "39286": (32.311287, -90.39715699999999),
    "39288": (32.313127, -89.799625),
    "39289": (32.311287, -90.39715699999999),
    "39296": (32.311287, -90.39715699999999),
    "39298": (32.319905, -89.992257),
    "39301": (32.381605, -88.663489),
    "39302": (32.431958, -88.641888),
    "39303": (32.401233, -88.652279),
    "39304": (32.420847, -88.646016),
    "39305": (32.403111, -88.658234),
    "39307": (32.386718, -88.676575),
    "39309": (32.337389, -88.726474),
    "39320": (32.52258, -88.745613),
    "39322": (31.582003, -88.548006),
    "39323": (32.35048, -88.955099),
    "39324": (31.593682, -88.704829),
    "39325": (32.434473, -88.78778),
    "39326": (32.556534, -88.679062),
    "39327": (32.427135, -89.092952),
    "39328": (32.799065, -88.698657),
    "39330": (32.14342, -88.819543),
    "39332": (32.323107, -89.083928),
    "39335": (32.498068, -88.534433),
    "39336": (32.319198, -89.258254),
    "39337": (32.5049, -88.995468),
    "39338": (32.109313, -89.187423),
    "39339": (33.101687, -89.068098),
    "39341": (33.125769, -88.54474),
    "39342": (32.336743, -88.616297),
    "39345": (32.39983, -89.08313),
    "39346": (32.980751, -89.108325),
    "39347": (32.021692, -88.885093),
    "39348": (32.069413, -89.027181),
    "39350": (32.754387, -89.116797),
    "39352": (32.797547, -88.523668),
    "39354": (32.855983, -88.827847),
    "39355": (32.013802, -88.663429),
    "39356": (32.13603, -88.998801),
    "39358": (32.822624, -88.478138),
    "39359": (32.551832, -89.357384),
    "39360": (31.960687, -88.716818),
    "39361": (33.082645, -88.659645),
    "39362": (31.360647, -88.606456),
    "39363": (32.140683, -88.770572),
    "39364": (32.424306, -88.660633),
    "39365": (32.643921, -89.111993),
    "39366": (31.950645, -88.970738),
    "39367": (31.659327, -88.704113),
    "39401": (31.245138, -89.28071),
    "39402": (31.335865, -89.379246),
    "39403": (31.356642, -89.382415),
    "39404": (31.172142, -89.294772),
    "39406": (31.172142, -89.294772),
    "39407": (31.172142, -89.294772),
    "39421": (31.582332, -89.781429),
    "39422": (31.989146, -89.209877),
    "39423": (31.185365, -88.920132),
    "39425": (31.181756, -89.266547),
    "39426": (30.661121, -89.646536),
    "39427": (31.601319, -89.865962),
    "39428": (31.652811, -89.578002),
    "39429": (31.218188, -89.801872),
    "39436": (31.455471, -89.302042),
    "39437": (31.611088, -89.171825),
    "39439": (31.892668, -89.077368),
    "39440": (31.711733, -89.114317),
    "39441": (31.727664, -89.075482),
    "39442": (31.682254, -89.040622),
    "39443": (31.686952, -89.121296),
    "39451": (31.167734, -88.637767),
    "39452": (30.866791, -88.649035),
    "39455": (31.100426, -89.503417),
    "39456": (31.086666, -88.797692),
    "39457": (30.666936, -89.673392),
    "39459": (31.500214, -89.296883),
    "39460": (32.013235, -89.11656),
    "39461": (31.210172, -88.754841),
    "39462": (31.171903, -88.991561),
    "39463": (30.563724, -89.557751),
    "39464": (31.311643, -88.999044),
    "39465": (31.331528, -89.215061),
    "39466": (30.627655, -89.63128),
    "39470": (30.756774, -89.58072),
    "39474": (31.59763, -89.886038),
    "39475": (31.228126, -89.501513),
    "39476": (31.318239, -88.993126),
    "39477": (31.790929, -89.041363),
    "39478": (31.078868, -89.847732),
    "39479": (31.5378, -89.502846),
    "39480": (31.713226, -89.297336),
    "39481": (31.870465, -89.229337),
    "39482": (31.216581, -89.531088),
    "39483": (31.247873, -89.92857),
    "39501": (30.396277, -89.064103),
    "39502": (30.415795, -89.068448),
    "39503": (30.467067, -89.151485),
    "39505": (30.415795, -89.068448),
    "39506": (30.415795, -89.068448),
    "39507": (30.400079, -89.031635),
    "39520": (30.295608, -89.463187),
    "39521": (30.403156, -89.49821),
    "39522": (30.403156, -89.49821),
    "39525": (30.372821, -89.377942),
    "39529": (30.403156, -89.49821),
    "39530": (30.432454, -88.978634),
    "39531": (30.401498, -88.971229),
    "39532": (30.510988, -88.96808),
    "39533": (30.415795, -89.068448),
    "39534": (30.415795, -89.068448),
    "39535": (30.415795, -89.068448),
    "39552": (30.441072, -88.634482),
    "39553": (30.421676, -88.66487),
    "39555": (30.71325, -88.519743),
    "39556": (30.487498, -89.418722),
    "39558": (30.239124, -89.459526),
    "39560": (30.374646, -89.177143),
    "39561": (30.721036, -89.172285),
    "39562": (30.544726, -88.604298),
    "39563": (30.539088, -88.621049),
    "39564": (30.50028, -88.655024),
    "39565": (30.547365, -88.708582),
    "39566": (30.441072, -88.634482),
    "39567": (30.534162, -88.489379),
    "39568": (30.441072, -88.634482),
    "39569": (30.441072, -88.634482),
    "39571": (30.426162, -89.264327),
    "39572": (30.249299, -89.520472),
    "39573": (30.773109, -89.112944),
    "39574": (30.599773, -89.112683),
    "39576": (30.285046, -89.371231),
    "39577": (30.847777999999998, -89.086992),
    "39581": (30.539159, -88.621046),
    "39595": (30.441072, -88.634482),
    "39601": (31.521489, -90.460786),
    "39602": (31.533354, -90.490661),
    "39603": (31.612287, -90.446702),
    "39629": (31.447124, -90.45787),
    "39630": (31.465718, -90.895386),
    "39631": (31.134359, -91.175079),
    "39632": (31.114483, -90.487486),
    "39633": (31.247847, -90.885075),
    "39635": (31.18537, -90.427966),
    "39638": (31.199644, -90.916006),
    "39641": (31.409296, -90.142429),
    "39643": (31.243549, -89.978849),
    "39645": (31.17427, -90.803528),
    "39647": (31.465718, -90.895386),
    "39648": (31.1769, -90.40156),
    "39649": (31.17494, -90.403987),
    "39652": (31.143395, -90.403989),
    "39653": (31.469888, -90.891482),
    "39654": (31.540111, -90.161012),
    "39656": (31.48225, -90.036767),
    "39657": (31.043653, -90.403651),
    "39661": (31.50115, -91.069486),
    "39662": (31.409907, -90.291051),
    "39663": (31.594604, -90.044711),
    "39664": (31.268945, -90.670185),
    "39665": (31.640256, -90.189547),
    "39666": (31.258892, -90.404555),
    "39667": (31.175558, -90.090824),
    "39668": (31.714577, -90.746168),
    "39669": (31.175443, -91.324666),
    "39701": (33.516258, -88.461318),
    "39702": (33.429569, -88.460218),
    "39703": (33.484147, -88.283998),
    "39704": (33.548523, -88.379614),
    "39705": (33.550752, -88.486521),
    "39710": (33.51633, -88.460083),
    "39730": (33.847638, -88.514694),
    "39735": (33.278252, -89.191298),
    "39736": (33.411531, -88.644261),
    "39737": (33.648956, -89.334234),
    "39739": (33.220204, -88.482218),
    "39740": (33.81523, -88.271904),
    "39741": (33.659271, -88.753976),
    "39743": (33.334688, -88.556056),
    "39744": (33.549384, -89.290417),
    "39745": (33.289753, -89.399875),
    "39746": (33.778926, -88.358784),
    "39747": (33.4346, -89.585663),
    "39750": (33.599618, -89.262792),
    "39751": (33.94185, -89.323857),
    "39752": (33.540161, -89.130294),
    "39753": (33.483814, -88.640881),
    "39754": (33.659271, -88.753976),
    "39755": (33.659271, -88.753976),
    "39756": (33.783578, -88.664183),
    "39759": (33.42554, -88.879117),
    "39760": (33.459924, -88.832163),
    "39762": (33.415601, -88.743329),
    "39766": (33.603342, -88.321007),
    "39767": (33.518048, -89.467862),
    "39769": (33.405675, -88.993677),
    "39771": (33.595758000000004, -89.298621),
    "39772": (33.321036, -89.271149),
    "39773": (33.621135, -88.609136),
    "39776": (33.804808, -89.060746),
    "39901": (33.891251, -84.07456),
    "40003": (38.274456, -85.090374),
    "40004": (37.822585, -85.466944),
    "40006": (38.603011, -85.329441),
    "40007": (38.452892, -85.016907),
    "40008": (37.826549, -85.327083),
    "40009": (37.504057, -85.107213),
    "40010": (38.389195, -85.44584),
    "40011": (38.45807, -85.132315),
    "40012": (37.903151, -85.191533),
    "40013": (37.912465, -85.465785),
    "40014": (38.358083, -85.446974),
    "40018": (38.22977, -85.66304),
    "40019": (38.416293, -85.171224),
    "40020": (37.933981, -85.386242),
    "40022": (38.15483, -85.340174),
    "40023": (38.188936, -85.446269),
    "40025": (38.309597, -85.643359),
    "40026": (38.412346, -85.527464),
    "40027": (38.329718, -85.63299),
    "40031": (38.423186, -85.454359),
    "40032": (38.40464, -85.460504),
    "40033": (37.541558, -85.256025),
    "40036": (38.455714, -84.988603),
    "40037": (37.647483, -85.417876),
    "40040": (37.756812, -85.059008),
    "40041": (38.25361, -85.662215),
    "40045": (38.687402, -85.378762),
    "40046": (38.019718, -85.181188),
    "40047": (38.04141, -85.581303),
    "40048": (37.756941, -85.44671),
    "40049": (37.660251, -85.393204),
    "40050": (38.427404, -85.18706),
    "40051": (37.643761, -85.547037),
    "40052": (37.602081, -85.516424),
    "40055": (38.473652, -85.300936),
    "40056": (38.303255, -85.485175),
    "40057": (38.431413, -85.032581),
    "40058": (38.494055, -85.124192),
    "40059": (38.341558, -85.598451),
    "40060": (37.533664, -85.429061),
    "40061": (37.773962, -85.201068),
    "40062": (37.604695, -85.425149),
    "40063": (37.579519, -85.355132),
    "40065": (38.222445, -85.172072),
    "40066": (38.197268, -85.212156),
    "40067": (38.223861, -85.360625),
    "40068": (38.408032, -85.267223),
    "40069": (37.734249, -85.21065),
    "40070": (38.476096, -85.248914),
    "40071": (38.032735, -85.366055),
    "40075": (38.552133, -85.101879),
    "40076": (38.122662, -85.103096),
    "40077": (38.491635, -85.424726),
    "40078": (37.843697, -85.128804),
    "40104": (38.093864, -86.345301),
    "40107": (37.740827, -85.59479),
    "40108": (37.97552, -86.179546),
    "40109": (38.051236, -85.755592),
    "40110": (37.93462, -85.65545),
    "40111": (37.847839, -86.463591),
    "40115": (37.735817, -86.237827),
    "40117": (37.884962, -86.115209),
    "40118": (38.096526, -85.758416),
    "40119": (37.552184, -86.483592),
    "40121": (37.899466, -85.952833),
    "40140": (37.802295, -86.414768),
    "40142": (37.889946, -86.199842),
    "40143": (37.751214, -86.45371),
    "40144": (37.802295, -86.414768),
    "40145": (37.606992, -86.321158),
    "40146": (37.828452, -86.28417),
    "40150": (37.90878, -85.688029),
    "40152": (37.619425, -86.449076),
    "40153": (37.802295, -86.414768),
    "40155": (37.934131, -86.081991),
    "40157": (38.022328, -86.355493),
    "40159": (37.723474, -85.976854),
    "40160": (37.826634, -85.849432),
    "40161": (38.005963, -86.398391),
    "40162": (37.755939, -86.032496),
    "40164": (37.802295, -86.414768),
    "40165": (37.959505, -85.704609),
    "40170": (37.913755, -86.52421),
    "40171": (37.802295, -86.414768),
    "40175": (37.803725, -86.050646),
    "40176": (37.881048, -86.287044),
    "40177": (37.980384, -85.966061),
    "40178": (37.645844, -86.405203),
    "40201": (38.188962, -85.676819),
    "40202": (38.25247, -85.753812),
    "40203": (38.249273, -85.769412),
    "40204": (38.23942, -85.722711),
    "40205": (38.224181, -85.60026),
    "40206": (38.25032, -85.703411),
    "40207": (38.262769, -85.666284),
    "40208": (38.21782, -85.763912),
    "40209": (38.214391, -85.769189),
    "40210": (38.23207, -85.788702),
    "40211": (38.232811, -85.815363),
    "40212": (38.234969, -85.794213),
    "40213": (38.182609, -85.707133),
    "40214": (38.163269, -85.788862),
    "40215": (38.19188, -85.785512),
    "40216": (38.186519, -85.833463),
    "40217": (38.21787, -85.739861),
    "40218": (38.171856, -85.67806),
    "40219": (38.138118, -85.69526),
    "40220": (38.214603, -85.620304),
    "40221": (38.188962, -85.676819),
    "40222": (38.267429, -85.623671),
    "40223": (38.265072, -85.558228),
    "40224": (38.188962, -85.676819),
    "40225": (38.188962, -85.676819),
    "40228": (38.144155, -85.626526),
    "40229": (38.135961, -85.649393),
    "40231": (38.188962, -85.676819),
    "40232": (38.188962, -85.676819),
    "40233": (38.188962, -85.676819),
    "40241": (38.304531, -85.581536),
    "40242": (38.278469, -85.59396),
    "40243": (38.242201, -85.535309),
    "40245": (38.258384, -85.475021),
    "40250": (38.188962, -85.676819),
    "40251": (38.188962, -85.676819),
    "40252": (38.188962, -85.676819),
    "40253": (38.188962, -85.676819),
    "40255": (38.188962, -85.676819),
    "40256": (38.188962, -85.676819),
    "40257": (38.188962, -85.676819),
    "40258": (38.145719, -85.864063),
    "40259": (38.188962, -85.676819),
    "40261": (38.188962, -85.676819),
    "40266": (38.188962, -85.676819),
    "40268": (38.188962, -85.676819),
    "40269": (38.188962, -85.676819),
    "40270": (38.188962, -85.676819),
    "40272": (38.084554, -85.851022),
    "40280": (38.246721, -85.685261),
    "40281": (38.188962, -85.676819),
    "40282": (38.188962, -85.676819),
    "40283": (38.188962, -85.676819),
    "40285": (38.188962, -85.676819),
    "40287": (38.188962, -85.676819),
    "40289": (38.188962, -85.676819),
    "40290": (38.188962, -85.676819),
    "40291": (38.13132, -85.575352),
    "40292": (38.188962, -85.676819),
    "40293": (38.188962, -85.676819),
    "40294": (38.188962, -85.676819),
    "40295": (38.188962, -85.676819),
    "40296": (38.188962, -85.676819),
    "40297": (38.188962, -85.676819),
    "40298": (38.188962, -85.676819),
    "40299": (38.176762, -85.521751),
    "40310": (37.754839, -84.74994),
    "40311": (38.334059, -83.994865),
    "40312": (37.847517, -83.859331),
    "40313": (38.128726, -83.442495),
    "40316": (37.938651, -83.605538),
    "40317": (38.176471, -83.268234),
    "40319": (38.140258, -83.533691),
    "40320": (37.968496, -84.157766),
    "40322": (37.947025, -83.608449),
    "40324": (38.239718, -84.574498),
    "40328": (37.585972, -85.08651),
    "40329": (38.206706, -83.41725),
    "40330": (37.803283, -84.860707),
    "40334": (38.016064, -83.771261),
    "40336": (37.70424, -83.944815),
    "40337": (37.964096, -83.870275),
    "40339": (37.950381, -84.656887),
    "40340": (37.866238, -84.579491),
    "40342": (38.006484, -84.979923),
    "40346": (37.973921, -83.743488),
    "40347": (38.145835, -84.718028),
    "40348": (38.296337, -84.151319),
    "40350": (38.303859, -83.886328),
    "40351": (38.210471, -83.42039),
    "40353": (38.052103, -83.924711),
    "40355": (38.627652, -84.87562),
    "40356": (37.863751, -84.565075),
    "40357": (38.146395, -84.107655),
    "40358": (38.084908, -83.700824),
    "40359": (38.493552, -84.843115),
    "40360": (38.146022, -83.78456),
    "40361": (38.217248, -84.213426),
    "40362": (38.219407, -84.205944),
    "40363": (38.5218, -85.013882),
    "40366": (38.086673, -83.757123),
    "40370": (38.383618, -84.553016),
    "40371": (38.10437, -83.621715),
    "40372": (37.866351, -84.884036),
    "40374": (38.228942, -83.88438),
    "40376": (37.816074, -83.693949),
    "40379": (38.306329, -84.676123),
    "40380": (37.822307, -83.785309),
    "40383": (37.998762, -84.737666),
    "40384": (38.021292, -84.745488),
    "40385": (37.717603, -84.14483),
    "40386": (38.021292, -84.745488),
    "40387": (37.978036, -83.467497),
    "40390": (37.860199, -84.671365),
    "40391": (37.964922, -84.160724),
    "40392": (37.968496, -84.157766),
    "40402": (37.305202, -83.971127),
    "40403": (37.592589, -84.235247),
    "40404": (37.716443, -84.299699),
    "40405": (37.716443, -84.299699),
    "40409": (37.373811, -84.412242),
    "40410": (37.651397, -84.546693),
    "40419": (37.43221, -84.517065),
    "40421": (37.416008, -83.993588),
    "40422": (37.636006, -84.849682),
    "40423": (37.624659, -84.845767),
    "40434": (37.395468, -83.908492),
    "40437": (37.443361, -84.767288),
    "40440": (37.581754, -84.846678),
    "40442": (37.362372, -84.695425),
    "40444": (37.683184, -84.583605),
    "40445": (37.290742, -84.213618),
    "40446": (37.651397, -84.546693),
    "40447": (37.433778, -84.025131),
    "40448": (37.445989, -84.699802),
    "40452": (37.603345, -84.94918),
    "40456": (37.398303, -84.337882),
    "40460": (37.345751, -84.31614),
    "40461": (37.593625, -84.426456),
    "40464": (37.571105, -84.924963),
    "40467": (37.416008, -83.993588),
    "40468": (37.637433, -84.97602),
    "40472": (37.713915, -83.856874),
    "40473": (37.345751, -84.31614),
    "40475": (37.764867, -84.296913),
    "40476": (37.716443, -84.299699),
    "40481": (37.46592, -84.059717),
    "40484": (37.522046, -84.684467),
    "40486": (37.357587, -83.930007),
    "40488": (37.47477, -84.042748),
    "40489": (37.377689, -84.620613),
    "40492": (37.345751, -84.31614),
    "40495": (37.709721, -84.082894),
    "40502": (38.016674, -84.486043),
    "40503": (38.002578, -84.539437),
    "40504": (38.038613, -84.539422),
    "40505": (38.060845, -84.462937),
    "40506": (38.028712, -84.507471),
    "40507": (38.045571, -84.495969),
    "40508": (38.051285, -84.498954),
    "40509": (37.986629, -84.372883),
    "40510": (38.06146, -84.594901),
    "40511": (38.132747, -84.492226),
    "40512": (38.028269, -84.471505),
    "40513": (38.01513, -84.605827),
    "40514": (37.982677, -84.560827),
    "40515": (37.924774, -84.437207),
    "40516": (38.064867, -84.430752),
    "40517": (37.986751, -84.487251),
    "40522": (38.028269, -84.471505),
    "40523": (38.028269, -84.471505),
    "40524": (38.028269, -84.471505),
    "40526": (38.028269, -84.471505),
    "40533": (38.028269, -84.471505),
    "40536": (38.032075, -84.508361),
    "40544": (38.028269, -84.471505),
    "40546": (38.028269, -84.471505),
    "40550": (38.028269, -84.471505),
    "40555": (38.028269, -84.471505),
    "40574": (38.028269, -84.471505),
    "40575": (38.028269, -84.471505),
    "40576": (38.028269, -84.471505),
    "40577": (38.028269, -84.471505),
    "40578": (38.028269, -84.471505),
    "40579": (38.028269, -84.471505),
    "40580": (38.028269, -84.471505),
    "40581": (38.028269, -84.471505),
    "40582": (38.028269, -84.471505),
    "40583": (38.028269, -84.471505),
    "40584": (38.028269, -84.471505),
    "40585": (38.028269, -84.471505),
    "40586": (38.028269, -84.471505),
    "40587": (38.028269, -84.471505),
    "40588": (38.028269, -84.471505),
    "40589": (38.028269, -84.471505),
    "40590": (38.028269, -84.471505),
    "40591": (38.028269, -84.471505),
    "40592": (38.028269, -84.471505),
    "40593": (38.028269, -84.471505),
    "40594": (38.028269, -84.471505),
    "40595": (38.028269, -84.471505),
    "40596": (38.028269, -84.471505),
    "40601": (38.228115, -84.869708),
    "40602": (38.234133, -84.874809),
    "40603": (38.234133, -84.874809),
    "40604": (38.234133, -84.874809),
    "40618": (38.234133, -84.874809),
    "40619": (38.234133, -84.874809),
    "40620": (38.234133, -84.874809),
    "40621": (38.234133, -84.874809),
    "40622": (38.234133, -84.874809),
    "40701": (36.854371, -84.184688),
    "40702": (36.937426, -84.1031),
    "40724": (37.152074, -84.140847),
    "40729": (37.248761, -84.13796),
    "40730": (36.703868, -84.141486),
    "40734": (36.936999, -83.933848),
    "40737": (36.997587, -84.129021),
    "40740": (37.025647, -84.028217),
    "40741": (37.154931, -84.096062),
    "40742": (37.137615, -84.115617),
    "40743": (37.134455, -84.045746),
    "40744": (37.09949, -84.113057),
    "40745": (37.137615, -84.115617),
    "40751": (37.137615, -84.115617),
    "40754": (36.780333, -84.11678),
    "40755": (37.167752, -84.116614),
    "40759": (36.832568, -84.070522),
    "40763": (36.702504, -83.955033),
    "40769": (36.747032, -84.139406),
    "40771": (36.871254, -83.829985),
    "40801": (36.865351, -83.287927),
    "40803": (37.011357, -83.4553),
    "40806": (36.879484, -83.304537),
    "40807": (36.971157, -82.955273),
    "40808": (36.984102, -83.206701),
    "40810": (36.934041, -83.324159),
    "40813": (36.714629, -83.64046),
    "40815": (36.781218, -83.291362),
    "40816": (37.009799, -83.349418),
    "40818": (36.789038, -83.264806),
    "40819": (36.820072, -83.470712),
    "40820": (36.847188, -83.170137),
    "40823": (36.912209, -83.163759),
    "40824": (36.835555, -83.375307),
    "40826": (37.043638, -82.809267),
    "40827": (37.054676, -83.456094),
    "40828": (36.839806, -83.223251),
    "40829": (36.797447, -83.264497),
    "40830": (36.77011, -83.330675),
    "40831": (36.861519, -83.203025),
    "40840": (36.954292, -83.431346),
    "40843": (36.876106, -82.988157),
    "40844": (37.070198, -83.424395),
    "40845": (36.769184, -83.708181),
    "40847": (36.87338, -83.145061),
    "40849": (36.889879, -83.14331),
    "40854": (36.848097, -83.353034),
    "40855": (36.960303, -82.919767),
    "40856": (36.769184, -83.708181),
    "40858": (36.998854, -83.394253),
    "40862": (37.012888, -82.879541),
    "40863": (36.74962, -83.45935),
    "40865": (36.903881, -83.238139),
    "40868": (37.08308, -83.419745),
    "40870": (36.932991, -83.161655),
    "40873": (36.817164, -83.419056),
    "40874": (36.98397, -83.466672),
    "40902": (36.769184, -83.708181),
    "40903": (36.839539, -83.850573),
    "40906": (36.810109, -83.894888),
    "40913": (36.769184, -83.708181),
    "40914": (37.147687, -83.737014),
    "40915": (36.908172, -83.78916100000001),
    "40921": (36.871254, -83.829985),
    "40923": (36.871254, -83.829985),
    "40927": (36.88452, -83.030287),
    "40930": (36.871254, -83.829985),
    "40931": (37.147687, -83.737014),
    "40932": (37.147687, -83.737014),
    "40935": (36.871254, -83.829985),
    "40939": (36.871254, -83.829985),
    "40940": (36.769184, -83.708181),
    "40941": (37.147687, -83.737014),
    "40943": (36.871254, -83.829985),
    "40944": (37.147687, -83.737014),
    "40946": (36.871254, -83.829985),
    "40949": (36.871254, -83.829985),
    "40951": (37.147687, -83.737014),
    "40953": (36.871254, -83.829985),
    "40955": (36.769184, -83.708181),
    "40958": (36.769184, -83.708181),
    "40962": (37.151101, -83.779273),
    "40964": (36.842977, -83.183446),
    "40965": (36.669566, -83.693159),
    "40972": (37.147687, -83.737014),
    "40977": (36.715863, -83.766776),
    "40979": (37.043772, -83.494862),
    "40981": (37.331259, -83.386991),
    "40982": (36.871254, -83.829985),
    "40983": (37.147687, -83.737014),
    "40988": (36.769184, -83.708181),
    "40995": (36.871254, -83.829985),
    "40997": (36.871254, -83.829985),
    "40999": (36.871254, -83.829985),
    "41001": (38.921584, -84.374584),
    "41002": (38.72342, -83.982911),
    "41003": (38.442076, -84.347201),
    "41004": (38.638654, -84.093504),
    "41005": (39.015027, -84.773564),
    "41006": (38.739446, -84.392841),
    "41007": (38.905563, -84.317079),
    "41008": (38.663866, -85.098906),
    "41010": (38.552305, -84.611567),
    "41011": (39.05906, -84.542748),
    "41012": (38.944663, -84.520501),
    "41014": (39.064211, -84.511793),
    "41015": (38.94711, -84.490048),
    "41016": (39.082839, -84.574749),
    "41017": (39.029983, -84.55902),
    "41018": (39.019684, -84.591389),
    "41019": (38.944663, -84.520501),
    "41022": (38.962372, -84.747789),
    "41030": (38.770542, -84.597256),
    "41031": (38.356954, -84.323033),
    "41033": (38.762312, -84.485907),
    "41034": (38.707093, -83.904101),
    "41035": (38.691789, -84.650966),
    "41037": (38.3481, -83.718626),
    "41039": (38.3481, -83.718626),
    "41040": (38.637848, -84.318142),
    "41041": (38.438363, -83.73228399999999),
    "41042": (38.989548, -84.656711),
    "41043": (38.766691, -84.171226),
    "41044": (38.635744, -83.989965),
    "41045": (38.715638, -85.047073),
    "41046": (38.732647, -84.805495),
    "41048": (39.086656, -84.712389),
    "41049": (38.237176, -83.584351),
    "41051": (38.923041, -84.54745),
    "41052": (38.658689, -84.750673),
    "41053": (38.944663, -84.520501),
    "41054": (38.593226, -84.578552),
    "41055": (38.522012, -83.860969),
    "41056": (38.620653, -83.806657),
    "41059": (39.003401, -84.35698),
    "41061": (38.688556, -84.070074),
    "41062": (38.719573, -83.910276),
    "41063": (38.866297, -84.517548),
    "41064": (38.531698, -84.035565),
    "41065": (38.3481, -83.718626),
    "41071": (39.056261, -84.478742),
    "41072": (38.963761, -84.368926),
    "41073": (39.10441, -84.473642),
    "41074": (39.057835, -84.396404),
    "41075": (39.080411, -84.453991),
    "41076": (39.029015, -84.440757),
    "41080": (39.039096, -84.837832),
    "41081": (38.3481, -83.718626),
    "41083": (38.660372, -85.005783),
    "41085": (39.034045, -84.388143),
    "41086": (38.731246, -84.895823),
    "41091": (38.921583, -84.746057),
    "41092": (38.824585, -84.692136),
    "41093": (38.3481, -83.718626),
    "41094": (38.88142, -84.665597),
    "41095": (38.762505, -84.877785),
    "41096": (38.61225, -83.808021),
    "41097": (38.654385, -84.603041),
    "41098": (38.637181, -85.047765),
    "41099": (38.963761, -84.368926),
    "41101": (38.43296, -82.693914),
    "41102": (38.421818, -82.717284),
    "41105": (38.370285, -82.694757),
    "41114": (38.370285, -82.694757),
    "41121": (38.511714, -82.872362),
    "41124": (38.074113, -82.744663),
    "41127": (38.602881, -83.361625),
    "41128": (38.433912, -83.133597),
    "41129": (38.349127, -82.649833),
    "41132": (38.259701, -82.856231),
    "41135": (38.521926, -83.335329),
    "41137": (38.521926, -83.335329),
    "41139": (38.50316, -82.728176),
    "41141": (38.521926, -83.335329),
    "41142": (38.28974, -83.081077),
    "41143": (38.324893, -83.000742),
    "41144": (38.617863, -82.839401),
    "41146": (38.271432, -83.061941),
    "41149": (38.131568, -83.079708),
    "41150": (38.225087, -83.242129),
    "41156": (38.565211, -82.916586),
    "41159": (38.074113, -82.744663),
    "41160": (38.074113, -82.744663),
    "41164": (38.349219, -83.177987),
    "41166": (38.521926, -83.335329),
    "41168": (38.30911, -82.717666),
    "41169": (38.607408, -82.827053),
    "41170": (38.521926, -83.335329),
    "41171": (38.131568, -83.079708),
    "41173": (38.262029, -83.28472),
    "41174": (38.565211, -82.916586),
    "41175": (38.714809, -82.936626),
    "41179": (38.469945, -83.270248),
    "41180": (38.190296, -82.882533),
    "41181": (38.204459, -82.907615),
    "41183": (38.546615, -82.727678),
    "41189": (38.521926, -83.335329),
    "41201": (38.074113, -82.744663),
    "41203": (37.761149, -82.622288),
    "41204": (37.822653, -82.694671),
    "41214": (37.800137, -82.559438),
    "41215": (37.771963, -82.865092),
    "41216": (37.757935, -82.818187),
    "41219": (37.923134, -82.922077),
    "41222": (37.780451, -82.841565),
    "41224": (37.8754, -82.533718),
    "41226": (37.973831, -82.966183),
    "41228": (37.739663, -82.865598),
    "41230": (38.104327, -82.605591),
    "41231": (37.815648, -82.492731),
    "41232": (38.074113, -82.744663),
    "41234": (37.807776, -82.741549),
    "41238": (37.812772, -82.939108),
    "41240": (37.824167, -82.794504),
    "41250": (37.815648, -82.492731),
    "41254": (37.879486, -82.725052),
    "41255": (37.920063, -82.832532),
    "41256": (37.825284, -82.882251),
    "41257": (37.916598, -82.803427),
    "41260": (37.810703, -82.766705),
    "41262": (37.825114, -82.645668),
    "41263": (37.850698, -82.760226),
    "41264": (38.074113, -82.744663),
    "41265": (37.784196, -82.740121),
    "41267": (37.815648, -82.492731),
    "41268": (37.797057, -82.791012),
    "41271": (37.831277, -82.726407),
    "41274": (37.899527, -82.781153),
    "41301": (37.728737, -83.494029),
    "41307": (37.515013, -83.26432),
    "41310": (37.640513, -83.244088),
    "41311": (37.599904, -83.714013),
    "41313": (37.740503, -83.475446),
    "41314": (37.496523, -83.657351),
    "41317": (37.462104, -83.235959),
    "41332": (37.798052, -83.420976),
    "41333": (37.556255, -83.776253),
    "41338": (37.398617, -83.704908),
    "41339": (37.486809, -83.291331),
    "41342": (37.740503, -83.475446),
    "41344": (37.398617, -83.704908),
    "41347": (37.54418, -83.600784),
    "41348": (37.441782, -83.297614),
    "41351": (37.398617, -83.704908),
    "41352": (37.914001999999996, -83.233761),
    "41360": (37.772774, -83.631377),
    "41362": (37.60332, -83.713974),
    "41364": (37.387127, -83.675179),
    "41365": (37.715699, -83.636349),
    "41366": (37.593059, -83.287774),
    "41367": (37.397017, -83.226964),
    "41368": (37.611684, -83.64341),
    "41377": (37.417538, -83.444462),
    "41385": (37.628827, -83.360738),
    "41386": (37.398617, -83.704908),
    "41390": (37.421929, -83.377999),
    "41397": (37.672317, -83.687173),
    "41408": (37.914001999999996, -83.233761),
    "41410": (37.690636, -83.074592),
    "41413": (37.970507, -83.125202),
    "41419": (37.690636, -83.074592),
    "41421": (37.970781, -83.11931),
    "41422": (37.690636, -83.074592),
    "41425": (37.914001999999996, -83.233761),
    "41426": (37.784255, -83.010863),
    "41433": (37.690636, -83.074592),
    "41444": (37.690636, -83.074592),
    "41451": (37.914001999999996, -83.233761),
    "41459": (37.914001999999996, -83.233761),
    "41464": (37.676288, -83.0225),
    "41465": (37.732536, -83.029761),
    "41472": (37.97621, -83.198234),
    "41477": (37.914001999999996, -83.233761),
    "41501": (37.482901, -82.447075),
    "41502": (37.481637, -82.550507),
    "41503": (37.48871, -82.310048),
    "41512": (37.462655, -82.448017),
    "41513": (37.34781, -82.340599),
    "41514": (37.640727, -82.313128),
    "41517": (37.184477, -82.61109),
    "41519": (37.589934, -82.330826),
    "41520": (37.279027, -82.57732),
    "41522": (37.42367, -82.384689),
    "41524": (37.426582, -82.256227),
    "41526": (37.437194, -82.518527),
    "41527": (37.630682, -82.279522),
    "41528": (37.551774, -82.129733),
    "41531": (37.649157, -82.264495),
    "41534": (37.281894, -82.480755),
    "41535": (37.606484, -82.288195),
    "41537": (37.191103, -82.651342),
    "41538": (37.470577, -82.348837),
    "41539": (37.411318, -82.330705),
    "41540": (37.359184, -82.309224),
    "41542": (37.314848, -82.464979),
    "41543": (37.562421, -82.280348),
    "41544": (37.628873, -82.226783),
    "41546": (37.519774, -82.301252),
    "41547": (37.531145, -82.091605),
    "41548": (37.395235, -82.348728),
    "41549": (37.470577, -82.348837),
    "41553": (37.541435, -82.229946),
    "41554": (37.408938, -82.424168),
    "41555": (37.546621, -82.262124),
    "41557": (37.493468, -82.422135),
    "41558": (37.542575, -82.208487),
    "41559": (37.370376, -82.407751),
    "41560": (37.379875, -82.561632),
    "41561": (37.33162, -82.462574),
    "41562": (37.40628, -82.467345),
    "41563": (37.231149, -82.528583),
    "41564": (37.557911, -82.411486),
    "41566": (37.399777, -82.197771),
    "41567": (37.580715, -82.27437),
    "41568": (37.509279, -82.078363),
    "41569": (37.608343, -82.286675),
    "41571": (37.621659, -82.507019),
    "41572": (37.319685, -82.611355),
    "41601": (37.479896, -82.6769),
    "41602": (37.715759, -82.695892),
    "41603": (37.570682, -82.680631),
    "41604": (37.377377, -82.686866),
    "41605": (37.54042, -82.701035),
    "41606": (37.346493, -82.740255),
    "41607": (37.633196, -82.740742),
    "41612": (37.346545, -82.716529),
    "41615": (37.561699, -82.684788),
    "41616": (37.576668, -82.870801),
    "41619": (37.493261, -82.75754),
    "41621": (37.624553, -82.722679),
    "41622": (37.512564, -82.818388),
    "41630": (37.472094, -82.834287),
    "41631": (37.457565, -82.664491),
    "41632": (37.589246, -82.94521399999999),
    "41635": (37.580715, -82.677387),
    "41636": (37.428614, -82.714841),
    "41640": (37.508668, -82.851807),
    "41642": (37.469203, -82.677517),
    "41643": (37.470999, -82.829405),
    "41645": (37.586933, -82.797386),
    "41647": (37.560801, -82.713723),
    "41649": (37.600698, -82.78595),
    "41650": (37.353614, -82.676257),
    "41651": (37.454849, -82.76464),
    "41653": (37.536748, -82.771139),
    "41655": (37.568892, -82.762194),
    "41659": (37.45838, -82.673213),
    "41660": (37.413736, -82.648485),
    "41663": (37.572499, -82.645206),
    "41666": (37.514783, -82.729805),
    "41667": (37.316961, -82.704127),
    "41669": (37.331441, -82.715606),
    "41701": (37.299666, -83.239904),
    "41702": (37.320076, -83.206495),
    "41712": (37.363778, -83.154594),
    "41713": (37.22539, -83.273609),
    "41714": (37.193912, -83.503508),
    "41719": (37.310308, -83.309013),
    "41721": (37.302001, -83.47173),
    "41722": (37.315033, -83.156088),
    "41723": (37.277522, -83.238897),
    "41725": (37.318236, -83.068963),
    "41727": (37.277764, -83.262663),
    "41729": (37.264854, -83.217443),
    "41730": (37.258617, -83.395648),
    "41731": (37.1408, -83.088916),
    "41735": (37.033615, -83.096311),
    "41736": (37.375823, -83.241868),
    "41739": (37.339408, -83.130273),
    "41740": (37.349857, -83.047116),
    "41743": (37.30636, -83.090441),
    "41745": (37.349687, -83.436773),
    "41746": (37.210078, -83.091716),
    "41747": (37.300202, -83.122477),
    "41749": (37.187746, -83.416902),
    "41751": (37.218395, -83.142655),
    "41754": (37.347409, -83.275015),
    "41759": (37.231962, -83.02461),
    "41760": (37.197107, -83.081735),
    "41762": (37.218801, -83.506407),
    "41763": (37.070492, -83.113638),
    "41764": (37.121424, -83.253867),
    "41766": (37.158641, -83.384749),
    "41772": (37.407264, -83.01531),
    "41773": (37.201968, -83.065816),
    "41774": (37.24369, -83.13639),
    "41775": (37.107867, -83.356305),
    "41776": (37.126066, -83.267303),
    "41777": (37.056529, -83.236134),
    "41778": (37.283017, -83.321215),
    "41804": (37.155055, -82.995605),
    "41810": (37.178814, -82.69498),
    "41812": (37.240912, -82.769564),
    "41815": (37.140336, -82.814691),
    "41817": (37.367552, -82.910653),
    "41819": (36.989061, -83.065458),
    "41821": (37.083683, -83.002662),
    "41822": (37.367278, -82.961977),
    "41824": (37.193211, -82.875397),
    "41825": (37.224615, -82.722772),
    "41826": (37.135577, -82.837148),
    "41828": (37.313565, -82.797478),
    "41831": (37.370519, -82.967672),
    "41832": (37.153075, -82.954758),
    "41833": (37.023328, -82.987812),
    "41834": (37.275003, -82.944607),
    "41835": (37.213652, -82.673426),
    "41836": (37.269218, -82.91613),
    "41837": (37.130234, -82.742726),
    "41838": (37.176559, -82.751669),
    "41839": (37.419099, -82.885808),
    "41840": (37.187588, -82.711046),
    "41843": (37.28679, -82.874059),
    "41844": (37.349054, -82.874239),
    "41845": (37.125231, -82.903459),
    "41847": (37.217206, -82.942357),
    "41848": (37.110216, -82.94073),
    "41849": (37.173926, -82.716166),
    "41855": (37.178608, -82.795137),
    "41858": (37.13885, -82.855032),
    "41859": (37.397578, -82.783552),
    "41861": (37.387621, -82.836144),
    "41862": (37.348498, -82.792578),
    "42001": (37.031586, -88.713292),
    "42002": (37.085511, -88.71247),
    "42003": (37.015159, -88.581289),
    "42020": (36.690186, -88.283872),
    "42021": (36.789033, -89.009178),
    "42022": (37.148007, -88.948562),
    "42023": (36.87522, -89.006956),
    "42024": (37.081273, -89.01148),
    "42025": (36.888765, -88.305502),
    "42027": (36.900149, -88.637039),
    "42028": (37.155977, -88.339599),
    "42029": (36.986553, -88.373197),
    "42031": (36.680798, -88.979474),
    "42032": (36.732689, -89.1019),
    "42033": (37.336533, -88.079607),
    "42035": (36.863147, -88.995991),
    "42036": (36.715535, -88.235991),
    "42037": (37.157866, -88.183598),
    "42038": (37.044697, -88.024871),
    "42039": (36.780953, -88.78873),
    "42040": (36.600013, -88.51864),
    "42041": (36.546939, -89.081143),
    "42044": (36.965547, -88.266684),
    "42045": (37.076174, -88.264746),
    "42046": (36.6033, -88.092285),
    "42047": (37.302521, -88.393763),
    "42048": (36.817672, -88.30444),
    "42049": (36.578831, -88.322336),
    "42050": (36.548671, -89.208001),
    "42051": (36.852197, -88.640928),
    "42053": (37.098119, -88.851344),
    "42054": (36.699095, -88.421888),
    "42055": (37.073525, -88.144971),
    "42056": (37.080505, -88.986278),
    "42058": (37.061146, -88.466549),
    "42060": (36.96365, -88.836371),
    "42061": (36.886172, -88.772824),
    "42063": (36.723872, -88.652009),
    "42064": (37.322088, -88.087479),
    "42066": (36.715599, -88.651839),
    "42069": (36.904548, -88.758968),
    "42070": (36.863147, -88.995991),
    "42071": (36.625349, -88.279562),
    "42076": (36.562065, -88.150463),
    "42078": (37.269417, -88.329698),
    "42079": (36.574835, -88.581458),
    "42081": (37.238666, -88.375665),
    "42082": (36.904412, -88.515287),
    "42083": (37.145668, -88.285031),
    "42084": (37.434913, -88.246148),
    "42085": (36.572137, -88.761466),
    "42086": (37.082918, -88.810261),
    "42087": (37.056862, -88.961579),
    "42088": (36.60784, -88.725226),
    "42101": (37.017407, -86.451752),
    "42102": (36.922292, -86.387046),
    "42103": (36.950002, -86.358413),
    "42104": (36.887214, -86.453985),
    "42120": (36.67931, -86.17603),
    "42122": (36.866699, -86.348542),
    "42123": (36.815869, -85.992039),
    "42124": (36.857666, -85.649583),
    "42127": (37.10279, -85.908887),
    "42128": (36.983441, -86.394012),
    "42129": (37.000783, -85.609522),
    "42130": (36.91297, -85.775282),
    "42131": (36.819311, -85.91168),
    "42133": (36.726089, -85.846991),
    "42134": (36.740598, -86.583305),
    "42135": (36.758166, -86.581957),
    "42140": (36.669398, -85.856306),
    "42141": (36.942763, -85.941203),
    "42142": (36.946326, -85.957797),
    "42150": (36.782131, -86.184088),
    "42151": (36.647144, -85.567555),
    "42152": (37.098753, -85.816472),
    "42153": (36.678703, -86.038273),
    "42154": (37.055613, -85.698474),
    "42156": (36.840503, -85.995572),
    "42157": (36.772341, -85.819518),
    "42159": (36.998452, -86.250131),
    "42160": (36.965149, -86.013864),
    "42163": (37.09425, -86.143188),
    "42164": (36.783817, -86.188104),
    "42166": (36.956935, -85.660577),
    "42167": (36.723634, -85.700865),
    "42170": (36.90641, -86.538),
    "42171": (37.01823, -86.187045),
    "42201": (37.279564, -86.670181),
    "42202": (36.772851, -86.860422),
    "42203": (36.929243, -87.219328),
    "42204": (36.720672, -87.104104),
    "42206": (36.835067, -86.797432),
    "42207": (37.300469, -86.25426),
    "42209": (37.197491, -86.67216),
    "42210": (37.222931, -86.292256),
    "42211": (36.80201, -87.828578),
    "42214": (37.11767, -85.703791),
    "42215": (36.953435, -87.718377),
    "42216": (37.004492, -87.152148),
    "42217": (37.043116, -87.487724),
    "42219": (37.170909, -86.767822),
    "42220": (36.862405, -87.177881),
    "42221": (36.898071, -87.496529),
    "42223": (36.657253, -87.458858),
    "42232": (36.918213, -87.580011),
    "42234": (36.714895, -87.150248),
    "42235": (36.983441, -86.394012),
    "42236": (36.719274, -87.604569),
    "42240": (36.876568, -87.471106),
    "42241": (36.898071, -87.496529),
    "42251": (37.157967, -86.885846),
    "42252": (37.248326, -86.509271),
    "42254": (36.677547, -87.645839),
    "42256": (36.907058, -86.918045),
    "42257": (37.237211, -86.299361),
    "42259": (37.280199, -86.168796),
    "42261": (37.20017, -86.685898),
    "42262": (36.738092, -87.429302),
    "42265": (36.759526, -86.980398),
    "42266": (36.864233, -87.409139),
    "42267": (37.229645, -86.804803),
    "42270": (36.983441, -86.394012),
    "42273": (37.207489, -86.859847),
    "42274": (36.924137, -86.597869),
    "42275": (37.242474, -86.411435),
    "42276": (36.845273, -86.882321),
    "42280": (36.948365, -87.1095),
    "42283": (36.869206, -86.663225),
    "42285": (37.236073, -86.27074),
    "42286": (36.74195, -87.24589),
    "42287": (37.318319, -86.522996),
    "42288": (37.197491, -86.67216),
    "42301": (37.751818, -87.257303),
    "42302": (37.745491, -87.112823),
    "42303": (37.779387, -87.042939),
    "42304": (37.745491, -87.112823),
    "42320": (37.355569, -86.864676),
    "42321": (37.153324, -87.024457),
    "42322": (37.615062, -87.406866),
    "42323": (37.233477, -87.076198),
    "42324": (37.137789, -87.004852),
    "42325": (37.337159, -87.271176),
    "42326": (37.199946, -87.00006),
    "42327": (37.58095, -87.287491),
    "42328": (37.394873, -87.026469),
    "42330": (37.243098, -87.111579),
    "42332": (37.253342, -87.089689),
    "42333": (37.373832, -86.764417),
    "42334": (37.745491, -87.112823),
    "42337": (37.211475, -87.008634),
    "42338": (37.552013, -86.77762),
    "42339": (37.194268, -87.018401),
    "42343": (37.614496, -86.729497),
    "42344": (37.246726, -87.297584),
    "42345": (37.20083, -87.164385),
    "42347": (37.472545, -86.869715),
    "42348": (37.832151, -86.782723),
    "42349": (37.415242, -86.689904),
    "42350": (37.459336, -87.206541),
    "42351": (37.911077, -86.882034),
    "42352": (37.513281, -87.112413),
    "42354": (37.363601, -86.924358),
    "42355": (37.859021, -86.977249),
    "42356": (37.693229, -87.323841),
    "42361": (37.518118, -86.718192),
    "42364": (37.827235, -86.804814),
    "42365": (37.112633, -86.994053),
    "42366": (37.719598, -86.929674),
    "42367": (37.242948, -87.154898),
    "42368": (37.740277, -86.741434),
    "42369": (37.389897, -86.88526),
    "42370": (37.545044, -86.778272),
    "42371": (37.470441, -87.246152),
    "42372": (37.488059, -87.258644),
    "42374": (37.353575, -87.165762),
    "42375": (37.745491, -87.112823),
    "42376": (37.633807, -87.12177),
    "42377": (37.745491, -87.112823),
    "42378": (37.682485, -86.883013),
    "42402": (37.778911, -87.60124),
    "42403": (37.446023, -87.933437),
    "42404": (37.486077, -87.812941),
    "42406": (37.754734, -87.689478),
    "42408": (37.220571, -87.624098),
    "42409": (37.519247, -87.67168),
    "42410": (37.27427, -87.513052),
    "42411": (37.201173, -87.988003),
    "42413": (37.335312, -87.469567),
    "42419": (37.807173, -87.599052),
    "42420": (37.785068, -87.527383),
    "42431": (37.299458, -87.532576),
    "42436": (37.406689, -87.563868),
    "42437": (37.686939, -87.943938),
    "42440": (37.249018, -87.461536),
    "42441": (37.364469, -87.651863),
    "42442": (37.257874, -87.506773),
    "42444": (37.641002, -87.643862),
    "42445": (37.140606, -87.865635),
    "42450": (37.484437, -87.734014),
    "42451": (37.8497, -87.378292),
    "42452": (37.700857, -87.551576),
    "42453": (37.160353, -87.569718),
    "42455": (37.570081, -87.636436),
    "42456": (37.505442, -87.534622),
    "42457": (37.83233, -87.788906),
    "42458": (37.840368, -87.547026),
    "42459": (37.628913, -87.989378),
    "42460": (37.493997, -87.932773),
    "42461": (37.717433, -87.914375),
    "42462": (37.631341, -87.866487),
    "42463": (37.487972, -87.866125),
    "42464": (37.20031, -87.400477),
    "42501": (37.10288, -84.544294),
    "42502": (37.09325, -84.427729),
    "42503": (37.131938, -84.518445),
    "42516": (37.242524, -84.89986),
    "42518": (36.952751, -84.624731),
    "42519": (37.029301, -84.537413),
    "42528": (37.190615, -84.983484),
    "42533": (37.114754, -84.69969),
    "42539": (37.302162, -84.957722),
    "42541": (37.36719, -84.798875),
    "42544": (37.063143, -84.719207),
    "42553": (37.110682, -84.686815),
    "42558": (36.94919, -84.581482),
    "42564": (37.111433, -84.592898),
    "42565": (37.15679, -84.879909),
    "42566": (37.291935, -84.82628),
    "42567": (37.128053, -84.59699),
    "42602": (36.745738, -85.181967),
    "42603": (36.751732, -85.135354),
    "42629": (36.945046, -85.124561),
    "42631": (36.777331, -84.502512),
    "42632": (36.800363, -84.818345),
    "42633": (36.8674, -84.8254),
    "42634": (36.777331, -84.502512),
    "42635": (36.777331, -84.502512),
    "42638": (36.777331, -84.502512),
    "42642": (37.019307, -85.069717),
    "42647": (36.777331, -84.502512),
    "42649": (36.777331, -84.502512),
    "42653": (36.721677, -84.467609),
    "42701": (37.684807, -85.878391),
    "42702": (37.723474, -85.976854),
    "42711": (36.879564, -85.317785),
    "42712": (37.493818, -86.286363),
    "42713": (37.370142, -85.913432),
    "42715": (36.955287, -85.403561),
    "42716": (37.485493, -85.626798),
    "42717": (36.769106, -85.408741),
    "42718": (37.337416, -85.357952),
    "42719": (37.337936, -85.330374),
    "42720": (37.121145, -85.370926),
    "42721": (37.430259, -86.370024),
    "42722": (37.277025, -85.727548),
    "42724": (37.669044, -86.054481),
    "42726": (37.433583, -86.208318),
    "42728": (37.116131, -85.265586),
    "42729": (37.260115, -85.982964),
    "42731": (36.842115, -85.539565),
    "42732": (37.606115, -86.090565),
    "42733": (37.340494, -85.218987),
    "42735": (37.045089, -85.29683),
    "42740": (37.602581, -86.007199),
    "42741": (37.006969, -85.248697),
    "42742": (37.091158, -85.465005),
    "42743": (37.27586, -85.519334),
    "42746": (37.216477, -85.772032),
    "42748": (37.559321, -85.707267),
    "42749": (37.202266, -85.89552),
    "42753": (37.231312, -85.17202),
    "42754": (37.460336, -86.324894),
    "42755": (37.471943, -86.343941),
    "42757": (37.469063, -85.723511),
    "42758": (37.360392, -85.198031),
    "42759": (36.830573, -85.50154),
    "42761": (37.107146, -85.459565),
    "42762": (37.444623, -86.400828),
    "42764": (37.463961, -85.639231),
    "42765": (37.29204, -85.914004),
    "42776": (37.515024, -85.950238),
    "42782": (37.354827, -85.614043),
    "42783": (37.567134, -86.085259),
    "42784": (37.478353, -85.963435),
    "42786": (36.819839, -85.462435),
    "42788": (37.534951, -86.033456),
    "43001": (40.100513, -82.612389),
    "43002": (39.969036, -83.011389),
    "43003": (40.389346, -82.98071),
    "43004": (40.016713, -82.839198),
    "43005": (40.29623, -82.27362),
    "43006": (40.477294, -82.191485),
    "43007": (40.340633, -83.416306),
    "43008": (39.944674, -82.47972),
    "43009": (40.161025, -83.648461),
    "43010": (39.99914, -83.622204),
    "43011": (40.313394, -82.665177),
    "43013": (40.115251, -82.690898),
    "43014": (40.417167, -82.270253),
    "43015": (40.289886, -82.981095),
    "43016": (39.969036, -83.011389),
    "43017": (40.076041, -82.814456),
    "43018": (39.957167, -82.683686),
    "43019": (40.487135, -82.512463),
    "43021": (40.201142, -82.874886),
    "43022": (40.338527, -82.348673),
    "43023": (40.048971, -82.539941),
    "43025": (39.974804, -82.511108),
    "43026": (39.969036, -83.011389),
    "43027": (40.132821, -82.561556),
    "43028": (40.418367, -82.283974),
    "43029": (40.128208, -83.442548),
    "43030": (39.968846, -82.430017),
    "43031": (40.16145, -82.60439),
    "43032": (40.313445, -82.961585),
    "43033": (39.953532, -82.593998),
    "43035": (40.187886, -82.987804),
    "43036": (40.352835, -83.263418),
    "43037": (40.29519, -82.322187),
    "43040": (40.267651, -83.376632),
    "43041": (40.306924, -83.360645),
    "43044": (40.117805, -83.587808),
    "43045": (40.170089, -83.441008),
    "43046": (39.884758, -82.539214),
    "43047": (40.204914, -83.646581),
    "43048": (40.406113, -82.465777),
    "43050": (40.37066, -82.481346),
    "43054": (40.085113, -82.814347),
    "43055": (40.085963, -82.485985),
    "43056": (40.004407, -82.467105),
    "43058": (40.095148, -82.482659),
    "43060": (40.204788, -83.568531),
    "43061": (40.295612, -83.199506),
    "43062": (40.014869, -82.624424),
    "43064": (40.057901, -83.307323),
    "43065": (40.183405, -83.091235),
    "43066": (40.380541, -83.172985),
    "43067": (40.337997, -83.465462),
    "43068": (39.951513, -82.802896),
    "43070": (40.172288, -83.962411),
    "43071": (40.189158, -82.353301),
    "43072": (40.121683, -83.947262),
    "43073": (39.996516, -82.754034),
    "43074": (40.266029, -82.854334),
    "43076": (39.851267, -82.385238),
    "43077": (40.124392, -83.30822),
    "43078": (40.121722, -83.797312),
    "43080": (40.17595, -82.444279),
    "43081": (40.10447, -82.896457),
    "43082": (40.167712, -82.869636),
    "43083": (40.102185, -83.83786),
    "43084": (40.1511, -83.545445),
    "43085": (40.040113, -82.897222),
    "43086": (39.969036, -83.011389),
    "43093": (40.095148, -82.482659),
    "43098": (40.095148, -82.482659),
    "43101": (39.466524, -82.754731),
    "43102": (39.698161, -82.688692),
    "43103": (39.67194, -83.015457),
    "43105": (39.77796, -82.665141),
    "43106": (39.64064, -83.419366),
    "43107": (39.697655, -82.554876),
    "43109": (39.924238, -82.846098),
    "43110": (39.821343, -82.764939),
    "43111": (39.504455, -82.242899),
    "43112": (39.80114, -82.706291),
    "43113": (39.597084, -82.945899),
    "43115": (39.479662, -83.099899),
    "43116": (39.769857, -83.060153),
    "43117": (39.773025, -83.199472),
    "43119": (39.969036, -83.011389),
    "43123": (39.969036, -83.011389),
    "43125": (39.84692, -82.88487),
    "43126": (39.969036, -83.011389),
    "43127": (39.476564, -82.328099),
    "43128": (39.654055, -83.572613),
    "43130": (39.68965, -82.609282),
    "43135": (39.462546, -82.666506),
    "43136": (39.76155, -82.7219),
    "43137": (39.761894, -82.98932),
    "43138": (39.52535, -82.437424),
    "43140": (39.886277, -83.407733),
    "43142": (39.588319, -83.583292),
    "43143": (39.765249, -83.344831),
    "43144": (39.505508, -82.171089),
    "43145": (39.56981, -83.21419),
    "43146": (39.682607, -83.14155),
    "43147": (39.781747, -82.664536),
    "43148": (39.82724, -82.500765),
    "43149": (39.525792, -82.606994),
    "43150": (39.77882, -82.438446),
    "43151": (39.727083, -83.452833),
    "43152": (39.417379, -82.592291),
    "43153": (39.748496, -83.531355),
    "43154": (39.616, -82.80858),
    "43155": (39.63769, -82.532092),
    "43156": (39.555583, -82.782171),
    "43157": (39.842263, -82.560131),
    "43158": (39.433804, -82.366742),
    "43160": (39.536986, -83.455012),
    "43162": (39.94886, -83.309892),
    "43163": (39.7631, -82.447024),
    "43164": (39.604282, -83.126646),
    "43199": (39.969036, -83.011389),
    "43201": (39.969036, -83.011389),
    "43202": (39.969036, -83.011389),
    "43203": (39.969036, -83.011389),
    "43204": (39.969036, -83.011389),
    "43205": (39.969036, -83.011389),
    "43206": (39.969036, -83.011389),
    "43207": (39.86905, -82.958539),
    "43209": (39.969036, -83.011389),
    "43210": (39.914038, -82.832558),
    "43211": (39.969036, -83.011389),
    "43212": (39.969036, -83.011389),
    "43213": (39.972734, -82.832887),
    "43214": (39.969036, -83.011389),
    "43215": (39.891745, -82.877131),
    "43216": (39.969036, -83.011389),
    "43217": (39.827675, -82.934198),
    "43218": (39.969036, -83.011389),
    "43219": (40.032615, -82.910251),
    "43220": (39.969036, -83.011389),
    "43221": (39.969036, -83.011389),
    "43222": (39.969036, -83.011389),
    "43223": (39.969036, -83.011389),
    "43224": (40.080339, -82.928604),
    "43226": (39.969036, -83.011389),
    "43227": (39.922863, -82.858048),
    "43228": (39.969036, -83.011389),
    "43229": (40.095713, -82.962671),
    "43230": (40.034713, -82.872611),
    "43231": (40.084463, -82.933811),
    "43232": (39.922663, -82.85664),
    "43234": (39.969036, -83.011389),
    "43235": (40.108836, -82.974204),
    "43236": (40.135711, -83.007626),
    "43240": (39.969036, -83.011389),
    "43251": (39.969036, -83.011389),
    "43260": (39.969036, -83.011389),
    "43265": (39.969036, -83.011389),
    "43266": (39.969036, -83.011389),
    "43268": (39.969036, -83.011389),
    "43270": (39.969036, -83.011389),
    "43271": (39.969036, -83.011389),
    "43272": (39.969036, -83.011389),
    "43279": (39.969036, -83.011389),
    "43287": (39.969036, -83.011389),
    "43291": (39.969036, -83.011389),
    "43299": (39.969036, -83.011389),
    "43301": (40.616604, -83.069296),
    "43302": (40.584028, -83.101687),
    "43306": (40.56941, -83.139341),
    "43307": (40.56941, -83.139341),
    "43310": (40.491005, -83.752068),
    "43311": (40.378783, -83.787784),
    "43314": (40.631257, -82.958179),
    "43315": (40.479648, -82.852969),
    "43316": (40.927265, -83.387038),
    "43317": (40.478905, -82.682805),
    "43318": (40.374272, -83.784554),
    "43319": (40.303893, -83.728511),
    "43320": (40.588234, -82.890436),
    "43321": (40.49712, -82.834207),
    "43322": (40.541659, -83.230407),
    "43323": (40.7346, -83.253668),
    "43324": (40.43991, -83.809604),
    "43325": (40.60796, -82.872954),
    "43326": (40.6401, -83.616923),
    "43330": (40.813023, -83.419606),
    "43331": (40.501851, -83.92023),
    "43332": (40.596476, -83.344599),
    "43333": (40.436912, -83.926452),
    "43334": (40.406317, -82.782091),
    "43335": (40.668497, -82.909984),
    "43336": (40.294825, -83.57726),
    "43337": (40.667978, -83.26335),
    "43338": (40.525904, -82.752848),
    "43340": (40.561493, -83.495423),
    "43341": (40.599228, -83.308663),
    "43342": (40.492106, -83.178414),
    "43343": (40.391089, -83.792897),
    "43344": (40.427182, -83.352079),
    "43345": (40.532668, -83.58265),
    "43346": (40.573227, -83.846199),
    "43347": (40.474334, -83.650983),
    "43348": (40.402746, -83.890243),
    "43349": (40.614239, -82.661938),
    "43350": (40.528862, -82.82292),
    "43351": (40.828153, -83.313786),
    "43356": (40.475651, -83.048607),
    "43357": (40.278247, -83.713148),
    "43358": (40.36691, -83.625912),
    "43359": (40.875991, -83.448021),
    "43360": (40.321114, -83.640462),
    "43402": (41.376449, -83.613714),
    "43403": (41.39235, -83.648996),
    "43406": (41.334031, -83.542092),
    "43407": (41.278621, -83.244604),
    "43408": (41.568599, -83.363224),
    "43410": (41.321281, -82.948337),
    "43412": (41.597798, -83.357328),
    "43413": (41.226545, -83.664525),
    "43414": (41.39235, -83.648996),
    "43416": (41.57267, -83.078075),
    "43420": (41.35622, -83.133981),
    "43430": (41.524657, -83.352477),
    "43431": (41.392094, -83.317648),
    "43432": (41.564723, -83.26128),
    "43433": (41.503759, -82.87084),
    "43434": (41.645699, -83.620233),
    "43435": (41.325996, -83.318648),
    "43436": (41.715332, -82.822697),
    "43437": (41.255902, -83.602198),
    "43438": (41.59593, -82.706816),
    "43439": (41.518115, -83.041312),
    "43440": (41.524698, -82.776567),
    "43441": (41.536132, -83.45938),
    "43442": (41.422628, -83.231171),
    "43443": (41.457596, -83.473648),
    "43445": (41.569398, -83.311577),
    "43446": (41.683477, -82.804677),
    "43447": (41.426265, -83.512454),
    "43449": (41.53653, -83.144869),
    "43450": (41.398798, -83.484086),
    "43451": (41.315346, -83.621091),
    "43452": (41.558318, -83.050219),
    "43456": (41.647236, -82.819009),
    "43457": (41.336722, -83.466992),
    "43458": (41.530157, -83.21276),
    "43460": (41.458371, -83.529646),
    "43462": (41.283902, -83.72564),
    "43463": (41.509051, -83.508531),
    "43464": (41.396673, -82.921319),
    "43465": (41.462958, -83.49109),
    "43466": (41.296984, -83.524683),
    "43467": (41.24264, -83.489583),
    "43468": (41.605048, -83.338128),
    "43469": (41.42021, -83.31686),
    "43501": (41.577786, -84.584125),
    "43502": (41.578355, -84.25106),
    "43504": (41.606301, -83.822288),
    "43505": (41.523945, -84.730275),
    "43506": (41.553851, -84.585209),
    "43510": (41.419878, -84.013674),
    "43511": (41.259285, -83.811421),
    "43512": (41.296657, -84.390413),
    "43515": (41.58568, -84.124257),
    "43516": (41.232641, -83.949391),
    "43517": (41.554099, -84.620862),
    "43518": (41.58754, -84.738401),
    "43519": (41.422158, -84.396619),
    "43520": (41.39066, -84.631322),
    "43521": (41.649036, -84.28596),
    "43522": (41.394707, -83.834935),
    "43523": (41.341081, -84.000532),
    "43524": (41.230082, -84.035807),
    "43525": (41.466702, -83.705486),
    "43526": (41.325013, -84.678021),
    "43527": (41.23175, -84.129612),
    "43528": (41.628501, -83.751138),
    "43529": (41.187234, -83.784704),
    "43530": (41.325764, -84.279306),
    "43531": (41.634007, -84.502598),
    "43532": (41.429356, -84.008448),
    "43533": (41.68575, -84.161891),
    "43534": (41.356582, -83.941313),
    "43535": (41.305439, -84.003632),
    "43536": (41.31085, -84.640393),
    "43537": (41.571251, -83.685036),
    "43540": (41.688656, -84.104541),
    "43541": (41.300891, -83.829596),
    "43542": (41.577251, -83.772378),
    "43543": (41.606061, -84.588777),
    "43545": (41.355586, -84.123028),
    "43547": (41.491952, -83.870598),
    "43548": (41.194308, -84.141421),
    "43549": (41.361864, -84.51582),
    "43550": (41.326664, -84.111701),
    "43551": (41.535057, -83.577701),
    "43552": (41.39235, -83.648996),
    "43553": (41.531033, -84.225646),
    "43554": (41.648218, -84.585241),
    "43555": (41.435059, -84.254414),
    "43556": (41.318045, -84.569545),
    "43557": (41.488708, -84.409876),
    "43558": (41.593787, -84.103035),
    "43560": (41.6929, -83.727737),
    "43565": (41.423102, -83.747936),
    "43566": (41.513751, -83.765287),
    "43567": (41.59151, -84.178148),
    "43569": (41.35002, -83.796033),
    "43570": (41.591453, -84.447033),
    "43571": (41.509602, -83.801789),
    "43601": (41.720684, -83.569359),
    "43602": (41.647449, -83.548128),
    "43603": (41.686778, -83.43943),
    "43604": (41.655798, -83.536833),
    "43605": (41.652548, -83.508482),
    "43606": (41.674099, -83.604535),
    "43607": (41.647399, -83.606785),
    "43608": (41.681648, -83.531983),
    "43609": (41.624749, -83.584234),
    "43610": (41.673449, -83.556083),
    "43611": (41.698298, -83.486382),
    "43612": (41.695847, -83.460181),
    "43613": (41.703548, -83.606235),
    "43614": (41.609041, -83.633941),
    "43615": (41.6496, -83.678586),
    "43616": (41.656948, -83.44433),
    "43617": (41.66765, -83.722437),
    "43618": (41.656948, -83.399129),
    "43619": (41.596099, -83.485681),
    "43620": (41.664849, -83.553933),
    "43623": (41.702949, -83.682686),
    "43624": (41.654599, -83.546233),
    "43635": (41.686778, -83.43943),
    "43652": (41.686778, -83.43943),
    "43653": (41.686778, -83.43943),
    "43654": (41.686778, -83.43943),
    "43655": (41.686778, -83.43943),
    "43656": (41.678167, -83.497155),
    "43657": (41.686778, -83.43943),
    "43659": (41.686778, -83.43943),
    "43660": (41.654649, -83.532883),
    "43661": (41.678167, -83.497155),
    "43666": (41.678167, -83.497155),
    "43667": (41.686778, -83.43943),
    "43681": (41.686778, -83.43943),
    "43682": (41.686778, -83.43943),
    "43697": (41.686778, -83.43943),
    "43699": (41.653788, -83.658937),
    "43701": (39.927415, -82.004058),
    "43702": (39.961236, -81.962539),
    "43711": (39.827556, -81.554854),
    "43713": (39.985318, -81.137495),
    "43716": (39.780188, -80.991731),
    "43717": (39.768475, -81.465752),
    "43718": (40.004009, -80.988043),
    "43719": (39.996312, -81.065991),
    "43720": (39.820021, -81.876343),
    "43721": (39.94518, -82.255984),
    "43722": (39.91944, -81.53113),
    "43723": (39.953185, -81.531919),
    "43724": (39.744445999999996, -81.483049),
    "43725": (40.02701, -81.582025),
    "43727": (39.865211, -81.799363),
    "43728": (39.497841, -81.898307),
    "43730": (39.636069, -82.110219),
    "43731": (39.704142, -82.165011),
    "43732": (39.88812, -81.617372),
    "43733": (39.923616, -81.542965),
    "43734": (39.872071, -81.89422),
    "43735": (39.853931, -82.121262),
    "43736": (40.064971, -81.255793),
    "43738": (39.855525, -82.137754),
    "43739": (39.884312, -82.297706),
    "43740": (39.953262, -82.211784),
    "43746": (39.970024, -82.174647),
    "43747": (39.82588, -81.123561),
    "43748": (39.684697, -82.302787),
    "43749": (40.158911, -81.548992),
    "43750": (39.994467, -81.500579),
    "43752": (39.717086, -81.009999),
    "43754": (39.74607, -81.227706),
    "43755": (40.052671, -81.435723),
    "43756": (39.676688, -81.81256),
    "43757": (39.859373, -81.151604),
    "43758": (39.632381, -81.908715),
    "43759": (40.011338, -80.970135),
    "43760": (39.760789, -82.20775),
    "43761": (39.740299, -82.248369),
    "43762": (40.024342, -81.767017),
    "43764": (39.706051, -82.20614),
    "43766": (39.619477, -82.252758),
    "43767": (40.011106, -81.804302),
    "43768": (40.039201, -81.452164),
    "43771": (39.822159, -81.954582),
    "43772": (39.918285, -81.551647),
    "43773": (40.040755, -81.31356099999999),
    "43777": (39.821869, -82.039389),
    "43778": (40.015591, -81.373692),
    "43779": (39.816285, -81.428046),
    "43780": (39.9427, -81.458577),
    "43782": (39.625239, -82.214886),
    "43783": (39.736529, -82.278894),
    "43786": (39.711168, -81.275824),
    "43787": (39.548994, -81.826194),
    "43788": (39.795107, -81.370927),
    "43789": (39.654386, -81.240732),
    "43791": (39.87133, -82.098668),
    "43793": (39.751516, -81.075921),
    "43802": (40.090767, -81.855203),
    "43803": (40.357237, -81.643638),
    "43804": (40.426559, -81.67444),
    "43805": (40.398274, -81.968787),
    "43811": (40.247685, -81.929225),
    "43812": (40.300934, -81.864066),
    "43821": (40.106916, -81.999822),
    "43822": (40.108668, -82.103212),
    "43824": (40.364667, -81.755507),
    "43828": (40.351271, -81.873607),
    "43830": (40.063883, -82.099574),
    "43832": (40.33031, -81.571033),
    "43836": (40.200382, -81.720675),
    "43837": (40.306936, -81.467895),
    "43840": (40.404888, -81.602889),
    "43842": (40.143323, -81.995016),
    "43843": (40.340702, -82.155887),
    "43844": (40.3198, -81.958266),
    "43845": (40.27446, -81.82464),
    "43901": (40.260579, -80.789377),
    "43902": (39.894917, -80.980056),
    "43903": (40.486354, -80.84505),
    "43905": (40.107366999999996, -80.84441),
    "43906": (39.991864, -80.805716),
    "43907": (40.263163, -81.030687),
    "43908": (40.50022, -80.856529),
    "43909": (40.070102, -80.817605),
    "43910": (40.341244, -80.774815),
    "43912": (40.092799, -80.788948),
    "43913": (40.323767, -80.768624),
    "43914": (39.768729, -80.945431),
    "43915": (39.744008, -80.903818),
    "43916": (40.122351, -80.814948),
    "43917": (40.333811, -80.77266),
    "43920": (40.677372, -80.600629),
    "43925": (40.415106, -80.756661),
    "43926": (40.509225, -80.624051),
    "43927": (40.12245, -80.938031),
    "43928": (40.010896, -80.899286),
    "43930": (40.460885, -80.719014),
    "43931": (39.676317, -80.891369),
    "43932": (40.525504, -80.763971),
    "43933": (39.937228, -80.888014),
    "43934": (40.079975, -80.800316),
    "43935": (40.117231, -80.758087),
    "43937": (40.130167, -80.877264),
    "43938": (40.358475, -80.762054),
    "43939": (40.17699, -80.782734),
    "43940": (40.028448, -80.824454),
    "43941": (40.263948, -80.835767),
    "43942": (40.006175, -80.960745),
    "43943": (40.337357, -80.771562),
    "43944": (40.441964, -80.791768),
    "43945": (40.649533, -80.822333),
    "43946": (39.646018, -80.970678),
    "43947": (39.950713, -80.804364),
    "43948": (40.28006, -80.784927),
    "43950": (40.077792, -80.978797),
    "43951": (40.11098, -81.010169),
    "43952": (40.349541, -80.746759),
    "43953": (40.352418, -80.678099),
    "43961": (40.518479, -80.628515),
    "43962": (40.679456, -80.881583),
    "43963": (40.22676, -80.738107),
    "43964": (40.477049, -80.670057),
    "43966": (40.360979, -80.839519),
    "43967": (40.020007, -80.916901),
    "43968": (40.650362, -80.692008),
    "43970": (40.46947, -80.889206),
    "43971": (40.338699, -80.810216),
    "43972": (40.103155, -80.975639),
    "43973": (40.230697, -81.223669),
    "43974": (40.181476, -80.888159),
    "43976": (40.314449, -81.070506),
    "43977": (40.115634, -81.090224),
    "43981": (40.183933, -80.995856),
    "43983": (40.134188, -81.194538),
    "43984": (40.29649, -81.102502),
    "43985": (40.011338, -80.970135),
    "43986": (40.370274, -80.996826),
    "43988": (40.307421, -81.104831),
    "43989": (40.29649, -81.102502),
    "44001": (41.361746, -82.253828),
    "44003": (41.740136, -80.602278),
    "44004": (41.772583, -80.74349),
    "44005": (41.730146, -80.955313),
    "44010": (41.772459, -80.856463),
    "44011": (41.448492, -82.019866),
    "44012": (41.49674, -82.017527),
    "44017": (41.456905, -81.693019),
    "44021": (41.447117, -81.152938),
    "44022": (41.449353, -81.431436),
    "44023": (41.387203, -81.304222),
    "44024": (41.572432, -81.157142),
    "44026": (41.530351, -81.307472),
    "44028": (41.3056, -81.949111),
    "44030": (41.756356, -80.616195),
    "44032": (41.677076, -80.673288),
    "44033": (41.53335, -81.111175),
    "44035": (41.371396, -82.105112),
    "44036": (41.401494, -82.077068),
    "44039": (41.377776, -82.019365),
    "44040": (41.513251, -81.414597),
    "44041": (41.736396, -80.785627),
    "44044": (41.2745, -82.046168),
    "44045": (41.742693, -81.282125),
    "44046": (41.538433, -81.073366),
    "44047": (41.700536, -80.693315),
    "44048": (41.846175, -80.647299),
    "44049": (41.26635, -82.306383),
    "44050": (41.258201, -82.119671),
    "44052": (41.450991, -82.166534),
    "44053": (41.425292, -82.218185),
    "44054": (41.463541, -82.089769),
    "44055": (41.434492, -82.134021),
    "44056": (41.311288, -81.492511),
    "44057": (41.781467, -81.073247),
    "44060": (41.679291, -81.328779),
    "44061": (41.910676, -81.249027),
    "44062": (41.453242, -81.068303),
    "44064": (41.603114, -81.051767),
    "44065": (41.456099, -81.273831),
    "44067": (41.306454, -81.54079),
    "44068": (41.904594, -80.685034),
    "44070": (41.417347, -81.922461),
    "44072": (41.468754, -81.328211),
    "44073": (41.837043, -80.955545),
    "44074": (41.294649, -82.227628),
    "44076": (41.588584, -80.834349),
    "44077": (41.707918, -81.19903),
    "44080": (41.364495, -81.053411),
    "44081": (41.768495, -81.14626),
    "44082": (41.769302, -80.573251),
    "44084": (41.689765, -80.905118),
    "44085": (41.624828, -80.770777),
    "44086": (41.673116, -81.052453),
    "44087": (41.313304, -81.440435),
    "44088": (41.783323, -81.003385),
    "44089": (41.380755, -82.401637),
    "44090": (41.160846, -82.211778),
    "44092": (41.597299, -81.458638),
    "44093": (41.535263, -80.726693),
    "44094": (41.637997, -81.377383),
    "44095": (41.658653, -81.444531),
    "44096": (41.910676, -81.249027),
    "44097": (41.910676, -81.249027),
    "44099": (41.549414, -80.967673),
    "44101": (41.523401, -81.599648),
    "44102": (41.47225, -81.740305),
    "44103": (41.51805, -81.6425),
    "44104": (41.480502, -81.629599),
    "44105": (41.452502, -81.632912),
    "44106": (41.504751, -81.602799),
    "44107": (41.514849, -81.637249),
    "44108": (41.54345, -81.608297),
    "44109": (41.445963, -81.698483),
    "44110": (41.5641, -81.57156),
    "44111": (41.4595, -81.787006),
    "44112": (41.528632, -81.545576),
    "44113": (41.473782, -81.64297),
    "44114": (41.5145, -81.677302),
    "44115": (41.490351, -81.675602),
    "44116": (41.469497, -81.849209),
    "44117": (41.566834, -81.526142),
    "44118": (41.500752, -81.551645),
    "44119": (41.583849, -81.544409),
    "44120": (41.473102, -81.579746),
    "44121": (41.527651, -81.532344),
    "44122": (41.473248, -81.505389),
    "44123": (41.602548, -81.525842),
    "44124": (41.501001, -81.469427),
    "44125": (41.43349, -81.632298),
    "44126": (41.442927, -81.852959),
    "44127": (41.472551, -81.64919),
    "44128": (41.439352, -81.533893),
    "44129": (41.437052, -81.626348),
    "44130": (41.3826, -81.796406),
    "44131": (41.395652, -81.64231),
    "44132": (41.606049, -81.510858),
    "44133": (41.314603, -81.745102),
    "44134": (41.381701, -81.726551),
    "44135": (41.4797, -81.653799),
    "44136": (41.313268, -81.831656),
    "44137": (41.404703, -81.557493),
    "44138": (41.4656, -81.768304),
    "44139": (41.386753, -81.440322),
    "44140": (41.490967, -81.921513),
    "44141": (41.362052, -81.643247),
    "44142": (41.401, -81.832107),
    "44143": (41.55915, -81.48279),
    "44144": (41.438501, -81.739804),
    "44145": (41.445145, -81.921811),
    "44146": (41.389054, -81.536842),
    "44147": (41.314053, -81.673099),
    "44177": (41.685744, -81.672797),
    "44178": (41.685744, -81.672797),
    "44179": (41.685744, -81.672797),
    "44181": (41.685744, -81.672797),
    "44184": (41.685744, -81.672797),
    "44185": (41.685744, -81.672797),
    "44186": (41.685744, -81.672797),
    "44188": (41.685744, -81.672797),
    "44189": (41.685744, -81.672797),
    "44190": (41.685744, -81.672797),
    "44191": (41.685744, -81.672797),
    "44192": (41.685744, -81.672797),
    "44193": (41.685744, -81.672797),
    "44194": (41.685744, -81.672797),
    "44195": (41.685744, -81.672797),
    "44197": (41.685744, -81.672797),
    "44198": (41.685744, -81.672797),
    "44199": (41.685744, -81.672797),
    "44201": (41.040507, -81.194614),
    "44202": (41.311704, -81.292977),
    "44203": (41.019655, -81.621195),
    "44210": (41.128705, -81.53999),
    "44211": (41.169816, -81.312416),
    "44212": (41.206132, -81.82281),
    "44214": (40.927483, -81.996351),
    "44215": (41.065342, -81.901693),
    "44216": (40.948706, -81.571443),
    "44217": (40.945417, -81.912937),
    "44221": (41.143906, -81.473585),
    "44222": (41.128705, -81.53999),
    "44223": (41.170605, -81.526738),
    "44224": (41.172402, -81.450184),
    "44230": (40.958926, -81.770787),
    "44231": (41.291405, -81.081534),
    "44232": (40.932506, -81.461987),
    "44233": (41.23648, -81.736072),
    "44234": (41.310354, -81.1652),
    "44235": (41.038796, -82.113597),
    "44236": (41.244023, -81.476335),
    "44237": (41.128705, -81.53999),
    "44238": (41.128705, -81.53999),
    "44240": (41.205705, -81.313278),
    "44241": (41.241655, -81.340528),
    "44242": (41.170006, -81.196615),
    "44243": (41.147537, -81.341531),
    "44250": (41.022156, -81.427942),
    "44251": (41.028837, -81.928342),
    "44253": (41.162553, -82.020109),
    "44254": (41.044913, -81.992065),
    "44255": (41.282355, -81.229924),
    "44256": (41.109975, -81.855048),
    "44258": (41.127594, -81.841079),
    "44260": (41.026954, -81.404982),
    "44262": (41.138206, -81.431677),
    "44264": (41.230355, -81.549261),
    "44265": (41.010907, -81.297727),
    "44266": (41.163755, -81.172922),
    "44270": (40.949448, -81.862397),
    "44272": (41.078728, -81.173572),
    "44273": (41.044552, -81.960694),
    "44274": (41.09924, -81.734329),
    "44275": (41.081789, -82.052299),
    "44276": (40.936853, -81.830515),
    "44278": (41.096656, -81.428883),
    "44280": (41.233736, -81.917187),
    "44281": (41.071841, -81.751008),
    "44282": (41.132725, -81.929185),
    "44285": (41.159706, -81.070017),
    "44286": (41.235492, -81.621093),
    "44287": (40.925084, -82.070909),
    "44288": (41.239066, -81.096118),
    "44301": (41.012239, -81.507831),
    "44302": (41.090605, -81.539039),
    "44303": (41.104355, -81.535089),
    "44304": (41.083293, -81.506187),
    "44305": (41.078706, -81.458435),
    "44306": (41.041805, -81.479986),
    "44307": (41.073207, -81.543889),
    "44308": (41.082455, -81.517438),
    "44309": (41.096205, -81.512338),
    "44310": (41.105505, -81.498182),
    "44311": (41.064955, -81.522838),
    "44312": (41.018961, -81.443312),
    "44313": (41.16112, -81.576591),
    "44314": (41.041555, -81.559791),
    "44315": (41.027977, -81.463238),
    "44316": (41.067506, -81.484686),
    "44317": (41.052455, -81.529139),
    "44319": (40.978755, -81.524376),
    "44320": (41.07739, -81.579391),
    "44321": (41.100154, -81.644346),
    "44322": (41.049143, -81.581032),
    "44325": (41.076425, -81.51026),
    "44326": (41.172713, -81.472701),
    "44328": (41.075955, -81.520588),
    "44333": (41.155154, -81.631394),
    "44334": (41.128705, -81.53999),
    "44372": (41.128705, -81.53999),
    "44393": (41.128705, -81.53999),
    "44396": (41.128705, -81.53999),
    "44397": (41.071603, -81.525556),
    "44398": (41.128705, -81.53999),
    "44399": (41.128705, -81.53999),
    "44401": (41.034545, -80.928626),
    "44402": (41.376806, -80.866704),
    "44403": (41.238176, -80.573511),
    "44404": (41.329006, -80.559111),
    "44405": (41.077708, -80.591894),
    "44406": (41.008621, -80.822094),
    "44408": (40.857858, -80.730023),
    "44410": (41.354945, -80.778301),
    "44411": (41.037807, -81.061016),
    "44412": (41.102836, -81.049216),
    "44413": (40.837509, -80.646556),
    "44415": (40.76304, -80.704245),
    "44416": (41.017082, -80.802854),
    "44417": (41.416766, -80.667111),
    "44418": (41.307463, -80.602868),
    "44420": (41.17133, -80.795028),
    "44422": (41.017082, -80.802854),
    "44423": (40.760843, -80.887866),
    "44424": (41.309096, -80.584681),
    "44425": (41.236088, -80.736973),
    "44427": (40.729298, -80.942791),
    "44428": (41.327247, -80.601336),
    "44429": (41.097587, -80.973988),
    "44430": (41.24112, -80.886138),
    "44431": (40.837984, -80.749844),
    "44432": (40.743051, -80.745313),
    "44436": (41.056428, -80.549561),
    "44437": (41.151895, -80.751899),
    "44438": (41.263559, -80.54444),
    "44439": (41.459359, -80.942716),
    "44440": (41.168441, -80.78209),
    "44441": (40.763029, -80.572088),
    "44442": (40.965525, -80.54902),
    "44443": (40.928876, -80.587833),
    "44444": (41.197392, -80.952731),
    "44445": (40.843906, -80.614381),
    "44446": (41.186106, -80.742459),
    "44449": (40.967155, -81.021052),
    "44450": (41.443995, -80.818751),
    "44451": (41.075435, -80.86694),
    "44452": (40.951177, -80.662484),
    "44453": (41.32519, -80.533572),
    "44454": (40.929, -80.54758),
    "44455": (40.778137, -80.605674),
    "44460": (40.862743, -80.763459),
    "44470": (41.283579, -80.952784),
    "44471": (41.050058, -80.591298),
    "44473": (41.2656, -80.704184),
    "44481": (41.248912, -80.867431),
    "44482": (41.317424, -80.761269),
    "44483": (41.242576, -80.720029),
    "44484": (41.241952, -80.760752),
    "44485": (41.249104, -80.8439),
    "44486": (41.317424, -80.761269),
    "44487": (41.317424, -80.761269),
    "44488": (41.317424, -80.761269),
    "44490": (40.896699, -80.767064),
    "44491": (41.368863, -80.950285),
    "44492": (40.709282, -80.70141),
    "44493": (40.828584, -80.896714),
    "44501": (41.017082, -80.802854),
    "44502": (41.087352, -80.638546),
    "44503": (41.099258, -80.655146),
    "44504": (41.122607, -80.65525),
    "44505": (41.108057, -80.616596),
    "44506": (41.095258, -80.626295),
    "44507": (41.074413, -80.655046),
    "44509": (41.109533, -80.693098),
    "44510": (41.120407, -80.668447),
    "44511": (41.067608, -80.698121),
    "44512": (41.025158, -80.668667),
    "44513": (41.017082, -80.802854),
    "44514": (41.009287, -80.618344),
    "44515": (41.097937, -80.759813),
    "44555": (41.103858, -80.643646),
    "44598": (41.017082, -80.802854),
    "44599": (41.017082, -80.802854),
    "44601": (40.820292, -81.335275),
    "44606": (40.733099, -81.763389),
    "44607": (40.686028, -81.02187),
    "44608": (40.665824, -81.592696),
    "44609": (40.941802, -80.969891),
    "44610": (40.547385, -81.876602),
    "44611": (40.598522, -82.086715),
    "44612": (40.618002, -81.449534),
    "44613": (40.714208, -81.595746),
    "44614": (40.808555, -81.488163),
    "44615": (40.571861, -81.064859),
    "44617": (40.507088, -81.782872),
    "44618": (40.757197, -81.76092),
    "44619": (40.902146, -80.962843),
    "44620": (40.587709, -81.226442),
    "44621": (40.416656, -81.352297),
    "44622": (40.492563, -81.47911),
    "44624": (40.589023, -81.605824),
    "44625": (40.770542, -80.981107),
    "44626": (40.695388, -81.381386),
    "44627": (40.696545, -81.831036),
    "44628": (40.53833, -82.128771),
    "44629": (40.335928, -81.430921),
    "44630": (40.929507, -81.400134),
    "44631": (40.521924, -81.003619),
    "44632": (40.822158, -81.442635),
    "44633": (40.624618, -81.937501),
    "44634": (40.830059, -81.033298),
    "44636": (40.738387, -81.742811),
    "44637": (40.501625, -82.041222),
    "44638": (40.614615, -82.128493),
    "44639": (40.547688, -81.243498),
    "44640": (40.983558, -81.149664),
    "44641": (40.802406, -81.390056),
    "44643": (40.679881, -81.312133),
    "44644": (40.590393, -81.200395),
    "44645": (40.908987, -81.725668),
    "44646": (40.850643, -81.43535),
    "44647": (40.801057, -81.575795),
    "44648": (40.811809, -81.368284),
    "44650": (40.874558, -81.173873),
    "44651": (40.629918, -80.959514),
    "44652": (40.895057, -81.326195),
    "44653": (40.437981, -81.372875),
    "44654": (40.544738, -81.878772),
    "44656": (40.570507, -81.343581),
    "44657": (40.749759, -81.175266),
    "44659": (40.690225, -81.692787),
    "44660": (40.622284, -81.782532),
    "44661": (40.593256, -82.11676),
    "44662": (40.708566, -81.535805),
    "44663": (40.511632, -81.458777),
    "44665": (40.843563, -80.979435),
    "44666": (40.824937, -81.613396),
    "44667": (40.788723, -81.850598),
    "44669": (40.797908, -81.145349),
    "44670": (40.764741, -81.187875),
    "44671": (40.644174, -81.365254),
    "44672": (40.920492, -81.021736),
    "44675": (40.49571, -81.216271),
    "44676": (40.71617, -82.028231),
    "44677": (40.872545, -81.855266),
    "44678": (40.56488, -81.352352),
    "44679": (40.440407, -81.488516),
    "44680": (40.598698, -81.549884),
    "44681": (40.473446, -81.553581),
    "44682": (40.395881, -81.406883),
    "44683": (40.451788, -81.356471),
    "44685": (40.969521, -81.458185),
    "44687": (40.551575, -81.728416),
    "44688": (40.692071, -81.274199),
    "44689": (40.657981, -81.638348),
    "44690": (40.616535999999996, -81.681707),
    "44691": (40.830699, -81.895377),
    "44693": (40.294686, -81.183933),
    "44695": (40.398846, -81.175864),
    "44697": (40.61829, -81.414245),
    "44699": (40.277046, -81.262892),
    "44701": (40.782408, -81.371185),
    "44702": (40.800108, -81.379535),
    "44703": (40.808808, -81.379886),
    "44704": (40.799158, -81.345934),
    "44705": (40.830092, -81.330583),
    "44706": (40.741553, -81.430161),
    "44707": (40.759808, -81.350034),
    "44708": (40.825707, -81.436938),
    "44709": (40.80488, -81.387905),
    "44710": (40.789508, -81.426988),
    "44711": (40.811809, -81.368284),
    "44712": (40.811809, -81.368284),
    "44714": (40.834457, -81.360834),
    "44718": (40.846532, -81.440791),
    "44720": (40.895607, -81.433036),
    "44721": (40.891608, -81.318381),
    "44730": (40.770507, -81.26598),
    "44735": (40.811809, -81.368284),
    "44750": (40.784646, -81.418943),
    "44760": (40.853958, -81.42778),
    "44767": (40.895721, -81.424552),
    "44798": (40.811809, -81.368284),
    "44799": (40.811809, -81.368284),
    "44801": (41.090712, -83.365404),
    "44802": (41.054782, -83.391792),
    "44803": (41.037511, -82.910552),
    "44804": (41.115906, -83.535416),
    "44805": (40.826965, -82.296131),
    "44807": (41.077343, -82.903207),
    "44809": (41.132816, -83.285361),
    "44811": (41.216488, -82.793687),
    "44813": (40.646184, -82.481491),
    "44814": (41.338364, -82.459915),
    "44815": (41.246929, -83.239806),
    "44816": (41.334898, -82.355035),
    "44817": (41.217112, -83.535075),
    "44818": (41.046546, -82.968764),
    "44820": (40.832674, -82.973876),
    "44822": (40.587193, -82.406952),
    "44824": (41.366624, -82.785818),
    "44825": (40.965022, -82.936698),
    "44826": (41.166039, -82.489),
    "44827": (40.824607, -82.909054),
    "44828": (41.23707, -82.859705),
    "44830": (41.159551, -83.152472),
    "44833": (40.746972, -82.823),
    "44836": (41.186418, -83.042327),
    "44837": (41.119451, -82.564392),
    "44838": (40.768006, -82.249991),
    "44839": (41.375658, -82.538619),
    "44840": (40.78933, -82.206323),
    "44841": (41.228968, -83.310194),
    "44842": (40.656997, -82.236734),
    "44843": (40.653256, -82.454979),
    "44844": (40.958503, -83.247403),
    "44845": (41.024204, -83.109783),
    "44846": (41.320775, -82.610479),
    "44847": (41.192976, -82.696315),
    "44848": (40.920617, -82.281695),
    "44849": (40.837199, -83.150116),
    "44850": (41.034952, -82.676973),
    "44851": (41.124479, -82.437501),
    "44853": (41.061468, -83.298986),
    "44854": (40.942627, -82.841736),
    "44855": (41.109479, -82.58654),
    "44856": (40.793372, -82.856557),
    "44857": (41.204562, -82.573222),
    "44859": (41.011373, -82.329107),
    "44860": (40.835677, -83.102857),
    "44861": (41.235206, -83.15236),
    "44862": (40.772874, -82.532057),
    "44864": (40.674683, -82.308743),
    "44865": (40.849371, -82.57178),
    "44866": (40.922051, -82.192733),
    "44867": (41.146881, -82.970007),
    "44870": (41.399129, -82.724417),
    "44871": (41.49181, -82.647824),
    "44874": (40.964517, -82.388476),
    "44875": (40.848784, -82.571998),
    "44878": (40.926203, -82.528622),
    "44880": (41.028371, -82.242915),
    "44881": (40.868645, -82.875027),
    "44882": (40.94245, -83.192192),
    "44883": (41.12453, -83.144773),
    "44887": (40.914732, -82.806099),
    "44888": (41.141541, -82.588928),
    "44889": (41.211052, -82.417989),
    "44890": (41.120678, -82.697369),
    "44901": (40.850833, -82.511369),
    "44902": (40.762711, -82.51189),
    "44903": (40.80142, -82.538356),
    "44904": (40.682416, -82.528564),
    "44905": (40.777896, -82.461347),
    "44906": (40.756992, -82.588394),
    "44907": (40.726256, -82.52284),
    "44999": (40.772874, -82.532057),
    "45001": (39.135158, -84.709797),
    "45002": (39.191546, -84.742376),
    "45003": (39.547254, -84.599698),
    "45004": (39.440956, -84.575746),
    "45005": (39.526049, -84.186961),
    "45011": (39.425137, -84.472925),
    "45012": (39.440956, -84.575746),
    "45013": (39.436146, -84.618498),
    "45014": (39.387357, -84.499743),
    "45015": (39.349361, -84.537563),
    "45018": (39.440956, -84.575746),
    "45020": (39.440956, -84.575746),
    "45023": (39.440956, -84.575746),
    "45025": (39.440956, -84.575746),
    "45026": (39.440956, -84.575746),
    "45030": (39.244275, -84.736254),
    "45032": (39.501283, -84.006729),
    "45033": (39.177259, -84.762731),
    "45034": (39.357963, -84.247288),
    "45036": (39.429284, -84.173507),
    "45039": (39.316973, -84.243763),
    "45040": (39.397999, -84.180906),
    "45041": (39.176088, -84.708517),
    "45042": (39.543446, -84.442394),
    "45043": (39.440956, -84.575746),
    "45044": (39.418175, -84.424549),
    "45050": (39.448492, -84.374549),
    "45051": (39.09646, -84.643096),
    "45052": (39.149862, -84.750268),
    "45053": (39.354854, -84.776769),
    "45054": (39.458117, -84.079543),
    "45055": (39.451806, -84.515245),
    "45056": (39.479227, -84.68575),
    "45061": (39.31235, -84.64828),
    "45062": (39.478956, -84.551196),
    "45063": (39.325805, -84.712099),
    "45064": (39.545634, -84.6275),
    "45065": (39.356027, -84.207204),
    "45066": (39.465762, -84.14633),
    "45067": (39.48332, -84.489895),
    "45068": (39.51812, -84.0806),
    "45069": (39.336058, -84.40536),
    "45070": (39.594686, -84.54682),
    "45071": (39.440956, -84.575746),
    "45073": (39.440956, -84.575746),
    "45099": (39.440956, -84.575746),
    "45101": (38.693525, -83.740804),
    "45102": (39.014823, -84.205859),
    "45103": (39.025905, -84.157048),
    "45105": (38.749779, -83.612574),
    "45106": (38.922008, -84.109327),
    "45107": (39.40252, -83.894217),
    "45110": (39.074262, -83.848414),
    "45111": (39.19977, -84.303075),
    "45112": (38.792553, -84.138221),
    "45113": (39.398125, -83.932644),
    "45114": (39.356846, -83.857237),
    "45115": (38.823707, -83.699476),
    "45118": (39.1748, -83.935821),
    "45119": (38.880632, -84.00874),
    "45120": (38.820683, -84.126923),
    "45121": (38.981336, -83.903529),
    "45122": (39.21292, -84.10444),
    "45123": (39.288414, -83.583223),
    "45130": (38.902187, -83.982347),
    "45131": (38.790301, -83.966624),
    "45132": (39.352669, -83.602424),
    "45133": (39.169164, -83.59454),
    "45135": (39.270862, -83.595228),
    "45138": (39.416747, -83.647583),
    "45140": (39.223187, -84.245103),
    "45142": (39.200697, -83.777545),
    "45144": (38.698772, -83.574357),
    "45145": (39.145698, -84.007023),
    "45146": (39.313795999999996, -83.796942),
    "45147": (39.213739, -84.300232),
    "45148": (39.291345, -83.885714),
    "45150": (39.016349, -84.197778),
    "45152": (39.342034, -84.106916),
    "45153": (38.867485, -84.192222),
    "45154": (39.057857, -83.913915),
    "45155": (39.038774, -83.750522),
    "45156": (38.815645, -84.204877),
    "45157": (38.9124, -84.206745),
    "45158": (39.18779, -84.078313),
    "45159": (39.349254, -83.702933),
    "45160": (39.123187, -84.135023),
    "45162": (39.294913, -84.092498),
    "45164": (39.551413, -83.788084),
    "45165": (39.198813, -83.607858),
    "45166": (39.480543, -83.677197),
    "45167": (38.758164, -83.822146),
    "45168": (38.84798, -83.767404),
    "45169": (39.438429, -83.680807),
    "45171": (39.005468, -83.799563),
    "45172": (39.07382, -83.385303),
    "45174": (39.153831, -84.329171),
    "45176": (39.013595, -84.050406),
    "45177": (39.444985, -83.824424),
    "45201": (39.166759, -84.53822),
    "45202": (39.11026, -84.486142),
    "45203": (39.10886, -84.531993),
    "45204": (39.10016, -84.589645),
    "45205": (39.11161, -84.577994),
    "45206": (39.12616, -84.482642),
    "45207": (39.14311, -84.468842),
    "45208": (39.13786, -84.434891),
    "45209": (39.15471, -84.450692),
    "45210": (39.11451, -84.511093),
    "45211": (39.158409, -84.602646),
    "45212": (39.187659, -84.454342),
    "45213": (39.180214, -84.420441),
    "45214": (39.12186, -84.550594),
    "45215": (39.214259, -84.464093),
    "45216": (39.200309, -84.485893),
    "45217": (39.166109, -84.495893),
    "45218": (39.2774, -84.520544),
    "45219": (39.12851, -84.515191),
    "45220": (39.145559, -84.520093),
    "45221": (39.166759, -84.53822),
    "45222": (39.166759, -84.53822),
    "45223": (39.160002, -84.593605),
    "45224": (39.199058, -84.525094),
    "45225": (39.144309, -84.548944),
    "45226": (39.110111, -84.43088),
    "45227": (39.15926, -84.37284),
    "45228": (39.070561, -84.417891),
    "45229": (39.153559, -84.490043),
    "45230": (39.071262, -84.37584),
    "45231": (39.259325, -84.532395),
    "45232": (39.181109, -84.51166),
    "45233": (39.110994, -84.659396),
    "45234": (39.166759, -84.53822),
    "45235": (39.166759, -84.53822),
    "45236": (39.210001, -84.395046),
    "45237": (39.190690000000004, -84.447342),
    "45238": (39.109209, -84.610845),
    "45239": (39.201707999999996, -84.621296),
    "45240": (39.284357, -84.439066),
    "45241": (39.263837, -84.409191),
    "45242": (39.244659, -84.345489),
    "45243": (39.18481, -84.344758),
    "45244": (39.119102, -84.350974),
    "45245": (39.068815, -84.280171),
    "45246": (39.283858, -84.474394),
    "45247": (39.220761, -84.641752),
    "45248": (39.165158, -84.662509),
    "45249": (39.269226, -84.330686),
    "45250": (39.166759, -84.53822),
    "45251": (39.267157, -84.599285),
    "45252": (39.272557, -84.632143),
    "45253": (39.166759, -84.53822),
    "45254": (39.166759, -84.53822),
    "45255": (39.058412, -84.339639),
    "45258": (39.166759, -84.53822),
    "45262": (39.166759, -84.53822),
    "45263": (39.166759, -84.53822),
    "45264": (39.166759, -84.53822),
    "45267": (39.166759, -84.53822),
    "45268": (39.166759, -84.53822),
    "45269": (39.166759, -84.53822),
    "45270": (39.166759, -84.53822),
    "45271": (39.166759, -84.53822),
    "45273": (39.166759, -84.53822),
    "45274": (39.166759, -84.53822),
    "45275": (38.946921, -83.862877),
    "45277": (39.166759, -84.53822),
    "45296": (39.166759, -84.53822),
    "45298": (39.166759, -84.53822),
    "45299": (39.262158, -84.509268),
    "45301": (39.706459, -84.016233),
    "45302": (40.407239, -84.203271),
    "45303": (40.214675, -84.653188),
    "45304": (40.126915, -84.539928),
    "45305": (39.632829, -84.049985),
    "45306": (40.439778, -84.189245),
    "45307": (39.575597, -83.715323),
    "45308": (40.115737, -84.279352),
    "45309": (39.836157, -84.330392),
    "45310": (40.354106, -84.643532),
    "45311": (39.640948, -84.647001),
    "45312": (40.066567, -84.08161),
    "45314": (39.747459, -83.759973),
    "45315": (39.854454, -84.340345),
    "45316": (39.795971, -83.819766),
    "45317": (40.137029, -84.046873),
    "45318": (40.124386, -84.281167),
    "45319": (39.918936, -83.944909),
    "45320": (39.77485, -84.674889),
    "45321": (39.872177, -84.681067),
    "45322": (39.877005, -84.331945),
    "45323": (39.857967, -83.933431),
    "45324": (39.728549, -84.014834),
    "45325": (39.781301, -84.41397),
    "45326": (40.144491, -84.100988),
    "45327": (39.747497, -84.396912),
    "45328": (40.114729, -84.493439),
    "45330": (39.641558, -84.527613),
    "45331": (40.156478, -84.649068),
    "45332": (39.993964, -84.783714),
    "45333": (40.248489, -84.345612),
    "45334": (40.434921, -84.058495),
    "45335": (39.674084, -83.766709),
    "45336": (40.441325, -84.262602),
    "45337": (39.985177, -84.399364),
    "45338": (39.780916, -84.567331),
    "45339": (40.005764, -84.351781),
    "45340": (40.364305, -84.056464),
    "45341": (39.878918, -84.021827),
    "45342": (39.641658, -84.27464),
    "45343": (39.750471, -84.268593),
    "45344": (39.959249, -83.986855),
    "45345": (39.800056, -84.327),
    "45346": (39.982103, -84.705736),
    "45347": (39.783378, -84.668892),
    "45348": (40.316833, -84.633911),
    "45349": (39.989309, -83.938933),
    "45350": (40.135426, -84.619129),
    "45351": (40.340616, -84.496342),
    "45352": (40.050323, -84.745706),
    "45353": (40.29522, -84.032272),
    "45354": (39.905385, -84.402785),
    "45356": (40.123618, -84.228811),
    "45358": (39.987043, -84.486582),
    "45359": (40.050483, -84.348699),
    "45360": (40.330713, -84.092589),
    "45361": (39.963492, -84.414484),
    "45362": (40.287621, -84.637078),
    "45363": (40.263253, -84.263227),
    "45365": (40.293558, -84.209198),
    "45367": (40.333611, -84.218308),
    "45368": (39.854349, -83.66528),
    "45369": (39.957723, -83.614481),
    "45370": (39.608285, -84.025972),
    "45371": (39.941967, -84.16626),
    "45372": (40.013871, -83.83325),
    "45373": (40.062621, -84.226398),
    "45374": (40.03997, -84.229799),
    "45377": (39.889006, -84.242243),
    "45378": (39.897035, -84.499044),
    "45380": (40.25304, -84.523891),
    "45381": (39.750097, -84.537597),
    "45382": (39.88133, -84.621617),
    "45383": (39.98791, -84.350107),
    "45384": (39.712811, -83.878088),
    "45385": (39.684731, -83.90813),
    "45387": (39.760531, -83.8836),
    "45388": (40.321853, -84.484466),
    "45389": (40.0564, -84.025444),
    "45390": (40.211787, -84.758818),
    "45401": (39.750471, -84.268593),
    "45402": (39.756658, -84.181639),
    "45403": (39.764658, -84.150738),
    "45404": (39.794958, -84.163589),
    "45405": (39.789857, -84.217391),
    "45406": (39.782457, -84.239391),
    "45407": (39.758658, -84.226041),
    "45408": (39.730258, -84.219846),
    "45409": (39.723809, -84.185439),
    "45410": (39.748008, -84.156938),
    "45412": (39.750471, -84.268593),
    "45413": (39.750471, -84.268593),
    "45414": (39.805957, -84.199737),
    "45415": (39.834756, -84.252292),
    "45416": (39.801057, -84.257792),
    "45417": (39.75344, -84.245841),
    "45418": (39.707057, -84.276891),
    "45419": (39.681909, -84.166388),
    "45420": (39.717059, -84.134172),
    "45422": (39.758058, -84.20009),
    "45423": (39.750471, -84.268593),
    "45424": (39.835257, -84.112288),
    "45426": (39.798187, -84.321119),
    "45427": (39.755506, -84.304893),
    "45428": (39.746656, -84.259292),
    "45429": (39.684059, -84.163337),
    "45430": (39.709159, -84.104836),
    "45431": (39.757377, -84.056934),
    "45432": (39.732309, -84.160422),
    "45433": (39.798503, -84.052053),
    "45434": (39.750471, -84.268593),
    "45435": (39.750471, -84.268593),
    "45437": (39.750471, -84.268593),
    "45439": (39.749308, -84.19954),
    "45440": (39.675548, -84.121086),
    "45441": (39.750471, -84.268593),
    "45448": (39.750471, -84.268593),
    "45449": (39.665109, -84.24009),
    "45454": (39.750471, -84.268593),
    "45458": (39.606209, -84.169519),
    "45459": (39.646371, -84.171733),
    "45463": (39.750471, -84.268593),
    "45469": (39.740509, -84.178939),
    "45470": (39.750471, -84.268593),
    "45475": (39.750471, -84.268593),
    "45479": (39.734409, -84.194389),
    "45481": (39.750471, -84.268593),
    "45482": (39.750471, -84.268593),
    "45490": (39.750471, -84.268593),
    "45501": (39.927059, -83.813228),
    "45502": (39.917208, -83.854642),
    "45503": (39.963784, -83.77139),
    "45504": (39.950457, -83.890862),
    "45505": (39.906009, -83.7482),
    "45506": (39.883209, -83.86983),
    "45601": (39.337384, -82.991332),
    "45612": (39.244298, -83.219712),
    "45613": (39.040682, -82.887103),
    "45614": (38.92307, -82.276201),
    "45616": (38.756374, -83.340308),
    "45617": (39.280388, -83.158991),
    "45618": (38.892198, -83.621787),
    "45619": (38.482955, -82.450548),
    "45620": (38.798525, -82.189958),
    "45621": (39.110614, -82.613028),
    "45622": (39.354339, -82.503012),
    "45623": (38.796783, -82.271583),
    "45624": (39.16378, -83.342941),
    "45628": (39.387165, -83.182591),
    "45629": (38.650439, -82.802128),
    "45630": (38.793335, -82.96046),
    "45631": (38.793762, -82.2692),
    "45633": (39.46557, -82.747853),
    "45634": (39.178317, -82.503194),
    "45636": (38.592446, -82.828817),
    "45638": (38.544457, -82.596777),
    "45640": (39.03738, -82.628954),
    "45642": (39.052267, -83.050031),
    "45643": (38.86833, -82.256185),
    "45644": (39.424824, -82.862234),
    "45645": (38.562503, -82.545723),
    "45646": (39.081031, -83.312422),
    "45647": (39.292098, -82.795487),
    "45648": (38.888422, -82.98132),
    "45650": (38.73906, -83.42617),
    "45651": (39.280013, -82.47532),
    "45652": (38.852654, -83.135398),
    "45653": (38.889049, -82.911143),
    "45654": (39.332256, -82.379663),
    "45656": (38.976464, -82.603687),
    "45657": (38.875128, -83.159778),
    "45658": (38.765791, -82.390542),
    "45659": (38.674554, -82.614563),
    "45660": (38.858792, -83.461114),
    "45661": (39.043707, -83.12101),
    "45662": (38.793214, -82.930576),
    "45663": (38.749539, -83.133477),
    "45669": (38.49585, -82.364902),
    "45671": (38.957722, -83.236465),
    "45672": (39.230553, -82.66956),
    "45673": (39.203167, -82.854167),
    "45674": (38.881447, -82.378213),
    "45675": (38.536685, -82.532715),
    "45677": (38.794115, -82.755455),
    "45678": (38.598567, -82.385511),
    "45679": (38.957941, -83.535617),
    "45680": (38.465171, -82.501206),
    "45681": (39.328523, -83.242873),
    "45682": (38.819687, -82.727978),
    "45683": (38.955485, -82.858402),
    "45684": (38.783492, -83.102804),
    "45685": (38.870525, -82.406298),
    "45686": (38.961601, -82.345709),
    "45687": (39.072829, -83.085764),
    "45688": (38.719009, -82.535141),
    "45690": (39.072309, -83.024014),
    "45692": (39.116467, -82.553489),
    "45693": (38.82346, -83.504048),
    "45694": (38.745832, -82.847351),
    "45695": (39.141589, -82.36824),
    "45696": (38.590602, -82.456062),
    "45697": (38.9163, -83.580733),
    "45698": (39.283031, -82.397708),
    "45699": (38.793335, -82.96046),
    "45701": (39.339279, -82.013803),
    "45710": (39.240816, -82.177096),
    "45711": (39.410743, -81.936397),
    "45712": (39.386825, -81.395219),
    "45713": (39.430738, -81.44512),
    "45714": (39.449988, -81.559698),
    "45715": (39.541791, -81.606295),
    "45716": (39.452247, -82.179423),
    "45717": (39.368235, -82.010132),
    "45719": (39.400154, -82.130241),
    "45720": (39.085629, -81.921443),
    "45721": (39.430738, -81.44512),
    "45723": (39.246862, -81.830623),
    "45724": (39.430738, -81.44512),
    "45727": (39.67387, -81.485687),
    "45729": (39.430738, -81.44512),
    "45732": (39.475277, -82.063319),
    "45734": (39.663015, -81.182232),
    "45735": (39.249339, -81.922005),
    "45739": (39.197888, -81.744573),
    "45740": (39.461905, -82.073188),
    "45741": (39.069673, -82.24991),
    "45742": (39.274635, -81.655976),
    "45743": (39.071167, -81.839685),
    "45744": (39.538823, -81.47884),
    "45745": (39.561107, -81.39676),
    "45746": (39.580501, -81.479272),
    "45750": (39.413446, -81.351051),
    "45760": (39.069059, -82.021994),
    "45761": (39.379936, -82.088793),
    "45764": (39.357211, -82.045466),
    "45766": (39.307332, -82.167867),
    "45767": (39.523303, -81.064116),
    "45768": (39.393315, -81.225093),
    "45769": (39.07866, -82.069422),
    "45770": (38.981015, -81.812092),
    "45771": (38.984835, -81.892503),
    "45772": (39.13447, -81.835405),
    "45773": (39.430738, -81.44512),
    "45775": (39.090877, -82.148554),
    "45776": (39.214673, -82.018739),
    "45777": (39.368235, -82.010132),
    "45778": (39.362514, -81.906878),
    "45779": (39.003291, -81.966122),
    "45780": (39.35076, -81.968751),
    "45781": (39.368235, -82.010132),
    "45782": (39.484517, -82.080528),
    "45783": (39.168349, -81.842313),
    "45784": (39.367877, -81.665232),
    "45786": (39.538788, -81.639888),
    "45787": (39.430738, -81.44512),
    "45788": (39.430738, -81.44512),
    "45789": (39.544391, -81.245804),
    "45801": (40.772147, -84.0471),
    "45802": (40.781785, -84.138566),
    "45804": (40.694996, -84.063491),
    "45805": (40.733043, -84.169749),
    "45806": (40.589876, -84.12786),
    "45807": (40.795463, -84.138298),
    "45808": (40.831419, -83.975831),
    "45809": (40.847946, -84.183152),
    "45810": (40.676042, -83.700633),
    "45812": (40.679192, -83.795649),
    "45813": (41.186851, -84.727141),
    "45814": (40.908204, -83.617612),
    "45815": (41.153855, -83.941281),
    "45816": (41.003087, -83.793147),
    "45817": (40.78635, -83.928268),
    "45819": (40.62408, -84.260275),
    "45820": (40.830388, -84.085154),
    "45821": (41.223404, -84.571519),
    "45822": (40.556645, -84.628714),
    "45826": (40.428177, -84.633484),
    "45827": (41.003391, -84.298718),
    "45828": (40.476443, -84.68752),
    "45830": (40.97793, -84.15053),
    "45831": (41.104335, -84.236754),
    "45832": (40.896997, -84.716607),
    "45833": (40.794444, -84.311596),
    "45835": (40.761389, -83.702404),
    "45836": (40.782629, -83.652433),
    "45837": (41.046252, -84.319494),
    "45838": (40.735491, -84.485028),
    "45839": (40.993263, -83.650714),
    "45840": (41.015219, -83.664786),
    "45841": (40.885048, -83.722963),
    "45843": (40.755387, -83.671142),
    "45844": (40.922538, -84.295652),
    "45845": (40.364003, -84.23261),
    "45846": (40.452405, -84.7169),
    "45848": (41.096421, -84.112031),
    "45849": (41.032277, -84.479422),
    "45850": (40.739067, -83.941613),
    "45851": (41.03321, -84.60076),
    "45853": (40.979612, -84.219208),
    "45854": (40.758211, -83.949934),
    "45855": (41.07712, -84.583005),
    "45856": (41.050948, -84.11025),
    "45858": (41.09817, -83.784671),
    "45859": (40.689897, -83.811072),
    "45860": (40.394413, -84.535296),
    "45861": (41.08119, -84.428684),
    "45862": (40.575306, -84.547735),
    "45863": (40.899321, -84.454113),
    "45864": (41.103776, -84.131541),
    "45865": (40.410299, -84.39708),
    "45866": (40.489028, -84.549391),
    "45867": (40.904671, -83.528932),
    "45868": (40.970761, -83.842293),
    "45869": (40.504687, -84.2145),
    "45870": (40.549772, -83.950093),
    "45871": (40.496141, -84.282659),
    "45872": (41.204236, -83.6837),
    "45873": (41.121548, -84.534212),
    "45874": (40.821778, -84.658335),
    "45875": (41.019657, -84.111533),
    "45876": (41.027573, -84.238754),
    "45877": (40.956609, -83.937984),
    "45879": (41.121205, -84.532406),
    "45880": (41.062763, -84.716982),
    "45881": (40.941562, -83.770206),
    "45882": (40.669681, -84.657861),
    "45883": (40.408584, -84.635417),
    "45884": (40.520289, -84.16797),
    "45885": (40.584975, -84.376744),
    "45886": (40.975363, -84.603141),
    "45887": (40.732147, -84.159688),
    "45888": (40.602259, -84.086022),
    "45889": (41.142264, -83.628337),
    "45890": (40.935704, -83.502731),
    "45891": (40.873247, -84.594525),
    "45893": (40.882077, -84.148028),
    "45894": (40.771925, -84.47458),
    "45895": (40.582252, -84.152138),
    "45896": (40.589899, -83.953648),
    "45897": (40.834004, -83.651785),
    "45898": (40.775148, -84.745809),
    "45899": (40.794002, -84.785735),
    "45944": (39.166759, -84.53822),
    "45999": (39.166759, -84.53822),
    "46001": (40.213154, -85.680698),
    "46011": (40.141033, -85.766164),
    "46012": (40.165726, -85.633225),
    "46013": (40.05668, -85.674976),
    "46014": (40.161733, -85.719659),
    "46015": (40.093792, -85.657825),
    "46016": (40.144894, -85.742377),
    "46017": (40.100275, -85.710226),
    "46018": (40.161733, -85.719659),
    "46030": (40.167756, -86.045789),
    "46031": (40.174289, -86.018909),
    "46032": (40.071102, -86.117215),
    "46033": (39.974404, -86.082936),
    "46034": (40.154903, -86.038337),
    "46035": (40.211041, -86.64787),
    "46036": (40.27843, -85.719657),
    "46038": (39.967406, -85.964894),
    "46039": (40.373825, -86.309246),
    "46040": (39.894912, -85.792762),
    "46041": (40.304355, -86.468915),
    "46044": (40.213173, -85.786049),
    "46045": (40.289836, -86.149423),
    "46046": (40.304473, -86.469044),
    "46047": (40.284101, -85.945505),
    "46048": (39.95729, -85.798078),
    "46049": (40.307545, -86.146767),
    "46050": (40.259929, -86.45201),
    "46051": (40.05956, -85.834429),
    "46052": (40.050302, -86.490381),
    "46055": (39.878113, -85.897957),
    "46056": (39.985793, -85.617925),
    "46057": (40.306276, -86.490945),
    "46058": (40.359433, -86.628659),
    "46060": (40.073328, -85.999521),
    "46061": (40.072462, -86.052285),
    "46063": (40.271524, -85.72808),
    "46064": (40.107304, -85.757678),
    "46065": (40.360973, -86.603449),
    "46067": (40.304473, -86.469044),
    "46068": (40.354088, -86.118782),
    "46069": (40.129468, -86.185273),
    "46070": (40.314012, -85.666794),
    "46071": (40.068631, -86.58186),
    "46072": (40.311418, -86.063107),
    "46074": (40.097028, -86.125716),
    "46075": (40.022608, -86.346179),
    "46076": (40.348927, -85.937642),
    "46077": (39.997457, -86.298135),
    "46082": (40.072462, -86.052285),
    "46102": (39.995599, -86.619774),
    "46103": (39.736926, -86.483474),
    "46104": (39.663342, -85.590869),
    "46105": (39.752428, -86.812416),
    "46106": (39.489652, -86.102271),
    "46107": (39.713893, -86.093293),
    "46110": (39.566614, -85.91406),
    "46111": (39.539599, -86.370057),
    "46112": (39.807038, -86.470429),
    "46113": (39.6533, -86.30309),
    "46114": (39.762448, -86.510386),
    "46115": (39.735455, -85.552199),
    "46117": (39.838824, -85.625798),
    "46118": (39.711088, -86.495365),
    "46120": (39.658826, -86.782523),
    "46121": (39.688598, -86.594745),
    "46122": (39.766794, -86.530319),
    "46123": (39.721434, -86.488881),
    "46124": (39.430795, -86.099838),
    "46125": (39.506641, -86.641773),
    "46126": (39.617344, -85.87593),
    "46127": (39.729032, -85.333088),
    "46128": (39.652271, -86.73796),
    "46129": (39.821516, -85.765169),
    "46130": (39.580663, -85.809775),
    "46131": (39.469172, -86.068718),
    "46133": (39.58598, -85.276882),
    "46135": (39.699485, -86.857172),
    "46140": (39.821787, -85.775403),
    "46142": (39.491246, -86.100454),
    "46143": (39.50708, -86.10149),
    "46144": (39.66172, -85.647634),
    "46146": (39.619923, -85.46554),
    "46147": (39.988674, -86.563204),
    "46148": (39.836197, -85.474444),
    "46149": (39.871667, -86.560328),
    "46150": (39.546509, -85.583666),
    "46151": (39.477625, -86.466792),
    "46154": (39.856763, -85.768357),
    "46155": (39.743769, -85.431184),
    "46156": (39.488994, -85.486278),
    "46157": (39.555178, -86.531957),
    "46158": (39.50942, -86.437089),
    "46160": (39.244566, -86.267561),
    "46161": (39.65521, -85.71264),
    "46162": (39.560511, -85.96563),
    "46163": (39.739927, -85.885962),
    "46164": (39.391505, -86.109534),
    "46165": (39.839162, -86.640794),
    "46166": (39.427654, -86.533865),
    "46167": (39.784191, -86.475318),
    "46168": (39.729892, -86.423412),
    "46170": (39.668441, -86.828402),
    "46171": (39.543141, -86.955955),
    "46172": (39.821381, -86.814317),
    "46173": (39.612836, -85.439133),
    "46175": (39.822491, -86.973306),
    "46176": (39.511568, -85.791993),
    "46180": (39.632997, -86.60767799999999),
    "46181": (39.416652, -86.103674),
    "46182": (39.515, -85.781538),
    "46183": (39.648251, -86.28509),
    "46184": (39.50607, -86.08434),
    "46186": (39.895139, -85.643767),
    "46201": (39.775092, -86.13216),
    "46202": (39.762392, -86.143736),
    "46203": (39.743493, -86.113535),
    "46204": (39.772692, -86.158038),
    "46205": (39.822641, -86.129886),
    "46206": (39.761293, -86.161336),
    "46207": (39.767293, -86.160616),
    "46208": (39.832741, -86.190186),
    "46209": (39.779492, -86.132837),
    "46211": (39.779492, -86.132837),
    "46214": (39.792379, -86.287465),
    "46216": (39.864689, -86.013632),
    "46217": (39.678245, -86.197637),
    "46218": (39.806991, -86.100535),
    "46219": (39.782841, -86.081084),
    "46220": (39.86904, -86.10895),
    "46221": (39.764258, -86.130655),
    "46222": (39.783642, -86.207687),
    "46223": (39.779492, -86.132837),
    "46224": (39.794042, -86.27074),
    "46225": (39.743793, -86.167886),
    "46226": (39.832577, -86.083634),
    "46227": (39.678945, -86.130154),
    "46228": (39.846191, -86.195081),
    "46229": (39.798941, -86.035533),
    "46230": (39.779492, -86.132837),
    "46231": (39.703844, -86.30294),
    "46234": (39.808793, -86.316288),
    "46235": (39.84709, -85.974081),
    "46236": (39.868939, -85.976532),
    "46237": (39.742726, -86.171117),
    "46239": (39.726493, -86.000482),
    "46240": (39.877991, -86.200688),
    "46241": (39.709624, -86.261389),
    "46242": (39.779492, -86.132837),
    "46244": (39.779492, -86.132837),
    "46247": (39.779492, -86.132837),
    "46249": (39.858989, -86.006082),
    "46250": (39.904838, -86.067263),
    "46251": (39.779492, -86.132837),
    "46253": (39.779492, -86.132837),
    "46254": (39.81594, -86.22681),
    "46255": (39.779492, -86.132837),
    "46256": (39.897708, -86.009447),
    "46259": (39.667045, -85.998092),
    "46260": (39.89384, -86.137988),
    "46266": (39.779492, -86.132837),
    "46268": (39.868173, -86.21231),
    "46274": (39.779492, -86.132837),
    "46275": (39.779492, -86.132837),
    "46277": (39.779492, -86.132837),
    "46278": (39.872591, -86.276791),
    "46280": (39.9416, -86.115707),
    "46282": (39.779492, -86.132837),
    "46283": (39.779492, -86.132837),
    "46285": (39.779492, -86.132837),
    "46290": (39.93731, -86.199445),
    "46291": (39.779492, -86.132837),
    "46295": (39.779492, -86.132837),
    "46298": (39.779492, -86.132837),
    "46301": (41.683796, -86.975178),
    "46302": (41.354186, -87.130431),
    "46303": (41.311861, -87.41665),
    "46304": (41.498946, -87.087021),
    "46307": (41.444409, -87.360089),
    "46308": (41.461543, -87.372779),
    "46310": (41.107336, -87.208423),
    "46311": (41.451993, -87.499489),
    "46312": (41.640835, -87.46149),
    "46319": (41.522129, -87.390338),
    "46320": (41.444246, -87.487242),
    "46321": (41.550534999999996, -87.502585),
    "46322": (41.577699, -87.47744),
    "46323": (41.590519, -87.45644),
    "46324": (41.585185, -87.496665),
    "46325": (41.461543, -87.372779),
    "46327": (41.615085, -87.49039),
    "46340": (41.378592, -86.788687),
    "46341": (41.347188, -87.152358),
    "46342": (41.520515, -87.347486),
    "46345": (41.526023, -86.699703),
    "46346": (41.480172, -86.691914),
    "46347": (41.301319, -87.066825),
    "46348": (41.394105, -86.806742),
    "46349": (41.108242, -87.418963),
    "46350": (41.537585, -86.73764),
    "46352": (41.498992, -86.709883),
    "46355": (41.359415, -87.27081),
    "46356": (41.280102, -87.411308),
    "46360": (41.594185, -86.756985),
    "46361": (41.70354, -86.915077),
    "46365": (41.609081, -86.543956),
    "46366": (41.25163, -86.735127),
    "46368": (41.473367, -87.12927),
    "46371": (41.686609, -86.599414),
    "46372": (41.143358, -87.322049),
    "46373": (41.453965, -87.453086),
    "46374": (41.216655, -86.884),
    "46375": (41.487733, -87.441525),
    "46376": (41.189953, -87.477881),
    "46377": (41.191734, -87.339778),
    "46379": (41.167119, -87.43355),
    "46380": (41.194816, -86.968614),
    "46381": (41.17115, -87.331323),
    "46382": (41.466863, -86.772226),
    "46383": (41.454731, -87.065565),
    "46384": (41.490545, -87.076094),
    "46385": (41.470567, -87.078309),
    "46390": (41.421123, -86.872078),
    "46391": (41.549933, -86.742979),
    "46392": (41.133299, -87.063818),
    "46393": (41.511578, -87.179177),
    "46394": (41.656785, -87.493392),
    "46401": (41.590686, -87.319937),
    "46402": (41.599336, -87.336338),
    "46403": (41.605636, -87.268536),
    "46404": (41.584136, -87.377538),
    "46405": (41.555785, -87.354587),
    "46406": (41.596012, -87.388189),
    "46407": (41.578886, -87.319987),
    "46408": (41.544936, -87.375307),
    "46409": (41.545636, -87.304186),
    "46410": (41.497212, -87.338656),
    "46411": (41.461543, -87.372779),
    "46501": (41.242669, -86.248052),
    "46502": (41.254035, -85.969708),
    "46504": (41.323904, -86.150818),
    "46506": (41.40577, -86.242235),
    "46507": (41.712983, -85.824845),
    "46508": (41.154726, -85.969282),
    "46510": (41.136771, -85.871487),
    "46511": (41.314629, -86.386582),
    "46513": (41.361903, -86.444254),
    "46514": (41.71873, -85.937024),
    "46515": (41.641449, -85.938348),
    "46516": (41.620856, -85.897236),
    "46517": (41.617705, -85.965717),
    "46524": (41.296306, -85.99843),
    "46526": (41.584839, -85.858059),
    "46527": (41.597739, -85.858076),
    "46528": (41.624763, -85.839139),
    "46530": (41.734912, -86.139868),
    "46531": (41.34963, -86.524321),
    "46532": (41.393141, -86.594849),
    "46534": (41.280907, -86.608249),
    "46536": (41.526373, -86.270086),
    "46537": (41.455431, -86.309368),
    "46538": (41.342883, -85.823785),
    "46539": (41.177648, -86.008586),
    "46540": (41.646192, -85.831327),
    "46542": (41.28296, -85.871138),
    "46543": (41.531255, -85.712083),
    "46544": (41.61536, -86.287884),
    "46545": (41.696407, -86.304735),
    "46546": (41.688432, -86.196485),
    "46550": (41.574743, -85.972724),
    "46552": (41.701172, -86.455494),
    "46553": (41.47867, -85.8192),
    "46554": (41.561716, -86.414045),
    "46555": (41.332568, -85.710285),
    "46556": (41.596769, -86.292991),
    "46561": (41.669504, -86.087002),
    "46562": (41.265769, -85.854745),
    "46563": (41.352997, -86.301486),
    "46565": (41.67572, -85.567362),
    "46566": (41.137923, -85.88883),
    "46567": (41.296386, -85.844729),
    "46570": (41.215971, -86.12282),
    "46571": (41.578904, -85.540055),
    "46572": (41.325513, -86.260569),
    "46573": (41.58574, -85.882695),
    "46574": (41.488957, -86.446734),
    "46580": (41.2228, -85.860179),
    "46581": (41.239365, -85.864267),
    "46582": (41.254225, -85.849508),
    "46590": (41.232725, -85.826346),
    "46595": (41.518136, -86.165227),
    "46601": (41.673383, -86.251654),
    "46604": (41.664198, -86.221805),
    "46612": (41.628483, -86.234589),
    "46613": (41.656573, -86.255696),
    "46614": (41.616532, -86.278463),
    "46615": (41.677046, -86.216105),
    "46616": (41.695957, -86.264293),
    "46617": (41.682897, -86.238906),
    "46619": (41.672919, -86.296056),
    "46620": (41.596769, -86.292991),
    "46624": (41.733223, -86.283278),
    "46626": (41.677397, -86.252506),
    "46628": (41.716559, -86.335738),
    "46629": (41.671919, -86.27911),
    "46634": (41.596769, -86.292991),
    "46635": (41.686358, -86.338666),
    "46637": (41.699077, -86.315321),
    "46660": (41.596769, -86.292991),
    "46680": (41.596769, -86.292991),
    "46699": (41.596769, -86.292991),
    "46701": (41.376028, -85.413862),
    "46702": (40.820278, -85.597862),
    "46703": (41.672567, -85.000474),
    "46704": (41.103797, -85.292474),
    "46705": (41.501455, -85.071275),
    "46706": (41.377758, -85.027689),
    "46710": (41.368123, -85.391019),
    "46711": (40.671628, -84.934331),
    "46713": (40.829196, -85.489198),
    "46714": (40.71327, -85.2023),
    "46720": (41.395275, -85.423462),
    "46721": (41.426441, -84.912517),
    "46723": (41.190811, -85.389672),
    "46725": (41.14956, -85.50042),
    "46730": (41.463082, -85.137324),
    "46731": (40.794056, -85.104206),
    "46732": (41.377903, -85.59875),
    "46733": (40.81911, -84.93785),
    "46737": (41.711462, -84.945643),
    "46738": (41.323007, -85.140707),
    "46740": (40.612058, -84.936072),
    "46741": (41.195015, -84.963984),
    "46742": (41.572304, -84.897465),
    "46743": (41.227324, -84.987882),
    "46745": (40.957347, -85.002148),
    "46746": (41.711914, -85.367474),
    "46747": (41.577125, -85.113166),
    "46748": (41.237988, -85.159437),
    "46750": (40.842697, -85.489225),
    "46755": (41.431488, -85.389073),
    "46759": (40.603317, -85.205635),
    "46760": (41.369423, -85.543448),
    "46761": (41.655135, -85.387208),
    "46763": (41.292913, -85.27904),
    "46764": (41.206938, -85.591994),
    "46765": (41.232203, -85.043118),
    "46766": (40.698551, -85.278222),
    "46767": (41.405478, -85.42573),
    "46769": (40.74532, -84.937926),
    "46770": (40.862309, -85.354611),
    "46771": (41.665489, -85.267567),
    "46772": (40.709518, -84.919164),
    "46773": (41.059007, -84.90402),
    "46774": (41.102098, -84.962038),
    "46776": (41.71364, -85.140168),
    "46777": (40.855435, -85.203797),
    "46778": (40.611419, -85.152604),
    "46779": (41.577443, -85.031873),
    "46780": (40.74532, -84.937926),
    "46781": (40.639684, -85.259163),
    "46782": (40.83204, -85.005402),
    "46783": (40.954446, -85.393868),
    "46784": (41.401296, -85.401402),
    "46785": (41.319754, -84.888552),
    "46786": (41.536899, -85.319241),
    "46787": (41.071204, -85.510981),
    "46788": (41.302927, -84.902416),
    "46789": (41.583493, -85.199186),
    "46791": (40.859358, -85.270039),
    "46792": (40.712066, -85.468798),
    "46793": (41.461019, -85.019562),
    "46794": (41.476682, -85.386856),
    "46795": (41.583475, -85.337737),
    "46796": (41.336115, -85.500246),
    "46797": (41.125044, -84.874249),
    "46798": (41.009498, -85.086518),
    "46799": (40.918797, -85.282422),
    "46801": (41.093763, -85.070713),
    "46802": (41.065397, -85.15842),
    "46803": (41.065648, -85.084069),
    "46804": (41.057168, -85.239172),
    "46805": (41.099948, -85.078019),
    "46806": (41.049248, -85.082319),
    "46807": (41.042342, -85.14682),
    "46808": (41.093898, -85.184121),
    "46809": (41.037097, -85.205071),
    "46814": (41.045647, -85.305823),
    "46815": (41.141189, -85.072068),
    "46816": (40.988047, -85.033817),
    "46818": (41.112548, -85.203895),
    "46819": (40.978697, -85.126419),
    "46825": (41.138003, -85.104001),
    "46835": (41.156698, -85.057218),
    "46845": (41.095957, -85.084581),
    "46850": (41.093763, -85.070713),
    "46851": (41.093763, -85.070713),
    "46852": (41.093763, -85.070713),
    "46853": (41.093763, -85.070713),
    "46854": (41.093763, -85.070713),
    "46855": (41.093763, -85.070713),
    "46856": (41.093763, -85.070713),
    "46857": (41.093763, -85.070713),
    "46858": (41.093763, -85.070713),
    "46859": (41.093763, -85.070713),
    "46860": (41.093763, -85.070713),
    "46861": (41.093763, -85.070713),
    "46862": (41.093763, -85.070713),
    "46863": (41.093763, -85.070713),
    "46864": (41.093763, -85.070713),
    "46865": (41.126298, -85.090669),
    "46866": (41.093763, -85.070713),
    "46867": (41.093763, -85.070713),
    "46868": (41.093763, -85.070713),
    "46869": (41.093763, -85.070713),
    "46885": (41.093763, -85.070713),
    "46895": (41.093763, -85.070713),
    "46896": (41.093763, -85.070713),
    "46897": (41.093763, -85.070713),
    "46898": (41.093763, -85.070713),
    "46899": (41.093763, -85.070713),
    "46901": (40.506851, -86.171054),
    "46902": (40.444291, -86.17559),
    "46903": (40.469625, -86.11894),
    "46904": (40.469625, -86.11894),
    "46910": (41.047932, -86.069172),
    "46911": (40.650476, -85.943552),
    "46912": (41.040988, -86.206925),
    "46913": (40.500141, -86.507065),
    "46914": (40.659068, -86.102125),
    "46915": (40.495181, -86.394248),
    "46916": (40.584272, -86.573952),
    "46917": (40.626954, -86.499148),
    "46919": (40.578034, -85.878104),
    "46920": (40.485424, -86.488525),
    "46921": (40.960538, -86.12908),
    "46922": (41.040988, -86.206925),
    "46923": (40.580452, -86.637891),
    "46926": (40.867036, -86.07524),
    "46928": (40.515421, -85.661196),
    "46929": (40.556269, -86.490521),
    "46930": (40.40993, -85.571035),
    "46931": (40.948405, -86.265814),
    "46932": (40.634254, -86.269625),
    "46933": (40.54429, -85.585245),
    "46935": (41.040988, -86.206925),
    "46936": (40.485442, -85.997326),
    "46937": (40.418662, -86.018139),
    "46938": (40.44673, -85.650398),
    "46939": (41.040533, -86.374647),
    "46940": (40.696155, -85.740428),
    "46941": (40.826475, -85.700909),
    "46942": (40.736111, -86.37341),
    "46943": (40.974279, -85.837546),
    "46945": (41.040988, -86.206925),
    "46946": (41.035629, -85.735756),
    "46947": (40.77927, -86.375168),
    "46950": (40.875277, -86.354066),
    "46951": (40.95841, -86.129366),
    "46952": (40.519756, -85.636731),
    "46953": (40.499959, -85.626401),
    "46957": (40.389831, -85.476619),
    "46958": (40.822384, -86.116189),
    "46959": (40.61466, -86.106432),
    "46960": (41.124552, -86.544617),
    "46961": (40.762054, -86.193648),
    "46962": (40.859877, -85.794138),
    "46965": (40.412741, -86.101484),
    "46967": (40.694298, -86.204238),
    "46968": (41.175557, -86.554326),
    "46970": (40.73991, -86.07581),
    "46971": (40.780955, -86.016441),
    "46974": (40.951589, -85.854151),
    "46975": (41.040988, -86.254272),
    "46977": (40.584272, -86.573952),
    "46978": (40.851622, -86.492019),
    "46979": (40.42573, -86.269717),
    "46980": (40.848927, -85.792501),
    "46982": (41.130963, -85.856589),
    "46984": (40.671369, -85.828846),
    "46985": (41.003004, -86.589005),
    "46986": (40.505141, -85.815617),
    "46987": (40.564673, -85.765569),
    "46988": (40.866096, -86.233899),
    "46989": (40.455985, -85.62512),
    "46990": (40.886571, -85.736386),
    "46991": (40.617379, -85.514796),
    "46992": (40.801867, -85.791823),
    "46994": (40.677128, -86.260927),
    "46995": (40.442117, -86.215482),
    "46996": (41.035862, -86.622156),
    "46998": (40.866023, -86.225982),
    "47001": (39.091081, -84.988904),
    "47003": (39.515851, -84.862979),
    "47006": (39.19017, -85.229151),
    "47010": (39.490701, -84.853529),
    "47011": (38.864386, -85.074867),
    "47012": (39.416398, -85.00028),
    "47016": (39.367379, -84.910391),
    "47017": (38.945037, -85.191159),
    "47018": (39.002217, -85.02623),
    "47019": (38.868591, -84.925998),
    "47020": (38.82353, -84.950119),
    "47021": (38.970266, -85.15039),
    "47022": (39.193261, -84.964354),
    "47023": (39.082863, -85.374353),
    "47024": (39.467957, -85.178057),
    "47025": (39.152741, -84.891015),
    "47030": (39.433095, -85.111826),
    "47031": (39.115266, -85.22819),
    "47032": (39.16259, -84.980417),
    "47033": (39.281429, -85.1739),
    "47034": (39.204833, -85.326962),
    "47035": (39.309983, -84.900711),
    "47036": (39.386175, -85.238529),
    "47037": (39.172808, -85.285367),
    "47038": (38.84188, -84.881782),
    "47039": (39.111625, -85.255114),
    "47040": (38.958134, -84.984085),
    "47041": (39.231396, -85.140001),
    "47042": (39.039682, -85.244161),
    "47043": (38.809388, -85.061136),
    "47060": (39.25151, -84.91437),
    "47102": (38.748455, -85.750469),
    "47104": (38.539899, -85.421753),
    "47106": (38.482335, -85.76776),
    "47107": (38.190314, -86.115257),
    "47108": (38.614255, -86.220645),
    "47110": (38.096971, -86.172327),
    "47111": (38.459992, -85.615235),
    "47112": (38.1863, -86.145211),
    "47114": (38.289882, -86.08239),
    "47115": (38.338462, -86.212957),
    "47116": (38.329303, -86.575635),
    "47117": (38.094629, -85.988349),
    "47118": (38.288549, -86.501185),
    "47119": (38.35257, -85.890727),
    "47120": (38.46772, -86.185333),
    "47122": (38.31098, -85.960009),
    "47123": (38.281966, -86.484327),
    "47124": (38.373209, -85.986626),
    "47125": (38.500408, -86.244689),
    "47126": (38.5504, -85.774327),
    "47129": (38.310958, -85.764463),
    "47130": (38.404909, -85.716548),
    "47131": (38.437021, -85.704973),
    "47132": (38.286819, -85.732062),
    "47133": (38.286819, -85.732062),
    "47134": (38.286819, -85.732062),
    "47135": (38.039957, -86.06555),
    "47136": (38.227683999999996, -85.990389),
    "47137": (38.195771, -86.368905),
    "47138": (38.671281, -85.6333),
    "47139": (38.600666, -86.078828),
    "47140": (38.357884, -86.372687),
    "47141": (38.549871, -85.597466),
    "47142": (38.073945, -86.204065),
    "47143": (38.467595, -85.769631),
    "47144": (38.286819, -85.732062),
    "47145": (38.337832, -86.314971),
    "47146": (38.298486, -85.896961),
    "47147": (38.580326, -85.532171),
    "47150": (38.293355, -85.837911),
    "47151": (38.298486, -85.896961),
    "47160": (38.148843, -86.049282),
    "47161": (38.328025, -86.105996),
    "47162": (38.550289, -85.486131),
    "47163": (38.535058, -85.669829),
    "47164": (38.380353, -86.105954),
    "47165": (38.512878, -86.010567),
    "47166": (38.303364, -86.168979),
    "47167": (38.608621, -86.079404),
    "47170": (38.695648, -85.772815),
    "47172": (38.404577, -85.787963),
    "47174": (38.22588, -86.490751),
    "47175": (38.345487, -86.54608),
    "47177": (38.584823, -85.748631),
    "47199": (38.286819, -85.732062),
    "47201": (39.191447, -85.891338),
    "47202": (39.192972, -85.885168),
    "47203": (39.241129, -85.827439),
    "47220": (38.866192, -86.046452),
    "47223": (39.046146, -85.486831),
    "47224": (38.873448, -85.291935),
    "47225": (39.424072, -85.347677),
    "47226": (39.282609, -85.868533),
    "47227": (38.868992, -85.660004),
    "47228": (38.974458, -85.962761),
    "47229": (38.815289, -85.985182),
    "47230": (38.794988, -85.60731),
    "47231": (38.876272, -85.500519),
    "47232": (39.118884, -85.773533),
    "47234": (39.393802, -85.77201),
    "47235": (38.962837, -86.155545),
    "47236": (39.152228, -85.726135),
    "47240": (39.299802, -85.491781),
    "47243": (38.734755, -85.376804),
    "47244": (39.218578, -85.717648),
    "47245": (39.001301, -85.619906),
    "47246": (39.20336, -85.787611),
    "47247": (39.059349, -85.888579),
    "47249": (38.897974, -86.056681),
    "47250": (38.804552, -85.420605),
    "47260": (38.84003, -86.194693),
    "47261": (39.292004, -85.491788),
    "47262": (39.001301, -85.619906),
    "47263": (39.308252, -85.329695),
    "47264": (38.947371, -86.23671),
    "47265": (39.023539, -85.622328),
    "47270": (38.86752, -85.716186),
    "47272": (39.318, -85.463684),
    "47273": (39.064795, -85.733853),
    "47274": (38.944827, -86.010789),
    "47280": (39.295266, -85.949844),
    "47281": (38.814419, -86.092983),
    "47282": (38.982509, -85.616595),
    "47283": (39.241181, -85.564278),
    "47302": (40.142124, -85.389874),
    "47303": (40.280332, -85.383447),
    "47304": (40.238544, -85.484122),
    "47305": (40.247979, -85.433223),
    "47306": (40.202293, -85.408221),
    "47307": (40.162093, -85.442772),
    "47308": (40.227938, -85.396685),
    "47320": (40.277967, -85.274125),
    "47322": (39.656994, -85.167996),
    "47324": (39.757864, -84.848442),
    "47325": (39.682946, -84.995266),
    "47326": (40.54116, -84.982803),
    "47327": (39.848569, -85.035364),
    "47330": (39.787438, -84.986277),
    "47331": (39.656933, -85.168099),
    "47334": (40.143843, -85.50845699999999),
    "47335": (39.812688, -85.204359),
    "47336": (40.43525, -85.091124),
    "47337": (39.803063, -85.43711),
    "47338": (40.252982, -85.338738),
    "47339": (39.961044, -85.102314),
    "47340": (40.187565, -85.14558),
    "47341": (39.864218, -84.995365),
    "47342": (40.309361, -85.432657),
    "47344": (39.878933, -85.464036),
    "47345": (39.893845, -85.013775),
    "47346": (39.895789, -85.05967),
    "47348": (40.472672, -85.326447),
    "47351": (39.904018, -85.520548),
    "47352": (39.830372, -85.372732),
    "47353": (39.625149, -84.925002),
    "47354": (40.048148, -85.17051),
    "47355": (40.055775, -84.941102),
    "47356": (39.941555, -85.462793),
    "47357": (39.764911, -85.109015),
    "47358": (40.055419, -85.108514),
    "47359": (40.515895, -85.295619),
    "47360": (40.01641, -85.293037),
    "47361": (40.001295, -85.319923),
    "47362": (39.92487, -85.366926),
    "47366": (39.931785, -85.398625),
    "47367": (40.079197, -85.389978),
    "47368": (40.174184, -85.173858),
    "47369": (40.457413, -85.133813),
    "47370": (39.861314, -85.147437),
    "47371": (40.431634, -84.983015),
    "47373": (40.359568, -85.151994),
    "47374": (39.84081, -85.010442),
    "47375": (39.860417, -85.015983),
    "47380": (40.167082, -85.048286),
    "47381": (40.378574, -84.882263),
    "47382": (40.234703, -84.91848),
    "47383": (40.15178, -85.265562),
    "47384": (39.946332, -85.485528),
    "47385": (39.91725, -85.450834),
    "47386": (40.011128, -85.383768),
    "47387": (39.83059, -85.284275),
    "47388": (40.005999, -85.44341),
    "47390": (40.166457, -85.006297),
    "47392": (39.911895, -84.935057),
    "47393": (39.930541, -85.028032),
    "47394": (40.159854, -84.984682),
    "47396": (40.19855, -85.509272),
    "47401": (39.07881, -86.435094),
    "47402": (39.173234, -86.501543),
    "47403": (39.07884, -86.592389),
    "47404": (39.25007, -86.580849),
    "47405": (39.173447, -86.515145),
    "47406": (39.174541, -86.518296),
    "47407": (39.173234, -86.501543),
    "47408": (39.230326, -86.469187),
    "47420": (38.839482, -86.47943),
    "47421": (38.890524, -86.525843),
    "47424": (39.031541, -86.838359),
    "47426": (39.173234, -86.501543),
    "47427": (39.319527, -86.842743),
    "47429": (39.276356, -86.62658),
    "47430": (38.839482, -86.47943),
    "47431": (39.319527, -86.842743),
    "47432": (38.486914, -86.587861),
    "47433": (39.346964, -86.701332),
    "47434": (39.012984, -86.545732),
    "47435": (39.196272, -86.230212),
    "47436": (38.839482, -86.47943),
    "47437": (38.722153, -86.670987),
    "47438": (39.078835, -86.992896),
    "47439": (39.037144, -86.961577),
    "47441": (39.04963, -87.126965),
    "47443": (38.988255, -87.102958),
    "47445": (39.037144, -86.961577),
    "47446": (38.803928, -86.50326),
    "47448": (39.180583, -86.226228),
    "47449": (39.037144, -86.961577),
    "47451": (38.895608, -86.525522),
    "47452": (38.586595, -86.451946),
    "47453": (39.037144, -86.961577),
    "47454": (38.513132, -86.459473),
    "47455": (39.319527, -86.842743),
    "47456": (39.442888, -86.669559),
    "47457": (39.037144, -86.961577),
    "47458": (39.173234, -86.501543),
    "47459": (39.104137, -86.73706),
    "47460": (39.313258, -86.756423),
    "47462": (38.941408, -86.584408),
    "47463": (39.085896, -86.6689),
    "47464": (39.299823, -86.648201),
    "47465": (39.037144, -86.961577),
    "47467": (38.839482, -86.47943),
    "47468": (39.274735, -86.42106),
    "47469": (38.620834, -86.589851),
    "47470": (38.839482, -86.47943),
    "47471": (39.124289, -86.970755),
    "47490": (39.173234, -86.501543),
    "47501": (38.689503, -87.121505),
    "47512": (38.741286, -87.346192),
    "47513": (38.326772, -86.820726),
    "47514": (38.053876, -86.621994),
    "47515": (38.198133, -86.682068),
    "47516": (38.761354, -87.417076),
    "47519": (38.697289, -87.091762),
    "47520": (37.949544, -86.715557),
    "47521": (38.406745, -86.742618),
    "47522": (38.894879, -86.900174),
    "47523": (38.149611, -86.946217),
    "47524": (38.626138, -87.511863),
    "47525": (38.020017, -86.565129),
    "47527": (38.439461, -86.777335),
    "47528": (38.786795, -87.38271),
    "47529": (38.877167, -87.085001),
    "47531": (38.045062, -86.864745),
    "47532": (38.251171, -86.867492),
    "47535": (38.862735, -87.312678),
    "47536": (37.993813, -87.016971),
    "47537": (38.080052, -87.049834),
    "47541": (38.249617, -87.007734),
    "47542": (38.298972, -86.952413),
    "47545": (38.413687, -87.000879),
    "47546": (38.360357, -86.929481),
    "47547": (38.364749, -86.876173),
    "47549": (38.364749, -86.876173),
    "47550": (38.042888, -86.94971),
    "47551": (38.127658, -86.570969),
    "47552": (38.124192, -86.995988),
    "47553": (38.771691, -86.912985),
    "47556": (38.16644, -86.917205),
    "47557": (38.590433, -87.368456),
    "47558": (38.697289, -87.091762),
    "47561": (38.709818, -87.388134),
    "47562": (38.841866, -86.986145),
    "47564": (38.477976, -87.128545),
    "47567": (38.459787, -87.298174),
    "47568": (38.697289, -87.091762),
    "47573": (38.744136, -87.321357),
    "47574": (37.937193, -86.534002),
    "47575": (38.321125, -86.823444),
    "47576": (38.152479, -86.64902),
    "47577": (38.141725, -86.821891),
    "47578": (38.881471, -87.19594),
    "47579": (38.117579, -86.928645),
    "47580": (38.352759, -86.912488),
    "47581": (38.669976, -86.788412),
    "47584": (38.26376, -87.230482),
    "47585": (38.271004, -87.147783),
    "47586": (37.999711, -86.731971),
    "47588": (38.033118, -86.798123),
    "47590": (38.367402, -87.109044),
    "47591": (38.707231, -87.417306),
    "47596": (38.791556, -87.3318),
    "47597": (38.656969, -87.329395),
    "47598": (38.372926, -87.211093),
    "47601": (38.04247, -87.287145),
    "47610": (38.054569, -87.267847),
    "47611": (38.031396, -86.970053),
    "47612": (38.175698, -87.711423),
    "47613": (38.128931, -87.416104),
    "47614": (38.130034, -87.163636),
    "47615": (38.003542, -86.996351),
    "47616": (38.190994, -87.91701),
    "47617": (37.903557, -87.249886),
    "47618": (37.997128, -87.574963),
    "47619": (38.162899, -87.283955),
    "47620": (37.961781, -87.868228),
    "47629": (38.06242, -87.245214),
    "47630": (38.038331, -87.283581),
    "47631": (38.101827, -87.898765),
    "47633": (38.148016, -87.786303),
    "47634": (37.975392, -87.136282),
    "47635": (37.929173, -87.033681),
    "47637": (38.118439, -87.244937),
    "47638": (38.069277, -87.783602),
    "47639": (38.202701, -87.577358),
    "47640": (38.384971, -87.473674),
    "47647": (38.34949, -87.651777),
    "47648": (38.30512, -87.518339),
    "47649": (38.331581, -87.447826),
    "47654": (38.34949, -87.651777),
    "47660": (38.306265, -87.514796),
    "47665": (38.272833, -87.681174),
    "47666": (38.401233, -87.583761),
    "47670": (38.303369, -87.534003),
    "47683": (38.281095, -87.37734),
    "47701": (37.997128, -87.574963),
    "47702": (37.997128, -87.574963),
    "47703": (37.997128, -87.574963),
    "47704": (37.997128, -87.574963),
    "47705": (37.997128, -87.574963),
    "47706": (37.997128, -87.574963),
    "47708": (37.976692, -87.564842),
    "47710": (38.029714, -87.569024),
    "47711": (38.061732, -87.554802),
    "47712": (37.984112, -87.580057),
    "47713": (37.95219, -87.547564),
    "47714": (37.959092, -87.519682),
    "47715": (37.984202, -87.489212),
    "47716": (37.997128, -87.574963),
    "47719": (37.997128, -87.574963),
    "47720": (38.059937, -87.637962),
    "47721": (37.978035, -87.600791),
    "47722": (37.970192, -87.542014),
    "47724": (37.997128, -87.574963),
    "47725": (38.045237, -87.547704),
    "47727": (38.031942, -87.538915),
    "47728": (37.997128, -87.574963),
    "47730": (37.997128, -87.574963),
    "47731": (37.997128, -87.574963),
    "47732": (37.997128, -87.574963),
    "47733": (37.997128, -87.574963),
    "47734": (37.997128, -87.574963),
    "47735": (37.997128, -87.574963),
    "47736": (37.997128, -87.574963),
    "47737": (37.997128, -87.574963),
    "47739": (37.997128, -87.574963),
    "47740": (37.997128, -87.574963),
    "47741": (37.997128, -87.574963),
    "47744": (37.977492, -87.597316),
    "47747": (37.997128, -87.574963),
    "47750": (37.962292, -87.505512),
    "47801": (39.433602, -87.410094),
    "47802": (39.357875, -87.42014),
    "47803": (39.468961, -87.315069),
    "47804": (39.505836, -87.342968),
    "47805": (39.532737, -87.325458),
    "47807": (39.467536, -87.392019),
    "47808": (39.433602, -87.410094),
    "47809": (39.470986, -87.41107),
    "47811": (39.433602, -87.410094),
    "47812": (39.433602, -87.410094),
    "47813": (39.433602, -87.410094),
    "47814": (39.433602, -87.410094),
    "47830": (39.779078, -87.221819),
    "47831": (39.877847, -87.443566),
    "47832": (39.779078, -87.221819),
    "47833": (39.415414, -87.065524),
    "47834": (39.387611, -87.126509),
    "47836": (39.779078, -87.221819),
    "47837": (39.591282, -87.113196),
    "47838": (38.966806, -87.384354),
    "47840": (39.408241, -87.053309),
    "47841": (39.301664, -87.136902),
    "47842": (39.746685, -87.458654),
    "47845": (39.387544, -87.090363),
    "47846": (39.368643, -87.175317),
    "47847": (39.838952, -87.471163),
    "47848": (39.039488, -87.30662),
    "47849": (39.190101, -87.547036),
    "47850": (39.222063, -87.425279),
    "47851": (39.573663, -87.24536),
    "47852": (39.080474, -87.449558),
    "47853": (39.537199, -87.072888),
    "47854": (39.808476, -87.424521),
    "47855": (39.183335, -87.299448),
    "47856": (39.779078, -87.221819),
    "47857": (39.526913, -87.086882),
    "47858": (39.302796, -87.277737),
    "47859": (39.779078, -87.221819),
    "47860": (39.779078, -87.221819),
    "47861": (39.057641, -87.566595),
    "47862": (39.791725, -87.369135),
    "47863": (39.580285, -87.46157),
    "47864": (39.041245, -87.475747),
    "47865": (39.01849, -87.389047),
    "47866": (39.292886, -87.33555),
    "47868": (39.444565, -86.960667),
    "47869": (39.433602, -87.410094),
    "47870": (39.371187, -87.475871),
    "47871": (39.388638, -87.301367),
    "47872": (39.712361, -87.222646),
    "47874": (39.622405, -87.320767),
    "47875": (39.877847, -87.443566),
    "47876": (39.433602, -87.410094),
    "47878": (39.492838, -87.266549),
    "47879": (39.10494, -87.382988),
    "47880": (39.600636, -87.419569),
    "47881": (39.491743, -87.186673),
    "47882": (39.084199, -87.419003),
    "47884": (39.622129, -87.454769),
    "47885": (39.498419, -87.468825),
    "47901": (40.39905, -86.830286),
    "47902": (40.388656, -86.894908),
    "47903": (40.304402, -86.824468),
    "47904": (40.482287, -86.917273),
    "47905": (40.392686, -86.884071),
    "47906": (40.467303, -86.928132),
    "47907": (40.424923, -86.916215),
    "47909": (40.322769, -86.888066),
    "47916": (39.962271, -87.050635),
    "47917": (40.527877, -87.499343),
    "47918": (40.240204, -87.213921),
    "47920": (40.533131, -86.822842),
    "47921": (40.577647999999996, -87.311618),
    "47922": (40.883043, -87.394076),
    "47923": (40.661019, -86.845433),
    "47924": (40.487603, -86.763111),
    "47925": (40.750414, -86.789632),
    "47926": (40.813168, -86.619353),
    "47928": (39.927176, -87.471616),
    "47929": (40.754782, -86.934599),
    "47930": (40.250791, -86.75244),
    "47932": (40.096833, -87.352877),
    "47933": (40.042425, -86.893538),
    "47934": (40.040014, -86.893614),
    "47935": (40.040014, -86.893614),
    "47936": (40.040014, -86.893614),
    "47937": (40.040014, -86.893614),
    "47938": (40.040014, -86.893614),
    "47939": (40.040014, -86.893614),
    "47940": (40.107625, -86.777653),
    "47941": (40.362781, -86.763031),
    "47942": (40.679382, -87.415972),
    "47943": (41.076883, -87.208786),
    "47944": (40.606541, -87.311247),
    "47946": (40.984442, -86.83465),
    "47948": (40.794039, -87.324812),
    "47949": (40.045073, -87.175046),
    "47950": (40.809887, -86.739391),
    "47951": (40.794191, -87.439821),
    "47952": (40.017364, -87.256877),
    "47954": (40.050731999999996, -86.855491),
    "47955": (40.191498, -86.901826),
    "47957": (41.072624, -86.849745),
    "47958": (40.164139, -87.14754),
    "47959": (40.795391, -86.93711),
    "47960": (40.779211, -86.749521),
    "47962": (40.473159, -87.027571),
    "47963": (40.95469, -87.411025),
    "47964": (40.977567, -87.396982),
    "47965": (39.952351, -86.920609),
    "47966": (39.87356, -87.406937),
    "47967": (40.193583, -86.976237),
    "47968": (40.026229, -86.827059),
    "47969": (40.203459, -87.147014),
    "47970": (40.598666, -87.13607),
    "47971": (40.533538, -87.259375),
    "47974": (40.023673, -87.475513),
    "47975": (40.439726, -87.255833),
    "47977": (40.903837, -87.140991),
    "47978": (40.994793, -87.10368),
    "47980": (40.782613, -86.919278),
    "47981": (40.258026, -86.920786),
    "47982": (40.19674, -87.526532),
    "47983": (40.284511, -86.772436),
    "47984": (40.606301, -87.310042),
    "47986": (40.505497, -87.20696),
    "47987": (40.110318, -87.228444),
    "47988": (39.986538, -87.147674),
    "47989": (39.913473, -86.980365),
    "47990": (40.055655, -87.035366),
    "47991": (40.265862, -87.438432),
    "47992": (40.318084, -87.046004),
    "47993": (40.314172, -87.403882),
    "47994": (40.118361, -86.964894),
    "47995": (40.726466, -86.989485),
    "47996": (40.388656, -86.894908),
    "47997": (40.670628, -86.722352),
    "48001": (42.614984, -82.597768),
    "48002": (42.938828, -82.919818),
    "48003": (42.934027, -83.052481),
    "48004": (42.824095, -82.66522),
    "48005": (42.850051, -82.894993),
    "48006": (43.075152, -82.695467),
    "48007": (42.606088, -83.297593),
    "48009": (42.534834, -83.22416),
    "48012": (42.604425, -83.292382),
    "48014": (43.026326, -82.929772),
    "48015": (42.480186, -83.027221),
    "48017": (42.536785, -83.146427),
    "48021": (42.464986, -82.944318),
    "48022": (43.03545, -82.800896),
    "48023": (42.702264, -82.668829),
    "48025": (42.520184, -83.264031),
    "48026": (42.538702, -82.949421),
    "48027": (42.944333, -82.691559),
    "48028": (42.597245, -82.596757),
    "48030": (42.496485, -83.098474),
    "48032": (43.12226, -82.599804),
    "48034": (42.478495, -83.279164),
    "48035": (42.551185, -82.91672),
    "48036": (42.593834, -82.913321),
    "48037": (42.567543, -83.149978),
    "48038": (42.620607, -82.960775),
    "48039": (42.68586, -82.549857),
    "48040": (42.78269, -82.491538),
    "48041": (42.941032, -82.804636),
    "48042": (42.673476, -82.916262),
    "48043": (42.597984, -82.877669),
    "48044": (42.644211, -82.898513),
    "48045": (42.587734, -82.821517),
    "48046": (42.672322, -82.903065),
    "48047": (42.601469, -82.821874),
    "48048": (42.744267, -82.804166),
    "48049": (43.034915, -82.574831),
    "48050": (42.785908, -82.797858),
    "48051": (42.67518, -82.809082),
    "48054": (42.776889, -82.543697),
    "48059": (43.088821, -82.490486),
    "48060": (42.984014, -82.467461),
    "48061": (42.824095, -82.66522),
    "48062": (42.838913, -82.799617),
    "48063": (42.889238, -82.667478),
    "48064": (42.767364, -82.672786),
    "48065": (42.839951, -83.038836),
    "48066": (42.509635, -82.936069),
    "48067": (42.492485, -83.145375),
    "48068": (42.660091, -83.3863),
    "48069": (42.471385, -83.144026),
    "48070": (42.481786, -83.166376),
    "48071": (42.505292, -83.136126),
    "48072": (42.499235, -83.181077),
    "48073": (42.5216, -83.163477),
    "48074": (42.905056, -82.567942),
    "48075": (42.462215, -83.230578),
    "48076": (42.498117, -83.205798),
    "48079": (42.876235, -82.547672),
    "48080": (42.470639, -82.902194),
    "48081": (42.494085, -82.898986),
    "48082": (42.526935, -82.884117),
    "48083": (42.555985, -83.119206),
    "48084": (42.554751, -83.17688),
    "48086": (42.660091, -83.3863),
    "48089": (42.474786, -82.995121),
    "48090": (42.672322, -82.903065),
    "48091": (42.470938, -83.054623),
    "48092": (42.513435, -83.056988),
    "48093": (42.514886, -83.006613),
    "48094": (42.755978999999996, -83.037598),
    "48095": (42.768153, -83.039474),
    "48096": (42.754039, -82.916348),
    "48097": (42.879217, -82.739491),
    "48098": (42.599883, -83.14908),
    "48099": (42.587643, -83.173666),
    "48101": (42.27633, -83.194425),
    "48103": (42.266638, -83.849042),
    "48104": (42.270903, -83.727826),
    "48105": (42.323077, -83.713891),
    "48106": (42.253502, -83.836571),
    "48107": (42.253502, -83.836571),
    "48108": (42.223305, -83.729342),
    "48109": (42.276324, -83.711228),
    "48110": (42.008164, -83.664277),
    "48111": (42.263968, -83.416284),
    "48112": (42.239933, -83.150823),
    "48113": (42.253502, -83.836571),
    "48114": (42.546402, -83.877776),
    "48115": (42.160216, -83.911693),
    "48116": (42.529541, -83.776055),
    "48117": (42.0413, -83.428904),
    "48118": (42.31375, -84.013999),
    "48120": (42.310037, -83.177625),
    "48121": (42.239933, -83.150823),
    "48122": (42.353686, -83.223427),
    "48123": (42.239933, -83.150823),
    "48124": (42.299302, -83.242577),
    "48125": (42.342272, -83.298123),
    "48126": (42.271811, -83.225877),
    "48127": (42.334386, -83.273929),
    "48128": (42.31927, -83.251428),
    "48130": (42.353887, -83.898295),
    "48131": (41.964903, -83.668808),
    "48133": (41.790287, -83.504033),
    "48134": (42.116811, -83.300439),
    "48135": (42.326437, -83.343431),
    "48136": (42.239933, -83.150823),
    "48137": (42.496024, -84.084724),
    "48138": (42.135191, -83.156124),
    "48139": (42.452284, -83.814654),
    "48140": (41.887078, -83.58177),
    "48141": (42.293338, -83.314674),
    "48143": (42.457317, -83.836643),
    "48144": (41.759998, -83.618485),
    "48145": (41.845509, -83.462383),
    "48146": (42.242038, -83.180375),
    "48150": (42.369351, -83.371753),
    "48151": (42.239933, -83.150823),
    "48152": (42.426235, -83.370682),
    "48153": (42.239933, -83.150823),
    "48154": (42.375986, -83.389962),
    "48157": (41.813365, -83.436032),
    "48158": (42.18314, -84.013795),
    "48159": (42.041832, -83.557254),
    "48160": (42.001525, -83.659763),
    "48161": (41.928024, -83.430682),
    "48162": (41.929341, -83.444773),
    "48164": (42.135225, -83.390422),
    "48165": (42.498145, -83.608727),
    "48166": (41.921912, -83.330583),
    "48167": (42.41729, -83.432434),
    "48169": (42.467503, -83.946982),
    "48170": (42.366737, -83.489679),
    "48173": (42.112182, -83.272588),
    "48174": (42.20284, -83.351255),
    "48175": (42.405636, -83.578088),
    "48176": (42.147636, -83.802375),
    "48177": (41.807647, -83.579334),
    "48178": (42.474564, -83.612188),
    "48179": (42.051135, -83.27095),
    "48180": (42.245837, -83.249067),
    "48182": (41.790497, -83.584998),
    "48183": (42.138209, -83.217937),
    "48184": (42.263487, -83.39597499999999),
    "48185": (42.31507, -83.373093),
    "48186": (42.28902, -83.368582),
    "48187": (42.374118, -83.418143),
    "48188": (42.291734, -83.485776),
    "48189": (42.386914, -83.783736),
    "48190": (42.124398, -83.594567),
    "48191": (42.129589, -83.569965),
    "48192": (42.19499, -83.206572),
    "48195": (42.257801, -83.285939),
    "48197": (42.202139, -83.620494),
    "48198": (42.309687, -83.772991),
    "48201": (42.239933, -83.150823),
    "48202": (42.239933, -83.150823),
    "48203": (42.239933, -83.150823),
    "48204": (42.239933, -83.150823),
    "48205": (42.239933, -83.150823),
    "48206": (42.239933, -83.150823),
    "48207": (42.239933, -83.150823),
    "48208": (42.239933, -83.150823),
    "48209": (42.239933, -83.150823),
    "48210": (42.326937, -83.148424),
    "48211": (42.239933, -83.150823),
    "48212": (42.239933, -83.150823),
    "48213": (42.239933, -83.150823),
    "48214": (42.239933, -83.150823),
    "48215": (42.239933, -83.150823),
    "48216": (42.337787, -83.167925),
    "48217": (42.273038, -83.152573),
    "48218": (42.268761, -83.135137),
    "48219": (42.437192, -83.287477),
    "48220": (42.460586, -83.140675),
    "48221": (42.239933, -83.150823),
    "48222": (42.239933, -83.150823),
    "48223": (42.395986, -83.275979),
    "48224": (42.239933, -83.150823),
    "48225": (42.239933, -83.150823),
    "48226": (42.239933, -83.150823),
    "48227": (42.239933, -83.150823),
    "48228": (42.335937, -83.217127),
    "48229": (42.249838, -83.143121),
    "48230": (42.239933, -83.150823),
    "48231": (42.239933, -83.150823),
    "48232": (42.239933, -83.150823),
    "48233": (42.239933, -83.150823),
    "48234": (42.239933, -83.150823),
    "48235": (42.239933, -83.150823),
    "48236": (42.239933, -83.150823),
    "48237": (42.466585, -83.178177),
    "48238": (42.239933, -83.150823),
    "48239": (42.392286, -83.282029),
    "48240": (42.423035, -83.30358),
    "48242": (42.216575, -83.35324),
    "48243": (42.239933, -83.150823),
    "48244": (42.239933, -83.150823),
    "48255": (42.239933, -83.150823),
    "48260": (42.239933, -83.150823),
    "48264": (42.239933, -83.150823),
    "48265": (42.239933, -83.150823),
    "48266": (42.239933, -83.150823),
    "48267": (42.239933, -83.150823),
    "48268": (42.239933, -83.150823),
    "48269": (42.239933, -83.150823),
    "48272": (42.239933, -83.150823),
    "48275": (42.239933, -83.150823),
    "48277": (42.239933, -83.150823),
    "48278": (42.239933, -83.150823),
    "48279": (42.239933, -83.150823),
    "48288": (42.239933, -83.150823),
    "48301": (42.544534, -83.279231),
    "48302": (42.584789, -83.282116),
    "48303": (42.660091, -83.3863),
    "48304": (42.587034, -83.235931),
    "48306": (42.726216, -83.156629),
    "48307": (42.659283, -83.122482),
    "48308": (42.638533, -83.131426),
    "48309": (42.662644, -83.183666),
    "48310": (42.564395, -83.068475),
    "48311": (42.672322, -82.903065),
    "48312": (42.566338, -83.028532),
    "48313": (42.606847, -83.01041),
    "48314": (42.603976, -83.036259),
    "48315": (42.671025, -82.998811),
    "48316": (42.688531, -83.05483),
    "48317": (42.641276, -83.05043),
    "48318": (42.672322, -82.903065),
    "48320": (42.611409, -83.335629),
    "48321": (42.660091, -83.3863),
    "48322": (42.542715, -83.379535),
    "48323": (42.568292, -83.380535),
    "48324": (42.596093, -83.381886),
    "48325": (42.660091, -83.3863),
    "48326": (42.673931, -83.295052),
    "48327": (42.644824, -83.406111),
    "48328": (42.647831, -83.355433),
    "48329": (42.68258, -83.386338),
    "48330": (42.675435, -83.363697),
    "48331": (42.505138, -83.407233),
    "48332": (42.660091, -83.3863),
    "48333": (42.660091, -83.3863),
    "48334": (42.506468, -83.348394),
    "48335": (42.461669, -83.405333),
    "48336": (42.465635, -83.363784),
    "48340": (42.670272, -83.289036),
    "48341": (42.633716, -83.291471),
    "48342": (42.694224, -83.288516),
    "48343": (42.660091, -83.3863),
    "48346": (42.723851, -83.423242),
    "48347": (42.660091, -83.3863),
    "48348": (42.760507, -83.403984),
    "48350": (42.749639, -83.535805),
    "48353": (42.648484, -83.717806),
    "48356": (42.701111, -83.422549),
    "48357": (42.654444, -83.561306),
    "48359": (42.723081, -83.276903),
    "48360": (42.74288, -83.272037),
    "48361": (42.660091, -83.3863),
    "48362": (42.776329, -83.274778),
    "48363": (42.766093, -83.157643),
    "48366": (42.803277, -83.18412),
    "48367": (42.843653, -83.140608),
    "48370": (42.840328, -83.200206),
    "48371": (42.772209, -83.339754),
    "48374": (42.468959, -83.522221),
    "48375": (42.463569, -83.46663),
    "48376": (42.470984, -83.474785),
    "48377": (42.49917, -83.477335),
    "48380": (42.593161, -83.645451),
    "48381": (42.554322, -83.579098),
    "48382": (42.583382, -83.500878),
    "48383": (42.657698, -83.534444),
    "48386": (42.657843, -83.478714),
    "48387": (42.7253, -83.311605),
    "48390": (42.558183, -83.47726),
    "48391": (42.660091, -83.3863),
    "48393": (42.520533, -83.549145),
    "48397": (42.491736, -83.040222),
    "48398": (42.660091, -83.3863),
    "48401": (43.35159, -82.670835),
    "48410": (43.558856, -82.945483),
    "48411": (42.940019, -83.536923),
    "48412": (43.066173, -83.257592),
    "48413": (43.79455, -82.949138),
    "48414": (42.865732, -84.083097),
    "48415": (43.27849, -83.81449),
    "48416": (43.242602, -82.918819),
    "48417": (43.263947, -83.893403),
    "48418": (42.826333, -84.020577),
    "48419": (43.443662, -82.663858),
    "48420": (43.170497, -83.707374),
    "48421": (43.072417, -83.292729),
    "48422": (43.252807, -82.644104),
    "48423": (43.041994, -83.622843),
    "48426": (43.517467, -82.853426),
    "48427": (43.535064, -82.722491),
    "48428": (42.937629, -83.154685),
    "48429": (42.894936, -84.02596),
    "48430": (42.83333, -83.763433),
    "48432": (43.952572, -82.973268),
    "48433": (42.978274, -83.808006),
    "48434": (43.663206, -82.613319),
    "48435": (43.277734, -83.39199),
    "48436": (42.872466, -83.858445),
    "48437": (43.018423, -83.691666),
    "48438": (42.91884, -83.51249),
    "48439": (42.9227, -83.67376),
    "48440": (42.93062, -83.360013),
    "48441": (43.867295, -82.800293),
    "48442": (42.775922, -83.579384),
    "48444": (43.065642, -83.060893),
    "48445": (43.961537, -82.944266),
    "48446": (43.121459, -83.319558),
    "48449": (42.98966, -83.90026399999999),
    "48450": (43.392172, -82.78895),
    "48451": (42.825944, -83.811322),
    "48453": (43.357539, -83.002816),
    "48454": (43.20471, -82.810553),
    "48455": (42.942128, -83.29607),
    "48456": (43.651302, -82.756025),
    "48457": (43.003962, -83.873179),
    "48458": (43.120587, -83.692978),
    "48460": (43.109913, -83.998893),
    "48461": (43.112848, -83.250511),
    "48462": (42.835019, -83.42298),
    "48463": (43.157936, -83.529863),
    "48464": (43.211722, -83.405752),
    "48465": (43.614613, -82.707455),
    "48466": (43.274949, -82.807228),
    "48467": (43.99756, -83.052623),
    "48468": (43.944086, -82.907943),
    "48469": (43.458914, -82.566894),
    "48471": (43.374676, -82.858995),
    "48472": (43.40401, -82.951494),
    "48473": (42.950323, -83.812575),
    "48475": (43.80794, -83.023993),
    "48476": (42.940553, -84.032828),
    "48501": (42.965926, -83.780835),
    "48502": (43.015127, -83.694756),
    "48503": (43.010835, -83.69278),
    "48504": (43.020626, -83.697666),
    "48505": (43.076926, -83.690207),
    "48506": (43.065313, -83.631004),
    "48507": (42.982076, -83.734004),
    "48509": (43.025934, -83.604053),
    "48519": (42.985927, -83.613452),
    "48529": (42.974427, -83.662853),
    "48531": (43.002, -83.692507),
    "48532": (43.011127, -83.803045),
    "48550": (43.034927, -83.688706),
    "48551": (42.978995, -83.713124),
    "48552": (42.977895, -83.713074),
    "48553": (42.973627, -83.720306),
    "48554": (42.972244, -83.79463),
    "48555": (43.011277, -83.710756),
    "48556": (43.032677, -83.646255),
    "48557": (43.080578, -83.783675),
    "48559": (43.002, -83.692507),
    "48601": (43.41242, -83.886873),
    "48602": (43.42926, -84.056977),
    "48603": (43.460115, -84.026587),
    "48604": (43.482403, -83.969391),
    "48605": (43.458776, -84.051827),
    "48606": (43.348535, -84.032612),
    "48607": (43.431875, -83.933672),
    "48608": (43.348535, -84.032612),
    "48609": (43.38689, -84.092633),
    "48610": (44.324353, -84.162443),
    "48611": (43.639444, -84.059141),
    "48612": (43.965212, -84.436146),
    "48613": (43.92673, -84.105306),
    "48614": (43.237044, -84.288736),
    "48615": (43.38631, -84.46894),
    "48616": (43.329465, -84.136197),
    "48617": (43.976073, -84.739685),
    "48618": (43.720284, -84.52035),
    "48619": (44.756363, -84.046449),
    "48620": (43.777368, -84.381307),
    "48621": (44.689286, -84.011959),
    "48622": (43.951093, -84.866432),
    "48623": (43.496884, -84.102426),
    "48624": (44.032603, -84.429231),
    "48625": (44.005299, -84.85096),
    "48626": (43.428523, -84.230091),
    "48627": (44.387123, -84.701346),
    "48628": (43.770317, -84.4046),
    "48629": (44.351007, -84.733596),
    "48630": (44.332152, -84.71945),
    "48631": (43.688372, -84.026419),
    "48632": (43.914196, -84.867626),
    "48633": (43.958329, -84.919332),
    "48634": (43.771397, -84.051257),
    "48635": (44.377795, -84.072974),
    "48636": (44.622852, -84.14818),
    "48637": (43.389643, -84.309397),
    "48640": (43.626132, -84.33803),
    "48641": (43.538252, -84.387753),
    "48642": (43.68698, -84.280136),
    "48647": (44.662952, -84.089518),
    "48649": (43.165075, -84.207683),
    "48650": (43.839179, -84.038715),
    "48651": (44.343508, -84.647139),
    "48652": (43.868833, -84.228499),
    "48653": (44.394517, -84.611194),
    "48654": (44.334415, -84.190661),
    "48655": (43.25677, -84.180476),
    "48656": (44.359863, -84.543576),
    "48657": (43.712095, -84.399532),
    "48658": (43.979427, -83.900702),
    "48659": (44.079473, -83.956748),
    "48661": (44.33095, -84.202733),
    "48662": (43.379034, -84.419329),
    "48663": (43.467315, -83.975475),
    "48667": (43.647297, -84.387331),
    "48670": (43.637471, -84.256758),
    "48674": (43.612884, -84.197125),
    "48686": (43.647297, -84.387331),
    "48701": (43.582147, -83.546114),
    "48703": (44.063621, -83.686379),
    "48705": (44.678354, -83.599977),
    "48706": (43.608773, -83.953007),
    "48707": (43.737798, -83.933337),
    "48708": (43.559572, -83.820876),
    "48710": (43.556574, -83.994328),
    "48720": (43.815182, -83.341775),
    "48721": (44.794881, -83.34884),
    "48722": (43.343016, -83.832323),
    "48723": (43.489001, -83.385078),
    "48724": (43.465024, -83.925473),
    "48725": (43.84953, -83.232873),
    "48726": (43.586075, -83.293496),
    "48727": (43.28298, -83.178182),
    "48728": (44.705591, -83.78745),
    "48729": (43.491974, -83.198239),
    "48730": (44.349592, -83.562942),
    "48731": (43.826222, -83.141633),
    "48732": (43.601522, -83.778971),
    "48733": (43.534504, -83.573677),
    "48734": (43.353763, -83.756467),
    "48735": (43.599096, -83.340629),
    "48736": (43.49442, -83.624431),
    "48737": (44.57341, -83.708328),
    "48738": (44.557782, -83.338437),
    "48739": (44.358808, -83.764739),
    "48740": (44.656694, -83.41973),
    "48741": (43.398564, -83.195025),
    "48742": (44.65922, -83.454865),
    "48743": (44.441563, -83.851644),
    "48744": (43.344868, -83.367939),
    "48745": (44.578092, -83.591419),
    "48746": (43.297434, -83.47392),
    "48747": (43.529339, -83.762898),
    "48748": (44.280833, -83.71748),
    "48749": (44.065941, -83.846526),
    "48750": (44.422917, -83.550866),
    "48754": (43.768927, -83.228252),
    "48755": (43.84452, -83.241886),
    "48756": (44.291742, -83.985725),
    "48757": (43.478735, -83.619435),
    "48758": (43.407321, -83.676156),
    "48759": (43.73616, -83.381857),
    "48760": (43.285214, -83.261468),
    "48761": (44.472352, -83.959844),
    "48762": (44.792293, -83.489404),
    "48763": (44.277551, -83.677131),
    "48764": (44.266549, -83.519166),
    "48765": (44.110526, -83.701888),
    "48766": (44.104905, -83.865674),
    "48767": (43.649504, -83.452826),
    "48768": (43.404594, -83.561187),
    "48769": (43.327048, -83.657355),
    "48770": (44.262826, -83.688778),
    "48787": (43.334958, -83.749418),
    "48801": (43.298805, -84.63017),
    "48802": (43.389262, -84.666661),
    "48804": (43.640574, -84.847417),
    "48805": (42.599184, -84.371973),
    "48806": (43.204648, -84.494123),
    "48807": (43.161282, -84.433708),
    "48808": (42.819509, -84.483853),
    "48809": (42.98004, -85.128727),
    "48811": (43.279958, -85.05493),
    "48812": (43.413761, -84.975271),
    "48813": (42.574191, -84.838452),
    "48815": (42.835039, -85.252353),
    "48816": (42.757633, -83.938967),
    "48817": (42.995625, -84.140012),
    "48818": (43.267035, -84.95489),
    "48819": (42.549235, -84.273815),
    "48820": (42.85479, -84.616108),
    "48821": (42.654335, -84.654181),
    "48822": (42.85703, -84.759243),
    "48823": (42.737334, -84.503527),
    "48824": (42.728334, -84.488226),
    "48825": (42.723784, -84.464775),
    "48826": (42.599184, -84.371973),
    "48827": (42.590246, -84.797012),
    "48829": (43.401096, -85.022308),
    "48830": (43.363931, -84.836198),
    "48831": (43.08143, -84.445584),
    "48832": (43.408141, -84.775817),
    "48833": (42.944209, -84.600723),
    "48834": (43.292973, -85.045217),
    "48835": (42.993295, -84.761244),
    "48836": (42.641649, -84.054241),
    "48837": (42.700035, -84.766787),
    "48838": (43.282538, -85.077695),
    "48840": (42.750324, -84.378655),
    "48841": (42.983136, -84.229888),
    "48842": (42.639785, -84.506522),
    "48843": (42.630687, -83.910266),
    "48844": (42.603479, -83.911173),
    "48845": (43.090457, -84.896225),
    "48846": (42.973427, -85.090548),
    "48847": (43.249453, -84.60379),
    "48848": (42.879874, -84.313294),
    "48849": (42.827728, -85.143286),
    "48850": (43.398672, -85.175752),
    "48851": (42.956819, -84.958071),
    "48852": (43.350251, -85.051692),
    "48853": (43.099153, -84.68977),
    "48854": (42.574335, -84.460273),
    "48856": (43.197902, -84.730738),
    "48857": (42.844288, -84.136097),
    "48858": (43.636855, -84.807511),
    "48859": (43.564736, -84.847297),
    "48860": (43.046851, -84.900482),
    "48861": (42.724229, -84.916222),
    "48862": (43.356518, -84.497138),
    "48863": (42.603479, -83.911173),
    "48864": (42.719534, -84.425136),
    "48865": (43.078789, -85.102387),
    "48866": (43.015906, -84.52884),
    "48867": (42.982578, -84.184937),
    "48870": (43.113587, -85.007665),
    "48871": (43.162586, -84.679727),
    "48872": (42.823317, -84.211149),
    "48873": (42.970044, -84.916118),
    "48874": (43.186268, -84.601718),
    "48875": (42.883458, -84.965969),
    "48876": (42.643807, -84.729716),
    "48877": (43.382803, -84.816107),
    "48878": (43.709243, -84.770931),
    "48879": (42.979673, -84.581962),
    "48880": (43.324772, -84.603002),
    "48881": (42.93571, -85.20298),
    "48882": (42.803973, -84.295949),
    "48883": (43.530865, -84.756824),
    "48884": (43.206319, -85.069087),
    "48885": (43.235402, -85.191444),
    "48886": (43.341346, -85.177052),
    "48887": (42.944929, -85.074665),
    "48888": (43.289347, -85.059556),
    "48889": (43.26895, -84.660821),
    "48890": (42.703177, -84.896833),
    "48891": (43.294643, -84.955903),
    "48892": (42.656484, -84.200923),
    "48893": (43.67589, -84.977751),
    "48894": (42.932843, -84.808267),
    "48895": (42.680434, -84.271215),
    "48896": (43.530832, -84.906289),
    "48897": (42.697951, -85.133685),
    "48901": (42.599184, -84.371973),
    "48906": (42.755284, -84.562979),
    "48907": (42.596071, -84.838206),
    "48908": (42.596071, -84.838206),
    "48909": (42.599184, -84.371973),
    "48910": (42.703435, -84.518543),
    "48911": (42.680335, -84.543494),
    "48912": (42.740054, -84.524939),
    "48913": (42.599184, -84.371973),
    "48915": (42.738764, -84.571179),
    "48916": (42.599184, -84.371973),
    "48917": (42.722414, -84.652032),
    "48918": (42.599184, -84.371973),
    "48919": (42.728585, -84.551728),
    "48921": (42.723735, -84.555629),
    "48922": (42.732535, -84.558679),
    "48924": (42.599184, -84.371973),
    "48929": (42.732535, -84.558679),
    "48930": (42.732535, -84.558679),
    "48933": (42.731384, -84.553698),
    "48937": (42.748734, -84.559029),
    "48950": (42.599184, -84.371973),
    "48956": (42.732535, -84.558679),
    "48980": (42.599184, -84.371973),
    "49001": (42.261596, -85.510095),
    "49002": (42.193793, -85.563901),
    "49003": (42.245412, -85.529858),
    "49004": (42.306859, -85.56816),
    "49005": (42.323045, -85.493232),
    "49006": (42.292247, -85.633033),
    "49007": (42.242774, -85.560265),
    "49008": (42.263007, -85.618046),
    "49009": (42.299211, -85.592635),
    "49010": (42.539295, -85.894873),
    "49011": (42.119031, -85.214348),
    "49012": (42.353739, -85.346599),
    "49013": (42.312771, -86.096133),
    "49014": (42.303041, -85.13044),
    "49015": (42.219313, -85.229238),
    "49016": (42.246402, -85.004511),
    "49017": (42.367389, -85.194996),
    "49018": (42.246402, -85.004511),
    "49019": (42.245412, -85.529858),
    "49020": (42.246402, -85.004511),
    "49021": (42.514158, -85.014665),
    "49022": (42.14338, -86.348568),
    "49023": (42.001551, -86.715294),
    "49024": (42.197442, -85.619352),
    "49026": (42.367738, -85.964714),
    "49027": (42.346504, -86.072501),
    "49028": (41.880399, -85.162804),
    "49029": (42.130843, -85.1023),
    "49030": (41.839785, -85.365433),
    "49031": (41.904174, -85.999067),
    "49032": (41.904488, -85.479907),
    "49033": (42.235692, -85.090633),
    "49034": (42.226193, -85.363194),
    "49035": (42.595121, -85.308555),
    "49036": (41.905358, -85.058716),
    "49038": (42.147551, -86.365588),
    "49039": (42.224757, -86.372276),
    "49040": (41.977796, -85.351074),
    "49041": (42.245412, -85.529858),
    "49042": (41.936948, -85.533122),
    "49043": (42.28054, -86.266608),
    "49045": (42.174485, -86.071429),
    "49046": (42.532723, -85.384885),
    "49047": (41.961597, -86.019304),
    "49050": (42.605588, -85.339902),
    "49051": (42.1779, -85.234287),
    "49052": (42.13344, -85.342481),
    "49053": (42.303241, -85.395798),
    "49055": (42.357819, -85.859198),
    "49056": (42.367516, -86.07133),
    "49057": (42.218519, -86.052434),
    "49058": (42.639121, -85.28988),
    "49060": (42.500132, -85.396204),
    "49061": (41.885831, -85.833847),
    "49062": (42.36175, -85.814072),
    "49063": (42.393586, -86.209904),
    "49064": (42.214896, -86.047077),
    "49065": (42.185207, -86.011811),
    "49066": (42.028161, -85.35224),
    "49067": (42.008635, -85.857579),
    "49068": (42.265016, -84.948946),
    "49069": (42.204494, -84.949919),
    "49070": (42.537142, -85.626918),
    "49071": (42.244501, -85.805041),
    "49072": (42.009094, -85.449665),
    "49073": (42.621104, -85.197412),
    "49074": (42.245412, -85.529858),
    "49075": (41.918535, -85.452884),
    "49076": (42.559717, -84.922599),
    "49077": (42.245412, -85.529858),
    "49078": (42.486075, -85.724612),
    "49079": (42.243011, -85.930846),
    "49080": (42.479577, -85.633538),
    "49081": (42.171777, -85.617824),
    "49082": (41.949119, -85.032201),
    "49083": (42.376138, -85.454755),
    "49084": (42.178035, -86.38557),
    "49085": (41.977412, -86.533144),
    "49087": (42.135078, -85.656846),
    "49088": (42.254992, -85.424395),
    "49089": (42.000564, -85.225195),
    "49090": (42.363778, -86.138952),
    "49091": (41.842913, -85.478265),
    "49092": (42.13422, -84.972831),
    "49093": (41.928972, -85.538215),
    "49094": (42.025271, -85.078799),
    "49095": (41.936454, -85.885793),
    "49096": (42.639932, -85.004661),
    "49097": (42.17954, -85.473371),
    "49098": (42.161397, -86.271878),
    "49099": (41.859335, -85.553193),
    "49101": (41.949647, -86.475504),
    "49102": (41.954986, -86.2681),
    "49103": (41.907363, -86.472582),
    "49104": (42.001551, -86.715294),
    "49106": (41.942151, -86.544561),
    "49107": (41.841369, -86.429249),
    "49111": (42.027591, -86.299153),
    "49112": (41.807011, -85.997234),
    "49113": (41.81146, -86.499237),
    "49115": (41.877103, -86.630243),
    "49116": (41.833625, -86.662174),
    "49117": (41.79273, -86.746022),
    "49119": (41.868746, -86.547369),
    "49120": (41.844732, -86.421005),
    "49121": (42.001551, -86.715294),
    "49125": (41.899733, -86.571325),
    "49126": (42.029487, -86.378199),
    "49127": (42.00743, -86.508146),
    "49128": (41.827553, -86.600498),
    "49129": (41.825532, -86.684816),
    "49130": (41.800617, -85.866011),
    "49201": (42.248979, -84.421104),
    "49202": (42.275635, -84.398207),
    "49203": (42.186861, -84.46471),
    "49204": (42.252847, -84.213755),
    "49220": (41.985346, -84.314543),
    "49221": (41.889943, -84.065892),
    "49224": (42.2906, -84.792885),
    "49227": (41.956345999999996, -84.767913),
    "49228": (41.852645, -83.873899),
    "49229": (41.997944, -83.857925),
    "49230": (42.160388, -84.388821),
    "49232": (41.747377, -84.638542),
    "49233": (42.048091, -84.315009),
    "49234": (42.119607, -84.369085),
    "49235": (41.930577, -84.156209),
    "49236": (42.061881, -83.957586),
    "49237": (42.186022, -84.641897),
    "49238": (41.900279, -83.817849),
    "49239": (41.782499, -84.604662),
    "49240": (42.258533, -84.344285),
    "49241": (42.111258, -84.601588),
    "49242": (41.853903, -84.582913),
    "49245": (42.144355, -84.848182),
    "49246": (42.131129, -84.479081),
    "49247": (41.870383, -84.095955),
    "49248": (41.770362, -84.001125),
    "49249": (42.029587, -84.468662),
    "49250": (41.898745, -84.585577),
    "49251": (42.478186, -84.407118),
    "49252": (42.029101, -84.619228),
    "49253": (41.970384, -84.270369),
    "49254": (42.208747, -84.465922),
    "49255": (41.792652, -84.900917),
    "49256": (41.84736, -84.229012),
    "49257": (42.054795, -84.503905),
    "49258": (41.884795, -84.593491),
    "49259": (42.360385, -84.233087),
    "49261": (42.164338, -84.24575),
    "49262": (41.963943, -84.473084),
    "49263": (42.158189, -84.183828),
    "49264": (42.472836, -84.541672),
    "49265": (42.007537, -84.182082),
    "49266": (41.832935, -84.548539),
    "49267": (41.772724, -83.704835),
    "49268": (41.86957, -83.920024),
    "49269": (42.257902, -84.580681),
    "49270": (41.865026, -83.670689),
    "49271": (41.854948, -84.452585),
    "49272": (42.387785, -84.347636),
    "49274": (41.846897, -84.728441),
    "49275": (41.988026, -83.865674),
    "49276": (41.791517999999996, -83.814189),
    "49277": (42.384636, -84.465133),
    "49278": (41.912292, -84.32652),
    "49279": (41.775793, -84.112125),
    "49280": (41.79583, -84.186608),
    "49281": (42.023026, -84.379391),
    "49282": (42.050199, -84.392191),
    "49283": (42.272863, -84.605612),
    "49284": (42.37823, -84.630106),
    "49285": (42.496734, -84.24306),
    "49286": (42.008398, -83.922214),
    "49287": (42.02172, -84.064971),
    "49288": (41.743114, -84.447488),
    "49289": (41.768254, -84.107609),
    "49301": (42.963833, -85.482266),
    "49302": (42.856096, -85.402859),
    "49303": (43.272182, -85.854471),
    "49304": (43.929225, -85.840774),
    "49305": (43.737488, -85.166327),
    "49306": (43.074996, -85.563211),
    "49307": (43.683493, -85.3518),
    "49309": (43.712217, -85.860379),
    "49310": (43.552836, -84.966988),
    "49311": (42.633006, -85.643043),
    "49312": (43.666006, -85.791055),
    "49314": (42.731193, -85.840372),
    "49315": (42.835828, -85.664425),
    "49316": (42.81868, -85.524437),
    "49317": (43.071201, -85.480856),
    "49318": (43.234658, -85.840115),
    "49319": (43.175953, -85.514105),
    "49320": (43.755335, -85.278303),
    "49321": (43.081164, -85.679652),
    "49322": (43.359517, -85.353161),
    "49323": (42.721585, -85.788666),
    "49325": (42.738867, -85.364444),
    "49326": (43.310955, -85.21072),
    "49327": (43.539032, -85.850409),
    "49328": (42.623664, -85.780339),
    "49329": (43.382007, -85.442836),
    "49330": (43.23506, -85.670248),
    "49331": (42.969378, -85.384134),
    "49332": (43.60077, -85.31329),
    "49333": (42.670351, -85.427281),
    "49335": (42.736987, -85.663538),
    "49336": (43.52199, -85.423262),
    "49337": (43.444927, -85.73898),
    "49338": (43.72777, -85.365385),
    "49339": (43.368549, -85.473124),
    "49340": (43.637851, -85.198945),
    "49341": (43.132429, -85.551631),
    "49342": (43.691187, -85.318534),
    "49343": (43.258296, -85.504509),
    "49344": (42.612772, -85.612828),
    "49345": (43.157685, -85.683555),
    "49346": (43.590861, -85.403676),
    "49347": (43.330898, -85.414422),
    "49348": (42.685065, -85.642406),
    "49349": (43.611483, -85.797989),
    "49351": (43.031413, -85.550267),
    "49355": (43.031413, -85.550267),
    "49356": (43.031413, -85.550267),
    "49357": (43.031413, -85.550267),
    "49401": (42.979522, -85.93927),
    "49402": (43.967633, -85.980028),
    "49403": (43.118172, -85.848391),
    "49404": (43.062122, -85.959758),
    "49405": (43.932434, -86.177683),
    "49406": (42.636883, -86.202158),
    "49408": (42.542809, -86.11849),
    "49409": (43.080865, -86.215413),
    "49410": (44.030126, -86.142483),
    "49411": (44.071924, -86.252729),
    "49412": (43.513456, -85.9132),
    "49413": (43.554311, -85.800884),
    "49415": (43.275502, -86.07655),
    "49416": (42.630533, -86.072032),
    "49417": (43.008786, -86.129031),
    "49418": (42.882726, -85.753056),
    "49419": (42.693859, -85.980959),
    "49420": (43.700968, -86.334122),
    "49421": (43.574326, -86.223175),
    "49422": (42.985596, -86.444751),
    "49423": (42.812579, -86.037218),
    "49424": (42.924578, -86.121901),
    "49425": (43.417206, -86.130268),
    "49426": (42.861575, -85.935917),
    "49427": (42.826676, -85.844378),
    "49428": (42.918544, -85.842586),
    "49429": (42.985596, -86.444751),
    "49430": (43.010337, -85.89754),
    "49431": (43.998926, -86.349439),
    "49434": (42.76973, -86.205471),
    "49435": (43.023673, -85.844039),
    "49436": (43.681533, -86.468975),
    "49437": (43.42404, -86.339517),
    "49440": (43.233764, -86.232858),
    "49441": (43.245871, -86.264015),
    "49442": (43.237314, -86.14768),
    "49443": (43.295493, -86.468853),
    "49444": (43.245821, -86.185694),
    "49445": (43.295208, -86.278985),
    "49446": (43.536651, -86.322856),
    "49448": (43.080186, -86.068544),
    "49449": (43.728586, -86.291994),
    "49450": (42.483692, -86.06653),
    "49451": (43.20596, -85.968106),
    "49452": (43.626346, -86.233687),
    "49453": (42.645611, -86.165451),
    "49454": (43.940385, -86.26351),
    "49455": (43.638343, -86.349283),
    "49456": (43.076609, -86.19538),
    "49457": (43.358015, -86.157722),
    "49458": (43.949422, -86.10421),
    "49459": (43.721873, -86.141107),
    "49460": (42.929518, -86.095232),
    "49461": (43.345831, -86.327092),
    "49463": (43.295493, -86.468853),
    "49464": (42.869816, -85.969722),
    "49468": (43.031413, -85.550267),
    "49501": (42.984226, -85.629101),
    "49502": (43.031413, -85.550267),
    "49503": (42.956176, -85.660693),
    "49504": (42.973687, -85.726496),
    "49505": (43.017776, -85.611596),
    "49506": (42.943577, -85.577113),
    "49507": (42.930777, -85.656978),
    "49508": (42.889378, -85.621876),
    "49509": (42.899917, -85.710077),
    "49510": (43.031413, -85.550267),
    "49512": (42.880192, -85.535214),
    "49514": (43.031413, -85.550267),
    "49515": (43.031413, -85.550267),
    "49516": (43.031413, -85.550267),
    "49518": (43.031413, -85.550267),
    "49523": (43.031413, -85.550267),
    "49525": (43.013527, -85.602729),
    "49530": (43.031413, -85.550267),
    "49544": (43.007274, -85.725535),
    "49546": (42.930146, -85.53904),
    "49548": (42.864793, -85.615175),
    "49550": (43.031413, -85.550267),
    "49555": (43.031413, -85.550267),
    "49560": (43.031413, -85.550267),
    "49588": (43.031413, -85.550267),
    "49599": (43.031413, -85.550267),
    "49601": (44.335278, -85.549093),
    "49610": (44.789382, -85.488449),
    "49611": (44.983262, -84.961776),
    "49612": (44.900641, -85.232932),
    "49613": (44.478837, -86.209391),
    "49614": (44.396671, -86.116727),
    "49615": (44.997248, -85.198742),
    "49616": (44.574478, -86.07937),
    "49617": (44.630634, -86.002509),
    "49618": (44.289721, -85.675458),
    "49619": (44.309195, -85.972541),
    "49620": (44.465123, -85.681485),
    "49621": (44.860517, -85.813768),
    "49622": (45.075986, -85.25591),
    "49623": (43.95217, -85.672695),
    "49625": (44.42757, -86.028192),
    "49626": (44.241337, -86.291309),
    "49627": (45.08806, -85.3219),
    "49628": (44.599526, -86.21407),
    "49629": (44.92902, -85.319467),
    "49630": (44.837888, -85.976477),
    "49631": (43.958084, -85.302063),
    "49632": (44.242162, -85.043655),
    "49633": (44.584533, -85.393948),
    "49634": (44.238191, -86.057975),
    "49635": (44.613058, -86.177255),
    "49636": (44.873421, -85.98867),
    "49637": (44.634126, -85.703494),
    "49638": (44.280319, -85.710694),
    "49639": (43.981883, -85.360457),
    "49640": (44.690037, -86.050384),
    "49642": (43.887179, -85.775872),
    "49643": (44.633562, -85.782278),
    "49644": (44.091983, -85.90658),
    "49645": (44.377928, -86.041189),
    "49646": (44.697144, -85.092905),
    "49648": (45.006971, -85.355394),
    "49649": (44.577555, -85.530156),
    "49650": (44.722002, -85.882364),
    "49651": (44.376692, -85.0946),
    "49653": (44.980451, -85.736199),
    "49654": (44.989416, -85.770227),
    "49655": (44.013375, -85.32548),
    "49656": (44.04206, -85.712873),
    "49657": (44.258292, -85.154382),
    "49659": (44.947938, -85.122624),
    "49660": (44.263534, -86.182473),
    "49663": (44.412765, -85.468268),
    "49664": (44.869321, -85.902284),
    "49665": (43.989936, -85.271121),
    "49666": (44.625041, -85.542496),
    "49667": (44.343261, -84.944639),
    "49668": (44.39912, -85.629669),
    "49670": (45.12216, -85.61847),
    "49673": (44.955872, -85.490005),
    "49674": (45.066568, -85.597374),
    "49675": (44.418184, -86.222187),
    "49676": (44.80389, -85.250629),
    "49677": (43.952029, -85.414718),
    "49679": (43.963767, -85.187258),
    "49680": (44.634438, -85.252891),
    "49682": (44.988569, -85.644068),
    "49683": (44.58678, -85.931969),
    "49684": (44.693963, -85.676342),
    "49685": (44.816178, -85.575147),
    "49686": (44.784919, -85.490673),
    "49688": (44.112055, -85.405091),
    "49689": (44.330169, -86.027194),
    "49690": (44.767181, -85.427605),
    "49696": (44.816178, -85.575147),
    "49701": (45.753019, -84.691745),
    "49705": (45.366479, -84.429893),
    "49706": (45.539802, -84.805792),
    "49707": (45.033143, -83.495091),
    "49709": (45.030626, -84.173067),
    "49710": (46.278437, -84.196899),
    "49711": (45.523425, -85.332038),
    "49712": (45.226478, -85.016896),
    "49713": (45.203875, -84.848126),
    "49715": (46.389131, -84.698136),
    "49716": (45.506991, -84.703893),
    "49717": (45.430705, -84.691207),
    "49718": (45.59626, -84.851386),
    "49719": (46.007211, -84.276199),
    "49720": (45.26536, -85.229723),
    "49721": (45.592842, -84.468639),
    "49722": (45.423616, -84.852401),
    "49723": (45.625353, -85.041872),
    "49724": (46.311604, -84.617131),
    "49725": (45.997182, -83.923941),
    "49726": (46.011531, -83.692502),
    "49727": (45.203995, -85.102843),
    "49728": (46.536871, -84.862889),
    "49729": (45.156457, -85.303853),
    "49730": (45.02396, -84.755439),
    "49733": (44.786738, -84.697844),
    "49734": (45.028411, -84.612207),
    "49735": (45.000937, -84.624586),
    "49736": (46.078984, -84.144989),
    "49737": (45.580183, -85.113678),
    "49738": (44.691777, -84.612941),
    "49739": (44.682996, -84.610441),
    "49740": (45.55423, -84.925826),
    "49743": (45.283467, -83.873719),
    "49744": (44.996329, -83.667641),
    "49745": (46.021715, -84.42845),
    "49746": (45.05958, -84.022691),
    "49747": (44.909723, -83.608911),
    "49748": (46.390752, -85.176386),
    "49749": (45.447209, -84.578019),
    "49751": (44.963223, -84.505983),
    "49752": (46.259604, -84.647332),
    "49753": (45.013075, -83.76195799999999),
    "49755": (45.592565, -84.86323),
    "49756": (44.91306, -84.21857),
    "49757": (45.853721, -84.618203),
    "49759": (45.430946, -84.085375),
    "49760": (46.07039, -84.992591),
    "49761": (45.559536, -84.522098),
    "49762": (46.109525, -85.34592),
    "49764": (45.480257, -84.814645),
    "49765": (45.363283, -83.871571),
    "49766": (45.028249, -83.53661),
    "49768": (46.595083, -85.097324),
    "49769": (45.566112, -84.863241),
    "49770": (45.355915, -84.913255),
    "49774": (46.179987, -84.315417),
    "49775": (45.969075, -84.991195),
    "49776": (45.278913, -83.734615),
    "49777": (45.283057, -83.586073),
    "49778": (46.410777, -84.336519),
    "49779": (45.384168, -83.74985),
    "49780": (46.258514, -84.800411),
    "49781": (45.99852, -84.697818),
    "49782": (45.668447, -85.547299),
    "49783": (46.357439, -84.587315),
    "49784": (46.410777, -84.336519),
    "49785": (46.181451, -84.405367),
    "49786": (46.410777, -84.336519),
    "49788": (46.288432, -84.541577),
    "49790": (46.387377, -84.966792),
    "49791": (45.483842, -84.593561),
    "49792": (45.358825, -84.295283),
    "49793": (46.215929, -85.006769),
    "49795": (45.139667, -84.552604),
    "49796": (45.245371, -84.938228),
    "49797": (44.870233999999996, -84.659847),
    "49799": (45.326831, -84.549533),
    "49801": (46.021627, -87.874496),
    "49802": (45.807905, -88.084302),
    "49805": (47.287939, -88.412893),
    "49806": (46.444586, -86.911506),
    "49807": (45.695595, -87.207306),
    "49808": (46.770788, -87.672566),
    "49812": (45.601899, -87.519075),
    "49813": (45.443789, -87.401604),
    "49814": (46.466637, -87.920429),
    "49815": (46.17823, -87.934279),
    "49816": (46.336962, -86.993579),
    "49817": (45.915778, -86.473246),
    "49818": (45.910352, -87.20714),
    "49819": (46.604141, -87.614805),
    "49820": (46.159286, -85.699294),
    "49821": (45.524441, -87.614772),
    "49822": (46.426964, -87.049704),
    "49825": (46.329926, -87.013761),
    "49826": (46.348071, -87.043622),
    "49827": (46.169384, -85.587976),
    "49829": (45.851343, -87.057049),
    "49831": (46.022634, -87.793865),
    "49833": (46.279714, -87.331099),
    "49834": (45.939891, -87.805995),
    "49835": (45.756636, -86.586125),
    "49836": (46.042076, -86.235756),
    "49837": (45.881256, -87.115221),
    "49838": (46.074658, -85.733841),
    "49839": (46.668806000000004, -85.964145),
    "49840": (46.042076, -86.235756),
    "49841": (46.331119, -87.439658),
    "49845": (45.692178, -87.351342),
    "49847": (45.700102, -87.642374),
    "49848": (45.371769, -87.623735),
    "49849": (46.43869, -87.709096),
    "49852": (45.827514, -87.776381),
    "49853": (46.347592, -85.658525),
    "49854": (46.006223, -86.25549),
    "49855": (46.593435, -87.615282),
    "49858": (45.228959, -87.56772),
    "49861": (46.530795, -88.091432),
    "49862": (46.414779, -86.460319),
    "49863": (45.608658, -87.56331),
    "49864": (45.842437, -86.655849),
    "49865": (46.604141, -87.614805),
    "49866": (46.494904, -87.799518),
    "49868": (46.460159, -85.515605),
    "49870": (45.857201, -87.917602),
    "49871": (46.441565, -87.576355),
    "49872": (45.992475999999996, -87.079231),
    "49873": (45.84102, -87.481565),
    "49874": (45.703409, -87.512409),
    "49876": (45.80759, -87.959862),
    "49877": (46.129666, -87.736665),
    "49878": (45.913952, -86.804734),
    "49879": (46.36558, -87.89039),
    "49880": (46.057396, -87.122594),
    "49881": (46.074737, -88.039613),
    "49883": (46.042076, -86.235756),
    "49884": (46.434256, -86.367899),
    "49885": (46.396896, -87.300505),
    "49886": (45.677744, -87.485236),
    "49887": (45.447416, -87.61396),
    "49891": (46.238695, -87.014443),
    "49892": (45.830389, -87.807258),
    "49893": (45.295383, -87.585611),
    "49894": (45.788216, -87.078454),
    "49895": (46.291471, -86.671351),
    "49896": (45.679339, -87.389877),
    "49901": (47.293287, -88.389708),
    "49902": (46.030951, -88.377097),
    "49903": (46.249415, -88.417593),
    "49905": (47.072716, -88.634939),
    "49908": (46.80476, -88.575842),
    "49910": (46.585302, -89.517464),
    "49911": (46.423427, -89.992677),
    "49912": (46.475105, -89.222897),
    "49913": (47.154742, -88.525475),
    "49915": (46.065734, -88.630972),
    "49916": (47.020152, -88.572499),
    "49917": (47.284183, -88.387535),
    "49918": (47.471616, -87.946283),
    "49919": (46.526495, -88.584598),
    "49920": (46.143009, -88.376197),
    "49921": (47.092838, -88.583578),
    "49922": (47.120346, -88.461337),
    "49925": (46.548352, -89.365311),
    "49927": (46.035213, -88.56094),
    "49929": (46.780865, -89.114601),
    "49930": (47.156614, -88.558554),
    "49931": (47.105336, -88.548157),
    "49934": (47.167087, -88.466785),
    "49935": (46.12047, -88.618995),
    "49938": (46.479574, -90.167111),
    "49942": (47.269416, -88.41841),
    "49945": (47.162481, -88.503108),
    "49946": (46.740227, -88.44705),
    "49947": (46.379315, -89.612621),
    "49948": (46.722794, -89.051191),
    "49950": (47.352566, -88.288905),
    "49952": (46.774818, -88.879888),
    "49953": (46.73807, -89.334696),
    "49955": (47.04038, -88.670361),
    "49958": (46.7402, -88.7479),
    "49959": (46.472742, -89.99761),
    "49960": (46.753715, -89.195837),
    "49961": (46.501487, -88.79715),
    "49962": (46.867128, -88.139072),
    "49963": (47.071862, -88.651973),
    "49964": (46.079655, -88.629006),
    "49965": (46.910918, -88.85321),
    "49967": (46.4931, -89.085164),
    "49968": (46.490844, -89.875182),
    "49969": (46.22184, -89.240577),
    "49970": (46.731668, -88.335388),
    "49971": (46.782698, -89.597404),
    "50001": (41.384345, -93.424294),
    "50002": (41.439109, -94.633805),
    "50003": (41.617591, -94.034515),
    "50005": (42.143933, -92.961868),
    "50006": (42.430997, -93.390638),
    "50007": (41.813089, -93.609929),
    "50008": (40.672872, -93.405589),
    "50009": (41.65097, -93.4685),
    "50010": (42.037879, -93.600254),
    "50011": (42.035998, -93.465172),
    "50012": (42.023557, -93.648465),
    "50015": (41.672687, -93.572173),
    "50020": (41.390677, -94.813882),
    "50021": (41.756321, -93.601467),
    "50022": (41.381871, -94.960765),
    "50025": (41.704535, -94.918652),
    "50026": (41.827251, -94.449511),
    "50027": (41.46974, -92.487177),
    "50028": (41.811839, -93.159506),
    "50029": (41.6872, -94.528322),
    "50031": (42.038746, -94.143566),
    "50032": (41.665838, -93.54323),
    "50033": (41.334078, -94.015337),
    "50034": (42.485099, -93.68778),
    "50035": (41.730186, -93.45694),
    "50036": (42.0425, -93.904897),
    "50037": (42.036552, -93.931686),
    "50038": (41.630419, -93.946297),
    "50039": (41.82003, -94.00881),
    "50040": (42.161647, -94.088499),
    "50041": (42.600335, -93.223204),
    "50042": (41.54069, -94.878382),
    "50043": (42.417866, -93.375544),
    "50044": (41.211897, -93.054149),
    "50046": (41.914036, -93.51988),
    "50047": (41.416785, -93.520445),
    "50048": (41.576333, -94.521205),
    "50049": (41.046868, -93.309464),
    "50050": (42.141856, -94.503538),
    "50051": (42.11412, -93.149072),
    "50052": (40.634202, -93.447953),
    "50054": (41.684506999999996, -93.222321),
    "50055": (41.906479, -93.294572),
    "50056": (42.000921, -93.380733),
    "50057": (41.196557, -93.159664),
    "50058": (41.957228, -94.735083),
    "50059": (42.036334, -94.396956),
    "50060": (40.777093, -93.327355),
    "50061": (41.468663, -93.745358),
    "50062": (41.334487, -93.14778),
    "50063": (41.713107, -93.930807),
    "50064": (42.100422, -94.230723),
    "50065": (40.634604, -93.8105),
    "50066": (41.800769, -94.202714),
    "50067": (40.743001, -93.831719),
    "50068": (41.029481, -93.327475),
    "50069": (41.521176, -94.107532),
    "50070": (41.531827, -94.205252),
    "50071": (42.651566, -93.582732),
    "50072": (41.43059, -94.107202),
    "50073": (41.783265, -93.5171),
    "50074": (40.846834, -94.088656),
    "50075": (42.325487, -93.55153),
    "50076": (41.589212, -94.870749),
    "50078": (41.937357, -92.865043),
    "50101": (42.666494, -93.627104),
    "50102": (42.235432, -93.373262),
    "50103": (40.736644, -93.785839),
    "50104": (41.480854, -92.371164),
    "50105": (42.114752, -93.63986),
    "50106": (41.987443999999996, -92.963098),
    "50107": (42.035745, -94.242288),
    "50108": (40.819397, -93.962986),
    "50109": (41.761574, -93.853297),
    "50110": (41.840109, -94.981191),
    "50111": (41.652116, -93.600453),
    "50112": (41.685324, -92.630258),
    "50115": (41.683516, -94.559702),
    "50116": (41.189953, -92.95896),
    "50117": (41.746719, -94.847093),
    "50118": (41.439093, -93.36963),
    "50119": (41.299888, -92.928147),
    "50120": (41.938248, -92.968108),
    "50122": (42.303338, -93.329584),
    "50123": (40.80286, -93.518445),
    "50124": (41.906086, -93.616342),
    "50125": (41.314309, -93.588041),
    "50126": (42.43026, -93.253363),
    "50127": (41.777174, -93.21383),
    "50128": (41.820851, -94.319081),
    "50129": (42.007323, -94.372586),
    "50130": (42.339466, -93.721503),
    "50131": (41.714435, -93.732559),
    "50132": (42.390667, -93.684048),
    "50133": (40.709922, -94.049307),
    "50134": (41.932278, -93.654229),
    "50135": (41.706656, -93.023296),
    "50136": (41.455621, -92.288871),
    "50137": (41.659444, -92.939073),
    "50138": (41.295893, -93.104232),
    "50139": (41.218741, -93.414713),
    "50140": (40.618769, -93.927187),
    "50141": (41.898521, -92.967122),
    "50142": (42.020946, -92.775909),
    "50143": (41.338137, -92.794397),
    "50144": (40.740697, -93.748889),
    "50145": (41.207133, -93.499347),
    "50146": (41.674068, -94.203105),
    "50147": (40.586053, -93.523318),
    "50148": (42.175223, -92.969854),
    "50149": (41.108111, -94.102318),
    "50150": (41.028469, -92.976822),
    "50151": (41.004925, -93.492145),
    "50152": (41.938679, -93.837061),
    "50153": (41.60565, -92.846323),
    "50154": (42.158029, -93.395647),
    "50155": (41.210365, -94.182509),
    "50156": (41.92886, -93.797086),
    "50157": (41.732036, -92.512822),
    "50158": (42.036096, -92.998867),
    "50160": (41.385401, -93.741773),
    "50161": (41.920999, -93.395946),
    "50162": (42.035719, -93.115647),
    "50163": (41.242194, -93.173193),
    "50164": (41.553004, -94.395245),
    "50165": (40.843741, -93.362185),
    "50166": (41.283124, -93.428847),
    "50167": (41.732252, -94.047607),
    "50168": (41.775852, -93.246431),
    "50169": (41.626952, -93.373903),
    "50170": (41.569003, -93.101184),
    "50171": (41.605693, -92.473857),
    "50173": (41.95619, -92.712756),
    "50174": (41.026682, -93.925695),
    "50177": (41.685742, -92.532032),
    "50197": (41.334549, -93.099205),
    "50198": (41.334549, -93.099205),
    "50201": (42.00207, -93.503866),
    "50206": (42.272076, -93.256399),
    "50207": (41.393559, -92.634295),
    "50208": (41.718107, -93.012335),
    "50210": (41.319061, -93.672017),
    "50211": (41.442071, -93.667713),
    "50212": (42.043714, -94.052358),
    "50213": (41.029937, -93.775845),
    "50214": (41.426958, -93.030605),
    "50216": (41.650933, -94.425111),
    "50217": (42.166202, -94.280982),
    "50218": (41.349901, -93.880265),
    "50219": (41.341915, -93.092797),
    "50220": (41.790296, -94.06178),
    "50222": (41.221731, -93.962334),
    "50223": (42.059677, -94.040876),
    "50225": (41.351116, -93.23362),
    "50226": (41.75673, -93.698063),
    "50227": (42.644276, -93.450081),
    "50228": (41.590964, -93.234793),
    "50229": (41.368045, -93.703126),
    "50230": (42.310875, -93.347563),
    "50231": (42.240121, -93.628266),
    "50232": (41.560308, -92.981908),
    "50233": (41.621146, -94.212048),
    "50234": (41.906231, -93.154445),
    "50235": (41.928403, -94.222127),
    "50236": (42.161972, -93.496057),
    "50237": (41.561367, -93.398946),
    "50238": (40.981221, -93.200472),
    "50239": (42.140911, -93.174505),
    "50240": (41.289336, -93.862695),
    "50241": (41.308413, -93.736916),
    "50242": (41.569631, -92.654204),
    "50243": (41.857068, -93.697325),
    "50244": (41.8925, -93.664006),
    "50246": (42.296671, -93.776637),
    "50247": (42.02551, -93.144785),
    "50248": (42.158072, -93.610141),
    "50249": (42.296737, -93.721315),
    "50250": (41.573966, -94.339598),
    "50251": (41.576832, -92.924355),
    "50252": (41.457722, -93.219421),
    "50254": (40.978688, -94.10039),
    "50255": (41.336267, -92.178366),
    "50256": (41.263991, -92.938838),
    "50257": (41.206381, -93.863473),
    "50258": (42.252265, -93.089028),
    "50259": (42.383133, -93.250567),
    "50261": (41.658215, -93.944641),
    "50262": (40.736644, -93.785839),
    "50263": (41.59896, -93.875317),
    "50264": (40.885821, -93.761591),
    "50265": (41.567138, -93.717232),
    "50266": (41.653027, -93.747073),
    "50268": (41.396307, -92.331335),
    "50269": (42.271774, -93.021413),
    "50271": (42.477733, -93.554643),
    "50272": (41.029481, -93.327475),
    "50273": (41.351621, -94.042219),
    "50274": (41.374394, -94.904879),
    "50275": (41.029822, -93.614875),
    "50276": (41.776121, -93.955694),
    "50277": (41.775934, -94.357971),
    "50278": (42.149851, -93.29898),
    "50301": (41.672687, -93.572173),
    "50302": (41.672687, -93.572173),
    "50303": (41.672687, -93.572173),
    "50304": (41.672687, -93.572173),
    "50305": (41.672687, -93.572173),
    "50306": (41.672687, -93.572173),
    "50307": (41.672687, -93.572173),
    "50308": (41.672687, -93.572173),
    "50309": (41.584089, -93.620267),
    "50310": (41.623438, -93.680954),
    "50311": (41.63998, -93.71657),
    "50312": (41.582645, -93.691719),
    "50313": (41.643316, -93.621343),
    "50314": (41.603938, -93.613817),
    "50315": (41.545107, -93.620917),
    "50316": (41.609988, -93.600816),
    "50317": (41.612221, -93.529588),
    "50318": (41.672687, -93.572173),
    "50319": (41.592089, -93.603967),
    "50320": (41.544539, -93.582366),
    "50321": (41.546945, -93.659668),
    "50322": (41.630449, -93.753628),
    "50323": (41.62938, -93.771676),
    "50325": (41.607588, -93.744905),
    "50328": (41.672687, -93.572173),
    "50329": (41.672687, -93.572173),
    "50330": (41.672687, -93.572173),
    "50331": (41.672687, -93.572173),
    "50332": (41.672687, -93.572173),
    "50333": (41.672687, -93.572173),
    "50334": (41.672687, -93.572173),
    "50335": (41.672687, -93.572173),
    "50336": (41.672687, -93.572173),
    "50338": (41.672687, -93.572173),
    "50339": (41.672687, -93.572173),
    "50340": (41.672687, -93.572173),
    "50347": (41.672687, -93.572173),
    "50350": (41.672687, -93.572173),
    "50359": (41.672687, -93.572173),
    "50360": (41.672687, -93.572173),
    "50361": (41.672687, -93.572173),
    "50362": (41.672687, -93.572173),
    "50363": (41.672687, -93.572173),
    "50364": (41.672687, -93.572173),
    "50367": (41.672687, -93.572173),
    "50368": (41.672687, -93.572173),
    "50369": (41.672687, -93.572173),
    "50380": (41.672687, -93.572173),
    "50381": (41.672687, -93.572173),
    "50391": (41.672687, -93.572173),
    "50392": (41.587839, -93.627368),
    "50393": (41.672687, -93.572173),
    "50394": (41.672687, -93.572173),
    "50395": (41.672687, -93.572173),
    "50396": (41.672687, -93.572173),
    "50397": (41.672687, -93.572173),
    "50398": (41.594543, -93.785502),
    "50401": (43.116477, -93.270559),
    "50402": (43.081604, -93.260879),
    "50420": (42.819841, -93.429379),
    "50421": (42.783801, -93.712614),
    "50423": (43.081779, -93.734689),
    "50424": (43.37731, -93.803062),
    "50426": (43.414935, -93.002846),
    "50427": (42.834852, -93.222587),
    "50428": (43.100399, -93.260676),
    "50430": (42.980309, -93.872724),
    "50431": (42.738164, -93.369996),
    "50432": (43.21835, -93.800697),
    "50433": (43.053101, -93.261024),
    "50434": (43.299228, -93.28496),
    "50435": (43.136067, -92.77932),
    "50436": (43.299419, -93.684781),
    "50438": (43.089116, -93.734009),
    "50439": (43.074783, -93.675089),
    "50440": (43.320548, -93.200006),
    "50441": (42.731454, -93.230657),
    "50444": (43.32067, -93.378938),
    "50446": (43.353565, -93.3832),
    "50447": (43.069212, -93.734839),
    "50448": (43.359809, -93.240306),
    "50449": (42.991727, -93.566985),
    "50450": (43.408993, -93.567204),
    "50451": (43.366038, -94.10309),
    "50452": (42.782628, -93.389744),
    "50453": (43.342548, -93.689464),
    "50454": (43.385605, -92.738099),
    "50455": (43.457197, -92.63316),
    "50456": (43.342237, -93.271287),
    "50457": (43.059175, -93.292969),
    "50458": (43.149677, -92.974488),
    "50459": (43.428355, -93.261042),
    "50460": (43.234006, -92.686031),
    "50461": (43.320773, -92.789683),
    "50464": (43.234199, -93.082854),
    "50465": (43.464673, -93.872202),
    "50466": (43.381795, -92.475226),
    "50467": (43.206593, -93.08574),
    "50468": (43.016911, -92.907599),
    "50469": (43.00211, -93.181709),
    "50470": (42.724794, -93.558042),
    "50471": (43.128382, -92.887374),
    "50472": (43.406399, -92.810582),
    "50473": (43.457336, -93.674587),
    "50475": (42.732312, -93.262211),
    "50476": (43.435628, -92.853243),
    "50477": (42.984273, -93.35609),
    "50478": (43.406406, -93.748603),
    "50479": (43.077155, -93.312569),
    "50480": (43.253389, -94.05929),
    "50481": (43.356439, -92.788967),
    "50482": (43.111474, -93.467873),
    "50483": (43.103297, -94.029455),
    "50484": (43.197698, -93.881521),
    "50501": (42.438596, -94.166587),
    "50510": (42.735002, -95.151118),
    "50511": (43.109313, -94.166994),
    "50514": (43.407517, -94.531703),
    "50515": (43.01825, -94.855316),
    "50516": (42.601287, -94.148103),
    "50517": (43.306166, -94.251434),
    "50518": (42.552043, -94.369181),
    "50519": (42.863891, -94.295698),
    "50520": (42.801126, -94.358387),
    "50521": (42.346605, -94.116205),
    "50522": (43.183395, -94.177422),
    "50523": (42.347134, -94.280864),
    "50524": (42.514307, -94.212455),
    "50525": (42.703045, -93.745623),
    "50526": (42.733001, -93.73523),
    "50527": (42.970187, -94.769596),
    "50528": (43.124819, -94.531189),
    "50529": (42.73695, -94.243675),
    "50530": (42.281924, -94.110777),
    "50531": (43.449975, -94.610236),
    "50532": (42.463053, -94.016459),
    "50533": (42.646337, -93.882675),
    "50535": (42.458243, -95.16624),
    "50536": (43.118345, -94.690755),
    "50538": (42.279298, -94.465144),
    "50539": (43.241336, -94.384458),
    "50540": (42.646211, -94.797046),
    "50541": (42.720638, -94.393684),
    "50542": (42.785534, -93.91222),
    "50543": (42.325308, -94.25193),
    "50544": (42.260243, -94.16463),
    "50545": (42.797529, -94.079932),
    "50546": (42.842446, -94.721926),
    "50548": (42.775833, -94.207763),
    "50551": (42.487057, -94.756959),
    "50552": (42.42361, -94.458642),
    "50554": (42.821248, -94.835889),
    "50556": (43.443079, -94.187319),
    "50557": (42.390452, -94.048108),
    "50558": (42.841534, -94.163578),
    "50559": (43.219959, -94.309997),
    "50560": (42.976166, -94.124477),
    "50561": (42.421312, -94.821328),
    "50562": (42.973755, -94.644417),
    "50563": (42.50089, -94.57695),
    "50565": (42.858254, -94.9984),
    "50566": (42.440996, -94.315601),
    "50567": (42.509655, -95.104435),
    "50568": (42.705762, -95.003782),
    "50569": (42.437722, -94.220655),
    "50570": (42.841797, -94.374343),
    "50571": (42.645733, -94.560735),
    "50573": (42.864825, -94.619745),
    "50574": (42.726507, -94.650755),
    "50575": (42.519205, -94.678445),
    "50576": (42.825241, -95.141444),
    "50577": (42.844755, -94.1314),
    "50578": (43.31281, -94.560669),
    "50579": (42.393114, -94.633664),
    "50581": (42.744133, -94.642302),
    "50582": (42.79315, -94.305614),
    "50583": (42.439752, -94.992967),
    "50585": (42.757096, -95.103677),
    "50586": (42.386479, -94.454529),
    "50588": (42.693184, -95.151811),
    "50590": (43.283285, -94.295584),
    "50591": (42.77609, -94.059946),
    "50592": (42.726167, -95.185325),
    "50593": (42.659794, -94.897858),
    "50594": (42.581749, -94.030651),
    "50595": (42.434161, -93.825581),
    "50597": (43.002465, -94.501553),
    "50598": (43.082501, -94.389877),
    "50599": (42.600976, -93.794414),
    "50601": (42.408805, -93.09251),
    "50602": (42.697108, -92.7981),
    "50603": (43.13992, -92.424719),
    "50604": (42.657249, -92.895287),
    "50605": (42.804004, -92.985938),
    "50606": (42.752653, -91.69556),
    "50607": (42.570346, -91.748063),
    "50608": (42.58243, -92.95988),
    "50609": (42.260476, -92.806788),
    "50611": (42.811045, -92.882596),
    "50612": (42.271906, -92.388908),
    "50613": (42.517091, -92.43585),
    "50614": (42.469768, -92.309475),
    "50616": (43.059926, -92.789058),
    "50619": (42.793119, -92.653238),
    "50620": (43.110765, -92.744821),
    "50621": (42.261859, -92.913373),
    "50622": (42.686195, -92.387102),
    "50623": (42.525282, -92.220701),
    "50624": (42.377438, -92.713296),
    "50625": (42.753663, -92.912537),
    "50626": (42.562505, -92.178342),
    "50627": (42.335289, -93.141651),
    "50628": (43.296535, -92.3868),
    "50629": (42.577399, -91.981702),
    "50630": (43.052855, -92.205513),
    "50631": (42.882661, -92.306271),
    "50632": (42.101125, -92.674254),
    "50633": (42.669601, -93.114687),
    "50634": (42.419686, -92.21986),
    "50635": (42.194806, -92.533334),
    "50636": (42.826237, -92.84909),
    "50638": (42.369118, -92.807878),
    "50641": (42.574258, -91.924112),
    "50642": (42.44797, -92.817924),
    "50643": (42.383317, -92.416125),
    "50644": (42.506055, -91.81214),
    "50645": (43.052822, -92.445706),
    "50647": (42.665934, -92.465858),
    "50648": (42.482524, -91.90519),
    "50649": (42.662619, -92.911151),
    "50650": (42.585655, -91.716494),
    "50651": (42.369559, -92.206097),
    "50652": (42.264291, -92.693018),
    "50653": (43.060131, -92.877776),
    "50654": (42.457286, -91.564233),
    "50655": (42.878853, -91.917241),
    "50657": (42.343304, -92.673819),
    "50658": (42.985096, -92.475463),
    "50659": (43.065359, -92.338474),
    "50660": (42.599292, -92.623199),
    "50661": (43.117425, -92.414422),
    "50662": (42.693463, -91.853578),
    "50664": (42.862275, -91.843639),
    "50665": (42.655813, -92.824122),
    "50666": (42.840591, -92.470373),
    "50667": (42.466587, -92.21642),
    "50668": (42.693337, -92.219605),
    "50669": (42.332039, -92.705292),
    "50670": (42.674311, -92.633495),
    "50671": (42.614435, -91.795647),
    "50672": (42.412327, -93.084751),
    "50673": (42.525507, -92.70291),
    "50674": (42.787919, -92.309263),
    "50675": (42.173618, -92.527236),
    "50676": (42.786204, -92.278632),
    "50677": (42.774781, -92.403969),
    "50680": (42.445049, -92.926227),
    "50681": (42.781206, -92.012235),
    "50682": (42.433855, -91.831019),
    "50701": (42.441117, -92.339209),
    "50702": (42.458761, -92.313876),
    "50703": (42.549802, -92.258493),
    "50704": (42.469768, -92.309475),
    "50706": (42.415638, -92.270339),
    "50707": (42.482297, -92.276183),
    "50799": (42.469768, -92.309475),
    "50801": (41.049896, -94.347137),
    "50830": (41.033593, -94.19714),
    "50831": (40.931394, -94.219334),
    "50833": (40.687613, -94.690576),
    "50835": (40.735117, -94.243258),
    "50836": (40.624823, -94.547407),
    "50837": (41.258885, -94.666868),
    "50839": (41.048733, -94.823088),
    "50840": (40.782221, -94.606348),
    "50841": (41.028942, -94.746591),
    "50842": (41.039762, -94.461622),
    "50843": (41.255042, -94.947597),
    "50845": (40.727999, -94.292656),
    "50846": (41.300894, -94.54783),
    "50847": (41.142675, -94.984159),
    "50848": (40.772971, -94.737189),
    "50849": (41.299977, -94.456404),
    "50851": (40.844837, -94.585174),
    "50853": (41.229493, -94.784375),
    "50854": (40.716275, -94.228794),
    "50857": (40.9765, -94.871606),
    "50858": (41.215096, -94.423224),
    "50859": (41.057677, -94.594228),
    "50860": (40.604641, -94.388509),
    "50861": (40.933655, -94.242881),
    "50862": (40.812934, -94.662137),
    "50863": (40.853588, -94.194013),
    "50864": (41.029639, -95.051602),
    "50936": (41.672687, -93.572173),
    "50940": (41.672687, -93.572173),
    "50947": (41.672687, -93.572173),
    "50950": (41.672687, -93.572173),
    "50980": (41.672687, -93.572173),
    "50981": (41.672687, -93.572173),
    "51001": (42.822482, -96.462952),
    "51002": (42.735364, -95.151121),
    "51003": (43.03801, -95.970314),
    "51004": (42.336668, -95.962495),
    "51005": (42.719513, -95.534693),
    "51006": (42.359052, -95.546574),
    "51007": (42.421334, -96.165179),
    "51008": (42.809252, -96.26257),
    "51009": (42.9552, -95.570082),
    "51010": (42.080842, -95.903339),
    "51011": (42.926468, -96.494824),
    "51012": (42.721535, -95.574297),
    "51014": (42.779201, -95.701743),
    "51015": (42.345024, -96.087523),
    "51016": (42.394029, -95.969596),
    "51017": (42.896225, -96.309509),
    "51018": (42.355069, -96.015944),
    "51019": (42.339186, -96.016316),
    "51020": (42.487916, -95.430208),
    "51022": (42.974677, -96.086114),
    "51023": (43.022799, -96.263075),
    "51024": (42.625126, -96.299512),
    "51025": (42.443085, -95.530596),
    "51026": (42.300778, -96.092119),
    "51027": (43.039676, -96.303174),
    "51028": (42.619263, -96.077531),
    "51029": (42.873445, -95.565095),
    "51030": (42.475035, -96.03323),
    "51031": (42.749146, -96.261735),
    "51033": (42.865889, -95.274623),
    "51034": (42.137392, -95.913273),
    "51035": (42.76416, -95.786406),
    "51036": (42.975118, -96.307201),
    "51037": (42.822577, -95.642519),
    "51038": (42.764455, -96.354983),
    "51039": (42.444948, -96.069377),
    "51040": (42.021131, -96.129525),
    "51041": (43.033432, -96.076051),
    "51044": (42.298397, -95.972137),
    "51045": (42.8199, -96.056556),
    "51046": (42.982521, -95.69489),
    "51047": (43.004019, -95.299649),
    "51048": (42.394713, -96.017208),
    "51049": (42.701397, -95.70264),
    "51050": (42.793867, -96.207399),
    "51051": (42.197953, -95.976865),
    "51052": (42.399824, -96.11349),
    "51053": (42.480673, -95.265117),
    "51054": (42.387867, -96.335924),
    "51055": (42.345513, -96.048349),
    "51056": (42.347007, -96.037409),
    "51058": (42.997133, -95.486296),
    "51059": (42.033205, -95.965126),
    "51060": (42.033712, -95.720898),
    "51061": (42.691698, -95.628595),
    "51062": (42.70123, -96.50939),
    "51063": (42.149647, -96.179563),
    "51101": (42.494745, -96.399356),
    "51102": (42.368406, -96.317951),
    "51103": (42.523895, -96.435508),
    "51104": (42.472367, -96.106247),
    "51105": (42.481003, -96.403691),
    "51106": (42.471097, -96.338435),
    "51108": (42.5336, -96.354682),
    "51109": (42.527558, -96.453358),
    "51111": (42.423688, -96.378007),
    "51201": (43.170886, -95.792885),
    "51230": (43.352717, -96.311777),
    "51231": (43.098882, -95.743011),
    "51232": (43.309073, -95.772984),
    "51234": (43.186085, -96.005794),
    "51235": (43.301697, -96.244934),
    "51237": (43.345209, -95.988879),
    "51238": (43.07719, -95.938839),
    "51239": (43.192887, -96.180883),
    "51240": (43.338402, -96.293245),
    "51241": (43.423375, -96.457839),
    "51242": (43.444333, -96.336111),
    "51243": (43.389621, -96.081644),
    "51244": (43.214976, -95.915089),
    "51245": (43.083854, -95.625042),
    "51246": (43.415126, -96.146555),
    "51247": (43.084636, -96.204802),
    "51248": (43.172865, -95.643967),
    "51249": (43.377681, -95.624809),
    "51250": (43.084013, -96.269648),
    "51301": (43.13291, -95.177909),
    "51330": (43.415305, -95.643435),
    "51331": (43.377945, -95.24015),
    "51333": (43.135131, -94.983739),
    "51334": (43.377886, -94.737792),
    "51338": (43.176799, -95.308899),
    "51340": (43.082426, -95.151095),
    "51341": (43.015704, -95.043088),
    "51342": (43.19802, -94.736878),
    "51343": (43.107743, -95.140993),
    "51344": (43.393593, -94.704925),
    "51345": (43.399433, -95.437464),
    "51346": (43.154712, -95.505959),
    "51347": (43.399671, -95.284164),
    "51349": (43.377882, -95.624809),
    "51350": (43.315953, -95.614641),
    "51351": (43.367677, -95.208331),
    "51354": (43.378852, -95.626901),
    "51355": (43.429006, -95.077599),
    "51357": (43.043676, -95.199867),
    "51358": (43.130459, -94.855389),
    "51360": (43.407002, -95.121813),
    "51363": (43.431836, -94.946943),
    "51364": (43.35271, -95.119487),
    "51365": (43.318868, -94.796359),
    "51366": (42.967221, -95.013216),
    "51401": (42.042547, -94.8338),
    "51430": (42.087657, -95.015299),
    "51431": (42.341553, -95.371381),
    "51432": (41.911924, -95.135602),
    "51433": (42.340836, -95.080439),
    "51436": (42.15864, -94.991919),
    "51439": (42.08798, -95.372611),
    "51440": (41.960798, -94.833323),
    "51441": (42.123762, -95.304518),
    "51442": (42.037235, -95.381819),
    "51443": (42.049241, -94.802643),
    "51444": (42.008229, -94.994311),
    "51445": (42.326783, -95.477979),
    "51446": (41.684667, -95.325315),
    "51447": (41.718539, -95.189811),
    "51448": (42.046292, -95.294668),
    "51449": (42.29709, -94.721051),
    "51450": (42.312348, -95.028491),
    "51451": (42.184481, -94.691739),
    "51452": (42.125396, -94.775361),
    "51453": (42.281733, -94.542337),
    "51454": (41.968254, -95.222803),
    "51455": (42.024754, -94.861182),
    "51458": (42.319844, -95.100688),
    "51459": (42.041412, -94.632143),
    "51460": (42.130428, -95.574593),
    "51461": (42.137253, -95.388295),
    "51462": (42.02913, -94.541989),
    "51463": (41.912702, -94.898698),
    "51465": (42.037189, -95.256476),
    "51466": (42.268076, -95.121242),
    "51467": (42.080572, -95.26403),
    "51501": (41.23238, -95.875086),
    "51502": (41.332943, -95.587197),
    "51503": (41.286046, -95.711085),
    "51510": (41.287335, -95.91689),
    "51520": (41.979124, -95.450804),
    "51521": (41.433448, -95.342363),
    "51523": (41.915049, -96.049414),
    "51525": (41.224143, -95.413327),
    "51526": (41.363436, -95.887827),
    "51527": (41.80531, -95.353707),
    "51528": (41.950237, -95.470108),
    "51529": (41.779196, -95.716392),
    "51530": (41.787073, -95.438704),
    "51531": (41.562409, -95.129522),
    "51532": (41.119637, -95.108675),
    "51533": (41.016355, -95.422695),
    "51534": (41.031806, -95.71558),
    "51535": (41.236242, -95.041216),
    "51536": (41.389941, -95.372891),
    "51537": (41.667566, -95.29087),
    "51540": (41.013156, -95.500756),
    "51541": (41.12933, -95.453376),
    "51542": (41.435092, -95.831903),
    "51543": (41.657834, -95.044476),
    "51544": (41.252785, -95.098198),
    "51545": (41.787434, -96.005056),
    "51546": (41.657856, -95.786047),
    "51548": (41.377671, -95.599683),
    "51549": (41.327892, -95.514083),
    "51550": (41.693412, -95.889638),
    "51551": (41.006817, -95.594792),
    "51552": (41.447152, -95.104078),
    "51553": (41.404922, -95.549781),
    "51554": (41.141404, -95.700491),
    "51555": (41.605102, -95.908803),
    "51556": (41.643973, -96.013027),
    "51557": (41.739098, -95.99577),
    "51558": (41.939436, -95.853673),
    "51559": (41.390749, -95.583086),
    "51560": (41.324842, -95.422978),
    "51561": (41.011257, -95.808797),
    "51562": (41.701435, -95.492423),
    "51563": (41.634002, -95.788095),
    "51564": (41.805536, -95.898207),
    "51565": (41.708156, -95.44989),
    "51566": (41.030516, -95.19404),
    "51570": (41.476766, -95.370203),
    "51571": (41.110642, -95.604984),
    "51572": (41.994014, -95.778514),
    "51573": (40.980119, -95.115799),
    "51574": (41.595663, -95.441923),
    "51575": (41.230742, -95.608582),
    "51576": (41.382994, -95.721535),
    "51577": (41.418923, -95.302966),
    "51578": (41.719899, -95.39518699999999),
    "51579": (41.745172, -95.716704),
    "51591": (41.030256, -95.156205),
    "51593": (41.332943, -95.587197),
    "51601": (40.718258, -95.16372),
    "51602": (40.738309, -95.149305),
    "51603": (40.738309, -95.149305),
    "51630": (40.616851, -95.152493),
    "51631": (40.604915, -95.017884),
    "51632": (40.738247, -95.108481),
    "51636": (40.646512, -95.199797),
    "51637": (40.63122, -95.12241),
    "51638": (40.77046, -95.261263),
    "51639": (40.72146, -95.477606),
    "51640": (40.741699, -95.583179),
    "51645": (40.858205, -95.432381),
    "51646": (40.722464, -94.842837),
    "51647": (40.609974, -95.316476),
    "51648": (40.742301, -95.761779),
    "51649": (40.847951, -95.537377),
    "51650": (40.662884, -95.577257),
    "51651": (40.65747, -95.024969),
    "51652": (40.77152, -95.626355),
    "51653": (40.822599, -95.694406),
    "51654": (40.79334, -95.758636),
    "51656": (40.737446, -95.156217),
    "52001": (42.458876, -90.877135),
    "52002": (42.532019, -90.7718),
    "52003": (42.436426, -90.716921),
    "52004": (42.484861, -90.804116),
    "52030": (42.164053, -90.61074),
    "52031": (42.207444, -90.49192),
    "52032": (42.338928, -90.864175),
    "52033": (42.362066, -90.903195),
    "52035": (42.560859, -91.347333),
    "52036": (42.476609, -91.311248),
    "52037": (41.9604, -90.636408),
    "52038": (42.559127, -91.47609),
    "52039": (42.534545, -90.851368),
    "52040": (42.421746, -91.035655),
    "52041": (42.519834, -91.299742),
    "52042": (42.756961, -91.34453),
    "52043": (42.842609, -91.408507),
    "52044": (42.762431, -91.320305),
    "52045": (42.458113, -90.933197),
    "52046": (42.45328, -91.026374),
    "52047": (42.984477, -91.354816),
    "52048": (42.736871, -91.249013),
    "52049": (42.808244, -91.257708),
    "52050": (42.554136, -91.332816),
    "52052": (42.845668, -91.249472),
    "52053": (42.539813, -90.90914),
    "52054": (42.284057, -90.595351),
    "52055": (42.862739, -91.252459),
    "52056": (42.578283, -91.062066),
    "52057": (42.492356, -91.39658),
    "52060": (42.19807, -90.605827),
    "52064": (42.120881, -90.329993),
    "52065": (42.547149, -90.991701),
    "52066": (42.667786, -90.986518),
    "52068": (42.432281, -90.808309),
    "52069": (42.076366, -90.432502),
    "52070": (42.093989, -90.360035),
    "52071": (42.319577, -90.490269),
    "52072": (42.876289, -91.386044),
    "52073": (42.5854, -90.811885),
    "52074": (42.098358, -90.478972),
    "52075": (42.164766, -90.498366),
    "52076": (42.720409, -91.490023),
    "52077": (42.844453, -91.496533),
    "52078": (42.388741, -91.089374),
    "52079": (42.338446, -90.714464),
    "52099": (42.484861, -90.804116),
    "52101": (43.294252, -91.789582),
    "52132": (43.168758, -91.867666),
    "52133": (43.136114, -91.664324),
    "52134": (43.464701, -92.40617),
    "52135": (42.942633, -91.674712),
    "52136": (43.35666, -92.189287),
    "52140": (43.43073, -91.509087),
    "52141": (42.941219, -91.699573),
    "52142": (42.885443, -91.8084),
    "52144": (43.268916, -91.924788),
    "52146": (43.288601, -91.209339),
    "52147": (42.938391, -91.929151),
    "52149": (43.463765, -91.689862),
    "52151": (43.346574, -91.277117),
    "52154": (43.110826, -92.169251),
    "52155": (43.410582, -92.276168),
    "52156": (43.020695, -91.47665),
    "52157": (42.91563, -91.295555),
    "52158": (43.036006, -91.193057),
    "52159": (43.034025, -91.393408),
    "52160": (43.457526, -91.354022),
    "52161": (43.142181, -91.763097),
    "52162": (43.175423, -91.507751),
    "52163": (43.216975, -92.092682),
    "52164": (42.846576, -91.896581),
    "52165": (43.253702, -91.880018),
    "52166": (43.060717, -91.923226),
    "52168": (43.203195, -91.944055),
    "52169": (42.841014, -91.674168),
    "52170": (43.217292, -91.310349),
    "52171": (42.92664, -91.976961),
    "52172": (43.290026, -91.445754),
    "52175": (42.943828, -91.833409),
    "52201": (41.351113, -91.581212),
    "52202": (42.157086, -91.645825),
    "52203": (41.812242, -91.913869),
    "52204": (41.686351, -92.063603),
    "52205": (42.10352, -91.240145),
    "52206": (42.057516, -92.058526),
    "52207": (42.120007, -90.816341),
    "52208": (41.917133, -92.242382),
    "52209": (41.913181, -92.112381),
    "52210": (42.348147, -92.003981),
    "52211": (41.759702, -92.436452),
    "52212": (42.120097, -91.029004),
    "52213": (42.197041, -91.744447),
    "52214": (42.186959, -91.520359),
    "52215": (42.036478, -92.400098),
    "52216": (41.864242, -91.024771),
    "52217": (42.083382, -92.420884),
    "52218": (42.250724, -91.53445),
    "52219": (42.231046, -91.395429),
    "52220": (41.73543, -92.010162),
    "52221": (41.637767, -92.347941),
    "52222": (41.59165, -92.373998),
    "52223": (42.413678, -91.31071),
    "52224": (42.195645, -92.36492),
    "52225": (41.990954, -92.363359),
    "52226": (41.988971, -90.73596),
    "52227": (41.910425, -91.575268),
    "52228": (41.912837, -91.764387),
    "52229": (42.137698, -92.160995),
    "52231": (41.357763, -92.063442),
    "52232": (41.810889, -92.342571),
    "52233": (42.047863, -91.685645),
    "52235": (41.555704, -91.530842),
    "52236": (41.730806, -91.881072),
    "52237": (42.366671, -91.276347),
    "52240": (41.648207, -91.541579),
    "52241": (41.699942, -91.6332),
    "52242": (41.733924, -91.555328),
    "52243": (41.642657, -91.599974),
    "52244": (41.572682, -91.661901),
    "52245": (41.668592, -91.518388),
    "52246": (41.600628, -91.589264),
    "52247": (41.460979, -91.698928),
    "52248": (41.356073, -92.001798),
    "52249": (42.007605, -92.071971),
    "52251": (41.710377, -92.189413),
    "52252": (42.191979, -91.225836),
    "52253": (41.914581, -91.385445),
    "52254": (41.876909, -90.541188),
    "52255": (41.856539, -90.966516),
    "52257": (42.003812, -92.163137),
    "52301": (41.768214, -92.094866),
    "52302": (42.056938, -91.573963),
    "52305": (42.018308, -91.321727),
    "52306": (41.866983, -91.269378),
    "52307": (41.79544, -91.901776),
    "52308": (41.576444, -92.166645),
    "52309": (42.13894, -90.864621),
    "52310": (42.139945, -91.158852),
    "52312": (42.048397, -91.178455),
    "52313": (42.254106, -92.098959),
    "52314": (41.939802, -91.450762),
    "52315": (42.006958, -91.970161),
    "52316": (41.555588, -92.067635),
    "52317": (41.763944, -91.604798),
    "52318": (41.905263, -91.900096),
    "52319": (41.642657, -91.599974),
    "52320": (42.08132, -91.116054),
    "52321": (42.1065, -91.020988),
    "52322": (41.700994, -91.730339),
    "52323": (42.030946, -91.005688),
    "52324": (42.049832, -91.788933),
    "52325": (41.575705, -91.939701),
    "52326": (42.469908, -91.710553),
    "52327": (41.39539, -91.580364),
    "52328": (42.073943, -91.665177),
    "52329": (42.469721, -91.773824),
    "52330": (42.367794, -91.445994),
    "52332": (42.101443, -91.914187),
    "52333": (41.792851, -91.506086),
    "52334": (41.724365, -91.939343),
    "52335": (41.452856, -92.067973),
    "52336": (42.063342, -91.471893),
    "52337": (41.89206, -91.152099),
    "52338": (41.827112, -91.721642),
    "52339": (41.934093, -92.585494),
    "52340": (41.701791, -91.677347),
    "52341": (42.111669, -91.732863),
    "52342": (42.068965, -92.551725),
    "52344": (42.079415, -91.599215),
    "52345": (42.236512, -91.888136),
    "52346": (42.014398, -92.067227),
    "52347": (41.706644, -92.25127),
    "52348": (41.980201, -92.375713),
    "52349": (42.087347, -91.987332),
    "52350": (42.091217, -91.385047),
    "52351": (41.877045, -91.836855),
    "52352": (42.255159, -91.726637),
    "52353": (41.31663, -91.751808),
    "52354": (41.92003, -91.978744),
    "52355": (41.449144, -92.169002),
    "52356": (41.448663, -91.840264),
    "52358": (41.728915, -91.25056),
    "52359": (41.393969, -91.740025),
    "52361": (41.649999, -92.065181),
    "52362": (42.065281, -91.078891),
    "52401": (41.976612, -91.657578),
    "52402": (42.020105, -91.681029),
    "52403": (41.972936, -91.58127),
    "52404": (41.919542, -91.704467),
    "52405": (41.987067, -91.753326),
    "52406": (42.287191, -91.777472),
    "52407": (42.079415, -91.599215),
    "52408": (42.079415, -91.599215),
    "52409": (42.079415, -91.599215),
    "52410": (42.079415, -91.599215),
    "52411": (42.049262, -91.726331),
    "52497": (42.079415, -91.599215),
    "52498": (42.079415, -91.599215),
    "52499": (42.079415, -91.599215),
    "52501": (41.030933, -92.409827),
    "52530": (40.979036, -92.426183),
    "52531": (41.00004, -92.835186),
    "52533": (41.013559, -92.0835),
    "52534": (41.29511, -92.598024),
    "52535": (40.827181, -91.951174),
    "52536": (40.981083, -92.570024),
    "52537": (40.746315, -92.406245),
    "52538": (40.745286, -92.408679),
    "52540": (41.211747, -91.845034),
    "52542": (40.643077, -92.069754),
    "52543": (41.219972, -92.506291),
    "52544": (40.686447, -92.881614),
    "52548": (41.060681, -92.552769),
    "52549": (40.626921, -92.953118),
    "52550": (41.28437, -92.351218),
    "52551": (40.837786, -92.085948),
    "52552": (40.819643, -92.500244),
    "52553": (41.112342, -92.570765),
    "52554": (41.030032, -92.408837),
    "52555": (40.630992, -92.884722),
    "52556": (41.030998, -91.957527),
    "52557": (41.016566, -91.96821),
    "52560": (40.84047, -92.284098),
    "52561": (41.227386, -92.467531),
    "52562": (41.336267, -92.178366),
    "52563": (41.211206, -92.297854),
    "52565": (40.704158, -91.853076),
    "52566": (41.143796, -92.5006),
    "52567": (40.951469, -92.082459),
    "52568": (41.194806, -92.271472),
    "52569": (41.03227, -93.035367),
    "52570": (40.671781, -92.162092),
    "52571": (40.866821, -92.736442),
    "52572": (40.740795, -92.806081),
    "52573": (40.749913, -91.948106),
    "52574": (40.780847, -92.979322),
    "52576": (41.218708, -92.120482),
    "52577": (41.283366, -92.662675),
    "52580": (41.119571, -92.092371),
    "52581": (40.818638, -92.975714),
    "52583": (40.786539, -93.141255),
    "52584": (40.649038, -92.265179),
    "52585": (41.20699, -92.126742),
    "52586": (41.390468, -92.560102),
    "52588": (40.749913, -91.948106),
    "52590": (40.710521, -93.130436),
    "52591": (41.310884, -92.159246),
    "52593": (40.80475, -92.714834),
    "52594": (40.812488, -92.701454),
    "52595": (41.286383, -92.618357),
    "52601": (40.898412, -91.164393),
    "52619": (40.546499, -91.585217),
    "52620": (40.672405, -91.770841),
    "52621": (41.20951, -91.551283),
    "52623": (40.866863, -91.307634),
    "52624": (40.743432, -91.323858),
    "52625": (40.631583, -91.56008),
    "52626": (40.639028, -91.7394),
    "52627": (40.596949, -91.434473),
    "52630": (40.845708, -91.670699),
    "52631": (40.769982, -91.613795),
    "52632": (40.584716, -91.471682),
    "52635": (40.988685, -91.785249),
    "52637": (41.012819, -91.127994),
    "52638": (40.848173, -91.269867),
    "52639": (40.542856, -91.468901),
    "52640": (41.135562, -91.291067),
    "52641": (40.994595, -91.573713),
    "52642": (40.977395, -91.692312),
    "52644": (41.010776, -91.43819),
    "52645": (40.907221, -91.527126),
    "52646": (41.117324, -91.074161),
    "52647": (41.146979, -91.544426),
    "52648": (40.594704, -91.415648),
    "52649": (40.857375, -91.610895),
    "52650": (40.920383, -91.208938),
    "52651": (40.868097, -91.889766),
    "52652": (41.104302, -91.546988),
    "52653": (41.203527, -91.207463),
    "52654": (41.033746, -91.561327),
    "52655": (40.850783, -91.229873),
    "52656": (40.610778, -91.461569),
    "52657": (40.758742, -91.478305),
    "52658": (40.7129, -91.23819),
    "52659": (41.082887, -91.543142),
    "52660": (40.983507, -91.302644),
    "52701": (41.964393, -90.222348),
    "52720": (41.475075, -91.16406),
    "52721": (41.749923, -90.96289),
    "52722": (41.57048, -90.529138),
    "52726": (41.61105, -90.660178),
    "52727": (41.953426, -90.326961),
    "52728": (41.469263, -90.736557),
    "52729": (41.829003, -90.740567),
    "52730": (41.813438, -90.317574),
    "52731": (41.966744, -90.555111),
    "52732": (41.899176, -90.301599),
    "52733": (41.880619, -90.519519),
    "52736": (41.880619, -90.519519),
    "52737": (41.25926, -91.374686),
    "52738": (41.292638, -91.300624),
    "52739": (41.401379, -91.338658),
    "52742": (41.841735, -90.55621),
    "52745": (41.711283, -90.75534),
    "52746": (41.71654, -90.646985),
    "52747": (41.772184, -91.132045),
    "52748": (41.59972, -90.564348),
    "52749": (41.3486, -91.123729),
    "52750": (41.942428, -90.378578),
    "52751": (41.850144, -90.669527),
    "52752": (41.256712, -91.19669),
    "52753": (41.568131, -90.537234),
    "52754": (41.304284, -91.249503),
    "52755": (41.510935, -91.440616),
    "52756": (41.726242, -90.540219),
    "52757": (41.806528, -90.370566),
    "52758": (41.743048, -90.453905),
    "52759": (41.462494, -90.808767),
    "52760": (41.552779, -91.058797),
    "52761": (41.462426, -91.053888),
    "52765": (41.713165, -90.850502),
    "52766": (41.492577, -91.196155),
    "52767": (41.574582, -90.42128),
    "52768": (41.69565, -90.394692),
    "52769": (41.538729000000004, -90.856921),
    "52771": (41.999113, -90.218704),
    "52772": (41.772503, -91.13248),
    "52773": (41.61358, -90.753478),
    "52774": (41.917411, -90.597017),
    "52776": (41.529715, -91.190607),
    "52777": (41.873852, -90.682244),
    "52778": (41.559742, -90.959154),
    "52801": (41.527232, -90.573686),
    "52802": (41.497582, -90.623887),
    "52803": (41.538332, -90.556985),
    "52804": (41.556481, -90.598757),
    "52805": (41.613034, -90.606284),
    "52806": (41.545731, -90.633688),
    "52807": (41.571131, -90.555825),
    "52808": (41.613034, -90.606284),
    "52809": (41.613034, -90.606284),
    "53001": (43.658488, -87.973717),
    "53002": (43.382128, -88.26219),
    "53003": (43.217506, -88.525315),
    "53004": (43.499631, -87.918042),
    "53005": (43.062707, -88.105906),
    "53006": (43.602789, -88.52302),
    "53007": (43.108459, -88.071489),
    "53008": (43.018696, -88.302997),
    "53010": (43.682727, -88.350947),
    "53011": (43.725504, -88.048378),
    "53012": (43.321475, -88.004033),
    "53013": (43.590548, -87.85532),
    "53014": (44.020561, -88.185906),
    "53015": (43.935653, -87.80346),
    "53016": (43.31546, -88.720642),
    "53017": (43.209445, -88.241501),
    "53018": (43.015666, -88.386519),
    "53019": (43.672543, -88.50384),
    "53020": (43.827363, -87.9915),
    "53021": (43.477015, -87.961162),
    "53022": (43.235477, -88.124711),
    "53023": (43.772128, -88.041299),
    "53024": (43.299956, -87.94104),
    "53026": (43.718294, -87.618716),
    "53027": (43.357616, -88.31903199999999),
    "53029": (43.123679, -88.336087),
    "53031": (43.639395, -87.915705),
    "53032": (43.422045, -88.624268),
    "53033": (43.367185, -88.252892),
    "53034": (43.330523, -88.603032),
    "53035": (43.36296, -88.581515),
    "53036": (43.147748, -88.588628),
    "53037": (43.32393, -88.152212),
    "53038": (43.092348, -88.743276),
    "53039": (43.372221, -88.710157),
    "53040": (43.499425, -88.206447),
    "53042": (43.96317, -87.955059),
    "53044": (43.748441, -87.776246),
    "53045": (43.06081, -88.15589),
    "53046": (43.153279, -88.164427),
    "53047": (43.256793, -88.6281),
    "53048": (43.516912, -88.480811),
    "53049": (43.875302, -88.287108),
    "53050": (43.483463, -88.545925),
    "53051": (43.124189, -88.227543),
    "53052": (43.018696, -88.302997),
    "53056": (43.146023, -88.30975),
    "53057": (43.711957, -88.443585),
    "53058": (43.109127, -88.40248),
    "53059": (43.289809, -88.533958),
    "53060": (43.433807, -88.062338),
    "53061": (43.949886, -88.101954),
    "53062": (44.067942, -88.223131),
    "53063": (43.957599, -87.792815),
    "53064": (43.018696, -88.302997),
    "53065": (43.690246, -88.678209),
    "53066": (43.087062, -88.463305),
    "53069": (43.117886, -88.439353),
    "53070": (43.620857, -87.810616),
    "53072": (43.080185, -88.264875),
    "53073": (43.768454, -87.975773),
    "53074": (43.387702, -87.881232),
    "53075": (43.582924, -88.000555),
    "53076": (43.2727, -88.206716),
    "53078": (43.304408, -88.504428),
    "53079": (43.797531, -88.201679),
    "53080": (43.432544, -87.947537),
    "53081": (43.722489, -87.856793),
    "53082": (43.718294, -87.618716),
    "53083": (43.775428, -87.860803),
    "53085": (43.726404, -87.853069),
    "53086": (43.327417, -88.260878),
    "53088": (44.080455, -88.312404),
    "53089": (43.148887, -88.245381),
    "53090": (43.443839, -88.19631),
    "53091": (43.483635, -88.450107),
    "53092": (43.235856, -87.981188),
    "53093": (43.662704, -87.930254),
    "53094": (43.132599, -88.743595),
    "53095": (43.422223, -88.195862),
    "53097": (43.247112, -87.980914),
    "53098": (43.276444, -88.715408),
    "53099": (43.414202, -88.704914),
    "53101": (42.58098, -87.662878),
    "53102": (42.500141, -88.079983),
    "53103": (42.882441, -88.205514),
    "53104": (42.553518, -88.028986),
    "53105": (42.692103, -88.228793),
    "53108": (42.803697, -87.930936),
    "53109": (42.535968, -88.144386),
    "53110": (42.948015, -87.866831),
    "53114": (42.658281, -88.660964),
    "53115": (42.641556, -88.653496),
    "53118": (42.951536, -88.444097),
    "53119": (42.929074, -88.47489),
    "53120": (42.756533, -88.507327),
    "53121": (42.671666, -88.563961),
    "53122": (43.048211, -88.087888),
    "53125": (42.545625, -88.463036),
    "53126": (42.785553, -87.995471),
    "53127": (42.960098, -88.374455),
    "53128": (42.549412, -88.438624),
    "53129": (42.937765, -87.998935),
    "53130": (42.943614, -88.046454),
    "53132": (42.887289, -88.009597),
    "53137": (43.008958, -88.6726),
    "53138": (42.66749, -88.541721),
    "53139": (42.720022, -88.120616),
    "53140": (42.622449, -87.830375),
    "53141": (42.58098, -87.662878),
    "53142": (42.558221, -87.925876),
    "53143": (42.53607, -87.824828),
    "53144": (42.618427, -87.948079),
    "53146": (42.969924, -88.177554),
    "53147": (42.617877, -88.52023),
    "53148": (42.648665, -88.359044),
    "53149": (42.97594, -88.329731),
    "53150": (42.88799, -88.132708),
    "53151": (42.973459, -88.127689),
    "53152": (42.574616, -88.232632),
    "53153": (42.940971, -88.401712),
    "53154": (42.886266, -87.89198),
    "53156": (42.893937, -88.59712),
    "53157": (42.540048, -88.358167),
    "53158": (42.52926, -87.885546),
    "53159": (42.555695, -88.296914),
    "53167": (42.748168, -88.243586),
    "53168": (42.574598, -88.137535),
    "53170": (42.552018, -88.160836),
    "53171": (42.642298, -87.903161),
    "53172": (42.911616, -87.950533),
    "53176": (42.636038, -88.415987),
    "53177": (42.712962, -87.934013),
    "53178": (43.018327, -88.600429),
    "53179": (42.517168, -88.138001),
    "53181": (42.523887, -88.235389),
    "53182": (42.739435, -88.083092),
    "53183": (43.003573, -88.376916),
    "53184": (42.561543, -88.597153),
    "53185": (42.763168, -88.197361),
    "53186": (42.987835, -88.217715),
    "53187": (43.018696, -88.302997),
    "53188": (42.994564, -88.241786),
    "53189": (42.95163, -88.296321),
    "53190": (42.784255, -88.592559),
    "53191": (42.691288, -88.635035),
    "53192": (42.507165, -88.191337),
    "53194": (42.58098, -87.662878),
    "53195": (42.513649, -88.484322),
    "53201": (43.011264, -87.958409),
    "53202": (43.043213, -87.894734),
    "53203": (43.038313, -87.916534),
    "53204": (43.019463, -87.925534),
    "53205": (43.053112, -87.933185),
    "53206": (43.074311, -87.933135),
    "53207": (42.975115, -87.894682),
    "53208": (43.045962, -87.963536),
    "53209": (43.140909, -87.942653),
    "53210": (43.071111, -87.973786),
    "53211": (43.082018, -87.889534),
    "53212": (43.074862, -87.907178),
    "53213": (43.075461, -87.999511),
    "53214": (43.021514, -88.017587),
    "53215": (43.006014, -87.942935),
    "53216": (43.086244, -87.976988),
    "53217": (43.13446, -87.933386),
    "53218": (43.11546, -87.991687),
    "53219": (42.995814, -87.990335),
    "53220": (42.955864, -87.993285),
    "53221": (42.950565, -87.987933),
    "53222": (43.082161, -88.036938),
    "53223": (43.162959, -87.977896),
    "53224": (43.163122, -88.022586),
    "53225": (43.115159, -88.040188),
    "53226": (43.049312, -88.041387),
    "53227": (43.000926, -88.031418),
    "53228": (42.967564, -88.043386),
    "53233": (43.037213, -87.933529),
    "53234": (43.017412, -87.569664),
    "53235": (42.969865, -87.873732),
    "53237": (43.017412, -87.569664),
    "53259": (43.038663, -87.913934),
    "53263": (43.074583, -88.06044),
    "53267": (43.044013, -87.909834),
    "53268": (43.038513, -87.909584),
    "53270": (43.038763, -87.903634),
    "53274": (43.017412, -87.569664),
    "53277": (43.038863, -87.902384),
    "53278": (43.038863, -87.902384),
    "53280": (43.040963, -87.957786),
    "53281": (43.040963, -87.957786),
    "53284": (43.017412, -87.569664),
    "53285": (43.017412, -87.569664),
    "53288": (43.040613, -87.909784),
    "53290": (43.037263, -87.914034),
    "53293": (43.040813, -87.919135),
    "53295": (43.017412, -87.569664),
    "53401": (42.727153, -87.675979),
    "53402": (42.755628, -87.821815),
    "53403": (42.700619, -87.835901),
    "53404": (42.756718, -87.812275),
    "53405": (42.731827, -87.820925),
    "53406": (42.72993, -87.866213),
    "53407": (42.731224, -87.782818),
    "53408": (42.727153, -87.675979),
    "53490": (42.727153, -87.675979),
    "53501": (42.605454, -89.070448),
    "53502": (42.712827, -89.45123),
    "53503": (43.119643, -89.947679),
    "53504": (42.690143, -89.922697),
    "53505": (42.659301, -88.83065),
    "53506": (43.138475, -90.280725),
    "53507": (43.008396, -89.897387),
    "53508": (42.903829, -89.586339),
    "53510": (42.685375, -90.263828),
    "53511": (42.562039, -89.086045),
    "53512": (42.669779, -89.072779),
    "53515": (43.113953, -89.624544),
    "53516": (42.693258, -90.104765),
    "53517": (43.03822, -89.804576),
    "53518": (42.97045, -90.571655),
    "53520": (42.605797, -89.580126),
    "53521": (42.717122, -89.582703),
    "53522": (42.563199, -89.778793),
    "53523": (42.987505, -89.080742),
    "53525": (42.56239, -88.859993),
    "53526": (42.963325, -90.369319),
    "53527": (43.071165, -89.196996),
    "53528": (43.106453, -89.695091),
    "53529": (43.239966, -89.523346),
    "53530": (42.69112, -90.134781),
    "53531": (43.057662, -89.091798),
    "53532": (43.149066, -89.260855),
    "53533": (43.007063, -90.192522),
    "53534": (42.803797, -89.101389),
    "53535": (43.011323, -90.133932),
    "53536": (42.766359, -89.250152),
    "53537": (42.672575, -89.211151),
    "53538": (42.926467, -88.841626),
    "53540": (43.234509, -90.261804),
    "53541": (42.579894, -90.031186),
    "53542": (42.632325, -89.15942),
    "53543": (42.991078, -90.133812),
    "53544": (42.871497, -89.923881),
    "53545": (42.710981, -89.112201),
    "53546": (42.663574, -88.947859),
    "53547": (42.729359, -89.030111),
    "53549": (42.993502, -88.759793),
    "53550": (42.564434, -89.507906),
    "53551": (43.080902, -88.913251),
    "53553": (42.963106, -90.320561),
    "53554": (42.898716, -90.511593),
    "53555": (43.342813, -89.557023),
    "53556": (43.241475, -90.265197),
    "53557": (43.343056, -88.791442),
    "53558": (43.010519, -89.363862),
    "53559": (43.173921, -89.091315),
    "53560": (43.190983, -89.729261),
    "53561": (43.364531, -89.66396),
    "53562": (43.114772, -89.529153),
    "53563": (42.737804, -89.041277),
    "53565": (42.989701, -90.152558),
    "53566": (42.612966, -89.656994),
    "53569": (43.031263, -90.492475),
    "53570": (42.74305, -89.621013),
    "53571": (43.277325, -89.356403),
    "53572": (42.973438, -89.513903),
    "53573": (43.1234, -90.488423),
    "53574": (42.816273, -89.651287),
    "53575": (42.933918, -89.389642),
    "53576": (42.614273, -89.233129),
    "53577": (43.293776, -90.022327),
    "53578": (43.360759, -89.808407),
    "53579": (43.287987, -88.887444),
    "53580": (42.856934, -90.377784),
    "53581": (43.366148, -90.430225),
    "53582": (43.016577, -89.986458),
    "53583": (43.251127, -89.89584),
    "53584": (43.279435, -90.287566),
    "53585": (42.607688, -88.623745),
    "53586": (42.605221, -90.113635),
    "53587": (42.579926, -89.931751),
    "53588": (43.230001, -90.040066),
    "53589": (42.931289, -89.168354),
    "53590": (43.195712, -89.209418),
    "53591": (43.06956, -89.423861),
    "53593": (42.995697, -89.566512),
    "53594": (43.12904, -88.947513),
    "53595": (42.976078, -90.141299),
    "53596": (43.192403, -89.26288),
    "53597": (43.183972, -89.322655),
    "53598": (43.207783, -89.34178),
    "53599": (42.649309, -89.862202),
    "53701": (43.06956, -89.423861),
    "53702": (43.06956, -89.423861),
    "53703": (43.053085, -89.352764),
    "53704": (43.104429, -89.322135),
    "53705": (43.073147, -89.45681),
    "53706": (43.077755, -89.413326),
    "53707": (43.06956, -89.423861),
    "53708": (43.06956, -89.423861),
    "53709": (43.06956, -89.423861),
    "53710": (43.06956, -89.423861),
    "53711": (43.021252, -89.417973),
    "53713": (43.037167, -89.397066),
    "53714": (43.118663, -89.312644),
    "53715": (43.061839, -89.394619),
    "53716": (43.063103, -89.313327),
    "53717": (43.015966, -89.656734),
    "53718": (43.11416, -89.249067),
    "53719": (43.03125, -89.494568),
    "53725": (43.06956, -89.423861),
    "53726": (43.06956, -89.423861),
    "53744": (43.06956, -89.423861),
    "53777": (43.06956, -89.423861),
    "53778": (43.06956, -89.423861),
    "53779": (43.098202, -89.324196),
    "53780": (43.06956, -89.423861),
    "53782": (43.06956, -89.423861),
    "53783": (43.15955, -89.285235),
    "53784": (43.048908, -89.338447),
    "53785": (43.06956, -89.423861),
    "53786": (43.06956, -89.423861),
    "53787": (43.06956, -89.423861),
    "53788": (43.076691, -89.37632),
    "53789": (43.06956, -89.423861),
    "53790": (43.06956, -89.423861),
    "53791": (43.06956, -89.423861),
    "53792": (43.06956, -89.423861),
    "53793": (43.06956, -89.423861),
    "53794": (43.06956, -89.423861),
    "53801": (42.796401, -90.823145),
    "53802": (42.873625, -90.936354),
    "53803": (42.554499, -90.350817),
    "53804": (42.838191, -90.907665),
    "53805": (42.896051, -90.779071),
    "53806": (42.782451, -90.945303),
    "53807": (42.751647, -90.699166),
    "53808": (42.635081, -90.583298),
    "53809": (42.806387, -90.677324),
    "53810": (42.822065, -90.982153),
    "53811": (42.543893, -90.536322),
    "53812": (42.859325, -90.791337),
    "53813": (42.864155, -90.684965),
    "53816": (42.975521, -90.84962),
    "53817": (42.942183, -90.964596),
    "53818": (42.795971, -90.644975),
    "53820": (42.692445, -90.731654),
    "53821": (43.084008, -91.069064),
    "53824": (42.859325, -90.791337),
    "53825": (42.926596, -90.583575),
    "53826": (43.110147, -90.957097),
    "53827": (43.035813, -90.853002),
    "53901": (43.50666, -89.399335),
    "53910": (43.892066, -89.827509),
    "53911": (43.336846, -89.36061),
    "53913": (43.446602, -89.863957),
    "53916": (43.466482, -88.862852),
    "53917": (43.414202, -88.704914),
    "53919": (43.740975, -88.62245),
    "53920": (43.7076, -89.551629),
    "53922": (43.517272, -88.73346),
    "53923": (43.550235, -89.15173),
    "53924": (43.46358, -90.28225),
    "53925": (43.3569, -89.12088),
    "53926": (43.679317, -89.186656),
    "53927": (43.95546, -89.941771),
    "53928": (43.426605, -89.149069),
    "53929": (43.82702, -90.10446),
    "53930": (43.6866, -89.483441),
    "53931": (43.747481, -88.866516),
    "53932": (43.417126, -89.070459),
    "53933": (43.568169, -88.895723),
    "53934": (43.997966, -89.777051),
    "53935": (43.590116, -89.05931),
    "53936": (43.947894, -89.72751),
    "53937": (43.390863, -90.128539),
    "53939": (43.6911, -89.130237),
    "53940": (43.593912, -89.791242),
    "53941": (43.547459, -90.117243),
    "53942": (43.468211, -90.161478),
    "53943": (43.385775, -90.017885),
    "53944": (43.714061, -89.949337),
    "53946": (43.723578, -89.065361),
    "53947": (43.746464, -89.138441),
    "53948": (43.908679, -90.07242),
    "53949": (43.812581, -89.372011),
    "53950": (43.911145, -90.165918),
    "53951": (43.4031, -89.872232),
    "53952": (43.767789, -89.463944),
    "53953": (43.764385, -89.4576),
    "53954": (43.516772, -89.31459),
    "53955": (43.433273, -89.394518),
    "53956": (43.534002, -88.946714),
    "53957": (43.535249, -89.006845),
    "53958": (43.393767, -89.95589),
    "53959": (43.482108, -89.966806),
    "53960": (43.398335, -89.250177),
    "53961": (43.459884, -89.931931),
    "53962": (43.94521, -90.049489),
    "53963": (43.459309, -88.754483),
    "53964": (43.848698, -89.478459),
    "53965": (43.568982, -89.44168),
    "53968": (43.690867, -90.203595),
    "53969": (43.498907, -89.30497),
    "54001": (45.348566, -92.401379),
    "54002": (44.969171, -92.441061),
    "54003": (44.789742, -92.448434),
    "54004": (45.31484, -92.430772),
    "54005": (45.282945, -92.429816),
    "54006": (45.554321, -92.662155),
    "54007": (45.087504, -92.379021),
    "54009": (45.36179, -92.549952),
    "54010": (44.734759, -92.465532),
    "54011": (44.740142, -92.548289),
    "54012": (45.11453, -92.276235),
    "54013": (45.060365, -92.248403),
    "54014": (44.655504, -92.573652),
    "54015": (44.966938999999996, -92.456512),
    "54016": (44.971853, -92.481156),
    "54017": (45.090925, -92.496993),
    "54020": (45.283783, -92.535618),
    "54021": (44.747209, -92.640483),
    "54022": (44.802351, -92.595365),
    "54023": (44.974357, -92.59762),
    "54024": (45.509689, -92.611733),
    "54025": (45.081379, -92.474419),
    "54026": (45.265619, -92.480793),
    "54027": (44.945813, -92.25605),
    "54028": (44.946202, -92.376526),
    "54082": (45.080119, -92.746568),
    "54101": (44.792284, -88.044067),
    "54102": (45.492839, -88.049604),
    "54103": (45.672311, -88.530545),
    "54104": (45.420602, -88.246901),
    "54106": (44.470235, -88.454719),
    "54107": (44.699153, -88.454312),
    "54110": (44.163209, -88.133876),
    "54111": (44.810274, -88.391648),
    "54112": (45.306273, -88.002389),
    "54113": (44.348711, -88.361208),
    "54114": (45.261661, -88.078001),
    "54115": (44.453629, -87.978279),
    "54119": (45.591557, -88.222435),
    "54120": (45.74447, -88.47565),
    "54121": (45.845525, -88.284254),
    "54123": (44.211065, -88.151532),
    "54124": (44.916397, -88.174299),
    "54125": (45.648826, -88.333152),
    "54126": (44.347365, -88.037736),
    "54127": (44.804687, -88.269238),
    "54128": (44.806061, -88.732786),
    "54129": (44.146516, -88.195124),
    "54130": (44.334465, -88.295776),
    "54131": (44.416326, -88.464873),
    "54135": (44.88646, -88.575133),
    "54136": (44.303208, -88.473445),
    "54137": (44.755693, -88.289822),
    "54138": (45.308254, -88.477771),
    "54139": (45.063468, -88.214802),
    "54140": (44.294746, -88.316305),
    "54141": (44.744566, -87.995493),
    "54143": (45.086805, -87.716311),
    "54149": (45.095725, -88.47889),
    "54150": (44.86893, -88.618552),
    "54151": (45.579448, -87.918821),
    "54152": (44.566799, -88.458164),
    "54153": (44.897088, -88.082586),
    "54154": (44.901999, -88.125829),
    "54155": (44.447167, -88.23333),
    "54156": (45.392437, -87.904337),
    "54157": (45.174269, -87.902),
    "54159": (45.205901, -87.8274),
    "54160": (44.119917, -88.096495),
    "54161": (45.117544, -87.977136),
    "54162": (44.583761, -88.103417),
    "54165": (44.430443, -88.463328),
    "54166": (44.745058, -88.664156),
    "54169": (44.167388, -88.229438),
    "54170": (44.482935, -88.589547),
    "54171": (44.726641, -88.121792),
    "54173": (44.635701, -88.122034),
    "54174": (45.111843, -88.418694),
    "54175": (45.309457, -88.605896),
    "54177": (45.383307, -87.876231),
    "54180": (44.494921, -88.124743),
    "54182": (44.731453, -88.369842),
    "54201": (44.596017, -87.540266),
    "54202": (45.077002, -87.14603),
    "54203": (44.109853, -87.483874),
    "54204": (44.752379, -87.625888),
    "54205": (44.596082, -87.637308),
    "54207": (44.091021, -87.990241),
    "54208": (44.459153, -87.885734),
    "54209": (45.012261, -87.266031),
    "54210": (45.253108, -87.044698),
    "54211": (45.159184, -87.171024),
    "54212": (45.11038, -87.209899),
    "54213": (44.722418, -87.528122),
    "54214": (44.204875, -87.715629),
    "54215": (44.222585, -87.801651),
    "54216": (44.438185, -87.592719),
    "54217": (44.541977, -87.670551),
    "54220": (44.109709, -87.714403),
    "54221": (44.132295, -87.599031),
    "54226": (45.059713, -87.006012),
    "54227": (44.276554, -87.801651),
    "54228": (44.167783, -87.739206),
    "54229": (44.571416, -87.833306),
    "54230": (44.142382, -87.904684),
    "54232": (44.005714, -87.922351),
    "54234": (45.178293, -87.101748),
    "54235": (44.945314, -87.384142),
    "54240": (44.282802, -87.632398),
    "54241": (44.225538, -87.627759),
    "54245": (44.053321, -87.899912),
    "54246": (45.373786, -86.897472),
    "54247": (44.189293, -87.781594),
    "54301": (44.494385, -87.976051),
    "54302": (44.495042, -87.978652),
    "54303": (44.552247, -88.078803),
    "54304": (44.497541, -88.032443),
    "54305": (44.460064, -88.007382),
    "54306": (44.460064, -88.007382),
    "54307": (44.460064, -88.007382),
    "54308": (44.459509, -87.805912),
    "54311": (44.523605, -87.95768699999999),
    "54313": (44.54964, -87.99597),
    "54324": (44.460064, -88.007382),
    "54344": (44.42504, -88.111252),
    "54401": (44.961874, -89.794002),
    "54402": (44.900936, -89.7701),
    "54403": (44.952863, -89.531804),
    "54404": (44.466554, -90.02136),
    "54405": (44.960186, -90.374893),
    "54406": (44.393087, -89.335313),
    "54407": (44.530435, -89.356252),
    "54408": (45.008812, -89.357822),
    "54409": (45.160809, -89.093942),
    "54410": (44.535658, -90.007245),
    "54411": (44.982348, -90.007765),
    "54412": (44.559652, -90.00532),
    "54413": (44.298272, -90.140404),
    "54414": (44.919163, -89.1042),
    "54415": (44.619128, -89.918563),
    "54416": (44.898739, -88.838922),
    "54417": (45.02735, -89.654118),
    "54418": (45.160395, -88.994008),
    "54420": (44.606893, -90.375852),
    "54421": (44.879977, -90.384734),
    "54422": (44.944027, -90.52792),
    "54423": (44.580724000000004, -89.586502),
    "54424": (45.272303, -89.086848),
    "54425": (44.996496, -90.374411),
    "54426": (44.904647, -90.012469),
    "54427": (44.808419, -89.301349),
    "54428": (45.413361, -89.143347),
    "54429": (44.780171, -89.247809),
    "54430": (45.212455, -88.83459),
    "54432": (44.900936, -89.7701),
    "54433": (45.197791, -90.632113),
    "54434": (45.206757, -90.484132),
    "54435": (45.38097, -89.607232),
    "54436": (44.607247, -90.457313),
    "54437": (44.660403, -90.6756),
    "54439": (45.206757, -90.484132),
    "54440": (44.797963, -89.513916),
    "54441": (44.645875, -90.105056),
    "54442": (45.366386, -89.670022),
    "54443": (44.588962, -89.707997),
    "54444": (45.249382, -89.032136),
    "54446": (44.729482, -90.634557),
    "54447": (45.16658, -90.769811),
    "54448": (44.875437, -89.80077),
    "54449": (44.589394, -90.190595),
    "54450": (45.006232, -89.047379),
    "54451": (45.164705, -90.445798),
    "54452": (45.217518, -89.713291),
    "54454": (44.598179, -89.904543),
    "54455": (44.809226, -89.701277),
    "54456": (44.688149, -90.669407),
    "54457": (44.299968, -89.920843),
    "54458": (44.490241, -89.310944),
    "54459": (45.451541, -90.287732),
    "54460": (44.900923, -90.627475),
    "54462": (45.386148, -88.971242),
    "54463": (45.525897, -89.236033),
    "54464": (45.249382, -89.032136),
    "54465": (45.362544, -88.950339),
    "54466": (44.408897, -90.190911),
    "54467": (44.413942, -89.565507),
    "54469": (44.350934, -89.876274),
    "54470": (45.208013, -90.168991),
    "54471": (44.929692, -89.364964),
    "54472": (44.466554, -90.02136),
    "54473": (44.605786, -89.356834),
    "54474": (44.898819, -89.712935),
    "54475": (44.474097, -89.795501),
    "54476": (44.866501, -89.576968),
    "54479": (44.805167, -90.141112),
    "54480": (45.19405, -90.302783),
    "54481": (44.551808, -89.531871),
    "54484": (44.809072, -90.030674),
    "54485": (45.396466, -89.217933),
    "54486": (44.75984, -89.039052),
    "54487": (45.337814, -89.765239),
    "54488": (44.840956, -90.257456),
    "54489": (44.462338, -90.003283),
    "54490": (45.330939, -90.401519),
    "54491": (45.248003, -88.803154),
    "54492": (44.509433, -89.528584),
    "54493": (44.715341, -90.769733),
    "54494": (44.379694, -89.918546),
    "54495": (44.388082, -89.922751),
    "54498": (44.944248, -90.638388),
    "54499": (44.801314, -89.11476),
    "54501": (45.704474, -89.386562),
    "54511": (45.711791, -88.810386),
    "54512": (46.078442, -89.531393),
    "54513": (45.584525, -90.166914),
    "54514": (46.394779, -90.628174),
    "54515": (45.535762, -90.504465),
    "54517": (46.645163, -90.442721),
    "54519": (46.072385, -89.260939),
    "54520": (45.511846, -88.891846),
    "54521": (45.988126, -89.265609),
    "54524": (45.814336, -90.453045),
    "54525": (46.395746, -90.191139),
    "54526": (45.486195, -90.847935),
    "54527": (46.126107, -90.611172),
    "54529": (45.690115, -89.663974),
    "54530": (45.518558, -90.743138),
    "54531": (45.74835, -89.821598),
    "54532": (45.337678, -89.735524),
    "54534": (46.371032, -90.221645),
    "54536": (46.318241, -90.342024),
    "54537": (45.528816, -90.606178),
    "54538": (46.068073, -89.76566),
    "54539": (45.775685, -89.574808),
    "54540": (46.073659, -89.444514),
    "54541": (45.561723, -88.706496),
    "54542": (45.913837, -88.623498),
    "54543": (45.72293, -89.557263),
    "54545": (46.155097, -89.845465),
    "54546": (46.320677, -90.746141),
    "54547": (46.143746, -90.110725),
    "54548": (45.827583, -89.824294),
    "54550": (46.396613, -90.309085),
    "54552": (45.846473, -90.360373),
    "54554": (46.092807, -89.257762),
    "54555": (45.724607, -90.37098399999999),
    "54556": (45.532944, -90.28166),
    "54557": (46.200011, -89.738691),
    "54558": (45.942092, -89.686925),
    "54559": (46.502552, -90.402719),
    "54560": (46.02023, -89.497889),
    "54561": (46.061297, -89.485834),
    "54562": (45.762075, -89.157339),
    "54563": (45.45197, -90.964443),
    "54564": (45.725515, -89.943993),
    "54565": (46.370313, -90.434344),
    "54566": (45.443574, -88.619413),
    "54568": (45.859618, -89.653705),
    "54601": (43.85456, -91.132072),
    "54602": (43.907739, -91.167621),
    "54603": (43.853763, -91.246238),
    "54610": (44.346721, -91.836481),
    "54611": (44.451027, -90.975918),
    "54612": (44.251711, -91.387699),
    "54613": (44.079992, -89.803877),
    "54614": (43.919308, -91.081457),
    "54615": (44.295394, -90.83128),
    "54616": (44.251701, -91.264753),
    "54618": (43.988481, -90.239261),
    "54619": (43.851133, -90.699047),
    "54620": (44.087601, -90.842289),
    "54621": (43.667006, -90.741409),
    "54622": (44.237714, -91.741701),
    "54623": (43.574486, -91.043819),
    "54624": (43.480668, -91.133309),
    "54625": (44.14309, -91.520432),
    "54626": (43.220573, -91.034135),
    "54627": (44.184171, -91.257707),
    "54628": (43.319219, -91.054678),
    "54629": (44.170774, -91.674962),
    "54630": (44.094809, -91.339528),
    "54631": (43.269667, -90.83178),
    "54632": (43.618089, -90.837971),
    "54634": (43.616843, -90.659829),
    "54635": (44.40376, -91.044171),
    "54636": (43.968617, -91.223484),
    "54637": (43.88013, -90.272928),
    "54638": (43.816431, -90.40265),
    "54639": (43.600044, -90.636482),
    "54640": (43.266172, -91.022031),
    "54641": (43.94521, -90.049489),
    "54642": (44.196358, -90.979249),
    "54643": (44.186869, -90.635831),
    "54644": (44.021422, -91.03295),
    "54645": (43.206361, -90.940479),
    "54646": (44.022637, -90.130552),
    "54648": (43.83159, -90.647476),
    "54649": (43.971514, -90.361161),
    "54650": (43.886664, -91.130399),
    "54651": (43.696538, -90.548053),
    "54652": (43.470286, -90.774539),
    "54653": (43.841142, -90.950732),
    "54654": (43.206361, -90.940479),
    "54655": (43.369813, -90.808363),
    "54656": (43.949925, -90.752783),
    "54657": (43.274205, -90.924336),
    "54658": (43.669102, -91.134346),
    "54659": (44.291449, -91.087671),
    "54660": (43.983826, -90.473336),
    "54661": (44.076755, -91.460168),
    "54662": (44.003084, -90.562005),
    "54664": (43.501783, -90.706816),
    "54665": (43.530515, -90.991573),
    "54666": (43.987879, -90.466582),
    "54667": (43.653701, -90.841723),
    "54669": (43.897572, -91.120198),
    "54670": (43.848835, -90.468791),
    "54701": (44.75653, -91.473097),
    "54702": (44.726626, -91.285931),
    "54703": (44.80456, -91.477897),
    "54720": (44.803612, -91.442253),
    "54721": (44.602774, -92.062219),
    "54722": (44.726811, -91.212598),
    "54723": (44.631517, -92.435186),
    "54724": (45.042352, -91.408026),
    "54725": (45.075804, -92.013036),
    "54726": (45.00521, -91.175615),
    "54727": (45.015803, -91.353301),
    "54728": (45.405423, -91.828102),
    "54729": (44.958689, -91.319492),
    "54730": (45.037889, -91.888046),
    "54731": (45.357563, -91.088353),
    "54732": (45.125153, -91.170922),
    "54733": (45.261871, -91.845156),
    "54734": (45.001949, -92.099665),
    "54735": (44.946496, -91.90344),
    "54736": (44.640224, -91.831869),
    "54737": (44.749316, -92.04191),
    "54738": (44.394025, -91.411701),
    "54739": (44.855107, -91.736968),
    "54740": (44.744453, -92.226414),
    "54741": (44.659822, -91.014753),
    "54742": (44.762892, -91.306304),
    "54743": (44.311074, -91.806396),
    "54744": (45.319786, -91.881754),
    "54745": (45.150752, -91.121308),
    "54746": (44.516708, -90.709853),
    "54747": (44.356483, -91.443718),
    "54748": (45.088875, -91.256794),
    "54749": (44.947538, -92.07521),
    "54750": (44.623923, -92.29072),
    "54751": (44.867809, -91.943198),
    "54754": (44.436841, -90.796318),
    "54755": (44.48773, -91.68068),
    "54756": (44.473584, -91.910518),
    "54757": (45.118159, -91.486707),
    "54758": (44.333502, -91.347015),
    "54759": (44.509108, -92.131821),
    "54760": (44.424863, -91.207421),
    "54761": (44.619607, -92.180419),
    "54762": (45.262353, -91.992842),
    "54763": (45.168279, -91.875797),
    "54764": (44.946496, -91.90344),
    "54765": (45.142866, -91.699794),
    "54766": (45.349548, -90.887173),
    "54767": (44.781928, -92.283761),
    "54768": (44.993395, -91.069525),
    "54769": (44.508365, -92.232594),
    "54770": (44.387425, -91.394415),
    "54771": (44.894112, -90.790684),
    "54772": (45.094148, -91.879257),
    "54773": (44.443778, -91.285758),
    "54774": (45.07413, -91.294397),
    "54801": (45.922016, -91.811707),
    "54805": (45.434373, -91.965942),
    "54806": (46.558577, -90.738773),
    "54810": (45.421648, -92.378752),
    "54812": (45.47734, -91.86779),
    "54813": (45.557393, -92.016728),
    "54814": (46.853517, -90.915934),
    "54816": (46.682796, -91.143254),
    "54817": (45.732675, -91.615044),
    "54818": (45.423409, -91.848206),
    "54819": (45.469246, -91.293073),
    "54820": (46.555409, -91.605419),
    "54821": (46.21018, -91.189305),
    "54822": (45.465645, -91.68441),
    "54824": (45.420898, -92.544088),
    "54826": (45.495679, -92.037821),
    "54827": (46.834502, -91.092821),
    "54828": (45.837967, -91.291784),
    "54829": (45.42772, -91.899489),
    "54830": (45.972603, -92.292996),
    "54832": (46.682796, -91.143254),
    "54834": (45.742371, -91.476541),
    "54835": (45.780382, -91.224718),
    "54836": (46.452892, -92.171445),
    "54837": (45.526263, -92.429333),
    "54838": (46.293033, -91.894633),
    "54839": (46.682796, -91.143254),
    "54840": (45.795342, -92.693513),
    "54841": (45.620445, -91.801751),
    "54842": (46.514162, -91.862136),
    "54843": (45.955223, -91.278308),
    "54844": (46.682796, -91.143254),
    "54845": (45.799612, -92.153743),
    "54846": (46.376072, -90.761153),
    "54847": (46.599552, -91.437437),
    "54848": (45.490835, -91.0943),
    "54849": (46.493011, -91.71342),
    "54850": (46.803272, -90.692287),
    "54851": (45.468941, -92.521938),
    "54853": (45.455357, -92.467658),
    "54854": (46.652638, -91.733798),
    "54855": (46.366834, -90.840821),
    "54856": (46.362341, -91.116899),
    "54857": (45.609562, -91.61965000000001),
    "54858": (45.51583, -92.461712),
    "54859": (46.09709, -91.859913),
    "54861": (46.560783, -90.619716),
    "54862": (45.797008, -91.127234),
    "54864": (46.594249, -91.815333),
    "54865": (46.715564, -91.353195),
    "54867": (45.800649, -91.268979),
    "54868": (45.519692, -91.826575),
    "54870": (45.73714, -91.775875),
    "54871": (45.878356, -91.79215),
    "54872": (45.782741, -92.385751),
    "54873": (46.417261, -91.810992),
    "54874": (46.568809, -91.935156),
    "54875": (45.945201, -91.675448),
    "54876": (45.821216, -91.462771),
    "54880": (46.574982, -92.117578),
    "54888": (45.966368, -91.886372),
    "54889": (45.400115, -92.074695),
    "54890": (46.525129, -91.921631),
    "54891": (46.697289, -90.904151),
    "54893": (45.869606, -92.30286),
    "54895": (45.40913, -91.423051),
    "54896": (45.832746, -91.014362),
    "54901": (44.005661, -88.55756),
    "54902": (43.99461, -88.526025),
    "54903": (44.06858, -88.644873),
    "54904": (44.062366, -88.623779),
    "54906": (44.06858, -88.644873),
    "54909": (44.379544, -89.356552),
    "54911": (44.275702, -88.370856),
    "54912": (44.416326, -88.464873),
    "54913": (44.345553, -88.434297),
    "54914": (44.271285, -88.486307),
    "54915": (44.373778, -88.444396),
    "54919": (44.416326, -88.464873),
    "54921": (44.341602, -89.526303),
    "54922": (44.432373, -88.559628),
    "54923": (43.915726, -89.027124),
    "54926": (44.617819, -89.016622),
    "54927": (44.103137, -88.653949),
    "54928": (44.735836, -88.876673),
    "54929": (44.593386, -88.868093),
    "54930": (44.026085, -89.486854),
    "54931": (44.416326, -88.464873),
    "54932": (43.832253, -88.582166),
    "54933": (44.668605, -88.704318),
    "54934": (44.003153, -88.839692),
    "54935": (43.734724, -88.523176),
    "54936": (43.740559, -88.522984),
    "54937": (43.765009, -88.605657),
    "54940": (44.272779, -88.833282),
    "54941": (43.85627, -88.985883),
    "54942": (44.286983, -88.556406),
    "54943": (44.103548, -89.491566),
    "54944": (44.342058, -88.588244),
    "54945": (44.572209, -89.071142),
    "54946": (44.336537, -89.146258),
    "54947": (44.194993, -88.688629),
    "54948": (44.781006, -88.890714),
    "54949": (44.488057, -88.926954),
    "54950": (44.546623, -88.937717),
    "54951": (44.416326, -88.464873),
    "54952": (44.141025, -88.569088),
    "54956": (44.170785, -88.658087),
    "54957": (44.198944, -88.678863),
    "54960": (43.922097, -89.310982),
    "54961": (44.405595, -88.859107),
    "54962": (44.426783, -88.993214),
    "54963": (44.050782, -88.754887),
    "54964": (43.956653, -88.71918),
    "54965": (44.155967, -89.02096),
    "54966": (44.191887, -89.297481),
    "54967": (44.134044, -88.986361),
    "54968": (43.832741, -89.122651),
    "54969": (44.269991, -88.775457),
    "54970": (44.080217, -89.217031),
    "54971": (43.782526, -88.533445),
    "54974": (43.775697, -88.659504),
    "54975": (44.461926, -88.915027),
    "54976": (44.209313, -89.096856),
    "54977": (44.451051, -89.146915),
    "54978": (44.79604, -88.898362),
    "54979": (43.839613, -88.543924),
    "54980": (43.988578, -88.771167),
    "54981": (44.429163, -89.04668),
    "54982": (44.075321, -89.271177),
    "54983": (44.332498, -88.922821),
    "54984": (44.168882, -89.223228),
    "54985": (44.070584, -88.517762),
    "54986": (44.124886, -88.745129),
    "54990": (44.461926, -88.915027),
    "55001": (44.90717, -92.816193),
    "55002": (45.513447, -92.894239),
    "55003": (45.013918, -92.781055),
    "55005": (45.388716, -93.231538),
    "55006": (45.69146, -93.278348),
    "55007": (45.947444, -93.073628),
    "55008": (45.602457, -93.263457),
    "55009": (44.483189, -92.885609),
    "55010": (44.547215, -93.153115),
    "55011": (45.341448, -93.235026),
    "55012": (45.448211, -92.789369),
    "55013": (45.362621, -92.902261),
    "55014": (45.185565, -93.129272),
    "55016": (44.818216, -92.92861),
    "55017": (45.660954, -93.430806),
    "55018": (44.426537, -92.955359),
    "55019": (44.398613, -93.194444),
    "55020": (44.588963, -93.369473),
    "55021": (44.36287, -93.267456),
    "55024": (44.640515, -93.14196),
    "55025": (45.246466, -92.949266),
    "55026": (44.520038, -92.358158),
    "55027": (44.427157, -92.620355),
    "55029": (45.642235, -93.201107),
    "55030": (45.856598, -93.081255),
    "55031": (44.608467, -92.955479),
    "55032": (45.593629, -92.998865),
    "55033": (44.737166, -93.032909),
    "55036": (45.854335, -93.124235),
    "55037": (46.014689, -92.938103),
    "55038": (45.182366, -92.945218),
    "55040": (45.565289, -93.287101),
    "55041": (44.421753, -92.232221),
    "55042": (44.992866, -92.898177),
    "55043": (44.940859, -92.789447),
    "55044": (44.633421, -93.25812),
    "55045": (45.404477, -92.823088),
    "55046": (44.447704, -93.425156),
    "55047": (45.198774, -92.825767),
    "55049": (44.160283, -93.246471),
    "55051": (45.918782, -93.297792),
    "55052": (44.328365, -93.342652),
    "55053": (44.32738, -93.242155),
    "55054": (44.571056, -93.354267),
    "55055": (44.872395, -92.993263),
    "55056": (45.556522, -92.885433),
    "55057": (44.376816, -93.241838),
    "55060": (44.047613, -93.223724),
    "55063": (45.949599, -92.892997),
    "55065": (44.545066, -93.02496),
    "55066": (44.521909, -92.537774),
    "55067": (46.074687, -92.718004),
    "55068": (44.661216, -93.076163),
    "55069": (45.67987, -92.978158),
    "55070": (45.393554, -93.357614),
    "55071": (44.822826, -92.989204),
    "55072": (46.132453, -92.588959),
    "55073": (45.253166, -92.837344),
    "55074": (45.382835, -92.726135),
    "55075": (44.890315, -93.049879),
    "55076": (44.828816, -93.039064),
    "55077": (44.828265, -93.093969),
    "55078": (45.513447, -92.894239),
    "55079": (45.405278, -92.969118),
    "55080": (45.651313, -93.275622),
    "55082": (45.061416, -92.84736),
    "55083": (45.021016, -92.983726),
    "55084": (45.457557, -92.733042),
    "55085": (44.674799, -92.968309),
    "55087": (44.239946, -93.397354),
    "55088": (44.500341, -93.382574),
    "55089": (44.575372, -92.704731),
    "55090": (45.053466, -92.957034),
    "55092": (45.336417, -92.967517),
    "55101": (44.967965, -93.092168),
    "55102": (44.932929, -93.118968),
    "55103": (44.967215, -93.125319),
    "55104": (44.955615, -93.16702),
    "55105": (44.934515, -93.16097),
    "55106": (44.957065, -93.041616),
    "55107": (44.932465, -93.087967),
    "55108": (44.980614, -93.177122),
    "55109": (45.013234, -93.029667),
    "55110": (45.079965, -93.022317),
    "55111": (44.882838, -93.200671),
    "55112": (45.078815, -93.187223),
    "55113": (45.013895, -93.157071),
    "55114": (44.964115, -93.194872),
    "55115": (45.070951, -92.939113),
    "55116": (44.911215, -93.165356),
    "55117": (45.002115, -93.106269),
    "55118": (44.856615, -93.113028),
    "55119": (44.941415, -93.010714),
    "55120": (44.870365, -93.143369),
    "55121": (44.822093, -93.15908),
    "55122": (44.786018, -93.22020499999999),
    "55123": (44.805989, -93.140878),
    "55124": (44.749701, -93.202881),
    "55125": (44.919716, -92.943876),
    "55126": (45.073561, -93.138022),
    "55127": (45.080265, -93.08752),
    "55128": (44.991316, -92.948738),
    "55129": (44.898516, -92.92301),
    "55133": (45.005902, -93.105869),
    "55144": (45.005902, -93.105869),
    "55145": (45.005902, -93.105869),
    "55146": (44.942656, -93.082793),
    "55150": (44.886554, -93.161258),
    "55155": (44.952165, -93.095518),
    "55161": (45.005902, -93.105869),
    "55164": (44.990915, -93.106593),
    "55165": (45.005902, -93.105869),
    "55166": (45.005902, -93.105869),
    "55168": (45.005902, -93.105869),
    "55169": (45.005902, -93.105869),
    "55170": (45.005902, -93.105869),
    "55171": (45.005902, -93.105869),
    "55172": (45.005902, -93.105869),
    "55175": (45.005902, -93.105869),
    "55177": (45.005902, -93.105869),
    "55182": (45.005902, -93.105869),
    "55187": (45.005902, -93.105869),
    "55188": (45.005902, -93.105869),
    "55190": (45.005902, -93.105869),
    "55191": (45.005902, -93.105869),
    "55301": (45.258673, -93.664342),
    "55302": (45.218652, -94.105948),
    "55303": (45.282482, -93.418574),
    "55304": (45.237661, -93.272428),
    "55305": (44.952763, -93.43723),
    "55306": (44.762208, -93.221535),
    "55307": (44.597449, -94.105481),
    "55308": (45.451864, -93.842187),
    "55309": (45.367294, -93.686916),
    "55310": (44.753182, -94.848215),
    "55311": (45.124263, -93.499583),
    "55312": (44.758102, -94.251718),
    "55313": (45.180732, -93.927556),
    "55314": (44.71031, -94.752767),
    "55315": (44.723162, -93.701637),
    "55316": (45.176914, -93.397481),
    "55317": (44.853364, -93.572584),
    "55318": (44.810062, -93.653336),
    "55319": (45.466197, -93.952504),
    "55320": (45.226627, -93.92441),
    "55321": (45.086044, -94.185096),
    "55322": (44.768262, -93.787041),
    "55323": (45.015914, -93.47188),
    "55324": (45.070558, -94.420292),
    "55325": (45.102011, -94.368691),
    "55327": (45.201514, -93.482833),
    "55328": (45.041472, -93.97792),
    "55329": (45.282592, -94.524712),
    "55330": (45.403289, -93.644522),
    "55331": (44.912712, -93.623186),
    "55332": (44.595338, -94.726284),
    "55333": (44.564953, -94.891273),
    "55334": (44.572583, -94.191699),
    "55335": (44.55017, -94.543258),
    "55336": (44.770238, -94.195685),
    "55337": (44.771547, -93.226258),
    "55338": (44.63575, -94.057781),
    "55339": (44.785812, -93.837873),
    "55340": (45.073663, -93.568735),
    "55341": (45.160196, -93.673418),
    "55342": (44.70976, -94.756704),
    "55343": (44.913969, -93.44813),
    "55344": (44.850563, -93.440429),
    "55345": (44.916963, -93.481749),
    "55346": (44.875463, -93.47808),
    "55347": (44.841713, -93.459829),
    "55348": (44.848263, -93.398727),
    "55349": (45.101679, -94.047497),
    "55350": (44.875565, -94.266332),
    "55352": (44.658362, -93.601183),
    "55353": (45.36261, -94.309928),
    "55354": (44.880454, -94.100616),
    "55355": (45.122737, -94.529861),
    "55356": (44.995129, -93.593836),
    "55357": (45.100098, -93.657256),
    "55358": (45.214072, -94.060149),
    "55359": (44.983312, -93.689162),
    "55360": (44.905962, -93.913561),
    "55361": (44.940212, -93.592735),
    "55362": (45.249636, -93.851533),
    "55363": (45.048202, -94.056543),
    "55364": (44.935062, -93.662938),
    "55365": (45.200875, -93.888099),
    "55366": (44.673454, -94.229311),
    "55367": (44.899612, -93.970832),
    "55368": (44.738862, -93.89995),
    "55369": (45.128414, -93.458932),
    "55370": (44.839939, -94.050518),
    "55371": (45.740703, -93.63663),
    "55372": (44.682763, -93.464428),
    "55373": (45.155019, -93.865168),
    "55374": (45.168896, -93.574586),
    "55375": (44.904062, -93.74904),
    "55376": (45.16826, -93.893628),
    "55377": (45.540181, -93.815434),
    "55378": (44.751113, -93.367975),
    "55379": (44.731113, -93.474144),
    "55380": (45.315823, -93.979766),
    "55381": (44.921134, -94.195425),
    "55382": (45.265248, -94.165984),
    "55383": (44.805487, -93.766524),
    "55384": (44.936862, -93.630286),
    "55385": (44.766671, -94.344376),
    "55386": (44.846645, -93.661737),
    "55387": (44.844847, -93.746148),
    "55388": (44.924416, -93.853894),
    "55389": (45.268619, -94.444561),
    "55390": (45.060676, -93.974555),
    "55391": (44.984663, -93.542233),
    "55392": (45.015914, -93.47188),
    "55393": (45.200875, -93.888099),
    "55394": (44.805487, -93.766524),
    "55395": (44.946121, -94.07572),
    "55396": (44.550833, -94.347525),
    "55397": (44.800912, -93.919675),
    "55398": (45.467503, -93.602475),
    "55399": (44.805487, -93.766524),
    "55401": (44.979265, -93.273024),
    "55402": (44.975915, -93.271825),
    "55403": (44.972615, -93.287275),
    "55404": (44.948614, -93.329926),
    "55405": (44.970114, -93.300275),
    "55406": (44.976015, -93.278975),
    "55407": (44.935465, -93.254023),
    "55408": (44.947515, -93.288975),
    "55409": (44.925014, -93.289224),
    "55410": (44.912364, -93.318825),
    "55411": (44.999514, -93.297393),
    "55412": (45.025115, -93.298876),
    "55413": (44.994365, -93.240774),
    "55414": (44.974515, -93.234173),
    "55415": (44.974215, -93.258474),
    "55416": (44.949714, -93.337326),
    "55417": (44.962965, -93.253624),
    "55418": (45.017765, -93.244524),
    "55419": (44.890914, -93.282724),
    "55420": (44.835164, -93.255222),
    "55421": (45.052315, -93.254075),
    "55422": (45.009601, -93.342428),
    "55423": (44.875614, -93.255272),
    "55424": (44.905164, -93.340326),
    "55425": (44.842664, -93.236286),
    "55426": (44.955014, -93.382928),
    "55427": (44.999964, -93.390979),
    "55428": (44.981413, -93.372979),
    "55429": (44.975664, -93.336926),
    "55430": (45.063923, -93.302227),
    "55431": (44.828764, -93.311823),
    "55432": (45.094965, -93.23957),
    "55433": (45.164263, -93.319278),
    "55434": (45.170399, -93.226925),
    "55435": (44.932864, -93.367327),
    "55436": (44.901163, -93.42267),
    "55437": (44.826064, -93.353791),
    "55438": (44.826613, -93.375027),
    "55439": (44.874414, -93.375277),
    "55440": (45.015914, -93.47188),
    "55441": (45.005804, -93.419323),
    "55442": (45.04674, -93.431047),
    "55443": (45.119364, -93.34312),
    "55444": (45.117765, -93.305378),
    "55445": (45.123064, -93.352439),
    "55446": (45.040013, -93.486482),
    "55447": (45.003335, -93.487482),
    "55448": (45.174056, -93.313274),
    "55449": (45.169739, -93.188924),
    "55450": (44.881113, -93.220658),
    "55454": (44.980859, -93.252524),
    "55455": (45.038364, -93.298376),
    "55458": (45.015914, -93.47188),
    "55459": (45.015914, -93.47188),
    "55460": (45.015914, -93.47188),
    "55468": (45.015914, -93.47188),
    "55470": (45.015914, -93.47188),
    "55472": (45.015914, -93.47188),
    "55473": (44.805487, -93.766524),
    "55474": (45.015914, -93.47188),
    "55478": (45.015914, -93.47188),
    "55479": (45.015914, -93.47188),
    "55480": (45.015914, -93.47188),
    "55483": (45.015914, -93.47188),
    "55484": (45.015914, -93.47188),
    "55485": (45.015914, -93.47188),
    "55486": (45.015914, -93.47188),
    "55487": (45.015914, -93.47188),
    "55488": (45.015914, -93.47188),
    "55550": (44.805487, -93.766524),
    "55551": (44.805487, -93.766524),
    "55552": (44.805487, -93.766524),
    "55553": (44.805487, -93.766524),
    "55554": (44.805487, -93.766524),
    "55555": (44.805487, -93.766524),
    "55556": (44.805487, -93.766524),
    "55557": (44.805487, -93.766524),
    "55558": (44.805487, -93.766524),
    "55559": (44.805487, -93.766524),
    "55560": (44.805487, -93.766524),
    "55561": (44.805487, -93.766524),
    "55562": (44.805487, -93.766524),
    "55563": (44.805487, -93.766524),
    "55564": (44.805487, -93.766524),
    "55565": (45.200875, -93.888099),
    "55566": (44.805487, -93.766524),
    "55567": (44.805487, -93.766524),
    "55568": (44.805487, -93.766524),
    "55569": (45.015914, -93.47188),
    "55570": (45.015914, -93.47188),
    "55571": (45.015914, -93.47188),
    "55572": (45.015914, -93.47188),
    "55573": (45.015914, -93.47188),
    "55574": (45.015914, -93.47188),
    "55575": (45.015914, -93.47188),
    "55576": (45.015914, -93.47188),
    "55577": (45.015914, -93.47188),
    "55578": (45.015914, -93.47188),
    "55579": (45.015914, -93.47188),
    "55580": (45.200875, -93.888099),
    "55581": (45.200875, -93.888099),
    "55582": (45.200875, -93.888099),
    "55583": (44.805487, -93.766524),
    "55584": (45.200875, -93.888099),
    "55585": (45.200875, -93.888099),
    "55586": (45.200875, -93.888099),
    "55587": (45.200875, -93.888099),
    "55588": (44.989512, -93.880245),
    "55589": (45.200875, -93.888099),
    "55590": (45.200875, -93.888099),
    "55591": (45.200875, -93.888099),
    "55592": (45.200875, -93.888099),
    "55593": (45.015914, -93.47188),
    "55594": (44.805487, -93.766524),
    "55595": (45.015914, -93.47188),
    "55596": (45.015914, -93.47188),
    "55597": (45.015914, -93.47188),
    "55598": (45.015914, -93.47188),
    "55599": (45.015914, -93.47188),
    "55601": (47.256021, -91.356586),
    "55602": (47.256933, -92.00427),
    "55603": (47.497114, -91.320571),
    "55604": (47.872285, -90.42294),
    "55605": (47.923022, -89.851983),
    "55606": (47.851669, -90.001214),
    "55607": (47.660406, -91.498861),
    "55609": (46.95388, -91.777997),
    "55612": (47.7059, -90.682372),
    "55613": (47.518552, -90.949997),
    "55614": (47.358488, -91.220483),
    "55615": (47.648636, -90.801861),
    "55616": (47.134891, -91.545363),
    "55701": (47.640367, -92.442797),
    "55702": (47.014861, -92.612312),
    "55703": (47.753747, -92.756769),
    "55704": (46.215511, -92.759076),
    "55705": (47.634557, -92.071317),
    "55706": (47.742305, -91.953532),
    "55707": (46.556833, -92.720097),
    "55708": (47.532826, -92.340774),
    "55709": (47.347269, -93.388826),
    "55710": (47.645047, -92.651923),
    "55711": (46.837747, -92.680451),
    "55712": (46.2263, -92.705581),
    "55713": (47.493197, -92.764262),
    "55716": (47.322883, -93.276267),
    "55717": (47.0686, -92.442794),
    "55718": (46.622794999999996, -92.675569),
    "55719": (47.563308, -92.443251),
    "55720": (46.592512, -92.549564),
    "55721": (47.238241, -93.516501),
    "55722": (47.377503, -93.385597),
    "55723": (47.877563, -92.768568),
    "55724": (47.152067, -92.435223),
    "55725": (48.241245, -92.525385),
    "55726": (46.654061, -92.836499),
    "55730": (47.087782, -93.921429),
    "55731": (47.918943, -92.020778),
    "55732": (47.662641, -92.228145),
    "55733": (46.712582, -92.364896),
    "55734": (47.386893, -92.452058),
    "55735": (46.23792, -92.950358),
    "55736": (46.937895, -92.837735),
    "55738": (47.273191, -92.675563),
    "55741": (47.447686, -92.366335),
    "55742": (47.167838, -93.132367),
    "55744": (47.232889, -93.393555),
    "55745": (47.087782, -93.921429),
    "55746": (47.413263, -92.87621),
    "55747": (47.640367, -92.442797),
    "55748": (46.671645, -93.432392),
    "55749": (46.482697, -92.410931),
    "55750": (47.507262, -92.112844),
    "55751": (47.420472, -92.681078),
    "55752": (46.592204, -93.433078),
    "55753": (47.398025, -93.078443),
    "55756": (46.331356, -92.662237),
    "55757": (46.52049, -92.908622),
    "55758": (47.512132, -92.740216),
    "55760": (46.607188, -93.30756),
    "55763": (47.264753, -92.181209),
    "55764": (47.321916, -93.29388),
    "55765": (47.116076, -92.803506),
    "55766": (47.249626, -92.412343),
    "55767": (46.552827, -92.756405),
    "55768": (47.454993, -92.686192),
    "55769": (47.441216, -93.243688),
    "55771": (47.742195, -92.757902),
    "55772": (48.081686, -93.083438),
    "55775": (47.287391, -93.212906),
    "55777": (47.640367, -92.442797),
    "55779": (46.910179, -92.448123),
    "55780": (46.701794, -92.639079),
    "55781": (47.551459, -92.994885),
    "55782": (47.821007, -92.246359),
    "55783": (46.367039, -92.824278),
    "55784": (47.06717, -93.190708),
    "55785": (46.696774, -93.645502),
    "55786": (47.316395, -93.342118),
    "55787": (46.630318, -93.213416),
    "55790": (47.787247, -92.338233),
    "55791": (47.640367, -92.442797),
    "55792": (47.646075, -92.499975),
    "55793": (47.241169, -93.228104),
    "55795": (46.310484, -92.863863),
    "55796": (47.720643, -92.266525),
    "55797": (46.565172, -92.657895),
    "55798": (46.614151, -92.735406),
    "55801": (47.005566, -92.001934),
    "55802": (46.904912, -92.039109),
    "55803": (47.217311, -92.1184),
    "55804": (46.886239, -92.005488),
    "55805": (46.800389, -92.094589),
    "55806": (46.774939, -92.133189),
    "55807": (46.735978, -92.17764),
    "55808": (46.683891, -92.242241),
    "55810": (46.76062, -92.266038),
    "55811": (46.814712, -92.199825),
    "55812": (46.810788, -92.072288),
    "55814": (47.640367, -92.442797),
    "55815": (47.640367, -92.442797),
    "55816": (47.640367, -92.442797),
    "55901": (44.075285, -92.516916),
    "55902": (43.972494, -92.389901),
    "55903": (43.996612999999996, -92.540929),
    "55904": (43.98622, -92.302649),
    "55905": (44.022513, -92.466826),
    "55906": (44.107815, -92.405294),
    "55909": (43.565168, -92.74389),
    "55910": (44.085616, -91.946134),
    "55912": (43.699305, -92.976818),
    "55917": (44.011627, -93.144007),
    "55918": (43.746834, -92.866996),
    "55919": (43.648232, -91.410977),
    "55920": (43.988227, -92.599372),
    "55921": (43.635474, -91.458938),
    "55922": (43.527479, -91.85297),
    "55923": (43.758684, -92.139962),
    "55924": (44.046168, -92.975313),
    "55925": (43.935613, -91.606021),
    "55926": (43.616293, -92.786355),
    "55927": (44.045362, -92.910808),
    "55929": (43.989637, -92.138889),
    "55931": (43.508371, -91.463204),
    "55932": (44.123683, -92.252177),
    "55933": (43.664334, -92.682753),
    "55934": (44.009932, -92.264837),
    "55935": (43.651181, -92.075216),
    "55936": (43.668417, -92.544587),
    "55939": (43.534993, -92.069594),
    "55940": (43.896909, -92.797679),
    "55941": (43.759533, -91.398755),
    "55942": (44.019989, -91.68187),
    "55943": (43.781431, -91.571198),
    "55944": (44.017216, -92.790593),
    "55945": (44.273871, -92.109479),
    "55946": (44.294333, -92.905937),
    "55947": (43.770564, -91.352968),
    "55949": (43.721194, -91.977384),
    "55950": (43.762936, -92.965279),
    "55951": (43.546515, -92.532554),
    "55952": (43.944412, -91.880535),
    "55953": (43.506952, -92.942939),
    "55954": (43.521277, -91.768082),
    "55955": (44.065741, -92.760046),
    "55956": (44.241752, -92.513947),
    "55957": (44.234483, -92.336216),
    "55959": (44.081907, -91.73508),
    "55960": (44.084556, -92.373869),
    "55961": (43.714209, -92.087863),
    "55962": (43.747262, -92.048539),
    "55963": (44.261029, -92.710905),
    "55964": (44.15121, -92.202044),
    "55965": (43.706377, -92.09459),
    "55967": (43.784072, -92.483567),
    "55968": (44.340826, -92.282467),
    "55969": (44.099266, -91.819882),
    "55970": (43.669317, -92.830439),
    "55971": (43.809873, -91.793376),
    "55972": (43.960809, -91.922346),
    "55973": (43.804657, -92.802913),
    "55974": (43.571029, -91.635822),
    "55975": (43.689711, -92.334603),
    "55976": (43.884346, -92.503744),
    "55977": (43.557786, -92.660555),
    "55979": (43.92098, -91.969704),
    "55981": (44.3579, -92.087925),
    "55982": (43.694738, -92.79693),
    "55983": (44.272099, -92.812034),
    "55985": (44.148244, -92.903452),
    "55987": (44.029975, -91.700889),
    "55988": (44.025217, -91.770781),
    "55990": (43.704566, -92.237117),
    "55991": (44.242705, -92.425643),
    "55992": (44.287597, -92.693235),
    "56001": (44.061451, -94.003112),
    "56002": (44.056047, -94.069828),
    "56003": (44.217193, -94.094192),
    "56006": (44.056047, -94.069828),
    "56007": (43.686288, -93.389838),
    "56009": (43.733525, -93.532143),
    "56010": (43.886884, -94.15839),
    "56011": (44.608912, -93.757888),
    "56013": (43.6503, -93.977974),
    "56014": (43.669878, -93.826733),
    "56016": (43.761669, -93.326712),
    "56017": (44.298188, -93.817622),
    "56019": (44.111351, -94.907833),
    "56020": (43.62105, -93.548214),
    "56021": (44.265888, -94.272911),
    "56022": (44.05483, -94.790185),
    "56023": (43.768062, -94.007655),
    "56024": (44.163231, -93.882127),
    "56025": (43.760823, -93.897589),
    "56026": (43.927861, -93.286367),
    "56027": (43.575712, -93.96984),
    "56028": (44.199317, -93.68198),
    "56029": (43.652544, -93.403429),
    "56030": (44.325833, -94.605226),
    "56031": (43.674049, -94.51078),
    "56032": (43.783807, -93.525396),
    "56033": (43.564879, -93.908248),
    "56034": (44.052118, -94.165036),
    "56035": (43.673904, -93.348869),
    "56036": (43.664991, -93.36173),
    "56037": (44.029182, -94.112395),
    "56039": (43.659429, -94.440978),
    "56041": (44.133457, -94.49948499999999),
    "56042": (43.803384, -93.485456),
    "56043": (43.646968, -93.244932),
    "56044": (44.564912, -93.962668),
    "56045": (43.759484, -93.204246),
    "56046": (43.955103, -93.274017),
    "56047": (43.738397, -94.228897),
    "56048": (44.051012, -93.58735),
    "56050": (44.273281, -93.931119),
    "56051": (43.550446, -93.708504),
    "56052": (44.313417, -93.574653),
    "56054": (44.361224, -94.293887),
    "56055": (44.147701, -94.212574),
    "56056": (43.978335, -94.614361),
    "56057": (44.360047, -93.781405),
    "56058": (44.390864, -93.903348),
    "56060": (43.923423, -94.434135),
    "56062": (44.050715, -94.41548),
    "56063": (44.08391, -93.862052),
    "56064": (43.763839, -93.468959),
    "56065": (43.925112, -93.952056),
    "56068": (43.811561, -93.817817),
    "56069": (44.349609, -93.580277),
    "56071": (44.536713, -93.55598),
    "56072": (43.981294, -93.561426),
    "56073": (44.259924, -94.511407),
    "56074": (44.273214, -94.188233),
    "56075": (43.735278, -94.435705),
    "56076": (43.673904, -93.348869),
    "56078": (44.007674, -93.783274),
    "56080": (44.081669, -93.857123),
    "56081": (43.982851, -94.604116),
    "56082": (44.337793, -94.070153),
    "56083": (44.282403, -95.167551),
    "56084": (44.302893, -94.738827),
    "56085": (44.317309, -94.777163),
    "56087": (44.253427, -94.903534),
    "56088": (43.789856, -94.430809),
    "56089": (43.559269, -93.420578),
    "56090": (43.925892, -94.233683),
    "56091": (43.907326, -93.682513),
    "56093": (44.065547, -93.550495),
    "56096": (44.324235, -93.569726),
    "56097": (43.702814, -93.912041),
    "56098": (43.673848, -93.948241),
    "56101": (43.900192, -95.046828),
    "56110": (43.620754, -95.953225),
    "56111": (43.674174, -95.154494),
    "56113": (44.382668, -96.1842),
    "56114": (43.960084, -95.60317),
    "56115": (44.261464, -95.889647),
    "56116": (43.612344, -96.364663),
    "56117": (43.540643, -95.687951),
    "56118": (43.895565, -95.048996),
    "56119": (43.732427, -95.512519),
    "56120": (44.002201, -94.814932),
    "56121": (43.584995, -94.606517),
    "56122": (43.92199, -95.81997),
    "56123": (44.048028, -95.704397),
    "56125": (44.053323, -95.549899),
    "56127": (43.674184, -94.550932),
    "56128": (43.930332, -96.149676),
    "56129": (43.536342, -95.983538),
    "56131": (43.905962, -95.593288),
    "56132": (44.305584, -95.86177),
    "56134": (43.810378, -96.218283),
    "56136": (44.460984, -96.33771),
    "56137": (43.795977, -95.320571),
    "56138": (43.525185, -96.358365),
    "56139": (44.09239, -96.188124),
    "56140": (43.895464, -96.364032),
    "56141": (43.891474, -95.784003),
    "56142": (44.460411, -96.246374),
    "56143": (43.650174, -95.021954),
    "56144": (43.879857, -96.342955),
    "56145": (44.055769, -95.195219),
    "56146": (43.674883, -96.252794),
    "56147": (43.674883, -96.252794),
    "56149": (44.294793, -96.270936),
    "56150": (43.678125, -95.171548),
    "56151": (44.00692, -95.825082),
    "56152": (44.282497, -95.269338),
    "56153": (43.840423, -96.012811),
    "56155": (43.682995, -95.942501),
    "56156": (43.698546, -96.163242),
    "56157": (44.399913, -95.937984),
    "56158": (43.644047, -96.07695),
    "56159": (43.939276, -94.924319),
    "56160": (43.867848, -94.742716),
    "56161": (43.738986, -95.316815),
    "56162": (43.826503, -94.663493),
    "56164": (43.989267, -96.265153),
    "56165": (43.732304, -95.703514),
    "56166": (44.23913, -95.355744),
    "56167": (43.631841, -95.640477),
    "56168": (43.623088, -95.803869),
    "56169": (44.335085, -95.97804000000001),
    "56170": (44.153916, -96.275913),
    "56171": (43.667369, -94.759431),
    "56172": (43.993479, -95.763493),
    "56173": (43.674883, -96.252794),
    "56174": (44.039624, -95.319366),
    "56175": (44.290092, -95.773754),
    "56176": (43.783229, -94.713525),
    "56177": (43.889477, -96.260066),
    "56178": (44.275371, -96.141967),
    "56180": (44.283007, -95.48189),
    "56181": (43.66727, -94.673433),
    "56183": (44.007813, -95.196562),
    "56185": (43.790084, -95.826712),
    "56186": (44.009283, -96.09925),
    "56187": (43.645207, -95.735375),
    "56201": (45.147104, -94.977723),
    "56207": (45.585961, -96.000761),
    "56208": (45.282008, -95.95757),
    "56209": (45.109205, -94.968572),
    "56210": (45.559291, -96.558886),
    "56211": (45.381402, -96.469532),
    "56212": (45.053253, -96.095554),
    "56214": (44.553001, -95.324839),
    "56215": (45.281669, -95.672102),
    "56216": (44.950076, -95.058849),
    "56218": (45.053253, -96.095554),
    "56219": (45.59432, -96.834959),
    "56220": (44.775235, -95.916433),
    "56221": (45.573876, -96.172979),
    "56222": (44.992549, -95.36042),
    "56223": (44.790853, -95.806933),
    "56224": (44.418189, -95.261177),
    "56225": (45.461092, -96.431538),
    "56226": (45.305865, -95.838919),
    "56227": (45.381402, -96.469532),
    "56228": (45.022087, -94.660884),
    "56229": (44.56956, -95.744921),
    "56230": (44.76007, -95.09754),
    "56231": (45.281751, -95.721936),
    "56232": (44.929289, -96.056499),
    "56235": (45.690959, -96.010121),
    "56236": (45.718556, -96.422981),
    "56237": (44.617739, -95.411535),
    "56239": (44.485432, -95.907811),
    "56240": (45.521519, -96.440429),
    "56241": (44.780794, -95.670577),
    "56243": (45.146898, -94.674112),
    "56244": (45.497402, -95.79426),
    "56245": (44.692039, -95.62058),
    "56246": (45.33763, -94.85611),
    "56248": (45.838396, -96.141993),
    "56249": (45.29184, -95.624619),
    "56251": (45.142577, -94.918264),
    "56252": (45.231737, -95.317927),
    "56253": (45.011036, -94.900783),
    "56255": (44.472194, -95.409783),
    "56256": (45.038164, -96.311044),
    "56257": (45.067384, -96.440184),
    "56258": (44.460429, -95.785872),
    "56260": (44.999613, -95.573816),
    "56262": (45.108407, -95.817699),
    "56263": (44.417632, -95.531336),
    "56264": (44.52307, -95.954362),
    "56265": (45.014054, -95.601718),
    "56266": (44.404589, -94.976823),
    "56267": (45.595739, -95.923233),
    "56270": (44.586097, -94.97066),
    "56271": (45.281997, -95.512817),
    "56273": (45.167597, -95.049378),
    "56274": (45.934055, -96.012359),
    "56276": (45.381402, -96.469532),
    "56277": (44.760343, -95.032641),
    "56278": (45.376691, -96.516214),
    "56279": (45.219496, -95.141233),
    "56280": (44.674215, -96.11204),
    "56281": (45.029662, -95.000152),
    "56282": (45.094173, -95.111335),
    "56283": (44.521759, -95.200255),
    "56284": (44.760675, -95.240065),
    "56285": (44.779761, -95.370482),
    "56287": (44.461267, -95.328167),
    "56288": (45.164862, -95.020124),
    "56289": (45.258882, -95.141945),
    "56291": (44.580923, -95.883387),
    "56292": (44.492318, -95.447604),
    "56293": (44.420734, -95.248847),
    "56294": (44.32978, -95.211785),
    "56295": (45.019892, -95.630814),
    "56296": (45.703481, -96.633211),
    "56297": (44.667478, -95.576938),
    "56301": (45.519196, -94.330619),
    "56302": (45.493430000000004, -94.643922),
    "56303": (45.627994, -94.223023),
    "56304": (45.544864, -94.440969),
    "56307": (45.614724, -94.494229),
    "56308": (45.902017, -95.420589),
    "56309": (46.09171, -95.816743),
    "56310": (45.599386, -94.436477),
    "56311": (45.902775, -95.85025),
    "56312": (45.509715, -94.963049),
    "56313": (45.784462, -93.552152),
    "56314": (45.868809, -94.422896),
    "56315": (45.966435, -95.516619),
    "56316": (45.513441, -95.056661),
    "56317": (46.061307, -94.208731),
    "56318": (45.86575, -94.685781),
    "56319": (45.991208, -95.371207),
    "56320": (45.470708, -94.661654),
    "56321": (45.578278, -94.419941),
    "56323": (45.641425, -95.709642),
    "56324": (46.172907, -95.918542),
    "56325": (45.563556, -94.946428),
    "56326": (45.984659, -95.670545),
    "56327": (45.728746, -95.623944),
    "56328": (45.953341, -94.546845),
    "56329": (45.691931, -93.914797),
    "56330": (45.735675, -93.647135),
    "56331": (45.643851, -94.660815),
    "56332": (45.984672, -95.506622),
    "56333": (45.691714, -94.05629),
    "56334": (45.589131, -95.357347),
    "56335": (45.597122, -94.851494),
    "56336": (45.827791, -94.77757),
    "56338": (45.990074, -93.888513),
    "56339": (45.836077, -95.791353),
    "56340": (45.623632, -94.41914),
    "56341": (45.830998, -95.541618),
    "56342": (45.973268, -93.536504),
    "56343": (45.811895, -95.665241),
    "56344": (46.061307, -94.208731),
    "56345": (45.980055, -94.245867),
    "56347": (45.904136, -94.815114),
    "56349": (45.715846, -95.540402),
    "56350": (46.195728, -93.377414),
    "56352": (45.614071, -94.634556),
    "56353": (45.90321, -93.620355),
    "56354": (46.06187, -95.295146),
    "56355": (45.935551, -95.23975),
    "56356": (45.62974, -94.751937),
    "56357": (45.702225, -93.816445),
    "56358": (45.833199, -93.402621),
    "56359": (45.943108, -93.663152),
    "56360": (45.871169, -95.237474),
    "56361": (46.150334, -95.350438),
    "56362": (45.506403, -94.734316),
    "56363": (45.697362, -93.646503),
    "56364": (45.994539, -94.123384),
    "56367": (45.745866, -94.124878),
    "56368": (45.460536, -94.536053),
    "56369": (45.468679, -94.340582),
    "56371": (45.426781, -94.633502),
    "56372": (45.52886, -94.593338),
    "56373": (45.871308, -94.161377),
    "56374": (45.614235, -94.350962),
    "56375": (45.587011, -94.380968),
    "56376": (45.489612, -94.718248),
    "56377": (45.573808, -94.355049),
    "56378": (45.638568, -94.974275),
    "56379": (45.654829, -94.073533),
    "56381": (45.572758, -95.573436),
    "56382": (45.904382, -94.540074),
    "56384": (45.804875, -94.565187),
    "56385": (45.719299, -95.225097),
    "56386": (45.989733, -93.620235),
    "56387": (45.510622, -94.667422),
    "56389": (45.799542, -95.08213),
    "56393": (45.52886, -94.593338),
    "56395": (45.52886, -94.593338),
    "56396": (45.52886, -94.593338),
    "56397": (45.52886, -94.593338),
    "56398": (45.52886, -94.593338),
    "56399": (45.52886, -94.593338),
    "56401": (46.350195, -94.099983),
    "56425": (46.373474, -94.196884),
    "56430": (46.862332, -94.641872),
    "56431": (46.563605, -93.430495),
    "56433": (46.987609, -94.726405),
    "56434": (46.379683, -94.936381),
    "56435": (46.803348, -94.521914),
    "56436": (47.108153, -94.921064),
    "56437": (46.268233, -95.06077),
    "56438": (46.063955, -94.867727),
    "56440": (46.128416, -94.950401),
    "56441": (46.537059, -93.928197),
    "56442": (46.67734, -94.112783),
    "56443": (46.205759, -94.561294),
    "56444": (46.429194, -93.878493),
    "56446": (46.149778, -94.99949),
    "56447": (46.697119, -94.117266),
    "56448": (46.727867, -94.040303),
    "56449": (46.200293, -94.245167),
    "56450": (46.312962, -93.866016),
    "56452": (46.939139, -94.450641),
    "56453": (46.330157, -94.945126),
    "56455": (46.477792, -93.978854),
    "56456": (46.480723, -94.08587),
    "56458": (47.108153, -94.921064),
    "56459": (46.498749, -94.251926),
    "56461": (47.108153, -94.921064),
    "56464": (46.730538, -94.975221),
    "56465": (46.539308, -94.134385),
    "56466": (46.288105, -94.563773),
    "56467": (46.94336, -94.844112),
    "56468": (46.401244, -94.237094),
    "56469": (46.712878, -93.489808),
    "56470": (46.984699, -95.09935),
    "56472": (46.616147, -94.235561),
    "56473": (46.693034, -94.464381),
    "56474": (46.712158, -94.251126),
    "56475": (46.105236, -94.531738),
    "56477": (46.652292, -94.974942),
    "56478": (46.605266, -94.900729),
    "56479": (46.250882, -94.934361),
    "56481": (46.506528, -94.967564),
    "56482": (46.564002, -95.082796),
    "56484": (47.067057, -94.489824),
    "56501": (46.834262, -95.746871),
    "56502": (46.933961, -95.678375),
    "56510": (47.325283, -96.597259),
    "56511": (46.850852, -95.995824),
    "56513": (46.890034, -96.506156),
    "56514": (46.649467, -96.391637),
    "56515": (46.294519, -95.707485),
    "56516": (47.325198, -95.80918),
    "56517": (47.801705, -96.43368),
    "56518": (46.412413, -95.713452),
    "56519": (47.201971, -96.500374),
    "56520": (46.191367, -96.500224),
    "56521": (46.979328, -95.912192),
    "56522": (46.140224, -96.443327),
    "56523": (47.683698, -96.87154),
    "56524": (46.275667, -95.630788),
    "56525": (46.890034, -96.506156),
    "56527": (46.392933, -95.318951),
    "56528": (46.57101, -95.728629),
    "56529": (46.877143, -96.709806),
    "56531": (45.997662, -95.963007),
    "56533": (46.380324, -96.132614),
    "56534": (46.483858, -96.097914),
    "56535": (47.665688, -95.99807),
    "56536": (47.077246, -96.503987),
    "56537": (46.3194, -95.657003),
    "56538": (46.412413, -95.713452),
    "56540": (47.534788, -96.285663),
    "56541": (47.325074, -96.469194),
    "56542": (47.597727, -96.270444),
    "56543": (46.326166, -96.528032),
    "56544": (46.803165, -95.579405),
    "56545": (47.372863, -96.264276),
    "56546": (46.890034, -96.506156),
    "56547": (46.870695, -96.576425),
    "56548": (47.350668, -96.82368),
    "56549": (46.977738, -96.409155),
    "56550": (47.263731, -96.811279),
    "56551": (46.293243, -95.483624),
    "56552": (46.972026, -96.25589),
    "56553": (46.326166, -96.528032),
    "56554": (46.891231, -96.102425),
    "56556": (47.637117, -95.884768),
    "56557": (47.287889, -95.939586),
    "56560": (46.803546, -96.557389),
    "56561": (46.890034, -96.506156),
    "56562": (46.890034, -96.506156),
    "56563": (46.890034, -96.506156),
    "56565": (46.326166, -96.528032),
    "56566": (47.325198, -95.80918),
    "56567": (46.491294, -95.366068),
    "56568": (47.836367, -96.3504),
    "56569": (47.10914, -95.782254),
    "56570": (46.923974, -95.362298),
    "56571": (46.465546, -95.564365),
    "56572": (46.611549, -96.059669),
    "56573": (46.597093, -95.822634),
    "56574": (47.177615, -96.804613),
    "56575": (47.061724, -95.429915),
    "56576": (46.443365, -95.792367),
    "56577": (46.933961, -95.678375),
    "56578": (46.886152, -95.724599),
    "56579": (46.529553, -96.349085),
    "56580": (46.779487, -96.651185),
    "56581": (47.320042, -96.54441),
    "56583": (46.007415, -96.359342),
    "56584": (47.271463, -96.182441),
    "56585": (47.0663, -96.258706),
    "56586": (46.285081, -95.874117),
    "56587": (46.457968, -95.919355),
    "56588": (46.412413, -95.713452),
    "56589": (47.184343, -95.939849),
    "56590": (45.934055, -96.012359),
    "56591": (46.933961, -95.678375),
    "56592": (47.631462, -95.889453),
    "56593": (46.821648, -95.391968),
    "56594": (46.326166, -96.528032),
    "56601": (47.571964, -94.801272),
    "56619": (47.625699, -94.822154),
    "56621": (47.531644, -95.377949),
    "56623": (48.750473, -94.84626),
    "56626": (47.370372, -94.251376),
    "56627": (48.091615, -93.81606),
    "56628": (47.710353, -93.612694),
    "56629": (48.642546, -94.06358),
    "56630": (47.804493, -94.575871),
    "56631": (47.087782, -93.921429),
    "56633": (47.327719, -94.476853),
    "56634": (47.610498, -95.421104),
    "56636": (47.46843, -93.810949),
    "56637": (47.615375, -93.837811),
    "56639": (47.852226, -93.524252),
    "56641": (47.206552, -94.263384),
    "56644": (47.715406, -95.470782),
    "56646": (47.836367, -96.3504),
    "56647": (47.974989, -95.008708),
    "56649": (48.232494, -93.640382),
    "56650": (47.940789, -94.45001),
    "56652": (47.585873, -95.375974),
    "56653": (48.357144, -93.612836),
    "56654": (48.538803, -93.840769),
    "56655": (46.994097, -94.243551),
    "56657": (47.548518, -93.62356),
    "56658": (48.27888, -93.755536),
    "56659": (47.661759, -94.015607),
    "56660": (47.933964, -94.23693),
    "56661": (47.919215, -94.097415),
    "56662": (46.879043, -93.918172),
    "56663": (47.448274, -94.471485),
    "56666": (47.974989, -95.008708),
    "56667": (47.974989, -95.008708),
    "56668": (48.603143, -93.29771),
    "56669": (48.394721, -93.310667),
    "56670": (47.974989, -95.008708),
    "56671": (47.974989, -95.008708),
    "56672": (47.095793, -94.021032),
    "56673": (48.769244, -95.747559),
    "56676": (47.585873, -95.375974),
    "56678": (47.974989, -95.008708),
    "56679": (48.27888, -93.755536),
    "56680": (47.635946, -93.922032),
    "56681": (47.624415, -94.187735),
    "56682": (48.769244, -95.747559),
    "56683": (47.974989, -95.008708),
    "56684": (47.836367, -96.3504),
    "56685": (47.974989, -95.008708),
    "56686": (48.820842999999996, -94.933138),
    "56687": (47.974989, -95.008708),
    "56688": (47.746177, -93.962961),
    "56701": (48.076333, -96.149002),
    "56710": (48.191085, -96.998433),
    "56711": (48.875164, -94.885668),
    "56712": (47.836367, -96.3504),
    "56713": (48.331455, -96.816197),
    "56714": (48.774428, -96.020334),
    "56715": (47.814152, -96.005263),
    "56716": (47.705082, -96.412),
    "56720": (48.771938, -96.812921),
    "56721": (47.874048, -96.924085),
    "56722": (47.836367, -96.3504),
    "56723": (47.799949, -96.798532),
    "56724": (48.358371, -96.378062),
    "56725": (48.144158, -95.804345),
    "56726": (48.834783, -96.286287),
    "56727": (48.358371, -96.378062),
    "56728": (48.774787, -96.942022),
    "56729": (48.771938, -96.812921),
    "56731": (48.771938, -96.812921),
    "56732": (48.565003, -96.53266),
    "56733": (48.643714, -96.914605),
    "56734": (48.771938, -96.812921),
    "56735": (48.771938, -96.812921),
    "56736": (47.681728, -96.154311),
    "56737": (48.438104, -96.513779),
    "56738": (48.358371, -96.378062),
    "56740": (48.771938, -96.812921),
    "56741": (48.875164, -94.885668),
    "56742": (47.838345, -95.853261),
    "56744": (48.19941, -97.130755),
    "56748": (47.86217, -96.095883),
    "56750": (47.885347, -96.270368),
    "56751": (48.704839, -95.750383),
    "56754": (48.014969, -96.213472),
    "56755": (48.871994, -97.092442),
    "56756": (48.769244, -95.747559),
    "56757": (48.477158, -96.867548),
    "56758": (48.358371, -96.378062),
    "56759": (48.749138, -96.062783),
    "56760": (48.358371, -96.378062),
    "56761": (48.769244, -95.747559),
    "56762": (48.261376, -96.772583),
    "56763": (48.900663, -95.250324),
    "57001": (42.931698, -96.624298),
    "57002": (44.304195, -96.667977),
    "57003": (43.64514, -96.814589),
    "57004": (42.842947, -96.681135),
    "57005": (43.603401, -96.793708),
    "57006": (44.355091, -96.762102),
    "57007": (44.369696, -96.790705),
    "57010": (42.827796, -96.847373),
    "57012": (43.572888, -97.248418),
    "57013": (43.29831, -96.70718),
    "57014": (43.291296, -97.042271),
    "57015": (43.408226, -96.983852),
    "57016": (43.895505, -96.928024),
    "57017": (43.984778, -96.814237),
    "57018": (43.790192, -96.907845),
    "57020": (43.666894, -96.822137),
    "57021": (43.272502, -96.983494),
    "57022": (43.803585, -96.699766),
    "57024": (43.998434, -96.648034),
    "57025": (42.76399, -96.676742),
    "57026": (44.289677, -96.540249),
    "57027": (43.197041, -96.513506),
    "57028": (43.984004, -96.616189),
    "57029": (43.321384, -97.547869),
    "57030": (43.747639, -96.596379),
    "57031": (42.886136, -97.209902),
    "57032": (43.425258, -96.659737),
    "57033": (43.630545, -96.814539),
    "57034": (43.184976, -96.580939),
    "57035": (43.637836, -96.816129),
    "57036": (43.278943, -97.141677),
    "57038": (42.580112, -96.576256),
    "57039": (43.298098, -96.856021),
    "57040": (43.06062, -97.568901),
    "57041": (43.728488, -96.870928),
    "57042": (44.054223, -97.091339),
    "57043": (43.292364, -97.278318),
    "57044": (42.840984, -97.091959),
    "57045": (43.248825, -97.538733),
    "57046": (42.969251, -97.297103),
    "57047": (43.489841, -97.250932),
    "57048": (43.696853, -97.18593),
    "57049": (42.587483, -96.585026),
    "57050": (44.021983, -97.129455),
    "57051": (44.245942, -97.32031),
    "57052": (43.284183, -97.718224),
    "57053": (43.399595, -97.134211),
    "57054": (44.1186, -97.215191),
    "57055": (43.666979, -96.760473),
    "57056": (43.521559, -96.558738),
    "57057": (44.021983, -97.129455),
    "57058": (43.639298, -97.343417),
    "57059": (43.024378, -97.783482),
    "57061": (44.242764, -97.018205),
    "57062": (42.881672, -97.926212),
    "57063": (42.947515, -97.714195),
    "57064": (43.41434, -96.842783),
    "57065": (43.907616, -96.653301),
    "57066": (42.98853, -97.873263),
    "57067": (43.016376, -97.369385),
    "57068": (43.594402, -96.528511),
    "57069": (42.854124, -96.973318),
    "57070": (43.188383, -97.180373),
    "57071": (44.369694, -96.790512),
    "57072": (43.002044, -97.239829),
    "57073": (42.996509, -97.058654),
    "57075": (43.996979, -96.967095),
    "57076": (44.021983, -97.129455),
    "57077": (43.286596, -96.776784),
    "57078": (42.94396, -97.37689),
    "57079": (42.867556, -97.390268),
    "57101": (43.546358, -96.69063),
    "57103": (43.548433, -96.63871),
    "57104": (43.589218, -96.685294),
    "57105": (43.518636, -96.732266),
    "57106": (43.529244, -96.780065),
    "57107": (43.600064, -96.801033),
    "57108": (43.550404, -96.696878),
    "57109": (43.674582, -96.79134),
    "57110": (43.548613, -96.633203),
    "57115": (43.521895, -96.868464),
    "57117": (43.674582, -96.79134),
    "57118": (43.674582, -96.79134),
    "57188": (43.674582, -96.79134),
    "57189": (43.674582, -96.79134),
    "57192": (43.674582, -96.79134),
    "57193": (43.674582, -96.79134),
    "57194": (43.674582, -96.79134),
    "57195": (43.674582, -96.79134),
    "57196": (43.674582, -96.79134),
    "57197": (43.674582, -96.79134),
    "57198": (43.674582, -96.79134),
    "57201": (44.955643, -97.177954),
    "57202": (44.977634, -97.188372),
    "57212": (44.368264, -97.246086),
    "57213": (44.562302, -96.591264),
    "57214": (44.484381, -97.209173),
    "57216": (45.170552, -96.534574),
    "57217": (44.90626, -97.708049),
    "57218": (44.76048, -96.668424),
    "57219": (45.319218, -97.637812),
    "57220": (44.456735, -96.89302),
    "57221": (44.590094, -97.466776),
    "57223": (44.65665, -97.116149),
    "57224": (45.616422, -96.849416),
    "57225": (44.891983, -97.832972),
    "57226": (44.761249, -96.690651),
    "57227": (45.616422, -96.849416),
    "57231": (44.369482, -97.542049),
    "57232": (45.631054, -97.40057),
    "57233": (44.470856, -97.370412),
    "57234": (44.673761999999996, -97.188324),
    "57235": (45.015481, -97.306014),
    "57236": (44.848565, -97.737227),
    "57237": (44.792302, -96.45927),
    "57238": (44.76048, -96.668424),
    "57239": (45.369855, -97.603949),
    "57241": (44.657338, -97.20497),
    "57242": (44.759144, -97.381575),
    "57243": (44.929255, -97.391955),
    "57244": (44.425409, -97.289881),
    "57245": (44.892254, -96.917412),
    "57246": (45.115408, -96.670622),
    "57247": (45.717904, -97.470748),
    "57248": (44.588234, -97.142872),
    "57249": (44.369159, -97.382824),
    "57251": (45.274296, -96.942159),
    "57252": (45.171617, -96.629203),
    "57253": (45.151477, -96.839235),
    "57255": (45.616422, -96.849416),
    "57256": (45.616422, -96.849416),
    "57257": (45.542151, -96.951675),
    "57258": (44.910756, -97.939298),
    "57259": (45.080517, -96.555664),
    "57260": (45.616422, -96.849416),
    "57262": (45.541443, -96.970202),
    "57263": (45.100745, -97.036356),
    "57264": (45.106694, -96.802259),
    "57265": (45.021579, -96.74078),
    "57266": (45.30204, -97.036537),
    "57268": (44.567419, -96.59444),
    "57269": (45.230876, -96.823706),
    "57270": (45.849458, -97.376617),
    "57271": (44.848565, -97.737227),
    "57272": (45.093607, -97.453149),
    "57273": (45.332568, -97.307239),
    "57274": (45.31506, -97.525395),
    "57276": (44.405596, -96.599788),
    "57278": (44.659815, -97.573152),
    "57279": (45.39857, -96.832256),
    "57301": (43.69591, -98.086401),
    "57311": (43.66844, -97.75632),
    "57312": (44.122811, -98.412198),
    "57313": (43.341035, -98.398964),
    "57314": (44.020961, -98.01144),
    "57315": (42.988284, -97.878579),
    "57317": (43.248832, -99.016376),
    "57319": (43.550264, -97.469058),
    "57321": (43.892123, -97.540053),
    "57322": (44.848565, -97.737227),
    "57323": (44.138176, -97.720661),
    "57324": (44.325314, -98.013968),
    "57325": (43.772585, -99.149806),
    "57326": (43.71725, -99.131736),
    "57328": (43.420306, -98.439859),
    "57329": (42.984707, -98.175204),
    "57330": (43.290614, -98.178372),
    "57331": (43.470444, -97.999352),
    "57332": (43.586451, -97.65539),
    "57334": (43.59997, -98.074101),
    "57335": (43.248832, -99.016376),
    "57337": (44.001852, -97.750838),
    "57339": (44.064873, -99.251509),
    "57340": (43.762939, -97.869025),
    "57341": (44.064873, -99.251509),
    "57342": (43.251263, -98.736404),
    "57344": (43.409186, -98.528068),
    "57345": (44.574651, -99.486417),
    "57346": (44.545094, -99.488221),
    "57348": (44.567404, -98.406424),
    "57349": (44.037102, -97.56034),
    "57350": (44.398874, -98.180113),
    "57353": (44.369593, -97.652194),
    "57354": (43.334069, -97.756924),
    "57355": (43.744477, -98.95381),
    "57356": (43.147572, -98.527479),
    "57357": (43.136365, -98.427173),
    "57358": (44.069628, -98.425228),
    "57359": (43.953471, -98.151193),
    "57361": (43.01957, -98.446929),
    "57362": (44.480979, -99.062766),
    "57363": (43.674994, -98.164483),
    "57364": (43.427358, -98.608778),
    "57365": (43.797502, -99.394735),
    "57366": (43.383849, -97.915618),
    "57367": (43.067306, -98.522951),
    "57368": (43.746753, -98.518533),
    "57369": (43.2916, -98.767186),
    "57370": (43.776542, -99.186931),
    "57371": (44.422833, -99.218556),
    "57373": (44.495497, -98.869647),
    "57374": (43.723565, -97.581441),
    "57375": (43.571628, -98.498361),
    "57376": (43.24846, -97.923502),
    "57379": (44.283816, -98.50273),
    "57380": (43.034725, -98.315504),
    "57381": (44.415437, -98.642453),
    "57382": (44.066415, -98.675133),
    "57383": (43.714955, -98.644922),
    "57384": (44.44945, -98.487894),
    "57385": (44.04271, -98.231397),
    "57386": (44.522526, -98.040081),
    "57399": (44.414319, -98.279548),
    "57401": (45.476172, -98.410405),
    "57402": (45.589567, -98.352014),
    "57420": (45.29069, -99.991823),
    "57421": (45.758528, -97.927389),
    "57422": (45.369855, -97.603949),
    "57424": (45.046485, -98.397319),
    "57426": (45.735409, -98.569848),
    "57427": (45.626851, -98.270454),
    "57428": (45.469377, -99.595667),
    "57429": (45.163452, -98.319296),
    "57430": (45.761704, -97.72957),
    "57432": (45.682867, -98.051948),
    "57433": (45.537847, -98.339885),
    "57434": (45.139317, -98.15339),
    "57435": (45.136245, -98.915424),
    "57436": (44.846523, -98.10236),
    "57437": (45.77074, -99.330778),
    "57438": (45.085504, -99.195418),
    "57439": (45.32904, -98.083721),
    "57440": (44.870365, -98.225875),
    "57441": (45.693116, -98.368918),
    "57442": (45.033588, -100.035273),
    "57445": (45.589027, -98.245639),
    "57446": (45.849431, -98.157861),
    "57448": (45.552579, -99.461653),
    "57449": (45.60711, -98.170069),
    "57450": (45.241265, -99.777259),
    "57451": (45.421905, -99.258683),
    "57452": (45.449196, -99.821987),
    "57454": (45.692919, -97.768102),
    "57455": (45.072088, -99.998438),
    "57456": (45.773436, -98.983305),
    "57457": (45.882332, -99.169825),
    "57460": (45.22295, -98.599388),
    "57461": (45.155829, -98.426714),
    "57462": (45.404015, -98.806895),
    "57465": (45.125985, -98.625836),
    "57466": (45.180068, -99.46426),
    "57467": (44.911775, -99.073204),
    "57468": (45.369855, -97.603949),
    "57469": (44.954101, -98.406878),
    "57470": (45.033056, -98.882787),
    "57471": (45.419289, -99.346593),
    "57472": (45.434632, -100.098171),
    "57473": (44.99142, -99.340678),
    "57474": (45.306691, -98.258376),
    "57475": (45.22375, -99.694578),
    "57476": (44.893778, -98.402047),
    "57477": (45.045466, -98.182922),
    "57479": (45.329227, -98.47485),
    "57481": (45.670534, -98.580207),
    "57501": (44.334073, -100.094195),
    "57520": (44.802621, -100.158903),
    "57521": (43.691966, -101.601609),
    "57522": (44.43719, -99.926952),
    "57523": (43.182547, -99.293674),
    "57526": (43.382122, -99.88231),
    "57528": (43.260083, -99.716537),
    "57529": (43.23571, -99.515887),
    "57531": (43.938049, -100.701672),
    "57532": (44.343326, -100.635312),
    "57533": (43.213649, -99.36219),
    "57534": (43.382122, -99.88231),
    "57536": (44.333927, -99.767237),
    "57537": (44.531281, -101.014052),
    "57538": (43.114883, -99.195945),
    "57540": (44.490558, -99.589344),
    "57541": (43.382122, -99.88231),
    "57542": (43.85862, -99.824337),
    "57543": (43.824178, -101.389524),
    "57544": (43.85862, -99.824337),
    "57547": (43.691966, -101.601609),
    "57548": (43.85862, -99.824337),
    "57551": (43.172158, -101.734068),
    "57552": (44.370733, -101.527178),
    "57553": (44.370733, -101.527178),
    "57555": (43.304572, -100.662079),
    "57557": (44.475844, -100.529517),
    "57559": (43.879993, -100.75734),
    "57560": (43.623523, -100.721218),
    "57562": (43.938049, -100.701672),
    "57563": (43.194063, -100.713373),
    "57564": (44.722873, -99.979546),
    "57566": (43.194063, -100.713373),
    "57567": (44.046063, -101.630722),
    "57568": (43.908372, -100.046855),
    "57569": (43.85862, -99.824337),
    "57570": (43.302375, -100.626863),
    "57571": (43.248832, -99.016376),
    "57572": (43.194063, -100.713373),
    "57574": (43.193203, -101.66933),
    "57576": (43.85862, -99.824337),
    "57577": (43.691966, -101.601609),
    "57578": (43.382122, -99.88231),
    "57579": (43.566116, -100.745912),
    "57580": (43.331763, -99.803286),
    "57584": (43.382122, -99.88231),
    "57585": (43.623523, -100.721218),
    "57601": (45.550822, -100.330283),
    "57620": (45.409748, -102.513087),
    "57621": (45.847567, -101.09974),
    "57622": (44.992051, -101.568656),
    "57623": (45.050456, -101.607171),
    "57625": (45.001611, -101.232885),
    "57626": (45.024533, -102.026734),
    "57628": (45.098685, -100.879214),
    "57629": (44.992051, -101.568656),
    "57630": (45.098685, -100.879214),
    "57631": (45.504288, -100.311701),
    "57632": (45.833733, -100.020048),
    "57633": (45.396212, -101.438525),
    "57634": (45.708402, -101.154581),
    "57636": (45.098685, -100.879214),
    "57638": (45.732219, -102.410975),
    "57639": (45.708402, -101.154581),
    "57640": (45.703777, -102.663011),
    "57641": (45.708402, -101.154581),
    "57642": (45.876336, -100.891469),
    "57643": (45.708402, -101.154581),
    "57644": (45.453221, -102.280948),
    "57645": (45.708402, -101.154581),
    "57646": (45.715461, -100.048071),
    "57647": (45.098685, -100.879214),
    "57648": (45.844431, -100.283026),
    "57649": (45.440744, -102.704216),
    "57650": (45.578941, -103.493668),
    "57651": (45.578941, -103.493668),
    "57652": (45.098685, -100.879214),
    "57653": (45.680798, -102.292753),
    "57656": (45.427032, -101.07469),
    "57657": (45.708402, -101.154581),
    "57658": (45.655452, -100.537928),
    "57659": (45.708402, -101.154581),
    "57660": (45.708402, -101.154581),
    "57661": (45.098685, -100.879214),
    "57701": (44.004363, -103.240024),
    "57702": (44.003641, -103.358868),
    "57703": (44.048039, -103.176287),
    "57706": (44.185222, -103.229087),
    "57709": (44.076106, -103.317149),
    "57714": (43.193203, -101.66933),
    "57716": (43.352617, -102.5411),
    "57717": (44.93037, -103.87313),
    "57718": (44.183216, -103.326118),
    "57719": (44.03667, -103.204293),
    "57720": (45.576652, -103.911719),
    "57722": (43.666816, -103.371071),
    "57724": (45.578941, -103.493668),
    "57725": (43.948063, -102.793461),
    "57729": (44.312407, -102.150335),
    "57730": (43.657304, -103.425807),
    "57732": (44.36485, -103.735731),
    "57735": (43.294549, -103.830431),
    "57736": (44.348777, -102.52386),
    "57737": (44.589806, -102.787188),
    "57738": (43.685927, -103.20817),
    "57741": (44.40932, -103.455428),
    "57742": (44.66913, -103.697073),
    "57744": (43.838528, -103.19146),
    "57745": (44.0082, -103.651357),
    "57747": (43.314186, -103.528353),
    "57748": (44.589806, -102.787188),
    "57750": (43.691966, -101.601609),
    "57751": (43.884764, -103.399471),
    "57752": (43.352617, -102.5411),
    "57754": (44.444505, -103.752683),
    "57755": (45.578941, -103.493668),
    "57756": (43.352617, -102.5411),
    "57758": (44.589806, -102.787188),
    "57759": (44.372688, -103.754204),
    "57760": (44.715217, -103.417574),
    "57761": (44.056691, -102.79897),
    "57762": (44.673533, -103.556354),
    "57763": (43.180956, -103.243935),
    "57764": (43.352617, -102.5411),
    "57765": (44.589806, -102.787188),
    "57766": (43.239655, -103.527757),
    "57767": (44.067413, -102.680781),
    "57769": (44.220524, -103.272284),
    "57770": (43.024319, -102.535178),
    "57772": (43.352617, -102.5411),
    "57773": (43.666816, -103.371071),
    "57774": (43.239655, -103.527757),
    "57775": (44.068731, -102.222633),
    "57776": (45.578941, -103.493668),
    "57777": (44.691005, -102.587048),
    "57778": (44.117606, -103.761058),
    "57779": (44.547307, -103.723214),
    "57780": (43.788416, -102.346797),
    "57782": (43.239655, -103.527757),
    "57783": (44.467137, -103.772331),
    "57785": (44.369172, -103.361658),
    "57787": (44.653923, -102.725189),
    "57788": (44.719176, -103.42562),
    "57790": (44.013772, -102.238397),
    "57791": (44.016848, -102.59866),
    "57792": (44.589806, -102.787188),
    "57793": (44.46498, -103.644136),
    "57794": (43.352617, -102.5411),
    "57799": (44.495846, -103.870251),
    "58001": (46.447936, -96.727788),
    "58002": (46.859694, -97.214587),
    "58004": (47.021032, -97.271545),
    "58005": (47.057026, -96.975162),
    "58006": (47.102334, -97.140334),
    "58007": (47.01392, -97.462894),
    "58008": (46.273086, -96.864373),
    "58009": (47.454888, -97.151692),
    "58011": (46.920016, -97.557491),
    "58012": (47.050272, -97.062647),
    "58013": (46.062144, -97.529438),
    "58014": (46.775027, -97.352437),
    "58015": (46.593582, -96.809354),
    "58016": (47.454888, -97.151692),
    "58017": (46.06593, -97.820733),
    "58018": (46.457386, -96.873653),
    "58021": (46.731743, -97.063137),
    "58027": (46.456337, -97.777909),
    "58029": (47.115505, -97.377138),
    "58030": (46.094599, -96.907594),
    "58031": (46.775099, -97.797553),
    "58032": (46.058634, -97.633282),
    "58033": (46.449387, -97.909114),
    "58035": (47.270447, -97.408156),
    "58036": (47.157949, -96.957752),
    "58038": (47.072418, -96.96915),
    "58039": (46.160427, -96.843465),
    "58040": (46.152725, -97.767735),
    "58041": (46.073423, -96.92473),
    "58042": (46.956511, -96.965445),
    "58043": (45.978943, -97.54423),
    "58045": (47.383461, -97.060324),
    "58046": (47.323726, -97.713371),
    "58047": (46.710147, -96.88506),
    "58048": (46.981541, -97.150669),
    "58049": (46.717679, -97.976311),
    "58051": (46.673526, -97.050584),
    "58052": (46.765575, -97.294037),
    "58053": (46.191782, -96.994919),
    "58054": (46.455974, -97.636917),
    "58056": (47.45565, -97.718955),
    "58057": (46.443826, -97.343373),
    "58058": (46.16038, -96.969366),
    "58059": (46.861424, -97.115726),
    "58060": (46.200657, -97.477179),
    "58061": (46.315035, -96.861092),
    "58062": (46.680795, -97.786984),
    "58063": (46.964791, -97.789289),
    "58064": (47.000029, -97.515646),
    "58065": (46.650741, -98.195722),
    "58067": (46.036974, -97.431104),
    "58068": (46.521481, -97.416257),
    "58069": (46.221613, -97.62307),
    "58071": (46.949236, -97.626101),
    "58072": (46.972286, -98.007534),
    "58074": (46.283291, -96.917614),
    "58075": (46.336591, -96.792057),
    "58076": (46.271839, -96.608142),
    "58077": (46.445916, -97.013693),
    "58078": (46.890692, -96.925828),
    "58079": (46.832617, -97.346067),
    "58081": (46.384021, -97.11408),
    "58102": (46.92536, -96.990615),
    "58103": (46.832152, -96.825841),
    "58104": (46.781589, -96.884106),
    "58105": (46.9414, -96.967371),
    "58106": (46.934596, -97.229718),
    "58107": (46.934596, -97.229718),
    "58108": (46.934596, -97.229718),
    "58109": (46.82352, -96.8148),
    "58121": (46.934596, -97.229718),
    "58122": (46.934596, -97.229718),
    "58123": (46.934596, -97.229718),
    "58124": (46.934596, -97.229718),
    "58125": (46.934596, -97.229718),
    "58126": (46.934596, -97.229718),
    "58201": (47.9041, -97.431501),
    "58202": (47.933481, -97.394446),
    "58203": (47.892243, -97.301297),
    "58204": (47.967909, -97.367534),
    "58205": (47.933481, -97.394446),
    "58206": (47.933481, -97.394446),
    "58207": (47.933481, -97.394446),
    "58208": (47.933481, -97.394446),
    "58210": (48.383547, -97.997964),
    "58212": (47.766493, -98.043481),
    "58213": (48.237795, -97.275528),
    "58214": (47.925956, -97.494107),
    "58216": (48.874863, -97.42543),
    "58218": (47.602249, -97.099519),
    "58219": (47.454888, -97.151692),
    "58220": (48.738902, -97.699122),
    "58222": (48.6449, -97.633342),
    "58223": (47.454888, -97.151692),
    "58224": (48.165871, -97.957485),
    "58225": (48.668146, -97.362726),
    "58227": (48.499712, -97.893218),
    "58228": (47.889676, -97.280993),
    "58229": (48.380603, -98.054828),
    "58230": (47.51207, -97.83707),
    "58231": (48.281947, -97.827805),
    "58233": (48.259974, -97.522485),
    "58235": (48.085827, -97.514081),
    "58236": (48.720149, -97.469623),
    "58237": (48.368876, -97.437265),
    "58238": (48.778717, -97.449975),
    "58239": (48.77178, -98.464102),
    "58240": (47.638521, -97.459319),
    "58241": (48.720338, -97.699287),
    "58243": (48.490539, -97.677015),
    "58244": (48.107863, -97.683056),
    "58249": (48.753679, -98.288629),
    "58250": (48.282007, -98.076663),
    "58251": (47.911531, -97.626389),
    "58254": (47.856367, -98.134365),
    "58255": (48.77178, -98.464102),
    "58256": (48.107279, -97.28791),
    "58257": (47.487262, -97.345104),
    "58258": (48.007368, -97.430451),
    "58259": (48.020355, -98.118574),
    "58260": (48.624861, -98.042871),
    "58261": (48.25997, -97.314367),
    "58262": (48.693099, -97.884115),
    "58265": (48.943793, -97.512602),
    "58266": (48.015728, -97.817106),
    "58267": (47.759107, -97.603773),
    "58269": (48.77178, -98.464102),
    "58270": (48.420411, -97.774812),
    "58271": (48.85897, -97.288585),
    "58272": (48.00598, -98.000193),
    "58273": (48.323898, -97.81439),
    "58274": (47.582141, -97.244353),
    "58275": (47.872332, -97.236128),
    "58276": (48.630369, -97.471056),
    "58277": (47.45565, -97.718955),
    "58278": (47.785848, -97.34703),
    "58281": (48.77178, -98.464102),
    "58282": (48.880795, -97.797358),
    "58301": (48.264352, -98.781979),
    "58310": (48.770913, -99.772702),
    "58311": (48.77178, -98.464102),
    "58313": (48.104177, -99.992145),
    "58316": (48.777557, -99.799919),
    "58317": (48.58807, -99.23173),
    "58318": (48.830347, -100.601174),
    "58319": (47.663508, -99.664406),
    "58320": (48.28641, -99.404705),
    "58321": (48.238222, -98.400599),
    "58323": (48.77178, -98.464102),
    "58324": (48.500121, -99.231923),
    "58325": (48.29, -99.070499),
    "58327": (48.091012, -98.573116),
    "58329": (48.856083, -100.024102),
    "58330": (48.422614, -98.49963),
    "58331": (48.652908, -99.123224),
    "58332": (48.059736, -99.538336),
    "58335": (48.108758, -99.186842),
    "58337": (47.587372, -99.667737),
    "58338": (48.499953, -98.644371),
    "58339": (48.900063, -99.427769),
    "58341": (47.703539, -99.747755),
    "58343": (48.301215, -99.689358),
    "58344": (47.971966, -98.324631),
    "58345": (48.275146, -98.438346),
    "58346": (48.165312, -99.432466),
    "58348": (47.999093, -99.535801),
    "58351": (48.130016, -99.38981),
    "58352": (48.66937, -98.835465),
    "58353": (48.772022, -99.838063),
    "58355": (48.77178, -98.464102),
    "58356": (47.71736, -98.898693),
    "58357": (47.949694, -99.133201),
    "58359": (48.089537, -100.164357),
    "58361": (47.798489000000004, -98.364994),
    "58362": (48.275494, -99.070415),
    "58363": (48.754621, -99.438351),
    "58365": (48.844548, -99.26309),
    "58366": (48.700886, -99.878456),
    "58367": (48.826826, -99.786546),
    "58368": (48.254504, -99.989912),
    "58369": (48.880498, -99.734073),
    "58370": (47.985595, -98.849264),
    "58372": (48.77178, -98.464102),
    "58374": (47.761272, -98.90997),
    "58377": (48.449321, -98.760596),
    "58379": (48.108758, -99.186842),
    "58380": (47.846213, -98.451175),
    "58381": (47.910133, -98.75889),
    "58382": (48.317012, -98.800481),
    "58384": (48.660609, -100.352409),
    "58385": (48.465282, -99.645681),
    "58386": (48.256479, -99.602542),
    "58401": (46.921005, -98.745485),
    "58402": (46.97882, -98.960032),
    "58405": (46.913344, -98.699553),
    "58413": (46.056209, -99.285013),
    "58415": (46.362715, -98.473702),
    "58416": (47.489506, -98.410133),
    "58418": (47.457667, -99.649702),
    "58420": (47.005084, -98.900709),
    "58421": (47.457278, -98.893314),
    "58422": (47.628946, -99.404936),
    "58423": (47.464366, -99.830601),
    "58424": (46.893112, -99.128846),
    "58425": (47.366922, -98.295699),
    "58426": (47.196576, -98.594244),
    "58428": (46.806728, -99.772396),
    "58429": (47.182819, -98.161621),
    "58430": (47.529679, -100.271687),
    "58431": (46.47261, -98.54261),
    "58432": (46.892518, -98.375536),
    "58433": (46.41198, -98.713086),
    "58436": (46.106141, -98.620707),
    "58438": (47.625048, -99.564274),
    "58439": (46.011902, -98.848644),
    "58440": (46.37014, -99.173337),
    "58441": (46.175992, -98.379846),
    "58442": (46.522452, -99.173063),
    "58443": (47.456948, -98.691563),
    "58444": (47.479529, -100.14659),
    "58445": (47.457057, -98.702131),
    "58448": (47.378619, -98.350201),
    "58451": (47.472804, -99.937233),
    "58452": (47.456477, -98.230415),
    "58454": (46.551079, -98.86671),
    "58455": (47.240135, -98.753458),
    "58456": (46.391635, -98.603141),
    "58458": (46.384379, -98.358671),
    "58460": (46.140661, -99.378147),
    "58461": (46.717981, -98.186443),
    "58463": (47.506755, -100.41715),
    "58464": (47.507777, -98.627951),
    "58466": (46.551382, -98.368983),
    "58467": (46.899774, -99.316908),
    "58472": (46.681609, -98.660404),
    "58474": (46.109493, -98.225652),
    "58475": (47.153918, -99.584222),
    "58476": (47.203846, -99.014385),
    "58477": (47.212951, -100.548434),
    "58478": (46.979659, -99.689234),
    "58479": (47.074088, -98.213603),
    "58480": (46.892615, -98.258971),
    "58481": (46.986518, -98.521889),
    "58482": (46.875966, -99.798975),
    "58483": (46.718326, -99.344287),
    "58484": (47.39903, -98.403593),
    "58486": (47.421182, -99.404828),
    "58487": (46.806274, -99.594248),
    "58488": (47.132159, -99.970526),
    "58489": (46.027975, -99.649774),
    "58490": (46.398713, -98.099446),
    "58492": (47.110075, -98.397443),
    "58494": (47.157924, -100.294569),
    "58495": (46.191724, -99.613132),
    "58496": (47.153721, -99.259784),
    "58497": (46.768695, -98.565136),
    "58501": (46.981207, -100.502724),
    "58502": (46.8887, -100.681855),
    "58504": (46.829938, -100.45598),
    "58505": (46.816543, -100.780505),
    "58506": (46.980475, -100.520063),
    "58507": (46.980475, -100.520063),
    "58520": (46.720185, -101.498156),
    "58521": (47.016148, -100.693721),
    "58523": (47.277895, -101.853161),
    "58524": (46.56035, -100.107546),
    "58528": (46.361639, -100.688991),
    "58529": (46.300853, -101.673608),
    "58530": (47.145874, -101.159363),
    "58531": (47.581047, -101.143206),
    "58532": (46.851141, -100.18329),
    "58533": (46.367859, -101.755819),
    "58535": (46.599807, -101.316642),
    "58538": (46.170605, -100.710536),
    "58540": (47.667515, -101.61418),
    "58541": (47.312542, -102.056796),
    "58542": (46.080221, -100.097715),
    "58544": (46.517223, -100.337283),
    "58545": (47.386092, -101.760142),
    "58549": (46.455044, -99.969631),
    "58552": (46.185512, -100.233084),
    "58553": (46.871308, -100.402135),
    "58554": (46.71312, -100.952585),
    "58558": (46.808449, -100.45556),
    "58559": (47.501822, -100.758394),
    "58560": (46.673047, -100.300199),
    "58561": (46.464858, -99.65682),
    "58562": (46.382285, -101.961907),
    "58563": (46.805999, -101.429122),
    "58564": (46.267125, -101.372162),
    "58565": (47.396354, -101.203255),
    "58566": (46.646616, -100.94428),
    "58568": (46.186442, -101.252738),
    "58569": (46.244657, -101.218713),
    "58570": (46.365588, -100.783143),
    "58571": (47.377264, -101.394939),
    "58572": (46.876069, -100.277434),
    "58573": (46.080388, -100.223542),
    "58575": (47.501425, -100.895863),
    "58576": (47.445896, -101.21736),
    "58577": (47.380715, -101.095673),
    "58579": (47.488872, -101.085504),
    "58580": (47.263087, -101.929416),
    "58581": (46.064366, -99.786023),
    "58601": (46.805716, -102.756514),
    "58602": (46.820185, -102.663913),
    "58620": (46.454966, -103.485325),
    "58621": (46.963728, -103.898766),
    "58622": (46.819805, -103.126111),
    "58623": (46.205537, -103.521263),
    "58625": (47.305726, -102.202834),
    "58626": (47.336337, -102.663492),
    "58627": (46.921188, -103.509564),
    "58630": (46.848918, -102.6399),
    "58631": (46.813372, -101.822672),
    "58632": (46.672225, -103.952158),
    "58634": (47.737435, -103.298383),
    "58636": (47.351748, -102.336761),
    "58638": (46.849592, -101.972303),
    "58639": (46.057786, -102.785054),
    "58640": (47.526978, -102.703916),
    "58641": (46.724077, -102.663709),
    "58642": (47.402085, -102.622139),
    "58643": (46.454966, -103.485325),
    "58644": (47.402085, -102.622139),
    "58645": (46.979437, -103.349989),
    "58646": (46.369616, -102.326958),
    "58647": (46.459446, -102.595864),
    "58649": (46.113891, -102.496805),
    "58650": (46.418659, -102.56228),
    "58651": (46.112755, -103.520928),
    "58652": (46.820533, -102.264513),
    "58653": (46.112755, -103.520928),
    "58654": (46.847632, -103.874736),
    "58655": (46.767691, -103.072219),
    "58656": (46.856469, -102.784581),
    "58701": (48.084625, -101.419006),
    "58702": (48.336898, -101.451285),
    "58703": (48.299433, -101.606),
    "58704": (48.42429, -101.319942),
    "58705": (48.234184, -101.297161),
    "58707": (48.245267, -101.301179),
    "58710": (47.926998, -100.284856),
    "58711": (48.813251, -101.227611),
    "58712": (47.992914999999996, -100.497516),
    "58713": (48.528579, -100.635538),
    "58716": (47.761315, -101.109594),
    "58718": (48.306397, -101.686644),
    "58721": (48.837753, -102.283897),
    "58722": (48.10469, -101.543429),
    "58723": (47.69365, -100.692443),
    "58725": (48.417859, -101.705933),
    "58727": (48.852362, -102.592042),
    "58730": (48.928166, -103.296728),
    "58731": (48.490508, -100.961945),
    "58733": (48.187543, -101.668759),
    "58734": (48.495604, -102.006123),
    "58735": (47.952635, -101.464689),
    "58736": (47.978309, -100.384482),
    "58737": (48.877183, -102.382327),
    "58740": (48.647206, -101.540749),
    "58741": (48.305738, -100.67856),
    "58744": (48.194146, -100.591093),
    "58746": (48.523046, -101.670989),
    "58747": (47.876848, -100.660544),
    "58748": (48.697742, -100.634566),
    "58750": (48.634598, -101.297326),
    "58752": (48.821804, -102.611948),
    "58755": (48.405038, -103.407189),
    "58756": (47.957203, -101.778246),
    "58757": (47.737435, -103.298383),
    "58758": (47.717951, -100.21234),
    "58759": (47.567805, -101.164109),
    "58760": (48.736655999999996, -101.197701),
    "58761": (48.726868, -101.605847),
    "58762": (48.770759, -101.067192),
    "58763": (47.971759, -102.471636),
    "58765": (48.925358, -103.071081),
    "58768": (48.269539, -100.95024599999999),
    "58769": (48.284698, -102.257478),
    "58770": (47.946158, -102.103378),
    "58771": (48.065743, -102.030195),
    "58772": (48.953774, -102.622651),
    "58773": (48.655093, -102.679499),
    "58775": (47.681855, -101.866895),
    "58776": (48.272077, -102.547886),
    "58778": (47.746583, -100.931173),
    "58779": (47.978815, -101.668252),
    "58781": (48.181645, -101.340912),
    "58782": (48.863353, -101.770037),
    "58783": (48.87384, -100.735863),
    "58784": (48.345765, -102.418466),
    "58785": (48.290933, -101.111794),
    "58787": (48.759404, -101.862477),
    "58788": (48.363638, -100.4854),
    "58789": (48.348495, -100.831317),
    "58790": (48.021268, -100.629723),
    "58792": (47.98605, -100.798821),
    "58793": (48.86655, -100.836782),
    "58794": (48.299352, -102.770085),
    "58795": (48.567814, -103.153622),
    "58801": (48.225729, -103.649047),
    "58802": (48.168836, -103.614824),
    "58830": (48.538749, -103.47341),
    "58831": (47.737435, -103.298383),
    "58833": (48.816502, -103.467251),
    "58835": (47.807748, -103.438887),
    "58838": (47.737435, -103.298383),
    "58843": (48.276356, -103.376284),
    "58844": (48.816502, -103.467251),
    "58845": (48.5252, -103.917588),
    "58847": (47.737435, -103.298383),
    "58849": (48.321696, -103.165391),
    "58852": (48.364623, -102.957597),
    "58853": (48.295057, -103.438083),
    "58854": (47.802905, -103.2667),
    "58856": (48.532242, -103.772098),
    "59001": (45.515571, -109.455156),
    "59002": (45.929056, -108.688831),
    "59003": (45.605673, -106.278272),
    "59004": (46.017965, -106.99199),
    "59006": (45.892314, -108.098389),
    "59007": (45.161913, -109.158349),
    "59008": (45.091835, -109.034212),
    "59010": (46.176296, -107.33875),
    "59011": (45.834206, -109.950025),
    "59012": (46.017965, -106.99199),
    "59013": (45.410149, -109.136458),
    "59014": (45.335953, -108.920853),
    "59015": (46.041717, -108.759561),
    "59016": (45.536218, -106.961213),
    "59018": (45.834082, -110.622234),
    "59019": (45.657453, -109.206617),
    "59020": (45.023373, -109.90697),
    "59022": (45.608203, -107.469868),
    "59024": (46.212579, -107.693279),
    "59025": (45.518708, -107.481697),
    "59026": (45.444257, -108.848692),
    "59027": (45.270789, -110.79207099999999),
    "59028": (45.410217, -109.771658),
    "59029": (45.398686, -108.817298),
    "59030": (45.114735, -110.809991),
    "59031": (45.518708, -107.481697),
    "59032": (47.286641, -108.763415),
    "59033": (45.696301, -109.855062),
    "59034": (45.52731, -107.6963),
    "59035": (45.308898, -107.925665),
    "59036": (46.447745, -109.843492),
    "59037": (45.876735, -108.211535),
    "59038": (46.290753, -107.228948),
    "59039": (46.017965, -106.99199),
    "59041": (45.494126, -108.992234),
    "59043": (45.620185, -106.678901),
    "59044": (45.80418, -108.227571),
    "59046": (46.383858, -109.003382),
    "59047": (45.530664, -110.369054),
    "59050": (45.316565, -107.367494),
    "59052": (45.832835, -109.955671),
    "59053": (46.619039, -110.845396),
    "59054": (46.598623, -107.869188),
    "59055": (45.696301, -109.855062),
    "59057": (45.944684, -108.911917),
    "59058": (47.414133, -107.027417),
    "59059": (46.515315, -108.089742),
    "59061": (45.475459, -109.595984),
    "59062": (45.391078, -105.630461),
    "59063": (45.657911, -109.047266),
    "59064": (45.964417, -107.938592),
    "59065": (45.333104, -110.713691),
    "59066": (45.518708, -107.481697),
    "59067": (45.948864, -109.230246),
    "59068": (45.241262, -109.323626),
    "59069": (45.743871, -109.522372),
    "59070": (45.354073, -109.207199),
    "59071": (45.319054, -108.948445),
    "59072": (46.440929, -108.427325),
    "59073": (46.444224, -108.395473),
    "59074": (46.378527, -109.257354),
    "59075": (45.518708, -107.481697),
    "59076": (46.176296, -107.33875),
    "59077": (47.414133, -107.027417),
    "59078": (46.485721, -109.834856),
    "59079": (46.082782, -108.435851),
    "59081": (45.004618, -109.98539),
    "59082": (45.33333, -110.477384),
    "59083": (46.017965, -106.99199),
    "59084": (47.173641, -108.281168),
    "59085": (46.424187, -110.071194),
    "59086": (46.016146, -110.599503),
    "59087": (47.002053, -108.122735),
    "59088": (46.091269, -108.011128),
    "59089": (45.518708, -107.481697),
    "59101": (45.686966, -108.387392),
    "59102": (45.790379, -108.588144),
    "59103": (45.978288, -108.194508),
    "59104": (45.978288, -108.194508),
    "59105": (45.949726, -108.599037),
    "59106": (45.799217, -108.568842),
    "59107": (45.825204, -108.393388),
    "59108": (45.978288, -108.194508),
    "59111": (45.978288, -108.194508),
    "59112": (45.978288, -108.194508),
    "59114": (45.978288, -108.194508),
    "59115": (45.978288, -108.194508),
    "59116": (45.978288, -108.194508),
    "59117": (45.978288, -108.194508),
    "59201": (48.2088, -105.072426),
    "59211": (48.700718, -104.360729),
    "59212": (48.139784, -104.219188),
    "59213": (48.280119, -104.94413),
    "59214": (47.24993, -105.906002),
    "59215": (47.484243, -105.758852),
    "59217": (47.711026, -104.183625),
    "59218": (48.150238, -104.517106),
    "59219": (48.558851, -104.294475),
    "59221": (47.853542, -104.061953),
    "59222": (48.781396, -105.562544),
    "59223": (48.019588, -106.446962),
    "59225": (48.295916, -106.032354),
    "59226": (48.335745, -104.492637),
    "59230": (48.43923, -106.474987),
    "59231": (48.403894, -106.542815),
    "59240": (48.330241, -106.609665),
    "59241": (48.342617, -106.854457),
    "59242": (48.292043, -104.813996),
    "59243": (47.752074, -104.638367),
    "59244": (48.678589, -106.357152),
    "59245": (48.280119, -104.94413),
    "59247": (48.544896, -104.418145),
    "59248": (48.216068, -106.320808),
    "59250": (48.912477, -106.272664),
    "59252": (48.899627, -104.793406),
    "59253": (48.72942, -105.885542),
    "59254": (48.747919, -104.468029),
    "59255": (48.115522, -105.189701),
    "59256": (48.694565, -104.552352),
    "59257": (48.728018, -104.940164),
    "59258": (48.569892, -104.570289),
    "59259": (47.463408, -104.988111),
    "59260": (48.650714, -106.119229),
    "59261": (48.457237, -107.342553),
    "59262": (47.452578, -104.342955),
    "59263": (48.712594, -105.535656),
    "59270": (47.655825, -104.195206),
    "59273": (48.330241, -106.609665),
    "59274": (47.874088, -105.535752),
    "59275": (48.868265, -104.314372),
    "59276": (48.8956, -105.161657),
    "59301": (46.447808, -105.795343),
    "59311": (45.567085, -104.539066),
    "59312": (46.017965, -106.99199),
    "59313": (46.351496, -104.273377),
    "59314": (45.391078, -105.630461),
    "59315": (47.409962, -104.959584),
    "59316": (45.567085, -104.539066),
    "59317": (45.25719, -105.256813),
    "59318": (47.414133, -107.027417),
    "59319": (45.567085, -104.539066),
    "59322": (47.414133, -107.027417),
    "59323": (45.934423, -106.636783),
    "59324": (45.897576, -104.640001),
    "59326": (46.860997, -105.345182),
    "59327": (46.174223, -106.6303),
    "59330": (47.180623, -104.774873),
    "59332": (45.567085, -104.539066),
    "59333": (46.017965, -106.99199),
    "59336": (46.323967, -105.462341),
    "59337": (47.325641, -106.943963),
    "59338": (46.323967, -105.462341),
    "59339": (47.254164, -105.172545),
    "59341": (46.860997, -105.345182),
    "59343": (45.391078, -105.630461),
    "59344": (46.283486, -104.475079),
    "59345": (45.391078, -105.630461),
    "59347": (46.267953, -106.666959),
    "59348": (45.391078, -105.630461),
    "59349": (46.789256, -105.312757),
    "59351": (46.323967, -105.462341),
    "59353": (46.824454, -104.122311),
    "59354": (46.283486, -104.475079),
    "59401": (47.402024, -111.422948),
    "59402": (47.510209, -111.195906),
    "59403": (47.258392, -111.341975),
    "59404": (47.554109, -111.391407),
    "59405": (47.277623, -111.290803),
    "59406": (47.619998, -111.239305),
    "59410": (47.444053, -112.513362),
    "59411": (48.904169, -113.298384),
    "59412": (47.319621, -110.884712),
    "59414": (47.533156, -111.234986),
    "59416": (48.065733, -111.715365),
    "59417": (48.649105, -112.793626),
    "59418": (47.248497, -109.26308),
    "59419": (48.052324, -112.457343),
    "59420": (47.861021, -110.471075),
    "59421": (47.276562, -111.730457),
    "59422": (47.824102, -112.266872),
    "59424": (47.248497, -109.26308),
    "59425": (48.182782, -111.845931),
    "59427": (48.654298, -112.93062),
    "59430": (47.432933, -109.973645),
    "59432": (48.181533, -112.594329),
    "59433": (47.842372, -111.795709),
    "59434": (48.445686, -113.218976),
    "59435": (48.609072, -111.731852),
    "59436": (47.61386, -112.207191),
    "59440": (47.861021, -110.471075),
    "59441": (47.248497, -109.26308),
    "59442": (47.67977, -110.44038),
    "59443": (47.545978, -111.875624),
    "59444": (48.811061, -111.470386),
    "59445": (47.055715, -109.468299),
    "59446": (47.600099, -110.26891),
    "59447": (47.258941, -110.494703),
    "59448": (48.297291, -112.845587),
    "59450": (47.861021, -110.471075),
    "59451": (47.415174, -109.395158),
    "59452": (46.996773, -109.875615),
    "59453": (46.485721, -109.834856),
    "59454": (48.750313, -111.579092),
    "59456": (48.27717, -111.828592),
    "59457": (47.250047, -109.381996),
    "59460": (47.936513, -110.502597),
    "59461": (48.609072, -111.731852),
    "59462": (47.051079, -109.910548),
    "59463": (47.05149, -110.883026),
    "59464": (46.974485, -109.693316),
    "59465": (47.293879, -111.153717),
    "59466": (48.825895, -111.691145),
    "59467": (48.042871, -112.316655),
    "59468": (47.726972, -111.6938),
    "59469": (47.044583, -110.267003),
    "59471": (47.308278, -109.085342),
    "59472": (47.408651, -111.136243),
    "59473": (48.65417, -113.126262),
    "59474": (48.610551, -111.73233),
    "59477": (47.495784, -111.886092),
    "59479": (47.151357, -110.222384),
    "59480": (47.25466, -111.083851),
    "59482": (48.879199, -111.735136),
    "59483": (47.4808, -111.753303),
    "59484": (48.940067, -111.849008),
    "59485": (47.353925, -111.595425),
    "59486": (48.270833, -112.311973),
    "59487": (47.580761, -111.637014),
    "59489": (47.065531, -109.430106),
    "59501": (48.663002, -110.09437),
    "59520": (48.17641, -110.311201),
    "59521": (48.320405, -110.215299),
    "59522": (48.510659, -110.967372),
    "59523": (48.487741, -109.261678),
    "59524": (48.394962, -108.246539),
    "59525": (48.571498, -110.301301),
    "59526": (48.655123, -108.818157),
    "59527": (48.360516, -108.89392),
    "59528": (48.571498, -110.301301),
    "59529": (48.360516, -108.89392),
    "59530": (48.566602, -110.110287),
    "59531": (48.565402, -111.075884),
    "59532": (48.449359, -110.106003),
    "59535": (48.360516, -108.89392),
    "59537": (48.224749, -108.035444),
    "59538": (48.124479, -107.783145),
    "59540": (48.566602, -110.110287),
    "59542": (48.360516, -108.89392),
    "59544": (48.224749, -108.035444),
    "59545": (48.50968, -110.966631),
    "59546": (48.224749, -108.035444),
    "59547": (48.360516, -108.89392),
    "59601": (46.70934, -112.197616),
    "59602": (46.707449, -111.957961),
    "59604": (46.6672, -111.968877),
    "59620": (47.184233, -112.330214),
    "59623": (46.590083, -112.040173),
    "59624": (46.610002, -112.062393),
    "59625": (46.601832, -112.041346),
    "59626": (47.184233, -112.330214),
    "59631": (46.329577, -112.196662),
    "59632": (46.141948, -111.942989),
    "59633": (47.184233, -112.330214),
    "59634": (46.388739, -112.07162),
    "59635": (46.633769, -111.852594),
    "59636": (46.609677, -112.121494),
    "59638": (46.367883, -112.023155),
    "59639": (46.958253, -112.623833),
    "59640": (46.749945, -112.299402),
    "59641": (46.206922, -111.634364),
    "59642": (46.636196, -110.965623),
    "59643": (46.285118, -111.526373),
    "59644": (46.406137, -111.399649),
    "59645": (46.63316, -111.050627),
    "59647": (46.45447, -111.650954),
    "59648": (47.085616, -112.147602),
    "59701": (45.997895, -112.598765),
    "59702": (45.905345, -112.637705),
    "59703": (45.905345, -112.637705),
    "59707": (45.905345, -112.637705),
    "59710": (45.193898, -112.056807),
    "59711": (46.15821, -113.009421),
    "59713": (46.565725, -112.649859),
    "59714": (45.426786, -111.099517),
    "59715": (45.809998, -111.168212),
    "59716": (45.27826, -111.270773),
    "59717": (45.627982, -110.90128),
    "59718": (45.66812, -111.240393),
    "59719": (45.627982, -110.90128),
    "59720": (44.992962, -111.528472),
    "59721": (45.870517, -111.889682),
    "59722": (46.401859, -112.642136),
    "59724": (45.149805, -112.70073),
    "59725": (45.244373, -112.99687),
    "59727": (45.905345, -112.637705),
    "59728": (46.503396, -112.400742),
    "59729": (45.289586, -111.665136),
    "59730": (45.338987, -111.24848),
    "59731": (46.594845, -112.775572),
    "59732": (45.149805, -112.70073),
    "59733": (46.58791, -112.936757),
    "59735": (45.283594, -112.027561),
    "59736": (45.368653, -113.359826),
    "59739": (44.699033, -112.663633),
    "59740": (45.408045, -111.776123),
    "59741": (45.771228, -111.374118),
    "59743": (45.905345, -112.637705),
    "59745": (45.566095, -111.721631),
    "59746": (45.56265, -113.018805),
    "59747": (45.283594, -112.027561),
    "59748": (46.028844, -112.758914),
    "59749": (45.309586, -111.932378),
    "59750": (45.939758, -112.736528),
    "59751": (45.700002, -112.253501),
    "59752": (45.375515, -111.45624),
    "59754": (45.492611, -112.416508),
    "59755": (45.325565, -111.868085),
    "59756": (46.218279, -112.811742),
    "59758": (44.763016, -111.237705),
    "59759": (45.996345, -112.088845),
    "59760": (45.782744, -111.634532),
    "59761": (45.542434, -113.473541),
    "59762": (45.720048, -113.250784),
    "59771": (45.72465, -111.123775),
    "59772": (45.636149, -111.064676),
    "59773": (45.627982, -110.90128),
    "59801": (46.853606, -113.909123),
    "59802": (46.989689, -113.954788),
    "59803": (46.811758, -113.987645),
    "59804": (46.846708, -114.169784),
    "59806": (47.116034, -114.049824),
    "59807": (46.910342, -113.958686),
    "59808": (46.977603, -114.061856),
    "59812": (47.116034, -114.049824),
    "59820": (46.989275, -114.558456),
    "59821": (47.220055, -114.024625),
    "59823": (46.870183, -113.727871),
    "59824": (47.312398, -114.176098),
    "59825": (46.778468, -113.683052),
    "59826": (47.479334, -113.677639),
    "59827": (45.918972, -114.05904),
    "59828": (46.446801, -114.117918),
    "59829": (46.086434, -114.176841),
    "59830": (47.388827, -115.347934),
    "59831": (47.306957, -114.328588),
    "59832": (46.687633, -113.215445),
    "59833": (46.617296, -114.04192),
    "59834": (47.065558, -114.251384),
    "59835": (46.060169, -114.040777),
    "59836": (47.013278, -113.444116),
    "59837": (46.466704, -113.23873),
    "59840": (46.234189, -114.165774),
    "59841": (46.332893, -114.223493),
    "59842": (47.402824, -115.516347),
    "59843": (46.863363, -112.931166),
    "59844": (48.047863, -115.969619),
    "59845": (47.633565, -114.553693),
    "59846": (47.067886, -114.398643),
    "59847": (46.745400000000004, -114.299241),
    "59848": (47.725065, -114.657042),
    "59851": (46.873695, -113.878294),
    "59853": (48.076781, -115.858153),
    "59854": (47.035882, -113.097461),
    "59855": (47.651275, -114.212413),
    "59856": (47.387824, -114.799),
    "59858": (46.272241, -113.435709),
    "59859": (47.603143, -115.083253),
    "59860": (47.737279, -114.230256),
    "59863": (47.594957, -114.101443),
    "59864": (47.507347, -114.178287),
    "59865": (47.37245, -114.064086),
    "59866": (47.311106, -115.140511),
    "59867": (47.399653, -115.422358),
    "59868": (47.300776, -113.548481),
    "59870": (46.320508, -114.047154),
    "59871": (45.843266, -113.874776),
    "59872": (47.137198, -114.747599),
    "59873": (47.744885, -115.407291),
    "59874": (47.794472, -115.538422),
    "59875": (46.395224, -114.160159),
    "59901": (48.202765, -114.303919),
    "59902": (48.189424, -114.143531),
    "59903": (48.22372, -114.429648),
    "59904": (48.240382, -114.256123),
    "59910": (47.76942, -114.281296),
    "59911": (48.145854, -113.921121),
    "59912": (48.358322, -114.345902),
    "59913": (48.434243, -114.058384),
    "59914": (47.854921, -114.281873),
    "59915": (47.696598, -114.214962),
    "59916": (48.324238, -113.893384),
    "59917": (48.729135, -115.345992),
    "59918": (48.758601, -114.880925),
    "59919": (48.279332, -113.910545),
    "59920": (48.047758, -114.513752),
    "59921": (48.298875, -113.949739),
    "59922": (48.17669, -114.234902),
    "59923": (48.380992, -115.394062),
    "59925": (48.09368, -114.727422),
    "59926": (48.400447, -114.087311),
    "59927": (48.545453, -114.591981),
    "59928": (48.77808, -114.338774),
    "59929": (47.907058, -114.341333),
    "59930": (48.867183, -115.118207),
    "59931": (47.899392, -114.206827),
    "59932": (48.06771, -114.2017),
    "59933": (48.44572, -115.330964),
    "59934": (48.44572, -115.330964),
    "59935": (48.580494, -115.816915),
    "59936": (48.432962, -114.062198),
    "59937": (48.274564, -114.365126),
    "60001": (42.324761, -88.452481),
    "60002": (42.451419, -88.075733),
    "60004": (42.085626, -87.99822),
    "60005": (42.060928, -87.883073),
    "60006": (41.811929, -87.68732),
    "60007": (42.020278, -87.905866),
    "60008": (42.074226, -88.026871),
    "60009": (41.811929, -87.68732),
    "60010": (42.2735, -88.072583),
    "60011": (42.322814, -87.610053),
    "60012": (42.232096, -88.305292),
    "60013": (42.204626, -88.250783),
    "60014": (42.243772, -88.323986),
    "60015": (42.178175, -87.866818),
    "60016": (42.048278, -87.890466),
    "60017": (42.028779, -87.894366),
    "60018": (42.015479, -87.868714),
    "60019": (42.024278, -87.907066),
    "60020": (42.40247, -88.170234),
    "60021": (42.213058, -88.250406),
    "60022": (42.102927, -87.815914),
    "60025": (42.082715, -87.819714),
    "60026": (41.811929, -87.68732),
    "60029": (42.058029, -87.791636),
    "60030": (42.352423, -88.054502),
    "60031": (42.375121, -87.939683),
    "60033": (42.362962, -88.495375),
    "60034": (42.455151, -88.430802),
    "60035": (42.187424, -87.811865),
    "60037": (42.255073, -87.818268),
    "60038": (42.097976, -88.014072),
    "60039": (42.324761, -88.452481),
    "60040": (42.207374, -87.814666),
    "60041": (42.366521, -88.145683),
    "60042": (42.27179, -88.188464),
    "60043": (42.088428, -87.71456),
    "60044": (42.294172, -87.86767),
    "60045": (42.240027, -87.877569),
    "60046": (42.381271, -87.999077),
    "60047": (42.216543, -88.076942),
    "60048": (42.28947, -87.957724),
    "60049": (42.198674, -88.041875),
    "60050": (42.296671, -88.320886),
    "60051": (42.324761, -88.452481),
    "60053": (42.039329, -87.793815),
    "60055": (42.097976, -88.014072),
    "60056": (42.062377, -87.931797),
    "60060": (42.252523, -88.027327),
    "60061": (42.231183, -87.962973),
    "60062": (42.120176, -87.838815),
    "60064": (42.347324, -87.962976),
    "60065": (41.811929, -87.68732),
    "60067": (42.101977, -88.055804),
    "60068": (42.037228, -87.843714),
    "60069": (42.309143, -87.987213),
    "60070": (42.105805, -87.939519),
    "60071": (42.328463, -88.429864),
    "60072": (42.404829, -88.305439),
    "60073": (42.279215, -88.050226),
    "60074": (42.129875, -88.049424),
    "60075": (42.322814, -87.610053),
    "60076": (42.057878, -87.883566),
    "60077": (42.03468, -87.76266),
    "60078": (41.811929, -87.68732),
    "60079": (42.322814, -87.610053),
    "60080": (42.442519, -88.276047),
    "60081": (42.367273, -88.252639),
    "60082": (42.116377, -87.812064),
    "60083": (42.440139, -87.940027),
    "60084": (42.249873, -88.073127),
    "60085": (42.327366, -87.982025),
    "60086": (42.43335, -87.776595),
    "60087": (42.372921, -87.868471),
    "60088": (42.309272, -87.85427),
    "60089": (42.180411, -87.960771),
    "60090": (42.124176, -87.933819),
    "60091": (42.079228, -87.72836),
    "60092": (42.322814, -87.610053),
    "60093": (42.112176, -87.940168),
    "60094": (41.811929, -87.68732),
    "60095": (41.811929, -87.68732),
    "60096": (42.47832, -87.834222),
    "60097": (42.355165, -88.332794),
    "60098": (42.320271, -88.462832),
    "60099": (42.45577, -87.884975),
    "60101": (41.887579, -88.022516),
    "60102": (42.280715, -88.461937),
    "60103": (42.033376, -88.157756),
    "60104": (41.811929, -87.68732),
    "60105": (41.839679, -88.088716),
    "60106": (41.839679, -88.088716),
    "60107": (42.019093, -88.178475),
    "60108": (41.839679, -88.088716),
    "60109": (42.045792, -88.539027),
    "60110": (42.125008, -88.297238),
    "60111": (42.008626, -88.83055),
    "60112": (41.926177, -88.684007),
    "60113": (41.931157999999996, -88.956564),
    "60115": (41.816826, -88.79101),
    "60116": (41.839679, -88.088716),
    "60117": (41.839679, -88.088716),
    "60118": (42.022867, -88.417789),
    "60119": (41.834928, -88.469931),
    "60120": (41.990689, -88.429777),
    "60121": (42.04133, -88.3126),
    "60122": (42.067101, -88.304994),
    "60123": (42.036325, -88.371044),
    "60125": (41.839679, -88.088716),
    "60126": (41.88353, -87.946413),
    "60128": (41.839679, -88.088716),
    "60129": (42.042932, -88.919791),
    "60130": (41.811929, -87.68732),
    "60131": (41.93598, -87.884962),
    "60132": (41.839679, -88.088716),
    "60134": (41.97974, -88.406165),
    "60135": (42.10153, -88.718101),
    "60136": (42.102524, -88.379932),
    "60137": (41.872034, -88.029385),
    "60138": (41.839679, -88.088716),
    "60139": (41.839679, -88.088716),
    "60140": (42.027886, -88.454812),
    "60141": (41.811929, -87.68732),
    "60142": (42.197379, -88.450815),
    "60143": (41.839679, -88.088716),
    "60144": (41.936977, -88.420178),
    "60145": (42.090787, -88.762765),
    "60146": (42.087039, -88.871153),
    "60147": (41.936977, -88.420178),
    "60148": (41.869829, -88.003864),
    "60150": (41.931731, -88.88516),
    "60151": (41.922915, -88.507929),
    "60152": (42.255176, -88.607897),
    "60153": (41.811929, -87.68732),
    "60154": (41.811929, -87.68732),
    "60155": (41.811929, -87.68732),
    "60157": (41.839679, -88.088716),
    "60159": (41.811929, -87.68732),
    "60160": (41.91488, -87.858707),
    "60161": (41.811929, -87.68732),
    "60162": (41.811929, -87.68732),
    "60163": (41.811929, -87.68732),
    "60164": (41.92138, -87.892412),
    "60165": (41.90743, -87.878011),
    "60168": (41.811929, -87.68732),
    "60170": (42.025776, -88.425931),
    "60171": (41.923168, -87.83931),
    "60172": (41.839679, -88.088716),
    "60173": (42.079837, -88.046403),
    "60174": (41.937151, -88.430167),
    "60175": (41.943171, -88.386905),
    "60176": (41.95918, -87.873412),
    "60177": (42.007476, -88.405895),
    "60178": (41.893687, -88.68562),
    "60179": (42.079336, -88.223655),
    "60180": (42.222569, -88.525091),
    "60181": (41.875379, -87.97643),
    "60182": (41.908736, -88.59915),
    "60183": (41.936977, -88.420178),
    "60184": (41.839679, -88.088716),
    "60185": (41.839679, -88.088716),
    "60186": (41.839679, -88.088716),
    "60187": (41.839679, -88.088716),
    "60188": (41.839679, -88.088716),
    "60189": (41.839679, -88.088716),
    "60190": (41.839679, -88.088716),
    "60191": (41.839679, -88.088716),
    "60192": (42.092487, -88.116129),
    "60193": (42.016827, -88.117844),
    "60194": (42.028926, -88.116655),
    "60195": (42.076376, -88.109263),
    "60196": (42.056376, -88.072522),
    "60197": (41.839679, -88.088716),
    "60199": (41.839679, -88.088716),
    "60201": (42.049148, -87.702155),
    "60202": (42.044529, -87.687969),
    "60203": (42.047928, -87.718159),
    "60204": (41.811929, -87.68732),
    "60208": (42.058629, -87.684506),
    "60209": (42.04973, -87.679408),
    "60301": (41.811929, -87.68732),
    "60302": (41.811929, -87.68732),
    "60303": (41.811929, -87.68732),
    "60304": (41.811929, -87.68732),
    "60305": (41.811929, -87.68732),
    "60401": (41.356872, -87.626723),
    "60402": (41.811929, -87.68732),
    "60406": (41.811929, -87.68732),
    "60407": (41.238676, -88.278834),
    "60408": (41.285878, -88.017171),
    "60409": (41.811929, -87.68732),
    "60410": (41.43313, -88.199325),
    "60411": (41.811929, -87.68732),
    "60412": (41.811929, -87.68732),
    "60415": (41.811929, -87.68732),
    "60416": (41.284033, -88.374819),
    "60417": (41.426684, -87.621223),
    "60419": (41.811929, -87.68732),
    "60420": (41.059551, -88.417086),
    "60421": (41.44288, -88.090588),
    "60422": (41.811929, -87.68732),
    "60423": (41.451744, -87.896109),
    "60424": (41.1775, -88.338018),
    "60425": (41.811929, -87.68732),
    "60426": (41.811929, -87.68732),
    "60429": (41.811929, -87.68732),
    "60430": (41.811929, -87.68732),
    "60431": (41.471206, -87.93909),
    "60432": (41.54273, -88.045146),
    "60433": (41.476265, -87.882249),
    "60434": (41.52543, -88.084208),
    "60435": (41.468729, -87.938034),
    "60436": (41.48843, -88.15716),
    "60437": (41.188078, -88.472407),
    "60438": (41.811929, -87.68732),
    "60439": (41.707431, -87.975568),
    "60440": (41.623336, -88.022464),
    "60441": (41.552615, -88.031268),
    "60442": (41.491903, -87.979113),
    "60443": (41.811929, -87.68732),
    "60444": (41.226425, -88.421748),
    "60445": (41.811929, -87.68732),
    "60446": (41.64038, -88.069621),
    "60447": (41.429869, -88.422884),
    "60448": (41.426002, -88.006767),
    "60449": (41.412269, -87.786645),
    "60450": (41.337433, -88.430183),
    "60451": (41.510802, -87.961808),
    "60452": (41.811929, -87.68732),
    "60453": (41.811929, -87.68732),
    "60454": (41.811929, -87.68732),
    "60455": (41.811929, -87.68732),
    "60456": (41.811929, -87.68732),
    "60457": (41.811929, -87.68732),
    "60458": (41.811929, -87.68732),
    "60459": (41.811929, -87.68732),
    "60460": (40.998811, -88.538538),
    "60461": (41.811929, -87.68732),
    "60462": (41.811929, -87.68732),
    "60463": (41.811929, -87.68732),
    "60464": (41.811929, -87.68732),
    "60465": (41.811929, -87.68732),
    "60466": (41.811929, -87.68732),
    "60467": (41.811929, -87.68732),
    "60468": (41.346316, -87.772133),
    "60469": (41.811929, -87.68732),
    "60470": (41.172532, -88.663755),
    "60471": (41.811929, -87.68732),
    "60472": (41.95273, -87.878888),
    "60473": (41.811929, -87.68732),
    "60474": (41.171883, -88.267338),
    "60475": (41.811929, -87.68732),
    "60476": (41.811929, -87.68732),
    "60477": (42.143475, -88.026517),
    "60478": (41.811929, -87.68732),
    "60479": (41.247346, -88.505582),
    "60480": (41.811929, -87.68732),
    "60481": (41.35934, -88.084716),
    "60482": (41.811929, -87.68732),
    "60490": (41.679041, -88.140332),
    "60499": (41.811929, -87.68732),
    "60501": (41.811929, -87.68732),
    "60504": (41.768399, -88.136616),
    "60505": (41.765478, -88.405446),
    "60506": (41.79083, -88.416837),
    "60507": (41.936977, -88.420178),
    "60510": (41.828292, -88.407334),
    "60511": (41.764324, -88.54574),
    "60512": (41.698414, -88.427873),
    "60513": (41.811929, -87.68732),
    "60514": (41.774295, -87.966094),
    "60515": (41.796279, -88.012267),
    "60516": (41.75231, -88.021797),
    "60517": (41.736788, -88.041731),
    "60518": (41.549922, -88.935981),
    "60519": (41.777235, -88.246193),
    "60520": (41.740713, -88.686052),
    "60521": (41.78213, -87.966845),
    "60522": (41.839679, -88.088716),
    "60523": (41.83713, -87.963759),
    "60525": (41.811929, -87.68732),
    "60526": (41.811929, -87.68732),
    "60527": (41.839679, -88.088716),
    "60530": (41.784398, -88.97506),
    "60531": (41.47805, -88.7265),
    "60532": (41.79818, -88.037714),
    "60534": (41.811929, -87.68732),
    "60536": (41.590315, -88.562023),
    "60537": (41.561386, -88.59747),
    "60538": (41.643752, -88.457951),
    "60539": (41.823928, -88.334023),
    "60540": (41.759029, -88.152381),
    "60541": (41.540661, -88.492909),
    "60542": (41.807369, -88.335182),
    "60543": (41.631012, -88.420476),
    "60544": (41.632457, -88.169698),
    "60545": (41.628567, -88.513814),
    "60546": (41.811929, -87.68732),
    "60548": (41.702091, -88.688906),
    "60549": (41.48974, -88.752495),
    "60550": (41.746774, -88.836821),
    "60551": (41.521219, -88.710974),
    "60552": (41.860645, -88.783041),
    "60553": (41.796742, -89.086129),
    "60554": (41.776787, -88.451655),
    "60555": (41.805422, -88.171551),
    "60556": (41.755215, -88.778554),
    "60557": (41.44088, -88.770327),
    "60558": (41.811929, -87.68732),
    "60559": (41.799876, -87.970713),
    "60560": (41.601679, -88.437533),
    "60561": (41.743437, -87.98046),
    "60563": (41.782455, -88.149884),
    "60564": (41.681479, -88.201424),
    "60565": (41.737929, -88.112714),
    "60566": (41.839679, -88.088716),
    "60567": (41.839679, -88.088716),
    "60568": (41.935616, -88.43238),
    "60570": (41.839679, -88.088716),
    "60572": (41.839679, -88.088716),
    "60597": (41.839679, -88.088716),
    "60598": (41.839679, -88.088716),
    "60599": (41.839679, -88.088716),
    "60601": (41.811929, -87.68732),
    "60602": (41.811929, -87.68732),
    "60603": (42.055179, -87.72596),
    "60604": (41.811929, -87.68732),
    "60605": (41.811929, -87.68732),
    "60606": (41.811929, -87.68732),
    "60607": (41.928881, -87.81381),
    "60608": (41.811929, -87.68732),
    "60609": (41.811929, -87.68732),
    "60610": (41.811929, -87.68732),
    "60611": (41.811929, -87.68732),
    "60612": (41.811929, -87.68732),
    "60613": (41.811929, -87.68732),
    "60614": (41.811929, -87.68732),
    "60615": (41.811929, -87.68732),
    "60616": (41.811929, -87.68732),
    "60617": (41.811929, -87.68732),
    "60618": (41.811929, -87.68732),
    "60619": (41.811929, -87.68732),
    "60620": (41.811929, -87.68732),
    "60621": (41.811929, -87.68732),
    "60622": (41.811929, -87.68732),
    "60623": (41.811929, -87.68732),
    "60624": (41.811929, -87.68732),
    "60625": (41.811929, -87.68732),
    "60626": (41.811929, -87.68732),
    "60628": (41.811929, -87.68732),
    "60629": (41.811929, -87.68732),
    "60630": (41.811929, -87.68732),
    "60631": (42.00583, -87.808611),
    "60632": (41.811929, -87.68732),
    "60633": (41.811929, -87.68732),
    "60634": (41.933355, -87.816309),
    "60636": (41.811929, -87.68732),
    "60637": (41.811929, -87.68732),
    "60638": (41.811929, -87.68732),
    "60639": (41.811929, -87.68732),
    "60640": (41.811929, -87.68732),
    "60641": (41.811929, -87.68732),
    "60643": (41.811929, -87.68732),
    "60644": (41.811929, -87.68732),
    "60645": (42.00808, -87.721458),
    "60646": (42.00663, -87.75901),
    "60647": (41.811929, -87.68732),
    "60649": (41.811929, -87.68732),
    "60651": (41.811929, -87.68732),
    "60652": (41.811929, -87.68732),
    "60653": (41.811929, -87.68732),
    "60654": (41.811929, -87.68732),
    "60655": (41.811929, -87.68732),
    "60656": (41.97353, -87.865763),
    "60657": (41.811929, -87.68732),
    "60659": (41.997247, -87.716621),
    "60660": (41.811929, -87.68732),
    "60661": (41.811929, -87.68732),
    "60663": (41.811929, -87.68732),
    "60664": (41.811929, -87.68732),
    "60665": (41.811929, -87.68732),
    "60666": (41.968029, -87.891214),
    "60667": (41.811929, -87.68732),
    "60668": (41.811929, -87.68732),
    "60669": (41.811929, -87.68732),
    "60670": (41.811929, -87.68732),
    "60671": (41.811929, -87.68732),
    "60672": (41.811929, -87.68732),
    "60673": (41.811929, -87.68732),
    "60674": (41.811929, -87.68732),
    "60675": (41.811929, -87.68732),
    "60677": (41.811929, -87.68732),
    "60678": (41.811929, -87.68732),
    "60679": (41.811929, -87.68732),
    "60680": (41.811929, -87.68732),
    "60681": (41.811929, -87.68732),
    "60683": (41.811929, -87.68732),
    "60684": (41.811929, -87.68732),
    