"""
    Red Hat Openshift SmartEvents Fleet Manager V2

    The API exposed by the fleet manager of the SmartEvents service.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: openbridge-dev@redhat.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from rhoas_smart_events_mgmt_sdk.api_client import ApiClient, Endpoint as _Endpoint
from rhoas_smart_events_mgmt_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from rhoas_smart_events_mgmt_sdk.model.errors_list import ErrorsList
from rhoas_smart_events_mgmt_sdk.model.managed_resource_status import ManagedResourceStatus
from rhoas_smart_events_mgmt_sdk.model.processor_list_response import ProcessorListResponse
from rhoas_smart_events_mgmt_sdk.model.processor_request import ProcessorRequest
from rhoas_smart_events_mgmt_sdk.model.processor_response import ProcessorResponse


class ProcessorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.processors_api_create_processor_endpoint = _Endpoint(
            settings={
                'response_type': (ProcessorResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/smartevents_mgmt/v2/bridges/{bridgeId}/processors',
                'operation_id': 'processors_api_create_processor',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_id',
                    'processor_request',
                ],
                'required': [
                    'bridge_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bridge_id',
                ]
            },
            root_map={
                'validations': {
                    ('bridge_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_id':
                        (str,),
                    'processor_request':
                        (ProcessorRequest,),
                },
                'attribute_map': {
                    'bridge_id': 'bridgeId',
                },
                'location_map': {
                    'bridge_id': 'path',
                    'processor_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.processors_api_delete_processor_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/smartevents_mgmt/v2/bridges/{bridgeId}/processors/{processorId}',
                'operation_id': 'processors_api_delete_processor',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_id',
                    'processor_id',
                ],
                'required': [
                    'bridge_id',
                    'processor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_id':
                        (str,),
                    'processor_id':
                        (str,),
                },
                'attribute_map': {
                    'bridge_id': 'bridgeId',
                    'processor_id': 'processorId',
                },
                'location_map': {
                    'bridge_id': 'path',
                    'processor_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.processors_api_get_processor_endpoint = _Endpoint(
            settings={
                'response_type': (ProcessorResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/smartevents_mgmt/v2/bridges/{bridgeId}/processors/{processorId}',
                'operation_id': 'processors_api_get_processor',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_id',
                    'processor_id',
                ],
                'required': [
                    'bridge_id',
                    'processor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bridge_id',
                    'processor_id',
                ]
            },
            root_map={
                'validations': {
                    ('bridge_id',): {

                        'min_length': 1,
                    },
                    ('processor_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_id':
                        (str,),
                    'processor_id':
                        (str,),
                },
                'attribute_map': {
                    'bridge_id': 'bridgeId',
                    'processor_id': 'processorId',
                },
                'location_map': {
                    'bridge_id': 'path',
                    'processor_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.processors_api_get_processors_endpoint = _Endpoint(
            settings={
                'response_type': (ProcessorListResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/smartevents_mgmt/v2/bridges/{bridgeId}/processors',
                'operation_id': 'processors_api_get_processors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_id',
                    'name',
                    'page',
                    'size',
                    'status',
                ],
                'required': [
                    'bridge_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bridge_id',
                    'page',
                    'size',
                    'status',
                ]
            },
            root_map={
                'validations': {
                    ('bridge_id',): {

                        'min_length': 1,
                    },
                    ('page',): {

                        'inclusive_minimum': 0,
                    },
                    ('size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('status',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_id':
                        (str,),
                    'name':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'status':
                        ([ManagedResourceStatus],),
                },
                'attribute_map': {
                    'bridge_id': 'bridgeId',
                    'name': 'name',
                    'page': 'page',
                    'size': 'size',
                    'status': 'status',
                },
                'location_map': {
                    'bridge_id': 'path',
                    'name': 'query',
                    'page': 'query',
                    'size': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'status': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.processors_api_update_processor_endpoint = _Endpoint(
            settings={
                'response_type': (ProcessorResponse,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/api/smartevents_mgmt/v2/bridges/{bridgeId}/processors/{processorId}',
                'operation_id': 'processors_api_update_processor',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'bridge_id',
                    'processor_id',
                    'processor_request',
                ],
                'required': [
                    'bridge_id',
                    'processor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bridge_id',
                    'processor_id',
                ]
            },
            root_map={
                'validations': {
                    ('bridge_id',): {

                        'min_length': 1,
                    },
                    ('processor_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bridge_id':
                        (str,),
                    'processor_id':
                        (str,),
                    'processor_request':
                        (ProcessorRequest,),
                },
                'attribute_map': {
                    'bridge_id': 'bridgeId',
                    'processor_id': 'processorId',
                },
                'location_map': {
                    'bridge_id': 'path',
                    'processor_id': 'path',
                    'processor_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def processors_api_create_processor(
        self,
        bridge_id,
        **kwargs
    ):
        """Create a Processor of a Bridge instance  # noqa: E501

        Create a Processor of a Bridge instance for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.processors_api_create_processor(bridge_id, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_id (str):

        Keyword Args:
            processor_request (ProcessorRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProcessorResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_id'] = \
            bridge_id
        return self.processors_api_create_processor_endpoint.call_with_http_info(**kwargs)

    def processors_api_delete_processor(
        self,
        bridge_id,
        processor_id,
        **kwargs
    ):
        """Delete a Processor of a Bridge instance  # noqa: E501

        Delete a Processor of a Bridge instance for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.processors_api_delete_processor(bridge_id, processor_id, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_id (str):
            processor_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_id'] = \
            bridge_id
        kwargs['processor_id'] = \
            processor_id
        return self.processors_api_delete_processor_endpoint.call_with_http_info(**kwargs)

    def processors_api_get_processor(
        self,
        bridge_id,
        processor_id,
        **kwargs
    ):
        """Get a Processor of a Bridge instance  # noqa: E501

        Get a Processor of a Bridge instance for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.processors_api_get_processor(bridge_id, processor_id, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_id (str):
            processor_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProcessorResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_id'] = \
            bridge_id
        kwargs['processor_id'] = \
            processor_id
        return self.processors_api_get_processor_endpoint.call_with_http_info(**kwargs)

    def processors_api_get_processors(
        self,
        bridge_id,
        **kwargs
    ):
        """Get the list of Processors of a Bridge instance  # noqa: E501

        Get the list of Processors of a Bridge instance for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.processors_api_get_processors(bridge_id, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_id (str):

        Keyword Args:
            name (str): [optional]
            page (int): [optional] if omitted the server will use the default value of 0
            size (int): [optional] if omitted the server will use the default value of 100
            status ([ManagedResourceStatus]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProcessorListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_id'] = \
            bridge_id
        return self.processors_api_get_processors_endpoint.call_with_http_info(**kwargs)

    def processors_api_update_processor(
        self,
        bridge_id,
        processor_id,
        **kwargs
    ):
        """Update a Processor instance.  # noqa: E501

        Update a Processor instance for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.processors_api_update_processor(bridge_id, processor_id, async_req=True)
        >>> result = thread.get()

        Args:
            bridge_id (str):
            processor_id (str):

        Keyword Args:
            processor_request (ProcessorRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProcessorResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['bridge_id'] = \
            bridge_id
        kwargs['processor_id'] = \
            processor_id
        return self.processors_api_update_processor_endpoint.call_with_http_info(**kwargs)

