"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Application Load Balancer integration resource for HTTP API
 */
class HttpAlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB application listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpAlbIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpAlbIntegration);
            }
            throw error;
        }
    }
    bind(options) {
        let vpc = this.props.vpcLink?.vpc;
        if (!vpc && (this.listener instanceof elbv2.ApplicationListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Application Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpAlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpAlbIntegration", version: "2.79.0-alpha.0" };
exports.HttpAlbIntegration = HttpAlbIntegration;
//# sourceMappingURL=data:application/json;base64,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