"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUrlIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpUrlIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param url the URL to proxy to
     * @param props properties to configure the integration
     */
    constructor(id, url, props = {}) {
        super(id);
        this.url = url;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpUrlIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpUrlIntegration);
            }
            throw error;
        }
    }
    bind(_options) {
        return {
            method: this.props.method ?? aws_apigatewayv2_alpha_1.HttpMethod.ANY,
            payloadFormatVersion: aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0,
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.url,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpUrlIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", version: "2.79.0-alpha.0" };
exports.HttpUrlIntegration = HttpUrlIntegration;
//# sourceMappingURL=data:application/json;base64,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