"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class HttpLambdaIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda handler to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, handler, props = {}) {
        super(id);
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpLambdaIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpLambdaIntegration);
            }
            throw error;
        }
        this._id = id;
    }
    completeBind(options) {
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${route.path ?? ''}`, // empty string in the case of the catch-all route $default
            }),
        });
    }
    bind(_options) {
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.AWS_PROXY,
            uri: this.handler.functionArn,
            payloadFormatVersion: this.props.payloadFormatVersion ?? aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration", version: "2.79.0-alpha.0" };
exports.HttpLambdaIntegration = HttpLambdaIntegration;
//# sourceMappingURL=data:application/json;base64,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