"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Lambda WebSocket Integration
 */
class WebSocketLambdaIntegration extends aws_apigatewayv2_alpha_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda function handler
     * @param props properties to configure the integration
     */
    constructor(id, handler) {
        super(id);
        this.handler = handler;
        this._id = id;
    }
    bind(options) {
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = aws_cdk_lib_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketLambdaIntegration", version: "2.79.0-alpha.0" };
exports.WebSocketLambdaIntegration = WebSocketLambdaIntegration;
//# sourceMappingURL=data:application/json;base64,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