import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable description of the environment. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#description DialogflowCxEnvironment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The human-readable name of the environment (unique in an agent). Limit of 64 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#display_name DialogflowCxEnvironment#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The Agent to create an Environment for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#parent DialogflowCxEnvironment#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#timeouts DialogflowCxEnvironment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxEnvironmentTimeouts;
    /**
     * version_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#version_configs DialogflowCxEnvironment#version_configs}
     *
     * @stability stable
     */
    readonly versionConfigs: DialogflowCxEnvironmentVersionConfigs[];
}
/**
 * @stability stable
 */
export interface DialogflowCxEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#create DialogflowCxEnvironment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#delete DialogflowCxEnvironment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#update DialogflowCxEnvironment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DialogflowCxEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxEnvironmentVersionConfigs {
    /**
     * Format: projects/{{project}}/locations/{{location}}/agents/{{agent}}/flows/{{flow}}/versions/{{version}}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#version DialogflowCxEnvironment#version}
     *
     * @stability stable
     */
    readonly version: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html google_dialogflow_cx_environment}.
 *
 * @stability stable
 */
export declare class DialogflowCxEnvironment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html google_dialogflow_cx_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxEnvironmentConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string | undefined;
    /**
     * @stability stable
     */
    set parent(value: string | undefined);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxEnvironmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxEnvironmentTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxEnvironmentTimeouts | undefined;
    private _versionConfigs?;
    /**
     * @stability stable
     */
    get versionConfigs(): DialogflowCxEnvironmentVersionConfigs[];
    /**
     * @stability stable
     */
    set versionConfigs(value: DialogflowCxEnvironmentVersionConfigs[]);
    /**
     * @stability stable
     */
    get versionConfigsInput(): DialogflowCxEnvironmentVersionConfigs[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
