import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-friendly name for the uptime check configuration.
     *
     * The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#display_name MonitoringUptimeCheckConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * How often, in seconds, the uptime check is performed.
     *
     * Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#period MonitoringUptimeCheckConfig#period}
     *
     * @stability stable
     */
    readonly period?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#project MonitoringUptimeCheckConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The list of regions from which the check will be run.
     *
     * Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#selected_regions MonitoringUptimeCheckConfig#selected_regions}
     *
     * @stability stable
     */
    readonly selectedRegions?: string[];
    /**
     * The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds).
     *
     * Accepted formats https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.Duration
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeout MonitoringUptimeCheckConfig#timeout}
     *
     * @stability stable
     */
    readonly timeout: string;
    /**
     * content_matchers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_matchers MonitoringUptimeCheckConfig#content_matchers}
     *
     * @stability stable
     */
    readonly contentMatchers?: MonitoringUptimeCheckConfigContentMatchers[];
    /**
     * http_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#http_check MonitoringUptimeCheckConfig#http_check}
     *
     * @stability stable
     */
    readonly httpCheck?: MonitoringUptimeCheckConfigHttpCheck;
    /**
     * monitored_resource block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#monitored_resource MonitoringUptimeCheckConfig#monitored_resource}
     *
     * @stability stable
     */
    readonly monitoredResource?: MonitoringUptimeCheckConfigMonitoredResource;
    /**
     * resource_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_group MonitoringUptimeCheckConfig#resource_group}
     *
     * @stability stable
     */
    readonly resourceGroup?: MonitoringUptimeCheckConfigResourceGroup;
    /**
     * tcp_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#tcp_check MonitoringUptimeCheckConfig#tcp_check}
     *
     * @stability stable
     */
    readonly tcpCheck?: MonitoringUptimeCheckConfigTcpCheck;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeouts MonitoringUptimeCheckConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringUptimeCheckConfigTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigContentMatchers {
    /**
     * String or regex content to match (max 1024 bytes).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content MonitoringUptimeCheckConfig#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
     *
     * Default value: "CONTAINS_STRING" Possible values: ["CONTAINS_STRING", "NOT_CONTAINS_STRING", "MATCHES_REGEX", "NOT_MATCHES_REGEX"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#matcher MonitoringUptimeCheckConfig#matcher}
     *
     * @stability stable
     */
    readonly matcher?: string;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigHttpCheckAuthInfo {
    /**
     * The password to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#password MonitoringUptimeCheckConfig#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * The username to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#username MonitoringUptimeCheckConfig#username}
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigHttpCheck {
    /**
     * The request body associated with the HTTP POST request.
     *
     * If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#body MonitoringUptimeCheckConfig#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * The content type to use for the check. Possible values: ["TYPE_UNSPECIFIED", "URL_ENCODED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_type MonitoringUptimeCheckConfig#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * The list of headers to send as part of the uptime check request.
     *
     * If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#headers MonitoringUptimeCheckConfig#headers}
     *
     * @stability stable
     */
    readonly headers?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Boolean specifying whether to encrypt the header information.
     *
     * Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#mask_headers MonitoringUptimeCheckConfig#mask_headers}
     *
     * @stability stable
     */
    readonly maskHeaders?: boolean | cdktf.IResolvable;
    /**
     * The path to the page to run the check against.
     *
     * Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#path MonitoringUptimeCheckConfig#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * The HTTP request method to use for the check.
     *
     * If set to METHOD_UNSPECIFIED then requestMethod defaults to GET. Default value: "GET" Possible values: ["METHOD_UNSPECIFIED", "GET", "POST"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#request_method MonitoringUptimeCheckConfig#request_method}
     *
     * @stability stable
     */
    readonly requestMethod?: string;
    /**
     * If true, use HTTPS instead of HTTP to run the check.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#use_ssl MonitoringUptimeCheckConfig#use_ssl}
     *
     * @stability stable
     */
    readonly useSsl?: boolean | cdktf.IResolvable;
    /**
     * Boolean specifying whether to include SSL certificate validation as a part of the Uptime check.
     *
     * Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#validate_ssl MonitoringUptimeCheckConfig#validate_ssl}
     *
     * @stability stable
     */
    readonly validateSsl?: boolean | cdktf.IResolvable;
    /**
     * auth_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#auth_info MonitoringUptimeCheckConfig#auth_info}
     *
     * @stability stable
     */
    readonly authInfo?: MonitoringUptimeCheckConfigHttpCheckAuthInfo;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigHttpCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string | undefined;
    /**
     * @stability stable
     */
    set body(value: string | undefined);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string | undefined;
    /**
     * @stability stable
     */
    set contentType(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set headers(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maskHeaders?;
    /**
     * @stability stable
     */
    get maskHeaders(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set maskHeaders(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMaskHeaders(): void;
    /**
     * @stability stable
     */
    get maskHeadersInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string | undefined;
    /**
     * @stability stable
     */
    set path(value: string | undefined);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _requestMethod?;
    /**
     * @stability stable
     */
    get requestMethod(): string | undefined;
    /**
     * @stability stable
     */
    set requestMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestMethod(): void;
    /**
     * @stability stable
     */
    get requestMethodInput(): string | undefined;
    private _useSsl?;
    /**
     * @stability stable
     */
    get useSsl(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set useSsl(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUseSsl(): void;
    /**
     * @stability stable
     */
    get useSslInput(): boolean | cdktf.IResolvable | undefined;
    private _validateSsl?;
    /**
     * @stability stable
     */
    get validateSsl(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set validateSsl(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValidateSsl(): void;
    /**
     * @stability stable
     */
    get validateSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authInfo?;
    private __authInfoOutput;
    /**
     * @stability stable
     */
    get authInfo(): MonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference;
    /**
     * @stability stable
     */
    putAuthInfo(value: MonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined): void;
    /**
     * @stability stable
     */
    resetAuthInfo(): void;
    /**
     * @stability stable
     */
    get authInfoInput(): MonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigMonitoredResource {
    /**
     * Values for all of the labels listed in the associated monitored resource descriptor.
     *
     * For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#labels MonitoringUptimeCheckConfig#labels}
     *
     * @stability stable
     */
    readonly labels: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The monitored resource type.
     *
     * This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#type MonitoringUptimeCheckConfig#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigMonitoredResourceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigResourceGroup {
    /**
     * The group of resources being monitored. Should be the 'name' of a group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#group_id MonitoringUptimeCheckConfig#group_id}
     *
     * @stability stable
     */
    readonly groupId?: string;
    /**
     * The resource type of the group members. Possible values: ["RESOURCE_TYPE_UNSPECIFIED", "INSTANCE", "AWS_ELB_LOAD_BALANCER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_type MonitoringUptimeCheckConfig#resource_type}
     *
     * @stability stable
     */
    readonly resourceType?: string;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigResourceGroupOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string | undefined;
    /**
     * @stability stable
     */
    set groupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroupId(): void;
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string | undefined;
    /**
     * @stability stable
     */
    set resourceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceType(): void;
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigTcpCheck {
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) to construct the full URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     *
     * @stability stable
     */
    readonly port: number;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigTcpCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#create MonitoringUptimeCheckConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#delete MonitoringUptimeCheckConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#update MonitoringUptimeCheckConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config}.
 *
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringUptimeCheckConfigConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _period?;
    /**
     * @stability stable
     */
    get period(): string | undefined;
    /**
     * @stability stable
     */
    set period(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeriod(): void;
    /**
     * @stability stable
     */
    get periodInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _selectedRegions?;
    /**
     * @stability stable
     */
    get selectedRegions(): string[] | undefined;
    /**
     * @stability stable
     */
    set selectedRegions(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSelectedRegions(): void;
    /**
     * @stability stable
     */
    get selectedRegionsInput(): string[] | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
    /**
     * @stability stable
     */
    get uptimeCheckId(): string;
    private _contentMatchers?;
    /**
     * @stability stable
     */
    get contentMatchers(): MonitoringUptimeCheckConfigContentMatchers[] | undefined;
    /**
     * @stability stable
     */
    set contentMatchers(value: MonitoringUptimeCheckConfigContentMatchers[] | undefined);
    /**
     * @stability stable
     */
    resetContentMatchers(): void;
    /**
     * @stability stable
     */
    get contentMatchersInput(): MonitoringUptimeCheckConfigContentMatchers[] | undefined;
    private _httpCheck?;
    private __httpCheckOutput;
    /**
     * @stability stable
     */
    get httpCheck(): MonitoringUptimeCheckConfigHttpCheckOutputReference;
    /**
     * @stability stable
     */
    putHttpCheck(value: MonitoringUptimeCheckConfigHttpCheck | undefined): void;
    /**
     * @stability stable
     */
    resetHttpCheck(): void;
    /**
     * @stability stable
     */
    get httpCheckInput(): MonitoringUptimeCheckConfigHttpCheck | undefined;
    private _monitoredResource?;
    private __monitoredResourceOutput;
    /**
     * @stability stable
     */
    get monitoredResource(): MonitoringUptimeCheckConfigMonitoredResourceOutputReference;
    /**
     * @stability stable
     */
    putMonitoredResource(value: MonitoringUptimeCheckConfigMonitoredResource | undefined): void;
    /**
     * @stability stable
     */
    resetMonitoredResource(): void;
    /**
     * @stability stable
     */
    get monitoredResourceInput(): MonitoringUptimeCheckConfigMonitoredResource | undefined;
    private _resourceGroup?;
    private __resourceGroupOutput;
    /**
     * @stability stable
     */
    get resourceGroup(): MonitoringUptimeCheckConfigResourceGroupOutputReference;
    /**
     * @stability stable
     */
    putResourceGroup(value: MonitoringUptimeCheckConfigResourceGroup | undefined): void;
    /**
     * @stability stable
     */
    resetResourceGroup(): void;
    /**
     * @stability stable
     */
    get resourceGroupInput(): MonitoringUptimeCheckConfigResourceGroup | undefined;
    private _tcpCheck?;
    private __tcpCheckOutput;
    /**
     * @stability stable
     */
    get tcpCheck(): MonitoringUptimeCheckConfigTcpCheckOutputReference;
    /**
     * @stability stable
     */
    putTcpCheck(value: MonitoringUptimeCheckConfigTcpCheck | undefined): void;
    /**
     * @stability stable
     */
    resetTcpCheck(): void;
    /**
     * @stability stable
     */
    get tcpCheckInput(): MonitoringUptimeCheckConfigTcpCheck | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringUptimeCheckConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringUptimeCheckConfigTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringUptimeCheckConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
