import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VertexAiDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user-defined name of the Dataset.
     *
     * The name can be up to 128 characters long and can be consist of any UTF-8 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#display_name VertexAiDataset#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * A set of key/value label pairs to assign to this Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#labels VertexAiDataset#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Points to a YAML file stored on Google Cloud Storage describing additional information about the Dataset.
     *
     * The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#metadata_schema_uri VertexAiDataset#metadata_schema_uri}
     *
     * @stability stable
     */
    readonly metadataSchemaUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#project VertexAiDataset#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the dataset. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#region VertexAiDataset#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * encryption_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#encryption_spec VertexAiDataset#encryption_spec}
     *
     * @stability stable
     */
    readonly encryptionSpec?: VertexAiDatasetEncryptionSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#timeouts VertexAiDataset#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VertexAiDatasetTimeouts;
}
/**
 * @stability stable
 */
export interface VertexAiDatasetEncryptionSpec {
    /**
     * Required.
     *
     * The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
     * Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#kms_key_name VertexAiDataset#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
}
/**
 * @stability stable
 */
export declare class VertexAiDatasetEncryptionSpecOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyName(): void;
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VertexAiDatasetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#create VertexAiDataset#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#delete VertexAiDataset#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#update VertexAiDataset#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class VertexAiDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html google_vertex_ai_dataset}.
 *
 * @stability stable
 */
export declare class VertexAiDataset extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html google_vertex_ai_dataset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VertexAiDatasetConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _metadataSchemaUri?;
    /**
     * @stability stable
     */
    get metadataSchemaUri(): string;
    /**
     * @stability stable
     */
    set metadataSchemaUri(value: string);
    /**
     * @stability stable
     */
    get metadataSchemaUriInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _encryptionSpec?;
    private __encryptionSpecOutput;
    /**
     * @stability stable
     */
    get encryptionSpec(): VertexAiDatasetEncryptionSpecOutputReference;
    /**
     * @stability stable
     */
    putEncryptionSpec(value: VertexAiDatasetEncryptionSpec | undefined): void;
    /**
     * @stability stable
     */
    resetEncryptionSpec(): void;
    /**
     * @stability stable
     */
    get encryptionSpecInput(): VertexAiDatasetEncryptionSpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VertexAiDatasetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VertexAiDatasetTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VertexAiDatasetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
