import * as iam from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ILogGroup, SubscriptionFilterOptions } from './log-group';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Interface for classes that can be the destination of a log Subscription.
 *
 * @stability stable
 */
export interface ILogSubscriptionDestination {
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope: CoreConstruct, sourceLogGroup: ILogGroup): LogSubscriptionDestinationConfig;
}
/**
 * Properties returned by a Subscription destination.
 *
 * @stability stable
 */
export interface LogSubscriptionDestinationConfig {
    /**
     * The ARN of the subscription's destination.
     *
     * @stability stable
     */
    readonly arn: string;
    /**
     * The role to assume to write log events to the destination.
     *
     * @default No role assumed
     * @stability stable
     */
    readonly role?: iam.IRole;
}
/**
 * Properties for a SubscriptionFilter.
 *
 * @stability stable
 */
export interface SubscriptionFilterProps extends SubscriptionFilterOptions {
    /**
     * The log group to create the subscription on.
     *
     * @stability stable
     */
    readonly logGroup: ILogGroup;
}
/**
 * A new Subscription on a CloudWatch log group.
 *
 * @stability stable
 */
export declare class SubscriptionFilter extends Resource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SubscriptionFilterProps);
}
