"""Tabulated data about the elements."""

# From https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020
# With missing masses from WebElements
element_data = {
    "H": {
        "atomic number": 1,
        "atomic symbol": "H",
        "element": "hydrogen",
        "atomic weight": 1.008,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "He": {
        "atomic number": 2,
        "atomic symbol": "He",
        "element": "helium",
        "atomic weight": 4.0026,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Li": {
        "atomic number": 3,
        "atomic symbol": "Li",
        "element": "lithium",
        "atomic weight": 6.967499999999999,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Be": {
        "atomic number": 4,
        "atomic symbol": "Be",
        "element": "beryllium",
        "atomic weight": 9.0122,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "B": {
        "atomic number": 5,
        "atomic symbol": "B",
        "element": "boron",
        "atomic weight": 10.8135,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "C": {
        "atomic number": 6,
        "atomic symbol": "C",
        "element": "carbon",
        "atomic weight": 12.0105,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "N": {
        "atomic number": 7,
        "atomic symbol": "N",
        "element": "nitrogen",
        "atomic weight": 14.007,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "O": {
        "atomic number": 8,
        "atomic symbol": "O",
        "element": "oxygen",
        "atomic weight": 15.999500000000001,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "F": {
        "atomic number": 9,
        "atomic symbol": "F",
        "element": "fluorine",
        "atomic weight": 18.998,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ne": {
        "atomic number": 10,
        "atomic symbol": "Ne",
        "element": "neon",
        "atomic weight": 20.18,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Na": {
        "atomic number": 11,
        "atomic symbol": "Na",
        "element": "sodium",
        "atomic weight": 22.99,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Mg": {
        "atomic number": 12,
        "atomic symbol": "Mg",
        "element": "magnesium",
        "atomic weight": 24.3055,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Al": {
        "atomic number": 13,
        "atomic symbol": "Al",
        "element": "aluminium",
        "atomic weight": 26.982,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Si": {
        "atomic number": 14,
        "atomic symbol": "Si",
        "element": "silicon",
        "atomic weight": 28.085,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "P": {
        "atomic number": 15,
        "atomic symbol": "P",
        "element": "phosphorus",
        "atomic weight": 30.974,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "S": {
        "atomic number": 16,
        "atomic symbol": "S",
        "element": "sulfur",
        "atomic weight": 32.067499999999995,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Cl": {
        "atomic number": 17,
        "atomic symbol": "Cl",
        "element": "chlorine",
        "atomic weight": 35.451499999999996,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ar": {
        "atomic number": 18,
        "atomic symbol": "Ar",
        "element": "argon",
        "atomic weight": 39.8775,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "K": {
        "atomic number": 19,
        "atomic symbol": "K",
        "element": "potassium",
        "atomic weight": 39.098,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ca": {
        "atomic number": 20,
        "atomic symbol": "Ca",
        "element": "calcium",
        "atomic weight": 40.078,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Sc": {
        "atomic number": 21,
        "atomic symbol": "Sc",
        "element": "scandium",
        "atomic weight": 44.956,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ti": {
        "atomic number": 22,
        "atomic symbol": "Ti",
        "element": "titanium",
        "atomic weight": 47.867,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "V": {
        "atomic number": 23,
        "atomic symbol": "V",
        "element": "vanadium",
        "atomic weight": 50.942,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Cr": {
        "atomic number": 24,
        "atomic symbol": "Cr",
        "element": "chromium",
        "atomic weight": 51.996,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Mn": {
        "atomic number": 25,
        "atomic symbol": "Mn",
        "element": "manganese",
        "atomic weight": 54.938,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Fe": {
        "atomic number": 26,
        "atomic symbol": "Fe",
        "element": "iron",
        "atomic weight": 55.845,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Co": {
        "atomic number": 27,
        "atomic symbol": "Co",
        "element": "cobalt",
        "atomic weight": 58.933,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ni": {
        "atomic number": 28,
        "atomic symbol": "Ni",
        "element": "nickel",
        "atomic weight": 58.693,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Cu": {
        "atomic number": 29,
        "atomic symbol": "Cu",
        "element": "copper",
        "atomic weight": 63.546,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Zn": {
        "atomic number": 30,
        "atomic symbol": "Zn",
        "element": "zinc",
        "atomic weight": 65.38,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ga": {
        "atomic number": 31,
        "atomic symbol": "Ga",
        "element": "gallium",
        "atomic weight": 69.723,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ge": {
        "atomic number": 32,
        "atomic symbol": "Ge",
        "element": "germanium",
        "atomic weight": 72.63,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "As": {
        "atomic number": 33,
        "atomic symbol": "As",
        "element": "arsenic",
        "atomic weight": 74.922,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Se": {
        "atomic number": 34,
        "atomic symbol": "Se",
        "element": "selenium",
        "atomic weight": 78.971,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Br": {
        "atomic number": 35,
        "atomic symbol": "Br",
        "element": "bromine",
        "atomic weight": 79.904,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Kr": {
        "atomic number": 36,
        "atomic symbol": "Kr",
        "element": "krypton",
        "atomic weight": 83.798,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Rb": {
        "atomic number": 37,
        "atomic symbol": "Rb",
        "element": "rubidium",
        "atomic weight": 85.468,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Sr": {
        "atomic number": 38,
        "atomic symbol": "Sr",
        "element": "strontium",
        "atomic weight": 87.62,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Y": {
        "atomic number": 39,
        "atomic symbol": "Y",
        "element": "yttrium",
        "atomic weight": 88.906,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Zr": {
        "atomic number": 40,
        "atomic symbol": "Zr",
        "element": "zirconium",
        "atomic weight": 91.224,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Nb": {
        "atomic number": 41,
        "atomic symbol": "Nb",
        "element": "niobium",
        "atomic weight": 92.906,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Mo": {
        "atomic number": 42,
        "atomic symbol": "Mo",
        "element": "molybdenum",
        "atomic weight": 95.95,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Tc": {
        "atomic number": 43,
        "atomic symbol": "Tc",
        "element": "technetium",
        "atomic weight": 96.906,
        "source": "webelements  30 July 2020"
    },
    "Ru": {
        "atomic number": 44,
        "atomic symbol": "Ru",
        "element": "ruthenium",
        "atomic weight": 101.07,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Rh": {
        "atomic number": 45,
        "atomic symbol": "Rh",
        "element": "rhodium",
        "atomic weight": 102.91,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pd": {
        "atomic number": 46,
        "atomic symbol": "Pd",
        "element": "palladium",
        "atomic weight": 106.42,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ag": {
        "atomic number": 47,
        "atomic symbol": "Ag",
        "element": "silver",
        "atomic weight": 107.87,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Cd": {
        "atomic number": 48,
        "atomic symbol": "Cd",
        "element": "cadmium",
        "atomic weight": 112.41,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "In": {
        "atomic number": 49,
        "atomic symbol": "In",
        "element": "indium",
        "atomic weight": 114.82,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Sn": {
        "atomic number": 50,
        "atomic symbol": "Sn",
        "element": "tin",
        "atomic weight": 118.71,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Sb": {
        "atomic number": 51,
        "atomic symbol": "Sb",
        "element": "antimony",
        "atomic weight": 121.76,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Te": {
        "atomic number": 52,
        "atomic symbol": "Te",
        "element": "tellurium",
        "atomic weight": 127.6,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "I": {
        "atomic number": 53,
        "atomic symbol": "I",
        "element": "iodine",
        "atomic weight": 126.9,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Xe": {
        "atomic number": 54,
        "atomic symbol": "Xe",
        "element": "xenon",
        "atomic weight": 131.29,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Cs": {
        "atomic number": 55,
        "atomic symbol": "Cs",
        "element": "caesium",
        "atomic weight": 132.91,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ba": {
        "atomic number": 56,
        "atomic symbol": "Ba",
        "element": "barium",
        "atomic weight": 137.33,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "La": {
        "atomic number": 57,
        "atomic symbol": "La",
        "element": "lanthanum",
        "atomic weight": 138.91,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ce": {
        "atomic number": 58,
        "atomic symbol": "Ce",
        "element": "cerium",
        "atomic weight": 140.12,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pr": {
        "atomic number": 59,
        "atomic symbol": "Pr",
        "element": "praseodymium",
        "atomic weight": 140.91,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Nd": {
        "atomic number": 60,
        "atomic symbol": "Nd",
        "element": "neodymium",
        "atomic weight": 144.24,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pm": {
        "atomic number": 61,
        "atomic symbol": "Pm",
        "element": "promethium",
        "atomic weight": 144.91,
        "source": "webelements  30 July 2020"
    },
    "Sm": {
        "atomic number": 62,
        "atomic symbol": "Sm",
        "element": "samarium",
        "atomic weight": 150.36,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Eu": {
        "atomic number": 63,
        "atomic symbol": "Eu",
        "element": "europium",
        "atomic weight": 151.96,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Gd": {
        "atomic number": 64,
        "atomic symbol": "Gd",
        "element": "gadolinium",
        "atomic weight": 157.25,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Tb": {
        "atomic number": 65,
        "atomic symbol": "Tb",
        "element": "terbium",
        "atomic weight": 158.93,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Dy": {
        "atomic number": 66,
        "atomic symbol": "Dy",
        "element": "dysprosium",
        "atomic weight": 162.5,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ho": {
        "atomic number": 67,
        "atomic symbol": "Ho",
        "element": "holmium",
        "atomic weight": 164.93,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Er": {
        "atomic number": 68,
        "atomic symbol": "Er",
        "element": "erbium",
        "atomic weight": 167.26,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Tm": {
        "atomic number": 69,
        "atomic symbol": "Tm",
        "element": "thulium",
        "atomic weight": 168.93,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Yb": {
        "atomic number": 70,
        "atomic symbol": "Yb",
        "element": "ytterbium",
        "atomic weight": 173.05,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Lu": {
        "atomic number": 71,
        "atomic symbol": "Lu",
        "element": "lutetium",
        "atomic weight": 174.97,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Hf": {
        "atomic number": 72,
        "atomic symbol": "Hf",
        "element": "hafnium",
        "atomic weight": 178.49,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ta": {
        "atomic number": 73,
        "atomic symbol": "Ta",
        "element": "tantalum",
        "atomic weight": 180.95,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "W": {
        "atomic number": 74,
        "atomic symbol": "W",
        "element": "tungsten",
        "atomic weight": 183.84,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Re": {
        "atomic number": 75,
        "atomic symbol": "Re",
        "element": "rhenium",
        "atomic weight": 186.21,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Os": {
        "atomic number": 76,
        "atomic symbol": "Os",
        "element": "osmium",
        "atomic weight": 190.23,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Ir": {
        "atomic number": 77,
        "atomic symbol": "Ir",
        "element": "iridium",
        "atomic weight": 192.22,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pt": {
        "atomic number": 78,
        "atomic symbol": "Pt",
        "element": "platinum",
        "atomic weight": 195.08,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Au": {
        "atomic number": 79,
        "atomic symbol": "Au",
        "element": "gold",
        "atomic weight": 196.97,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Hg": {
        "atomic number": 80,
        "atomic symbol": "Hg",
        "element": "mercury",
        "atomic weight": 200.59,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Tl": {
        "atomic number": 81,
        "atomic symbol": "Tl",
        "element": "thallium",
        "atomic weight": 204.385,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pb": {
        "atomic number": 82,
        "atomic symbol": "Pb",
        "element": "lead",
        "atomic weight": 207.2,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Bi": {
        "atomic number": 83,
        "atomic symbol": "Bi",
        "element": "bismuth",
        "atomic weight": 208.98,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Po": {
        "atomic number": 84,
        "atomic symbol": "Po",
        "element": "polonium",
        "atomic weight": 208.98,
        "source": "webelements  30 July 2020"
    },
    "At": {
        "atomic number": 85,
        "atomic symbol": "At",
        "element": "astatine",
        "atomic weight": 209.99,
        "source": "webelements  30 July 2020"
    },
    "Rn": {
        "atomic number": 86,
        "atomic symbol": "Rn",
        "element": "radon",
        "atomic weight": 222.02,
        "source": "webelements  30 July 2020"
    },
    "Fr": {
        "atomic number": 87,
        "atomic symbol": "Fr",
        "element": "francium",
        "atomic weight": 223.02,
        "source": "webelements  30 July 2020"
    },
    "Ra": {
        "atomic number": 88,
        "atomic symbol": "Ra",
        "element": "radium",
        "atomic weight": 226.03,
        "source": "webelements  30 July 2020"
    },
    "Ac": {
        "atomic number": 89,
        "atomic symbol": "Ac",
        "element": "actinium",
        "atomic weight": 227.03,
        "source": "webelements  30 July 2020"
    },
    "Th": {
        "atomic number": 90,
        "atomic symbol": "Th",
        "element": "thorium",
        "atomic weight": 232.04,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Pa": {
        "atomic number": 91,
        "atomic symbol": "Pa",
        "element": "protactinium",
        "atomic weight": 231.04,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "U": {
        "atomic number": 92,
        "atomic symbol": "U",
        "element": "uranium",
        "atomic weight": 238.03,
        "source": "https://ciaaw.org/abridged-atomic-weights.htm  30 July 2020"
    },
    "Np": {
        "atomic number": 93,
        "atomic symbol": "Np",
        "element": "neptunium",
        "atomic weight": 237.05,
        "source": "webelements  30 July 2020"
    },
    "Pu": {
        "atomic number": 94,
        "atomic symbol": "Pu",
        "element": "plutonium",
        "atomic weight": 244.06,
        "source": "webelements  30 July 2020"
    },
    "Am": {
        "atomic number": 95,
        "atomic symbol": "Am",
        "element": "americium",
        "atomic weight": 243.06,
        "source": "webelements  30 July 2020"
    },
    "Cm": {
        "atomic number": 96,
        "atomic symbol": "Cm",
        "element": "curium",
        "atomic weight": 247.07,
        "source": "webelements  30 July 2020"
    },
    "Bk": {
        "atomic number": 97,
        "atomic symbol": "Bk",
        "element": "berkelium",
        "atomic weight": 247.07,
        "source": "webelements  30 July 2020"
    },
    "Cf": {
        "atomic number": 98,
        "atomic symbol": "Cf",
        "element": "californium",
        "atomic weight": 251.08,
        "source": "webelements  30 July 2020"
    },
    "Es": {
        "atomic number": 99,
        "atomic symbol": "Es",
        "element": "einsteinium",
        "atomic weight": 252.08,
        "source": "webelements  30 July 2020"
    },
    "Fm": {
        "atomic number": 100,
        "atomic symbol": "Fm",
        "element": "fermium",
        "atomic weight": 257.10,
        "source": "webelements  30 July 2020"
    },
    "Md": {
        "atomic number": 101,
        "atomic symbol": "Md",
        "element": "mendelevium",
        "atomic weight": 258.10,
        "source": "webelements  30 July 2020"
    },
    "No": {
        "atomic number": 102,
        "atomic symbol": "No",
        "element": "nobelium",
        "atomic weight": 259.10,
        "source": "webelements  30 July 2020"
    },
    "Lr": {
        "atomic number": 103,
        "atomic symbol": "Lr",
        "element": "lawrencium",
        "atomic weight": 262.11,
        "source": "webelements  30 July 2020"
    },
    "Rf": {
        "atomic number": 104,
        "atomic symbol": "Rf",
        "element": "rutherfordium",
        "atomic weight": 267.12,
        "source": "webelements  30 July 2020"
    },
    "Db": {
        "atomic number": 105,
        "atomic symbol": "Db",
        "element": "dubnium",
        "atomic weight": 270.13,
        "source": "webelements  30 July 2020"
    },
    "Sg": {
        "atomic number": 106,
        "atomic symbol": "Sg",
        "element": "seaborgium",
        "atomic weight": 269.13,
        "source": "webelements  30 July 2020"
    },
    "Bh": {
        "atomic number": 107,
        "atomic symbol": "Bh",
        "element": "bohrium",
        "atomic weight": 270.13,
        "source": "webelements  30 July 2020"
    },
    "Hs": {
        "atomic number": 108,
        "atomic symbol": "Hs",
        "element": "hassium",
        "atomic weight": 269.13,
        "source": "webelements  30 July 2020"
    },
    "Mt": {
        "atomic number": 109,
        "atomic symbol": "Mt",
        "element": "meitnerium",
        "atomic weight": 278.16,
        "source": "webelements  30 July 2020"
    },
    "Ds": {
        "atomic number": 110,
        "atomic symbol": "Ds",
        "element": "darmstadtium",
        "atomic weight": 281.17,
        "source": "webelements  30 July 2020"
    },
    "Rg": {
        "atomic number": 111,
        "atomic symbol": "Rg",
        "element": "roentgenium",
        "atomic weight": 281.17,
        "source": "webelements  30 July 2020"
    },
    "Cn": {
        "atomic number": 112,
        "atomic symbol": "Cn",
        "element": "copernicium",
        "atomic weight": 285.18,
        "source": "webelements  30 July 2020"
    },
    "Nh": {
        "atomic number": 113,
        "atomic symbol": "Nh",
        "element": "nihonium",
        "atomic weight": 286.18,
        "source": "webelements  30 July 2020"
    },
    "Fl": {
        "atomic number": 114,
        "atomic symbol": "Fl",
        "element": "flerovium",
        "atomic weight": 289.19,
        "source": "webelements  30 July 2020"
    },
    "Mc": {
        "atomic number": 115,
        "atomic symbol": "Mc",
        "element": "moscovium",
        "atomic weight": 289.20,
        "source": "webelements  30 July 2020"
    },
    "Lv": {
        "atomic number": 116,
        "atomic symbol": "Lv",
        "element": "livermorium",
        "atomic weight": 293.20,
        "source": "webelements  30 July 2020"
    },
    "Ts": {
        "atomic number": 117,
        "atomic symbol": "Ts",
        "element": "tennessine",
        "atomic weight": 293.21,
        "source": "webelements  30 July 2020"
    },
    "Og": {
        "atomic number": 118,
        "atomic symbol": "Og",
        "element": "oganesson",
        "atomic weight": 294.21,
        "source": "webelements  30 July 2020"
    }
}
