from datetime import datetime
from tinydb_serialization import Serializer


class DateTimeSerializer(Serializer):
    OBJ_CLASS = datetime  # The class this serializer handles

    def encode(self, obj):
        return obj.strftime('%Y-%m-%d %H:%M:%S')

    def decode(self, s):
        return datetime.strptime(s, '%Y-%m-%d %H:%M:%S')
