# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src',
 'src.data_pipeline',
 'src.data_pipeline.feature_engineering',
 'src.data_pipeline.pre_processing',
 'src.parser']

package_data = \
{'': ['*'], 'src': ['yamls/*']}

install_requires = \
['Jinja2==3.1.2',
 'MarkupSafe==2.1.1',
 'Pillow==9.4.0',
 'PyYAML==6.0',
 'altair==4.2.0',
 'attrs==22.2.0',
 'bpemb==0.3.4',
 'certifi==2022.12.7',
 'charset-normalizer==2.1.1',
 'contourpy==1.0.6',
 'coverage==7.0.2',
 'cycler==0.11.0',
 'entrypoints==0.4',
 'exceptiongroup==1.1.0',
 'fonttools==4.38.0',
 'gensim==3.8.3',
 'idna==3.4',
 'importlib-resources==5.10.2',
 'iniconfig==1.1.1',
 'joblib==1.2.0',
 'jsonschema==4.17.3',
 'kiwisolver==1.4.4',
 'matplotlib==3.6.2',
 'numpy==1.24.1',
 'packaging==22.0',
 'pandas==1.5.2',
 'pkgutil-resolve-name==1.3.10',
 'pluggy==1.0.0',
 'pyparsing==3.0.9',
 'pyrsistent==0.19.3',
 'pytest-cov==4.0.0',
 'pytest==7.2.0',
 'python-dateutil==2.8.2',
 'pytz==2022.7',
 'requests==2.28.1',
 'scikit-learn==1.2.0',
 'scipy==1.9.3',
 'sentencepiece==0.1.97',
 'six==1.16.0',
 'smart-open==6.3.0',
 'threadpoolctl==3.1.0',
 'tomli==2.0.1',
 'toolz==0.12.0',
 'tqdm==4.64.1',
 'urllib3==1.26.13',
 'whatlies==0.7.0',
 'zipp==3.11.0']

setup_kwargs = {
    'name': 'trabalho-de-gces',
    'version': '0.1.4',
    'description': '',
    'long_description': "# Trabalho GCES\nAluno: Antonio Igor Carvalho\nMatrícula: 180030264\n\n## Containerização do Banco\nO banco foi containerizado utilizando a imagem oficial do postgres\n![BancoDocker](./prints/banco_docker.png)\n\n## Containerização da biblioteca + Banco\nA biblioteca foi containerizada com uma imagem criada por mim, e o container do app, banco e metabase utilizando o docker-compose\n![BancoAppDocker](./prints/banco_app_docker.png)\n\n## Publicação da biblioteca\nA publicação da biblioteca foi feita no pypi, utilizando o poetry\n![Pypi](./prints/pypi.png)\nhttps://pypi.org/project/trabalho-de-gces/\n\n## Documentação automatizada\nA documentação é atualizada juntamente com a build da imagem\n![Documentação](./prints/documentacao.png)\n\n## Integração contínua\nA build, atualização da documentação e teste são feitos quando ocorre a publicação de um novo commit\n![CI](./prints/ci.png)\n## Deploy contínuo\nA publicação da biblioteca é feita automaticamente quando a varivável de ambiente 'current_version' é atualizada\n![Pypi](./prints/pypi.png)\n",
    'author': 'Antonio Igor Carvalho',
    'author_email': 'antonioigorcarvalho@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.16,<4.0.0',
}


setup(**setup_kwargs)
