"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloudshell = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Cloudshell extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'cloudshell';
        this.accessLevelList = {
            Write: [
                'CreateEnvironment',
                'CreateSession',
                'DeleteEnvironment',
                'GetFileDownloadUrls',
                'GetFileUploadUrls',
                'PutCredentials',
                'StartEnvironment',
                'StopEnvironment'
            ],
            Read: [
                'GetEnvironmentStatus'
            ]
        };
    }
    /**
     * Grants permissions to create a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateEnvironment
     */
    toCreateEnvironment() {
        return this.to('CreateEnvironment');
    }
    /**
     * Grants permissions to connect to a CloudShell environment from the AWS Management Console
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateSession
     */
    toCreateSession() {
        return this.to('CreateSession');
    }
    /**
     * Grants permission to delete a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#DeleteEnvironment
     */
    toDeleteEnvironment() {
        return this.to('DeleteEnvironment');
    }
    /**
     * Grants permission to read a CloudShell environment status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetEnvironmentStatus
     */
    toGetEnvironmentStatus() {
        return this.to('GetEnvironmentStatus');
    }
    /**
     * Grants permissions to download files from a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileDownloadUrls
     */
    toGetFileDownloadUrls() {
        return this.to('GetFileDownloadUrls');
    }
    /**
     * Grants permissions to upload files to a CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileUploadUrls
     */
    toGetFileUploadUrls() {
        return this.to('GetFileUploadUrls');
    }
    /**
     * Grants permissions to forward console credentials to the environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#PutCredentials
     */
    toPutCredentials() {
        return this.to('PutCredentials');
    }
    /**
     * Grants permission to start a stopped CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StartEnvironment
     */
    toStartEnvironment() {
        return this.to('StartEnvironment');
    }
    /**
     * Grants permission to stop a running CloudShell environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StopEnvironment
     */
    toStopEnvironment() {
        return this.to('StopEnvironment');
    }
    /**
     * Adds a resource of type Environment to the statement
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#Environment
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEnvironment(environmentId, account, region, partition) {
        return this.on(`arn:${partition || Cloudshell.defaultPartition}:cloudshell:${region || '*'}:${account || '*'}:environment/${environmentId}`);
    }
}
exports.Cloudshell = Cloudshell;
_a = JSII_RTTI_SYMBOL_1;
Cloudshell[_a] = { fqn: "iam-floyd.Cloudshell", version: "0.398.0" };
//# sourceMappingURL=data:application/json;base64,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