"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Timestream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [timestream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestream.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Timestream extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [timestream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontimestream.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'timestream';
        this.accessLevelList = {
            Write: [
                'CancelQuery',
                'CreateDatabase',
                'CreateScheduledQuery',
                'CreateTable',
                'DeleteDatabase',
                'DeleteScheduledQuery',
                'DeleteTable',
                'ExecuteScheduledQuery',
                'UpdateDatabase',
                'UpdateScheduledQuery',
                'UpdateTable',
                'WriteRecords'
            ],
            Read: [
                'DescribeDatabase',
                'DescribeScheduledQuery',
                'DescribeTable',
                'ListTagsForResource',
                'PrepareQuery',
                'Select',
                'SelectValues'
            ],
            List: [
                'DescribeEndpoints',
                'ListDatabases',
                'ListMeasures',
                'ListScheduledQueries',
                'ListTables'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to cancel queries in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_CancelQuery.html
     */
    toCancelQuery() {
        return this.to('CancelQuery');
    }
    /**
     * Grants permission to create a database in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_CreateDatabase.html
     */
    toCreateDatabase() {
        return this.to('CreateDatabase');
    }
    /**
     * Grants permission to create a scheduled query in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_CreateScheduledQuery.html
     */
    toCreateScheduledQuery() {
        return this.to('CreateScheduledQuery');
    }
    /**
     * Grants permission to create a table in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_CreateTable.html
     */
    toCreateTable() {
        return this.to('CreateTable');
    }
    /**
     * Grants permission to delete a database in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DeleteDatabase.html
     */
    toDeleteDatabase() {
        return this.to('DeleteDatabase');
    }
    /**
     * Grants permission to delete a scheduled query in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DeleteScheduledQuery.html
     */
    toDeleteScheduledQuery() {
        return this.to('DeleteScheduledQuery');
    }
    /**
     * Grants permission to delete a table in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DeleteTable.html
     */
    toDeleteTable() {
        return this.to('DeleteTable');
    }
    /**
     * Grants permission to describe a database in your account
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeDatabase.html
     */
    toDescribeDatabase() {
        return this.to('DescribeDatabase');
    }
    /**
     * Grants permission to describe timestream endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeEndpoints.html
     */
    toDescribeEndpoints() {
        return this.to('DescribeEndpoints');
    }
    /**
     * Grants permission to describe a scheduled query in your account
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeScheduledQuery.html
     */
    toDescribeScheduledQuery() {
        return this.to('DescribeScheduledQuery');
    }
    /**
     * Grants permission to describe a table in your account
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_DescribeTable.html
     */
    toDescribeTable() {
        return this.to('DescribeTable');
    }
    /**
     * Grants permission to execute a scheduled query in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ExecuteScheduledQuery.html
     */
    toExecuteScheduledQuery() {
        return this.to('ExecuteScheduledQuery');
    }
    /**
     * Grants permission to list databases in your account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListDatabases.html
     */
    toListDatabases() {
        return this.to('ListDatabases');
    }
    /**
     * Grants permission to list measures of a table in your account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toListMeasures() {
        return this.to('ListMeasures');
    }
    /**
     * Grants permission to list scheduled queries in your account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListScheduledQueries.html
     */
    toListScheduledQueries() {
        return this.to('ListScheduledQueries');
    }
    /**
     * Grants permission to list tables in your account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListTables.html
     */
    toListTables() {
        return this.to('ListTables');
    }
    /**
     * Grants permission to list tags of a resource in your account
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to issue prepare queries
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     * - timestream:Select
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_PrepareQuery.html
     */
    toPrepareQuery() {
        return this.to('PrepareQuery');
    }
    /**
     * Grants permission to issue 'select from table' queries
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toSelect() {
        return this.to('Select');
    }
    /**
     * Grants permission to issue 'select 1' queries
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_query_Query.html
     */
    toSelectValues() {
        return this.to('SelectValues');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a database in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UpdateDatabase.html
     */
    toUpdateDatabase() {
        return this.to('UpdateDatabase');
    }
    /**
     * Grants permission to update a scheduled query in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UpdateScheduledQuery.html
     */
    toUpdateScheduledQuery() {
        return this.to('UpdateScheduledQuery');
    }
    /**
     * Grants permission to update a table in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_UpdateTable.html
     */
    toUpdateTable() {
        return this.to('UpdateTable');
    }
    /**
     * Grants permission to ingest data to a table in your account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - timestream:DescribeEndpoints
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_WriteRecords.html
     */
    toWriteRecords() {
        return this.to('WriteRecords');
    }
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_Database.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatabase(databaseName, account, region, partition) {
        return this.on(`arn:${partition || Timestream.defaultPartition}:timestream:${region || '*'}:${account || '*'}:database/${databaseName}`);
    }
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_Table.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTable(databaseName, tableName, account, region, partition) {
        return this.on(`arn:${partition || Timestream.defaultPartition}:timestream:${region || '*'}:${account || '*'}:database/${databaseName}/table/${tableName}`);
    }
    /**
     * Adds a resource of type scheduled-query to the statement
     *
     * https://docs.aws.amazon.com/timestream/latest/developerguide/API_ScheduledQuery.html
     *
     * @param scheduledQueryName - Identifier for the scheduledQueryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScheduledQuery(scheduledQueryName, account, region, partition) {
        return this.on(`arn:${partition || Timestream.defaultPartition}:timestream:${region || '*'}:${account || '*'}:scheduled-query/${scheduledQueryName}`);
    }
}
exports.Timestream = Timestream;
_a = JSII_RTTI_SYMBOL_1;
Timestream[_a] = { fqn: "iam-floyd.Timestream", version: "0.398.0" };
//# sourceMappingURL=data:application/json;base64,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