/**
 * ListenerCondition providers definition.
 *
 * @stability stable
 */
export declare abstract class ListenerCondition {
    /**
     * Create a host-header listener rule condition.
     *
     * @param values Hosts for host headers.
     * @stability stable
     */
    static hostHeaders(values: string[]): ListenerCondition;
    /**
     * Create a http-header listener rule condition.
     *
     * @param name HTTP header name.
     * @param values HTTP header values.
     * @stability stable
     */
    static httpHeader(name: string, values: string[]): ListenerCondition;
    /**
     * Create a http-request-method listener rule condition.
     *
     * @param values HTTP request methods.
     * @stability stable
     */
    static httpRequestMethods(values: string[]): ListenerCondition;
    /**
     * Create a path-pattern listener rule condition.
     *
     * @param values Path patterns.
     * @stability stable
     */
    static pathPatterns(values: string[]): ListenerCondition;
    /**
     * Create a query-string listener rule condition.
     *
     * @param values Query string key/value pairs.
     * @stability stable
     */
    static queryStrings(values: QueryStringCondition[]): ListenerCondition;
    /**
     * Create a source-ip listener rule condition.
     *
     * @param values Source ips.
     * @stability stable
     */
    static sourceIps(values: string[]): ListenerCondition;
    /**
     * Render the raw Cfn listener rule condition object.
     *
     * @stability stable
     */
    abstract renderRawCondition(): any;
}
/**
 * Properties for the key/value pair of the query string.
 *
 * @stability stable
 */
export interface QueryStringCondition {
    /**
     * The query string key for the condition.
     *
     * @default - Any key can be matched.
     * @stability stable
     */
    readonly key?: string;
    /**
     * The query string value for the condition.
     *
     * @stability stable
     */
    readonly value: string;
}
