import * as acm from '@aws-cdk/aws-certificatemanager';
/**
 * A certificate source for an ELBv2 listener.
 *
 * @stability stable
 */
export interface IListenerCertificate {
    /**
     * The ARN of the certificate to use.
     *
     * @stability stable
     */
    readonly certificateArn: string;
}
/**
 * A certificate source for an ELBv2 listener.
 *
 * @stability stable
 */
export declare class ListenerCertificate implements IListenerCertificate {
    /**
     * Use an ACM certificate as a listener certificate.
     *
     * @stability stable
     */
    static fromCertificateManager(acmCertificate: acm.ICertificate): ListenerCertificate;
    /**
     * Use any certificate, identified by its ARN, as a listener certificate.
     *
     * @stability stable
     */
    static fromArn(certificateArn: string): ListenerCertificate;
    /**
     * The ARN of the certificate to use.
     *
     * @stability stable
     */
    readonly certificateArn: string;
    /**
     * @stability stable
     */
    protected constructor(certificateArn: string);
}
