# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class DeliveryStatusDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'sent_id': 'str',
        'remote_mta_ip': 'str',
        'inbox_id': 'str',
        'reporting_mta': 'str',
        'recipients': 'list[str]',
        'smtp_response': 'str',
        'smtp_status_code': 'int',
        'processing_time_millis': 'int',
        'received': 'datetime',
        'subject': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'sent_id': 'sentId',
        'remote_mta_ip': 'remoteMtaIp',
        'inbox_id': 'inboxId',
        'reporting_mta': 'reportingMta',
        'recipients': 'recipients',
        'smtp_response': 'smtpResponse',
        'smtp_status_code': 'smtpStatusCode',
        'processing_time_millis': 'processingTimeMillis',
        'received': 'received',
        'subject': 'subject',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, user_id=None, sent_id=None, remote_mta_ip=None, inbox_id=None, reporting_mta=None, recipients=None, smtp_response=None, smtp_status_code=None, processing_time_millis=None, received=None, subject=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """DeliveryStatusDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._sent_id = None
        self._remote_mta_ip = None
        self._inbox_id = None
        self._reporting_mta = None
        self._recipients = None
        self._smtp_response = None
        self._smtp_status_code = None
        self._processing_time_millis = None
        self._received = None
        self._subject = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        self.user_id = user_id
        if sent_id is not None:
            self.sent_id = sent_id
        if remote_mta_ip is not None:
            self.remote_mta_ip = remote_mta_ip
        if inbox_id is not None:
            self.inbox_id = inbox_id
        if reporting_mta is not None:
            self.reporting_mta = reporting_mta
        if recipients is not None:
            self.recipients = recipients
        if smtp_response is not None:
            self.smtp_response = smtp_response
        if smtp_status_code is not None:
            self.smtp_status_code = smtp_status_code
        if processing_time_millis is not None:
            self.processing_time_millis = processing_time_millis
        if received is not None:
            self.received = received
        if subject is not None:
            self.subject = subject
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this DeliveryStatusDto.  # noqa: E501


        :return: The id of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeliveryStatusDto.


        :param id: The id of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this DeliveryStatusDto.  # noqa: E501


        :return: The user_id of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this DeliveryStatusDto.


        :param user_id: The user_id of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def sent_id(self):
        """Gets the sent_id of this DeliveryStatusDto.  # noqa: E501


        :return: The sent_id of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._sent_id

    @sent_id.setter
    def sent_id(self, sent_id):
        """Sets the sent_id of this DeliveryStatusDto.


        :param sent_id: The sent_id of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._sent_id = sent_id

    @property
    def remote_mta_ip(self):
        """Gets the remote_mta_ip of this DeliveryStatusDto.  # noqa: E501


        :return: The remote_mta_ip of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._remote_mta_ip

    @remote_mta_ip.setter
    def remote_mta_ip(self, remote_mta_ip):
        """Sets the remote_mta_ip of this DeliveryStatusDto.


        :param remote_mta_ip: The remote_mta_ip of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._remote_mta_ip = remote_mta_ip

    @property
    def inbox_id(self):
        """Gets the inbox_id of this DeliveryStatusDto.  # noqa: E501


        :return: The inbox_id of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._inbox_id

    @inbox_id.setter
    def inbox_id(self, inbox_id):
        """Sets the inbox_id of this DeliveryStatusDto.


        :param inbox_id: The inbox_id of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._inbox_id = inbox_id

    @property
    def reporting_mta(self):
        """Gets the reporting_mta of this DeliveryStatusDto.  # noqa: E501


        :return: The reporting_mta of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._reporting_mta

    @reporting_mta.setter
    def reporting_mta(self, reporting_mta):
        """Sets the reporting_mta of this DeliveryStatusDto.


        :param reporting_mta: The reporting_mta of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._reporting_mta = reporting_mta

    @property
    def recipients(self):
        """Gets the recipients of this DeliveryStatusDto.  # noqa: E501


        :return: The recipients of this DeliveryStatusDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """Sets the recipients of this DeliveryStatusDto.


        :param recipients: The recipients of this DeliveryStatusDto.  # noqa: E501
        :type: list[str]
        """

        self._recipients = recipients

    @property
    def smtp_response(self):
        """Gets the smtp_response of this DeliveryStatusDto.  # noqa: E501


        :return: The smtp_response of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._smtp_response

    @smtp_response.setter
    def smtp_response(self, smtp_response):
        """Sets the smtp_response of this DeliveryStatusDto.


        :param smtp_response: The smtp_response of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._smtp_response = smtp_response

    @property
    def smtp_status_code(self):
        """Gets the smtp_status_code of this DeliveryStatusDto.  # noqa: E501


        :return: The smtp_status_code of this DeliveryStatusDto.  # noqa: E501
        :rtype: int
        """
        return self._smtp_status_code

    @smtp_status_code.setter
    def smtp_status_code(self, smtp_status_code):
        """Sets the smtp_status_code of this DeliveryStatusDto.


        :param smtp_status_code: The smtp_status_code of this DeliveryStatusDto.  # noqa: E501
        :type: int
        """

        self._smtp_status_code = smtp_status_code

    @property
    def processing_time_millis(self):
        """Gets the processing_time_millis of this DeliveryStatusDto.  # noqa: E501


        :return: The processing_time_millis of this DeliveryStatusDto.  # noqa: E501
        :rtype: int
        """
        return self._processing_time_millis

    @processing_time_millis.setter
    def processing_time_millis(self, processing_time_millis):
        """Sets the processing_time_millis of this DeliveryStatusDto.


        :param processing_time_millis: The processing_time_millis of this DeliveryStatusDto.  # noqa: E501
        :type: int
        """

        self._processing_time_millis = processing_time_millis

    @property
    def received(self):
        """Gets the received of this DeliveryStatusDto.  # noqa: E501


        :return: The received of this DeliveryStatusDto.  # noqa: E501
        :rtype: datetime
        """
        return self._received

    @received.setter
    def received(self, received):
        """Sets the received of this DeliveryStatusDto.


        :param received: The received of this DeliveryStatusDto.  # noqa: E501
        :type: datetime
        """

        self._received = received

    @property
    def subject(self):
        """Gets the subject of this DeliveryStatusDto.  # noqa: E501


        :return: The subject of this DeliveryStatusDto.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this DeliveryStatusDto.


        :param subject: The subject of this DeliveryStatusDto.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def created_at(self):
        """Gets the created_at of this DeliveryStatusDto.  # noqa: E501


        :return: The created_at of this DeliveryStatusDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this DeliveryStatusDto.


        :param created_at: The created_at of this DeliveryStatusDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this DeliveryStatusDto.  # noqa: E501


        :return: The updated_at of this DeliveryStatusDto.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this DeliveryStatusDto.


        :param updated_at: The updated_at of this DeliveryStatusDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeliveryStatusDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeliveryStatusDto):
            return True

        return self.to_dict() != other.to_dict()
