

import flatbuffers

class FaceAnimation(object):
    __slots__ = ['_tab']

    @classmethod
    def GetRootAsFaceAnimation(cls, buf, offset):
        n = flatbuffers.encode.Get(flatbuffers.packer.uoffset, buf, offset)
        x = FaceAnimation()
        x.Init(buf, n + offset)
        return x

    # FaceAnimation
    def Init(self, buf, pos):
        self._tab = flatbuffers.table.Table(buf, pos)

    # FaceAnimation
    def TriggerTimeMs(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(4))
        if o != 0:
            return self._tab.Get(flatbuffers.number_types.Uint32Flags, o + self._tab.Pos)
        return 0

    # FaceAnimation
    def AnimName(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        if o != 0:
            return self._tab.String(o + self._tab.Pos)
        return None

def FaceAnimationStart(builder): builder.StartObject(2)
def FaceAnimationAddTriggerTimeMs(builder, triggerTimeMs): builder.PrependUint32Slot(0, triggerTimeMs, 0)
def FaceAnimationAddAnimName(builder, animName): builder.PrependUOffsetTRelativeSlot(1, flatbuffers.number_types.UOffsetTFlags.py_type(animName), 0)
def FaceAnimationEnd(builder): return builder.EndObject()
