

import flatbuffers

class LiftHeight(object):
    __slots__ = ['_tab']

    @classmethod
    def GetRootAsLiftHeight(cls, buf, offset):
        n = flatbuffers.encode.Get(flatbuffers.packer.uoffset, buf, offset)
        x = LiftHeight()
        x.Init(buf, n + offset)
        return x

    # LiftHeight
    def Init(self, buf, pos):
        self._tab = flatbuffers.table.Table(buf, pos)

    # LiftHeight
    def TriggerTimeMs(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(4))
        if o != 0:
            return self._tab.Get(flatbuffers.number_types.Uint32Flags, o + self._tab.Pos)
        return 0

    # LiftHeight
    def DurationTimeMs(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        if o != 0:
            return self._tab.Get(flatbuffers.number_types.Uint32Flags, o + self._tab.Pos)
        return 0

    # LiftHeight
    def HeightMm(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(8))
        if o != 0:
            return self._tab.Get(flatbuffers.number_types.Uint8Flags, o + self._tab.Pos)
        return 0

    # LiftHeight
    def HeightVariabilityMm(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(10))
        if o != 0:
            return self._tab.Get(flatbuffers.number_types.Uint8Flags, o + self._tab.Pos)
        return 0

def LiftHeightStart(builder): builder.StartObject(4)
def LiftHeightAddTriggerTimeMs(builder, triggerTimeMs): builder.PrependUint32Slot(0, triggerTimeMs, 0)
def LiftHeightAddDurationTimeMs(builder, durationTimeMs): builder.PrependUint32Slot(1, durationTimeMs, 0)
def LiftHeightAddHeightMm(builder, heightMm): builder.PrependUint8Slot(2, heightMm, 0)
def LiftHeightAddHeightVariabilityMm(builder, heightVariabilityMm): builder.PrependUint8Slot(3, heightVariabilityMm, 0)
def LiftHeightEnd(builder): return builder.EndObject()
