import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SalesforceProviderConfig {
    /**
    * API version of the salesforce org in the format in the format: MAJOR.MINOR (please omit any leading 'v'). The provider requires at least version 53.0. Can be specified with the environment variable SALESFORCE_API_VERSION.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#api_version SalesforceProvider#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Client ID of the connected app. Corresponds to Consumer Key in the user interface. Can be specified with the environment variable SALESFORCE_CLIENT_ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#client_id SalesforceProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * Directs the authentication request, defaults to the production endpoint https://login.salesforce.com, should be set to https://test.salesforce.com for sandbox organizations. Can be specified with the environment variable SALESFORCE_LOGIN_URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#login_url SalesforceProvider#login_url}
    */
    readonly loginUrl?: string;
    /**
    * Private Key associated to the public certificate that was uploaded to the connected app. This may point to a file location or be set directly. This should not be confused with the Consumer Secret in the user interface. Can be specified with the environment variable SALESFORCE_PRIVATE_KEY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#private_key SalesforceProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * Salesforce Username of a System Administrator like user for the provider to authenticate as. Can be specified with the environment variable SALESFORCE_USERNAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#username SalesforceProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce#alias SalesforceProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce salesforce}
*/
export declare class SalesforceProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "salesforce";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce salesforce} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SalesforceProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SalesforceProviderConfig);
    private _apiVersion?;
    get apiVersion(): string | undefined;
    set apiVersion(value: string | undefined);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _loginUrl?;
    get loginUrl(): string | undefined;
    set loginUrl(value: string | undefined);
    resetLoginUrl(): void;
    get loginUrlInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
