(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"));
	else if(typeof define === 'function' && define.amd)
		define(["react"], factory);
	else if(typeof exports === 'object')
		exports["dazzler_core"] = factory(require("react"));
	else
		root["dazzler_core"] = factory(root["React"]);
})(self, function(__WEBPACK_EXTERNAL_MODULE_react__) {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/commons/js/casing.js":
/*!**********************************!*\
  !*** ./src/commons/js/casing.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "camelToSnakeCase": () => (/* binding */ camelToSnakeCase),
/* harmony export */   "snakeToCamelCase": () => (/* binding */ snakeToCamelCase),
/* harmony export */   "camelToSpinal": () => (/* binding */ camelToSpinal),
/* harmony export */   "transformKeys": () => (/* binding */ transformKeys)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/last.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/slice.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


function camelToSnakeCase(s) {
  return s.split('').map(function (c, i) {
    return c.charCodeAt(0) > 96 ? c : i > 0 ? "_".concat(c.toLowerCase()) : c.toLowerCase();
  }).reduce(function (p, n) {
    return p + n;
  });
}
function snakeToCamelCase(s) {
  return s.split('').reduce(function (a, e) {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.default)(a) === '_' ? (0,ramda__WEBPACK_IMPORTED_MODULE_1__.default)(0, a.length - 1, a) + e.toUpperCase() : a + e;
  }, '');
}
function camelToSpinal(s) {
  return s.split('').map(function (c, i) {
    return c.charCodeAt(0) > 96 ? c : i > 0 ? "-".concat(c.toLowerCase()) : c.toLowerCase();
  }).reduce(function (p, n) {
    return p + n;
  });
}
function transformKeys(obj, transform) {
  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(obj).reduce(function (a, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        k = _ref2[0],
        v = _ref2[1];

    a[transform(k)] = v;
    return a;
  }, {});
}

/***/ }),

/***/ "./src/commons/js/index.js":
/*!*********************************!*\
  !*** ./src/commons/js/index.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "toTimestamp": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.toTimestamp),
/* harmony export */   "timestampProp": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.timestampProp),
/* harmony export */   "loadCss": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.loadCss),
/* harmony export */   "loadScript": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.loadScript),
/* harmony export */   "debounce": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.debounce),
/* harmony export */   "snakeToCamelCase": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.snakeToCamelCase),
/* harmony export */   "camelToSnakeCase": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.camelToSnakeCase),
/* harmony export */   "camelToSpinal": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.camelToSpinal),
/* harmony export */   "transformKeys": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.transformKeys),
/* harmony export */   "collectTruePropKeys": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.collectTruePropKeys),
/* harmony export */   "chunk": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.chunk),
/* harmony export */   "disableCss": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.disableCss)
/* harmony export */ });
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scss/index.scss */ "./src/commons/scss/index.scss");
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_scss_index_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./src/commons/js/utils.js");
/* harmony import */ var _casing__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./casing */ "./src/commons/js/casing.js");





/***/ }),

/***/ "./src/commons/js/utils.js":
/*!*********************************!*\
  !*** ./src/commons/js/utils.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "toTimestamp": () => (/* binding */ toTimestamp),
/* harmony export */   "timestampProp": () => (/* binding */ timestampProp),
/* harmony export */   "loadScript": () => (/* binding */ loadScript),
/* harmony export */   "disableCss": () => (/* binding */ disableCss),
/* harmony export */   "loadCss": () => (/* binding */ loadCss),
/* harmony export */   "debounce": () => (/* binding */ debounce),
/* harmony export */   "collectTruePropKeys": () => (/* binding */ collectTruePropKeys),
/* harmony export */   "chunk": () => (/* binding */ chunk)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/includes.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/pluck.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


function toTimestamp(date) {
  return parseInt((date.getTime() / 1000).toFixed(0));
}
var timestampProp = function timestampProp(prop_name, value) {
  var payload = {};
  payload[prop_name] = value;
  payload["".concat(prop_name, "_timestamp")] = toTimestamp(new Date());
  return payload;
};
function loadScript(uri) {
  var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 3000;
  return new Promise(function (resolve, reject) {
    /* eslint-disable prefer-const */
    var timeoutId;

    var onload = function onload() {
      clearTimeout(timeoutId);
      resolve(uri);
    };

    var attributes = {
      src: uri,
      async: true
    };
    var element = document.createElement('script');
    Object.keys(attributes).forEach(function (k) {
      return element.setAttribute(k, attributes[k]);
    });
    element.onload = onload;
    timeoutId = setTimeout(function () {
      element.src = '';
      reject({
        error: "".concat(uri, " did not load after ").concat(timeout, "ms")
      });
    }, timeout);
    document.querySelector('body').appendChild(element);
  });
}
function disableCss(uri) {
  var element = document.getElementById("css-".concat(uri));

  if (element) {
    element.setAttribute('disabled', 'disabled');
    element.id = null;
  }
}
function loadCss(uri) {
  var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 3000;
  return new Promise(function (resolve, reject) {
    /* eslint-disable prefer-const */
    var timeoutId;

    var onload = function onload() {
      clearTimeout(timeoutId);
      resolve(uri);
    };

    disableCss(uri);
    var attributes = {
      rel: 'stylesheet',
      type: 'text/css',
      href: uri,
      media: 'all',
      id: "css-".concat(uri)
    };
    var element = document.createElement('link');
    Object.keys(attributes).forEach(function (k) {
      return element.setAttribute(k, attributes[k]);
    });
    element.onload = onload;
    timeoutId = setTimeout(function () {
      element.href = '';
      reject({
        error: "".concat(uri, " did not load after ").concat(timeout, "ms")
      });
    }, timeout);
    document.querySelector('head').appendChild(element);
  });
}
function debounce(func, wait) {
  var timeout, lastCall;
  return function () {
    var _arguments = arguments,
        _this = this;

    var now = new Date();

    if (!lastCall) {
      lastCall = now;
    }

    var later = function later() {
      timeout = null;
      /* eslint-disable no-invalid-this */

      func.apply(_this, _arguments);
      lastCall = new Date();
    };

    clearTimeout(timeout);
    var diff = now - lastCall;

    if (diff >= wait) {
      /* eslint-disable no-invalid-this */
      func.apply(this, arguments);
      lastCall = now;
    } else {
      timeout = setTimeout(later, diff);
    }
  };
}
function collectTruePropKeys(obj, filterKeys) {
  var pairs = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.default)(obj);

  if (filterKeys) {
    pairs = pairs.filter(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          k = _ref2[0],
          _ = _ref2[1];

      return (0,ramda__WEBPACK_IMPORTED_MODULE_1__.default)(k, filterKeys);
    });
  }

  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(0, pairs.filter(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        _ = _ref4[0],
        v = _ref4[1];

    return v;
  }));
}
function chunk(arr, n) {
  return arr.map(function (item, index) {
    return index % n === 0 ? arr.slice(index, index + n) : null;
  }).filter(function (item) {
    return item;
  });
}

/***/ }),

/***/ "./src/core/js/components/Button.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Button.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





/**
 * A button to click on!
 *
 * :CSS:
 *
 *     - ``dazzler-core-button``
 *     - ``bordered``
 *     - ``rounded``
 *     - ``circle``
 *     - ``primary``
 *     - ``danger``
 *     - ``warning``
 *     - ``success``
 *     - ``tiny``
 *     - ``small``
 *     - ``medium``
 *     - ``large``
 *     - ``x-large``
 *     - ``xx-large``
 *
 * @example
 *
 *     from dazzler.system import Page, Trigger
 *     from dazzler.components import core
 *
 *     button = core.Button('Click me', identity='btn')
 *
 *     page = Page(
 *         __name__,
 *         core.Container([button, core.Container(identity="output")])
 *     )
 *
 *     @page.binding(Trigger('btn', 'clicks'))
 *     async def on_click(ctx):
 *         await ctx.set_aspect('output', f'Clicked {ctx.trigger.value}')
 */

var Button = /*#__PURE__*/function (_React$Component) {
  _inherits(Button, _React$Component);

  var _super = _createSuper(Button);

  function Button() {
    _classCallCheck(this, Button);

    return _super.apply(this, arguments);
  }

  _createClass(Button, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          label = _this$props.label,
          identity = _this$props.identity,
          id = _this$props.id,
          class_name = _this$props.class_name,
          preset = _this$props.preset,
          style = _this$props.style,
          disabled = _this$props.disabled,
          size = _this$props.size;
      var css = (0,commons__WEBPACK_IMPORTED_MODULE_2__.collectTruePropKeys)(this.props, ['rounded', 'circle', 'bordered', 'disabled']);

      if (preset) {
        css.push(preset);
      } else {
        css.push('default');
      }

      if (size) {
        css.push(size);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, [class_name])),
        id: id || identity,
        style: style,
        disabled: disabled,
        onClick: function onClick() {
          return _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      }, label);
    }
  }]);

  return Button;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Button.defaultProps = {
  clicks: 0,
  bordered: true
};
Button.propTypes = {
  /**
   * Text or component to display.
   */
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),

  /**
   * The number of times the button was clicked.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Class name to give the button.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to the Button.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * DOM id, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Preset style colors to apply.
   */
  preset: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['primary', 'secondary', 'danger', 'warning', 'success']),

  /**
   * Disable the button.
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Round the edges.
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Circle button
   */
  circle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a border
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The size of the button.
   */
  size: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['tiny', 'small', 'medium', 'large', 'larger', 'x-large', 'xx-large']),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/CheckList.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/CheckList.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * A list of labels with options, the values aspect get all selected options.
 */

var CheckList = /*#__PURE__*/function (_React$Component) {
  _inherits(CheckList, _React$Component);

  var _super = _createSuper(CheckList);

  function CheckList() {
    _classCallCheck(this, CheckList);

    return _super.apply(this, arguments);
  }

  _createClass(CheckList, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          options = _this$props.options,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          id = _this$props.id,
          labels_class_name = _this$props.labels_class_name,
          inputs_class_name = _this$props.inputs_class_name,
          style = _this$props.style,
          labels_style = _this$props.labels_style,
          options_style = _this$props.options_style;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: id || identity,
        style: style
      }, options.map(function (_ref) {
        var label = _ref.label,
            value = _ref.value,
            title = _ref.title,
            label_class_name = _ref.label_class_name,
            input_class_name = _ref.input_class_name;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          title: title,
          key: "".concat(identity, "-opt-").concat(value),
          className: label_class_name || labels_class_name,
          style: labels_style
        }, label, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          type: "checkbox",
          className: input_class_name || inputs_class_name,
          style: options_style,
          onChange: function onChange(e) {
            return _this.props.updateAspects({
              values: e.target.checked ? (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(_this.props.values, [value]) : _this.props.values.filter(function (v) {
                return v !== value;
              })
            });
          }
        }));
      }));
    }
  }]);

  return CheckList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


CheckList.defaultProps = {
  values: []
};
CheckList.propTypes = {
  /**
   * Items in the checklist with labels, values and elements attributes.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    label_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    input_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Checked values
   */
  values: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)])),

  /**
   * Style object of the container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Class name of the container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global class name to give to labels.
   */
  labels_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global labels style objects.
   */
  labels_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Global options class name.
   */
  options_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global style object of options.
   */
  options_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Html id of the component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Container.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/Container.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Container)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Virtual div
 *
 * :CSS:
 *
 *     - ``dazzler-core-container``.
 *     - ``scroll``
 *     - ``flex``
 *     - ``row``
 *     - ``column``
 *     - ``btn``
 *     - ``center``
 *     - ``hidden``
 */

var Container = /*#__PURE__*/function (_React$Component) {
  _inherits(Container, _React$Component);

  var _super = _createSuper(Container);

  function Container() {
    _classCallCheck(this, Container);

    return _super.apply(this, arguments);
  }

  _createClass(Container, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      // Ignore virtual n_clicks don't need a re-render of
      // the whole children.
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          style = _this$props.style,
          children = _this$props.children,
          title = _this$props.title,
          identity = _this$props.identity,
          draggable = _this$props.draggable;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: class_name,
        style: style,
        title: title,
        draggable: draggable,
        onClick: function onClick() {
          _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      }, children);
    }
  }]);

  return Container;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Container.defaultProps = {
  clicks: 0
};
Container.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  draggable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Number of times the container was clicked.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/DataList.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/DataList.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A html datalist (select with autocomplete).
 */

var DataList = /*#__PURE__*/function (_React$Component) {
  _inherits(DataList, _React$Component);

  var _super = _createSuper(DataList);

  function DataList() {
    _classCallCheck(this, DataList);

    return _super.apply(this, arguments);
  }

  _createClass(DataList, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          class_name = _this$props.class_name,
          id = _this$props.id,
          identity = _this$props.identity,
          value = _this$props.value,
          options = _this$props.options,
          title = _this$props.title;
      var list_id = "datalist-".concat(identity);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: id || identity,
        title: title
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
        list: list_id,
        onChange: function onChange(e) {
          var value = e.target.value;
          var data_value = options.reduce(function (data, option) {
            return option.label === value ? option.value : data;
          }, null);

          _this.props.updateAspects({
            value: value,
            data_value: data_value
          });
        },
        value: value
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("datalist", {
        id: list_id
      }, options.map(function (option) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
          value: option.label
        });
      })));
    }
  }]);

  return DataList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


DataList.defaultProps = {};
DataList.propTypes = {
  /**
   * Options of the datalist.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Unique id for the component.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Value of the text input.
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * The value of the selected option if found.
   */
  data_value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),

  /**
   * Tooltip.
   */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Dropdown.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/Dropdown.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/is.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/includes.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/without.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/filter.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/any.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/values.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




var OptionType = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)]).isRequired,
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};

var DropdownOption = function DropdownOption(props) {
  var label = props.label,
      value = props.value,
      _onClick = props.onClick,
      style = props.style,
      class_name = props.class_name,
      selected = props.selected;
  var className = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var css = ['dropdown-item'];

    if (class_name) {
      css.push(class_name);
    }

    if (selected) {
      css.push('selected');
    }

    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css);
  }, [class_name, selected]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: className,
    onClick: function onClick(e) {
      e.stopPropagation();

      _onClick({
        value: value,
        label: label
      });
    },
    style: style
  }, label);
};

DropdownOption.propTypes = _objectSpread(_objectSpread({}, OptionType), {}, {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
  selected: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
});

var SelectedItem = function SelectedItem(props) {
  var option = props.option,
      onRemove = props.onRemove;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-selected-item"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-label"
  }, option.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-remover",
    onClick: function onClick(e) {
      e.stopPropagation();
      onRemove(option);
    }
  }, "\u2716"));
};
/**
 * A dropdown to select options from a list.
 *
 * :CSS:
 *
 *     - ``dazzler-core-dropdown``
 *     - ``drop-toggle``
 *     - ``drop-symbol``
 *     - ``drop-container``
 *     - ``drop-item``
 *     - ``drop-selected-item``
 *     - ``selected``
 *     - ``selected-items``
 *     - ``selected-label``
 *     - ``selected-remover``
 *     - ``no-results``
 *     - ``search-content``
 *     - ``dropdown-search-input``
 *     - ``drop-controls``
 *
 * @example
 *
 *      from dazzler.components.core import Dropdown
 *
 *      dropdown = Dropdown(
 *          {'label': 'Option 1', 'value': 1},
            {'label': 'Option 2', 'value': 2}
 *      )
 *
 */


var Dropdown = function Dropdown(props) {
  var options = props.options,
      class_name = props.class_name,
      style = props.style,
      identity = props.identity,
      updateAspects = props.updateAspects,
      toggle_symbol = props.toggle_symbol,
      opened = props.opened,
      multi = props.multi,
      value = props.value,
      searchable = props.searchable,
      search_value = props.search_value,
      search_props = props.search_props,
      search_label = props.search_label,
      search_backend = props.search_backend,
      filtered_options = props.filtered_options,
      no_results_label = props.no_results_label,
      scrollable = props.scrollable,
      scroll_max_size = props.scroll_max_size;
  var mainRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var containerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var toggleRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var searchContentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var symbolRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var selectedRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null); // Keep them items with labels

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(function () {
    if (value) {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, value)) {
        return [{
          value: value,
          label: value
        }];
      }

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Array, value)) {
        return value;
      }

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, value)) {
        return [value];
      }
    }

    return [];
  }),
      _useState2 = _slicedToArray(_useState, 2),
      selectedItems = _useState2[0],
      setSelectedItems = _useState2[1];

  var containerStyle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var s = {};
    if (!opened) return s; // TODO orient top or bottom.

    var _toggleRef$current$ge = toggleRef.current.getBoundingClientRect(),
        height = _toggleRef$current$ge.height,
        width = _toggleRef$current$ge.width,
        top = _toggleRef$current$ge.top;

    s.top = "".concat(height, "px");
    s.width = "".concat(width - 1, "px");

    if (scrollable) {
      if (scroll_max_size) {
        s.maxHeight = scroll_max_size;
      } else {
        s.maxHeight = window.innerHeight - top - height - 24;
      }
    }

    return s;
  }, [opened, selectedItems, scrollable, scroll_max_size]);
  var containerCss = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var css = ['drop-container'];

    if (opened) {
      css.push('opened');
    }

    if (scrollable) {
      css.push('scrollable');
    }

    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css);
  }, [opened, scrollable]);

  var onItemClick = function onItemClick(option) {
    var itemValue = option.value;
    var payload = {
      opened: false
    };

    if (multi) {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(itemValue, value || [])) {
        payload.value = (0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([itemValue], value);
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([option], selectedItems));
      } else {
        payload.value = (0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(value || [], [itemValue]);
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(selectedItems, [option]));
      }
    } else {
      if (value === itemValue) {
        payload.value = null;
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([option], selectedItems));
      } else {
        payload.value = itemValue;
        setSelectedItems([option]);
      }
    }

    updateAspects(payload);
  }; // Search filtering


  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (search_backend) {
      return;
    }

    if (!search_value) {
      updateAspects({
        filtered_options: null
      });
      return;
    }

    var matcher = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(search_value);
    updateAspects({
      filtered_options: (0,ramda__WEBPACK_IMPORTED_MODULE_7__.default)(function (option) {
        if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option)) {
          return matcher(option);
        }

        if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, option)) {
          var isOk = false;

          if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, option.value)) {
            if (search_props && search_props.length) {
              // noinspection JSUnusedLocalSymbols
              isOk = search_props.reduce(function (acc, prop) {
                if (acc) {
                  return acc;
                }

                return matcher(option.value[prop]);
              }, false);
            } else {
              isOk = (0,ramda__WEBPACK_IMPORTED_MODULE_8__.default)(matcher, (0,ramda__WEBPACK_IMPORTED_MODULE_9__.default)(option.value));
            }
          } else if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option.value)) {
            isOk = matcher(option.value);
          }

          if (search_label) {
            isOk = isOk || matcher(option.label);
          }

          return isOk;
        }

        return false;
      }, options)
    });
  }, [search_value, search_backend, options, search_props, search_label]);
  var onSearch = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (e) {
    var payload = {
      search_value: e.target.value
    };

    if (!opened) {
      payload.opened = true;
    }

    updateAspects(payload);
  }, [updateAspects, opened]);
  var optionsContent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var opts = filtered_options ? filtered_options : options;

    if (opts.length === 0) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "no-results"
      }, no_results_label);
    }

    return opts.map(function (option, i) {
      var selected;
      var key = "".concat(identity, "-").concat(i);

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option)) {
        selected = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(value, option);
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, {
          label: option,
          value: option,
          key: key,
          selected: selected,
          onClick: onItemClick
        });
      }

      selected = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(value, option.value);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, _extends({}, option, {
        key: key,
        selected: selected,
        onClick: onItemClick
      }));
    });
  }, [options, filtered_options, value, selectedItems]);
  var onToggle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    var open = !opened;
    updateAspects({
      opened: open
    });
    event.stopPropagation();

    if (open) {
      if (searchable) {
        inputRef.current.focus();
      }

      var autoClose = function autoClose() {
        updateAspects({
          opened: false
        });
        document.removeEventListener('click', autoClose);
      };

      document.addEventListener('click', autoClose);
    }
  }, [opened, inputRef]);
  var searchWidth = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    if (!searchContentRef.current) {
      return 9;
    }

    var toggleWidth = toggleRef.current.getBoundingClientRect().width;
    var searchWidth = searchContentRef.current.getBoundingClientRect().width + 9;
    var symbolWidth = symbolRef.current.getBoundingClientRect().width;
    var maxWidth = toggleWidth - symbolWidth - 16;

    if (searchWidth < maxWidth) {
      return searchWidth;
    }

    return maxWidth;
  }, [search_value, selectedItems, filtered_options]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: class_name,
    style: style,
    id: identity,
    ref: mainRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-toggle",
    onClick: onToggle,
    ref: toggleRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-controls"
  }, searchable && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "search-content",
    ref: searchContentRef
  }, search_value), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    value: search_value,
    onChange: onSearch,
    className: "dropdown-search-input",
    ref: inputRef,
    style: {
      width: searchWidth
    }
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-items",
    ref: selectedRef
  }, multi || searchable ? selectedItems.map(function (item, i) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SelectedItem, {
      option: item,
      onRemove: onItemClick,
      key: "".concat(identity, "-selected-").concat(i)
    });
  }) : selectedItems.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, _extends({}, selectedItems[0], {
    selected: true,
    onClick: onToggle
  })) : null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "drop-symbol",
    ref: symbolRef
  }, toggle_symbol)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: containerCss,
    ref: containerRef,
    style: containerStyle
  }, optionsContent));
};

Dropdown.defaultProps = {
  toggle_symbol: '⏷',
  opened: false,
  filtered_options: null,
  search_value: '',
  no_results_label: 'No results!'
};
Dropdown.propTypes = {
  /**
   * List of options to choose/search from.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape(OptionType), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)])).isRequired,

  /**
   * Currently selected value(s).
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)]),

  /**
   * Allow multiple values to be chosen, the value become a list of values.
   */
  multi: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * If true, render an input
   */
  searchable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Value entered by user to search options.
   */
  search_value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Keys to filter on searching the options.
   *
   * - Leave empty for all props.
   * - Valid values types to search on are strings & arrays.
   * - Nested prop access with dot notation.
   */
  search_props: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)),

  /**
   * Search the label along with the value.
   */
  search_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Do not perform any search on the options from the frontend and instead
   * relies on binding the ``search_value`` to filter and set the
   * ``filtered_options`` aspect.
   */
  search_backend: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Array of options that are filtered, set from backend with search
   */
  filtered_options: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),

  /**
   * Is the dropdown currently open ?
   */
  opened: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Label to use when no search results are available.
   */
  no_results_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Unicode character used as the toggle button.
   */
  toggle_symbol: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Make the menu scrollable.
   */
  scrollable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  scroll_max_size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dropdown);

/***/ }),

/***/ "./src/core/js/components/Form.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Form.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A form element with auto fields.
 *
 * :CSS:
 *
 *     - ``dazzler-core-form``
 *     - ``form-header``
 *     - ``form-body``
 *     - ``form-field``
 *     - ``field-error``
 *     - ``form-label``
 *     - ``form-input``
 *     - ``form-footer``
 *     - ``form-submit``
 */

var Form = /*#__PURE__*/function (_React$Component) {
  _inherits(Form, _React$Component);

  var _super = _createSuper(Form);

  function Form() {
    _classCallCheck(this, Form);

    return _super.apply(this, arguments);
  }

  _createClass(Form, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          style = _this$props.style,
          action = _this$props.action,
          method = _this$props.method,
          target = _this$props.target,
          auto_complete = _this$props.auto_complete,
          name = _this$props.name,
          header = _this$props.header,
          fields = _this$props.fields,
          body = _this$props.body,
          footer = _this$props.footer,
          errors = _this$props.errors,
          include_submit = _this$props.include_submit,
          submit_label = _this$props.submit_label;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", {
        id: identity,
        className: class_name,
        style: style,
        action: action,
        method: method,
        target: target,
        autoComplete: auto_complete,
        name: name
      }, header && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-header"
      }, header), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-body"
      }, fields && fields.map(function (_ref) {
        var label = _ref.label,
            type = _ref.type,
            name = _ref.name,
            component = _ref.component,
            value = _ref.value;
        var error = errors[name];
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: 'form-field' + (error ? ' field-error' : ''),
          key: "form-".concat(identity, "-").concat(name)
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          className: "form-label"
        }, label), component || /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          name: name,
          type: type,
          className: 'form-input',
          value: value
        }), error && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: "form-error"
        }, error));
      }), body), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-footer"
      }, footer), include_submit && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
        type: "submit",
        className: "form-submit"
      }, submit_label));
    }
  }]);

  return Form;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Form.defaultProps = {
  include_submit: true,
  submit_label: 'Submit',
  errors: {}
};
Form.propTypes = {
  /**
   * Fields of the form, either provide a component or a type for the input.
   */
  fields: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    type: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    component: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any)
  })),

  /**
   * Render on top of the form (CSS: form-header)
   */
  header: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Render in the middle of the form, after the fields. (CSS: form-body)
   */
  body: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Render at the bottom of the form (CSS: form-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Url to submit the form.
   */
  action: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Http method to submit the form.
   */
  method: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['get', 'post']),

  /**
   * How will the response display.
   */
  target: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['_blank', '_self', '_parent', '_top']),

  /**
   * Name of the form.
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Specifies auto complete for the form.
   */
  auto_complete: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['on', 'off']),

  /**
   * How the data is encode before submit.
   */
  enctype: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['application/x-www-form-urlencoded', 'multipart/form-data', 'text/plain']),

  /**
   * Character encoding for submission.
   */
  accept_charset: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Specify the form should be validated on submission.
   */
  no_validate: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * CSS class of the form element.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the form element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Errors to show with the fields. Keys are name.
   */
  errors: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Include a submit button on the form.
   */
  include_submit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Label of the submit button.
   */
  submit_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Grid.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Grid.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Grid)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Render a list in a grid with a number of ``columns``.
 *
 * :CSS:
 *
 *     - ``dazzler-core-grid``
 *     - ``grid-row``
 *     - ``grid-cell``
 *
 * @example
 *
 *     from dazzler.components import core
 *
 *     grid = core.Grid([1, 2, 3, 4], 2)
 */

var Grid = /*#__PURE__*/function (_React$Component) {
  _inherits(Grid, _React$Component);

  var _super = _createSuper(Grid);

  function Grid() {
    _classCallCheck(this, Grid);

    return _super.apply(this, arguments);
  }

  _createClass(Grid, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          children = _this$props.children,
          columns = _this$props.columns;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: identity,
        className: class_name
      }, (0,commons__WEBPACK_IMPORTED_MODULE_2__.chunk)(children, columns).map(function (row, y) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          key: "".concat(identity, "-row-").concat(y),
          className: 'grid-row'
        }, row.map(function (cell, x) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
            key: "".concat(identity, "-cell-").concat(y, "-").concat(x),
            className: 'grid-cell'
          }, cell);
        }));
      }));
    }
  }]);

  return Grid;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Grid.defaultProps = {};
Grid.propTypes = {
  /**
   * Children to render in a grid.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * Number of columns
   */
  columns: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Html.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Html.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Html)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/type.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/map.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }






function prepareType(obj) {
  switch ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(obj)) {
    case 'String':
    case 'Number':
    case 'Boolean':
    case 'Null':
      return obj;

    case 'Array':
      return obj.map(prepareType).filter(function (e) {
        return (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(e) !== 'Undefined';
      });

    case 'Object':
      return (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(prepareObject, obj);

    default:
      return;
  }
}

function prepareObject(obj) {
  var payload = {};

  for (var k in obj) {
    // noinspection JSUnfilteredForInLoop
    if (!k.startsWith('_')) {
      // noinspection JSUnfilteredForInLoop
      payload[(0,commons__WEBPACK_IMPORTED_MODULE_2__.camelToSnakeCase)(k)] = prepareType(obj[k]);
    }
  }

  return payload;
}
/**
 * Html tag wrapper, give any props as ``attributes``.
 * Listen to events with the readonly event aspect containing the
 * latest event fired.
 */


var Html = /*#__PURE__*/function (_React$Component) {
  _inherits(Html, _React$Component);

  var _super = _createSuper(Html);

  function Html(props) {
    var _this;

    _classCallCheck(this, Html);

    _this = _super.call(this, props);
    _this.onEvent = _this.onEvent.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Html, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      if (this.props.events) {
        this.props.events.forEach(function (e) {
          _this2.element.addEventListener(e, _this2.onEvent);
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var _this3 = this;

      if (this.props.events) {
        this.props.events.forEach(function (e) {
          _this3.element.removeEventListener(e, _this3.onEvent);
        });
      }
    }
  }, {
    key: "onEvent",
    value: function onEvent(e) {
      this.props.updateAspects({
        event: _objectSpread({
          name: e.name
        }, prepareObject(e))
      });
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      // Ignore virtual event don't need a re-render of
      // the whole children.
      return !(this.props.event !== nextProps.event);
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var _this$props = this.props,
          tag = _this$props.tag,
          id = _this$props.id,
          class_name = _this$props.class_name,
          attributes = _this$props.attributes,
          identity = _this$props.identity,
          children = _this$props.children;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(tag, _objectSpread(_objectSpread({
        id: id || identity,
        className: class_name,
        children: children
      }, attributes), {}, {
        ref: function ref(r) {
          return _this4.element = r;
        }
      }));
    }
  }]);

  return Html;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Html.defaultProps = {};
Html.propTypes = {
  /**
   * Tag name of the component.
   */
  tag: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Children of the html tag.
   */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Id of the element in DOM.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Class of the element.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Any other html attributes relevant to the html tag
   */
  attributes: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Events to subscribe.
   */
  events: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),

  /**
   * Last event fired.
   */
  event: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Image.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Image.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Image)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





/**
 * An image.
 *
 * :CSS:
 *
 *     - ``dazzler-core-image``
 *     - ``bordered``
 *     - ``padded``
 *     - ``rounded``
 *     - ``centered``
 */

var Image = /*#__PURE__*/function (_React$Component) {
  _inherits(Image, _React$Component);

  var _super = _createSuper(Image);

  function Image() {
    _classCallCheck(this, Image);

    return _super.apply(this, arguments);
  }

  _createClass(Image, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          class_name = _this$props.class_name,
          style = _this$props.style,
          identity = _this$props.identity,
          alt = _this$props.alt,
          src = _this$props.src,
          caption = _this$props.caption,
          height = _this$props.height,
          width = _this$props.width,
          cross_origin = _this$props.cross_origin,
          decoding = _this$props.decoding,
          caption_class_name = _this$props.caption_class_name,
          caption_style = _this$props.caption_style,
          link = _this$props.link,
          link_class_name = _this$props.link_class_name,
          link_style = _this$props.link_style,
          figure_class_name = _this$props.figure_class_name,
          figure_style = _this$props.figure_style;
      var css = (0,commons__WEBPACK_IMPORTED_MODULE_2__.collectTruePropKeys)(this.props, ['rounded', 'bordered', 'circle', 'flexible', 'centered', 'padded']);
      var content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
        alt: alt,
        src: src,
        height: height,
        width: width,
        crossOrigin: cross_origin,
        decoding: decoding,
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, [class_name])),
        style: style,
        id: identity,
        onClick: function onClick() {
          return _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      });

      if (link) {
        var linkCss = ['dazzler-core-image-link'];

        if (link_class_name) {
          linkCss.push(link_class_name);
        }

        content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
          href: link,
          style: link_style,
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, linkCss))
        }, content);
      }

      if (caption) {
        var figCss = ['dazzler-core-figure'];
        var capCss = ['dazzler-core-caption'];

        if (figure_class_name) {
          figCss.push(figure_class_name);
        }

        if (caption_class_name) {
          capCss.push(caption_class_name);
        }

        content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figure", {
          style: figure_style,
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, figCss))
        }, content, caption && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figcaption", {
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, capCss)),
          style: caption_style
        }, caption));
      }

      return content;
    }
  }]);

  return Image;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Image.defaultProps = {
  clicks: 0
};
Image.propTypes = {
  /**
   * The source url of the image.
   */
  src: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Alt img attribute to show when the browser cannot display the image.
   */
  alt: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Height in pixel
   */
  height: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Width in pixel
   */
  width: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Link to another page when the image is clicked.
   */
  link: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Text to include beneath the image.
   */
  caption: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Fetch the image with CORS.
   */
  cross_origin: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['anonymous', 'use-credentials']),

  /**
   * Decoding hint for the browser
   */
  decoding: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['sync', 'async', 'auto']),

  /**
   * Preload the image before mount.
   */
  preload: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Times the image was clicked on.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS class to give to root element, (Scoped: dazzler-core-image)
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the root element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Add bordered style class
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add rounded style class
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add centered style class for the image to
   * appear in the horizontal middle
   */
  centered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Take up the whole size of the parent container.
   */
  flexible: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Image is a circle
   */
  circle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a little padding around the image.
   */
  padded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Style to give to the caption of the image.
   */
  caption_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * CSS class to give to the caption of the image.
   */
  caption_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class to give to figure if caption is provided.
   */
  figure_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to figure if caption is provided.
   */
  figure_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * CSS class to give to the link element.
   */
  link_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to the link.
   */
  link_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Input.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Input.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Input)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/omit.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Html input wrapper.
 */

var Input = /*#__PURE__*/function (_React$Component) {
  _inherits(Input, _React$Component);

  var _super = _createSuper(Input);

  function Input() {
    _classCallCheck(this, Input);

    return _super.apply(this, arguments);
  }

  _createClass(Input, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          identity = _this$props.identity,
          type = _this$props.type,
          auto_complete = _this$props.auto_complete,
          auto_focus = _this$props.auto_focus,
          auto_save = _this$props.auto_save,
          auto_correct = _this$props.auto_correct,
          min_length = _this$props.min_length,
          max_length = _this$props.max_length;
      var omitted = ['class_name', 'id', 'identity', 'auto_complete', 'auto_focus', 'auto_save', 'auto_correct', 'min_length', 'updateAspects', 'n_blur', 'n_submit', '_name', '_package'];

      if (type === 'reset') {
        omitted.push('value');
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", _extends({
        id: id || identity,
        className: class_name,
        autoComplete: auto_complete,
        autoFocus: auto_focus,
        autoSave: auto_save,
        autoCorrect: auto_correct,
        minLength: min_length,
        maxLength: max_length
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(omitted, this.props), {
        onChange: function onChange(e) {
          var payload = {};

          switch (_this.props.type) {
            case 'number':
              payload.value = Number(e.target.value);
              break;

            case 'checkbox':
              payload.checked = e.target.checked;
              break;

            default:
              payload.value = e.target.value;
          }

          _this.props.updateAspects(payload);
        },
        onBlur: function onBlur() {
          return _this.props.updateAspects({
            n_blur: _this.props.n_blur + 1
          });
        },
        onKeyUp: function onKeyUp(e) {
          if (e.key === 'Enter') {
            _this.props.updateAspects({
              n_submit: _this.props.n_submit + 1
            });
          }
        }
      }));
    }
  }]);

  return Input;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Input.defaultProps = {
  value: '',
  n_blur: 0,
  n_submit: 0,
  checked: false
};
Input.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
  type: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['hidden', 'text', 'number', 'search', 'tel', 'password', 'range', 'email', 'url', 'submit', 'checkbox', 'reset']),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  pattern: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_complete: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_focus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  auto_save: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_correct: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  n_blur: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  n_submit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  min: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  min_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  max: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  step: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
  multiple: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Interval.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/Interval.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Interval)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Update ``times`` aspect every interval to trigger a binding.
 */

var Interval = /*#__PURE__*/function (_React$Component) {
  _inherits(Interval, _React$Component);

  var _super = _createSuper(Interval);

  function Interval(props) {
    var _this;

    _classCallCheck(this, Interval);

    _this = _super.call(this, props);
    _this.state = {
      intervalId: null
    };
    _this.loop = _this.loop.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Interval, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      this.startLoop();
    }
  }, {
    key: "startLoop",
    value: function startLoop() {
      var timeout = this.props.timeout;
      var intervalId = window.setInterval(this.loop, timeout);
      this.setState({
        intervalId: intervalId
      });
    }
  }, {
    key: "loop",
    value: function loop() {
      if (this.props.active) {
        this.props.updateAspects({
          times: this.props.times + 1
        });
      } else {
        window.clearInterval(this.state.intervalId);
        this.setState({
          intervalId: null
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.state.intervalId) {
        window.clearInterval(this.state.intervalId);
        this.setState({
          intervalId: null
        });
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.active && !this.props.active) {
        this.startLoop();
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Interval;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Interval.defaultProps = {
  timeout: 1000,
  times: 0,
  active: true
};
Interval.propTypes = {
  /**
   * The delay between each time.
   */
  timeout: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Number of times the interval was fired.
   */
  times: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Enable/disable the interval loop.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Link.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Link.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Link)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Link to external url or other dazzler page by name.
 *
 * :CSS: ``dazzler-core-link``
 */

var Link = /*#__PURE__*/function (_React$Component) {
  _inherits(Link, _React$Component);

  var _super = _createSuper(Link);

  function Link() {
    _classCallCheck(this, Link);

    return _super.apply(this, arguments);
  }

  _createClass(Link, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          href = _this$props.href,
          children = _this$props.children,
          style = _this$props.style,
          page_name = _this$props.page_name,
          identity = _this$props.identity;
      var url = href;

      if (page_name) {
        url = "".concat(window.dazzler_base_url, "/dazzler/link?page=").concat(encodeURIComponent(page_name));
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
        id: id || identity,
        href: url,
        className: class_name,
        style: style
      }, children || page_name || url);
    }
  }]);

  return Link;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Link.defaultProps = {};
Link.propTypes = {
  /**
   * The link destination.
   */
  href: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Text/Component to show as link.
   */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Id of the html element, othewise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the <a> element
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of root <a> element
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Hovered description
   */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Name of the page to redirect to if the href is not set.
   */
  page_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ListBox.jsx":
/*!********************************************!*\
  !*** ./src/core/js/components/ListBox.jsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/isNil.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/slice.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/insert.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/remove.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/mergeAll.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




/**
 * A component where you can ``add`` items to instead of rendering
 * the whole list again. With an optional max size.
 *
 * :CSS:
 *
 *     - ``dazzler-core-list-box``
 *     - ``vertical``
 *     - ``horizontal``
 *     - ``scrollable``
 *
 * :example:
 *
 * .. literalinclude:: ../../tests/components/pages/list_box.py
 */

var ListBox = function ListBox(_ref) {
  var items = _ref.items,
      max_length = _ref.max_length,
      append = _ref.append,
      prepend = _ref.prepend,
      concat = _ref.concat,
      insert = _ref.insert,
      delete_index = _ref.delete_index,
      scrollable = _ref.scrollable,
      direction = _ref.direction,
      size = _ref.size,
      keep_scroll = _ref.keep_scroll,
      class_name = _ref.class_name,
      style = _ref.style,
      identity = _ref.identity,
      updateAspects = _ref.updateAspects;
  var root = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      toScroll = _useState2[0],
      setToScroll = _useState2[1]; // Operation handlers


  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(append)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(items, [append]);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(1, arr.length, arr);
      }

      updateAspects({
        append: null,
        items: arr
      });

      if (scrollable && keep_scroll) {
        setToScroll(true);
      }
    }
  }, [append, max_length, scrollable, keep_scroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(prepend)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)([prepend], items);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(0, arr.length - 1, arr);
      }

      updateAspects({
        prepend: null,
        items: arr
      });
    }
  }, [prepend, max_length, scrollable, keep_scroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(concat)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(items, concat);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(arr.length - max_length, arr.length, arr);
      }

      updateAspects({
        concat: null,
        items: arr
      });
    }
  }, [concat]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(insert)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)(insert.index, insert.item, items);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(0, arr.length - 1, arr);
      }

      updateAspects({
        insert: null,
        items: arr
      });
    }
  }, [insert]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(delete_index)) {
      updateAspects({
        delete_index: null,
        items: (0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(delete_index, 1, items)
      });
    }
  }, [delete_index]); // Update scrolling.

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (toScroll) {
      if (direction === 'vertical') {
        root.current.scrollTop = root.current.scrollHeight;
      } else {
        root.current.scrollLeft = root.current.scrollWidth;
      }

      setToScroll(false);
    }
  }, [toScroll]); // Render

  var internalStyle = {};
  var css = [class_name, direction];

  if (scrollable) {
    css.push('scrollable');

    if (direction === 'vertical') {
      internalStyle.height = "".concat(size, "px");
    } else {
      internalStyle.width = "".concat(size, "px");
    }
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: (0,ramda__WEBPACK_IMPORTED_MODULE_7__.default)(' ', css),
    style: (0,ramda__WEBPACK_IMPORTED_MODULE_8__.default)([style, internalStyle]),
    id: identity,
    ref: root
  }, items);
};

ListBox.defaultProps = {
  items: [],
  direction: 'vertical'
};
ListBox.propTypes = {
  /**
   * List of items to render.
   */
  items: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * Maximum amount of items in the list, extra items will be popped off.
   */
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Add an item to the end of the list.
   */
  append: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Add an item to the start of the list.
   */
  prepend: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Concatenate another list with the current items.
   */
  concat: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)),

  /**
   * Insert an item at an index position.
   */
  insert: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    /**
     * Index to insert the item at.
     */
    index: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

    /**
     * Item to insert.
     */
    item: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)
  }),

  /**
   * Delete the item at the index.
   */
  delete_index: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Wether the list box container is scrollable.
   */
  scrollable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * In which direction the items will be inserted.
   */
  direction: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['vertical', 'horizontal']),

  /**
   * Must be set for the scrollable aspect to work.
   * Height or width in pixels depending on the direction aspect.
   */
  size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Keep the last appended item in view if scrolling is enabled.
   */
  keep_scroll: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ListBox);

/***/ }),

/***/ "./src/core/js/components/Modal.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Modal.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Modal)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A modal overlay the page with a darkened background.
 *
 * :CSS:
 *
 *     - ``dazzler-core-modal``
 *     - ``modal-overlay``
 *     - ``modal-active``
 *     - ``modal-content``
 *     - ``modal-header``
 *     - ``modal-closer``
 *     - ``modal-body``
 *     - ``modal-footer``
 */

var Modal = /*#__PURE__*/function (_React$Component) {
  _inherits(Modal, _React$Component);

  var _super = _createSuper(Modal);

  function Modal() {
    _classCallCheck(this, Modal);

    return _super.apply(this, arguments);
  }

  _createClass(Modal, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          style = _this$props.style,
          active = _this$props.active,
          body = _this$props.body,
          header = _this$props.header,
          footer = _this$props.footer,
          close_button = _this$props.close_button;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        style: style,
        id: identity
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-overlay".concat(active ? ' modal-active' : ''),
        onClick: function onClick(e) {
          _this.props.updateAspects({
            active: false
          });

          e.stopPropagation();
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-content",
        onClick: function onClick(e) {
          return e.stopPropagation();
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-header"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, header), close_button && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-closer",
        onClick: function onClick() {
          return _this.props.updateAspects({
            active: false
          });
        }
      }, "X")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-body"
      }, body), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-footer"
      }, footer))));
    }
  }]);

  return Modal;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Modal.defaultProps = {
  close_button: true
};
Modal.propTypes = {
  /**
   * Main content of the modal. (css: modal-body)
   */
  body: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),

  /**
   * Appear before the body. (css: modal-header)
   */
  header: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Appear after the body. (css: modal-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Activate the modal.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Include a close button in the top right corner of the header.
   */
  close_button: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * CSS class of the modal.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of outer container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ProgressBar.jsx":
/*!************************************************!*\
  !*** ./src/core/js/components/ProgressBar.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Simple progress bar support by all browsers.
 *
 * :CSS:
 *
 *     - ``dazzler-core-progress-bar``
 *     - ``progress``
 *     - ``high``
 *     - ``low``
 *     - ``optimum``
 *     - ``striped``
 *     - ``rounded``
 */

var ProgressBar = /*#__PURE__*/function (_React$Component) {
  _inherits(ProgressBar, _React$Component);

  var _super = _createSuper(ProgressBar);

  function ProgressBar() {
    _classCallCheck(this, ProgressBar);

    return _super.apply(this, arguments);
  }

  _createClass(ProgressBar, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          identity = _this$props.identity,
          id = _this$props.id,
          class_name = _this$props.class_name,
          style = _this$props.style,
          value = _this$props.value,
          minimum = _this$props.minimum,
          maximum = _this$props.maximum,
          optimum = _this$props.optimum,
          high = _this$props.high,
          low = _this$props.low,
          striped = _this$props.striped,
          rounded = _this$props.rounded,
          progress_class_name = _this$props.progress_class_name,
          progress_text = _this$props.progress_text;
      var outerClasses = [class_name];
      var innerClasses = ['progress'];

      if (progress_class_name) {
        innerClasses.push(progress_class_name);
      }

      if (high && value >= high) {
        innerClasses.push('high');
      } else if (optimum && value >= optimum) {
        innerClasses.push('optimum');
      } else if (low && value <= low) {
        innerClasses.push('low');
      }

      if (striped) {
        innerClasses.push('striped');
      }

      if (rounded) {
        innerClasses.push('rounded');
        outerClasses.push('rounded');
      }

      var total = maximum - minimum;
      var width = value / total * 100;
      var text = '';

      if (progress_text === 'percent') {
        text = "".concat(width.toFixed(0), " %");
      }

      if (progress_text === 'value') {
        text = "".concat(value, " / ").concat(maximum);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', outerClasses),
        ref: function ref(r) {
          return _this.progress = r;
        },
        style: style,
        onClick: function onClick(e) {
          var x = e.pageX - _this.progress.offsetLeft;
          var y = e.pageY - _this.progress.offsetTop;
          var clicked = x * maximum / _this.progress.offsetWidth;

          _this.props.updateAspects({
            click: {
              x: x,
              y: y,
              value: clicked,
              timestamp: e.timeStamp
            }
          });
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', innerClasses),
        style: {
          width: "".concat(width, "%")
        }
      }, text));
    }
  }]);

  return ProgressBar;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


ProgressBar.defaultProps = {
  value: 0,
  minimum: 0,
  maximum: 100
};
ProgressBar.propTypes = {
  /**
   * The current numeric value. This must be between the minimum and maximum values (min attribute and max attribute) if they are specified. If unspecified or malformed, the value is 0. If specified, but not within the range given by the min attribute and max attribute, the value is equal to the nearest end of the range.
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The lower numeric bound of the measured range. This must be less than the maximum value (max attribute), if specified. If unspecified, the minimum value is 0
   */
  minimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The upper numeric bound of the measured range. This must be greater than the minimum value (min attribute), if specified. If unspecified, the maximum value is 1.
   */
  maximum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The upper numeric bound of the low end of the measured range. This must be greater than the minimum value (min attribute), and it also must be less than the high value and maximum value (high attribute and max attribute, respectively), if any are specified. If unspecified, or if less than the minimum value, the low value is equal to the minimum value.
   */
  low: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The lower numeric bound of the high end of the measured range. This must be less than the maximum value (max attribute), and it also must be greater than the low value and minimum value (low attribute and min attribute, respectively), if any are specified. If unspecified, or if greater than the maximum value, the high value is equal to the maximum value.
   */
  high: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * This attribute indicates the optimal numeric value. It must be within the range (as defined by the min attribute and max attribute). When used with the low attribute and high attribute, it gives an indication where along the range is considered preferable. For example, if it is between the min attribute and the low attribute, then the lower range is considered preferred.
   */
  optimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Id for this component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the outer container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the inner progress container.
   */
  progress_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style of the component.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Set to show the value on the progress bar.
   */
  progress_text: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['percent', 'value']),

  /**
   * Readonly click event with the value.
   */
  click: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    x: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    y: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    timestamp: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
  }),

  /**
   * Use striped style.
   */
  striped: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Use the rounded style
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/RadioList.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/RadioList.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RadioList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A radio button list where only a single value can be selected.
 */

var RadioList = /*#__PURE__*/function (_React$Component) {
  _inherits(RadioList, _React$Component);

  var _super = _createSuper(RadioList);

  function RadioList() {
    _classCallCheck(this, RadioList);

    return _super.apply(this, arguments);
  }

  _createClass(RadioList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          value = _this$props.value,
          options = _this$props.options;

      if (value === undefined) {
        this.props.updateAspects({
          value: options[0].value
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props2 = this.props,
          identity = _this$props2.identity,
          id = _this$props2.id,
          options = _this$props2.options,
          class_name = _this$props2.class_name,
          labels_class_name = _this$props2.labels_class_name,
          labels_style = _this$props2.labels_style,
          options_class_name = _this$props2.options_class_name,
          options_style = _this$props2.options_style;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: class_name
      }, options.map(function (_ref) {
        var value = _ref.value,
            label = _ref.label,
            title = _ref.title,
            label_class_name = _ref.label_class_name,
            input_class_name = _ref.input_class_name;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          key: "".concat(identity, "-opt-").concat(value),
          className: label_class_name || labels_class_name,
          style: labels_style
        }, label, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          name: identity,
          type: "radio",
          title: title,
          checked: value === _this.props.value,
          className: input_class_name || options_class_name,
          style: options_style,
          onChange: function onChange() {
            _this.props.updateAspects({
              value: value
            });
          }
        }));
      }));
    }
  }]);

  return RadioList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


RadioList.defaultProps = {};
RadioList.propTypes = {
  /**
   * Items in the radio list with labels, values and elements attributes.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    label_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    input_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Selected radio button.
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),

  /**
   * Style object of the container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Class name of the container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global class name to give to labels.
   */
  labels_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global labels style objects.
   */
  labels_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Global options class name.
   */
  options_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global style object of options.
   */
  options_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Html id of the component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Select.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Select.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Select)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A select
 */

var Select = /*#__PURE__*/function (_React$Component) {
  _inherits(Select, _React$Component);

  var _super = _createSuper(Select);

  function Select() {
    _classCallCheck(this, Select);

    return _super.apply(this, arguments);
  }

  _createClass(Select, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          options = _this$props.options,
          identity = _this$props.identity,
          multi = _this$props.multi,
          class_name = _this$props.class_name,
          placeholder = _this$props.placeholder,
          name = _this$props.name,
          disabled = _this$props.disabled;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", {
        className: class_name,
        id: identity,
        name: name,
        value: this.props.value,
        multiple: multi,
        disabled: disabled,
        placeholder: placeholder,
        onChange: function onChange(e) {
          var value;

          if (multi) {
            var opts = e.target.options;
            value = [];

            for (var i = 0, l = opts.length; i < l; i++) {
              if (opts[i].selected) {
                value.push(options[i].value);
              }
            }
          } else {
            value = options[e.target.selectedIndex].value;
          }

          _this.props.updateAspects({
            value: value
          });
        }
      }, options.map(function (_ref) {
        var value = _ref.value,
            label = _ref.label;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
          key: "".concat(identity, "-option-").concat(value),
          className: '.dazzler-core-option',
          value: value
        }, label);
      }));
    }
  }]);

  return Select;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Select.defaultProps = {};
Select.propTypes = {
  /**
   * Option of the select.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Controls wether multiple options can be selected.
   */
  multi: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Value of the selected option(s)
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]))]),

  /**
   * Size of the options to use instead of
   */
  size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS class of the Select
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Placeholder text when the input has no value.
   */
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * name of the html input that will be created with the current value
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Disable the component.
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Slider.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Slider.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Slider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * A slider with a caret contained within a min and max value.
 *
 * :CSS:
 *
 *     - ``dazzler-core-slider``
 *     - ``slider-area``: The outer div of the slider.
 *     - ``slider-handle``: The drag handle
 *     - ``slider-spacer``: The space that is before the handle.
 *
 * :Example:
 *
 * .. literalinclude:: ../../tests/components/pages/slider.py
 *     :lines: 5-43
 */

var Slider = /*#__PURE__*/function (_React$Component) {
  _inherits(Slider, _React$Component);

  var _super = _createSuper(Slider);

  function Slider(props) {
    var _this;

    _classCallCheck(this, Slider);

    _this = _super.call(this, props);
    _this.onDragStart = _this.onDragStart.bind(_assertThisInitialized(_this));
    _this.onDragEnd = _this.onDragEnd.bind(_assertThisInitialized(_this));
    _this.handleDrag = (0,commons__WEBPACK_IMPORTED_MODULE_2__.debounce)(_this.handleDrag, _this.props.debounce);
    _this.onDragOver = _this.onDragOver.bind(_assertThisInitialized(_this));
    _this.state = {
      dragging: false
    };
    _this.dragX = 0;
    return _this;
  }

  _createClass(Slider, [{
    key: "onDragStart",
    value: function onDragStart(e) {
      this.setState({
        dragging: true
      });
      e.nativeEvent.dataTransfer.setData('application/node type', this._draggable); // Put a event listener on document dragover for the time of the
      // drag, hate on you IE and Firefox.
      // Needs to be document otherwise you can only drag over anchor.

      document.addEventListener('dragover', this.onDragOver);
    }
  }, {
    key: "handleDrag",
    value: function handleDrag(pageX) {
      // Some basic math, get the position of the x relative to the root.
      // The percentage is the x / width of the root
      // then the value is equal to  minimum + percent * range width
      var _this$props = this.props,
          minimum = _this$props.minimum,
          maximum = _this$props.maximum,
          round = _this$props.round;
      var x = pageX - this._root.offsetLeft;
      var percentage = x / this._root.offsetWidth;
      var width = maximum - minimum;
      var value = minimum + percentage * width;

      if (value > maximum) {
        value = maximum;
      }

      if (value < minimum) {
        value = minimum;
      }

      if (round === 'ceil') {
        value = Math.ceil(value);
      } else if (round === 'floor') {
        value = Math.floor(value);
      }

      this.props.updateAspects({
        value: value
      });
    }
  }, {
    key: "onDragEnd",
    value: function onDragEnd() {
      this.setState({
        dragging: false
      });
      document.removeEventListener('dragover', this.onDragOver); // Handle the last event, otherwise can't get the max/min values.

      this.handleDrag(this.dragX);
    }
  }, {
    key: "onDragOver",
    value: function onDragOver(e) {
      this.handleDrag(e.pageX);
      this.dragX = e.pageX;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          class_name = _this$props2.class_name,
          identity = _this$props2.identity,
          minimum = _this$props2.minimum,
          maximum = _this$props2.maximum,
          value = _this$props2.value,
          style = _this$props2.style;
      var dragging = this.state.dragging;
      var total = maximum - minimum;
      var width = (value - minimum) / total * 100;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: identity,
        style: style
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-area",
        ref: function ref(r) {
          return _this2._root = r;
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-spacer",
        style: {
          width: "".concat(width, "%")
        }
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-handle".concat(dragging ? ' dragged' : ''),
        draggable: true,
        onDragStart: this.onDragStart,
        onDragEnd: this.onDragEnd,
        ref: function ref(r) {
          return _this2._draggable = r;
        }
      })));
    }
  }]);

  return Slider;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Slider.defaultProps = {
  value: 0,
  debounce: 50
};
Slider.propTypes = {
  /**
   * Minimum (leftmost) value of the slider.
   */
  minimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   * Maximum (rightmost) value of the slider.
   */
  maximum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   * Current value
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Round the value
   */
  round: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['ceil', 'floor']),

  /**
   * Time in milliseconds to wait before updating the value.
   */
  debounce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS classes to use. (Scope: dazzler-core-slider)
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the root div.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Store.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Store.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Store)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Store data in the browser memory. Data last until the page is refreshed.
 */

var Store = /*#__PURE__*/function (_React$Component) {
  _inherits(Store, _React$Component);

  var _super = _createSuper(Store);

  function Store() {
    _classCallCheck(this, Store);

    return _super.apply(this, arguments);
  }

  _createClass(Store, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Store;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Store.defaultProps = {};
Store.propTypes = {
  /**
   * Stored data.
   */
  data: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Table.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Table.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Table)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Display data in a tabular manner (Non interactive).
 *
 * :CSS:
 *
 *     - ``dazzler-core-table``
 *     - ``table-head``
 *     - ``table-heading``
 *     - ``table-body``
 *     - ``table-row``
 *     - ``table-cell``
 *     - ``table-footer``
 *
 * :Example:
 *
 * .. literalinclude:: ../../tests/components/pages/table.py
 *     :lines: 5-22
 */

var Table = /*#__PURE__*/function (_React$Component) {
  _inherits(Table, _React$Component);

  var _super = _createSuper(Table);

  function Table() {
    _classCallCheck(this, Table);

    return _super.apply(this, arguments);
  }

  _createClass(Table, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          headers = _this$props.headers,
          rows = _this$props.rows,
          footer = _this$props.footer,
          style = _this$props.style,
          caption = _this$props.caption,
          include_row_number = _this$props.include_row_number,
          row_number_start = _this$props.row_number_start,
          default_table = _this$props.default_table,
          collapsed = _this$props.collapsed,
          centered = _this$props.centered,
          bordered = _this$props.bordered,
          size = _this$props.size;
      var c = [class_name];

      if (default_table) {
        c.push('default-table');
      }

      if (collapsed) {
        c.push('collapsed');
      }

      if (centered) {
        c.push('centered');
      }

      if (bordered) {
        c.push('bordered');
      }

      if (size) {
        c.push(size);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("table", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', c),
        id: identity,
        style: style
      }, caption && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("caption", {
        className: 'table-title'
      }, caption), headers && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("thead", {
        className: "table-head"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", null, include_row_number && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", {
        className: 'table-heading row-num'
      }), headers.map(function (header, i) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", {
          key: "".concat(identity, "-header-").concat(i),
          className: 'table-heading'
        }, header);
      }, headers))), rows && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tbody", {
        className: 'table-body'
      }, rows.map(function (row, i) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", {
          key: "".concat(identity, "-row-").concat(i),
          className: 'table-row'
        }, include_row_number && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", {
          className: 'table-cell row-num'
        }, row_number_start + i), row.map(function (cell, j) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", {
            key: "".concat(identity, "-cell-").concat(j, "x").concat(i),
            className: 'table-cell'
          }, cell);
        }));
      })), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tfoot", {
        className: "table-footer"
      }, footer));
    }
  }]);

  return Table;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Table.defaultProps = {
  default_table: true,
  collapsed: true
};
Table.propTypes = {
  /**
   * Rows of data or components to display.
   */
  rows: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node))),

  /**
   * Title of the table
   */
  caption: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Table headings
   */
  headers: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)),

  /**
   * CSS class of the table.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style of the table element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Content of tfoot element (.table-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Each row start with the row number.
   */
  include_row_number: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The start of the row number, useful if paged.
   */
  row_number_start: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Apply default style.
   */
  default_table: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Collapse the borders of the table.
   */
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Center the cell
   */
  centered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Put a border around elements
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The size of the table.
   */
  size: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['tiny', 'small', 'medium', 'large', 'larger', 'x-large', 'xx-large']),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/TextArea.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/TextArea.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextArea)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Html Textarea wrapper.
 *
 * :CSS:
 *
 *     - ``dazzler-core-text-area``
 *     - ``autosize``
 */

var TextArea = /*#__PURE__*/function (_React$Component) {
  _inherits(TextArea, _React$Component);

  var _super = _createSuper(TextArea);

  function TextArea() {
    _classCallCheck(this, TextArea);

    return _super.apply(this, arguments);
  }

  _createClass(TextArea, [{
    key: "resize",
    value: function resize() {
      this.elem.style.height = 'auto';
      this.elem.style.height = "".concat(this.elem.scrollHeight, "px");
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.autosize) {
        this.resize();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          value = _this$props.value,
          identity = _this$props.identity,
          cols = _this$props.cols,
          rows = _this$props.rows,
          name = _this$props.name,
          required = _this$props.required,
          class_name = _this$props.class_name,
          style = _this$props.style,
          autosize = _this$props.autosize;
      var css = [class_name];

      if (autosize) {
        css.push('autosize');
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", {
        name: name,
        id: identity,
        cols: cols,
        rows: rows,
        value: value,
        required: required,
        ref: function ref(r) {
          return _this.elem = r;
        },
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css),
        style: _objectSpread({}, style),
        onChange: function onChange(e) {
          _this.props.updateAspects({
            value: e.target.value
          });

          if (autosize) {
            _this.resize();
          }
        }
      });
    }
  }]);

  return TextArea;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


TextArea.defaultProps = {};
TextArea.propTypes = {
  /**
   * Current value of the textarea
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Name of the element for forms.
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Number of columns.
   */
  cols: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Number of rows.
   */
  rows: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Is it required in a form.
   */
  required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Is it disabled ?
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Hint when no value is entered.
   */
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Max length of the value.
   */
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Auto size the
   */
  autosize: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ViewPort.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/ViewPort.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewPort)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Activate a view with key.
 *
 * Standalone or tabbed.
 *
 * :CSS:
 *
 *     - ``dazzler-core-view-port``
 *     - ``view-content``
 *     - ``dazzler-tab``
 *     - ``dazzler-tabs``
 *     - ``tab-active``
 */

var ViewPort = /*#__PURE__*/function (_React$Component) {
  _inherits(ViewPort, _React$Component);

  var _super = _createSuper(ViewPort);

  function ViewPort() {
    _classCallCheck(this, ViewPort);

    return _super.apply(this, arguments);
  }

  _createClass(ViewPort, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          active = _this$props.active,
          views = _this$props.views,
          class_name = _this$props.class_name,
          style = _this$props.style,
          identity = _this$props.identity,
          tabbed = _this$props.tabbed,
          tab_labels = _this$props.tab_labels,
          vertical_tabs = _this$props.vertical_tabs,
          rounded_tabs = _this$props.rounded_tabs,
          bordered = _this$props.bordered;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: identity,
        className: class_name,
        style: style
      }, tabbed && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "dazzler-tabs".concat(vertical_tabs ? ' vertical' : '').concat(rounded_tabs ? ' rounded' : '')
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(views).map(function (k) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: "dazzler-tab".concat(k === active ? ' tab-active' : '').concat(rounded_tabs ? ' rounded' : ''),
          key: "".concat(identity, "-tab-").concat(k),
          onClick: function onClick() {
            return _this.props.updateAspects({
              active: k
            });
          }
        }, tab_labels[k] || k);
      }), rounded_tabs && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "filler"
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "view-content".concat(bordered ? ' bordered' : '').concat(rounded_tabs ? ' rounded' : '')
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(views).map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            k = _ref2[0],
            v = _ref2[1];

        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: k === active ? 'dazzler-view' : 'dazzler-view hidden',
          key: "".concat(identity, "-view-").concat(k)
        }, v);
      })));
    }
  }]);

  return ViewPort;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


ViewPort.defaultProps = {};
ViewPort.propTypes = {
  /**
   * The view that is active.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * A dictionary of components to render with the active key.
   */
  views: prop_types__WEBPACK_IMPORTED_MODULE_1___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * The class name of the outer div.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the outer div.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Incorporate tabs before the views.
   */
  tabbed: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Labels for the tabs otherwise the tab keys will be used.
   */
  tab_labels: prop_types__WEBPACK_IMPORTED_MODULE_1___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)),

  /**
   * Make the tabs vertical aligned.
   */
  vertical_tabs: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Round tab style
   */
  rounded_tabs: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a border around the viewport content (CSS bordered).
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss":
/*!************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss ***!
  \************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss":
/*!*********************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss ***!
  \*********************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/object-assign/index.js":
/*!*********************************************!*\
  !*** ./node_modules/object-assign/index.js ***!
  \*********************************************/
/***/ ((module) => {

"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/


/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};


/***/ }),

/***/ "./node_modules/prop-types/checkPropTypes.js":
/*!***************************************************!*\
  !*** ./node_modules/prop-types/checkPropTypes.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var printWarning = function() {};

if (true) {
  var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");
  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (true) {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error(
              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
            );
            err.name = 'Invariant Violation';
            throw err;
          }
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
        } catch (ex) {
          error = ex;
        }
        if (error && !(error instanceof Error)) {
          printWarning(
            (componentName || 'React class') + ': type specification of ' +
            location + ' `' + typeSpecName + '` is invalid; the type checker ' +
            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
            'You may have forgotten to pass an argument to the type checker ' +
            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
            'shape all require an argument).'
          );
        }
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          printWarning(
            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
          );
        }
      }
    }
  }
}

/**
 * Resets warning cache when testing.
 *
 * @private
 */
checkPropTypes.resetWarningCache = function() {
  if (true) {
    loggedTypeFailures = {};
  }
}

module.exports = checkPropTypes;


/***/ }),

/***/ "./node_modules/prop-types/factoryWithTypeCheckers.js":
/*!************************************************************!*\
  !*** ./node_modules/prop-types/factoryWithTypeCheckers.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
var assign = __webpack_require__(/*! object-assign */ "./node_modules/object-assign/index.js");

var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");
var checkPropTypes = __webpack_require__(/*! ./checkPropTypes */ "./node_modules/prop-types/checkPropTypes.js");

var has = Function.call.bind(Object.prototype.hasOwnProperty);
var printWarning = function() {};

if (true) {
  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

module.exports = function(isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (true) {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error(
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
          err.name = 'Invariant Violation';
          throw err;
        } else if ( true && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            printWarning(
              'You are manually calling a React.PropTypes validation ' +
              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!ReactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (true) {
        if (arguments.length > 1) {
          printWarning(
            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
          );
        } else {
          printWarning('Invalid argument supplied to oneOf, expected an array.');
        }
      }
      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);
        if (type === 'symbol') {
          return String(value);
        }
        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (has(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
       true ? printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') : 0;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        printWarning(
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
        );
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = assign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // falsy value can't be a Symbol
    if (!propValue) {
      return false;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes;
  ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ "./node_modules/prop-types/index.js":
/*!******************************************!*\
  !*** ./node_modules/prop-types/index.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (true) {
  var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = __webpack_require__(/*! ./factoryWithTypeCheckers */ "./node_modules/prop-types/factoryWithTypeCheckers.js")(ReactIs.isElement, throwOnDirectAccess);
} else {}


/***/ }),

/***/ "./node_modules/prop-types/lib/ReactPropTypesSecret.js":
/*!*************************************************************!*\
  !*** ./node_modules/prop-types/lib/ReactPropTypesSecret.js ***!
  \*************************************************************/
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ "./node_modules/ramda/es/any.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/any.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_xany_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xany.js */ "./node_modules/ramda/es/internal/_xany.js");




/**
 * Returns `true` if at least one of the elements of the list match the predicate,
 * `false` otherwise.
 *
 * Dispatches to the `any` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig (a -> Boolean) -> [a] -> Boolean
 * @param {Function} fn The predicate function.
 * @param {Array} list The array to consider.
 * @return {Boolean} `true` if the predicate is satisfied by at least one element, `false`
 *         otherwise.
 * @see R.all, R.none, R.transduce
 * @example
 *
 *      const lessThan0 = R.flip(R.lt)(0);
 *      const lessThan2 = R.flip(R.lt)(2);
 *      R.any(lessThan0)([1, 2]); //=> false
 *      R.any(lessThan2)([1, 2]); //=> true
 */
var any = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['any'], _internal_xany_js__WEBPACK_IMPORTED_MODULE_2__.default, function any(fn, list) {
  var idx = 0;
  while (idx < list.length) {
    if (fn(list[idx])) {
      return true;
    }
    idx += 1;
  }
  return false;
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (any);

/***/ }),

/***/ "./node_modules/ramda/es/bind.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/bind.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");



/**
 * Creates a function that is bound to a context.
 * Note: `R.bind` does not provide the additional argument-binding capabilities of
 * [Function.prototype.bind](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
 *
 * @func
 * @memberOf R
 * @since v0.6.0
 * @category Function
 * @category Object
 * @sig (* -> *) -> {*} -> (* -> *)
 * @param {Function} fn The function to bind to context
 * @param {Object} thisObj The context to bind `fn` to
 * @return {Function} A function that will execute in the context of `thisObj`.
 * @see R.partial
 * @example
 *
 *      const log = R.bind(console.log, console);
 *      R.pipe(R.assoc('a', 2), R.tap(log), R.assoc('a', 3))({a: 1}); //=> {a: 3}
 *      // logs {a: 2}
 * @symb R.bind(f, o)(a, b) = f.call(o, a, b)
 */
var bind = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function bind(fn, thisObj) {
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn.length, function () {
    return fn.apply(thisObj, arguments);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (bind);

/***/ }),

/***/ "./node_modules/ramda/es/concat.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/concat.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_isFunction.js */ "./node_modules/ramda/es/internal/_isFunction.js");
/* harmony import */ var _internal_isString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_isString.js */ "./node_modules/ramda/es/internal/_isString.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toString.js */ "./node_modules/ramda/es/toString.js");






/**
 * Returns the result of concatenating the given lists or strings.
 *
 * Note: `R.concat` expects both arguments to be of the same type,
 * unlike the native `Array.prototype.concat` method. It will throw
 * an error if you `concat` an Array with a non-Array value.
 *
 * Dispatches to the `concat` method of the first argument, if present.
 * Can also concatenate two members of a [fantasy-land
 * compatible semigroup](https://github.com/fantasyland/fantasy-land#semigroup).
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig [a] -> [a] -> [a]
 * @sig String -> String -> String
 * @param {Array|String} firstList The first list
 * @param {Array|String} secondList The second list
 * @return {Array|String} A list consisting of the elements of `firstList` followed by the elements of
 * `secondList`.
 *
 * @example
 *
 *      R.concat('ABC', 'DEF'); // 'ABCDEF'
 *      R.concat([4, 5, 6], [1, 2, 3]); //=> [4, 5, 6, 1, 2, 3]
 *      R.concat([], []); //=> []
 */
var concat = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function concat(a, b) {
  if ((0,_internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(a)) {
    if ((0,_internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(b)) {
      return a.concat(b);
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(b) + ' is not an array');
  }
  if ((0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_3__.default)(a)) {
    if ((0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_3__.default)(b)) {
      return a + b;
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(b) + ' is not a string');
  }
  if (a != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__.default)(a['fantasy-land/concat'])) {
    return a['fantasy-land/concat'](b);
  }
  if (a != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__.default)(a.concat)) {
    return a.concat(b);
  }
  throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(a) + ' does not have a method named "concat" or "fantasy-land/concat"');
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (concat);

/***/ }),

/***/ "./node_modules/ramda/es/curryN.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/curryN.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_curryN.js */ "./node_modules/ramda/es/internal/_curryN.js");





/**
 * Returns a curried equivalent of the provided function, with the specified
 * arity. The curried function has two unusual capabilities. First, its
 * arguments needn't be provided one at a time. If `g` is `R.curryN(3, f)`, the
 * following are equivalent:
 *
 *   - `g(1)(2)(3)`
 *   - `g(1)(2, 3)`
 *   - `g(1, 2)(3)`
 *   - `g(1, 2, 3)`
 *
 * Secondly, the special placeholder value [`R.__`](#__) may be used to specify
 * "gaps", allowing partial application of any combination of arguments,
 * regardless of their positions. If `g` is as above and `_` is [`R.__`](#__),
 * the following are equivalent:
 *
 *   - `g(1, 2, 3)`
 *   - `g(_, 2, 3)(1)`
 *   - `g(_, _, 3)(1)(2)`
 *   - `g(_, _, 3)(1, 2)`
 *   - `g(_, 2)(1)(3)`
 *   - `g(_, 2)(1, 3)`
 *   - `g(_, 2)(_, 3)(1)`
 *
 * @func
 * @memberOf R
 * @since v0.5.0
 * @category Function
 * @sig Number -> (* -> a) -> (* -> a)
 * @param {Number} length The arity for the returned function.
 * @param {Function} fn The function to curry.
 * @return {Function} A new, curried function.
 * @see R.curry
 * @example
 *
 *      const sumArgs = (...args) => R.sum(args);
 *
 *      const curriedAddFourNumbers = R.curryN(4, sumArgs);
 *      const f = curriedAddFourNumbers(1, 2);
 *      const g = f(3);
 *      g(4); //=> 10
 */
var curryN = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function curryN(length, fn) {
  if (length === 1) {
    return (0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn);
  }
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_2__.default)(length, (0,_internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__.default)(length, [], fn));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (curryN);

/***/ }),

/***/ "./node_modules/ramda/es/equals.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/equals.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_equals_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_equals.js */ "./node_modules/ramda/es/internal/_equals.js");



/**
 * Returns `true` if its arguments are equivalent, `false` otherwise. Handles
 * cyclical data structures.
 *
 * Dispatches symmetrically to the `equals` methods of both arguments, if
 * present.
 *
 * @func
 * @memberOf R
 * @since v0.15.0
 * @category Relation
 * @sig a -> b -> Boolean
 * @param {*} a
 * @param {*} b
 * @return {Boolean}
 * @example
 *
 *      R.equals(1, 1); //=> true
 *      R.equals(1, '1'); //=> false
 *      R.equals([1, 2, 3], [1, 2, 3]); //=> true
 *
 *      const a = {}; a.v = a;
 *      const b = {}; b.v = b;
 *      R.equals(a, b); //=> true
 */
var equals = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function equals(a, b) {
  return (0,_internal_equals_js__WEBPACK_IMPORTED_MODULE_1__.default)(a, b, [], []);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (equals);

/***/ }),

/***/ "./node_modules/ramda/es/filter.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/filter.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_filter_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./internal/_filter.js */ "./node_modules/ramda/es/internal/_filter.js");
/* harmony import */ var _internal_isObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_isObject.js */ "./node_modules/ramda/es/internal/_isObject.js");
/* harmony import */ var _internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_reduce.js */ "./node_modules/ramda/es/internal/_reduce.js");
/* harmony import */ var _internal_xfilter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xfilter.js */ "./node_modules/ramda/es/internal/_xfilter.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");








/**
 * Takes a predicate and a `Filterable`, and returns a new filterable of the
 * same type containing the members of the given filterable which satisfy the
 * given predicate. Filterable objects include plain objects or any object
 * that has a filter method such as `Array`.
 *
 * Dispatches to the `filter` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Filterable f => (a -> Boolean) -> f a -> f a
 * @param {Function} pred
 * @param {Array} filterable
 * @return {Array} Filterable
 * @see R.reject, R.transduce, R.addIndex
 * @example
 *
 *      const isEven = n => n % 2 === 0;
 *
 *      R.filter(isEven, [1, 2, 3, 4]); //=> [2, 4]
 *
 *      R.filter(isEven, {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, d: 4}
 */
var filter = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['filter'], _internal_xfilter_js__WEBPACK_IMPORTED_MODULE_2__.default, function (pred, filterable) {
  return (0,_internal_isObject_js__WEBPACK_IMPORTED_MODULE_3__.default)(filterable) ? (0,_internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__.default)(function (acc, key) {
    if (pred(filterable[key])) {
      acc[key] = filterable[key];
    }
    return acc;
  }, {}, (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(filterable)) :
  // else
  (0,_internal_filter_js__WEBPACK_IMPORTED_MODULE_6__.default)(pred, filterable);
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filter);

/***/ }),

/***/ "./node_modules/ramda/es/flip.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/flip.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");



/**
 * Returns a new function much like the supplied one, except that the first two
 * arguments' order is reversed.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig ((a, b, c, ...) -> z) -> (b -> a -> c -> ... -> z)
 * @param {Function} fn The function to invoke with its first two parameters reversed.
 * @return {*} The result of invoking `fn` with its first two parameters' order reversed.
 * @example
 *
 *      const mergeThree = (a, b, c) => [].concat(a, b, c);
 *
 *      mergeThree(1, 2, 3); //=> [1, 2, 3]
 *
 *      R.flip(mergeThree)(1, 2, 3); //=> [2, 1, 3]
 * @symb R.flip(f)(a, b, c) = f(b, a, c)
 */
var flip = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function flip(fn) {
  return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn.length, function (a, b) {
    var args = Array.prototype.slice.call(arguments, 0);
    args[0] = b;
    args[1] = a;
    return fn.apply(this, args);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (flip);

/***/ }),

/***/ "./node_modules/ramda/es/includes.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/includes.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_includes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");



/**
 * Returns `true` if the specified value is equal, in [`R.equals`](#equals)
 * terms, to at least one element of the given list; `false` otherwise.
 * Works also with strings.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig a -> [a] -> Boolean
 * @param {Object} a The item to compare against.
 * @param {Array} list The array to consider.
 * @return {Boolean} `true` if an equivalent item is in the list, `false` otherwise.
 * @see R.any
 * @example
 *
 *      R.includes(3, [1, 2, 3]); //=> true
 *      R.includes(4, [1, 2, 3]); //=> false
 *      R.includes({ name: 'Fred' }, [{ name: 'Fred' }]); //=> true
 *      R.includes([42], [[42]]); //=> true
 *      R.includes('ba', 'banana'); //=>true
 */
var includes = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(_internal_includes_js__WEBPACK_IMPORTED_MODULE_1__.default);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (includes);

/***/ }),

/***/ "./node_modules/ramda/es/insert.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/insert.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");


/**
 * Inserts the supplied element into the list, at the specified `index`. _Note that

 * this is not destructive_: it returns a copy of the list with the changes.
 * <small>No lists have been harmed in the application of this function.</small>
 *
 * @func
 * @memberOf R
 * @since v0.2.2
 * @category List
 * @sig Number -> a -> [a] -> [a]
 * @param {Number} index The position to insert the element
 * @param {*} elt The element to insert into the Array
 * @param {Array} list The list to insert into
 * @return {Array} A new Array with `elt` inserted at `index`.
 * @example
 *
 *      R.insert(2, 'x', [1,2,3,4]); //=> [1,2,'x',3,4]
 */
var insert = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)(function insert(idx, elt, list) {
  idx = idx < list.length && idx >= 0 ? idx : list.length;
  var result = Array.prototype.slice.call(list, 0);
  result.splice(idx, 0, elt);
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (insert);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_arity.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_arity.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arity)
/* harmony export */ });
function _arity(n, fn) {
  /* eslint-disable no-unused-vars */
  switch (n) {
    case 0:
      return function () {
        return fn.apply(this, arguments);
      };
    case 1:
      return function (a0) {
        return fn.apply(this, arguments);
      };
    case 2:
      return function (a0, a1) {
        return fn.apply(this, arguments);
      };
    case 3:
      return function (a0, a1, a2) {
        return fn.apply(this, arguments);
      };
    case 4:
      return function (a0, a1, a2, a3) {
        return fn.apply(this, arguments);
      };
    case 5:
      return function (a0, a1, a2, a3, a4) {
        return fn.apply(this, arguments);
      };
    case 6:
      return function (a0, a1, a2, a3, a4, a5) {
        return fn.apply(this, arguments);
      };
    case 7:
      return function (a0, a1, a2, a3, a4, a5, a6) {
        return fn.apply(this, arguments);
      };
    case 8:
      return function (a0, a1, a2, a3, a4, a5, a6, a7) {
        return fn.apply(this, arguments);
      };
    case 9:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8) {
        return fn.apply(this, arguments);
      };
    case 10:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
        return fn.apply(this, arguments);
      };
    default:
      throw new Error('First argument to _arity must be a non-negative integer no greater than ten');
  }
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_arrayFromIterator.js":
/*!**************************************************************!*\
  !*** ./node_modules/ramda/es/internal/_arrayFromIterator.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arrayFromIterator)
/* harmony export */ });
function _arrayFromIterator(iter) {
  var list = [];
  var next;
  while (!(next = iter.next()).done) {
    list.push(next.value);
  }
  return list;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_checkForMethod.js":
/*!***********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_checkForMethod.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _checkForMethod)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");


/**
 * This checks whether a function has a [methodname] function. If it isn't an
 * array it will execute that function otherwise it will default to the ramda
 * implementation.
 *
 * @private
 * @param {Function} fn ramda implemtation
 * @param {String} methodname property to check for a custom implementation
 * @return {Object} Whatever the return value of the method is.
 */
function _checkForMethod(methodname, fn) {
  return function () {
    var length = arguments.length;
    if (length === 0) {
      return fn();
    }
    var obj = arguments[length - 1];
    return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__.default)(obj) || typeof obj[methodname] !== 'function' ? fn.apply(this, arguments) : obj[methodname].apply(obj, Array.prototype.slice.call(arguments, 0, length - 1));
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_complement.js":
/*!*******************************************************!*\
  !*** ./node_modules/ramda/es/internal/_complement.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _complement)
/* harmony export */ });
function _complement(f) {
  return function () {
    return !f.apply(this, arguments);
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry1.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry1.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry1)
/* harmony export */ });
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");


/**
 * Optimized internal one-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry1(fn) {
  return function f1(a) {
    if (arguments.length === 0 || (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a)) {
      return f1;
    } else {
      return fn.apply(this, arguments);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry2.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry2.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry2)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");



/**
 * Optimized internal two-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry2(fn) {
  return function f2(a, b) {
    switch (arguments.length) {
      case 0:
        return f2;
      case 1:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? f2 : (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b) {
          return fn(a, _b);
        });
      default:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? f2 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a) {
          return fn(_a, b);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b) {
          return fn(a, _b);
        }) : fn(a, b);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry3.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry3.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry3)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");




/**
 * Optimized internal three-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry3(fn) {
  return function f3(a, b, c) {
    switch (arguments.length) {
      case 0:
        return f3;
      case 1:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? f3 : (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        });
      case 2:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_c) {
          return fn(a, b, _c);
        });
      default:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _b) {
          return fn(_a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_a) {
          return fn(_a, b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_b) {
          return fn(a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_c) {
          return fn(a, b, _c);
        }) : fn(a, b, c);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curryN.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curryN.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curryN)
/* harmony export */ });
/* harmony import */ var _arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");



/**
 * Internal curryN function.
 *
 * @private
 * @category Function
 * @param {Number} length The arity of the curried function.
 * @param {Array} received An array of arguments received thus far.
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curryN(length, received, fn) {
  return function () {
    var combined = [];
    var argsIdx = 0;
    var left = length;
    var combinedIdx = 0;
    while (combinedIdx < received.length || argsIdx < arguments.length) {
      var result;
      if (combinedIdx < received.length && (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(received[combinedIdx]) || argsIdx >= arguments.length)) {
        result = received[combinedIdx];
      } else {
        result = arguments[argsIdx];
        argsIdx += 1;
      }
      combined[combinedIdx] = result;
      if (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(result)) {
        left -= 1;
      }
      combinedIdx += 1;
    }
    return left <= 0 ? fn.apply(this, combined) : (0,_arity_js__WEBPACK_IMPORTED_MODULE_1__.default)(left, _curryN(length, combined, fn));
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_dispatchable.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_dispatchable.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _dispatchable)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _isTransformer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isTransformer.js */ "./node_modules/ramda/es/internal/_isTransformer.js");



/**
 * Returns a function that dispatches with different strategies based on the
 * object in list position (last argument). If it is an array, executes [fn].
 * Otherwise, if it has a function with one of the given method names, it will
 * execute that function (functor case). Otherwise, if it is a transformer,
 * uses transducer [xf] to return a new transformer (transducer case).
 * Otherwise, it will default to executing [fn].
 *
 * @private
 * @param {Array} methodNames properties to check for a custom implementation
 * @param {Function} xf transducer to initialize if object is transformer
 * @param {Function} fn default ramda implementation
 * @return {Function} A function that dispatches on object in list position
 */
function _dispatchable(methodNames, xf, fn) {
  return function () {
    if (arguments.length === 0) {
      return fn();
    }
    var args = Array.prototype.slice.call(arguments, 0);
    var obj = args.pop();
    if (!(0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__.default)(obj)) {
      var idx = 0;
      while (idx < methodNames.length) {
        if (typeof obj[methodNames[idx]] === 'function') {
          return obj[methodNames[idx]].apply(obj, args);
        }
        idx += 1;
      }
      if ((0,_isTransformer_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj)) {
        var transducer = xf.apply(null, args);
        return transducer(obj);
      }
    }
    return fn.apply(this, arguments);
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_equals.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_equals.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _equals)
/* harmony export */ });
/* harmony import */ var _arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_arrayFromIterator.js */ "./node_modules/ramda/es/internal/_arrayFromIterator.js");
/* harmony import */ var _includesWith_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_includesWith.js */ "./node_modules/ramda/es/internal/_includesWith.js");
/* harmony import */ var _functionName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_functionName.js */ "./node_modules/ramda/es/internal/_functionName.js");
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");
/* harmony import */ var _objectIs_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_objectIs.js */ "./node_modules/ramda/es/internal/_objectIs.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../keys.js */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var _type_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../type.js */ "./node_modules/ramda/es/type.js");








/**
 * private _uniqContentEquals function.
 * That function is checking equality of 2 iterator contents with 2 assumptions
 * - iterators lengths are the same
 * - iterators values are unique
 *
 * false-positive result will be returned for comparision of, e.g.
 * - [1,2,3] and [1,2,3,4]
 * - [1,1,1] and [1,2,3]
 * */

function _uniqContentEquals(aIterator, bIterator, stackA, stackB) {
  var a = (0,_arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__.default)(aIterator);
  var b = (0,_arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__.default)(bIterator);

  function eq(_a, _b) {
    return _equals(_a, _b, stackA.slice(), stackB.slice());
  }

  // if *a* array contains any element that is not included in *b*
  return !(0,_includesWith_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (b, aItem) {
    return !(0,_includesWith_js__WEBPACK_IMPORTED_MODULE_1__.default)(eq, aItem, b);
  }, b, a);
}

function _equals(a, b, stackA, stackB) {
  if ((0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a, b)) {
    return true;
  }

  var typeA = (0,_type_js__WEBPACK_IMPORTED_MODULE_3__.default)(a);

  if (typeA !== (0,_type_js__WEBPACK_IMPORTED_MODULE_3__.default)(b)) {
    return false;
  }

  if (a == null || b == null) {
    return false;
  }

  if (typeof a['fantasy-land/equals'] === 'function' || typeof b['fantasy-land/equals'] === 'function') {
    return typeof a['fantasy-land/equals'] === 'function' && a['fantasy-land/equals'](b) && typeof b['fantasy-land/equals'] === 'function' && b['fantasy-land/equals'](a);
  }

  if (typeof a.equals === 'function' || typeof b.equals === 'function') {
    return typeof a.equals === 'function' && a.equals(b) && typeof b.equals === 'function' && b.equals(a);
  }

  switch (typeA) {
    case 'Arguments':
    case 'Array':
    case 'Object':
      if (typeof a.constructor === 'function' && (0,_functionName_js__WEBPACK_IMPORTED_MODULE_4__.default)(a.constructor) === 'Promise') {
        return a === b;
      }
      break;
    case 'Boolean':
    case 'Number':
    case 'String':
      if (!(typeof a === typeof b && (0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a.valueOf(), b.valueOf()))) {
        return false;
      }
      break;
    case 'Date':
      if (!(0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a.valueOf(), b.valueOf())) {
        return false;
      }
      break;
    case 'Error':
      return a.name === b.name && a.message === b.message;
    case 'RegExp':
      if (!(a.source === b.source && a.global === b.global && a.ignoreCase === b.ignoreCase && a.multiline === b.multiline && a.sticky === b.sticky && a.unicode === b.unicode)) {
        return false;
      }
      break;
  }

  var idx = stackA.length - 1;
  while (idx >= 0) {
    if (stackA[idx] === a) {
      return stackB[idx] === b;
    }
    idx -= 1;
  }

  switch (typeA) {
    case 'Map':
      if (a.size !== b.size) {
        return false;
      }

      return _uniqContentEquals(a.entries(), b.entries(), stackA.concat([a]), stackB.concat([b]));
    case 'Set':
      if (a.size !== b.size) {
        return false;
      }

      return _uniqContentEquals(a.values(), b.values(), stackA.concat([a]), stackB.concat([b]));
    case 'Arguments':
    case 'Array':
    case 'Object':
    case 'Boolean':
    case 'Number':
    case 'String':
    case 'Date':
    case 'Error':
    case 'RegExp':
    case 'Int8Array':
    case 'Uint8Array':
    case 'Uint8ClampedArray':
    case 'Int16Array':
    case 'Uint16Array':
    case 'Int32Array':
    case 'Uint32Array':
    case 'Float32Array':
    case 'Float64Array':
    case 'ArrayBuffer':
      break;
    default:
      // Values of other types are only equal if identical.
      return false;
  }

  var keysA = (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(a);
  if (keysA.length !== (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(b).length) {
    return false;
  }

  var extendedStackA = stackA.concat([a]);
  var extendedStackB = stackB.concat([b]);

  idx = keysA.length - 1;
  while (idx >= 0) {
    var key = keysA[idx];
    if (!((0,_has_js__WEBPACK_IMPORTED_MODULE_6__.default)(key, b) && _equals(b[key], a[key], extendedStackA, extendedStackB))) {
      return false;
    }
    idx -= 1;
  }
  return true;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_filter.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_filter.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _filter)
/* harmony export */ });
function _filter(fn, list) {
  var idx = 0;
  var len = list.length;
  var result = [];

  while (idx < len) {
    if (fn(list[idx])) {
      result[result.length] = list[idx];
    }
    idx += 1;
  }
  return result;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_functionName.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_functionName.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _functionName)
/* harmony export */ });
function _functionName(f) {
  // String(x => x) evaluates to "x => x", so the pattern may not match.
  var match = String(f).match(/^function (\w*)/);
  return match == null ? '' : match[1];
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_has.js":
/*!************************************************!*\
  !*** ./node_modules/ramda/es/internal/_has.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _has)
/* harmony export */ });
function _has(prop, obj) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_includes.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_includes.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _includes)
/* harmony export */ });
/* harmony import */ var _indexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_indexOf.js */ "./node_modules/ramda/es/internal/_indexOf.js");


function _includes(a, list) {
  return (0,_indexOf_js__WEBPACK_IMPORTED_MODULE_0__.default)(list, a, 0) >= 0;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_includesWith.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_includesWith.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _includesWith)
/* harmony export */ });
function _includesWith(pred, x, list) {
  var idx = 0;
  var len = list.length;

  while (idx < len) {
    if (pred(x, list[idx])) {
      return true;
    }
    idx += 1;
  }
  return false;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_indexOf.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_indexOf.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _indexOf)
/* harmony export */ });
/* harmony import */ var _equals_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../equals.js */ "./node_modules/ramda/es/equals.js");


function _indexOf(list, a, idx) {
  var inf, item;
  // Array.prototype.indexOf doesn't exist below IE9
  if (typeof list.indexOf === 'function') {
    switch (typeof a) {
      case 'number':
        if (a === 0) {
          // manually crawl the list to distinguish between +0 and -0
          inf = 1 / a;
          while (idx < list.length) {
            item = list[idx];
            if (item === 0 && 1 / item === inf) {
              return idx;
            }
            idx += 1;
          }
          return -1;
        } else if (a !== a) {
          // NaN
          while (idx < list.length) {
            item = list[idx];
            if (typeof item === 'number' && item !== item) {
              return idx;
            }
            idx += 1;
          }
          return -1;
        }
        // non-zero numbers can utilise Set
        return list.indexOf(a, idx);

      // all these types can utilise Set
      case 'string':
      case 'boolean':
      case 'function':
      case 'undefined':
        return list.indexOf(a, idx);

      case 'object':
        if (a === null) {
          // null can utilise Set
          return list.indexOf(a, idx);
        }
    }
  }
  // anything else not covered above, defer to R.equals
  while (idx < list.length) {
    if ((0,_equals_js__WEBPACK_IMPORTED_MODULE_0__.default)(list[idx], a)) {
      return idx;
    }
    idx += 1;
  }
  return -1;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArguments.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArguments.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");


var toString = Object.prototype.toString;
var _isArguments = /*#__PURE__*/function () {
  return toString.call(arguments) === '[object Arguments]' ? function _isArguments(x) {
    return toString.call(x) === '[object Arguments]';
  } : function _isArguments(x) {
    return (0,_has_js__WEBPACK_IMPORTED_MODULE_0__.default)('callee', x);
  };
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isArguments);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArray.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArray.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Tests whether or not an object is an array.
 *
 * @private
 * @param {*} val The object to test.
 * @return {Boolean} `true` if `val` is an array, `false` otherwise.
 * @example
 *
 *      _isArray([]); //=> true
 *      _isArray(null); //=> false
 *      _isArray({}); //=> false
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Array.isArray || function _isArray(val) {
  return val != null && val.length >= 0 && Object.prototype.toString.call(val) === '[object Array]';
});

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArrayLike.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArrayLike.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _isString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isString.js */ "./node_modules/ramda/es/internal/_isString.js");




/**
 * Tests whether or not an object is similar to an array.
 *
 * @private
 * @category Type
 * @category List
 * @sig * -> Boolean
 * @param {*} x The object to test.
 * @return {Boolean} `true` if `x` has a numeric length property and extreme indices defined; `false` otherwise.
 * @example
 *
 *      _isArrayLike([]); //=> true
 *      _isArrayLike(true); //=> false
 *      _isArrayLike({}); //=> false
 *      _isArrayLike({length: 10}); //=> false
 *      _isArrayLike({0: 'zero', 9: 'nine', length: 10}); //=> true
 */
var _isArrayLike = /*#__PURE__*/(0,_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function isArrayLike(x) {
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(x)) {
    return true;
  }
  if (!x) {
    return false;
  }
  if (typeof x !== 'object') {
    return false;
  }
  if ((0,_isString_js__WEBPACK_IMPORTED_MODULE_2__.default)(x)) {
    return false;
  }
  if (x.nodeType === 1) {
    return !!x.length;
  }
  if (x.length === 0) {
    return true;
  }
  if (x.length > 0) {
    return x.hasOwnProperty(0) && x.hasOwnProperty(x.length - 1);
  }
  return false;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isArrayLike);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isFunction.js":
/*!*******************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isFunction.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isFunction)
/* harmony export */ });
function _isFunction(x) {
  return Object.prototype.toString.call(x) === '[object Function]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isObject.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isObject.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isObject)
/* harmony export */ });
function _isObject(x) {
  return Object.prototype.toString.call(x) === '[object Object]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isPlaceholder.js":
/*!**********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isPlaceholder.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isPlaceholder)
/* harmony export */ });
function _isPlaceholder(a) {
       return a != null && typeof a === 'object' && a['@@functional/placeholder'] === true;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isString.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isString.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isString)
/* harmony export */ });
function _isString(x) {
  return Object.prototype.toString.call(x) === '[object String]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isTransformer.js":
/*!**********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isTransformer.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isTransformer)
/* harmony export */ });
function _isTransformer(obj) {
  return obj != null && typeof obj['@@transducer/step'] === 'function';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_map.js":
/*!************************************************!*\
  !*** ./node_modules/ramda/es/internal/_map.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _map)
/* harmony export */ });
function _map(fn, functor) {
  var idx = 0;
  var len = functor.length;
  var result = Array(len);
  while (idx < len) {
    result[idx] = fn(functor[idx]);
    idx += 1;
  }
  return result;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_objectAssign.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_objectAssign.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");


// Based on https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
function _objectAssign(target) {
  if (target == null) {
    throw new TypeError('Cannot convert undefined or null to object');
  }

  var output = Object(target);
  var idx = 1;
  var length = arguments.length;
  while (idx < length) {
    var source = arguments[idx];
    if (source != null) {
      for (var nextKey in source) {
        if ((0,_has_js__WEBPACK_IMPORTED_MODULE_0__.default)(nextKey, source)) {
          output[nextKey] = source[nextKey];
        }
      }
    }
    idx += 1;
  }
  return output;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typeof Object.assign === 'function' ? Object.assign : _objectAssign);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_objectIs.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_objectIs.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Based on https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
function _objectIs(a, b) {
  // SameValue algorithm
  if (a === b) {
    // Steps 1-5, 7-10
    // Steps 6.b-6.e: +0 != -0
    return a !== 0 || 1 / a === 1 / b;
  } else {
    // Step 6.a: NaN == NaN
    return a !== a && b !== b;
  }
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typeof Object.is === 'function' ? Object.is : _objectIs);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_quote.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_quote.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _quote)
/* harmony export */ });
function _quote(s) {
  var escaped = s.replace(/\\/g, '\\\\').replace(/[\b]/g, '\\b') // \b matches word boundary; [\b] matches backspace
  .replace(/\f/g, '\\f').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/\t/g, '\\t').replace(/\v/g, '\\v').replace(/\0/g, '\\0');

  return '"' + escaped.replace(/"/g, '\\"') + '"';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_reduce.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_reduce.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _reduce)
/* harmony export */ });
/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isArrayLike.js */ "./node_modules/ramda/es/internal/_isArrayLike.js");
/* harmony import */ var _xwrap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_xwrap.js */ "./node_modules/ramda/es/internal/_xwrap.js");
/* harmony import */ var _bind_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../bind.js */ "./node_modules/ramda/es/bind.js");




function _arrayReduce(xf, acc, list) {
  var idx = 0;
  var len = list.length;
  while (idx < len) {
    acc = xf['@@transducer/step'](acc, list[idx]);
    if (acc && acc['@@transducer/reduced']) {
      acc = acc['@@transducer/value'];
      break;
    }
    idx += 1;
  }
  return xf['@@transducer/result'](acc);
}

function _iterableReduce(xf, acc, iter) {
  var step = iter.next();
  while (!step.done) {
    acc = xf['@@transducer/step'](acc, step.value);
    if (acc && acc['@@transducer/reduced']) {
      acc = acc['@@transducer/value'];
      break;
    }
    step = iter.next();
  }
  return xf['@@transducer/result'](acc);
}

function _methodReduce(xf, acc, obj, methodName) {
  return xf['@@transducer/result'](obj[methodName]((0,_bind_js__WEBPACK_IMPORTED_MODULE_0__.default)(xf['@@transducer/step'], xf), acc));
}

var symIterator = typeof Symbol !== 'undefined' ? Symbol.iterator : '@@iterator';

function _reduce(fn, acc, list) {
  if (typeof fn === 'function') {
    fn = (0,_xwrap_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn);
  }
  if ((0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_2__.default)(list)) {
    return _arrayReduce(fn, acc, list);
  }
  if (typeof list['fantasy-land/reduce'] === 'function') {
    return _methodReduce(fn, acc, list, 'fantasy-land/reduce');
  }
  if (list[symIterator] != null) {
    return _iterableReduce(fn, acc, list[symIterator]());
  }
  if (typeof list.next === 'function') {
    return _iterableReduce(fn, acc, list);
  }
  if (typeof list.reduce === 'function') {
    return _methodReduce(fn, acc, list, 'reduce');
  }

  throw new TypeError('reduce: list must be array or iterable');
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_reduced.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_reduced.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _reduced)
/* harmony export */ });
function _reduced(x) {
  return x && x['@@transducer/reduced'] ? x : {
    '@@transducer/value': x,
    '@@transducer/reduced': true
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_toISOString.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_toISOString.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Polyfill from <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString>.
 */
var pad = function pad(n) {
  return (n < 10 ? '0' : '') + n;
};

var _toISOString = typeof Date.prototype.toISOString === 'function' ? function _toISOString(d) {
  return d.toISOString();
} : function _toISOString(d) {
  return d.getUTCFullYear() + '-' + pad(d.getUTCMonth() + 1) + '-' + pad(d.getUTCDate()) + 'T' + pad(d.getUTCHours()) + ':' + pad(d.getUTCMinutes()) + ':' + pad(d.getUTCSeconds()) + '.' + (d.getUTCMilliseconds() / 1000).toFixed(3).slice(2, 5) + 'Z';
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_toISOString);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_toString.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_toString.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _toString)
/* harmony export */ });
/* harmony import */ var _includes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_map.js */ "./node_modules/ramda/es/internal/_map.js");
/* harmony import */ var _quote_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_quote.js */ "./node_modules/ramda/es/internal/_quote.js");
/* harmony import */ var _toISOString_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_toISOString.js */ "./node_modules/ramda/es/internal/_toISOString.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../keys.js */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var _reject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../reject.js */ "./node_modules/ramda/es/reject.js");







function _toString(x, seen) {
  var recur = function recur(y) {
    var xs = seen.concat([x]);
    return (0,_includes_js__WEBPACK_IMPORTED_MODULE_0__.default)(y, xs) ? '<Circular>' : _toString(y, xs);
  };

  //  mapPairs :: (Object, [String]) -> [String]
  var mapPairs = function (obj, keys) {
    return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (k) {
      return (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)(k) + ': ' + recur(obj[k]);
    }, keys.slice().sort());
  };

  switch (Object.prototype.toString.call(x)) {
    case '[object Arguments]':
      return '(function() { return arguments; }(' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(recur, x).join(', ') + '))';
    case '[object Array]':
      return '[' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(recur, x).concat(mapPairs(x, (0,_reject_js__WEBPACK_IMPORTED_MODULE_3__.default)(function (k) {
        return (/^\d+$/.test(k)
        );
      }, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__.default)(x)))).join(', ') + ']';
    case '[object Boolean]':
      return typeof x === 'object' ? 'new Boolean(' + recur(x.valueOf()) + ')' : x.toString();
    case '[object Date]':
      return 'new Date(' + (isNaN(x.valueOf()) ? recur(NaN) : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)((0,_toISOString_js__WEBPACK_IMPORTED_MODULE_5__.default)(x))) + ')';
    case '[object Null]':
      return 'null';
    case '[object Number]':
      return typeof x === 'object' ? 'new Number(' + recur(x.valueOf()) + ')' : 1 / x === -Infinity ? '-0' : x.toString(10);
    case '[object String]':
      return typeof x === 'object' ? 'new String(' + recur(x.valueOf()) + ')' : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)(x);
    case '[object Undefined]':
      return 'undefined';
    default:
      if (typeof x.toString === 'function') {
        var repr = x.toString();
        if (repr !== '[object Object]') {
          return repr;
        }
      }
      return '{' + mapPairs(x, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__.default)(x)).join(', ') + '}';
  }
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xany.js":
/*!*************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xany.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _reduced_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_reduced.js */ "./node_modules/ramda/es/internal/_reduced.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");




var XAny = /*#__PURE__*/function () {
  function XAny(f, xf) {
    this.xf = xf;
    this.f = f;
    this.any = false;
  }
  XAny.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XAny.prototype['@@transducer/result'] = function (result) {
    if (!this.any) {
      result = this.xf['@@transducer/step'](result, false);
    }
    return this.xf['@@transducer/result'](result);
  };
  XAny.prototype['@@transducer/step'] = function (result, input) {
    if (this.f(input)) {
      this.any = true;
      result = (0,_reduced_js__WEBPACK_IMPORTED_MODULE_1__.default)(this.xf['@@transducer/step'](result, true));
    }
    return result;
  };

  return XAny;
}();

var _xany = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_2__.default)(function _xany(f, xf) {
  return new XAny(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xany);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xfBase.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xfBase.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  init: function () {
    return this.xf['@@transducer/init']();
  },
  result: function (result) {
    return this.xf['@@transducer/result'](result);
  }
});

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xfilter.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xfilter.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");



var XFilter = /*#__PURE__*/function () {
  function XFilter(f, xf) {
    this.xf = xf;
    this.f = f;
  }
  XFilter.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XFilter.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.result;
  XFilter.prototype['@@transducer/step'] = function (result, input) {
    return this.f(input) ? this.xf['@@transducer/step'](result, input) : result;
  };

  return XFilter;
}();

var _xfilter = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function _xfilter(f, xf) {
  return new XFilter(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xfilter);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xmap.js":
/*!*************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xmap.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");



var XMap = /*#__PURE__*/function () {
  function XMap(f, xf) {
    this.xf = xf;
    this.f = f;
  }
  XMap.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XMap.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.result;
  XMap.prototype['@@transducer/step'] = function (result, input) {
    return this.xf['@@transducer/step'](result, this.f(input));
  };

  return XMap;
}();

var _xmap = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function _xmap(f, xf) {
  return new XMap(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xmap);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xwrap.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xwrap.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xwrap)
/* harmony export */ });
var XWrap = /*#__PURE__*/function () {
  function XWrap(fn) {
    this.f = fn;
  }
  XWrap.prototype['@@transducer/init'] = function () {
    throw new Error('init not implemented on XWrap');
  };
  XWrap.prototype['@@transducer/result'] = function (acc) {
    return acc;
  };
  XWrap.prototype['@@transducer/step'] = function (acc, x) {
    return this.f(acc, x);
  };

  return XWrap;
}();

function _xwrap(fn) {
  return new XWrap(fn);
}

/***/ }),

/***/ "./node_modules/ramda/es/invoker.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/invoker.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isFunction_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_isFunction.js */ "./node_modules/ramda/es/internal/_isFunction.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toString.js */ "./node_modules/ramda/es/toString.js");





/**
 * Turns a named method with a specified arity into a function that can be
 * called directly supplied with arguments and a target object.
 *
 * The returned function is curried and accepts `arity + 1` parameters where
 * the final parameter is the target object.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig Number -> String -> (a -> b -> ... -> n -> Object -> *)
 * @param {Number} arity Number of arguments the returned function should take
 *        before the target object.
 * @param {String} method Name of the method to call.
 * @return {Function} A new curried function.
 * @see R.construct
 * @example
 *
 *      const sliceFrom = R.invoker(1, 'slice');
 *      sliceFrom(6, 'abcdefghijklm'); //=> 'ghijklm'
 *      const sliceFrom6 = R.invoker(2, 'slice')(6);
 *      sliceFrom6(8, 'abcdefghijklm'); //=> 'gh'
 * @symb R.invoker(0, 'method')(o) = o['method']()
 * @symb R.invoker(1, 'method')(a, o) = o['method'](a)
 * @symb R.invoker(2, 'method')(a, b, o) = o['method'](a, b)
 */
var invoker = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function invoker(arity, method) {
  return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_1__.default)(arity + 1, function () {
    var target = arguments[arity];
    if (target != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_2__.default)(target[method])) {
      return target[method].apply(target, Array.prototype.slice.call(arguments, 0, arity));
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_3__.default)(target) + ' does not have a method named "' + method + '"');
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (invoker);

/***/ }),

/***/ "./node_modules/ramda/es/is.js":
/*!*************************************!*\
  !*** ./node_modules/ramda/es/is.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * See if an object (`val`) is an instance of the supplied constructor. This
 * function will check up the inheritance chain, if any.
 *
 * @func
 * @memberOf R
 * @since v0.3.0
 * @category Type
 * @sig (* -> {*}) -> a -> Boolean
 * @param {Object} ctor A constructor
 * @param {*} val The value to test
 * @return {Boolean}
 * @example
 *
 *      R.is(Object, {}); //=> true
 *      R.is(Number, 1); //=> true
 *      R.is(Object, 1); //=> false
 *      R.is(String, 's'); //=> true
 *      R.is(String, new String('')); //=> true
 *      R.is(Object, new String('')); //=> true
 *      R.is(Object, 's'); //=> false
 *      R.is(Number, {}); //=> false
 */
var is = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function is(Ctor, val) {
  return val != null && val.constructor === Ctor || val instanceof Ctor;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (is);

/***/ }),

/***/ "./node_modules/ramda/es/isNil.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/isNil.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");


/**
 * Checks if the input value is `null` or `undefined`.
 *
 * @func
 * @memberOf R
 * @since v0.9.0
 * @category Type
 * @sig * -> Boolean
 * @param {*} x The value to test.
 * @return {Boolean} `true` if `x` is `undefined` or `null`, otherwise `false`.
 * @example
 *
 *      R.isNil(null); //=> true
 *      R.isNil(undefined); //=> true
 *      R.isNil(0); //=> false
 *      R.isNil([]); //=> false
 */
var isNil = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function isNil(x) {
  return x == null;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNil);

/***/ }),

/***/ "./node_modules/ramda/es/join.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/join.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _invoker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./invoker.js */ "./node_modules/ramda/es/invoker.js");


/**
 * Returns a string made by inserting the `separator` between each element and
 * concatenating all the elements into a single string.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig String -> [a] -> String
 * @param {Number|String} separator The string used to separate the elements.
 * @param {Array} xs The elements to join into a string.
 * @return {String} str The string made by concatenating `xs` with `separator`.
 * @see R.split
 * @example
 *
 *      const spacer = R.join(' ');
 *      spacer(['a', 2, 3.4]);   //=> 'a 2 3.4'
 *      R.join('|', [1, 2, 3]);    //=> '1|2|3'
 */
var join = /*#__PURE__*/(0,_invoker_js__WEBPACK_IMPORTED_MODULE_0__.default)(1, 'join');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (join);

/***/ }),

/***/ "./node_modules/ramda/es/keys.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/keys.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_has_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_has.js */ "./node_modules/ramda/es/internal/_has.js");
/* harmony import */ var _internal_isArguments_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isArguments.js */ "./node_modules/ramda/es/internal/_isArguments.js");




// cover IE < 9 keys issues
var hasEnumBug = ! /*#__PURE__*/{ toString: null }.propertyIsEnumerable('toString');
var nonEnumerableProps = ['constructor', 'valueOf', 'isPrototypeOf', 'toString', 'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];
// Safari bug
var hasArgsEnumBug = /*#__PURE__*/function () {
  'use strict';

  return arguments.propertyIsEnumerable('length');
}();

var contains = function contains(list, item) {
  var idx = 0;
  while (idx < list.length) {
    if (list[idx] === item) {
      return true;
    }
    idx += 1;
  }
  return false;
};

/**
 * Returns a list containing the names of all the enumerable own properties of
 * the supplied object.
 * Note that the order of the output array is not guaranteed to be consistent
 * across different JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig {k: v} -> [k]
 * @param {Object} obj The object to extract properties from
 * @return {Array} An array of the object's own properties.
 * @see R.keysIn, R.values
 * @example
 *
 *      R.keys({a: 1, b: 2, c: 3}); //=> ['a', 'b', 'c']
 */
var keys = typeof Object.keys === 'function' && !hasArgsEnumBug ? /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function keys(obj) {
  return Object(obj) !== obj ? [] : Object.keys(obj);
}) : /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function keys(obj) {
  if (Object(obj) !== obj) {
    return [];
  }
  var prop, nIdx;
  var ks = [];
  var checkArgsLength = hasArgsEnumBug && (0,_internal_isArguments_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj);
  for (prop in obj) {
    if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_2__.default)(prop, obj) && (!checkArgsLength || prop !== 'length')) {
      ks[ks.length] = prop;
    }
  }
  if (hasEnumBug) {
    nIdx = nonEnumerableProps.length - 1;
    while (nIdx >= 0) {
      prop = nonEnumerableProps[nIdx];
      if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_2__.default)(prop, obj) && !contains(ks, prop)) {
        ks[ks.length] = prop;
      }
      nIdx -= 1;
    }
  }
  return ks;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (keys);

/***/ }),

/***/ "./node_modules/ramda/es/last.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/last.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _nth_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./nth.js */ "./node_modules/ramda/es/nth.js");


/**
 * Returns the last element of the given list or string.
 *
 * @func
 * @memberOf R
 * @since v0.1.4
 * @category List
 * @sig [a] -> a | Undefined
 * @sig String -> String
 * @param {*} list
 * @return {*}
 * @see R.init, R.head, R.tail
 * @example
 *
 *      R.last(['fi', 'fo', 'fum']); //=> 'fum'
 *      R.last([]); //=> undefined
 *
 *      R.last('abc'); //=> 'c'
 *      R.last(''); //=> ''
 */
var last = /*#__PURE__*/(0,_nth_js__WEBPACK_IMPORTED_MODULE_0__.default)(-1);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (last);

/***/ }),

/***/ "./node_modules/ramda/es/map.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/map.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./internal/_map.js */ "./node_modules/ramda/es/internal/_map.js");
/* harmony import */ var _internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_reduce.js */ "./node_modules/ramda/es/internal/_reduce.js");
/* harmony import */ var _internal_xmap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xmap.js */ "./node_modules/ramda/es/internal/_xmap.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");








/**
 * Takes a function and
 * a [functor](https://github.com/fantasyland/fantasy-land#functor),
 * applies the function to each of the functor's values, and returns
 * a functor of the same shape.
 *
 * Ramda provides suitable `map` implementations for `Array` and `Object`,
 * so this function may be applied to `[1, 2, 3]` or `{x: 1, y: 2, z: 3}`.
 *
 * Dispatches to the `map` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * Also treats functions as functors and will compose them together.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Functor f => (a -> b) -> f a -> f b
 * @param {Function} fn The function to be called on every element of the input `list`.
 * @param {Array} list The list to be iterated over.
 * @return {Array} The new list.
 * @see R.transduce, R.addIndex
 * @example
 *
 *      const double = x => x * 2;
 *
 *      R.map(double, [1, 2, 3]); //=> [2, 4, 6]
 *
 *      R.map(double, {x: 1, y: 2, z: 3}); //=> {x: 2, y: 4, z: 6}
 * @symb R.map(f, [a, b]) = [f(a), f(b)]
 * @symb R.map(f, { x: a, y: b }) = { x: f(a), y: f(b) }
 * @symb R.map(f, functor_o) = functor_o.map(f)
 */
var map = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['fantasy-land/map', 'map'], _internal_xmap_js__WEBPACK_IMPORTED_MODULE_2__.default, function map(fn, functor) {
  switch (Object.prototype.toString.call(functor)) {
    case '[object Function]':
      return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_3__.default)(functor.length, function () {
        return fn.call(this, functor.apply(this, arguments));
      });
    case '[object Object]':
      return (0,_internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__.default)(function (acc, key) {
        acc[key] = fn(functor[key]);
        return acc;
      }, {}, (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(functor));
    default:
      return (0,_internal_map_js__WEBPACK_IMPORTED_MODULE_6__.default)(fn, functor);
  }
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (map);

/***/ }),

/***/ "./node_modules/ramda/es/mergeAll.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/mergeAll.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_objectAssign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_objectAssign.js */ "./node_modules/ramda/es/internal/_objectAssign.js");
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");



/**
 * Merges a list of objects together into one object.
 *
 * @func
 * @memberOf R
 * @since v0.10.0
 * @category List
 * @sig [{k: v}] -> {k: v}
 * @param {Array} list An array of objects
 * @return {Object} A merged object.
 * @see R.reduce
 * @example
 *
 *      R.mergeAll([{foo:1},{bar:2},{baz:3}]); //=> {foo:1,bar:2,baz:3}
 *      R.mergeAll([{foo:1},{foo:2},{bar:2}]); //=> {foo:2,bar:2}
 * @symb R.mergeAll([{ x: 1 }, { y: 2 }, { z: 3 }]) = { x: 1, y: 2, z: 3 }
 */
var mergeAll = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function mergeAll(list) {
  return _internal_objectAssign_js__WEBPACK_IMPORTED_MODULE_1__.default.apply(null, [{}].concat(list));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mergeAll);

/***/ }),

/***/ "./node_modules/ramda/es/nth.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/nth.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isString.js */ "./node_modules/ramda/es/internal/_isString.js");



/**
 * Returns the nth element of the given list or string. If n is negative the
 * element at index length + n is returned.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Number -> [a] -> a | Undefined
 * @sig Number -> String -> String
 * @param {Number} offset
 * @param {*} list
 * @return {*}
 * @example
 *
 *      const list = ['foo', 'bar', 'baz', 'quux'];
 *      R.nth(1, list); //=> 'bar'
 *      R.nth(-1, list); //=> 'quux'
 *      R.nth(-99, list); //=> undefined
 *
 *      R.nth(2, 'abc'); //=> 'c'
 *      R.nth(3, 'abc'); //=> ''
 * @symb R.nth(-1, [a, b, c]) = c
 * @symb R.nth(0, [a, b, c]) = a
 * @symb R.nth(1, [a, b, c]) = b
 */
var nth = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function nth(offset, list) {
  var idx = offset < 0 ? list.length + offset : offset;
  return (0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_1__.default)(list) ? list.charAt(idx) : list[idx];
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (nth);

/***/ }),

/***/ "./node_modules/ramda/es/omit.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/omit.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * Returns a partial copy of an object omitting the keys specified.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig [String] -> {String: *} -> {String: *}
 * @param {Array} names an array of String property names to omit from the new object
 * @param {Object} obj The object to copy from
 * @return {Object} A new object with properties from `names` not on it.
 * @see R.pick
 * @example
 *
 *      R.omit(['a', 'd'], {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, c: 3}
 */
var omit = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function omit(names, obj) {
  var result = {};
  var index = {};
  var idx = 0;
  var len = names.length;

  while (idx < len) {
    index[names[idx]] = 1;
    idx += 1;
  }

  for (var prop in obj) {
    if (!index.hasOwnProperty(prop)) {
      result[prop] = obj[prop];
    }
  }
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (omit);

/***/ }),

/***/ "./node_modules/ramda/es/path.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/path.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * Retrieve the value at a given path.
 *
 * @func
 * @memberOf R
 * @since v0.2.0
 * @category Object
 * @typedefn Idx = String | Int
 * @sig [Idx] -> {a} -> a | Undefined
 * @param {Array} path The path to use.
 * @param {Object} obj The object to retrieve the nested property from.
 * @return {*} The data at `path`.
 * @see R.prop
 * @example
 *
 *      R.path(['a', 'b'], {a: {b: 2}}); //=> 2
 *      R.path(['a', 'b'], {c: {b: 2}}); //=> undefined
 */
var path = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function path(paths, obj) {
  var val = obj;
  var idx = 0;
  while (idx < paths.length) {
    if (val == null) {
      return;
    }
    val = val[paths[idx]];
    idx += 1;
  }
  return val;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (path);

/***/ }),

/***/ "./node_modules/ramda/es/pluck.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/pluck.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./map.js */ "./node_modules/ramda/es/map.js");
/* harmony import */ var _prop_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./prop.js */ "./node_modules/ramda/es/prop.js");




/**
 * Returns a new list by plucking the same named property off all objects in
 * the list supplied.
 *
 * `pluck` will work on
 * any [functor](https://github.com/fantasyland/fantasy-land#functor) in
 * addition to arrays, as it is equivalent to `R.map(R.prop(k), f)`.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Functor f => k -> f {k: v} -> f v
 * @param {Number|String} key The key name to pluck off of each object.
 * @param {Array} f The array or functor to consider.
 * @return {Array} The list of values for the given key.
 * @see R.props
 * @example
 *
 *      var getAges = R.pluck('age');
 *      getAges([{name: 'fred', age: 29}, {name: 'wilma', age: 27}]); //=> [29, 27]
 *
 *      R.pluck(0, [[1, 2], [3, 4]]);               //=> [1, 3]
 *      R.pluck('val', {a: {val: 3}, b: {val: 5}}); //=> {a: 3, b: 5}
 * @symb R.pluck('x', [{x: 1, y: 2}, {x: 3, y: 4}, {x: 5, y: 6}]) = [1, 3, 5]
 * @symb R.pluck(0, [[1, 2], [3, 4], [5, 6]]) = [1, 3, 5]
 */
var pluck = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function pluck(p, list) {
  return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_prop_js__WEBPACK_IMPORTED_MODULE_2__.default)(p), list);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pluck);

/***/ }),

/***/ "./node_modules/ramda/es/prop.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/prop.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./path.js */ "./node_modules/ramda/es/path.js");



/**
 * Returns a function that when supplied an object returns the indicated
 * property of that object, if it exists.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig s -> {s: a} -> a | Undefined
 * @param {String} p The property name
 * @param {Object} obj The object to query
 * @return {*} The value at `obj.p`.
 * @see R.path
 * @example
 *
 *      R.prop('x', {x: 100}); //=> 100
 *      R.prop('x', {}); //=> undefined
 *      R.compose(R.inc, R.prop('x'))({ x: 3 }) //=> 4
 */

var prop = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function prop(p, obj) {
  return (0,_path_js__WEBPACK_IMPORTED_MODULE_1__.default)([p], obj);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prop);

/***/ }),

/***/ "./node_modules/ramda/es/reject.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/reject.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_complement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_complement.js */ "./node_modules/ramda/es/internal/_complement.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filter.js */ "./node_modules/ramda/es/filter.js");




/**
 * The complement of [`filter`](#filter).
 *
 * Acts as a transducer if a transformer is given in list position. Filterable
 * objects include plain objects or any object that has a filter method such
 * as `Array`.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Filterable f => (a -> Boolean) -> f a -> f a
 * @param {Function} pred
 * @param {Array} filterable
 * @return {Array}
 * @see R.filter, R.transduce, R.addIndex
 * @example
 *
 *      const isOdd = (n) => n % 2 === 1;
 *
 *      R.reject(isOdd, [1, 2, 3, 4]); //=> [2, 4]
 *
 *      R.reject(isOdd, {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, d: 4}
 */
var reject = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function reject(pred, filterable) {
  return (0,_filter_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_internal_complement_js__WEBPACK_IMPORTED_MODULE_2__.default)(pred), filterable);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reject);

/***/ }),

/***/ "./node_modules/ramda/es/remove.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/remove.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");


/**
 * Removes the sub-list of `list` starting at index `start` and containing
 * `count` elements. _Note that this is not destructive_: it returns a copy of
 * the list with the changes.
 * <small>No lists have been harmed in the application of this function.</small>
 *
 * @func
 * @memberOf R
 * @since v0.2.2
 * @category List
 * @sig Number -> Number -> [a] -> [a]
 * @param {Number} start The position to start removing elements
 * @param {Number} count The number of elements to remove
 * @param {Array} list The list to remove from
 * @return {Array} A new Array with `count` elements from `start` removed.
 * @see R.without
 * @example
 *
 *      R.remove(2, 3, [1,2,3,4,5,6,7,8]); //=> [1,2,6,7,8]
 */
var remove = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)(function remove(start, count, list) {
  var result = Array.prototype.slice.call(list, 0);
  result.splice(start, count);
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (remove);

/***/ }),

/***/ "./node_modules/ramda/es/slice.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/slice.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_checkForMethod_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_checkForMethod.js */ "./node_modules/ramda/es/internal/_checkForMethod.js");
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");



/**
 * Returns the elements of the given list or string (or object with a `slice`
 * method) from `fromIndex` (inclusive) to `toIndex` (exclusive).
 *
 * Dispatches to the `slice` method of the third argument, if present.
 *
 * @func
 * @memberOf R
 * @since v0.1.4
 * @category List
 * @sig Number -> Number -> [a] -> [a]
 * @sig Number -> Number -> String -> String
 * @param {Number} fromIndex The start index (inclusive).
 * @param {Number} toIndex The end index (exclusive).
 * @param {*} list
 * @return {*}
 * @example
 *
 *      R.slice(1, 3, ['a', 'b', 'c', 'd']);        //=> ['b', 'c']
 *      R.slice(1, Infinity, ['a', 'b', 'c', 'd']); //=> ['b', 'c', 'd']
 *      R.slice(0, -1, ['a', 'b', 'c', 'd']);       //=> ['a', 'b', 'c']
 *      R.slice(-3, -1, ['a', 'b', 'c', 'd']);      //=> ['b', 'c']
 *      R.slice(0, 3, 'ramda');                     //=> 'ram'
 */
var slice = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_checkForMethod_js__WEBPACK_IMPORTED_MODULE_1__.default)('slice', function slice(fromIndex, toIndex, list) {
  return Array.prototype.slice.call(list, fromIndex, toIndex);
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (slice);

/***/ }),

/***/ "./node_modules/ramda/es/toPairs.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/toPairs.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_has_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_has.js */ "./node_modules/ramda/es/internal/_has.js");



/**
 * Converts an object into an array of key, value arrays. Only the object's
 * own properties are used.
 * Note that the order of the output array is not guaranteed to be consistent
 * across different JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.4.0
 * @category Object
 * @sig {String: *} -> [[String,*]]
 * @param {Object} obj The object to extract from
 * @return {Array} An array of key, value arrays from the object's own properties.
 * @see R.fromPairs
 * @example
 *
 *      R.toPairs({a: 1, b: 2, c: 3}); //=> [['a', 1], ['b', 2], ['c', 3]]
 */
var toPairs = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function toPairs(obj) {
  var pairs = [];
  for (var prop in obj) {
    if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_1__.default)(prop, obj)) {
      pairs[pairs.length] = [prop, obj[prop]];
    }
  }
  return pairs;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toPairs);

/***/ }),

/***/ "./node_modules/ramda/es/toString.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/toString.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_toString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_toString.js */ "./node_modules/ramda/es/internal/_toString.js");



/**
 * Returns the string representation of the given value. `eval`'ing the output
 * should result in a value equivalent to the input value. Many of the built-in
 * `toString` methods do not satisfy this requirement.
 *
 * If the given value is an `[object Object]` with a `toString` method other
 * than `Object.prototype.toString`, this method is invoked with no arguments
 * to produce the return value. This means user-defined constructor functions
 * can provide a suitable `toString` method. For example:
 *
 *     function Point(x, y) {
 *       this.x = x;
 *       this.y = y;
 *     }
 *
 *     Point.prototype.toString = function() {
 *       return 'new Point(' + this.x + ', ' + this.y + ')';
 *     };
 *
 *     R.toString(new Point(1, 2)); //=> 'new Point(1, 2)'
 *
 * @func
 * @memberOf R
 * @since v0.14.0
 * @category String
 * @sig * -> String
 * @param {*} val
 * @return {String}
 * @example
 *
 *      R.toString(42); //=> '42'
 *      R.toString('abc'); //=> '"abc"'
 *      R.toString([1, 2, 3]); //=> '[1, 2, 3]'
 *      R.toString({foo: 1, bar: 2, baz: 3}); //=> '{"bar": 2, "baz": 3, "foo": 1}'
 *      R.toString(new Date('2001-02-03T04:05:06Z')); //=> 'new Date("2001-02-03T04:05:06.000Z")'
 */
var toString = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function toString(val) {
  return (0,_internal_toString_js__WEBPACK_IMPORTED_MODULE_1__.default)(val, []);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toString);

/***/ }),

/***/ "./node_modules/ramda/es/type.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/type.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");


/**
 * Gives a single-word string description of the (native) type of a value,
 * returning such answers as 'Object', 'Number', 'Array', or 'Null'. Does not
 * attempt to distinguish user Object types any further, reporting them all as
 * 'Object'.
 *
 * @func
 * @memberOf R
 * @since v0.8.0
 * @category Type
 * @sig (* -> {*}) -> String
 * @param {*} val The value to test
 * @return {String}
 * @example
 *
 *      R.type({}); //=> "Object"
 *      R.type(1); //=> "Number"
 *      R.type(false); //=> "Boolean"
 *      R.type('s'); //=> "String"
 *      R.type(null); //=> "Null"
 *      R.type([]); //=> "Array"
 *      R.type(/[A-z]/); //=> "RegExp"
 *      R.type(() => {}); //=> "Function"
 *      R.type(undefined); //=> "Undefined"
 */
var type = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function type(val) {
  return val === null ? 'Null' : val === undefined ? 'Undefined' : Object.prototype.toString.call(val).slice(8, -1);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (type);

/***/ }),

/***/ "./node_modules/ramda/es/values.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/values.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");



/**
 * Returns a list of all the enumerable own properties of the supplied object.
 * Note that the order of the output array is not guaranteed across different
 * JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig {k: v} -> [v]
 * @param {Object} obj The object to extract values from
 * @return {Array} An array of the values of the object's own properties.
 * @see R.valuesIn, R.keys
 * @example
 *
 *      R.values({a: 1, b: 2, c: 3}); //=> [1, 2, 3]
 */
var values = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function values(obj) {
  var props = (0,_keys_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj);
  var len = props.length;
  var vals = [];
  var idx = 0;
  while (idx < len) {
    vals[idx] = obj[props[idx]];
    idx += 1;
  }
  return vals;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (values);

/***/ }),

/***/ "./node_modules/ramda/es/without.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/without.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./flip.js */ "./node_modules/ramda/es/flip.js");
/* harmony import */ var _reject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reject.js */ "./node_modules/ramda/es/reject.js");





/**
 * Returns a new list without values in the first argument.
 * [`R.equals`](#equals) is used to determine equality.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.19.0
 * @category List
 * @sig [a] -> [a] -> [a]
 * @param {Array} list1 The values to be removed from `list2`.
 * @param {Array} list2 The array to remove values from.
 * @return {Array} The new array without values in `list1`.
 * @see R.transduce, R.difference, R.remove
 * @example
 *
 *      R.without([1, 2], [1, 2, 1, 3, 4]); //=> [3, 4]
 */
var without = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function (xs, list) {
  return (0,_reject_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_flip_js__WEBPACK_IMPORTED_MODULE_2__.default)(_internal_includes_js__WEBPACK_IMPORTED_MODULE_3__.default)(xs), list);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (without);

/***/ }),

/***/ "./node_modules/react-is/cjs/react-is.development.js":
/*!***********************************************************!*\
  !*** ./node_modules/react-is/cjs/react-is.development.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/** @license React v16.8.6
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */





if (true) {
  (function() {
'use strict';

Object.defineProperty(exports, "__esModule", ({ value: true }));

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;

var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;
var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' ||
  // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE);
}

/**
 * Forked from fbjs/warning:
 * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
 *
 * Only change is we use console.warn instead of console.error,
 * and do nothing when 'console' is not supported.
 * This really simplifies the code.
 * ---
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var lowPriorityWarning = function () {};

{
  var printWarning = function (format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });
    if (typeof console !== 'undefined') {
      console.warn(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  lowPriorityWarning = function (condition, format) {
    if (format === undefined) {
      throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');
    }
    if (!condition) {
      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(undefined, [format].concat(args));
    }
  };
}

var lowPriorityWarning$1 = lowPriorityWarning;

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;
    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;
          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;
              default:
                return $$typeof;
            }
        }
      case REACT_LAZY_TYPE:
      case REACT_MEMO_TYPE:
      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
}

// AsyncMode is deprecated along with isAsyncMode
var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;

var hasWarnedAboutDeprecatedIsAsyncMode = false;

// AsyncMode should be deprecated
function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true;
      lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }
  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.typeOf = typeOf;
exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isValidElementType = isValidElementType;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
  })();
}


/***/ }),

/***/ "./node_modules/react-is/index.js":
/*!****************************************!*\
  !*** ./node_modules/react-is/index.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "./node_modules/react-is/cjs/react-is.development.js");
}


/***/ }),

/***/ "./src/commons/scss/index.scss":
/*!*************************************!*\
  !*** ./src/commons/scss/index.scss ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var content = __webpack_require__(/*! !!../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js!./index.scss */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss");

if(typeof content === 'string') content = [[module.id, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(/*! !../../../node_modules/style-loader/lib/addStyles.js */ "./node_modules/style-loader/lib/addStyles.js")(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),

/***/ "./src/core/scss/index.scss":
/*!**********************************!*\
  !*** ./src/core/scss/index.scss ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var content = __webpack_require__(/*! !!../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js!./index.scss */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss");

if(typeof content === 'string') content = [[module.id, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(/*! !../../../node_modules/style-loader/lib/addStyles.js */ "./node_modules/style-loader/lib/addStyles.js")(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),

/***/ "./node_modules/style-loader/lib/addStyles.js":
/*!****************************************************!*\
  !*** ./node_modules/style-loader/lib/addStyles.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getTarget = function (target, parent) {
  if (parent){
    return parent.querySelector(target);
  }
  return document.querySelector(target);
};

var getElement = (function (fn) {
	var memo = {};

	return function(target, parent) {
                // If passing function in options, then use it for resolve "head" element.
                // Useful for Shadow Root style i.e
                // {
                //   insertInto: function () { return document.querySelector("#foo").shadowRoot }
                // }
                if (typeof target === 'function') {
                        return target();
                }
                if (typeof memo[target] === "undefined") {
			var styleTarget = getTarget.call(this, target, parent);
			// Special case to return head of iframe instead of iframe itself
			if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[target] = styleTarget;
		}
		return memo[target]
	};
})();

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(/*! ./urls */ "./node_modules/style-loader/lib/urls.js");

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
        if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertAt.before, target);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}

	if(options.attrs.nonce === undefined) {
		var nonce = getNonce();
		if (nonce) {
			options.attrs.nonce = nonce;
		}
	}

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function getNonce() {
	if (false) {}

	return __webpack_require__.nc;
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = typeof options.transform === 'function'
		 ? options.transform(obj.css) 
		 : options.transform.default(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ "./node_modules/style-loader/lib/urls.js":
/*!***********************************************!*\
  !*** ./node_modules/style-loader/lib/urls.js ***!
  \***********************************************/
/***/ ((module) => {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ "react":
/*!****************************************************************************************************!*\
  !*** external {"commonjs":"react","commonjs2":"react","amd":"react","umd":"react","root":"React"} ***!
  \****************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = __WEBPACK_EXTERNAL_MODULE_react__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!******************************!*\
  !*** ./src/core/js/index.js ***!
  \******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Container": () => (/* reexport safe */ _components_Container__WEBPACK_IMPORTED_MODULE_1__.default),
/* harmony export */   "DataList": () => (/* reexport safe */ _components_DataList__WEBPACK_IMPORTED_MODULE_2__.default),
/* harmony export */   "Html": () => (/* reexport safe */ _components_Html__WEBPACK_IMPORTED_MODULE_6__.default),
/* harmony export */   "Link": () => (/* reexport safe */ _components_Link__WEBPACK_IMPORTED_MODULE_10__.default),
/* harmony export */   "Input": () => (/* reexport safe */ _components_Input__WEBPACK_IMPORTED_MODULE_3__.default),
/* harmony export */   "Interval": () => (/* reexport safe */ _components_Interval__WEBPACK_IMPORTED_MODULE_4__.default),
/* harmony export */   "Store": () => (/* reexport safe */ _components_Store__WEBPACK_IMPORTED_MODULE_5__.default),
/* harmony export */   "Select": () => (/* reexport safe */ _components_Select__WEBPACK_IMPORTED_MODULE_7__.default),
/* harmony export */   "RadioList": () => (/* reexport safe */ _components_RadioList__WEBPACK_IMPORTED_MODULE_8__.default),
/* harmony export */   "CheckList": () => (/* reexport safe */ _components_CheckList__WEBPACK_IMPORTED_MODULE_9__.default),
/* harmony export */   "ProgressBar": () => (/* reexport safe */ _components_ProgressBar__WEBPACK_IMPORTED_MODULE_11__.default),
/* harmony export */   "ViewPort": () => (/* reexport safe */ _components_ViewPort__WEBPACK_IMPORTED_MODULE_12__.default),
/* harmony export */   "Button": () => (/* reexport safe */ _components_Button__WEBPACK_IMPORTED_MODULE_13__.default),
/* harmony export */   "Slider": () => (/* reexport safe */ _components_Slider__WEBPACK_IMPORTED_MODULE_14__.default),
/* harmony export */   "Image": () => (/* reexport safe */ _components_Image__WEBPACK_IMPORTED_MODULE_15__.default),
/* harmony export */   "Modal": () => (/* reexport safe */ _components_Modal__WEBPACK_IMPORTED_MODULE_16__.default),
/* harmony export */   "TextArea": () => (/* reexport safe */ _components_TextArea__WEBPACK_IMPORTED_MODULE_17__.default),
/* harmony export */   "Table": () => (/* reexport safe */ _components_Table__WEBPACK_IMPORTED_MODULE_18__.default),
/* harmony export */   "Grid": () => (/* reexport safe */ _components_Grid__WEBPACK_IMPORTED_MODULE_19__.default),
/* harmony export */   "Form": () => (/* reexport safe */ _components_Form__WEBPACK_IMPORTED_MODULE_20__.default),
/* harmony export */   "ListBox": () => (/* reexport safe */ _components_ListBox__WEBPACK_IMPORTED_MODULE_21__.default),
/* harmony export */   "Dropdown": () => (/* reexport safe */ _components_Dropdown__WEBPACK_IMPORTED_MODULE_22__.default)
/* harmony export */ });
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scss/index.scss */ "./src/core/scss/index.scss");
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_scss_index_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/Container */ "./src/core/js/components/Container.jsx");
/* harmony import */ var _components_DataList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/DataList */ "./src/core/js/components/DataList.jsx");
/* harmony import */ var _components_Input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/Input */ "./src/core/js/components/Input.jsx");
/* harmony import */ var _components_Interval__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Interval */ "./src/core/js/components/Interval.jsx");
/* harmony import */ var _components_Store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/Store */ "./src/core/js/components/Store.jsx");
/* harmony import */ var _components_Html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/Html */ "./src/core/js/components/Html.jsx");
/* harmony import */ var _components_Select__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/Select */ "./src/core/js/components/Select.jsx");
/* harmony import */ var _components_RadioList__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/RadioList */ "./src/core/js/components/RadioList.jsx");
/* harmony import */ var _components_CheckList__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/CheckList */ "./src/core/js/components/CheckList.jsx");
/* harmony import */ var _components_Link__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/Link */ "./src/core/js/components/Link.jsx");
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/ProgressBar */ "./src/core/js/components/ProgressBar.jsx");
/* harmony import */ var _components_ViewPort__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./components/ViewPort */ "./src/core/js/components/ViewPort.jsx");
/* harmony import */ var _components_Button__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./components/Button */ "./src/core/js/components/Button.jsx");
/* harmony import */ var _components_Slider__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/Slider */ "./src/core/js/components/Slider.jsx");
/* harmony import */ var _components_Image__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./components/Image */ "./src/core/js/components/Image.jsx");
/* harmony import */ var _components_Modal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./components/Modal */ "./src/core/js/components/Modal.jsx");
/* harmony import */ var _components_TextArea__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./components/TextArea */ "./src/core/js/components/TextArea.jsx");
/* harmony import */ var _components_Table__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./components/Table */ "./src/core/js/components/Table.jsx");
/* harmony import */ var _components_Grid__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./components/Grid */ "./src/core/js/components/Grid.jsx");
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./components/Form */ "./src/core/js/components/Form.jsx");
/* harmony import */ var _components_ListBox__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./components/ListBox */ "./src/core/js/components/ListBox.jsx");
/* harmony import */ var _components_Dropdown__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./components/Dropdown */ "./src/core/js/components/Dropdown.jsx");
























})();

/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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