"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class Dropdown(Component):
    """
    A dropdown to select options from a list.

    :CSS:

        - ``dazzler-core-dropdown``
        - ``drop-toggle``
        - ``drop-symbol``
        - ``drop-container``
        - ``drop-item``
        - ``drop-selected-item``
        - ``selected``
        - ``selected-items``
        - ``selected-label``
        - ``selected-remover``
        - ``no-results``
        - ``search-content``
        - ``dropdown-search-input``
        - ``drop-controls``

    :Example:

    .. code-block:: python3

         from dazzler.components.core import Dropdown

         dropdown = Dropdown(
             {'label': 'Option 1', 'value': 1},
                {'label': 'Option 2', 'value': 2}
         )
    """
    _aspect_keys = []
    _children = []
    options = Aspect(required=True, children=True, docstring="List of options to choose/search from.")  # noqa: E501
    value = Aspect(docstring="Currently selected value(s).")
    multi = Aspect(docstring="Allow multiple values to be chosen, the value become a list of values.")  # noqa: E501
    searchable = Aspect(docstring="If true, render an input")
    search_value = Aspect(default='', docstring="Value entered by user to search options. (default='')")  # noqa: E501
    search_props = Aspect(docstring="Keys to filter on searching the options.- Leave empty for all props.- Valid values types to search on are strings & arrays.- Nested prop access with dot notation.")  # noqa: E501
    search_label = Aspect(docstring="Search the label along with the value.")
    search_backend = Aspect(docstring="Do not perform any search on the options from the frontend and insteadrelies on binding the ``search_value`` to filter and set the``filtered_options`` aspect.")  # noqa: E501
    filtered_options = Aspect(default=UNDEFINED, docstring="Array of options that are filtered, set from backend with search (default=null)")  # noqa: E501
    opened = Aspect(default=False, docstring="Is the dropdown currently open ? (default=False)")  # noqa: E501
    no_results_label = Aspect(default=UNDEFINED, children=True, docstring="Label to use when no search results are available.")  # noqa: E501
    toggle_symbol = Aspect(default='⏷', docstring="Unicode character used as the toggle button. (default='⏷')")  # noqa: E501
    scrollable = Aspect(docstring="Make the menu scrollable.")
    scroll_max_size = Aspect()
    class_name = Aspect()
    style = Aspect()

    def __init__(
            self,
            options: typing.List[typing.Union[typing.Dict[str, typing.Union[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]], typing.Union[str, typing.Union[float, int], typing.Dict], typing.Dict, str]], str]],  # noqa: E501
            value: typing.Optional[typing.Union[str, typing.List, typing.Union[float, int], typing.Dict]] = UNDEFINED,  # noqa: E501
            multi: typing.Optional[bool] = UNDEFINED,
            searchable: typing.Optional[bool] = UNDEFINED,
            search_value: typing.Optional[str] = '',
            search_props: typing.Optional[typing.List[str]] = UNDEFINED,
            search_label: typing.Optional[bool] = UNDEFINED,
            search_backend: typing.Optional[bool] = UNDEFINED,
            filtered_options: typing.Optional[typing.List] = UNDEFINED,
            opened: typing.Optional[bool] = False,
            no_results_label: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            toggle_symbol: typing.Optional[str] = '⏷',
            scrollable: typing.Optional[bool] = UNDEFINED,
            scroll_max_size: typing.Optional[typing.Union[float, int]] = UNDEFINED,  # noqa: E501
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            identity: str = None
    ):
        """
        :param options: List of options to choose/search from.
        :param value: Currently selected value(s).
        :param multi: Allow multiple values to be chosen, the value become
            a list of values.
        :param searchable: If true, render an input
        :param search_value: Value entered by user to search options.
            (default='')
        :param search_props: Keys to filter on searching the options.  -
            Leave empty for all props. - Valid values types to search on are
            strings & arrays. - Nested prop access with dot notation.
        :param search_label: Search the label along with the value.
        :param search_backend: Do not perform any search on the options
            from the frontend and instead relies on binding the
            ``search_value`` to filter and set the ``filtered_options`` aspect.
        :param filtered_options: Array of options that are filtered, set
            from backend with search (default=null)
        :param opened: Is the dropdown currently open ? (default=False)
        :param no_results_label: Label to use when no search results are
            available.
        :param toggle_symbol: Unicode character used as the toggle button.
            (default='⏷')
        :param scrollable: Make the menu scrollable.
        :param scroll_max_size:
        :param class_name:
        :param style:
        """
        Component.__init__(self, locals(), identity)
