"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class Image(Component):
    """
    An image.

    :CSS:

        - ``dazzler-core-image``
        - ``bordered``
        - ``padded``
        - ``rounded``
        - ``centered``
    """
    _aspect_keys = []
    _children = []
    src = Aspect(required=True, docstring="The source url of the image.")
    alt = Aspect(required=True, docstring="Alt img attribute to show when the browser cannot display the image.")  # noqa: E501
    height = Aspect(docstring="Height in pixel")
    width = Aspect(docstring="Width in pixel")
    link = Aspect(docstring="Link to another page when the image is clicked.")
    caption = Aspect(children=True, docstring="Text to include beneath the image.")  # noqa: E501
    cross_origin = Aspect(docstring="Fetch the image with CORS. (Possible values: 'anonymous', 'use-credentials')")  # noqa: E501
    decoding = Aspect(docstring="Decoding hint for the browser (Possible values: 'sync', 'async', 'auto')")  # noqa: E501
    preload = Aspect(docstring="Preload the image before mount.")
    clicks = Aspect(default=0, docstring="Times the image was clicked on. (default=0)")  # noqa: E501
    class_name = Aspect(docstring="CSS class to give to root element, (Scoped: dazzler-core-image)")  # noqa: E501
    style = Aspect(docstring="Style object of the root element.")
    bordered = Aspect(docstring="Add bordered style class")
    rounded = Aspect(docstring="Add rounded style class")
    centered = Aspect(docstring="Add centered style class for the image toappear in the horizontal middle")  # noqa: E501
    flexible = Aspect(docstring="Take up the whole size of the parent container.")  # noqa: E501
    circle = Aspect(docstring="Image is a circle")
    padded = Aspect(docstring="Add a little padding around the image.")
    caption_style = Aspect(docstring="Style to give to the caption of the image.")  # noqa: E501
    caption_class_name = Aspect(docstring="CSS class to give to the caption of the image.")  # noqa: E501
    figure_class_name = Aspect(docstring="CSS class to give to figure if caption is provided.")  # noqa: E501
    figure_style = Aspect(docstring="Style object to give to figure if caption is provided.")  # noqa: E501
    link_class_name = Aspect(docstring="CSS class to give to the link element.")  # noqa: E501
    link_style = Aspect(docstring="Style object to give to the link.")

    def __init__(
            self,
            src: str,
            alt: str,
            height: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            width: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            link: typing.Optional[str] = UNDEFINED,
            caption: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            cross_origin: typing.Optional[typing.Any] = UNDEFINED,
            decoding: typing.Optional[typing.Any] = UNDEFINED,
            preload: typing.Optional[bool] = UNDEFINED,
            clicks: typing.Optional[typing.Union[float, int]] = 0,
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            bordered: typing.Optional[bool] = UNDEFINED,
            rounded: typing.Optional[bool] = UNDEFINED,
            centered: typing.Optional[bool] = UNDEFINED,
            flexible: typing.Optional[bool] = UNDEFINED,
            circle: typing.Optional[bool] = UNDEFINED,
            padded: typing.Optional[bool] = UNDEFINED,
            caption_style: typing.Optional[typing.Dict] = UNDEFINED,
            caption_class_name: typing.Optional[str] = UNDEFINED,
            figure_class_name: typing.Optional[str] = UNDEFINED,
            figure_style: typing.Optional[typing.Dict] = UNDEFINED,
            link_class_name: typing.Optional[str] = UNDEFINED,
            link_style: typing.Optional[typing.Dict] = UNDEFINED,
            identity: str = None
    ):
        """
        :param src: The source url of the image.
        :param alt: Alt img attribute to show when the browser cannot
            display the image.
        :param height: Height in pixel
        :param width: Width in pixel
        :param link: Link to another page when the image is clicked.
        :param caption: Text to include beneath the image.
        :param cross_origin: Fetch the image with CORS. (Possible values:
            'anonymous', 'use-credentials')
        :param decoding: Decoding hint for the browser (Possible values:
            'sync', 'async', 'auto')
        :param preload: Preload the image before mount.
        :param clicks: Times the image was clicked on. (default=0)
        :param class_name: CSS class to give to root element, (Scoped:
            dazzler-core-image)
        :param style: Style object of the root element.
        :param bordered: Add bordered style class
        :param rounded: Add rounded style class
        :param centered: Add centered style class for the image to appear
            in the horizontal middle
        :param flexible: Take up the whole size of the parent container.
        :param circle: Image is a circle
        :param padded: Add a little padding around the image.
        :param caption_style: Style to give to the caption of the image.
        :param caption_class_name: CSS class to give to the caption of the
            image.
        :param figure_class_name: CSS class to give to figure if caption is
            provided.
        :param figure_style: Style object to give to figure if caption is
            provided.
        :param link_class_name: CSS class to give to the link element.
        :param link_style: Style object to give to the link.
        """
        Component.__init__(self, locals(), identity)
