"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Support = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Support extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'support';
        this.accessLevelList = {
            Write: [
                'AddAttachmentsToSet',
                'AddCommunicationToCase',
                'CreateCase',
                'InitiateCallForCase',
                'InitiateChatForCase',
                'PutCaseAttributes',
                'RateCaseCommunication',
                'RefreshTrustedAdvisorCheck',
                'ResolveCase'
            ],
            Read: [
                'DescribeAttachment',
                'DescribeCaseAttributes',
                'DescribeCases',
                'DescribeCommunications',
                'DescribeIssueTypes',
                'DescribeServices',
                'DescribeSeverityLevels',
                'DescribeSupportLevel',
                'DescribeTrustedAdvisorCheckRefreshStatuses',
                'DescribeTrustedAdvisorCheckResult',
                'DescribeTrustedAdvisorCheckSummaries',
                'DescribeTrustedAdvisorChecks',
                'SearchForCases'
            ]
        };
    }
    /**
     * Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    toAddAttachmentsToSet() {
        return this.to('AddAttachmentsToSet');
    }
    /**
     * Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    toAddCommunicationToCase() {
        return this.to('AddCommunicationToCase');
    }
    /**
     * Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    toCreateCase() {
        return this.to('CreateCase');
    }
    /**
     * Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    toDescribeAttachment() {
        return this.to('DescribeAttachment');
    }
    /**
     * This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     */
    toDescribeCaseAttributes() {
        return this.to('DescribeCaseAttributes');
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    toDescribeCases() {
        return this.to('DescribeCases');
    }
    /**
     * Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    toDescribeCommunications() {
        return this.to('DescribeCommunications');
    }
    /**
     * Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     */
    toDescribeIssueTypes() {
        return this.to('DescribeIssueTypes');
    }
    /**
     * Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    toDescribeServices() {
        return this.to('DescribeServices');
    }
    /**
     * Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    toDescribeSeverityLevels() {
        return this.to('DescribeSeverityLevels');
    }
    /**
     * Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     */
    toDescribeSupportLevel() {
        return this.to('DescribeSupportLevel');
    }
    /**
     * Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses() {
        return this.to('DescribeTrustedAdvisorCheckRefreshStatuses');
    }
    /**
     * Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    toDescribeTrustedAdvisorCheckResult() {
        return this.to('DescribeTrustedAdvisorCheckResult');
    }
    /**
     * Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    toDescribeTrustedAdvisorCheckSummaries() {
        return this.to('DescribeTrustedAdvisorCheckSummaries');
    }
    /**
     * Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    toDescribeTrustedAdvisorChecks() {
        return this.to('DescribeTrustedAdvisorChecks');
    }
    /**
     * This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateCallForCase() {
        return this.to('InitiateCallForCase');
    }
    /**
     * This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     */
    toInitiateChatForCase() {
        return this.to('InitiateChatForCase');
    }
    /**
     * This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     */
    toPutCaseAttributes() {
        return this.to('PutCaseAttributes');
    }
    /**
     * Rate an AWS Support case communication.
     *
     * Access Level: Write
     */
    toRateCaseCommunication() {
        return this.to('RateCaseCommunication');
    }
    /**
     * Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    toRefreshTrustedAdvisorCheck() {
        return this.to('RefreshTrustedAdvisorCheck');
    }
    /**
     * Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    toResolveCase() {
        return this.to('ResolveCase');
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     */
    toSearchForCases() {
        return this.to('SearchForCases');
    }
}
exports.Support = Support;
_a = JSII_RTTI_SYMBOL_1;
Support[_a] = { fqn: "iam-floyd.Support", version: "0.393.0" };
//# sourceMappingURL=data:application/json;base64,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