# mypy-boto3-machinelearning

[![PyPI - mypy-boto3-machinelearning](https://img.shields.io/pypi/v/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MachineLearning 1.14.22](https://boto3.amazonaws.com/v1/documentation/api/1.14.22/reference/services/machinelearning.html#MachineLearning) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MachineLearning` service.

```bash
python -m pip install boto3-stubs[machinelearning]
```

## How to use

### Client annotations

`MachineLearningClient` provides annotations for `boto3.client("machinelearning")`.

```python
import boto3

from mypy_boto3_machinelearning import MachineLearningClient
from mypy_boto3_machinelearning.paginator import (
    DescribeBatchPredictionsPaginator,
    DescribeDataSourcesPaginator,
    DescribeEvaluationsPaginator,
    DescribeMLModelsPaginator,
)
from mypy_boto3_machinelearning.type_defs import BatchPredictionTypeDef, ...
from mypy_boto3_machinelearning.waiter import (
    BatchPredictionAvailableWaiter,
    DataSourceAvailableWaiter,
    EvaluationAvailableWaiter,
    MLModelAvailableWaiter,
)

client: MachineLearningClient = boto3.client("machinelearning")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MachineLearningClient = session.client("machinelearning")
```

### Paginators annotations

`mypy_boto3_machinelearning.paginator` module contains type annotations for all paginators.

```python

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_batch_predictions_paginator: DescribeBatchPredictionsPaginator = client.get_paginator("describe_batch_predictions")
describe_data_sources_paginator: DescribeDataSourcesPaginator = client.get_paginator("describe_data_sources")
describe_evaluations_paginator: DescribeEvaluationsPaginator = client.get_paginator("describe_evaluations")
describe_ml_models_paginator: DescribeMLModelsPaginator = client.get_paginator("describe_ml_models")
```


### Waiters annotations

`mypy_boto3_machinelearning.waiter` module contains type annotations for all waiters.

```python

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
batch_prediction_available_waiter: BatchPredictionAvailableWaiter = client.get_waiter("batch_prediction_available")
data_source_available_waiter: DataSourceAvailableWaiter = client.get_waiter("data_source_available")
evaluation_available_waiter: EvaluationAvailableWaiter = client.get_waiter("evaluation_available")
ml_model_available_waiter: MLModelAvailableWaiter = client.get_waiter("ml_model_available")
```





### Typed dictionations

`mypy_boto3_machinelearning.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> BatchPredictionTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_machinelearning` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("machinelearning")

session_client = boto3.Session().client("machinelearning")
```
