# alchemite-apiclient

This is a client for interacting with Alchemite Analytics, an applied machine learning platform to accelerate industrial
R&D and optimise manufacturing by extracting information from sparce or noisy datasets.
To obtain a licence for this product, please [contact Intellegens](https://intellegens.com/contact-us/) for more information.

API version: 0.63.0

## Requirements.

Python >=3.8

## Installation & Usage
### pip install
Either you can install this from the public pip repository using:

```sh
pip install alchemite-apiclient
```

Alternatively, you can install it from a zip archive using:

```sh
pip install ./api_client_python-version.zip
```
(you may need to run `pip` with root permission: `sudo pip install ./api_client_python-version.zip`)

Then import the package:
```python
import alchemite_apiclient
```

## Getting Started

Please follow the [installation procedure](#installation--usage).

Examples can be found in the source distribution, downloadable from https://pypi.org/project/alchemite-apiclient/#files

Then place your `credentials.json` file in the "example" directory and run
```bash
python example_connect.py
```
This should connect to the API server and, if successful, print something like this to the terminal (the numbers you see may be different):
```
------ API version -----
{'alchemite_version': '20200414',
 'api_application_version': '0.15.3',
 'api_definition_version': '0.14.3'}
```
If instead you encounter an error at this stage please contact Intellegens for further guidance.

Next, look through and try running example/example_basic.py.  This will upload a small dataset, train a basic model with the default hyperparameters and predict the missing values from a dataset.

Examples of other functionality possible through the Alchemite API are given by:
- example/example_hyperopt.py train an optimal model using hyperparameter optimization and impute the training dataset
- example/example_chunk.py upload a larger dataset in chunks
- example/example_delete.py delete models and datasets
- example/example_optimize.py search the model's parameter space for parameters predicted to meet certain targets
- example/example_outliers.py find outliers in the model's training dataset
- example/example_preload.py preload a model into memory to make predictions for larger models faster

## Credentials

The credentials.json file requires the following elements:
- `host`: The base uri of the Alchemite api you are attempting to use. (Ordinarily `https://alchemiteapi.intellegens.ai/v0`)
- `client_id`: The client id to use for authentication. (Ordinarily `PythonClient`)
- `grant_type`: One of `password`, `client_credentials`, `authorization_code`.

Grant types each have additional elements:
#### Authorization Code:
This will open a browser to prompt for user credentials for using the API. This is the recommended way of authenticating.
- `offline` (optional): If true, the client will attempt to acquire an offline token to persist user authentication between sessions. This token is stored in a `.alchemite_token` file in the working directory.

#### Password:
This will use credentials collected from the commandline to authenticate with the API.
- `username` (optional): The username to log in with. If omitted the user will be prompted to enter it
- `password` (optional): The password to log in with. If omitted the user will be prompted to enter it
- `offline` (optional): If true, the client will attempt to acquire an offline token to persist user authentication between sessions. This token is stored in a `.alchemite_token` file in the working directory.

#### Client Credentials:
Attempts to authenticate using a client secret.
- `client_secret`: The client secret to use for authentication.

### Offline tokens
Offline tokens persist indefinitely, but will expire if unused for more than 30 days.
In the event that the token is lost or stolen, it can be revoked from your profile page in the Applications tab.

Reference documentation corresponding to each API endpoint can be found in the docs directory of the source distribution.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project.
