"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_a = props.stage) !== null && _a !== void 0 ? _a : (props.restApi instanceof restapi_1.RestApi
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,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