# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aws_snippets']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.17.78,<2.0.0']

setup_kwargs = {
    'name': 'aws-snippets',
    'version': '2021.1.0.0',
    'description': 'Python3 classes and functions to execute common AWS operations.',
    'long_description': '================\n**aws_snippets**\n================\n\nOverview\n--------\n\nPython3 classes and functions to execute common AWS operations.\n\nUsage Example\n-------------\n\n.. code-block:: BASH\n\n   """Read secret string from AWS Secrets Manager."""\n   import aws_snippets\n\n   # secret_string = aws_snippets.readsecret(\'<secret-ID>\')\n   secret_string = aws_snippets.readsecret(\'dkfjh765-sdfsf456-dfgd\')\n   print(secret_string)\n\n   # Output: "I\'m Batman!"\n\nGet Full Functionality List from Docstring\n------------------------------------------\n\nPython Commands:\n\n.. code-block:: BASH\n\n   import aws_snippets\n   help(aws_snippets)\n\nBASH Commands:\n\n.. code-block:: BASH\n\n   python -c \'import aws_snippets; help(aws_snippets)\'\n\nOutput\n------\n\n.. code-block:: BASH\n\n   Help on package aws_snippets:\n\n   NAME\n      aws_snippets - Execute AWS operations.\n\n   PACKAGE CONTENTS\n\n\n   CLASSES\n      builtins.object\n         WriteLog\n      \n      class WriteLog(builtins.object)\n      |  WriteLog(text)\n      |  \n      |  Create JSON log object for CloudWatch.\n      |  \n      |  # Import modules.\n      |  import json\n      |  from aws_snippets import WriteLog\n      |  \n      |  # Initiate with empty dictionary.\n      |  logger = WriteLog({})\n      |  \n      |  # Collect entries to log.\n      |  logger.log(\'<strkey>\', \'<value>\')\n      |  logger.log(\'<intkey>\', <value>)\n      |  logger.log(\'<boolkey>\', <True/False>)\n      |  \n      |  # Print out to CloudWatch as accumulated log.\n      |  print(json.dumps(logger.text))\n      |  \n      |  Methods defined here:\n      |  \n      |  __init__(self, text)\n      |      Initialize log content.\n      |  \n      |  log(self, key, value)\n      |      Update log content.\n      |  \n      |  ----------------------------------------------------------------------\n      |  Data descriptors defined here:\n      |  \n      |  __dict__\n      |      dictionary for instance variables (if defined)\n      |  \n      |  __weakref__\n      |      list of weak references to the object (if defined)\n\n   FUNCTIONS\n      b64encode(cleartext: str, encoding: str = \'latin-1\') -> str\n         Encode strings using Base64.\n         \n         return str\n      \n      cfpurge(cf_dist: str, path: str, call_ref: str) -> dict\n         Create Amazon CloudFront cache invalidation.\n         \n         return dict\n      \n      cleantmp(tmppath: str) -> None\n         Clean Lambda /tmp path.\n         \n         return None\n      \n      dynamodbcreatetable(table: str, attrdictls: list, schemadictls: list, kmsid: str, tagdictls: list) -> None\n         Create a table in DynamoDB.\n         \n         return None\n      \n      dynamodbdeleteallitems(table: str) -> None\n         Delete all items from a DynamoDB table.\n         \n         return None\n      \n      dynamodbdeletetable(table: str) -> None\n         Delete a table from DynamoDB.\n         \n         return None\n      \n      dynamodbgetitem(table: str, key: str, value: str) -> dict\n         Get a single item from DynamoDB.\n         \n         return dict\n      \n      dynamodbputitem(table: str, itemdict: dict) -> None\n         Put a single item into DynamoDB.\n         \n         return None\n      \n      dynamodbqueryitems(table: str, key: str, value: str) -> dict\n         Get items based on keyword query from DynamoDB.\n         \n         return dict\n      \n      dynamodbscanallitems(table: str) -> dict\n         Get all items from a table in DynamoDB.\n         \n         return dict\n      \n      dynamodbscanitems(table: str, key: str, value: str, patternexp: dict) -> dict\n         Get all items from a DynamoDB table then filter by expression.\n         \n         return dict\n      \n      dynamodbupdateitem(table: str, keydict: dict, attributedict: dict, valuedict: dict, updateexpression: str) -> dict\n         Update an item in a DynamoDB table.\n         \n         return dict\n      \n      httpget(url: str, headers: dict = {}, encoding: str = \'latin-1\') -> dict\n         Make HTTP requests using GET method.\n         \n         return dict\n      \n      httppost(url: str, headers: dict = {}, data: dict = {}, encoding: str = \'latin-1\') -> str\n         Make HTTP requests using POST method.\n         \n         return str\n\n      kmsdecrypt(ciphertext: str, kmsid: str) -> str\n         Decrypt strings using AWS KMS.\n         \n         return str\n      \n      kmsencrypt(cleartext: str, kmsid: str) -> str\n         Encrypt strings using AWS KMS.\n         \n         return str\n      \n      randomize(length: int, punctuations: bool = False) -> str\n         Create random strings.\n         \n         return str\n      \n      readsecret(id: str) -> str\n         Read secret values in AWS Secrets Manager.\n         \n         return str\n      \n      sanitizerclean(input: str) -> str\n         Sanitize input items.\n         \n         return str\n      \n      sanitizercleanlist(input: list, pattern: str) -> list\n         Sanitize input list.\n         \n         return list\n      \n      sanitizercleanurl(url: str) -> str\n         Sanitize input URLs.\n         \n         return str\n      \n      sanitizercleanurllist(input: list, pattern: str) -> list\n         Sanitize input list.\n         \n         return list\n      \n      sanitizervalidate(input: str, pattern: str) -> bool\n         Validate input items to RegEx patterns.\n         \n         return bool\n      \n      sanitizervalidatelist(input: list) -> bool\n         Validate input list.\n         \n         return bool\n      \n      sha3512hash(clrtxt: str, condiments: str, encoding: str = \'latin-1\') -> str\n         Hash strings using SHA3_512 algorithm.\n         \n         return str\n      \n      snsnotify(topic: str, message: str, subject: str) -> None\n         Send AWS SNS notifications.\n         \n         return None\n      \n      sqsmessage(queue_url: str, message: dict) -> dict\n         Send messages into AWS SQS queues.\n         \n         return dict\n\n   DATA\n      Union = typing.Union\n         Union type; Union[X, Y] means either X or Y.\n         \n         To define a union, use e.g. Union[int, str].  Details:\n         - The arguments must be types and there must be at least one.\n         - None as an argument is a special case and is replaced by\n            type(None).\n         - Unions of unions are flattened, e.g.::\n         \n               Union[Union[int, str], float] == Union[int, str, float]\n         \n         - Unions of a single argument vanish, e.g.::\n         \n               Union[int] == int  # The constructor actually returns int\n         \n         - Redundant arguments are skipped, e.g.::\n         \n               Union[int, str, int] == Union[int, str]\n         \n         - When comparing unions, the argument order is ignored, e.g.::\n         \n               Union[int, str] == Union[str, int]\n         \n         - You cannot subclass or instantiate a union.\n         - You can use Optional[X] as a shorthand for Union[X, None].\n\n   VERSION\n      2021.1.0.0\n\n   FILE\n      /Users/abdahmad/Desktop/aws_snippets/__init__.py\n',
    'author': 'Ahmad Ferdaus Abd Razak',
    'author_email': 'ahmad.ferdaus.abd.razak@ni.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fer1035/pypi-awssnippets',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
