# The map of SPDX license id to trove classifiers
TROVE_CLASSIFIERS = {
    ("CC0-1.0",): "License :: CC0 1.0 Universal (CC0 1.0) Public Domain Dedication",
    ("CECILL-B",): "License :: CeCILL-B Free Software License Agreement (CECILL-B)",
    ("CECILL-C",): "License :: CeCILL-C Free Software License Agreement (CECILL-C)",
    ("NPL-1.0", "NPL-1.1"): "License :: Netscape Public License (NPL)",
    (
        "AFL-1.1",
        "AFL-1.2",
        "AFL-2.0",
        "AFL-2.1",
        "AFL-3.0",
    ): "License :: OSI Approved :: Academic Free License (AFL)",
    (
        "Apache-1.0",
        "Apache-1.1",
        "Apache-2.0",
    ): "License :: OSI Approved :: Apache Software License",
    (
        "APSL-1.0",
        "APSL-1.1",
        "APSL-1.2",
        "APSL-2.0",
    ): "License :: OSI Approved :: Apple Public Source License",
    ("Artistic-1.0", "Artistic-2.0"): "License :: OSI Approved :: Artistic License",
    ("AAL",): "License :: OSI Approved :: Attribution Assurance License",
    ("BSD-2-Clause", "BSD-3-Clause"): "License :: OSI Approved :: BSD License",
    ("BSL-1.0",): "License :: OSI Approved :: Boost Software License 1.0 (BSL-1.0)",
    (
        "CECILL-2.1",
    ): "License :: OSI Approved :: CEA CNRS Inria Logiciel Libre License, version 2.1 (CeCILL-2.1)",  # noqa
    (
        "CDDL-1.0",
    ): "License :: OSI Approved :: Common Development and Distribution License 1.0 (CDDL-1.0)",  # noqa
    ("CPL-1.0",): "License :: OSI Approved :: Common Public License",
    ("EPL-1.0",): "License :: OSI Approved :: Eclipse Public License 1.0 (EPL-1.0)",
    ("EPL-2.0",): "License :: OSI Approved :: Eclipse Public License 2.0 (EPL-2.0)",
    ("EFL-1.0", "EFL-2.0"): "License :: OSI Approved :: Eiffel Forum License",
    (
        "EUPL-1.0",
    ): "License :: OSI Approved :: European Union Public Licence 1.0 (EUPL 1.0)",
    (
        "EUPL-1.1",
    ): "License :: OSI Approved :: European Union Public Licence 1.1 (EUPL 1.1)",
    (
        "EUPL-1.2",
    ): "License :: OSI Approved :: European Union Public Licence 1.2 (EUPL 1.2)",
    (
        "AGPL-3.0",
        "AGPL-3.0-only",
    ): "License :: OSI Approved :: GNU Affero General Public License v3",
    (
        "AGPL-3.0-or-later",
    ): "License :: OSI Approved :: GNU Affero General Public License v3 or later (AGPLv3+)",  # noqa
    (
        "GFDL-1.1",
        "GFDL-1.2",
        "GFDL-1.3",
    ): "License :: OSI Approved :: GNU Free Documentation License (FDL)",
    ("GPL-1.0",): "License :: OSI Approved :: GNU General Public License (GPL)",
    ("GPL-2.0",): "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
    (
        "GPL-2.0-or-later"
    ): "License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)",
    ("GPL-3.0",): "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
    (
        "GPL-3.0-or-later",
    ): "License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)",
    (
        "LGPL-2.0",
    ): "License :: OSI Approved :: GNU Lesser General Public License v2 (LGPLv2)",
    (
        "LGPL-2.0-or-later",
    ): "License :: OSI Approved :: GNU Lesser General Public License v2 or later (LGPLv2+)",  # noqa
    (
        "LGPL-3.0",
    ): "License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)",
    (
        "LGPL-3.0-or-later",
    ): "License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)",  # noqa
    (
        "LGPL",
    ): "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
    (
        "HPND",
    ): "License :: OSI Approved :: Historical Permission Notice and Disclaimer (HPND)",
    ("IPL-1.0",): "License :: OSI Approved :: IBM Public License",
    ("ISC",): "License :: OSI Approved :: ISC License (ISCL)",
    ("Intel",): "License :: OSI Approved :: Intel Open Source License",
    ("MIT",): "License :: OSI Approved :: MIT License",
    ("MirOS",): "License :: OSI Approved :: MirOS License (MirOS)",
    ("Motosoto",): "License :: OSI Approved :: Motosoto License",
    ("MPL-1.0",): "License :: OSI Approved :: Mozilla Public License 1.0 (MPL)",
    ("MPL-1.1",): "License :: OSI Approved :: Mozilla Public License 1.1 (MPL 1.1)",
    ("MPL-2.0",): "License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)",
    ("NGPL",): "License :: OSI Approved :: Nethack General Public License",
    ("Nokia",): "License :: OSI Approved :: Nokia Open Source License",
    ("OGTSL",): "License :: OSI Approved :: Open Group Test Suite License",
    ("OSL-3.0",): "License :: OSI Approved :: Open Software License 3.0 (OSL-3.0)",
    ("PostgreSQL",): "License :: OSI Approved :: PostgreSQL License",
    ("CNRI-Python",): "License :: OSI Approved :: Python License (CNRI Python License)",
    ("PSF-2.0",): "License :: OSI Approved :: Python Software Foundation License",
    ("RSCPL",): "License :: OSI Approved :: Ricoh Source Code Public License",
    ("OFL-1.1",): "License :: OSI Approved :: SIL Open Font License 1.1 (OFL-1.1)",
    ("Sleepycat",): "License :: OSI Approved :: Sleepycat License",
    (
        "SISSL",
        "SISSL-1.2",
    ): "License :: OSI Approved :: Sun Industry Standards Source License (SISSL)",
    ("SPL-1.0",): "License :: OSI Approved :: Sun Public License",
    ("Unlicense",): "License :: OSI Approved :: The Unlicense (Unlicense)",
    ("UPL-1.0",): "License :: OSI Approved :: Universal Permissive License (UPL)",
    (
        "NCSA",
    ): "License :: OSI Approved :: University of Illinois/NCSA Open Source License",
    ("VSL-1.0",): "License :: OSI Approved :: Vovida Software License 1.0",
    ("W3C",): "License :: OSI Approved :: W3C License",
    ("Xnet",): "License :: OSI Approved :: X.Net License",
    ("ZPL-1.1", "ZPL-2.0", "ZPL-2.1"): "License :: OSI Approved :: Zope Public License",
    ("Zlib",): "License :: OSI Approved :: zlib/libpng License",
}
DEFAULT_LICENSE = "License :: Other/Proprietary License"

license_lookup = {k: v for keys, v in TROVE_CLASSIFIERS.items() for k in keys}
