# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['AccountTeamProject']


class AccountTeamProject(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 team_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Account Team Project Resource

        The Account Team Project resource allows the creation and management of an Account Team Projects.

        It is intended to link and existing project to the existing account team.
        It is important to note that the project should have an `account_id` property set and equal to
        account team you are trying to link this project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: is a unique account id.
        :param pulumi.Input[str] project_name: is a project name of already existing project.
        :param pulumi.Input[str] team_id: is an account team id.
        :param pulumi.Input[str] team_type: is an account team project type, can one of the following values: `admin`, 
               `developer`, `operator` and `read_only`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if account_id is None:
                raise TypeError("Missing required property 'account_id'")
            __props__['account_id'] = account_id
            __props__['project_name'] = project_name
            if team_id is None:
                raise TypeError("Missing required property 'team_id'")
            __props__['team_id'] = team_id
            __props__['team_type'] = team_type
        super(AccountTeamProject, __self__).__init__(
            'aiven:index/accountTeamProject:AccountTeamProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            team_type: Optional[pulumi.Input[str]] = None) -> 'AccountTeamProject':
        """
        Get an existing AccountTeamProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: is a unique account id.
        :param pulumi.Input[str] project_name: is a project name of already existing project.
        :param pulumi.Input[str] team_id: is an account team id.
        :param pulumi.Input[str] team_type: is an account team project type, can one of the following values: `admin`, 
               `developer`, `operator` and `read_only`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["project_name"] = project_name
        __props__["team_id"] = team_id
        __props__["team_type"] = team_type
        return AccountTeamProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        is a unique account id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[Optional[str]]:
        """
        is a project name of already existing project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        is an account team id.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="teamType")
    def team_type(self) -> pulumi.Output[Optional[str]]:
        """
        is an account team project type, can one of the following values: `admin`, 
        `developer`, `operator` and `read_only`.
        """
        return pulumi.get(self, "team_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

