# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ElasticSearchAcl']


class ElasticSearchAcl(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ElasticSearchAclAclArgs']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 extended_acl: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Elasticsearch ACL Resource

        The Elasticsearch ACL resource allows the creation and management of an Aiven Elasticsearch ACLs
        for Elasticsearch service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        es_acls = aiven.ElasticSearchAcl("es-acls",
            project=aiven_project["es-project"]["project"],
            service_name=aiven_service["es"]["service_name"],
            enabled=True,
            extended_acl=False,
            acls=[
                aiven.ElasticSearchAclAclArgs(
                    username=aiven_service_user["es-user"]["username"],
                    rules=[
                        aiven.ElasticSearchAclAclRuleArgs(
                            index="_*",
                            permission="admin",
                        ),
                        aiven.ElasticSearchAclAclRuleArgs(
                            index="*",
                            permission="admin",
                        ),
                    ],
                ),
                aiven.ElasticSearchAclAclArgs(
                    username="avnadmin",
                    rules=[
                        aiven.ElasticSearchAclAclRuleArgs(
                            index="_*",
                            permission="read",
                        ),
                        aiven.ElasticSearchAclAclRuleArgs(
                            index="*",
                            permission="read",
                        ),
                    ],
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ElasticSearchAclAclArgs']]]] acls: List of Elasticsearch ACLs
        :param pulumi.Input[bool] enabled: enables of disables Elasticsearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs 
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use
               these APIs as long as all operations only target indexes they have been granted access to.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. 
               They should be defined using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Elasticsearch ACLs to
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acls'] = acls
            __props__['enabled'] = enabled
            __props__['extended_acl'] = extended_acl
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
        super(ElasticSearchAcl, __self__).__init__(
            'aiven:index/elasticSearchAcl:ElasticSearchAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ElasticSearchAclAclArgs']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            extended_acl: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None) -> 'ElasticSearchAcl':
        """
        Get an existing ElasticSearchAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ElasticSearchAclAclArgs']]]] acls: List of Elasticsearch ACLs
        :param pulumi.Input[bool] enabled: enables of disables Elasticsearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs 
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use
               these APIs as long as all operations only target indexes they have been granted access to.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. 
               They should be defined using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Elasticsearch ACLs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acls"] = acls
        __props__["enabled"] = enabled
        __props__["extended_acl"] = extended_acl
        __props__["project"] = project
        __props__["service_name"] = service_name
        return ElasticSearchAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[List['outputs.ElasticSearchAclAcl']]]:
        """
        List of Elasticsearch ACLs
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        enables of disables Elasticsearch ACL's.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="extendedAcl")
    def extended_acl(self) -> pulumi.Output[Optional[bool]]:
        """
        Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs 
        (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use
        these APIs as long as all operations only target indexes they have been granted access to.
        """
        return pulumi.get(self, "extended_acl")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        and `service_name` - (Required) define the project and service the ACL belongs to. 
        They should be defined using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the Elasticsearch ACLs to
        """
        return pulumi.get(self, "service_name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

