# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = [
    'GetMirrorMakerReplicationFlowResult',
    'AwaitableGetMirrorMakerReplicationFlowResult',
    'get_mirror_maker_replication_flow',
]

@pulumi.output_type
class GetMirrorMakerReplicationFlowResult:
    """
    A collection of values returned by getMirrorMakerReplicationFlow.
    """
    def __init__(__self__, enable=None, id=None, project=None, service_name=None, source_cluster=None, target_cluster=None, topics=None, topics_blacklists=None):
        if enable and not isinstance(enable, bool):
            raise TypeError("Expected argument 'enable' to be a bool")
        pulumi.set(__self__, "enable", enable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if source_cluster and not isinstance(source_cluster, str):
            raise TypeError("Expected argument 'source_cluster' to be a str")
        pulumi.set(__self__, "source_cluster", source_cluster)
        if target_cluster and not isinstance(target_cluster, str):
            raise TypeError("Expected argument 'target_cluster' to be a str")
        pulumi.set(__self__, "target_cluster", target_cluster)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if topics_blacklists and not isinstance(topics_blacklists, list):
            raise TypeError("Expected argument 'topics_blacklists' to be a list")
        pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        enable of disable replication flows for a mirror maker service
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> str:
        return pulumi.get(self, "source_cluster")

    @property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> str:
        return pulumi.get(self, "target_cluster")

    @property
    @pulumi.getter
    def topics(self) -> Optional[List[str]]:
        """
        is a list of topics and/or regular expressions to replicate.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Optional[List[str]]:
        """
        is a list of topics and/or regular expressions to not replicate.
        """
        return pulumi.get(self, "topics_blacklists")


class AwaitableGetMirrorMakerReplicationFlowResult(GetMirrorMakerReplicationFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMirrorMakerReplicationFlowResult(
            enable=self.enable,
            id=self.id,
            project=self.project,
            service_name=self.service_name,
            source_cluster=self.source_cluster,
            target_cluster=self.target_cluster,
            topics=self.topics,
            topics_blacklists=self.topics_blacklists)


def get_mirror_maker_replication_flow(enable: Optional[bool] = None,
                                      project: Optional[str] = None,
                                      service_name: Optional[str] = None,
                                      source_cluster: Optional[str] = None,
                                      target_cluster: Optional[str] = None,
                                      topics: Optional[List[str]] = None,
                                      topics_blacklists: Optional[List[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMirrorMakerReplicationFlowResult:
    """
    ## # MirrorMaker 2 Replication Flow Data Source

    The MirrorMaker 2 Replication Flow data source provides information about the existing MirrorMaker 2
    Replication Flow on Aiven Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    f1 = aiven.get_mirror_maker_replication_flow(project=aiven_project["kafka-mm-project1"]["project"],
        service_name=aiven_service["mm"]["service_name"],
        source_cluster=aiven_service["source"]["service_name"],
        target_cluster=aiven_service["target"]["service_name"])
    ```


    :param bool enable: enable of disable replication flows for a mirror maker service
    :param str project: and `service_name` - (Required) define the project and service the Kafka MirrorMaker Replication 
           Flow belongs to. They should be defined using reference as shown above to set up dependencies correctly.
    :param str source_cluster: is a source cluster alias.
    :param str target_cluster: is a target cluster alias.
    :param List[str] topics: is a list of topics and/or regular expressions to replicate.
    :param List[str] topics_blacklists: is a list of topics and/or regular expressions to not replicate.
    """
    __args__ = dict()
    __args__['enable'] = enable
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['sourceCluster'] = source_cluster
    __args__['targetCluster'] = target_cluster
    __args__['topics'] = topics
    __args__['topicsBlacklists'] = topics_blacklists
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getMirrorMakerReplicationFlow:getMirrorMakerReplicationFlow', __args__, opts=opts, typ=GetMirrorMakerReplicationFlowResult).value

    return AwaitableGetMirrorMakerReplicationFlowResult(
        enable=__ret__.enable,
        id=__ret__.id,
        project=__ret__.project,
        service_name=__ret__.service_name,
        source_cluster=__ret__.source_cluster,
        target_cluster=__ret__.target_cluster,
        topics=__ret__.topics,
        topics_blacklists=__ret__.topics_blacklists)
