# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = [
    'GetServiceUserResult',
    'AwaitableGetServiceUserResult',
    'get_service_user',
]

@pulumi.output_type
class GetServiceUserResult:
    """
    A collection of values returned by getServiceUser.
    """
    def __init__(__self__, access_cert=None, access_key=None, id=None, password=None, project=None, service_name=None, type=None, username=None):
        if access_cert and not isinstance(access_cert, str):
            raise TypeError("Expected argument 'access_cert' to be a str")
        pulumi.set(__self__, "access_cert", access_cert)
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> str:
        """
        is the access certificate of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_cert")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        is the access key of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        is the password of the user (not applicable for all services).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        tells whether the user is primary account or regular account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


class AwaitableGetServiceUserResult(GetServiceUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceUserResult(
            access_cert=self.access_cert,
            access_key=self.access_key,
            id=self.id,
            password=self.password,
            project=self.project,
            service_name=self.service_name,
            type=self.type,
            username=self.username)


def get_service_user(access_cert: Optional[str] = None,
                     access_key: Optional[str] = None,
                     password: Optional[str] = None,
                     project: Optional[str] = None,
                     service_name: Optional[str] = None,
                     type: Optional[str] = None,
                     username: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceUserResult:
    """
    ## # Service User Data Source

    The Service User data source provides information about the existing Aiven Service User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myserviceuser = aiven.get_service_user(project=aiven_project["myproject"]["project"],
        service_name=aiven_service["myservice"]["service_name"],
        username="<USERNAME>")
    ```


    :param str access_cert: is the access certificate of the user (not applicable for all services).
    :param str access_key: is the access key of the user (not applicable for all services).
    :param str password: is the password of the user (not applicable for all services).
    :param str project: and `service_name` - (Required) define the project and service the user belongs to.
           They should be defined using reference as shown above to set up dependencies correctly.
    :param str type: tells whether the user is primary account or regular account.
    :param str username: is the actual name of the user account.
    """
    __args__ = dict()
    __args__['accessCert'] = access_cert
    __args__['accessKey'] = access_key
    __args__['password'] = password
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['type'] = type
    __args__['username'] = username
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getServiceUser:getServiceUser', __args__, opts=opts, typ=GetServiceUserResult).value

    return AwaitableGetServiceUserResult(
        access_cert=__ret__.access_cert,
        access_key=__ret__.access_key,
        id=__ret__.id,
        password=__ret__.password,
        project=__ret__.project,
        service_name=__ret__.service_name,
        type=__ret__.type,
        username=__ret__.username)
