# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegration']


class ServiceIntegration(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_endpoint_id: Optional[pulumi.Input[str]] = None,
                 destination_service_name: Optional[pulumi.Input[str]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]] = None,
                 logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']]] = None,
                 mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_endpoint_id: Optional[pulumi.Input[str]] = None,
                 source_service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Service Integration Resource

        The Service Integration resource allows the creation and management of an Aiven Service Integration`s.

        Service Integration defines an integration between two Aiven services or between Aiven
        service and an external integration endpoint. Integration could be for example sending
        metrics from Kafka service to an InfluxDB service, getting metrics from an InfluxDB
        service to a Grafana service to show dashboards, sending logs from any service to
        Elasticsearch, etc.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        myintegration = aiven.ServiceIntegration("myintegration",
            destination_endpoint_id=aiven_service_integration_endpoint["myendpoint"]["id"],
            destination_service_name="",
            integration_type="datadog",
            project=aiven_project["myproject"]["project"],
            source_endpoint_id="",
            source_service_name=aiven_service["testkafka"]["service_name"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_endpoint_id: or `destination_service_name` - (Required) identifies the target side of
               the integration. Only either endpoint identifier or service name must be specified. In
               either case the target needs to be defined using the reference syntax described above to
               set up the dependency correctly.
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_type: identifies the type of integration that is set up. Possible values
               include `dashboard`, `datadog`, `logs`, `metrics` and `mirrormaker`.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Mirrormaker 2 integration specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']] logs_user_config: Log integration specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']] mirrormaker_user_config: Mirrormaker 1 integration specific user configurable settings
        :param pulumi.Input[str] project: defines the project the integration belongs to.
        :param pulumi.Input[str] source_endpoint_id: or `source_service_name` - (Optional) identifies the source side of the
               integration. Only either endpoint identifier or service name must be specified. In either
               case the source needs to be defined using the reference syntax described above to set up
               the dependency correctly.
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['destination_endpoint_id'] = destination_endpoint_id
            __props__['destination_service_name'] = destination_service_name
            if integration_type is None:
                raise TypeError("Missing required property 'integration_type'")
            __props__['integration_type'] = integration_type
            __props__['kafka_connect_user_config'] = kafka_connect_user_config
            __props__['kafka_mirrormaker_user_config'] = kafka_mirrormaker_user_config
            __props__['logs_user_config'] = logs_user_config
            __props__['mirrormaker_user_config'] = mirrormaker_user_config
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['source_endpoint_id'] = source_endpoint_id
            __props__['source_service_name'] = source_service_name
        super(ServiceIntegration, __self__).__init__(
            'aiven:index/serviceIntegration:ServiceIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_endpoint_id: Optional[pulumi.Input[str]] = None,
            destination_service_name: Optional[pulumi.Input[str]] = None,
            integration_type: Optional[pulumi.Input[str]] = None,
            kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']]] = None,
            kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]] = None,
            logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']]] = None,
            mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            source_endpoint_id: Optional[pulumi.Input[str]] = None,
            source_service_name: Optional[pulumi.Input[str]] = None) -> 'ServiceIntegration':
        """
        Get an existing ServiceIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_endpoint_id: or `destination_service_name` - (Required) identifies the target side of
               the integration. Only either endpoint identifier or service name must be specified. In
               either case the target needs to be defined using the reference syntax described above to
               set up the dependency correctly.
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_type: identifies the type of integration that is set up. Possible values
               include `dashboard`, `datadog`, `logs`, `metrics` and `mirrormaker`.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Mirrormaker 2 integration specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']] logs_user_config: Log integration specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']] mirrormaker_user_config: Mirrormaker 1 integration specific user configurable settings
        :param pulumi.Input[str] project: defines the project the integration belongs to.
        :param pulumi.Input[str] source_endpoint_id: or `source_service_name` - (Optional) identifies the source side of the
               integration. Only either endpoint identifier or service name must be specified. In either
               case the source needs to be defined using the reference syntax described above to set up
               the dependency correctly.
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["destination_endpoint_id"] = destination_endpoint_id
        __props__["destination_service_name"] = destination_service_name
        __props__["integration_type"] = integration_type
        __props__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__["logs_user_config"] = logs_user_config
        __props__["mirrormaker_user_config"] = mirrormaker_user_config
        __props__["project"] = project
        __props__["source_endpoint_id"] = source_endpoint_id
        __props__["source_service_name"] = source_service_name
        return ServiceIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> pulumi.Output[Optional[str]]:
        """
        or `destination_service_name` - (Required) identifies the target side of
        the integration. Only either endpoint identifier or service name must be specified. In
        either case the target needs to be defined using the reference syntax described above to
        set up the dependency correctly.
        """
        return pulumi.get(self, "destination_endpoint_id")

    @property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> pulumi.Output[Optional[str]]:
        """
        Destination service for the integration (if any)
        """
        return pulumi.get(self, "destination_service_name")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output[str]:
        """
        identifies the type of integration that is set up. Possible values
        include `dashboard`, `datadog`, `logs`, `metrics` and `mirrormaker`.
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaConnectUserConfig']]:
        """
        Kafka Connect specific user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaMirrormakerUserConfig']]:
        """
        Mirrormaker 2 integration specific user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationLogsUserConfig']]:
        """
        Log integration specific user configurable settings
        """
        return pulumi.get(self, "logs_user_config")

    @property
    @pulumi.getter(name="mirrormakerUserConfig")
    def mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationMirrormakerUserConfig']]:
        """
        Mirrormaker 1 integration specific user configurable settings
        """
        return pulumi.get(self, "mirrormaker_user_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        defines the project the integration belongs to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> pulumi.Output[Optional[str]]:
        """
        or `source_service_name` - (Optional) identifies the source side of the
        integration. Only either endpoint identifier or service name must be specified. In either
        case the source needs to be defined using the reference syntax described above to set up
        the dependency correctly.
        """
        return pulumi.get(self, "source_endpoint_id")

    @property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> pulumi.Output[Optional[str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

