# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FlinkJobArgs', 'FlinkJob']

@pulumi.input_type
class FlinkJobArgs:
    def __init__(__self__, *,
                 job_name: pulumi.Input[str],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 statement: pulumi.Input[str],
                 table_ids: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a FlinkJob resource.
        :param pulumi.Input[str] job_name: Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] statement: The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_ids: A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
               a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "table_ids", table_ids)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def statement(self) -> pulumi.Input[str]:
        """
        The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[str]):
        pulumi.set(self, "statement", value)

    @property
    @pulumi.getter(name="tableIds")
    def table_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
        a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_ids")

    @table_ids.setter
    def table_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "table_ids", value)


@pulumi.input_type
class _FlinkJobState:
    def __init__(__self__, *,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 statement: Optional[pulumi.Input[str]] = None,
                 table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering FlinkJob resources.
        :param pulumi.Input[str] job_id: The Job ID of the flink job in the flink service.
        :param pulumi.Input[str] job_name: Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: The current state of the flink job in the flink service
        :param pulumi.Input[str] statement: The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_ids: A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
               a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statement is not None:
            pulumi.set(__self__, "statement", statement)
        if table_ids is not None:
            pulumi.set(__self__, "table_ids", table_ids)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Job ID of the flink job in the flink service.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the flink job in the flink service
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statement(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement", value)

    @property
    @pulumi.getter(name="tableIds")
    def table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
        a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_ids")

    @table_ids.setter
    def table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "table_ids", value)


class FlinkJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 statement: Optional[pulumi.Input[str]] = None,
                 table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The Flink Job resource allows the creation and management of Aiven Jobs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        job = aiven.FlinkJob("job",
            project=aiven_flink["flink"]["project"],
            service_name=aiven_flink["flink"]["service_name"],
            job_name="<JOB_NAME>",
            table_ids=[
                aiven_flink_table["source"]["table_id"],
                aiven_flink_table["sink"]["table_id"],
            ],
            statement=f\"\"\"        INSERT INTO {aiven_flink_table["sink"]["table_name"]}                                            
                SELECT * FROM {aiven_flink_table["source"]["table_name"]}                                        
                WHERE `cpu` > 50                                                                            
        \"\"\")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] job_name: Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] statement: The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_ids: A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
               a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Flink Job resource allows the creation and management of Aiven Jobs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        job = aiven.FlinkJob("job",
            project=aiven_flink["flink"]["project"],
            service_name=aiven_flink["flink"]["service_name"],
            job_name="<JOB_NAME>",
            table_ids=[
                aiven_flink_table["source"]["table_id"],
                aiven_flink_table["sink"]["table_id"],
            ],
            statement=f\"\"\"        INSERT INTO {aiven_flink_table["sink"]["table_name"]}                                            
                SELECT * FROM {aiven_flink_table["source"]["table_name"]}                                        
                WHERE `cpu` > 50                                                                            
        \"\"\")
        ```

        :param str resource_name: The name of the resource.
        :param FlinkJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 statement: Optional[pulumi.Input[str]] = None,
                 table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkJobArgs.__new__(FlinkJobArgs)

            if job_name is None and not opts.urn:
                raise TypeError("Missing required property 'job_name'")
            __props__.__dict__["job_name"] = job_name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if statement is None and not opts.urn:
                raise TypeError("Missing required property 'statement'")
            __props__.__dict__["statement"] = statement
            if table_ids is None and not opts.urn:
                raise TypeError("Missing required property 'table_ids'")
            __props__.__dict__["table_ids"] = table_ids
            __props__.__dict__["job_id"] = None
            __props__.__dict__["state"] = None
        super(FlinkJob, __self__).__init__(
            'aiven:index/flinkJob:FlinkJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            job_id: Optional[pulumi.Input[str]] = None,
            job_name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            statement: Optional[pulumi.Input[str]] = None,
            table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'FlinkJob':
        """
        Get an existing FlinkJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] job_id: The Job ID of the flink job in the flink service.
        :param pulumi.Input[str] job_name: Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: The current state of the flink job in the flink service
        :param pulumi.Input[str] statement: The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] table_ids: A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
               a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkJobState.__new__(_FlinkJobState)

        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_name"] = job_name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        __props__.__dict__["statement"] = statement
        __props__.__dict__["table_ids"] = table_ids
        return FlinkJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[str]:
        """
        The Job ID of the flink job in the flink service.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this job is submitted to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the flink job in the flink service
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statement(self) -> pulumi.Output[str]:
        """
        The SQL statement to define the job. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter(name="tableIds")
    def table_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of table ids that are required in the job runtime. To set up proper dependencies please refer to this variable as
        a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_ids")

