# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MirrorMakerReplicationFlowArgs', 'MirrorMakerReplicationFlow']

@pulumi.input_type
class MirrorMakerReplicationFlowArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 source_cluster: pulumi.Input[str],
                 target_cluster: pulumi.Input[str],
                 emit_heartbeats_enabled: Optional[pulumi.Input[bool]] = None,
                 replication_policy_class: Optional[pulumi.Input[str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MirrorMakerReplicationFlow resource.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] source_cluster: Source cluster alias. Maximum Length: `128`.
        :param pulumi.Input[str] target_cluster: Target cluster alias. Maximum Length: `128`.
        :param pulumi.Input[bool] emit_heartbeats_enabled: Emit heartbeats enabled. The default value is `false`.
        :param pulumi.Input[str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
               `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
               `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "source_cluster", source_cluster)
        pulumi.set(__self__, "target_cluster", target_cluster)
        if emit_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_heartbeats_enabled", emit_heartbeats_enabled)
        if replication_policy_class is not None:
            pulumi.set(__self__, "replication_policy_class", replication_policy_class)
        if sync_group_offsets_enabled is not None:
            pulumi.set(__self__, "sync_group_offsets_enabled", sync_group_offsets_enabled)
        if sync_group_offsets_interval_seconds is not None:
            pulumi.set(__self__, "sync_group_offsets_interval_seconds", sync_group_offsets_interval_seconds)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if topics_blacklists is not None:
            pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        Enable of disable replication flows for a service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> pulumi.Input[str]:
        """
        Source cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @source_cluster.setter
    def source_cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_cluster", value)

    @property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> pulumi.Input[str]:
        """
        Target cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @target_cluster.setter
    def target_cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_cluster", value)

    @property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Emit heartbeats enabled. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @emit_heartbeats_enabled.setter
    def emit_heartbeats_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emit_heartbeats_enabled", value)

    @property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> Optional[pulumi.Input[str]]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
        `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
        `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @replication_policy_class.setter
    def replication_policy_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_policy_class", value)

    @property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @sync_group_offsets_enabled.setter
    def sync_group_offsets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_group_offsets_enabled", value)

    @property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @sync_group_offsets_interval_seconds.setter
    def sync_group_offsets_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sync_group_offsets_interval_seconds", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of topics and/or regular expressions to replicate
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of topics and/or regular expressions to not replicate.
        """
        return pulumi.get(self, "topics_blacklists")

    @topics_blacklists.setter
    def topics_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics_blacklists", value)


@pulumi.input_type
class _MirrorMakerReplicationFlowState:
    def __init__(__self__, *,
                 emit_heartbeats_enabled: Optional[pulumi.Input[bool]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_policy_class: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_cluster: Optional[pulumi.Input[str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[int]] = None,
                 target_cluster: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering MirrorMakerReplicationFlow resources.
        :param pulumi.Input[bool] emit_heartbeats_enabled: Emit heartbeats enabled. The default value is `false`.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
               `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
               `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[str] service_name: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] source_cluster: Source cluster alias. Maximum Length: `128`.
        :param pulumi.Input[bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[str] target_cluster: Target cluster alias. Maximum Length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        if emit_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_heartbeats_enabled", emit_heartbeats_enabled)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_policy_class is not None:
            pulumi.set(__self__, "replication_policy_class", replication_policy_class)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if source_cluster is not None:
            pulumi.set(__self__, "source_cluster", source_cluster)
        if sync_group_offsets_enabled is not None:
            pulumi.set(__self__, "sync_group_offsets_enabled", sync_group_offsets_enabled)
        if sync_group_offsets_interval_seconds is not None:
            pulumi.set(__self__, "sync_group_offsets_interval_seconds", sync_group_offsets_interval_seconds)
        if target_cluster is not None:
            pulumi.set(__self__, "target_cluster", target_cluster)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if topics_blacklists is not None:
            pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Emit heartbeats enabled. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @emit_heartbeats_enabled.setter
    def emit_heartbeats_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emit_heartbeats_enabled", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable of disable replication flows for a service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> Optional[pulumi.Input[str]]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
        `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
        `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @replication_policy_class.setter
    def replication_policy_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_policy_class", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        Source cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @source_cluster.setter
    def source_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cluster", value)

    @property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @sync_group_offsets_enabled.setter
    def sync_group_offsets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_group_offsets_enabled", value)

    @property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @sync_group_offsets_interval_seconds.setter
    def sync_group_offsets_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sync_group_offsets_interval_seconds", value)

    @property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        Target cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @target_cluster.setter
    def target_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_cluster", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of topics and/or regular expressions to replicate
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of topics and/or regular expressions to not replicate.
        """
        return pulumi.get(self, "topics_blacklists")

    @topics_blacklists.setter
    def topics_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics_blacklists", value)


class MirrorMakerReplicationFlow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[bool]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_policy_class: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_cluster: Optional[pulumi.Input[str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[int]] = None,
                 target_cluster: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The MirrorMaker 2 Replication Flow resource allows the creation and management of MirrorMaker 2 Replication Flows on Aiven Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        f1 = aiven.MirrorMakerReplicationFlow("f1",
            project=aiven_project["kafka-mm-project1"]["project"],
            service_name=aiven_service["mm"]["service_name"],
            source_cluster=aiven_service["source"]["service_name"],
            target_cluster=aiven_service["target"]["service_name"],
            enable=True,
            topics=[".*"],
            topics_blacklists=[
                ".*[\\-\\.]internal",
                ".*\\.replica",
                "__.*",
            ])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow f1 project/service_name/source_cluster/target_cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] emit_heartbeats_enabled: Emit heartbeats enabled. The default value is `false`.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
               `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
               `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[str] service_name: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] source_cluster: Source cluster alias. Maximum Length: `128`.
        :param pulumi.Input[bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[str] target_cluster: Target cluster alias. Maximum Length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MirrorMakerReplicationFlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The MirrorMaker 2 Replication Flow resource allows the creation and management of MirrorMaker 2 Replication Flows on Aiven Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        f1 = aiven.MirrorMakerReplicationFlow("f1",
            project=aiven_project["kafka-mm-project1"]["project"],
            service_name=aiven_service["mm"]["service_name"],
            source_cluster=aiven_service["source"]["service_name"],
            target_cluster=aiven_service["target"]["service_name"],
            enable=True,
            topics=[".*"],
            topics_blacklists=[
                ".*[\\-\\.]internal",
                ".*\\.replica",
                "__.*",
            ])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow f1 project/service_name/source_cluster/target_cluster
        ```

        :param str resource_name: The name of the resource.
        :param MirrorMakerReplicationFlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MirrorMakerReplicationFlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[bool]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication_policy_class: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_cluster: Optional[pulumi.Input[str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[int]] = None,
                 target_cluster: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MirrorMakerReplicationFlowArgs.__new__(MirrorMakerReplicationFlowArgs)

            __props__.__dict__["emit_heartbeats_enabled"] = emit_heartbeats_enabled
            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["replication_policy_class"] = replication_policy_class
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if source_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'source_cluster'")
            __props__.__dict__["source_cluster"] = source_cluster
            __props__.__dict__["sync_group_offsets_enabled"] = sync_group_offsets_enabled
            __props__.__dict__["sync_group_offsets_interval_seconds"] = sync_group_offsets_interval_seconds
            if target_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'target_cluster'")
            __props__.__dict__["target_cluster"] = target_cluster
            __props__.__dict__["topics"] = topics
            __props__.__dict__["topics_blacklists"] = topics_blacklists
        super(MirrorMakerReplicationFlow, __self__).__init__(
            'aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            emit_heartbeats_enabled: Optional[pulumi.Input[bool]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            replication_policy_class: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            source_cluster: Optional[pulumi.Input[str]] = None,
            sync_group_offsets_enabled: Optional[pulumi.Input[bool]] = None,
            sync_group_offsets_interval_seconds: Optional[pulumi.Input[int]] = None,
            target_cluster: Optional[pulumi.Input[str]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'MirrorMakerReplicationFlow':
        """
        Get an existing MirrorMakerReplicationFlow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] emit_heartbeats_enabled: Emit heartbeats enabled. The default value is `false`.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
               `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
               `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[str] service_name: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] source_cluster: Source cluster alias. Maximum Length: `128`.
        :param pulumi.Input[bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[str] target_cluster: Target cluster alias. Maximum Length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MirrorMakerReplicationFlowState.__new__(_MirrorMakerReplicationFlowState)

        __props__.__dict__["emit_heartbeats_enabled"] = emit_heartbeats_enabled
        __props__.__dict__["enable"] = enable
        __props__.__dict__["project"] = project
        __props__.__dict__["replication_policy_class"] = replication_policy_class
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["source_cluster"] = source_cluster
        __props__.__dict__["sync_group_offsets_enabled"] = sync_group_offsets_enabled
        __props__.__dict__["sync_group_offsets_interval_seconds"] = sync_group_offsets_interval_seconds
        __props__.__dict__["target_cluster"] = target_cluster
        __props__.__dict__["topics"] = topics
        __props__.__dict__["topics_blacklists"] = topics_blacklists
        return MirrorMakerReplicationFlow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Emit heartbeats enabled. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[bool]:
        """
        Enable of disable replication flows for a service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> pulumi.Output[Optional[str]]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and
        `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is
        `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> pulumi.Output[str]:
        """
        Source cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> pulumi.Output[str]:
        """
        Target cluster alias. Maximum Length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of topics and/or regular expressions to replicate
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of topics and/or regular expressions to not replicate.
        """
        return pulumi.get(self, "topics_blacklists")

