# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['StaticIpArgs', 'StaticIp']

@pulumi.input_type
class StaticIpArgs:
    def __init__(__self__, *,
                 cloud_name: pulumi.Input[str],
                 project: pulumi.Input[str]):
        """
        The set of arguments for constructing a StaticIp resource.
        :param pulumi.Input[str] cloud_name: Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
               resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "cloud_name", cloud_name)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Input[str]:
        """
        Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
        resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _StaticIpState:
    def __init__(__self__, *,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 static_ip_address_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StaticIp resources.
        :param pulumi.Input[str] cloud_name: Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
               resource.
        :param pulumi.Input[str] ip_address: The address of the static ip
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: The service name the static ip is associated with.
        :param pulumi.Input[str] state: The state the static ip is in.
        :param pulumi.Input[str] static_ip_address_id: The static ip id of the resource. Should be used as a reference elsewhere.
        """
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_ip_address_id is not None:
            pulumi.set(__self__, "static_ip_address_id", static_ip_address_id)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
        resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the static ip
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service name the static ip is associated with.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state the static ip is in.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticIpAddressId")
    def static_ip_address_id(self) -> Optional[pulumi.Input[str]]:
        """
        The static ip id of the resource. Should be used as a reference elsewhere.
        """
        return pulumi.get(self, "static_ip_address_id")

    @static_ip_address_id.setter
    def static_ip_address_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "static_ip_address_id", value)


class StaticIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The aiven static_ip resource allows the creation and deletion of static ips. Please not that once a static ip is in the 'assigned' state it it is bound to the node it is assigned to and cannot be deleted or disassociated until the node is recycled. Plans that would delete static ips that are in the assigned state will be blocked.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
               resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The aiven static_ip resource allows the creation and deletion of static ips. Please not that once a static ip is in the 'assigned' state it it is bound to the node it is assigned to and cannot be deleted or disassociated until the node is recycled. Plans that would delete static ips that are in the assigned state will be blocked.

        :param str resource_name: The name of the resource.
        :param StaticIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticIpArgs.__new__(StaticIpArgs)

            if cloud_name is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_name'")
            __props__.__dict__["cloud_name"] = cloud_name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["static_ip_address_id"] = None
        super(StaticIp, __self__).__init__(
            'aiven:index/staticIp:StaticIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            static_ip_address_id: Optional[pulumi.Input[str]] = None) -> 'StaticIp':
        """
        Get an existing StaticIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
               resource.
        :param pulumi.Input[str] ip_address: The address of the static ip
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: The service name the static ip is associated with.
        :param pulumi.Input[str] state: The state the static ip is in.
        :param pulumi.Input[str] static_ip_address_id: The static ip id of the resource. Should be used as a reference elsewhere.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticIpState.__new__(_StaticIpState)

        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        __props__.__dict__["static_ip_address_id"] = static_ip_address_id
        return StaticIp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[str]:
        """
        Specifies the cloud that the static ip belongs to. This property cannot be changed, doing so forces recreation of the
        resource.
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The address of the static ip
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The service name the static ip is associated with.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state the static ip is in.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticIpAddressId")
    def static_ip_address_id(self) -> pulumi.Output[str]:
        """
        The static ip id of the resource. Should be used as a reference elsewhere.
        """
        return pulumi.get(self, "static_ip_address_id")

