# coding: utf-8

# (C) Copyright IBM Corp. 2022.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# IBM OpenAPI SDK Code Generator Version: 3.40.0-910cf8c2-20211006-154754
 
"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)

API Version: __VERSION__
"""

from datetime import datetime
from enum import Enum
from typing import BinaryIO, Dict, List
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import convert_model, datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################

class DirectLinkV1(BaseService):
    """The Direct Link V1 service."""

    DEFAULT_SERVICE_URL = 'https://directlink.cloud.ibm.com/v1'
    DEFAULT_SERVICE_NAME = 'direct_link'

    @classmethod
    def new_instance(cls,
                     version: str,
                     service_name: str = DEFAULT_SERVICE_NAME,
                    ) -> 'DirectLinkV1':
        """
        Return a new client for the Direct Link service using the specified
               parameters and external configuration.

        :param str version: Requests the version of the API as a date in the format
               `YYYY-MM-DD`. Any date from 2019-12-13 up to the current date may be
               provided. Specify the current date to request the latest version.
        """
        if version is None:
            raise ValueError('version must be provided')

        authenticator = get_authenticator_from_environment(service_name)
        service = cls(
            version,
            authenticator
            )
        service.configure_service(service_name)
        return service

    def __init__(self,
                 version: str,
                 authenticator: Authenticator = None,
                ) -> None:
        """
        Construct a new client for the Direct Link service.

        :param str version: Requests the version of the API as a date in the format
               `YYYY-MM-DD`. Any date from 2019-12-13 up to the current date may be
               provided. Specify the current date to request the latest version.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/main/README.md
               about initializing the authenticator of your choice.
        """
        if version is None:
            raise ValueError('version must be provided')

        BaseService.__init__(self,
                             service_url=self.DEFAULT_SERVICE_URL,
                             authenticator=authenticator)
        self.version = version


    #########################
    # gatewayASPrepends
    #########################


    def list_gateway_as_prepends(self,
        gateway_id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List AS Prepends.

        Retrieve all AS Prepends for the specified Direct Link gateway.

        :param str gateway_id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `AsPrependCollection` object
        """

        if not gateway_id:
            raise ValueError('gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_as_prepends')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/as_prepends'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def replace_gateway_as_prepends(self,
        gateway_id: str,
        if_match: str,
        *,
        as_prepends: List['AsPrependPrefixArrayTemplate'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Replace existing AS Prepends.

        Replace the given set of AS prepends on the specified gateway.  Existing resources
        may be reused when the individual AS Prepend item is unchanged.

        :param str gateway_id: Direct Link gateway identifier.
        :param str if_match: If present, the request will fail if the specified
               ETag value does not match the resource's current ETag value.
        :param List[AsPrependPrefixArrayTemplate] as_prepends: (optional) array of
               AS Prepend configuration information.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `AsPrependCollection` object
        """

        if not gateway_id:
            raise ValueError('gateway_id must be provided')
        if not if_match:
            raise ValueError('if_match must be provided')
        if as_prepends is not None:
            as_prepends = [convert_model(x) for x in as_prepends]
        headers = {
            'If-Match': if_match
        }
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='replace_gateway_as_prepends')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'as_prepends': as_prepends
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/as_prepends'.format(**path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # gatewayRouteReports
    #########################


    def list_gateway_route_reports(self,
        gateway_id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List route reports.

        Retrieve all route reports for the specified Direct Link gateway.

        :param str gateway_id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReportCollection` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_route_reports')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/route_reports'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def create_gateway_route_report(self,
        gateway_id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Request a route report.

        Request route report generation.  While report generation is in progress,
        additional requests to generate a report are ignored and return the current
        pending report. While `status` is `pending`, `gateway_routes`, `on_prem_routes`,
        `virtual_connection_routes`, and `overlapping_routes` will be empty arrays. These
        fields will be filled when the `status` enters the `completed` status.  Call
        `get_gateway_route_report` with the pending route report's `id` to check on the
        current status of the report.

        :param str gateway_id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReport` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/route_reports'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def delete_gateway_route_report(self,
        gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete route report.

        Delete a route report.

        :param str gateway_id: Direct Link gateway identifier.
        :param str id: Route report identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['gateway_id', 'id']
        path_param_values = self.encode_path_vars(gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/route_reports/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_gateway_route_report(self,
        gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieve route report.

        Retrieve a route report.

        :param str gateway_id: Direct Link gateway identifier.
        :param str id: Route report identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `RouteReport` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_route_report')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id', 'id']
        path_param_values = self.encode_path_vars(gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/route_reports/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # gateways
    #########################


    def list_gateways(self,
        **kwargs
    ) -> DetailedResponse:
        """
        List gateways.

        List all Direct Link gateways in this account.  Gateways in other accounts with
        connections to networks in this account are also returned.

        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateways')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/gateways'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def create_gateway(self,
        gateway_template: 'GatewayTemplate',
        **kwargs
    ) -> DetailedResponse:
        """
        Create gateway.

        Creates a Direct Link gateway based on the supplied template.

        :param GatewayTemplate gateway_template: The Direct Link Gateway template.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Gateway` object
        """

        if gateway_template is None:
            raise ValueError('gateway_template must be provided')
        if isinstance(gateway_template, GatewayTemplate):
            gateway_template = convert_model(gateway_template)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = json.dumps(gateway_template)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/gateways'
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def delete_gateway(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete gateway.

        Delete a Direct Link gateway.

        :param str id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_gateway(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get gateway.

        Retrieve a Direct Link gateway.

        :param str id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Gateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def update_gateway(self,
        id: str,
        *,
        authentication_key: 'GatewayPatchTemplateAuthenticationKey' = None,
        bfd_config: 'GatewayBfdPatchTemplate' = None,
        bgp_asn: int = None,
        bgp_cer_cidr: str = None,
        bgp_ibm_cidr: str = None,
        connection_mode: str = None,
        global_: bool = None,
        loa_reject_reason: str = None,
        macsec_config: 'GatewayMacsecConfigPatchTemplate' = None,
        metered: bool = None,
        name: str = None,
        operational_status: str = None,
        patch_panel_completion_notice: str = None,
        speed_mbps: int = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update gateway.

        Update a Direct Link gateway.

        :param str id: Direct Link gateway identifier.
        :param GatewayPatchTemplateAuthenticationKey authentication_key: (optional)
               The identity of the standard key to use for BGP MD5 authentication key.
               The key material that you provide must be base64 encoded and original
               string must be maximum 126 ASCII characters in length.
               To clear the optional `authentication_key` field patch its crn to `""`.
        :param GatewayBfdPatchTemplate bfd_config: (optional) BFD configuration
               information.
        :param int bgp_asn: (optional) The autonomous system number (ASN) of Border
               Gateway Protocol (BGP) configuration for the IBM side of the DL 2.0
               gateway.
        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR is the
               new CIDR (Classless Inter-Domain Routing) value to be updated on customer
               edge router for the DL 2.0 gateway.
               Customer edge IP and IBM IP should be in the same network. Updating
               customer edge router CIDR should be accompanied with IBM CIDR in the
               request. Update customer edge router IP to a valid bgp_cer_cidr and
               bgp_ibm_cidr CIDR, the value must reside in one of "10.254.0.0/16",
               "172.16.0.0/12", "192.168.0.0/16", "169.254.0.0/16" or an owned public
               CIDR.  bgp_cer_cidr and bgp_ibm_cidr must have matching network and subnet
               mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR is the new CIDR (Classless
               Inter-Domain Routing) value to be updated on IBM edge router for the DL 2.0
               gateway.
               IBM IP and customer edge IP should be in the same network. Updating IBM
               CIDR should be accompanied with customer edge router CIDR in the request.
               Update IBM CIDR to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value
               must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
               "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr
               must have matching network and subnet mask values.
        :param str connection_mode: (optional) Type of services this Gateway is
               attached to. Mode transit means this Gateway will be attached to Transit
               Gateway Service and direct means this Gateway will be attached to vpc or
               classic connection. The list of enumerated values for this property may
               expand in the future. Code and processes using this field  must tolerate
               unexpected values.
        :param bool global_: (optional) Gateways with global routing (`true`) can
               connect to networks outside of their associated region.
        :param str loa_reject_reason: (optional) Use this field during LOA
               rejection to provide the reason for the rejection.
               Only allowed for type=dedicated gateways.
        :param GatewayMacsecConfigPatchTemplate macsec_config: (optional) MACsec
               configuration information.  When patching any macsec_config fields, no
               other fields may be specified in the patch request.  Contact IBM support
               for access to MACsec.
               A MACsec config cannot be added to a gateway created without MACsec.
        :param bool metered: (optional) Metered billing option.  When `true`
               gateway usage is billed per gigabyte.  When `false` there is no per
               gigabyte usage charge, instead a flat rate is charged for the gateway.
        :param str name: (optional) The unique user-defined name for this gateway.
        :param str operational_status: (optional) Gateway operational status.
               For gateways pending LOA approval, patch operational_status to the
               appropriate value to approve or reject its LOA.  When rejecting an LOA,
               provide reject reasoning in `loa_reject_reason`.
               Only allowed for type=dedicated gateways.
        :param str patch_panel_completion_notice: (optional) Gateway patch panel
               complete notification from implementation team.
        :param int speed_mbps: (optional) Gateway speed in megabits per second.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Gateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        if authentication_key is not None:
            authentication_key = convert_model(authentication_key)
        if bfd_config is not None:
            bfd_config = convert_model(bfd_config)
        if macsec_config is not None:
            macsec_config = convert_model(macsec_config)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'authentication_key': authentication_key,
            'bfd_config': bfd_config,
            'bgp_asn': bgp_asn,
            'bgp_cer_cidr': bgp_cer_cidr,
            'bgp_ibm_cidr': bgp_ibm_cidr,
            'connection_mode': connection_mode,
            'global': global_,
            'loa_reject_reason': loa_reject_reason,
            'macsec_config': macsec_config,
            'metered': metered,
            'name': name,
            'operational_status': operational_status,
            'patch_panel_completion_notice': patch_panel_completion_notice,
            'speed_mbps': speed_mbps
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def create_gateway_action(self,
        id: str,
        action: str,
        *,
        as_prepends: List['AsPrependTemplate'] = None,
        authentication_key: 'GatewayActionTemplateAuthenticationKey' = None,
        bfd_config: 'GatewayBfdConfigActionTemplate' = None,
        connection_mode: str = None,
        global_: bool = None,
        metered: bool = None,
        resource_group: 'ResourceGroupIdentity' = None,
        updates: List['GatewayActionTemplateUpdatesItem'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Approve or reject change requests.

        Approve or reject a gateway's current oustanding change request.
        This API is only used for provider created Direct Link Connect gateways to approve
        or reject specific changes initiated from a provider portal.

        :param str id: Direct Link Connect gateway identifier.
        :param str action: Action request.
        :param List[AsPrependTemplate] as_prepends: (optional) Applicable for
               create_gateway_approve requests to create AS Prepends. Contains an array of
               AS Prepend configuration information.
        :param GatewayActionTemplateAuthenticationKey authentication_key:
               (optional) Applicable for create_gateway_approve requests to select the
               gateway's BGP MD5 authentication key.
               The key material that you provide must be base64 encoded and original
               string must be maximum 126 ASCII characters in length.
               To clear the optional `authentication_key` field patch its crn to `""`.
        :param GatewayBfdConfigActionTemplate bfd_config: (optional) Applicable for
               create_gateway_approve requests to select the gateway's BFD configuration
               information.
        :param str connection_mode: (optional) Applicable for
               create_gateway_approve requests to select the type of services this gateway
               is attached to. Mode transit indicates this gateway will be attached to
               Transit Gateway Service and direct means this gateway will be attached to
               vpc or classic connection. If unspecified on create_gateway_approve,
               default value direct is used. The list of enumerated values for this
               property may expand in the future. Code and processes using this field must
               tolerate unexpected values.
        :param bool global_: (optional) Applicable for create_gateway_approve
               requests to select the gateway's routing option. Gateways with global
               routing (`true`) can connect to networks outside of their associated
               region.
        :param bool metered: (optional) Applicable for create_gateway_approve
               requests to select the gateway's metered billing option.  When `true`
               gateway usage is billed per gigabyte.  When `false` there is no per
               gigabyte usage charge, instead a flat rate is charged for the gateway.
        :param ResourceGroupIdentity resource_group: (optional) Set for
               create_gateway_approve requests to select the gateway's resource group.  If
               unspecified on create_gateway_approve, the account's [default resource
               group](https://cloud.ibm.com/apidocs/resource-manager#introduction) is
               used.
        :param List[GatewayActionTemplateUpdatesItem] updates: (optional) Specify
               attribute updates being approved or rejected, update_attributes_approve and
               update_attributes_reject actions must provide an updates field that matches
               the gateway's current pending changes.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Gateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        if action is None:
            raise ValueError('action must be provided')
        if as_prepends is not None:
            as_prepends = [convert_model(x) for x in as_prepends]
        if authentication_key is not None:
            authentication_key = convert_model(authentication_key)
        if bfd_config is not None:
            bfd_config = convert_model(bfd_config)
        if resource_group is not None:
            resource_group = convert_model(resource_group)
        if updates is not None:
            updates = [convert_model(x) for x in updates]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_gateway_action')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'action': action,
            'as_prepends': as_prepends,
            'authentication_key': authentication_key,
            'bfd_config': bfd_config,
            'connection_mode': connection_mode,
            'global': global_,
            'metered': metered,
            'resource_group': resource_group,
            'updates': updates
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/actions'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_gateway_completion_notice(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get completion notice.

        Retrieve a Direct Link Dedicated gateway's completion notice.

        :param str id: Direct Link Dedicated gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `BinaryIO` result
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_completion_notice')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/pdf'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/completion_notice'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def create_gateway_completion_notice(self,
        id: str,
        *,
        upload: BinaryIO = None,
        upload_content_type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create completion notice.

        Upload a Direct Link Dedicated gateway completion notice.

        :param str id: Direct Link Dedicated gateway identifier.
        :param BinaryIO upload: (optional) Completion notice PDF file.
        :param str upload_content_type: (optional) The content type of upload.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_gateway_completion_notice')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        form_data = []
        if upload:
            form_data.append(('upload', (None, upload, upload_content_type or 'application/octet-stream')))

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/completion_notice'.format(**path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       files=form_data)

        response = self.send(request, **kwargs)
        return response


    def list_gateway_letter_of_authorization(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get letter of authorization.

        Retrieve a Direct Link Dedicated gateway's Letter of Authorization.

        :param str id: Direct Link Dedicated gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `BinaryIO` result
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_letter_of_authorization')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/pdf'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/letter_of_authorization'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_gateway_statistics(self,
        id: str,
        type: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Gateway statistics/debug information.

        Retrieve gateway statistics or debug information.  Specify statistic to retrieve
        using required `type` query parameter.

        :param str id: Direct Link gateway identifier.
        :param str type: Specify statistic to retrieve.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayStatisticCollection` object
        """

        if id is None:
            raise ValueError('id must be provided')
        if type is None:
            raise ValueError('type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_statistics')
        headers.update(sdk_headers)

        params = {
            'type': type,
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/statistics'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_gateway_status(self,
        id: str,
        *,
        type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Gateway status information.

        Retrieve gateway status.  Specify status to retrieve using required `type` query
        parameter.

        :param str id: Direct Link gateway identifier.
        :param str type: (optional) Specify status to retrieve.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayStatusCollection` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_status')
        headers.update(sdk_headers)

        params = {
            'version': self.version,
            'type': type
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{id}/status'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # offeringInformation
    #########################


    def list_offering_type_locations(self,
        offering_type: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List available locations.

        Retrieve the list of valid locations for the specified Direct Link offering.

        :param str offering_type: The Direct Link offering type.  Current supported
               values are `"dedicated"` and `"connect"`.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `LocationCollection` object
        """

        if offering_type is None:
            raise ValueError('offering_type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_offering_type_locations')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['offering_type']
        path_param_values = self.encode_path_vars(offering_type)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/offering_types/{offering_type}/locations'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def list_offering_type_location_cross_connect_routers(self,
        offering_type: str,
        location_name: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List routers.

        Retrieve location specific cross connect router information.  Only valid for
        offering_type=dedicated locations.

        :param str offering_type: The Direct Link offering type.  Only value
               `"dedicated"` is supported for this API.
        :param str location_name: The name of the Direct Link location.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `LocationCrossConnectRouterCollection` object
        """

        if offering_type is None:
            raise ValueError('offering_type must be provided')
        if location_name is None:
            raise ValueError('location_name must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_offering_type_location_cross_connect_routers')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['offering_type', 'location_name']
        path_param_values = self.encode_path_vars(offering_type, location_name)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/offering_types/{offering_type}/locations/{location_name}/cross_connect_routers'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def list_offering_type_speeds(self,
        offering_type: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List speed options.

        List the available Direct Link speeds.

        :param str offering_type: The Direct Link offering type.  Current supported
               values are `"dedicated"` and `"connect"`.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `OfferingSpeedCollection` object
        """

        if offering_type is None:
            raise ValueError('offering_type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_offering_type_speeds')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['offering_type']
        path_param_values = self.encode_path_vars(offering_type)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/offering_types/{offering_type}/speeds'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # ports
    #########################


    def list_ports(self,
        *,
        start: str = None,
        limit: int = None,
        location_name: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List ports.

        Retrieve list of available Direct Link connect ports.  These ports can be used to
        create Direct Link connect gateways.

        :param str start: (optional) A server-supplied token determining which
               resource to start the page on.
        :param int limit: (optional) The number of resources to return on a page.
        :param str location_name: (optional) Direct Link location short name.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `PortCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_ports')
        headers.update(sdk_headers)

        params = {
            'version': self.version,
            'start': start,
            'limit': limit,
            'location_name': location_name
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        url = '/ports'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_port(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get port.

        Retrieve Direct Link Connect provider port.

        :param str id: The port identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Port` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_port')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['id']
        path_param_values = self.encode_path_vars(id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/ports/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # virtualConnections
    #########################


    def list_gateway_virtual_connections(self,
        gateway_id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        List virtual connections.

        List a gateway's virtual connections.   For gateway in other account with virtual
        connections that connect to network in this account.  Only virtual connections
        that connect to this account are returned.

        :param str gateway_id: Direct Link gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayVirtualConnectionCollection` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_virtual_connections')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/virtual_connections'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def create_gateway_virtual_connection(self,
        gateway_id: str,
        name: str,
        type: str,
        *,
        network_id: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create virtual connection.

        Create a virtual connection to the specified network.

        :param str gateway_id: Direct Link gateway identifier.
        :param str name: The user-defined name for this virtual connection.
               Virtual connection names are unique within a gateway.  This is the name of
               the virtual connection itself, the network being connected may have its own
               name attribute.
        :param str type: The type of virtual connection.
        :param str network_id: (optional) Unique identifier of the target network.
               For type=vpc virtual connections this is the CRN of the target VPC.  This
               field does not apply to type=classic connections.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayVirtualConnection` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if type is None:
            raise ValueError('type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_gateway_virtual_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'name': name,
            'type': type,
            'network_id': network_id
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id']
        path_param_values = self.encode_path_vars(gateway_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/virtual_connections'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def delete_gateway_virtual_connection(self,
        gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete virtual connection.

        Delete the virtual connection.

        :param str gateway_id: Direct Link gateway identifier.
        :param str id: The virtual connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_gateway_virtual_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['gateway_id', 'id']
        path_param_values = self.encode_path_vars(gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/virtual_connections/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_gateway_virtual_connection(self,
        gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get virtual connection.

        Retrieve a virtual connection.

        :param str gateway_id: Direct Link gateway identifier.
        :param str id: The virtual connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayVirtualConnection` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_virtual_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id', 'id']
        path_param_values = self.encode_path_vars(gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/virtual_connections/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def update_gateway_virtual_connection(self,
        gateway_id: str,
        id: str,
        *,
        name: str = None,
        status: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update virtual connection.

        Update a virtual connection.

        :param str gateway_id: Direct Link gateway identifier.
        :param str id: The virtual connection identifier.
        :param str name: (optional) The user-defined name for this virtual
               connection.  Virtual connection names are unique within a gateway.  This is
               the name of the virtual connection itself, the network being connected may
               have its own name attribute.
        :param str status: (optional) Status of the virtual connection.  Virtual
               connections that span IBM Cloud Accounts are created in approval_pending
               status.  The owner of the target network can accept or reject connection
               requests by patching status to attached or rejected respectively.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GatewayVirtualConnection` object
        """

        if gateway_id is None:
            raise ValueError('gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_gateway_virtual_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'name': name,
            'status': status
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['gateway_id', 'id']
        path_param_values = self.encode_path_vars(gateway_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/gateways/{gateway_id}/virtual_connections/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


class GetGatewayStatisticsEnums:
    """
    Enums for get_gateway_statistics parameters.
    """

    class Type(str, Enum):
        """
        Specify statistic to retrieve.
        """
        MACSEC_MKA_SESSION = 'macsec_mka_session'
        MACSEC_POLICY = 'macsec_policy'
        MACSEC_MKA_STATISTICS = 'macsec_mka_statistics'
        BFD_SESSION = 'bfd_session'


class GetGatewayStatusEnums:
    """
    Enums for get_gateway_status parameters.
    """

    class Type(str, Enum):
        """
        Specify status to retrieve.
        """
        BGP = 'bgp'
        BFD = 'bfd'
        LINK = 'link'


class ListOfferingTypeLocationsEnums:
    """
    Enums for list_offering_type_locations parameters.
    """

    class OfferingType(str, Enum):
        """
        The Direct Link offering type.  Current supported values are `"dedicated"` and
        `"connect"`.
        """
        DEDICATED = 'dedicated'
        CONNECT = 'connect'


class ListOfferingTypeLocationCrossConnectRoutersEnums:
    """
    Enums for list_offering_type_location_cross_connect_routers parameters.
    """

    class OfferingType(str, Enum):
        """
        The Direct Link offering type.  Only value `"dedicated"` is supported for this
        API.
        """
        DEDICATED = 'dedicated'


class ListOfferingTypeSpeedsEnums:
    """
    Enums for list_offering_type_speeds parameters.
    """

    class OfferingType(str, Enum):
        """
        The Direct Link offering type.  Current supported values are `"dedicated"` and
        `"connect"`.
        """
        DEDICATED = 'dedicated'
        CONNECT = 'connect'


##############################################################################
# Models
##############################################################################


class AsPrepend():
    """
    AS Prepend.

    :attr datetime created_at: (optional) The date and time resource was created.
    :attr str id: (optional) The unique identifier for this AS Prepend.
    :attr int length: (optional) Number of times the ASN to appended to the AS Path.
    :attr str policy: (optional) Route type this AS Prepend applies to.
    :attr str prefix: (optional) Deprecated: Comma separated list of prefixes this
          AS Prepend applies to.  If empty, this applies to all prefixes.
    :attr List[str] specific_prefixes: (optional) Array of prefixes this AS Prepend
          applies to. This parameter is not returned when AS Prepend applies to all
          prefixes.  Note that ordering is not significant and may differ from request
          order.
    :attr datetime updated_at: (optional) The date and time resource was last
          updated.
    """

    def __init__(self,
                 *,
                 created_at: datetime = None,
                 id: str = None,
                 length: int = None,
                 policy: str = None,
                 prefix: str = None,
                 specific_prefixes: List[str] = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a AsPrepend object.

        :param datetime created_at: (optional) The date and time resource was
               created.
        :param str id: (optional) The unique identifier for this AS Prepend.
        :param int length: (optional) Number of times the ASN to appended to the AS
               Path.
        :param str policy: (optional) Route type this AS Prepend applies to.
        :param str prefix: (optional) Deprecated: Comma separated list of prefixes
               this AS Prepend applies to.  If empty, this applies to all prefixes.
        :param List[str] specific_prefixes: (optional) Array of prefixes this AS
               Prepend applies to. This parameter is not returned when AS Prepend applies
               to all prefixes.  Note that ordering is not significant and may differ from
               request order.
        :param datetime updated_at: (optional) The date and time resource was last
               updated.
        """
        self.created_at = created_at
        self.id = id
        self.length = length
        self.policy = policy
        self.prefix = prefix
        self.specific_prefixes = specific_prefixes
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'AsPrepend':
        """Initialize a AsPrepend object from a json dictionary."""
        args = {}
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        if 'length' in _dict:
            args['length'] = _dict.get('length')
        if 'policy' in _dict:
            args['policy'] = _dict.get('policy')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        if 'specific_prefixes' in _dict:
            args['specific_prefixes'] = _dict.get('specific_prefixes')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a AsPrepend object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'length') and self.length is not None:
            _dict['length'] = self.length
        if hasattr(self, 'policy') and self.policy is not None:
            _dict['policy'] = self.policy
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'specific_prefixes') and self.specific_prefixes is not None:
            _dict['specific_prefixes'] = self.specific_prefixes
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this AsPrepend object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'AsPrepend') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'AsPrepend') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class PolicyEnum(str, Enum):
        """
        Route type this AS Prepend applies to.
        """
        IMPORT = 'import'
        EXPORT = 'export'


class AsPrependCollection():
    """
    array of AS Prepends.

    :attr List[AsPrependEntry] as_prepends: (optional) array of AS Prepend
          information.
    """

    def __init__(self,
                 *,
                 as_prepends: List['AsPrependEntry'] = None) -> None:
        """
        Initialize a AsPrependCollection object.

        :param List[AsPrependEntry] as_prepends: (optional) array of AS Prepend
               information.
        """
        self.as_prepends = as_prepends

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'AsPrependCollection':
        """Initialize a AsPrependCollection object from a json dictionary."""
        args = {}
        if 'as_prepends' in _dict:
            args['as_prepends'] = [AsPrependEntry.from_dict(x) for x in _dict.get('as_prepends')]
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a AsPrependCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'as_prepends') and self.as_prepends is not None:
            _dict['as_prepends'] = [x.to_dict() for x in self.as_prepends]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this AsPrependCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'AsPrependCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'AsPrependCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class AsPrependEntry():
    """
    AS Prepends API object.

    :attr datetime created_at: (optional) The date and time resource was created.
    :attr str id: (optional) The unique identifier for this AS Prepend.
    :attr int length: (optional) Number of times the ASN to appended to the AS Path.
    :attr str policy: (optional) Route type this AS Prepend applies to.
    :attr List[str] specific_prefixes: (optional) Array of prefixes this AS Prepend
          applies to. This parameter is not returned when AS Prepend applies to all
          prefixes.  Note that ordering is not significant and may differ from request
          order.
    :attr datetime updated_at: (optional) The date and time resource was last
          updated.
    """

    def __init__(self,
                 *,
                 created_at: datetime = None,
                 id: str = None,
                 length: int = None,
                 policy: str = None,
                 specific_prefixes: List[str] = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a AsPrependEntry object.

        :param datetime created_at: (optional) The date and time resource was
               created.
        :param str id: (optional) The unique identifier for this AS Prepend.
        :param int length: (optional) Number of times the ASN to appended to the AS
               Path.
        :param str policy: (optional) Route type this AS Prepend applies to.
        :param List[str] specific_prefixes: (optional) Array of prefixes this AS
               Prepend applies to. This parameter is not returned when AS Prepend applies
               to all prefixes.  Note that ordering is not significant and may differ from
               request order.
        :param datetime updated_at: (optional) The date and time resource was last
               updated.
        """
        self.created_at = created_at
        self.id = id
        self.length = length
        self.policy = policy
        self.specific_prefixes = specific_prefixes
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'AsPrependEntry':
        """Initialize a AsPrependEntry object from a json dictionary."""
        args = {}
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        if 'length' in _dict:
            args['length'] = _dict.get('length')
        if 'policy' in _dict:
            args['policy'] = _dict.get('policy')
        if 'specific_prefixes' in _dict:
            args['specific_prefixes'] = _dict.get('specific_prefixes')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a AsPrependEntry object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'length') and self.length is not None:
            _dict['length'] = self.length
        if hasattr(self, 'policy') and self.policy is not None:
            _dict['policy'] = self.policy
        if hasattr(self, 'specific_prefixes') and self.specific_prefixes is not None:
            _dict['specific_prefixes'] = self.specific_prefixes
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this AsPrependEntry object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'AsPrependEntry') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'AsPrependEntry') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class PolicyEnum(str, Enum):
        """
        Route type this AS Prepend applies to.
        """
        IMPORT = 'import'
        EXPORT = 'export'


class AsPrependPrefixArrayTemplate():
    """
    Create AS Prepend Configuration template.

    :attr int length: Number of times the ASN to be prepended to the AS Path.
    :attr str policy: Route type this AS Prepend applies to.
    :attr List[str] specific_prefixes: (optional) Array of prefixes this AS Prepend
          applies to. If this property is absent, the AS Prepend applies to all prefixes.
          Note that ordering is not significant and may differ from request order.
    """

    def __init__(self,
                 length: int,
                 policy: str,
                 *,
                 specific_prefixes: List[str] = None) -> None:
        """
        Initialize a AsPrependPrefixArrayTemplate object.

        :param int length: Number of times the ASN to be prepended to the AS Path.
        :param str policy: Route type this AS Prepend applies to.
        :param List[str] specific_prefixes: (optional) Array of prefixes this AS
               Prepend applies to. If this property is absent, the AS Prepend applies to
               all prefixes.  Note that ordering is not significant and may differ from
               request order.
        """
        self.length = length
        self.policy = policy
        self.specific_prefixes = specific_prefixes

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'AsPrependPrefixArrayTemplate':
        """Initialize a AsPrependPrefixArrayTemplate object from a json dictionary."""
        args = {}
        if 'length' in _dict:
            args['length'] = _dict.get('length')
        else:
            raise ValueError('Required property \'length\' not present in AsPrependPrefixArrayTemplate JSON')
        if 'policy' in _dict:
            args['policy'] = _dict.get('policy')
        else:
            raise ValueError('Required property \'policy\' not present in AsPrependPrefixArrayTemplate JSON')
        if 'specific_prefixes' in _dict:
            args['specific_prefixes'] = _dict.get('specific_prefixes')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a AsPrependPrefixArrayTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'length') and self.length is not None:
            _dict['length'] = self.length
        if hasattr(self, 'policy') and self.policy is not None:
            _dict['policy'] = self.policy
        if hasattr(self, 'specific_prefixes') and self.specific_prefixes is not None:
            _dict['specific_prefixes'] = self.specific_prefixes
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this AsPrependPrefixArrayTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'AsPrependPrefixArrayTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'AsPrependPrefixArrayTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class PolicyEnum(str, Enum):
        """
        Route type this AS Prepend applies to.
        """
        IMPORT = 'import'
        EXPORT = 'export'


class AsPrependTemplate():
    """
    Create AS Prepend Configuration template.

    :attr int length: Number of times the ASN to be prepended to the AS Path.
    :attr str policy: Route type this AS Prepend applies to.
    :attr str prefix: (optional) Deprecated: Comma separated list of prefixes this
          AS Prepend applies to.  Maximum of 10 prefixes.  If not specified, this AS
          Prepend applies to all prefixes.
    :attr List[str] specific_prefixes: (optional) Array of prefixes this AS Prepend
          applies to. If this property is absent, the AS Prepend applies to all prefixes.
    """

    def __init__(self,
                 length: int,
                 policy: str,
                 *,
                 prefix: str = None,
                 specific_prefixes: List[str] = None) -> None:
        """
        Initialize a AsPrependTemplate object.

        :param int length: Number of times the ASN to be prepended to the AS Path.
        :param str policy: Route type this AS Prepend applies to.
        :param str prefix: (optional) Deprecated: Comma separated list of prefixes
               this AS Prepend applies to.  Maximum of 10 prefixes.  If not specified,
               this AS Prepend applies to all prefixes.
        :param List[str] specific_prefixes: (optional) Array of prefixes this AS
               Prepend applies to. If this property is absent, the AS Prepend applies to
               all prefixes.
        """
        self.length = length
        self.policy = policy
        self.prefix = prefix
        self.specific_prefixes = specific_prefixes

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'AsPrependTemplate':
        """Initialize a AsPrependTemplate object from a json dictionary."""
        args = {}
        if 'length' in _dict:
            args['length'] = _dict.get('length')
        else:
            raise ValueError('Required property \'length\' not present in AsPrependTemplate JSON')
        if 'policy' in _dict:
            args['policy'] = _dict.get('policy')
        else:
            raise ValueError('Required property \'policy\' not present in AsPrependTemplate JSON')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        if 'specific_prefixes' in _dict:
            args['specific_prefixes'] = _dict.get('specific_prefixes')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a AsPrependTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'length') and self.length is not None:
            _dict['length'] = self.length
        if hasattr(self, 'policy') and self.policy is not None:
            _dict['policy'] = self.policy
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'specific_prefixes') and self.specific_prefixes is not None:
            _dict['specific_prefixes'] = self.specific_prefixes
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this AsPrependTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'AsPrependTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'AsPrependTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class PolicyEnum(str, Enum):
        """
        Route type this AS Prepend applies to.
        """
        IMPORT = 'import'
        EXPORT = 'export'


class CrossConnectRouter():
    """
    Cross Connect Router details.

    :attr List[str] capabilities: (optional) Array of capabilities for this router.
    :attr str router_name: (optional) The name of the Router.
    :attr int total_connections: (optional) Count of existing Direct Link Dedicated
          gateways on this router for this account.
    """

    def __init__(self,
                 *,
                 capabilities: List[str] = None,
                 router_name: str = None,
                 total_connections: int = None) -> None:
        """
        Initialize a CrossConnectRouter object.

        :param List[str] capabilities: (optional) Array of capabilities for this
               router.
        :param str router_name: (optional) The name of the Router.
        :param int total_connections: (optional) Count of existing Direct Link
               Dedicated gateways on this router for this account.
        """
        self.capabilities = capabilities
        self.router_name = router_name
        self.total_connections = total_connections

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'CrossConnectRouter':
        """Initialize a CrossConnectRouter object from a json dictionary."""
        args = {}
        if 'capabilities' in _dict:
            args['capabilities'] = _dict.get('capabilities')
        if 'router_name' in _dict:
            args['router_name'] = _dict.get('router_name')
        if 'total_connections' in _dict:
            args['total_connections'] = _dict.get('total_connections')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a CrossConnectRouter object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'capabilities') and self.capabilities is not None:
            _dict['capabilities'] = self.capabilities
        if hasattr(self, 'router_name') and self.router_name is not None:
            _dict['router_name'] = self.router_name
        if hasattr(self, 'total_connections') and self.total_connections is not None:
            _dict['total_connections'] = self.total_connections
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this CrossConnectRouter object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'CrossConnectRouter') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'CrossConnectRouter') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Gateway():
    """
    gateway.

    :attr List[AsPrepend] as_prepends: (optional) array of AS Prepend information.
    :attr GatewayAuthenticationKey authentication_key: (optional) The identity of
          the standard key to use for BGP MD5 authentication key.
          The key material that you provide must be base64 encoded and original string
          must be maximum 126 ASCII characters in length.
          To clear the optional `authentication_key` field patch its crn to `""`.
    :attr GatewayBfdConfig bfd_config: (optional) BFD configuration information.
    :attr int bgp_asn: Customer BGP ASN.
    :attr str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR is deprecated and
          no longer recognized by the Direct Link APIs.
          See bgp_cer_cidr and bgp_ibm_cidr fields instead for IP related information.
          Deprecated field bgp_base_cidr will be removed from the API specificiation after
          15-MAR-2021.
    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
    :attr int bgp_ibm_asn: (optional) IBM BGP ASN.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR.
    :attr str bgp_status: (optional) Gateway BGP status. The list of enumerated
          values for this property may expand in the future. Code and processes using this
          field  must tolerate unexpected values.
    :attr datetime bgp_status_updated_at: (optional) Date and time bgp status was
          updated.
    :attr str carrier_name: (optional) Carrier name.  Only set for type=dedicated
          gateways.
    :attr GatewayChangeRequest change_request: (optional) Changes pending approval
          for provider managed Direct Link Connect gateways.
    :attr str completion_notice_reject_reason: (optional) Reason for completion
          notice rejection.  Only included on type=dedicated gateways with a rejected
          completion notice.
    :attr str connection_mode: (optional) Type of services this Gateway is attached
          to. Mode transit means this Gateway will be attached to Transit Gateway Service
          and direct means this Gateway will be attached to vpc or classic connection. The
          list of enumerated values for this property may expand in the future. Code and
          processes using this field  must tolerate unexpected values.
    :attr datetime created_at: The date and time resource was created.
    :attr str crn: The CRN (Cloud Resource Name) of this gateway.
    :attr str cross_connect_router: (optional) Cross connect router.  Only included
          on type=dedicated gateways.
    :attr str customer_name: (optional) Customer name.  Only set for type=dedicated
          gateways.
    :attr bool global_: Gateways with global routing (`true`) can connect to
          networks outside their associated region.
    :attr str id: The unique identifier of this gateway.
    :attr str link_status: (optional) Gateway link status.  Only included on
          type=dedicated gateways. The list of enumerated values for this property may
          expand in the future. Code and processes using this field  must tolerate
          unexpected values.
    :attr datetime link_status_updated_at: (optional) Date and time link status was
          updated.
    :attr str location_display_name: Gateway location long name.
    :attr str location_name: Gateway location.
    :attr GatewayMacsecConfig macsec_config: (optional) MACsec configuration
          information.  For Dedicated Gateways with MACsec configured, return
          configuration information.  Contact IBM support for access to MACsec.
    :attr bool metered: Metered billing option.  When `true` gateway usage is billed
          per gigabyte.  When `false` there is no per gigabyte usage charge, instead a
          flat rate is charged for the gateway.
    :attr str name: The unique user-defined name for this gateway.
    :attr str operational_status: Gateway operational status. The list of enumerated
          values for this property may expand in the future. Code and processes using this
          field  must tolerate unexpected values.
    :attr str patch_panel_completion_notice: (optional) Gateway patch panel complete
          notification from implementation team.
    :attr GatewayPort port: (optional) gateway port for type=connect gateways.
    :attr bool provider_api_managed: (optional) Indicates whether gateway changes
          must be made via a provider portal.
    :attr ResourceGroupReference resource_group: (optional) Resource group
          reference.
    :attr int speed_mbps: Gateway speed in megabits per second.
    :attr str type: Offering type. The list of enumerated values for this property
          may expand in the future. Code and processes using this field  must tolerate
          unexpected values.
    :attr int vlan: (optional) VLAN allocated for this gateway.  Only set for
          type=connect gateways.
    """

    def __init__(self,
                 bgp_asn: int,
                 created_at: datetime,
                 crn: str,
                 global_: bool,
                 id: str,
                 location_display_name: str,
                 location_name: str,
                 metered: bool,
                 name: str,
                 operational_status: str,
                 speed_mbps: int,
                 type: str,
                 *,
                 as_prepends: List['AsPrepend'] = None,
                 authentication_key: 'GatewayAuthenticationKey' = None,
                 bfd_config: 'GatewayBfdConfig' = None,
                 bgp_base_cidr: str = None,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_asn: int = None,
                 bgp_ibm_cidr: str = None,
                 bgp_status: str = None,
                 bgp_status_updated_at: datetime = None,
                 carrier_name: str = None,
                 change_request: 'GatewayChangeRequest' = None,
                 completion_notice_reject_reason: str = None,
                 connection_mode: str = None,
                 cross_connect_router: str = None,
                 customer_name: str = None,
                 link_status: str = None,
                 link_status_updated_at: datetime = None,
                 macsec_config: 'GatewayMacsecConfig' = None,
                 patch_panel_completion_notice: str = None,
                 port: 'GatewayPort' = None,
                 provider_api_managed: bool = None,
                 resource_group: 'ResourceGroupReference' = None,
                 vlan: int = None) -> None:
        """
        Initialize a Gateway object.

        :param int bgp_asn: Customer BGP ASN.
        :param datetime created_at: The date and time resource was created.
        :param str crn: The CRN (Cloud Resource Name) of this gateway.
        :param bool global_: Gateways with global routing (`true`) can connect to
               networks outside their associated region.
        :param str id: The unique identifier of this gateway.
        :param str location_display_name: Gateway location long name.
        :param str location_name: Gateway location.
        :param bool metered: Metered billing option.  When `true` gateway usage is
               billed per gigabyte.  When `false` there is no per gigabyte usage charge,
               instead a flat rate is charged for the gateway.
        :param str name: The unique user-defined name for this gateway.
        :param str operational_status: Gateway operational status. The list of
               enumerated values for this property may expand in the future. Code and
               processes using this field  must tolerate unexpected values.
        :param int speed_mbps: Gateway speed in megabits per second.
        :param str type: Offering type. The list of enumerated values for this
               property may expand in the future. Code and processes using this field
               must tolerate unexpected values.
        :param List[AsPrepend] as_prepends: (optional) array of AS Prepend
               information.
        :param GatewayAuthenticationKey authentication_key: (optional) The identity
               of the standard key to use for BGP MD5 authentication key.
               The key material that you provide must be base64 encoded and original
               string must be maximum 126 ASCII characters in length.
               To clear the optional `authentication_key` field patch its crn to `""`.
        :param GatewayBfdConfig bfd_config: (optional) BFD configuration
               information.
        :param str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR is
               deprecated and no longer recognized by the Direct Link APIs.
               See bgp_cer_cidr and bgp_ibm_cidr fields instead for IP related
               information.
               Deprecated field bgp_base_cidr will be removed from the API specificiation
               after 15-MAR-2021.
        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
        :param int bgp_ibm_asn: (optional) IBM BGP ASN.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR.
        :param str bgp_status: (optional) Gateway BGP status. The list of
               enumerated values for this property may expand in the future. Code and
               processes using this field  must tolerate unexpected values.
        :param datetime bgp_status_updated_at: (optional) Date and time bgp status
               was updated.
        :param str carrier_name: (optional) Carrier name.  Only set for
               type=dedicated gateways.
        :param GatewayChangeRequest change_request: (optional) Changes pending
               approval for provider managed Direct Link Connect gateways.
        :param str completion_notice_reject_reason: (optional) Reason for
               completion notice rejection.  Only included on type=dedicated gateways with
               a rejected completion notice.
        :param str connection_mode: (optional) Type of services this Gateway is
               attached to. Mode transit means this Gateway will be attached to Transit
               Gateway Service and direct means this Gateway will be attached to vpc or
               classic connection. The list of enumerated values for this property may
               expand in the future. Code and processes using this field  must tolerate
               unexpected values.
        :param str cross_connect_router: (optional) Cross connect router.  Only
               included on type=dedicated gateways.
        :param str customer_name: (optional) Customer name.  Only set for
               type=dedicated gateways.
        :param str link_status: (optional) Gateway link status.  Only included on
               type=dedicated gateways. The list of enumerated values for this property
               may expand in the future. Code and processes using this field  must
               tolerate unexpected values.
        :param datetime link_status_updated_at: (optional) Date and time link
               status was updated.
        :param GatewayMacsecConfig macsec_config: (optional) MACsec configuration
               information.  For Dedicated Gateways with MACsec configured, return
               configuration information.  Contact IBM support for access to MACsec.
        :param str patch_panel_completion_notice: (optional) Gateway patch panel
               complete notification from implementation team.
        :param GatewayPort port: (optional) gateway port for type=connect gateways.
        :param bool provider_api_managed: (optional) Indicates whether gateway
               changes must be made via a provider portal.
        :param ResourceGroupReference resource_group: (optional) Resource group
               reference.
        :param int vlan: (optional) VLAN allocated for this gateway.  Only set for
               type=connect gateways.
        """
        self.as_prepends = as_prepends
        self.authentication_key = authentication_key
        self.bfd_config = bfd_config
        self.bgp_asn = bgp_asn
        self.bgp_base_cidr = bgp_base_cidr
        self.bgp_cer_cidr = bgp_cer_cidr
        self.bgp_ibm_asn = bgp_ibm_asn
        self.bgp_ibm_cidr = bgp_ibm_cidr
        self.bgp_status = bgp_status
        self.bgp_status_updated_at = bgp_status_updated_at
        self.carrier_name = carrier_name
        self.change_request = change_request
        self.completion_notice_reject_reason = completion_notice_reject_reason
        self.connection_mode = connection_mode
        self.created_at = created_at
        self.crn = crn
        self.cross_connect_router = cross_connect_router
        self.customer_name = customer_name
        self.global_ = global_
        self.id = id
        self.link_status = link_status
        self.link_status_updated_at = link_status_updated_at
        self.location_display_name = location_display_name
        self.location_name = location_name
        self.macsec_config = macsec_config
        self.metered = metered
        self.name = name
        self.operational_status = operational_status
        self.patch_panel_completion_notice = patch_panel_completion_notice
        self.port = port
        self.provider_api_managed = provider_api_managed
        self.resource_group = resource_group
        self.speed_mbps = speed_mbps
        self.type = type
        self.vlan = vlan

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Gateway':
        """Initialize a Gateway object from a json dictionary."""
        args = {}
        if 'as_prepends' in _dict:
            args['as_prepends'] = [AsPrepend.from_dict(x) for x in _dict.get('as_prepends')]
        if 'authentication_key' in _dict:
            args['authentication_key'] = GatewayAuthenticationKey.from_dict(_dict.get('authentication_key'))
        if 'bfd_config' in _dict:
            args['bfd_config'] = GatewayBfdConfig.from_dict(_dict.get('bfd_config'))
        if 'bgp_asn' in _dict:
            args['bgp_asn'] = _dict.get('bgp_asn')
        else:
            raise ValueError('Required property \'bgp_asn\' not present in Gateway JSON')
        if 'bgp_base_cidr' in _dict:
            args['bgp_base_cidr'] = _dict.get('bgp_base_cidr')
        if 'bgp_cer_cidr' in _dict:
            args['bgp_cer_cidr'] = _dict.get('bgp_cer_cidr')
        if 'bgp_ibm_asn' in _dict:
            args['bgp_ibm_asn'] = _dict.get('bgp_ibm_asn')
        if 'bgp_ibm_cidr' in _dict:
            args['bgp_ibm_cidr'] = _dict.get('bgp_ibm_cidr')
        if 'bgp_status' in _dict:
            args['bgp_status'] = _dict.get('bgp_status')
        if 'bgp_status_updated_at' in _dict:
            args['bgp_status_updated_at'] = string_to_datetime(_dict.get('bgp_status_updated_at'))
        if 'carrier_name' in _dict:
            args['carrier_name'] = _dict.get('carrier_name')
        if 'change_request' in _dict:
            args['change_request'] = _dict.get('change_request')
        if 'completion_notice_reject_reason' in _dict:
            args['completion_notice_reject_reason'] = _dict.get('completion_notice_reject_reason')
        if 'connection_mode' in _dict:
            args['connection_mode'] = _dict.get('connection_mode')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in Gateway JSON')
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in Gateway JSON')
        if 'cross_connect_router' in _dict:
            args['cross_connect_router'] = _dict.get('cross_connect_router')
        if 'customer_name' in _dict:
            args['customer_name'] = _dict.get('customer_name')
        if 'global' in _dict:
            args['global_'] = _dict.get('global')
        else:
            raise ValueError('Required property \'global\' not present in Gateway JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Gateway JSON')
        if 'link_status' in _dict:
            args['link_status'] = _dict.get('link_status')
        if 'link_status_updated_at' in _dict:
            args['link_status_updated_at'] = string_to_datetime(_dict.get('link_status_updated_at'))
        if 'location_display_name' in _dict:
            args['location_display_name'] = _dict.get('location_display_name')
        else:
            raise ValueError('Required property \'location_display_name\' not present in Gateway JSON')
        if 'location_name' in _dict:
            args['location_name'] = _dict.get('location_name')
        else:
            raise ValueError('Required property \'location_name\' not present in Gateway JSON')
        if 'macsec_config' in _dict:
            args['macsec_config'] = GatewayMacsecConfig.from_dict(_dict.get('macsec_config'))
        if 'metered' in _dict:
            args['metered'] = _dict.get('metered')
        else:
            raise ValueError('Required property \'metered\' not present in Gateway JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Gateway JSON')
        if 'operational_status' in _dict:
            args['operational_status'] = _dict.get('operational_status')
        else:
            raise ValueError('Required property \'operational_status\' not present in Gateway JSON')
        if 'patch_panel_completion_notice' in _dict:
            args['patch_panel_completion_notice'] = _dict.get('patch_panel_completion_notice')
        if 'port' in _dict:
            args['port'] = GatewayPort.from_dict(_dict.get('port'))
        if 'provider_api_managed' in _dict:
            args['provider_api_managed'] = _dict.get('provider_api_managed')
        if 'resource_group' in _dict:
            args['resource_group'] = ResourceGroupReference.from_dict(_dict.get('resource_group'))
        if 'speed_mbps' in _dict:
            args['speed_mbps'] = _dict.get('speed_mbps')
        else:
            raise ValueError('Required property \'speed_mbps\' not present in Gateway JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in Gateway JSON')
        if 'vlan' in _dict:
            args['vlan'] = _dict.get('vlan')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Gateway object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'as_prepends') and self.as_prepends is not None:
            _dict['as_prepends'] = [x.to_dict() for x in self.as_prepends]
        if hasattr(self, 'authentication_key') and self.authentication_key is not None:
            _dict['authentication_key'] = self.authentication_key.to_dict()
        if hasattr(self, 'bfd_config') and self.bfd_config is not None:
            _dict['bfd_config'] = self.bfd_config.to_dict()
        if hasattr(self, 'bgp_asn') and self.bgp_asn is not None:
            _dict['bgp_asn'] = self.bgp_asn
        if hasattr(self, 'bgp_base_cidr') and self.bgp_base_cidr is not None:
            _dict['bgp_base_cidr'] = self.bgp_base_cidr
        if hasattr(self, 'bgp_cer_cidr') and self.bgp_cer_cidr is not None:
            _dict['bgp_cer_cidr'] = self.bgp_cer_cidr
        if hasattr(self, 'bgp_ibm_asn') and self.bgp_ibm_asn is not None:
            _dict['bgp_ibm_asn'] = self.bgp_ibm_asn
        if hasattr(self, 'bgp_ibm_cidr') and self.bgp_ibm_cidr is not None:
            _dict['bgp_ibm_cidr'] = self.bgp_ibm_cidr
        if hasattr(self, 'bgp_status') and self.bgp_status is not None:
            _dict['bgp_status'] = self.bgp_status
        if hasattr(self, 'bgp_status_updated_at') and self.bgp_status_updated_at is not None:
            _dict['bgp_status_updated_at'] = datetime_to_string(self.bgp_status_updated_at)
        if hasattr(self, 'carrier_name') and self.carrier_name is not None:
            _dict['carrier_name'] = self.carrier_name
        if hasattr(self, 'change_request') and self.change_request is not None:
            if isinstance(self.change_request, dict):
                _dict['change_request'] = self.change_request
            else:
                _dict['change_request'] = self.change_request.to_dict()
        if hasattr(self, 'completion_notice_reject_reason') and self.completion_notice_reject_reason is not None:
            _dict['completion_notice_reject_reason'] = self.completion_notice_reject_reason
        if hasattr(self, 'connection_mode') and self.connection_mode is not None:
            _dict['connection_mode'] = self.connection_mode
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'cross_connect_router') and self.cross_connect_router is not None:
            _dict['cross_connect_router'] = self.cross_connect_router
        if hasattr(self, 'customer_name') and self.customer_name is not None:
            _dict['customer_name'] = self.customer_name
        if hasattr(self, 'global_') and self.global_ is not None:
            _dict['global'] = self.global_
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'link_status') and self.link_status is not None:
            _dict['link_status'] = self.link_status
        if hasattr(self, 'link_status_updated_at') and self.link_status_updated_at is not None:
            _dict['link_status_updated_at'] = datetime_to_string(self.link_status_updated_at)
        if hasattr(self, 'location_display_name') and self.location_display_name is not None:
            _dict['location_display_name'] = self.location_display_name
        if hasattr(self, 'location_name') and self.location_name is not None:
            _dict['location_name'] = self.location_name
        if hasattr(self, 'macsec_config') and self.macsec_config is not None:
            _dict['macsec_config'] = self.macsec_config.to_dict()
        if hasattr(self, 'metered') and self.metered is not None:
            _dict['metered'] = self.metered
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'operational_status') and self.operational_status is not None:
            _dict['operational_status'] = self.operational_status
        if hasattr(self, 'patch_panel_completion_notice') and self.patch_panel_completion_notice is not None:
            _dict['patch_panel_completion_notice'] = self.patch_panel_completion_notice
        if hasattr(self, 'port') and self.port is not None:
            _dict['port'] = self.port.to_dict()
        if hasattr(self, 'provider_api_managed') and self.provider_api_managed is not None:
            _dict['provider_api_managed'] = self.provider_api_managed
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group.to_dict()
        if hasattr(self, 'speed_mbps') and self.speed_mbps is not None:
            _dict['speed_mbps'] = self.speed_mbps
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'vlan') and self.vlan is not None:
            _dict['vlan'] = self.vlan
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Gateway object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Gateway') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Gateway') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class BgpStatusEnum(str, Enum):
        """
        Gateway BGP status. The list of enumerated values for this property may expand in
        the future. Code and processes using this field  must tolerate unexpected values.
        """
        ACTIVE = 'active'
        CONNECT = 'connect'
        ESTABLISHED = 'established'
        IDLE = 'idle'


    class ConnectionModeEnum(str, Enum):
        """
        Type of services this Gateway is attached to. Mode transit means this Gateway will
        be attached to Transit Gateway Service and direct means this Gateway will be
        attached to vpc or classic connection. The list of enumerated values for this
        property may expand in the future. Code and processes using this field  must
        tolerate unexpected values.
        """
        DIRECT = 'direct'
        TRANSIT = 'transit'


    class LinkStatusEnum(str, Enum):
        """
        Gateway link status.  Only included on type=dedicated gateways. The list of
        enumerated values for this property may expand in the future. Code and processes
        using this field  must tolerate unexpected values.
        """
        DOWN = 'down'
        UP = 'up'


    class OperationalStatusEnum(str, Enum):
        """
        Gateway operational status. The list of enumerated values for this property may
        expand in the future. Code and processes using this field  must tolerate
        unexpected values.
        """
        AWAITING_COMPLETION_NOTICE = 'awaiting_completion_notice'
        AWAITING_LOA = 'awaiting_loa'
        CONFIGURING = 'configuring'
        CREATE_PENDING = 'create_pending'
        CREATE_REJECTED = 'create_rejected'
        COMPLETION_NOTICE_APPROVED = 'completion_notice_approved'
        COMPLETION_NOTICE_RECEIVED = 'completion_notice_received'
        COMPLETION_NOTICE_REJECTED = 'completion_notice_rejected'
        DELETE_PENDING = 'delete_pending'
        LOA_ACCEPTED = 'loa_accepted'
        LOA_CREATED = 'loa_created'
        LOA_REJECTED = 'loa_rejected'
        PROVISIONED = 'provisioned'


    class TypeEnum(str, Enum):
        """
        Offering type. The list of enumerated values for this property may expand in the
        future. Code and processes using this field  must tolerate unexpected values.
        """
        CONNECT = 'connect'
        DEDICATED = 'dedicated'


class GatewayActionTemplateAuthenticationKey():
    """
    Applicable for create_gateway_approve requests to select the gateway's BGP MD5
    authentication key. The key material that you provide must be base64 encoded and
    original string must be maximum 126 ASCII characters in length. To clear the optional
    `authentication_key` field patch its crn to `""`.

    :attr str crn: The CRN of the [Key Protect Standard
          Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
          or [Hyper Protect Crypto Service Standard
          Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for this
          resource.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayActionTemplateAuthenticationKey object.

        :param str crn: The CRN of the [Key Protect Standard
               Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
               or [Hyper Protect Crypto Service Standard
               Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for
               this resource.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayActionTemplateAuthenticationKey':
        """Initialize a GatewayActionTemplateAuthenticationKey object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayActionTemplateAuthenticationKey JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayActionTemplateAuthenticationKey object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayActionTemplateAuthenticationKey object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayActionTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayActionTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayActionTemplateUpdatesItem():
    """
    GatewayActionTemplateUpdatesItem.

    """

    def __init__(self) -> None:
        """
        Initialize a GatewayActionTemplateUpdatesItem object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate', 'GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate', 'GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate', 'GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate']))
        raise Exception(msg)

class GatewayAuthenticationKey():
    """
    The identity of the standard key to use for BGP MD5 authentication key. The key
    material that you provide must be base64 encoded and original string must be maximum
    126 ASCII characters in length. To clear the optional `authentication_key` field patch
    its crn to `""`.

    :attr str crn: The CRN of the [Key Protect Standard
          Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
          or [Hyper Protect Crypto Service Standard
          Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for this
          resource.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayAuthenticationKey object.

        :param str crn: The CRN of the [Key Protect Standard
               Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
               or [Hyper Protect Crypto Service Standard
               Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for
               this resource.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayAuthenticationKey':
        """Initialize a GatewayAuthenticationKey object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayAuthenticationKey JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayAuthenticationKey object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayAuthenticationKey object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayAuthenticationKey') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayAuthenticationKey') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayBfdConfig():
    """
    BFD configuration information.

    :attr str bfd_status: (optional) Gateway BFD status. The list of enumerated
          values for this property may expand in the future. Code and processes using this
          field must tolerate unexpected values.
    :attr datetime bfd_status_updated_at: (optional) Date and time bfd status was
          updated.
    :attr int interval: Minimum interval in milliseconds at which the local routing
          device transmits hello packets and then expects to receive a reply from a
          neighbor with which it has established a BFD session.
    :attr int multiplier: The number of hello packets not received by a neighbor
          that causes the originating interface to be declared down.
    """

    def __init__(self,
                 interval: int,
                 multiplier: int,
                 *,
                 bfd_status: str = None,
                 bfd_status_updated_at: datetime = None) -> None:
        """
        Initialize a GatewayBfdConfig object.

        :param int interval: Minimum interval in milliseconds at which the local
               routing device transmits hello packets and then expects to receive a reply
               from a neighbor with which it has established a BFD session.
        :param int multiplier: The number of hello packets not received by a
               neighbor that causes the originating interface to be declared down.
        :param str bfd_status: (optional) Gateway BFD status. The list of
               enumerated values for this property may expand in the future. Code and
               processes using this field must tolerate unexpected values.
        :param datetime bfd_status_updated_at: (optional) Date and time bfd status
               was updated.
        """
        self.bfd_status = bfd_status
        self.bfd_status_updated_at = bfd_status_updated_at
        self.interval = interval
        self.multiplier = multiplier

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayBfdConfig':
        """Initialize a GatewayBfdConfig object from a json dictionary."""
        args = {}
        if 'bfd_status' in _dict:
            args['bfd_status'] = _dict.get('bfd_status')
        if 'bfd_status_updated_at' in _dict:
            args['bfd_status_updated_at'] = string_to_datetime(_dict.get('bfd_status_updated_at'))
        if 'interval' in _dict:
            args['interval'] = _dict.get('interval')
        else:
            raise ValueError('Required property \'interval\' not present in GatewayBfdConfig JSON')
        if 'multiplier' in _dict:
            args['multiplier'] = _dict.get('multiplier')
        else:
            raise ValueError('Required property \'multiplier\' not present in GatewayBfdConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayBfdConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bfd_status') and self.bfd_status is not None:
            _dict['bfd_status'] = self.bfd_status
        if hasattr(self, 'bfd_status_updated_at') and self.bfd_status_updated_at is not None:
            _dict['bfd_status_updated_at'] = datetime_to_string(self.bfd_status_updated_at)
        if hasattr(self, 'interval') and self.interval is not None:
            _dict['interval'] = self.interval
        if hasattr(self, 'multiplier') and self.multiplier is not None:
            _dict['multiplier'] = self.multiplier
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayBfdConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayBfdConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayBfdConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class BfdStatusEnum(str, Enum):
        """
        Gateway BFD status. The list of enumerated values for this property may expand in
        the future. Code and processes using this field must tolerate unexpected values.
        """
        INIT = 'init'
        UP = 'up'
        DOWN = 'down'


class GatewayBfdConfigActionTemplate():
    """
    Applicable for create_gateway_approve requests to select the gateway's BFD
    configuration information.

    :attr int interval: Minimum interval in milliseconds at which the local routing
          device transmits hello packets and then expects to receive a reply from a
          neighbor with which it has established a BFD session.
    :attr int multiplier: (optional) The number of hello packets not received by a
          neighbor that causes the originating interface to be declared down.
    """

    def __init__(self,
                 interval: int,
                 *,
                 multiplier: int = None) -> None:
        """
        Initialize a GatewayBfdConfigActionTemplate object.

        :param int interval: Minimum interval in milliseconds at which the local
               routing device transmits hello packets and then expects to receive a reply
               from a neighbor with which it has established a BFD session.
        :param int multiplier: (optional) The number of hello packets not received
               by a neighbor that causes the originating interface to be declared down.
        """
        self.interval = interval
        self.multiplier = multiplier

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayBfdConfigActionTemplate':
        """Initialize a GatewayBfdConfigActionTemplate object from a json dictionary."""
        args = {}
        if 'interval' in _dict:
            args['interval'] = _dict.get('interval')
        else:
            raise ValueError('Required property \'interval\' not present in GatewayBfdConfigActionTemplate JSON')
        if 'multiplier' in _dict:
            args['multiplier'] = _dict.get('multiplier')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayBfdConfigActionTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'interval') and self.interval is not None:
            _dict['interval'] = self.interval
        if hasattr(self, 'multiplier') and self.multiplier is not None:
            _dict['multiplier'] = self.multiplier
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayBfdConfigActionTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayBfdConfigActionTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayBfdConfigActionTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayBfdConfigTemplate():
    """
    BFD configuration information.

    :attr int interval: Minimum interval in milliseconds at which the local routing
          device transmits hello packets and then expects to receive a reply from a
          neighbor with which it has established a BFD session.
    :attr int multiplier: (optional) The number of hello packets not received by a
          neighbor that causes the originating interface to be declared down.
    """

    def __init__(self,
                 interval: int,
                 *,
                 multiplier: int = None) -> None:
        """
        Initialize a GatewayBfdConfigTemplate object.

        :param int interval: Minimum interval in milliseconds at which the local
               routing device transmits hello packets and then expects to receive a reply
               from a neighbor with which it has established a BFD session.
        :param int multiplier: (optional) The number of hello packets not received
               by a neighbor that causes the originating interface to be declared down.
        """
        self.interval = interval
        self.multiplier = multiplier

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayBfdConfigTemplate':
        """Initialize a GatewayBfdConfigTemplate object from a json dictionary."""
        args = {}
        if 'interval' in _dict:
            args['interval'] = _dict.get('interval')
        else:
            raise ValueError('Required property \'interval\' not present in GatewayBfdConfigTemplate JSON')
        if 'multiplier' in _dict:
            args['multiplier'] = _dict.get('multiplier')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayBfdConfigTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'interval') and self.interval is not None:
            _dict['interval'] = self.interval
        if hasattr(self, 'multiplier') and self.multiplier is not None:
            _dict['multiplier'] = self.multiplier
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayBfdConfigTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayBfdConfigTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayBfdConfigTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayBfdPatchTemplate():
    """
    BFD configuration information.

    :attr int interval: (optional) Minimum interval in milliseconds at which the
          local routing device transmits hello packets and then expects to receive a reply
          from a neighbor with which it has established a BFD session.
          To clear the BFD configuration patch its interval to 0.
    :attr int multiplier: (optional) The number of hello packets not received by a
          neighbor that causes the originating interface to be declared down.
    """

    def __init__(self,
                 *,
                 interval: int = None,
                 multiplier: int = None) -> None:
        """
        Initialize a GatewayBfdPatchTemplate object.

        :param int interval: (optional) Minimum interval in milliseconds at which
               the local routing device transmits hello packets and then expects to
               receive a reply from a neighbor with which it has established a BFD
               session.
               To clear the BFD configuration patch its interval to 0.
        :param int multiplier: (optional) The number of hello packets not received
               by a neighbor that causes the originating interface to be declared down.
        """
        self.interval = interval
        self.multiplier = multiplier

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayBfdPatchTemplate':
        """Initialize a GatewayBfdPatchTemplate object from a json dictionary."""
        args = {}
        if 'interval' in _dict:
            args['interval'] = _dict.get('interval')
        if 'multiplier' in _dict:
            args['multiplier'] = _dict.get('multiplier')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayBfdPatchTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'interval') and self.interval is not None:
            _dict['interval'] = self.interval
        if hasattr(self, 'multiplier') and self.multiplier is not None:
            _dict['multiplier'] = self.multiplier
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayBfdPatchTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayBfdPatchTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayBfdPatchTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequest():
    """
    GatewayChangeRequest.

    """

    def __init__(self) -> None:
        """
        Initialize a GatewayChangeRequest object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['GatewayChangeRequestGatewayClientGatewayCreate', 'GatewayChangeRequestGatewayClientGatewayDelete', 'GatewayChangeRequestGatewayClientGatewayUpdateAttributes']))
        raise Exception(msg)

class GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem():
    """
    GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem.

    """

    def __init__(self) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate', 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate', 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate', 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate']))
        raise Exception(msg)

class GatewayCollection():
    """
    GatewayCollection.

    :attr List[Gateway] gateways: Collection of Direct Link gateways.
    """

    def __init__(self,
                 gateways: List['Gateway']) -> None:
        """
        Initialize a GatewayCollection object.

        :param List[Gateway] gateways: Collection of Direct Link gateways.
        """
        self.gateways = gateways

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayCollection':
        """Initialize a GatewayCollection object from a json dictionary."""
        args = {}
        if 'gateways' in _dict:
            args['gateways'] = [Gateway.from_dict(x) for x in _dict.get('gateways')]
        else:
            raise ValueError('Required property \'gateways\' not present in GatewayCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'gateways') and self.gateways is not None:
            _dict['gateways'] = [x.to_dict() for x in self.gateways]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfig():
    """
    MACsec configuration information.  For Dedicated Gateways with MACsec configured,
    return configuration information.  Contact IBM support for access to MACsec.

    :attr bool active: Indicate whether MACsec should currently be active (true) or
          inactive (false) for a MACsec enabled gateway.   To be MACsec enabled a
          `macsec_config` must be specified at gateway create time.
    :attr GatewayMacsecConfigActiveCak active_cak: (optional) Active connectivity
          association key.
          During normal operation `active_cak` will match the desired `primary_cak`.
          During CAK changes this field can be used to indicate which key is currently
          active on the gateway.
    :attr str cipher_suite: (optional) SAK cipher suite.
    :attr int confidentiality_offset: (optional) confidentiality offset.
    :attr str cryptographic_algorithm: (optional) cryptographic algorithm.
    :attr GatewayMacsecConfigFallbackCak fallback_cak: (optional) fallback
          connectivity association key.
    :attr int key_server_priority: (optional) key server priority.
    :attr GatewayMacsecConfigPrimaryCak primary_cak: desired primary connectivity
          association key.
    :attr int sak_expiry_time: (optional) Secure Association Key (SAK) expiry time
          in seconds.
    :attr str security_policy: (optional) Packets without MACsec headers are dropped
          when security_policy is `must_secure`.
    :attr str status: Current status of MACsec on this gateway.
          Status 'offline' is returned during gateway creation and deletion.
    :attr int window_size: (optional) replay protection window size.
    """

    def __init__(self,
                 active: bool,
                 primary_cak: 'GatewayMacsecConfigPrimaryCak',
                 status: str,
                 *,
                 active_cak: 'GatewayMacsecConfigActiveCak' = None,
                 cipher_suite: str = None,
                 confidentiality_offset: int = None,
                 cryptographic_algorithm: str = None,
                 fallback_cak: 'GatewayMacsecConfigFallbackCak' = None,
                 key_server_priority: int = None,
                 sak_expiry_time: int = None,
                 security_policy: str = None,
                 window_size: int = None) -> None:
        """
        Initialize a GatewayMacsecConfig object.

        :param bool active: Indicate whether MACsec should currently be active
               (true) or inactive (false) for a MACsec enabled gateway.   To be MACsec
               enabled a `macsec_config` must be specified at gateway create time.
        :param GatewayMacsecConfigPrimaryCak primary_cak: desired primary
               connectivity association key.
        :param str status: Current status of MACsec on this gateway.
               Status 'offline' is returned during gateway creation and deletion.
        :param GatewayMacsecConfigActiveCak active_cak: (optional) Active
               connectivity association key.
               During normal operation `active_cak` will match the desired `primary_cak`.
               During CAK changes this field can be used to indicate which key is
               currently active on the gateway.
        :param str cipher_suite: (optional) SAK cipher suite.
        :param int confidentiality_offset: (optional) confidentiality offset.
        :param str cryptographic_algorithm: (optional) cryptographic algorithm.
        :param GatewayMacsecConfigFallbackCak fallback_cak: (optional) fallback
               connectivity association key.
        :param int key_server_priority: (optional) key server priority.
        :param int sak_expiry_time: (optional) Secure Association Key (SAK) expiry
               time in seconds.
        :param str security_policy: (optional) Packets without MACsec headers are
               dropped when security_policy is `must_secure`.
        :param int window_size: (optional) replay protection window size.
        """
        self.active = active
        self.active_cak = active_cak
        self.cipher_suite = cipher_suite
        self.confidentiality_offset = confidentiality_offset
        self.cryptographic_algorithm = cryptographic_algorithm
        self.fallback_cak = fallback_cak
        self.key_server_priority = key_server_priority
        self.primary_cak = primary_cak
        self.sak_expiry_time = sak_expiry_time
        self.security_policy = security_policy
        self.status = status
        self.window_size = window_size

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfig':
        """Initialize a GatewayMacsecConfig object from a json dictionary."""
        args = {}
        if 'active' in _dict:
            args['active'] = _dict.get('active')
        else:
            raise ValueError('Required property \'active\' not present in GatewayMacsecConfig JSON')
        if 'active_cak' in _dict:
            args['active_cak'] = GatewayMacsecConfigActiveCak.from_dict(_dict.get('active_cak'))
        if 'cipher_suite' in _dict:
            args['cipher_suite'] = _dict.get('cipher_suite')
        if 'confidentiality_offset' in _dict:
            args['confidentiality_offset'] = _dict.get('confidentiality_offset')
        if 'cryptographic_algorithm' in _dict:
            args['cryptographic_algorithm'] = _dict.get('cryptographic_algorithm')
        if 'fallback_cak' in _dict:
            args['fallback_cak'] = GatewayMacsecConfigFallbackCak.from_dict(_dict.get('fallback_cak'))
        if 'key_server_priority' in _dict:
            args['key_server_priority'] = _dict.get('key_server_priority')
        if 'primary_cak' in _dict:
            args['primary_cak'] = GatewayMacsecConfigPrimaryCak.from_dict(_dict.get('primary_cak'))
        else:
            raise ValueError('Required property \'primary_cak\' not present in GatewayMacsecConfig JSON')
        if 'sak_expiry_time' in _dict:
            args['sak_expiry_time'] = _dict.get('sak_expiry_time')
        if 'security_policy' in _dict:
            args['security_policy'] = _dict.get('security_policy')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in GatewayMacsecConfig JSON')
        if 'window_size' in _dict:
            args['window_size'] = _dict.get('window_size')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'active') and self.active is not None:
            _dict['active'] = self.active
        if hasattr(self, 'active_cak') and self.active_cak is not None:
            _dict['active_cak'] = self.active_cak.to_dict()
        if hasattr(self, 'cipher_suite') and self.cipher_suite is not None:
            _dict['cipher_suite'] = self.cipher_suite
        if hasattr(self, 'confidentiality_offset') and self.confidentiality_offset is not None:
            _dict['confidentiality_offset'] = self.confidentiality_offset
        if hasattr(self, 'cryptographic_algorithm') and self.cryptographic_algorithm is not None:
            _dict['cryptographic_algorithm'] = self.cryptographic_algorithm
        if hasattr(self, 'fallback_cak') and self.fallback_cak is not None:
            _dict['fallback_cak'] = self.fallback_cak.to_dict()
        if hasattr(self, 'key_server_priority') and self.key_server_priority is not None:
            _dict['key_server_priority'] = self.key_server_priority
        if hasattr(self, 'primary_cak') and self.primary_cak is not None:
            _dict['primary_cak'] = self.primary_cak.to_dict()
        if hasattr(self, 'sak_expiry_time') and self.sak_expiry_time is not None:
            _dict['sak_expiry_time'] = self.sak_expiry_time
        if hasattr(self, 'security_policy') and self.security_policy is not None:
            _dict['security_policy'] = self.security_policy
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'window_size') and self.window_size is not None:
            _dict['window_size'] = self.window_size
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class CipherSuiteEnum(str, Enum):
        """
        SAK cipher suite.
        """
        GCM_AES_XPN_256 = 'gcm_aes_xpn_256'


    class CryptographicAlgorithmEnum(str, Enum):
        """
        cryptographic algorithm.
        """
        AES_256_CMAC = 'aes_256_cmac'


    class SecurityPolicyEnum(str, Enum):
        """
        Packets without MACsec headers are dropped when security_policy is `must_secure`.
        """
        MUST_SECURE = 'must_secure'


    class StatusEnum(str, Enum):
        """
        Current status of MACsec on this gateway.
        Status 'offline' is returned during gateway creation and deletion.
        """
        INIT = 'init'
        PENDING = 'pending'
        OFFLINE = 'offline'
        SECURED = 'secured'


class GatewayMacsecConfigActiveCak():
    """
    Active connectivity association key.
    During normal operation `active_cak` will match the desired `primary_cak`.  During CAK
    changes this field can be used to indicate which key is currently active on the
    gateway.

    :attr str crn: connectivity association key crn.
    :attr str status: connectivity association key status.
    """

    def __init__(self,
                 crn: str,
                 status: str) -> None:
        """
        Initialize a GatewayMacsecConfigActiveCak object.

        :param str crn: connectivity association key crn.
        :param str status: connectivity association key status.
        """
        self.crn = crn
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigActiveCak':
        """Initialize a GatewayMacsecConfigActiveCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigActiveCak JSON')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in GatewayMacsecConfigActiveCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigActiveCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigActiveCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigActiveCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigActiveCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigFallbackCak():
    """
    fallback connectivity association key.

    :attr str crn: connectivity association key crn.
    :attr str status: connectivity association key status.
    """

    def __init__(self,
                 crn: str,
                 status: str) -> None:
        """
        Initialize a GatewayMacsecConfigFallbackCak object.

        :param str crn: connectivity association key crn.
        :param str status: connectivity association key status.
        """
        self.crn = crn
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigFallbackCak':
        """Initialize a GatewayMacsecConfigFallbackCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigFallbackCak JSON')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in GatewayMacsecConfigFallbackCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigFallbackCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigFallbackCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigFallbackCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigFallbackCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigPatchTemplate():
    """
    MACsec configuration information.  When patching any macsec_config fields, no other
    fields may be specified in the patch request.  Contact IBM support for access to
    MACsec.
    A MACsec config cannot be added to a gateway created without MACsec.

    :attr bool active: (optional) Indicate whether MACsec protection should be
          active (true) or inactive (false) for this MACsec enabled gateway.
    :attr GatewayMacsecConfigPatchTemplateFallbackCak fallback_cak: (optional)
          Fallback connectivity association key.
          MACsec keys must be type=standard with key name lengths between 2 to 64
          inclusive and contain only characters [a-fA-F0-9].
          The key material must be exactly 64 characters in length and contain only
          [a-fA-F0-9].
          To clear the optional `fallback_cak` field patch its crn to `""`.
          A gateway's `fallback_cak` crn cannot match its `primary_cak` crn.
    :attr GatewayMacsecConfigPatchTemplatePrimaryCak primary_cak: (optional) Desired
          primary connectivity association key.
          MACsec keys must be type=standard with key name lengths between 2 to 64
          inclusive and contain only characters [a-fA-F0-9].
          The key material must be exactly 64 characters in length and contain only
          [a-fA-F0-9].
          A gateway's `primary_cak` crn cannot match its `fallback_cak` crn.
    :attr int window_size: (optional) replay protection window size.
    """

    def __init__(self,
                 *,
                 active: bool = None,
                 fallback_cak: 'GatewayMacsecConfigPatchTemplateFallbackCak' = None,
                 primary_cak: 'GatewayMacsecConfigPatchTemplatePrimaryCak' = None,
                 window_size: int = None) -> None:
        """
        Initialize a GatewayMacsecConfigPatchTemplate object.

        :param bool active: (optional) Indicate whether MACsec protection should be
               active (true) or inactive (false) for this MACsec enabled gateway.
        :param GatewayMacsecConfigPatchTemplateFallbackCak fallback_cak: (optional)
               Fallback connectivity association key.
               MACsec keys must be type=standard with key name lengths between 2 to 64
               inclusive and contain only characters [a-fA-F0-9].
               The key material must be exactly 64 characters in length and contain only
               [a-fA-F0-9].
               To clear the optional `fallback_cak` field patch its crn to `""`.
               A gateway's `fallback_cak` crn cannot match its `primary_cak` crn.
        :param GatewayMacsecConfigPatchTemplatePrimaryCak primary_cak: (optional)
               Desired primary connectivity association key.
               MACsec keys must be type=standard with key name lengths between 2 to 64
               inclusive and contain only characters [a-fA-F0-9].
               The key material must be exactly 64 characters in length and contain only
               [a-fA-F0-9].
               A gateway's `primary_cak` crn cannot match its `fallback_cak` crn.
        :param int window_size: (optional) replay protection window size.
        """
        self.active = active
        self.fallback_cak = fallback_cak
        self.primary_cak = primary_cak
        self.window_size = window_size

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigPatchTemplate':
        """Initialize a GatewayMacsecConfigPatchTemplate object from a json dictionary."""
        args = {}
        if 'active' in _dict:
            args['active'] = _dict.get('active')
        if 'fallback_cak' in _dict:
            args['fallback_cak'] = GatewayMacsecConfigPatchTemplateFallbackCak.from_dict(_dict.get('fallback_cak'))
        if 'primary_cak' in _dict:
            args['primary_cak'] = GatewayMacsecConfigPatchTemplatePrimaryCak.from_dict(_dict.get('primary_cak'))
        if 'window_size' in _dict:
            args['window_size'] = _dict.get('window_size')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigPatchTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'active') and self.active is not None:
            _dict['active'] = self.active
        if hasattr(self, 'fallback_cak') and self.fallback_cak is not None:
            _dict['fallback_cak'] = self.fallback_cak.to_dict()
        if hasattr(self, 'primary_cak') and self.primary_cak is not None:
            _dict['primary_cak'] = self.primary_cak.to_dict()
        if hasattr(self, 'window_size') and self.window_size is not None:
            _dict['window_size'] = self.window_size
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigPatchTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigPatchTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigPatchTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigPatchTemplateFallbackCak():
    """
    Fallback connectivity association key.
    MACsec keys must be type=standard with key name lengths between 2 to 64 inclusive and
    contain only characters [a-fA-F0-9]. The key material must be exactly 64 characters in
    length and contain only [a-fA-F0-9].
    To clear the optional `fallback_cak` field patch its crn to `""`.
    A gateway's `fallback_cak` crn cannot match its `primary_cak` crn.

    :attr str crn: connectivity association key crn.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayMacsecConfigPatchTemplateFallbackCak object.

        :param str crn: connectivity association key crn.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigPatchTemplateFallbackCak':
        """Initialize a GatewayMacsecConfigPatchTemplateFallbackCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigPatchTemplateFallbackCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigPatchTemplateFallbackCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigPatchTemplateFallbackCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigPatchTemplateFallbackCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigPatchTemplateFallbackCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigPatchTemplatePrimaryCak():
    """
    Desired primary connectivity association key.
    MACsec keys must be type=standard with key name lengths between 2 to 64 inclusive and
    contain only characters [a-fA-F0-9]. The key material must be exactly 64 characters in
    length and contain only [a-fA-F0-9].
    A gateway's `primary_cak` crn cannot match its `fallback_cak` crn.

    :attr str crn: connectivity association key crn.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayMacsecConfigPatchTemplatePrimaryCak object.

        :param str crn: connectivity association key crn.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigPatchTemplatePrimaryCak':
        """Initialize a GatewayMacsecConfigPatchTemplatePrimaryCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigPatchTemplatePrimaryCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigPatchTemplatePrimaryCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigPatchTemplatePrimaryCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigPatchTemplatePrimaryCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigPatchTemplatePrimaryCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigPrimaryCak():
    """
    desired primary connectivity association key.

    :attr str crn: connectivity association key crn.
    :attr str status: connectivity association key status.
    """

    def __init__(self,
                 crn: str,
                 status: str) -> None:
        """
        Initialize a GatewayMacsecConfigPrimaryCak object.

        :param str crn: connectivity association key crn.
        :param str status: connectivity association key status.
        """
        self.crn = crn
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigPrimaryCak':
        """Initialize a GatewayMacsecConfigPrimaryCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigPrimaryCak JSON')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in GatewayMacsecConfigPrimaryCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigPrimaryCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigPrimaryCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigPrimaryCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigPrimaryCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigTemplate():
    """
    MACsec configuration information.  Contact IBM support for access to MACsec.

    :attr bool active: Indicate whether MACsec protection should be active (true) or
          inactive (false) for this MACsec enabled gateway.
    :attr GatewayMacsecConfigTemplateFallbackCak fallback_cak: (optional) Fallback
          connectivity association key.
          The `fallback_cak` crn cannot match the `primary_cak` crn.
          MACsec keys must be type=standard with key name lengths between 2 to 64
          inclusive and contain only characters [a-fA-F0-9].
          The key material must be exactly 64 characters in length and contain only
          [a-fA-F0-9].
    :attr GatewayMacsecConfigTemplatePrimaryCak primary_cak: Desired primary
          connectivity association key.
          MACsec keys must be type=standard with key name lengths between 2 to 64
          inclusive and contain only characters [a-fA-F0-9].
          The key material must be exactly 64 characters in length and contain only
          [a-fA-F0-9].
    :attr int window_size: (optional) replay protection window size.
    """

    def __init__(self,
                 active: bool,
                 primary_cak: 'GatewayMacsecConfigTemplatePrimaryCak',
                 *,
                 fallback_cak: 'GatewayMacsecConfigTemplateFallbackCak' = None,
                 window_size: int = None) -> None:
        """
        Initialize a GatewayMacsecConfigTemplate object.

        :param bool active: Indicate whether MACsec protection should be active
               (true) or inactive (false) for this MACsec enabled gateway.
        :param GatewayMacsecConfigTemplatePrimaryCak primary_cak: Desired primary
               connectivity association key.
               MACsec keys must be type=standard with key name lengths between 2 to 64
               inclusive and contain only characters [a-fA-F0-9].
               The key material must be exactly 64 characters in length and contain only
               [a-fA-F0-9].
        :param GatewayMacsecConfigTemplateFallbackCak fallback_cak: (optional)
               Fallback connectivity association key.
               The `fallback_cak` crn cannot match the `primary_cak` crn.
               MACsec keys must be type=standard with key name lengths between 2 to 64
               inclusive and contain only characters [a-fA-F0-9].
               The key material must be exactly 64 characters in length and contain only
               [a-fA-F0-9].
        :param int window_size: (optional) replay protection window size.
        """
        self.active = active
        self.fallback_cak = fallback_cak
        self.primary_cak = primary_cak
        self.window_size = window_size

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigTemplate':
        """Initialize a GatewayMacsecConfigTemplate object from a json dictionary."""
        args = {}
        if 'active' in _dict:
            args['active'] = _dict.get('active')
        else:
            raise ValueError('Required property \'active\' not present in GatewayMacsecConfigTemplate JSON')
        if 'fallback_cak' in _dict:
            args['fallback_cak'] = GatewayMacsecConfigTemplateFallbackCak.from_dict(_dict.get('fallback_cak'))
        if 'primary_cak' in _dict:
            args['primary_cak'] = GatewayMacsecConfigTemplatePrimaryCak.from_dict(_dict.get('primary_cak'))
        else:
            raise ValueError('Required property \'primary_cak\' not present in GatewayMacsecConfigTemplate JSON')
        if 'window_size' in _dict:
            args['window_size'] = _dict.get('window_size')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'active') and self.active is not None:
            _dict['active'] = self.active
        if hasattr(self, 'fallback_cak') and self.fallback_cak is not None:
            _dict['fallback_cak'] = self.fallback_cak.to_dict()
        if hasattr(self, 'primary_cak') and self.primary_cak is not None:
            _dict['primary_cak'] = self.primary_cak.to_dict()
        if hasattr(self, 'window_size') and self.window_size is not None:
            _dict['window_size'] = self.window_size
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigTemplateFallbackCak():
    """
    Fallback connectivity association key.
    The `fallback_cak` crn cannot match the `primary_cak` crn. MACsec keys must be
    type=standard with key name lengths between 2 to 64 inclusive and contain only
    characters [a-fA-F0-9]. The key material must be exactly 64 characters in length and
    contain only [a-fA-F0-9].

    :attr str crn: connectivity association key crn.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayMacsecConfigTemplateFallbackCak object.

        :param str crn: connectivity association key crn.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigTemplateFallbackCak':
        """Initialize a GatewayMacsecConfigTemplateFallbackCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigTemplateFallbackCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigTemplateFallbackCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigTemplateFallbackCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigTemplateFallbackCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigTemplateFallbackCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayMacsecConfigTemplatePrimaryCak():
    """
    Desired primary connectivity association key.
    MACsec keys must be type=standard with key name lengths between 2 to 64 inclusive and
    contain only characters [a-fA-F0-9]. The key material must be exactly 64 characters in
    length and contain only [a-fA-F0-9].

    :attr str crn: connectivity association key crn.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayMacsecConfigTemplatePrimaryCak object.

        :param str crn: connectivity association key crn.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayMacsecConfigTemplatePrimaryCak':
        """Initialize a GatewayMacsecConfigTemplatePrimaryCak object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayMacsecConfigTemplatePrimaryCak JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayMacsecConfigTemplatePrimaryCak object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayMacsecConfigTemplatePrimaryCak object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayMacsecConfigTemplatePrimaryCak') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayMacsecConfigTemplatePrimaryCak') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayPatchTemplateAuthenticationKey():
    """
    The identity of the standard key to use for BGP MD5 authentication key. The key
    material that you provide must be base64 encoded and original string must be maximum
    126 ASCII characters in length. To clear the optional `authentication_key` field patch
    its crn to `""`.

    :attr str crn: The CRN of the [Key Protect Standard
          Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
          or [Hyper Protect Crypto Service Standard
          Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for this
          resource.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayPatchTemplateAuthenticationKey object.

        :param str crn: The CRN of the [Key Protect Standard
               Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
               or [Hyper Protect Crypto Service Standard
               Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for
               this resource.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayPatchTemplateAuthenticationKey':
        """Initialize a GatewayPatchTemplateAuthenticationKey object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayPatchTemplateAuthenticationKey JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayPatchTemplateAuthenticationKey object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayPatchTemplateAuthenticationKey object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayPatchTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayPatchTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayPort():
    """
    gateway port for type=connect gateways.

    :attr str id: Port Identifier.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a GatewayPort object.

        :param str id: Port Identifier.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayPort':
        """Initialize a GatewayPort object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in GatewayPort JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayPort object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayPort object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayPort') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayPort') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayPortIdentity():
    """
    Select Port Label for new type=connect gateway.

    :attr str id: port id.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a GatewayPortIdentity object.

        :param str id: port id.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayPortIdentity':
        """Initialize a GatewayPortIdentity object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in GatewayPortIdentity JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayPortIdentity object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayPortIdentity object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayPortIdentity') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayPortIdentity') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayStatistic():
    """
    Gateway statistics and debug commands.

    :attr datetime created_at: Date and time data was collected.
    :attr str data: statistics output.
    :attr str type: statistic type.
    """

    def __init__(self,
                 created_at: datetime,
                 data: str,
                 type: str) -> None:
        """
        Initialize a GatewayStatistic object.

        :param datetime created_at: Date and time data was collected.
        :param str data: statistics output.
        :param str type: statistic type.
        """
        self.created_at = created_at
        self.data = data
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatistic':
        """Initialize a GatewayStatistic object from a json dictionary."""
        args = {}
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in GatewayStatistic JSON')
        if 'data' in _dict:
            args['data'] = _dict.get('data')
        else:
            raise ValueError('Required property \'data\' not present in GatewayStatistic JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayStatistic JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatistic object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'data') and self.data is not None:
            _dict['data'] = self.data
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatistic object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatistic') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatistic') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        statistic type.
        """
        MACSEC_MKA_SESSION = 'macsec_mka_session'
        MACSEC_POLICY = 'macsec_policy'
        MACSEC_MKA_STATISTICS = 'macsec_mka_statistics'
        BFD_SESSION = 'bfd_session'


class GatewayStatisticCollection():
    """
    gateway statistics.

    :attr List[GatewayStatistic] statistics: Collection of gateway statistics.
    """

    def __init__(self,
                 statistics: List['GatewayStatistic']) -> None:
        """
        Initialize a GatewayStatisticCollection object.

        :param List[GatewayStatistic] statistics: Collection of gateway statistics.
        """
        self.statistics = statistics

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatisticCollection':
        """Initialize a GatewayStatisticCollection object from a json dictionary."""
        args = {}
        if 'statistics' in _dict:
            args['statistics'] = [GatewayStatistic.from_dict(x) for x in _dict.get('statistics')]
        else:
            raise ValueError('Required property \'statistics\' not present in GatewayStatisticCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatisticCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'statistics') and self.statistics is not None:
            _dict['statistics'] = [x.to_dict() for x in self.statistics]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatisticCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatisticCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatisticCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayStatus():
    """
    GatewayStatus.

    """

    def __init__(self) -> None:
        """
        Initialize a GatewayStatus object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['GatewayStatusGatewayBGPStatus', 'GatewayStatusGatewayBFDStatus', 'GatewayStatusGatewayLinkStatus']))
        raise Exception(msg)

class GatewayStatusCollection():
    """
    gateway status.

    :attr List[GatewayStatus] status: (optional) array of status.
    """

    def __init__(self,
                 *,
                 status: List['GatewayStatus'] = None) -> None:
        """
        Initialize a GatewayStatusCollection object.

        :param List[GatewayStatus] status: (optional) array of status.
        """
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatusCollection':
        """Initialize a GatewayStatusCollection object from a json dictionary."""
        args = {}
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatusCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'status') and self.status is not None:
            status_list = []
            for x in self.status:
                if isinstance(x, dict):
                    status_list.append(x)
                else:
                    status_list.append(x.to_dict())
            _dict['status'] = status_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatusCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatusCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatusCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayTemplate():
    """
    Create gateway template.

    :attr List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
          configuration information.
    :attr GatewayTemplateAuthenticationKey authentication_key: (optional) The
          identity of the standard key to use for BGP MD5 authentication key.
          The key material that you provide must be base64 encoded and original string
          must be maximum 126 ASCII characters in length.
          To clear the optional `authentication_key` field patch its crn to `""`.
    :attr GatewayBfdConfigTemplate bfd_config: (optional) BFD configuration
          information.
    :attr int bgp_asn: BGP ASN.
    :attr str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
          Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how to
          create a gateway using either automatic or explicit IP assignment.  Any
          bgp_base_cidr value set will be ignored.
          Deprecated field bgp_base_cidr will be removed from the API specificiation after
          15-MAR-2021.
    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str connection_mode: (optional) Type of services this Gateway is attached
          to. Mode transit means this Gateway will be attached to Transit Gateway Service
          and direct means this Gateway will be attached to vpc or classic connection. The
          list of enumerated values for this property may expand in the future. Code and
          processes using this field  must tolerate unexpected values.
    :attr bool global_: Gateways with global routing (`true`) can connect to
          networks outside their associated region.
    :attr bool metered: Metered billing option.  When `true` gateway usage is billed
          per gigabyte.  When `false` there is no per gigabyte usage charge, instead a
          flat rate is charged for the gateway.
    :attr str name: The unique user-defined name for this gateway.
    :attr str patch_panel_completion_notice: (optional) Gateway patch panel complete
          notification from implementation team.
    :attr ResourceGroupIdentity resource_group: (optional) Resource group for this
          resource. If unspecified, the account's [default resource
          group](https://cloud.ibm.com/apidocs/resource-manager#introduction) is used.
    :attr int speed_mbps: Gateway speed in megabits per second.
    :attr str type: Offering type.
    """

    def __init__(self,
                 bgp_asn: int,
                 global_: bool,
                 metered: bool,
                 name: str,
                 speed_mbps: int,
                 type: str,
                 *,
                 as_prepends: List['AsPrependTemplate'] = None,
                 authentication_key: 'GatewayTemplateAuthenticationKey' = None,
                 bfd_config: 'GatewayBfdConfigTemplate' = None,
                 bgp_base_cidr: str = None,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_cidr: str = None,
                 connection_mode: str = None,
                 patch_panel_completion_notice: str = None,
                 resource_group: 'ResourceGroupIdentity' = None) -> None:
        """
        Initialize a GatewayTemplate object.

        :param int bgp_asn: BGP ASN.
        :param bool global_: Gateways with global routing (`true`) can connect to
               networks outside their associated region.
        :param bool metered: Metered billing option.  When `true` gateway usage is
               billed per gigabyte.  When `false` there is no per gigabyte usage charge,
               instead a flat rate is charged for the gateway.
        :param str name: The unique user-defined name for this gateway.
        :param int speed_mbps: Gateway speed in megabits per second.
        :param str type: Offering type.
        :param List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
               configuration information.
        :param GatewayTemplateAuthenticationKey authentication_key: (optional) The
               identity of the standard key to use for BGP MD5 authentication key.
               The key material that you provide must be base64 encoded and original
               string must be maximum 126 ASCII characters in length.
               To clear the optional `authentication_key` field patch its crn to `""`.
        :param GatewayBfdConfigTemplate bfd_config: (optional) BFD configuration
               information.
        :param str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
               Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how
               to create a gateway using either automatic or explicit IP assignment.  Any
               bgp_base_cidr value set will be ignored.
               Deprecated field bgp_base_cidr will be removed from the API specificiation
               after 15-MAR-2021.
        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str connection_mode: (optional) Type of services this Gateway is
               attached to. Mode transit means this Gateway will be attached to Transit
               Gateway Service and direct means this Gateway will be attached to vpc or
               classic connection. The list of enumerated values for this property may
               expand in the future. Code and processes using this field  must tolerate
               unexpected values.
        :param str patch_panel_completion_notice: (optional) Gateway patch panel
               complete notification from implementation team.
        :param ResourceGroupIdentity resource_group: (optional) Resource group for
               this resource. If unspecified, the account's [default resource
               group](https://cloud.ibm.com/apidocs/resource-manager#introduction) is
               used.
        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['GatewayTemplateGatewayTypeDedicatedTemplate', 'GatewayTemplateGatewayTypeConnectTemplate']))
        raise Exception(msg)

    class ConnectionModeEnum(str, Enum):
        """
        Type of services this Gateway is attached to. Mode transit means this Gateway will
        be attached to Transit Gateway Service and direct means this Gateway will be
        attached to vpc or classic connection. The list of enumerated values for this
        property may expand in the future. Code and processes using this field  must
        tolerate unexpected values.
        """
        DIRECT = 'direct'
        TRANSIT = 'transit'


    class TypeEnum(str, Enum):
        """
        Offering type.
        """
        CONNECT = 'connect'
        DEDICATED = 'dedicated'


class GatewayTemplateAuthenticationKey():
    """
    The identity of the standard key to use for BGP MD5 authentication key. The key
    material that you provide must be base64 encoded and original string must be maximum
    126 ASCII characters in length. To clear the optional `authentication_key` field patch
    its crn to `""`.

    :attr str crn: The CRN of the [Key Protect Standard
          Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
          or [Hyper Protect Crypto Service Standard
          Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for this
          resource.
    """

    def __init__(self,
                 crn: str) -> None:
        """
        Initialize a GatewayTemplateAuthenticationKey object.

        :param str crn: The CRN of the [Key Protect Standard
               Key](https://cloud.ibm.com/docs/key-protect?topic=key-protect-getting-started-tutorial)
               or [Hyper Protect Crypto Service Standard
               Key](https://cloud.ibm.com/docs/hs-crypto?topic=hs-crypto-get-started) for
               this resource.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayTemplateAuthenticationKey':
        """Initialize a GatewayTemplateAuthenticationKey object from a json dictionary."""
        args = {}
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in GatewayTemplateAuthenticationKey JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayTemplateAuthenticationKey object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayTemplateAuthenticationKey object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayTemplateAuthenticationKey') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayVirtualConnection():
    """
    Virtual connection.

    :attr datetime created_at: The date and time resource was created.
    :attr str id: The unique identifier for this virtual connection.
    :attr str name: The user-defined name for this virtual connection.  Virtual
          connection names are unique within a gateway.  This is the name of the virtual
          connection itself, the network being connected may have its own name attribute.
    :attr str network_account: (optional) For virtual connections across two
          different IBM Cloud Accounts network_account indicates the account that owns the
          target network.
    :attr str network_id: (optional) Unique identifier of the target network.  For
          type=vpc virtual connections this is the CRN of the target VPC.  This field does
          not apply to type=classic connections.
    :attr str status: Status of the virtual connection.
          The list of enumerated values for this property may expand in the future. Code
          and processes using this field  must tolerate unexpected values.
    :attr str type: Virtual connection type.
          The list of enumerated values for this property may expand in the future. Code
          and processes using this field  must tolerate unexpected values.
    """

    def __init__(self,
                 created_at: datetime,
                 id: str,
                 name: str,
                 status: str,
                 type: str,
                 *,
                 network_account: str = None,
                 network_id: str = None) -> None:
        """
        Initialize a GatewayVirtualConnection object.

        :param datetime created_at: The date and time resource was created.
        :param str id: The unique identifier for this virtual connection.
        :param str name: The user-defined name for this virtual connection.
               Virtual connection names are unique within a gateway.  This is the name of
               the virtual connection itself, the network being connected may have its own
               name attribute.
        :param str status: Status of the virtual connection.
               The list of enumerated values for this property may expand in the future.
               Code and processes using this field  must tolerate unexpected values.
        :param str type: Virtual connection type.
               The list of enumerated values for this property may expand in the future.
               Code and processes using this field  must tolerate unexpected values.
        :param str network_account: (optional) For virtual connections across two
               different IBM Cloud Accounts network_account indicates the account that
               owns the target network.
        :param str network_id: (optional) Unique identifier of the target network.
               For type=vpc virtual connections this is the CRN of the target VPC.  This
               field does not apply to type=classic connections.
        """
        self.created_at = created_at
        self.id = id
        self.name = name
        self.network_account = network_account
        self.network_id = network_id
        self.status = status
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayVirtualConnection':
        """Initialize a GatewayVirtualConnection object from a json dictionary."""
        args = {}
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in GatewayVirtualConnection JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in GatewayVirtualConnection JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in GatewayVirtualConnection JSON')
        if 'network_account' in _dict:
            args['network_account'] = _dict.get('network_account')
        if 'network_id' in _dict:
            args['network_id'] = _dict.get('network_id')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in GatewayVirtualConnection JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayVirtualConnection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayVirtualConnection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'network_account') and self.network_account is not None:
            _dict['network_account'] = self.network_account
        if hasattr(self, 'network_id') and self.network_id is not None:
            _dict['network_id'] = self.network_id
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayVirtualConnection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayVirtualConnection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayVirtualConnection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class StatusEnum(str, Enum):
        """
        Status of the virtual connection.
        The list of enumerated values for this property may expand in the future. Code and
        processes using this field  must tolerate unexpected values.
        """
        PENDING = 'pending'
        ATTACHED = 'attached'
        APPROVAL_PENDING = 'approval_pending'
        REJECTED = 'rejected'
        EXPIRED = 'expired'
        DELETING = 'deleting'
        DETACHED_BY_NETWORK_PENDING = 'detached_by_network_pending'
        DETACHED_BY_NETWORK = 'detached_by_network'


    class TypeEnum(str, Enum):
        """
        Virtual connection type.
        The list of enumerated values for this property may expand in the future. Code and
        processes using this field  must tolerate unexpected values.
        """
        CLASSIC = 'classic'
        VPC = 'vpc'
        TRANSIT = 'transit'


class GatewayVirtualConnectionCollection():
    """
    Virtual connection collection.

    :attr List[GatewayVirtualConnection] virtual_connections: virtual connection
          array.
    """

    def __init__(self,
                 virtual_connections: List['GatewayVirtualConnection']) -> None:
        """
        Initialize a GatewayVirtualConnectionCollection object.

        :param List[GatewayVirtualConnection] virtual_connections: virtual
               connection array.
        """
        self.virtual_connections = virtual_connections

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayVirtualConnectionCollection':
        """Initialize a GatewayVirtualConnectionCollection object from a json dictionary."""
        args = {}
        if 'virtual_connections' in _dict:
            args['virtual_connections'] = [GatewayVirtualConnection.from_dict(x) for x in _dict.get('virtual_connections')]
        else:
            raise ValueError('Required property \'virtual_connections\' not present in GatewayVirtualConnectionCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayVirtualConnectionCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'virtual_connections') and self.virtual_connections is not None:
            _dict['virtual_connections'] = [x.to_dict() for x in self.virtual_connections]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayVirtualConnectionCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayVirtualConnectionCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayVirtualConnectionCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class LocationCollection():
    """
    location collection.

    :attr List[LocationOutput] locations: Collection of Direct Link locations.
    """

    def __init__(self,
                 locations: List['LocationOutput']) -> None:
        """
        Initialize a LocationCollection object.

        :param List[LocationOutput] locations: Collection of Direct Link locations.
        """
        self.locations = locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'LocationCollection':
        """Initialize a LocationCollection object from a json dictionary."""
        args = {}
        if 'locations' in _dict:
            args['locations'] = [LocationOutput.from_dict(x) for x in _dict.get('locations')]
        else:
            raise ValueError('Required property \'locations\' not present in LocationCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a LocationCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'locations') and self.locations is not None:
            _dict['locations'] = [x.to_dict() for x in self.locations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this LocationCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'LocationCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'LocationCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class LocationCrossConnectRouterCollection():
    """
    List of cross connect router details.

    :attr List[CrossConnectRouter] cross_connect_routers: (optional) Array of
          Routers for this location.
    """

    def __init__(self,
                 *,
                 cross_connect_routers: List['CrossConnectRouter'] = None) -> None:
        """
        Initialize a LocationCrossConnectRouterCollection object.

        :param List[CrossConnectRouter] cross_connect_routers: (optional) Array of
               Routers for this location.
        """
        self.cross_connect_routers = cross_connect_routers

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'LocationCrossConnectRouterCollection':
        """Initialize a LocationCrossConnectRouterCollection object from a json dictionary."""
        args = {}
        if 'cross_connect_routers' in _dict:
            args['cross_connect_routers'] = [CrossConnectRouter.from_dict(x) for x in _dict.get('cross_connect_routers')]
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a LocationCrossConnectRouterCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'cross_connect_routers') and self.cross_connect_routers is not None:
            _dict['cross_connect_routers'] = [x.to_dict() for x in self.cross_connect_routers]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this LocationCrossConnectRouterCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'LocationCrossConnectRouterCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'LocationCrossConnectRouterCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class LocationOutput():
    """
    location.

    :attr str billing_location: (optional) Billing location.  Only present for
          locations where provisioning is enabled.
    :attr str building_colocation_owner: (optional) Building colocation owner.  Only
          present for offering_type=dedicated locations where provisioning is enabled.
    :attr str display_name: Location long name.
    :attr str location_type: Location type.
    :attr bool macsec_enabled: (optional) Indicate whether location supports MACsec.
           Only returned for gateway type=dedicated locations.  Contact IBM support for
          access to MACsec.
    :attr str market: Location market.
    :attr str market_geography: (optional) Location geography.  Only present for
          locations where provisioning is enabled.
    :attr bool mzr: (optional) Is location a multi-zone region (MZR).  Only present
          for locations where provisioning is enabled.
    :attr str name: Location short name.
    :attr str offering_type: Location offering type.
    :attr bool provision_enabled: Indicates for the specific offering_type whether
          this location supports gateway provisioning.
    :attr str vpc_region: (optional) Location's VPC region.  Only present for
          locations where provisioning is enabled.
    """

    def __init__(self,
                 display_name: str,
                 location_type: str,
                 market: str,
                 name: str,
                 offering_type: str,
                 provision_enabled: bool,
                 *,
                 billing_location: str = None,
                 building_colocation_owner: str = None,
                 macsec_enabled: bool = None,
                 market_geography: str = None,
                 mzr: bool = None,
                 vpc_region: str = None) -> None:
        """
        Initialize a LocationOutput object.

        :param str display_name: Location long name.
        :param str location_type: Location type.
        :param str market: Location market.
        :param str name: Location short name.
        :param str offering_type: Location offering type.
        :param bool provision_enabled: Indicates for the specific offering_type
               whether this location supports gateway provisioning.
        :param str billing_location: (optional) Billing location.  Only present for
               locations where provisioning is enabled.
        :param str building_colocation_owner: (optional) Building colocation owner.
                Only present for offering_type=dedicated locations where provisioning is
               enabled.
        :param bool macsec_enabled: (optional) Indicate whether location supports
               MACsec.  Only returned for gateway type=dedicated locations.  Contact IBM
               support for access to MACsec.
        :param str market_geography: (optional) Location geography.  Only present
               for locations where provisioning is enabled.
        :param bool mzr: (optional) Is location a multi-zone region (MZR).  Only
               present for locations where provisioning is enabled.
        :param str vpc_region: (optional) Location's VPC region.  Only present for
               locations where provisioning is enabled.
        """
        self.billing_location = billing_location
        self.building_colocation_owner = building_colocation_owner
        self.display_name = display_name
        self.location_type = location_type
        self.macsec_enabled = macsec_enabled
        self.market = market
        self.market_geography = market_geography
        self.mzr = mzr
        self.name = name
        self.offering_type = offering_type
        self.provision_enabled = provision_enabled
        self.vpc_region = vpc_region

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'LocationOutput':
        """Initialize a LocationOutput object from a json dictionary."""
        args = {}
        if 'billing_location' in _dict:
            args['billing_location'] = _dict.get('billing_location')
        if 'building_colocation_owner' in _dict:
            args['building_colocation_owner'] = _dict.get('building_colocation_owner')
        if 'display_name' in _dict:
            args['display_name'] = _dict.get('display_name')
        else:
            raise ValueError('Required property \'display_name\' not present in LocationOutput JSON')
        if 'location_type' in _dict:
            args['location_type'] = _dict.get('location_type')
        else:
            raise ValueError('Required property \'location_type\' not present in LocationOutput JSON')
        if 'macsec_enabled' in _dict:
            args['macsec_enabled'] = _dict.get('macsec_enabled')
        if 'market' in _dict:
            args['market'] = _dict.get('market')
        else:
            raise ValueError('Required property \'market\' not present in LocationOutput JSON')
        if 'market_geography' in _dict:
            args['market_geography'] = _dict.get('market_geography')
        if 'mzr' in _dict:
            args['mzr'] = _dict.get('mzr')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in LocationOutput JSON')
        if 'offering_type' in _dict:
            args['offering_type'] = _dict.get('offering_type')
        else:
            raise ValueError('Required property \'offering_type\' not present in LocationOutput JSON')
        if 'provision_enabled' in _dict:
            args['provision_enabled'] = _dict.get('provision_enabled')
        else:
            raise ValueError('Required property \'provision_enabled\' not present in LocationOutput JSON')
        if 'vpc_region' in _dict:
            args['vpc_region'] = _dict.get('vpc_region')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a LocationOutput object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'billing_location') and self.billing_location is not None:
            _dict['billing_location'] = self.billing_location
        if hasattr(self, 'building_colocation_owner') and self.building_colocation_owner is not None:
            _dict['building_colocation_owner'] = self.building_colocation_owner
        if hasattr(self, 'display_name') and self.display_name is not None:
            _dict['display_name'] = self.display_name
        if hasattr(self, 'location_type') and self.location_type is not None:
            _dict['location_type'] = self.location_type
        if hasattr(self, 'macsec_enabled') and self.macsec_enabled is not None:
            _dict['macsec_enabled'] = self.macsec_enabled
        if hasattr(self, 'market') and self.market is not None:
            _dict['market'] = self.market
        if hasattr(self, 'market_geography') and self.market_geography is not None:
            _dict['market_geography'] = self.market_geography
        if hasattr(self, 'mzr') and self.mzr is not None:
            _dict['mzr'] = self.mzr
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'offering_type') and self.offering_type is not None:
            _dict['offering_type'] = self.offering_type
        if hasattr(self, 'provision_enabled') and self.provision_enabled is not None:
            _dict['provision_enabled'] = self.provision_enabled
        if hasattr(self, 'vpc_region') and self.vpc_region is not None:
            _dict['vpc_region'] = self.vpc_region
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this LocationOutput object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'LocationOutput') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'LocationOutput') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class OfferingSpeed():
    """
    Speed.

    :attr List[str] capabilities: Array of capabilities for billing option.
    :attr int link_speed: Link speed in megabits per second.
    :attr bool macsec_enabled: (optional) Indicate whether speed supports MACsec.
          Only returned for gateway type=dedicated speeds.  Contact IBM support for access
          to MACsec.
    """

    def __init__(self,
                 capabilities: List[str],
                 link_speed: int,
                 *,
                 macsec_enabled: bool = None) -> None:
        """
        Initialize a OfferingSpeed object.

        :param List[str] capabilities: Array of capabilities for billing option.
        :param int link_speed: Link speed in megabits per second.
        :param bool macsec_enabled: (optional) Indicate whether speed supports
               MACsec.  Only returned for gateway type=dedicated speeds.  Contact IBM
               support for access to MACsec.
        """
        self.capabilities = capabilities
        self.link_speed = link_speed
        self.macsec_enabled = macsec_enabled

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'OfferingSpeed':
        """Initialize a OfferingSpeed object from a json dictionary."""
        args = {}
        if 'capabilities' in _dict:
            args['capabilities'] = _dict.get('capabilities')
        else:
            raise ValueError('Required property \'capabilities\' not present in OfferingSpeed JSON')
        if 'link_speed' in _dict:
            args['link_speed'] = _dict.get('link_speed')
        else:
            raise ValueError('Required property \'link_speed\' not present in OfferingSpeed JSON')
        if 'macsec_enabled' in _dict:
            args['macsec_enabled'] = _dict.get('macsec_enabled')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a OfferingSpeed object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'capabilities') and self.capabilities is not None:
            _dict['capabilities'] = self.capabilities
        if hasattr(self, 'link_speed') and self.link_speed is not None:
            _dict['link_speed'] = self.link_speed
        if hasattr(self, 'macsec_enabled') and self.macsec_enabled is not None:
            _dict['macsec_enabled'] = self.macsec_enabled
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this OfferingSpeed object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'OfferingSpeed') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'OfferingSpeed') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class OfferingSpeedCollection():
    """
    OfferingSpeedCollection.

    :attr List[OfferingSpeed] speeds: speed list.
    """

    def __init__(self,
                 speeds: List['OfferingSpeed']) -> None:
        """
        Initialize a OfferingSpeedCollection object.

        :param List[OfferingSpeed] speeds: speed list.
        """
        self.speeds = speeds

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'OfferingSpeedCollection':
        """Initialize a OfferingSpeedCollection object from a json dictionary."""
        args = {}
        if 'speeds' in _dict:
            args['speeds'] = [OfferingSpeed.from_dict(x) for x in _dict.get('speeds')]
        else:
            raise ValueError('Required property \'speeds\' not present in OfferingSpeedCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a OfferingSpeedCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'speeds') and self.speeds is not None:
            _dict['speeds'] = [x.to_dict() for x in self.speeds]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this OfferingSpeedCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'OfferingSpeedCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'OfferingSpeedCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Port():
    """
    Provider port details.

    :attr int direct_link_count: Count of existing Direct Link gateways in this
          account on this port.
    :attr str id: Port identifier.
    :attr str label: Port Label.
    :attr str location_display_name: Port location long name.
    :attr str location_name: Port location name identifier.
    :attr str provider_name: Port's provider name.
    :attr List[int] supported_link_speeds: Port's supported speeds in megabits per
          second.
    """

    def __init__(self,
                 direct_link_count: int,
                 id: str,
                 label: str,
                 location_display_name: str,
                 location_name: str,
                 provider_name: str,
                 supported_link_speeds: List[int]) -> None:
        """
        Initialize a Port object.

        :param int direct_link_count: Count of existing Direct Link gateways in
               this account on this port.
        :param str id: Port identifier.
        :param str label: Port Label.
        :param str location_display_name: Port location long name.
        :param str location_name: Port location name identifier.
        :param str provider_name: Port's provider name.
        :param List[int] supported_link_speeds: Port's supported speeds in megabits
               per second.
        """
        self.direct_link_count = direct_link_count
        self.id = id
        self.label = label
        self.location_display_name = location_display_name
        self.location_name = location_name
        self.provider_name = provider_name
        self.supported_link_speeds = supported_link_speeds

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Port':
        """Initialize a Port object from a json dictionary."""
        args = {}
        if 'direct_link_count' in _dict:
            args['direct_link_count'] = _dict.get('direct_link_count')
        else:
            raise ValueError('Required property \'direct_link_count\' not present in Port JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Port JSON')
        if 'label' in _dict:
            args['label'] = _dict.get('label')
        else:
            raise ValueError('Required property \'label\' not present in Port JSON')
        if 'location_display_name' in _dict:
            args['location_display_name'] = _dict.get('location_display_name')
        else:
            raise ValueError('Required property \'location_display_name\' not present in Port JSON')
        if 'location_name' in _dict:
            args['location_name'] = _dict.get('location_name')
        else:
            raise ValueError('Required property \'location_name\' not present in Port JSON')
        if 'provider_name' in _dict:
            args['provider_name'] = _dict.get('provider_name')
        else:
            raise ValueError('Required property \'provider_name\' not present in Port JSON')
        if 'supported_link_speeds' in _dict:
            args['supported_link_speeds'] = _dict.get('supported_link_speeds')
        else:
            raise ValueError('Required property \'supported_link_speeds\' not present in Port JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Port object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'direct_link_count') and self.direct_link_count is not None:
            _dict['direct_link_count'] = self.direct_link_count
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'label') and self.label is not None:
            _dict['label'] = self.label
        if hasattr(self, 'location_display_name') and self.location_display_name is not None:
            _dict['location_display_name'] = self.location_display_name
        if hasattr(self, 'location_name') and self.location_name is not None:
            _dict['location_name'] = self.location_name
        if hasattr(self, 'provider_name') and self.provider_name is not None:
            _dict['provider_name'] = self.provider_name
        if hasattr(self, 'supported_link_speeds') and self.supported_link_speeds is not None:
            _dict['supported_link_speeds'] = self.supported_link_speeds
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Port object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Port') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Port') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class PortCollection():
    """
    List of port label details.

    :attr PortsPaginatedCollectionFirst first: A reference to the first page of
          resources.
    :attr int limit: The maximum number of resources can be returned by the request.
    :attr PortsPaginatedCollectionNext next: (optional) A reference to the next page
          of resources; this reference is included for all pages except the last page.
    :attr int total_count: The total number of resources across all pages.
    :attr List[Port] ports: (optional) Array of ports.
    """

    def __init__(self,
                 first: 'PortsPaginatedCollectionFirst',
                 limit: int,
                 total_count: int,
                 *,
                 next: 'PortsPaginatedCollectionNext' = None,
                 ports: List['Port'] = None) -> None:
        """
        Initialize a PortCollection object.

        :param PortsPaginatedCollectionFirst first: A reference to the first page
               of resources.
        :param int limit: The maximum number of resources can be returned by the
               request.
        :param int total_count: The total number of resources across all pages.
        :param PortsPaginatedCollectionNext next: (optional) A reference to the
               next page of resources; this reference is included for all pages except the
               last page.
        :param List[Port] ports: (optional) Array of ports.
        """
        self.first = first
        self.limit = limit
        self.next = next
        self.total_count = total_count
        self.ports = ports

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PortCollection':
        """Initialize a PortCollection object from a json dictionary."""
        args = {}
        if 'first' in _dict:
            args['first'] = PortsPaginatedCollectionFirst.from_dict(_dict.get('first'))
        else:
            raise ValueError('Required property \'first\' not present in PortCollection JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in PortCollection JSON')
        if 'next' in _dict:
            args['next'] = PortsPaginatedCollectionNext.from_dict(_dict.get('next'))
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in PortCollection JSON')
        if 'ports' in _dict:
            args['ports'] = [Port.from_dict(x) for x in _dict.get('ports')]
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PortCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'ports') and self.ports is not None:
            _dict['ports'] = [x.to_dict() for x in self.ports]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PortCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PortCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PortCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class PortsPaginatedCollectionFirst():
    """
    A reference to the first page of resources.

    :attr str href: The URL for the first page of resources.
    """

    def __init__(self,
                 href: str) -> None:
        """
        Initialize a PortsPaginatedCollectionFirst object.

        :param str href: The URL for the first page of resources.
        """
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PortsPaginatedCollectionFirst':
        """Initialize a PortsPaginatedCollectionFirst object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError('Required property \'href\' not present in PortsPaginatedCollectionFirst JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PortsPaginatedCollectionFirst object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PortsPaginatedCollectionFirst object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PortsPaginatedCollectionFirst') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PortsPaginatedCollectionFirst') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class PortsPaginatedCollectionNext():
    """
    A reference to the next page of resources; this reference is included for all pages
    except the last page.

    :attr str href: URL for the next page of resources.
    :attr str start: (optional) start token for the next page of resources.
    """

    def __init__(self,
                 href: str,
                 *,
                 start: str = None) -> None:
        """
        Initialize a PortsPaginatedCollectionNext object.

        :param str href: URL for the next page of resources.
        :param str start: (optional) start token for the next page of resources.
        """
        self.href = href
        self.start = start

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PortsPaginatedCollectionNext':
        """Initialize a PortsPaginatedCollectionNext object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError('Required property \'href\' not present in PortsPaginatedCollectionNext JSON')
        if 'start' in _dict:
            args['start'] = _dict.get('start')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PortsPaginatedCollectionNext object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        if hasattr(self, 'start') and self.start is not None:
            _dict['start'] = self.start
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PortsPaginatedCollectionNext object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PortsPaginatedCollectionNext') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PortsPaginatedCollectionNext') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class ResourceGroupIdentity():
    """
    Resource group for this resource. If unspecified, the account's [default resource
    group](https://cloud.ibm.com/apidocs/resource-manager#introduction) is used.

    :attr str id: Resource group identifier.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a ResourceGroupIdentity object.

        :param str id: Resource group identifier.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupIdentity':
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in ResourceGroupIdentity JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupIdentity object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class ResourceGroupReference():
    """
    Resource group reference.

    :attr str id: Resource group identifier.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a ResourceGroupReference object.

        :param str id: Resource group identifier.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupReference':
        """Initialize a ResourceGroupReference object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in ResourceGroupReference JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RouteReport():
    """
    route report.

    :attr datetime created_at: Date and time route report was requested.
    :attr List[RouteReportRoute] gateway_routes: Array of local/direct routes.
    :attr str id: Report identifier.
    :attr List[RouteReportOnPremRoute] on_prem_routes: Array of on premises routes.
    :attr List[RouteReportOverlappingRouteGroup] overlapping_routes: Array of
          overlapping routes.
    :attr str status: Route report status. The list of enumerated values for this
          property may expand in the future. Code and processes using this field must
          tolerate unexpected values.
    :attr datetime updated_at: (optional) Date and time route report was last
          modified.
    :attr List[RouteReportConnection] virtual_connection_routes: Array of routes on
          virtual connections.
    """

    def __init__(self,
                 created_at: datetime,
                 gateway_routes: List['RouteReportRoute'],
                 id: str,
                 on_prem_routes: List['RouteReportOnPremRoute'],
                 overlapping_routes: List['RouteReportOverlappingRouteGroup'],
                 status: str,
                 virtual_connection_routes: List['RouteReportConnection'],
                 *,
                 updated_at: datetime = None) -> None:
        """
        Initialize a RouteReport object.

        :param datetime created_at: Date and time route report was requested.
        :param List[RouteReportRoute] gateway_routes: Array of local/direct routes.
        :param str id: Report identifier.
        :param List[RouteReportOnPremRoute] on_prem_routes: Array of on premises
               routes.
        :param List[RouteReportOverlappingRouteGroup] overlapping_routes: Array of
               overlapping routes.
        :param str status: Route report status. The list of enumerated values for
               this property may expand in the future. Code and processes using this field
               must tolerate unexpected values.
        :param List[RouteReportConnection] virtual_connection_routes: Array of
               routes on virtual connections.
        :param datetime updated_at: (optional) Date and time route report was last
               modified.
        """
        self.created_at = created_at
        self.gateway_routes = gateway_routes
        self.id = id
        self.on_prem_routes = on_prem_routes
        self.overlapping_routes = overlapping_routes
        self.status = status
        self.updated_at = updated_at
        self.virtual_connection_routes = virtual_connection_routes

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReport':
        """Initialize a RouteReport object from a json dictionary."""
        args = {}
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in RouteReport JSON')
        if 'gateway_routes' in _dict:
            args['gateway_routes'] = [RouteReportRoute.from_dict(x) for x in _dict.get('gateway_routes')]
        else:
            raise ValueError('Required property \'gateway_routes\' not present in RouteReport JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in RouteReport JSON')
        if 'on_prem_routes' in _dict:
            args['on_prem_routes'] = [RouteReportOnPremRoute.from_dict(x) for x in _dict.get('on_prem_routes')]
        else:
            raise ValueError('Required property \'on_prem_routes\' not present in RouteReport JSON')
        if 'overlapping_routes' in _dict:
            args['overlapping_routes'] = [RouteReportOverlappingRouteGroup.from_dict(x) for x in _dict.get('overlapping_routes')]
        else:
            raise ValueError('Required property \'overlapping_routes\' not present in RouteReport JSON')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in RouteReport JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        if 'virtual_connection_routes' in _dict:
            args['virtual_connection_routes'] = [RouteReportConnection.from_dict(x) for x in _dict.get('virtual_connection_routes')]
        else:
            raise ValueError('Required property \'virtual_connection_routes\' not present in RouteReport JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReport object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'gateway_routes') and self.gateway_routes is not None:
            _dict['gateway_routes'] = [x.to_dict() for x in self.gateway_routes]
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'on_prem_routes') and self.on_prem_routes is not None:
            _dict['on_prem_routes'] = [x.to_dict() for x in self.on_prem_routes]
        if hasattr(self, 'overlapping_routes') and self.overlapping_routes is not None:
            _dict['overlapping_routes'] = [x.to_dict() for x in self.overlapping_routes]
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'virtual_connection_routes') and self.virtual_connection_routes is not None:
            _dict['virtual_connection_routes'] = [x.to_dict() for x in self.virtual_connection_routes]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReport object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReport') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReport') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class StatusEnum(str, Enum):
        """
        Route report status. The list of enumerated values for this property may expand in
        the future. Code and processes using this field must tolerate unexpected values.
        """
        COMPLETE = 'complete'
        PENDING = 'pending'


class RouteReportCollection():
    """
    route reports.

    :attr List[RouteReport] route_reports: Array of route reports.
    """

    def __init__(self,
                 route_reports: List['RouteReport']) -> None:
        """
        Initialize a RouteReportCollection object.

        :param List[RouteReport] route_reports: Array of route reports.
        """
        self.route_reports = route_reports

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportCollection':
        """Initialize a RouteReportCollection object from a json dictionary."""
        args = {}
        if 'route_reports' in _dict:
            args['route_reports'] = [RouteReport.from_dict(x) for x in _dict.get('route_reports')]
        else:
            raise ValueError('Required property \'route_reports\' not present in RouteReportCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'route_reports') and self.route_reports is not None:
            _dict['route_reports'] = [x.to_dict() for x in self.route_reports]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RouteReportConnection():
    """
    Routes of a virtual connection.

    :attr List[RouteReportRoute] routes: Array of virtual connection's routes.
    :attr str virtual_connection_id: (optional) ID of virtual connection.
    :attr str virtual_connection_name: (optional) name of virtual connection.
    :attr str virtual_connection_type: (optional) type of virtual connection.
    """

    def __init__(self,
                 routes: List['RouteReportRoute'],
                 *,
                 virtual_connection_id: str = None,
                 virtual_connection_name: str = None,
                 virtual_connection_type: str = None) -> None:
        """
        Initialize a RouteReportConnection object.

        :param List[RouteReportRoute] routes: Array of virtual connection's routes.
        :param str virtual_connection_id: (optional) ID of virtual connection.
        :param str virtual_connection_name: (optional) name of virtual connection.
        :param str virtual_connection_type: (optional) type of virtual connection.
        """
        self.routes = routes
        self.virtual_connection_id = virtual_connection_id
        self.virtual_connection_name = virtual_connection_name
        self.virtual_connection_type = virtual_connection_type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportConnection':
        """Initialize a RouteReportConnection object from a json dictionary."""
        args = {}
        if 'routes' in _dict:
            args['routes'] = [RouteReportRoute.from_dict(x) for x in _dict.get('routes')]
        else:
            raise ValueError('Required property \'routes\' not present in RouteReportConnection JSON')
        if 'virtual_connection_id' in _dict:
            args['virtual_connection_id'] = _dict.get('virtual_connection_id')
        if 'virtual_connection_name' in _dict:
            args['virtual_connection_name'] = _dict.get('virtual_connection_name')
        if 'virtual_connection_type' in _dict:
            args['virtual_connection_type'] = _dict.get('virtual_connection_type')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportConnection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'routes') and self.routes is not None:
            _dict['routes'] = [x.to_dict() for x in self.routes]
        if hasattr(self, 'virtual_connection_id') and self.virtual_connection_id is not None:
            _dict['virtual_connection_id'] = self.virtual_connection_id
        if hasattr(self, 'virtual_connection_name') and self.virtual_connection_name is not None:
            _dict['virtual_connection_name'] = self.virtual_connection_name
        if hasattr(self, 'virtual_connection_type') and self.virtual_connection_type is not None:
            _dict['virtual_connection_type'] = self.virtual_connection_type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportConnection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportConnection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportConnection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RouteReportOnPremRoute():
    """
    on-prem route.

    :attr str next_hop: (optional) Next hop address.
    :attr str prefix: (optional) prefix.
    """

    def __init__(self,
                 *,
                 next_hop: str = None,
                 prefix: str = None) -> None:
        """
        Initialize a RouteReportOnPremRoute object.

        :param str next_hop: (optional) Next hop address.
        :param str prefix: (optional) prefix.
        """
        self.next_hop = next_hop
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOnPremRoute':
        """Initialize a RouteReportOnPremRoute object from a json dictionary."""
        args = {}
        if 'next_hop' in _dict:
            args['next_hop'] = _dict.get('next_hop')
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOnPremRoute object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'next_hop') and self.next_hop is not None:
            _dict['next_hop'] = self.next_hop
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOnPremRoute object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOnPremRoute') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOnPremRoute') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RouteReportOverlappingRoute():
    """
    overlapping route details.

    """

    def __init__(self) -> None:
        """
        Initialize a RouteReportOverlappingRoute object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['RouteReportOverlappingRouteForConnection', 'RouteReportOverlappingRouteForOthers']))
        raise Exception(msg)

class RouteReportOverlappingRouteGroup():
    """
    Collection of overlapping route.

    :attr List[RouteReportOverlappingRoute] routes: (optional) Array of overlapping
          connection/prefix pairs.
    """

    def __init__(self,
                 *,
                 routes: List['RouteReportOverlappingRoute'] = None) -> None:
        """
        Initialize a RouteReportOverlappingRouteGroup object.

        :param List[RouteReportOverlappingRoute] routes: (optional) Array of
               overlapping connection/prefix pairs.
        """
        self.routes = routes

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOverlappingRouteGroup':
        """Initialize a RouteReportOverlappingRouteGroup object from a json dictionary."""
        args = {}
        if 'routes' in _dict:
            args['routes'] = _dict.get('routes')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOverlappingRouteGroup object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'routes') and self.routes is not None:
            routes_list = []
            for x in self.routes:
                if isinstance(x, dict):
                    routes_list.append(x)
                else:
                    routes_list.append(x.to_dict())
            _dict['routes'] = routes_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOverlappingRouteGroup object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOverlappingRouteGroup') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOverlappingRouteGroup') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RouteReportRoute():
    """
    route.

    :attr str prefix: (optional) prefix.
    """

    def __init__(self,
                 *,
                 prefix: str = None) -> None:
        """
        Initialize a RouteReportRoute object.

        :param str prefix: (optional) prefix.
        """
        self.prefix = prefix

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportRoute':
        """Initialize a RouteReportRoute object from a json dictionary."""
        args = {}
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportRoute object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportRoute object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportRoute') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportRoute') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate(GatewayActionTemplateUpdatesItem):
    """
    The autonomous system number (ASN) of Border Gateway Protocol
    (BGP) configuration for the IBM side of the DL 2.0 gateway.

    :attr int bgp_asn: (optional) New gateway BGP ASN.
    """

    def __init__(self,
                 *,
                 bgp_asn: int = None) -> None:
        """
        Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate object.

        :param int bgp_asn: (optional) New gateway BGP ASN.
        """
        # pylint: disable=super-init-not-called
        self.bgp_asn = bgp_asn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate':
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate object from a json dictionary."""
        args = {}
        if 'bgp_asn' in _dict:
            args['bgp_asn'] = _dict.get('bgp_asn')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bgp_asn') and self.bgp_asn is not None:
            _dict['bgp_asn'] = self.bgp_asn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientBGPASNUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate(GatewayActionTemplateUpdatesItem):
    """
    Update BGP customer and IBM CIDR.

    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR is the new CIDR
          (Classless Inter-Domain Routing) value to be updated on customer edge router for
          the DL 2.0 gateway.
          Customer edge IP and IBM IP should be in the same network. Updating customer
          edge router CIDR should be accompanied with IBM CIDR in the request. Update
          customer edge router IP to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value
          must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR is the new CIDR (Classless
          Inter-Domain Routing) value to be updated on IBM edge router for the DL 2.0
          gateway.
          IBM IP and customer edge IP should be in the same network. Updating IBM CIDR
          should be accompanied with customer edge router CIDR in the request. Update IBM
          CIDR to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value must reside in one
          of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16", "169.254.0.0/16" or an
          owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must have matching network and
          subnet mask values.
    """

    def __init__(self,
                 *,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_cidr: str = None) -> None:
        """
        Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate object.

        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR is the
               new CIDR (Classless Inter-Domain Routing) value to be updated on customer
               edge router for the DL 2.0 gateway.
               Customer edge IP and IBM IP should be in the same network. Updating
               customer edge router CIDR should be accompanied with IBM CIDR in the
               request. Update customer edge router IP to a valid bgp_cer_cidr and
               bgp_ibm_cidr CIDR, the value must reside in one of "10.254.0.0/16",
               "172.16.0.0/12", "192.168.0.0/16",
               "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr
               must have matching network and subnet mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR is the new CIDR (Classless
               Inter-Domain Routing) value to be updated on IBM edge router for the DL 2.0
               gateway.
               IBM IP and customer edge IP should be in the same network. Updating IBM
               CIDR should be accompanied with customer edge router CIDR in the request.
               Update IBM CIDR to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value
               must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
               "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr
               must have matching network and subnet mask values.
        """
        # pylint: disable=super-init-not-called
        self.bgp_cer_cidr = bgp_cer_cidr
        self.bgp_ibm_cidr = bgp_ibm_cidr

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate':
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate object from a json dictionary."""
        args = {}
        if 'bgp_cer_cidr' in _dict:
            args['bgp_cer_cidr'] = _dict.get('bgp_cer_cidr')
        if 'bgp_ibm_cidr' in _dict:
            args['bgp_ibm_cidr'] = _dict.get('bgp_ibm_cidr')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bgp_cer_cidr') and self.bgp_cer_cidr is not None:
            _dict['bgp_cer_cidr'] = self.bgp_cer_cidr
        if hasattr(self, 'bgp_ibm_cidr') and self.bgp_ibm_cidr is not None:
            _dict['bgp_ibm_cidr'] = self.bgp_ibm_cidr
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientBGPIPUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate(GatewayActionTemplateUpdatesItem):
    """
    gateway speed change.

    :attr int speed_mbps: (optional) New gateway speed in megabits per second.
    """

    def __init__(self,
                 *,
                 speed_mbps: int = None) -> None:
        """
        Initialize a GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate object.

        :param int speed_mbps: (optional) New gateway speed in megabits per second.
        """
        # pylint: disable=super-init-not-called
        self.speed_mbps = speed_mbps

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate':
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate object from a json dictionary."""
        args = {}
        if 'speed_mbps' in _dict:
            args['speed_mbps'] = _dict.get('speed_mbps')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'speed_mbps') and self.speed_mbps is not None:
            _dict['speed_mbps'] = self.speed_mbps
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientSpeedUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate(GatewayActionTemplateUpdatesItem):
    """
    Update VLAN for this gateway
    VLAN provided should be in the range 1 to 4094.

    :attr int vlan: (optional) VLAN to be updated for this gateway.
    """

    def __init__(self,
                 *,
                 vlan: int = None) -> None:
        """
        Initialize a GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate object.

        :param int vlan: (optional) VLAN to be updated for this gateway.
        """
        # pylint: disable=super-init-not-called
        self.vlan = vlan

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate':
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate object from a json dictionary."""
        args = {}
        if 'vlan' in _dict:
            args['vlan'] = _dict.get('vlan')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'vlan') and self.vlan is not None:
            _dict['vlan'] = self.vlan
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayActionTemplateUpdatesItemGatewayClientVLANUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate(GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem):
    """
    The autonomous system number (ASN) of Border Gateway Protocol
    (BGP) configuration for the IBM side of the DL 2.0 gateway.

    :attr int bgp_asn: (optional) New gateway BGP ASN.
    """

    def __init__(self,
                 *,
                 bgp_asn: int = None) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate object.

        :param int bgp_asn: (optional) New gateway BGP ASN.
        """
        # pylint: disable=super-init-not-called
        self.bgp_asn = bgp_asn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate':
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate object from a json dictionary."""
        args = {}
        if 'bgp_asn' in _dict:
            args['bgp_asn'] = _dict.get('bgp_asn')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bgp_asn') and self.bgp_asn is not None:
            _dict['bgp_asn'] = self.bgp_asn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPASNUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate(GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem):
    """
    Update BGP customer and IBM CIDR.

    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR is the new CIDR
          (Classless Inter-Domain Routing) value to be updated on customer edge router for
          the DL 2.0 gateway.
          Customer edge IP and IBM IP should be in the same network. Updating customer
          edge router CIDR should be accompanied with IBM CIDR in the request. Update
          customer edge router IP to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value
          must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR is the new CIDR (Classless
          Inter-Domain Routing) value to be updated on IBM edge router for the DL 2.0
          gateway.
          IBM IP and customer edge IP should be in the same network. Updating IBM CIDR
          should be accompanied with customer edge router CIDR in the request. Update IBM
          CIDR to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value must reside in one
          of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16", "169.254.0.0/16" or an
          owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must have matching network and
          subnet mask values.
    """

    def __init__(self,
                 *,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_cidr: str = None) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate object.

        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR is the
               new CIDR (Classless Inter-Domain Routing) value to be updated on customer
               edge router for the DL 2.0 gateway.
               Customer edge IP and IBM IP should be in the same network. Updating
               customer edge router CIDR should be accompanied with IBM CIDR in the
               request. Update customer edge router IP to a valid bgp_cer_cidr and
               bgp_ibm_cidr CIDR, the value must reside in one of "10.254.0.0/16",
               "172.16.0.0/12", "192.168.0.0/16",
               "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr
               must have matching network and subnet mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR is the new CIDR (Classless
               Inter-Domain Routing) value to be updated on IBM edge router for the DL 2.0
               gateway.
               IBM IP and customer edge IP should be in the same network. Updating IBM
               CIDR should be accompanied with customer edge router CIDR in the request.
               Update IBM CIDR to a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the value
               must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
               "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr
               must have matching network and subnet mask values.
        """
        # pylint: disable=super-init-not-called
        self.bgp_cer_cidr = bgp_cer_cidr
        self.bgp_ibm_cidr = bgp_ibm_cidr

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate':
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate object from a json dictionary."""
        args = {}
        if 'bgp_cer_cidr' in _dict:
            args['bgp_cer_cidr'] = _dict.get('bgp_cer_cidr')
        if 'bgp_ibm_cidr' in _dict:
            args['bgp_ibm_cidr'] = _dict.get('bgp_ibm_cidr')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bgp_cer_cidr') and self.bgp_cer_cidr is not None:
            _dict['bgp_cer_cidr'] = self.bgp_cer_cidr
        if hasattr(self, 'bgp_ibm_cidr') and self.bgp_ibm_cidr is not None:
            _dict['bgp_ibm_cidr'] = self.bgp_ibm_cidr
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientBGPIPUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate(GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem):
    """
    gateway speed change.

    :attr int speed_mbps: (optional) New gateway speed in megabits per second.
    """

    def __init__(self,
                 *,
                 speed_mbps: int = None) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate object.

        :param int speed_mbps: (optional) New gateway speed in megabits per second.
        """
        # pylint: disable=super-init-not-called
        self.speed_mbps = speed_mbps

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate':
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate object from a json dictionary."""
        args = {}
        if 'speed_mbps' in _dict:
            args['speed_mbps'] = _dict.get('speed_mbps')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'speed_mbps') and self.speed_mbps is not None:
            _dict['speed_mbps'] = self.speed_mbps
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientSpeedUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate(GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem):
    """
    Update VLAN for this gateway
    VLAN provided should be in the range 1 to 4094.

    :attr int vlan: (optional) VLAN to be updated for this gateway.
    """

    def __init__(self,
                 *,
                 vlan: int = None) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate object.

        :param int vlan: (optional) VLAN to be updated for this gateway.
        """
        # pylint: disable=super-init-not-called
        self.vlan = vlan

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate':
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate object from a json dictionary."""
        args = {}
        if 'vlan' in _dict:
            args['vlan'] = _dict.get('vlan')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'vlan') and self.vlan is not None:
            _dict['vlan'] = self.vlan
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItemGatewayClientVLANUpdate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class GatewayChangeRequestGatewayClientGatewayCreate(GatewayChangeRequest):
    """
    gateway create.

    :attr str type: type of gateway change request.
    """

    def __init__(self,
                 type: str) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayCreate object.

        :param str type: type of gateway change request.
        """
        # pylint: disable=super-init-not-called
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayCreate':
        """Initialize a GatewayChangeRequestGatewayClientGatewayCreate object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayChangeRequestGatewayClientGatewayCreate JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayCreate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayCreate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayCreate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayCreate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        type of gateway change request.
        """
        CREATE_GATEWAY = 'create_gateway'


class GatewayChangeRequestGatewayClientGatewayDelete(GatewayChangeRequest):
    """
    gateway delete.

    :attr str type: type of gateway change request.
    """

    def __init__(self,
                 type: str) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayDelete object.

        :param str type: type of gateway change request.
        """
        # pylint: disable=super-init-not-called
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayDelete':
        """Initialize a GatewayChangeRequestGatewayClientGatewayDelete object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayChangeRequestGatewayClientGatewayDelete JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayDelete object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayDelete object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayDelete') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayDelete') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        type of gateway change request.
        """
        DELETE_GATEWAY = 'delete_gateway'


class GatewayChangeRequestGatewayClientGatewayUpdateAttributes(GatewayChangeRequest):
    """
    gateway attributes update.

    :attr str type: type of gateway change request.
    :attr List[GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem]
          updates: array of pending updates.
    """

    def __init__(self,
                 type: str,
                 updates: List['GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem']) -> None:
        """
        Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributes object.

        :param str type: type of gateway change request.
        :param
               List[GatewayChangeRequestGatewayClientGatewayUpdateAttributesUpdatesItem]
               updates: array of pending updates.
        """
        # pylint: disable=super-init-not-called
        self.type = type
        self.updates = updates

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayChangeRequestGatewayClientGatewayUpdateAttributes':
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributes object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayChangeRequestGatewayClientGatewayUpdateAttributes JSON')
        if 'updates' in _dict:
            args['updates'] = _dict.get('updates')
        else:
            raise ValueError('Required property \'updates\' not present in GatewayChangeRequestGatewayClientGatewayUpdateAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayChangeRequestGatewayClientGatewayUpdateAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updates') and self.updates is not None:
            updates_list = []
            for x in self.updates:
                if isinstance(x, dict):
                    updates_list.append(x)
                else:
                    updates_list.append(x.to_dict())
            _dict['updates'] = updates_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayChangeRequestGatewayClientGatewayUpdateAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayChangeRequestGatewayClientGatewayUpdateAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        type of gateway change request.
        """
        UPDATE_ATTRIBUTES = 'update_attributes'


class GatewayStatusGatewayBFDStatus(GatewayStatus):
    """
    Gateway bfd status.

    :attr str type: Status type.
    :attr datetime updated_at: Date and time status was collected.
    :attr str value: Status.
    """

    def __init__(self,
                 type: str,
                 updated_at: datetime,
                 value: str) -> None:
        """
        Initialize a GatewayStatusGatewayBFDStatus object.

        :param str type: Status type.
        :param datetime updated_at: Date and time status was collected.
        :param str value: Status.
        """
        # pylint: disable=super-init-not-called
        self.type = type
        self.updated_at = updated_at
        self.value = value

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatusGatewayBFDStatus':
        """Initialize a GatewayStatusGatewayBFDStatus object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayStatusGatewayBFDStatus JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in GatewayStatusGatewayBFDStatus JSON')
        if 'value' in _dict:
            args['value'] = _dict.get('value')
        else:
            raise ValueError('Required property \'value\' not present in GatewayStatusGatewayBFDStatus JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatusGatewayBFDStatus object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'value') and self.value is not None:
            _dict['value'] = self.value
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatusGatewayBFDStatus object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatusGatewayBFDStatus') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatusGatewayBFDStatus') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Status type.
        """
        BFD = 'bfd'


    class ValueEnum(str, Enum):
        """
        Status.
        """
        NOT_AVAILABLE = 'not_available'
        INIT = 'init'
        UP = 'up'
        DOWN = 'down'


class GatewayStatusGatewayBGPStatus(GatewayStatus):
    """
    Gateway bgp status.

    :attr str type: Status type.
    :attr datetime updated_at: Date and time status was collected.
    :attr str value: Status.
    """

    def __init__(self,
                 type: str,
                 updated_at: datetime,
                 value: str) -> None:
        """
        Initialize a GatewayStatusGatewayBGPStatus object.

        :param str type: Status type.
        :param datetime updated_at: Date and time status was collected.
        :param str value: Status.
        """
        # pylint: disable=super-init-not-called
        self.type = type
        self.updated_at = updated_at
        self.value = value

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatusGatewayBGPStatus':
        """Initialize a GatewayStatusGatewayBGPStatus object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayStatusGatewayBGPStatus JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in GatewayStatusGatewayBGPStatus JSON')
        if 'value' in _dict:
            args['value'] = _dict.get('value')
        else:
            raise ValueError('Required property \'value\' not present in GatewayStatusGatewayBGPStatus JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatusGatewayBGPStatus object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'value') and self.value is not None:
            _dict['value'] = self.value
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatusGatewayBGPStatus object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatusGatewayBGPStatus') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatusGatewayBGPStatus') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Status type.
        """
        BGP = 'bgp'


    class ValueEnum(str, Enum):
        """
        Status.
        """
        ACTIVE = 'active'
        CONNECT = 'connect'
        ESTABLISHED = 'established'
        IDLE = 'idle'


class GatewayStatusGatewayLinkStatus(GatewayStatus):
    """
    Gateway link status. Only available for dedicated gateways.

    :attr str type: Status type.
    :attr datetime updated_at: Date and time status was collected.
    :attr str value: Status.
    """

    def __init__(self,
                 type: str,
                 updated_at: datetime,
                 value: str) -> None:
        """
        Initialize a GatewayStatusGatewayLinkStatus object.

        :param str type: Status type.
        :param datetime updated_at: Date and time status was collected.
        :param str value: Status.
        """
        # pylint: disable=super-init-not-called
        self.type = type
        self.updated_at = updated_at
        self.value = value

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayStatusGatewayLinkStatus':
        """Initialize a GatewayStatusGatewayLinkStatus object from a json dictionary."""
        args = {}
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayStatusGatewayLinkStatus JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in GatewayStatusGatewayLinkStatus JSON')
        if 'value' in _dict:
            args['value'] = _dict.get('value')
        else:
            raise ValueError('Required property \'value\' not present in GatewayStatusGatewayLinkStatus JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayStatusGatewayLinkStatus object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'value') and self.value is not None:
            _dict['value'] = self.value
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayStatusGatewayLinkStatus object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayStatusGatewayLinkStatus') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayStatusGatewayLinkStatus') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Status type.
        """
        LINK = 'link'


    class ValueEnum(str, Enum):
        """
        Status.
        """
        UP = 'up'
        DOWN = 'down'


class GatewayTemplateGatewayTypeConnectTemplate(GatewayTemplate):
    """
    Gateway fields specific to type=connect gateway create.

    :attr List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
          configuration information.
    :attr GatewayTemplateAuthenticationKey authentication_key: (optional)
    :attr GatewayBfdConfigTemplate bfd_config: (optional)
    :attr int bgp_asn: BGP ASN.
    :attr str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
          Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how to
          create a gateway using either automatic or explicit IP assignment.  Any
          bgp_base_cidr value set will be ignored.
          Deprecated field bgp_base_cidr will be removed from the API specificiation after
          15-MAR-2021.
    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str connection_mode: (optional) Type of services this Gateway is attached
          to. Mode transit means this Gateway will be attached to Transit Gateway Service
          and direct means this Gateway will be attached to vpc or classic connection. The
          list of enumerated values for this property may expand in the future. Code and
          processes using this field  must tolerate unexpected values.
    :attr bool global_: Gateways with global routing (`true`) can connect to
          networks outside their associated region.
    :attr bool metered: Metered billing option.  When `true` gateway usage is billed
          per gigabyte.  When `false` there is no per gigabyte usage charge, instead a
          flat rate is charged for the gateway.
    :attr str name: The unique user-defined name for this gateway.
    :attr str patch_panel_completion_notice: (optional) Gateway patch panel complete
          notification from implementation team.
    :attr ResourceGroupIdentity resource_group: (optional)
    :attr int speed_mbps: Gateway speed in megabits per second.
    :attr str type: Offering type.
    :attr GatewayPortIdentity port: Select Port Label for new type=connect gateway.
    """

    def __init__(self,
                 bgp_asn: int,
                 global_: bool,
                 metered: bool,
                 name: str,
                 speed_mbps: int,
                 type: str,
                 port: 'GatewayPortIdentity',
                 *,
                 as_prepends: List['AsPrependTemplate'] = None,
                 authentication_key: 'GatewayTemplateAuthenticationKey' = None,
                 bfd_config: 'GatewayBfdConfigTemplate' = None,
                 bgp_base_cidr: str = None,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_cidr: str = None,
                 connection_mode: str = None,
                 patch_panel_completion_notice: str = None,
                 resource_group: 'ResourceGroupIdentity' = None) -> None:
        """
        Initialize a GatewayTemplateGatewayTypeConnectTemplate object.

        :param int bgp_asn: BGP ASN.
        :param bool global_: Gateways with global routing (`true`) can connect to
               networks outside their associated region.
        :param bool metered: Metered billing option.  When `true` gateway usage is
               billed per gigabyte.  When `false` there is no per gigabyte usage charge,
               instead a flat rate is charged for the gateway.
        :param str name: The unique user-defined name for this gateway.
        :param int speed_mbps: Gateway speed in megabits per second.
        :param str type: Offering type.
        :param GatewayPortIdentity port: Select Port Label for new type=connect
               gateway.
        :param List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
               configuration information.
        :param GatewayTemplateAuthenticationKey authentication_key: (optional)
        :param GatewayBfdConfigTemplate bfd_config: (optional)
        :param str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
               Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how
               to create a gateway using either automatic or explicit IP assignment.  Any
               bgp_base_cidr value set will be ignored.
               Deprecated field bgp_base_cidr will be removed from the API specificiation
               after 15-MAR-2021.
        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str connection_mode: (optional) Type of services this Gateway is
               attached to. Mode transit means this Gateway will be attached to Transit
               Gateway Service and direct means this Gateway will be attached to vpc or
               classic connection. The list of enumerated values for this property may
               expand in the future. Code and processes using this field  must tolerate
               unexpected values.
        :param str patch_panel_completion_notice: (optional) Gateway patch panel
               complete notification from implementation team.
        :param ResourceGroupIdentity resource_group: (optional)
        """
        # pylint: disable=super-init-not-called
        self.as_prepends = as_prepends
        self.authentication_key = authentication_key
        self.bfd_config = bfd_config
        self.bgp_asn = bgp_asn
        self.bgp_base_cidr = bgp_base_cidr
        self.bgp_cer_cidr = bgp_cer_cidr
        self.bgp_ibm_cidr = bgp_ibm_cidr
        self.connection_mode = connection_mode
        self.global_ = global_
        self.metered = metered
        self.name = name
        self.patch_panel_completion_notice = patch_panel_completion_notice
        self.resource_group = resource_group
        self.speed_mbps = speed_mbps
        self.type = type
        self.port = port

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayTemplateGatewayTypeConnectTemplate':
        """Initialize a GatewayTemplateGatewayTypeConnectTemplate object from a json dictionary."""
        args = {}
        if 'as_prepends' in _dict:
            args['as_prepends'] = [AsPrependTemplate.from_dict(x) for x in _dict.get('as_prepends')]
        if 'authentication_key' in _dict:
            args['authentication_key'] = GatewayTemplateAuthenticationKey.from_dict(_dict.get('authentication_key'))
        if 'bfd_config' in _dict:
            args['bfd_config'] = GatewayBfdConfigTemplate.from_dict(_dict.get('bfd_config'))
        if 'bgp_asn' in _dict:
            args['bgp_asn'] = _dict.get('bgp_asn')
        else:
            raise ValueError('Required property \'bgp_asn\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'bgp_base_cidr' in _dict:
            args['bgp_base_cidr'] = _dict.get('bgp_base_cidr')
        if 'bgp_cer_cidr' in _dict:
            args['bgp_cer_cidr'] = _dict.get('bgp_cer_cidr')
        if 'bgp_ibm_cidr' in _dict:
            args['bgp_ibm_cidr'] = _dict.get('bgp_ibm_cidr')
        if 'connection_mode' in _dict:
            args['connection_mode'] = _dict.get('connection_mode')
        if 'global' in _dict:
            args['global_'] = _dict.get('global')
        else:
            raise ValueError('Required property \'global\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'metered' in _dict:
            args['metered'] = _dict.get('metered')
        else:
            raise ValueError('Required property \'metered\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'patch_panel_completion_notice' in _dict:
            args['patch_panel_completion_notice'] = _dict.get('patch_panel_completion_notice')
        if 'resource_group' in _dict:
            args['resource_group'] = ResourceGroupIdentity.from_dict(_dict.get('resource_group'))
        if 'speed_mbps' in _dict:
            args['speed_mbps'] = _dict.get('speed_mbps')
        else:
            raise ValueError('Required property \'speed_mbps\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        if 'port' in _dict:
            args['port'] = GatewayPortIdentity.from_dict(_dict.get('port'))
        else:
            raise ValueError('Required property \'port\' not present in GatewayTemplateGatewayTypeConnectTemplate JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayTemplateGatewayTypeConnectTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'as_prepends') and self.as_prepends is not None:
            _dict['as_prepends'] = [x.to_dict() for x in self.as_prepends]
        if hasattr(self, 'authentication_key') and self.authentication_key is not None:
            _dict['authentication_key'] = self.authentication_key.to_dict()
        if hasattr(self, 'bfd_config') and self.bfd_config is not None:
            _dict['bfd_config'] = self.bfd_config.to_dict()
        if hasattr(self, 'bgp_asn') and self.bgp_asn is not None:
            _dict['bgp_asn'] = self.bgp_asn
        if hasattr(self, 'bgp_base_cidr') and self.bgp_base_cidr is not None:
            _dict['bgp_base_cidr'] = self.bgp_base_cidr
        if hasattr(self, 'bgp_cer_cidr') and self.bgp_cer_cidr is not None:
            _dict['bgp_cer_cidr'] = self.bgp_cer_cidr
        if hasattr(self, 'bgp_ibm_cidr') and self.bgp_ibm_cidr is not None:
            _dict['bgp_ibm_cidr'] = self.bgp_ibm_cidr
        if hasattr(self, 'connection_mode') and self.connection_mode is not None:
            _dict['connection_mode'] = self.connection_mode
        if hasattr(self, 'global_') and self.global_ is not None:
            _dict['global'] = self.global_
        if hasattr(self, 'metered') and self.metered is not None:
            _dict['metered'] = self.metered
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'patch_panel_completion_notice') and self.patch_panel_completion_notice is not None:
            _dict['patch_panel_completion_notice'] = self.patch_panel_completion_notice
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group.to_dict()
        if hasattr(self, 'speed_mbps') and self.speed_mbps is not None:
            _dict['speed_mbps'] = self.speed_mbps
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'port') and self.port is not None:
            _dict['port'] = self.port.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayTemplateGatewayTypeConnectTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayTemplateGatewayTypeConnectTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayTemplateGatewayTypeConnectTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ConnectionModeEnum(str, Enum):
        """
        Type of services this Gateway is attached to. Mode transit means this Gateway will
        be attached to Transit Gateway Service and direct means this Gateway will be
        attached to vpc or classic connection. The list of enumerated values for this
        property may expand in the future. Code and processes using this field  must
        tolerate unexpected values.
        """
        DIRECT = 'direct'
        TRANSIT = 'transit'


    class TypeEnum(str, Enum):
        """
        Offering type.
        """
        CONNECT = 'connect'
        DEDICATED = 'dedicated'


class GatewayTemplateGatewayTypeDedicatedTemplate(GatewayTemplate):
    """
    Gateway fields specific to type=dedicated gateway create.

    :attr List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
          configuration information.
    :attr GatewayTemplateAuthenticationKey authentication_key: (optional)
    :attr GatewayBfdConfigTemplate bfd_config: (optional)
    :attr int bgp_asn: BGP ASN.
    :attr str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
          Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how to
          create a gateway using either automatic or explicit IP assignment.  Any
          bgp_base_cidr value set will be ignored.
          Deprecated field bgp_base_cidr will be removed from the API specificiation after
          15-MAR-2021.
    :attr str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str bgp_ibm_cidr: (optional) BGP IBM CIDR.
          For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
          automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
          For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR, the
          value must reside in one of "10.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16",
          "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr and bgp_ibm_cidr must
          have matching network and subnet mask values.
    :attr str connection_mode: (optional) Type of services this Gateway is attached
          to. Mode transit means this Gateway will be attached to Transit Gateway Service
          and direct means this Gateway will be attached to vpc or classic connection. The
          list of enumerated values for this property may expand in the future. Code and
          processes using this field  must tolerate unexpected values.
    :attr bool global_: Gateways with global routing (`true`) can connect to
          networks outside their associated region.
    :attr bool metered: Metered billing option.  When `true` gateway usage is billed
          per gigabyte.  When `false` there is no per gigabyte usage charge, instead a
          flat rate is charged for the gateway.
    :attr str name: The unique user-defined name for this gateway.
    :attr str patch_panel_completion_notice: (optional) Gateway patch panel complete
          notification from implementation team.
    :attr ResourceGroupIdentity resource_group: (optional)
    :attr int speed_mbps: Gateway speed in megabits per second.
    :attr str type: Offering type.
    :attr str carrier_name: Carrier name.
    :attr str cross_connect_router: Cross connect router.
    :attr str customer_name: Customer name.
    :attr str location_name: Gateway location.
    :attr GatewayMacsecConfigTemplate macsec_config: (optional) MACsec configuration
          information.  Contact IBM support for access to MACsec.
    """

    def __init__(self,
                 bgp_asn: int,
                 global_: bool,
                 metered: bool,
                 name: str,
                 speed_mbps: int,
                 type: str,
                 carrier_name: str,
                 cross_connect_router: str,
                 customer_name: str,
                 location_name: str,
                 *,
                 as_prepends: List['AsPrependTemplate'] = None,
                 authentication_key: 'GatewayTemplateAuthenticationKey' = None,
                 bfd_config: 'GatewayBfdConfigTemplate' = None,
                 bgp_base_cidr: str = None,
                 bgp_cer_cidr: str = None,
                 bgp_ibm_cidr: str = None,
                 connection_mode: str = None,
                 patch_panel_completion_notice: str = None,
                 resource_group: 'ResourceGroupIdentity' = None,
                 macsec_config: 'GatewayMacsecConfigTemplate' = None) -> None:
        """
        Initialize a GatewayTemplateGatewayTypeDedicatedTemplate object.

        :param int bgp_asn: BGP ASN.
        :param bool global_: Gateways with global routing (`true`) can connect to
               networks outside their associated region.
        :param bool metered: Metered billing option.  When `true` gateway usage is
               billed per gigabyte.  When `false` there is no per gigabyte usage charge,
               instead a flat rate is charged for the gateway.
        :param str name: The unique user-defined name for this gateway.
        :param int speed_mbps: Gateway speed in megabits per second.
        :param str type: Offering type.
        :param str carrier_name: Carrier name.
        :param str cross_connect_router: Cross connect router.
        :param str customer_name: Customer name.
        :param str location_name: Gateway location.
        :param List[AsPrependTemplate] as_prepends: (optional) array of AS Prepend
               configuration information.
        :param GatewayTemplateAuthenticationKey authentication_key: (optional)
        :param GatewayBfdConfigTemplate bfd_config: (optional)
        :param str bgp_base_cidr: (optional) (DEPRECATED) BGP base CIDR.
               Field is deprecated.  See bgp_ibm_cidr and bgp_cer_cidr for details on how
               to create a gateway using either automatic or explicit IP assignment.  Any
               bgp_base_cidr value set will be ignored.
               Deprecated field bgp_base_cidr will be removed from the API specificiation
               after 15-MAR-2021.
        :param str bgp_cer_cidr: (optional) BGP customer edge router CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str bgp_ibm_cidr: (optional) BGP IBM CIDR.
               For auto IP assignment, omit bgp_cer_cidr and bgp_ibm_cidr.  IBM will
               automatically select values for bgp_cer_cidr and bgp_ibm_cidr.
               For explicit IP assignment set a valid bgp_cer_cidr and bgp_ibm_cidr CIDR,
               the value must reside in one of "10.254.0.0/16", "172.16.0.0/12",
               "192.168.0.0/16", "169.254.0.0/16" or an owned public CIDR.  bgp_cer_cidr
               and bgp_ibm_cidr must have matching network and subnet mask values.
        :param str connection_mode: (optional) Type of services this Gateway is
               attached to. Mode transit means this Gateway will be attached to Transit
               Gateway Service and direct means this Gateway will be attached to vpc or
               classic connection. The list of enumerated values for this property may
               expand in the future. Code and processes using this field  must tolerate
               unexpected values.
        :param str patch_panel_completion_notice: (optional) Gateway patch panel
               complete notification from implementation team.
        :param ResourceGroupIdentity resource_group: (optional)
        :param GatewayMacsecConfigTemplate macsec_config: (optional) MACsec
               configuration information.  Contact IBM support for access to MACsec.
        """
        # pylint: disable=super-init-not-called
        self.as_prepends = as_prepends
        self.authentication_key = authentication_key
        self.bfd_config = bfd_config
        self.bgp_asn = bgp_asn
        self.bgp_base_cidr = bgp_base_cidr
        self.bgp_cer_cidr = bgp_cer_cidr
        self.bgp_ibm_cidr = bgp_ibm_cidr
        self.connection_mode = connection_mode
        self.global_ = global_
        self.metered = metered
        self.name = name
        self.patch_panel_completion_notice = patch_panel_completion_notice
        self.resource_group = resource_group
        self.speed_mbps = speed_mbps
        self.type = type
        self.carrier_name = carrier_name
        self.cross_connect_router = cross_connect_router
        self.customer_name = customer_name
        self.location_name = location_name
        self.macsec_config = macsec_config

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GatewayTemplateGatewayTypeDedicatedTemplate':
        """Initialize a GatewayTemplateGatewayTypeDedicatedTemplate object from a json dictionary."""
        args = {}
        if 'as_prepends' in _dict:
            args['as_prepends'] = [AsPrependTemplate.from_dict(x) for x in _dict.get('as_prepends')]
        if 'authentication_key' in _dict:
            args['authentication_key'] = GatewayTemplateAuthenticationKey.from_dict(_dict.get('authentication_key'))
        if 'bfd_config' in _dict:
            args['bfd_config'] = GatewayBfdConfigTemplate.from_dict(_dict.get('bfd_config'))
        if 'bgp_asn' in _dict:
            args['bgp_asn'] = _dict.get('bgp_asn')
        else:
            raise ValueError('Required property \'bgp_asn\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'bgp_base_cidr' in _dict:
            args['bgp_base_cidr'] = _dict.get('bgp_base_cidr')
        if 'bgp_cer_cidr' in _dict:
            args['bgp_cer_cidr'] = _dict.get('bgp_cer_cidr')
        if 'bgp_ibm_cidr' in _dict:
            args['bgp_ibm_cidr'] = _dict.get('bgp_ibm_cidr')
        if 'connection_mode' in _dict:
            args['connection_mode'] = _dict.get('connection_mode')
        if 'global' in _dict:
            args['global_'] = _dict.get('global')
        else:
            raise ValueError('Required property \'global\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'metered' in _dict:
            args['metered'] = _dict.get('metered')
        else:
            raise ValueError('Required property \'metered\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'patch_panel_completion_notice' in _dict:
            args['patch_panel_completion_notice'] = _dict.get('patch_panel_completion_notice')
        if 'resource_group' in _dict:
            args['resource_group'] = ResourceGroupIdentity.from_dict(_dict.get('resource_group'))
        if 'speed_mbps' in _dict:
            args['speed_mbps'] = _dict.get('speed_mbps')
        else:
            raise ValueError('Required property \'speed_mbps\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'carrier_name' in _dict:
            args['carrier_name'] = _dict.get('carrier_name')
        else:
            raise ValueError('Required property \'carrier_name\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'cross_connect_router' in _dict:
            args['cross_connect_router'] = _dict.get('cross_connect_router')
        else:
            raise ValueError('Required property \'cross_connect_router\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'customer_name' in _dict:
            args['customer_name'] = _dict.get('customer_name')
        else:
            raise ValueError('Required property \'customer_name\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'location_name' in _dict:
            args['location_name'] = _dict.get('location_name')
        else:
            raise ValueError('Required property \'location_name\' not present in GatewayTemplateGatewayTypeDedicatedTemplate JSON')
        if 'macsec_config' in _dict:
            args['macsec_config'] = GatewayMacsecConfigTemplate.from_dict(_dict.get('macsec_config'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GatewayTemplateGatewayTypeDedicatedTemplate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'as_prepends') and self.as_prepends is not None:
            _dict['as_prepends'] = [x.to_dict() for x in self.as_prepends]
        if hasattr(self, 'authentication_key') and self.authentication_key is not None:
            _dict['authentication_key'] = self.authentication_key.to_dict()
        if hasattr(self, 'bfd_config') and self.bfd_config is not None:
            _dict['bfd_config'] = self.bfd_config.to_dict()
        if hasattr(self, 'bgp_asn') and self.bgp_asn is not None:
            _dict['bgp_asn'] = self.bgp_asn
        if hasattr(self, 'bgp_base_cidr') and self.bgp_base_cidr is not None:
            _dict['bgp_base_cidr'] = self.bgp_base_cidr
        if hasattr(self, 'bgp_cer_cidr') and self.bgp_cer_cidr is not None:
            _dict['bgp_cer_cidr'] = self.bgp_cer_cidr
        if hasattr(self, 'bgp_ibm_cidr') and self.bgp_ibm_cidr is not None:
            _dict['bgp_ibm_cidr'] = self.bgp_ibm_cidr
        if hasattr(self, 'connection_mode') and self.connection_mode is not None:
            _dict['connection_mode'] = self.connection_mode
        if hasattr(self, 'global_') and self.global_ is not None:
            _dict['global'] = self.global_
        if hasattr(self, 'metered') and self.metered is not None:
            _dict['metered'] = self.metered
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'patch_panel_completion_notice') and self.patch_panel_completion_notice is not None:
            _dict['patch_panel_completion_notice'] = self.patch_panel_completion_notice
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group.to_dict()
        if hasattr(self, 'speed_mbps') and self.speed_mbps is not None:
            _dict['speed_mbps'] = self.speed_mbps
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'carrier_name') and self.carrier_name is not None:
            _dict['carrier_name'] = self.carrier_name
        if hasattr(self, 'cross_connect_router') and self.cross_connect_router is not None:
            _dict['cross_connect_router'] = self.cross_connect_router
        if hasattr(self, 'customer_name') and self.customer_name is not None:
            _dict['customer_name'] = self.customer_name
        if hasattr(self, 'location_name') and self.location_name is not None:
            _dict['location_name'] = self.location_name
        if hasattr(self, 'macsec_config') and self.macsec_config is not None:
            _dict['macsec_config'] = self.macsec_config.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GatewayTemplateGatewayTypeDedicatedTemplate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GatewayTemplateGatewayTypeDedicatedTemplate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GatewayTemplateGatewayTypeDedicatedTemplate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class ConnectionModeEnum(str, Enum):
        """
        Type of services this Gateway is attached to. Mode transit means this Gateway will
        be attached to Transit Gateway Service and direct means this Gateway will be
        attached to vpc or classic connection. The list of enumerated values for this
        property may expand in the future. Code and processes using this field  must
        tolerate unexpected values.
        """
        DIRECT = 'direct'
        TRANSIT = 'transit'


    class TypeEnum(str, Enum):
        """
        Offering type.
        """
        CONNECT = 'connect'
        DEDICATED = 'dedicated'


class RouteReportOverlappingRouteForConnection(RouteReportOverlappingRoute):
    """
    overlapping route details.

    :attr str prefix: overlapping prefix.
    :attr str type: type of the route.
    :attr str virtual_connection_id: virtual connection ID.
    """

    def __init__(self,
                 prefix: str,
                 type: str,
                 virtual_connection_id: str) -> None:
        """
        Initialize a RouteReportOverlappingRouteForConnection object.

        :param str prefix: overlapping prefix.
        :param str type: type of the route.
        :param str virtual_connection_id: virtual connection ID.
        """
        # pylint: disable=super-init-not-called
        self.prefix = prefix
        self.type = type
        self.virtual_connection_id = virtual_connection_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOverlappingRouteForConnection':
        """Initialize a RouteReportOverlappingRouteForConnection object from a json dictionary."""
        args = {}
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError('Required property \'prefix\' not present in RouteReportOverlappingRouteForConnection JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in RouteReportOverlappingRouteForConnection JSON')
        if 'virtual_connection_id' in _dict:
            args['virtual_connection_id'] = _dict.get('virtual_connection_id')
        else:
            raise ValueError('Required property \'virtual_connection_id\' not present in RouteReportOverlappingRouteForConnection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOverlappingRouteForConnection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'virtual_connection_id') and self.virtual_connection_id is not None:
            _dict['virtual_connection_id'] = self.virtual_connection_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOverlappingRouteForConnection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOverlappingRouteForConnection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOverlappingRouteForConnection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        type of the route.
        """
        VIRTUAL_CONNECTION = 'virtual_connection'


class RouteReportOverlappingRouteForOthers(RouteReportOverlappingRoute):
    """
    overlapping route details.

    :attr str prefix: overlapping prefix.
    :attr str type: type of the route.
    """

    def __init__(self,
                 prefix: str,
                 type: str) -> None:
        """
        Initialize a RouteReportOverlappingRouteForOthers object.

        :param str prefix: overlapping prefix.
        :param str type: type of the route.
        """
        # pylint: disable=super-init-not-called
        self.prefix = prefix
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RouteReportOverlappingRouteForOthers':
        """Initialize a RouteReportOverlappingRouteForOthers object from a json dictionary."""
        args = {}
        if 'prefix' in _dict:
            args['prefix'] = _dict.get('prefix')
        else:
            raise ValueError('Required property \'prefix\' not present in RouteReportOverlappingRouteForOthers JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in RouteReportOverlappingRouteForOthers JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RouteReportOverlappingRouteForOthers object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'prefix') and self.prefix is not None:
            _dict['prefix'] = self.prefix
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RouteReportOverlappingRouteForOthers object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RouteReportOverlappingRouteForOthers') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RouteReportOverlappingRouteForOthers') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        type of the route.
        """
        GATEWAY = 'gateway'
        ON_PREM = 'on_prem'

