from datetime import datetime
from typing import Optional

from pydantic import BaseModel


class SynapseQueryLog(BaseModel):
    # transaction_id for serverless sql pool
    request_id: str
    session_id: Optional[str]
    sql_query: str
    login_name: str
    start_time: datetime
    end_time: datetime
    # in milliseconds
    duration: int
    # in MB
    query_size: Optional[int]
    error: Optional[str]
    row_count: Optional[int]
    query_operation: Optional[str]
